/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 424 ) = {
 10,  10, 115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  55,  55,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  47,  99, 112,  97, 115,  95,  98,  95,  95, 115, 114,
 99,  46, 112,  97, 115,  12,  12, 115, 114,  99,  95,  97, 108, 108, 111,  99,
 97, 116, 101,   8,   8, 115, 114,  99,  95, 102, 114, 101, 101,   9,   9, 115,
114,  99,  95,  99, 108, 111, 115, 101,   8,   8, 115, 114,  99,  95, 111, 112,
101, 110,  17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 116, 101, 120, 116,
 95, 108, 105, 110, 101,  11,  11, 115, 114,  99,  95, 111, 117, 116, 108, 105,
110, 101,  17,  17, 115, 114,  99,  95, 111, 117, 116, 101, 114, 114,  95,  98,
 97, 110, 110, 101, 114,  40,  40,  32,  37,  42,  43,  42,  43,  42,  32, 101,
114, 114, 111, 114,  40, 115,  41,  32, 119,  97, 115,  32, 100, 101, 116, 101,
 99, 116, 101, 100,  32,  97, 116,  32, 108, 105, 110, 101,  32,  35,  32,  16,
 16,  32, 105, 110,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  58,  32,
 34,  13,  13, 115, 114,  99,  95, 111, 117, 116,  95, 101, 114, 114, 111, 114,
 17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 109,  97,  99,  95, 101, 114,
114, 111, 114,   9,   9, 115, 114,  99,  95, 101, 114, 114, 111, 114,  17,  17,
115, 114,  99,  95, 103, 101, 116,  95, 105, 110, 112, 117, 116, 108, 105, 110,
101,  14,  14, 115, 114,  99,  95, 112, 117, 116,  95, 112, 114, 111, 109, 112,
116,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95, 108, 105, 110, 101,  15,
 15, 115, 114,  99,  95, 101, 110, 100,  95, 111, 102,  95, 108, 105, 110, 101,
  4,   4,  83,  95,  71,  76,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95,
 99, 104,  97, 114,  12,  12, 115, 107, 105, 112,  95,  99, 111, 109, 109, 101,
110, 116,  10,  10, 115, 114,  99,  95, 105, 110,  99, 104,  97, 114,  13,  13,
115, 114,  99,  95, 110, 101, 120, 116,  95,  99, 104,  97, 114,  15,  15, 115,
114,  99,  95, 115, 101,  97, 114,  99, 104,  95,  99, 104,  97, 114,   8,   8,
115, 114,  99,  95, 105, 110, 105, 116
};

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
SL V_src_lstinsnb;
V V_src_control;
V V_src_cont_base;
V V_src_hde;
V V_src_listing;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);
void P_vsr_nextstring();


/* Procedure/Function : " src_r_init "  */
void BASIC_SRC_src_r_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=181; /* line # 181 */
  Rv0=F_p;
  ((V *)Rv0)[1]=NULL;
  ((SL *)Rv0)[3]=0;
  Ra.sl[3]=186; /* line # 186 */
  ((SL *)Rv0)[4]=0;
  ((SL *)Rv0)[5]=0;
  ((SL *)Rv0)[7]=0;
  ((SL *)Rv0)[8]=0;
  ((SL *)Rv0)[9]=1;
  Ra.sl[3]=191; /* line # 191 */
  ((C *)Rv0)[45]=32;
  ((C *)Rv0)[46]=32;
  ((C *)Rv0)[44]=1;
  ((SL *)Rv0)[10]=255;
  Rv1=1;
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Ra.sl[3]=196; /* line # 196 */
    ((V *)Rv0)[Rv1*5+11]=NULL;
    Rv1++;
  }
  ((UL *)Rv0)[52]=16456;
  Ra.sl[3]=201; /* line # 201 */
  ((UB *)Rv0)[212]=0;
  ((UB *)((V *)Rv0)[54])[1]=0;
  P_str_copy_lim(((V *)Rv0)+55,V_def_prompt,64);
  _FILE_CLEAR(((V *)Rv0)[57]);
  Ra.sl[3]=206; /* line # 206 */
  _FILE_CLEAR(((V *)Rv0)[56]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V P_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+69;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=220; /* line # 220 */
  Rv0=PAS__NEW(232);
  Rv1=Rv0;
  ((V *)Rv1)[0]=V_src_hde;
  ((V *)Rv1)[54]=PAS__NEW(257);
  ((UB *)((V *)Rv1)[54])[0]=255;
  ((UB *)((V *)Rv1)[54])[1]=0;
  Ra.sl[3]=225; /* line # 225 */
  ((V *)Rv1)[55]=PAS__NEW(257);
  ((UB *)((V *)Rv1)[55])[0]=255;
  ((UB *)((V *)Rv1)[55])[1]=0;
  BASIC_SRC_src_r_init(Rv0);
  V_src_hde=Rv0;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+83;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=240; /* line # 240 */
  Rv0=NULL;
  if (F_p!=NULL) {
    Rv1=V_src_hde;
    while (Rv1!=F_p&&Rv1!=NULL){
      Ra.sl[3]=246; /* line # 246 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Ra.sl[3]=251; /* line # 251 */
    Rv2=F_p;
    PAS__DISPOSE(((V *)Rv2)+54);
    if (!(512&((UL *)Rv2)[52])) PAS__DISPOSE(((V *)Rv2)+55);
    Ra.sl[3]=257; /* line # 257 */
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    PAS__DISPOSE(&F_p);
    F_p=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+93;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=274; /* line # 274 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (128&((UL *)Rv0)[52]) Rv1=2048;
    else Rv1=0;
    Ra.sl[3]=279; /* line # 279 */
    PAS__CLOSE(((V *)Rv0)+57,Rv1);
    if (8&((UL *)Rv0)[52]) PAS__CLOSE(((V *)Rv0)+56,0);
  }
  if (!F_bfree) BASIC_SRC_src_r_init((*F_p));
  else P_src_free((*F_p));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_open "  */
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+104;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=301; /* line # 301 */
  (*F_ierr)=0;
  if ((*F_p)==NULL) {
    Rv0=0;
    (*F_p)=P_src_allocate();
  }
  else {
    Ra.sl[3]=306; /* line # 306 */
    Rv0=1;
    P_src_close(F_p,0);
  }
  Rv1=(*F_p);
  Ra.sl[3]=311; /* line # 311 */
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[57],PAS__f_input);
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]|16;
    PAS__iostatus=0;
  }
  else {
    Ra.sl[3]=317; /* line # 317 */
    PAS__OPEN(((V *)Rv1)+57,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  }
  if (PAS__iostatus==0) {
    Ra.sl[3]=322; /* line # 322 */
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~8;
    if (PAS__TTY_FILE(((V *)Rv1)[57])) {
      if (((UB *)F_fspc)[1]==0) {
        Ra.sl[3]=327; /* line # 327 */
        _FILE_DUPLICATE(((V *)Rv1)[56],PAS__f_output);
        PAS__iostatus=0;
      }
      else PAS__OPEN(((V *)Rv1)+56,0, F_fspc,4098,0,-1);
      if (PAS__iostatus!=0) {
        Ra.sl[3]=332; /* line # 332 */
        (*F_ierr)=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+57,0);
      }
      else((UL *)Rv1)[52]=((UL *)Rv1)[52]|8;
    }
    if (!(8&((UL *)Rv1)[52])) {
      Ra.sl[3]=337; /* line # 337 */
      if (F_bdelete) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|128;
    }
  }
  else (*F_ierr)=PAS__iostatus;
  if ((*F_ierr)!=0) {
    if (Rv0) BASIC_SRC_src_r_init((*F_p));
    else {
      Ra.sl[3]=342; /* line # 342 */
      P_src_free((*F_p));
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SRC_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+114;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=355; /* line # 355 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Rv1=V_lst_current;
  if (F_bterm) Rv2=80;
  else Rv2=((SL *)Rv1)[10];
  Ra.sl[3]=360; /* line # 360 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    if (Rv0>Rv2) {
      Ra.sl[3]=365; /* line # 365 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      if (!F_bterm) ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[3]=371; /* line # 371 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SRC_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+133;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=383; /* line # 383 */
  Rv0=V_src_control;
  if (V_src_lstinsnb!=((SL *)Rv0)[4]) {
    V_src_lstinsnb=((SL *)Rv0)[4];
    Ra.sl[3]=388; /* line # 388 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[4],5,0);
  }
  else {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[45]);
  PAS__WRITE_CHAR(((C *)Rv0)[46]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[5],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[3]=393; /* line # 393 */
  Rv1=((V *)Rv0)[54];
  Rv2=V_lst_current;
  if (F_bterm) Rv3=80;
  else Rv3=((SL *)Rv2)[10];
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[8],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[3]=398; /* line # 398 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Rv4=20;
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[3]=403; /* line # 403 */
      Rv4=Rv4+1;
      if (Rv4>Rv3) {
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        if (!F_bterm) ((SL *)Rv2)[6]=((SL *)Rv2)[6]+1;
        Ra.sl[3]=408; /* line # 408 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=414; /* line # 414 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[54],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SRC_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+146;
  Ra.v[67]=Rd.s+12;
  Ra.sl[68]=433; /* line # 433 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.ub[1]=Ra.ub[0];
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[68]=439; /* line # 439 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[9]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
    Rv5=(((S *)Rv0)+Rv4*20+28);
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  if (((UB *)((V *)Rv0)[54])[1]>((SL *)Rv0)[10]) {
    Ra.sl[68]=446; /* line # 446 */
    Rv6=((SL *)Rv0)[10]+1;
    for( Rf0=(((UB *)((V *)Rv0)[54])[1]+1)-(((SL *)Rv0)[10]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.ub[1]=((UB *)((V *)Rv0)[54])[1];
  }
  else Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[7]*5+7];
  Ra.sl[68]=451; /* line # 451 */
  BASIC_SRC_src_out_text_line(F_f,Ra.s,F_bterm);
  if (F_bterm) {
    P_lst_newline();
    ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
  }
  Ra.sl[68]=457; /* line # 457 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+165,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[8],5,0);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+207,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+276,((V *)Rv0)[57]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SRC_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+225;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=466; /* line # 466 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if ((1&((UL *)Rv0)[52]&&((SL *)Rv0)[6]>=((SL *)Rv0)[5])&&!(64&((UB *)Rv1)[48])
  ) {
    Ra.sl[3]=471; /* line # 471 */
    ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
    BASIC_SRC_src_outerr_banner(((V *)Rv1)+13,0);
    Rv2=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=476; /* line # 476 */
      P_lst_newline();
      ((SL *)Rv1)[6]=((SL *)Rv1)[6]+1;
      P_err_display(((V *)Rv1)+13,Rv2,(((S *)Rv0)+Rv2*20+28));
      Rv2++;
    }
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[13]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=482; /* line # 482 */
  if (64&((UL *)Rv0)[52]||64&((UB *)Rv1)[48]) {
    if (!F_bmac) BASIC_SRC_src_outline(&PAS__f_output,1);
    BASIC_SRC_src_outerr_banner(&PAS__f_output,1);
    Rv3=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=487; /* line # 487 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*20+28));
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
    Ra.sl[3]=492; /* line # 492 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*5+11));
    Rv4++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+240;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=501; /* line # 501 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (((SL *)Rv0)[7]>0) {
    if (64&((UL *)Rv0)[52]||64&((UB *)Rv1)[48]) (*F_out_mac_line)(&PAS__f_output,1);
    BASIC_SRC_src_out_error(1);
    Ra.sl[3]=506; /* line # 506 */
    ((SL *)Rv0)[7]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+259;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=522; /* line # 522 */
  Rv0=V_src_control;
  if (((SL *)Rv0)[2]<((SL *)Rv0)[9]) ((SL *)Rv0)[2]=((SL *)Rv0)[9];
  else {
    if (((SL *)Rv0)[2]>((SL *)Rv0)[10]) ((SL *)Rv0)[2]=((SL *)Rv0)[10];
  }
  Ra.sl[3]=528; /* line # 528 */
  if (((SL *)Rv0)[7]>=8) {
    ((SL *)Rv0)[7]=8;
    Rv1=0;
  }
  else {
    Ra.sl[3]=534; /* line # 534 */
    Rv1=1;
    Rv2=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      if (((SL *)Rv0)[2]==((SL *)Rv0)[Rv2*5+7]) Rv1=0;
      Rv2++;
    }
    if (Rv1) ((SL *)Rv0)[7]=((SL *)Rv0)[7]+1;
  }
  Ra.sl[3]=540; /* line # 540 */
  if (Rv1) {
    Rv3=(((S *)Rv0)+((SL *)Rv0)[7]*20+28);
    ((SL *)Rv3)[0]=((SL *)Rv0)[2];
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[3]=545; /* line # 545 */
    ((SL *)Rv3)[1]=F_number;
    ((UB *)Rv3)[8]=F_severity;
    memcpy(Rv3+9,Ra.s+16,4);
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[7]*20+28));
  }
  else {
    Ra.sl[3]=551; /* line # 551 */
    ((UB *)Rv0)[((SL *)Rv0)[7]*20+36]=F_severity;
  }
  if (!(512&((UL *)Rv0)[52]||PAS__TTY_FILE(((V *)Rv0)[57]))) {
    if (PAS__EOF(((V *)Rv0)[57])) BASIC_SRC_src_out_error(0);
  }
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  Ra.sl[3]=556; /* line # 556 */
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+270;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=578; /* line # 578 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[3]=583; /* line # 583 */
  ((UB *)Rv0)[1]=0;
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    if (Rv2==9) while (1){
      Ra.sl[3]=589; /* line # 589 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      if (Rv2>=32) {
        Ra.sl[3]=594; /* line # 594 */
        if (((UB *)Rv0)[1]<255) {
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[3]=599; /* line # 599 */
          ((UL *)Rv1)[52]=((UL *)Rv1)[52]|256;
        }
      }
    }
  }
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|65536;
  else {
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  ((SL *)Rv1)[8]=((SL *)Rv1)[8]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+289;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=613; /* line # 613 */
  if (F_pstr!=NULL) {
    Rv0=V_src_control;
    if (8&((UL *)Rv0)[52]) {
      Ra.sl[3]=618; /* line # 618 */
      PAS__SELECT_OUT(((V *)Rv0)[56]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SRC_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+305;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=629; /* line # 629 */
  Rv0=V_src_control;
  ((SL *)Rv0)[3]=((SL *)Rv0)[9]-1;
  ((SL *)Rv0)[7]=0;
  Ra.sl[3]=634; /* line # 634 */
  if (512&((UL *)Rv0)[52]) {
    P_vsr_nextstring();
    ((SL *)Rv0)[8]=((SL *)Rv0)[8]+1;
  }
  else {
    Ra.sl[3]=642; /* line # 642 */
    if (8&((UL *)Rv0)[52]) P_src_put_prompt(((V *)Rv0)[55]);
    P_src_get_inputline(((V *)Rv0)+57,((V *)Rv0)+54);
    if (32&((UL *)Rv0)[52]) {
      Ra.sl[3]=647; /* line # 647 */
      if (8&((UL *)Rv0)[52]) P_lst_put_string(((V *)Rv0)[55]);
      P_lst_put_string(((V *)Rv0)[54]);
      P_lst_eoln();
    }
  }
  Ra.sl[3]=652; /* line # 652 */
  ((SL *)Rv0)[2]=((SL *)Rv0)[9];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+319;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=663; /* line # 663 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (256&((UL *)Rv0)[52]) {
    Ra.sl[3]=668; /* line # 668 */
    ((SL *)Rv0)[2]=((SL *)Rv0)[10]-1;
    P_src_error(Rd.s+338,1,2);
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~256;
  }
  if (1&((UL *)Rv0)[52]&&((SL *)Rv0)[6]>=((SL *)Rv0)[5]) {
    if (!(64&((UB *)Rv1)[48])) {
      Ra.sl[3]=675; /* line # 675 */
      P_lst_newline();
      BASIC_SRC_src_outline(((V *)Rv1)+13,0);
    }
  }
  if (((SL *)Rv0)[7]>0) BASIC_SRC_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SRC_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+342;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=689; /* line # 689 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  while (!(65536&((UL *)Rv0)[52])&&16384&((UL *)Rv0)[52]){
    Ra.sl[3]=696; /* line # 696 */
    if (((SL *)Rv0)[8]>0&&!(2048&((UL *)Rv0)[52])) P_src_end_of_line();
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~18432;
    BASIC_SRC_src_get_line();
    Ra.sl[3]=702; /* line # 702 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]|4096;
  }
  if (!(65536&((UL *)Rv0)[52])) {
    if (((SL *)Rv0)[3]>=((SL *)Rv0)[10]||((SL *)Rv0)[3]>=((UB *)Rv1)[1]) {
      Ra.sl[3]=707; /* line # 707 */
      if (2048&((UL *)Rv0)[52]&&((SL *)Rv0)[8]>0) P_src_end_of_line();
      if ((9216&((UL *)Rv0)[52])!=0) Rv2=1;
      else Rv2=32;
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]|16384;
    }
    else {
      Ra.sl[3]=715; /* line # 715 */
      ((SL *)Rv0)[3]=((SL *)Rv0)[3]+1;
      Rv2=((C *)Rv1)[((SL *)Rv0)[3]+1];
    }
  }
  else {
    Rv2=0;
    Ra.sl[3]=720; /* line # 720 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]|32768;
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SRC_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+356;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=735; /* line # 735 */
  Rv0=0;
  Rv1=V_src_control;
  if (4096&((UL *)Rv1)[52]&&((C *)Rv1)[45]==32) {
    Ra.sl[3]=740; /* line # 740 */
    ((C *)Rv1)[45]=67;
  }
  if (F_nlmd) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|8192;
  Rv2=((UB *)Rv1)[212];
  ((UB *)Rv1)[212]=4;
  while (1){
    while (1){
      Ra.sl[3]=746; /* line # 746 */
      Rv3=BASIC_SRC_src_get_char();
      if ((Rv3==0||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    switch (Rv2) {
      case 0:Ra.sl[3]=751; /* line # 751 */
      Rv0=F_stp==125&&Rv3==F_stp||Rv3==0;
      if (F_stp==42&&Rv3!=0) {
        if (((SL *)Rv1)[3]<((UB *)((V *)Rv1)[54])[1]) {
          Ra.sl[3]=756; /* line # 756 */
          Rv0=((C *)((V *)Rv1)[54])[(((SL *)Rv1)[3]+1)+1]==41;
          if (Rv0) Rv3=BASIC_SRC_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[3]=763; /* line # 763 */
      if (Rv3!=0) {
        if (((SL *)Rv1)[3]<((UB *)((V *)Rv1)[54])[1]) Rv3=BASIC_SRC_src_get_char();
        Rv0=Rv3==47;
      }
      else Rv0=1;
      break;
      case 2:
      case 3:
      case 4:Ra.sl[3]=772; /* line # 772 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[3]=777; /* line # 777 */
  if (F_nlmd) ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~8192;
  ((UB *)Rv1)[212]=Rv2;
  if (Rv3!=0) {
    if (Rv3==1&&!(1024&((UL *)Rv1)[52])||Rv3>1) {
      Ra.sl[3]=783; /* line # 783 */
      Rv3=32;
    }
  }
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+370;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=798; /* line # 798 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Rv2=BASIC_SRC_src_get_char();
  switch (((UB *)Rv0)[212]) {
    case 0:Ra.sl[3]=804; /* line # 804 */
    if (Rv2==123) Rv2=BASIC_SRC_skip_comment(125,0);
    else {
      if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==42) {
          Rv2=BASIC_SRC_src_get_char();
          Ra.sl[3]=809; /* line # 809 */
          Rv2=BASIC_SRC_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
      Ra.sl[3]=814; /* line # 814 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==42) {
        Rv2=BASIC_SRC_src_get_char();
        Rv2=BASIC_SRC_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[3]=821; /* line # 821 */
    if (Rv2==59) Rv2=BASIC_SRC_skip_comment(59,1);
    break;
    case 2:if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==45) {
        Ra.sl[3]=826; /* line # 826 */
        Rv2=BASIC_SRC_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[3]=831; /* line # 831 */
    break;
  }
  if (4096&((UL *)Rv0)[52]) {
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[3]=836; /* line # 836 */
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~4096;
      if (((C *)Rv0)[45]==67) ((C *)Rv0)[45]=32;
    }
  }
  ((C *)Rv0)[44]=Rv2;
  Ra.sl[3]=841; /* line # 841 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+382;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=850; /* line # 850 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  if (((SL *)Rv0)[3]>=((UB *)Rv1)[1]||((SL *)Rv0)[3]>=((SL *)Rv0)[10]) Ret=32;
  else Ret=((C *)Rv1)[(((SL *)Rv0)[3]+1)+1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+397;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=867; /* line # 867 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Rv2=((SL *)Rv0)[3];
  Rv3=1;
  while (Rv3){
    Ra.sl[3]=872; /* line # 872 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[10]) {
      Rv4=((C *)Rv1)[Rv2+1];
      if (Rv4==32) Rv2=Rv2+1;
      else Rv3=0;
    }
    else {
      Ra.sl[3]=880; /* line # 880 */
      Rv3=0;
      Rv4=32;
    }
  }
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=-1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+414;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=906; /* line # 906 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Rv1=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv1]=0;
    Rv1++;
  }
  V_error_result=0;
  Ra.sl[3]=911; /* line # 911 */
  V_src_control=NULL;
  if (((UB *)F_def_src)[1]>0) P_src_open(&V_src_control, F_def_src,0, &Rv0);
  if (Rv0==0) {
    Rv2=V_src_control;
    Ra.sl[3]=917; /* line # 917 */
    ((SL *)Rv2)[5]=1;
    ((SL *)Rv2)[6]=1;
  }
  else V_src_control=NULL;
  V_src_hde=V_src_control;
  Ra.sl[3]=922; /* line # 922 */
  V_src_cont_base=V_src_control;
  PAS__curr_cntx=Ra.v[0];
}
