/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[6];

/* Define the local data section. */
static Blk( Rd, 4056 ) = {
 15,  15, 115, 101, 116,  95, 112,  97, 103, 101, 104, 101,  97, 100, 105, 110,
103,  47,  47,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 109,
120, 100,  95, 115, 114,  99,  47, 109, 120, 100,  95, 108, 115, 113,  46, 112,
 97, 115,   7,   7,  99, 121,  99, 108, 101,  35,  32,   2,   2,  44,  32,   7,
  7, 108, 111, 111, 107, 118,  97, 114,   7,   7, 108, 105, 115, 116, 100, 101,
114,   5,   5, 118,  97, 108, 117, 101,   7,   7, 102, 111, 118,  97, 108, 117,
101,   3,   3, 100, 101, 114,   7,   7, 102, 111, 100, 101, 114, 105, 118,   8,
  8, 117, 115, 101, 114,  99,  97, 108, 108,   7,   7, 115, 117, 109, 108, 111,
111, 112,  11,  11, 115, 107, 105, 112, 118, 105, 114, 116, 117,  97, 108,   9,
  9, 111, 117, 116, 110,  97, 109, 101, 105, 100,  13,  13, 101, 114, 114, 111,
114,  95, 104,  97, 110, 100, 108, 101, 114,  34,  34,  32,  42,  42,  42,  32,
 85, 110, 100, 105, 102, 102, 101, 114, 101, 110,  99, 105, 101, 100,  32,  78,
117, 109, 101, 114, 105,  99,  32,  69, 114, 114, 111, 114,  46,  28,  28,  32,
 42,  42,  42,  32,  73, 110, 116, 101, 103, 101, 114,  32,  79, 118, 101, 114,
102, 108, 111, 119,  32,  69, 114, 114, 111, 114,  46,  31,  31,  32,  42,  42,
 42,  32,  73, 110, 116, 101, 103, 101, 114,  32,  90, 101, 114, 111,  32,  68,
105, 118, 105, 100, 101,  32,  69, 114, 114, 111, 114,  46,  30,  30,  32,  42,
 42,  42,  32,  70, 108, 111,  97, 116, 116, 105, 110, 103,  32,  79, 118, 101,
114, 102, 108, 111, 119,  32,  69, 114, 114, 111, 114,  46,  33,  33,  32,  42,
 42,  42,  32,  70, 108, 111,  97, 116, 116, 105, 110, 103,  32,  90, 101, 114,
111,  32,  68, 105, 118, 105, 100, 101,  32,  69, 114, 114, 111, 114,  46,  37,
 37,  32,  73, 110,  32, 116, 104, 101,  32, 100, 101, 114, 105, 118,  97, 116,
105, 111, 110,  32, 111, 102,  32, 116, 104, 101,  32,  80,  97, 114,  97, 109,
101, 116, 101, 114,  32,  34,   6,   6,  34,  32,  98, 121,  32,  34,  37,  37,
 32,  73, 110,  32, 116, 104, 101,  32, 101, 118,  97, 108, 117,  97, 116, 105,
111, 110,  32, 111, 102,  32, 116, 104, 101,  32,  80,  97, 114,  97, 109, 101,
116, 101, 114,  32,  34,   2,   2,  34,  46,   0,   0,   2,   2,  42,  42,   5,
  5,  83,  81,  82,  84,  40,   4,   4,  76,  79,  71,  40,   4,   4,  69,  88,
 80,  40,   4,   4,  84,  65,  78,  40,   5,   5,  65,  83,  73,  78,  40,   5,
  5,  65,  67,  79,  83,  40,   5,   5,  65,  84,  65,  78,  40,   5,   5,  84,
 65,  78,  72,  40,   5,   5,  65,  84,  65,  78,  40,   6,   6,  82,  79,  85,
 78,  68,  40,   3,   3, 109, 111, 100,   7,   7,  83,  85,  77,  72,  75,  76,
 40,   5,   5,  83,  85,  77,  77,  40,  17,  17,  32,  84, 114, 121,  32, 116,
111,  32,  99, 111, 109, 112, 117, 116, 101,  32,  34,   2,   2,  44,  32,   4,
  4,  32,  41,  34,  46,   2,   2,  34,  46,  10,  10, 112,  97, 114, 109, 100,
101, 114, 118,  97, 108,   9,   9,  99, 108, 114, 115, 117, 109, 104, 107, 108,
 10,  10, 109,  97, 107, 101, 115, 117, 109, 104, 107, 108,   6,   6, 115, 101,
112,  97, 116, 109,  10,  10, 115, 101, 116, 114, 101,  97, 108, 118,  97, 114,
  8,   8,  98, 108, 107,  46, 109,  97, 105, 110,   9,   9, 115, 101, 116, 111,
112, 116, 105, 111, 110,   4,   4, 105, 110, 105, 116,   6,   6,  77,  88,  68,
 76,  83,  81,   3,   3,  84,  84,  58,  60,  60,  32,  77,  32,  88,  32,  68,
 32,  76,  32,  83,  32,  81,  32,  32,  45,  32,  80,  46,  87, 111, 108, 102,
101, 114, 115,  32,  83, 111, 102, 116, 119,  97, 114, 101,  58,  32,  77,  88,
 68,  32,  86,  51,  46,  57,  45,  69,  32, 111, 102,  32,  48,  49,  45,  78,
 79,  86,  45,  57,  55,  32,   4,   4,  32,  43,  32,  32,   4,   4,  32,  45,
 32,  32,   4,   4,  43,  47,  45,  32,   4,   4,  32,  43,  43,  32,   4,   4,
 32,  45,  45,  32,   4,   4,  32,  43,  45,  32,   4,   4,  32,  45,  43,  32,
 18,  18,  77,  88,  68,  76,  73,  66,  58, 109, 120, 100,  95, 108, 115, 113,
 46, 101, 114, 114,   6,   6, 105, 110, 105,  98, 108, 107,   3,   3,  46,  69,
 46,   8,   8, 114, 111, 116,  97, 116, 118,  97, 114,  13,  13, 109,  97, 116,
 99, 104,  97, 110, 103, 101, 100, 105,  97, 103,   6,   6, 109,  97, 116, 105,
110, 118,  42,  42,  32,  42,  42,  42,  32,  83,  73,  78,  71,  85,  76,  65,
 82,  32,  77,  65,  84,  82,  73,  88,  32,  87,  73,  84,  72,  32,  86,  65,
 82,  73,  65,  66,  76,  69,  32,  78,  65,  77,  69,  68,  32,  34,  26,  26,
 32,  61,  62,  32,  86,  65,  82,  73,  65,  66,  76,  69,  32,  73,  83,  32,
 76,  79,  67,  75,  69,  68,  32,  42,  42,  42,  19,  19,  32,  61,  62,  32,
 70,  65,  84,  65,  76,  32,  69,  82,  82,  79,  82,  32,  42,  42,  42,   6,
  6, 114, 101, 115, 111, 108, 118,   9,   9, 111, 117, 116, 109,  97, 116, 114,
105, 120,  29,  29,  32,  67,  79,  82,  82,  69,  76,  65,  84,  73,  79,  78,
 32,  77,  65,  84,  82,  73,  88,  32,  69,  76,  69,  77,  69,  78,  84,  83,
 46,   2,   2,  32,  42,   9,   9, 111, 117, 116, 114, 101, 115, 105, 100, 117,
 47,  47,  32,  87, 101, 105, 103, 104, 116, 101, 100,  32,  76,  83,  81,  32,
 82,  32,  70,  97,  99, 116, 111, 114,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  82,  87,  76,  83,  81,  32,  32,  32,  32,  32,  32,  32,  61,
 32,  14,  14,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
 42,  47,  47,  32,  87, 101, 105, 103, 104, 116, 101, 100,  32,  65,  66,  83,
 32,  82,  32,  70,  97,  99, 116, 111, 114,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  82,  87,  65,  66,  83,  32,  32,  32,  32,  32,  32,  32,
 61,  32,  47,  47,  32,  85, 110, 119, 101, 105, 103, 104, 116, 101, 100,  32,
 76,  83,  81,  32,  82,  32,  70,  97,  99, 116, 111, 114,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  82,  76,  83,  81,  32,  32,  32,  32,  32,  32,  32,
 32,  61,  32,  47,  47,  32,  85, 110, 119, 101, 105, 103, 104, 116, 101, 100,
 32,  65,  66,  83,  32,  82,  32,  70,  97,  99, 116, 111, 114,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  82,  65,  66,  83,  32,  32,  32,  32,  32,  32,
 32,  32,  61,  32,  47,  47,  32,  84, 104, 101,  32, 114, 101, 100, 117,  99,
101, 100,  32, 103, 111, 111, 100, 110, 101, 115, 115,  32, 111, 102,  32, 102,
105, 116,  32,  40,  67, 104, 105,  32,  83, 113, 117,  97, 114, 101, 100,  41,
 32, 105, 115,  32,  32,   8,   8, 111, 117, 116, 112,  97, 114,  97, 109,  25,
 25,  32,  80,  97, 114,  97, 109, 101, 116, 101, 114,  32,  73, 110, 102, 111,
114, 109,  97, 116, 105, 111, 110, 115,  32,  58,  36,  36,  32,  32,  32,  78,
 97, 109, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  86,  97, 108, 117, 101,  32,  32,  32,  32,  32,  83, 105, 103, 109,  97,
  5,   5,  32,  32,  32,  32,  32,   6,   6, 111, 117, 116, 118, 110, 109,  12,
 12, 111, 117, 116, 115, 116, 114, 117,  99, 116, 117, 114, 101,  24,  24,  32,
 83, 116, 114, 117,  99, 116, 117, 114, 101,  32,  68, 101, 115,  99, 114, 105,
112, 116, 105, 111, 110,  32,  58,   8,   8,  32,  65,  84,  79,  77,  69,  32,
 58,   3,   3,  97,  32,  32,   3,   3,  32,  32,  32,   3,   3,  32,  32,  32,
  3,   3,  65,  94,  50,   3,   3,  97,  94,  50,   7,   7,  44,  32,  85,  32,
 32,  32,  61,   3,   3,  65,  94,  50,   7,   7,  44,  32,  66,  32,  32,  32,
 61,  18,  18,  77,  97, 103, 110, 101, 116, 105,  99,  32,  77, 111, 109, 101,
110, 116, 115,  32,  58,   3,   3,  98, 109, 117,   3,   3,  98, 109, 117,   9,
  9,  32,  32,  32,  44,  81,  78,  32,  61,  34,  25,  25,  77, 111, 100, 117,
108,  97, 116, 101, 100,  32,  68, 105, 115, 112, 108,  97,  99, 101, 109, 101,
110, 116, 115,  32,  58,   3,   3,  32,  32,  32,   3,   3,  32,  32,  32,   7,
  7,  44,  32,  81,  78,  32,  61,  34,   3,   3,  65,  32,  32,   7,   7, 100,
 97, 116,  97, 108, 115, 116,  28,  28,  32,  76, 105, 115, 116,  32, 111, 102,
 32,  68,  97, 116,  97,  32,  67, 111, 108, 108, 101,  99, 116, 105, 111, 110,
115,  32,  58,  32,   6,   6,  32, 119, 105, 116, 104,  32,   4,   4,  32,  32,
 83,  70,   4,   4,  32,  32,  70,  50,   4,   4,  32,  82,  65,  89,  30,  30,
 32,  79,  98, 115, 101, 114, 118,  97, 116, 105, 111, 110, 115,  32,  97, 110,
100,  32,  97,  32,  83,  67,  65,  76,  69,  32, 111, 102,  32,  58,  21,  21,
116, 104, 101,  32,  99, 111, 114, 114, 101,  99, 116, 105, 111, 110,  32, 102,
 97,  99, 116, 111, 114,   3,   3,  32, 105, 115,   5,   5, 115,  32,  97, 114,
101,  12,  12,  32,  97, 112, 112, 108, 105, 101, 100,  32, 116, 111,  32,   5,
  5,  36,  70,  78,  50,  32,   4,   4,  97, 110, 100,  32,   5,   5,  36,  70,
 77,  50,  32,   2,   2,  44,  32,  25,  25,  32,  65,  32, 100, 121, 110,  97,
109, 105,  99,  32, 119, 101, 105, 103, 104, 116,  32, 105, 115,  32, 117, 115,
101, 100,   7,   7, 119,  97, 118, 101, 108, 115, 116,  23,  23,  32,  76, 105,
115, 116,  32, 111, 102,  32,  87,  97, 118, 101,  32,  86, 101,  99, 116, 111,
114, 115,  32,  58,   9,   9,  32,  82,  97, 116, 105, 111, 110,  97, 108,   6,
  6, 112, 111, 108, 108, 115, 116,  34,  34,  32,  76, 105, 115, 116,  32, 111,
102,  32,  97, 112, 112, 108, 105, 101, 100,  32,  77,  97, 103, 110, 101, 116,
105,  99,  32,  70, 105, 101, 108, 100, 115,  32,  58,   9,   9, 115, 121, 109,
116, 114, 121, 108, 115, 116,  35,  35,  32,  76, 105, 115, 116,  32, 111, 102,
 32,  83, 121, 109, 101, 116, 114, 121,  32, 111, 112, 101, 114,  97, 116, 111,
114,  32, 109,  97, 116, 114, 105, 120, 115,  32,  58,  11,  11, 102, 105, 114,
115, 116, 111, 117, 116, 112, 117, 116,   7,   7,  80,  65,  66,  67,  73,  82,
 70,  27,  27,  32,  82,  97, 102, 102, 105, 110, 101, 109, 101, 110, 116,  32,
 73, 110, 102, 111, 114, 109,  97, 116, 105, 111, 110, 115,  32,  58,  12,  12,
 32,  32,  84, 104, 101, 114, 101,  32,  97, 114, 101,  32,  21,  21,  32, 118,
 97, 114, 105,  97,  98, 108, 101, 115,  32, 116, 111,  32, 114, 101, 102, 105,
110, 101,  46,  49,  49,  32,  32,  84, 104, 101,  32, 118,  97, 114, 105,  97,
 98, 108, 101,  32, 114, 111, 116,  97, 116, 105, 111, 110,  32, 105, 115,  32,
101, 110,  97,  98, 108, 101,  32, 119, 105, 116, 104,  32,  97,  32, 115, 116,
101, 112,  32, 111, 102,  32,  14,  14,  32,  87, 101,  32, 115, 116,  97, 114,
116,  32, 102, 111, 114,  32,   8,   8,  32,  99, 121,  99, 108, 101, 115,  46,
 34,  34,  32,  65,  32,  99, 101, 110, 116, 101, 114,  32,  97, 116,  32,  40,
 48,  44,  48,  44,  48,  41,  32, 105, 115,  32, 115, 112, 101,  99, 105, 102,
105, 101, 100,  46,  26,  26,  32,  84, 104, 101,  32, 115, 112, 101,  99, 105,
102, 105, 101, 100,  32, 108,  97, 116, 116, 105,  99, 101,  32, 105, 115,  32,
 60,  60,  32,  84, 104, 101,  32, 118,  97, 114, 105,  97,  98, 108, 101,  32,
119, 105, 108, 108,  32,  98, 101,  32,  83,  97, 118, 101, 100,  32, 111, 110,
 32, 101, 110, 100,  32, 111, 102,  32, 116, 104, 105, 115,  32, 114, 117, 110,
 32, 111, 110,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  58,  54,  54,
 32,  65,  32,  70, 111, 117, 114, 105, 101, 114,  32, 100,  97, 116,  32, 102,
105, 108, 101,  32, 119, 105, 108, 108,  32,  98, 101,  32, 119, 114, 105, 116,
116, 101, 110,  32, 111, 110,  32, 116, 104, 101,  32, 101, 110, 100,  32, 111,
102,  32, 114, 117, 110,  46,  58,  58,  32,  65,  32,  99, 111, 114, 114, 101,
108,  97, 116, 105, 111, 110,  32, 100,  97, 116,  32, 102, 105, 108, 101,  32,
119, 105, 108, 108,  32,  98, 101,  32, 119, 114, 105, 116, 116, 101, 110,  32,
111, 110,  32, 116, 104, 101,  32, 101, 110, 100,  32, 111, 102,  32, 114, 117,
110,  46,  20,  20,  32,  76, 105, 115, 116,  32, 111, 102,  32,  86,  97, 114,
105,  97,  98, 108, 101, 115,  32,  58,  42,  42,  32,  84, 104, 101,  32, 118,
 97, 114, 105,  97,  98, 108, 101,  32, 119, 105, 116, 104,  32, 116, 104, 101,
 32, 102, 108,  97, 103,  32,  34, 102,  34,  32,  97, 114, 101,  32, 102, 105,
120, 101, 100,  46,  44,  44,  32,  84, 104, 101,  32, 118,  97, 114, 105,  97,
 98, 108, 101,  32, 119, 105, 116, 104,  32, 116, 104, 101,  32, 102, 108,  97,
103,  32,  34, 108,  34,  32,  97, 114, 101,  32, 108, 105, 109, 105, 116, 101,
100,  46,   2,   2,  32, 102,   2,   2,  32, 108,  32,  32,  32,  66, 101, 103,
105, 110,  32, 111, 102,  32,  76, 101,  97, 115, 116,  32,  83, 113, 117,  97,
114, 101, 115,  32, 112, 114, 111,  99, 101, 115, 115,  46,   4,   4, 103, 116,
118, 100,   8,   8, 111, 117, 116,  97, 116, 111, 109, 101,   9,   9,  97, 116,
111, 109, 115,  46, 100,  97, 116,   2,   2,  32,  32,   7,   7, 109, 115, 101,
116, 100, 101, 114,   8,   8,  99, 112, 102,  50,  99, 111, 114, 114,   8,   8,
116, 114,  97, 110, 115, 104, 107, 108,   6,   6, 100, 115, 112, 102,  97,  99,
  6,   6, 115, 116, 114, 100, 115, 112,   6,   6, 109, 111, 109, 102,  97,  99,
  6,   6, 115, 116, 114, 109, 111, 109,   8,   8, 115, 101, 116, 115, 103,  97,
116, 109,   7,   7, 112, 114, 111, 106, 101,  99, 116,   7,   7, 110, 101, 117,
112, 111, 108,  97,   6,   6, 115, 116, 114, 102,  97,  99,   7,   7,  99, 111,
108, 108, 101,  99, 116,  29,  29,  32,  68,  97, 116,  97,  32,  82, 101, 102,
108, 101,  99, 116, 105, 111, 110,  32,  67, 111, 108, 108, 101,  99, 116, 105,
111, 110,  32,  34,   2,   2,  34,  46,  20,  20,  82, 101, 102, 108, 101, 120,
105, 111, 110,  32,  99, 111, 109, 112, 117, 116, 105, 110, 103,  32,  17,  17,
 97, 102, 116, 101, 114,  32, 108,  97, 115, 116,  32,  99, 121,  99, 108, 101,
 46,  11,  11, 102, 111, 114,  32,  99, 121,  99, 108, 101,  32,  35,   5,   5,
 32,  79,  66,  83,  35,   5,   5,  47,  83,  69,  76,  35,   5,   5,  47,  78,
 80,  79,  76,   2,   2,  47,  32,  31,  31,  32,  32,  32,  72,  32,  32,  32,
 75,  32,  32,  32,  76,  32,  32,  77,  32,  32,  78,  32,  32,  32,  82,  70,
 78,  32,  32,  32,  32,  73,  70,  78,  39,  39,  32,  32,  32,  82,  70,  88,
 32,  32,  32,  73,  70,  88,  32,  32,  32,  82,  70,  89,  32,  32,  32,  73,
 70,  89,  32,  32,  32,  82,  70,  90,  32,  32,  32,  73,  70,  90,  32,  32,
 32,  39,  39,  32,  32,  82,  70,  77,  88,  32,  32,  73,  70,  77,  88,  32,
 32,  82,  70,  77,  89,  32,  32,  73,  70,  77,  89,  32,  32,  82,  70,  77,
 90,  32,  32,  73,  70,  77,  90,  32,  32,  32,  10,  10,  32,  32,  32,  49,
 47,  50,  68,  32,  32,  32,  10,  10,  32,  32,  32,  32,  70,  50,  32,  32,
 32,  32,  27,  27,  32,  32,  32,  70,  50,  78,  85,  67,  76,  32,  32,  32,
 70,  50,  77,  65,  71,  32,  32,  32,  32,  70,  50,  83,  85,  77,  32,  48,
 48,  32,  32,  67,  65,  76,  67,  32,  32,  32,  32,  32,  79,  66,  83,  32,
 32,  32,  32,  68,  69,  76,  84,  65,  32,  32,  83,  73,  71,  77,  65,  32,
 32,  32,  87,  69,  73,  71,  72,  84,  32,  32,  68,  69,  76,  47,  83,  73,
 71,  23,  23,  32,  65,  99, 116, 117,  97, 108,  32,  83,  69,  76,  78,  66,
 32, 105, 110, 100, 101, 120,  32, 105, 115,  32,  20,  20,  32, 119, 105, 116,
104,  32, 109,  97, 103, 110, 101, 116, 105,  99,  32, 109, 111, 100, 101,  32,
  6,   6, 101, 110,  97,  98, 108, 101,   7,   7, 100, 105, 115,  97,  98, 108,
101,   2,   2,  32,  46,  24,  24,  32,  65,  99, 116, 117,  97, 108,  32,  87,
 97, 118, 101,  32,  86, 101,  99, 116, 111, 114,  32, 105, 115,  32,  34,  24,
 24,  32,  65,  99, 116, 117,  97, 108,  32,  78,  32,  80, 111, 108,  97,  32,
 68, 105, 114,  46,  32, 105, 115,  32,  34,   2,   2,  32,  32,   7,   7,  32,
 45,  32,  45,  32,  45,  32,   2,   2,  32, 114,  51,  51,  32,  80,  97, 114,
116, 105,  99, 117, 108,  97, 114,  32,  65, 103, 114, 101, 101, 109, 101, 110,
116,  32,  70,  97,  99, 116, 111, 114, 115,  32, 102, 111, 114,  32, 100,  97,
116,  97,  32,  99, 111, 108, 108, 101,  99, 116, 105, 111, 110,  32,  34,   7,
  7,  34,  32, 119, 105, 116, 104,  32,  13,  13, 111,  98, 115, 101, 114, 118,
 97, 116, 105, 111, 110, 115,  46,   4,   4, 111,  98, 115,  46,  27,  27,  32,
 71, 101, 110, 101, 114,  97, 108,  32,  65, 103, 114, 101, 101, 109, 101, 110,
116,  32,  70,  97,  99, 116, 111, 114, 115,  32,  14,  14,  32,  97, 102, 116,
101, 114,  32,  99, 121,  99, 108, 101,  32,  35,  14,  14,  98, 101, 102, 111,
114, 101,  32,  99, 121,  99, 108, 101,  32,  35,  15,  15,  32,  99, 111, 109,
112, 117, 116, 101, 100,  32, 119, 105, 116, 104,  32,  14,  14,  32, 111,  98,
115, 101, 114, 118,  97, 116, 105, 111, 110, 115,  46,   7,   7,  32,  84, 104,
101, 114, 101,  32,   3,   3,  97, 114, 101,   2,   2, 105, 115,  17,  17,  32,
100, 105, 102, 102, 114,  97,  99, 116, 105, 111, 110,  32, 108, 105, 110, 101,
 57,  57,  32, 116, 104,  97, 116,  32,  99,  97, 110, 110, 111, 116,  32, 117,
115, 101, 100,  32, 116, 111,  32,  99, 111, 109, 112, 117, 116, 101,  32, 116,
104, 101,  32, 115, 113, 117,  97, 114, 101, 100,  32, 103, 111, 111, 100, 110,
101, 115, 115,  32, 111, 102,  32, 102, 105, 116,  46,  47,  47,  32,  97, 110,
100,  32, 116, 104, 101,  32,  67, 104, 105,  32,  83, 113, 117,  97, 114, 101,
100,  32, 102, 114, 111, 109,  32, 116, 104, 101,  32, 105, 110, 105, 116, 105,
 97, 108,  32, 115, 105, 103, 109,  97,  32, 105, 115,  32,  11,  11, 115, 101,
116, 118,  97, 114, 105,  97,  98, 108, 101,  17,  17,  32,  68, 105,  97, 103,
111, 110,  97, 108,  32,  66, 108, 111,  99, 107,  32,  34,   5,   5,  34,  32,
111, 102,  32,  10,  10,  32, 118,  97, 114, 105,  97,  98, 108, 101, 115,  26,
 26,  32, 119, 105, 116, 104,  32,  97,  32,  68,  97, 109, 112, 105, 110, 103,
 32,  70,  97,  99, 116, 111, 114,  32, 111, 102,  32,   2,   2,  32,  46,   4,
  4,  32,  97, 110, 100,  39,  39,  32, 119, 105, 116, 104,  32,  97, 110,  32,
 77,  97, 114, 113, 117, 119,  97, 114, 100,  47,  76,  97, 110, 100, 113, 117,
 97, 114, 107,  32, 102,  97,  99, 116, 111, 114,  32, 111, 102,  32,   2,   2,
 32,  46,  23,  23,  86,  97, 114, 105,  97,  98, 108, 101,  32,  73, 110, 102,
111, 114, 109,  97, 116, 105, 111, 110, 115,  32,  58,  39,  39,  32,  32,  78,
 97, 109, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 78, 101, 119,  45,  86,  97, 108, 117, 101,  32,  32,  32,  32,  32,  83, 105,
103, 109,  97,  32,  22,  22,  32,  32,  79, 108, 100,  45,  86,  97, 108, 117,
101,  32,  32,  32,  32,  67, 104,  97, 110, 103, 101,  32,   4,   4,  32,  32,
 32,  32,   4,   4,  42,  76, 114,  32,   4,   4,  42,  77, 100,  32,   5,   5,
 99, 121,  99, 108, 101,  10,  10,  77,  88,  68,  83,  67,  73,  46,  84,  77,
 80,  20,  20,  32,  70, 105, 110,  97, 108,  32,  76, 101,  97, 115, 116,  32,
 83, 113, 117,  97, 114, 101, 115,  24,  24,  32,  83, 116, 114, 117,  99, 116,
117, 114, 101,  32,  73, 110, 102, 111, 114, 109,  97, 116, 105, 111, 110, 115,
 32,  13,  13,  97, 102, 116, 101, 114,  32,  99, 121,  99, 108, 101,  32,  35,
  2,   2,  32,  58,  42,  42,  32,  77,  97, 116, 114, 105, 120,  32,  67, 111,
114, 114, 101, 108,  97, 116, 105, 111, 110,  32, 101, 108, 101, 109, 101, 110,
116, 115,  32, 103, 114, 101,  97, 116, 101, 114,  32, 116, 104,  97, 110,  32,
  6,   6,  32,  87, 105, 116, 104,  32,  41,  41,  32,  42,  42,  42,  32,  65,
108, 108,  32,  86,  97, 114, 105,  97,  98, 108, 101, 115,  32,  97, 114, 101,
 32,  76, 111,  99, 107, 101, 100,  32,  61,  62,  32,  83, 116, 111, 112,  32,
 42,  42,  42,   9,   9, 115,  97, 118, 101,  99, 121,  99, 108, 101,   6,   6,
 99, 121,  99, 108, 101,  95,  11,  11,  46, 109, 120, 100,  95, 115,  97, 118,
101,  46,  49,   3,   3,  32, 123,  32,   2,   2,  32, 125,   3,   3,  32,  61,
 32,   6,   6,  99, 111, 109, 112, 117, 116,  15,  15,  70, 105, 110, 105, 115,
104, 101, 100,  32,  67, 121,  99, 108, 101,  32,  11,  11, 102, 105, 110,  97,
108, 111, 117, 116, 112, 117, 116,  25,  25,  85, 115, 101, 100,  32,  67,  80,
 85,  32,  84, 105, 109, 101,  32,  83, 116,  97, 116, 105, 115, 116, 105,  99,
115,  46,  36,  36,  32,  83, 116, 114, 117,  99,  46,  32,  70,  97,  99, 116,
111, 114,  32,  99, 111, 109, 112, 117, 116, 105, 110, 103,  32,  67,  80,  85,
 32, 116, 105, 109, 101,  32,  61,  32,  36,  36,  32,  66, 117, 105, 108, 100,
 32, 109,  97, 116, 114, 105, 120,  32,  67,  80,  85,  32, 116, 105, 109, 101,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  61,  32,  36,  36,
 32,  73, 110, 118, 101, 114, 115, 105, 111, 110,  47,  82, 101, 115, 111, 108,
117, 116, 105, 111, 110,  32,  67,  80,  85,  32, 116, 105, 109, 101,  32,  32,
 32,  32,  61,  32,  36,  36,  32,  84, 111, 116,  97, 108,  32, 117, 115, 101,
100,  32,  67,  80,  85,  32, 116, 105, 109, 101,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  61,  32,   7,   7, 109, 120, 100,  95,
108, 115, 113,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 16 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 509440 );

static sigjmp_buf G_lb_env;

/* Declaration of external variables. */
extern V V_pageheadpt2;
extern V V_parhde;
extern Blk(V_pardhde, 32 );
extern Blk(V_cdrec, 128 );
extern F V_hr;
extern F V_kr;
extern F V_lr;
extern F V_hc;
extern F V_kc;
extern F V_lc;
extern V V_cnpola;
extern V V_cwave;
extern F V_hh;
extern F V_kk;
extern F V_ll;
extern F V_h2;
extern F V_k2;
extern F V_l2;
extern SL V_refcatsv;
extern F V_fnr;
extern F V_fni;
extern F V_fmxr;
extern F V_fmyr;
extern F V_fmzr;
extern F V_fmxi;
extern F V_fmyi;
extern F V_fmzi;
extern UL V_cselect;
extern V V_cformula;
extern V V_cvariable;
extern V V_lst;
extern V V_intf;
extern V V_cparam;
extern V V_sumhhde;
extern V V_atomhde;
extern V V_atmshde;
extern V V_blkhde;
extern V V_gvarhde;
extern V V_varhde;
extern SL V_varnb;
extern V V_freeblk;
extern SL V_mxcateg;
extern Blk(V_program_name, 8 );
extern V V_pageheadpt1;
extern Blk(V_errmsgspecif, 136 );
extern V V_symhde;
extern V V_momhde;
extern V V_polhde;
extern V V_datahde;
extern V V_idat;
extern Blk(V_virtvtab, 16 );
extern UB V_bshortlst;
extern UB V_b132;
extern V V_sbttlpt;
extern UB V_buiso;
extern V PAS__f_output;
extern V V_wavhde;
extern UB V_bcentric;
extern SL V_latticenb;
extern V V_psav;
extern SL V_nbfixed;
extern UB V_bflimited;
extern V V_csymtry;
extern F V_h1;
extern F V_k1;
extern F V_l1;
extern F V_rgf;
extern F V_igf;
extern V V_cmdsdsp;
extern V V_catome;
extern SL V_iqwave;
extern V V_cmoment;
extern F V_fxr;
extern F V_fxi;
extern F V_fyr;
extern F V_fyi;
extern F V_fzr;
extern F V_fzi;
extern Blk(V_magsel, 32 );
extern F V_ra;
extern F V_rb;
extern F V_rc;
extern V V_cdata;
extern F V_fcalc2;
extern F V_fcalc2s;
extern F V_fstr;
extern V V_contrhde;
extern V V_ccontr;
extern F V_fnucl2;
extern F V_fmag2;
extern SL V_ncpobs;
extern SL V_ccateg;
extern UB V_bfmagnetic;
extern F V_delta;
extern Blk(V_crrec, 32 );
extern SL V_nbcoll;
extern UB V_bstop;
extern SL V_topcpu;


/* Function/procedure prototypes. */
F P_fbjn(F *F_dbjn, F F_x, SL F_n);
V P_st_create();
void P_st_put_mchar(V F_st, C F_ch, SL F_m);
void P_st_put_pastr(V F_trg, V F_src);
void P_st_put_ident(V F_trg, V F_src, SL F_fld);
void P_st_put_int(V F_st, SL F_iv, SL F_ndig);
void P_open_listing(V *F_f, V F_fname, SL F__Sz, SL F_mdflg);
void P_openw_txtfile(V *F_f, V F_fname, SL F_mdflg);
void P_close_txtfile(V *F_f);
SL P_cpu_clock();
UB P_openr_bdtfile(V *F_f, V F_spc);
void P_close_bdtfile(V *F_f);
void P_open_bcffile(V *F_f, V F_spc);
void P_close_bcffile(V *F_f);
UB P_inige(V F_mxdnam);
void P_newlinelst();
void P_error(SL F_n);
void P_underline(SL F_i, SL F_n);
void P_skipline(SL F_n);
void P_newparagraphe(SL F_n);
void P_writecpu(SL F_ti);
V P_buildsymbol(V F_symb);
V P_schitem(V F_h, UB F_bl);
void P_buildtree();
F MXD_TANH(F F_v);
F MXD_LSQ_usercall(V F_pn, V F_pv, UB F_bf);
F MXD_LSQ_sumloop(V F_pn, V F_pv);


/* Procedure/Function : " set_pageheading "  */
void MXD_LSQ_set_pageheading(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=282; /* line # 282 */
  ((C *)V_pageheadpt2)[136]=0;
  Ra.sl[3]=283; /* line # 283 */
  if (Rs.sl[0]>0) {
    Ra.sl[3]=285; /* line # 285 */
    P_st_put_pastr(V_pageheadpt2,Rd.s+66);
    Ra.sl[3]=286; /* line # 286 */
    if (Rs.sl[0]<Rs.sl[1]) P_st_put_int(V_pageheadpt2,Rs.sl[0],3);
    else {
      Ra.sl[3]=287; /* line # 287 */
      P_st_put_int(V_pageheadpt2,Rs.sl[1],3);
    }
    Ra.sl[3]=288; /* line # 288 */
    P_st_put_pastr(V_pageheadpt2,Rd.s+75);
  }
  else {
    Ra.sl[3]=290; /* line # 290 */
    P_st_put_mchar(V_pageheadpt2,32,12);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lookvar "  */
void MXD_LSQ_PRC_00000000(V F_pt, UB F_bvok){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  register V Rv7;
  SL Rv8;
  SL Rv9;
  V Rv10;
  V Rv11;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+79;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=320; /* line # 320 */
  Rv0=F_pt;
  Ra.sl[3]=321; /* line # 321 */
  switch (((UB *)Rv0)[0]) {
    case 20:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:Ra.sl[3]=325; /* line # 325 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[1],0);
    MXD_LSQ_PRC_00000000(((V *)Rv0)[2],0);
    break;
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 17:Ra.sl[3]=330; /* line # 330 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[1],F_bvok);
    MXD_LSQ_PRC_00000000(((V *)Rv0)[2],F_bvok);
    break;
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 18:Ra.sl[3]=334; /* line # 334 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[1],F_bvok);
    break;
    case 21:Ra.sl[3]=336; /* line # 336 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[1],0);
    MXD_LSQ_PRC_00000000(((V *)Rv0)[2],F_bvok);
    break;
    case 19:Ra.sl[3]=338; /* line # 338 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[1],0);
    break;
    case 16:Ra.sl[3]=339; /* line # 339 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[1],F_bvok);
    break;
    case 40:Ra.sl[3]=341; /* line # 341 */
    if (((SL *)Rv0)[5]!=0) {
      Ra.sl[3]=343; /* line # 343 */
      Rv1=((SL *)Rv0)[3];
      Ra.sl[3]=344; /* line # 344 */
      Rv2=Lx[0].v[0];
      Rv3=0;
      Rv4=NULL;
      Ra.sl[3]=345; /* line # 345 */
      Rv5=-100;
      Ra.sl[3]=346; /* line # 346 */
      while (Rv2!=NULL&&!Rv3){
        Ra.sl[3]=348; /* line # 348 */
        Rv5=((SL *)((V *)Rv2)[1])[3];
        Ra.sl[3]=349; /* line # 349 */
        Rv3=Rv1<=Rv5;
        Ra.sl[3]=350; /* line # 350 */
        if (!Rv3) {
          Ra.sl[3]=352; /* line # 352 */
          Rv4=Rv2;
          Ra.sl[3]=353; /* line # 353 */
          Rv2=((V *)Rv2)[0];
        }
      }
      Ra.sl[3]=356; /* line # 356 */
      if (Rv5!=Rv1&&F_bvok) {
        Ra.sl[3]=359; /* line # 359 */
        Rv6=PAS__NEW(12);
        ((V *)Rv6)[0]=Rv2;
        Ra.sl[3]=360; /* line # 360 */
        if (Rv4==NULL) Lx[0].v[0]=Rv6;
        else((V *)Rv4)[0]=Rv6;
        Ra.sl[3]=361; /* line # 361 */
        Rv7=Rv6;
        Ra.sl[3]=362; /* line # 362 */
        ((V *)Rv7)[1]=F_pt;
        ((F *)Rv7)[2]=(F)0.000000E-01;
      }
      Ra.sl[3]=364; /* line # 364 */
      if (Rv1<0) {
        Ra.sl[3]=365; /* line # 365 */
        if (Rv1==-1) {
          Ra.sl[3]=367; /* line # 367 */
          if (Lx[0].sl[1]<6) Lx[0].sl[1]=6;
        }
        else {
          Ra.sl[3]=370; /* line # 370 */
          if (Rv1==-4) {
            Ra.sl[3]=372; /* line # 372 */
            if (Lx[0].sl[1]<5) Lx[0].sl[1]=5;
          }
          else {
            Ra.sl[3]=376; /* line # 376 */
            if (Lx[0].sl[1]<4) Lx[0].sl[1]=4;
          }
        }
      }
    }
    break;
    case 41:Ra.sl[3]=380; /* line # 380 */
    if (Lx[0].sl[1]<6) Lx[0].sl[1]=6;
    break;
    case 38:Ra.sl[3]=381; /* line # 381 */
    Lx[0].sl[1]=3;
    break;
    case 39:Ra.sl[3]=382; /* line # 382 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[4],F_bvok);
    break;
    case 34:Ra.sl[3]=383; /* line # 383 */
    if (Lx[0].sl[1]<2) Lx[0].sl[1]=2;
    break;
    case 35:Ra.sl[3]=384; /* line # 384 */
    switch (((SL *)Rv0)[1]) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:Ra.sl[3]=386; /* line # 386 */
      if (Lx[0].sl[1]<2) Lx[0].sl[1]=2;
      break;
      case 10:
      case 11:
      case 12:Ra.sl[3]=387; /* line # 387 */
      if (Lx[0].sl[1]<1) Lx[0].sl[1]=1;
      break;
      case 20:
      case 21:
      case 22:Ra.sl[3]=388; /* line # 388 */
      if (Lx[0].sl[1]<3) Lx[0].sl[1]=3;
      break;
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:Ra.sl[3]=389; /* line # 389 */
      if (Lx[0].sl[1]<4) Lx[0].sl[1]=4;
      break;
      case 23:
      case 24:
      case 25:
      case 26:Ra.sl[3]=391; /* line # 391 */
      break;
    }
    break;
    case 36:
    case 37:Ra.sl[3]=392; /* line # 392 */
    if (Lx[0].sl[1]<0) Lx[0].sl[1]=0;
    Ra.sl[3]=393; /* line # 393 */
    if (((UB *)Rv0)[0]==37) {
      Ra.sl[3]=395; /* line # 395 */
      MXD_LSQ_PRC_00000000(((V *)Rv0)[3],0);
      Rv8=1;
    }
    else {
      Ra.sl[3]=396; /* line # 396 */
      Rv8=0;
    }
    Ra.sl[3]=397; /* line # 397 */
    Rv9=Rv8;
    for( Rf0=((((SL *)Rv0)[2]-1)+1)-Rv8;Rf0>0;Rf0-- ) {
      Ra.sl[3]=398; /* line # 398 */
      if (((V *)Rv0)[Rv9+3]!=NULL) MXD_LSQ_PRC_00000000(((V *)Rv0)[Rv9+3],F_bvok);
      Rv9++;
    }
    break;
    case 22:Ra.sl[3]=400; /* line # 400 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[5],F_bvok);
    break;
    case 24:
    case 26:Ra.sl[3]=403; /* line # 403 */
    Rv10=((V *)Rv0)[((SL *)Rv0)[2]+3];
    Ra.sl[3]=404; /* line # 404 */
    if (((UB *)Rv0)[0]==26) Rv10=((V *)Rv10)[5];
    Ra.sl[3]=405; /* line # 405 */
    Rv11=((V *)Rv10)[4];
    Ra.sl[3]=406; /* line # 406 */
    Rv1=0;
    Ra.sl[3]=407; /* line # 407 */
    while (Rv11!=NULL){
      Ra.sl[3]=409; /* line # 409 */
      if (Rv1<((SL *)Rv0)[2]) ((V *)Rv11)[5]=((V *)Rv0)[Rv1+3];
      else {
        Ra.sl[3]=410; /* line # 410 */
        ((V *)Rv11)[5]=NULL;
      }
      Ra.sl[3]=411; /* line # 411 */
      Rv1=Rv1+1;
      Rv11=((V *)Rv11)[4];
    }
    Ra.sl[3]=413; /* line # 413 */
    MXD_LSQ_PRC_00000000(((V *)Rv10)[5],F_bvok);
    break;
    case 25:Ra.sl[3]=415; /* line # 415 */
    MXD_LSQ_PRC_00000000(((V *)Rv0)[5],F_bvok);
    break;
    case 23:
    case 33:
    case 42:Ra.sl[3]=417; /* line # 417 */
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " listder "  */
void MXD_LSQ_listder(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[3]=Rd.s+88;
  Ra.v[4]=Rd.s+17;
  Ra.sl[5]=421; /* line # 421 */
  Rv0=V_parhde;
  Ra.sl[5]=422; /* line # 422 */
  Rv1=0;
  for( Rf0=7;Rf0>0;Rf0-- ) {
    Ra.v[Rv1+6]=NULL;
    Rv1++;
  }
  Ra.sl[5]=423; /* line # 423 */
  while (Rv0!=NULL){
    Ra.sl[5]=425; /* line # 425 */
    Ra.v[0]=NULL;
    Ra.sl[1]=-1;
    Ra.sl[5]=426; /* line # 426 */
    Rv2=Rv0;
    Ra.sl[5]=428; /* line # 428 */
    MXD_LSQ_PRC_00000000(((V *)Rv2)[4],1);
    ((V *)Rv2)[5]=Ra.v[0];
    Ra.sl[5]=429; /* line # 429 */
    if (Ra.sl[1]>-1) {
      Ra.sl[5]=431; /* line # 431 */
      if (Ra.v[Ra.sl[1]+6]==NULL) V_pardhde.v[Ra.sl[1]]=Rv0;
      else((V *)Ra.v[Ra.sl[1]+6])[7]=Rv0;
      Ra.sl[5]=432; /* line # 432 */
      Ra.v[Ra.sl[1]+6]=Rv0;
      ((V *)Rv2)[7]=NULL;
    }
    Ra.sl[5]=435; /* line # 435 */
    Rv0=((V *)Rv0)[1];
  }
  PAS__curr_cntx=Ra.v[2];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " value "  */
F MXD_LSQ_value(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+97;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=455; /* line # 455 */
  if (F_p==NULL) Ret=(F)0.000000E-01;
  else Ret=((F *)F_p)[6];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fovalue "  */
F MXD_LSQ_fovalue(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  register int Rgi;
  register int Rgj;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+104;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=466; /* line # 466 */
  if (Ri.ul[0]<1024) Ri.ul[0]=Ri.ul[0]+1;
  Ra.sl[3]=467; /* line # 467 */
  Rs.v[Ri.ul[0]+1]=F_p;
  Ra.sl[3]=468; /* line # 468 */
  if (F_p==NULL) Ret=(F)0.000000E-01;
  else {
    Ra.sl[3]=469; /* line # 469 */
    Rv0=F_p;
    Ra.sl[3]=470; /* line # 470 */
    switch (((UB *)Rv0)[0]) {
      case 0:Ra.sl[3]=471; /* line # 471 */
      Ret=MXD_LSQ_fovalue(((V *)Rv0)[1])+MXD_LSQ_fovalue(((V *)Rv0)[2]);
      break;
      case 1:Ra.sl[3]=472; /* line # 472 */
      Ret=MXD_LSQ_fovalue(((V *)Rv0)[1])-MXD_LSQ_fovalue(((V *)Rv0)[2]);
      break;
      case 2:Ra.sl[3]=474; /* line # 474 */
      ((F *)Rv0)[3]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      ((F *)Rv0)[4]=MXD_LSQ_fovalue(((V *)Rv0)[2]);
      Ra.sl[3]=475; /* line # 475 */
      Ret=((F *)Rv0)[3]*((F *)Rv0)[4];
      break;
      case 3:Ra.sl[3]=478; /* line # 478 */
      ((F *)Rv0)[3]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      ((F *)Rv0)[4]=MXD_LSQ_fovalue(((V *)Rv0)[2]);
      Ra.sl[3]=479; /* line # 479 */
      Ret=((F *)Rv0)[3]/((F *)Rv0)[4];
      break;
      case 4:Ra.sl[3]=482; /* line # 482 */
      ((F *)Rv0)[3]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      ((F *)Rv0)[4]=MXD_LSQ_fovalue(((V *)Rv0)[2]);
      Ra.sl[3]=483; /* line # 483 */
      Ret=exp(((F *)Rv0)[4]*log(((F *)Rv0)[3]));
      break;
      case 5:Ra.sl[3]=485; /* line # 485 */
      Ret= -MXD_LSQ_fovalue(((V *)Rv0)[1]);
      break;
      case 6:Ra.sl[3]=486; /* line # 486 */
      ((F *)Rv0)[2]=sqrt(MXD_LSQ_fovalue(((V *)Rv0)[1]));
      Ret=((F *)Rv0)[2];
      break;
      case 7:Ra.sl[3]=487; /* line # 487 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ret=log(((F *)Rv0)[2]);
      break;
      case 8:Ra.sl[3]=488; /* line # 488 */
      ((F *)Rv0)[2]=exp(MXD_LSQ_fovalue(((V *)Rv0)[1]));
      Ret=((F *)Rv0)[2];
      break;
      case 9:Ra.sl[3]=489; /* line # 489 */
      ((F *)Rv0)[2]=(float)(1.745329310000000E-002*(double)MXD_LSQ_fovalue(((V *)
      Rv0)[1]));
      Ret=sin(((F *)Rv0)[2]);
      break;
      case 10:Ra.sl[3]=490; /* line # 490 */
      ((F *)Rv0)[2]=(float)(1.745329310000000E-002*(double)MXD_LSQ_fovalue(((V *)
      Rv0)[1]));
      Ret=cos(((F *)Rv0)[2]);
      break;
      case 11:Ra.sl[3]=492; /* line # 492 */
      ((F *)Rv0)[2]=(float)(1.745329310000000E-002*(double)MXD_LSQ_fovalue(((V *)
      Rv0)[1]));
      Ra.sl[3]=493; /* line # 493 */
      Rv1=sin(((F *)Rv0)[2]);
      Ret=Rv1/sqrt((F)1.000000E+00-Rv1*Rv1);
      break;
      case 12:Ra.sl[3]=496; /* line # 496 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ret=(float)((double)asin(((F *)Rv0)[2])/1.745329310000000E-002);
      break;
      case 13:Ra.sl[3]=499; /* line # 499 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ret=(float)(9.000000000000000E+001-(double)asin(((F *)Rv0)[2])/1.745329310000000E-002)
      ;
      break;
      case 14:Ra.sl[3]=501; /* line # 501 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ret=(float)((double)atan(((F *)Rv0)[2])/1.745329310000000E-002);
      break;
      case 15:Ra.sl[3]=502; /* line # 502 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ret=MXD_TANH(((F *)Rv0)[2]);
      break;
      case 16:Ra.sl[3]=504; /* line # 504 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ret=PAS__IFPOWER(((F *)Rv0)[2],((SL *)Rv0)[3]);
      break;
      case 33:Ra.sl[3]=506; /* line # 506 */
      Ret=((F *)Rv0)[1];
      break;
      case 34:Ra.sl[3]=507; /* line # 507 */
      Ret=V_cdrec.f[((SL *)Rv0)[1]+16];
      break;
      case 35:Ra.sl[3]=509; /* line # 509 */
      switch (((SL *)Rv0)[1]) {
        case 0:Ra.sl[3]=510; /* line # 510 */
        Ret=V_hr;
        break;
        case 1:Ra.sl[3]=511; /* line # 511 */
        Ret=V_kr;
        break;
        case 2:Ra.sl[3]=512; /* line # 512 */
        Ret=V_lr;
        break;
        case 3:Ra.sl[3]=513; /* line # 513 */
        Ret=V_hc;
        break;
        case 4:Ra.sl[3]=514; /* line # 514 */
        Ret=V_kc;
        break;
        case 5:Ra.sl[3]=515; /* line # 515 */
        Ret=V_lc;
        break;
        case 6:Ra.sl[3]=516; /* line # 516 */
        Ret=V_cdrec.f[12];
        break;
        case 7:
        case 8:
        case 9:Ra.sl[3]=517; /* line # 517 */
        if (V_cnpola==NULL) Ret=(F)0.000000E-01;
        else {
          Ra.sl[3]=518; /* line # 518 */
          Ret=MXD_LSQ_value(((V *)V_cnpola)[(((SL *)Rv0)[1]-6)+3]);
        }
        break;
        case 10:Ra.sl[3]=519; /* line # 519 */
        if (V_cwave==NULL) Ret=(F)0.000000E-01;
        else Ret=((F *)V_cwave)[4];
        break;
        case 11:Ra.sl[3]=520; /* line # 520 */
        if (V_cwave==NULL) Ret=(F)0.000000E-01;
        else Ret=((F *)V_cwave)[5];
        break;
        case 12:Ra.sl[3]=521; /* line # 521 */
        if (V_cwave==NULL) Ret=(F)0.000000E-01;
        else Ret=((F *)V_cwave)[6];
        break;
        case 13:Ra.sl[3]=522; /* line # 522 */
        Ret=V_hh;
        break;
        case 14:Ra.sl[3]=523; /* line # 523 */
        Ret=V_kk;
        break;
        case 15:Ra.sl[3]=524; /* line # 524 */
        Ret=V_ll;
        break;
        case 20:Ra.sl[3]=525; /* line # 525 */
        Ret=(float)((double)V_h2/6.283185299999999E+000);
        break;
        case 21:Ra.sl[3]=526; /* line # 526 */
        Ret=(float)((double)V_k2/6.283185299999999E+000);
        break;
        case 22:Ra.sl[3]=527; /* line # 527 */
        Ret=(float)((double)V_l2/6.283185299999999E+000);
        break;
        case 16:Ra.sl[3]=528; /* line # 528 */
        Ret=V_cdrec.f[13];
        break;
        case 17:Ra.sl[3]=529; /* line # 529 */
        Ret=V_cdrec.f[15];
        break;
        case 18:Ra.sl[3]=530; /* line # 530 */
        Ret=V_cdrec.f[14];
        break;
        case 19:Ra.sl[3]=531; /* line # 531 */
        Ret=(float)V_refcatsv;
        break;
        case 23:Ra.sl[3]=532; /* line # 532 */
        Ret=Rs.f[1026];
        break;
        case 24:Ra.sl[3]=533; /* line # 533 */
        Ret=Rs.f[1027];
        break;
        case 25:Ra.sl[3]=534; /* line # 534 */
        Ret=Rs.f[1028];
        break;
        case 26:Ra.sl[3]=535; /* line # 535 */
        Ret=Rs.f[1029];
        break;
        case 27:Ra.sl[3]=536; /* line # 536 */
        Ret=V_fnr;
        break;
        case 28:Ra.sl[3]=537; /* line # 537 */
        Ret=V_fni;
        break;
        case 29:Ra.sl[3]=538; /* line # 538 */
        Ret=V_fmxr;
        break;
        case 30:Ra.sl[3]=539; /* line # 539 */
        Ret=V_fmyr;
        break;
        case 31:Ra.sl[3]=540; /* line # 540 */
        Ret=V_fmzr;
        break;
        case 32:Ra.sl[3]=541; /* line # 541 */
        Ret=V_fmxi;
        break;
        case 33:Ra.sl[3]=542; /* line # 542 */
        Ret=V_fmyi;
        break;
        case 34:Ra.sl[3]=543; /* line # 543 */
        Ret=V_fmzi;
        break;
      }
      break;
      case 37:Ra.sl[3]=546; /* line # 546 */
      ((SL *)Rv0)[1]=PAS__F_ROUND(MXD_LSQ_fovalue(((V *)Rv0)[3])+(F)1.000000E+00)
      ;
      Ra.sl[3]=547; /* line # 547 */
      if (((SL *)Rv0)[1]<1||((SL *)Rv0)[1]>=((SL *)Rv0)[2]) Ret=(F)0.000000E-01;
      else {
        Ra.sl[3]=548; /* line # 548 */
        Ret=MXD_LSQ_fovalue(((V *)Rv0)[((SL *)Rv0)[1]+3]);
      }
      break;
      case 36:Ra.sl[3]=550; /* line # 550 */
      if (V_cselect>=((SL *)Rv0)[2]) Ret=(F)0.000000E-01;
      else {
        Ra.sl[3]=551; /* line # 551 */
        if (((V *)Rv0)[V_cselect+3]==NULL) Ret=(F)0.000000E-01;
        else {
          Ra.sl[3]=552; /* line # 552 */
          Ret=MXD_LSQ_fovalue(((V *)Rv0)[V_cselect+3]);
        }
      }
      break;
      case 17:Ra.sl[3]=554; /* line # 554 */
      ((F *)Rv0)[3]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      ((F *)Rv0)[4]=MXD_LSQ_fovalue(((V *)Rv0)[2]);
      Ra.sl[3]=555; /* line # 555 */
      Ret=(float)((double)atan2(((F *)Rv0)[3],((F *)Rv0)[4])/1.745329310000000E-002)
      ;
      break;
      case 21:Ra.sl[3]=558; /* line # 558 */
      Ret=P_fbjn(((F *)Rv0)+3,MXD_LSQ_fovalue(((V *)Rv0)[2]),PAS__F_ROUND(MXD_LSQ_fovalue((
      (V *)Rv0)[1])));
      break;
      case 18:Ra.sl[3]=562; /* line # 562 */
      ((F *)Rv0)[2]=MXD_LSQ_fovalue(((V *)Rv0)[1]);
      Ra.sl[3]=563; /* line # 563 */
      Ret=fabs(((F *)Rv0)[2]);
      break;
      case 19:Ra.sl[3]=565; /* line # 565 */
      Ret=(float)PAS__F_ROUND(MXD_LSQ_fovalue(((V *)Rv0)[1]));
      break;
      case 20:Ra.sl[3]=566; /* line # 566 */
      Ret=(float)PAS__I_MOD(PAS__F_ROUND(MXD_LSQ_fovalue(((V *)Rv0)[1])),PAS__F_ROUND
      (MXD_LSQ_fovalue(((V *)Rv0)[2])));
      break;
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:Ra.sl[3]=568; /* line # 568 */
      Rv1=MXD_LSQ_fovalue(((V *)Rv0)[1])-MXD_LSQ_fovalue(((V *)Rv0)[2]);
      Ra.sl[3]=569; /* line # 569 */
      switch (((UB *)Rv0)[0]) {
        case 27:Ra.sl[3]=570; /* line # 570 */
        Ret=(float)((SL)(Rv1==(F)0.000000E-01));
        break;
        case 28:Ra.sl[3]=571; /* line # 571 */
        Ret=(float)((SL)(Rv1!=(F)0.000000E-01));
        break;
        case 29:Ra.sl[3]=572; /* line # 572 */
        Ret=(float)((SL)(Rv1<(F)0.000000E-01));
        break;
        case 30:Ra.sl[3]=573; /* line # 573 */
        Ret=(float)((SL)(Rv1<=(F)0.000000E-01));
        break;
        case 31:Ra.sl[3]=574; /* line # 574 */
        Ret=(float)((SL)(Rv1>=(F)0.000000E-01));
        break;
        case 32:Ra.sl[3]=575; /* line # 575 */
        Ret=(float)((SL)(Rv1>(F)0.000000E-01));
        break;
      }
      break;
      case 38:Ra.sl[3]=578; /* line # 578 */
      Ret=((F *)Rv0)[1];
      break;
      case 22:Ra.sl[3]=579; /* line # 579 */
      Ret=MXD_LSQ_sumloop(F_p,NULL);
      break;
      case 24:
      case 26:Ra.sl[3]=581; /* line # 581 */
      Ret=MXD_LSQ_usercall(F_p,NULL,((UB *)Rv0)[0]==26);
      break;
      case 23:Ra.sl[3]=582; /* line # 582 */
      Ret=((F *)Rv0)[4];
      break;
      case 25:Ra.sl[3]=583; /* line # 583 */
      Ret=MXD_LSQ_fovalue(((V *)Rv0)[5]);
      break;
      case 39:Ra.sl[3]=584; /* line # 584 */
      Ret=((F *)Rv0)[6];
      break;
      case 40:Ra.sl[3]=585; /* line # 585 */
      Ret=((F *)Rv0)[7];
      break;
      case 41:Ra.sl[3]=586; /* line # 586 */
      Ret=((F *)Rv0)[4];
      break;
    }
  }
  Ra.sl[3]=588; /* line # 588 */
  if (Ri.ul[0]>0) Ri.ul[0]=Ri.ul[0] -1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " der "  */
F MXD_LSQ_der(V F_p, V F_q){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  V Rv1;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+113;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=600; /* line # 600 */
  if (F_p==NULL) Ret=(F)0.000000E-01;
  else {
    Ra.sl[3]=602; /* line # 602 */
    Rv0=(F)0.000000E-01;
    Rv1=((V *)F_p)[5];
    Ra.sl[3]=603; /* line # 603 */
    while (Rv1!=NULL){
      Ra.sl[3]=604; /* line # 604 */
      if (((V *)Rv1)[1]==F_q) {
        Ra.sl[3]=605; /* line # 605 */
        Rv0=((F *)Rv1)[2];
        Rv1=NULL;
      }
      else {
        Ra.sl[3]=606; /* line # 606 */
        Rv1=((V *)Rv1)[0];
      }
    }
    Ra.sl[3]=607; /* line # 607 */
    Ret=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " foderiv "  */
F MXD_LSQ_foderiv(V F_p, V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+118;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=620; /* line # 620 */
  V_cformula=F_p;
  Ra.sl[3]=621; /* line # 621 */
  V_cvariable=F_pr;
  Ra.sl[3]=622; /* line # 622 */
  if (F_p==NULL) Ret=(F)0.000000E-01;
  else {
    Ra.sl[3]=623; /* line # 623 */
    Rv0=F_p;
    Ra.sl[3]=624; /* line # 624 */
    switch (((UB *)Rv0)[0]) {
      case 0:Ra.sl[3]=625; /* line # 625 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)+MXD_LSQ_foderiv(((V *)Rv0)[2],F_pr);
      break;
      case 1:Ra.sl[3]=626; /* line # 626 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)-MXD_LSQ_foderiv(((V *)Rv0)[2],F_pr);
      break;
      case 2:Ra.sl[3]=627; /* line # 627 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*((F *)Rv0)[4]+((F *)Rv0)[3]*MXD_LSQ_foderiv((
      (V *)Rv0)[2],F_pr);
      break;
      case 3:Ra.sl[3]=628; /* line # 628 */
      Ret=(MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*((F *)Rv0)[4]-MXD_LSQ_foderiv(((V
       *)Rv0)[2],F_pr)*((F *)Rv0)[3])/PAS__F_SQR(((F *)Rv0)[4]);
      break;
      case 4:Ra.sl[3]=631; /* line # 631 */
      Rv1=log(((F *)Rv0)[3]);
      Ra.sl[3]=632; /* line # 632 */
      Ret=exp(Rv1*((F *)Rv0)[4])*(MXD_LSQ_foderiv(((V *)Rv0)[2],F_pr)*Rv1+(((F *)
      Rv0)[4]*MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr))/((F *)Rv0)[3]);
      break;
      case 5:Ra.sl[3]=635; /* line # 635 */
      Ret= -MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr);
      break;
      case 6:Ra.sl[3]=636; /* line # 636 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)/((F)2.000000E+00*((F *)Rv0)[2]);
      break;
      case 7:Ra.sl[3]=637; /* line # 637 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)/((F *)Rv0)[2];
      break;
      case 8:Ra.sl[3]=638; /* line # 638 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*((F *)Rv0)[2];
      break;
      case 9:Ra.sl[3]=639; /* line # 639 */
      Ret=(float)(((double)MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*1.745329310000000E-002)
      *(double)cos(((F *)Rv0)[2]));
      break;
      case 10:Ra.sl[3]=640; /* line # 640 */
      Ret=(float)(((double)( -MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr))*1.745329310000000E-002)
      *(double)sin(((F *)Rv0)[2]));
      break;
      case 11:Ra.sl[3]=641; /* line # 641 */
      Ret=(float)(((double)MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*1.745329310000000E-002)
      /(double)PAS__F_SQR(cos(((F *)Rv0)[2])));
      break;
      case 12:Ra.sl[3]=642; /* line # 642 */
      Ret=(float)((double)MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)/((double)sqrt((F)1.000000E+00-
      PAS__F_SQR(((F *)Rv0)[2]))*1.745329310000000E-002));
      break;
      case 13:Ra.sl[3]=643; /* line # 643 */
      Ret=(float)((double)( -MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr))/((double)sqrt(
      (F)1.000000E+00-PAS__F_SQR(((F *)Rv0)[2]))*1.745329310000000E-002));
      break;
      case 14:Ra.sl[3]=644; /* line # 644 */
      Ret=(float)((double)MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)/((double)((F)1.000000E+00+
      PAS__F_SQR(((F *)Rv0)[2]))*1.745329310000000E-002));
      break;
      case 15:Ra.sl[3]=645; /* line # 645 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*((F)1.000000E+00-PAS__F_SQR(MXD_TANH((
      (F *)Rv0)[2])));
      break;
      case 21:Ra.sl[3]=646; /* line # 646 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[2],F_pr)*((F *)Rv0)[3];
      break;
      case 16:Ra.sl[3]=647; /* line # 647 */
      Ret=(MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*(float)((SL *)Rv0)[3])*PAS__IFPOWER
      (((F *)Rv0)[2],((SL *)Rv0)[3]-1);
      break;
      case 33:
      case 34:Ra.sl[3]=649; /* line # 649 */
      Ret=(F)0.000000E-01;
      break;
      case 39:Ra.sl[3]=650; /* line # 650 */
      Ret=MXD_LSQ_der(F_p, F_pr);
      break;
      case 40:Ra.sl[3]=651; /* line # 651 */
      if (F_pr==F_p) Ret=(F)1.000000E+00;
      else Ret=(F)0.000000E-01;
      break;
      case 37:Ra.sl[3]=654; /* line # 654 */
      if (((SL *)Rv0)[1]<1||((SL *)Rv0)[1]>=((SL *)Rv0)[2]) Ret=(F)0.000000E-01;
      else {
        Ra.sl[3]=655; /* line # 655 */
        Ret=MXD_LSQ_foderiv(((V *)Rv0)[((SL *)Rv0)[1]+3],F_pr);
      }
      break;
      case 36:Ra.sl[3]=658; /* line # 658 */
      if (V_cselect>=((SL *)Rv0)[2]) Ret=(F)0.000000E-01;
      else {
        Ra.sl[3]=659; /* line # 659 */
        if (((V *)Rv0)[V_cselect+3]==NULL) Ret=(F)0.000000E-01;
        else {
          Ra.sl[3]=660; /* line # 660 */
          Ret=MXD_LSQ_foderiv(((V *)Rv0)[V_cselect+3],F_pr);
        }
      }
      break;
      case 17:Ra.sl[3]=663; /* line # 663 */
      Rv1=PAS__F_SQR(((F *)Rv0)[3])+PAS__F_SQR(((F *)Rv0)[4]);
      Ra.sl[3]=664; /* line # 664 */
      if (Rv1<=(F)1.000000E-06) Ret=(F)0.000000E-01;
      else {
        Ra.sl[3]=665; /* line # 665 */
        Ret=(float)((double)(MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr)*((F *)Rv0)[4]-(
        (F *)Rv0)[3]*MXD_LSQ_foderiv(((V *)Rv0)[2],F_pr))/(1.745329310000000E-002*
        (double)Rv1));
      }
      break;
      case 18:Ra.sl[3]=669; /* line # 669 */
      if (((F *)Rv0)[2]==(F)0.000000E-01) Ret=(F)0.000000E-01;
      else {
        Ra.sl[3]=670; /* line # 670 */
        if (((F *)Rv0)[2]>(F)0.000000E-01) Ret=MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr);
        else {
          Ra.sl[3]=671; /* line # 671 */
          Ret= -MXD_LSQ_foderiv(((V *)Rv0)[1],F_pr);
        }
      }
      break;
      case 22:Ra.sl[3]=673; /* line # 673 */
      Ret=MXD_LSQ_sumloop(F_p, F_pr);
      break;
      case 24:
      case 26:Ra.sl[3]=675; /* line # 675 */
      Ret=MXD_LSQ_usercall(F_p, F_pr,((UB *)Rv0)[0]==26);
      break;
      case 25:Ra.sl[3]=677; /* line # 677 */
      Ret=MXD_LSQ_foderiv(((V *)Rv0)[5],F_pr);
      break;
      case 19:
      case 20:
      case 23:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 35:
      case 38:
      case 41:Ra.sl[3]=680; /* line # 680 */
      Ret=(F)0.000000E-01;
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " usercall "  */
F MXD_LSQ_usercall(V F_pn, V F_pv, UB F_bf){
  /* Define the automatic variable space. */
  Blk( Ra, 144 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+127;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=693; /* line # 693 */
  Rv0=F_pn;
  Ra.sl[3]=695; /* line # 695 */
  Rv1=((V *)Rv0)[((SL *)Rv0)[2]+3];
  Ra.sl[3]=696; /* line # 696 */
  if (F_bf) Rv1=((V *)Rv1)[5];
  Ra.sl[3]=697; /* line # 697 */
  Rv2=((V *)Rv1)[4];
  Ra.sl[3]=698; /* line # 698 */
  Rv3=0;
  Ra.sl[3]=699; /* line # 699 */
  while (Rv2!=NULL){
    Ra.sl[3]=702; /* line # 702 */
    Ra.v[Rv3+4]=((V *)Rv2)[5];
    Ra.sl[3]=703; /* line # 703 */
    if (Rv3<((SL *)Rv0)[2]) ((V *)Rv2)[5]=((V *)Rv0)[Rv3+3];
    else {
      Ra.sl[3]=704; /* line # 704 */
      ((V *)Rv2)[5]=NULL;
    }
    Ra.sl[3]=705; /* line # 705 */
    Rv3=Rv3+1;
    Rv2=((V *)Rv2)[4];
  }
  Ra.sl[3]=707; /* line # 707 */
  if (F_pv==NULL) {
    Ra.sl[3]=708; /* line # 708 */
    Ret=MXD_LSQ_fovalue(((V *)Rv1)[5]);
  }
  else {
    Ra.sl[3]=710; /* line # 710 */
    Ret=MXD_LSQ_foderiv(((V *)Rv1)[5],F_pv);
  }
  Ra.sl[3]=711; /* line # 711 */
  Rv3=0;
  Rv2=((V *)Rv1)[4];
  Ra.sl[3]=712; /* line # 712 */
  while (Rv2!=NULL){
    Ra.sl[3]=714; /* line # 714 */
    ((V *)Rv2)[5]=Ra.v[Rv3+4];
    Rv3=Rv3+1;
    Rv2=((V *)Rv2)[4];
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sumloop "  */
F MXD_LSQ_sumloop(V F_pn, V F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+137;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=726; /* line # 726 */
  Rv0=F_pn;
  Ra.sl[3]=728; /* line # 728 */
  Rv1=MXD_LSQ_fovalue(((V *)Rv0)[1]);
  Rv2=MXD_LSQ_fovalue(((V *)Rv0)[2]);
  Ra.sl[3]=729; /* line # 729 */
  Rv3=MXD_LSQ_fovalue(((V *)Rv0)[3]);
  Rv4=((F *)((V *)Rv0)[4])[4];
  Ra.sl[3]=730; /* line # 730 */
  Rv5=(F)0.000000E-01;
  Ra.sl[3]=731; /* line # 731 */
  while (Rv3>(F)0.000000E-01&&Rv1<=Rv2||Rv3<(F)0.000000E-01&&Rv1>=Rv2){
    Ra.sl[3]=734; /* line # 734 */
    ((F *)((V *)Rv0)[4])[4]=Rv1;
    Ra.sl[3]=735; /* line # 735 */
    if (F_pv==NULL) Rv5=Rv5+MXD_LSQ_fovalue(((V *)Rv0)[5]);
    else {
      Ra.sl[3]=736; /* line # 736 */
      Rv5=Rv5+MXD_LSQ_foderiv(((V *)Rv0)[5],F_pv);
    }
    Ra.sl[3]=737; /* line # 737 */
    Rv1=Rv1+Rv3;
  }
  Ra.sl[3]=739; /* line # 739 */
  ((F *)((V *)Rv0)[4])[4]=Rv4;
  Ra.sl[3]=741; /* line # 741 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skipvirtual "  */
void MXD_LSQ_skipvirtual(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+146;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=753; /* line # 753 */
  Rv0=0;
  Ra.sl[3]=754; /* line # 754 */
  while (!Rv0){
    Ra.sl[3]=756; /* line # 756 */
    Rv0=(*F_p)==NULL;
    Ra.sl[3]=757; /* line # 757 */
    if (!Rv0) {
      Ra.sl[3]=758; /* line # 758 */
      if (((SL *)((V *)(*F_p))[1])[5]<1) (*F_p)=((V *)(*F_p))[0];
      else Rv0=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outnameid "  */
void MXD_LSQ_outnameid(V F_pid, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+159;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=769; /* line # 769 */
  if (F_pid!=NULL) {
    Ra.sl[3]=770; /* line # 770 */
    Rv0=F_pid;
    Ra.sl[3]=772; /* line # 772 */
    Rv1=(SL)((C *)Rv0)[0];
    Ra.sl[3]=773; /* line # 773 */
    if (F_f>=0) {
      Ra.sl[3]=774; /* line # 774 */
      if (F_f<=Rv1) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHT(Rv0+1,16, Rv1,-1,32);
      }
      else {
        Ra.sl[3]=775; /* line # 775 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHT(Rv0+1,16, Rv1,-1,32);
        PAS__WRITE_FCHAR(32, F_f-Rv1,-1,1,32);
      }
    }
    else {
      Ra.sl[3]=778; /* line # 778 */
      F_f= -F_f;
      Ra.sl[3]=779; /* line # 779 */
      if (F_f<=Rv1) {
        PAS__SELECT_OUT(V_intf);
        PAS__WRITE_CHT(Rv0+1,16, Rv1,-1,32);
      }
      else {
        Ra.sl[3]=780; /* line # 780 */
        PAS__SELECT_OUT(V_intf);
        PAS__WRITE_CHT(Rv0+1,16, Rv1,-1,32);
        PAS__WRITE_FCHAR(32, F_f-Rv1,-1,1,32);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " error_handler "  */
SL MXD_LSQ_error_handler(SL F_nerr){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  UB Rv2;
  F Rv3;
  F Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+170;
  Ra.v[11]=Rd.s+17;
  Ra.sl[12]=796; /* line # 796 */
  switch (F_nerr) {
    case 20:
    case 21:
    case 22:
    case 24:
    case 25:Ra.sl[12]=802; /* line # 802 */
    if (V_cparam!=NULL) {
      Ra.sl[12]=804; /* line # 804 */
      if (Ri.ul[0]>0&&Ri.ul[0]<=1024) {
        Ra.sl[12]=805; /* line # 805 */
        V_cformula=Rs.v[Ri.ul[0]+1];
      }
      Ra.sl[12]=806; /* line # 806 */
      P_skipline(2);
      Ra.sl[12]=807; /* line # 807 */
      P_newlinelst();
      Ra.sl[12]=808; /* line # 808 */
      switch (F_nerr) {
        case 20:Ra.sl[12]=809; /* line # 809 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+185,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 21:Ra.sl[12]=810; /* line # 810 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+221,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 22:Ra.sl[12]=811; /* line # 811 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+251,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 24:Ra.sl[12]=812; /* line # 812 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+284,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 25:Ra.sl[12]=813; /* line # 813 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+316,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
      }
      Ra.sl[12]=815; /* line # 815 */
      P_skipline(1);
      Ra.sl[12]=816; /* line # 816 */
      P_newlinelst();
      Ra.sl[12]=817; /* line # 817 */
      if (V_cvariable!=NULL) {
        Ra.sl[12]=819; /* line # 819 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+351,-1,-1,32);
        Ra.sl[12]=820; /* line # 820 */
        MXD_LSQ_outnameid(((V *)V_cparam)[2],0);
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+390,-1,-1,32);
        Ra.sl[12]=821; /* line # 821 */
        MXD_LSQ_outnameid(((V *)V_cvariable)[2],0);
      }
      else {
        Ra.sl[12]=825; /* line # 825 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+398,-1,-1,32);
        Ra.sl[12]=826; /* line # 826 */
        MXD_LSQ_outnameid(((V *)V_cparam)[2],0);
      }
      Ra.sl[12]=828; /* line # 828 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+437,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[12]=829; /* line # 829 */
      if (V_cformula!=NULL) {
        Ra.sl[12]=831; /* line # 831 */
        PAS__STR_TO_STR(Ra.s,Rd.s+441);
        Ra.sl[12]=832; /* line # 832 */
        Rv1=V_cformula;
        Ra.sl[12]=833; /* line # 833 */
        switch (((UB *)Rv1)[0]) {
          case 0:
          case 1:Ra.sl[12]=836; /* line # 836 */
          if (((UB *)Rv1)[0]==0) PAS__CHA_TO_STR(Ra.s,43);
          else PAS__CHA_TO_STR(Ra.s,45);
          Ra.sl[12]=837; /* line # 837 */
          Rv2=1;
          Ra.sl[12]=838; /* line # 838 */
          Rv3=MXD_LSQ_fovalue(((V *)Rv1)[1]);
          Rv4=MXD_LSQ_fovalue(((V *)Rv1)[2]);
          break;
          case 2:
          case 3:Ra.sl[12]=842; /* line # 842 */
          if (((UB *)Rv1)[0]==2) PAS__CHA_TO_STR(Ra.s,42);
          else PAS__CHA_TO_STR(Ra.s,47);
          Ra.sl[12]=843; /* line # 843 */
          Rv2=1;
          Ra.sl[12]=844; /* line # 844 */
          Rv3=((F *)Rv1)[3];
          Rv4=((F *)Rv1)[4];
          break;
          case 4:
          case 16:Ra.sl[12]=848; /* line # 848 */
          Rv2=1;
          PAS__STR_TO_STR(Ra.s,Rd.s+443);
          Ra.sl[12]=849; /* line # 849 */
          if (((UB *)Rv1)[0]==4) {
            Ra.sl[12]=850; /* line # 850 */
            Rv3=((F *)Rv1)[3];
            Rv4=((F *)Rv1)[4];
          }
          else {
            Ra.sl[12]=852; /* line # 852 */
            Rv3=((F *)Rv1)[2];
            Rv4=(float)((SL *)Rv1)[3];
          }
          break;
          case 5:Ra.sl[12]=856; /* line # 856 */
          PAS__CHA_TO_STR(Ra.s,45);
          Rv3=MXD_LSQ_fovalue(((V *)Rv1)[1]);
          break;
          case 6:Ra.sl[12]=858; /* line # 858 */
          PAS__STR_TO_STR(Ra.s,Rd.s+447);
          Rv3=MXD_LSQ_fovalue(((V *)Rv1)[1]);
          break;
          case 7:Ra.sl[12]=859; /* line # 859 */
          PAS__STR_TO_STR(Ra.s,Rd.s+454);
          Rv3=((F *)Rv1)[2];
          break;
          case 8:Ra.sl[12]=860; /* line # 860 */
          PAS__STR_TO_STR(Ra.s,Rd.s+460);
          Rv3=((F *)Rv1)[2];
          break;
          case 11:Ra.sl[12]=861; /* line # 861 */
          PAS__STR_TO_STR(Ra.s,Rd.s+466);
          Rv3=(float)((double)((F *)Rv1)[2]/1.745329310000000E-002);
          break;
          case 12:Ra.sl[12]=862; /* line # 862 */
          PAS__STR_TO_STR(Ra.s,Rd.s+472);
          Rv3=((F *)Rv1)[2];
          break;
          case 13:Ra.sl[12]=863; /* line # 863 */
          PAS__STR_TO_STR(Ra.s,Rd.s+479);
          Rv3=((F *)Rv1)[2];
          break;
          case 14:Ra.sl[12]=864; /* line # 864 */
          PAS__STR_TO_STR(Ra.s,Rd.s+486);
          Rv3=((F *)Rv1)[2];
          break;
          case 15:Ra.sl[12]=865; /* line # 865 */
          PAS__STR_TO_STR(Ra.s,Rd.s+493);
          Rv3=((F *)Rv1)[2];
          break;
          case 17:Ra.sl[12]=868; /* line # 868 */
          PAS__STR_TO_STR(Ra.s,Rd.s+500);
          Rv2=1;
          Ra.sl[12]=869; /* line # 869 */
          Rv3=((F *)Rv1)[3];
          Rv4=((F *)Rv1)[4];
          break;
          case 19:Ra.sl[12]=871; /* line # 871 */
          PAS__STR_TO_STR(Ra.s,Rd.s+507);
          Rv3=MXD_LSQ_fovalue(((V *)Rv1)[1]);
          break;
          case 20:Ra.sl[12]=874; /* line # 874 */
          PAS__STR_TO_STR(Ra.s,Rd.s+515);
          Rv2=1;
          Ra.sl[12]=875; /* line # 875 */
          Rv3=MXD_LSQ_fovalue(((V *)Rv1)[1]);
          Rv4=MXD_LSQ_fovalue(((V *)Rv1)[2]);
          break;
          case 38:Ra.sl[12]=877; /* line # 877 */
          PAS__STR_TO_STR(Ra.s,Rd.s+520);
          Rv3=MXD_LSQ_fovalue(((V *)Rv1)[3]);
          break;
          case 22:Ra.sl[12]=880; /* line # 880 */
          PAS__STR_TO_STR(Ra.s,Rd.s+529);
          Rv2=1;
          Ra.sl[12]=881; /* line # 881 */
          Rv3=((F *)((V *)Rv1)[4])[4];
          Rv4=MXD_LSQ_fovalue(((V *)Rv1)[5]);
          break;
          default:break;
        }
        Ra.sl[12]=886; /* line # 886 */
        if (Ra.ub[1]>0) {
          Ra.sl[12]=888; /* line # 888 */
          P_newlinelst();
          Ra.sl[12]=889; /* line # 889 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+536,-1,-1,32);
          Ra.sl[12]=890; /* line # 890 */
          if (Ra.c[Ra.ub[1]+1]==40) {
            Ra.sl[12]=892; /* line # 892 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Ra.s,-1,-1,32);
            PAS__WRITE_SNGL(Rv3,16,-6,0);
            Ra.sl[12]=893; /* line # 893 */
            if (Rv2) {
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+555,-1,-1,32);
              PAS__WRITE_SNGL(Rv4,16,-6,0);
            }
            Ra.sl[12]=894; /* line # 894 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+559,-1,-1,32);
            PAS__WRITE_EOLN();
          }
          else {
            Ra.sl[12]=898; /* line # 898 */
            if (Rv2) {
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_SNGL(Rv3,16,-6,0);
            }
            Ra.sl[12]=899; /* line # 899 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Ra.s,-1,-1,32);
            Ra.sl[12]=900; /* line # 900 */
            if (Rv2) {
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_SNGL(Rv4,16,-6,0);
            }
            else {
              Ra.sl[12]=901; /* line # 901 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_SNGL(Rv3,16,-6,0);
            }
            Ra.sl[12]=902; /* line # 902 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+565,-1,-1,32);
            PAS__WRITE_EOLN();
          }
        }
      }
      Ra.sl[12]=906; /* line # 906 */
      siglongjmp(G_lb_env,1);
      Ra.sl[12]=908; /* line # 908 */
      Rv0=1;
    }
    else {
      Ra.sl[12]=910; /* line # 910 */
      Rv0=0;
    }
    break;
    default:Ra.sl[12]=913; /* line # 913 */
    Rv0=0;
    break;
  }
  Ra.sl[12]=915; /* line # 915 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[9];
  return(Ret);
}


/* Procedure/Function : " parmderval "  */
void MXD_LSQ_parmderval(SL F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+569;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=928; /* line # 928 */
  if (F_id<0) Rv0=V_parhde;
  else Rv0=V_pardhde.v[F_id];
  Ra.sl[3]=929; /* line # 929 */
  while (Rv0!=NULL){
    Ra.sl[3]=931; /* line # 931 */
    V_cparam=Rv0;
    Ra.sl[3]=932; /* line # 932 */
    V_cvariable=NULL;
    Ra.sl[3]=933; /* line # 933 */
    Rv1=Rv0;
    Ra.sl[3]=935; /* line # 935 */
    ((F *)Rv1)[6]=MXD_LSQ_fovalue(((V *)Rv1)[4]);
    Ra.sl[3]=936; /* line # 936 */
    Rv2=((V *)Rv1)[5];
    Ra.sl[3]=937; /* line # 937 */
    while (Rv2!=NULL){
      Ra.sl[3]=939; /* line # 939 */
      Rv3=Rv2;
      ((F *)Rv3)[2]=MXD_LSQ_foderiv(((V *)Rv1)[4],((V *)Rv3)[1]);
      Ra.sl[3]=940; /* line # 940 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[3]=943; /* line # 943 */
    if (F_id<0) Rv0=((V *)Rv0)[1];
    else Rv0=((V *)Rv0)[7];
  }
  Ra.sl[3]=945; /* line # 945 */
  V_cparam=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " clrsumhkl "  */
void MXD_LSQ_clrsumhkl(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+581;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=956; /* line # 956 */
  Rv0=V_sumhhde;
  Ra.sl[3]=957; /* line # 957 */
  while (Rv0!=NULL){
    Ra.sl[3]=958; /* line # 958 */
    ((F *)Rv0)[1]=(F)0.000000E-01;
    Rv0=((V *)Rv0)[2];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " makesumhkl "  */
void MXD_LSQ_makesumhkl(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+592;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=969; /* line # 969 */
  Rv0=V_sumhhde;
  Ra.sl[3]=970; /* line # 970 */
  while (Rv0!=NULL){
    Ra.sl[3]=971; /* line # 971 */
    Rv1=Rv0;
    Ra.sl[3]=973; /* line # 973 */
    ((F *)Rv1)[1]=((F *)Rv1)[1]+MXD_LSQ_fovalue(((V *)Rv1)[3]);
    Rv0=((V *)Rv1)[2];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " sepatm "  */
void MXD_LSQ_sepatm(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+604;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=990; /* line # 990 */
  Rv0=V_atomhde;
  Rv1=NULL;
  Rv2=NULL;
  V_atmshde=NULL;
  Ra.sl[3]=991; /* line # 991 */
  while (Rv0!=NULL){
    Ra.sl[3]=993; /* line # 993 */
    Rv3=Rv0;
    Ra.sl[3]=995; /* line # 995 */
    Rv4=((V *)Rv3)[1];
    Ra.sl[3]=996; /* line # 996 */
    if (((V *)Rv3)[4]!=NULL||((V *)Rv3)[5]!=NULL) {
      Ra.sl[3]=999; /* line # 999 */
      if (Rv2==NULL) V_atmshde=Rv0;
      else((V *)Rv2)[1]=Rv0;
      Ra.sl[3]=1000; /* line # 1000 */
      Rv2=Rv0;
      ((V *)Rv3)[1]=NULL;
      Ra.sl[3]=1002; /* line # 1002 */
      if (Rv1==NULL) V_atomhde=Rv4;
      else((V *)Rv1)[1]=Rv4;
    }
    else {
      Ra.sl[3]=1005; /* line # 1005 */
      Rv1=Rv0;
    }
    Ra.sl[3]=1007; /* line # 1007 */
    Rv0=Rv4;
  }
  Ra.sl[3]=1010; /* line # 1010 */
  if (Rv1!=NULL) ((V *)Rv1)[1]=V_atmshde;
  else V_atomhde=V_atmshde;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setrealvar "  */
void MXD_LSQ_setrealvar(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+612;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1026; /* line # 1026 */
  Rv0=V_blkhde;
  Rv1=NULL;
  Ra.sl[3]=1027; /* line # 1027 */
  Rv2=V_gvarhde;
  Rv3=NULL;
  V_varhde=NULL;
  Ra.sl[3]=1028; /* line # 1028 */
  Rv4=0;
  Rv5=0;
  V_varnb=0;
  Rs.sl[1030]=1;
  Rs.sl[1031]=0;
  Ra.sl[3]=1029; /* line # 1029 */
  while (Rv2!=NULL){
    Ra.sl[3]=1031; /* line # 1031 */
    Rv4=Rv4+1;
    Ra.sl[3]=1032; /* line # 1032 */
    Rv6=Rv2;
    Ra.sl[3]=1034; /* line # 1034 */
    if (((SL *)Rv6)[5]>0) {
      Ra.sl[3]=1036; /* line # 1036 */
      V_varnb=V_varnb+1;
      ((SL *)Rv6)[5]=V_varnb;
      Ra.sl[3]=1038; /* line # 1038 */
      if (Rv3==NULL) V_varhde=Rv2;
      else((V *)Rv3)[3]=Rv2;
      Ra.sl[3]=1039; /* line # 1039 */
      Rv3=Rv2;
      ((V *)Rv6)[3]=V_varhde;
    }
    Ra.sl[3]=1042; /* line # 1042 */
    if (Rv0!=NULL) {
      Ra.sl[3]=1043; /* line # 1043 */
      Rv7=Rv0;
      Ra.sl[3]=1044; /* line # 1044 */
      if (((V *)Rv7)[7]==Rv2) {
        Ra.sl[3]=1046; /* line # 1046 */
        ((SL *)Rv7)[4]=V_varnb-Rv5;
        Rv5=V_varnb;
        Ra.sl[3]=1047; /* line # 1047 */
        Rs.sl[1031]=Rs.sl[1031]+(((SL *)Rv7)[4]*(((SL *)Rv7)[4]+1))/2;
        Ra.sl[3]=1048; /* line # 1048 */
        if (Rs.sl[1031]>126250) P_error(-10);
        Ra.sl[3]=1049; /* line # 1049 */
        Rs.sl[1030]=Rs.sl[1030]+((SL *)Rv7)[4];
        Ra.sl[3]=1050; /* line # 1050 */
        Rv8=((V *)Rv7)[1];
        Ra.sl[3]=1051; /* line # 1051 */
        if (((SL *)Rv7)[4]==0) {
          Ra.sl[3]=1053; /* line # 1053 */
          if (Rv0==V_blkhde) V_blkhde=((V *)Rv7)[1];
          else((V *)Rv1)[1]=((V *)Rv7)[1];
          Ra.sl[3]=1054; /* line # 1054 */
          ((V *)Rv7)[1]=V_freeblk;
          V_freeblk=Rv0;
        }
        else {
          Ra.sl[3]=1055; /* line # 1055 */
          Rv1=Rv0;
        }
        Ra.sl[3]=1056; /* line # 1056 */
        Rv0=Rv8;
      }
    }
    Ra.sl[3]=1058; /* line # 1058 */
    Rv2=((V *)Rv2)[1];
  }
  Ra.sl[3]=1061; /* line # 1061 */
  if (V_varnb>=Rs.sl[1030]) {
    Ra.sl[3]=1063; /* line # 1063 */
    if (V_freeblk==NULL) Rv8=PAS__NEW(32);
    else {
      Ra.sl[3]=1064; /* line # 1064 */
      Rv8=V_freeblk;
      V_freeblk=((V *)Rv8)[1];
    }
    Ra.sl[3]=1066; /* line # 1066 */
    if (Rv1==NULL) V_blkhde=Rv8;
    else((V *)Rv1)[1]=Rv8;
    Ra.sl[3]=1068; /* line # 1068 */
    Rv9=Rv8;
    Ra.sl[3]=1070; /* line # 1070 */
    ((V *)Rv9)[1]=NULL;
    Ra.sl[3]=1071; /* line # 1071 */
    ((V *)Rv9)[2]=P_buildsymbol(Rd.s+624);
    ((SL *)Rv9)[3]=0;
    Ra.sl[3]=1072; /* line # 1072 */
    ((V *)Rv9)[5]=NULL;
    Ra.sl[3]=1073; /* line # 1073 */
    ((V *)Rv9)[6]=NULL;
    Ra.sl[3]=1074; /* line # 1074 */
    ((SL *)Rv9)[4]=(V_varnb-Rs.sl[1030])+1;
    Ra.sl[3]=1075; /* line # 1075 */
    Rs.sl[1031]=Rs.sl[1031]+(((SL *)Rv9)[4]*(((SL *)Rv9)[4]+1))/2;
    Ra.sl[3]=1077; /* line # 1077 */
    if (Rs.sl[1031]>126250) P_error(-10);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setoption "  */
void P_setoption(SL F_i, SL F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  V Rv1;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+634;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1097; /* line # 1097 */
  if (F_id>0&&F_i!=17) {
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(&Rv0,0);
  }
  else Rv0=(F)0.000000E-01;
  Ra.sl[3]=1098; /* line # 1098 */
  if (F_i>=1&&F_i<=31) {
    Ra.sl[3]=1099; /* line # 1099 */
    switch (F_i) {
      case 1:Ra.sl[3]=1100; /* line # 1100 */
      Rs.sl[1]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      break;
      case 2:Ra.sl[3]=1102; /* line # 1102 */
      Rs.ub[4128]=Rv0>=(F)5.000000E-01;
      Rs.ub[4129]=Rv0>=(F)1.500000E+00;
      Ra.sl[3]=1103; /* line # 1103 */
      if (F_id>1) {
        Ra.sl[3]=1104; /* line # 1104 */
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(&Rv0,0);
        Rs.f[1033]=fabs(Rv0);
      }
      break;
      case 3:Ra.sl[3]=1106; /* line # 1106 */
      Rs.ub[4136]=Rv0>=(F)5.000000E-01;
      break;
      case 4:Ra.sl[3]=1107; /* line # 1107 */
      Rs.ub[4137]=Rv0>=(F)5.000000E-01;
      break;
      case 5:Ra.sl[3]=1108; /* line # 1108 */
      Rs.ub[4138]=Rv0>=(F)5.000000E-01;
      break;
      case 6:Ra.sl[3]=1109; /* line # 1109 */
      Rs.ub[4139]=Rv0>=(F)5.000000E-01;
      break;
      case 7:Ra.sl[3]=1110; /* line # 1110 */
      Rs.ub[4140]=Rv0>=(F)5.000000E-01;
      break;
      case 8:Ra.sl[3]=1111; /* line # 1111 */
      Rs.ub[4141]=Rv0>=(F)5.000000E-01;
      break;
      case 9:Ra.sl[3]=1112; /* line # 1112 */
      Rs.ub[4142]=Rv0>=(F)5.000000E-01;
      Rs.ub[4143]=Rv0>=(F)1.500000E+00;
      break;
      case 10:Ra.sl[3]=1113; /* line # 1113 */
      Rs.sl[1036]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      break;
      case 11:Ra.sl[3]=1114; /* line # 1114 */
      Rs.ub[4148]=Rv0>=(F)5.000000E-01;
      break;
      case 12:Ra.sl[3]=1115; /* line # 1115 */
      V_mxcateg=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      break;
      case 13:Ra.sl[3]=1116; /* line # 1116 */
      Rs.f[1038]=Rv0;
      break;
      case 14:Ra.sl[3]=1117; /* line # 1117 */
      Rs.f[1039]=Rv0;
      break;
      case 15:Ra.sl[3]=1118; /* line # 1118 */
      Rs.f[1040]=Rv0;
      break;
      case 16:Ra.sl[3]=1121; /* line # 1121 */
      Rs.sl[1041]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      Rs.sl[1042]= -Rs.sl[1041];
      Rs.sl[1043]=Rs.sl[1041];
      Ra.sl[3]=1122; /* line # 1122 */
      Rs.sl[1044]=Rs.sl[1042];
      Rs.sl[1045]=Rs.sl[1041];
      Rs.sl[1046]=Rs.sl[1042];
      Ra.sl[3]=1123; /* line # 1123 */
      if (F_id>=2) {
        Ra.sl[3]=1124; /* line # 1124 */
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(&Rv0,0);
        Rs.sl[1043]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      }
      Ra.sl[3]=1125; /* line # 1125 */
      if (F_id>=3) {
        Ra.sl[3]=1126; /* line # 1126 */
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(&Rv0,0);
        Rs.sl[1045]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      }
      Ra.sl[3]=1127; /* line # 1127 */
      if (F_id>=4) {
        Ra.sl[3]=1128; /* line # 1128 */
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(&Rv0,0);
        Rs.sl[1042]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      }
      Ra.sl[3]=1129; /* line # 1129 */
      if (F_id>=5) {
        Ra.sl[3]=1130; /* line # 1130 */
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(&Rv0,0);
        Rs.sl[1044]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      }
      Ra.sl[3]=1131; /* line # 1131 */
      if (F_id>=6) {
        Ra.sl[3]=1132; /* line # 1132 */
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(&Rv0,0);
        Rs.sl[1046]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      }
      break;
      case 17:Ra.sl[3]=1135; /* line # 1135 */
      if (F_id<=0) {
        Ra.sl[3]=1137; /* line # 1137 */
        Rs.sl[1047]=4;
        Ra.sl[3]=1138; /* line # 1138 */
        while (Rs.sl[1047]>0){
          Ra.sl[3]=1140; /* line # 1140 */
          Rs.v[Rs.sl[1047]+1047]=NULL;
          Rs.sl[1047]=Rs.sl[1047]-1;
        }
        Ra.sl[3]=1142; /* line # 1142 */
        Rs.ub[4208]=0;
      }
      else {
        Ra.sl[3]=1145; /* line # 1145 */
        while (F_id>0){
          Ra.sl[3]=1147; /* line # 1147 */
          Rv1=P_schitem(V_parhde,1);
          F_id=F_id-1;
          Ra.sl[3]=1148; /* line # 1148 */
          if (Rv1!=NULL) {
            Ra.sl[3]=1150; /* line # 1150 */
            Rs.sl[1047]=Rs.sl[1047]+1;
            Ra.sl[3]=1151; /* line # 1151 */
            if (Rs.sl[1047]>4) Rs.sl[1047]=1;
            Ra.sl[3]=1152; /* line # 1152 */
            Rs.ub[4208]=1;
            Rs.v[Rs.sl[1047]+1047]=Rv1;
          }
        }
      }
      break;
      case 18:Ra.sl[3]=1156; /* line # 1156 */
      Rs.f[1053]=fabs(Rv0);
      break;
      case 19:Ra.sl[3]=1158; /* line # 1158 */
      Rs.ub[4216]=Rv0>=(F)5.000000E-01;
      break;
      case 20:Ra.sl[3]=1160; /* line # 1160 */
      Rs.f[1055]=Rv0;
      Rs.ub[4224]=Rs.f[1055]>(F)0.000000E-01;
      break;
      case 21:Ra.sl[3]=1162; /* line # 1162 */
      Rs.f[1057]=fabs(Rv0);
      break;
      case 22:Ra.sl[3]=1163; /* line # 1163 */
      Rs.ub[4232]=Rv0>(F)5.000000E-01;
      break;
      case 23:Ra.sl[3]=1164; /* line # 1164 */
      Rs.ub[4233]=Rv0>=(F)5.000000E-01;
      break;
      case 24:Ra.sl[3]=1166; /* line # 1166 */
      Rs.ub[4234]=Rv0>(F)5.000000E-01;
      break;
      case 25:Ra.sl[3]=1169; /* line # 1169 */
      Rs.ub[4235]=Rv0>=(F)5.000000E-01;
      if (Rs.ub[4235]) Rs.ub[4216]=0;
      break;
      case 26:Ra.sl[3]=1172; /* line # 1172 */
      if (Rv0>=(F)5.000000E-01) {
        Ra.sl[3]=1174; /* line # 1174 */
        Rs.ub[4236]=1;
        Rv0=(F)0.000000E-01;
        Ra.sl[3]=1175; /* line # 1175 */
        if (F_id>3) {
          Ra.sl[3]=1176; /* line # 1176 */
          PAS__SELECT_INP(V_intf);
          PAS__READ_SNGL(Rs.f+1060,0);
          PAS__READ_SNGL(Rs.f+1061,0);
          PAS__READ_SNGL(Rs.f+1062,0);
          Ra.sl[3]=1177; /* line # 1177 */
          Rv0=sqrt((PAS__F_SQR(Rs.f[1060])+PAS__F_SQR(Rs.f[1061]))+PAS__F_SQR(Rs
          .f[1062]));
          Ra.sl[3]=1178; /* line # 1178 */
          if (Rv0>(F)1.000000E-04) {
            Ra.sl[3]=1179; /* line # 1179 */
            Rs.f[1060]=Rs.f[1060]/Rv0;
            Rs.f[1061]=Rs.f[1061]/Rv0;
            Rs.f[1062]=Rs.f[1062]/Rv0;
          }
          else {
            Ra.sl[3]=1180; /* line # 1180 */
            Rv0=(F)0.000000E-01;
          }
        }
        Ra.sl[3]=1182; /* line # 1182 */
        if (Rv0==(F)0.000000E-01) {
          Ra.sl[3]=1183; /* line # 1183 */
          Rs.f[1060]=(F)0.000000E-01;
          Rs.f[1061]=(F)0.000000E-01;
          Rs.f[1062]=(F)1.000000E+00;
        }
      }
      else {
        Ra.sl[3]=1185; /* line # 1185 */
        Rs.ub[4236]=0;
      }
      break;
      case 27:Ra.sl[3]=1187; /* line # 1187 */
      Rs.ub[4252]=Rv0>=(F)5.000000E-01;
      break;
      case 28:Ra.sl[3]=1188; /* line # 1188 */
      Rs.ub[4253]=Rv0>=(F)5.000000E-01;
      break;
      case 29:Ra.sl[3]=1189; /* line # 1189 */
      Rs.sl[1064]=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
      break;
      case 30:
      case 31:Ra.sl[3]=1191; /* line # 1191 */
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init "  */
UB MXD_LSQ_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+645;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1206; /* line # 1206 */
  PAS__CHT_TO_CHT(V_program_name.s,6, Rd.s+653,6);
  Ra.sl[3]=1207; /* line # 1207 */
  Rv0=P_inige(Rd.s+659);
  Ra.sl[3]=1208; /* line # 1208 */
  if (Rv0) {
    Ra.sl[3]=1210; /* line # 1210 */
    P_st_put_pastr(V_pageheadpt1,Rd.s+664);
    Ra.sl[3]=1211; /* line # 1211 */
    Rs.sl[1065]=0;
    Rs.sl[1066]=0;
    Rs.sl[1067]=0;
    Ra.sl[3]=1213; /* line # 1213 */
    Rs.v[1068]=NULL;
    Rs.v[1069]=NULL;
    Ra.sl[3]=1215; /* line # 1215 */
    Rs.sl[1042]=-1000;
    Rs.sl[1044]=Rs.sl[1042];
    Rs.sl[1046]=Rs.sl[1042];
    Ra.sl[3]=1216; /* line # 1216 */
    Rs.sl[1041]=1000;
    Rs.sl[1043]=Rs.sl[1041];
    Rs.sl[1045]=Rs.sl[1041];
    Ra.sl[3]=1217; /* line # 1217 */
    Rs.ub[4280]=0;
    Rs.ub[4232]=1;
    Ra.sl[3]=1218; /* line # 1218 */
    Rs.ub[4141]=0;
    Rs.ub[4148]=0;
    Rs.ub[4224]=1;
    Ra.sl[3]=1219; /* line # 1219 */
    Rs.ub[4129]=0;
    Rs.ub[4128]=0;
    Rs.ub[4281]=0;
    Ra.sl[3]=1220; /* line # 1220 */
    Rs.ub[4139]=0;
    Rs.ub[4140]=0;
    Rs.ub[4143]=0;
    Ra.sl[3]=1221; /* line # 1221 */
    Rs.ub[4142]=1;
    Rs.ub[4216]=0;
    Rs.ub[4234]=1;
    Ra.sl[3]=1222; /* line # 1222 */
    Rs.ub[4235]=0;
    Rs.ub[4236]=0;
    Ra.sl[3]=1223; /* line # 1223 */
    Rs.ub[4252]=0;
    Ra.sl[3]=1224; /* line # 1224 */
    Rs.ub[4136]=1;
    Rs.ub[4137]=0;
    Rs.ub[4138]=0;
    Ra.sl[3]=1225; /* line # 1225 */
    Rs.ub[4253]=1;
    Ra.sl[3]=1226; /* line # 1226 */
    Rs.sl[1064]=0;
    Ra.sl[3]=1227; /* line # 1227 */
    Rs.f[1033]=(F)0.000000E-01;
    Rs.f[1053]=(F)0.000000E-01;
    Ra.sl[3]=1229; /* line # 1229 */
    Rs.f[1040]=(F)0.000000E-01;
    Ra.sl[3]=1231; /* line # 1231 */
    Rs.f[1038]=(F)1.000000E+05;
    Ra.sl[3]=1232; /* line # 1232 */
    Rs.f[1039]=(F)0.000000E-01;
    Ra.sl[3]=1233; /* line # 1233 */
    Rs.f[1055]=(F)5.000000E-01;
    Ra.sl[3]=1234; /* line # 1234 */
    Rs.f[1057]=(F)0.000000E-01;
    Ra.sl[3]=1236; /* line # 1236 */
    Rs.sl[0]=0;
    Ra.sl[3]=1238; /* line # 1238 */
    Rs.sl[1036]=0;
    Ra.sl[3]=1240; /* line # 1240 */
    Rs.sl[1047]=4;
    Ra.sl[3]=1241; /* line # 1241 */
    while (Rs.sl[1047]>0){
      Ra.sl[3]=1242; /* line # 1242 */
      Rs.v[Rs.sl[1047]+1047]=NULL;
      Rs.sl[1047]=Rs.sl[1047]-1;
    }
    Ra.sl[3]=1243; /* line # 1243 */
    Rs.ub[4208]=0;
    Rs.ub[4233]=0;
    Ra.sl[3]=1244; /* line # 1244 */
    Rs.f[1028]=(F)-1.000000E+010;
    Rs.f[1029]=Rs.f[1028];
    Ra.sl[3]=1245; /* line # 1245 */
    Rs.f[1026]= -Rs.f[1028];
    Rs.f[1027]=Rs.f[1026];
    Ra.sl[3]=1246; /* line # 1246 */
    Rs.sl[1071]=0;
    Ra.sl[3]=1247; /* line # 1247 */
    PAS__CHT_TO_CHT(Rs.s+4288,4, Rd.s+728,4);
    Ra.sl[3]=1248; /* line # 1248 */
    PAS__CHT_TO_CHT(Rs.s+4292,4, Rd.s+734,4);
    Ra.sl[3]=1249; /* line # 1249 */
    PAS__CHT_TO_CHT(Rs.s+4296,4, Rd.s+740,4);
    Ra.sl[3]=1250; /* line # 1250 */
    PAS__CHT_TO_CHT(Rs.s+4300,4, Rd.s+746,4);
    Ra.sl[3]=1251; /* line # 1251 */
    PAS__CHT_TO_CHT(Rs.s+4304,4, Rd.s+752,4);
    Ra.sl[3]=1252; /* line # 1252 */
    PAS__CHT_TO_CHT(Rs.s+4308,4, Rd.s+758,4);
    Ra.sl[3]=1253; /* line # 1253 */
    PAS__CHT_TO_CHT(Rs.s+4312,4, Rd.s+764,4);
    Ra.sl[3]=1255; /* line # 1255 */
    PAS__STR_TO_STR(V_errmsgspecif.s,Rd.s+768);
  }
  Ra.sl[3]=1257; /* line # 1257 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " iniblk "  */
void MXD_LSQ_iniblk(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+788;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1279; /* line # 1279 */
  if (V_symhde==NULL) {
    Ra.sl[3]=1281; /* line # 1281 */
    V_symhde=PAS__NEW(68);
    Ra.sl[3]=1282; /* line # 1282 */
    Rv0=V_symhde;
    Ra.sl[3]=1284; /* line # 1284 */
    ((V *)Rv0)[1]=NULL;
    ((V *)Rv0)[2]=P_buildsymbol(Rd.s+796);
    ((SL *)Rv0)[3]=-1;
    Ra.sl[3]=1285; /* line # 1285 */
    ((SL *)Rv0)[4]=1;
    ((SL *)Rv0)[5]=0;
    ((SL *)Rv0)[6]=0;
    ((SL *)Rv0)[7]=0;
    Ra.sl[3]=1286; /* line # 1286 */
    ((SL *)Rv0)[8]=0;
    ((SL *)Rv0)[9]=1;
    ((SL *)Rv0)[10]=0;
    ((SL *)Rv0)[11]=0;
    Ra.sl[3]=1287; /* line # 1287 */
    ((SL *)Rv0)[12]=0;
    ((SL *)Rv0)[13]=0;
    ((SL *)Rv0)[14]=1;
    ((SL *)Rv0)[15]=0;
    Ra.sl[3]=1288; /* line # 1288 */
    ((V *)Rv0)[16]=NULL;
  }
  Ra.sl[3]=1293; /* line # 1293 */
  Rs.sl[1079]=Rs.sl[1031]+1;
  Rs.sl[1080]=Rs.sl[1079]+V_varnb;
  Ra.sl[3]=1294; /* line # 1294 */
  if (V_momhde!=NULL&&V_polhde!=NULL) {
    Ra.sl[3]=1296; /* line # 1296 */
    Rs.sl[1071]=Rs.sl[1080]+V_varnb;
    Rs.sl[1081]=Rs.sl[1071]+V_varnb;
  }
  else {
    Ra.sl[3]=1297; /* line # 1297 */
    Rs.sl[1081]=Rs.sl[1080]+V_varnb;
  }
  Ra.sl[3]=1298; /* line # 1298 */
  Rs.sl[1082]=Rs.sl[1081]+V_varnb;
  Ra.sl[3]=1299; /* line # 1299 */
  Rs.sl[1083]=Rs.sl[1082]+V_varnb;
  Ra.sl[3]=1300; /* line # 1300 */
  if (V_momhde!=NULL) {
    Ra.sl[3]=1302; /* line # 1302 */
    Rs.sl[1084]=Rs.sl[1083]+V_varnb;
    Rs.sl[1085]=Rs.sl[1084]+V_varnb;
    Ra.sl[3]=1303; /* line # 1303 */
    Rs.sl[1086]=Rs.sl[1085]+V_varnb;
    Rs.sl[1087]=Rs.sl[1086]+V_varnb;
    Ra.sl[3]=1304; /* line # 1304 */
    Rs.sl[1088]=Rs.sl[1087]+V_varnb;
    Rs.sl[1089]=Rs.sl[1088]+V_varnb;
    Ra.sl[3]=1305; /* line # 1305 */
    Rs.sl[1090]=Rs.sl[1089]+V_varnb;
    Ra.sl[3]=1306; /* line # 1306 */
    Rs.sl[1091]=(Rs.sl[1090]+V_varnb)-1;
  }
  else {
    Ra.sl[3]=1307; /* line # 1307 */
    Rs.sl[1091]=(Rs.sl[1083]+V_varnb)-1;
  }
  Ra.sl[3]=1308; /* line # 1308 */
  Rs.sl[1092]=Rs.sl[1091];
  Ra.sl[3]=1309; /* line # 1309 */
  if (Rs.ub[4233]) {
    Ra.sl[3]=1311; /* line # 1311 */
    Rs.sl[1093]=Rs.sl[1091]+1;
    Rs.sl[1091]=Rs.sl[1091]+V_varnb;
  }
  Ra.sl[3]=1314; /* line # 1314 */
  if (Rs.sl[1036]>=V_varnb) Rs.sl[1036]=V_varnb/2;
  Ra.sl[3]=1315; /* line # 1315 */
  if (Rs.sl[1091]>126250) P_error(-11);
  else {
    Ra.sl[3]=1316; /* line # 1316 */
    if (V_datahde==NULL) P_error(-12);
    else {
      Ra.sl[3]=1317; /* line # 1317 */
      Rv1=V_datahde;
      Ra.sl[3]=1318; /* line # 1318 */
      if (!P_openr_bdtfile(&V_idat,((V *)Rv1)[4])) P_error(-13);
      else {
        Ra.sl[3]=1319; /* line # 1319 */
        PAS__SELECT_INP(V_idat);
        PAS__READ_BIN(V_cdrec.s);
      }
    }
  }
  Ra.sl[3]=1324; /* line # 1324 */
  Rv2=1;
  for( Rf0=4;Rf0>0;Rf0-- ) {
    Ra.sl[3]=1325; /* line # 1325 */
    if (V_virtvtab.v[Rv2-1]!=NULL) {
      Ra.sl[3]=1326; /* line # 1326 */
      Rv3=V_virtvtab.v[Rv2-1];
      Ra.sl[3]=1327; /* line # 1327 */
      switch (Rv2) {
        case 1:Ra.sl[3]=1328; /* line # 1328 */
        ((SL *)Rv3)[5]= -Rs.sl[1080];
        break;
        case 2:Ra.sl[3]=1329; /* line # 1329 */
        ((SL *)Rv3)[5]= -Rs.sl[1083];
        break;
        case 3:Ra.sl[3]=1330; /* line # 1330 */
        ((SL *)Rv3)[5]= -Rs.sl[1090];
        break;
        case 4:Ra.sl[3]=1331; /* line # 1331 */
        ((SL *)Rv3)[5]= -Rs.sl[1081];
        break;
      }
    }
    Rv2++;
  }
  Ra.sl[3]=1334; /* line # 1334 */
  if (Rs.ub[4208]) {
    Ra.sl[3]=1336; /* line # 1336 */
    Rs.sl[1047]=4;
    Ra.sl[3]=1337; /* line # 1337 */
    while (Rs.v[Rs.sl[1047]+1047]==NULL)
    Rs.sl[1047]=Rs.sl[1047]-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rotatvar "  */
void MXD_LSQ_rotatvar(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+801;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1353; /* line # 1353 */
  Rv0=Rs.sl[1036];
  Ra.sl[3]=1355; /* line # 1355 */
  while (Rv0>0){
    Ra.sl[3]=1356; /* line # 1356 */
    Rv0=Rv0-1;
    V_varhde=((V *)V_varhde)[3];
  }
  Ra.sl[3]=1358; /* line # 1358 */
  Rv1=0;
  Ra.sl[3]=1359; /* line # 1359 */
  Rv2=V_blkhde;
  Rv3=V_varhde;
  Ra.sl[3]=1360; /* line # 1360 */
  while (Rv2!=NULL){
    Ra.sl[3]=1362; /* line # 1362 */
    Rv4=Rv2;
    Ra.sl[3]=1364; /* line # 1364 */
    ((V *)Rv4)[7]=Rv3;
    Rv0=((SL *)Rv4)[4];
    Ra.sl[3]=1365; /* line # 1365 */
    while (Rv0>0){
      Ra.sl[3]=1367; /* line # 1367 */
      Rv1=Rv1+1;
      ((SL *)Rv3)[5]=Rv1;
      Ra.sl[3]=1368; /* line # 1368 */
      Rv0=Rv0-1;
      Rv3=((V *)Rv3)[3];
    }
    Ra.sl[3]=1371; /* line # 1371 */
    Rv2=((V *)Rv2)[1];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " matchangediag "  */
void MXD_LSQ_matchangediag(SL F_n, SL F_ior, F F_mrq){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+811;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1384; /* line # 1384 */
  if (F_mrq>(F)1.000000E-06&&F_mrq<(F)1.000000E+00) {
    Ra.sl[3]=1386; /* line # 1386 */
    Rv0=F_n;
    Ra.sl[3]=1387; /* line # 1387 */
    Rv1=F_ior;
    Ra.sl[3]=1388; /* line # 1388 */
    F_mrq=(F)1.000000E+00/F_mrq;
    Ra.sl[3]=1389; /* line # 1389 */
    for( Rf0=F_n;Rf0>0;Rf0-- ) {
      Ra.sl[3]=1391; /* line # 1391 */
      Rs.f[Rv1+1093]=Rs.f[Rv1+1093]*F_mrq;
      Ra.sl[3]=1392; /* line # 1392 */
      Rv1=Rv1+Rv0;
      Ra.sl[3]=1393; /* line # 1393 */
      Rv0=Rv0-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " matinv "  */
void MXD_LSQ_matinv(SL F_n, SL F_ior, SL F_vor, SL *F_nfail, V F_psing){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  F Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  SL Rv9;
  F Rv10;
  F Rv11;
  SL Rv12;
  SL Rv13;
  register V Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  SL Rv21;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+826;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1408; /* line # 1408 */
  Rv0=0;
  Ra.sl[3]=1410; /* line # 1410 */
  Rv1=F_ior;
  Ra.sl[3]=1411; /* line # 1411 */
  Rv2=1;
  while (1){
    Ra.sl[3]=1414; /* line # 1414 */
    Rv3=Rv2-1;
    Ra.sl[3]=1415; /* line # 1415 */
    Rv4=Rv2;
    while (1){
      Ra.sl[3]=1418; /* line # 1418 */
      Rv5=(F)0.000000E-01;
      Ra.sl[3]=1419; /* line # 1419 */
      Rv6=(Rv4+F_ior)-1;
      Ra.sl[3]=1420; /* line # 1420 */
      Rv7=(Rv2+F_ior)-1;
      Ra.sl[3]=1421; /* line # 1421 */
      if (Rv3>0) {
        Ra.sl[3]=1423; /* line # 1423 */
        Rv8=1;
        for( Rf2=Rv3;Rf2>0;Rf2-- ) {
          Ra.sl[3]=1425; /* line # 1425 */
          Rv5=Rv5+Rs.f[Rv6+1093]*Rs.f[Rv7+1093];
          Ra.sl[3]=1426; /* line # 1426 */
          Rv9=F_n-Rv8;
          Ra.sl[3]=1427; /* line # 1427 */
          Rv6=Rv6+Rv9;
          Ra.sl[3]=1428; /* line # 1428 */
          Rv7=Rv7+Rv9;
          Rv8++;
        }
      }
      Ra.sl[3]=1431; /* line # 1431 */
      Rv10=Rs.f[Rv1+1093]-Rv5;
      Ra.sl[3]=1432; /* line # 1432 */
      if (Rv4<=Rv2) {
        Ra.sl[3]=1435; /* line # 1435 */
        if (Rv10>Rs.f[1057]) {
          Ra.sl[3]=1437; /* line # 1437 */
          Rv11=sqrt(Rv10);
          Ra.sl[3]=1438; /* line # 1438 */
          Rs.f[Rv1+1093]=Rv11;
        }
        else {
          Ra.sl[3]=1442; /* line # 1442 */
          Rv11=(F)1.000000E+00;
          Rs.f[Rv1+1093]=Rv11;
          Ra.sl[3]=1444; /* line # 1444 */
          Rv12=Rv1+1;
          for( Rf2=(((Rv1+F_n)-Rv2)+1)-(Rv1+1);Rf2>0;Rf2-- ) {
            Rs.f[Rv12+1093]=(F)0.000000E-01;
            Rv12++;
          }
          Ra.sl[3]=1445; /* line # 1445 */
          Rv7=(Rv2+F_ior)-1;
          Ra.sl[3]=1446; /* line # 1446 */
          Rv13=1;
          for( Rf2=Rv3;Rf2>0;Rf2-- ) {
            Ra.sl[3]=1448; /* line # 1448 */
            Rs.f[Rv7+1093]=(F)0.000000E-01;
            Rv7=(Rv7+F_n)-Rv13;
            Rv13++;
          }
          Ra.sl[3]=1450; /* line # 1450 */
          Rs.f[((F_vor+Rv2)-1)+1093]=(F)0.000000E-01;
          Ra.sl[3]=1452; /* line # 1452 */
          P_newlinelst();
          Ra.sl[3]=1453; /* line # 1453 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+834,-1,-1,32);
          Ra.sl[3]=1454; /* line # 1454 */
          Rv14=((V *)F_psing)[2];
          Ra.sl[3]=1455; /* line # 1455 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_CHT(Rv14+1,16,(SL)((C *)Rv14)[0],-1,32);
          PAS__WRITE_CHAR(34);
          Ra.sl[3]=1456; /* line # 1456 */
          if (Rs.ub[4224]) {
            Ra.sl[3]=1458; /* line # 1458 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+878,-1,-1,32);
            PAS__WRITE_EOLN();
            Ra.sl[3]=1459; /* line # 1459 */
            (*F_nfail)=(*F_nfail)+1;
          }
          else {
            Ra.sl[3]=1463; /* line # 1463 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+906,-1,-1,32);
            PAS__WRITE_EOLN();
            Ra.sl[3]=1464; /* line # 1464 */
            Rv0=1;
          }
          Ra.sl[3]=1466; /* line # 1466 */
          P_skipline(1);
        }
      }
      else {
        Ra.sl[3]=1470; /* line # 1470 */
        Rs.f[Rv1+1093]=Rv10/Rv11;
      }
      Ra.sl[3]=1471; /* line # 1471 */
      Rv1=Rv1+1;
      Ra.sl[3]=1472; /* line # 1472 */
      Rv4=Rv4+1;
      if (Rv4>F_n||Rv0)  break;
    }
    Ra.sl[3]=1475; /* line # 1475 */
    Rv2=Rv2+1;
    F_psing=((V *)F_psing)[3];
    if (Rv2>F_n||Rv0)  break;
  }
  Ra.sl[3]=1478; /* line # 1478 */
  if (Rv0) (*F_nfail)=Rv2-1;
  else {
    Ra.sl[3]=1480; /* line # 1480 */
    Rs.f[F_ior+1093]=(F)1.000000E+00/Rs.f[F_ior+1093];
    Ra.sl[3]=1481; /* line # 1481 */
    Rv15=F_ior;
    Ra.sl[3]=1483; /* line # 1483 */
    Rv16=2;
    for( Rf2=F_n-1;Rf2>0;Rf2-- ) {
      Ra.sl[3]=1485; /* line # 1485 */
      Rv15=((Rv15+F_n)-Rv16)+2;
      Ra.sl[3]=1487; /* line # 1487 */
      Rv10=(F)1.000000E+00/Rs.f[Rv15+1093];
      Ra.sl[3]=1488; /* line # 1488 */
      Rs.f[Rv15+1093]=Rv10;
      Ra.sl[3]=1489; /* line # 1489 */
      Rv7=F_ior-1;
      Ra.sl[3]=1490; /* line # 1490 */
      Rv6=(Rv16+F_ior)-1;
      Ra.sl[3]=1491; /* line # 1491 */
      Rv3=Rv16-1;
      Ra.sl[3]=1493; /* line # 1493 */
      Rv17=1;
      for( Rf1=Rv3;Rf1>0;Rf1-- ) {
        Ra.sl[3]=1495; /* line # 1495 */
        Rv1=Rv6;
        Ra.sl[3]=1497; /* line # 1497 */
        Rv5=(F)0.000000E-01;
        Ra.sl[3]=1498; /* line # 1498 */
        Rv18=Rv17;
        for( Rf0=(Rv3+1)-Rv17;Rf0>0;Rf0-- ) {
          Ra.sl[3]=1500; /* line # 1500 */
          Rv19=Rv7+Rv18;
          Ra.sl[3]=1501; /* line # 1501 */
          Rv5=Rv5-Rs.f[Rv6+1093]*Rs.f[Rv19+1093];
          Ra.sl[3]=1502; /* line # 1502 */
          Rv6=(Rv6+F_n)-Rv18;
          Rv18++;
        }
        Ra.sl[3]=1505; /* line # 1505 */
        Rs.f[Rv1+1093]=Rv5*Rv10;
        Ra.sl[3]=1506; /* line # 1506 */
        Rv9=F_n-Rv17;
        Ra.sl[3]=1507; /* line # 1507 */
        Rv6=Rv1+Rv9;
        Ra.sl[3]=1508; /* line # 1508 */
        Rv7=Rv7+Rv9;
        Rv17++;
      }
      Rv16++;
    }
    Ra.sl[3]=1512; /* line # 1512 */
    Rv1=F_ior;
    Ra.sl[3]=1513; /* line # 1513 */
    Rv20=1;
    for( Rf2=F_n;Rf2>0;Rf2-- ) {
      Ra.sl[3]=1515; /* line # 1515 */
      Rv6=Rv1;
      Ra.sl[3]=1516; /* line # 1516 */
      Rv21=Rv20;
      for( Rf1=(F_n+1)-Rv20;Rf1>0;Rf1-- ) {
        Ra.sl[3]=1518; /* line # 1518 */
        Rv7=Rv1;
        Ra.sl[3]=1519; /* line # 1519 */
        Rv3=(F_n-Rv21)+1;
        Ra.sl[3]=1520; /* line # 1520 */
        Rv5=(F)0.000000E-01;
        Ra.sl[3]=1521; /* line # 1521 */
        for( Rf0=Rv3;Rf0>0;Rf0-- ) {
          Ra.sl[3]=1523; /* line # 1523 */
          Rv5=Rv5+Rs.f[Rv6+1093]*Rs.f[Rv7+1093];
          Ra.sl[3]=1524; /* line # 1524 */
          Rv6=Rv6+1;
          Ra.sl[3]=1525; /* line # 1525 */
          Rv7=Rv7+1;
        }
        Ra.sl[3]=1527; /* line # 1527 */
        Rs.f[Rv1+1093]=Rv5;
        Ra.sl[3]=1528; /* line # 1528 */
        Rv1=Rv1+1;
        Rv21++;
      }
      Rv20++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " resolv "  */
void MXD_LSQ_resolv(SL F_n, SL F_ior, SL F_vor, SL F_pdor, SL F_dior){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+927;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1545; /* line # 1545 */
  Rv0=1;
  for( Rf1=F_n;Rf1>0;Rf1-- ) {
    Ra.sl[3]=1547; /* line # 1547 */
    Rv1=(F)0.000000E-01;
    Ra.sl[3]=1548; /* line # 1548 */
    Rv2=(Rv0+F_ior)-1;
    Ra.sl[3]=1549; /* line # 1549 */
    Rv3=F_n-1;
    Ra.sl[3]=1550; /* line # 1550 */
    Rv4=1;
    for( Rf0=F_n;Rf0>0;Rf0-- ) {
      Ra.sl[3]=1552; /* line # 1552 */
      Rv1=Rv1+Rs.f[Rv2+1093]*Rs.f[((Rv4+F_vor)-1)+1093];
      Ra.sl[3]=1553; /* line # 1553 */
      if (Rv4<Rv0) {
        Ra.sl[3]=1555; /* line # 1555 */
        Rv2=Rv2+Rv3;
        Ra.sl[3]=1556; /* line # 1556 */
        Rv3=Rv3-1;
      }
      else {
        Ra.sl[3]=1559; /* line # 1559 */
        if (Rv0==Rv4) Rs.f[((Rv4+F_dior)-1)+1093]=Rs.f[Rv2+1093];
        Ra.sl[3]=1560; /* line # 1560 */
        Rv2=Rv2+1;
      }
      Rv4++;
    }
    Ra.sl[3]=1563; /* line # 1563 */
    Rs.f[((Rv0+F_pdor)-1)+1093]=Rv1;
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outmatrix "  */
void MXD_LSQ_outmatrix(SL F_morg, SL F_mdim, V F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register V Rv4;
  SL Rv5;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+935;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1577; /* line # 1577 */
  if (!V_bshortlst&&F_mdim>1) {
    Ra.sl[3]=1579; /* line # 1579 */
    P_newparagraphe(30);
    Ra.sl[3]=1580; /* line # 1580 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+946,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1581; /* line # 1581 */
    P_underline(0,28);
    Ra.sl[3]=1582; /* line # 1582 */
    P_skipline(2);
    Ra.sl[3]=1583; /* line # 1583 */
    Rv0=1;
    for( Rf1=F_mdim;Rf1>0;Rf1-- ) {
      Ra.sl[3]=1585; /* line # 1585 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+977,-1,-1,32);
      Ra.sl[3]=1586; /* line # 1586 */
      Rv1=(F_morg+Rv0)-1;
      Rv2=F_mdim-1;
      Ra.sl[3]=1587; /* line # 1587 */
      Rv3=1;
      for( Rf0=Rv0;Rf0>0;Rf0-- ) {
        Ra.sl[3]=1589; /* line # 1589 */
        if (Rv0==Rv3) {
          Ra.sl[3]=1590; /* line # 1590 */
          Rv4=((V *)F_pv)[2];
          Ra.sl[3]=1592; /* line # 1592 */
          Rv5=(SL)((C *)Rv4)[0];
          Ra.sl[3]=1593; /* line # 1593 */
          if (Rv5<8) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_FCHAR(32,(8-Rv5)/2+1,-1,1,32);
            PAS__WRITE_CHT(Rv4+1,16, Rv5,-1,32);
          }
          else {
            Ra.sl[3]=1594; /* line # 1594 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_CHT(Rv4+1,16, Rv5,-1,32);
          }
        }
        else {
          Ra.sl[3]=1597; /* line # 1597 */
          if (fabs(Rs.f[Rv1+1093])<(F)1.000000E+01) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_SNGL(Rs.f[Rv1+1093],8,5,0);
          }
          else {
            Ra.sl[3]=1598; /* line # 1598 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_SNGL(Rs.f[Rv1+1093],8,-6,0);
          }
        }
        Ra.sl[3]=1599; /* line # 1599 */
        if ((Rv3&15)==0) {
          Ra.sl[3]=1600; /* line # 1600 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_EOLN();
          P_newlinelst();
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_FCHAR(32,2,-1,1,32);
        }
        Ra.sl[3]=1601; /* line # 1601 */
        Rv1=Rv1+Rv2;
        Rv2=Rv2-1;
        Rv3++;
      }
      Ra.sl[3]=1603; /* line # 1603 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1604; /* line # 1604 */
      P_skipline(1);
      Ra.sl[3]=1605; /* line # 1605 */
      F_pv=((V *)F_pv)[3];
      Rv0++;
    }
  }
  Ra.sl[3]=1608; /* line # 1608 */
  P_skipline(4);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outresidu "  */
void MXD_LSQ_outresidu(V *F_f, UB F_flg, F *F_wre, F *F_wcre, F *F_uwre, F *F_uwcre
, F *F_chi2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+981;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1621; /* line # 1621 */
  if (!V_bshortlst&&F_flg) P_skipline(2);
  Ra.sl[3]=1622; /* line # 1622 */
  if (F_flg) P_newlinelst();
  Ra.sl[3]=1623; /* line # 1623 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+992,-1,-1,32);
  Ra.sl[3]=1624; /* line # 1624 */
  if ((*F_wre)<(F)0.000000E-01) {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+1041,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=1625; /* line # 1625 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_SNGL((*F_wre),14,4,0);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1626; /* line # 1626 */
  if (!V_bshortlst&&F_flg) P_skipline(1);
  Ra.sl[3]=1627; /* line # 1627 */
  if (F_flg) P_newlinelst();
  Ra.sl[3]=1628; /* line # 1628 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+1057,-1,-1,32);
  Ra.sl[3]=1629; /* line # 1629 */
  if ((*F_wcre)<(F)0.000000E-01) {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+1041,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=1630; /* line # 1630 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_SNGL((*F_wcre),14,4,0);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1631; /* line # 1631 */
  if (!V_bshortlst) P_skipline(1);
  Ra.sl[3]=1632; /* line # 1632 */
  if (F_flg) P_newlinelst();
  Ra.sl[3]=1633; /* line # 1633 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+1106,-1,-1,32);
  Ra.sl[3]=1634; /* line # 1634 */
  if ((*F_uwre)<(F)0.000000E-01) {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+1041,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=1635; /* line # 1635 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_SNGL((*F_uwre),14,4,0);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1636; /* line # 1636 */
  if (!V_bshortlst&&F_flg) P_skipline(1);
  Ra.sl[3]=1637; /* line # 1637 */
  if (F_flg) P_newlinelst();
  Ra.sl[3]=1638; /* line # 1638 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+1155,-1,-1,32);
  Ra.sl[3]=1639; /* line # 1639 */
  if ((*F_uwcre)<(F)0.000000E-01) {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+1041,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=1640; /* line # 1640 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_SNGL((*F_uwcre),14,4,0);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1641; /* line # 1641 */
  if (!V_bshortlst&&F_flg) P_skipline(1);
  Ra.sl[3]=1642; /* line # 1642 */
  if (F_flg) P_newlinelst();
  Ra.sl[3]=1643; /* line # 1643 */
  if ((*F_chi2)>=(F)0.000000E-01) {
    Ra.sl[3]=1644; /* line # 1644 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+1204,-1,-1,32);
    PAS__WRITE_SNGL((*F_chi2),14,5,0);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outparam "  */
void MXD_LSQ_outparam(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  V Rv6;
  F Rv7;
  V Rv8;
  SL Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  register V Rv14;
  F Rv15;
  V Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  SL Rv21;
  register V Rv22;
  register int Rgi;
  register int Rgj;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1253;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1662; /* line # 1662 */
  Rv0=V_parhde;
  Ra.sl[3]=1663; /* line # 1663 */
  Rv1=0;
  Ra.sl[3]=1664; /* line # 1664 */
  while (Rv0!=NULL){
    Ra.sl[3]=1666; /* line # 1666 */
    Rv2=Rv0;
    Ra.sl[3]=1667; /* line # 1667 */
    if (((C *)((V *)Rv2)[2])[1]!=46&&((C *)((V *)Rv2)[2])[1]!=35) {
      Ra.sl[3]=1669; /* line # 1669 */
      if (Rv1==0) {
        Ra.sl[3]=1671; /* line # 1671 */
        if (!V_bshortlst) P_newparagraphe(10);
        else {
          Ra.sl[3]=1672; /* line # 1672 */
          P_newparagraphe(5);
        }
        Ra.sl[3]=1673; /* line # 1673 */
        P_newlinelst();
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+1263,-1,-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[3]=1674; /* line # 1674 */
        P_underline(0,24);
        Ra.sl[3]=1675; /* line # 1675 */
        if (!V_bshortlst) P_skipline(2);
        Ra.sl[3]=1676; /* line # 1676 */
        P_newlinelst();
        Ra.sl[3]=1677; /* line # 1677 */
        if (V_b132) Rv3=3;
        else Rv3=2;
        Ra.sl[3]=1678; /* line # 1678 */
        ((C *)V_sbttlpt)[136]=0;
        Ra.sl[3]=1679; /* line # 1679 */
        Rv4=1;
        for( Rf0=Rv3;Rf0>0;Rf0-- ) {
          Ra.sl[3]=1681; /* line # 1681 */
          P_st_put_pastr(V_sbttlpt,Rd.s+1290);
          Ra.sl[3]=1682; /* line # 1682 */
          if (Rv4<Rv3) P_st_put_pastr(V_sbttlpt,Rd.s+1328);
          Rv4++;
        }
        Ra.sl[3]=1684; /* line # 1684 */
        Rv5=V_sbttlpt;
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHT(Rv5+4,132,(SL)((C *)Rv5)[136],-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[3]=1685; /* line # 1685 */
        P_skipline(1);
        Ra.sl[3]=1686; /* line # 1686 */
        Rv1=0;
      }
      Ra.sl[3]=1688; /* line # 1688 */
      if (PAS__I_MOD(Rv1,Rv3)==1) P_newlinelst();
      Ra.sl[3]=1689; /* line # 1689 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      MXD_LSQ_outnameid(((V *)Rv2)[2],16);
      Ra.sl[3]=1690; /* line # 1690 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(((F *)Rv2)[6],9,5,0);
      Ra.sl[3]=1691; /* line # 1691 */
      Rv6=((V *)Rv2)[5];
      Ra.sl[3]=1693; /* line # 1693 */
      MXD_LSQ_skipvirtual(&Rv6);
      Ra.sl[3]=1694; /* line # 1694 */
      Rv7=(F)0.000000E-01;
      Ra.sl[3]=1695; /* line # 1695 */
      while (Rv6!=NULL){
        Ra.sl[3]=1697; /* line # 1697 */
        Rv8=V_blkhde;
        Rv9=1;
        Rv10=1;
        Rv11=((SL *)Rv8)[4];
        Rv12=Rv11;
        Ra.sl[3]=1698; /* line # 1698 */
        Rv13=((SL *)((V *)Rv6)[1])[5];
        Ra.sl[3]=1699; /* line # 1699 */
        while (Rv13>Rv12){
          Ra.sl[3]=1701; /* line # 1701 */
          Rv9=Rv9+(Rv11*Rv11+Rv11)/2;
          Ra.sl[3]=1702; /* line # 1702 */
          Rv10=Rv10+Rv11;
          Rv8=((V *)Rv8)[1];
          Rv11=((SL *)Rv8)[4];
          Ra.sl[3]=1703; /* line # 1703 */
          Rv12=(Rv10+Rv11)-1;
        }
        Ra.sl[3]=1705; /* line # 1705 */
        Rv14=Rv6;
        Ra.sl[3]=1706; /* line # 1706 */
        Rv15=((F *)((V *)Rv14)[1])[8]*((F *)Rv14)[2];
        Ra.sl[3]=1707; /* line # 1707 */
        Rv7=Rv7+Rv15*Rv15;
        Ra.sl[3]=1708; /* line # 1708 */
        Rv16=((V *)Rv6)[0];
        Ra.sl[3]=1709; /* line # 1709 */
        while (Rv16!=NULL){
          Ra.sl[3]=1711; /* line # 1711 */
          Rv17=((SL *)((V *)Rv16)[1])[5];
          Ra.sl[3]=1712; /* line # 1712 */
          if (Rv17>=Rv10&&Rv17<=Rv12) {
            Ra.sl[3]=1714; /* line # 1714 */
            Rv18=(Rv13-Rv10)+1;
            Rv19=(Rv17-Rv10)+1;
            Rv20=Rv9;
            Ra.sl[3]=1715; /* line # 1715 */
            if (Rv18>Rv19) {
              Ra.sl[3]=1717; /* line # 1717 */
              Rv21=Rv18;
              Rv18=Rv19;
              Rv19=Rv21;
            }
            Ra.sl[3]=1719; /* line # 1719 */
            Rv21=Rv11;
            Ra.sl[3]=1720; /* line # 1720 */
            while (Rv18>1){
              Ra.sl[3]=1722; /* line # 1722 */
              Rv20=Rv20+Rv21;
              Rv21=Rv21-1;
              Ra.sl[3]=1723; /* line # 1723 */
              Rv18=Rv18-1;
              Rv19=Rv19-1;
            }
            Ra.sl[3]=1725; /* line # 1725 */
            Rv22=Rv16;
            Ra.sl[3]=1726; /* line # 1726 */
            Rv7=Rv7+((((F)2.000000E+00*Rs.f[((Rv20+Rv19)-1)+1093])*Rv15)*((F *)(
            (V *)Rv22)[1])[8])*((F *)Rv22)[2];
          }
          Ra.sl[3]=1728; /* line # 1728 */
          Rv16=((V *)Rv16)[0];
        }
        Ra.sl[3]=1730; /* line # 1730 */
        Rv6=((V *)Rv6)[0];
      }
      Ra.sl[3]=1732; /* line # 1732 */
      Rv7=sqrt(fabs(Rv7));
      Ra.sl[3]=1733; /* line # 1733 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(Rv7,9,5,0);
      Ra.sl[3]=1734; /* line # 1734 */
      Rv1=Rv1+1;
      Ra.sl[3]=1735; /* line # 1735 */
      if (PAS__I_MOD(Rv1,Rv3)==0) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[3]=1736; /* line # 1736 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,4,-1,1,32);
      }
    }
    Ra.sl[3]=1738; /* line # 1738 */
    Rv0=((V *)Rv0)[1];
  }
  Ra.sl[3]=1740; /* line # 1740 */
  if (PAS__I_MOD(Rv1,3)!=0) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1741; /* line # 1741 */
  ((C *)V_sbttlpt)[136]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outvnm "  */
void MXD_LSQ_outvnm(C F_ic, V F_p, V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_st,3);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1335;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1754; /* line # 1754 */
  if (F_p==NULL) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(F_ic,15,-1,1,32);
  }
  else {
    Ra.sl[3]=1756; /* line # 1756 */
    Rv0=F_p;
    Rv1=((V *)Rv0)[2];
    Ra.sl[3]=1758; /* line # 1758 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(F_ic);
    Ra.sl[3]=1759; /* line # 1759 */
    Rv2=(SL)((C *)Rv1)[0];
    Ra.sl[3]=1760; /* line # 1760 */
    if (((C *)Rv1)[1]==46) {
      Ra.sl[3]=1761; /* line # 1761 */
      Rv3=2;
      for( Rf0=Rv2-1;Rf0>0;Rf0-- ) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(((C *)Rv1)[Rv3]);
        Rv3++;
      }
    }
    else {
      Ra.sl[3]=1762; /* line # 1762 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHT(Rv1+1,16, Rv2,-1,32);
    }
    Ra.sl[3]=1763; /* line # 1763 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(61);
    PAS__WRITE_SNGL(((F *)Rv0)[6],7,4,0);
    PAS__WRITE_CHT(Ra.s+16,3,3,-1,32);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outstructure "  */
void MXD_LSQ_outstructure(){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  SL Rv9;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1343;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1779; /* line # 1779 */
  Rv0=V_atomhde;
  Ra.sl[3]=1780; /* line # 1780 */
  P_newparagraphe(15);
  Ra.sl[3]=1781; /* line # 1781 */
  P_newlinelst();
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+1357,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=1782; /* line # 1782 */
  P_underline(0,23);
  Ra.sl[3]=1783; /* line # 1783 */
  P_skipline(2);
  Ra.sl[3]=1784; /* line # 1784 */
  Rv1=1;
  Ra.sl[3]=1785; /* line # 1785 */
  while (Rv0!=NULL){
    Ra.sl[3]=1787; /* line # 1787 */
    if (Rv1) {
      Ra.sl[3]=1789; /* line # 1789 */
      P_newlinelst();
      Ra.sl[3]=1790; /* line # 1790 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+1383,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1791; /* line # 1791 */
      Rv1=0;
    }
    Ra.sl[3]=1793; /* line # 1793 */
    Rv2=Rv0;
    Ra.sl[3]=1795; /* line # 1795 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(32,2,-1,1,32);
    Ra.sl[3]=1796; /* line # 1796 */
    MXD_LSQ_outnameid(((V *)Rv2)[2],16);
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(58);
    Ra.sl[3]=1797; /* line # 1797 */
    if (((UB *)Rv2)[76]) PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+1395,3);
    else PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+1400,3);
    Ra.sl[3]=1798; /* line # 1798 */
    MXD_LSQ_outvnm(32,((V *)Rv2)[9],Rd.s+1405);
    Ra.sl[3]=1799; /* line # 1799 */
    Rv3=4;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      MXD_LSQ_outvnm(44,((V *)Rv2)[Rv3+6],Ra.s+16);
      Rv3++;
    }
    Ra.sl[3]=1800; /* line # 1800 */
    if (((UB *)Rv2)[77]) {
      Ra.sl[3]=1802; /* line # 1802 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
      P_newlinelst();
      Ra.sl[3]=1803; /* line # 1803 */
      MXD_LSQ_outvnm(32,((V *)Rv2)[13],Rd.s+1410);
      Ra.sl[3]=1804; /* line # 1804 */
      Rv4=8;
      for( Rf0=5;Rf0>0;Rf0-- ) {
        MXD_LSQ_outvnm(44,((V *)Rv2)[Rv4+6],Rd.s+1415);
        Rv4++;
      }
      Ra.sl[3]=1805; /* line # 1805 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=1809; /* line # 1809 */
      if (((V *)Rv2)[13]!=NULL) {
        Ra.sl[3]=1810; /* line # 1810 */
        if (V_buiso) {
          Ra.sl[3]=1811; /* line # 1811 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+1418,-1,-1,32);
          PAS__WRITE_SNGL(((F *)((V *)Rv2)[13])[6],7,4,0);
          PAS__WRITE_STR(Rd.s+1427,-1,-1,32);
        }
        else {
          Ra.sl[3]=1813; /* line # 1813 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+1432,-1,-1,32);
          PAS__WRITE_SNGL(((F *)((V *)Rv2)[13])[6],7,4,0);
        }
      }
      Ra.sl[3]=1814; /* line # 1814 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=1816; /* line # 1816 */
    if (((V *)Rv2)[4]!=NULL) {
      Ra.sl[3]=1818; /* line # 1818 */
      Rv5=((V *)Rv2)[4];
      Ra.sl[3]=1819; /* line # 1819 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      PAS__WRITE_STR(Rd.s+1441,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1820; /* line # 1820 */
      Rv1=1;
      Ra.sl[3]=1821; /* line # 1821 */
      while (Rv5!=NULL){
        Ra.sl[3]=1823; /* line # 1823 */
        Rv6=Rv5;
        Ra.sl[3]=1825; /* line # 1825 */
        P_newlinelst();
        Ra.sl[3]=1826; /* line # 1826 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        MXD_LSQ_outnameid(((V *)Rv6)[2],16);
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(58);
        Ra.sl[3]=1827; /* line # 1827 */
        MXD_LSQ_outvnm(32,((V *)Rv6)[7],Rd.s+1463);
        Ra.sl[3]=1828; /* line # 1828 */
        Rv7=3;
        for( Rf0=5;Rf0>0;Rf0-- ) {
          MXD_LSQ_outvnm(44,((V *)Rv6)[Rv7+5],Rd.s+1468);
          Rv7++;
        }
        Ra.sl[3]=1829; /* line # 1829 */
        if (((V *)Rv6)[4]!=NULL) {
          Ra.sl[3]=1831; /* line # 1831 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+1471,-1,-1,32);
          MXD_LSQ_outnameid(((V *)((V *)Rv6)[4])[2],16);
          Ra.sl[3]=1832; /* line # 1832 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_CHAR(34);
          PAS__WRITE_EOLN();
        }
        else {
          Ra.sl[3]=1834; /* line # 1834 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_EOLN();
        }
        Ra.sl[3]=1836; /* line # 1836 */
        Rv5=((V *)Rv5)[5];
      }
    }
    Ra.sl[3]=1839; /* line # 1839 */
    if (((V *)Rv2)[5]!=NULL) {
      Ra.sl[3]=1841; /* line # 1841 */
      Rv5=((V *)Rv2)[5];
      Ra.sl[3]=1842; /* line # 1842 */
      Rv1=1;
      Ra.sl[3]=1843; /* line # 1843 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      PAS__WRITE_STR(Rd.s+1482,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1844; /* line # 1844 */
      while (Rv5!=NULL){
        Ra.sl[3]=1846; /* line # 1846 */
        Rv8=Rv5;
        Ra.sl[3]=1848; /* line # 1848 */
        P_newlinelst();
        Ra.sl[3]=1849; /* line # 1849 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        PAS__WRITE_EOLN();
        MXD_LSQ_outnameid(((V *)Rv8)[2],16);
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(58);
        PAS__WRITE_EOLN();
        Ra.sl[3]=1850; /* line # 1850 */
        MXD_LSQ_outvnm(32,((V *)Rv8)[6],Rd.s+1511);
        Ra.sl[3]=1851; /* line # 1851 */
        MXD_LSQ_outvnm(44,((V *)Rv8)[7],Rd.s+1516);
        Ra.sl[3]=1852; /* line # 1852 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+1519,-1,-1,32);
        MXD_LSQ_outnameid(((V *)((V *)Rv8)[4])[2],16);
        Ra.sl[3]=1853; /* line # 1853 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(34);
        PAS__WRITE_EOLN();
        Ra.sl[3]=1854; /* line # 1854 */
        if ((((V *)Rv8)[8]!=NULL||((V *)Rv8)[9]!=NULL)||((V *)Rv8)[11]!=NULL) {
          Ra.sl[3]=1856; /* line # 1856 */
          P_newlinelst();
          Ra.sl[3]=1857; /* line # 1857 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_FCHAR(32,14,-1,1,32);
          Ra.sl[3]=1858; /* line # 1858 */
          Rv9=3;
          for( Rf0=6;Rf0>0;Rf0-- ) {
            MXD_LSQ_outvnm(44,((V *)Rv8)[Rv9+5],Rd.s+1530);
            Rv9++;
          }
          Ra.sl[3]=1859; /* line # 1859 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_EOLN();
        }
        Ra.sl[3]=1862; /* line # 1862 */
        Rv5=((V *)Rv5)[5];
      }
    }
    Ra.sl[3]=1866; /* line # 1866 */
    P_skipline(2);
    Ra.sl[3]=1867; /* line # 1867 */
    Rv0=((V *)Rv0)[1];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " datalst "  */
void MXD_LSQ_datalst(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  UB Rv2;
  UB Rv3;
  UB Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1533;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1880; /* line # 1880 */
  if (V_datahde!=NULL) {
    Ra.sl[3]=1882; /* line # 1882 */
    P_newparagraphe(10);
    Ra.sl[3]=1883; /* line # 1883 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+1542,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1884; /* line # 1884 */
    P_underline(0,26);
    P_skipline(1);
    Ra.sl[3]=1885; /* line # 1885 */
    Rv0=V_datahde;
    Ra.sl[3]=1886; /* line # 1886 */
    while (Rv0!=NULL){
      Ra.sl[3]=1888; /* line # 1888 */
      Rv1=Rv0;
      Ra.sl[3]=1890; /* line # 1890 */
      P_newlinelst();
      Ra.sl[3]=1891; /* line # 1891 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      Ra.sl[3]=1892; /* line # 1892 */
      MXD_LSQ_outnameid(((V *)Rv1)[2],16);
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+1572,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv1)[11],7,0);
      PAS__WRITE_CHAR(47);
      PAS__WRITE_INT(((SL *)Rv1)[10],7,0);
      Ra.sl[3]=1893; /* line # 1893 */
      switch (((SL *)Rv1)[9]) {
        case 0:Ra.sl[3]=1894; /* line # 1894 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+1580,-1,-1,32);
        break;
        case 1:Ra.sl[3]=1895; /* line # 1895 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+1586,-1,-1,32);
        break;
        case 2:Ra.sl[3]=1896; /* line # 1896 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+1592,-1,-1,32);
        break;
      }
      Ra.sl[3]=1898; /* line # 1898 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+1598,-1,-1,32);
      PAS__WRITE_SNGL(((F *)((V *)Rv1)[8])[6],12,4,0);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1899; /* line # 1899 */
      Rv2=((V *)Rv1)[6]!=NULL;
      Ra.sl[3]=1900; /* line # 1900 */
      Rv3=((V *)Rv1)[7]!=NULL;
      Ra.sl[3]=1901; /* line # 1901 */
      Rv4=((V *)Rv1)[5]!=NULL;
      Ra.sl[3]=1902; /* line # 1902 */
      if ((Rv2||Rv3)||Rv4) {
        Ra.sl[3]=1904; /* line # 1904 */
        P_newlinelst();
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,8,-1,1,32);
        Ra.sl[3]=1905; /* line # 1905 */
        if (Rv2||Rv3) {
          Ra.sl[3]=1907; /* line # 1907 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+1630,-1,-1,32);
          Ra.sl[3]=1908; /* line # 1908 */
          if (!(Rv2&&Rv3)) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+1653,-1,-1,32);
          }
          else {
            Ra.sl[3]=1909; /* line # 1909 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+1658,-1,-1,32);
          }
          Ra.sl[3]=1910; /* line # 1910 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+1665,-1,-1,32);
          Ra.sl[3]=1911; /* line # 1911 */
          if (Rv2) {
            Ra.sl[3]=1913; /* line # 1913 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+1679,-1,-1,32);
            Ra.sl[3]=1914; /* line # 1914 */
            if (Rv3) {
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+1686,-1,-1,32);
            }
          }
          Ra.sl[3]=1916; /* line # 1916 */
          if (Rv3) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+1692,-1,-1,32);
          }
        }
        Ra.sl[3]=1918; /* line # 1918 */
        if (Rv4) {
          Ra.sl[3]=1920; /* line # 1920 */
          if (Rv2||Rv3) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+1699,-1,-1,32);
          }
          Ra.sl[3]=1921; /* line # 1921 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+1703,-1,-1,32);
        }
        Ra.sl[3]=1923; /* line # 1923 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(46);
        PAS__WRITE_EOLN();
      }
      Ra.sl[3]=1926; /* line # 1926 */
      Rv0=((V *)Rv0)[1];
    }
  }
  Ra.sl[3]=1929; /* line # 1929 */
  P_skipline(2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wavelst "  */
void MXD_LSQ_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1730;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1943; /* line # 1943 */
  if (V_wavhde!=NULL) {
    Ra.sl[3]=1945; /* line # 1945 */
    P_newparagraphe(8);
    Ra.sl[3]=1946; /* line # 1946 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+1739,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1947; /* line # 1947 */
    P_underline(0,22);
    Ra.sl[3]=1948; /* line # 1948 */
    P_skipline(1);
    Ra.sl[3]=1949; /* line # 1949 */
    Lx[1].v[0]=V_wavhde;
    Ra.sl[3]=1950; /* line # 1950 */
    while (Lx[1].v[0]!=NULL){
      Ra.sl[3]=1952; /* line # 1952 */
      Rv0=Lx[1].v[0];
      Ra.sl[3]=1954; /* line # 1954 */
      P_newlinelst();
      Ra.sl[3]=1955; /* line # 1955 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_FCHAR(32,4,-1,1,32);
      MXD_LSQ_outnameid(((V *)Rv0)[2],16);
      Ra.sl[3]=1956; /* line # 1956 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(61);
      PAS__WRITE_SNGL(((F *)Rv0)[4],8,4,0);
      PAS__WRITE_SNGL(((F *)Rv0)[5],8,4,0);
      PAS__WRITE_SNGL(((F *)Rv0)[6],8,4,0);
      Ra.sl[3]=1957; /* line # 1957 */
      if (((UB *)Rv0)[40]) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+1764,-1,-1,32);
      }
      Ra.sl[3]=1958; /* line # 1958 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1960; /* line # 1960 */
      Lx[1].v[0]=((V *)Lx[1].v[0])[1];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pollst "  */
void MXD_LSQ_PRC_00000002(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1775;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1968; /* line # 1968 */
  if (V_polhde!=NULL) {
    Ra.sl[3]=1970; /* line # 1970 */
    P_newparagraphe(8);
    Ra.sl[3]=1971; /* line # 1971 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+1783,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1972; /* line # 1972 */
    P_underline(0,33);
    Ra.sl[3]=1973; /* line # 1973 */
    P_skipline(1);
    Ra.sl[3]=1974; /* line # 1974 */
    Lx[1].v[0]=V_polhde;
    Ra.sl[3]=1975; /* line # 1975 */
    while (Lx[1].v[0]!=NULL){
      Ra.sl[3]=1977; /* line # 1977 */
      Rv0=Lx[1].v[0];
      Ra.sl[3]=1979; /* line # 1979 */
      P_newlinelst();
      Ra.sl[3]=1980; /* line # 1980 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_FCHAR(32,4,-1,1,32);
      MXD_LSQ_outnameid(((V *)Rv0)[2],16);
      Ra.sl[3]=1981; /* line # 1981 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(61);
      PAS__WRITE_SNGL(MXD_LSQ_value(((V *)Rv0)[4]),8,4,0);
      PAS__WRITE_CHAR(44);
      PAS__WRITE_SNGL(MXD_LSQ_value(((V *)Rv0)[5]),8,4,0);
      PAS__WRITE_CHAR(44);
      PAS__WRITE_SNGL(MXD_LSQ_value(((V *)Rv0)[6]),8,4,0);
      PAS__WRITE_CHAR(59);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1985; /* line # 1985 */
      Lx[1].v[0]=((V *)Lx[1].v[0])[1];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " symtrylst "  */
void MXD_LSQ_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1819;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=1997; /* line # 1997 */
  if (Rs.ub[4141]) {
    Ra.sl[3]=1998; /* line # 1998 */
    if (V_symhde!=NULL) {
      Ra.sl[3]=2000; /* line # 2000 */
      P_newparagraphe(12);
      Ra.sl[3]=2001; /* line # 2001 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+1830,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=2002; /* line # 2002 */
      P_underline(0,34);
      Ra.sl[3]=2003; /* line # 2003 */
      P_skipline(1);
      Ra.sl[3]=2004; /* line # 2004 */
      Lx[1].v[0]=V_symhde;
      Ra.sl[3]=2005; /* line # 2005 */
      while (Lx[1].v[0]!=NULL){
        Ra.sl[3]=2007; /* line # 2007 */
        Rv0=Lx[1].v[0];
        Ra.sl[3]=2009; /* line # 2009 */
        P_newlinelst();
        Ra.sl[3]=2010; /* line # 2010 */
        Rv1=(float)((SL *)Rv0)[7]/(F)1.200000E+01;
        Ra.sl[3]=2011; /* line # 2011 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,4,-1,1,32);
        MXD_LSQ_outnameid(((V *)Rv0)[2],16);
        Ra.sl[3]=2012; /* line # 2012 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_INT(((SL *)Rv0)[4],4,0);
        PAS__WRITE_INT(((SL *)Rv0)[5],4,0);
        PAS__WRITE_INT(((SL *)Rv0)[6],4,0);
        PAS__WRITE_SNGL(Rv1,10,6,0);
        PAS__WRITE_EOLN();
        Ra.sl[3]=2013; /* line # 2013 */
        Rv1=(float)((SL *)Rv0)[11]/(F)1.200000E+01;
        Ra.sl[3]=2014; /* line # 2014 */
        P_newlinelst();
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,20,-1,1,32);
        PAS__WRITE_INT(((SL *)Rv0)[8],4,0);
        PAS__WRITE_INT(((SL *)Rv0)[9],4,0);
        PAS__WRITE_INT(((SL *)Rv0)[10],4,0);
        PAS__WRITE_SNGL(Rv1,10,6,0);
        PAS__WRITE_EOLN();
        Ra.sl[3]=2015; /* line # 2015 */
        Rv1=(float)((SL *)Rv0)[15]/(F)1.200000E+01;
        Ra.sl[3]=2016; /* line # 2016 */
        P_newlinelst();
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,20,-1,1,32);
        PAS__WRITE_INT(((SL *)Rv0)[12],4,0);
        PAS__WRITE_INT(((SL *)Rv0)[13],4,0);
        PAS__WRITE_INT(((SL *)Rv0)[14],4,0);
        PAS__WRITE_SNGL(Rv1,10,6,0);
        PAS__WRITE_EOLN();
        Ra.sl[3]=2017; /* line # 2017 */
        P_skipline(1);
        Ra.sl[3]=2019; /* line # 2019 */
        Lx[1].v[0]=((V *)Lx[1].v[0])[1];
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " firstoutput "  */
void MXD_LSQ_firstoutput(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+1867;
  Ra.v[3]=Rd.s+17;
  Ra.sl[4]=2026; /* line # 2026 */
  PAS__CHT_TO_CHT(Ra.s+20,7, Rd.s+1882,7);
  Ra.sl[4]=2027; /* line # 2027 */
  P_newlinelst();
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+1889,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[4]=2028; /* line # 2028 */
  P_underline(0,26);
  Ra.sl[4]=2029; /* line # 2029 */
  P_skipline(2);
  Ra.sl[4]=2030; /* line # 2030 */
  if (V_varnb>0) {
    Ra.sl[4]=2032; /* line # 2032 */
    P_newlinelst();
    Ra.sl[4]=2033; /* line # 2033 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+1918,-1,-1,32);
    PAS__WRITE_INT(V_varnb,6,0);
    PAS__WRITE_STR(Rd.s+1932,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[4]=2034; /* line # 2034 */
    if (Rs.sl[1036]>0) {
      Ra.sl[4]=2036; /* line # 2036 */
      P_newlinelst();
      Ra.sl[4]=2037; /* line # 2037 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+1955,-1,-1,32);
      PAS__WRITE_INT(Rs.sl[1036],4,0);
      PAS__WRITE_CHAR(46);
      PAS__WRITE_EOLN();
    }
    Ra.sl[4]=2040; /* line # 2040 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+2006,-1,-1,32);
    PAS__WRITE_INT(Rs.sl[1],3,0);
    PAS__WRITE_STR(Rd.s+2022,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[4]=2041; /* line # 2041 */
    if (V_bcentric) {
      Ra.sl[4]=2043; /* line # 2043 */
      P_newlinelst();
      Ra.sl[4]=2044; /* line # 2044 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2032,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[4]=2046; /* line # 2046 */
    P_newlinelst();
    Ra.sl[4]=2047; /* line # 2047 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+2068,-1,-1,32);
    PAS__WRITE_CHAR(Ra.c[V_latticenb+19]);
    PAS__WRITE_CHAR(46);
    PAS__WRITE_EOLN();
    Ra.sl[4]=2048; /* line # 2048 */
    if (V_psav!=NULL) {
      Ra.sl[4]=2050; /* line # 2050 */
      P_skipline(1);
      P_newlinelst();
      Ra.sl[4]=2051; /* line # 2051 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2096,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[4]=2054; /* line # 2054 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHT(V_psav+4,132,(SL)((C *)V_psav)[136],-1,32);
      PAS__WRITE_CHAR(46);
      PAS__WRITE_EOLN();
    }
    Ra.sl[4]=2056; /* line # 2056 */
    if (Rs.ub[4138]) {
      Ra.sl[4]=2058; /* line # 2058 */
      P_newlinelst();
      Ra.sl[4]=2059; /* line # 2059 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2158,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[4]=2061; /* line # 2061 */
    if (Rs.ub[4148]) {
      Ra.sl[4]=2063; /* line # 2063 */
      P_newlinelst();
      Ra.sl[4]=2064; /* line # 2064 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2214,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[4]=2067; /* line # 2067 */
    if (!V_bshortlst) {
      Ra.sl[4]=2069; /* line # 2069 */
      MXD_LSQ_PRC_00000003();
      Ra.sl[4]=2070; /* line # 2070 */
      MXD_LSQ_PRC_00000001();
      Ra.sl[4]=2071; /* line # 2071 */
      MXD_LSQ_PRC_00000002();
      Ra.sl[4]=2072; /* line # 2072 */
      MXD_LSQ_datalst();
      Ra.sl[4]=2073; /* line # 2073 */
      P_skipline(2);
      Ra.sl[4]=2074; /* line # 2074 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2274,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[4]=2075; /* line # 2075 */
      P_underline(0,19);
      Ra.sl[4]=2076; /* line # 2076 */
      P_skipline(1);
      Ra.sl[4]=2077; /* line # 2077 */
      if (V_nbfixed>0) {
        Ra.sl[4]=2079; /* line # 2079 */
        P_newlinelst();
        Ra.sl[4]=2080; /* line # 2080 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+2296,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Ra.sl[4]=2082; /* line # 2082 */
      if (V_bflimited) {
        Ra.sl[4]=2084; /* line # 2084 */
        P_newlinelst();
        Ra.sl[4]=2085; /* line # 2085 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+2340,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Ra.sl[4]=2087; /* line # 2087 */
      P_newlinelst();
      Ra.sl[4]=2088; /* line # 2088 */
      Ra.v[0]=V_gvarhde;
      Ra.sl[4]=2089; /* line # 2089 */
      Rv0=0;
      Ra.sl[4]=2090; /* line # 2090 */
      while (Ra.v[0]!=NULL){
        Ra.sl[4]=2092; /* line # 2092 */
        if ((Rv0&3)==0) {
          Ra.sl[4]=2093; /* line # 2093 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_EOLN();
          P_newlinelst();
        }
        Ra.sl[4]=2094; /* line # 2094 */
        Rv0=Rv0+1;
        Ra.sl[4]=2095; /* line # 2095 */
        Rv1=Ra.v[0];
        Ra.sl[4]=2097; /* line # 2097 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        MXD_LSQ_outnameid(((V *)Rv1)[2],16);
        Ra.sl[4]=2098; /* line # 2098 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(61);
        PAS__WRITE_SNGL(((F *)Rv1)[7],8,4,0);
        Ra.sl[4]=2099; /* line # 2099 */
        if (((SL *)Rv1)[5]==0) {
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+2386,4,-1,32);
        }
        else {
          Ra.sl[4]=2100; /* line # 2100 */
          if (((V *)Rv1)[6]!=NULL) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+2390,4,-1,32);
          }
          else {
            Ra.sl[4]=2101; /* line # 2101 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_FCHAR(32,4,-1,1,32);
          }
        }
        Ra.sl[4]=2103; /* line # 2103 */
        Ra.v[0]=((V *)Ra.v[0])[1];
      }
      Ra.sl[4]=2105; /* line # 2105 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
    }
  }
  Ra.sl[4]=2108; /* line # 2108 */
  if (Rs.ub[4139]&&!V_bshortlst) MXD_LSQ_outstructure();
  Ra.sl[4]=2109; /* line # 2109 */
  if (V_bshortlst) P_newparagraphe(20);
  else P_newparagraphe(30);
  Ra.sl[4]=2110; /* line # 2110 */
  P_newlinelst();
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+2394,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[4]=2111; /* line # 2111 */
  P_underline(0,31);
  Ra.sl[4]=2112; /* line # 2112 */
  P_skipline(2);
  PAS__curr_cntx=Ra.v[1];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " gtvd "  */
F MXD_LSQ_gtvd(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2428;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2120; /* line # 2120 */
  if (F_pt==NULL) Ret=(F)0.000000E-01;
  else Ret=((F *)F_pt)[6];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " outatome "  */
void MXD_LSQ_outatome(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  F Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2434;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2134; /* line # 2134 */
  P_open_listing(&V_intf, Rd.s+2446,9,1);
  Ra.sl[3]=2135; /* line # 2135 */
  Rv0=V_atomhde;
  Ra.sl[3]=2136; /* line # 2136 */
  while (Rv0!=NULL){
    Ra.sl[3]=2138; /* line # 2138 */
    Rv1=Rv0;
    Ra.sl[3]=2140; /* line # 2140 */
    PAS__SELECT_OUT(V_intf);
    PAS__WRITE_STR(Rd.s+2455,-1,-1,32);
    MXD_LSQ_outnameid(((V *)Rv1)[2],16);
    Ra.sl[3]=2141; /* line # 2141 */
    Rv2=4;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      PAS__SELECT_OUT(V_intf);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(MXD_LSQ_gtvd(((V *)Rv1)[Rv2+6]),9,6,0);
      Rv2++;
    }
    Ra.sl[3]=2142; /* line # 2142 */
    PAS__SELECT_OUT(V_intf);
    PAS__WRITE_EOLN();
    Ra.sl[3]=2143; /* line # 2143 */
    Rv3=MXD_LSQ_gtvd(((V *)Rv1)[13]);
    Ra.sl[3]=2144; /* line # 2144 */
    if (!(((UB *)Rv1)[77]||!V_buiso)) Rv3=(float)((double)Rv3*7.895683754154633E+001)
    ;
    Ra.sl[3]=2145; /* line # 2145 */
    PAS__SELECT_OUT(V_intf);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv3,9,6,0);
    Ra.sl[3]=2146; /* line # 2146 */
    Rv4=8;
    for( Rf0=5;Rf0>0;Rf0-- ) {
      PAS__SELECT_OUT(V_intf);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(MXD_LSQ_gtvd(((V *)Rv1)[Rv4+6]),9,6,0);
      Rv4++;
    }
    Ra.sl[3]=2147; /* line # 2147 */
    PAS__SELECT_OUT(V_intf);
    PAS__WRITE_EOLN();
    Ra.sl[3]=2149; /* line # 2149 */
    Rv0=((V *)Rv0)[1];
  }
  Ra.sl[3]=2151; /* line # 2151 */
  P_close_txtfile(&V_intf);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " msetder "  */
void MXD_LSQ_msetder(SL F_iv, SL F_jv, V F_pp, F F_rdv, F F_idv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2459;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2166; /* line # 2166 */
  if (F_pp!=NULL) {
    Ra.sl[3]=2168; /* line # 2168 */
    Rv0=((V *)F_pp)[5];
    Ra.sl[3]=2169; /* line # 2169 */
    while (Rv0!=NULL){
      Ra.sl[3]=2171; /* line # 2171 */
      Rv1=Rv0;
      Ra.sl[3]=2172; /* line # 2172 */
      Rv2=((V *)Rv1)[1];
      Ra.sl[3]=2173; /* line # 2173 */
      if (((SL *)Rv2)[5]>0) {
        Ra.sl[3]=2175; /* line # 2175 */
        Rs.f[((F_iv+((SL *)Rv2)[5])-1)+1093]=Rs.f[((F_iv+((SL *)Rv2)[5])-1)+1093]
        +((F *)Rv1)[2]*F_rdv;
        Ra.sl[3]=2176; /* line # 2176 */
        Rs.f[((F_jv+((SL *)Rv2)[5])-1)+1093]=Rs.f[((F_jv+((SL *)Rv2)[5])-1)+1093]
        +((F *)Rv1)[2]*F_idv;
      }
      Ra.sl[3]=2178; /* line # 2178 */
      Rv0=((V *)Rv0)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cpf2corr "  */
void MXD_LSQ_cpf2corr(F *F_fcal, F F_ncf2, V F_pcorr, SL F_id, SL F_jd, UB F_add
, UB F_deriv, UB F_bsqrt){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  V Rv2;
  UB Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  F Rv9;
  SL Rv10;
  register V Rv11;
  F Rv12;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2468;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2214; /* line # 2214 */
  if (F_pcorr==NULL) {
    Ra.sl[3]=2216; /* line # 2216 */
    if (F_add) (*F_fcal)=(*F_fcal)+F_ncf2;
    else (*F_fcal)=F_ncf2;
    Ra.sl[3]=2217; /* line # 2217 */
    if (F_id!=F_jd) {
      Ra.sl[3]=2218; /* line # 2218 */
      if (F_deriv) {
        Ra.sl[3]=2219; /* line # 2219 */
        for( Rf1=V_varnb;Rf1>0;Rf1-- ) {
          Ra.sl[3]=2221; /* line # 2221 */
          if (F_add) Rs.f[F_jd+1093]=Rs.f[F_jd+1093]+Rs.f[F_id+1093];
          else Rs.f[F_jd+1093]=Rs.f[F_id+1093];
          Ra.sl[3]=2222; /* line # 2222 */
          F_id=F_id+1;
          F_jd=F_jd+1;
        }
      }
    }
  }
  else {
    Ra.sl[3]=2226; /* line # 2226 */
    Rv0=F_pcorr;
    Ra.sl[3]=2228; /* line # 2228 */
    if (F_bsqrt) Rv1=sqrt(((F *)Rv0)[6]);
    else Rv1=((F *)Rv0)[6];
    Ra.sl[3]=2229; /* line # 2229 */
    if (F_add) (*F_fcal)=(*F_fcal)+F_ncf2*Rv1;
    else {
      Ra.sl[3]=2230; /* line # 2230 */
      (*F_fcal)=F_ncf2*Rv1;
    }
    Ra.sl[3]=2231; /* line # 2231 */
    if (F_deriv) {
      Ra.sl[3]=2233; /* line # 2233 */
      Rv2=((V *)Rv0)[5];
      Rv3=1;
      Rv4=0;
      Ra.sl[3]=2234; /* line # 2234 */
      if (Rv2!=NULL) {
        Ra.sl[3]=2235; /* line # 2235 */
        while (Rv2!=NULL&&Rv3){
          Ra.sl[3]=2236; /* line # 2236 */
          Rv5=Rv2;
          Ra.sl[3]=2237; /* line # 2237 */
          if (((SL *)((V *)Rv5)[1])[5]<0) {
            Ra.sl[3]=2239; /* line # 2239 */
            Rv4=Rv4+1;
            Ra.sl[3]=2240; /* line # 2240 */
            Rv6=(Ra.s+Rv4*8+8);
            Ra.sl[3]=2242; /* line # 2242 */
            ((SL *)Rv6)[0]= -((SL *)((V *)Rv5)[1])[5];
            Ra.sl[3]=2243; /* line # 2243 */
            if (F_bsqrt) ((F *)Rv6)[1]=(((F *)Rv5)[2]/Rv1)/(F)2.000000E+00;
            else((F *)Rv6)[1]=((F *)Rv5)[2];
            Ra.sl[3]=2245; /* line # 2245 */
            Rv2=((V *)Rv5)[0];
          }
          else {
            Ra.sl[3]=2246; /* line # 2246 */
            Rv3=0;
          }
        }
      }
      Ra.sl[3]=2248; /* line # 2248 */
      Rv7=1;
      for( Rf1=V_varnb;Rf1>0;Rf1-- ) {
        Ra.sl[3]=2250; /* line # 2250 */
        if (Rv2!=NULL) {
          Ra.sl[3]=2251; /* line # 2251 */
          Rv8=Rv2;
          Ra.sl[3]=2252; /* line # 2252 */
          if (((SL *)((V *)Rv8)[1])[5]==Rv7) {
            Ra.sl[3]=2254; /* line # 2254 */
            if (F_bsqrt) Rv9=(((F *)Rv8)[2]/Rv1)/(F)2.000000E+00;
            else Rv9=((F *)Rv8)[2];
            Ra.sl[3]=2255; /* line # 2255 */
            Rv2=((V *)Rv8)[0];
          }
          else {
            Ra.sl[3]=2257; /* line # 2257 */
            Rv9=(F)0.000000E-01;
          }
        }
        else {
          Ra.sl[3]=2258; /* line # 2258 */
          Rv9=(F)0.000000E-01;
        }
        Ra.sl[3]=2259; /* line # 2259 */
        Rv10=1;
        for( Rf0=Rv4;Rf0>0;Rf0-- ) {
          Ra.sl[3]=2260; /* line # 2260 */
          Rv11=(Ra.s+Rv10*8+8);
          Ra.sl[3]=2261; /* line # 2261 */
          Rv9=Rv9+((F *)Rv11)[1]*Rs.f[((SL *)Rv11)[0]+1093];
          Rv10++;
        }
        Ra.sl[3]=2262; /* line # 2262 */
        Rv12=Rs.f[F_id+1093]*Rv1+F_ncf2*Rv9;
        Ra.sl[3]=2263; /* line # 2263 */
        if (F_add) Rs.f[F_jd+1093]=Rs.f[F_jd+1093]+Rv12;
        else Rs.f[F_jd+1093]=Rv12;
        Ra.sl[3]=2264; /* line # 2264 */
        F_id=F_id+1;
        F_jd=F_jd+1;
        Rv7++;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " transhkl "  */
void MXD_LSQ_PRC_00000005(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2478;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2296; /* line # 2296 */
  Rv0=V_csymtry;
  Ra.sl[3]=2298; /* line # 2298 */
  V_h1=(float)(6.283185299999999E+000*(double)((V_hr*(float)((SL *)Rv0)[4]+V_kr*
  (float)((SL *)Rv0)[8])+V_lr*(float)((SL *)Rv0)[12]));
  Ra.sl[3]=2299; /* line # 2299 */
  V_k1=(float)(6.283185299999999E+000*(double)((V_hr*(float)((SL *)Rv0)[5]+V_kr*
  (float)((SL *)Rv0)[9])+V_lr*(float)((SL *)Rv0)[13]));
  Ra.sl[3]=2300; /* line # 2300 */
  V_l1=(float)(6.283185299999999E+000*(double)((V_hr*(float)((SL *)Rv0)[6]+V_kr*
  (float)((SL *)Rv0)[10])+V_lr*(float)((SL *)Rv0)[14]));
  Ra.sl[3]=2302; /* line # 2302 */
  if (((V *)Rv0)[16]!=NULL) {
    Ra.sl[3]=2304; /* line # 2304 */
    V_h2=(float)(6.283185299999999E+000*(double)((V_hc*((F *)((V *)Rv0)[16])[0]+
    V_kc*((F *)((V *)Rv0)[16])[3])+V_lc*((F *)((V *)Rv0)[16])[6]));
    Ra.sl[3]=2305; /* line # 2305 */
    V_k2=(float)(6.283185299999999E+000*(double)((V_hc*((F *)((V *)Rv0)[16])[1]+
    V_kc*((F *)((V *)Rv0)[16])[4])+V_lc*((F *)((V *)Rv0)[16])[7]));
    Ra.sl[3]=2306; /* line # 2306 */
    V_l2=(float)(6.283185299999999E+000*(double)((V_hc*((F *)((V *)Rv0)[16])[2]+
    V_kc*((F *)((V *)Rv0)[16])[5])+V_lc*((F *)((V *)Rv0)[16])[8]));
  }
  else {
    Ra.sl[3]=2309; /* line # 2309 */
    V_h2=(float)(6.283185299999999E+000*(double)((V_hc*(float)((SL *)Rv0)[4]+V_kc*
    (float)((SL *)Rv0)[8])+V_lc*(float)((SL *)Rv0)[12]));
    Ra.sl[3]=2310; /* line # 2310 */
    V_k2=(float)(6.283185299999999E+000*(double)((V_hc*(float)((SL *)Rv0)[5]+V_kc*
    (float)((SL *)Rv0)[9])+V_lc*(float)((SL *)Rv0)[13]));
    Ra.sl[3]=2311; /* line # 2311 */
    V_l2=(float)(6.283185299999999E+000*(double)((V_hc*(float)((SL *)Rv0)[6]+V_kc*
    (float)((SL *)Rv0)[10])+V_lc*(float)((SL *)Rv0)[14]));
  }
  Ra.sl[3]=2313; /* line # 2313 */
  Lx[4].f[0]=(float)(((double)(((float)((SL *)Rv0)[7]*V_hr+(float)((SL *)Rv0)[11]
  *V_kr)+(float)((SL *)Rv0)[15]*V_lr)*6.283185299999999E+000)/1.200000000000000E+001)
  ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dspfac "  */
void MXD_LSQ_PRC_00000007(SL F_n, F F_ppm, F F_pph, F F_flph){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  F Rv13;
  F Rv14;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2488;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2346; /* line # 2346 */
  Rv0=abs(F_n);
  Rv1=(float)(((double)(Lx[3].f[0]-(float)F_n*Lx[3].f[1])+(double)Rv0*1.570796330000000E+000)
  +(double)F_pph);
  Ra.sl[3]=2347; /* line # 2347 */
  Rv2=cos(Rv1);
  Rv3=sin(Rv1);
  Ra.sl[3]=2348; /* line # 2348 */
  Rv4=P_fbjn(&Rv5, (F)2.000000E+00*Lx[3].f[2],Rv0);
  Rv5=(F)2.000000E+00*Rv5;
  Ra.sl[3]=2349; /* line # 2349 */
  Rv6=(float)F_n*Rv4;
  Ra.sl[3]=2350; /* line # 2350 */
  Rv7=Rv6*Rv2;
  Rv8=Rv6*Rv3;
  Ra.sl[3]=2351; /* line # 2351 */
  Rv9=Rv5*Rv2;
  Rv10=Rv5*Rv3;
  Ra.sl[3]=2352; /* line # 2352 */
  Rv11=Rv4*Rv2;
  Rv12=Rv4*Rv3;
  Rv13=Rv11*F_ppm;
  Rv14=Rv12*F_ppm;
  Ra.sl[3]=2353; /* line # 2353 */
  Lx[3].f[3]=Lx[3].f[3]+F_ppm*(Rv9*Lx[3].f[4]+Rv8*Lx[3].f[5]);
  Ra.sl[3]=2354; /* line # 2354 */
  Lx[3].f[6]=Lx[3].f[6]+F_ppm*(Rv9*Lx[3].f[7]+Rv8*Lx[3].f[8]);
  Ra.sl[3]=2355; /* line # 2355 */
  Lx[3].f[9]=Lx[3].f[9]+F_ppm*(Rv10*Lx[3].f[4]-Rv7*Lx[3].f[5]);
  Ra.sl[3]=2356; /* line # 2356 */
  Lx[3].f[10]=Lx[3].f[10]+F_ppm*(Rv10*Lx[3].f[7]-Rv7*Lx[3].f[8]);
  Ra.sl[3]=2357; /* line # 2357 */
  Lx[3].f[11]=Rv11;
  Lx[3].f[12]=Rv12;
  Lx[3].f[13]=Lx[3].f[13]-Rv14;
  Lx[3].f[14]=Lx[3].f[14]+Rv13;
  Ra.sl[3]=2358; /* line # 2358 */
  Lx[3].f[15]=Lx[3].f[15]-Rv14*F_flph;
  Lx[3].f[16]=Lx[3].f[16]+Rv13*F_flph;
  Ra.sl[3]=2359; /* line # 2359 */
  V_rgf=V_rgf+Rv13;
  V_igf=V_igf+Rv14;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " strdsp "  */
void MXD_LSQ_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  register V Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2496;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2371; /* line # 2371 */
  V_cmdsdsp=((V *)V_catome)[5];
  Ra.sl[3]=2372; /* line # 2372 */
  Lx[3].ub[68]=0;
  Ra.sl[3]=2373; /* line # 2373 */
  if (V_iqwave!=0) {
    Ra.sl[3]=2375; /* line # 2375 */
    Lx[3].ub[69]=0;
    Ra.sl[3]=2376; /* line # 2376 */
    if (abs(Lx[3].sl[18])==1) {
      Ra.sl[3]=2379; /* line # 2379 */
      while (V_cmdsdsp!=NULL&&!Lx[3].ub[69]){
        Ra.sl[3]=2381; /* line # 2381 */
        Lx[3].ub[69]=((SL *)((V *)V_cmdsdsp)[4])[3]==V_cdrec.sl[5];
        Ra.sl[3]=2382; /* line # 2382 */
        if (!Lx[3].ub[69]) V_cmdsdsp=((V *)V_cmdsdsp)[5];
      }
      Ra.sl[3]=2384; /* line # 2384 */
      if (Lx[3].ub[69]) {
        Ra.sl[3]=2385; /* line # 2385 */
        Rv0=V_cmdsdsp;
        Ra.sl[3]=2387; /* line # 2387 */
        if (Lx[3].sl[18]>0) {
          Ra.sl[3]=2389; /* line # 2389 */
          Rv1=(float)((double)Lx[3].f[0]-(double)MXD_LSQ_gtvd(((V *)Rv0)[7])*1.745329310000000E-002)
          ;
          Rv2=(F)-1.000000E+00;
        }
        else {
          Ra.sl[3]=2393; /* line # 2393 */
          Rv1=(float)((double)Lx[3].f[0]+(double)MXD_LSQ_gtvd(((V *)Rv0)[7])*1.745329310000000E-002)
          ;
          Rv2=(F)1.000000E+00;
        }
        Ra.sl[3]=2395; /* line # 2395 */
        Rv3=MXD_LSQ_gtvd(((V *)Rv0)[6]);
      }
    }
    Ra.sl[3]=2398; /* line # 2398 */
    if (!Lx[3].ub[69]) {
      Rv3=(F)1.000000E+00;
      Rv1=Lx[3].f[0];
      Rv2=(F)0.000000E-01;
    }
    Ra.sl[3]=2399; /* line # 2399 */
    Lx[3].f[19]=cos(Rv1);
    Lx[3].f[20]=sin(Rv1);
    Ra.sl[3]=2400; /* line # 2400 */
    V_rgf=Rv3*Lx[3].f[19];
    V_igf=Rv3*Lx[3].f[20];
    Ra.sl[3]=2401; /* line # 2401 */
    Lx[3].f[13]= -V_igf;
    Lx[3].f[14]=V_rgf;
    Ra.sl[3]=2402; /* line # 2402 */
    Lx[3].f[15]=Lx[3].f[13]*Rv2;
    Lx[3].f[16]=Lx[3].f[14]*Rv2;
  }
  else {
    Ra.sl[3]=2406; /* line # 2406 */
    Rv4=V_cmdsdsp;
    Ra.sl[3]=2408; /* line # 2408 */
    Lx[3].ub[68]=1;
    Ra.sl[3]=2409; /* line # 2409 */
    Lx[3].f[21]=(float)((double)V_hh*6.283185299999999E+000);
    Lx[3].f[22]=(float)((double)V_kk*6.283185299999999E+000);
    Lx[3].f[23]=(float)((double)V_ll*6.283185299999999E+000);
    Ra.sl[3]=2410; /* line # 2410 */
    Rv5=(Lx[3].f[21]*MXD_LSQ_gtvd(((V *)Rv4)[8])+Lx[3].f[22]*MXD_LSQ_gtvd(((V *)
    Rv4)[9]))+Lx[3].f[23]*MXD_LSQ_gtvd(((V *)Rv4)[10]);
    Ra.sl[3]=2412; /* line # 2412 */
    Rv6=(Lx[3].f[21]*MXD_LSQ_gtvd(((V *)Rv4)[11])+Lx[3].f[22]*MXD_LSQ_gtvd(((V *)
    Rv4)[12]))+Lx[3].f[23]*MXD_LSQ_gtvd(((V *)Rv4)[13]);
    Ra.sl[3]=2414; /* line # 2414 */
    Rv7=Rv5*Rv5+Rv6*Rv6;
    Ra.sl[3]=2415; /* line # 2415 */
    if (Rv7>(F)1.000000E-016) {
      Ra.sl[3]=2417; /* line # 2417 */
      Lx[3].f[2]=sqrt(Rv7);
      Ra.sl[3]=2418; /* line # 2418 */
      if (fabs(Rv5)<(F)1.000000E-016) Lx[3].f[1]=(F)1.570796E+00;
      else {
        Ra.sl[3]=2419; /* line # 2419 */
        Lx[3].f[1]=atan(Rv6/Rv5);
      }
      Ra.sl[3]=2420; /* line # 2420 */
      if (Rv5<(F)0.000000E-01) Lx[3].f[1]=(float)((double)Lx[3].f[1]+3.141592660000000E+000)
      ;
      Ra.sl[3]=2421; /* line # 2421 */
      Lx[3].f[4]=Rv5/Lx[3].f[2];
      Lx[3].f[7]=Rv6/Lx[3].f[2];
      Lx[3].f[5]= -Rv6/Rv7;
      Lx[3].f[8]=Rv5/Rv7;
    }
    else {
      Ra.sl[3]=2424; /* line # 2424 */
      Lx[3].f[1]=(F)0.000000E-01;
      Lx[3].f[2]=(F)0.000000E-01;
      Lx[3].f[4]=(F)1.000000E+00;
      Lx[3].f[7]=(F)1.000000E+00;
      Lx[3].f[5]=(F)0.000000E-01;
      Lx[3].f[8]=(F)0.000000E-01;
    }
    Ra.sl[3]=2426; /* line # 2426 */
    V_rgf=(F)0.000000E-01;
    V_igf=(F)0.000000E-01;
    Lx[3].f[13]=(F)0.000000E-01;
    Lx[3].f[14]=(F)0.000000E-01;
    Ra.sl[3]=2427; /* line # 2427 */
    Lx[3].f[3]=(F)0.000000E-01;
    Lx[3].f[9]=(F)0.000000E-01;
    Lx[3].f[6]=(F)0.000000E-01;
    Lx[3].f[10]=(F)0.000000E-01;
    Ra.sl[3]=2428; /* line # 2428 */
    Lx[3].f[15]=(F)0.000000E-01;
    Lx[3].f[16]=(F)0.000000E-01;
    Ra.sl[3]=2429; /* line # 2429 */
    MXD_LSQ_PRC_00000007(Lx[3].sl[18],(F)1.000000E+00, (F)0.000000E-01, (F)0.000000E-01);
    Ra.sl[3]=2430; /* line # 2430 */
    if (((V *)V_catome)[4]!=NULL) {
      Ra.sl[3]=2432; /* line # 2432 */
      Lx[3].f[24]=V_rgf;
      Lx[3].f[25]=V_igf;
      Lx[3].f[26]=Lx[3].f[13];
      Lx[3].f[27]=Lx[3].f[14];
      Ra.sl[3]=2433; /* line # 2433 */
      Lx[3].f[28]=Lx[3].f[3];
      Lx[3].f[29]=Lx[3].f[6];
      Lx[3].f[30]=Lx[3].f[9];
      Lx[3].f[31]=Lx[3].f[10];
    }
    Ra.sl[3]=2435; /* line # 2435 */
    if (((V *)Rv4)[6]!=NULL) {
      Ra.sl[3]=2437; /* line # 2437 */
      Rv3=MXD_LSQ_gtvd(((V *)Rv4)[6]);
      Rv1=(float)((double)MXD_LSQ_gtvd(((V *)Rv4)[7])*1.745329310000000E-002);
      Ra.sl[3]=2438; /* line # 2438 */
      MXD_LSQ_PRC_00000007(Lx[3].sl[18]-1, Rv3, -Rv1, (F)-1.000000E+00);
      Ra.sl[3]=2439; /* line # 2439 */
      Lx[3].f[19]=Lx[3].f[11];
      Lx[3].f[20]=Lx[3].f[12];
      Ra.sl[3]=2440; /* line # 2440 */
      MXD_LSQ_PRC_00000007(Lx[3].sl[18]+1, Rv3, Rv1, (F)1.000000E+00);
      Ra.sl[3]=2441; /* line # 2441 */
      Lx[3].f[19]=Lx[3].f[19]+Lx[3].f[11];
      Lx[3].f[20]=Lx[3].f[20]+Lx[3].f[12];
    }
    else {
      Ra.sl[3]=2444; /* line # 2444 */
      Lx[3].f[19]=(F)0.000000E-01;
      Lx[3].f[20]=(F)0.000000E-01;
    }
  }
  Ra.sl[3]=2446; /* line # 2446 */
  Lx[3].f[15]=(float)((double)Lx[3].f[15]*1.745329310000000E-002);
  Lx[3].f[16]=(float)((double)Lx[3].f[16]*1.745329310000000E-002);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " momfac "  */
void MXD_LSQ_PRC_00000010(SL F_ivr, SL F_ivi, SL F_i, F *F_fr, F *F_fi){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  F Rv11;
  F Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2504;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2464; /* line # 2464 */
  Rv0=V_cmoment;
  Ra.sl[3]=2466; /* line # 2466 */
  Rv1=MXD_LSQ_gtvd(((V *)Rv0)[F_i+5]);
  Ra.sl[3]=2467; /* line # 2467 */
  Rv2=Lx[3].f[24]*Rv1;
  Rv3=Lx[3].f[25]*Rv1;
  Ra.sl[3]=2468; /* line # 2468 */
  if (Lx[2].ub[0]) {
    Ra.sl[3]=2470; /* line # 2470 */
    if (Lx[3].sl[18]>0) Rv4=(F)-1.000000E+00;
    else Rv4=(F)1.000000E+00;
    Ra.sl[3]=2471; /* line # 2471 */
    Rv5=Rv4*MXD_LSQ_gtvd(((V *)Rv0)[(F_i+3)+5]);
    Ra.sl[3]=2472; /* line # 2472 */
    Rv2=Rv2-Rv5*Lx[3].f[25];
    Rv3=Rv3+Rv5*Lx[3].f[24];
    Ra.sl[3]=2474; /* line # 2474 */
    MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv0)[(F_i+3)+5], -Lx[2].f[1]*Rv4, Lx[2].f[
2]*Rv4);
  }
  else {
    Ra.sl[3]=2475; /* line # 2475 */
    Rv5=(F)0.000000E-01;
  }
  Ra.sl[3]=2477; /* line # 2477 */
  MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv0)[F_i+5],Lx[2].f[2],Lx[2].f[1]);
  Ra.sl[3]=2478; /* line # 2478 */
  Rv6=Lx[2].f[3]*Rv2;
  Rv7=Lx[2].f[3]*Rv3;
  Ra.sl[3]=2479; /* line # 2479 */
  (*F_fr)=(*F_fr)+Rv6;
  (*F_fi)=(*F_fi)+Rv7;
  Ra.sl[3]=2481; /* line # 2481 */
  MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv0)[6],Rv2, Rv3);
  Ra.sl[3]=2483; /* line # 2483 */
  Rv2=Lx[2].f[3]*(Lx[3].f[13]*Rv1-Lx[3].f[14]*Rv5);
  Ra.sl[3]=2484; /* line # 2484 */
  Rv3=Lx[2].f[3]*(Lx[3].f[14]*Rv1+Lx[3].f[13]*Rv5);
  Ra.sl[3]=2485; /* line # 2485 */
  Rv8=V_catome;
  Ra.sl[3]=2487; /* line # 2487 */
  MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv8)[10],Rv2*Lx[4].f[1],Rv3*Lx[4].f[1]);
  Ra.sl[3]=2488; /* line # 2488 */
  MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv8)[11],Rv2*Lx[4].f[2],Rv3*Lx[4].f[2]);
  Ra.sl[3]=2489; /* line # 2489 */
  MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv8)[12],Rv2*Lx[4].f[3],Rv3*Lx[4].f[3]);
  Ra.sl[3]=2490; /* line # 2490 */
  if (((V *)Rv8)[6]!=NULL) {
    Ra.sl[3]=2491; /* line # 2491 */
    Rv9=((V *)Rv8)[6];
    Ra.sl[3]=2492; /* line # 2492 */
    switch (F_i-1) {
      case 1:Ra.sl[3]=2493; /* line # 2493 */
      ((F *)Rv9)[8]=((F *)Rv9)[8]+Rv6;
      ((F *)Rv9)[11]=((F *)Rv9)[11]+Rv7;
      break;
      case 2:Ra.sl[3]=2494; /* line # 2494 */
      ((F *)Rv9)[9]=((F *)Rv9)[9]+Rv6;
      ((F *)Rv9)[12]=((F *)Rv9)[12]+Rv7;
      break;
      case 3:Ra.sl[3]=2495; /* line # 2495 */
      ((F *)Rv9)[10]=((F *)Rv9)[10]+Rv6;
      ((F *)Rv9)[13]=((F *)Rv9)[13]+Rv7;
      break;
    }
  }
  Ra.sl[3]=2498; /* line # 2498 */
  if (V_cmdsdsp!=NULL) {
    Ra.sl[3]=2499; /* line # 2499 */
    Rv10=V_cmdsdsp;
    Ra.sl[3]=2501; /* line # 2501 */
    if (Lx[3].ub[68]) {
      Ra.sl[3]=2504; /* line # 2504 */
      Rv11=Lx[2].f[3]*(Rv1*Lx[3].f[28]-Rv5*Lx[3].f[30]);
      Rv12=Lx[2].f[3]*(Rv5*Lx[3].f[28]+Rv1*Lx[3].f[30]);
      Ra.sl[3]=2505; /* line # 2505 */
      MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv10)[8],Lx[3].f[21]*Rv11, Lx[3].f[21]*
      Rv12);
      Ra.sl[3]=2506; /* line # 2506 */
      MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv10)[9],Lx[3].f[22]*Rv11, Lx[3].f[22]*
      Rv12);
      Ra.sl[3]=2507; /* line # 2507 */
      MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv10)[10],Lx[3].f[23]*Rv11, Lx[3].f[23]
      *Rv12);
      Ra.sl[3]=2508; /* line # 2508 */
      Rv11=Lx[2].f[3]*(Rv1*Lx[3].f[29]-Rv5*Lx[3].f[31]);
      Rv12=Lx[2].f[3]*(Rv5*Lx[3].f[29]+Rv1*Lx[3].f[31]);
      Ra.sl[3]=2509; /* line # 2509 */
      MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv10)[11],Lx[3].f[21]*Rv11, Lx[3].f[21]
      *Rv12);
      Ra.sl[3]=2510; /* line # 2510 */
      MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv10)[12],Lx[3].f[22]*Rv11, Lx[3].f[22]
      *Rv12);
      Ra.sl[3]=2511; /* line # 2511 */
      MXD_LSQ_msetder(F_ivr, F_ivi,((V *)Rv10)[13],Lx[3].f[23]*Rv11, Lx[3].f[23]
      *Rv12);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " strmom "  */
void MXD_LSQ_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[5]=Rd.s+2512;
  Ra.v[6]=Rd.s+17;
  Ra.sl[7]=2520; /* line # 2520 */
  V_cmoment=((V *)V_catome)[4];
  Ra.sl[7]=2521; /* line # 2521 */
  while (V_cmoment!=NULL){
    Ra.sl[7]=2523; /* line # 2523 */
    Rv0=V_cmoment;
    Ra.sl[7]=2525; /* line # 2525 */
    Ra.sl[7]=2526; /* line # 2526 */
    if (((V *)Rv0)[4]==NULL) {
      Ra.sl[7]=2527; /* line # 2527 */
      if (V_cdrec.sl[5]==-1||V_cdrec.sl[4]==0) Ra.ub[0]=1;
      else Ra.ub[0]=0;
    }
    else {
      Ra.sl[7]=2529; /* line # 2529 */
      if (V_cdrec.sl[5]==((SL *)((V *)Rv0)[4])[3]&&abs(V_cdrec.sl[4])==1) Ra.ub[
0]=1;
      else {
        Ra.sl[7]=2530; /* line # 2530 */
        Ra.ub[0]=Lx[3].ub[68];
      }
    }
    Ra.sl[7]=2531; /* line # 2531 */
    if (Ra.ub[0]) {
      Ra.sl[7]=2533; /* line # 2533 */
      Ra.ub[0]=((V *)Rv0)[4]!=NULL;
      Ra.sl[7]=2534; /* line # 2534 */
      if (Ra.ub[0]) Ra.ub[0]=!((UB *)((V *)Rv0)[4])[40];
      Ra.sl[7]=2535; /* line # 2535 */
      Ra.f[3]=MXD_LSQ_gtvd(((V *)Rv0)[6]);
      Ra.sl[7]=2536; /* line # 2536 */
      Ra.f[2]=Ra.f[3]*Lx[3].f[24];
      Ra.f[1]=Ra.f[3]*Lx[3].f[25];
      Ra.sl[7]=2537; /* line # 2537 */
      MXD_LSQ_PRC_00000010(Rs.sl[1084],Rs.sl[1087],2, &V_fxr, &V_fxi);
      Ra.sl[7]=2538; /* line # 2538 */
      MXD_LSQ_PRC_00000010(Rs.sl[1085],Rs.sl[1088],3, &V_fyr, &V_fyi);
      Ra.sl[7]=2539; /* line # 2539 */
      MXD_LSQ_PRC_00000010(Rs.sl[1086],Rs.sl[1089],4, &V_fzr, &V_fzi);
    }
    Ra.sl[7]=2542; /* line # 2542 */
    V_cmoment=((V *)V_cmoment)[5];
  }
  PAS__curr_cntx=Ra.v[4];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " setsgatm "  */
void MXD_LSQ_PRC_00000006(){
  /* Define the automatic variable space. */
  Blk( Ra, 144 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  F Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  F Rv17;
  F Rv18;
  register V Rv19;
  register V Rv20;
  register F Rgf;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[32]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+128;
  Ra.v[33]=Rd.s+2520;
  Ra.v[34]=Rd.s+17;
  Ra.sl[35]=2549; /* line # 2549 */
  Ra.sl[18]=V_cdrec.sl[4];
  Ra.ub[68]=0;
  Ra.sl[35]=2550; /* line # 2550 */
  Rv0=V_catome;
  Ra.sl[35]=2553; /* line # 2553 */
  if (((UB *)Rv0)[76]) {
    Ra.sl[35]=2555; /* line # 2555 */
    Lx[4].f[1]=V_h2;
    Lx[4].f[2]=V_k2;
    Lx[4].f[3]=V_l2;
  }
  else {
    Ra.sl[35]=2558; /* line # 2558 */
    Lx[4].f[1]=V_h1;
    Lx[4].f[2]=V_k1;
    Lx[4].f[3]=V_l1;
  }
  Ra.sl[35]=2560; /* line # 2560 */
  Ra.f[0]=((Lx[4].f[1]*MXD_LSQ_gtvd(((V *)Rv0)[10])+Lx[4].f[2]*MXD_LSQ_gtvd(((V *)
  Rv0)[11]))+Lx[4].f[3]*MXD_LSQ_gtvd(((V *)Rv0)[12]))+Lx[4].f[0];
  Ra.sl[35]=2564; /* line # 2564 */
  if (((V *)Rv0)[5]!=NULL) {
    Ra.sl[35]=2565; /* line # 2565 */
    MXD_LSQ_PRC_00000008();
  }
  else {
    Ra.sl[35]=2568; /* line # 2568 */
    V_cmdsdsp=NULL;
    Ra.sl[35]=2569; /* line # 2569 */
    V_rgf=cos(Ra.f[0]);
    V_igf=sin(Ra.f[0]);
    Ra.sl[35]=2570; /* line # 2570 */
    if (Lx[4].ub[16]) {
      Ra.sl[35]=2572; /* line # 2572 */
      Ra.f[13]=(F)-2.000000E+00*V_igf;
      V_rgf=(F)2.000000E+00*V_rgf;
      Ra.sl[35]=2573; /* line # 2573 */
      Ra.f[14]=(F)0.000000E-01;
      V_igf=(F)0.000000E-01;
    }
    else {
      Ra.sl[35]=2576; /* line # 2576 */
      Ra.f[13]= -V_igf;
      Ra.f[14]=V_rgf;
      Ra.sl[35]=2577; /* line # 2577 */
      if (((V *)Rv0)[4]!=NULL) {
        Ra.sl[35]=2579; /* line # 2579 */
        Ra.f[24]=V_rgf;
        Ra.f[25]=V_igf;
        Ra.f[26]=Ra.f[13];
        Ra.f[27]=Ra.f[14];
      }
    }
  }
  Ra.sl[35]=2584; /* line # 2584 */
  if (V_magsel.ub[V_cselect]) MXD_LSQ_PRC_00000009();
  Ra.sl[35]=2587; /* line # 2587 */
  if (((V *)Rv0)[5]!=NULL||Ra.sl[18]==0) {
    Ra.sl[35]=2589; /* line # 2589 */
    if ((((V *)Rv0)[7]!=NULL||((V *)Rv0)[8]!=NULL)&&((V *)Rv0)[9]!=NULL) {
      Ra.sl[35]=2592; /* line # 2592 */
      if (((UB *)Rv0)[77]) {
        Ra.sl[35]=2594; /* line # 2594 */
        Rv1=(F)-5.000000E-01*PAS__F_SQR(Lx[4].f[1]);
        Ra.sl[35]=2595; /* line # 2595 */
        Rv2=(F)-5.000000E-01*PAS__F_SQR(Lx[4].f[2]);
        Ra.sl[35]=2596; /* line # 2596 */
        Rv3=(F)-5.000000E-01*PAS__F_SQR(Lx[4].f[3]);
        Ra.sl[35]=2597; /* line # 2597 */
        Rv4= -Lx[4].f[1]*Lx[4].f[2];
        Ra.sl[35]=2598; /* line # 2598 */
        Rv5= -Lx[4].f[1]*Lx[4].f[3];
        Ra.sl[35]=2599; /* line # 2599 */
        Rv6= -Lx[4].f[2]*Lx[4].f[3];
        Ra.sl[35]=2600; /* line # 2600 */
        if (!((UB *)Rv0)[76]) {
          Ra.sl[35]=2602; /* line # 2602 */
          Rv1=Rv1*(V_ra*V_ra);
          Ra.sl[35]=2603; /* line # 2603 */
          Rv2=Rv2*(V_rb*V_rb);
          Ra.sl[35]=2604; /* line # 2604 */
          Rv3=Rv3*(V_rc*V_rc);
          Ra.sl[35]=2605; /* line # 2605 */
          Rv4=(Rv4*V_ra)*V_rb;
          Ra.sl[35]=2606; /* line # 2606 */
          Rv5=(Rv5*V_ra)*V_rc;
          Ra.sl[35]=2607; /* line # 2607 */
          Rv6=(Rv6*V_rb)*V_rc;
        }
        Ra.sl[35]=2609; /* line # 2609 */
        Rv7=((((Rv1*MXD_LSQ_gtvd(((V *)Rv0)[13])+Rv2*MXD_LSQ_gtvd(((V *)Rv0)[14]
        ))+Rv3*MXD_LSQ_gtvd(((V *)Rv0)[15]))+Rv4*MXD_LSQ_gtvd(((V *)Rv0)[16]))+Rv5*
        MXD_LSQ_gtvd(((V *)Rv0)[17]))+Rv6*MXD_LSQ_gtvd(((V *)Rv0)[18]);
        Ra.sl[35]=2615; /* line # 2615 */
        Lx[4].ub[17]=1;
      }
      else {
        Ra.sl[35]=2617; /* line # 2617 */
        if (((V *)Rv0)[12]!=NULL) {
          Ra.sl[35]=2619; /* line # 2619 */
          Rv1=(F)-2.500000E-01*PAS__F_SQR(Lx[5].f[0]);
          Ra.sl[35]=2620; /* line # 2620 */
          if (V_buiso) Rv1=(float)((double)Rv1*7.895683599999999E+001);
          Ra.sl[35]=2621; /* line # 2621 */
          Rv7=Rv1*MXD_LSQ_gtvd(((V *)Rv0)[13]);
          Ra.sl[35]=2622; /* line # 2622 */
          Lx[4].ub[17]=1;
        }
        else {
          Ra.sl[35]=2624; /* line # 2624 */
          Lx[4].ub[17]=0;
        }
      }
      Ra.sl[35]=2625; /* line # 2625 */
      if (Lx[4].ub[17]) Rv8=exp(Rv7);
      else Rv8=(F)1.000000E+00;
      Ra.sl[35]=2627; /* line # 2627 */
      Rv9=MXD_LSQ_gtvd(((V *)Rv0)[7]);
      Rv10=MXD_LSQ_gtvd(((V *)Rv0)[8]);
      Ra.sl[35]=2629; /* line # 2629 */
      Rv11=MXD_LSQ_gtvd(((V *)Rv0)[9]);
      Ra.sl[35]=2631; /* line # 2631 */
      Rv12=Rv11*Rv8;
      Ra.sl[35]=2632; /* line # 2632 */
      Rv13=Rv9*V_rgf-Rv10*V_igf;
      Rv14=Rv9*V_igf+Rv10*V_rgf;
      Ra.sl[35]=2633; /* line # 2633 */
      Rv15=Rv12*Rv13;
      Rv16=Rv12*Rv14;
      Ra.sl[35]=2636; /* line # 2636 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[9],Rv8*Rv13, Rv8*Rv14);
      Ra.sl[35]=2638; /* line # 2638 */
      Rv17=Rv12*V_rgf;
      Rv18=Rv12*V_igf;
      Ra.sl[35]=2639; /* line # 2639 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[7],Rv17, Rv18);
      Ra.sl[35]=2640; /* line # 2640 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[8], -Rv18, Rv17);
      Ra.sl[35]=2642; /* line # 2642 */
      Rv17=Rv12*(Ra.f[13]*Rv9-Ra.f[14]*Rv10);
      Ra.sl[35]=2643; /* line # 2643 */
      Rv18=Rv12*(Ra.f[14]*Rv9+Ra.f[13]*Rv10);
      Ra.sl[35]=2644; /* line # 2644 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[10],Rv17*Lx[4].f[1],Rv18*
      Lx[4].f[1]);
      Ra.sl[35]=2645; /* line # 2645 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[11],Rv17*Lx[4].f[2],Rv18*
      Lx[4].f[2]);
      Ra.sl[35]=2646; /* line # 2646 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[12],Rv17*Lx[4].f[3],Rv18*
      Lx[4].f[3]);
      Ra.sl[35]=2648; /* line # 2648 */
      if (V_cmdsdsp!=NULL) {
        Ra.sl[35]=2649; /* line # 2649 */
        Rv19=V_cmdsdsp;
        Ra.sl[35]=2651; /* line # 2651 */
        Rv17=Rv12*(Ra.f[15]*Rv9-Ra.f[16]*Rv10);
        Ra.sl[35]=2652; /* line # 2652 */
        Rv18=Rv12*(Ra.f[16]*Rv9+Ra.f[15]*Rv10);
        Ra.sl[35]=2653; /* line # 2653 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[7],Rv17, Rv18);
        Ra.sl[35]=2654; /* line # 2654 */
        Rv17=Rv12*(Rv9*Ra.f[19]-Rv10*Ra.f[20]);
        Ra.sl[35]=2655; /* line # 2655 */
        Rv18=Rv12*(Rv9*Ra.f[20]+Rv10*Ra.f[19]);
        Ra.sl[35]=2656; /* line # 2656 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[6],Rv17, Rv18);
        Ra.sl[35]=2657; /* line # 2657 */
        if (Ra.ub[68]) {
          Ra.sl[35]=2659; /* line # 2659 */
          Rv17=Rv12*(Rv9*Ra.f[3]-Rv10*Ra.f[9]);
          Ra.sl[35]=2660; /* line # 2660 */
          Rv18=Rv12*(Rv10*Ra.f[3]+Rv9*Ra.f[9]);
          Ra.sl[35]=2661; /* line # 2661 */
          MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[8],Ra.f[21]*Rv17, Ra.
          f[21]*Rv18);
          Ra.sl[35]=2662; /* line # 2662 */
          MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[9],Ra.f[22]*Rv17, Ra.
          f[22]*Rv18);
          Ra.sl[35]=2663; /* line # 2663 */
          MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[10],Ra.f[23]*Rv17,
          Ra.f[23]*Rv18);
          Ra.sl[35]=2664; /* line # 2664 */
          Rv17=Rv12*(Rv9*Ra.f[6]-Rv10*Ra.f[10]);
          Ra.sl[35]=2665; /* line # 2665 */
          Rv18=Rv12*(Rv10*Ra.f[6]+Rv9*Ra.f[10]);
          Ra.sl[35]=2666; /* line # 2666 */
          MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[11],Ra.f[21]*Rv17,
          Ra.f[21]*Rv18);
          Ra.sl[35]=2667; /* line # 2667 */
          MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[12],Ra.f[22]*Rv17,
          Ra.f[22]*Rv18);
          Ra.sl[35]=2668; /* line # 2668 */
          MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv19)[13],Ra.f[23]*Rv17,
          Ra.f[23]*Rv18);
        }
      }
      Ra.sl[35]=2672; /* line # 2672 */
      MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[13],Rv1*Rv15, Rv1*Rv16);
      Ra.sl[35]=2673; /* line # 2673 */
      if (((UB *)Rv0)[77]) {
        Ra.sl[35]=2675; /* line # 2675 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[14],Rv2*Rv15, Rv2*Rv16);
        Ra.sl[35]=2676; /* line # 2676 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[15],Rv3*Rv15, Rv3*Rv16);
        Ra.sl[35]=2677; /* line # 2677 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[16],Rv4*Rv15, Rv4*Rv16);
        Ra.sl[35]=2678; /* line # 2678 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[17],Rv5*Rv15, Rv5*Rv16);
        Ra.sl[35]=2679; /* line # 2679 */
        MXD_LSQ_msetder(Rs.sl[1081],Rs.sl[1082],((V *)Rv0)[18],Rv6*Rv15, Rv6*Rv16);
      }
      Ra.sl[35]=2681; /* line # 2681 */
      V_fnr=V_fnr+Rv15;
      V_fni=V_fni+Rv16;
      Ra.sl[35]=2682; /* line # 2682 */
      if (((V *)Rv0)[6]!=NULL) {
        Ra.sl[35]=2683; /* line # 2683 */
        Rv20=((V *)Rv0)[6];
        Ra.sl[35]=2684; /* line # 2684 */
        ((F *)Rv20)[6]=((F *)Rv20)[6]+Rv15;
        ((F *)Rv20)[7]=((F *)Rv20)[7]+Rv16;
      }
    }
  }
  PAS__curr_cntx=Ra.v[32];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " project "  */
void MXD_LSQ_PRC_00000011(F *F_vx, F *F_vy, F *F_vz, F F_ex, F F_ey, F F_ez){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2530;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2697; /* line # 2697 */
  Rv0=((*F_vx)*F_ex+(*F_vy)*F_ey)+(*F_vz)*F_ez;
  Ra.sl[3]=2698; /* line # 2698 */
  (*F_vx)=(*F_vx)-Rv0*F_ex;
  (*F_vy)=(*F_vy)-Rv0*F_ey;
  (*F_vz)=(*F_vz)-Rv0*F_ez;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " neupola "  */
void MXD_LSQ_PRC_00000012(F F_px, F F_py, F F_pz, SL F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  SL Rv8;
  SL Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  SL Rv14;
  SL Rv15;
  F Rv16;
  F Rv17;
  F Rv18;
  F Rv19;
  F Rv20;
  F Rv21;
  F Rv22;
  F Rv23;
  F Rv24;
  F Rv25;
  register V Rv26;
  V Rv27;
  F Rv28;
  register V Rv29;
  V Rv30;
  F Rv31;
  register V Rv32;
  F Rv33;
  F Rv34;
  F Rv35;
  F Rv36;
  F Rv37;
  F Rv38;
  register V Rv39;
  SL Rv40;
  register V Rv41;
  F Rv42;
  F Rv43;
  register V Rv44;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2539;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=2726; /* line # 2726 */
  Rv0=sqrt((F_px*F_px+F_py*F_py)+F_pz*F_pz);
  Ra.sl[3]=2727; /* line # 2727 */
  if (Rv0>(F)0.000000E-01) {
    Ra.sl[3]=2729; /* line # 2729 */
    F_px=F_px/Rv0;
    F_py=F_py/Rv0;
    F_pz=F_pz/Rv0;
    Ra.sl[3]=2730; /* line # 2730 */
    if (((V *)V_cdata)[6]!=NULL) {
      Ra.sl[3]=2732; /* line # 2732 */
      MXD_LSQ_cpf2corr(&V_fnr, V_fnr,((V *)V_cdata)[6],Rs.sl[1081],Rs.sl[1081],0,
      Lx[4].ub[45],1);
      Ra.sl[3]=2733; /* line # 2733 */
      MXD_LSQ_cpf2corr(&V_fni, V_fni,((V *)V_cdata)[6],Rs.sl[1082],Rs.sl[1082],0,
      Lx[4].ub[45],1);
    }
    Ra.sl[3]=2735; /* line # 2735 */
    if (((V *)V_cdata)[7]!=NULL) {
      Ra.sl[3]=2737; /* line # 2737 */
      MXD_LSQ_cpf2corr(&V_fxr, V_fxr,((V *)V_cdata)[7],Rs.sl[1084],Rs.sl[1084],0,
      Lx[4].ub[45],1);
      Ra.sl[3]=2738; /* line # 2738 */
      MXD_LSQ_cpf2corr(&V_fyr, V_fyr,((V *)V_cdata)[7],Rs.sl[1085],Rs.sl[1085],0,
      Lx[4].ub[45],1);
      Ra.sl[3]=2739; /* line # 2739 */
      MXD_LSQ_cpf2corr(&V_fzr, V_fzr,((V *)V_cdata)[7],Rs.sl[1086],Rs.sl[1086],0,
      Lx[4].ub[45],1);
      Ra.sl[3]=2740; /* line # 2740 */
      MXD_LSQ_cpf2corr(&V_fxi, V_fxi,((V *)V_cdata)[7],Rs.sl[1087],Rs.sl[1087],0,
      Lx[4].ub[45],1);
      Ra.sl[3]=2741; /* line # 2741 */
      MXD_LSQ_cpf2corr(&V_fyi, V_fyi,((V *)V_cdata)[7],Rs.sl[1088],Rs.sl[1088],0,
      Lx[4].ub[45],1);
      Ra.sl[3]=2742; /* line # 2742 */
      MXD_LSQ_cpf2corr(&V_fzi, V_fzi,((V *)V_cdata)[7],Rs.sl[1089],Rs.sl[1089],0,
      Lx[4].ub[45],1);
    }
    Ra.sl[3]=2744; /* line # 2744 */
    Rv0=(V_fxr*F_px+V_fyr*F_py)+V_fzr*F_pz;
    Rv1=(V_fxi*F_px+V_fyi*F_py)+V_fzi*F_pz;
    Ra.sl[3]=2745; /* line # 2745 */
    Rv2=(PAS__F_SQR(V_fnr+(F)2.695000E-01*Rv0)+PAS__F_SQR(V_fni+(F)2.695000E-01*
    Rv1))/(F)2.000000E+00;
    Ra.sl[3]=2746; /* line # 2746 */
    Rv3=(PAS__F_SQR(V_fnr-(F)2.695000E-01*Rv0)+PAS__F_SQR(V_fni-(F)2.695000E-01*
    Rv1))/(F)2.000000E+00;
    Ra.sl[3]=2747; /* line # 2747 */
    if (F_ip<4||F_ip>5) {
      Ra.sl[3]=2750; /* line # 2750 */
      Rv4=(F)3.631500E-02*(((((((V_fxr*V_fxr+V_fyr*V_fyr)+V_fzr*V_fzr)-Rv0*Rv0)+
      V_fxi*V_fxi)+V_fyi*V_fyi)+V_fzi*V_fzi)-Rv1*Rv1);
      Ra.sl[3]=2752; /* line # 2752 */
      Rv5=(F)7.263000E-02*((((((F_px*V_fyr)*V_fzi+(F_py*V_fzr)*V_fxi)+(F_pz*V_fxr)
      *V_fyi)-(F_px*V_fzr)*V_fyi)-(F_py*V_fxr)*V_fzi)-(F_pz*V_fyr)*V_fxi);
      Ra.sl[3]=2754; /* line # 2754 */
      Rv6=Rv4-Rv5;
      Rv7=Rv4+Rv5;
    }
    Ra.sl[3]=2757; /* line # 2757 */
    if (Lx[4].ub[45]) {
      Ra.sl[3]=2758; /* line # 2758 */
      Rv8=Rs.sl[1084];
      Rv9=Rs.sl[1085];
      Rv10=Rs.sl[1086];
      Ra.sl[3]=2759; /* line # 2759 */
      Rv11=Rs.sl[1087];
      Rv12=Rs.sl[1088];
      Rv13=Rs.sl[1089];
      Ra.sl[3]=2760; /* line # 2760 */
      Rv14=Rs.sl[1081];
      Rv15=Rs.sl[1082];
      Ra.sl[3]=2761; /* line # 2761 */
      for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
        Ra.sl[3]=2763; /* line # 2763 */
        Rv16=(Rs.f[Rv8+1093]*F_px+Rs.f[Rv9+1093]*F_py)+Rs.f[Rv10+1093]*F_pz;
        Ra.sl[3]=2764; /* line # 2764 */
        Rv17=(Rs.f[Rv11+1093]*F_px+Rs.f[Rv12+1093]*F_py)+Rs.f[Rv13+1093]*F_pz;
        Ra.sl[3]=2765; /* line # 2765 */
        Rv18=(V_fnr+(F)2.695000E-01*Rv0)*(Rs.f[Rv14+1093]+(F)2.695000E-01*Rv16)+
        (V_fni+(F)2.695000E-01*Rv1)*(Rs.f[Rv15+1093]+(F)2.695000E-01*Rv17);
        Ra.sl[3]=2767; /* line # 2767 */
        Rv19=(V_fnr-(F)2.695000E-01*Rv0)*(Rs.f[Rv14+1093]-(F)2.695000E-01*Rv16)+
        (V_fni-(F)2.695000E-01*Rv1)*(Rs.f[Rv15+1093]-(F)2.695000E-01*Rv17);
        Ra.sl[3]=2769; /* line # 2769 */
        if (F_ip<4||F_ip>5) {
          Ra.sl[3]=2771; /* line # 2771 */
          Rv20=(F)7.263000E-02*(((((((V_fxr*Rs.f[Rv8+1093]+V_fyr*Rs.f[Rv9+1093])
          +V_fzr*Rs.f[Rv10+1093])-Rv0*Rv16)+V_fxi*Rs.f[Rv11+1093])+V_fyi*Rs.f[Rv12+
1093])+V_fzi*Rs.f[Rv13+1093])-Rv1*Rv17);
          Ra.sl[3]=2774; /* line # 2774 */
          Rv21=(F)7.263000E-02*((F_px*(((Rs.f[Rv9+1093]*V_fzi+V_fyr*Rs.f[Rv13+1093]
          )-Rs.f[Rv10+1093]*V_fyi)-V_fzr*Rs.f[Rv12+1093])+F_py*(((Rs.f[Rv10+1093]
          *V_fxi+V_fzr*Rs.f[Rv11+1093])-Rs.f[Rv8+1093]*V_fzi)-V_fxr*Rs.f[Rv13+1093]
          ))+F_pz*(((Rs.f[Rv8+1093]*V_fyi+V_fxr*Rs.f[Rv12+1093])-Rs.f[Rv9+1093]*
          V_fxi)-V_fyr*Rs.f[Rv11+1093]));
          Ra.sl[3]=2778; /* line # 2778 */
          Rs.f[Rv10+1093]=Rv20-Rv21;
          Rs.f[Rv13+1093]=Rv20+Rv21;
        }
        Ra.sl[3]=2780; /* line # 2780 */
        Rs.f[Rv14+1093]=Rv18;
        Rs.f[Rv15+1093]=Rv19;
        Ra.sl[3]=2781; /* line # 2781 */
        Rv8=Rv8+1;
        Rv9=Rv9+1;
        Rv10=Rv10+1;
        Ra.sl[3]=2782; /* line # 2782 */
        Rv11=Rv11+1;
        Rv12=Rv12+1;
        Rv13=Rv13+1;
        Ra.sl[3]=2783; /* line # 2783 */
        Rv14=Rv14+1;
        Rv15=Rv15+1;
      }
    }
    Ra.sl[3]=2788; /* line # 2788 */
    if (((V *)V_cnpola)[9]!=NULL) {
      Ra.sl[3]=2790; /* line # 2790 */
      V_refcatsv=4;
      Ra.sl[3]=2791; /* line # 2791 */
      if (V_virtvtab.v[3]!=NULL) ((F *)V_virtvtab.v[3])[7]=Rv2;
      Ra.sl[3]=2792; /* line # 2792 */
      MXD_LSQ_parmderval(5);
      Ra.sl[3]=2793; /* line # 2793 */
      Rv22=((F *)((V *)V_cnpola)[9])[6];
      Ra.sl[3]=2794; /* line # 2794 */
      MXD_LSQ_cpf2corr(&Rv2, Rv2,((V *)V_cnpola)[9],Rs.sl[1081],Rs.sl[1081],0, Lx[4]
      .ub[45],0);
      Ra.sl[3]=2797; /* line # 2797 */
      V_refcatsv=5;
      Ra.sl[3]=2798; /* line # 2798 */
      if (V_virtvtab.v[3]!=NULL) ((F *)V_virtvtab.v[3])[7]=Rv3;
      Ra.sl[3]=2799; /* line # 2799 */
      MXD_LSQ_parmderval(5);
      Ra.sl[3]=2800; /* line # 2800 */
      Rv23=((F *)((V *)V_cnpola)[9])[6];
      Ra.sl[3]=2801; /* line # 2801 */
      MXD_LSQ_cpf2corr(&Rv3, Rv3,((V *)V_cnpola)[9],Rs.sl[1082],Rs.sl[1082],0, Lx[4]
      .ub[45],0);
      Ra.sl[3]=2803; /* line # 2803 */
      if (F_ip<4||F_ip>5) {
        Ra.sl[3]=2805; /* line # 2805 */
        V_refcatsv=6;
        Ra.sl[3]=2806; /* line # 2806 */
        if (V_virtvtab.v[3]!=NULL) ((F *)V_virtvtab.v[3])[7]=Rv6;
        Ra.sl[3]=2807; /* line # 2807 */
        MXD_LSQ_parmderval(5);
        Ra.sl[3]=2808; /* line # 2808 */
        Rv24=((F *)((V *)V_cnpola)[9])[6];
        Ra.sl[3]=2809; /* line # 2809 */
        MXD_LSQ_cpf2corr(&Rv6, Rv6,((V *)V_cnpola)[9],Rs.sl[1086],Rs.sl[1086],0,
        Lx[4].ub[45],0);
        Ra.sl[3]=2812; /* line # 2812 */
        V_refcatsv=7;
        Ra.sl[3]=2813; /* line # 2813 */
        if (V_virtvtab.v[3]!=NULL) ((F *)V_virtvtab.v[3])[7]=Rv7;
        Ra.sl[3]=2814; /* line # 2814 */
        MXD_LSQ_parmderval(5);
        Ra.sl[3]=2815; /* line # 2815 */
        Rv25=((F *)((V *)V_cnpola)[9])[6];
        Ra.sl[3]=2816; /* line # 2816 */
        MXD_LSQ_cpf2corr(&Rv7, Rv7,((V *)V_cnpola)[9],Rs.sl[1089],Rs.sl[1089],0,
        Lx[4].ub[45],0);
        Ra.sl[3]=2818; /* line # 2818 */
        V_refcatsv=V_cdrec.sl[8];
      }
    }
    else {
      Ra.sl[3]=2821; /* line # 2821 */
      Rv22=(F)1.000000E+00;
      Rv23=(F)1.000000E+00;
      Rv24=(F)1.000000E+00;
      Rv25=(F)1.000000E+00;
    }
    Ra.sl[3]=2824; /* line # 2824 */
    if (F_ip<4) {
      Ra.sl[3]=2826; /* line # 2826 */
      Rv26=V_cnpola;
      Ra.sl[3]=2828; /* line # 2828 */
      if (((V *)Rv26)[7]==NULL) {
        Ra.sl[3]=2829; /* line # 2829 */
        Rv27=NULL;
        Rv28=(F)1.000000E+00;
      }
      else {
        Ra.sl[3]=2830; /* line # 2830 */
        Rv29=((V *)Rv26)[7];
        Ra.sl[3]=2832; /* line # 2832 */
        Rv28=((F *)Rv29)[6];
        Rv27=((V *)Rv29)[5];
      }
      Ra.sl[3]=2834; /* line # 2834 */
      if (((V *)Rv26)[8]==NULL) {
        Ra.sl[3]=2835; /* line # 2835 */
        Rv30=NULL;
        Rv31=(F)1.000000E+00;
      }
      else {
        Ra.sl[3]=2836; /* line # 2836 */
        Rv32=((V *)Rv26)[8];
        Ra.sl[3]=2838; /* line # 2838 */
        Rv31=((F *)Rv32)[6];
        Rv30=((V *)Rv32)[5];
      }
      Ra.sl[3]=2841; /* line # 2841 */
      Rv33=Rv2+Rv6;
      Rv34=Rv3+Rv7;
      Ra.sl[3]=2842; /* line # 2842 */
      Rv35=Rv33*Rv28+((F)1.000000E+00-Rv28)*Rv34;
      Ra.sl[3]=2843; /* line # 2843 */
      Rv36=Rv34*Rv31+((F)1.000000E+00-Rv31)*Rv33;
      Ra.sl[3]=2844; /* line # 2844 */
      if (Lx[4].sl[9]==0) {
        Ra.sl[3]=2845; /* line # 2845 */
        V_fcalc2=sqrt(Rv35);
        V_fcalc2s=sqrt(Rv36);
      }
      else {
        Ra.sl[3]=2847; /* line # 2847 */
        if (Lx[4].ub[44]) {
          Ra.sl[3]=2849; /* line # 2849 */
          V_fcalc2=V_fcalc2+(float)Lx[4].sl[10]*Rv35;
          Ra.sl[3]=2850; /* line # 2850 */
          V_fcalc2s=V_fcalc2s+(float)Lx[4].sl[10]*Rv36;
        }
        else {
          Ra.sl[3]=2852; /* line # 2852 */
          V_fcalc2=(float)Lx[4].sl[10]*Rv35;
          V_fcalc2s=(float)Lx[4].sl[10]*Rv36;
        }
      }
      Ra.sl[3]=2855; /* line # 2855 */
      Rv8=Rs.sl[1081];
      Rv9=Rs.sl[1082];
      Rv10=Rs.sl[1086];
      Rv11=Rs.sl[1089];
      Ra.sl[3]=2856; /* line # 2856 */
      Rv14=Rs.sl[1084];
      Rv15=Rs.sl[1087];
      Ra.sl[3]=2857; /* line # 2857 */
      for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
        Ra.sl[3]=2859; /* line # 2859 */
        Rv37=Rs.f[Rv8+1093]+Rs.f[Rv10+1093];
        Rv38=Rs.f[Rv9+1093]+Rs.f[Rv11+1093];
        Ra.sl[3]=2860; /* line # 2860 */
        Rs.f[Rv14+1093]=Rv28*(Rv37-Rv38)+Rv38;
        Rs.f[Rv15+1093]=Rv31*(Rv38-Rv37)+Rv37;
        Ra.sl[3]=2861; /* line # 2861 */
        Rv8=Rv8+1;
        Rv9=Rv9+1;
        Rv10=Rv10+1;
        Rv11=Rv11+1;
        Ra.sl[3]=2862; /* line # 2862 */
        Rv14=Rv14+1;
        Rv15=Rv15+1;
      }
      Ra.sl[3]=2864; /* line # 2864 */
      while (Rv27!=NULL){
        Ra.sl[3]=2866; /* line # 2866 */
        Rv39=Rv27;
        Ra.sl[3]=2867; /* line # 2867 */
        Rv40=(((SL *)((V *)Rv39)[1])[5]+Rs.sl[1084])-1;
        Ra.sl[3]=2868; /* line # 2868 */
        Rs.f[Rv40+1093]=Rs.f[Rv40+1093]+((F *)Rv39)[2]*(Rv33-Rv34);
        Ra.sl[3]=2870; /* line # 2870 */
        Rv27=((V *)Rv27)[0];
      }
      Ra.sl[3]=2872; /* line # 2872 */
      while (Rv27!=NULL){
        Ra.sl[3]=2874; /* line # 2874 */
        Rv41=Rv30;
        Ra.sl[3]=2875; /* line # 2875 */
        Rv40=(((SL *)((V *)Rv41)[1])[5]+Rs.sl[1087])-1;
        Ra.sl[3]=2876; /* line # 2876 */
        Rs.f[Rv40+1093]=Rs.f[Rv40+1093]+((F *)Rv41)[2]*(Rv34-Rv33);
        Ra.sl[3]=2878; /* line # 2878 */
        Rv30=((V *)Rv30)[0];
      }
      Ra.sl[3]=2880; /* line # 2880 */
      Rv8=Rs.sl[1084];
      Rv9=Rs.sl[1087];
      Ra.sl[3]=2881; /* line # 2881 */
      Rv12=Rs.sl[1080];
      Rv13=Rs.sl[1071];
      Ra.sl[3]=2882; /* line # 2882 */
      if (F_ip==2) {
        Ra.sl[3]=2884; /* line # 2884 */
        Rv13=Rv12;
        Rv12=Rs.sl[1071];
        Ra.sl[3]=2885; /* line # 2885 */
        V_fcalc2=V_fcalc2s;
      }
      Ra.sl[3]=2887; /* line # 2887 */
      for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
        Ra.sl[3]=2889; /* line # 2889 */
        Rv42=Rs.f[Rv8+1093];
        Rv43=Rs.f[Rv9+1093];
        Ra.sl[3]=2890; /* line # 2890 */
        if (Lx[4].sl[9]==0) {
          Ra.sl[3]=2892; /* line # 2892 */
          Rs.f[Rv12+1093]=(Rv42/V_fcalc2)/(F)2.000000E+00;
          Ra.sl[3]=2893; /* line # 2893 */
          Rs.f[Rv13+1093]=(Rv43/V_fcalc2s)/(F)2.000000E+00;
        }
        else {
          Ra.sl[3]=2895; /* line # 2895 */
          if (Lx[4].ub[44]) {
            Ra.sl[3]=2897; /* line # 2897 */
            Rs.f[Rv12+1093]=Rs.f[Rv12+1093]+(float)Lx[4].sl[10]*Rv42;
            Ra.sl[3]=2898; /* line # 2898 */
            Rs.f[Rv13+1093]=Rs.f[Rv13+1093]+(float)Lx[4].sl[10]*Rv43;
          }
          else {
            Ra.sl[3]=2900; /* line # 2900 */
            Rs.f[Rv12+1093]=(float)Lx[4].sl[10]*Rv42;
            Rs.f[Rv13+1093]=(float)Lx[4].sl[10]*Rv43;
          }
        }
        Ra.sl[3]=2902; /* line # 2902 */
        Rv8=Rv8+1;
        Rv9=Rv9+1;
        Rv10=Rv10+1;
        Rv11=Rv11+1;
        Ra.sl[3]=2903; /* line # 2903 */
        Rv12=Rv12+1;
        Rv13=Rv13+1;
      }
      Ra.sl[3]=2906; /* line # 2906 */
      if (V_cdrec.sl[6]>0) {
        Ra.sl[3]=2907; /* line # 2907 */
        if (F_ip!=3) V_fstr=V_fcalc2;
        else {
          Ra.sl[3]=2909; /* line # 2909 */
          if (V_fcalc2s<(F)1.000000E-05) V_fcalc2s=(F)1.000000E-05;
          Ra.sl[3]=2910; /* line # 2910 */
          V_fstr=V_fcalc2/V_fcalc2s;
          Ra.sl[3]=2911; /* line # 2911 */
          Rv8=Rs.sl[1080];
          Rv9=Rs.sl[1071];
          Ra.sl[3]=2912; /* line # 2912 */
          for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
            Ra.sl[3]=2914; /* line # 2914 */
            Rs.f[Rv8+1093]=(Rs.f[Rv8+1093]*V_fcalc2s-V_fcalc2*Rs.f[Rv9+1093])/(V_fcalc2s*
            V_fcalc2s);
            Ra.sl[3]=2915; /* line # 2915 */
            Rv8=Rv8+1;
            Rv9=Rv9+1;
          }
        }
      }
    }
    else {
      Ra.sl[3]=2921; /* line # 2921 */
      switch (F_ip) {
        case 0:
        case 1:
        case 2:
        case 3:break;
        case 4:Ra.sl[3]=2923; /* line # 2923 */
        Rv12=Rs.sl[1081];
        Rv33=Rv2;
        break;
        case 5:Ra.sl[3]=2924; /* line # 2924 */
        Rv12=Rs.sl[1082];
        Rv33=Rv3;
        break;
        case 6:Ra.sl[3]=2925; /* line # 2925 */
        Rv12=Rs.sl[1086];
        Rv33=Rv6;
        break;
        case 7:Ra.sl[3]=2926; /* line # 2926 */
        Rv12=Rs.sl[1089];
        Rv33=Rv7;
        break;
      }
      Ra.sl[3]=2928; /* line # 2928 */
      if (Lx[4].sl[9]==0) {
        Ra.sl[3]=2929; /* line # 2929 */
        V_fcalc2=sqrt(Rv33);
      }
      else {
        Ra.sl[3]=2931; /* line # 2931 */
        if (Lx[4].ub[44]) {
          Ra.sl[3]=2932; /* line # 2932 */
          V_fcalc2=V_fcalc2+(float)Lx[4].sl[10]*Rv33;
        }
        else {
          Ra.sl[3]=2934; /* line # 2934 */
          V_fcalc2=(float)Lx[4].sl[10]*Rv33;
        }
      }
      Ra.sl[3]=2935; /* line # 2935 */
      V_fstr=V_fcalc2;
      Ra.sl[3]=2936; /* line # 2936 */
      Rv8=Rs.sl[1080];
      Ra.sl[3]=2937; /* line # 2937 */
      for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
        Ra.sl[3]=2939; /* line # 2939 */
        if (Lx[4].sl[9]==0) {
          Ra.sl[3]=2940; /* line # 2940 */
          Rs.f[Rv8+1093]=Rs.f[Rv8+1093]/((F)2.000000E+00*V_fcalc2);
        }
        else {
          Ra.sl[3]=2942; /* line # 2942 */
          if (Lx[4].ub[44]) {
            Ra.sl[3]=2943; /* line # 2943 */
            Rs.f[Rv8+1093]=Rs.f[Rv8+1093]+(float)Lx[4].sl[10]*Rs.f[Rv12+1093];
          }
          else {
            Ra.sl[3]=2945; /* line # 2945 */
            Rs.f[Rv8+1093]=(float)Lx[4].sl[10]*Rs.f[Rv12+1093];
          }
        }
        Ra.sl[3]=2946; /* line # 2946 */
        Rv8=Rv8+1;
        Rv12=Rv12+1;
      }
    }
    Ra.sl[3]=2950; /* line # 2950 */
    if (V_contrhde!=NULL) {
      Ra.sl[3]=2952; /* line # 2952 */
      V_ccontr=V_contrhde;
      Ra.sl[3]=2953; /* line # 2953 */
      while (V_ccontr!=NULL){
        Ra.sl[3]=2955; /* line # 2955 */
        Rv44=V_ccontr;
        Ra.sl[3]=2957; /* line # 2957 */
        if (((V *)V_cdata)[6]!=NULL) {
          Ra.sl[3]=2959; /* line # 2959 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+6,((F *)Rv44)[6],((V *)V_cdata)[6],Rs.sl[
1081],Rs.sl[1081],0,0,0);
          Ra.sl[3]=2961; /* line # 2961 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+7,((F *)Rv44)[7],((V *)V_cdata)[6],Rs.sl[
1082],Rs.sl[1082],0,0,0);
        }
        Ra.sl[3]=2964; /* line # 2964 */
        if (((V *)V_cdata)[7]!=NULL) {
          Ra.sl[3]=2966; /* line # 2966 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+8,((F *)Rv44)[8],((V *)V_cdata)[7],Rs.sl[
1084],Rs.sl[1084],0,0,0);
          Ra.sl[3]=2968; /* line # 2968 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+9,((F *)Rv44)[9],((V *)V_cdata)[7],Rs.sl[
1085],Rs.sl[1085],0,0,0);
          Ra.sl[3]=2970; /* line # 2970 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+10,((F *)Rv44)[10],((V *)V_cdata)[7],Rs.sl[
1086],Rs.sl[1086],0,0,0);
          Ra.sl[3]=2972; /* line # 2972 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+11,((F *)Rv44)[11],((V *)V_cdata)[7],Rs.sl[
1087],Rs.sl[1087],0,0,0);
          Ra.sl[3]=2974; /* line # 2974 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+12,((F *)Rv44)[12],((V *)V_cdata)[7],Rs.sl[
1088],Rs.sl[1088],0,0,0);
          Ra.sl[3]=2976; /* line # 2976 */
          MXD_LSQ_cpf2corr(((F *)Rv44)+13,((F *)Rv44)[13],((V *)V_cdata)[7],Rs.sl[
1089],Rs.sl[1089],0,0,0);
        }
        Ra.sl[3]=2979; /* line # 2979 */
        Rv0=(((F *)Rv44)[8]*F_px+((F *)Rv44)[9]*F_py)+((F *)Rv44)[10]*F_pz;
        Rv1=(((F *)Rv44)[11]*F_px+((F *)Rv44)[12]*F_py)+((F *)Rv44)[13]*F_pz;
        Ra.sl[3]=2980; /* line # 2980 */
        Rv2=(Rv22*(PAS__F_SQR(((F *)Rv44)[6]+(F)2.695000E-01*Rv0)+PAS__F_SQR(((F
         *)Rv44)[7]+(F)2.695000E-01*Rv1)))/(F)2.000000E+00;
        Ra.sl[3]=2982; /* line # 2982 */
        Rv3=(Rv23*(PAS__F_SQR(((F *)Rv44)[6]-(F)2.695000E-01*Rv0)+PAS__F_SQR(((F
         *)Rv44)[7]-(F)2.695000E-01*Rv1)))/(F)2.000000E+00;
        Ra.sl[3]=2984; /* line # 2984 */
        if (F_ip<4||F_ip>5) {
          Ra.sl[3]=2986; /* line # 2986 */
          Rv4=(F)3.631500E-02*(((((((PAS__F_SQR(((F *)Rv44)[8])+PAS__F_SQR(((F *)
          Rv44)[9]))+PAS__F_SQR(((F *)Rv44)[10]))+PAS__F_SQR(((F *)Rv44)[11]))+PAS__F_SQR
          (((F *)Rv44)[12]))+PAS__F_SQR(((F *)Rv44)[13]))-Rv0*Rv0)-Rv1*Rv1);
          Ra.sl[3]=2989; /* line # 2989 */
          Rv5=(F)7.263000E-02*((((((F_px*((F *)Rv44)[9])*((F *)Rv44)[13]+(F_py*(
          (F *)Rv44)[10])*((F *)Rv44)[11])+(F_pz*((F *)Rv44)[8])*((F *)Rv44)[12]
          )-(F_px*((F *)Rv44)[10])*((F *)Rv44)[12])-(F_py*((F *)Rv44)[8])*((F *)
          Rv44)[13])-(F_pz*((F *)Rv44)[9])*((F *)Rv44)[11]);
          Ra.sl[3]=2991; /* line # 2991 */
          Rv6=Rv24*(Rv4-Rv5);
          Rv7=Rv25*(Rv4+Rv5);
        }
        Ra.sl[3]=2993; /* line # 2993 */
        switch (F_ip) {
          case 0:break;
          case 1:Ra.sl[3]=2995; /* line # 2995 */
          Rv35=Rv28*(Rv2+Rv6)+((F)1.000000E+00-Rv28)*(Rv3+Rv7);
          break;
          case 2:Ra.sl[3]=2996; /* line # 2996 */
          Rv35=Rv31*(Rv3+Rv7)+((F)1.000000E+00-Rv31)*(Rv2+Rv6);
          break;
          case 3:Ra.sl[3]=2999; /* line # 2999 */
          Rv37=Rv2+Rv6;
          Ra.sl[3]=3000; /* line # 3000 */
          Rv38=Rv3+Rv7;
          Ra.sl[3]=3001; /* line # 3001 */
          Rv35=Rv28*Rv37+((F)1.000000E+00-Rv28)*Rv38;
          Ra.sl[3]=3002; /* line # 3002 */
          Rv36=Rv31*Rv38+((F)1.000000E+00-Rv31)*Rv37;
          Ra.sl[3]=3003; /* line # 3003 */
          if (Lx[4].sl[9]==0) {
            Ra.sl[3]=3004; /* line # 3004 */
            ((F *)Rv44)[4]=sqrt(Rv35);
            ((F *)Rv44)[5]=sqrt(Rv36);
          }
          else {
            Ra.sl[3]=3006; /* line # 3006 */
            if (Lx[4].ub[44]) {
              Ra.sl[3]=3007; /* line # 3007 */
              ((F *)Rv44)[4]=((F *)Rv44)[4]+(float)Lx[4].sl[10]*Rv35;
              Ra.sl[3]=3008; /* line # 3008 */
              ((F *)Rv44)[5]=((F *)Rv44)[5]+(float)Lx[4].sl[10]*Rv36;
            }
            else {
              Ra.sl[3]=3010; /* line # 3010 */
              ((F *)Rv44)[4]=(float)Lx[4].sl[10]*Rv35;
              ((F *)Rv44)[5]=(float)Lx[4].sl[10]*Rv36;
            }
          }
          break;
          case 4:Ra.sl[3]=3013; /* line # 3013 */
          Rv35=Rv2;
          break;
          case 5:Ra.sl[3]=3014; /* line # 3014 */
          Rv35=Rv3;
          break;
          case 6:Ra.sl[3]=3015; /* line # 3015 */
          Rv35=Rv6;
          break;
          case 7:Ra.sl[3]=3016; /* line # 3016 */
          Rv35=Rv7;
          break;
        }
        Ra.sl[3]=3018; /* line # 3018 */
        if (F_ip!=3) {
          Ra.sl[3]=3019; /* line # 3019 */
          if (Lx[4].sl[9]==0) ((F *)Rv44)[4]=sqrt(Rv35);
          else {
            Ra.sl[3]=3020; /* line # 3020 */
            if (Lx[4].ub[44]) ((F *)Rv44)[4]=((F *)Rv44)[4]+(float)Lx[4].sl[10]*
            Rv35;
            else {
              Ra.sl[3]=3021; /* line # 3021 */
              ((F *)Rv44)[4]=(float)Lx[4].sl[10]*Rv35;
            }
          }
        }
        else {
          Ra.sl[3]=3023; /* line # 3023 */
          if (V_cdrec.sl[6]>0) {
            Ra.sl[3]=3024; /* line # 3024 */
            if (((F *)Rv44)[5]<(F)1.000000E-05) ((F *)Rv44)[5]=(F)1.000000E-05;
            Ra.sl[3]=3025; /* line # 3025 */
            ((F *)Rv44)[4]=((F *)Rv44)[4]/((F *)Rv44)[5];
          }
        }
        Ra.sl[3]=3029; /* line # 3029 */
        V_ccontr=((V *)V_ccontr)[1];
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " strfac "  */
void MXD_LSQ_PRC_00000004(SL F_isp, SL F_mltg, UB F_ba, UB F_bmatrix){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  SL Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  SL Rv21;
  register V Rv22;
  register int Rgi;
  register int Rgj;
  register F Rgf;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.sl[9]=F_isp;
  Ra.sl[10]=F_mltg;
  Ra.ub[44]=F_ba;
  Ra.ub[45]=F_bmatrix;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+20;
  Ra.v[6]=Rd.s+2548;
  Ra.v[7]=Rd.s+17;
  Ra.sl[8]=3039; /* line # 3039 */
  Rs.ub[509376]=1;
  Rs.ub[509377]=1;
  Ra.sl[8]=3040; /* line # 3040 */
  Ra.sl[8]=3041; /* line # 3041 */
  if (V_cdrec.sl[5]!=-1&&V_cdrec.sl[4]!=0) {
    Ra.sl[8]=3042; /* line # 3042 */
    Rv0=V_cwave;
    Ra.sl[8]=3044; /* line # 3044 */
    V_hh=V_hc+(float)V_cdrec.sl[4]*((F *)Rv0)[7];
    Ra.sl[8]=3045; /* line # 3045 */
    V_kk=V_kc+(float)V_cdrec.sl[4]*((F *)Rv0)[8];
    Ra.sl[8]=3046; /* line # 3046 */
    V_ll=V_lc+(float)V_cdrec.sl[4]*((F *)Rv0)[9];
  }
  else {
    Ra.sl[8]=3048; /* line # 3048 */
    V_hh=V_hc;
    V_kk=V_kc;
    V_ll=V_lc;
  }
  Ra.sl[8]=3050; /* line # 3050 */
  MXD_LSQ_parmderval(2);
  Ra.sl[8]=3054; /* line # 3054 */
  Rv1=Rs.sl[1081];
  for( Rf0=(Rs.sl[1092]+1)-Rs.sl[1081];Rf0>0;Rf0-- ) {
    Rs.f[Rv1+1093]=(F)0.000000E-01;
    Rv1++;
  }
  Ra.sl[8]=3056; /* line # 3056 */
  V_fnr=(F)0.000000E-01;
  V_fni=(F)0.000000E-01;
  Ra.sl[8]=3057; /* line # 3057 */
  if (V_momhde!=NULL) {
    Ra.sl[8]=3059; /* line # 3059 */
    V_fxr=(F)0.000000E-01;
    V_fyr=(F)0.000000E-01;
    V_fzr=(F)0.000000E-01;
    Ra.sl[8]=3060; /* line # 3060 */
    V_fxi=(F)0.000000E-01;
    V_fyi=(F)0.000000E-01;
    V_fzi=(F)0.000000E-01;
  }
  Ra.sl[8]=3063; /* line # 3063 */
  if (V_contrhde!=NULL) {
    Ra.sl[8]=3065; /* line # 3065 */
    V_ccontr=V_contrhde;
    Ra.sl[8]=3066; /* line # 3066 */
    while (V_ccontr!=NULL){
      Ra.sl[8]=3068; /* line # 3068 */
      Rv2=V_ccontr;
      Ra.sl[8]=3070; /* line # 3070 */
      ((F *)Rv2)[6]=(F)0.000000E-01;
      ((F *)Rv2)[7]=(F)0.000000E-01;
      Ra.sl[8]=3071; /* line # 3071 */
      ((F *)Rv2)[8]=(F)0.000000E-01;
      ((F *)Rv2)[9]=(F)0.000000E-01;
      ((F *)Rv2)[10]=(F)0.000000E-01;
      Ra.sl[8]=3072; /* line # 3072 */
      ((F *)Rv2)[11]=(F)0.000000E-01;
      ((F *)Rv2)[12]=(F)0.000000E-01;
      ((F *)Rv2)[13]=(F)0.000000E-01;
      Ra.sl[8]=3074; /* line # 3074 */
      V_ccontr=((V *)V_ccontr)[1];
    }
  }
  Ra.sl[8]=3078; /* line # 3078 */
  if (V_latticenb!=1) {
    Ra.sl[8]=3079; /* line # 3079 */
    Ra.sl[8]=3080; /* line # 3080 */
    switch (V_latticenb) {
      case 1:Ra.sl[8]=3082; /* line # 3082 */
      Ra.ub[17]=1;
      break;
      case 2:Ra.sl[8]=3083; /* line # 3083 */
      Ra.ub[17]=!(V_cdrec.sl[1]+V_cdrec.sl[2]&1);
      break;
      case 3:Ra.sl[8]=3084; /* line # 3084 */
      Ra.ub[17]=!(V_cdrec.sl[2]+V_cdrec.sl[0]&1);
      break;
      case 4:Ra.sl[8]=3085; /* line # 3085 */
      Ra.ub[17]=!(V_cdrec.sl[0]+V_cdrec.sl[1]&1);
      break;
      case 5:Ra.sl[8]=3086; /* line # 3086 */
      Ra.ub[17]=!((V_cdrec.sl[0]+V_cdrec.sl[1])+V_cdrec.sl[2]&1);
      break;
      case 6:Ra.sl[8]=3087; /* line # 3087 */
      Ra.ub[17]=PAS__I_MOD(( -V_cdrec.sl[0]+V_cdrec.sl[1])+V_cdrec.sl[2],3)==0;
      break;
      case 7:Ra.sl[8]=3088; /* line # 3088 */
      Ra.ub[17]=!(V_cdrec.sl[0]+V_cdrec.sl[1]&1)&&!(V_cdrec.sl[1]+V_cdrec.sl[2]&1
      );
      break;
    }
  }
  else {
    Ra.sl[8]=3090; /* line # 3090 */
    Ra.ub[17]=1;
  }
  Ra.sl[8]=3092; /* line # 3092 */
  if (Ra.ub[17]) {
    Ra.sl[8]=3094; /* line # 3094 */
    if (V_atomhde!=V_atmshde) {
      Ra.sl[8]=3096; /* line # 3096 */
      V_csymtry=V_symhde;
      Ra.ub[16]=V_bcentric;
      Ra.sl[8]=3097; /* line # 3097 */
      while (V_csymtry!=NULL){
        Ra.sl[8]=3099; /* line # 3099 */
        MXD_LSQ_PRC_00000005();
        MXD_LSQ_parmderval(3);
        Ra.sl[8]=3100; /* line # 3100 */
        V_catome=V_atomhde;
        Ra.sl[8]=3101; /* line # 3101 */
        while (V_catome!=V_atmshde){
          Ra.sl[8]=3103; /* line # 3103 */
          MXD_LSQ_PRC_00000006();
          Ra.sl[8]=3104; /* line # 3104 */
          V_catome=((V *)V_catome)[1];
        }
        Ra.sl[8]=3106; /* line # 3106 */
        V_csymtry=((V *)V_csymtry)[1];
      }
    }
    Ra.sl[8]=3109; /* line # 3109 */
    if (V_atmshde!=NULL) {
      Ra.sl[8]=3111; /* line # 3111 */
      Ra.ub[16]=0;
      Ra.sl[8]=3112; /* line # 3112 */
      Ra.f[0]=(F)0.000000E-01;
      Ra.sl[8]=3113; /* line # 3113 */
      MXD_LSQ_parmderval(3);
      Ra.sl[8]=3114; /* line # 3114 */
      if (V_cwave!=NULL) Ra.ub[17]=((UB *)V_cwave)[40];
      else Ra.ub[17]=0;
      Ra.sl[8]=3115; /* line # 3115 */
      if (Ra.ub[17]) {
        Ra.sl[8]=3116; /* line # 3116 */
        Rv3=V_cwave;
        Ra.sl[8]=3118; /* line # 3118 */
        V_h1=(float)(6.283185299999999E+000*(double)(V_hr+(float)V_cdrec.sl[4]*(
        (F *)Rv3)[4]));
        V_k1=(float)(6.283185299999999E+000*(double)(V_kr+(float)V_cdrec.sl[4]*(
        (F *)Rv3)[5]));
        Ra.sl[8]=3119; /* line # 3119 */
        V_l1=(float)(6.283185299999999E+000*(double)(V_lr+(float)V_cdrec.sl[4]*(
        (F *)Rv3)[6]));
        V_h2=(float)(6.283185299999999E+000*(double)V_hh);
        V_k2=(float)(6.283185299999999E+000*(double)V_kk);
        V_l2=(float)(6.283185299999999E+000*(double)V_ll);
      }
      else {
        Ra.sl[8]=3123; /* line # 3123 */
        V_h1=(float)(6.283185299999999E+000*(double)V_hr);
        V_k1=(float)(6.283185299999999E+000*(double)V_kr);
        V_l1=(float)(6.283185299999999E+000*(double)V_lr);
        Ra.sl[8]=3124; /* line # 3124 */
        V_h2=(float)(6.283185299999999E+000*(double)V_hc);
        V_k2=(float)(6.283185299999999E+000*(double)V_kc);
        V_l2=(float)(6.283185299999999E+000*(double)V_lc);
      }
      Ra.sl[8]=3126; /* line # 3126 */
      V_catome=V_atmshde;
      Ra.sl[8]=3127; /* line # 3127 */
      while (V_catome!=NULL){
        Ra.sl[8]=3129; /* line # 3129 */
        MXD_LSQ_PRC_00000006();
        Ra.sl[8]=3130; /* line # 3130 */
        V_catome=((V *)V_catome)[1];
      }
    }
  }
  Ra.sl[8]=3136; /* line # 3136 */
  V_fnucl2=V_fnr*V_fnr+V_fni*V_fni;
  Ra.sl[8]=3137; /* line # 3137 */
  if (V_virtvtab.v[1]!=NULL) ((F *)V_virtvtab.v[1])[7]=V_fnucl2;
  Ra.sl[8]=3138; /* line # 3138 */
  Rv4=Rs.sl[1081];
  Rv5=Rs.sl[1082];
  Ra.sl[8]=3139; /* line # 3139 */
  Rv6=Rs.sl[1083];
  Ra.sl[8]=3140; /* line # 3140 */
  if (Ra.ub[45]) {
    Ra.sl[8]=3141; /* line # 3141 */
    for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
      Ra.sl[8]=3143; /* line # 3143 */
      Rs.f[Rv6+1093]=(F)2.000000E+00*(V_fnr*Rs.f[Rv4+1093]+V_fni*Rs.f[Rv5+1093])
      ;
      Ra.sl[8]=3144; /* line # 3144 */
      Rv4=Rv4+1;
      Rv5=Rv5+1;
      Rv6=Rv6+1;
    }
  }
  Ra.sl[8]=3147; /* line # 3147 */
  if (V_momhde!=NULL&&V_magsel.ub[V_cselect]) {
    Ra.sl[8]=3148; /* line # 3148 */
    Ra.sl[8]=3151; /* line # 3151 */
    V_fmxr=V_fxr;
    V_fmyr=V_fyr;
    V_fmzr=V_fzr;
    Ra.sl[8]=3152; /* line # 3152 */
    V_fmxi=V_fxi;
    V_fmyi=V_fyi;
    V_fmzi=V_fzi;
    Ra.sl[8]=3154; /* line # 3154 */
    Rv7=V_hh/Lx[5].f[0];
    Rv8=V_kk/Lx[5].f[0];
    Rv9=V_ll/Lx[5].f[0];
    Ra.sl[8]=3155; /* line # 3155 */
    MXD_LSQ_PRC_00000011(&V_fxr, &V_fyr, &V_fzr, Rv7, Rv8, Rv9);
    Ra.sl[8]=3156; /* line # 3156 */
    MXD_LSQ_PRC_00000011(&V_fxi, &V_fyi, &V_fzi, Rv7, Rv8, Rv9);
    Ra.sl[8]=3157; /* line # 3157 */
    V_fmag2=(F)7.263000E-02*(((((V_fxr*V_fxr+V_fyr*V_fyr)+V_fzr*V_fzr)+V_fxi*V_fxi)
    +V_fyi*V_fyi)+V_fzi*V_fzi);
    Ra.sl[8]=3159; /* line # 3159 */
    if (Ra.ub[45]) {
      Ra.sl[8]=3161; /* line # 3161 */
      Rv10=Rs.sl[1090];
      Ra.sl[8]=3162; /* line # 3162 */
      Rv4=Rs.sl[1084];
      Rv5=Rs.sl[1085];
      Rv11=Rs.sl[1086];
      Ra.sl[8]=3163; /* line # 3163 */
      Rv12=Rs.sl[1087];
      Rv13=Rs.sl[1088];
      Rv14=Rs.sl[1089];
      Ra.sl[8]=3164; /* line # 3164 */
      for( Rf0=V_varnb;Rf0>0;Rf0-- ) {
        Ra.sl[8]=3166; /* line # 3166 */
        MXD_LSQ_PRC_00000011((Rs.f+Rv4+1093),(Rs.f+Rv5+1093),(Rs.f+Rv11+1093),Rv7,
        Rv8, Rv9);
        Ra.sl[8]=3167; /* line # 3167 */
        MXD_LSQ_PRC_00000011((Rs.f+Rv12+1093),(Rs.f+Rv13+1093),(Rs.f+Rv14+1093),
        Rv7, Rv8, Rv9);
        Ra.sl[8]=3168; /* line # 3168 */
        Rs.f[Rv10+1093]=(F)1.452600E-01*(((((V_fxr*Rs.f[Rv4+1093]+V_fyr*Rs.f[Rv5+
1093])+V_fzr*Rs.f[Rv11+1093])+V_fxi*Rs.f[Rv12+1093])+V_fyi*Rs.f[Rv13+1093])+V_fzi*
        Rs.f[Rv14+1093]);
        Ra.sl[8]=3170; /* line # 3170 */
        Rv4=Rv4+1;
        Rv5=Rv5+1;
        Rv11=Rv11+1;
        Ra.sl[8]=3171; /* line # 3171 */
        Rv12=Rv12+1;
        Rv13=Rv13+1;
        Rv14=Rv14+1;
        Ra.sl[8]=3172; /* line # 3172 */
        Rv10=Rv10+1;
      }
    }
    Ra.sl[8]=3176; /* line # 3176 */
    if (V_contrhde!=NULL) {
      Ra.sl[8]=3178; /* line # 3178 */
      V_ccontr=V_contrhde;
      Ra.sl[8]=3179; /* line # 3179 */
      while (V_ccontr!=NULL){
        Ra.sl[8]=3181; /* line # 3181 */
        Rv15=V_ccontr;
        Ra.sl[8]=3183; /* line # 3183 */
        MXD_LSQ_PRC_00000011(((F *)Rv15)+8,((F *)Rv15)+9,((F *)Rv15)+10,Rv7, Rv8,
        Rv9);
        Ra.sl[8]=3184; /* line # 3184 */
        MXD_LSQ_PRC_00000011(((F *)Rv15)+11,((F *)Rv15)+12,((F *)Rv15)+13,Rv7, Rv8,
        Rv9);
        Ra.sl[8]=3186; /* line # 3186 */
        V_ccontr=((V *)V_ccontr)[1];
      }
    }
    Ra.sl[8]=3189; /* line # 3189 */
    if (V_virtvtab.v[2]!=NULL) ((F *)V_virtvtab.v[2])[7]=V_fmag2;
  }
  else {
    Ra.sl[8]=3192; /* line # 3192 */
    V_fmag2=(F)0.000000E-01;
    Ra.sl[8]=3193; /* line # 3193 */
    if (V_virtvtab.v[2]!=NULL) ((F *)V_virtvtab.v[2])[7]=(F)0.000000E-01;
  }
  Ra.sl[8]=3196; /* line # 3196 */
  MXD_LSQ_parmderval(4);
  Ra.sl[8]=3197; /* line # 3197 */
  if (((V_cdrec.sl[8]<=0||V_cnpola==NULL)||V_momhde==NULL)||!V_magsel.ub[V_cselect]
  ) {
    Ra.sl[8]=3201; /* line # 3201 */
    if (V_momhde!=NULL&&V_magsel.ub[V_cselect]) {
      Ra.sl[8]=3203; /* line # 3203 */
      MXD_LSQ_cpf2corr(&V_fcalc2, V_fmag2,((V *)V_cdata)[7],Rs.sl[1090],Rs.sl[1082]
      ,0, Ra.ub[45],0);
      Ra.sl[8]=3205; /* line # 3205 */
      MXD_LSQ_cpf2corr(&V_fcalc2, V_fnucl2,((V *)V_cdata)[6],Rs.sl[1083],Rs.sl[1082]
      ,1, Ra.ub[45],0);
      Ra.sl[8]=3207; /* line # 3207 */
      if (V_contrhde!=NULL) {
        Ra.sl[8]=3209; /* line # 3209 */
        V_ccontr=V_contrhde;
        Ra.sl[8]=3210; /* line # 3210 */
        while (V_ccontr!=NULL){
          Ra.sl[8]=3212; /* line # 3212 */
          Rv16=V_ccontr;
          Ra.sl[8]=3214; /* line # 3214 */
          Ra.f[1]=(F)7.263000E-02*(((((PAS__F_SQR(((F *)Rv16)[8])+PAS__F_SQR(((F
           *)Rv16)[9]))+PAS__F_SQR(((F *)Rv16)[10]))+PAS__F_SQR(((F *)Rv16)[11])
          )+PAS__F_SQR(((F *)Rv16)[12]))+PAS__F_SQR(((F *)Rv16)[13]));
          Ra.sl[8]=3216; /* line # 3216 */
          Ra.f[2]=PAS__F_SQR(((F *)Rv16)[6])+PAS__F_SQR(((F *)Rv16)[7]);
          Ra.sl[8]=3217; /* line # 3217 */
          MXD_LSQ_cpf2corr(((F *)Rv16)+6,Ra.f[1],((V *)V_cdata)[7],Rs.sl[1090],Rs
          .sl[1082],0,0,0);
          Ra.sl[8]=3219; /* line # 3219 */
          MXD_LSQ_cpf2corr(((F *)Rv16)+6,Ra.f[2],((V *)V_cdata)[6],Rs.sl[1083],Rs
          .sl[1082],1,0,0);
          Ra.sl[8]=3221; /* line # 3221 */
          if (Ra.sl[9]==0) ((F *)Rv16)[4]=sqrt(((F *)Rv16)[6]);
          else {
            Ra.sl[8]=3222; /* line # 3222 */
            if (Ra.ub[44]) ((F *)Rv16)[4]=((F *)Rv16)[4]+(float)Ra.sl[10]*((F *)
            Rv16)[6];
            else {
              Ra.sl[8]=3223; /* line # 3223 */
              ((F *)Rv16)[4]=(float)Ra.sl[10]*((F *)Rv16)[6];
            }
          }
          Ra.sl[8]=3225; /* line # 3225 */
          V_ccontr=((V *)V_ccontr)[1];
        }
      }
    }
    else {
      Ra.sl[8]=3230; /* line # 3230 */
      MXD_LSQ_cpf2corr(&V_fcalc2, V_fnucl2,((V *)V_cdata)[6],Rs.sl[1083],Rs.sl[1082]
      ,0, Ra.ub[45],0);
      Ra.sl[8]=3232; /* line # 3232 */
      if (V_contrhde!=NULL) {
        Ra.sl[8]=3234; /* line # 3234 */
        V_ccontr=V_contrhde;
        Ra.sl[8]=3235; /* line # 3235 */
        while (V_ccontr!=NULL){
          Ra.sl[8]=3237; /* line # 3237 */
          Rv17=V_ccontr;
          Ra.sl[8]=3239; /* line # 3239 */
          Ra.f[1]=PAS__F_SQR(((F *)Rv17)[6])+PAS__F_SQR(((F *)Rv17)[7]);
          Ra.sl[8]=3240; /* line # 3240 */
          MXD_LSQ_cpf2corr(((F *)Rv17)+6,Ra.f[1],((V *)V_cdata)[6],Rs.sl[1083],Rs
          .sl[1082],0,0,0);
          Ra.sl[8]=3242; /* line # 3242 */
          if (Ra.sl[9]==0) ((F *)Rv17)[4]=sqrt(((F *)Rv17)[6]);
          else {
            Ra.sl[8]=3243; /* line # 3243 */
            if (Ra.ub[44]) ((F *)Rv17)[4]=((F *)Rv17)[4]+(float)Ra.sl[10]*((F *)
            Rv17)[6];
            else {
              Ra.sl[8]=3244; /* line # 3244 */
              ((F *)Rv17)[4]=(float)Ra.sl[10]*((F *)Rv17)[6];
            }
          }
          Ra.sl[8]=3246; /* line # 3246 */
          V_ccontr=((V *)V_ccontr)[1];
        }
      }
    }
    Ra.sl[8]=3251; /* line # 3251 */
    if (Ra.sl[9]==0) V_fstr=sqrt(V_fcalc2);
    else {
      Ra.sl[8]=3252; /* line # 3252 */
      if (Ra.ub[44]) V_fstr=V_fstr+(float)Ra.sl[10]*V_fcalc2;
      else V_fstr=(float)Ra.sl[10]*V_fcalc2;
    }
    Ra.sl[8]=3253; /* line # 3253 */
    Rv4=Rs.sl[1082];
    Ra.sl[8]=3254; /* line # 3254 */
    if (Ra.ub[45]) {
      Ra.sl[8]=3255; /* line # 3255 */
      if (Ra.sl[9]==0) {
        Ra.sl[8]=3256; /* line # 3256 */
        if (fabs(V_fcalc2)<(F)1.000000E-05) {
          Ra.sl[8]=3257; /* line # 3257 */
          Rv18=Rs.sl[1080];
          for( Rf0=((Rs.sl[1081]-1)+1)-Rs.sl[1080];Rf0>0;Rf0-- ) {
            Rs.f[Rv18+1093]=(F)0.000000E-01;
            Rv18++;
          }
        }
        else {
          Ra.sl[8]=3259; /* line # 3259 */
          Rv19=Rs.sl[1080];
          for( Rf0=((Rs.sl[1081]-1)+1)-Rs.sl[1080];Rf0>0;Rf0-- ) {
            Ra.sl[8]=3260; /* line # 3260 */
            Rs.f[Rv19+1093]=Rs.f[Rv4+1093]/((F)2.000000E+00*V_fstr);
            Rv4=Rv4+1;
            Rv19++;
          }
        }
      }
      else {
        Ra.sl[8]=3262; /* line # 3262 */
        if (Ra.ub[44]) {
          Ra.sl[8]=3263; /* line # 3263 */
          Rv20=Rs.sl[1080];
          for( Rf0=((Rs.sl[1081]-1)+1)-Rs.sl[1080];Rf0>0;Rf0-- ) {
            Ra.sl[8]=3264; /* line # 3264 */
            Rs.f[Rv20+1093]=Rs.f[Rv20+1093]+(float)Ra.sl[10]*Rs.f[Rv4+1093];
            Rv4=Rv4+1;
            Rv20++;
          }
        }
        else {
          Ra.sl[8]=3266; /* line # 3266 */
          Rv21=Rs.sl[1080];
          for( Rf0=((Rs.sl[1081]-1)+1)-Rs.sl[1080];Rf0>0;Rf0-- ) {
            Ra.sl[8]=3267; /* line # 3267 */
            Rs.f[Rv21+1093]=(float)Ra.sl[10]*Rs.f[Rv4+1093];
            Rv4=Rv4+1;
            Rv21++;
          }
        }
      }
    }
  }
  else {
    Ra.sl[8]=3269; /* line # 3269 */
    Rv22=V_cnpola;
    Ra.sl[8]=3271; /* line # 3271 */
    MXD_LSQ_PRC_00000012(MXD_LSQ_gtvd(((V *)Rv22)[4]),MXD_LSQ_gtvd(((V *)Rv22)[5]
    ),MXD_LSQ_gtvd(((V *)Rv22)[6]),V_refcatsv);
  }
  PAS__curr_cntx=Ra.v[5];
  Lx[4]=Lx_Sv;
}


/* Procedure/Function : " collect "  */
void MXD_LSQ_PRC_00000013(UB F_bmatrix){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  SL Rv13;
  SL Rv14;
  UB Rv15;
  SL Rv16;
  register V Rv17;
  SL Rv18;
  SL Rv19;
  UB Rv20;
  F Rv21;
  SL Rv22;
  SL Rv23;
  F Rv24;
  F Rv25;
  F Rv26;
  V Rv27;
  SL Rv28;
  SL Rv29;
  SL Rv30;
  SL Rv31;
  SL Rv32;
  SL Rv33;
  F Rv34;
  SL Rv35;
  F Rv36;
  register F Rgf;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2556;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=3291; /* line # 3291 */
  V_cdata=V_datahde;
  Lx[5].f[1]=(F)0.000000E-01;
  Ra.sl[3]=3293; /* line # 3293 */
  Rv0=(F)0.000000E-01;
  Ra.sl[3]=3294; /* line # 3294 */
  Rs.f[127345]=(F)0.000000E-01;
  Rs.f[127346]=(F)0.000000E-01;
  Rs.f[127347]=(F)0.000000E-01;
  Rs.f[127348]=(F)0.000000E-01;
  Ra.sl[3]=3295; /* line # 3295 */
  Rs.f[127349]=(F)0.000000E-01;
  Rs.f[127350]=(F)0.000000E-01;
  Rs.f[127351]=(F)0.000000E-01;
  Rs.f[127352]=(F)0.000000E-01;
  Ra.sl[3]=3296; /* line # 3296 */
  V_ncpobs=0;
  Ra.sl[3]=3298; /* line # 3298 */
  if (F_bmatrix) {
    Rv1=1;
    for( Rf2=Rs.sl[1081]-1;Rf2>0;Rf2-- ) {
      Rs.f[Rv1+1093]=(F)0.000000E-01;
      Rv1++;
    }
  }
  Ra.sl[3]=3299; /* line # 3299 */
  MXD_LSQ_clrsumhkl();
  Ra.sl[3]=3300; /* line # 3300 */
  while (V_cdata!=NULL){
    Ra.sl[3]=3302; /* line # 3302 */
    Rv2=V_cdata;
    Ra.sl[3]=3304; /* line # 3304 */
    P_close_bdtfile(&V_idat);
    Ra.sl[3]=3305; /* line # 3305 */
    P_openr_bdtfile(&V_idat,((V *)Rv2)[4]);
    Ra.sl[3]=3306; /* line # 3306 */
    PAS__SELECT_INP(V_idat);
    PAS__READ_BIN(V_cdrec.s);
    Ra.sl[3]=3307; /* line # 3307 */
    if (Rs.ub[4281]) {
      Ra.sl[3]=3309; /* line # 3309 */
      if (Rs.v[1068]==NULL) Rs.v[1068]=PAS__NEW(137);
      else {
        Ra.sl[3]=3310; /* line # 3310 */
        P_close_bcffile(Ri.v+1);
      }
      Ra.sl[3]=3311; /* line # 3311 */
      memcpy(Rs.v[1068],((V *)Rv2)[4],137);
      Ra.sl[3]=3312; /* line # 3312 */
      ((C *)Rs.v[1068])[12]=99;
      Ra.sl[3]=3313; /* line # 3313 */
      ((C *)Rs.v[1068])[13]=102;
      Ra.sl[3]=3314; /* line # 3314 */
      P_open_bcffile(Ri.v+1,Rs.v[1068]);
    }
    Ra.sl[3]=3316; /* line # 3316 */
    if (Rs.ub[4236]) {
      Ra.sl[3]=3318; /* line # 3318 */
      if (Rs.v[1069]==NULL) Rs.v[1069]=PAS__NEW(137);
      else {
        Ra.sl[3]=3319; /* line # 3319 */
        P_close_txtfile(Ri.v+2);
      }
      Ra.sl[3]=3320; /* line # 3320 */
      memcpy(Rs.v[1069],((V *)Rv2)[4],137);
      Ra.sl[3]=3321; /* line # 3321 */
      ((C *)Rs.v[1069])[11]=109;
      Ra.sl[3]=3322; /* line # 3322 */
      ((C *)Rs.v[1069])[12]=107;
      Ra.sl[3]=3323; /* line # 3323 */
      ((C *)Rs.v[1069])[13]=51;
      Ra.sl[3]=3324; /* line # 3324 */
      P_openw_txtfile(Ri.v+2,Rs.v[1069],0);
    }
    Ra.sl[3]=3326; /* line # 3326 */
    Rv3=-1;
    Rv4=-1;
    Ra.sl[3]=3328; /* line # 3328 */
    Rv5=(F)0.000000E-01;
    Rv6=(F)0.000000E-01;
    Rv7=(F)0.000000E-01;
    Rv8=(F)0.000000E-01;
    Ra.sl[3]=3329; /* line # 3329 */
    Rv9=(F)0.000000E-01;
    Rv10=(F)0.000000E-01;
    Rv11=(F)0.000000E-01;
    Rv12=(F)0.000000E-01;
    Ra.sl[3]=3330; /* line # 3330 */
    Rv13=0;
    Rv14=0;
    Ra.sl[3]=3331; /* line # 3331 */
    Rv15=0;
    Ra.sl[3]=3332; /* line # 3332 */
    if (Rs.ub[4129]&&F_bmatrix) {
      Ra.sl[3]=3334; /* line # 3334 */
      P_newparagraphe(25);
      Ra.sl[3]=3335; /* line # 3335 */
      P_newlinelst();
      Ra.sl[3]=3336; /* line # 3336 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2565,-1,-1,32);
      Ra.sl[3]=3337; /* line # 3337 */
      MXD_LSQ_outnameid(((V *)Rv2)[2],16);
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2596,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=3338; /* line # 3338 */
      P_underline(0,37);
      Ra.sl[3]=3339; /* line # 3339 */
      P_skipline(1);
      Ra.sl[3]=3340; /* line # 3340 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+2600,-1,-1,32);
      Ra.sl[3]=3341; /* line # 3341 */
      if (Rs.sl[0]>Rs.sl[1]) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+2622,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[3]=3342; /* line # 3342 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+2641,-1,-1,32);
        PAS__WRITE_INT(Rs.sl[0],4,0);
        PAS__WRITE_EOLN();
      }
      Ra.sl[3]=3343; /* line # 3343 */
      P_skipline(1);
      Ra.sl[3]=3344; /* line # 3344 */
      P_st_put_pastr(V_sbttlpt,Rd.s+2654);
      Ra.sl[3]=3345; /* line # 3345 */
      if (Rs.ub[4232]) P_st_put_pastr(V_sbttlpt,Rd.s+2661);
      else {
        Ra.sl[3]=3347; /* line # 3347 */
        if (V_polhde!=NULL) P_st_put_pastr(V_sbttlpt,Rd.s+2668);
        else {
          Ra.sl[3]=3348; /* line # 3348 */
          P_st_put_pastr(V_sbttlpt,Rd.s+2675);
        }
      }
      Ra.sl[3]=3349; /* line # 3349 */
      P_st_put_pastr(V_sbttlpt,Rd.s+2679);
      Ra.sl[3]=3350; /* line # 3350 */
      if (Rs.ub[4216]) {
        Ra.sl[3]=3351; /* line # 3351 */
        P_st_put_pastr(V_sbttlpt,Rd.s+2712);
      }
      else {
        Ra.sl[3]=3352; /* line # 3352 */
        if (Rs.ub[4235]) {
          Ra.sl[3]=3353; /* line # 3353 */
          P_st_put_pastr(V_sbttlpt,Rd.s+2753);
        }
        else {
          Ra.sl[3]=3356; /* line # 3356 */
          P_st_put_pastr(V_sbttlpt,Rd.s+2794);
          Ra.sl[3]=3357; /* line # 3357 */
          if (Rs.ub[4208]) {
            Ra.sl[3]=3358; /* line # 3358 */
            Rv16=1;
            for( Rf2=Rs.sl[1047];Rf2>0;Rf2-- ) {
              Ra.sl[3]=3359; /* line # 3359 */
              P_st_put_ident(V_sbttlpt,((V *)Rs.v[Rv16+1047])[2],9);
              Rv16++;
            }
          }
          else {
            Ra.sl[3]=3361; /* line # 3361 */
            if (V_momhde==NULL) P_st_put_pastr(V_sbttlpt,Rd.s+2806);
            else {
              Ra.sl[3]=3362; /* line # 3362 */
              P_st_put_pastr(V_sbttlpt,Rd.s+2818);
            }
          }
        }
      }
      Ra.sl[3]=3364; /* line # 3364 */
      P_st_put_pastr(V_sbttlpt,Rd.s+2847);
      Ra.sl[3]=3365; /* line # 3365 */
      P_newlinelst();
      Ra.sl[3]=3366; /* line # 3366 */
      Rv17=V_sbttlpt;
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHT(Rv17+4,132,(SL)((C *)Rv17)[136],-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=3367; /* line # 3367 */
      P_skipline(1);
    }
    Ra.sl[3]=3369; /* line # 3369 */
    Rv18=0;
    Ra.sl[3]=3370; /* line # 3370 */
    Rv19=1;
    for( Rf2=((SL *)Rv2)[10];Rf2>0;Rf2-- ) {
      Ra.sl[3]=3372; /* line # 3372 */
      Rv20=0;
      Ra.sl[3]=3373; /* line # 3373 */
      Rv21=(F)0.000000E-01;
      Ra.sl[3]=3374; /* line # 3374 */
      Ra.sl[3]=3377; /* line # 3377 */
      Rv22=abs(V_cdrec.sl[6])/64;
      V_ccateg=abs(V_cdrec.sl[6])&63;
      Ra.sl[3]=3378; /* line # 3378 */
      Lx[5].f[2]=(F)0.000000E-01;
      Lx[5].f[3]=(F)0.000000E-01;
      Ra.sl[3]=3379; /* line # 3379 */
      if ((((((((V_ccateg<=V_mxcateg&&V_cdrec.sl[0]<=Rs.sl[1041])&&V_cdrec.sl[0]
      >=Rs.sl[1042])&&V_cdrec.sl[1]<=Rs.sl[1043])&&V_cdrec.sl[1]>=Rs.sl[1044])&&
      V_cdrec.sl[2]<=Rs.sl[1045])&&V_cdrec.sl[2]>=Rs.sl[1046])&&V_cdrec.f[12]>=Rs
      .f[1039])&&V_cdrec.f[12]<=Rs.f[1038]) {
        Ra.sl[3]=3384; /* line # 3384 */
        if (Rv22!=V_cselect) {
          Ra.sl[3]=3386; /* line # 3386 */
          V_cselect=Rv22;
          MXD_LSQ_parmderval(0);
          Ra.sl[3]=3387; /* line # 3387 */
          if (Rs.ub[4129]&&!Rs.ub[4232]) {
            Ra.sl[3]=3389; /* line # 3389 */
            P_skipline(1);
            P_newlinelst();
            Ra.sl[3]=3390; /* line # 3390 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+2897,-1,-1,32);
            PAS__WRITE_INT(V_cselect,2,0);
            Ra.sl[3]=3391; /* line # 3391 */
            if (V_bfmagnetic&&V_momhde!=NULL) {
              Ra.sl[3]=3393; /* line # 3393 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+2922,-1,-1,32);
              Ra.sl[3]=3394; /* line # 3394 */
              if (V_magsel.ub[V_cselect]) {
                Ra.sl[3]=3395; /* line # 3395 */
                PAS__SELECT_OUT(V_lst);
                PAS__WRITE_STR(Rd.s+2944,-1,-1,32);
              }
              else {
                Ra.sl[3]=3397; /* line # 3397 */
                PAS__SELECT_OUT(V_lst);
                PAS__WRITE_STR(Rd.s+2952,-1,-1,32);
              }
            }
            Ra.sl[3]=3399; /* line # 3399 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+2961,-1,-1,32);
            PAS__WRITE_EOLN();
          }
        }
        Ra.sl[3]=3402; /* line # 3402 */
        V_hr=(float)V_cdrec.sl[0];
        V_kr=(float)V_cdrec.sl[1];
        V_lr=(float)V_cdrec.sl[2];
        Ra.sl[3]=3403; /* line # 3403 */
        V_hc=V_cdrec.f[9];
        V_kc=V_cdrec.f[10];
        V_lc=V_cdrec.f[11];
        Ra.sl[3]=3404; /* line # 3404 */
        if (((SL *)Rv2)[9]<2) Rv23=1;
        else Rv23=V_cdrec.sl[3];
        Ra.sl[3]=3405; /* line # 3405 */
        if (V_cdrec.sl[5]!=Rv4) {
          Ra.sl[3]=3406; /* line # 3406 */
          if (V_cdrec.sl[5]==-1) V_cwave=NULL;
          else {
            Ra.sl[3]=3408; /* line # 3408 */
            V_cwave=V_wavhde;
            Ra.sl[3]=3409; /* line # 3409 */
            while (((SL *)V_cwave)[3]!=V_cdrec.sl[5]&&((V *)V_cwave)[1]!=NULL){
              Ra.sl[3]=3410; /* line # 3410 */
              V_cwave=((V *)V_cwave)[1];
            }
            Ra.sl[3]=3411; /* line # 3411 */
            if (Rs.ub[4129]) {
              Ra.sl[3]=3413; /* line # 3413 */
              P_skipline(1);
              P_newlinelst();
              Ra.sl[3]=3414; /* line # 3414 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+2965,-1,-1,32);
              Ra.sl[3]=3415; /* line # 3415 */
              MXD_LSQ_outnameid(((V *)V_cwave)[2],16);
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_CHAR(34);
              PAS__WRITE_EOLN();
            }
            Ra.sl[3]=3417; /* line # 3417 */
            MXD_LSQ_parmderval(1);
            Ra.sl[3]=3418; /* line # 3418 */
            Rv4=V_cdrec.sl[5];
          }
        }
        Ra.sl[3]=3420; /* line # 3420 */
        if (V_cdrec.sl[7]!=Rv3) {
          Ra.sl[3]=3421; /* line # 3421 */
          if (V_cdrec.sl[7]==-1) V_cnpola=NULL;
          else {
            Ra.sl[3]=3423; /* line # 3423 */
            V_cnpola=V_polhde;
            Ra.sl[3]=3424; /* line # 3424 */
            while (((SL *)V_cnpola)[3]!=V_cdrec.sl[7]&&((V *)V_cnpola)[1]!=NULL)
            {
              Ra.sl[3]=3425; /* line # 3425 */
              V_cnpola=((V *)V_cnpola)[1];
            }
            Ra.sl[3]=3426; /* line # 3426 */
            if (Rs.ub[4129]) {
              Ra.sl[3]=3428; /* line # 3428 */
              P_skipline(1);
              P_newlinelst();
              Ra.sl[3]=3429; /* line # 3429 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+2991,-1,-1,32);
              Ra.sl[3]=3430; /* line # 3430 */
              MXD_LSQ_outnameid(((V *)V_cnpola)[2],16);
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_CHAR(34);
              PAS__WRITE_EOLN();
            }
            Ra.sl[3]=3432; /* line # 3432 */
            Rv3=V_cdrec.sl[7];
          }
        }
        Ra.sl[3]=3434; /* line # 3434 */
        if (V_cnpola!=NULL) V_refcatsv=V_cdrec.sl[8];
        else V_refcatsv=0;
        Ra.sl[3]=3435; /* line # 3435 */
        Rs.sl[127353]=P_cpu_clock();
        Ra.sl[3]=3436; /* line # 3436 */
        Lx[5].f[0]=V_cdrec.f[12]*(F)2.000000E+00;
        Ra.sl[3]=3437; /* line # 3437 */
        MXD_LSQ_PRC_00000004(((SL *)Rv2)[9],Rv23, Rv15, F_bmatrix);
        Ra.sl[3]=3439; /* line # 3439 */
        Rs.sl[1065]=(Rs.sl[1065]+P_cpu_clock())-Rs.sl[127353];
        Ra.sl[3]=3440; /* line # 3440 */
        if (((SL *)Rv2)[9]==2&&V_cdrec.sl[6]<0) Rv15=1;
        else {
          Ra.sl[3]=3442; /* line # 3442 */
          Rs.sl[127354]=P_cpu_clock();
          Ra.sl[3]=3443; /* line # 3443 */
          Rv15=0;
          Ra.sl[3]=3445; /* line # 3445 */
          if (V_virtvtab.v[0]!=NULL) ((F *)V_virtvtab.v[0])[7]=V_fstr;
          Ra.sl[3]=3446; /* line # 3446 */
          MXD_LSQ_parmderval(6);
          Ra.sl[3]=3448; /* line # 3448 */
          MXD_LSQ_cpf2corr(&Rv24, V_fstr,((V *)Rv2)[8],Rs.sl[1080],Rs.sl[1080],0,
          F_bmatrix,0);
          Ra.sl[3]=3450; /* line # 3450 */
          if (((V *)Rv2)[5]==NULL) Rv25=V_cdrec.f[14];
          else {
            Ra.sl[3]=3451; /* line # 3451 */
            Rv25=V_cdrec.f[14]*MXD_LSQ_gtvd(((V *)Rv2)[5]);
          }
          Ra.sl[3]=3452; /* line # 3452 */
          Rv26=Rv25*Rv25;
          Ra.sl[3]=3453; /* line # 3453 */
          if (Rv24>(F)1.000000E-05) {
            Ra.sl[3]=3454; /* line # 3454 */
            Rv0=(Rv0+V_cdrec.f[13]*log(Rv24))-fabs(Rv24);
          }
          Ra.sl[3]=3455; /* line # 3455 */
          V_delta=V_cdrec.f[13]-Rv24;
          Lx[5].f[2]=V_fnr;
          Lx[5].f[3]=V_fni;
          Ra.sl[3]=3456; /* line # 3456 */
          if (fabs(V_cdrec.f[15])<(F)1.000000E-020) {
            Ra.sl[3]=3457; /* line # 3457 */
            Rv21=(F)0.000000E-01;
            Rv14=Rv14+1;
          }
          else {
            Ra.sl[3]=3459; /* line # 3459 */
            Rv21=V_delta/V_cdrec.f[15];
          }
          Ra.sl[3]=3460; /* line # 3460 */
          if (Rs.f[1053]==(F)0.000000E-01||Rs.f[1053]>=fabs(Rv21)) {
            Ra.sl[3]=3463; /* line # 3463 */
            Rv27=V_blkhde;
            Ra.sl[3]=3464; /* line # 3464 */
            Rv28=1;
            Ra.sl[3]=3465; /* line # 3465 */
            Rv29=Rs.sl[1079];
            Ra.sl[3]=3466; /* line # 3466 */
            Rv30=Rs.sl[1080];
            Ra.sl[3]=3467; /* line # 3467 */
            if (F_bmatrix) {
              Ra.sl[3]=3468; /* line # 3468 */
              while (Rv27!=NULL){
                Ra.sl[3]=3470; /* line # 3470 */
                Rv31=((SL *)Rv27)[4];
                Ra.sl[3]=3471; /* line # 3471 */
                Rv32=1;
                for( Rf1=Rv31;Rf1>0;Rf1-- ) {
                  Ra.sl[3]=3473; /* line # 3473 */
                  Rv33=Rv30;
                  Ra.sl[3]=3474; /* line # 3474 */
                  Rv34=Rv26*Rs.f[Rv30+1093];
                  Ra.sl[3]=3475; /* line # 3475 */
                  for( Rf0=(Rv31+1)-Rv32;Rf0>0;Rf0-- ) {
                    Ra.sl[3]=3477; /* line # 3477 */
                    Rs.f[Rv28+1093]=Rs.f[Rv28+1093]+Rv34*Rs.f[Rv33+1093];
                    Ra.sl[3]=3478; /* line # 3478 */
                    Rv28=Rv28+1;
                    Rv33=Rv33+1;
                  }
                  Ra.sl[3]=3480; /* line # 3480 */
                  Rs.f[Rv29+1093]=Rs.f[Rv29+1093]+Rv34*V_delta;
                  Ra.sl[3]=3481; /* line # 3481 */
                  Rv29=Rv29+1;
                  Rv30=Rv30+1;
                  Rv32++;
                }
                Ra.sl[3]=3483; /* line # 3483 */
                Rv27=((V *)Rv27)[1];
              }
            }
            Ra.sl[3]=3486; /* line # 3486 */
            Rv9=Rv9+PAS__F_SQR(Rv25*V_delta);
            Ra.sl[3]=3487; /* line # 3487 */
            Rv10=Rv10+Rv25*fabs(V_delta);
            Ra.sl[3]=3488; /* line # 3488 */
            Rv11=Rv11+V_delta*V_delta;
            Ra.sl[3]=3489; /* line # 3489 */
            Rv12=Rv12+fabs(V_delta);
            Ra.sl[3]=3490; /* line # 3490 */
            Rv5=Rv5+PAS__F_SQR(Rv25*V_cdrec.f[13]);
            Ra.sl[3]=3491; /* line # 3491 */
            Rv7=Rv7+PAS__F_SQR(V_cdrec.f[13]);
            Ra.sl[3]=3492; /* line # 3492 */
            Rv6=Rv6+Rv25*fabs(V_cdrec.f[13]);
            Ra.sl[3]=3493; /* line # 3493 */
            Rv8=Rv8+fabs(V_cdrec.f[13]);
            Ra.sl[3]=3494; /* line # 3494 */
            Rv13=Rv13+1;
            Ra.sl[3]=3495; /* line # 3495 */
            if (V_cdrec.f[15]>(F)0.000000E-01) Lx[5].f[1]=Lx[5].f[1]+Rv21*Rv21;
            Ra.sl[3]=3497; /* line # 3497 */
            Rs.sl[1066]=(Rs.sl[1066]+P_cpu_clock())-Rs.sl[127354];
            Ra.sl[3]=3498; /* line # 3498 */
            MXD_LSQ_makesumhkl();
          }
        }
        Ra.sl[3]=3501; /* line # 3501 */
        if ((Rs.ub[4129]&&F_bmatrix)&&(Rs.f[1033]<=(F)0.000000E-01||V_cdrec.sl[6]
        >0&&Rs.f[1033]<fabs(Rv21))) {
          Ra.sl[3]=3504; /* line # 3504 */
          P_newlinelst();
          Ra.sl[3]=3505; /* line # 3505 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_INT(Rv19,5,0);
          PAS__WRITE_CHAR(47);
          Ra.sl[3]=3506; /* line # 3506 */
          if (Rs.ub[4232]) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_INT(V_cselect,2,0);
            PAS__WRITE_STR(Rd.s+3017,-1,-1,32);
          }
          else {
            Ra.sl[3]=3507; /* line # 3507 */
            if (V_cnpola!=NULL&&V_cdrec.sl[8]!=0) {
              Ra.sl[3]=3508; /* line # 3508 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_CHT((Rs.s+V_cdrec.sl[8]*4+4284),4,4,-1,32);
            }
            else {
              Ra.sl[3]=3510; /* line # 3510 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_CHAR(32);
            }
          }
          Ra.sl[3]=3511; /* line # 3511 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_INT(V_cdrec.sl[0],4,0);
          PAS__WRITE_INT(V_cdrec.sl[1],4,0);
          PAS__WRITE_INT(V_cdrec.sl[2],4,0);
          PAS__WRITE_INT(V_cdrec.sl[3],3,0);
          PAS__WRITE_INT(V_cdrec.sl[4],3,0);
          PAS__WRITE_SNGL(V_fnr,7,2,0);
          PAS__WRITE_SNGL(V_fni,7,2,0);
          Ra.sl[3]=3512; /* line # 3512 */
          if (Rs.ub[4216]) {
            Ra.sl[3]=3513; /* line # 3513 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_SNGL(V_fxr,6,2,0);
            PAS__WRITE_SNGL(V_fxi,6,2,0);
            PAS__WRITE_SNGL(V_fyr,6,2,0);
            PAS__WRITE_SNGL(V_fyi,6,2,0);
            PAS__WRITE_SNGL(V_fzr,6,2,0);
            PAS__WRITE_SNGL(V_fzi,6,2,0);
          }
          else {
            Ra.sl[3]=3515; /* line # 3515 */
            if (Rs.ub[4235]) {
              Ra.sl[3]=3516; /* line # 3516 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_SNGL(V_fmxr,6,2,0);
              PAS__WRITE_SNGL(V_fmxi,6,2,0);
              PAS__WRITE_SNGL(V_fmyr,6,2,0);
              PAS__WRITE_SNGL(V_fmyi,6,2,0);
              PAS__WRITE_SNGL(V_fmzr,6,2,0);
              PAS__WRITE_SNGL(V_fmzi,6,2,0);
            }
            else {
              Ra.sl[3]=3520; /* line # 3520 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_SNGL(V_cdrec.f[12],6,4,0);
              Ra.sl[3]=3521; /* line # 3521 */
              if (Rs.ub[4208]) {
                Ra.sl[3]=3522; /* line # 3522 */
                Rv35=1;
                for( Rf1=Rs.sl[1047];Rf1>0;Rf1-- ) {
                  Ra.sl[3]=3523; /* line # 3523 */
                  PAS__SELECT_OUT(V_lst);
                  PAS__WRITE_SNGL(((F *)Rs.v[Rv35+1047])[6],9,4,0);
                  Rv35++;
                }
              }
              else {
                Ra.sl[3]=3525; /* line # 3525 */
                if (V_momhde==NULL) {
                  PAS__SELECT_OUT(V_lst);
                  PAS__WRITE_SNGL(V_fnucl2,10,2,0);
                }
                else {
                  Ra.sl[3]=3526; /* line # 3526 */
                  PAS__SELECT_OUT(V_lst);
                  PAS__WRITE_SNGL(V_fnucl2,9,2,0);
                  PAS__WRITE_SNGL(V_fmag2,9,2,0);
                  PAS__WRITE_SNGL(V_fcalc2,9,2,0);
                }
              }
            }
          }
          Ra.sl[3]=3528; /* line # 3528 */
          if (V_cdrec.sl[6]>0) {
            Ra.sl[3]=3530; /* line # 3530 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_SNGL(Rv24,9,2,0);
            PAS__WRITE_SNGL(V_cdrec.f[13],9,2,0);
            PAS__WRITE_SNGL(V_delta,7,2,0);
            PAS__WRITE_SNGL(V_cdrec.f[15],7,2,0);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_SNGL(V_cdrec.f[14],9,-6,0);
            Ra.sl[3]=3532; /* line # 3532 */
            if (fabs(V_cdrec.f[15])>(F)1.000000E-020) {
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_SNGL(Rv21,7,2,0);
            }
            else {
              Ra.sl[3]=3533; /* line # 3533 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+3021,-1,-1,32);
            }
            Ra.sl[3]=3534; /* line # 3534 */
            if (Rs.f[1053]!=(F)0.000000E-01&&Rs.f[1053]<fabs(Rv21)) {
              Ra.sl[3]=3535; /* line # 3535 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_STR(Rd.s+3030,-1,-1,32);
            }
          }
          Ra.sl[3]=3537; /* line # 3537 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_EOLN();
        }
        Ra.sl[3]=3539; /* line # 3539 */
        if (Rs.ub[4236]) {
          Ra.sl[3]=3541; /* line # 3541 */
          V_fmzr=(Rs.f[1060]*V_fmxr+Rs.f[1061]*V_fmyr)+Rs.f[1062]*V_fmzr;
          Ra.sl[3]=3542; /* line # 3542 */
          V_fmzi=(Rs.f[1060]*V_fmxi+Rs.f[1061]*V_fmyi)+Rs.f[1062]*V_fmzi;
          Ra.sl[3]=3543; /* line # 3543 */
          PAS__SELECT_OUT(Ri.v[2]);
          PAS__WRITE_INT(V_cdrec.sl[0],4,0);
          PAS__WRITE_INT(V_cdrec.sl[1],4,0);
          PAS__WRITE_INT(V_cdrec.sl[2],4,0);
          PAS__WRITE_SNGL(sqrt(V_fmzi*V_fmzi+V_fmzr*V_fmzr),12,5,0);
          PAS__WRITE_SNGL(atan2(V_fmzi,V_fmzr),10,3,0);
          PAS__WRITE_SNGL(V_cdrec.f[13],16,5,0);
          PAS__WRITE_SNGL(V_delta,12,5,0);
          PAS__WRITE_EOLN();
        }
        Ra.sl[3]=3548; /* line # 3548 */
        if (Rs.ub[4281]) {
          Ra.sl[3]=3550; /* line # 3550 */
          Ra.sl[3]=3552; /* line # 3552 */
          V_crrec.sl[0]=Rv19-Rv18;
          Rv18=Rv19;
          Ra.sl[3]=3553; /* line # 3553 */
          V_crrec.f[1]=((F *)((V *)Rv2)[8])[6];
          Ra.sl[3]=3554; /* line # 3554 */
          if (((V *)Rv2)[6]==NULL) V_crrec.f[2]=(F)1.000000E+00;
          else {
            Ra.sl[3]=3555; /* line # 3555 */
            V_crrec.f[2]=((F *)((V *)Rv2)[6])[6];
          }
          Ra.sl[3]=3556; /* line # 3556 */
          if (((V *)Rv2)[7]==NULL) V_crrec.f[3]=(F)1.000000E+00;
          else {
            Ra.sl[3]=3557; /* line # 3557 */
            V_crrec.f[3]=((F *)((V *)Rv2)[7])[6];
          }
          Ra.sl[3]=3558; /* line # 3558 */
          V_crrec.f[4]=Lx[5].f[2];
          V_crrec.f[5]=Lx[5].f[3];
          V_crrec.f[6]=V_fmag2;
          V_crrec.f[7]=Rv21;
          Ra.sl[3]=3560; /* line # 3560 */
          PAS__SELECT_OUT(Ri.v[1]);
          PAS__WRITE_BIN(V_crrec.s);
        }
      }
      Ra.sl[3]=3565; /* line # 3565 */
      if (Rv19<((SL *)Rv2)[10]) {
        PAS__SELECT_INP(V_idat);
        PAS__READ_BIN(V_cdrec.s);
      }
      Rv19++;
    }
    Ra.sl[3]=3568; /* line # 3568 */
    Rs.f[127349]=Rs.f[127349]+Rv9;
    Rs.f[127350]=Rs.f[127350]+Rv10;
    Ra.sl[3]=3569; /* line # 3569 */
    Rs.f[127351]=Rs.f[127351]+Rv11;
    Rs.f[127352]=Rs.f[127352]+Rv12;
    Ra.sl[3]=3570; /* line # 3570 */
    Rs.f[127345]=Rs.f[127345]+Rv5;
    Rs.f[127347]=Rs.f[127347]+Rv6;
    Ra.sl[3]=3571; /* line # 3571 */
    Rs.f[127346]=Rs.f[127346]+Rv7;
    Rs.f[127348]=Rs.f[127348]+Rv8;
    Ra.sl[3]=3572; /* line # 3572 */
    V_ncpobs=V_ncpobs+Rv13;
    Ra.sl[3]=3574; /* line # 3574 */
    if (Rv13>V_varnb) {
      Ra.sl[3]=3576; /* line # 3576 */
      Rv36=Rv9/(float)(Rv13-V_varnb);
      Ra.sl[3]=3577; /* line # 3577 */
      if (Rv5>(F)1.000000E-020) Rv9=sqrt(Rv9/Rv5);
      else {
        Ra.sl[3]=3578; /* line # 3578 */
        Rv9=(F)-1.000000E+00;
      }
      Ra.sl[3]=3579; /* line # 3579 */
      if (Rv6>(F)1.000000E-020) Rv10=Rv10/Rv6;
      else {
        Ra.sl[3]=3580; /* line # 3580 */
        Rv10=(F)-1.000000E+00;
      }
      Ra.sl[3]=3581; /* line # 3581 */
      if (Rv7>(F)1.000000E-020) Rv11=sqrt(Rv11/Rv7);
      else {
        Ra.sl[3]=3582; /* line # 3582 */
        Rv11=(F)-1.000000E+00;
      }
      Ra.sl[3]=3583; /* line # 3583 */
      if (Rv8>(F)1.000000E-020) Rv12=Rv12/Rv8;
      else {
        Ra.sl[3]=3584; /* line # 3584 */
        Rv12=(F)-1.000000E+00;
      }
      Ra.sl[3]=3586; /* line # 3586 */
      if (V_sbttlpt!=NULL) {
        Ra.sl[3]=3587; /* line # 3587 */
        ((C *)V_sbttlpt)[136]=0;
      }
      Ra.sl[3]=3588; /* line # 3588 */
      if (V_nbcoll>1) {
        Ra.sl[3]=3589; /* line # 3589 */
        if (Rs.ub[4129]&&F_bmatrix||Rs.ub[4143]) {
          Ra.sl[3]=3591; /* line # 3591 */
          P_newparagraphe(16);
          Ra.sl[3]=3592; /* line # 3592 */
          P_newlinelst();
          Ra.sl[3]=3593; /* line # 3593 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+3034,-1,-1,32);
          Ra.sl[3]=3594; /* line # 3594 */
          MXD_LSQ_outnameid(((V *)Rv2)[2],16);
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+3087,-1,-1,32);
          PAS__WRITE_INT(Rv13,6,0);
          PAS__WRITE_CHAR(32);
          Ra.sl[3]=3595; /* line # 3595 */
          if (V_b132) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+3096,-1,-1,32);
            PAS__WRITE_EOLN();
          }
          else {
            Ra.sl[3]=3596; /* line # 3596 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+3111,-1,-1,32);
            PAS__WRITE_EOLN();
          }
          Ra.sl[3]=3597; /* line # 3597 */
          if (!V_bshortlst) P_underline(0,86);
          Ra.sl[3]=3598; /* line # 3598 */
          MXD_LSQ_outresidu(&V_lst,1, &Rv9, &Rv10, &Rv11, &Rv12, &Rv36);
          Ra.sl[3]=3599; /* line # 3599 */
          P_skipline(1);
        }
      }
    }
    Ra.sl[3]=3603; /* line # 3603 */
    V_cdata=((V *)V_cdata)[1];
  }
  Ra.sl[3]=3607; /* line # 3607 */
  if (V_ncpobs>V_varnb) {
    Ra.sl[3]=3609; /* line # 3609 */
    Lx[5].f[4]=Rs.f[127349]/(float)(V_ncpobs-V_varnb);
    Ra.sl[3]=3610; /* line # 3610 */
    Lx[5].f[1]=Lx[5].f[1]/(float)(V_ncpobs-V_varnb);
  }
  else {
    Ra.sl[3]=3614; /* line # 3614 */
    Lx[5].f[4]=(F)-1.000000E+00;
    Lx[5].f[1]=(F)-1.000000E+00;
  }
  Ra.sl[3]=3617; /* line # 3617 */
  if (Rs.f[127345]>(F)1.000000E-020) Rs.f[127349]=sqrt(Rs.f[127349]/Rs.f[127345]
  );
  else {
    Ra.sl[3]=3618; /* line # 3618 */
    Rs.f[127349]=(F)-1.000000E+00;
  }
  Ra.sl[3]=3619; /* line # 3619 */
  if (Rs.f[127347]>(F)1.000000E-020) Rs.f[127350]=Rs.f[127350]/Rs.f[127347];
  else {
    Ra.sl[3]=3620; /* line # 3620 */
    Rs.f[127350]=(F)-1.000000E+00;
  }
  Ra.sl[3]=3621; /* line # 3621 */
  if (Rs.f[127346]>(F)1.000000E-020) Rs.f[127351]=sqrt(Rs.f[127351]/Rs.f[127346]
  );
  else {
    Ra.sl[3]=3622; /* line # 3622 */
    Rs.f[127351]=(F)-1.000000E+00;
  }
  Ra.sl[3]=3623; /* line # 3623 */
  if (Rs.f[127348]>(F)1.000000E-020) Rs.f[127352]=Rs.f[127352]/Rs.f[127348];
  else {
    Ra.sl[3]=3624; /* line # 3624 */
    Rs.f[127352]=(F)-1.000000E+00;
  }
  Ra.sl[3]=3626; /* line # 3626 */
  if (Rs.ub[4233]&&!F_bmatrix||!Rs.ub[4233]) {
    Ra.sl[3]=3628; /* line # 3628 */
    if (V_bshortlst) P_newparagraphe(16);
    else P_newparagraphe(22);
    Ra.sl[3]=3629; /* line # 3629 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+3117,-1,-1,32);
    Ra.sl[3]=3630; /* line # 3630 */
    if (Rs.sl[0]>Rs.sl[1]) {
      Ra.sl[3]=3631; /* line # 3631 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3146,-1,-1,32);
      PAS__WRITE_INT(Rs.sl[1],4,0);
    }
    else {
      Ra.sl[3]=3632; /* line # 3632 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3162,-1,-1,32);
      PAS__WRITE_INT(Rs.sl[0],4,0);
    }
    Ra.sl[3]=3633; /* line # 3633 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+3178,-1,-1,32);
    PAS__WRITE_INT(V_ncpobs,6,0);
    PAS__WRITE_STR(Rd.s+3195,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=3634; /* line # 3634 */
    if (!V_bshortlst) P_underline(0,79);
    Ra.sl[3]=3636; /* line # 3636 */
    if (Rv14>0) {
      Ra.sl[3]=3638; /* line # 3638 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3211,-1,-1,32);
      Ra.sl[3]=3639; /* line # 3639 */
      if (Rv14>1) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+3220,-1,-1,32);
      }
      else {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+3225,-1,-1,32);
      }
      Ra.sl[3]=3640; /* line # 3640 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3229,-1,-1,32);
      Ra.sl[3]=3641; /* line # 3641 */
      if (Rv14>1) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(115);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
      P_newlinelst();
      Ra.sl[3]=3642; /* line # 3642 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3248,-1,-1,32);
    }
    Ra.sl[3]=3645; /* line # 3645 */
    MXD_LSQ_outresidu(&V_lst,1, Rs.f+127349,Rs.f+127350,Rs.f+127351,Rs.f+127352,
    Lx[5].f+4);
  }
  Ra.sl[3]=3647; /* line # 3647 */
  Rs.f[1026]=Rs.f[1027];
  Rs.f[1027]=Lx[5].f[4];
  Ra.sl[3]=3648; /* line # 3648 */
  Rs.f[1028]=Rs.f[1029];
  Rs.f[1029]=Rv0;
  Ra.sl[3]=3649; /* line # 3649 */
  if (Lx[5].f[1]>=(F)0.000000E-01) {
    Ra.sl[3]=3650; /* line # 3650 */
    if (fabs((Lx[5].f[1]-Lx[5].f[4])/Lx[5].f[1])>(F)1.000000E-04) {
      Ra.sl[3]=3652; /* line # 3652 */
      if (!V_bshortlst) P_skipline(2);
      Ra.sl[3]=3653; /* line # 3653 */
      P_newlinelst();
      Ra.sl[3]=3654; /* line # 3654 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3307,-1,-1,32);
      PAS__WRITE_SNGL(Lx[5].f[1],14,5,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setvariable "  */
void MXD_LSQ_PRC_00000014(UB F_bresult, SL *F_imem){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  register int Rgi;
  register int Rgj;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3356;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=3670; /* line # 3670 */
  Rv0=Lx[5].v[5];
  Ra.sl[3]=3671; /* line # 3671 */
  if (((V *)Rv0)[5]==NULL) Rv1=(F)1.000000E+00;
  else {
    Ra.sl[3]=3672; /* line # 3672 */
    Rv1=MXD_LSQ_gtvd(((V *)Rv0)[5]);
  }
  Ra.sl[3]=3673; /* line # 3673 */
  if (F_bresult) {
    Ra.sl[3]=3675; /* line # 3675 */
    if (Rs.ub[4136]||Rs.ub[4280]) {
      Ra.sl[3]=3676; /* line # 3676 */
      Rv2=Lx[5].v[5];
      Ra.sl[3]=3678; /* line # 3678 */
      P_newparagraphe(15);
      Ra.sl[3]=3679; /* line # 3679 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3369,-1,-1,32);
      Ra.sl[3]=3680; /* line # 3680 */
      MXD_LSQ_outnameid(((V *)Rv2)[2],1);
      Ra.sl[3]=3681; /* line # 3681 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3388,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv2)[4],4,0);
      PAS__WRITE_STR(Rd.s+3395,-1,-1,32);
      Ra.sl[3]=3682; /* line # 3682 */
      if (((V *)Rv2)[5]!=NULL) {
        Ra.sl[3]=3684; /* line # 3684 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_EOLN();
        Ra.sl[3]=3685; /* line # 3685 */
        P_newlinelst();
        Ra.sl[3]=3686; /* line # 3686 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+3407,-1,-1,32);
        PAS__WRITE_SNGL(Rv1,10,-6,0);
        Ra.sl[3]=3687; /* line # 3687 */
        if (((V *)Rv2)[6]==NULL) {
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+3435,-1,-1,32);
        }
      }
      Ra.sl[3]=3689; /* line # 3689 */
      if (((V *)Rv2)[6]!=NULL) {
        Ra.sl[3]=3691; /* line # 3691 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_EOLN();
        Ra.sl[3]=3692; /* line # 3692 */
        P_newlinelst();
        Ra.sl[3]=3693; /* line # 3693 */
        if (((V *)Rv2)[5]!=NULL) {
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+3439,-1,-1,32);
        }
        Ra.sl[3]=3694; /* line # 3694 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+3445,-1,-1,32);
        Ra.sl[3]=3695; /* line # 3695 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_SNGL(MXD_LSQ_gtvd(((V *)Rv2)[6]),10,-6,0);
      }
      Ra.sl[3]=3697; /* line # 3697 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3486,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=3698; /* line # 3698 */
      P_skipline(1);
    }
    Ra.sl[3]=3700; /* line # 3700 */
    if (Rs.ub[4136]&&!V_bshortlst) {
      Ra.sl[3]=3702; /* line # 3702 */
      P_newparagraphe(8);
      Ra.sl[3]=3703; /* line # 3703 */
      P_newlinelst();
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      PAS__WRITE_STR(Rd.s+3490,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=3704; /* line # 3704 */
      P_underline(7,23);
    }
    Ra.sl[3]=3706; /* line # 3706 */
    if (Rs.ub[4136]) {
      Ra.sl[3]=3708; /* line # 3708 */
      ((C *)V_sbttlpt)[136]=0;
      Ra.sl[3]=3709; /* line # 3709 */
      if (Rs.sl[0]>Rs.sl[1]) Lx[5].sl[6]=3;
      else Lx[5].sl[6]=2;
      Ra.sl[3]=3710; /* line # 3710 */
      if (!V_b132) Lx[5].sl[6]=Lx[5].sl[6]-1;
      Ra.sl[3]=3711; /* line # 3711 */
      Rv3=1;
      for( Rf0=Lx[5].sl[6];Rf0>0;Rf0-- ) {
        Ra.sl[3]=3713; /* line # 3713 */
        P_newparagraphe(5);
        Ra.sl[3]=3714; /* line # 3714 */
        P_st_put_pastr(V_sbttlpt,Rd.s+3515);
        Ra.sl[3]=3715; /* line # 3715 */
        if (Rs.sl[0]<=Rs.sl[1]) {
          Ra.sl[3]=3717; /* line # 3717 */
          P_st_put_pastr(V_sbttlpt,Rd.s+3556);
          Ra.sl[3]=3718; /* line # 3718 */
          if (Rv3<Lx[5].sl[6]) P_st_put_pastr(V_sbttlpt,Rd.s+3580);
        }
        Rv3++;
      }
      Ra.sl[3]=3721; /* line # 3721 */
      P_newlinelst();
      Ra.sl[3]=3722; /* line # 3722 */
      Rv4=V_sbttlpt;
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHT(Rv4+4,132,(SL)((C *)Rv4)[136],-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=3723; /* line # 3723 */
      P_skipline(1);
    }
  }
  Ra.sl[3]=3727; /* line # 3727 */
  Rv5=1;
  for( Rf0=((SL *)Lx[5].v[5])[4];Rf0>0;Rf0-- ) {
    Ra.sl[3]=3729; /* line # 3729 */
    Rv6=Lx[5].v[7];
    Ra.sl[3]=3731; /* line # 3731 */
    Lx[5].f[8]=((F *)Rv6)[7];
    ((F *)Rv6)[8]=sqrt(fabs(Lx[5].f[4]*Rs.f[((Rv5+Lx[5].sl[9])-1)+1093]));
    Ra.sl[3]=3732; /* line # 3732 */
    if (Rs.sl[0]<=Rs.sl[1]) {
      Ra.sl[3]=3733; /* line # 3733 */
      Lx[5].f[10]=Rv1*Rs.f[((Rv5+Lx[5].sl[11])-1)+1093];
    }
    else Lx[5].f[10]=(F)0.000000E-01;
    Ra.sl[3]=3735; /* line # 3735 */
    if (F_bresult&&Rs.ub[4233]) {
      Ra.sl[3]=3736; /* line # 3736 */
      Lx[5].f[8]=((F *)Rv6)[7]-Rs.f[(*F_imem)+1093];
      (*F_imem)=(*F_imem)+1;
    }
    Ra.sl[3]=3737; /* line # 3737 */
    ((F *)Rv6)[7]=Lx[5].f[8]+Lx[5].f[10];
    Ra.sl[3]=3738; /* line # 3738 */
    Lx[5].ub[48]=0;
    Lx[5].ub[49]=0;
    Ra.sl[3]=3739; /* line # 3739 */
    if (Rs.ub[4233]&&!F_bresult) {
      Ra.sl[3]=3742; /* line # 3742 */
      Rs.f[(*F_imem)+1093]=Lx[5].f[10];
      (*F_imem)=(*F_imem)+1;
    }
    else {
      Ra.sl[3]=3745; /* line # 3745 */
      if (((V *)Rv6)[6]!=NULL) {
        Ra.sl[3]=3746; /* line # 3746 */
        Rv7=((V *)Rv6)[6];
        Ra.sl[3]=3747; /* line # 3747 */
        if (((F *)Rv7)[0]<((F *)Rv7)[1]) {
          Ra.sl[3]=3749; /* line # 3749 */
          if (((F *)Rv6)[7]<((F *)Rv7)[0]) {
            Ra.sl[3]=3751; /* line # 3751 */
            ((F *)Rv6)[7]=((F *)Rv7)[0];
            Lx[5].ub[48]=1;
          }
          else {
            Ra.sl[3]=3753; /* line # 3753 */
            if (((F *)Rv6)[7]>((F *)Rv7)[1]) {
              Ra.sl[3]=3755; /* line # 3755 */
              ((F *)Rv6)[7]=((F *)Rv7)[1];
              Lx[5].ub[48]=1;
            }
          }
        }
        else {
          Ra.sl[3]=3760; /* line # 3760 */
          if (((F *)Rv6)[7]<((F *)Rv7)[1]) {
            Ra.sl[3]=3762; /* line # 3762 */
            Lx[5].ub[49]=1;
            Ra.sl[3]=3763; /* line # 3763 */
            ((F *)Rv6)[7]=((F *)Rv6)[7]+fabs(((F *)Rv7)[0])*(float)(1+(int)((((F
             *)Rv7)[1]-((F *)Rv6)[7])/fabs(((F *)Rv7)[0])));
          }
          else {
            Ra.sl[3]=3767; /* line # 3767 */
            if (((F *)Rv6)[7]>((F *)Rv7)[1]+fabs(((F *)Rv7)[0])) {
              Ra.sl[3]=3769; /* line # 3769 */
              Lx[5].ub[49]=1;
              Ra.sl[3]=3770; /* line # 3770 */
              ((F *)Rv6)[7]=((F *)Rv6)[7]-fabs(((F *)Rv7)[0])*(float)(int)((((F *)
              Rv6)[7]-((F *)Rv7)[1])/fabs(((F *)Rv7)[0]));
            }
          }
        }
      }
    }
    Ra.sl[3]=3774; /* line # 3774 */
    if (F_bresult&&Rs.ub[4136]) {
      Ra.sl[3]=3776; /* line # 3776 */
      if (PAS__I_MOD(Rv5,Lx[5].sl[6])==1||Lx[5].sl[6]==1) P_newlinelst();
      Ra.sl[3]=3777; /* line # 3777 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      MXD_LSQ_outnameid(((V *)Rv6)[2],16);
      Ra.sl[3]=3778; /* line # 3778 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(((F *)Rv6)[7],10,5,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(((F *)Rv6)[8],10,5,0);
      Ra.sl[3]=3779; /* line # 3779 */
      if (Rs.sl[0]<=Rs.sl[1]) {
        Ra.sl[3]=3781; /* line # 3781 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(Lx[5].f[8],10,5,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(Lx[5].f[10],10,5,0);
        Ra.sl[3]=3782; /* line # 3782 */
        if (Lx[5].ub[48]) {
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_STR(Rd.s+3586,-1,-1,32);
        }
        else {
          Ra.sl[3]=3784; /* line # 3784 */
          if (Lx[5].ub[49]) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_STR(Rd.s+3592,-1,-1,32);
          }
          else {
            Ra.sl[3]=3786; /* line # 3786 */
            if (PAS__I_MOD(Rv5,Lx[5].sl[6])!=0&&Rv5<((SL *)Lx[5].v[5])[4]) {
              Ra.sl[3]=3787; /* line # 3787 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_FCHAR(32,4,-1,1,32);
            }
          }
        }
      }
      Ra.sl[3]=3789; /* line # 3789 */
      if (PAS__I_MOD(Rv5,Lx[5].sl[6])==0||Rv5>=((SL *)Lx[5].v[5])[4]) {
        Ra.sl[3]=3791; /* line # 3791 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_EOLN();
        Ra.sl[3]=3792; /* line # 3792 */
        if (!V_bshortlst&&V_varnb<=10) P_skipline(1);
      }
    }
    Ra.sl[3]=3796; /* line # 3796 */
    Lx[5].v[7]=((V *)Lx[5].v[7])[3];
    Rv5++;
  }
  Ra.sl[3]=3798; /* line # 3798 */
  ((C *)V_sbttlpt)[136]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cycle "  */
void MXD_LSQ_cycle(){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  UB Rv7;
  SL Rv8;
  SL Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  V Rv13;
  register V Rv14;
  register V Rv15;
  register F Rgf;
  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[13]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+52;
  Ra.v[14]=Rd.s+3598;
  Ra.v[15]=Rd.s+17;
  Ra.sl[16]=3804; /* line # 3804 */
  MXD_LSQ_parmderval(-1);
  Ra.sl[16]=3805; /* line # 3805 */
  MXD_LSQ_set_pageheading();
  Ra.sl[16]=3806; /* line # 3806 */
  MXD_LSQ_PRC_00000013(1);
  Ra.sl[16]=3807; /* line # 3807 */
  if (V_varnb>0) {
    Ra.sl[16]=3809; /* line # 3809 */
    if (Rs.sl[0]>Rs.sl[1]) {
      Ra.sl[16]=3810; /* line # 3810 */
      if (Rs.ub[4148]) {
        Ra.sl[16]=3811; /* line # 3811 */
        P_open_listing(&V_intf, Rd.s+3607,10,0);
      }
    }
    Ra.sl[16]=3812; /* line # 3812 */
    if (Rs.ub[4136]||Rs.ub[4280]) {
      Ra.sl[16]=3814; /* line # 3814 */
      P_newparagraphe(15);
      Ra.sl[16]=3815; /* line # 3815 */
      P_newlinelst();
      Ra.sl[16]=3816; /* line # 3816 */
      if (Rs.sl[0]>Rs.sl[1]) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+3617,-1,-1,32);
      }
      Ra.sl[16]=3817; /* line # 3817 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3639,-1,-1,32);
      Ra.sl[16]=3818; /* line # 3818 */
      if (Rs.sl[0]<=Rs.sl[1]) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+3665,-1,-1,32);
        PAS__WRITE_INT(Rs.sl[0],4,0);
        PAS__WRITE_STR(Rd.s+3680,-1,-1,32);
      }
      Ra.sl[16]=3819; /* line # 3819 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
      P_underline(0,42);
      Ra.sl[16]=3820; /* line # 3820 */
      P_skipline(2);
    }
    Ra.sl[16]=3822; /* line # 3822 */
    Rs.sl[127355]=P_cpu_clock();
    Ra.sl[16]=3823; /* line # 3823 */
    Ra.v[5]=V_blkhde;
    Ra.sl[16]=3824; /* line # 3824 */
    Ra.v[7]=V_varhde;
    Ra.sl[16]=3825; /* line # 3825 */
    Rv0=0;
    Ra.sl[16]=3826; /* line # 3826 */
    Rv1=1;
    Ra.sl[16]=3827; /* line # 3827 */
    Rv2=Rs.sl[1079];
    Ra.sl[16]=3828; /* line # 3828 */
    Ra.sl[11]=Rs.sl[1081];
    Ra.sl[9]=Rs.sl[1082];
    Rv3=Rs.sl[1093];
    Ra.sl[16]=3829; /* line # 3829 */
    while (Ra.v[5]!=NULL){
      Ra.sl[16]=3830; /* line # 3830 */
      Rv4=Ra.v[5];
      Ra.sl[16]=3832; /* line # 3832 */
      if (((V *)Rv4)[6]!=NULL) MXD_LSQ_matchangediag(((SL *)Rv4)[4],Rv1, MXD_LSQ_gtvd((
      (V *)Rv4)[6]));
      Ra.sl[16]=3833; /* line # 3833 */
      MXD_LSQ_matinv(((SL *)Rv4)[4],Rv1, Rv2, &Rv0, Ra.v[7]);
      Ra.sl[16]=3834; /* line # 3834 */
      if (!Rs.ub[4224]&&(float)Rv0/(float)V_varnb>Rs.f[1055]) P_error(-100);
      else {
        Ra.sl[16]=3837; /* line # 3837 */
        MXD_LSQ_resolv(((SL *)Rv4)[4],Rv1, Rv2, Ra.sl[11],Ra.sl[9]);
        Ra.sl[16]=3838; /* line # 3838 */
        MXD_LSQ_PRC_00000014(!Rs.ub[4233],&Rv3);
      }
      Ra.sl[16]=3840; /* line # 3840 */
      Rv1=Rv1+(((SL *)Rv4)[4]*(((SL *)Rv4)[4]+1))/2;
      Ra.sl[16]=3841; /* line # 3841 */
      Rv2=Rv2+((SL *)Rv4)[4];
      Ra.sl[16]=3842; /* line # 3842 */
      Ra.sl[11]=Ra.sl[11]+((SL *)Rv4)[4];
      Ra.sl[9]=Ra.sl[9]+((SL *)Rv4)[4];
      Ra.sl[16]=3843; /* line # 3843 */
      Ra.v[5]=((V *)Ra.v[5])[1];
    }
    Ra.sl[16]=3845; /* line # 3845 */
    if (!V_bstop) {
      Ra.sl[16]=3847; /* line # 3847 */
      if (Rs.ub[4233]) MXD_LSQ_PRC_00000013(1);
      Ra.sl[16]=3848; /* line # 3848 */
      Ra.v[5]=V_blkhde;
      Ra.v[7]=V_varhde;
      Ra.sl[16]=3849; /* line # 3849 */
      Rv1=1;
      Rv2=Rs.sl[1079];
      Ra.sl[16]=3850; /* line # 3850 */
      Ra.sl[11]=Rs.sl[1081];
      Ra.sl[9]=Rs.sl[1082];
      Rv3=Rs.sl[1093];
      Ra.sl[16]=3851; /* line # 3851 */
      if (Rs.sl[0]>Rs.sl[1]||Rs.ub[4233]) {
        Ra.sl[16]=3852; /* line # 3852 */
        while (Ra.v[5]!=NULL){
          Ra.sl[16]=3853; /* line # 3853 */
          Rv5=Ra.v[5];
          Ra.sl[16]=3855; /* line # 3855 */
          Rv6=Ra.v[7];
          Ra.sl[16]=3856; /* line # 3856 */
          if (Rs.ub[4233]) MXD_LSQ_PRC_00000014(1, &Rv3);
          Ra.sl[16]=3857; /* line # 3857 */
          if (V_sbttlpt!=NULL) ((C *)V_sbttlpt)[136]=0;
          Ra.sl[16]=3858; /* line # 3858 */
          if (Rs.ub[4136]) P_skipline(2);
          Ra.sl[16]=3860; /* line # 3860 */
          if (Rs.sl[0]>Rs.sl[1]) {
            Ra.sl[16]=3862; /* line # 3862 */
            Rv7=1;
            Ra.sl[16]=3863; /* line # 3863 */
            Rv8=Rv1;
            Rv9=((SL *)Rv5)[4];
            Rv10=Rv8+1;
            Ra.sl[16]=3864; /* line # 3864 */
            while (Rv9>1){
              Ra.sl[16]=3866; /* line # 3866 */
              Rv11=Rv8+Rv9;
              Rv12=Rv9-1;
              Rv13=((V *)Ra.v[7])[3];
              Ra.sl[16]=3867; /* line # 3867 */
              while (Rv12>0){
                Ra.sl[16]=3869; /* line # 3869 */
                Rs.f[Rv10+1093]=Rs.f[Rv10+1093]/sqrt(fabs(Rs.f[Rv8+1093]*Rs.f[Rv11+
1093]));
                Ra.sl[16]=3870; /* line # 3870 */
                if (Rs.ub[4148]) {
                  Ra.sl[16]=3871; /* line # 3871 */
                  PAS__SELECT_OUT(V_intf);
                  PAS__WRITE_CHAR(32);
                  PAS__WRITE_INT(((SL *)Ra.v[7])[4],6,0);
                  PAS__WRITE_CHAR(32);
                  PAS__WRITE_INT(((SL *)Rv13)[4],6,0);
                  PAS__WRITE_CHAR(32);
                  PAS__WRITE_SNGL(Rs.f[Rv10+1093],18,-6,0);
                  PAS__WRITE_EOLN();
                }
                Ra.sl[16]=3873; /* line # 3873 */
                if (!Rs.ub[4280]&&Rs.f[1040]>(F)0.000000E-01) {
                  Ra.sl[16]=3874; /* line # 3874 */
                  if (fabs(Rs.f[Rv10+1093])>Rs.f[1040]) {
                    Ra.sl[16]=3876; /* line # 3876 */
                    if (Rv7) {
                      Ra.sl[16]=3878; /* line # 3878 */
                      P_newparagraphe(16);
                      P_newlinelst();
                      Rv7=0;
                      Ra.sl[16]=3879; /* line # 3879 */
                      PAS__SELECT_OUT(V_lst);
                      PAS__WRITE_STR(Rd.s+3684,-1,-1,32);
                      PAS__WRITE_SNGL(Rs.f[1040],8,4,0);
                      PAS__WRITE_EOLN();
                      Ra.sl[16]=3881; /* line # 3881 */
                      P_skipline(2);
                    }
                    Ra.sl[16]=3883; /* line # 3883 */
                    P_newlinelst();
                    Ra.sl[16]=3884; /* line # 3884 */
                    PAS__SELECT_OUT(V_lst);
                    PAS__WRITE_CHAR(32);
                    MXD_LSQ_outnameid(((V *)Ra.v[7])[2],16);
                    Ra.sl[16]=3885; /* line # 3885 */
                    PAS__SELECT_OUT(V_lst);
                    PAS__WRITE_STR(Rd.s+3728,-1,-1,32);
                    MXD_LSQ_outnameid(((V *)Rv13)[2],16);
                    Ra.sl[16]=3886; /* line # 3886 */
                    PAS__SELECT_OUT(V_lst);
                    PAS__WRITE_FCHAR(32,4,-1,1,32);
                    PAS__WRITE_SNGL(Rs.f[Rv10+1093],8,5,0);
                    PAS__WRITE_EOLN();
                  }
                }
                Ra.sl[16]=3888; /* line # 3888 */
                Rv10=Rv10+1;
                Rv11=Rv11+Rv12;
                Rv12=Rv12-1;
                Ra.sl[16]=3889; /* line # 3889 */
                Rv13=((V *)Rv13)[3];
              }
              Ra.sl[16]=3891; /* line # 3891 */
              if (Rs.ub[4148]) {
                Ra.sl[16]=3892; /* line # 3892 */
                Rv14=Ra.v[7];
                Ra.sl[16]=3893; /* line # 3893 */
                PAS__SELECT_OUT(V_intf);
                PAS__WRITE_CHAR(32);
                PAS__WRITE_INT(((SL *)Rv14)[4],6,0);
                PAS__WRITE_CHAR(32);
                PAS__WRITE_INT(((SL *)Rv14)[4],6,0);
                PAS__WRITE_CHAR(32);
                PAS__WRITE_SNGL(((F *)Rv14)[7],18,-6,0);
                PAS__WRITE_CHAR(32);
                PAS__WRITE_SNGL(PAS__F_SQR(((F *)Rv14)[8]),18,-6,0);
                PAS__WRITE_EOLN();
              }
              Ra.sl[16]=3895; /* line # 3895 */
              Rs.f[Rv8+1093]=(F)1.000000E+00;
              Ra.v[7]=((V *)Ra.v[7])[3];
              Ra.sl[16]=3896; /* line # 3896 */
              Rv10=Rv10+1;
              Rv8=Rv8+Rv9;
              Rv9=Rv9-1;
            }
            Ra.sl[16]=3898; /* line # 3898 */
            if (Rs.ub[4148]) {
              Ra.sl[16]=3899; /* line # 3899 */
              Rv15=Ra.v[7];
              Ra.sl[16]=3900; /* line # 3900 */
              PAS__SELECT_OUT(V_intf);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rv15)[4],6,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rv15)[4],6,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_SNGL(((F *)Rv15)[7],18,-6,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_SNGL(PAS__F_SQR(((F *)Rv15)[8]),18,-6,0);
              PAS__WRITE_EOLN();
            }
            Ra.sl[16]=3902; /* line # 3902 */
            Rs.f[Rv8+1093]=(F)1.000000E+00;
            Ra.v[7]=((V *)Ra.v[7])[3];
          }
          Ra.sl[16]=3904; /* line # 3904 */
          if (Rs.ub[4280]) MXD_LSQ_outmatrix(Rv1,((SL *)Rv5)[4],Rv6);
          Ra.sl[16]=3905; /* line # 3905 */
          Rv1=Rv1+(((SL *)Rv5)[4]*(((SL *)Rv5)[4]+1))/2;
          Ra.sl[16]=3906; /* line # 3906 */
          Rv2=Rv2+((SL *)Rv5)[4];
          Ra.sl[16]=3907; /* line # 3907 */
          Ra.sl[11]=Ra.sl[11]+((SL *)Rv5)[4];
          Ra.sl[9]=Ra.sl[9]+((SL *)Rv5)[4];
          Ra.sl[16]=3908; /* line # 3908 */
          Ra.v[5]=((V *)Ra.v[5])[1];
        }
      }
    }
    Ra.sl[16]=3911; /* line # 3911 */
    if (Rs.ub[4224]&&Rv0==V_varnb) {
      Ra.sl[16]=3913; /* line # 3913 */
      P_newlinelst();
      Ra.sl[16]=3914; /* line # 3914 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+3736,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[16]=3915; /* line # 3915 */
      P_error(-101);
    }
    Ra.sl[16]=3917; /* line # 3917 */
    if (Rs.sl[0]>Rs.sl[1]&&Rs.ub[4148]) P_close_txtfile(&V_intf);
    Ra.sl[16]=3918; /* line # 3918 */
    if (Rs.sl[0]<=Rs.sl[1]&&Rs.sl[1036]>0) MXD_LSQ_rotatvar();
    Ra.sl[16]=3920; /* line # 3920 */
    Rs.sl[1067]=(Rs.sl[1067]+P_cpu_clock())-Rs.sl[127355];
  }
  PAS__curr_cntx=Ra.v[13];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " savecycle "  */
void MXD_LSQ_savecycle(SL F_nc){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3779;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=3934; /* line # 3934 */
  if (F_nc>0||F_nc==0&&V_psav==NULL) {
    Ra.sl[3]=3936; /* line # 3936 */
    Rv0=P_st_create();
    Ra.sl[3]=3937; /* line # 3937 */
    P_st_put_pastr(Rv0,Rd.s+3790);
    Ra.sl[3]=3938; /* line # 3938 */
    P_st_put_int(Rv0,F_nc,-4);
    Ra.sl[3]=3939; /* line # 3939 */
    P_st_put_pastr(Rv0,Rd.s+3798);
    Ra.sl[3]=3940; /* line # 3940 */
    P_openw_txtfile(&V_intf, Rv0,0);
  }
  else {
    Ra.sl[3]=3942; /* line # 3942 */
    P_openw_txtfile(&V_intf, V_psav,1);
  }
  Ra.sl[3]=3943; /* line # 3943 */
  PAS__SELECT_OUT(V_intf);
  PAS__WRITE_STR(Rd.s+3811,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=3944; /* line # 3944 */
  MXD_LSQ_outresidu(&V_intf,0, Rs.f+127349,Rs.f+127350,Rs.f+127351,Rs.f+127352,Rs
  .f+1027);
  Ra.sl[3]=3945; /* line # 3945 */
  PAS__SELECT_OUT(V_intf);
  PAS__WRITE_STR(Rd.s+3816,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=3946; /* line # 3946 */
  Rv1=V_gvarhde;
  Ra.sl[3]=3947; /* line # 3947 */
  while (Rv1!=NULL){
    Ra.sl[3]=3949; /* line # 3949 */
    Rv2=Rv1;
    Ra.sl[3]=3951; /* line # 3951 */
    PAS__SELECT_OUT(V_intf);
    PAS__WRITE_CHAR(32);
    MXD_LSQ_outnameid(((V *)Rv2)[2],-16);
    Ra.sl[3]=3952; /* line # 3952 */
    PAS__SELECT_OUT(V_intf);
    PAS__WRITE_STR(Rd.s+3820,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv2)[7],15,-6,0);
    PAS__WRITE_CHAR(58);
    PAS__WRITE_SNGL(((F *)Rv2)[8],15,-6,0);
    PAS__WRITE_CHAR(59);
    PAS__WRITE_EOLN();
    Ra.sl[3]=3954; /* line # 3954 */
    Rv1=((V *)Rv1)[1];
  }
  Ra.sl[3]=3956; /* line # 3956 */
  P_close_txtfile(&V_intf);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " comput "  */
void MXD_LSQ_comput(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3825;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=3966; /* line # 3966 */
  Rs.sl[0]=1;
  Ra.sl[3]=3967; /* line # 3967 */
  while (Rs.sl[0]<=Rs.sl[1]+1&&!V_bstop){
    Ra.sl[3]=3969; /* line # 3969 */
    if (Rs.sl[0]>Rs.sl[1]) {
      Ra.sl[3]=3971; /* line # 3971 */
      Rs.ub[4136]=1;
      Ra.sl[3]=3972; /* line # 3972 */
      Rs.ub[4129]=Rs.ub[4128];
      Ra.sl[3]=3973; /* line # 3973 */
      Rs.ub[4143]=Rs.ub[4142];
      Ra.sl[3]=3974; /* line # 3974 */
      Rs.ub[4280]=Rs.ub[4137];
      Ra.sl[3]=3975; /* line # 3975 */
      Rs.ub[4281]=Rs.ub[4138];
      Ra.sl[3]=3976; /* line # 3976 */
      Rs.ub[4233]=0;
    }
    Ra.sl[3]=3978; /* line # 3978 */
    MXD_LSQ_cycle();
    Ra.sl[3]=3979; /* line # 3979 */
    if (Rs.sl[1064]>0) {
      Ra.sl[3]=3980; /* line # 3980 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+3833,-1,-1,32);
      PAS__WRITE_INT(Rs.sl[0],1,0);
      PAS__WRITE_CHAR(46);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=3981; /* line # 3981 */
    if (Rs.ub[4253]&&Rs.sl[0]<=Rs.sl[1]) MXD_LSQ_savecycle(Rs.sl[0]);
    Ra.sl[3]=3982; /* line # 3982 */
    Rs.sl[0]=Rs.sl[0]+1;
  }
  Ra.sl[3]=3984; /* line # 3984 */
  MXD_LSQ_parmderval(-1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " finaloutput "  */
void MXD_LSQ_finaloutput(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3850;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=3999; /* line # 3999 */
  if (V_psav!=NULL||!Rs.ub[4253]) MXD_LSQ_savecycle(0);
  Ra.sl[3]=4000; /* line # 4000 */
  if (Rs.ub[4140]) MXD_LSQ_outstructure();
  Ra.sl[3]=4001; /* line # 4001 */
  if (Rs.ub[4234]) MXD_LSQ_outparam();
  Ra.sl[3]=4002; /* line # 4002 */
  if (Rs.ub[4252]) MXD_LSQ_outatome();
  Ra.sl[3]=4003; /* line # 4003 */
  P_newparagraphe(14);
  Ra.sl[3]=4004; /* line # 4004 */
  P_skipline(2);
  Ra.sl[3]=4005; /* line # 4005 */
  P_newlinelst();
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_FCHAR(32,12,-1,1,32);
  PAS__WRITE_STR(Rd.s+3863,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=4006; /* line # 4006 */
  P_underline(11,24);
  Ra.sl[3]=4007; /* line # 4007 */
  P_skipline(1);
  P_newlinelst();
  Ra.sl[3]=4008; /* line # 4008 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+3890,-1,-1,32);
  P_writecpu(Rs.sl[1065]);
  Ra.sl[3]=4009; /* line # 4009 */
  P_newlinelst();
  Ra.sl[3]=4010; /* line # 4010 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+3928,-1,-1,32);
  P_writecpu(Rs.sl[1066]);
  Ra.sl[3]=4011; /* line # 4011 */
  P_newlinelst();
  Ra.sl[3]=4012; /* line # 4012 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+3966,-1,-1,32);
  P_writecpu(Rs.sl[1067]);
  Ra.sl[3]=4013; /* line # 4013 */
  P_newlinelst();
  Ra.sl[3]=4014; /* line # 4014 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+4004,-1,-1,32);
  Ra.sl[3]=4015; /* line # 4015 */
  P_writecpu(P_cpu_clock()-V_topcpu);
  Ra.sl[3]=4016; /* line # 4016 */
  P_skipline(1);
  P_newlinelst();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mxd_lsq "  */
main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  if (sigsetjmp(G_lb_env, 1 )) goto L_l_0;

  Rs.v[127356]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+509424;
  Rs.v[127357]=Rd.s+4042;
  Rs.v[127358]=Rd.s+17;
  Rs.sl[127359]=4024; /* line # 4024 */
  if (MXD_LSQ_init()) {
    Rs.sl[127359]=4026; /* line # 4026 */
    P_buildtree();
    Rs.sl[127359]=4028; /* line # 4028 */
    if (V_momhde==NULL) {
      Rs.sl[127359]=4030; /* line # 4030 */
      Rs.ub[4216]=0;
      Rs.sl[127359]=4031; /* line # 4031 */
      Rs.ub[4235]=0;
      Rs.sl[127359]=4032; /* line # 4032 */
      Rs.ub[4236]=0;
    }
    Rs.sl[127359]=4034; /* line # 4034 */
    if (V_bshortlst) {
      Rs.sl[127359]=4036; /* line # 4036 */
      Rs.ub[4128]=0;
      Rs.sl[127359]=4037; /* line # 4037 */
      Rs.ub[4129]=0;
      Rs.sl[127359]=4038; /* line # 4038 */
      Rs.ub[4137]=0;
      Rs.sl[127359]=4039; /* line # 4039 */
      Rs.ub[4141]=0;
      Rs.sl[127359]=4040; /* line # 4040 */
      Rs.ub[4139]=0;
      Rs.sl[127359]=4041; /* line # 4041 */
      Rs.ub[4140]=0;
    }
    Rs.sl[127359]=4043; /* line # 4043 */
    if (!V_bstop) {
      Rs.sl[127359]=4045; /* line # 4045 */
      MXD_LSQ_sepatm();
      Rs.sl[127359]=4046; /* line # 4046 */
      MXD_LSQ_listder();
      Rs.sl[127359]=4047; /* line # 4047 */
      MXD_LSQ_setrealvar();
      Rs.sl[127359]=4048; /* line # 4048 */
      MXD_LSQ_iniblk();
    }
    Rs.sl[127359]=4050; /* line # 4050 */
    if (!V_bstop) {
      Rs.sl[127359]=4052; /* line # 4052 */
      PAS__ESTABLISH(MXD_LSQ_error_handler);
      Rs.sl[127359]=4053; /* line # 4053 */
      MXD_LSQ_parmderval(-1);
      Rs.sl[127359]=4054; /* line # 4054 */
      MXD_LSQ_firstoutput();
      Rs.sl[127359]=4055; /* line # 4055 */
      MXD_LSQ_comput();
      Rs.sl[127359]=4056; /* line # 4056 */
      MXD_LSQ_finaloutput();
    }
  }
  PAS__curr_cntx=Rs.s+509424;
L_l_0:
  Rs.sl[127359]=4060; /* line # 4060 */
  PAS__curr_cntx=Rs.v[127356];
  PAS__EXIT( 0 );
}
