/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 272 ) = {
 15,  15, 112,  97, 115,  95,  95, 103, 101, 116,  95, 100, 111, 117,  98, 108,
101,  63,  63,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  45,  49,  45,
 65,  50,  47,  99, 112,  97, 115,  95,  95, 105, 111, 110, 117, 109,  46, 112,
 97, 115,  11,  11, 114, 101,  97, 100,  95, 100, 111, 117,  98, 108, 101,  11,
 11, 114, 101,  97, 100,  95, 115, 105, 110, 103, 108, 101,   8,   8, 114, 101,
 97, 100,  95, 105, 110, 116,   7,   7, 114, 101,  97, 100,  95, 117, 108,   7,
  7, 114, 101,  97, 100,  95, 115, 119,   7,   7, 114, 101,  97, 100,  95, 117,
119,   7,   7, 114, 101,  97, 100,  95, 115,  98,   7,   7, 114, 101,  97, 100,
 95, 117,  98,   9,   9, 119, 114, 105, 116, 101,  95, 117, 110, 115,   9,   9,
119, 114, 105, 116, 101,  95, 105, 110, 116,  11,  11, 112, 117, 116,  95, 100,
101,  99, 105, 109,  97, 108,  11,  11, 115, 105, 122, 101,  95, 100, 111, 117,
 98, 108, 101,  15,  15, 112,  97, 115,  95,  95, 112, 117, 116,  95, 101,  95,
100,  98, 108, 101,  15,  15, 112,  97, 115,  95,  95, 112, 117, 116,  95, 102,
 95, 100,  98, 108, 101,  10,  10, 119, 114, 105, 116, 101,  95, 100,  98, 108,
101,  10,  10, 119, 114, 105, 116, 101,  95, 115, 110, 103, 108,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__curr_iptr;


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " pas__get_double "  */
void P_pas__get_double(G *F_fl, SL F_fld){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  SL Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  C Rv6;
  SL Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=94; /* line # 94 */
  Rv0=0.000000000000000E-001;
  Ra.sl[3]=95; /* line # 95 */
  Rv1=1.000000000000000E-001;
  Ra.sl[3]=96; /* line # 96 */
  Rv2=0;
  Ra.sl[3]=97; /* line # 97 */
  Rv3=0;
  Ra.sl[3]=98; /* line # 98 */
  Rv4=0;
  Ra.sl[3]=99; /* line # 99 */
  Rv5=0;
  while (1){
    Ra.sl[3]=102; /* line # 102 */
    if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
    Ra.sl[3]=103; /* line # 103 */
    if (PAS__CURR_EOF()||Rv5>0&&PAS__CURR_EOLN())  break;
    Ra.sl[3]=105; /* line # 105 */
    if (F_fld>=0) F_fld=F_fld-1;
    Ra.sl[3]=106; /* line # 106 */
    Rv6=((C *)((V *)PAS__curr_iptr)[0])[0];
    Ra.sl[3]=110; /* line # 110 */
    switch (Rv6) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:Ra.sl[3]=111; /* line # 111 */
      if (Rv5>0) goto L_l_0;
      break;
      case 43:
      case 45:Ra.sl[3]=114; /* line # 114 */
      switch (Rv5) {
        case 0:Ra.sl[3]=115; /* line # 115 */
        Rv5=1;
        if (Rv6==45) Rv3=1;
        break;
        case 4:Ra.sl[3]=116; /* line # 116 */
        Rv5=5;
        if (Rv6==45) Rv4=1;
        break;
        default:Ra.sl[3]=118; /* line # 118 */
        goto L_l_0;
        break;
      }
      break;
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:Ra.sl[3]=123; /* line # 123 */
      Rv7=(SL)Rv6-48;
      Ra.sl[3]=124; /* line # 124 */
      switch (Rv5) {
        case 0:
        case 1:
        case 2:Ra.sl[3]=127; /* line # 127 */
        Rv0=Rv0*1.000000000000000E+001+(double)Rv7;
        Ra.sl[3]=128; /* line # 128 */
        if (Rv5<2) Rv5=2;
        break;
        case 3:Ra.sl[3]=130; /* line # 130 */
        Rv0=Rv0+Rv1*(double)Rv7;
        Rv1=Rv1*1.000000000000000E-001;
        break;
        case 4:
        case 5:Ra.sl[3]=133; /* line # 133 */
        Rv2=Rv2*10+Rv7;
        Ra.sl[3]=134; /* line # 134 */
        if (Rv5<5) Rv5=5;
        break;
        default:break;
      }
      break;
      case 46:Ra.sl[3]=140; /* line # 140 */
      if (Rv5<3) Rv5=3;
      else goto L_l_0;
      break;
      case 68:
      case 69:
      case 100:
      case 101:Ra.sl[3]=143; /* line # 143 */
      if (Rv5<4) {
        Ra.sl[3]=144; /* line # 144 */
        if (Rv5<2) Rv0=1.000000000000000E+000;
        Rv5=4;
      }
      else {
        Ra.sl[3]=145; /* line # 145 */
        goto L_l_0;
      }
      break;
      default:Ra.sl[3]=148; /* line # 148 */
      if (Rv5>0) goto L_l_0;
      Ra.sl[3]=149; /* line # 149 */
      PAS__ERROR(51);
      break;
    }
    Ra.sl[3]=151; /* line # 151 */
    PAS__GET(PAS__curr_iptr);
    if (F_fld==0)  break;
  }
L_l_0: ;
  Ra.sl[3]=154; /* line # 154 */
  if (Rv5==0) PAS__ERROR(51);
  Ra.sl[3]=157; /* line # 157 */
  if (Rv2!=0) {
    Ra.sl[3]=159; /* line # 159 */
    if (Rv4) Rv2= -Rv2;
    Ra.sl[3]=160; /* line # 160 */
    Rv0=Rv0*PAS__IGPOWER(1.000000000000000E+001,Rv2);
  }
  Ra.sl[3]=162; /* line # 162 */
  if (Rv3) Rv0=-Rv0;
  Ra.sl[3]=163; /* line # 163 */
  (*F_fl)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_double "  */
void PAS__READ_DBLE(G *F_fl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+82;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=171; /* line # 171 */
  P_pas__get_double(F_fl,F_f);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_single "  */
void PAS__READ_SNGL(F *F_fl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=179; /* line # 179 */
  P_pas__get_double(&Rv0, F_f);
  Ra.sl[3]=180; /* line # 180 */
  (*F_fl)=(float)Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_int "  */
void PAS__READ_SL(SL *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+108;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=194; /* line # 194 */
  P_pas__get_double(&Rv0, F_f);
  Ra.sl[3]=195; /* line # 195 */
  (*F_iv)=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_ul "  */
void PAS__READ_UL(UL *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+118;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=203; /* line # 203 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_sw "  */
void PAS__READ_SW(SW *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+127;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=211; /* line # 211 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_uw "  */
void PAS__READ_UW(UW *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+136;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=219; /* line # 219 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_sb "  */
void PAS__READ_SB(SB *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+145;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=227; /* line # 227 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_ub "  */
void PAS__READ_UB(UB *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+154;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=235; /* line # 235 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_uns "  */
void PAS__WRITE_UNS(UL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+163;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=252; /* line # 252 */
  Rv0=32;
  Ra.sl[3]=253; /* line # 253 */
  if (F_iv==0) {
    Ra.sl[3]=255; /* line # 255 */
    Ra.c[16]=48;
    Rv1=1;
  }
  else {
    Ra.sl[3]=259; /* line # 259 */
    if (F_b<2||F_b>16) F_b=10;
    Ra.sl[3]=260; /* line # 260 */
    Rv1=0;
    Ra.sl[3]=261; /* line # 261 */
    while (F_iv!=0){
      Ra.sl[3]=263; /* line # 263 */
      Rv1=Rv1+1;
      Ra.sl[3]=264; /* line # 264 */
      Rv2=F_iv%F_b;
      Ra.sl[3]=265; /* line # 265 */
      if (Rv2>9) {
        Ra.sl[3]=266; /* line # 266 */
        Ra.c[Rv1+15]=(C)((Rv2+65)-10);
      }
      else {
        Ra.sl[3]=268; /* line # 268 */
        Ra.c[Rv1+15]=(C)(Rv2+48);
      }
      Ra.sl[3]=269; /* line # 269 */
      F_iv=F_iv/F_b;
    }
  }
  Ra.sl[3]=272; /* line # 272 */
  if (F_f==0) F_f=Rv1;
  else {
    Ra.sl[3]=274; /* line # 274 */
    if (F_f<0) {
      Ra.sl[3]=276; /* line # 276 */
      Rv0=48;
      F_f= -F_f;
    }
  }
  Ra.sl[3]=278; /* line # 278 */
  Rv3=F_f-Rv1;
  Ra.sl[3]=279; /* line # 279 */
  if (Rv3>=0) {
    Ra.sl[3]=281; /* line # 281 */
    for( Rf0=Rv3;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    Ra.sl[3]=282; /* line # 282 */
    while (Rv1>0){
      Ra.sl[3]=284; /* line # 284 */
      PAS__WRITE_CHAR(Ra.c[Rv1+15]);
      Rv1=Rv1-1;
    }
  }
  else {
    Ra.sl[3]=288; /* line # 288 */
    for( Rf0=F_f;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_int "  */
void PAS__WRITE_INT(SL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+174;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=304; /* line # 304 */
  Rv0=32;
  Ra.sl[3]=305; /* line # 305 */
  if (F_iv==0) {
    Ra.sl[3]=307; /* line # 307 */
    Ra.c[16]=48;
    Rv1=1;
    Rv2=0;
  }
  else {
    Ra.sl[3]=311; /* line # 311 */
    Rv2=F_iv<0;
    Ra.sl[3]=312; /* line # 312 */
    if (F_b<2||F_b>16) F_b=10;
    Ra.sl[3]=313; /* line # 313 */
    Rv1=0;
    Ra.sl[3]=314; /* line # 314 */
    while (F_iv!=0){
      Ra.sl[3]=316; /* line # 316 */
      Rv1=Rv1+1;
      Ra.sl[3]=317; /* line # 317 */
      Rv3=abs(F_iv%F_b);
      Ra.sl[3]=318; /* line # 318 */
      if (Rv3>9) {
        Ra.sl[3]=319; /* line # 319 */
        Ra.c[Rv1+15]=(C)((Rv3+65)-10);
      }
      else {
        Ra.sl[3]=321; /* line # 321 */
        Ra.c[Rv1+15]=(C)(Rv3+48);
      }
      Ra.sl[3]=322; /* line # 322 */
      F_iv=F_iv/F_b;
    }
  }
  Ra.sl[3]=325; /* line # 325 */
  if (F_f==0) {
    Ra.sl[3]=326; /* line # 326 */
    F_f=Rv1+(SL)Rv2;
  }
  else {
    Ra.sl[3]=328; /* line # 328 */
    if (F_f<0) {
      Ra.sl[3]=330; /* line # 330 */
      Rv0=48;
      F_f= -F_f;
    }
  }
  Ra.sl[3]=332; /* line # 332 */
  Rv4=F_f-Rv1;
  Ra.sl[3]=333; /* line # 333 */
  if (Rv2) Rv4=Rv4-1;
  Ra.sl[3]=334; /* line # 334 */
  if (Rv4>=0) {
    Ra.sl[3]=336; /* line # 336 */
    if (Rv2&&Rv0==48) PAS__WRITE_CHAR(45);
    Ra.sl[3]=337; /* line # 337 */
    for( Rf0=Rv4;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    Ra.sl[3]=338; /* line # 338 */
    if (Rv2&&Rv0==32) PAS__WRITE_CHAR(45);
    Ra.sl[3]=339; /* line # 339 */
    while (Rv1>0){
      Ra.sl[3]=341; /* line # 341 */
      PAS__WRITE_CHAR(Ra.c[Rv1+15]);
      Rv1=Rv1-1;
    }
  }
  else {
    Ra.sl[3]=345; /* line # 345 */
    for( Rf0=F_f;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_decimal "  */
void CPAS__RWNUM_put_decimal(G F_dv, SL F_ndig, SL F_pent, UB F_bneg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+185;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=364; /* line # 364 */
  Rv0=1;
  Ra.sl[3]=365; /* line # 365 */
  while (F_ndig>0){
    Ra.sl[3]=367; /* line # 367 */
    Rv1=(int)(F_dv*1.000000000000000E+001);
    Ra.sl[3]=368; /* line # 368 */
    F_dv=F_dv*1.000000000000000E+001-(double)Rv1;
    Ra.sl[3]=369; /* line # 369 */
    if (Rv0) {
      Ra.sl[3]=370; /* line # 370 */
      if (Rv1==0&&F_pent>1) {
        Ra.sl[3]=371; /* line # 371 */
        PAS__WRITE_CHAR(32);
      }
      else {
        Ra.sl[3]=374; /* line # 374 */
        Rv0=0;
        Ra.sl[3]=375; /* line # 375 */
        if (F_bneg) PAS__WRITE_CHAR(45);
      }
    }
    Ra.sl[3]=379; /* line # 379 */
    if (!Rv0) PAS__WRITE_CHAR((C)(Rv1+48));
    Ra.sl[3]=380; /* line # 380 */
    F_ndig=F_ndig-1;
    Ra.sl[3]=381; /* line # 381 */
    F_pent=F_pent-1;
    Ra.sl[3]=383; /* line # 383 */
    if (F_pent==0&&F_ndig>0) PAS__WRITE_CHAR(46);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " size_double "  */
void CPAS__RWNUM_size_double(G *F_dv, SL *F_iexp, UB *F_bneg, UB F_bfix){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+198;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=397; /* line # 397 */
  if ((*F_dv)<0.000000000000000E-001) {
    Ra.sl[3]=399; /* line # 399 */
    (*F_dv)=-(*F_dv);
    Ra.sl[3]=400; /* line # 400 */
    (*F_bneg)=1;
  }
  else {
    Ra.sl[3]=402; /* line # 402 */
    (*F_bneg)=0;
  }
  Ra.sl[3]=403; /* line # 403 */
  if ((*F_dv)>0.000000000000000E-001) {
    Ra.sl[3]=405; /* line # 405 */
    (*F_iexp)=0;
    Rv0=(*F_dv);
    Ra.sl[3]=406; /* line # 406 */
    if ((*F_dv)>0.000000000000000E-001) {
      Ra.sl[3]=407; /* line # 407 */
      if ((*F_dv)>=1.000000000000000E+000) {
        Ra.sl[3]=408; /* line # 408 */
        while (Rv0>1.000000000000000E+000){
          Rv0=Rv0/1.000000000000000E+001;
          (*F_iexp)=(*F_iexp)+1;
        }
      }
      else {
        Ra.sl[3]=410; /* line # 410 */
        while (Rv0<1.000000000000000E-001){
          Rv0=Rv0*1.000000000000000E+001;
          (*F_iexp)=(*F_iexp)-1;
        }
      }
    }
    Ra.sl[3]=417; /* line # 417 */
    if (Rv0>=1.000000000000000E+000) {
      Ra.sl[3]=419; /* line # 419 */
      Rv0=Rv0*1.000000000000000E-001;
      (*F_iexp)=(*F_iexp)+1;
    }
    else {
      Ra.sl[3]=422; /* line # 422 */
      if (Rv0<1.000000000000000E-001) {
        Ra.sl[3]=424; /* line # 424 */
        Rv0=Rv0*1.000000000000000E+001;
        (*F_iexp)=(*F_iexp)-1;
      }
    }
    Ra.sl[3]=426; /* line # 426 */
    if (F_bfix&&(*F_iexp)<=0) (*F_dv)=(*F_dv)*1.000000000000000E-001;
    else {
      Ra.sl[3]=427; /* line # 427 */
      (*F_dv)=Rv0;
    }
  }
  else {
    Ra.sl[3]=429; /* line # 429 */
    (*F_iexp)=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pas__put_e_dble "  */
void P_pas__put_e_dble(G F_dv, SL F_fs, SL F_intsz, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UB Rv2;
  C Rv3;
  SL Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+211;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=445; /* line # 445 */
  F_es=abs(F_es);
  Ra.sl[3]=447; /* line # 447 */
  if (F_dcsz==-1) F_dcsz=7;
  else F_dcsz=abs(F_dcsz);
  Ra.sl[3]=448; /* line # 448 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[3]=449; /* line # 449 */
  if (F_fs<0) {
    Rv0=1;
    F_fs=abs(F_fs);
  }
  else {
    Ra.sl[3]=450; /* line # 450 */
    Rv0=0;
  }
  Ra.sl[3]=451; /* line # 451 */
  if (F_fs==0) F_fs=22;
  Ra.sl[3]=452; /* line # 452 */
  if (F_intsz<1) F_intsz=1;
  Ra.sl[3]=454; /* line # 454 */
  CPAS__RWNUM_size_double(&F_dv, &Rv1, &Rv2,0);
  Ra.sl[3]=458; /* line # 458 */
  Rv1=Rv1-F_intsz;
  Ra.sl[3]=460; /* line # 460 */
  if (Rv1>=0) Rv3=43;
  else {
    Ra.sl[3]=463; /* line # 463 */
    Rv1= -Rv1;
    Rv3=45;
  }
  Ra.sl[3]=466; /* line # 466 */
  if (Rv1<10) Rv4=2;
  else {
    Ra.sl[3]=467; /* line # 467 */
    if (Rv1<100) Rv4=3;
    else Rv4=4;
  }
  Ra.sl[3]=469; /* line # 469 */
  if (Rv4>F_es) F_es=Rv4;
  Ra.sl[3]=471; /* line # 471 */
  Rv5=F_dcsz>0;
  Ra.sl[3]=472; /* line # 472 */
  Rv6=(((((F_fs-F_dcsz)-F_es)-F_intsz)-(SL)Rv2)-2)-(SL)Rv5;
  Ra.sl[3]=473; /* line # 473 */
  if (Rv6<0) {
    Ra.sl[3]=476; /* line # 476 */
    if (Rv6<0&&Rv3==43) {
      Ra.sl[3]=478; /* line # 478 */
      Rv6=Rv6+1;
      Rv3=32;
    }
    Ra.sl[3]=481; /* line # 481 */
    while (F_es>Rv4&&Rv6<0){
      Ra.sl[3]=483; /* line # 483 */
      F_es=F_es-1;
      Rv6=Rv6+1;
    }
    Ra.sl[3]=486; /* line # 486 */
    if (Rv6<0&&F_dcsz>0) {
      Ra.sl[3]=488; /* line # 488 */
      Rv7=Rv6+F_dcsz;
      Ra.sl[3]=489; /* line # 489 */
      if (Rv7>0) {
        Ra.sl[3]=491; /* line # 491 */
        F_dcsz=Rv7;
        Rv6=0;
      }
      else {
        Ra.sl[3]=494; /* line # 494 */
        if (Rv7==-1&&Rv5) {
          Ra.sl[3]=496; /* line # 496 */
          F_dcsz=0;
          Rv6=0;
          Ra.sl[3]=497; /* line # 497 */
          Rv5=0;
        }
      }
    }
  }
  Ra.sl[3]=502; /* line # 502 */
  Rv8=F_dcsz+F_intsz;
  Ra.sl[3]=503; /* line # 503 */
  F_dv=F_dv+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
  Ra.sl[3]=504; /* line # 504 */
  if (F_dv>=1.000000000000000E+000) {
    Ra.sl[3]=506; /* line # 506 */
    F_dv=F_dv*1.000000000000000E-001;
    Ra.sl[3]=507; /* line # 507 */
    if (Rv3==45) {
      Ra.sl[3]=509; /* line # 509 */
      Rv1=Rv1-1;
      Ra.sl[3]=510; /* line # 510 */
      if (Rv1==0) Rv3=43;
    }
    else {
      Ra.sl[3]=514; /* line # 514 */
      Rv1=Rv1+1;
      Ra.sl[3]=515; /* line # 515 */
      if (Rv1>=10) {
        Ra.sl[3]=517; /* line # 517 */
        if (Rv3==43) {
          Ra.sl[3]=519; /* line # 519 */
          Rv3=32;
          Rv6=Rv6+1;
        }
        Ra.sl[3]=521; /* line # 521 */
        if (Rv1==10&&F_es==1) {
          Ra.sl[3]=522; /* line # 522 */
          F_es=2;
          Rv6=Rv6-1;
        }
        else {
          Ra.sl[3]=524; /* line # 524 */
          if (Rv1==100&&F_es==2) {
            Ra.sl[3]=525; /* line # 525 */
            F_es=3;
            Rv6=Rv6-1;
          }
        }
      }
      Ra.sl[3]=528; /* line # 528 */
      if (Rv6<0) {
        Ra.sl[3]=530; /* line # 530 */
        if (Rv8>1) {
          Ra.sl[3]=532; /* line # 532 */
          Rv8=Rv8-1;
          Ra.sl[3]=533; /* line # 533 */
          if (F_intsz<=Rv8) {
            Ra.sl[3]=535; /* line # 535 */
            if (Rv8==F_intsz) {
              Ra.sl[3]=537; /* line # 537 */
              Rv5=0;
              Rv6=Rv6+1;
            }
          }
          else {
            Ra.sl[3]=542; /* line # 542 */
            F_intsz=F_intsz-1;
            Ra.sl[3]=543; /* line # 543 */
            Rv1=Rv1+1;
          }
          Ra.sl[3]=545; /* line # 545 */
          Rv6=Rv6+1;
        }
      }
    }
  }
  Ra.sl[3]=551; /* line # 551 */
  if (Rv6<0) {
    Ra.sl[3]=552; /* line # 552 */
    for( Rf0=F_fs;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  else {
    Ra.sl[3]=555; /* line # 555 */
    if (Rv0) Rv6=0;
    Ra.sl[3]=556; /* line # 556 */
    if (Rv6>0) {
      Ra.sl[3]=557; /* line # 557 */
      for( Rf0=Rv6;Rf0>0;Rf0-- )
      PAS__WRITE_CHAR(32);
    }
    Ra.sl[3]=559; /* line # 559 */
    CPAS__RWNUM_put_decimal(F_dv, Rv8, F_intsz, Rv2);
    Ra.sl[3]=561; /* line # 561 */
    PAS__WRITE_CHAR(69);
    Ra.sl[3]=563; /* line # 563 */
    if (Rv3!=32) PAS__WRITE_CHAR(Rv3);
    Ra.sl[3]=565; /* line # 565 */
    PAS__WRITE_INT(Rv1, -F_es,10);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pas__put_f_dble "  */
void P_pas__put_f_dble(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  UB Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+228;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=582; /* line # 582 */
  if (F_dcsz==-1) F_dcsz=7;
  else {
    Ra.sl[3]=583; /* line # 583 */
    F_dcsz=abs(F_dcsz);
  }
  Ra.sl[3]=584; /* line # 584 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[3]=585; /* line # 585 */
  if (F_fs<0) F_fs=abs(F_fs);
  Ra.sl[3]=586; /* line # 586 */
  if (F_fs==0) F_fs=20;
  Ra.sl[3]=587; /* line # 587 */
  if (F_dcmin<0) F_dcmin=abs(F_dcmin);
  Ra.sl[3]=590; /* line # 590 */
  Rv0=F_dv;
  Ra.sl[3]=591; /* line # 591 */
  CPAS__RWNUM_size_double(&Rv0, &Rv1, &Rv2,1);
  Ra.sl[3]=594; /* line # 594 */
  if (Rv1>1) Rv3=Rv1;
  else {
    Ra.sl[3]=595; /* line # 595 */
    Rv3=1;
  }
  Ra.sl[3]=596; /* line # 596 */
  Rv4=F_dcsz>0;
  Ra.sl[3]=599; /* line # 599 */
  Rv5=(((F_fs-(SL)Rv2)-F_dcsz)-Rv3)-(SL)Rv4;
  Ra.sl[3]=601; /* line # 601 */
  Rv6=F_dcsz+Rv1;
  Ra.sl[3]=602; /* line # 602 */
  Rv7=F_dcsz;
  Ra.sl[3]=603; /* line # 603 */
  if ((Rv1<=0&&Rv6<F_dcmin)&&F_dcmin>0) {
    Ra.sl[3]=605; /* line # 605 */
    Rv7= -Rv1+F_dcmin;
    Ra.sl[3]=606; /* line # 606 */
    Rv5=((F_fs-Rv7)-2)-(SL)Rv2;
    Ra.sl[3]=607; /* line # 607 */
    if (!Rv4&&Rv7>0) {
      Ra.sl[3]=608; /* line # 608 */
      Rv5=Rv5-1;
      Rv4=1;
    }
  }
  else {
    Ra.sl[3]=612; /* line # 612 */
    if (Rv5<0) {
      Ra.sl[3]=614; /* line # 614 */
      Rv6=Rv5+Rv7;
      Ra.sl[3]=615; /* line # 615 */
      if (Rv6>=0) {
        Ra.sl[3]=617; /* line # 617 */
        Rv7=Rv6;
        Ra.sl[3]=618; /* line # 618 */
        if (Rv7>0) Rv5=0;
        else {
          Ra.sl[3]=620; /* line # 620 */
          Rv4=0;
          Rv5=1;
        }
      }
      else {
        Ra.sl[3]=623; /* line # 623 */
        if (Rv6==-1&&Rv4) {
          Ra.sl[3]=625; /* line # 625 */
          Rv7=0;
          Rv5=0;
          Ra.sl[3]=626; /* line # 626 */
          Rv4=0;
        }
      }
    }
  }
  Ra.sl[3]=631; /* line # 631 */
  if (Rv5>=0) {
    Ra.sl[3]=633; /* line # 633 */
    Rv8=Rv3+Rv7;
    Ra.sl[3]=634; /* line # 634 */
    Rv0=Rv0+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
    Ra.sl[3]=635; /* line # 635 */
    if (Rv0>=1.000000000000000E+000) {
      Ra.sl[3]=637; /* line # 637 */
      Rv0=Rv0*1.000000000000000E-001;
      Ra.sl[3]=638; /* line # 638 */
      Rv3=Rv3+1;
      Ra.sl[3]=639; /* line # 639 */
      Rv5=Rv5-1;
      Rv8=Rv8+1;
    }
  }
  Ra.sl[3]=644; /* line # 644 */
  if (Rv5<0) {
    Ra.sl[3]=645; /* line # 645 */
    P_pas__put_e_dble(F_dv, F_fs,1, F_dcsz,0);
  }
  else {
    Ra.sl[3]=649; /* line # 649 */
    for( Rf0=Rv5;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(32);
    Ra.sl[3]=651; /* line # 651 */
    CPAS__RWNUM_put_decimal(Rv0, Rv8, Rv3, Rv2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_dble "  */
void PAS__WRITE_DBLE(G F_fl, SL F_f, SL F_d, SL F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+245;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=659; /* line # 659 */
  if (F_f==0) F_f=-22;
  Ra.sl[3]=660; /* line # 660 */
  if (F_d<0||F_f<0) {
    Ra.sl[3]=661; /* line # 661 */
    P_pas__put_e_dble(F_fl, F_f,1, F_d,3);
  }
  else {
    Ra.sl[3]=662; /* line # 662 */
    P_pas__put_f_dble(F_fl, F_f, F_d, F_s);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_sngl "  */
void PAS__WRITE_SNGL(F F_fl, SL F_f, SL F_d, SL F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+257;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=669; /* line # 669 */
  if (F_f==0) F_f=-16;
  Ra.sl[3]=670; /* line # 670 */
  if (F_d<0||F_f<0) {
    Ra.sl[3]=671; /* line # 671 */
    P_pas__put_e_dble((double)F_fl, F_f,1, F_d,2);
  }
  else {
    Ra.sl[3]=672; /* line # 672 */
    P_pas__put_f_dble((double)F_fl, F_f, F_d, F_s);
  }
  PAS__curr_cntx=Ra.v[0];
}
