/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 1168 ) = {{
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  60,  60,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  47, 112,  99,
109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115, 101, 116,
 95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,   9,   9,
115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  97,
114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,  97, 114,
101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,  99, 111,
109, 112,  95, 115,  99,  97, 108,  97, 114,  13,  13,  99, 104, 105, 108, 100,
114, 101, 110,  95, 116, 121, 112, 101,  13,  13, 115, 117,  98,  95,  99, 111,
109, 112,  95, 116, 121, 112, 101,   1,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   3,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   4,   0,   1,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,
  0,   0,   4,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,
  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   1,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   4,   4,   4,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,
  0,   4,   4,   0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   4,   4,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,
  4,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,
  4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   4,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0,
  4,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,
  0,   0,   0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   4,   4,   4,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   9,   9,  99, 111, 109,
112,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112, 114, 111,
 99,  95,  97, 114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97, 114, 109,
 95,  99, 116, 101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,  49,  21,
 21, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,  95, 114,
101, 108, 101,  97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,  95, 105,
110,  95,  97, 114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110, 103,  95,
105, 110,  95, 115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16, 105, 110,
105, 116, 105,  97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,  15,  15,
116, 121, 112, 101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114, 109,   4,
  4,  84,  89,  67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,  95, 115,
101, 116,  95, 118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,  95, 112,
 97, 114, 109,  95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,  12, 105,
110, 105, 116,  95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100, 121, 110,
 95, 114, 101,  99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,  95, 100,
121, 110,  95, 114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100, 121, 110,
 95, 100,   4,   4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,  95, 100,
 95, 100, 121, 110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110, 105, 116,
 95, 100,  95, 116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10, 105, 110,
105, 116,  95, 100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,  13,  13,
105, 110, 105, 116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,   4,  73,
 68,  83,  84,  12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97, 114,  98,
108,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,   4,   4,
 69,  67,  85,  78,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,  98, 105,
110,   4,   4,  69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95, 102, 111,
114,  95, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,  99,  97,
108, 108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,  76,  76,
 14,  14, 103, 101, 110, 101, 114, 105,  99,  95, 115, 101,  97, 114,  99, 104,
  4,   4,  71,  69,  78,  83,  11,  11, 101, 120, 112,  95, 103, 101, 110, 111,
112, 101, 114,  13,  13, 103, 101, 110, 101, 114,  97, 116, 101,  95,  99,  97,
108, 108,   9,   9, 101, 120, 112,  95, 103, 101, 110, 111, 112,  13,  13, 108,
103, 116,  95, 103, 101, 110,  95, 115, 116, 111, 114, 101,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {{
 29,   0,   0,   0,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 248 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern Blk(V_oparg_cvtab, 56 );
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=93; /* line # 93 */
  if (V_sy_sym.ub[0]==5) {
    (*F_nam)=PAS__NEW(32);
    Rv0=(*F_nam);
    Ra.sl[6]=98; /* line # 98 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else((UB *)Rv0)[0]=V_sy_string.ub[1];
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=103; /* line # 103 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+75;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=118; /* line # 118 */
  Rv0=F_pr;
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+90,129,1);
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=124; /* line # 124 */
    ((V *)Rv0)[3]=NULL;
    P_src_error(Rd.s+90,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=139; /* line # 139 */
  V_enm_range=0;
  Rv0=F_ty1==F_ty2;
  if (!Rv0) {
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=144; /* line # 144 */
      if (((((UB *)F_ty1)[92]==((UB *)F_ty2)[92]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) switch ((
      (UB *)F_ty1)[92]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=150; /* line # 150 */
        if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)F_ty2)
        [29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) Rv0=1;
        break;
        case 3:
        case 4:Rv0=1;
        break;
        case 5:
        case 7:
        case 13:Ra.sl[6]=155; /* line # 155 */
        Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
        break;
        case 11:
        case 12:if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) Rv0=P_same_type(((V *)
        F_ty1)[13],((V *)F_ty2)[13]);
        break;
        case 8:
        case 9:Ra.sl[6]=160; /* line # 160 */
        if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
        [25]) {
          if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
          F_ty1)[14],((V *)F_ty2)[14])) Rv0=1;
        }
        break;
        case 22:Ra.sl[6]=166; /* line # 166 */
        Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
        break;
        case 6:Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=171; /* line # 171 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=184; /* line # 184 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Rv0=0;
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=190; /* line # 190 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else Rv0=1;
      if (Rv0) {
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=198; /* line # 198 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Rv0=P_same_type(((V *)Rv1)[4],((V *)Rv2)[4]);
          if (Rv0) {
            Ra.sl[6]=204; /* line # 204 */
            if (((UB *)Rv1)[56]==7) {
              if (((UB *)Rv2)[56]==7) {
                if (((UB *)((V *)Rv1)[9])[104]==3&&((UB *)((V *)Rv2)[9])[104]==3)
                 Rv0=P_compare_entry(((V *)Rv1)[9],((V *)Rv2)[9]);
                else Rv0=0;
              }
              else {
                Ra.sl[6]=209; /* line # 209 */
                Rv0=0;
              }
            }
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=217; /* line # 217 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+120;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=231; /* line # 231 */
  Rv0=0;
  if (F_pgc!=NULL&&F_ent!=NULL) while (F_pgc!=NULL&&!Rv0){
    Ra.sl[6]=236; /* line # 236 */
    Rv1=F_pgc;
    if (!((UB *)Rv1)[8]) {
      Rv2=((V *)Rv1)[2];
      Ra.sl[6]=241; /* line # 241 */
      Rv0=P_compare_entry(Rv2, F_ent);
    }
    if (!Rv0) {
      if (F_pgc==F_pgl) F_pgc=NULL;
      else F_pgc=((V *)F_pgc)[0];
    }
  }
  Ra.sl[6]=248; /* line # 248 */
  if (!Rv0) F_pgc=NULL;
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+140;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=268; /* line # 268 */
  Rv0=4;
  if (F_te==F_tf) Rv0=0;
  else {
    if (F_te!=NULL&&F_tf!=NULL) {
      Rv1=F_te;
      if (((UB *)Rv1)[92]==((UB *)F_tf)[92]) {
        Ra.sl[6]=273; /* line # 273 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          if (((UB *)Rv1)[112]) {
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=279; /* line # 279 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Rv4=F_tf;
          if (((UB *)Rv4)[112]) {
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=284; /* line # 284 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=290; /* line # 290 */
            if (Rv2==Rv5) {
              if (Rv3==Rv6) Rv0=0;
              else Rv0=1;
            }
            else Rv0=2;
          }
          else Rv0=3;
        }
        else {
          Ra.sl[6]=296; /* line # 296 */
          V_enm_range=1;
        }
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " children_type "  */
UB P_children_type(V F_eff, V F_frm, UB F_bpar, UB F_bsym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+153;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=311; /* line # 311 */
  if (F_frm!=NULL) {
    F_bpar=1;
    if (F_bpar) {
      Ra.sl[6]=316; /* line # 316 */
      Rv1=F_eff;
      while (Rv1!=NULL&&Rv1!=F_frm)
      Rv1=((V *)Rv1)[0];
      Rv0=Rv1==F_frm;
      if (!Rv0&&F_bsym) Rv0=P_children_type(F_frm, F_eff, F_bpar,0);
    }
    else {
      Ra.sl[6]=321; /* line # 321 */
      Rv0=F_eff==F_frm;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sub_comp_type "  */
UB PAS_EXPSION_PRC_00000000(V F_eff, V F_frm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+168;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=379; /* line # 379 */
  Rv0=0;
  Rv1=F_frm;
  switch (Rd.ub[((UB *)F_eff)[92]*22+((UB *)Rv1)[92]+183]) {
    case 4:Rv0=1;
    break;
    case 1:Ra.sl[6]=385; /* line # 385 */
    switch (((UB *)Rv1)[92]) {
      case 0:
      case 1:
      case 2:if (((UB *)Rv1)[88]) {
        Ra.sl[6]=390; /* line # 390 */
        if (!Lx[0].ub[28]) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
        else Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv1)[11]==((SL
         *)F_eff)[11];
      }
      break;
      case 11:
      case 12:Ra.sl[6]=395; /* line # 395 */
      Rv0=P_comp_type(((V *)F_eff)[13],((V *)Rv1)[13],Lx[0].ub[28],0);
      break;
      case 8:Rv0=((V *)F_eff)[14]==((V *)Rv1)[14]&&P_comp_type(((V *)F_eff)[15],(
      (V *)Rv1)[15],1,1);
      break;
      case 9:Ra.sl[6]=402; /* line # 402 */
      Rv0=P_comp_type(((V *)F_eff)[14],((V *)Rv1)[14],1,0)&&P_comp_type(((V *)F_eff)
      [15],((V *)((V *)Rv1)[15])[0],1,1);
      break;
      case 5:if (((V *)Rv1)[12]==NULL) Rv0=1;
      else {
        Ra.sl[6]=407; /* line # 407 */
        Rv0=P_comp_type(((V *)F_eff)[12],((V *)Rv1)[12],1,1);
      }
      break;
      case 6:if (((V *)Rv1)[13]==NULL) Rv0=1;
      else Rv0=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv1)[13]);
      break;
      default:break;
    }
    break;
    case 3:Ra.sl[6]=417; /* line # 417 */
    Rv0=P_comp_type(F_frm, V_typ_std.v[10],0,0);
    break;
    case 2:if (P_comp_type(F_eff, V_typ_std.v[10],0,0)) {
      Ra.sl[6]=422; /* line # 422 */
      Rv0=P_comp_type(((V *)((V *)F_eff)[13])[4],F_frm,0,0);
    }
    break;
    default:break;
  }
  Ra.sl[6]=427; /* line # 427 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_exact;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+667;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=432; /* line # 432 */
  V_enm_range=0;
  Rv0=0;
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=437; /* line # 437 */
    Rv0=P_children_type(F_eff, F_frm,!Ra.ub[28],F_sym);
    if (!Rv0) {
      Rv1=F_frm;
      if (((UB *)Rv1)[92]==22) {
        Ra.sl[6]=442; /* line # 442 */
        Rv0=P_comp_type(((V *)Rv1)[0],F_eff, Ra.ub[28],0);
      }
      if (!Rv0) {
        if (((UB *)F_eff)[92]<=21&&((UB *)Rv1)[92]<=21) {
          Ra.sl[6]=447; /* line # 447 */
          Rv0=PAS_EXPSION_PRC_00000000(F_eff, F_frm);
          if (!Rv0&&F_sym) Rv0=PAS_EXPSION_PRC_00000000(F_frm, F_eff);
        }
      }
    }
  }
  Ra.sl[6]=452; /* line # 452 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+678;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=466; /* line # 466 */
  Rv0=1;
  if (F_epr!=F_fpr) {
    if (F_epr!=NULL&&F_fpr!=NULL) {
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=471; /* line # 471 */
        Rv0=0;
      }
      else {
        Rv1=((V *)F_epr)[8];
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=476; /* line # 476 */
        if (((V *)F_epr)[11]!=NULL) {
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          if (((UB *)Rv2)[56]!=((UB *)Rv1)[56]) Rv0=0;
          else {
            Ra.sl[6]=482; /* line # 482 */
            switch (((UB *)Rv2)[56]) {
              case 5:Rv0=P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],((UB *)Rv2)[94]
              !=8,0);
              break;
              case 7:Ra.sl[6]=487; /* line # 487 */
              if (P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1,0)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[9],((V *)Rv2)[9]);
              else Rv0=0;
              break;
              default:break;
            }
          }
          Ra.sl[6]=493; /* line # 493 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
      }
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=499; /* line # 499 */
      Rv0=0;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+693;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=518; /* line # 518 */
  if (F_ty!=NULL) {
    Rv0=F_ty;
    Rv1=((V *)Rv0)[4];
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=523; /* line # 523 */
    while (Rv1!=NULL){
      Rv3=Rv1;
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Rv5=Rv4;
      Ra.sl[6]=529; /* line # 529 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+715,132,3);
      else {
        Rv6=((V *)Rv5)[7];
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[4])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[4];
      }
      Ra.sl[6]=534; /* line # 534 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[15];
      ((V *)Rv3)[10]=Rv4;
      ((UB *)Rv3)[64]=1;
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=539; /* line # 539 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      (*F_lghl)=Rv4;
      (*F_count)=(*F_count)+1;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+719;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=558; /* line # 558 */
  Rv0=((V *)F_ty)[4];
  while (Rv0!=NULL){
    Rv1=Rv0;
    ((UB *)Rv1)[64]=0;
    Ra.sl[6]=563; /* line # 563 */
    ((V *)Rv1)[10]=NULL;
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+742;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=581; /* line # 581 */
  if (((V *)F_lgt)[7]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=NULL;
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=586; /* line # 586 */
    Rv4=NULL;
    Rv5=NULL;
    Rv6=0;
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=596; /* line # 596 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      while (Rv4!=NULL){
        Rv5=Rv4;
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=601; /* line # 601 */
        Rv7=Rv5;
        Rv8=NULL;
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=606; /* line # 606 */
          ((V *)Rv2)[0]=Rv8;
        }
        Rv2=Rv8;
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=611; /* line # 611 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    if (Rv3<=0) {
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=616; /* line # 616 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=621; /* line # 621 */
      if (Rv3<=0) Rv3=1;
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else((V *)Rv2)[0]=((V *)Rv0)[7];
      Rv2=((V *)Rv0)[7];
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=626; /* line # 626 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=631; /* line # 631 */
        ((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
      }
      break;
      case 29:Ra.sl[6]=638; /* line # 638 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      if (Rv10==NULL) Rv11=0;
      else Rv11=((UB *)Rv10)[1];
      if (Rv3<=0) {
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=644; /* line # 644 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          if (Rv12!=NULL) {
            Rv13=Rv12;
            if (((UB *)Rv13)[40]==14) {
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=651; /* line # 651 */
      if (Rv3<=0) Rv3=Rv11;
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=656; /* line # 656 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else((SL *)Rv8)[13]=32;
        if (Rv2==NULL) Rv9=Rv8;
        else((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=665; /* line # 665 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    P_val_new(((V *)Rv0)+7,F_ty);
    Rv15=((V *)Rv0)[7];
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=670; /* line # 670 */
    ((SL *)Rv15)[6]=Rv3;
    ((SL *)Rv15)[2]=Rv6;
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=676; /* line # 676 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+759;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=690; /* line # 690 */
  if (((V *)F_lgt)[7]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=((V *)Rv0)[7];
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=695; /* line # 695 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Rv3=((V *)Rv0)[7];
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=702; /* line # 702 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+780;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=714; /* line # 714 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[6];
  ((UW *)Rv0)[46]=((UW *)Rv0)[46]|8;
  P_lgt_new(&Rv2,((V *)Rv0)[4],14,NULL);
  Ra.sl[6]=719; /* line # 719 */
  Rv3=Rv2;
  ((V *)Rv3)[7]=((V *)Rv0)[8];
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=724; /* line # 724 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  if (((UB *)((V *)Rv0)[4])[92]==7||((UB *)((V *)Rv0)[4])[92]==16) Rv2=P_lgt_new_code(3,
  Rv2);
  else {
    Ra.sl[6]=730; /* line # 730 */
    Rv2=P_exp_genop(28, Rv2);
  }
  switch (((UB *)Rv1)[104]) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:Ra.sl[6]=736; /* line # 736 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else((V *)((V *)Rv1)[17])[0]=Rv2;
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+798;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=758; /* line # 758 */
  Rv0=F_lgt;
  switch (((UB *)Rv0)[40]) {
    case 13:Rv1=((V *)Rv0)[6];
    if (((UB *)Rv1)[56]!=2) {
      Ra.sl[6]=764; /* line # 764 */
      P_src_error_s(Rd.s+817,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=770; /* line # 770 */
    Rv2=((V *)Rv0)[1];
    while (Rv2!=NULL){
      P_type_check_parm(Rv2);
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=776; /* line # 776 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=784; /* line # 784 */
      P_src_error(Rd.s+817,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=790; /* line # 790 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+817,203,3);
    break;
    default:P_src_error(Rd.s+817,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000001(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+821;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=818; /* line # 818 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=824; /* line # 824 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+840;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=835; /* line # 835 */
  Rv0=0;
  Rv1=F_lgt;
  Rv2=F_ip;
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=840; /* line # 840 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Rv4=Rv3;
    Rv5=Rv1;
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[4],0,0)) {
      Ra.sl[6]=847; /* line # 847 */
      P_type_check_parm(Rv1);
      ((UB *)Rv4)[64]=2;
      ((V *)Rv4)[10]=Rv1;
    }
    else {
      Ra.sl[6]=852; /* line # 852 */
      P_src_error_s(Rd.s+857,201,3,((V *)Rv4)[0],NULL);
    }
    Rv1=((V *)Rv1)[0];
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=858; /* line # 858 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+857,998,3);
  if (((UB *)((V *)Rv2)[4])[92]==27) {
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[4])[9],NULL,NULL,0);
    Ra.sl[6]=864; /* line # 864 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else P_src_error(Rd.s+857,222,3);
  }
  else {
    Ra.sl[6]=869; /* line # 869 */
    P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv6);
    Rv7=Rv6;
    ((UB *)Rv7)[89]=1;
    ((V *)Rv7)[0]=((V *)Rv2)[4];
    Ra.sl[6]=874; /* line # 874 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[4])[4];
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[4])[11];
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[4])[10];
    memcpy(Rv7+48,((V *)Rv2)[4]+48,1);
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[4])[10];
    Ra.sl[6]=879; /* line # 879 */
    ((UB *)Rv7)[90]=((UB *)((V *)Rv2)[4])[90];
    V_sy_type_gfirst=((V *)Rv2)[10];
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=884; /* line # 884 */
    PAS_EXPSION_PRC_00000001(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[4])[9]
    );
    switch (((UB *)Rv7)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=889; /* line # 889 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=897; /* line # 897 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[4])[12]);
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[4])[14]);
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[4])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=905; /* line # 905 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=919; /* line # 919 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[4])
      [13]);
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=932; /* line # 932 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      if (((V *)((V *)Rv7)[0])[14]!=NULL) ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)
      Rv7)[0])[14]);
      else {
        Ra.sl[6]=937; /* line # 937 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=942; /* line # 942 */
      P_src_error(Rd.s+857,998,3);
      break;
    }
  }
  Ra.sl[6]=948; /* line # 948 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  while (Rv3!=NULL){
    Rv8=Rv3;
    Ra.sl[6]=953; /* line # 953 */
    ((V *)Rv8)[10]=NULL;
    ((UB *)Rv8)[64]=0;
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=959; /* line # 959 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+861;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=993; /* line # 993 */
  Rv0=F_ty;
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Rv1=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
    Ra.sl[6]=1000; /* line # 1000 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Rv2=P_lgt_new_code(3, Rv1);
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[6]=1005; /* line # 1005 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    (*F_lgl)=Rv2;
    Rv3=1;
    Ra.sl[6]=1010; /* line # 1010 */
    if (((V *)Rv0)[13]!=NULL) {
      Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
      if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
        Ra.sl[6]=1016; /* line # 1016 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[6]=1022; /* line # 1022 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else((V *)(*F_lgl))[0]=Rv2;
        (*F_lgl)=Rv2;
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1028; /* line # 1028 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
    }
    if (Lx[2].ub[28]) {
      Ra.sl[6]=1033; /* line # 1033 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
    }
    else P_lgt_new_copy(F_trg, &Rv2);
    Ra.sl[6]=1038; /* line # 1038 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Rv6=Rv2;
    ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
    P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
    Ra.sl[6]=1043; /* line # 1043 */
    Rv7=((V *)Rv0)[14];
    Rv8=Rv2;
    ((V *)Rv8)[6]=F_ty;
    if (((UB *)Rv7)[92]!=10&&((UB *)Rv7)[92]!=23) ((SL *)Rv8)[4]=((SL *)Rv8)[4]+
    ((SL *)Rv7)[10];
    Ra.sl[6]=1048; /* line # 1048 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=1057; /* line # 1057 */
    Rv9=((V *)Rv0)[15];
    if (((UB *)Rv9)[92]!=22) {
      if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
      else Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
      Ra.sl[6]=1062; /* line # 1062 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
    }
    else Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
    Rv12=Rv11;
    Ra.sl[6]=1067; /* line # 1067 */
    PAS_EXPSION_PRC_00000002(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[6]=1078; /* line # 1078 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    ((UB *)Rv5)[41]=5;
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[6]=1083; /* line # 1083 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000005(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+875;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1108; /* line # 1108 */
  Rv0=NULL;
  Rv1=NULL;
  PAS_EXPSION_PRC_00000004(F_ty, Lx[1].v[4],&Rv0, &Rv1);
  if (Rv0!=NULL) {
    Ra.sl[6]=1113; /* line # 1113 */
    if (Rv1!=Rv0) {
      P_lgt_new(&Rv0,NULL,0, Rv0);
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1119; /* line # 1119 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+888;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1125; /* line # 1125 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[12];
  while (Rv1!=NULL){
    Ra.sl[6]=1130; /* line # 1130 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1135; /* line # 1135 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        if (Lx[2].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[4],2, P_lgt_link(Ra.v[4]));
        else P_lgt_new_copy(Ra.v[4],&Rv4);
        Ra.sl[6]=1140; /* line # 1140 */
        Rv5=Rv4;
        ((V *)Rv5)[4]=Rv1;
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[15];
        Ra.sl[6]=1147; /* line # 1147 */
        if (((UB *)Rv3)[92]!=10&&((UB *)Rv3)[92]!=23) ((SL *)Rv5)[4]=((SL *)Rv5)
        [4]+((SL *)((V *)Rv2)[4])[10];
        PAS_EXPSION_PRC_00000002(((V *)Rv2)[4],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1152; /* line # 1152 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[6]=1157; /* line # 1157 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1162; /* line # 1162 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else((V *)(*F_lgl))[0]=Rv6;
    (*F_lgl)=Rv6;
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1168; /* line # 1168 */
    P_lgt_new_copy(Rv7, &Rv4);
    ((V *)Rv6)[1]=Rv4;
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1173; /* line # 1173 */
    Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
    ((V *)Rv4)[0]=Rv6;
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1178; /* line # 1178 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    ((V *)Rv6)[0]=Rv4;
    Rv7=((V *)Rv7)[0];
    while (Rv7!=NULL){
      Ra.sl[6]=1183; /* line # 1183 */
      Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
      ((V *)Rv4)[0]=Rv6;
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+902;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1212; /* line # 1212 */
  Rv0=F_ty;
  if (((V *)Rv0)[4]!=NULL) {
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1217; /* line # 1217 */
    Rv2=((V *)Rv0)[7];
    while (Rv1!=NULL&&Rv2!=NULL){
      Rv3=Rv1;
      Ra.sl[6]=1222; /* line # 1222 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[4],2, P_lgt_link(F_trg));
      else P_lgt_new_copy(F_trg, &Rv4);
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1228; /* line # 1228 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
      if (((UB *)Rv6)[92]!=10&&((UB *)Rv6)[92]!=23) ((SL *)Rv5)[4]=((SL *)Rv5)[4]
      -((SL *)Rv6)[10];
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[4],0);
      Ra.sl[6]=1233; /* line # 1233 */
      ((V *)Rv3)[10]=((V *)Rv5)[0];
      ((UB *)Rv3)[64]=1;
      P_lgt_new(&Rv4,((V *)Rv3)[4],6, Rv4);
      Ra.sl[6]=1238; /* line # 1238 */
      ((UB *)Rv4)[41]=3;
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else((V *)(*F_lgl))[0]=Rv4;
      Ra.sl[6]=1243; /* line # 1243 */
      (*F_lgl)=Rv4;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1249; /* line # 1249 */
  if (((UB *)Rv0)[90]) switch (((UB *)Rv0)[92]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgh,F_lgl);
    break;
    case 8:
    case 9:Ra.sl[6]=1255; /* line # 1255 */
    PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
    break;
    default:P_src_error(Rd.s+916,131,3);
    break;
  }
  Ra.sl[6]=1261; /* line # 1261 */
  Rv1=((V *)F_ty)[4];
  while (Rv1!=NULL){
    Rv7=Rv1;
    ((V *)Rv7)[10]=NULL;
    Ra.sl[6]=1266; /* line # 1266 */
    ((UB *)Rv7)[64]=0;
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+920;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1274; /* line # 1274 */
  if (((UB *)F_ty)[90]) switch (((UB *)F_ty)[92]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    case 8:
    case 9:Ra.sl[6]=1281; /* line # 1281 */
    PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    default:P_src_error(Rd.s+934,131,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+938;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1314; /* line # 1314 */
  Rv0=F_ty;
  if (((V *)Rv0)[15]!=NULL) {
    Rv1=((V *)Rv0)[15];
    if (((UB *)Rv1)[92]!=22) {
      Ra.sl[6]=1319; /* line # 1319 */
      if (((UB *)Rv1)[112]) Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      else Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
    }
    else {
      Ra.sl[6]=1325; /* line # 1325 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      if (((UB *)Rv3)[40]==14) {
        Rv2=((SL *)((V *)Rv3)[7])[13];
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1331; /* line # 1331 */
        P_src_error(Rd.s+952,142,4);
      }
    }
  }
  else Rv2=0;
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1337; /* line # 1337 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    if (((UB *)Rv3)[40]==14) {
      Rv4=((SL *)((V *)Rv3)[7])[13];
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1343; /* line # 1343 */
      P_src_error(Rd.s+952,142,4);
    }
  }
  else Rv4=((SL *)Rv0)[25];
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1349; /* line # 1349 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1354; /* line # 1354 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv7;
    else((V *)Lx[3].v[1])[0]=Rv7;
    Lx[3].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1359; /* line # 1359 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000007(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+956;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1378; /* line # 1378 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[12];
  while (Rv1!=NULL){
    Ra.sl[6]=1383; /* line # 1383 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1388; /* line # 1388 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[4],0);
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1394; /* line # 1394 */
        if (((SL *)Rv3)[11]>0) {
          Rv4=NULL;
          P_val_new(&Rv4, V_typ_std.v[0]);
          Rv6=Rv4;
          Ra.sl[6]=1400; /* line # 1400 */
          Rv5=((SL *)Rv3)[11];
          ((UB *)Rv6)[48]=28;
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1406; /* line # 1406 */
          Rv5=0;
        }
      }
      if (Rv5>0) {
        (*F_iadr)=(*F_iadr)+Rv5;
        if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv4;
        else {
          Ra.sl[6]=1411; /* line # 1411 */
          ((V *)Lx[3].v[1])[0]=Rv4;
        }
        Lx[3].v[1]=Rv4;
      }
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[6]=1419; /* line # 1419 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Rv7=((V *)Rv0)[14];
    Rv8=((V *)Rv7)[1];
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1424; /* line # 1424 */
    Rv10=((V *)Rv9)[0];
    Rv11=Rv8;
    Rv12=((SL *)Rv11)[4];
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1429; /* line # 1429 */
      Rv13=((V *)Rv11)[7];
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1435; /* line # 1435 */
      Rv15=NULL;
    }
    if (((V *)Rv0)[4]!=NULL) {
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1440; /* line # 1440 */
      Rv17=Rv16;
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+970,142,3);
      else {
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else Rv18=Rv12-1;
      }
      Ra.sl[6]=1445; /* line # 1445 */
      P_lgt_free(&Rv16);
    }
    Rv19=((V *)Rv10)[0];
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1450; /* line # 1450 */
      Rv19=Rv9;
    }
    else {
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1457; /* line # 1457 */
        while (Rv18>0&&Rv19!=NULL){
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1464; /* line # 1464 */
    if (Rv19!=NULL) {
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000007(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+974;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1475; /* line # 1475 */
  Rv0=F_ty;
  Rv1=0;
  Ra.v[0]=NULL;
  Ra.v[1]=NULL;
  Ra.sl[10]=1480; /* line # 1480 */
  Rv2=NULL;
  Rv3=NULL;
  Rv4=((SL *)Rv0)[11];
  Rv5=0;
  Ra.sl[10]=1485; /* line # 1485 */
  if (((V *)Rv0)[4]!=NULL) {
    Rv6=((V *)Rv0)[4];
    Rv7=((V *)Rv0)[7];
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1490; /* line # 1490 */
      Rv8=Rv6;
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[4],0);
      ((SL *)Rv9)[4]=((SL *)Rv8)[15];
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1495; /* line # 1495 */
        ((V *)Rv3)[0]=Rv9;
      }
      Rv3=Rv9;
      Rv10=((V *)Rv9)[7];
      P_val_new(&Rv10,((V *)Rv8)[4]);
      ((V *)Rv10)[4]=((V *)Rv8)[4];
      Ra.sl[10]=1500; /* line # 1500 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[4])[11];
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else((V *)Ra.v[1])[0]=Rv10;
      Ra.v[1]=Rv10;
      Ra.sl[10]=1505; /* line # 1505 */
      ((V *)Rv8)[10]=Rv9;
      ((UB *)Rv8)[64]=1;
      Rv7=((V *)Rv7)[0];
      Rv6=((V *)Rv8)[3];
      if (((V *)Rv8)[4]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1510; /* line # 1510 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1515; /* line # 1515 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1520; /* line # 1520 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      P_lgt_free(&Rv7);
    }
    else P_src_error(Rd.s+991,147,4);
  }
  Ra.sl[10]=1525; /* line # 1525 */
  if (F_szw>Rv4) Rv4=F_szw;
  if (((UB *)Rv0)[90]) switch (((UB *)Rv0)[92]) {
    case 10:
    case 23:Ra.sl[10]=1530; /* line # 1530 */
    PAS_EXPSION_PRC_00000007(F_ty, &Rv1);
    break;
    case 8:
    case 9:PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
    break;
    default:Ra.sl[10]=1536; /* line # 1536 */
    P_src_error(Rd.s+991,131,3);
    break;
  }
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1543; /* line # 1543 */
    Rv6=((V *)Rv0)[4];
    while (Rv6!=NULL){
      ((UB *)Rv6)[64]=0;
      ((V *)Rv6)[10]=NULL;
      Ra.sl[10]=1548; /* line # 1548 */
      Rv6=((V *)Rv6)[3];
    }
  }
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1554; /* line # 1554 */
  if (Rv4>Rv1) {
    Rv10=NULL;
    P_val_new(&Rv10,NULL);
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1559; /* line # 1559 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.v[1]=Rv10;
    Rv11=Rv10;
    ((UB *)Rv11)[48]=28;
    Ra.sl[10]=1564; /* line # 1564 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    ((SL *)Rv11)[13]=0;
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1589; /* line # 1589 */
  Rv10=NULL;
  P_val_new(&Rv10, F_ty);
  Rv12=Rv10;
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1594; /* line # 1594 */
  ((SL *)Rv12)[6]=Rv4;
  ((V *)Rv12)[7]=Ra.v[0];
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1603; /* line # 1603 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+995;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1634; /* line # 1634 */
  Rv0=((V *)F_ip)[4];
  if (!((UB *)Rv0)[89]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[6];
  Ra.sl[6]=1640; /* line # 1640 */
  ((UW *)Rv1)[46]=((UW *)Rv1)[46]|16;
  if ((((UB *)Rv1)[94]==6||((UB *)Rv1)[94]==1)&&((SL *)Rv1)[10]>1) {
    Ra.sl[6]=1645; /* line # 1645 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else Rv4=((V *)Rv2)[4];
    Rv5=NULL;
    Rv6=NULL;
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1650; /* line # 1650 */
    Rv8=Rv4;
    while (Rv7!=NULL){
      Ra.sl[6]=1655; /* line # 1655 */
      P_lgt_new(&Rv9,((V *)Rv4)[4],13,NULL);
      Rv10=Rv9;
      Rv11=Rv8;
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      ((SL *)Rv10)[4]=((SL *)Rv11)[15];
      Ra.sl[6]=1660; /* line # 1660 */
      ((V *)Rv11)[10]=Rv9;
      ((UB *)Rv11)[64]=1;
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1666; /* line # 1666 */
      Rv7=((V *)Rv7)[0];
      Rv8=((V *)Rv8)[3];
      Rv12=P_lgt_new_code(3, Rv9);
      if (Rv5==NULL) Rv5=Rv12;
      else((V *)Rv6)[0]=Rv12;
      Ra.sl[6]=1671; /* line # 1671 */
      Rv6=Rv12;
    }
    if (((UB *)Rv2)[90]) {
      Ra.sl[6]=1676; /* line # 1676 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1681; /* line # 1681 */
    if (Rv5!=NULL) switch (((UB *)Rv3)[104]) {
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
      else {
        Ra.sl[6]=1686; /* line # 1686 */
        ((V *)((V *)Rv3)[17])[0]=Rv5;
      }
      ((V *)Rv3)[17]=Rv6;
      break;
      default:break;
    }
    Ra.sl[6]=1691; /* line # 1691 */
    while (Rv4!=NULL){
      Rv13=Rv4;
      ((V *)Rv13)[10]=NULL;
      ((UB *)Rv13)[64]=0;
      Ra.sl[6]=1696; /* line # 1696 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1701; /* line # 1701 */
    if (((V *)Rv1)[8]==NULL) {
      ((UW *)Rv1)[46]=((UW *)Rv1)[46]|8;
      ((V *)Rv1)[8]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1009;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1723; /* line # 1723 */
  if (((V *)F_p)[3]!=NULL) {
    Rv0=F_p;
    Rv1=((V *)Rv0)[3]+8;
    if (((UB *)Rv1)[8]!=0) F_puna=P_exp_val_una(F_puna, V_oparg_cvtab.v[((UB *)Rv1)
    [8]]);
    Ra.sl[6]=1728; /* line # 1728 */
    Rv2=F_puna;
    if (((UB *)Rv2)[40]==14) {
      Rv3=((V *)Rv2)[7];
      ((UW *)Rv2)[10]=1;
      Ra.sl[6]=1733; /* line # 1733 */
      switch (((UB *)Rv0)[9]) {
        case 6:((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]<=0);
        break;
        case 43:((SL *)Rv3)[13]=((SL *)Rv3)[13]+1;
        break;
        case 44:Ra.sl[6]=1738; /* line # 1738 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]-1;
        break;
        case 45:((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]&1);
        break;
        case 10:if (((UB *)Rv3)[48]==11||((UB *)Rv3)[48]==17) {
          Ra.sl[6]=1743; /* line # 1743 */
          if (((SL *)Rv3)[13]>=0) ((SL *)Rv3)[13]=-1-((SL *)Rv3)[13];
          else((SL *)Rv3)[13]= -(1+((SL *)Rv3)[13]);
        }
        break;
        case 46:((SL *)Rv3)[13]= -((SL *)Rv3)[13];
        break;
        case 61:
        case 77:Ra.sl[6]=1749; /* line # 1749 */
        ((G *)Rv3)[7]=-((G *)Rv3)[7];
        break;
        case 47:((SL *)Rv3)[13]=abs(((SL *)Rv3)[13]);
        break;
        case 62:
        case 78:((G *)Rv3)[7]=fabs(((G *)Rv3)[7]);
        break;
        case 48:Ra.sl[6]=1755; /* line # 1755 */
        ((SL *)Rv3)[13]=PAS__I_SQR(((SL *)Rv3)[13]);
        break;
        case 63:
        case 79:((G *)Rv3)[7]=PAS__G_SQR(((G *)Rv3)[7]);
        break;
        case 64:
        case 80:Ra.sl[6]=1760; /* line # 1760 */
        ((G *)Rv3)[7]=(double)((SL *)Rv3)[13];
        break;
        case 65:
        case 81:((SL *)Rv3)[13]=PAS__G_ROUND(((G *)Rv3)[7]);
        break;
        case 66:
        case 82:((SL *)Rv3)[13]=(int)(((G *)Rv3)[7]);
        break;
        case 92:
        case 110:Ra.sl[6]=1767; /* line # 1767 */
        if (((G *)Rv3)[7]<0.000000000000000E-001) P_src_error(Rd.s+1024,801,2);
        else((G *)Rv3)[7]=sqrt(((G *)Rv3)[7]);
        break;
        case 93:
        case 111:((G *)Rv3)[7]=sin(((G *)Rv3)[7]);
        break;
        case 94:
        case 112:Ra.sl[6]=1773; /* line # 1773 */
        ((G *)Rv3)[7]=cos(((G *)Rv3)[7]);
        break;
        case 95:
        case 113:((G *)Rv3)[7]=tan(((G *)Rv3)[7]);
        break;
        case 96:
        case 114:Ra.sl[6]=1779; /* line # 1779 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1024,802,2);
        else((G *)Rv3)[7]=asin(((G *)Rv3)[7]);
        break;
        case 97:
        case 115:if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.
        s+1024,803,2);
        else {
          Ra.sl[6]=1784; /* line # 1784 */
          ((G *)Rv3)[7]=acos(((G *)Rv3)[7]);
        }
        break;
        case 98:
        case 116:((G *)Rv3)[7]=atan(((G *)Rv3)[7]);
        break;
        case 102:
        case 120:Ra.sl[6]=1789; /* line # 1789 */
        ((G *)Rv3)[7]=PAS__SHG(((G *)Rv3)[7]);
        break;
        case 103:
        case 121:((G *)Rv3)[7]=PAS__CHG(((G *)Rv3)[7]);
        break;
        case 104:
        case 122:((G *)Rv3)[7]=PAS__THG(((G *)Rv3)[7]);
        break;
        case 105:
        case 123:Ra.sl[6]=1796; /* line # 1796 */
        ((G *)Rv3)[7]=PAS__ASHG(((G *)Rv3)[7]);
        break;
        case 106:
        case 124:if (((G *)Rv3)[7]<1.000000000000000E+000) P_src_error(Rd.s+1024,805,2);
        else((G *)Rv3)[7]=PAS__ACHG(((G *)Rv3)[7]);
        break;
        case 107:
        case 125:Ra.sl[6]=1803; /* line # 1803 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1024,806,2);
        else((G *)Rv3)[7]=PAS__ATHG(((G *)Rv3)[7]);
        break;
        case 100:
        case 118:((G *)Rv3)[7]=exp(((G *)Rv3)[7]);
        break;
        case 101:
        case 119:Ra.sl[6]=1810; /* line # 1810 */
        if (((G *)Rv3)[7]<=0.000000000000000E-001) P_src_error(Rd.s+1024,804,2);
        else((G *)Rv3)[7]=log(((G *)Rv3)[7]);
        break;
        default:break;
      }
      Ra.sl[6]=1815; /* line # 1815 */
      ((V *)Rv2)[4]=NULL;
      if (64&((UW *)Rv1)[5]) ((V *)Rv2)[3]=((V *)Rv1)[0];
      else((V *)Rv2)[3]=((V *)Rv0)[2];
      ((V *)Rv3)[4]=((V *)Rv2)[3];
      Ra.sl[6]=1820; /* line # 1820 */
      ((UB *)Rv3)[48]=((UB *)((V *)Rv2)[3])[92];
    }
    else {
      if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+1024,851,2);
      Ra.sl[6]=1825; /* line # 1825 */
      if (((UB *)Rv0)[9]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])
      [11]) {
        P_lgt_new(&Rv4,((V *)Rv0)[2],6, F_puna);
        Rv5=Rv4;
        Ra.sl[6]=1831; /* line # 1831 */
        if (64&((UW *)Rv1)[5]) ((V *)Rv5)[3]=((V *)Rv1)[0];
        ((V *)Rv5)[0]=((V *)F_puna)[0];
        ((UB *)Rv5)[41]=((UB *)Rv0)[9];
        ((UW *)Rv5)[10]=((UW *)F_puna)[10]&~2;
        Ra.sl[6]=1836; /* line # 1836 */
        ((V *)Rv2)[0]=NULL;
        F_puna=Rv4;
      }
      else((V *)F_puna)[3]=((V *)Rv0)[2];
    }
  }
  Ra.sl[6]=1842; /* line # 1842 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  G Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  register V Rv12;
  UL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1028;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1864; /* line # 1864 */
  Rv0=((V *)F_ob1)[0];
  if (((V *)F_p)[3]!=NULL) {
    Rv1=F_p;
    Rv2=((V *)Rv1)[2];
    Ra.sl[6]=1870; /* line # 1870 */
    Rv3=((V *)Rv1)[3]+8;
    if (64&((UW *)Rv3)[5]) Rv2=((V *)Rv3)[0];
    else {
      if (((UB *)Rv3)[8]!=0) F_ob1=P_exp_val_una(F_ob1, V_oparg_cvtab.v[((UB *)Rv3)
      [8]]);
    }
    Rv4=((V *)Rv1)[3]+24;
    Ra.sl[6]=1875; /* line # 1875 */
    if (64&((UW *)Rv4)[5]) Rv2=((V *)Rv4)[0];
    else {
      if (((UB *)Rv4)[8]!=0) Rv0=P_exp_val_una(Rv0, V_oparg_cvtab.v[((UB *)Rv4)[
8]]);
    }
    ((V *)F_ob1)[0]=Rv0;
    if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
      Ra.sl[6]=1882; /* line # 1882 */
      Rv5=((V *)F_ob1)[7];
      Rv6=Rv0;
      switch (((UB *)Rv1)[9]) {
        case 89:((SL *)Rv5)[13]=PAS__IIPOWER(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7]
        )[13]);
        break;
        case 90:
        case 108:((G *)Rv5)[7]=pow  (((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        case 91:
        case 109:Ra.sl[6]=1888; /* line # 1888 */
        ((G *)Rv5)[7]=PAS__IGPOWER(((G *)Rv5)[7],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 49:((SL *)Rv5)[13]=((SL *)Rv5)[13]+((SL *)((V *)Rv6)[7])[13];
        break;
        case 50:((SL *)Rv5)[13]=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        break;
        case 51:((SL *)Rv5)[13]=((SL *)Rv5)[13]*((SL *)((V *)Rv6)[7])[13];
        break;
        case 52:Ra.sl[6]=1893; /* line # 1893 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]/((SL *)((V *)Rv6)[7])[13];
        break;
        case 53:((SL *)Rv5)[13]=PAS__I_MOD(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])
        [13]);
        break;
        case 54:((SL *)Rv5)[13]=((SL *)Rv5)[13]%((SL *)((V *)Rv6)[7])[13];
        break;
        case 67:
        case 85:Ra.sl[6]=1898; /* line # 1898 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]+((G *)((V *)Rv6)[7])[7];
        break;
        case 68:
        case 86:((G *)Rv5)[7]=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        break;
        case 69:
        case 87:((G *)Rv5)[7]=((G *)Rv5)[7]*((G *)((V *)Rv6)[7])[7];
        break;
        case 70:
        case 88:Ra.sl[6]=1904; /* line # 1904 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]/((G *)((V *)Rv6)[7])[7];
        break;
        case 7:((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0&&((SL *)((V *)Rv6)[7])[13]
        >0);
        break;
        case 8:((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0||((SL *)((V *)Rv6)[7])[13]
        >0);
        break;
        case 9:((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0!=((SL *)((V *)Rv6)[7])[13]
        >0);
        break;
        case 11:Ra.sl[6]=1911; /* line # 1911 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13];
        break;
        case 12:((UL *)Rv5)[13]=(((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13])&~(((
        UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13]);
        break;
        case 13:((UL *)Rv5)[13]=((UL *)Rv5)[13]&~((UL *)((V *)Rv6)[7])[13];
        break;
        case 14:((UL *)Rv5)[13]=((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13];
        break;
        case 15:Ra.sl[6]=1916; /* line # 1916 */
        ((SL *)Rv5)[13]=(SL)((((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 16:break;
        case 17:break;
        case 18:break;
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:Ra.sl[6]=1925; /* line # 1925 */
        switch (((UB *)Rv1)[9]) {
          case 19:
          case 20:Rv7=(SL)PAS__SET_LE(((UL *)Rv5)[13],((UL *)((V *)Rv6)[7])[13])
          ;
          break;
          case 21:
          case 22:Rv7=(SL)PAS__SET_LE(((UL *)((V *)Rv6)[7])[13],((UL *)Rv5)[13])
          ;
          break;
          case 23:Ra.sl[6]=1930; /* line # 1930 */
          Rv7=(SL)(((UL *)Rv5)[13]!=((UL *)((V *)Rv6)[7])[13]);
          break;
          case 24:Rv7=(SL)(((UL *)Rv5)[13]==((UL *)((V *)Rv6)[7])[13]);
          break;
          default:break;
        }
        ((UB *)Rv5)[48]=1;
        Ra.sl[6]=1935; /* line # 1935 */
        ((SL *)Rv5)[6]=0;
        ((SL *)Rv5)[13]=Rv7;
        break;
        case 25:Rv7=(SL)((1<<((SL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:Ra.sl[6]=1944; /* line # 1944 */
        Rv7=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        switch (((UB *)Rv1)[9]) {
          case 28:
          case 32:((SL *)Rv5)[13]=(SL)(Rv7<0);
          break;
          case 29:
          case 33:((SL *)Rv5)[13]=(SL)(Rv7<=0);
          break;
          case 30:
          case 34:((SL *)Rv5)[13]=(SL)(Rv7>=0);
          break;
          case 31:
          case 35:Ra.sl[6]=1949; /* line # 1949 */
          ((SL *)Rv5)[13]=(SL)(Rv7>0);
          break;
          case 27:((SL *)Rv5)[13]=(SL)(Rv7!=0);
          break;
          case 26:((SL *)Rv5)[13]=(SL)(Rv7==0);
          break;
        }
        break;
        case 55:
        case 56:
        case 57:
        case 58:
        case 59:
        case 60:
        case 71:
        case 72:
        case 73:
        case 74:
        case 75:
        case 76:Ra.sl[6]=1957; /* line # 1957 */
        Rv8=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        switch (((UB *)Rv1)[9]) {
          case 55:
          case 71:((SL *)Rv5)[13]=(SL)(Rv8<0.000000000000000E-001);
          break;
          case 56:
          case 72:((SL *)Rv5)[13]=(SL)(Rv8<=0.000000000000000E-001);
          break;
          case 57:
          case 73:((SL *)Rv5)[13]=(SL)(Rv8>=0.000000000000000E-001);
          break;
          case 58:
          case 74:Ra.sl[6]=1962; /* line # 1962 */
          ((SL *)Rv5)[13]=(SL)(Rv8>0.000000000000000E-001);
          break;
          case 60:
          case 76:((SL *)Rv5)[13]=(SL)(Rv8!=0.000000000000000E-001);
          break;
          case 59:
          case 75:((SL *)Rv5)[13]=(SL)(Rv8==0.000000000000000E-001);
          break;
        }
        break;
        case 36:
        case 37:break;
        case 99:
        case 117:Ra.sl[6]=1974; /* line # 1974 */
        ((G *)Rv5)[7]=atan2(((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        default:break;
      }
      Rv9=F_ob1;
      Rv10=((V *)Rv9)[7];
      Ra.sl[6]=1980; /* line # 1980 */
      ((V *)Rv9)[4]=NULL;
      ((V *)Rv9)[3]=Rv2;
      ((V *)Rv10)[4]=((V *)Rv9)[3];
      ((UB *)Rv10)[48]=((UB *)((V *)Rv9)[3])[92];
      Ra.sl[6]=1986; /* line # 1986 */
      ((V *)F_ob1)[0]=NULL;
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=1991; /* line # 1991 */
      Rv11=1;
      switch (((UB *)Rv1)[9]) {
        case 25:if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=1996; /* line # 1996 */
          Rv12=F_ob1;
          Rv13=((SL *)((V *)Rv12)[7])[13];
          ((V *)Rv12)[3]=((V *)Rv0)[3];
          P_val_free(((V *)Rv12)+7);
          Ra.sl[6]=2001; /* line # 2001 */
          P_val_new(((V *)Rv12)+7,((V *)Rv12)[3]);
          Rv14=((V *)Rv12)[7];
          ((SL *)Rv14)[6]=(Rv13+7)/8;
          ((UL *)Rv14)[13]=1<<Rv13;
          Ra.sl[6]=2008; /* line # 2008 */
          P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
          Rv15=Rv0;
          ((UW *)Rv15)[10]=1;
          ((UB *)Rv15)[41]=15;
          Ra.sl[6]=2014; /* line # 2014 */
          Rv11=0;
        }
        break;
        case 7:if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2019; /* line # 2019 */
          Rv16=F_ob1;
          ((V *)F_ob1)[0]=NULL;
          Rv11=0;
          if (((SL *)((V *)Rv16)[7])[13]<=0) {
            Ra.sl[6]=2025; /* line # 2025 */
            P_lgt_free_tree(&Rv0);
            Rv0=F_ob1;
          }
          else P_lgt_free(&F_ob1);
        }
        else {
          Ra.sl[6]=2032; /* line # 2032 */
          if (((UB *)Rv0)[40]==14) {
            Rv17=Rv0;
            ((V *)F_ob1)[0]=NULL;
            Rv11=0;
            Ra.sl[6]=2037; /* line # 2037 */
            if (((SL *)((V *)Rv17)[7])[13]<=0) P_lgt_free_tree(&F_ob1);
            else {
              P_lgt_free(&Rv0);
              Ra.sl[6]=2042; /* line # 2042 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 8:Ra.sl[6]=2047; /* line # 2047 */
        if (((UB *)F_ob1)[40]==14) {
          Rv18=F_ob1;
          ((V *)F_ob1)[0]=NULL;
          Rv11=0;
          Ra.sl[6]=2052; /* line # 2052 */
          if (((SL *)((V *)Rv18)[7])[13]>0) {
            P_lgt_free_tree(&Rv0);
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2058; /* line # 2058 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          if (((UB *)Rv0)[40]==14) {
            Rv19=Rv0;
            Ra.sl[6]=2064; /* line # 2064 */
            ((V *)F_ob1)[0]=NULL;
            Rv11=0;
            if (((SL *)((V *)Rv19)[7])[13]>0) P_lgt_free_tree(&F_ob1);
            else {
              Ra.sl[6]=2070; /* line # 2070 */
              P_lgt_free(&Rv0);
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 1:
        case 3:
        case 4:
        case 5:Ra.sl[6]=2077; /* line # 2077 */
        Rv20=F_ob1;
        ((UW *)Rv20)[10]=((UW *)Rv20)[10]|8;
        if (!(2&((UW *)Rv20)[10])) P_src_error(Rd.s+1043,852,2);
        Ra.sl[6]=2082; /* line # 2082 */
        Rv21=Rv0;
        if (!(1&((UW *)Rv21)[10])) P_src_error(Rd.s+1043,851,1);
        if ((((UB *)Rv1)[9]!=1&&((UB *)Rv21)[40]==8)&&((V *)Rv21)[3]!=NULL) {
          Ra.sl[6]=2089; /* line # 2089 */
          Rv22=((V *)Rv21)[6];
          if (((V *)Rv22)[8]!=NULL) {
            if (((UB *)((V *)Rv22)[8])[94]==6) {
              ((V *)F_ob1)[0]=((V *)((V *)Rv21)[1])[0];
              Ra.sl[6]=2094; /* line # 2094 */
              P_lgt_free(((V *)Rv21)+1);
              ((UW *)Rv21)[10]=((UW *)Rv21)[10]|128;
              ((V *)Rv21)[1]=F_ob1;
              Rv11=0;
            }
          }
        }
        break;
        default:Ra.sl[6]=2102; /* line # 2102 */
        if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) P_src_error(Rd.s+1043,851,1);
        break;
      }
      if (Rv11) {
        Ra.sl[6]=2107; /* line # 2107 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Rv23=Rv0;
        ((V *)Rv23)[3]=Rv2;
        ((UW *)Rv23)[10]=1;
        Ra.sl[6]=2112; /* line # 2112 */
        ((UB *)Rv23)[41]=((UB *)Rv1)[9];
      }
      F_ob1=Rv0;
    }
  }
  Ra.sl[6]=2118; /* line # 2118 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1047;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2133; /* line # 2133 */
  Rv0=F_lgt;
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2138; /* line # 2138 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) Rv0=((V *)Rv1)[1];
    else Rv0=NULL;
  }
  Ra.sl[6]=2144; /* line # 2144 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2150; /* line # 2150 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1068;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2172; /* line # 2172 */
  Rv0=0;
  Rv1=NULL;
  if ((*F_lgt)!=NULL) {
    Rv2=(*F_lgt);
    Ra.sl[6]=2177; /* line # 2177 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Rv3=((V *)Rv2)[1];
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2182; /* line # 2182 */
  if (Rv1!=NULL) {
    Rv4=Rv1;
    Rv5=NULL;
    Rv6=NULL;
    Ra.sl[6]=2187; /* line # 2187 */
    Rv7=((V *)Rv4)[8];
    if (((V *)Rv4)[11]!=NULL) {
      Rv8=((V *)Rv4)[11];
      if (!((UB *)Rv8)[91]) {
        Ra.sl[6]=2198; /* line # 2198 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        ((V *)(*F_lgt))[1]=Rv5;
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2205; /* line # 2205 */
    while (Rv7!=NULL){
      Rv9=NULL;
      Rv10=0;
      Rv11=0;
      Ra.sl[6]=2210; /* line # 2210 */
      Rv12=Rv3;
      Rv13=Rv7;
      if (Rv3!=NULL) {
        Ra.sl[6]=2215; /* line # 2215 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          if (((V *)Rv13)[4]!=NULL) {
            Ra.sl[6]=2220; /* line # 2220 */
            Rv14=((V *)Rv13)[4];
            switch (((UB *)Rv14)[92]) {
              case 10:if (P_comp_type(((V *)Rv13)[4],V_typ_std.v[10],0,0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1,0)) {
                Ra.sl[6]=2225; /* line # 2225 */
                if (((UB *)Rv3)[40]==14) {
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  P_val_free(((V *)Rv3)+7);
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2230; /* line # 2230 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Rv16=((V *)Rv3)[7];
                  ((UB *)Rv16)[48]=29;
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2235; /* line # 2235 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2241; /* line # 2241 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  ((V *)Rv3)[0]=Rv17;
                  ((UW *)Rv3)[10]=5;
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2246; /* line # 2246 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2252; /* line # 2252 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0,0)) {
                Rv10=1;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2257; /* line # 2257 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[4],3, Rv3);
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2264; /* line # 2264 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0,0)) {
                  Rv10=1;
                  Rv11=1;
                }
              }
              if (((UB *)Rv14)[92]==9) Rv9=((V *)Rv13)[4];
              break;
              default:break;
            }
            Ra.sl[6]=2281; /* line # 2281 */
            if (64&((UW *)Rv13)[48]&&Rv6==NULL) Rv6=((V *)Rv3)[3];
            switch (((UB *)Rv13)[94]) {
              case 7:Ra.sl[6]=2287; /* line # 2287 */
              if (!(4&((UW *)Rv3)[10])) {
                Rv18=Rv3;
                if (64&((UW *)Rv13)[46]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2292; /* line # 2292 */
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                ((V *)Rv3)[0]=Rv17;
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
              }
              break;
              case 10:Ra.sl[6]=2302; /* line # 2302 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2307; /* line # 2307 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else((V *)Rv5)[0]=Rv3;
              break;
              default:break;
            }
            Ra.sl[6]=2313; /* line # 2313 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2319; /* line # 2319 */
        P_lgt_new(&Rv3,((V *)Rv13)[4],14,NULL);
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else((V *)Rv5)[0]=Rv3;
        Rv0=1;
      }
      Ra.sl[6]=2326; /* line # 2326 */
      if (Rv0) {
        if (8192&((UW *)Rv13)[46]) {
          Rv19=Rv3;
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2331; /* line # 2331 */
          ((V *)Rv19)[3]=((V *)Rv13)[4];
          ((V *)Rv19)[4]=NULL;
        }
        else {
          if (((V *)Rv13)[8]!=NULL) {
            Ra.sl[6]=2336; /* line # 2336 */
            Rv20=Rv3;
            ((UB *)Rv20)[40]=14;
            ((V *)Rv20)[3]=((V *)Rv13)[4];
            ((V *)Rv20)[7]=((V *)Rv13)[8];
            Ra.sl[6]=2341; /* line # 2341 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[4]);
            ((V *)Rv20)[4]=NULL;
          }
          else P_src_error_s(Rd.s+1084,854,2,((V *)Rv13)[0],NULL);
        }
      }
      Ra.sl[6]=2346; /* line # 2346 */
      Rv5=Rv3;
      if (Rv9!=NULL) {
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2351; /* line # 2351 */
          Rv21=((V *)Rv9)[15];
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Rv22=Rv12;
            if (((UB *)Rv22)[40]==8) ((UW *)Rv22)[10]=((UW *)Rv22)[10]|128;
            Ra.sl[6]=2357; /* line # 2357 */
            Rv23=((V *)Rv9)[15];
            Rv24=NULL;
            Rv25=NULL;
            if (Rv10) {
              while (1){
                Ra.sl[6]=2364; /* line # 2364 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
              }
              if (Rv11) {
                Ra.sl[6]=2369; /* line # 2369 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Rv7=((V *)Rv7)[3];
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[6]=2374; /* line # 2374 */
                  Rv7=((V *)Rv7)[3];
                }
                else Rv25=Rv24;
              }
              else {
                Ra.sl[6]=2380; /* line # 2380 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Rv25=Rv24;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2386; /* line # 2386 */
                if (((UB *)Rv12)[40]==14) Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)
                Rv12)[7])[6]);
                else {
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[4],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2392; /* line # 2392 */
                  if (!(64&((UW *)Rv7)[46])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[15];
                  if (((V *)Rv17)[3]!=Rv23) {
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2397; /* line # 2397 */
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                Rv7=((V *)Rv7)[3];
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[6]=2402; /* line # 2402 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[6]=2408; /* line # 2408 */
              Rv26=((V *)Rv3)[3];
              if (Rv26!=NULL) while (Rv9!=NULL&&Rv26!=NULL)
              if (((UB *)Rv9)[92]==9&&(((UB *)Rv26)[92]==9||((UB *)Rv26)[92]==8)
              ) {
                Ra.sl[6]=2415; /* line # 2415 */
                Rv27=((V *)Rv26)[15];
                Rv23=((V *)Rv9)[15];
                while (1){
                  if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                  if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
                }
                Ra.sl[6]=2422; /* line # 2422 */
                if (((UB *)Rv27)[92]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                else Rv28=Rv12;
                Ra.sl[6]=2427; /* line # 2427 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  if (((UB *)Rv27)[92]==22) {
                    Rv17=P_lgt_type_eval(((V *)Rv27)[13],Rv28,NULL,0);
                    Ra.sl[6]=2432; /* line # 2432 */
                    if (((SL *)Rv27)[11]!=((SL *)Rv23)[11]) {
                      Rv17=P_lgt_new_code(0, Rv17);
                      ((V *)Rv17)[3]=Rv23;
                    }
                  }
                  else {
                    Ra.sl[6]=2438; /* line # 2438 */
                    Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[29]);
                  }
                  if (Rv25==NULL) Rv24=Rv17;
                  else((V *)Rv25)[0]=Rv17;
                  Rv25=Rv17;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2445; /* line # 2445 */
                if (((UB *)Rv27)[92]==22) {
                  Rv17=P_lgt_type_eval(((V *)Rv27)[14],Rv28,NULL,0);
                  if (Rv27!=Rv23) {
                    Ra.sl[6]=2450; /* line # 2450 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                else Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[30]);
                Ra.sl[6]=2455; /* line # 2455 */
                if (Rv25==NULL) Rv24=Rv17;
                else((V *)Rv25)[0]=Rv17;
                Rv25=Rv17;
                Rv7=((V *)Rv7)[3];
                Rv26=((V *)Rv26)[14];
                Ra.sl[6]=2460; /* line # 2460 */
                Rv9=((V *)Rv9)[14];
              }
              else Rv9=NULL;
              Rv29=Rv3;
              if (((SL *)((V *)Rv29)[3])[10]>0) {
                Ra.sl[6]=2465; /* line # 2465 */
                ((SL *)Rv29)[4]=((SL *)Rv29)[4]+((SL *)((V *)Rv29)[3])[10];
              }
            }
            if (Rv24!=NULL) {
              Ra.sl[6]=2471; /* line # 2471 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              ((V *)Rv3)[0]=Rv24;
              Rv3=Rv25;
            }
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2478; /* line # 2478 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Rv7=((V *)Rv7)[3];
    }
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2483; /* line # 2483 */
      Rv30=(*F_lgt);
      if (Rv6!=NULL) {
        ((V *)Rv30)[3]=Rv6;
        Ra.sl[6]=2488; /* line # 2488 */
        if (!((UB *)Rv6)[91]&&((V *)Rv30)[1]!=NULL) ((V *)((V *)Rv30)[1])[3]=Rv6;
      }
      Ra.sl[6]=2493; /* line # 2493 */
      if (!((UB *)((V *)Rv4)[11])[91]) P_tmpstk_allocate(((V *)Rv30)[1],((V *)((
      V *)Rv30)[1])[3]);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  register V Rv14;
  register V Rv15;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1088;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2633; /* line # 2633 */
  Rv0=0;
  while (!Rv0&&(*F_pg)!=NULL){
    Rv1=F_parm_lst;
    Rv2=(*F_pg);
    Ra.sl[6]=2638; /* line # 2638 */
    if (((UB *)Rv2)[8]&&F_npa<=2) {
      Rv3=Rv1;
      switch (F_npa) {
        case 0:Rv0=((V *)Rv2)[3]==NULL;
        break;
        case 1:Ra.sl[6]=2644; /* line # 2644 */
        if (((V *)Rv2)[3]!=NULL) {
          if (((SL *)((V *)Rv2)[3])[0]==1) {
            Rv4=((V *)Rv2)[3]+8;
            if ((1&((UW *)Rv4)[5])<=(2&((UW *)Rv3)[10])) Rv0=P_comp_type(((V *)Rv3)
            [3],((V *)Rv4)[0],(8&((UW *)Rv4)[5])!=0,0);
          }
        }
        break;
        case 2:Ra.sl[6]=2650; /* line # 2650 */
        if (((V *)Rv2)[3]!=NULL) {
          if ((((SL *)((V *)Rv2)[3])[0]==2&&((SL *)((V *)Rv3)[3])[11]>0)&&((SL *)(
          (V *)((V *)Rv3)[0])[3])[11]>0) {
            Rv5=((V *)Rv2)[3]+8;
            memcpy(Ra.s+32,((V *)Rv2)[3]+24,12);
            Ra.sl[6]=2655; /* line # 2655 */
            if (((1&((UW *)Rv5)[5])<=(2&((UW *)Rv3)[10])&&(1&Ra.uw[21])<=(2&((UW
             *)((V *)Rv3)[0])[10]))&&((SL *)((V *)Rv3)[3])[10]==0) Rv0=P_comp_type((
            (V *)Rv3)[3],((V *)Rv5)[0],(8&((UW *)Rv5)[5])!=0,0)&&P_comp_type(((V
             *)((V *)Rv3)[0])[3],Ra.v[4],(8&Ra.uw[21])!=0,0);
            Ra.sl[6]=2660; /* line # 2660 */
            if (Rv0) {
              if (4&((UW *)Rv5)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V *)((
              V *)Rv3)[0])[3])[13],0,0);
              else {
                if (16&((UW *)Rv5)[5]) Rv0=((V *)Rv3)[3]==((V *)((V *)Rv3)[0])[3]
                &&((SL *)((V *)Rv3)[3])[10]==0;
                else {
                  Ra.sl[6]=2665; /* line # 2665 */
                  if (32&((UW *)Rv5)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V
                   *)Rv3)[0])[3],8&((UW *)Rv5)[5]||8&Ra.uw[21],1);
                }
              }
            }
          }
        }
        break;
      }
    }
    else {
      Ra.sl[6]=2671; /* line # 2671 */
      Rv6=((V *)Rv2)[2];
      if (((SL *)Rv6)[20]>=F_npa) {
        Rv7=((V *)Rv6)[8];
        if (Rv7!=NULL) {
          Ra.sl[6]=2676; /* line # 2676 */
          if (((UB *)Rv7)[94]==6) Rv7=((V *)Rv7)[3];
        }
        if ((F_npa==2&&((SL *)Rv6)[20]==2)&&(((UB *)Rv6)[104]==1||((UB *)Rv6)[104]
        ==2)) {
          Ra.sl[6]=2682; /* line # 2682 */
          Rv8=Rv1;
          Rv9=((V *)Rv7)[3];
          Rv0=P_comp_type(((V *)Rv8)[3],((V *)Rv7)[4],8&((UW *)Rv7)[48]||((UB *)
          Rv7)[94]!=8,0)&&P_comp_type(((V *)((V *)Rv8)[0])[3],((V *)Rv9)[4],8&((
          UW *)Rv9)[48]||((UB *)Rv9)[94]!=8,0);
          Ra.sl[6]=2689; /* line # 2689 */
          if (Rv0) {
            if (4&((UW *)Rv7)[48]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)((V
             *)Rv8)[0])[3])[13],0,0);
            else {
              if (16&((UW *)Rv7)[48]) Rv0=((V *)Rv8)[3]==((V *)((V *)Rv8)[0])[3]
              &&((SL *)((V *)Rv8)[3])[10]==0;
              else {
                Ra.sl[6]=2694; /* line # 2694 */
                if (32&((UW *)Rv7)[48]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)
                Rv8)[0])[3],8&((UW *)Rv7)[48]||8&((UW *)Rv9)[48],0);
              }
            }
          }
        }
        Ra.sl[6]=2722; /* line # 2722 */
        if (!Rv0) {
          Rv0=1;
          while (Rv0&&Rv7!=NULL){
            Ra.sl[6]=2727; /* line # 2727 */
            Rv10=0;
            Rv11=Rv7;
            if (Rv1!=NULL) {
              Rv12=Rv1;
              Ra.sl[6]=2732; /* line # 2732 */
              if (((UB *)Rv12)[40]==17) {
                if (((V *)Rv11)[8]==NULL&&!(8192&((UW *)Rv11)[46])) Rv0=0;
                else {
                  Ra.sl[6]=2737; /* line # 2737 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
              }
              else {
                Rv13=P_comp_type(((V *)Rv12)[3],((V *)Rv11)[4],((UB *)Rv11)[94]!=
8,0);
                Ra.sl[6]=2744; /* line # 2744 */
                if (!Rv13&&((UB *)Rv12)[40]==14) {
                  Rv14=((V *)Rv11)[4];
                  switch (((UB *)Rv14)[92]) {
                    case 4:Ra.sl[6]=2755; /* line # 2755 */
                    if (((UB *)((V *)Rv12)[3])[92]==3) {
                      ((V *)Rv12)[3]=V_typ_std.v[4];
                      Rv13=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[6]=2779; /* line # 2779 */
                    if ((P_comp_type(((V *)Rv14)[14],V_typ_std.v[0],1,0)&&((UB *)(
                    (V *)Rv14)[15])[92]==2)&&((SL *)Rv14)[10]==0) {
                      if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[10],0,0)) {
                        Ra.sl[6]=2785; /* line # 2785 */
                        if (((UB *)Rv14)[92]==8) {
                          Rv15=((V *)Rv14)[15];
                          Rv13=(((SL *)Rv15)[30]-((SL *)Rv15)[29])+1==((SL *)((V
                           *)Rv12)[7])[6];
                        }
                        else {
                          Ra.sl[6]=2790; /* line # 2790 */
                          Rv13=1;
                        }
                      }
                      else {
                        if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[0],0,0)) {
                          if (((UB *)Rv14)[92]==9) Rv13=1;
                          else {
                            Ra.sl[6]=2795; /* line # 2795 */
                            Rv13=((SL *)Rv14)[30]==((SL *)Rv14)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=2800; /* line # 2800 */
                if (Rv13) {
                  if (((V *)Rv11)[4]!=NULL) {
                    if (((UB *)((V *)Rv11)[4])[92]==9) Rv10=((SL *)((V *)Rv11)[4]
                    )[24];
                  }
                  Ra.sl[6]=2805; /* line # 2805 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
                else Rv0=0;
                if (Rv0) {
                  Ra.sl[6]=2811; /* line # 2811 */
                  if (((UB *)Rv11)[94]==8) {
                    if (!(1&((UW *)Rv12)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[6]=2816; /* line # 2816 */
                    if (4&((UW *)Rv12)[10]) {
                      if (32&((UW *)Rv11)[46]) {
                        if (!(1&((UW *)Rv12)[10])) Rv0=0;
                      }
                      if (64&((UW *)Rv11)[46]) {
                        Ra.sl[6]=2821; /* line # 2821 */
                        if (!(2&((UW *)Rv12)[10])) Rv0=0;
                      }
                    }
                    else {
                      if (64&((UW *)Rv11)[46]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[6]=2829; /* line # 2829 */
              if (((V *)Rv11)[8]==NULL&&!(8192&((UW *)Rv11)[46])) Rv0=0;
              else Rv7=((V *)Rv11)[3];
            }
            Ra.sl[6]=2834; /* line # 2834 */
            if (Rv10>0) while (1){
              Rv7=((V *)Rv7)[3];
              Rv10=Rv10-1;
              if (Rv10==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[6]=2841; /* line # 2841 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  if (!Rv0) {
    Ra.sl[6]=2850; /* line # 2850 */
    P_src_error_s(Rd.s+1106,113,3, F_id,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1110;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2875; /* line # 2875 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  if (F_p!=NULL) {
    Rv1=F_p;
    Ra.sl[6]=2880; /* line # 2880 */
    if (((UB *)Rv1)[8]) {
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else Rv2=P_exp_val_bin(F_oblst, F_p);
    }
    else {
      Ra.sl[6]=2888; /* line # 2888 */
      Rv3=((V *)Rv1)[2];
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      Ra.sl[6]=2893; /* line # 2893 */
      P_call_setting(&Rv2);
    }
    Ret=Rv2;
  }
  else Ret=F_oblst;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1123;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2912; /* line # 2912 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Rv0=((V *)F_ip)[10];
  if (F_np<=0) {
    Rv1=F_lgp;
    Ra.sl[6]=2917; /* line # 2917 */
    while (Rv1!=NULL){
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Rv2=NULL;
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2922; /* line # 2922 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=2927; /* line # 2927 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      if (((V *)Rv3)[2]!=NULL) {
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        P_call_setting(&Rv2);
      }
    }
  }
  Ra.sl[6]=2935; /* line # 2935 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1138;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2944; /* line # 2944 */
  Ri.ub[0]=F_op;
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1149;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2961; /* line # 2961 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else Rv0=((V *)V_ope_table.v[28])[3];
  Rv1=((V *)F_prm)[0];
  Rv2=((UW *)F_prm)[10];
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=2966; /* line # 2966 */
  if (F_bovr) {
    ((UW *)F_prm)[10]=Rv2|3;
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=2971; /* line # 2971 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  if (F_bovr) {
    ((UW *)F_prm)[10]=Rv2;
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=2977; /* line # 2977 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
