/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long int

/* Include the PAS environment file. */
#include <cpas_defs.h>


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " sinh_f "  */
F PAS__SHF(F F_v){
  /* Local variable stored in C variable */
  F Rv0;
  register F Ret;

  /* Code of procedure/function */
  Rv0=exp(F_v);
  Ret=(F)5.000000E-01*(Rv0-(F)1.000000E+00/Rv0);
  return(Ret);
}


/* Procedure/Function : " cosh_f "  */
F PAS__CHF(F F_v){
  /* Local variable stored in C variable */
  F Rv0;
  register F Ret;

  /* Code of procedure/function */
  Rv0=exp(F_v);
  Ret=(F)5.000000E-01*(Rv0+(F)1.000000E+00/Rv0);
  return(Ret);
}


/* Procedure/Function : " tanh_f "  */
F PAS__THF(F F_v){
  /* Local variable stored in C variable */
  F Rv0;
  register F Ret;

  /* Code of procedure/function */
  Rv0=exp((F)-2.000000E+00*fabs(F_v));
  Rv0=((F)1.000000E+00-Rv0)/((F)1.000000E+00+Rv0);
  if (F_v>(F)0.000000E-01) Ret=Rv0;
  else Ret= -Rv0;
  return(Ret);
}


/* Procedure/Function : " argsinh_f "  */
F PAS__ASHF(F F_v){
  /* Local variable stored in C variable */
  F Rv0;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Rv0=log(fabs(F_v)+sqrt(F_v*F_v+(F)1.000000E+00));
  if (F_v<(F)0.000000E-01) Ret= -Rv0;
  else Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " argcosh_f "  */
F PAS__ACHF(F F_v){
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  if (F_v<(F)1.000000E+00) PAS__ERROR(805);
  Ret=log(F_v+sqrt(F_v*F_v-(F)1.000000E+00));
  return(Ret);
}


/* Procedure/Function : " argtanh_f "  */
F PAS__ATHF(F F_v){
  register F Ret;

  /* Code of procedure/function */
  if (fabs(F_v)>=(F)1.000000E+00) PAS__ERROR(806);
  Ret=log(((F)1.000000E+00+F_v)/((F)1.000000E+00-F_v))*(F)5.000000E-01;
  return(Ret);
}
