/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[3];

/* Define the local data section. */
static Blk( Rd, 2592 ) = {
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 62,  62,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83,
111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  50,  65,  49,
 47, 112,  99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,  97, 115,
  3,   3,  84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115,
101, 116,  95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,  29,  32,
 84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111, 117, 114,
 99, 101,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,
 17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95, 115,  98,
116, 116, 108,  33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110,
116,  32,  67, 111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100, 117, 108,
101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116, 107,
101, 121, 119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121, 119,
111, 114, 100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120, 111,
114,   3,   3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105, 118,
  3,   3, 109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,   3,
110, 105, 108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116, 111,
  4,   4, 116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14, 117,
115, 101, 114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3, 118,
 97, 114,   6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,  95,
118,  97, 114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,  99,
 99, 101, 115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,  97,
121,   6,   6, 114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,   3,   3,
117, 115, 101,   3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,   7,   7,
100, 105, 115, 112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,   5, 114,
101, 115, 101, 116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,   6,  97,
112, 112, 101, 110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114, 101,  97,
100, 108, 110,   5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114, 105, 116,
101,   7,   7, 119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114, 105, 116,
101, 118,   7,   7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109, 111, 100,
117, 108, 101,   9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,   8,   8,
102, 117, 110,  99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117, 114, 110,
  7,   7, 102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116, 105,
 99,   6,   6, 103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99, 107, 101,
100,   8,   8, 101, 120, 116, 101, 114, 110,  97, 108,   8,   8, 115, 116,  97,
110, 100,  97, 114, 100,   6,   6, 105, 110, 108, 105, 110, 101,   5,   5,  98,
101, 103, 105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,   4,   4,
101, 108, 115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114, 101, 112,
101,  97, 116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111, 114,   4,
  4, 108, 111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,  97, 115,
101,   4,   4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9, 111, 116,
104, 101, 114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100, 111,   2,
  2, 116, 111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37, 100, 101,
102, 105, 110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110, 101,   4,
  4,  37, 108, 101, 116,   3,   3,  37, 105, 102,   6,   6,  37, 105, 102, 100,
101, 102,   8,   8,  37, 105, 102, 117, 110, 100, 101, 102,   5,   5,  37, 116,
104, 101, 110,   5,   5,  37, 101, 108, 115, 101,   6,   6,  37, 101, 110, 100,
105, 102,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,   8,  37, 105, 110,
 99, 108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103, 109,  97,   4,   4,
 37, 101, 111, 102,  16,  16,  99, 114, 101,  97, 116, 101,  95, 109,  97,  99,
 95, 105, 100, 101, 110, 116,   4,   4,  67,  82,  69,  77,   2,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   7,   7, 115, 111, 114, 116, 109,  99,
 49,  15,  15, 114, 101,  98, 117, 105, 108, 100,  95, 109,  99, 116, 114, 101,
101,  49,  14,  14, 114, 101,  98, 117, 105, 108, 100,  95, 109,  99, 116, 114,
101, 101,   6,   6, 110, 101, 120, 116,  99, 104,   8,   8, 112, 117, 116,  95,
 99, 104,  97, 114,   4,   4,  73,  78,  83,  89,  12,  12, 116, 101, 115, 116,
 95, 102, 105, 103, 117, 114, 101, 115,   7,   7, 102, 105, 103, 117, 114, 101,
115,   4,   4,  70,  73,  71,  85,  11,  11, 111, 118, 102,  95, 104,  97, 110,
100, 108, 101, 114,  11,  11,  84, 111, 111,  32,  79,  86,  72,  32,  69,  82,
 82,  12,  12, 105, 110, 115, 121, 109,  98, 111, 108,  95, 115, 114,  99,  13,
 13, 115, 107, 105, 112,  95, 109,  99, 115, 121, 109,  98, 111, 108,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 224,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,  16,  16,  99,  98,
 95, 109,  97,  99, 114, 111,  95, 109,  97, 110,  97, 103, 101, 114,  13,  13,
109,  97,  99, 114, 111,  95, 114, 101, 112, 108,  97,  99, 101,   4,   4,  77,
 65,  67,  84,  19,  19, 100, 101, 102, 105, 110, 101,  95, 109,  97,  99, 114,
111,  95, 115, 121, 109,  98, 111, 108,   4,   4,  67,  82,  77,  83,   0,   0,
  0,  12,   0,   0,   0,  12,   0,   0,  21,  21, 117, 110, 100, 101, 102, 105,
110, 101,  95, 109,  97,  99, 114, 111,  95, 115, 121, 109,  98, 111, 108,   4,
  4,  82,  77,  77,  83,   0,   0,   0,   0,  12,   0,   0,  19,  19, 109,  97,
 99, 114, 111,  95,  97, 115, 115, 105, 103, 110,  95, 115, 121, 109,  98, 111,
108,   4,   4,  65,  83,  77,  83,   0,   0,  12,   0,   0,   0,   0,   0,   0,
  0,   0,   2,   0,   0,   0,   0,   4,   9,   9, 115, 104, 111, 119,  95, 109,
118,  97, 108,  15,  15,  32,  69,  88,  80,  95,  73,  68,  69,  78,  84,  32,
 45,  62,  32,  91,   0,   0,   0,   3,   0,   8,   8, 109, 118,  97, 108,  95,
105, 110, 116,   8, 109, 118,  97, 108,  95, 115, 116, 114,   8, 109, 118,  97,
108,  95, 110, 117, 108,   8, 109, 118,  97, 108,  95, 117, 110, 100,   4,   4,
 44,  32, 105,  61,   5,   5,  44,  32, 115,  61,  34,   2,   2,  34,  93,  11,
 11, 115, 104, 111, 119,  95, 109, 115, 116,  97,  99, 107,  15,  15,  32, 115,
116,  97,  99, 107,  58,  32, 115, 116, 107, 112,  32,  61,  32,   2,   2,  32,
 91,   4,   4,  93,  32,  61,  32,   8,   8, 109, 118,  97, 108,  95,  99, 111,
112,   9,   9, 109, 118,  97, 108,  95, 102, 114, 101, 101,   5,   5, 109, 112,
117, 115, 104,   4,   4,  77,  80,  85,  83,   4,   4, 109, 112, 111, 112,   4,
  4,  77,  80,  79,  80,  15,  15, 103, 101, 116,  95, 109,  97,  99, 114, 111,
 95, 118,  97, 108, 117, 101,   9,   9, 109, 101, 120, 112,  95, 105, 110, 116,
118,  11,  11, 109, 101, 120, 112,  95, 118, 108,  95, 115, 116, 114,   9,   9,
109, 101, 120, 112,  95, 115, 116, 114, 118,   9,   9, 109, 101, 120, 112,  95,
 99,  97, 108, 108,   4,   4,  77,  67,  65,  76,   9,   9,  32,  76, 101, 110,
103, 116, 104,  40,  34,   6,   6,  34,  41,  32,  45,  62,  32,  10,  10, 109,
101, 120, 112,  95, 105, 100, 101, 110, 116,   4,   4,  77,  73,  68,  69,   0,
  7, 100, 101, 102, 105, 110, 101, 100,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  0,   0,   0,   1,   6, 115, 117,  98, 115, 116, 114,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32, 255, 255, 255, 253,   5, 105, 110, 100, 101, 120,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   2,   5, 108, 101, 110,
103, 116, 104,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   1,
  8,  42,  42,  42,  42,  42,  42,  42,  42,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  0,   0,   0,   0,   0,   8,   0,   0,  10,  10, 109, 101, 120, 112,  95,  98,
105, 110, 111, 112,   4,   4,  77,  66,  73,  78,  10,  10, 109, 101, 120, 112,
 95, 117, 110,  97, 111, 112,   4,   4,  77,  85,  78,  65,   8,   8, 109, 101,
120, 112,  95, 117, 110,  97,   4,   4,  77,  69,  88,  80,   8,   8, 109, 101,
120, 112,  95, 109, 117, 108,   8,   8, 109, 101, 120, 112,  95,  97, 100, 100,
  8,   8, 109, 101, 120, 112,  95, 114, 101, 108,   8,   8, 109, 101, 120, 112,
 95, 110, 111, 116,   8,   8, 109, 101, 120, 112,  95,  97, 110, 100,  12,  12,
109,  95, 101, 120, 112, 114,  95, 105, 110, 115, 116, 107,  10,  10, 109, 101,
120, 112, 114,  95, 115, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95,
105, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95,  98, 118,  97, 108,
  9,   9, 105, 102,  95, 109, 115, 116,  97, 116, 101,   4,   4,  77,  67,  73,
 70, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  13,  13, 112, 114,  97, 103, 109,  97,  95, 109, 115, 116,  97, 116,
101,   4,   4,  80,  82,  65,  71,  14,  14, 105, 110,  99, 108, 117, 100, 101,
 95, 109, 115, 116,  97, 116, 101,   4,   4,  46, 112,  97, 115,   4,   4,  73,
 78,  67,  76,  20,  20,  32,  79, 112, 101, 110,  32,  69, 114, 114, 111, 114,
 32,  40,  82,  84,  76,  41,  32,  35,  32,  22,  22,  32, 102, 111, 114,  32,
116, 104, 101,  32,  83, 111, 117, 114,  99, 101,  32, 102, 105, 108, 101,  32,
 34,   2,   2,  34,  46,  15,  15,  32,  82,  84,  76,  32, 109, 101, 115, 115,
 97, 103, 101,  32,  58,  32,  14,  14, 101, 110, 100, 102, 105, 108, 101,  95,
109, 115, 116,  97, 116, 101,   8,   8, 105, 110, 115, 121, 109,  98, 111, 108,
  4,   4,  77,  65,  83,  89,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   4,  11,  11, 115, 107, 105, 112,  95, 115,
121, 109,  98, 111, 108,  12,  12, 115, 107, 105, 112,  95, 109, 115, 121, 109,
 98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   2,   0, 128,   0,   0,   0,   0,   2,   0,   0,
  0,   0,   0,   0,   0,   4,   0,   0,   9,   9, 105, 110, 115, 121,  95, 105,
110, 105, 116,   0,   0,  53,  53,  32,  80,  32,  65,  32,  83,  32,  45,  32,
 80,  46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,  79,  70,  84,  87,
 65,  82,  69,  58,  32,  86,  51,  46,  49,  45,  66,  52,  32,  79,  70,  32,
 51,  48,  45,  83,  69,  80,  45,  50,  48,  49,  54,  32,  12,  12,  99, 112,
 97, 115,  95,  99, 109, 112,  46, 101, 114, 114,   5,   5,  32,  80,  65,  83,
 62,  48,  48,  32,  42,  42,  42,  32,  80,  67,  77,  80,  45,  67,  80,  65,
 83,  45,  67,  79,  77,  80,  73,  76,  69,  82,  32,  69,  82,  82,  79,  82,
 58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101, 110,  32, 116, 104,
101,  32,  34,  15,  15,  34,  32, 105, 110, 105, 116, 105,  97, 108,  32, 102,
105, 108, 101,  46,  54,  54,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32, 102, 111, 114,  32, 116, 104, 101,  32, 116,  97, 114,
103, 101, 116,  32, 115, 121, 115, 116, 101, 109,  32,  34,  22,  22,  32,  80,
 65,  83,  32,  67,  65,  78,  78,  79,  84,  32,  79,  80,  69,  78,  32,  84,
 72,  69,  32,  34,  23,  23,  34,  32,  79,  85,  84,  80,  85,  84,  32,  77,
 83,  71,  47,  76,  73,  83,  84,  32,  70,  73,  76,  69,  46,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 928 ) = {
  0,   0,   0,   0,   0,   1,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   4,   5,   6,   7,   7,   7,  15,   6,  16,  17,  10,  18,
 19,  20,   9,  21,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  14,  22,
 11,  12,  13,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  23,
 24,  25,  26,   7,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   4,
  5,   4,   4,   3,  12,  20,  14,  29,  15,  29,   9,  11,  18,  29,   9,  12,
  8,   7,  19,  29,  16,  29,   6,   0,  17,  29,  24,  29,   0,   0,   0,   0,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10, 112,  99, 109, 112, 100, 101,  98,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11, 112,  99, 109, 112, 100, 101,  98,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32
};

/* Define the local static section. */
static Blk( Rs, 384 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern V V_macsymb_tree;
extern V V_macsymb_frst;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern UB V_sy_attrflg;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern V V_sy_macsymb;
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_src_openerr;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern SL V_sy_maclevel;
extern Blk(V_cpas_ini_dir, 264 );
extern Blk(V_trg_env_fspc, 264 );
extern UB V_cmp_macroexp;
extern UB V_error_result;
extern UB V_emergency_stop;
extern Blk(V_trg_sys_name, 264 );
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp);
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp);
C P_src_return(UB F_bfree);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_set_flags(UL F_flg, UB F_fclr);
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_insymbol();
void P_skip_msymbol(V F_smb, UB F_rec_flg);
void P_binary_objf_close();
void P_generation_pragma();
void PAS_INSMBOL_get_macro_value(V F_vl);
void PAS_INSMBOL_m_expr_instk();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=164; /* line # 164 */
  if (F_icd>=0) {
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]));
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+80);
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[68]=170; /* line # 170 */
      if (V_srf_free==NULL) Rv0=PAS__NEW(8);
      else {
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Rv1=Rv0;
      Ra.sl[68]=176; /* line # 176 */
      ((V *)Rv1)[0]=V_srf_list;
      ((V *)Rv1)[1]=NULL;
      P_val_new(((V *)Rv1)+1,NULL);
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[68]=183; /* line # 183 */
      Rv2=V_srf_list;
      P_val_free(((V *)Rv2)+1);
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[68]=188; /* line # 188 */
    Rv3=((V *)V_srf_list)[1];
    ((UB *)Rv3)[36]=29;
    ((SL *)Rv3)[5]=Ra.ub[1];
    Rv4=Ra.ub[1];
    ((V *)Rv3)[10]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[10])[0]=Rv4;
    Ra.sl[68]=193; /* line # 193 */
    PAS__STR_TO_STR(((V *)Rv3)[10],Ra.s);
  }
  else {
    Ra.sl[68]=198; /* line # 198 */
    Rv0=V_srf_list;
    Rv5=Rv0;
    V_srf_list=((V *)Rv5)[0];
    P_val_free(((V *)Rv5)+1);
    Ra.sl[68]=203; /* line # 203 */
    ((V *)Rv5)[0]=V_srf_free;
    V_srf_free=Rv0;
  }
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+85;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=228; /* line # 228 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]));
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+104);
  Ra.sl[68]=233; /* line # 233 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+533,PAS__CON_STR_STR(Ra.s+276,Rd.s+
109,Ra.s),Rd.s+140));
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+144;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=251; /* line # 251 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  if (((V *)F_prc)[3]!=NULL) {
    Rv1=((V *)F_prc)[3];
    Ra.sl[68]=257; /* line # 257 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+276,Rv1+1,31,1,((UB *)Rv1)[0]));
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+533,PAS__CON_STR_STR(Ra.s+276,Rd.
    s+163,Ra.s),Rd.s+198));
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+202;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=286; /* line # 286 */
  Rv0=PAS__NEW(42);
  Rv1=Rv0;
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[3]=291; /* line # 291 */
  ((V *)Rv1)[8]=NULL;
  ((V *)Rv1)[9]=NULL;
  ((UB *)Rv1)[40]=F_skw;
  ((UB *)Rv1)[41]=F_opkw;
  Rv3=V_keyword_tree;
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[3]=298; /* line # 298 */
      Rv4=Rv3;
      Rv5=Rv3;
      Rv6=P_match(Rv0,Rv5);
      if (Rv6>0) Rv3=((V *)Rv5)[9];
      else {
        Ra.sl[3]=303; /* line # 303 */
        Rv3=((V *)Rv5)[8];
      }
      if (Rv3==NULL)  break;
    }
    if (Rv6>0) ((V *)Rv4)[9]=Rv0;
    else((V *)Rv4)[8]=Rv0;
  }
  else {
    Ra.sl[3]=309; /* line # 309 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+214;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=315; /* line # 315 */
  PAS_INSMBOL_PRC_00000000(Rd.s+232,13,21);
  PAS_INSMBOL_PRC_00000000(Rd.s+236,13,22);
  PAS_INSMBOL_PRC_00000000(Rd.s+241,12,20);
  PAS_INSMBOL_PRC_00000000(Rd.s+246,6,0);
  PAS_INSMBOL_PRC_00000000(Rd.s+251,8,8);
  Ra.sl[3]=320; /* line # 320 */
  PAS_INSMBOL_PRC_00000000(Rd.s+256,8,9);
  PAS_INSMBOL_PRC_00000000(Rd.s+261,8,10);
  PAS_INSMBOL_PRC_00000000(Rd.s+266,10,23);
  Ra.sl[3]=326; /* line # 326 */
  PAS_INSMBOL_PRC_00000000(Rd.s+270,28,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+275,33,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+282,34,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+288,30,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+294,29,29);
  Ra.sl[3]=331; /* line # 331 */
  PAS_INSMBOL_PRC_00000000(Rd.s+301,32,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+317,31,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+322,36,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+330,37,29);
  Ra.sl[3]=336; /* line # 336 */
  PAS_INSMBOL_PRC_00000000(Rd.s+339,44,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+348,39,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+356,40,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+362,41,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+369,42,29);
  Ra.sl[3]=341; /* line # 341 */
  PAS_INSMBOL_PRC_00000000(Rd.s+377,43,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+382,74,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+387,59,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+392,60,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+398,61,29);
  Ra.sl[3]=346; /* line # 346 */
  PAS_INSMBOL_PRC_00000000(Rd.s+407,62,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+413,63,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+420,64,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+429,65,29);
  Ra.sl[3]=351; /* line # 351 */
  PAS_INSMBOL_PRC_00000000(Rd.s+437,66,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+443,67,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+451,68,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+458,69,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+465,70,29);
  Ra.sl[3]=356; /* line # 356 */
  PAS_INSMBOL_PRC_00000000(Rd.s+474,71,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+482,76,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+491,75,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+499,77,29);
  Ra.sl[3]=361; /* line # 361 */
  PAS_INSMBOL_PRC_00000000(Rd.s+510,78,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+520,79,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+528,80,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+537,87,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+545,82,29);
  Ra.sl[3]=366; /* line # 366 */
  PAS_INSMBOL_PRC_00000000(Rd.s+553,38,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+561,81,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+571,83,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+581,84,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+589,72,29);
  Ra.sl[3]=371; /* line # 371 */
  PAS_INSMBOL_PRC_00000000(Rd.s+596,45,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+600,46,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+606,47,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+612,48,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+619,49,29);
  Ra.sl[3]=376; /* line # 376 */
  PAS_INSMBOL_PRC_00000000(Rd.s+627,50,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+634,51,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+639,55,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+645,56,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+651,57,29);
  Ra.sl[3]=381; /* line # 381 */
  PAS_INSMBOL_PRC_00000000(Rd.s+657,58,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+663,73,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+668,86,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+679,85,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+683,54,29);
  Ra.sl[3]=386; /* line # 386 */
  PAS_INSMBOL_PRC_00000000(Rd.s+687,52,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+691,53,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+699,90,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+708,91,29);
  Ra.sl[3]=391; /* line # 391 */
  PAS_INSMBOL_PRC_00000000(Rd.s+719,92,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+725,93,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+730,94,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+738,95,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+748,96,29);
  Ra.sl[3]=396; /* line # 396 */
  PAS_INSMBOL_PRC_00000000(Rd.s+755,97,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+762,98,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+770,101,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+779,100,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+789,102,29);
  Ra.sl[3]=405; /* line # 405 */
  PAS_INSMBOL_PRC_00000000(Rd.s+798,103,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_mac_ident "  */
V P_create_mac_ident(V F_id, UB F_cmdf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+804;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=425; /* line # 425 */
  Rv0=V_macsymb_tree;
  Rv1=NULL;
  Rv2=1;
  while (Rv0!=NULL&&Rv2!=0){
    Ra.sl[3]=430; /* line # 430 */
    Rv1=Rv0;
    Rv3=Rv0;
    Rv2=P_match(F_id,Rv3);
    if (Rv2!=0) {
      Ra.sl[3]=435; /* line # 435 */
      if (Rv2>0) Rv0=((V *)Rv3)[10];
      else Rv0=((V *)Rv3)[9];
    }
  }
  if (Rv2==0) {
    Ra.sl[3]=440; /* line # 440 */
    if (F_cmdf) Rv4=Rv0;
    else P_src_error(Rd.s+824,961,2);
  }
  else {
    Rv4=PAS__NEW(60);
    Ra.sl[3]=445; /* line # 445 */
    Rv5=Rv4;
    memcpy(Rv5,F_id,32);
    ((V *)Rv5)[8]=NULL;
    ((V *)Rv5)[9]=NULL;
    Ra.sl[3]=450; /* line # 450 */
    ((V *)Rv5)[10]=NULL;
    ((UB *)Rv5)[44]=0;
    memcpy(Rv5+48,Rd.s+828,12);
    if (Rv1==NULL) {
      Ra.sl[3]=455; /* line # 455 */
      V_macsymb_tree=Rv4;
    }
    else {
      if (Rv2>0) ((V *)Rv1)[10]=Rv4;
      else((V *)Rv1)[9]=Rv4;
    }
  }
  Ra.sl[3]=460; /* line # 460 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sortmc1 "  */
void PAS_INSMBOL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+840;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=487; /* line # 487 */
  Rv0=F_p;
  if (((V *)Rv0)[9]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[9]);
  Rv1=((UB *)Rv0)[0]==0;
  if (!Rv1) {
    Ra.sl[3]=493; /* line # 493 */
    if (V_macsymb_frst==NULL) V_macsymb_frst=F_p;
    else((V *)Lx[0].v[0])[8]=F_p;
    Lx[0].v[0]=F_p;
    ((V *)Rv0)[8]=NULL;
    Lx[0].sl[1]=Lx[0].sl[1]+1;
  }
  Ra.sl[3]=499; /* line # 499 */
  if (((V *)Rv0)[10]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[10]);
  if (Rv1) {
    Rv2=F_p;
    Rv3=Rv2+48;
    Ra.sl[3]=504; /* line # 504 */
    if (((V *)Rv3)[2]!=NULL) PAS__DISPOSE(((V *)Rv3)+2);
    PAS__DISPOSE(&F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rebuild_mctree1 "  */
V PAS_INSMBOL_PRC_00000002(SL F_n, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+849;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=518; /* line # 518 */
  Rv0=(F_n+F_m)/2;
  Rv1=((V *)Lx[0].v[2])[Rv0];
  Rv2=Rv1;
  if (Rv0==F_n) ((V *)Rv2)[9]=NULL;
  else {
    Ra.sl[3]=523; /* line # 523 */
    ((V *)Rv2)[9]=PAS_INSMBOL_PRC_00000002(F_n, Rv0-1);
  }
  if (Rv0==F_m) ((V *)Rv2)[10]=NULL;
  else((V *)Rv2)[10]=PAS_INSMBOL_PRC_00000002(Rv0+1, F_m);
  Ret=Rv1;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rebuild_mctree "  */
void P_rebuild_mctree(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+12;
  Ra.v[4]=Rd.s+866;
  Ra.v[5]=Rd.s+16;
  Ra.sl[6]=533; /* line # 533 */
  Ra.sl[1]=0;
  V_macsymb_frst=NULL;
  if (V_macsymb_tree!=NULL) {
    PAS_INSMBOL_PRC_00000001(V_macsymb_tree);
    Ra.sl[6]=538; /* line # 538 */
    if (Ra.sl[1]>0) {
      Ra.v[0]=V_macsymb_frst;
      Rv0=Ra.sl[1];
      Ra.v[2]=PAS__NEW(Rv0*4+4);
      ((SL *)Ra.v[2])[0]=Rv0;
      Rv1=1;
      for( Rf0=Ra.sl[1];Rf0>0;Rf0-- ) {
        Ra.sl[6]=543; /* line # 543 */
        ((V *)Ra.v[2])[Rv1]=Ra.v[0];
        Ra.v[0]=((V *)Ra.v[0])[8];
        Rv1++;
      }
      V_macsymb_tree=PAS_INSMBOL_PRC_00000002(1, Ra.sl[1]);
    }
    else {
      Ra.sl[6]=549; /* line # 549 */
      V_macsymb_tree=NULL;
      V_macsymb_frst=NULL;
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+882;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=637; /* line # 637 */
  V_sy_ch=P_src_inchar();
  V_sy_cmin=V_sy_ch;
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+890;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=646; /* line # 646 */
  if (!Lx[1].ub[0]) {
    if (Lx[1].sl[1]<V_sy_string.ub[0]) {
      V_sy_string.c[Lx[1].sl[1]+1]=V_sy_ch;
      Lx[1].sl[1]=Lx[1].sl[1]+1;
    }
    else {
      Ra.sl[3]=654; /* line # 654 */
      P_src_error(Rd.s+902,12,2);
      Lx[1].ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000005(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+906;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=665; /* line # 665 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    if ((Lx[1].ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else Rv0=-1;
  }
  if (Rv0>=Lx[1].sl[3]) Rv0=-2;
  Ra.sl[3]=670; /* line # 670 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000006(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+920;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=681; /* line # 681 */
  Rv0=PAS_INSMBOL_PRC_00000005(F_ch);
  if (Rv0==-2) {
    Rv0=0;
    P_src_error(Rd.s+931,16,2);
  }
  Ra.sl[3]=686; /* line # 686 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000007(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+935;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=696; /* line # 696 */
  Ri.sl[0]=Ri.sl[0]+1;
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+948,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  if (F_ierr>=20&&F_ierr<=25) {
    if (!Lx[1].ub[16]) {
      Ra.sl[3]=702; /* line # 702 */
      P_src_error(Rd.s+902,11,2);
      Lx[1].g[3]=1.000000000000000E+000;
      Lx[1].g[4]=1.000000000000000E+000;
      Lx[1].ub[16]=1;
    }
    Ret=1;
  }
  else {
    Ra.sl[3]=709; /* line # 709 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register V Rv2;
  G Rv3;
  SL Rv4;
  SL Rv5;
  G Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  C Rv14;
  UB Rv15;
  SL Rv16;
  register V Rv17;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[10]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[11]=Rd.s+961;
  Ra.v[12]=Rd.s+16;
  Ra.sl[13]=715; /* line # 715 */
  while (V_sy_ch==32||V_sy_ch==0)
  PAS_INSMBOL_PRC_00000003();
  Rv0=1;
  Rv1=V_sy_attrflg;
  V_sy_attrflg=0;
  Rv2=V_src_control;
  ((SL *)Rv2)[2]=((SL *)Rv2)[3];
  Ra.sl[13]=720; /* line # 720 */
  switch (Ri.ub[V_sy_cmin+4]) {
    case 8:
    case 9:PAS__ESTABLISH(PAS_INSMBOL_PRC_00000007);
    Ra.sl[13]=725; /* line # 725 */
    Ra.ub[16]=0;
    V_sy_sym.ub[0]=20;
    V_sy_sym.ub[1]=29;
    Rv3=0.000000000000000E-001;
    Ra.sl[3]=10;
    Ra.sl[13]=730; /* line # 730 */
    Rv4=0;
    Ra.ub[8]=0;
    while (Ri.ub[V_sy_cmin+4]==8){
      V_sy_sym.ub[0]=2;
      Ra.sl[13]=735; /* line # 735 */
      Rv5=(SL)V_sy_cmin-48;
      if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      while (1){
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_cmin!=95)  break;
      }
      if (!Ra.ub[16]) Rv3=Rv3*1.000000000000000E+001+(double)Rv5;
    }
    Ra.sl[13]=741; /* line # 741 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Rv4=0;
      Ra.sl[3]=(Rv3>0.0?(SL)(Rv3+0.5):(SL)(Rv3-0.5));
      if (Ra.sl[3]<2||Ra.sl[3]>16) {
        Ra.sl[13]=747; /* line # 747 */
        P_src_error(Rd.s+902,14,2);
        Ra.sl[3]=10;
      }
      Ra.ub[8]=1;
      Rv3=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[13]=753; /* line # 753 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
        if ((float)Rv5<(F)0.000000E-01)  break;
        if (!Ra.ub[16]) Rv3=Rv3*(double)Ra.sl[3]+(double)Rv5;
        if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      }
    }
    Ra.sl[13]=762; /* line # 762 */
    Rv6=(double)Ra.sl[3];
    Ra.g[3]=Rv6;
    if (V_sy_ch==46) {
      if (P_src_next_char()==46) {
        Ra.sl[13]=767; /* line # 767 */
        if (V_sy_sym.ub[0]==20) {
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=21;
        }
        else {
          Ra.sl[13]=772; /* line # 772 */
          Rv0=0;
        }
      }
      else {
        while (1){
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Rv6=(double)Ra.sl[3];
        Ra.g[3]=Rv6;
        Ra.g[4]=1.000000000000000E+000;
        Ra.sl[13]=777; /* line # 777 */
        if (PAS_INSMBOL_PRC_00000005(V_sy_cmin)<0) Rv0=0;
        else {
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[13]=783; /* line # 783 */
            if (Ra.g[4]!=1.000000000000000E+000) while (1){
              PAS_INSMBOL_PRC_00000003();
              if (V_sy_cmin!=95)  break;
            }
            Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
            if (Rv5<0)  break;
            Ra.g[4]=Ra.g[4]/Rv6;
            Ra.sl[13]=788; /* line # 788 */
            Rv3=Rv3+Ra.g[4]*(double)Rv5;
            Rv4=Rv4+1;
          }
        }
      }
    }
    Ra.sl[13]=795; /* line # 795 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000003();
    if (V_sy_sym.ub[0]!=20&&V_sy_sym.ub[0]!=21) {
      if (V_sy_cmin==101) {
        Ra.sl[13]=801; /* line # 801 */
        V_sy_sym.ub[0]=4;
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_ch==43||V_sy_ch==45) {
          if (V_sy_ch==45) Ra.g[3]=1.000000000000000E+000/Ra.g[3];
          Ra.sl[13]=806; /* line # 806 */
          PAS_INSMBOL_PRC_00000003();
        }
        Rv7=0;
        while (Ri.ub[V_sy_cmin+4]==8){
          Ra.sl[13]=812; /* line # 812 */
          Rv7=Rv7*10+((SL)V_sy_ch-48);
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[13]=817; /* line # 817 */
        Ra.g[4]=1.000000000000000E+000;
        while (Rv7!=0&&!Ra.ub[16])
        if (Rv7&1) {
          Ra.sl[13]=822; /* line # 822 */
          Rv7=Rv7-1;
          Ra.g[4]=Ra.g[4]*Ra.g[3];
        }
        else {
          Ra.sl[13]=827; /* line # 827 */
          Rv7=Rv7/2;
          Ra.g[3]=PAS__G_SQR(Ra.g[3]);
        }
        if (!Ra.ub[16]) Rv3=Rv3*Ra.g[4];
      }
      Ra.sl[13]=834; /* line # 834 */
      if (Ra.ub[16]) Rv3=0.000000000000000E-001;
      if (V_sy_sym.ub[0]==2) {
        if (Rv3<=4.294967295000001E+009&&Rv3>=-2.147483648000001E+009) {
          Ra.sl[13]=840; /* line # 840 */
          if (Rv3>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rv3)+1;
          else V_sy_ival=(int)(Rv3);
          V_sy_rval=(double)V_sy_ival;
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
            Ra.sl[13]=846; /* line # 846 */
            PAS_INSMBOL_PRC_00000003();
            P_ide_int_label();
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[13]=851; /* line # 851 */
          V_sy_sym.ub[0]=4;
        }
      }
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[13]=856; /* line # 856 */
        V_sy_ival=0;
        if (Rv3>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[13]=861; /* line # 861 */
          if (Ra.sl[3]>2) Rv4=Rv4*(int)(log(Rv6)/6.931471805599453E-001)+2;
          else Rv4=Rv4+2;
          if (Rv4>24) V_sy_sym.ub[0]=4;
          else V_sy_sym.ub[0]=3;
        }
      }
      Ra.sl[13]=868; /* line # 868 */
      V_sy_rval=Rv3;
      Rv0=0;
    }
    PAS__REVERT();
    break;
    case 7:Ra.sl[13]=875; /* line # 875 */
    V_sy_ident.ub[0]=0;
    while (1){
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[13]=882; /* line # 882 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      PAS_INSMBOL_PRC_00000003();
      if (Ri.ub[V_sy_cmin+4]!=7&&Ri.ub[V_sy_cmin+4]!=8)  break;
    }
    Ra.sl[13]=888; /* line # 888 */
    Rv8=V_keyword_tree;
    while (1){
      Rv9=Rv8;
      Rv10=P_match(V_sy_ident.s,Rv9);
      Ra.sl[13]=893; /* line # 893 */
      if (Rv10!=0) {
        if (Rv10>0) Rv8=((V *)Rv9)[9];
        else Rv8=((V *)Rv9)[8];
      }
      if (Rv10==0||Rv8==NULL)  break;
    }
    if (Rv8!=NULL) {
      Ra.sl[13]=898; /* line # 898 */
      memcpy(V_sy_sym.s,Rv8+40,2);
    }
    else {
      V_sy_macsymb=V_macsymb_tree;
      Ra.sl[13]=903; /* line # 903 */
      V_sy_sym.ub[0]=99;
      Rv10=1;
      while (Rv10!=0&&V_sy_macsymb!=NULL){
        Rv11=V_sy_macsymb;
        Ra.sl[13]=908; /* line # 908 */
        Rv10=P_match(V_sy_ident.s,Rv11);
        if (Rv10!=0) {
          if (Rv10>0) V_sy_macsymb=((V *)Rv11)[10];
          else V_sy_macsymb=((V *)Rv11)[9];
        }
      }
      if (Rv10==0) V_sy_sym.ub[0]=99;
      else {
        Ra.sl[13]=915; /* line # 915 */
        if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=1;
        }
        else {
          Ra.sl[13]=922; /* line # 922 */
          if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
          V_sy_sym.ub[0]=0;
        }
      }
      Ra.sl[13]=927; /* line # 927 */
      V_sy_sym.ub[1]=29;
    }
    Rv0=0;
    break;
    case 6:Ra.sl[13]=933; /* line # 933 */
    if (Rv1) {
      V_sy_sym.ub[0]=25;
      V_sy_sym.ub[1]=29;
      Rv1=0;
    }
    else {
      Ra.sl[13]=940; /* line # 940 */
      V_sy_sym.ub[1]=29;
      Rv12=V_src_control;
      Rv13=(524288&((UL *)Rv12)[52])!=0;
      Ra.sl[13]=945; /* line # 945 */
      ((UB *)Rv12)[212]=4;
      ((UL *)Rv12)[52]=((UL *)Rv12)[52]|524288;
      Rv14=V_sy_cmin;
      V_sy_sym.ub[0]=5;
      Ra.sl[13]=950; /* line # 950 */
      Ra.sl[1]=1;
      Ra.ub[0]=0;
      Rv15=1;
      while (Rv15){
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[13]=955; /* line # 955 */
        while (Ri.ub[V_sy_cmin+4]==1)
        PAS_INSMBOL_PRC_00000003();
        if (Ri.ub[V_sy_cmin+4]==2) Rv15=0;
        if (V_sy_ch==Rv14) {
          if (Rv14==P_src_next_char()) {
            Ra.sl[13]=961; /* line # 961 */
            PAS_INSMBOL_PRC_00000003();
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            ((UB *)V_src_control)[212]=0;
            Ra.sl[13]=966; /* line # 966 */
            Rv15=0;
          }
        }
        else {
          if (Rv14==34&&V_sy_ch==92) {
            Ra.sl[13]=972; /* line # 972 */
            PAS_INSMBOL_PRC_00000003();
            switch (V_sy_cmin) {
              case 34:
              case 39:
              case 92:break;
              case 97:V_sy_ch=7;
              break;
              case 98:V_sy_ch=8;
              break;
              case 101:Ra.sl[13]=977; /* line # 977 */
              V_sy_ch=27;
              break;
              case 102:V_sy_ch=12;
              break;
              case 110:V_sy_ch=10;
              break;
              case 114:V_sy_ch=13;
              break;
              case 116:V_sy_ch=9;
              break;
              case 118:Ra.sl[13]=982; /* line # 982 */
              V_sy_ch=11;
              break;
              case 122:V_sy_ch=0;
              break;
              case 48:
              case 49:
              case 50:
              case 51:
              case 52:
              case 53:
              case 54:
              case 55:
              case 56:
              case 57:Rv10=(SL)V_sy_cmin-48;
              PAS_INSMBOL_PRC_00000003();
              Ra.sl[13]=987; /* line # 987 */
              Rv16=3;
              while ((Rv16>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
                Rv10=(Rv10*10+(SL)V_sy_cmin)-48;
                PAS_INSMBOL_PRC_00000003();
              }
              Ra.sl[13]=993; /* line # 993 */
              if (Rv10<=255) V_sy_ch=(C)Rv10;
              else {
                V_sy_ch=32;
                P_src_error(Rd.s+902,17,2);
              }
              break;
              default:V_sy_ch=32;
              P_src_error(Rd.s+902,18,2);
              break;
            }
            Ra.sl[13]=999; /* line # 999 */
            PAS_INSMBOL_PRC_00000004();
          }
          else PAS_INSMBOL_PRC_00000004();
        }
      }
      V_sy_string.ub[1]=Ra.sl[1] -1;
      Ra.sl[13]=1005; /* line # 1005 */
      Rv17=V_src_control;
      if (!Rv13) {
        ((UL *)Rv17)[52]=((UL *)Rv17)[52]&~524288;
        if (Ri.ub[V_sy_cmin+4]==1) V_sy_ch=32;
      }
    }
    break;
    case 14:Ra.sl[13]=1015; /* line # 1015 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[1]=29;
    if (V_sy_ch==61) V_sy_sym.ub[0]=23;
    else {
      V_sy_sym.ub[0]=22;
      Rv0=0;
    }
    break;
    case 11:Ra.sl[13]=1023; /* line # 1023 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[13]=1028; /* line # 1028 */
        V_sy_sym.ub[1]=14;
        Rv0=0;
      }
    }
    break;
    case 13:Ra.sl[13]=1033; /* line # 1033 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      V_sy_sym.ub[1]=17;
      Rv0=0;
    }
    break;
    case 5:Ra.sl[13]=1041; /* line # 1041 */
    Rv14=V_sy_ch;
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==Rv14) {
      V_sy_sym.ub[0]=9;
      V_sy_sym.ub[1]=13;
    }
    else {
      V_sy_sym.ub[0]=13;
      V_sy_sym.ub[1]=21;
      Rv0=0;
    }
    break;
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[13]=1048; /* line # 1048 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    break;
    case 17:
    case 25:
    case 26:memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    Ra.sl[13]=1053; /* line # 1053 */
    PAS_INSMBOL_PRC_00000003();
    if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
    Rv0=0;
    break;
    case 10:Ra.sl[13]=1060; /* line # 1060 */
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      V_sy_sym.ub[0]=8;
      V_sy_sym.ub[1]=6;
      Rv0=0;
    }
    break;
    case 12:Ra.sl[13]=1067; /* line # 1067 */
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=26;
      V_sy_sym.ub[1]=29;
    }
    else {
      V_sy_sym.ub[0]=10;
      V_sy_sym.ub[1]=19;
      Rv0=0;
    }
    break;
    case 2:Ra.sl[13]=1073; /* line # 1073 */
    V_sy_sym.ub[0]=103;
    V_sy_sym.ub[1]=29;
    V_sy_ch=32;
    Rv0=0;
    break;
    case 1:V_sy_sym.ub[0]=88;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[13]=1079; /* line # 1079 */
    V_sy_sym.ub[0]=104;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    if (V_sy_ch!=32) P_src_error(Rd.s+902,13,2);
    V_sy_ch=32;
    break;
  }
  Ra.sl[13]=1086; /* line # 1086 */
  if (Rv0) PAS_INSMBOL_PRC_00000003();
  PAS__curr_cntx=Ra.v[10];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " skip_mcsymbol "  */
void PAS_INSMBOL_skip_mcsymbol(V F_smb){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+975;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1093; /* line # 1093 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,105)||V_sy_sym.ub[0]==89)){
    P_insymbol_src();
    Ra.sl[3]=1098; /* line # 1098 */
    switch (V_sy_sym.ub[0]) {
      case 93:
      case 94:
      case 95:while (PAS__INOP_LSET(V_sy_sym.ub[0],Rd.s+992,96)){
        PAS_INSMBOL_skip_mcsymbol(Rd.s+1004);
        Ra.sl[3]=1103; /* line # 1103 */
        P_insymbol_src();
      }
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cb_macro_manager "  */
V PAS_INSMBOL_cb_macro_manager(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1020;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1125; /* line # 1125 */
  Rv0=F_mcp;
  ((UB *)Rv0)[44]=0;
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " macro_replace "  */
void P_macro_replace(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1038;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1146; /* line # 1146 */
  Rv2=F_mcp;
  Rv3=Rv2+48;
  if (!((UB *)Rv2)[44]) {
    switch (((UB *)Rv3)[0]) {
      case 0:Ra.sl[3]=1153; /* line # 1153 */
      Rv0=PAS__NEW(24);
      ((UB *)Rv0)[0]=22;
      PAS__VWRITE_INIT(Rv0,1);
      PAS__WRITE_INT(((SL *)Rv3)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[3]=1158; /* line # 1158 */
      Rv4=((UB *)((V *)Rv3)[2])[1];
      Rv0=PAS__NEW((SL)Rv4+2);
      ((UB *)Rv0)[0]=Rv4;
      PAS__STR_TO_STR(Rv0,((V *)Rv3)[2]);
      break;
      default:break;
    }
    Ra.sl[3]=1163; /* line # 1163 */
    ((UB *)Rv2)[44]=1;
    Rv1=P_src_macro_open(Rv0, (V)PAS_INSMBOL_cb_macro_manager,F_mcp,1,NULL);
    V_sy_ch=0;
  }
  else {
    Ra.sl[3]=1169; /* line # 1169 */
    P_src_error_s(Rd.s+1055,979,2, F_mcp,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_macro_symbol "  */
void PAS_INSMBOL_define_macro_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1059;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1183; /* line # 1183 */
  P_insymbol_src();
  while (1){
    if (V_sy_sym.ub[0]==99) {
      Ra.sl[3]=1189; /* line # 1189 */
      P_src_error_s(Rd.s+1082,951,2, V_sy_ident.s,NULL);
      P_skip_msymbol((V)Rd.s+1088,0);
    }
    else {
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[3]=1195; /* line # 1195 */
        P_src_error(Rd.s+1082,952,2);
        P_skip_msymbol((V)Rd.s+1092,0);
      }
      else {
        Ra.sl[3]=1200; /* line # 1200 */
        Rv0=P_create_mac_ident(V_sy_ident.s,0);
        P_insymbol_src();
        if (V_sy_sym.ub[0]==23) {
          Rv1=Rv0;
          Ra.sl[3]=1205; /* line # 1205 */
          P_insymbol_src();
          PAS_INSMBOL_get_macro_value(Rv1+48);
        }
      }
    }
    Ra.sl[3]=1218; /* line # 1218 */
    if (V_sy_sym.ub[0]!=18)  break;
    P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1082,21,2);
  else P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " undefine_macro_symbol "  */
void PAS_INSMBOL_undefine_macro_mbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1096;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1234; /* line # 1234 */
  P_insymbol_src();
  while (1){
    if (V_sy_sym.ub[0]!=99) {
      Ra.sl[3]=1240; /* line # 1240 */
      P_src_error(Rd.s+1121,952,2);
      P_skip_msymbol((V)Rd.s+1128,0);
    }
    else {
      Ra.sl[3]=1245; /* line # 1245 */
      if (V_sy_macsymb==NULL) P_src_error_s(Rd.s+1121,953,2, V_sy_ident.s,NULL);
      else {
        Rv0=V_sy_macsymb;
        Ra.sl[3]=1250; /* line # 1250 */
        ((UB *)Rv0)[0]=0;
        if (((V *)Rv0)[14]!=NULL) PAS__DISPOSE(((V *)Rv0)+14);
      }
      P_insymbol_src();
    }
    Ra.sl[3]=1256; /* line # 1256 */
    if (V_sy_sym.ub[0]!=18)  break;
    P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1121,21,2);
  else P_insymbol_src();
  Ra.sl[3]=1262; /* line # 1262 */
  P_rebuild_mctree();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_assign_symbol "  */
void PAS_INSMBOL_macro_assign_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1132;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1275; /* line # 1275 */
  P_insymbol_src();
  if (V_sy_sym.ub[0]!=99) {
    Ra.sl[3]=1280; /* line # 1280 */
    P_src_error(Rd.s+1155,952,2);
    P_skip_msymbol(Rd.s+1160,0);
  }
  else {
    Ra.sl[3]=1285; /* line # 1285 */
    Rv0=V_sy_macsymb;
    P_insymbol_src();
    if (V_sy_sym.ub[0]!=23) P_src_error(Rd.s+1155,32,2);
    else P_insymbol_src();
    Rv1=Rv0;
    Ra.sl[3]=1291; /* line # 1291 */
    if (((V *)Rv1)[14]!=NULL) PAS__DISPOSE(((V *)Rv1)+14);
    PAS_INSMBOL_get_macro_value(Rv1+48);
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1155,21,2);
  else {
    Ra.sl[3]=1296; /* line # 1296 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mval "  */
void PAS_INSMBOL_show_mval(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1176;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1304; /* line # 1304 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1187,-1,-1,32);
  PAS__WRITE_ENM(((UB *)F_vl)[0],Rd.s+1204,0,-1,32);
  PAS__WRITE_STR(Rd.s+1246,-1,-1,32);
  PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
  PAS__WRITE_STR(Rd.s+1252,-1,-1,32);
  if (((V *)F_vl)[2]!=NULL&&((UB *)F_vl)[0]==1) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(((V *)F_vl)[2],-1,-1,32);
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1259,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mstack "  */
void PAS_INSMBOL_show_mstack(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1263;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1311; /* line # 1311 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(F_s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1276,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[39],-2,0);
  PAS__WRITE_EOLN();
  Rv0=Ri.sl[39];
  for( Rf0=Ri.sl[39];Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1293,-1,-1,32);
    PAS__WRITE_INT(Rv0,-2,0);
    PAS__WRITE_STR(Rd.s+1297,-1,-1,32);
    PAS_INSMBOL_show_mval((Rs.s+Rv0*12-12));
    Rv0--;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_cop "  */
void PAS_INSMBOL_mval_cop(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1303;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1322; /* line # 1322 */
  ((UB *)F_dst)[0]=((UB *)F_src)[0];
  ((SL *)F_dst)[1]=((SL *)F_src)[1];
  if (((V *)F_src)[2]!=NULL) {
    Rv0=((UB *)((V *)F_src)[2])[1];
    ((V *)F_dst)[2]=PAS__NEW((SL)Rv0+2);
    ((UB *)((V *)F_dst)[2])[0]=Rv0;
    Ra.sl[3]=1327; /* line # 1327 */
    PAS__STR_TO_STR(((V *)F_dst)[2],((V *)F_src)[2]);
  }
  else((V *)F_dst)[2]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_free "  */
void PAS_INSMBOL_mval_free(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1313;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1336; /* line # 1336 */
  if (((V *)F_vl)[2]!=NULL) PAS__DISPOSE(((V *)F_vl)+2);
  memcpy(F_vl,Rd.s+828,12);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpush "  */
void PAS_INSMBOL_mpush(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1324;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1347; /* line # 1347 */
  if (Ri.sl[39]<32) Ri.sl[39]=Ri.sl[39]+1;
  else P_src_error(Rd.s+1333,961,3);
  PAS_INSMBOL_mval_cop(F_vl,(Rs.s+Ri.sl[39]*12-12));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpop "  */
void PAS_INSMBOL_mpop(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1337;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1359; /* line # 1359 */
  if (Ri.sl[39]>0) {
    memcpy(F_vl,(Rs.s+Ri.sl[39]*12-12),12);
    Ri.sl[39]=Ri.sl[39]-1;
  }
  else {
    Ra.sl[3]=1366; /* line # 1366 */
    P_src_error(Rd.s+1345,962,3);
    memcpy(F_vl,Rd.s+828,12);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_macro_value "  */
void PAS_INSMBOL_get_macro_value(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1349;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1385; /* line # 1385 */
  PAS_INSMBOL_m_expr_instk();
  PAS_INSMBOL_mpop(F_vl);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_intv "  */
SL PAS_INSMBOL_mexp_intv(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1366;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1398; /* line # 1398 */
  PAS_INSMBOL_mpop(Ra.s+16);
  if (Ra.ub[16]==0) Rv0=Ra.sl[5];
  else {
    if (Ra.v[6]==NULL) Rv0=0;
    else {
      Ra.sl[3]=1404; /* line # 1404 */
      Rv1=Ra.v[6];
      Rv0=0;
      Rv2=0;
      Rv3=((UB *)Rv1)[1];
      while (Rv2<Rv3&&((C *)Rv1)[Rv2+1]<=32)
      Rv2=Rv2+1;
      while (Rv2<Rv3){
        Ra.sl[3]=1410; /* line # 1410 */
        Rv4=((C *)Rv1)[Rv2+1];
        if ((Rv4<48||Rv4>57)&&Rv4>32)  break;
        if (Rv4>32) Rv0=Rv0*10+((SL)Rv4-48);
        Rv2=Rv2+1;
      }
      Ra.sl[3]=1416; /* line # 1416 */
      PAS__DISPOSE(Ra.v+6);
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexp_vl_str "  */
void PAS_INSMBOL_mexp_vl_str(V F_vl, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1377;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1426; /* line # 1426 */
  if (((UB *)F_vl)[0]==0) {
    PAS__VWRITE_INIT(F_str,1);
    PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__STR_TO_STR(F_str,((V *)F_vl)[2]);
    Ra.sl[3]=1431; /* line # 1431 */
    PAS__DISPOSE(((V *)F_vl)+2);
    ((V *)F_vl)[2]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_strv "  */
void PAS_INSMBOL_mexp_strv(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1390;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1443; /* line # 1443 */
  PAS_INSMBOL_mpop(Ra.s+16);
  PAS_INSMBOL_mexp_vl_str(Ra.s+16,F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_call "  */
void PAS_INSMBOL_mexp_call(UB F_fn, SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+828,12);
  Ra.ub[12]=255;
  Ra.ub[269]=255;
  Ra.v[132]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+528;
  Ra.v[133]=Rd.s+1401;
  Ra.v[134]=Rd.s+16;
  Ra.sl[135]=1460; /* line # 1460 */
  if (F_fn==0) {
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1414,22,2);
    else {
      Ra.sl[135]=1465; /* line # 1465 */
      P_insymbol_src();
    }
    if (V_sy_sym.ub[0]==99&&V_sy_macsymb!=NULL) Ra.sl[1]=1;
    else Ra.sl[1]=0;
    Ra.ub[0]=0;
    Ra.sl[135]=1470; /* line # 1470 */
    P_insymbol_src();
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+1414,23,2);
    PAS_INSMBOL_mpush(Ra.s);
  }
  else {
    Ra.sl[135]=1476; /* line # 1476 */
    Rv0=0;
    if (V_sy_sym.ub[0]==14) {
      V_sy_sym.ub[0]=18;
      while (V_sy_sym.ub[0]==18){
        Ra.sl[135]=1482; /* line # 1482 */
        P_insymbol_src();
        PAS_INSMBOL_m_expr_instk();
        Rv0=Rv0+1;
      }
      if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+1414,23,2);
    }
    Ra.sl[135]=1488; /* line # 1488 */
    if (F_narg>0&&Rv0!=F_narg||F_narg<0&&Rv0> -F_narg) {
      P_src_error(Rd.s+1414,954,2);
      for( Rf0=Rv0;Rf0>0;Rf0-- )
      PAS_INSMBOL_mpop(Ra.s);
      Ra.sl[135]=1493; /* line # 1493 */
      PAS_INSMBOL_mpush(Rd.s+828);
    }
    else {
      Ra.sl[135]=1498; /* line # 1498 */
      switch (F_fn) {
        case 3:PAS_INSMBOL_mexp_strv(Ra.s+12);
        Ra.sl[1]=Ra.ub[13];
        Ra.sl[135]=1503; /* line # 1503 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1418,-1,-1,32);
        PAS__WRITE_STR(Ra.s+12,-1,-1,32);
        PAS__WRITE_STR(Rd.s+1429,-1,-1,32);
        PAS__WRITE_INT(Ra.sl[1],0,0);
        PAS__WRITE_EOLN();
        break;
        case 1:Ra.sl[135]=1508; /* line # 1508 */
        if (F_narg==3) Rv1=PAS_INSMBOL_mexp_intv();
        else Rv1=0;
        if (F_narg>1) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=1;
        if (F_narg>0) PAS_INSMBOL_mexp_strv(Ra.s+12);
        else Ra.ub[13]=0;
        Ra.ub[0]=1;
        Ra.sl[1]=0;
        Ra.sl[135]=1513; /* line # 1513 */
        PAS__STR_TO_STR(Ra.s+269,PAS__SUBSTR_STR(Ra.s+544,Ra.s+12,Rv2, Rv1));
        if (Ra.ub[270]>0) {
          Rv3=Ra.ub[270];
          Ra.v[2]=PAS__NEW((SL)Rv3+2);
          ((UB *)Ra.v[2])[0]=Rv3;
          PAS__STR_TO_STR(Ra.v[2],Ra.s+269);
        }
        break;
        case 2:Ra.sl[135]=1524; /* line # 1524 */
        if (F_narg==3) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=0;
        if (F_narg<2) Ra.ub[270]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+269);
        if (F_narg<1) Ra.ub[13]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+12);
        Ra.sl[1]=PAS__NINDEX_STR(Ra.s+14,(SL)Ra.ub[13],Ra.s+271,(SL)Ra.ub[270],Rv2,-1,1);
        break;
        default:Ra.sl[135]=1532; /* line # 1532 */
        P_src_error(Rd.s+1414,959,2);
        break;
      }
      PAS_INSMBOL_mpush(Ra.s);
    }
  }
  PAS__curr_cntx=Ra.v[132];
}


/* Procedure/Function : " mexp_ident "  */
void PAS_INSMBOL_mexp_ident(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register UB Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1437;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1552; /* line # 1552 */
  Rv0=1;
  Rv1=1;
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[3]=1559; /* line # 1559 */
    Rv2=0;
    while (Rv2<4){
      if (P_match(V_sy_ident.s,(Rd.s+Rv2*36+1456))==0)  break;
      Rv2=Rv2+1;
    }
    Ra.sl[3]=1565; /* line # 1565 */
    if (Rv2>=4) {
      P_src_error_s(Rd.s+1451,958,3, V_sy_ident.s,NULL);
      P_skip_msymbol((V)Rd.s+1636,0);
    }
    else {
      Ra.sl[3]=1572; /* line # 1572 */
      P_insymbol_src();
      PAS_INSMBOL_mexp_call(Rv2, Rd.sl[Rv2*9+372]);
      Rv1=0;
    }
    break;
    case 99:Ra.sl[3]=1579; /* line # 1579 */
    if (V_sy_macsymb!=NULL) {
      Rv1=0;
      PAS_INSMBOL_mpush(V_sy_macsymb+48);
    }
    else {
      Ra.sl[3]=1586; /* line # 1586 */
      P_src_error(Rd.s+1451,953,2);
    }
    break;
    case 5:Ra.sl[3]=1591; /* line # 1591 */
    Ra.ub[16]=1;
    Ra.sl[5]=0;
    if (V_sy_string.ub[1]>0) {
      Rv3=V_sy_string.ub[1];
      Ra.v[6]=PAS__NEW((SL)Rv3+2);
      ((UB *)Ra.v[6])[0]=Rv3;
      Ra.sl[3]=1596; /* line # 1596 */
      PAS__STR_TO_STR(Ra.v[6],V_sy_string.s);
    }
    break;
    case 2:Ra.sl[3]=1602; /* line # 1602 */
    Ra.ub[16]=0;
    Ra.sl[5]=V_sy_ival;
    Ra.v[6]=NULL;
    break;
    case 18:
    case 19:Ra.sl[3]=1610; /* line # 1610 */
    memcpy(Ra.s+16,Rd.s+828,12);
    Rv0=0;
    break;
    default:Ra.sl[3]=1615; /* line # 1615 */
    memcpy(Ra.s+16,Rd.s+828,12);
    Rv0=0;
    P_src_error(Rd.s+1451,955,2);
    break;
  }
  if (Rv1) PAS_INSMBOL_mpush(Ra.s+16);
  Ra.sl[3]=1620; /* line # 1620 */
  if (Rv0) P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_binop "  */
void PAS_INSMBOL_mexp_binop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 816 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  SL Rv2;
  register F Rgf;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+828,12);
  Ra.ub[12]=255;
  Ra.ub[269]=255;
  Ra.v[132]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+528;
  Ra.v[133]=Rd.s+1640;
  Ra.v[134]=Rd.s+16;
  Ra.sl[135]=1639; /* line # 1639 */
  switch (F_ope) {
    case 6:Rv0=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[135]=1644; /* line # 1644 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()*Rv0;
    break;
    case 7:Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[135]=1649; /* line # 1649 */
    Ra.ub[0]=0;
    if (Rv0!=0) Ra.sl[1]=PAS__F_ROUND((float)PAS_INSMBOL_mexp_intv()/(float)Rv0)
    ;
    else Ra.sl[1]=0;
    break;
    case 11:Ra.sl[135]=1655; /* line # 1655 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()+Rv0;
    break;
    case 12:Ra.sl[135]=1661; /* line # 1661 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()-Rv0;
    break;
    case 13:Ra.sl[135]=1667; /* line # 1667 */
    PAS_INSMBOL_mexp_strv(Ra.s+12);
    PAS_INSMBOL_mexp_strv(Ra.s+269);
    PAS__STR_TO_STR(Ra.s+269,PAS__CON_STR_STR(Ra.s+544,Ra.s+269,Ra.s+12));
    Ra.ub[0]=1;
    Ra.sl[1]=0;
    Ra.sl[135]=1672; /* line # 1672 */
    Rv1=Ra.ub[270];
    Ra.v[2]=PAS__NEW((SL)Rv1+2);
    ((UB *)Ra.v[2])[0]=Rv1;
    PAS__STR_TO_STR(Ra.v[2],Ra.s+269);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:Ra.sl[135]=1677; /* line # 1677 */
    PAS_INSMBOL_mpop(Ra.s+804);
    PAS_INSMBOL_mpop(Ra.s);
    Ra.ub[0]=0;
    if (Ra.ub[804]==1||Ra.ub[0]==1) {
      Ra.sl[135]=1682; /* line # 1682 */
      PAS_INSMBOL_mexp_vl_str(Ra.s+804,Ra.s+12);
      PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+269);
      Rv2=PAS__MATCH_STR(Ra.s+269,Ra.s+12);
      Ra.v[2]=NULL;
    }
    else {
      Ra.sl[135]=1687; /* line # 1687 */
      Rv2=Ra.sl[1]-Ra.sl[202];
    }
    switch (F_ope) {
      case 14:Ra.sl[1]=(SL)(Rv2<0);
      break;
      case 15:Ra.sl[1]=(SL)(Rv2<=0);
      break;
      case 16:Ra.sl[1]=(SL)(Rv2>=0);
      break;
      case 17:Ra.sl[135]=1692; /* line # 1692 */
      Ra.sl[1]=(SL)(Rv2>0);
      break;
      case 18:Ra.sl[1]=(SL)(Rv2!=0);
      break;
      case 19:Ra.sl[1]=(SL)(Rv2==0);
      break;
    }
    break;
    case 20:Ra.sl[135]=1699; /* line # 1699 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=(SL)(Rv0>0&&Rv2>0);
    break;
    case 21:Ra.sl[135]=1707; /* line # 1707 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=(SL)(Rv0>0||Rv2>0);
    break;
    case 22:Ra.sl[135]=1715; /* line # 1715 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=(SL)(Rv0>0&&Rv2<=0||Rv0<=0&&Rv2>0);
    break;
    default:Ra.sl[135]=1724; /* line # 1724 */
    P_src_error(Rd.s+1654,956,3);
    break;
  }
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[132];
}


/* Procedure/Function : " mexp_unaop "  */
void PAS_INSMBOL_mexp_unaop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+828,12);
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+12;
  Ra.v[4]=Rd.s+1658;
  Ra.v[5]=Rd.s+16;
  Ra.sl[6]=1742; /* line # 1742 */
  switch (F_ope) {
    case 0:Ra.ub[0]=0;
    Ra.v[2]=NULL;
    Ra.sl[6]=1747; /* line # 1747 */
    Ra.sl[1]=(SL)(PAS_INSMBOL_mexp_intv()<=0);
    break;
    default:P_src_error(Rd.s+1672,956,3);
    break;
  }
  Ra.sl[6]=1754; /* line # 1754 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[3];
}


/* Procedure/Function : " mexp_una "  */
void PAS_INSMBOL_PRC_00000013(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1676;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1797; /* line # 1797 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) V_sy_sym.ub[0]
  =6;
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[3]=1803; /* line # 1803 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else Rv0=29;
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000013();
    if (Rv0!=29) PAS_INSMBOL_mexp_unaop(Rv0);
  }
  else {
    Ra.sl[3]=1810; /* line # 1810 */
    if (V_sy_sym.ub[0]==14) {
      P_insymbol_src();
      PAS_INSMBOL_m_expr_instk();
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else {
        Ra.sl[3]=1815; /* line # 1815 */
        P_src_error(Rd.s+1688,23,3);
      }
    }
    else PAS_INSMBOL_mexp_ident();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_mul "  */
void PAS_INSMBOL_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1692;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1822; /* line # 1822 */
  PAS_INSMBOL_PRC_00000013();
  while (V_sy_sym.ub[0]==10){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=1827; /* line # 1827 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000013();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_add "  */
void PAS_INSMBOL_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1702;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1834; /* line # 1834 */
  PAS_INSMBOL_PRC_00000012();
  while (V_sy_sym.ub[0]==9){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=1839; /* line # 1839 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000012();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_rel "  */
void PAS_INSMBOL_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1712;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1846; /* line # 1846 */
  PAS_INSMBOL_PRC_00000011();
  while (V_sy_sym.ub[0]==10){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=1851; /* line # 1851 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000011();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_not "  */
void PAS_INSMBOL_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1722;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1858; /* line # 1858 */
  PAS_INSMBOL_PRC_00000010();
  if (V_sy_sym.ub[0]==11) {
    Lx[2].ub[0]=V_sy_sym.ub[1];
    Ra.sl[3]=1863; /* line # 1863 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000010();
    PAS_INSMBOL_mexp_unaop(Lx[2].ub[0]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_and "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+1732;
  Ra.v[3]=Rd.s+16;
  Ra.sl[4]=1870; /* line # 1870 */
  PAS_INSMBOL_PRC_00000009();
  while (V_sy_sym.ub[0]==12){
    Ra.ub[0]=V_sy_sym.ub[1];
    Ra.sl[4]=1875; /* line # 1875 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000009();
    PAS_INSMBOL_mexp_binop(Ra.ub[0]);
  }
  PAS__curr_cntx=Ra.v[1];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " m_expr_instk "  */
void PAS_INSMBOL_m_expr_instk(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1742;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1882; /* line # 1882 */
  PAS_INSMBOL_PRC_00000008();
  while (V_sy_sym.ub[0]==13){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=1887; /* line # 1887 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000008();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_sval "  */
void PAS_INSMBOL_mexpr_sval(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1756;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1897; /* line # 1897 */
  PAS_INSMBOL_m_expr_instk();
  PAS_INSMBOL_mexp_strv(F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_ival "  */
SL PAS_INSMBOL_mexpr_ival(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1768;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1905; /* line # 1905 */
  PAS_INSMBOL_m_expr_instk();
  Ret=PAS_INSMBOL_mexp_intv();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexpr_bval "  */
UB PAS_INSMBOL_mexpr_bval(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1780;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1913; /* line # 1913 */
  PAS_INSMBOL_m_expr_instk();
  Ret=PAS_INSMBOL_mexp_intv()>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " if_mstate "  */
UB PAS_INSMBOL_if_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1792;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=1929; /* line # 1929 */
  Rv0=V_sy_sym.ub[0];
  P_insymbol_src();
  switch (Rv0) {
    case 94:
    case 95:Ra.sl[3]=1937; /* line # 1937 */
    Rv1=V_sy_macsymb!=NULL^Rv0==95;
    P_insymbol_src();
    break;
    case 93:Ra.sl[3]=1942; /* line # 1942 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    break;
    default:break;
  }
  if (V_sy_sym.ub[0]!=96) P_src_error(Rd.s+1805,902,2);
  Ra.sl[3]=1947; /* line # 1947 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_pragma_mstate(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1056 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+828,12);
  Ra.ub[12]=255;
  PAS__STR_TO_STR(Ra.s+12,Rd.s+1809);
  Ra.ub[269]=255;
  PAS__STR_TO_STR(Ra.s+269,Rd.s+1809);
  Ra.ub[526]=255;
  PAS__STR_TO_STR(Ra.s+526,Rd.s+1809);
  Ra.ub[783]=255;
  PAS__STR_TO_STR(Ra.s+783,Rd.s+1809);
  Ra.v[260]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1040;
  Ra.v[261]=Rd.s+2066;
  Ra.v[262]=Rd.s+16;
  Ra.sl[263]=2025; /* line # 2025 */
  P_insymbol_src();
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=F_p_src;
  Ra.sl[263]=2030; /* line # 2030 */
  Rv2=35&((UL *)Rv1)[52];
  while (V_sy_sym.ub[0]==0){
    Rv3=0;
    Rv4=0;
    while (1){
      Ra.sl[263]=2036; /* line # 2036 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      if (Rv3||Rv4==23)  break;
      Rv4=Rv4+1;
    }
    P_insymbol_src();
    Ra.sl[263]=2041; /* line # 2041 */
    switch (Rv4) {
      case 0:PAS_INSMBOL_get_macro_value(Ra.s);
      if (Ra.ub[0]==1) {
        Ra.sl[263]=2047; /* line # 2047 */
        PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+12);
        if (Ra.ub[13]>0) {
          Rv5=V_lst_current;
          Ra.sl[263]=2052; /* line # 2052 */
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+269,((V *)Rv5)[2]);
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+526,((V *)Rv5)[4]);
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+783,((V *)Rv5)[5]);
          Ra.sl[263]=2058; /* line # 2058 */
          P_lst_open(&V_lst_current, Ra.s+12,Ra.s+269,Ra.s+526,Ra.s+783,132,-1,0,0,0,
          &Rv6);
          Ra.sl[263]=2070; /* line # 2070 */
          if (Rv6!=0) {
            if (!V_sy_init_mod) P_src_error(Rd.s+2083,905,2);
            else {
              Ra.sl[263]=2075; /* line # 2075 */
              Rv2=Rv2&~1;
            }
          }
          else {
            if (((SL *)Rv1)[6]<((SL *)Rv1)[5]) ((SL *)Rv1)[6]=((SL *)Rv1)[5];
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[263]=2083; /* line # 2083 */
          Rv2=Rv2&~1;
        }
      }
      if (((SL *)Rv1)[6]<((SL *)Rv1)[5]) ((SL *)Rv1)[6]=((SL *)Rv1)[5];
      Rv2=Rv2|1;
      break;
      case 1:Ra.sl[263]=2089; /* line # 2089 */
      Rv2=Rv2&~1;
      break;
      case 2:Rv2=Rv2|2;
      break;
      case 3:Rv2=Rv2&~2;
      break;
      case 4:Ra.sl[263]=2094; /* line # 2094 */
      Rv2=Rv2|32;
      break;
      case 5:Rv2=Rv2&~32;
      break;
      case 6:Ra.sl[263]=2099; /* line # 2099 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[6]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[263]=2105; /* line # 2105 */
        ((SL *)Rv1)[6]=1;
      }
      break;
      case 7:Ra.sl[263]=2110; /* line # 2110 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[9]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[263]=2116; /* line # 2116 */
        ((SL *)Rv1)[9]=1;
      }
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[10]=V_sy_ival;
        P_insymbol_src();
      }
      else((SL *)Rv1)[10]=255;
      break;
      case 8:Ra.sl[263]=2123; /* line # 2123 */
      V_cmp_macf=1;
      break;
      case 9:V_cmp_macf=0;
      break;
      case 10:V_cmp_cobj=1;
      break;
      case 11:V_cmp_cobj=0;
      break;
      case 12:Ra.sl[263]=2130; /* line # 2130 */
      if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[263]=2135; /* line # 2135 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else P_src_error(Rd.s+2083,904,4);
      }
      else {
        Ra.sl[263]=2141; /* line # 2141 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 13:if (V_cmp_objf) {
        Ra.sl[263]=2147; /* line # 2147 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 14:V_cmp_bltt=1;
      break;
      case 15:V_cmp_bltt=0;
      break;
      case 16:Ra.sl[263]=2154; /* line # 2154 */
      if (V_sy_sym.ub[0]==2) {
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[263]=2159; /* line # 2159 */
        P_insymbol_src();
      }
      else P_src_error(Rd.s+2083,906,3);
      break;
      case 17:V_cmp_debugopt=1;
      break;
      case 18:Ra.sl[263]=2164; /* line # 2164 */
      V_cmp_debugopt=0;
      break;
      case 19:V_cmp_range=1;
      break;
      case 20:V_cmp_range=0;
      break;
      case 21:Ra.sl[263]=2169; /* line # 2169 */
      P_generation_pragma();
      break;
      case 22:V_cmp_cmpdbg=1;
      break;
      case 23:V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[263]=2175; /* line # 2175 */
      P_src_error_s(Rd.s+2083,901,1, V_sy_ident.s,NULL);
      break;
    }
    if (V_sy_sym.ub[0]==18) P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+2083,21,2);
  else {
    Ra.sl[263]=2180; /* line # 2180 */
    P_insymbol_src();
  }
  ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~35|Rv2;
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[260];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_include_mstate(UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2087;
  Ra.v[67]=Rd.s+16;
  Ra.sl[68]=2200; /* line # 2200 */
  Rv0=V_sy_sym.ub[0]==100;
  P_insymbol_src();
  PAS_INSMBOL_mexpr_sval(Ra.s);
  Ra.sl[68]=2205; /* line # 2205 */
  Rv1=NULL;
  Rv2=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  if (Rv2==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+276,Ra.s,Rd.s+2103));
  Rv1=P_src_file_open(Ra.s,0,NULL);
  Ra.sl[68]=2210; /* line # 2210 */
  if (V_src_openerr==0) {
    Rv3=Rv1;
    ((V *)Rv3)[1]=V_src_control;
    Ra.sl[68]=2215; /* line # 2215 */
    ((SL *)Rv3)[5]=((SL *)V_src_control)[5];
    if (Rv0) ((SL *)Rv3)[5]=((SL *)Rv3)[5]+1;
    ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
    ((SL *)Rv3)[4]=((SL *)V_src_control)[4];
    ((SL *)Rv3)[9]=((SL *)V_src_control)[9];
    Ra.sl[68]=2220; /* line # 2220 */
    ((SL *)Rv3)[10]=((SL *)V_src_control)[10];
    ((UL *)Rv3)[52]=((UL *)Rv3)[52]|((UL *)V_src_control)[52]&103;
    Ra.sl[68]=2225; /* line # 2225 */
    if (V_sy_sym.ub[0]==18) {
      P_insymbol_src();
      PAS_INSMBOL_pragma_mstate(Rv1);
    }
    else {
      Ra.sl[68]=2231; /* line # 2231 */
      if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+2111,21,2);
    }
    if (!Rv0) P_src_end_of_line();
    V_src_control=Rv1;
    if (V_cmp_trace>0) V_cmp_tracecount=0;
    P_compile_set_title();
    Ra.sl[68]=2236; /* line # 2236 */
    P_set_srcfilespc((SL)Rv0);
    V_sy_ch=32;
    V_sy_sym.ub[0]=101;
    if (!Rv0) {
      Ra.sl[68]=2241; /* line # 2241 */
      Rv4=V_src_control;
      Rv1=((V *)Rv4)[1];
      ((V *)Rv4)[1]=((V *)Rv1)[1];
      Ra.sl[68]=2246; /* line # 2246 */
      P_src_close(&Rv1,1);
    }
  }
  else {
    P_lst_newline();
    Ra.sl[68]=2251; /* line # 2251 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2115,-1,-1,32);
    PAS__WRITE_INT(V_src_openerr,3,0);
    PAS__WRITE_EOLN();
    P_lst_newline();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2137,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2161,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__GET_RTL_MSG(V_src_openerr, Ra.s);
    P_lst_newline();
    Ra.sl[68]=2256; /* line # 2256 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2165,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    while ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=103)
    P_insymbol_src();
    if (F_bnsferr) {
      Ra.sl[68]=2261; /* line # 2261 */
      P_src_error(Rd.s+2111,902,4);
    }
    else P_src_error(Rd.s+2111,902,3);
  }
  Ra.sl[68]=2266; /* line # 2266 */
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_endfile_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2182;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=2277; /* line # 2277 */
  Rv0=V_src_control;
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=89;
  else {
    Ra.sl[3]=2282; /* line # 2282 */
    V_sy_ch=P_src_return(1);
    V_sy_sym.ub[0]=104;
    V_sy_ch=32;
    P_set_srcfilespc(-1);
    P_compile_set_title();
  }
  Ra.sl[3]=2289; /* line # 2289 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  if (V_sy_sym.ub[0]==89) V_pas_compile=0;
  else P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2198;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=2322; /* line # 2322 */
  P_insymbol_src();
  Rv0=V_src_control;
  while (V_sy_sym.ub[0]>=90){
    switch (V_sy_sym.ub[0]) {
      case 100:
      case 101:Ra.sl[3]=2328; /* line # 2328 */
      PAS_INSMBOL_include_mstate(V_sy_init_mod);
      break;
      case 102:PAS_INSMBOL_pragma_mstate(V_src_control);
      break;
      case 90:Ra.sl[3]=2334; /* line # 2334 */
      PAS_INSMBOL_define_macro_symbol();
      break;
      case 91:PAS_INSMBOL_undefine_macro_mbol();
      break;
      case 92:Ra.sl[3]=2340; /* line # 2340 */
      PAS_INSMBOL_macro_assign_symbol();
      break;
      case 93:
      case 94:
      case 95:if (PAS_INSMBOL_if_mstate()) {
        Ra.sl[3]=2345; /* line # 2345 */
        P_insymbol_src();
        V_sy_maclevel=V_sy_maclevel+1;
      }
      else {
        Ra.sl[3]=2350; /* line # 2350 */
        Rv1=((C *)Rv0)[46];
        ((C *)Rv0)[46]=83;
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2216);
        ((C *)Rv0)[46]=Rv1;
        if (V_sy_sym.ub[0]==97) {
          Ra.sl[3]=2355; /* line # 2355 */
          P_insymbol_src();
          V_sy_maclevel=V_sy_maclevel+1;
        }
        else P_insymbol_src();
      }
      break;
      case 97:Ra.sl[3]=2363; /* line # 2363 */
      V_sy_maclevel=V_sy_maclevel-1;
      Rv1=((C *)Rv0)[46];
      ((C *)Rv0)[46]=83;
      PAS_INSMBOL_skip_mcsymbol(Rd.s+2232);
      P_insymbol_src();
      ((C *)Rv0)[46]=Rv1;
      break;
      case 98:Ra.sl[3]=2372; /* line # 2372 */
      V_sy_maclevel=V_sy_maclevel-1;
      P_insymbol_src();
      break;
      case 99:Ra.sl[3]=2377; /* line # 2377 */
      if (V_sy_macsymb!=NULL) {
        P_macro_replace(V_sy_macsymb);
        P_insymbol_src();
      }
      else {
        Ra.sl[3]=2383; /* line # 2383 */
        P_src_error_s(Rd.s+2210,995,3, V_sy_ident.s,NULL);
      }
      break;
      case 103:PAS_INSMBOL_endfile_mstate();
      break;
      default:Ra.sl[3]=2392; /* line # 2392 */
      P_src_error(Rd.s+2210,997,3);
      break;
    }
    if (V_sy_maclevel<0) {
      P_src_error(Rd.s+2210,996,2);
      Ra.sl[3]=2397; /* line # 2397 */
      V_sy_maclevel=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2248;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=2407; /* line # 2407 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=89){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 57:Ra.sl[3]=2413; /* line # 2413 */
      if (!F_rec_flg) {
        P_skip_symbol(73,0,0);
        P_insymbol();
      }
      break;
      case 42:Ra.sl[3]=2419; /* line # 2419 */
      P_skip_symbol(73,1,0);
      P_insymbol();
      break;
      case 55:
      case 72:P_skip_symbol(73,0,0);
      P_insymbol();
      break;
      case 14:Ra.sl[3]=2427; /* line # 2427 */
      P_skip_symbol(15,0,0);
      P_insymbol();
      break;
      case 16:P_skip_symbol(17,0,0);
      P_insymbol();
      break;
      case 49:Ra.sl[3]=2435; /* line # 2435 */
      P_skip_symbol(50,0,0);
      P_insymbol();
      break;
      case 73:if (F_tosymbol==47||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_msymbol "  */
void P_skip_msymbol(V F_smb, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2261;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=2448; /* line # 2448 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,105)||V_sy_sym.ub[0]==89)){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 57:Ra.sl[3]=2454; /* line # 2454 */
      if (!F_rec_flg) {
        P_skip_msymbol(Rd.s+2276,0);
        P_insymbol();
      }
      break;
      case 42:Ra.sl[3]=2461; /* line # 2461 */
      P_skip_msymbol(Rd.s+2288,1);
      P_insymbol();
      break;
      case 55:
      case 72:Ra.sl[3]=2466; /* line # 2466 */
      P_skip_msymbol(Rd.s+2300,0);
      P_insymbol();
      break;
      case 14:Ra.sl[3]=2471; /* line # 2471 */
      P_skip_msymbol((V)Rd.s+2312,0);
      P_insymbol();
      break;
      case 16:Ra.sl[3]=2476; /* line # 2476 */
      P_skip_msymbol((V)Rd.s+2316,0);
      P_insymbol();
      break;
      case 49:Ra.sl[3]=2481; /* line # 2481 */
      P_skip_msymbol(Rd.s+2320,0);
      P_insymbol();
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2328;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=2497; /* line # 2497 */
  P_lst_g_init(Rd.s+2339,Rd.s+2341,&Rv0);
  if (Rv0==0) {
    Ra.sl[3]=2502; /* line # 2502 */
    P_err_init(PAS__CON_STR_STR(Ra.s+16,V_cpas_ini_dir.s,Rd.s+2396));
    P_src_init(Rd.s+2410,V_trg_env_fspc.s);
    if (V_cmp_macroexp) {
      Ra.sl[3]=2507; /* line # 2507 */
      P_src_set_flags(2,0);
    }
    if (V_src_control==NULL) {
      V_error_result=4;
      V_emergency_stop=1;
      Ra.sl[3]=2512; /* line # 2512 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2417,-1,-1,32);
      PAS__WRITE_STR(V_trg_env_fspc.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+2467,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2484,-1,-1,32);
      PAS__WRITE_STR(V_trg_sys_name.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=2521; /* line # 2521 */
      PAS_INSMBOL_set_keyword_tree();
      V_proc_seq=0;
      V_srf_free=NULL;
      V_srf_list=NULL;
      Ra.sl[3]=2526; /* line # 2526 */
      V_sy_maclevel=0;
      P_ide_init();
      Ra.sl[3]=2533; /* line # 2533 */
      P_set_srcfilespc(1);
      V_sy_attrflg=0;
      V_sy_ch=32;
      Ra.sl[3]=2540; /* line # 2540 */
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[3]=2545; /* line # 2545 */
    V_error_result=4;
    V_emergency_stop=1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2540,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2339,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2564,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
