/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 3488 ) = {
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  61,  61,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  50,  47, 112,
 99, 109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115, 101,
116,  95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,   9,
  9, 115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,
 97, 114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,  97,
114, 101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,  99,
111, 109, 112,  95, 115,  99,  97, 108,  97, 114,   9,   9,  99, 111, 109, 112,
 95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112, 114, 111,  99,
 95,  97, 114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,
 99, 116, 101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,  49,  21,  21,
116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,  95, 114, 101,
108, 101,  97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,  95, 105, 110,
 95,  97, 114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110, 103,  95, 105,
110,  95, 115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16, 105, 110, 105,
116, 105,  97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,  15,  15, 116,
121, 112, 101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114, 109,   4,   4,
 84,  89,  67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,  95, 115, 101,
116,  95, 118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,  95, 112,  97,
114, 109,  95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,  12, 105, 110,
105, 116,  95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100, 121, 110,  95,
114, 101,  99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,  95, 100, 121,
110,  95, 114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100, 121, 110,  95,
100,   4,   4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,  95, 100,  95,
100, 121, 110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110, 105, 116,  95,
100,  95, 116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10, 105, 110, 105,
116,  95, 100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,  13,  13, 105,
110, 105, 116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,   4,  73,  68,
 83,  84,  12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97, 114,  98, 108,
 11,  11, 101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,   4,   4,  69,
 67,  85,  78,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,  98, 105, 110,
  4,   4,  69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95, 102, 111, 114,
 95, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,  99,  97, 108,
108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,  76,  76,   3,
  3, 119, 114, 116,   0,   0,   0,  33,   0,  17,   9, 102, 111, 114, 109,  95,
 99, 104,  97, 114,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114,
109,  95, 108, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102,
111, 114, 109,  95, 105, 110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 11, 102, 111, 114, 109,  95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,
  0,   0,  11, 102, 111, 114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,
  0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101,
114,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 102, 101, 110, 116,
114, 121,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 105,
108, 101,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
 97, 114, 114,  97, 121,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95,  99, 111, 110, 102,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102,
111, 114, 109,  95, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   0,
  8, 102, 111, 114, 109,  95, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 108, 115, 101, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,
  0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110,
110, 117, 109,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
119, 102, 105, 108, 101,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102,
111, 114, 109,  95, 119, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
 10, 102, 111, 114, 109,  95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,
  0,   0,  12, 102, 111, 114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103,
101,   0,   0,   0,   0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97,
114, 105,  97, 110, 116,   0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95,
111, 114, 103,  97, 110, 105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114,
109,  95,  99, 111, 110, 115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102,
111, 114, 109,  95, 112, 114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,
 12, 102, 111, 114, 109,  95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 117, 118,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 101,
  0,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 110, 117,
108, 108,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95,
115, 116, 114, 105, 110, 103,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 102, 114, 101, 101,   0,   0,   0,   0,   0,   0,   0,   0,   8,   8,
 32,  45,  45,  45,  45,  45,  45,  32,  10,  10, 115, 104, 111, 119,  95, 101,
110, 116, 114, 121,  16,  16,  32,  79, 107,  32, 102, 111, 114,  32,  69, 110,
116, 114, 121,  32,  58,  32,  10,  10,  32,  32,  32,  32,  69, 110, 116, 114,
121,  32,   2,   2,  44,  32,   4,   4,  32,  45,  62,  32,  11,  11,  32,  45,
 62,  32,  99, 111, 100, 101,  32,  61,  32,   0,   0,   0,   0,   0,   0, 127,
  0,  15,   9, 112,  99, 111, 100,  95, 110, 111, 111, 112,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 116, 111, 114, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 114,  97, 110, 103, 101,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 105, 115, 116, 111, 114, 101,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 102, 115, 116, 111, 114, 101,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103, 115, 116, 111, 114, 101,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 110, 111, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  97, 110, 100,   0,   0,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 111, 114,   0,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 120, 111, 114,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 109,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  98,  97, 110, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  98, 120, 111, 114,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 115,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 116,   0,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 115, 101, 116, 103, 101, 110,   0,   0,
  0,   0,  12, 112,  99, 111, 100,  95, 108, 115, 101, 116, 103, 101, 110,   0,
  0,   0,  14, 112,  99, 111, 100,  95, 108, 115, 101, 116,  97, 100, 100, 101,
108,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108, 116,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103, 116,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 101, 113,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 110, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 105, 110, 115, 101, 116,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 101, 113,   0,   0,   0,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 110, 101,   0,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  95, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  95, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 110,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 100, 101,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  97, 115, 104,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 108, 115, 104,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 114, 111, 116,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 117,  99,  99,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 112, 114, 101, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 111, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 111, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 114, 101, 109,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 102,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 105,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 102, 116, 114, 117, 110,  99,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 105,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103, 116, 114, 117, 110,  99,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 102,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 105, 112, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 113, 114, 116,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 115, 105, 110,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 115,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 116,  97, 110,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97, 115, 105, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97,  99, 111, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97, 116,  97, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 112, 104,  97, 115,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 101, 120, 112,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 108, 111, 103,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 105, 110, 104,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 111, 115, 104,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 116,  97, 110, 104,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97, 115, 105, 110, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97,  99, 111, 115, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97, 116,  97, 110, 104,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 105, 112, 119,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 113, 114, 116,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 105, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  99, 111, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 116,  97, 110,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 115, 105, 110,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97,  99, 111, 115,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 116,  97, 110,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 112, 104,  97, 115,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 101, 120, 112,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 108, 111, 103,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 105, 110, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  99, 111, 115, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 116,  97, 110, 104,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 115, 105, 110, 104,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97,  99, 111, 115, 104,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 116,  97, 110, 104,   0,   0,
  0,   0,  14, 112,  99, 111, 100,  95,  95, 103, 101, 110, 115, 116, 114, 108,
 49,   0,  15, 112,  99, 111, 100,  95,  95, 103, 101, 110, 112, 114, 109, 116,
121, 112,   4,   4, 100, 117, 109, 112,  25,  25,  32,  71, 101, 110, 101, 114,
105,  99,  95,  83, 101,  97, 114,  99, 104,  32, 102, 111, 114,  32, 110, 112,
 32,  61,  32,   6,   6,  32, 119, 105, 116, 104,  32,  13,  13,  65, 114, 103,
 95,  49,  32, 102,  95, 116, 121, 112, 101,  32,  15,  15,  44,  32,  65, 114,
103,  95,  50,  32, 102,  95, 116, 121, 112, 101,  32,   7,   7,  78, 111,  32,
 97, 114, 103,  46,  14,  14, 103, 101, 110, 101, 114, 105,  99,  95, 115, 101,
 97, 114,  99, 104,   4,   4,  71,  69,  78,  83,  11,  11, 101, 120, 112,  95,
103, 101, 110, 111, 112, 101, 114,  13,  13, 103, 101, 110, 101, 114,  97, 116,
101,  95,  99,  97, 108, 108,   9,   9, 101, 120, 112,  95, 103, 101, 110, 111,
112,  13,  13, 108, 103, 116,  95, 103, 101, 110,  95, 115, 116, 111, 114, 101
};

/* Define the local static Initialized section. */
static Blk( Ri, 488 ) = {
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   5,   5,
  0,   0,   0,   0,   0,   5,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   5,   0,   0,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   2,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,
  0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   5,
  0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   0,   3,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,
  0,   0,   0,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   5,   5,   0,   5,   0,   0,
  0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   5,
  0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   0,   0,   5,   0,   5,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   5,   5,
  0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   0,
  0,   0,   0,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
  5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
  5,   5,   5,   5,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 136 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern V PAS__f_output;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 120 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000001(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=95; /* line # 95 */
  if (V_sy_sym.ub[0]==5) {
    (*F_nam)=PAS__NEW(32);
    Rv0=(*F_nam);
    Ra.sl[3]=100; /* line # 100 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else((UB *)Rv0)[0]=V_sy_string.ub[1];
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[3]=105; /* line # 105 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=120; /* line # 120 */
  Rv0=F_pr;
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+91,129,1);
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[3]=126; /* line # 126 */
    ((V *)Rv0)[3]=NULL;
    P_src_error(Rd.s+91,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=141; /* line # 141 */
  V_enm_range=0;
  Rv0=F_ty1==F_ty2;
  if (!Rv0) {
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[3]=146; /* line # 146 */
      if (((((UB *)F_ty1)[52]==((UB *)F_ty2)[52]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[6]==((SL *)F_ty2)[6]) switch ((
      (UB *)F_ty1)[52]) {
        case 0:
        case 1:
        case 2:Ra.sl[3]=152; /* line # 152 */
        if ((((UB *)F_ty1)[64]==((UB *)F_ty2)[64]&&((SL *)F_ty1)[17]==((SL *)F_ty2)
        [17])&&((SL *)F_ty1)[18]==((SL *)F_ty2)[18]) Rv0=1;
        break;
        case 3:
        case 4:Rv0=1;
        break;
        case 5:
        case 7:
        case 13:Ra.sl[3]=157; /* line # 157 */
        Rv0=P_same_type(((V *)F_ty1)[14],((V *)F_ty2)[14]);
        break;
        case 11:
        case 12:if (((SL *)F_ty1)[14]==((SL *)F_ty2)[14]) Rv0=P_same_type(((V *)
        F_ty1)[15],((V *)F_ty2)[15]);
        break;
        case 8:
        case 9:Ra.sl[3]=162; /* line # 162 */
        if (((SL *)F_ty1)[14]==((SL *)F_ty2)[14]&&((SL *)F_ty1)[15]==((SL *)F_ty2)
        [15]) {
          if (P_same_type(((V *)F_ty1)[18],((V *)F_ty2)[18])&&P_same_type(((V *)
          F_ty1)[17],((V *)F_ty2)[17])) Rv0=1;
        }
        break;
        case 22:Ra.sl[3]=168; /* line # 168 */
        Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
        break;
        case 6:Rv0=P_compare_entry(((V *)F_ty1)[15],((V *)F_ty2)[15]);
        break;
        default:break;
      }
    }
  }
  Ra.sl[3]=173; /* line # 173 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+106;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=186; /* line # 186 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Rv0=0;
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[3]=192; /* line # 192 */
      if (((V *)F_pr1)[12]!=((V *)F_pr2)[12]) Rv0=P_same_type(((V *)F_pr1)[12],(
      (V *)F_pr2)[12]);
      else Rv0=1;
      if (Rv0) {
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[3]=200; /* line # 200 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Rv0=P_same_type(((V *)Rv1)[4],((V *)Rv2)[4]);
          if (Rv0) {
            Ra.sl[3]=206; /* line # 206 */
            if (((UB *)Rv1)[28]==7) {
              if (((UB *)Rv2)[28]==7) {
                if (((UB *)((V *)Rv1)[9])[56]==3&&((UB *)((V *)Rv2)[9])[56]==3) 
                Rv0=P_compare_entry(((V *)Rv1)[9],((V *)Rv2)[9]);
                else Rv0=0;
              }
              else {
                Ra.sl[3]=211; /* line # 211 */
                Rv0=0;
              }
            }
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[3]=219; /* line # 219 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=233; /* line # 233 */
  Rv0=0;
  if (F_pgc!=NULL&&F_ent!=NULL) while (F_pgc!=NULL&&!Rv0){
    Ra.sl[3]=238; /* line # 238 */
    Rv1=F_pgc;
    if (!((UB *)Rv1)[4]) {
      Rv2=((V *)Rv1)[2];
      Ra.sl[3]=243; /* line # 243 */
      Rv0=P_compare_entry(Rv2, F_ent);
    }
    if (!Rv0) {
      if (F_pgc==F_pgl) F_pgc=NULL;
      else F_pgc=((V *)F_pgc)[0];
    }
  }
  Ra.sl[3]=250; /* line # 250 */
  if (!Rv0) F_pgc=NULL;
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+141;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=270; /* line # 270 */
  Rv0=4;
  if (F_te==F_tf) Rv0=0;
  else {
    if (F_te!=NULL&&F_tf!=NULL) {
      Rv1=F_te;
      if (((UB *)Rv1)[52]==((UB *)F_tf)[52]) {
        Ra.sl[3]=275; /* line # 275 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          if (((UB *)Rv1)[64]) {
            Rv2=(double)((UL *)Rv1)[17];
            Rv3=(double)((UL *)Rv1)[18];
          }
          else {
            Ra.sl[3]=281; /* line # 281 */
            Rv2=(double)((SL *)Rv1)[17];
            Rv3=(double)((SL *)Rv1)[18];
          }
          Rv4=F_tf;
          if (((UB *)Rv4)[64]) {
            Rv5=(double)((UL *)Rv4)[17];
            Rv6=(double)((UL *)Rv4)[18];
          }
          else {
            Ra.sl[3]=286; /* line # 286 */
            Rv5=(double)((SL *)Rv4)[17];
            Rv6=(double)((SL *)Rv4)[18];
          }
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[3]=292; /* line # 292 */
            if (Rv2==Rv5) {
              if (Rv3==Rv6) Rv0=0;
              else Rv0=1;
            }
            else Rv0=2;
          }
          else Rv0=3;
        }
        else {
          Ra.sl[3]=298; /* line # 298 */
          V_enm_range=1;
        }
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  UB Rv4;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+154;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=345; /* line # 345 */
  V_enm_range=0;
  Rv0=F_eff==F_frm;
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[3]=350; /* line # 350 */
    if (!Rv0) {
      Rv1=((V *)F_eff)[0];
      while (1){
        Ra.sl[3]=356; /* line # 356 */
        if (Rv1!=NULL) {
          Rv2=Rv1;
          Rv0=F_frm==Rv1;
          Rv1=((V *)Rv2)[0];
        }
        if (Rv0||Rv1==NULL)  break;
      }
      Ra.sl[3]=364; /* line # 364 */
      if (!Rv0) {
        Rv3=F_frm;
        if (((UB *)Rv3)[52]==22) {
          Ra.sl[3]=369; /* line # 369 */
          Rv0=P_comp_type(((V *)Rv3)[0],F_eff, F_exact);
        }
        if (!Rv0) {
          if (((UB *)F_eff)[52]<=21&&((UB *)Rv3)[52]<=21) {
            Ra.sl[3]=375; /* line # 375 */
            Rv4=Ri.ub[((UB *)F_eff)[52]*22+((UB *)Rv3)[52]];
            Ra.sl[3]=382; /* line # 382 */
            if (!((F_exact&&Rv4==5)&&((UB *)F_eff)[52]!=((UB *)Rv3)[52])) switch (
            Rv4) {
              case 5:Rv0=1;
              break;
              case 1:
              case 2:Ra.sl[3]=387; /* line # 387 */
              switch (((UB *)Rv3)[52]) {
                case 0:
                case 1:
                case 2:if (((UB *)Rv3)[48]) {
                  Ra.sl[3]=392; /* line # 392 */
                  if (!F_exact) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
                  else Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv3)
                  [6]==((SL *)F_eff)[6];
                }
                break;
                case 11:
                case 12:Ra.sl[3]=397; /* line # 397 */
                Rv0=P_comp_type(((V *)F_eff)[15],((V *)Rv3)[15],F_exact);
                break;
                case 8:Rv0=((V *)F_eff)[17]==((V *)Rv3)[17]&&P_comp_type(((V *)F_eff)
                [18],((V *)Rv3)[18],1);
                break;
                case 9:Ra.sl[3]=404; /* line # 404 */
                Rv0=P_comp_type(((V *)F_eff)[17],((V *)Rv3)[17],1)&&P_comp_type((
                (V *)F_eff)[18],((V *)((V *)Rv3)[18])[0],1);
                break;
                case 5:if (((V *)Rv3)[14]==NULL) Rv0=((UB *)F_eff)[52]==5;
                else {
                  Ra.sl[3]=409; /* line # 409 */
                  Rv0=P_comp_type(((V *)F_eff)[14],((V *)Rv3)[14],1);
                }
                break;
                case 6:if (((V *)Rv3)[15]==NULL) Rv0=((UB *)F_eff)[52]==6;
                else Rv0=P_comp_proc_arg(((V *)F_eff)[15],((V *)Rv3)[15]);
                break;
                default:break;
              }
              break;
              case 4:Ra.sl[3]=419; /* line # 419 */
              Rv0=P_comp_type(F_frm, V_typ_std.v[10],0);
              break;
              case 3:if (P_comp_type(F_eff, V_typ_std.v[10],0)) {
                Ra.sl[3]=424; /* line # 424 */
                Rv0=P_comp_type(((V *)((V *)F_eff)[15])[4],F_frm,0);
              }
              break;
              default:break;
            }
          }
        }
      }
    }
  }
  Ra.sl[3]=433; /* line # 433 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+165;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=447; /* line # 447 */
  Rv0=1;
  if (F_epr!=F_fpr) {
    if (F_epr!=NULL&&F_fpr!=NULL) {
      if (((V *)F_epr)[12]!=((V *)F_fpr)[12]) {
        Ra.sl[3]=452; /* line # 452 */
        Rv0=0;
      }
      else {
        Rv1=((V *)F_epr)[8];
        Rv2=((V *)F_fpr)[8];
        Ra.sl[3]=457; /* line # 457 */
        if (((V *)F_epr)[12]!=NULL) {
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          if (((UB *)Rv2)[28]!=((UB *)Rv1)[28]) Rv0=0;
          else {
            Ra.sl[3]=463; /* line # 463 */
            switch (((UB *)Rv2)[28]) {
              case 5:Rv0=P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],((UB *)Rv2)[38]
              !=8);
              break;
              case 7:Ra.sl[3]=468; /* line # 468 */
              if (P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[9],((V *)Rv2)[9]);
              else Rv0=0;
              break;
              default:break;
            }
          }
          Ra.sl[3]=474; /* line # 474 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
      }
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[3]=480; /* line # 480 */
      Rv0=0;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+180;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=499; /* line # 499 */
  if (F_ty!=NULL) {
    Rv0=F_ty;
    Rv1=((V *)Rv0)[4];
    Rv2=((V *)Rv0)[8];
    Ra.sl[3]=504; /* line # 504 */
    while (Rv1!=NULL){
      Rv3=Rv1;
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Rv5=Rv4;
      Ra.sl[3]=510; /* line # 510 */
      ((V *)Rv5)[4]=((V *)Rv3)[4];
      if (((UB *)Rv5)[24]!=14) P_src_error(Rd.s+202,132,3);
      else {
        Rv6=((V *)Rv5)[8];
        ((SL *)Rv6)[5]=((SL *)((V *)Rv3)[4])[6];
        ((V *)Rv6)[7]=((V *)Rv3)[4];
      }
      Ra.sl[3]=515; /* line # 515 */
      ((SL *)Rv5)[2]=((SL *)Rv3)[8];
      ((V *)Rv3)[11]=Rv4;
      ((UB *)Rv3)[36]=1;
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[3]=520; /* line # 520 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      (*F_lghl)=Rv4;
      (*F_count)=(*F_count)+1;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+206;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=539; /* line # 539 */
  Rv0=((V *)F_ty)[4];
  while (Rv0!=NULL){
    Rv1=Rv0;
    ((UB *)Rv1)[36]=0;
    Ra.sl[3]=544; /* line # 544 */
    ((V *)Rv1)[11]=NULL;
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+229;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=562; /* line # 562 */
  if (((V *)F_lgt)[8]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=NULL;
    Rv3=((SL *)Rv1)[6];
    Ra.sl[3]=567; /* line # 567 */
    Rv4=NULL;
    Rv5=NULL;
    Rv6=0;
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[3]=577; /* line # 577 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      while (Rv4!=NULL){
        Rv5=Rv4;
        Rv4=((V *)Rv4)[0];
        Ra.sl[3]=582; /* line # 582 */
        Rv7=Rv5;
        Rv8=NULL;
        P_val_copy(((V *)Rv7)+8,&Rv8,1);
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[3]=587; /* line # 587 */
          ((V *)Rv2)[0]=Rv8;
        }
        Rv2=Rv8;
        P_lgt_free(&Rv5);
      }
      Ra.sl[3]=592; /* line # 592 */
      Rv3=Rv3-((SL *)Rv1)[5];
    }
    if (Rv3<=0) {
      if (((V *)Rv1)[8]!=NULL) {
        Ra.sl[3]=597; /* line # 597 */
        Rv3=((SL *)((V *)((V *)Rv1)[8])[8])[10];
      }
    }
    switch (((UB *)((V *)Rv0)[8])[36]) {
      case 0:Ra.sl[3]=602; /* line # 602 */
      if (Rv3<=0) Rv3=1;
      if (Rv2==NULL) Rv9=((V *)Rv0)[8];
      else((V *)Rv2)[0]=((V *)Rv0)[8];
      Rv2=((V *)Rv0)[8];
      ((V *)Rv0)[8]=NULL;
      Ra.sl[3]=607; /* line # 607 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        ((SL *)Rv8)[10]=32;
        Ra.sl[3]=612; /* line # 612 */
        ((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
      }
      break;
      case 32:Ra.sl[3]=619; /* line # 619 */
      Rv10=((V *)((V *)Rv0)[8])[10];
      if (Rv10==NULL) Rv11=0;
      else Rv11=((UB *)Rv10)[1];
      if (Rv3<=0) {
        if (((V *)Rv1)[10]!=NULL) {
          Ra.sl[3]=625; /* line # 625 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[10],NULL,NULL,0);
          if (Rv12!=NULL) {
            Rv13=Rv12;
            if (((UB *)Rv13)[24]==14) {
              if (((V *)Rv13)[8]!=NULL) Rv3=((SL *)((V *)Rv13)[8])[10];
            }
          }
        }
      }
      Ra.sl[3]=632; /* line # 632 */
      if (Rv3<=0) Rv3=Rv11;
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[3]=637; /* line # 637 */
        if (Rv14<=Rv11) ((SL *)Rv8)[10]=(SL)((C *)Rv10)[Rv14+1];
        else((SL *)Rv8)[10]=32;
        if (Rv2==NULL) Rv9=Rv8;
        else((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[3]=646; /* line # 646 */
    if (((V *)Rv0)[8]!=NULL) P_val_free(((V *)Rv0)+8);
    P_val_new(((V *)Rv0)+8,F_ty);
    Rv15=((V *)Rv0)[8];
    ((V *)Rv15)[10]=Rv9;
    Ra.sl[3]=651; /* line # 651 */
    ((SL *)Rv15)[5]=Rv3;
    ((SL *)Rv15)[1]=Rv6;
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[3]=657; /* line # 657 */
  ((V *)F_lgt)[4]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+246;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=671; /* line # 671 */
  if (((V *)F_lgt)[8]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=((V *)Rv0)[8];
    ((V *)Rv0)[8]=NULL;
    Ra.sl[3]=676; /* line # 676 */
    P_val_copy(&Rv2,((V *)Rv0)+8,1);
    Rv3=((V *)Rv0)[8];
    ((SL *)Rv3)[5]=((SL *)Rv1)[6]-V_stri_stroffset;
    ((V *)Rv3)[7]=F_ty;
  }
  Ra.sl[3]=683; /* line # 683 */
  ((V *)F_lgt)[4]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+267;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=695; /* line # 695 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[6];
  ((UW *)Rv0)[18]=((UW *)Rv0)[18]|8;
  P_lgt_new(&Rv2,((V *)Rv0)[4],14,NULL);
  Ra.sl[3]=700; /* line # 700 */
  Rv3=Rv2;
  ((V *)Rv3)[8]=((V *)Rv0)[10];
  P_val_new(((V *)Rv3)+8,NULL);
  Ra.sl[3]=705; /* line # 705 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  if (((UB *)((V *)Rv0)[4])[52]==7||((UB *)((V *)Rv0)[4])[52]==16) Rv2=P_lgt_new_code(3,
  Rv2);
  else {
    Ra.sl[3]=711; /* line # 711 */
    Rv2=P_exp_genop(28, Rv2);
  }
  switch (((UB *)Rv1)[56]) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:Ra.sl[3]=717; /* line # 717 */
    if (((V *)Rv1)[19]==NULL) ((V *)Rv1)[19]=Rv2;
    else((V *)((V *)Rv1)[18])[0]=Rv2;
    ((V *)Rv1)[18]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+285;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=739; /* line # 739 */
  Rv0=F_lgt;
  switch (((UB *)Rv0)[24]) {
    case 13:Rv1=((V *)Rv0)[7];
    if (((UB *)Rv1)[28]!=2) {
      Ra.sl[3]=745; /* line # 745 */
      P_src_error_s(Rd.s+304,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[3]=751; /* line # 751 */
    Rv2=((V *)Rv0)[1];
    while (Rv2!=NULL){
      P_type_check_parm(Rv2);
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[3]=757; /* line # 757 */
    switch (((UB *)Rv0)[25]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[3]=765; /* line # 765 */
      P_src_error(Rd.s+304,202,3);
      break;
    }
    break;
    case 16:Ra.sl[3]=771; /* line # 771 */
    if (((V *)Rv0)[4]==NULL) P_src_error(Rd.s+304,203,3);
    break;
    default:P_src_error(Rd.s+304,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000000(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+308;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=798; /* line # 798 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    if ((*F_lgr)!=NULL) {
      Ra.sl[3]=804; /* line # 804 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[24]==14) {
        if (((V *)(*F_lgr))[8]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[8])[10];
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+327;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=815; /* line # 815 */
  Rv0=0;
  Rv1=F_lgt;
  Rv2=F_ip;
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[3]=820; /* line # 820 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Rv4=Rv3;
    Rv5=Rv1;
    if (P_comp_type(((V *)Rv5)[4],((V *)Rv4)[4],0)) {
      Ra.sl[3]=827; /* line # 827 */
      P_type_check_parm(Rv1);
      ((UB *)Rv4)[36]=2;
      ((V *)Rv4)[11]=Rv1;
    }
    else {
      Ra.sl[3]=832; /* line # 832 */
      P_src_error_s(Rd.s+344,201,3,((V *)Rv4)[0],NULL);
    }
    Rv1=((V *)Rv1)[0];
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[3]=838; /* line # 838 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+344,998,3);
  if (((UB *)((V *)Rv2)[4])[52]==27) {
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[4])[10],NULL,NULL,0);
    Ra.sl[3]=844; /* line # 844 */
    if (((UB *)Rv1)[24]==14) Rv6=V_comp_typ_ptr;
    else P_src_error(Rd.s+344,222,3);
  }
  else {
    Ra.sl[3]=849; /* line # 849 */
    P_ide_new_typ(((UB *)((V *)Rv2)[4])[52],&Rv6);
    Rv7=Rv6;
    ((UB *)Rv7)[49]=1;
    ((V *)Rv7)[0]=((V *)Rv2)[4];
    Ra.sl[3]=854; /* line # 854 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[4])[4];
    ((SL *)Rv7)[6]=((SL *)((V *)Rv2)[4])[6];
    ((SL *)Rv7)[5]=((SL *)((V *)Rv2)[4])[5];
    memcpy(Rv7+28,((V *)Rv2)[4]+28,1);
    ((V *)Rv7)[11]=((V *)((V *)Rv2)[4])[11];
    Ra.sl[3]=859; /* line # 859 */
    ((UB *)Rv7)[50]=((UB *)((V *)Rv2)[4])[50];
    V_sy_type_gfirst=((V *)Rv2)[10];
    ((V *)Rv7)[8]=F_lgt;
    Ra.sl[3]=864; /* line # 864 */
    PAS_EXPSION_PRC_00000000(((V *)Rv7)+10,((SL *)Rv7)+6,((V *)((V *)Rv2)[4])[10]
    );
    switch (((UB *)Rv7)[52]) {
      case 0:
      case 1:
      case 2:Ra.sl[3]=869; /* line # 869 */
      ((SL *)Rv7)[17]=((SL *)((V *)Rv7)[0])[17];
      ((SL *)Rv7)[18]=((SL *)((V *)Rv7)[0])[18];
      ((UB *)Rv7)[64]=((UB *)((V *)Rv7)[0])[64];
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      break;
      case 22:Ra.sl[3]=877; /* line # 877 */
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[4])[14]);
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+16,&Rv0,((V *)((V *)Rv2)[4])[16]);
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+15,&Rv0,((V *)((V *)Rv2)[4])[15]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[3]=885; /* line # 885 */
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      break;
      case 11:
      case 12:((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 8:Ra.sl[3]=899; /* line # 899 */
      ((SL *)Rv7)[15]=((SL *)((V *)Rv7)[0])[15];
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+16,((SL *)Rv7)+15,((V *)((V *)Rv2)[4])
      [16]);
      ((V *)Rv7)[17]=((V *)((V *)Rv7)[0])[17];
      ((V *)Rv7)[18]=((V *)((V *)Rv7)[0])[18];
      break;
      case 10:Ra.sl[3]=912; /* line # 912 */
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      if (((V *)((V *)Rv7)[0])[16]!=NULL) ((V *)Rv7)[16]=P_lgt_link(((V *)((V *)
      Rv7)[0])[16]);
      else {
        Ra.sl[3]=917; /* line # 917 */
        ((V *)Rv7)[16]=NULL;
      }
      break;
      default:Ra.sl[3]=922; /* line # 922 */
      P_src_error(Rd.s+344,998,3);
      break;
    }
  }
  Ra.sl[3]=928; /* line # 928 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  while (Rv3!=NULL){
    Rv8=Rv3;
    Ra.sl[3]=933; /* line # 933 */
    ((V *)Rv8)[11]=NULL;
    ((UB *)Rv8)[36]=0;
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[3]=939; /* line # 939 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+348;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=973; /* line # 973 */
  Rv0=F_ty;
  if (((V *)Rv0)[18]!=NULL&&((V *)Rv0)[17]!=NULL) {
    Rv1=P_all_new_tmp(V_int_typ, Lx[1].v[5]);
    Ra.sl[3]=980; /* line # 980 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Rv2=P_lgt_new_code(3, Rv1);
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[3]=985; /* line # 985 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    (*F_lgl)=Rv2;
    Rv3=1;
    Ra.sl[3]=990; /* line # 990 */
    if (((V *)Rv0)[16]!=NULL) {
      Rv4=P_lgt_type_eval(((V *)Rv0)[16],NULL,NULL,0);
      if (((UB *)Rv4)[24]!=14&&((UB *)Rv4)[24]!=13) {
        Ra.sl[3]=996; /* line # 996 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[1].v[5]);
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[3]=1002; /* line # 1002 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else((V *)(*F_lgl))[0]=Rv2;
        (*F_lgl)=Rv2;
        Rv3=0;
      }
    }
    else {
      Ra.sl[3]=1008; /* line # 1008 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[15]);
    }
    if (Lx[1].ub[16]) {
      Ra.sl[3]=1013; /* line # 1013 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      ((SL *)Rv2)[2]=((SL *)Rv2)[2]+((SL *)Rv0)[5];
    }
    else P_lgt_new_copy(F_trg, &Rv2);
    Ra.sl[3]=1018; /* line # 1018 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Rv6=Rv2;
    ((UW *)Rv6)[6]=((UW *)Rv6)[6]|4;
    P_lgt_new(&Rv2,((V *)Rv0)[17],1, Rv2);
    Ra.sl[3]=1023; /* line # 1023 */
    Rv7=((V *)Rv0)[17];
    Rv8=Rv2;
    ((V *)Rv8)[7]=F_ty;
    if (((UB *)Rv7)[52]!=10&&((UB *)Rv7)[52]!=23) ((SL *)Rv8)[2]=((SL *)Rv8)[2]+
    ((SL *)Rv7)[5];
    Ra.sl[3]=1028; /* line # 1028 */
    ((UW *)Rv8)[6]=((UW *)Rv8)[6]|4;
    Ra.sl[3]=1037; /* line # 1037 */
    Rv9=((V *)Rv0)[18];
    if (((UB *)Rv9)[52]!=22) {
      if (((UB *)Rv9)[64]) Rv10=(((UL *)Rv9)[18]-((UL *)Rv9)[17])+1;
      else Rv10=(((SL *)Rv9)[18]-((SL *)Rv9)[17])+1;
      Ra.sl[3]=1042; /* line # 1042 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[18],Rv10);
    }
    else Rv11=P_lgt_type_eval(((V *)Rv9)[14],NULL,NULL,0);
    Rv12=Rv11;
    Ra.sl[3]=1047; /* line # 1047 */
    PAS_EXPSION_PRC_00000001(((V *)Rv0)[17],Rv2, &Rv11, &Rv12,0);
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[3]=1058; /* line # 1058 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    ((UB *)Rv5)[25]=5;
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[3]=1063; /* line # 1063 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000004(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+362;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1088; /* line # 1088 */
  Rv0=NULL;
  Rv1=NULL;
  PAS_EXPSION_PRC_00000003(F_ty, Lx[0].v[4],&Rv0, &Rv1);
  if (Rv0!=NULL) {
    Ra.sl[3]=1093; /* line # 1093 */
    if (Rv1!=Rv0) {
      P_lgt_new(&Rv0,NULL,0, Rv0);
      ((UB *)Rv0)[25]=2;
    }
  }
  Ra.sl[3]=1099; /* line # 1099 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+375;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1105; /* line # 1105 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[14];
  while (Rv1!=NULL){
    Ra.sl[3]=1110; /* line # 1110 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[3]=1115; /* line # 1115 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[50]) {
        if (Lx[1].ub[16]) P_lgt_new(&Rv4,((V *)Rv2)[4],2, P_lgt_link(Ra.v[4]));
        else P_lgt_new_copy(Ra.v[4],&Rv4);
        Ra.sl[3]=1120; /* line # 1120 */
        Rv5=Rv4;
        ((V *)Rv5)[5]=Rv1;
        ((SL *)Rv5)[2]=((SL *)Rv5)[2]+((SL *)Rv2)[8];
        Ra.sl[3]=1127; /* line # 1127 */
        if (((UB *)Rv3)[52]!=10&&((UB *)Rv3)[52]!=23) ((SL *)Rv5)[2]=((SL *)Rv5)
        [2]+((SL *)((V *)Rv2)[4])[5];
        PAS_EXPSION_PRC_00000001(((V *)Rv2)[4],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[3]=1132; /* line # 1132 */
      if (Rv1==((V *)Rv3)[15]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[3]=1137; /* line # 1137 */
  if (((V *)Rv0)[16]!=NULL&&((V *)Rv0)[4]!=NULL) {
    P_lgt_new_copy(((V *)Rv0)[16],&Rv6);
    Ra.sl[3]=1142; /* line # 1142 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else((V *)(*F_lgl))[0]=Rv6;
    (*F_lgl)=Rv6;
    Rv7=((V *)((V *)Rv0)[16])[1];
    Ra.sl[3]=1148; /* line # 1148 */
    P_lgt_new_copy(Rv7, &Rv4);
    ((V *)Rv6)[1]=Rv4;
    Rv7=((V *)Rv7)[0];
    Ra.sl[3]=1153; /* line # 1153 */
    Rv6=PAS_EXPSION_PRC_00000004(((V *)Rv7)[4],Rv7);
    ((V *)Rv4)[0]=Rv6;
    Rv7=((V *)Rv7)[0];
    Ra.sl[3]=1158; /* line # 1158 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    ((V *)Rv6)[0]=Rv4;
    Rv7=((V *)Rv7)[0];
    while (Rv7!=NULL){
      Ra.sl[3]=1163; /* line # 1163 */
      Rv6=PAS_EXPSION_PRC_00000004(((V *)Rv7)[4],Rv7);
      ((V *)Rv4)[0]=Rv6;
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000001(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+389;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1192; /* line # 1192 */
  Rv0=F_ty;
  if (((V *)Rv0)[4]!=NULL) {
    Rv1=((V *)Rv0)[4];
    Ra.sl[3]=1197; /* line # 1197 */
    Rv2=((V *)Rv0)[8];
    while (Rv1!=NULL&&Rv2!=NULL){
      Rv3=Rv1;
      Ra.sl[3]=1202; /* line # 1202 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[4],2, P_lgt_link(F_trg));
      else P_lgt_new_copy(F_trg, &Rv4);
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[3]=1208; /* line # 1208 */
      ((V *)Rv5)[4]=((V *)Rv3)[4];
      ((SL *)Rv5)[2]=((SL *)Rv5)[2]+((SL *)Rv3)[8];
      if (((UB *)Rv6)[52]!=10&&((UB *)Rv6)[52]!=23) ((SL *)Rv5)[2]=((SL *)Rv5)[2]
      -((SL *)Rv6)[5];
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[4],0);
      Ra.sl[3]=1213; /* line # 1213 */
      ((V *)Rv3)[11]=((V *)Rv5)[0];
      ((UB *)Rv3)[36]=1;
      P_lgt_new(&Rv4,((V *)Rv3)[4],6, Rv4);
      Ra.sl[3]=1218; /* line # 1218 */
      ((UB *)Rv4)[25]=3;
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else((V *)(*F_lgl))[0]=Rv4;
      Ra.sl[3]=1223; /* line # 1223 */
      (*F_lgl)=Rv4;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[3]=1229; /* line # 1229 */
  if (((UB *)Rv0)[50]) switch (((UB *)Rv0)[52]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
    break;
    case 8:
    case 9:Ra.sl[3]=1235; /* line # 1235 */
    PAS_EXPSION_PRC_00000002(F_ty, F_trg, F_lgh,F_lgl);
    break;
    default:P_src_error(Rd.s+403,131,3);
    break;
  }
  Ra.sl[3]=1241; /* line # 1241 */
  Rv1=((V *)F_ty)[4];
  while (Rv1!=NULL){
    Rv7=Rv1;
    ((V *)Rv7)[11]=NULL;
    Ra.sl[3]=1246; /* line # 1246 */
    ((UB *)Rv7)[36]=0;
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[16]=F_bindir;
  Ra.v[5]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+407;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1254; /* line # 1254 */
  if (((UB *)F_ty)[50]) switch (((UB *)F_ty)[52]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    case 8:
    case 9:Ra.sl[3]=1261; /* line # 1261 */
    PAS_EXPSION_PRC_00000002(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    default:P_src_error(Rd.s+421,131,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000005(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+425;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1294; /* line # 1294 */
  Rv0=F_ty;
  if (((V *)Rv0)[18]!=NULL) {
    Rv1=((V *)Rv0)[18];
    if (((UB *)Rv1)[52]!=22) {
      Ra.sl[3]=1299; /* line # 1299 */
      if (((UB *)Rv1)[64]) Rv2=(((UL *)Rv1)[18]-((UL *)Rv1)[17])+1;
      else Rv2=(((SL *)Rv1)[18]-((SL *)Rv1)[17])+1;
    }
    else {
      Ra.sl[3]=1305; /* line # 1305 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[14],NULL,NULL,0);
      if (((UB *)Rv3)[24]==14) {
        Rv2=((SL *)((V *)Rv3)[8])[10];
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[3]=1311; /* line # 1311 */
        P_src_error(Rd.s+439,142,4);
      }
    }
  }
  else Rv2=0;
  if (((V *)Rv0)[16]!=NULL) {
    Ra.sl[3]=1317; /* line # 1317 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[16],NULL,NULL,0);
    if (((UB *)Rv3)[24]==14) {
      Rv4=((SL *)((V *)Rv3)[8])[10];
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[3]=1323; /* line # 1323 */
      P_src_error(Rd.s+439,142,4);
    }
  }
  else Rv4=((SL *)Rv0)[15];
  if (((V *)Rv0)[17]==NULL) Rv2=0;
  Ra.sl[3]=1329; /* line # 1329 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[17],Rv4);
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[3]=1334; /* line # 1334 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    if (Lx[2].v[0]==NULL) Lx[2].v[0]=Rv7;
    else((V *)Lx[2].v[1])[0]=Rv7;
    Lx[2].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[3]=1339; /* line # 1339 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+443;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1358; /* line # 1358 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[14];
  while (Rv1!=NULL){
    Ra.sl[3]=1363; /* line # 1363 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[3]=1368; /* line # 1368 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[50]) {
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[4],0);
        Rv5=((SL *)Rv4)[5];
      }
      else {
        Ra.sl[3]=1374; /* line # 1374 */
        if (((SL *)Rv3)[6]>0) {
          Rv4=NULL;
          P_val_new(&Rv4, V_typ_std.v[0]);
          Rv6=Rv4;
          Ra.sl[3]=1380; /* line # 1380 */
          Rv5=((SL *)Rv3)[6];
          ((UB *)Rv6)[36]=31;
          ((SL *)Rv6)[5]=((SL *)Rv3)[6];
          ((SL *)Rv6)[10]=0;
        }
        else {
          Ra.sl[3]=1386; /* line # 1386 */
          Rv5=0;
        }
      }
      if (Rv5>0) {
        (*F_iadr)=(*F_iadr)+Rv5;
        if (Lx[2].v[0]==NULL) Lx[2].v[0]=Rv4;
        else {
          Ra.sl[3]=1391; /* line # 1391 */
          ((V *)Lx[2].v[1])[0]=Rv4;
        }
        Lx[2].v[1]=Rv4;
      }
      if (Rv1==((V *)Rv3)[15]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[3]=1399; /* line # 1399 */
  if (((V *)Rv0)[16]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Rv7=((V *)Rv0)[16];
    Rv8=((V *)Rv7)[1];
    Rv9=((V *)Rv8)[0];
    Ra.sl[3]=1404; /* line # 1404 */
    Rv10=((V *)Rv9)[0];
    Rv11=Rv8;
    Rv12=((SL *)Rv11)[2];
    if (((V *)Rv11)[8]!=NULL) {
      Ra.sl[3]=1409; /* line # 1409 */
      Rv13=((V *)Rv11)[8];
      Rv14=(((SL *)Rv13)[5]+Rv12)-1;
      Rv15=((V *)Rv13)[10];
    }
    else {
      Ra.sl[3]=1415; /* line # 1415 */
      Rv15=NULL;
    }
    if (((V *)Rv0)[4]!=NULL) {
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[3]=1420; /* line # 1420 */
      Rv17=Rv16;
      if (((UB *)Rv17)[24]!=14) P_src_error(Rd.s+457,142,3);
      else {
        if (((V *)Rv17)[8]!=NULL) Rv18=((SL *)((V *)Rv17)[8])[10];
        else Rv18=Rv12-1;
      }
      Ra.sl[3]=1425; /* line # 1425 */
      P_lgt_free(&Rv16);
    }
    Rv19=((V *)Rv10)[0];
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[3]=1430; /* line # 1430 */
      Rv19=Rv9;
    }
    else {
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[3]=1437; /* line # 1437 */
        while (Rv18>0&&Rv19!=NULL){
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[3]=1444; /* line # 1444 */
    if (Rv19!=NULL) {
      if (((V *)Rv19)[4]!=NULL) PAS_EXPSION_PRC_00000006(((V *)Rv19)[4],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[3]=Rd.s+461;
  Ra.v[4]=Rd.s+13;
  Ra.sl[5]=1455; /* line # 1455 */
  Rv0=F_ty;
  Rv1=0;
  Ra.v[0]=NULL;
  Ra.v[1]=NULL;
  Ra.sl[5]=1460; /* line # 1460 */
  Rv2=NULL;
  Rv3=NULL;
  Rv4=((SL *)Rv0)[6];
  Rv5=0;
  Ra.sl[5]=1465; /* line # 1465 */
  if (((V *)Rv0)[4]!=NULL) {
    Rv6=((V *)Rv0)[4];
    Rv7=((V *)Rv0)[8];
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[5]=1470; /* line # 1470 */
      Rv8=Rv6;
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[4],0);
      ((SL *)Rv9)[2]=((SL *)Rv8)[8];
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[5]=1475; /* line # 1475 */
        ((V *)Rv3)[0]=Rv9;
      }
      Rv3=Rv9;
      Rv10=((V *)Rv9)[8];
      P_val_new(&Rv10,((V *)Rv8)[4]);
      ((V *)Rv10)[7]=((V *)Rv8)[4];
      Ra.sl[5]=1480; /* line # 1480 */
      ((SL *)Rv10)[5]=((SL *)((V *)Rv8)[4])[6];
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else((V *)Ra.v[1])[0]=Rv10;
      Ra.v[1]=Rv10;
      Ra.sl[5]=1485; /* line # 1485 */
      ((V *)Rv8)[11]=Rv9;
      ((UB *)Rv8)[36]=1;
      Rv7=((V *)Rv7)[0];
      Rv6=((V *)Rv8)[3];
      if (((V *)Rv8)[4]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[4])[6];
      Ra.sl[5]=1490; /* line # 1490 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[5]=1495; /* line # 1495 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[10]!=NULL) {
    Rv7=P_lgt_type_eval(((V *)Rv0)[10],NULL,NULL,0);
    if (((UB *)Rv7)[24]==14) {
      Ra.sl[5]=1500; /* line # 1500 */
      Rv4=((SL *)((V *)Rv7)[8])[10];
      P_lgt_free(&Rv7);
    }
    else P_src_error(Rd.s+478,147,4);
  }
  Ra.sl[5]=1505; /* line # 1505 */
  if (F_szw>Rv4) Rv4=F_szw;
  if (((UB *)Rv0)[50]) switch (((UB *)Rv0)[52]) {
    case 10:
    case 23:Ra.sl[5]=1510; /* line # 1510 */
    PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
    break;
    case 8:
    case 9:PAS_EXPSION_PRC_00000005(F_ty, &Rv1);
    break;
    default:Ra.sl[5]=1516; /* line # 1516 */
    P_src_error(Rd.s+478,131,3);
    break;
  }
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[5]=1523; /* line # 1523 */
    Rv6=((V *)Rv0)[4];
    while (Rv6!=NULL){
      ((UB *)Rv6)[36]=0;
      ((V *)Rv6)[11]=NULL;
      Ra.sl[5]=1528; /* line # 1528 */
      Rv6=((V *)Rv6)[3];
    }
  }
  P_lgt_free_tree(&Rv2);
  Ra.sl[5]=1534; /* line # 1534 */
  if (Rv4>Rv1) {
    Rv10=NULL;
    P_val_new(&Rv10,NULL);
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[5]=1539; /* line # 1539 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.v[1]=Rv10;
    Rv11=Rv10;
    ((UB *)Rv11)[36]=31;
    Ra.sl[5]=1544; /* line # 1544 */
    ((V *)Rv11)[7]=V_typ_std.v[0];
    ((SL *)Rv11)[10]=0;
    ((SL *)Rv11)[5]=Rv4-Rv1;
  }
  Ra.sl[5]=1569; /* line # 1569 */
  Rv10=NULL;
  P_val_new(&Rv10, F_ty);
  Rv12=Rv10;
  ((SL *)Rv12)[1]=((SL *)Rv0)[5];
  Ra.sl[5]=1574; /* line # 1574 */
  ((SL *)Rv12)[5]=Rv4;
  ((V *)Rv12)[10]=Ra.v[0];
  ((SL *)Rv12)[1]=Rv5;
  Ra.sl[5]=1583; /* line # 1583 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+482;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1614; /* line # 1614 */
  Rv0=((V *)F_ip)[4];
  if (!((UB *)Rv0)[49]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[6];
  Ra.sl[3]=1620; /* line # 1620 */
  ((UW *)Rv1)[18]=((UW *)Rv1)[18]|16;
  if ((((UB *)Rv1)[38]==6||((UB *)Rv1)[38]==1)&&((SL *)Rv1)[5]>1) {
    Ra.sl[3]=1625; /* line # 1625 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else Rv4=((V *)Rv2)[4];
    Rv5=NULL;
    Rv6=NULL;
    Rv7=((V *)Rv2)[8];
    Ra.sl[3]=1630; /* line # 1630 */
    Rv8=Rv4;
    while (Rv7!=NULL){
      Ra.sl[3]=1635; /* line # 1635 */
      P_lgt_new(&Rv9,((V *)Rv4)[4],13,NULL);
      Rv10=Rv9;
      Rv11=Rv8;
      ((V *)Rv10)[7]=F_ip;
      ((V *)Rv10)[8]=NULL;
      ((SL *)Rv10)[2]=((SL *)Rv11)[8];
      Ra.sl[3]=1640; /* line # 1640 */
      ((V *)Rv11)[11]=Rv9;
      ((UB *)Rv11)[36]=1;
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[3]=1646; /* line # 1646 */
      Rv7=((V *)Rv7)[0];
      Rv8=((V *)Rv8)[3];
      Rv12=P_lgt_new_code(3, Rv9);
      if (Rv5==NULL) Rv5=Rv12;
      else((V *)Rv6)[0]=Rv12;
      Ra.sl[3]=1651; /* line # 1651 */
      Rv6=Rv12;
    }
    if (((UB *)Rv2)[50]) {
      Ra.sl[3]=1656; /* line # 1656 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      P_lgt_free(&Rv9);
    }
    Ra.sl[3]=1661; /* line # 1661 */
    if (Rv5!=NULL) switch (((UB *)Rv3)[56]) {
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:if (((V *)Rv3)[19]==NULL) ((V *)Rv3)[19]=Rv5;
      else {
        Ra.sl[3]=1666; /* line # 1666 */
        ((V *)((V *)Rv3)[18])[0]=Rv5;
      }
      ((V *)Rv3)[18]=Rv6;
      break;
      default:break;
    }
    Ra.sl[3]=1671; /* line # 1671 */
    while (Rv4!=NULL){
      Rv13=Rv4;
      ((V *)Rv13)[11]=NULL;
      ((UB *)Rv13)[36]=0;
      Ra.sl[3]=1676; /* line # 1676 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[3]=1681; /* line # 1681 */
    if (((V *)Rv1)[10]==NULL) {
      ((UW *)Rv1)[18]=((UW *)Rv1)[18]|8;
      ((V *)Rv1)[10]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1703; /* line # 1703 */
  Rv0=F_p;
  if (((V *)Rv0)[5]!=NULL) F_puna=P_exp_val_una(F_puna,((V *)Rv0)[5]);
  Rv1=F_puna;
  Ra.sl[3]=1708; /* line # 1708 */
  if (((UB *)Rv1)[24]==14) {
    Rv2=((V *)Rv1)[8];
    ((UW *)Rv1)[6]=1;
    switch (((UB *)Rv0)[28]) {
      case 6:Ra.sl[3]=1713; /* line # 1713 */
      ((SL *)Rv2)[10]=(SL)(((SL *)Rv2)[10]<=0);
      break;
      case 43:((SL *)Rv2)[10]=((SL *)Rv2)[10]+1;
      break;
      case 44:((SL *)Rv2)[10]=((SL *)Rv2)[10]-1;
      break;
      case 45:Ra.sl[3]=1719; /* line # 1719 */
      ((SL *)Rv2)[10]=(SL)(((SL *)Rv2)[10]&1);
      break;
      case 10:if (((UB *)Rv2)[36]==11||((UB *)Rv2)[36]==17) {
        if (((SL *)Rv2)[10]>=0) ((SL *)Rv2)[10]=-1-((SL *)Rv2)[10];
        else {
          Ra.sl[3]=1724; /* line # 1724 */
          ((SL *)Rv2)[10]= -(1+((SL *)Rv2)[10]);
        }
      }
      break;
      case 46:((SL *)Rv2)[10]= -((SL *)Rv2)[10];
      break;
      case 61:
      case 77:((G *)Rv2)[5]=-((G *)Rv2)[5];
      break;
      case 47:Ra.sl[3]=1730; /* line # 1730 */
      ((SL *)Rv2)[10]=abs(((SL *)Rv2)[10]);
      break;
      case 62:
      case 78:((G *)Rv2)[5]=fabs(((G *)Rv2)[5]);
      break;
      case 48:((SL *)Rv2)[10]=PAS__I_SQR(((SL *)Rv2)[10]);
      break;
      case 63:
      case 79:Ra.sl[3]=1736; /* line # 1736 */
      ((G *)Rv2)[5]=PAS__G_SQR(((G *)Rv2)[5]);
      break;
      case 64:
      case 80:((G *)Rv2)[5]=(double)((SL *)Rv2)[10];
      break;
      case 65:
      case 81:Ra.sl[3]=1741; /* line # 1741 */
      ((SL *)Rv2)[10]=PAS__G_ROUND(((G *)Rv2)[5]);
      break;
      case 66:
      case 82:((SL *)Rv2)[10]=(int)(((G *)Rv2)[5]);
      break;
      case 92:
      case 110:Ra.sl[3]=1746; /* line # 1746 */
      if (((G *)Rv2)[5]<0.000000000000000E-001) P_src_error(Rd.s+511,801,2);
      else((G *)Rv2)[5]=sqrt(((G *)Rv2)[5]);
      break;
      case 93:
      case 111:((G *)Rv2)[5]=sin(((G *)Rv2)[5]);
      break;
      case 94:
      case 112:Ra.sl[3]=1752; /* line # 1752 */
      ((G *)Rv2)[5]=cos(((G *)Rv2)[5]);
      break;
      case 95:
      case 113:((G *)Rv2)[5]=tan(((G *)Rv2)[5]);
      break;
      case 96:
      case 114:Ra.sl[3]=1758; /* line # 1758 */
      if (fabs(((G *)Rv2)[5])>1.000000000000000E+000) P_src_error(Rd.s+511,802,2);
      else((G *)Rv2)[5]=asin(((G *)Rv2)[5]);
      break;
      case 97:
      case 115:if (fabs(((G *)Rv2)[5])>1.000000000000000E+000) P_src_error(Rd.s+
511,803,2);
      else {
        Ra.sl[3]=1763; /* line # 1763 */
        ((G *)Rv2)[5]=acos(((G *)Rv2)[5]);
      }
      break;
      case 98:
      case 116:((G *)Rv2)[5]=atan(((G *)Rv2)[5]);
      break;
      case 102:
      case 120:Ra.sl[3]=1768; /* line # 1768 */
      ((G *)Rv2)[5]=PAS__SHG(((G *)Rv2)[5]);
      break;
      case 103:
      case 121:((G *)Rv2)[5]=PAS__CHG(((G *)Rv2)[5]);
      break;
      case 104:
      case 122:((G *)Rv2)[5]=PAS__THG(((G *)Rv2)[5]);
      break;
      case 105:
      case 123:Ra.sl[3]=1775; /* line # 1775 */
      ((G *)Rv2)[5]=PAS__ASHG(((G *)Rv2)[5]);
      break;
      case 106:
      case 124:if (((G *)Rv2)[5]<1.000000000000000E+000) P_src_error(Rd.s+511,805,2);
      else((G *)Rv2)[5]=PAS__ACHG(((G *)Rv2)[5]);
      break;
      case 107:
      case 125:Ra.sl[3]=1782; /* line # 1782 */
      if (fabs(((G *)Rv2)[5])>1.000000000000000E+000) P_src_error(Rd.s+511,806,2);
      else((G *)Rv2)[5]=PAS__ATHG(((G *)Rv2)[5]);
      break;
      case 100:
      case 118:((G *)Rv2)[5]=exp(((G *)Rv2)[5]);
      break;
      case 101:
      case 119:Ra.sl[3]=1789; /* line # 1789 */
      if (((G *)Rv2)[5]<=0.000000000000000E-001) P_src_error(Rd.s+511,804,2);
      else((G *)Rv2)[5]=log(((G *)Rv2)[5]);
      break;
      default:break;
    }
    Ra.sl[3]=1794; /* line # 1794 */
    ((V *)Rv1)[5]=NULL;
    if (((V *)Rv0)[2]==V_typ_std.v[29]||((V *)Rv0)[2]==V_typ_std.v[28]) ((V *)Rv1)
    [4]=((V *)F_puna)[4];
    else((V *)Rv1)[4]=((V *)Rv0)[2];
    Ra.sl[3]=1799; /* line # 1799 */
    ((V *)Rv2)[7]=((V *)Rv1)[4];
    ((UB *)Rv2)[36]=((UB *)((V *)Rv1)[4])[52];
  }
  else {
    Ra.sl[3]=1804; /* line # 1804 */
    if (!(1&((UW *)F_puna)[6])) P_src_error(Rd.s+511,851,2);
    if (((UB *)Rv0)[28]!=0||((SL *)((V *)F_puna)[4])[6]!=((SL *)((V *)Rv0)[2])[6]
    ) {
      P_lgt_new(&Rv3,((V *)Rv0)[2],6, F_puna);
      Ra.sl[3]=1809; /* line # 1809 */
      Rv4=Rv3;
      if (((V *)Rv4)[4]==V_typ_std.v[29]||((V *)Rv4)[4]==V_typ_std.v[28]) ((V *)
      Rv4)[4]=((V *)F_puna)[4];
      Ra.sl[3]=1814; /* line # 1814 */
      ((V *)Rv4)[0]=((V *)F_puna)[0];
      ((UB *)Rv4)[25]=((UB *)Rv0)[28];
      ((UW *)Rv4)[6]=((UW *)F_puna)[6]&~2;
      ((V *)Rv1)[0]=NULL;
      Ra.sl[3]=1819; /* line # 1819 */
      F_puna=Rv3;
    }
    else((V *)F_puna)[4]=((V *)Rv0)[2];
  }
  Ra.sl[3]=1824; /* line # 1824 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  G Rv5;
  register V Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  UL Rv10;
  register V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+515;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=1845; /* line # 1845 */
  Rv0=((V *)F_ob1)[0];
  Rv1=F_p;
  if (((V *)Rv1)[5]!=NULL) F_ob1=P_exp_val_una(F_ob1,((V *)Rv1)[5]);
  Ra.sl[3]=1850; /* line # 1850 */
  if (((V *)Rv1)[6]!=NULL) Rv0=P_exp_val_una(Rv0,((V *)Rv1)[6]);
  ((V *)F_ob1)[0]=Rv0;
  if (((UB *)F_ob1)[24]==14&&((UB *)Rv0)[24]==14) {
    Ra.sl[3]=1855; /* line # 1855 */
    Rv2=((V *)F_ob1)[8];
    Rv3=Rv0;
    switch (((UB *)Rv1)[28]) {
      case 89:((SL *)Rv2)[10]=PAS__IIPOWER(((SL *)Rv2)[10],((SL *)((V *)Rv3)[8])
      [10]);
      break;
      case 90:
      case 108:((G *)Rv2)[5]=pow  (((G *)Rv2)[5],((G *)((V *)Rv3)[8])[5]);
      break;
      case 91:
      case 109:Ra.sl[3]=1861; /* line # 1861 */
      ((G *)Rv2)[5]=PAS__IGPOWER(((G *)Rv2)[5],((SL *)((V *)Rv3)[8])[10]);
      break;
      case 49:((SL *)Rv2)[10]=((SL *)Rv2)[10]+((SL *)((V *)Rv3)[8])[10];
      break;
      case 50:((SL *)Rv2)[10]=((SL *)Rv2)[10]-((SL *)((V *)Rv3)[8])[10];
      break;
      case 51:((SL *)Rv2)[10]=((SL *)Rv2)[10]*((SL *)((V *)Rv3)[8])[10];
      break;
      case 52:Ra.sl[3]=1866; /* line # 1866 */
      ((SL *)Rv2)[10]=((SL *)Rv2)[10]/((SL *)((V *)Rv3)[8])[10];
      break;
      case 53:((SL *)Rv2)[10]=PAS__I_MOD(((SL *)Rv2)[10],((SL *)((V *)Rv3)[8])[10]
      );
      break;
      case 54:((SL *)Rv2)[10]=((SL *)Rv2)[10]%((SL *)((V *)Rv3)[8])[10];
      break;
      case 67:
      case 85:Ra.sl[3]=1871; /* line # 1871 */
      ((G *)Rv2)[5]=((G *)Rv2)[5]+((G *)((V *)Rv3)[8])[5];
      break;
      case 68:
      case 86:((G *)Rv2)[5]=((G *)Rv2)[5]-((G *)((V *)Rv3)[8])[5];
      break;
      case 69:
      case 87:((G *)Rv2)[5]=((G *)Rv2)[5]*((G *)((V *)Rv3)[8])[5];
      break;
      case 70:
      case 88:Ra.sl[3]=1877; /* line # 1877 */
      ((G *)Rv2)[5]=((G *)Rv2)[5]/((G *)((V *)Rv3)[8])[5];
      break;
      case 7:((SL *)Rv2)[10]=(SL)(((SL *)Rv2)[10]>0&&((SL *)((V *)Rv3)[8])[10]>0)
      ;
      break;
      case 8:((SL *)Rv2)[10]=(SL)(((SL *)Rv2)[10]>0||((SL *)((V *)Rv3)[8])[10]>0)
      ;
      break;
      case 9:((SL *)Rv2)[10]=(SL)(((SL *)Rv2)[10]>0!=((SL *)((V *)Rv3)[8])[10]>0)
      ;
      break;
      case 11:Ra.sl[3]=1884; /* line # 1884 */
      ((UL *)Rv2)[10]=((UL *)Rv2)[10]&((UL *)((V *)Rv3)[8])[10];
      break;
      case 12:((UL *)Rv2)[10]=(((UL *)Rv2)[10]|((UL *)((V *)Rv3)[8])[10])&~(((UL
       *)Rv2)[10]&((UL *)((V *)Rv3)[8])[10]);
      break;
      case 13:((UL *)Rv2)[10]=((UL *)Rv2)[10]&~((UL *)((V *)Rv3)[8])[10];
      break;
      case 14:((UL *)Rv2)[10]=((UL *)Rv2)[10]|((UL *)((V *)Rv3)[8])[10];
      break;
      case 15:Ra.sl[3]=1889; /* line # 1889 */
      ((SL *)Rv2)[10]=(SL)((((UL *)Rv2)[10]&((UL *)((V *)Rv3)[8])[10])!=0);
      break;
      case 16:break;
      case 17:break;
      case 18:break;
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:Ra.sl[3]=1898; /* line # 1898 */
      switch (((UB *)Rv1)[28]) {
        case 19:
        case 20:Rv4=(SL)PAS__SET_LE(((UL *)Rv2)[10],((UL *)((V *)Rv3)[8])[10]);
        break;
        case 21:
        case 22:Rv4=(SL)PAS__SET_LE(((UL *)((V *)Rv3)[8])[10],((UL *)Rv2)[10]);
        break;
        case 23:Ra.sl[3]=1903; /* line # 1903 */
        Rv4=(SL)(((UL *)Rv2)[10]!=((UL *)((V *)Rv3)[8])[10]);
        break;
        case 24:Rv4=(SL)(((UL *)Rv2)[10]==((UL *)((V *)Rv3)[8])[10]);
        break;
        default:break;
      }
      ((UB *)Rv2)[36]=1;
      Ra.sl[3]=1908; /* line # 1908 */
      ((SL *)Rv2)[5]=0;
      ((SL *)Rv2)[10]=Rv4;
      break;
      case 25:Rv4=(SL)((1<<((SL *)Rv2)[10]&((UL *)((V *)Rv3)[8])[10])!=0);
      break;
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:Ra.sl[3]=1917; /* line # 1917 */
      Rv4=((SL *)Rv2)[10]-((SL *)((V *)Rv3)[8])[10];
      switch (((UB *)Rv1)[28]) {
        case 28:
        case 32:((SL *)Rv2)[10]=(SL)(Rv4<0);
        break;
        case 29:
        case 33:((SL *)Rv2)[10]=(SL)(Rv4<=0);
        break;
        case 30:
        case 34:((SL *)Rv2)[10]=(SL)(Rv4>=0);
        break;
        case 31:
        case 35:Ra.sl[3]=1922; /* line # 1922 */
        ((SL *)Rv2)[10]=(SL)(Rv4>0);
        break;
        case 27:((SL *)Rv2)[10]=(SL)(Rv4!=0);
        break;
        case 26:((SL *)Rv2)[10]=(SL)(Rv4==0);
        break;
      }
      break;
      case 55:
      case 56:
      case 57:
      case 58:
      case 59:
      case 60:
      case 71:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:Ra.sl[3]=1930; /* line # 1930 */
      Rv5=((G *)Rv2)[5]-((G *)((V *)Rv3)[8])[5];
      switch (((UB *)Rv1)[28]) {
        case 55:
        case 71:((SL *)Rv2)[10]=(SL)(Rv5<0.000000000000000E-001);
        break;
        case 56:
        case 72:((SL *)Rv2)[10]=(SL)(Rv5<=0.000000000000000E-001);
        break;
        case 57:
        case 73:((SL *)Rv2)[10]=(SL)(Rv5>=0.000000000000000E-001);
        break;
        case 58:
        case 74:Ra.sl[3]=1935; /* line # 1935 */
        ((SL *)Rv2)[10]=(SL)(Rv5>0.000000000000000E-001);
        break;
        case 60:
        case 76:((SL *)Rv2)[10]=(SL)(Rv5!=0.000000000000000E-001);
        break;
        case 59:
        case 75:((SL *)Rv2)[10]=(SL)(Rv5==0.000000000000000E-001);
        break;
      }
      break;
      case 36:
      case 37:break;
      case 99:
      case 117:Ra.sl[3]=1947; /* line # 1947 */
      ((G *)Rv2)[5]=atan2(((G *)Rv2)[5],((G *)((V *)Rv3)[8])[5]);
      break;
      default:break;
    }
    Rv6=F_ob1;
    Rv7=((V *)Rv6)[8];
    Ra.sl[3]=1953; /* line # 1953 */
    ((V *)Rv6)[5]=NULL;
    if (((V *)Rv1)[2]==V_typ_std.v[29]||((V *)Rv1)[2]==V_typ_std.v[28]) ((V *)Rv6)
    [4]=((V *)F_ob1)[4];
    else((V *)Rv6)[4]=((V *)Rv1)[2];
    Ra.sl[3]=1958; /* line # 1958 */
    ((V *)Rv7)[7]=((V *)Rv6)[4];
    ((UB *)Rv7)[36]=((UB *)((V *)Rv6)[4])[52];
    ((V *)F_ob1)[0]=NULL;
    P_lgt_free(&Rv0);
  }
  else {
    Ra.sl[3]=1966; /* line # 1966 */
    Rv8=1;
    switch (((UB *)Rv1)[28]) {
      case 25:if (((UB *)F_ob1)[24]==14) {
        Ra.sl[3]=1971; /* line # 1971 */
        Rv9=F_ob1;
        Rv10=((SL *)((V *)Rv9)[8])[10];
        ((V *)Rv9)[4]=((V *)Rv0)[4];
        P_val_free(((V *)Rv9)+8);
        Ra.sl[3]=1976; /* line # 1976 */
        P_val_new(((V *)Rv9)+8,((V *)Rv9)[4]);
        Rv11=((V *)Rv9)[8];
        ((SL *)Rv11)[5]=(Rv10+7)/8;
        ((UL *)Rv11)[10]=1<<Rv10;
        Ra.sl[3]=1983; /* line # 1983 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Rv12=Rv0;
        ((UW *)Rv12)[6]=1;
        ((UB *)Rv12)[25]=15;
        Ra.sl[3]=1989; /* line # 1989 */
        Rv8=0;
      }
      break;
      case 7:if (((UB *)F_ob1)[24]==14) {
        Ra.sl[3]=1994; /* line # 1994 */
        Rv13=F_ob1;
        ((V *)F_ob1)[0]=NULL;
        Rv8=0;
        if (((SL *)((V *)Rv13)[8])[10]<=0) {
          Ra.sl[3]=2000; /* line # 2000 */
          P_lgt_free_tree(&Rv0);
          Rv0=F_ob1;
        }
        else P_lgt_free(&F_ob1);
      }
      else {
        Ra.sl[3]=2007; /* line # 2007 */
        if (((UB *)Rv0)[24]==14) {
          Rv14=Rv0;
          ((V *)F_ob1)[0]=NULL;
          Rv8=0;
          Ra.sl[3]=2012; /* line # 2012 */
          if (((SL *)((V *)Rv14)[8])[10]<=0) P_lgt_free_tree(&F_ob1);
          else {
            P_lgt_free(&Rv0);
            Ra.sl[3]=2017; /* line # 2017 */
            Rv0=F_ob1;
          }
        }
      }
      break;
      case 8:Ra.sl[3]=2022; /* line # 2022 */
      if (((UB *)F_ob1)[24]==14) {
        Rv15=F_ob1;
        ((V *)F_ob1)[0]=NULL;
        Rv8=0;
        Ra.sl[3]=2027; /* line # 2027 */
        if (((SL *)((V *)Rv15)[8])[10]>0) {
          P_lgt_free_tree(&Rv0);
          Rv0=F_ob1;
        }
        else {
          Ra.sl[3]=2033; /* line # 2033 */
          P_lgt_free(&F_ob1);
        }
      }
      else {
        if (((UB *)Rv0)[24]==14) {
          Rv16=Rv0;
          Ra.sl[3]=2039; /* line # 2039 */
          ((V *)F_ob1)[0]=NULL;
          Rv8=0;
          if (((SL *)((V *)Rv16)[8])[10]>0) P_lgt_free_tree(&F_ob1);
          else {
            Ra.sl[3]=2045; /* line # 2045 */
            P_lgt_free(&Rv0);
            Rv0=F_ob1;
          }
        }
      }
      break;
      case 1:
      case 3:
      case 4:
      case 5:Ra.sl[3]=2052; /* line # 2052 */
      Rv17=F_ob1;
      ((UW *)Rv17)[6]=((UW *)Rv17)[6]|8;
      if (!(2&((UW *)Rv17)[6])) P_src_error(Rd.s+530,852,2);
      Ra.sl[3]=2057; /* line # 2057 */
      Rv18=Rv0;
      if (!(1&((UW *)Rv18)[6])) P_src_error(Rd.s+530,851,1);
      if ((((UB *)Rv1)[28]!=1&&((UB *)Rv18)[24]==8)&&((V *)Rv18)[4]!=NULL) {
        Ra.sl[3]=2064; /* line # 2064 */
        Rv19=((V *)Rv18)[7];
        if (((V *)Rv19)[8]!=NULL) {
          if (((UB *)((V *)Rv19)[8])[38]==6) {
            ((V *)F_ob1)[0]=((V *)((V *)Rv18)[1])[0];
            Ra.sl[3]=2069; /* line # 2069 */
            P_lgt_free(((V *)Rv18)+1);
            ((UW *)Rv18)[6]=((UW *)Rv18)[6]|128;
            ((V *)Rv18)[1]=F_ob1;
            Rv8=0;
          }
        }
      }
      break;
      default:Ra.sl[3]=2077; /* line # 2077 */
      if (!(1&((UW *)F_ob1)[6]&&1&((UW *)Rv0)[6])) P_src_error(Rd.s+530,851,1);
      break;
    }
    if (Rv8) {
      Ra.sl[3]=2082; /* line # 2082 */
      P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
      Rv20=Rv0;
      if (((V *)Rv20)[4]==V_typ_std.v[29]||((V *)Rv20)[4]==V_typ_std.v[28]) ((V *)
      Rv20)[4]=((V *)F_ob1)[4];
      Ra.sl[3]=2087; /* line # 2087 */
      ((UW *)Rv20)[6]=1;
      ((UB *)Rv20)[25]=((UB *)Rv1)[28];
    }
    F_ob1=Rv0;
  }
  Ra.sl[3]=2094; /* line # 2094 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+534;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2109; /* line # 2109 */
  Rv0=F_lgt;
  while (Rv0!=NULL&&((V *)Rv0)[4]!=NULL){
    Rv1=Rv0;
    Rv2=((V *)Rv1)[4];
    if (((SL *)Rv2)[5]>0)  break;
    Ra.sl[3]=2114; /* line # 2114 */
    if (((((UB *)Rv1)[24]==3||((UB *)Rv1)[24]==1)||((UB *)Rv1)[24]==5)||((UB *)Rv1)
    [24]==16) Rv0=((V *)Rv1)[1];
    else Rv0=NULL;
  }
  Ra.sl[3]=2120; /* line # 2120 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[3]=2126; /* line # 2126 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+555;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2147; /* line # 2147 */
  Rv0=0;
  Rv1=NULL;
  if ((*F_lgt)!=NULL) {
    Rv2=(*F_lgt);
    Ra.sl[3]=2152; /* line # 2152 */
    if (((V *)Rv2)[7]!=NULL) Rv1=((V *)Rv2)[7];
    Rv3=((V *)Rv2)[1];
    if (((UB *)Rv2)[24]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[3]=2157; /* line # 2157 */
  if (Rv1!=NULL) {
    Rv4=Rv1;
    Rv5=NULL;
    Rv6=NULL;
    Ra.sl[3]=2162; /* line # 2162 */
    Rv7=((V *)Rv4)[8];
    if (((V *)Rv4)[12]!=NULL) {
      Rv8=((V *)Rv4)[12];
      if (!((UB *)Rv8)[51]) {
        Ra.sl[3]=2173; /* line # 2173 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        ((V *)Rv5)[4]=((V *)Rv4)[12];
        ((V *)Rv5)[5]=((V *)Rv4)[5];
        ((V *)(*F_lgt))[1]=Rv5;
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[3]=2180; /* line # 2180 */
    while (Rv7!=NULL){
      Rv9=NULL;
      Rv10=0;
      Rv11=0;
      Ra.sl[3]=2185; /* line # 2185 */
      Rv12=Rv3;
      Rv13=Rv7;
      if (Rv3!=NULL) {
        Ra.sl[3]=2190; /* line # 2190 */
        if (((UB *)Rv3)[24]==17) Rv0=1;
        else {
          if (((V *)Rv13)[4]!=NULL) {
            Ra.sl[3]=2195; /* line # 2195 */
            Rv14=((V *)Rv13)[4];
            switch (((UB *)Rv14)[52]) {
              case 10:if (P_comp_type(((V *)Rv13)[4],V_typ_std.v[10],0)&&P_comp_type((
              (V *)Rv3)[4],V_typ_std.v[0],1)) {
                Ra.sl[3]=2200; /* line # 2200 */
                if (((UB *)Rv3)[24]==14) {
                  Rv15=(C)((SL *)((V *)Rv3)[8])[10];
                  P_val_free(((V *)Rv3)+8);
                  P_val_new(((V *)Rv3)+8,V_typ_std.v[10]);
                  Ra.sl[3]=2205; /* line # 2205 */
                  ((V *)Rv3)[4]=V_typ_std.v[10];
                  Rv16=((V *)Rv3)[8];
                  ((UB *)Rv16)[36]=32;
                  ((SL *)Rv16)[5]=1;
                  Ra.sl[3]=2210; /* line # 2210 */
                  ((V *)Rv16)[10]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[10])[0]=1;
                  PAS__CHA_TO_STR(((V *)Rv16)[10],Rv15);
                }
                else {
                  Ra.sl[3]=2216; /* line # 2216 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  ((V *)Rv3)[0]=Rv17;
                  ((UW *)Rv3)[6]=5;
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[3]=2221; /* line # 2221 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[3]=2227; /* line # 2227 */
              if (P_comp_type(((V *)Rv3)[4],V_typ_std.v[10],0)) {
                Rv10=1;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[3]=2232; /* line # 2232 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[15])[4],3, Rv3);
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
                ((SL *)Rv3)[2]=((SL *)((V *)V_typ_std.v[10])[15])[8];
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[3]=2239; /* line # 2239 */
                if (P_comp_type(((V *)Rv3)[4],V_typ_std.v[0],0)) {
                  Rv10=1;
                  Rv11=1;
                }
              }
              if (((UB *)Rv14)[52]==9) Rv9=((V *)Rv13)[4];
              break;
              case 13:
              case 14:
              case 15:
              case 17:
              case 18:
              case 19:
              case 20:
              case 21:
              case 29:Ra.sl[3]=2248; /* line # 2248 */
              if (Rv6==NULL) Rv6=((V *)Rv3)[4];
              else {
                if (((UB *)Rv6)[51]&&!((UB *)((V *)Rv3)[4])[51]||((SL *)Rv6)[6]<
                ((SL *)((V *)Rv3)[4])[6]) Rv6=((V *)Rv3)[4];
              }
              break;
              default:break;
            }
            Ra.sl[3]=2258; /* line # 2258 */
            switch (((UB *)Rv13)[38]) {
              case 7:if (!(4&((UW *)Rv3)[6])) {
                Ra.sl[3]=2263; /* line # 2263 */
                Rv18=Rv3;
                if (64&((UW *)Rv13)[18]) ((UW *)Rv18)[6]=((UW *)Rv18)[6]|8;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                P_lgt_new(&Rv3,((V *)Rv3)[4],5, Rv3);
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[3]=2269; /* line # 2269 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
              }
              break;
              case 10:Ra.sl[3]=2276; /* line # 2276 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              P_lgt_new(&Rv3,((V *)Rv3)[4],5, Rv3);
              ((UW *)Rv3)[6]=((UW *)Rv3)[6]|4;
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[3]=2281; /* line # 2281 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else((V *)Rv5)[0]=Rv3;
              break;
              default:break;
            }
            Ra.sl[3]=2287; /* line # 2287 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[3]=2293; /* line # 2293 */
        P_lgt_new(&Rv3,((V *)Rv13)[4],14,NULL);
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else((V *)Rv5)[0]=Rv3;
        Rv0=1;
      }
      Ra.sl[3]=2300; /* line # 2300 */
      if (Rv0) {
        if (8192&((UW *)Rv13)[18]) {
          Rv19=Rv3;
          ((UB *)Rv19)[24]=17;
          Ra.sl[3]=2305; /* line # 2305 */
          ((V *)Rv19)[4]=((V *)Rv13)[4];
          ((V *)Rv19)[5]=NULL;
        }
        else {
          if (((V *)Rv13)[10]!=NULL) {
            Ra.sl[3]=2310; /* line # 2310 */
            Rv20=Rv3;
            ((UB *)Rv20)[24]=14;
            ((V *)Rv20)[4]=((V *)Rv13)[4];
            ((V *)Rv20)[8]=((V *)Rv13)[10];
            Ra.sl[3]=2315; /* line # 2315 */
            P_val_new(((V *)Rv20)+8,((V *)Rv13)[4]);
            ((V *)Rv20)[5]=NULL;
          }
          else P_src_error_s(Rd.s+571,854,2,((V *)Rv13)[0],NULL);
        }
      }
      Ra.sl[3]=2320; /* line # 2320 */
      Rv5=Rv3;
      if (Rv9!=NULL) {
        if (((V *)Rv9)[18]!=NULL) {
          Ra.sl[3]=2325; /* line # 2325 */
          Rv21=((V *)Rv9)[18];
          if (((V *)Rv21)[15]!=NULL&&((V *)Rv21)[16]!=NULL) {
            Rv22=Rv12;
            if (((UB *)Rv22)[24]==8) ((UW *)Rv22)[6]=((UW *)Rv22)[6]|2048;
            Ra.sl[3]=2331; /* line # 2331 */
            Rv23=((V *)Rv9)[18];
            Rv24=NULL;
            Rv25=NULL;
            if (Rv10) {
              while (1){
                Ra.sl[3]=2338; /* line # 2338 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[52]!=22)  break;
              }
              if (Rv11) {
                Ra.sl[3]=2343; /* line # 2343 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Rv7=((V *)Rv7)[3];
                if (((UB *)((V *)Rv21)[15])[24]!=14) {
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[3]=2348; /* line # 2348 */
                  Rv7=((V *)Rv7)[3];
                }
                else Rv25=Rv24;
              }
              else {
                Ra.sl[3]=2354; /* line # 2354 */
                if (((UB *)((V *)Rv21)[15])[24]!=14) {
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Rv25=Rv24;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[3]=2360; /* line # 2360 */
                if (((UB *)Rv12)[24]==14) Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)
                Rv12)[8])[5]);
                else {
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[4],3, P_lgt_link(
                  Rv12));
                  Ra.sl[3]=2366; /* line # 2366 */
                  if (!(64&((UW *)Rv7)[18])) ((SL *)Rv17)[2]=((SL *)((V *)V_typ_std
                  .v[10])[14])[8];
                  if (((V *)Rv17)[4]!=Rv23) {
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[3]=2371; /* line # 2371 */
                    ((V *)Rv17)[4]=Rv23;
                  }
                }
                Rv7=((V *)Rv7)[3];
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[3]=2376; /* line # 2376 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[3]=2382; /* line # 2382 */
              Rv26=((V *)Rv3)[4];
              if (Rv26!=NULL) while (Rv9!=NULL&&Rv26!=NULL)
              if (((UB *)Rv9)[52]==9&&(((UB *)Rv26)[52]==9||((UB *)Rv26)[52]==8)
              ) {
                Ra.sl[3]=2389; /* line # 2389 */
                Rv27=((V *)Rv26)[18];
                Rv23=((V *)Rv9)[18];
                while (1){
                  if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                  if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[52]!=22)  break;
                }
                Ra.sl[3]=2396; /* line # 2396 */
                if (((UB *)Rv27)[52]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                else Rv28=Rv12;
                Ra.sl[3]=2401; /* line # 2401 */
                if (((UB *)((V *)Rv21)[15])[24]!=14) {
                  if (((UB *)Rv27)[52]==22) {
                    Rv17=P_lgt_type_eval(((V *)Rv27)[15],Rv28,NULL,0);
                    Ra.sl[3]=2406; /* line # 2406 */
                    if (((SL *)Rv27)[6]!=((SL *)Rv23)[6]) {
                      Rv17=P_lgt_new_code(0, Rv17);
                      ((V *)Rv17)[4]=Rv23;
                    }
                  }
                  else {
                    Ra.sl[3]=2412; /* line # 2412 */
                    Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[17]);
                  }
                  if (Rv25==NULL) Rv24=Rv17;
                  else((V *)Rv25)[0]=Rv17;
                  Rv25=Rv17;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[3]=2419; /* line # 2419 */
                if (((UB *)Rv27)[52]==22) {
                  Rv17=P_lgt_type_eval(((V *)Rv27)[16],Rv28,NULL,0);
                  if (Rv27!=Rv23) {
                    Ra.sl[3]=2424; /* line # 2424 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    ((V *)Rv17)[4]=Rv23;
                  }
                }
                else Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[18]);
                Ra.sl[3]=2429; /* line # 2429 */
                if (Rv25==NULL) Rv24=Rv17;
                else((V *)Rv25)[0]=Rv17;
                Rv25=Rv17;
                Rv7=((V *)Rv7)[3];
                Rv26=((V *)Rv26)[17];
                Ra.sl[3]=2434; /* line # 2434 */
                Rv9=((V *)Rv9)[17];
              }
              else Rv9=NULL;
              Rv29=Rv3;
              if (((SL *)((V *)Rv29)[4])[5]>0) {
                Ra.sl[3]=2439; /* line # 2439 */
                ((SL *)Rv29)[2]=((SL *)Rv29)[2]+((SL *)((V *)Rv29)[4])[5];
              }
            }
            if (Rv24!=NULL) {
              Ra.sl[3]=2445; /* line # 2445 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              ((V *)Rv3)[0]=Rv24;
              Rv3=Rv25;
            }
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[3]=2452; /* line # 2452 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Rv7=((V *)Rv7)[3];
    }
    if (((V *)Rv4)[12]!=NULL) {
      Ra.sl[3]=2457; /* line # 2457 */
      Rv30=(*F_lgt);
      if (((UB *)((V *)Rv4)[12])[52]==29||((UB *)((V *)Rv4)[12])[52]==28) {
        Ra.sl[3]=2462; /* line # 2462 */
        ((V *)Rv30)[4]=Rv6;
        if (!((UB *)Rv6)[51]&&((V *)Rv30)[1]!=NULL) ((V *)((V *)Rv30)[1])[4]=Rv6;
      }
      Ra.sl[3]=2468; /* line # 2468 */
      if (!((UB *)((V *)Rv4)[12])[51]) P_tmpstk_allocate(((V *)Rv30)[1],((V *)((
      V *)Rv30)[1])[4]);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wrt "  */
void PAS_EXPSION_PRC_00000007(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+575;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2514; /* line # 2514 */
  if (F_pt!=NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_ENM(((UB *)F_pt)[52],Rd.s+580,14,-1,32);
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1198,14,-1,32);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_entry "  */
void PAS_EXPSION_PRC_00000008(V F_pg, UB F_bt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1208;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2518; /* line # 2518 */
  Rv0=F_pg;
  if (((UB *)Rv0)[4]&&Lx[3].sl[5]<=2) {
    if (F_bt) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1220,-1,-1,32);
    }
    else {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1238,-1,-1,32);
    }
    Ra.sl[3]=2523; /* line # 2523 */
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[3]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1250,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[4]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1254,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[2]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1260,-1,-1,32);
    PAS__WRITE_ENM(((UB *)Rv0)[28],Rd.s+1276,0,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dump "  */
void PAS_EXPSION_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3330;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2531; /* line # 2531 */
  while (Lx[3].v[0]!=NULL){
    Rv1=Lx[3].v[0];
    if (Rv0) {
      Ra.sl[3]=2536; /* line # 2536 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+3336,-1,-1,32);
      PAS__WRITE_INT(Lx[3].sl[5],0,0);
      PAS__WRITE_STR(Rd.s+3363,-1,-1,32);
      if (Lx[3].v[6]!=NULL) {
        Rv2=Lx[3].v[6];
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3371,-1,-1,32);
        PAS_EXPSION_PRC_00000007(((V *)Rv2)[4]);
        Ra.sl[3]=2541; /* line # 2541 */
        if (((V *)Rv2)[0]!=NULL) {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+3386,-1,-1,32);
          PAS_EXPSION_PRC_00000007(((V *)((V *)Rv2)[0])[4]);
        }
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[3]=2546; /* line # 2546 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3403,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Rv0=0;
    }
    PAS_EXPSION_PRC_00000008(Lx[3].v[0],0);
    Lx[3].v[0]=((V *)Rv1)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  register V Rv11;
  register V Rv12;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.sl[5]=F_npa;
  Ra.v[6]=F_parm_lst;
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+3412;
  Ra.v[3]=Rd.s+13;
  Ra.sl[4]=2561; /* line # 2561 */
  Ra.v[0]=(*F_pg);
  Rv0=0;
  Ra.sl[4]=2566; /* line # 2566 */
  while (!Rv0&&(*F_pg)!=NULL){
    Rv1=Ra.v[6];
    Rv2=(*F_pg);
    if (((UB *)Rv2)[4]&&Ra.sl[5]<=2) {
      Ra.sl[4]=2572; /* line # 2572 */
      Rv3=Rv1;
      switch (Ra.sl[5]) {
        case 0:Rv0=((V *)Rv2)[3]==NULL&&((V *)Rv2)[4]==NULL;
        break;
        case 1:Rv0=((V *)Rv2)[4]==NULL&&P_comp_type(((V *)Rv3)[4],((V *)Rv2)[3],0);
        break;
        case 2:Ra.sl[4]=2577; /* line # 2577 */
        if (((SL *)((V *)Rv3)[4])[6]>0&&((SL *)((V *)((V *)Rv3)[0])[4])[6]>0) switch ((
        (UB *)((V *)Rv2)[3])[52]) {
          case 28:Rv0=((P_comp_type(((V *)((V *)Rv3)[0])[4],((V *)Rv3)[4],1)&&((
          SL *)((V *)Rv3)[4])[5]==0)&&((SL *)((V *)Rv3)[4])[6]==((SL *)((V *)((V
           *)Rv3)[0])[4])[6])&&P_comp_type(((V *)((V *)Rv3)[0])[4],((V *)Rv2)[4]
          ,0);
          break;
          case 29:Ra.sl[4]=2587; /* line # 2587 */
          Rv0=((P_comp_type(((V *)((V *)Rv3)[0])[4],((V *)Rv3)[4],0)||P_comp_type((
          (V *)Rv3)[4],((V *)((V *)Rv3)[0])[4],0))&&P_comp_type(((V *)Rv3)[4],((
          V *)Rv2)[4],0))&&P_comp_type(((V *)((V *)Rv3)[0])[4],((V *)Rv2)[4],0);
          break;
          case 30:Ra.sl[4]=2593; /* line # 2593 */
          Rv0=(P_comp_type(((V *)((V *)Rv3)[0])[4],V_typ_std.v[19],0)&&P_comp_type((
          (V *)Rv3)[4],((V *)((V *)((V *)Rv3)[0])[4])[15],0))&&P_comp_type(((V *)(
          (V *)Rv3)[0])[4],((V *)Rv2)[4],0);
          break;
          default:Ra.sl[4]=2599; /* line # 2599 */
          Rv0=P_comp_type(((V *)Rv3)[4],((V *)Rv2)[3],1)&&P_comp_type(((V *)((V *)
          Rv3)[0])[4],((V *)Rv2)[4],1);
          break;
        }
        break;
      }
    }
    else {
      Ra.sl[4]=2605; /* line # 2605 */
      Rv4=((V *)Rv2)[2];
      if (((SL *)Rv4)[11]>=Ra.sl[5]) {
        Rv5=((V *)Rv4)[8];
        if (((V *)Rv4)[8]!=NULL) {
          Ra.sl[4]=2610; /* line # 2610 */
          if (((UB *)((V *)Rv4)[8])[38]==6) Rv5=((V *)Rv5)[3];
        }
        if ((Ra.sl[5]==2&&((SL *)Rv4)[11]==2)&&(((UB *)Rv4)[56]==1||((UB *)Rv4)[
56]==2)) {
          Ra.sl[4]=2615; /* line # 2615 */
          Rv6=Rv1;
          switch (((UB *)((V *)Rv5)[4])[52]) {
            case 28:Rv0=(((V *)((V *)Rv6)[0])[4]==((V *)Rv6)[4]&&((SL *)((V *)Rv6)
            [4])[5]==0)&&P_comp_type(((V *)Rv6)[4],((V *)((V *)Rv5)[3])[4],0);
            break;
            case 29:Ra.sl[4]=2624; /* line # 2624 */
            Rv0=((P_comp_type(((V *)((V *)Rv6)[0])[4],((V *)Rv6)[4],0)||P_comp_type((
            (V *)Rv6)[4],((V *)((V *)Rv6)[0])[4],0))&&P_comp_type(((V *)Rv6)[4],(
            (V *)((V *)Rv5)[3])[4],0))&&P_comp_type(((V *)((V *)Rv6)[0])[4],((V *)(
            (V *)Rv5)[3])[4],0);
            break;
            case 30:Ra.sl[4]=2630; /* line # 2630 */
            if (P_comp_type(((V *)((V *)Rv6)[0])[4],V_typ_std.v[19],0)) Rv0=P_comp_type((
            (V *)Rv6)[4],((V *)((V *)((V *)Rv6)[0])[4])[15],0)&&P_comp_type(((V *)(
            (V *)Rv6)[0])[4],((V *)((V *)Rv5)[3])[4],0);
            break;
            default:Ra.sl[4]=2637; /* line # 2637 */
            Rv0=0;
            break;
          }
        }
        if (!Rv0) {
          Ra.sl[4]=2642; /* line # 2642 */
          Rv0=1;
          while (Rv0&&Rv5!=NULL){
            Rv7=0;
            Rv8=Rv5;
            Ra.sl[4]=2647; /* line # 2647 */
            if (Rv1!=NULL) {
              Rv9=Rv1;
              if (((UB *)Rv9)[24]==17) {
                if (((V *)Rv8)[10]==NULL&&!(8192&((UW *)Rv8)[18])) {
                  Ra.sl[4]=2652; /* line # 2652 */
                  Rv0=0;
                }
                else {
                  Rv5=((V *)Rv8)[3];
                  Rv1=((V *)Rv9)[0];
                }
              }
              else {
                Ra.sl[4]=2659; /* line # 2659 */
                Rv10=P_comp_type(((V *)Rv9)[4],((V *)Rv8)[4],((UB *)Rv8)[38]!=8);
                if (!Rv10&&((UB *)Rv9)[24]==14) {
                  Ra.sl[4]=2664; /* line # 2664 */
                  Rv11=((V *)Rv8)[4];
                  switch (((UB *)Rv11)[52]) {
                    case 4:Ra.sl[4]=2673; /* line # 2673 */
                    if (((UB *)((V *)Rv9)[4])[52]==3) {
                      ((V *)Rv9)[4]=V_typ_std.v[4];
                      Rv10=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[4]=2697; /* line # 2697 */
                    if ((P_comp_type(((V *)Rv11)[17],V_typ_std.v[0],1)&&((UB *)(
                    (V *)Rv11)[18])[52]==2)&&((SL *)Rv11)[5]==0) {
                      if (P_comp_type(((V *)Rv9)[4],V_typ_std.v[10],0)) {
                        Ra.sl[4]=2703; /* line # 2703 */
                        if (((UB *)Rv11)[52]==8) {
                          Rv12=((V *)Rv11)[18];
                          Rv10=(((SL *)Rv12)[18]-((SL *)Rv12)[17])+1==((SL *)((V
                           *)Rv9)[8])[5];
                        }
                        else {
                          Ra.sl[4]=2708; /* line # 2708 */
                          Rv10=1;
                        }
                      }
                      else {
                        if (P_comp_type(((V *)Rv9)[4],V_typ_std.v[0],0)) {
                          if (((UB *)Rv11)[52]==9) Rv10=1;
                          else {
                            Ra.sl[4]=2713; /* line # 2713 */
                            Rv10=((SL *)Rv11)[18]==((SL *)Rv11)[17];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[4]=2718; /* line # 2718 */
                if (Rv10) {
                  if (((V *)Rv8)[4]!=NULL) {
                    if (((UB *)((V *)Rv8)[4])[52]==9) Rv7=((SL *)((V *)Rv8)[4])[
14];
                  }
                  Ra.sl[4]=2723; /* line # 2723 */
                  Rv5=((V *)Rv8)[3];
                  Rv1=((V *)Rv9)[0];
                }
                else Rv0=0;
                if (Rv0) {
                  Ra.sl[4]=2729; /* line # 2729 */
                  if (((UB *)Rv8)[38]==8) {
                    if (!(1&((UW *)Rv9)[6])) Rv0=0;
                  }
                  else {
                    Ra.sl[4]=2734; /* line # 2734 */
                    if (4&((UW *)Rv9)[6]) {
                      if (32&((UW *)Rv8)[18]) {
                        if (!(1&((UW *)Rv9)[6])) Rv0=0;
                      }
                      if (64&((UW *)Rv8)[18]) {
                        Ra.sl[4]=2739; /* line # 2739 */
                        if (!(2&((UW *)Rv9)[6])) Rv0=0;
                      }
                    }
                    else {
                      if (64&((UW *)Rv8)[18]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[4]=2747; /* line # 2747 */
              if (((V *)Rv8)[10]==NULL&&!(8192&((UW *)Rv8)[18])) Rv0=0;
              else Rv5=((V *)Rv8)[3];
            }
            Ra.sl[4]=2752; /* line # 2752 */
            if (Rv7>0) while (1){
              Rv5=((V *)Rv5)[3];
              Rv7=Rv7-1;
              if (Rv7==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[4]=2759; /* line # 2759 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  if (!Rv0) {
    PAS_EXPSION_PRC_00000009();
    Ra.sl[4]=2764; /* line # 2764 */
    P_src_error_s(Rd.s+3430,113,3, F_id,NULL);
  }
  else Ra.sl[4]=2769; /* line # 2769 */
  PAS__curr_cntx=Ra.v[1];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3434;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2788; /* line # 2788 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  if (F_p!=NULL) {
    Rv1=F_p;
    Ra.sl[3]=2793; /* line # 2793 */
    if (((UB *)Rv1)[4]) {
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else Rv2=P_exp_val_bin(F_oblst, F_p);
      if (((V *)Rv2)[4]==V_typ_std.v[29]) ((V *)Rv2)[4]=((V *)F_oblst)[4];
    }
    else {
      Ra.sl[3]=2801; /* line # 2801 */
      Rv3=((V *)Rv1)[2];
      Rv2=P_lgt_new_call(((V *)Rv3)[12],((V *)Rv1)[2],F_oblst);
      if (((V *)Rv3)[12]==V_typ_std.v[29]) ((V *)Rv2)[4]=((V *)F_oblst)[4];
      Ra.sl[3]=2806; /* line # 2806 */
      P_call_setting(&Rv2);
    }
    Ret=Rv2;
  }
  else Ret=F_oblst;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3447;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2825; /* line # 2825 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Rv0=((V *)F_ip)[10];
  if (F_np<=0) {
    Rv1=F_lgp;
    Ra.sl[3]=2830; /* line # 2830 */
    while (Rv1!=NULL){
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Rv2=NULL;
  if (F_np==1||F_np==2) {
    Ra.sl[3]=2835; /* line # 2835 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[3]=2840; /* line # 2840 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      if (((V *)Rv3)[2]!=NULL) {
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[12],((V *)Rv3)[2],F_lgp);
        P_call_setting(&Rv2);
        Ra.sl[3]=2845; /* line # 2845 */
        if (((V *)((V *)Rv3)[2])[12]==V_typ_std.v[29]) ((V *)Rv2)[4]=((V *)F_lgp)
        [4];
      }
    }
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3462;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2856; /* line # 2856 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[4],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3473;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=2871; /* line # 2871 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else Rv0=((V *)V_ope_table.v[28])[4];
  Rv1=((V *)F_prm)[0];
  Rv2=((UW *)F_prm)[6];
  Rv3=((UW *)Rv1)[6];
  Ra.sl[3]=2876; /* line # 2876 */
  if (F_bovr) {
    ((UW *)F_prm)[6]=Rv2|3;
    ((UW *)Rv1)[6]=Rv3|1;
  }
  Ra.sl[3]=2881; /* line # 2881 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  if (F_bovr) {
    ((UW *)F_prm)[6]=Rv2;
    ((UW *)Rv1)[6]=Rv3;
  }
  Ra.sl[3]=2887; /* line # 2887 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
