/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 464 ) = {
 12,  12, 115, 116, 114,  95, 103, 101, 116,  95,  99, 104,  97, 114,  44,  44,
 47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 109, 120, 100,  95,
115, 114,  99,  47, 115, 111, 114, 116,  46, 112,  97, 115,  12,  12, 115, 116,
114,  95, 103, 101, 116,  95, 114, 101,  97, 108,   4,   4, 100, 105, 115, 116,
  9,   9, 103, 101, 116, 110, 117, 109,  98, 101, 114,  10,  10, 111, 117, 116,
116, 114, 105, 112, 108, 101, 116,   4,   4, 115, 111, 114, 116,   3,   3, 101,
110, 100,  32,  32,  32, 110, 117, 109,  98, 101, 114,  32, 111, 102,  32,  99,
111, 108, 117, 109, 110,  32, 102, 111, 114,  32, 101,  97,  99, 104,  32, 108,
105, 110, 101,  32,  15,  15,  32,  99, 111, 108, 117, 109, 110, 115,  32,  97,
 98, 111, 118, 101,  32,  20,  20,  39, 116, 104,  32, 119, 105, 108, 108,  32,
 98, 101,  32, 105, 103, 110, 111, 114, 101, 100,  46,  45,  45,  32,  67, 111,
108, 117, 109, 110,  32, 110, 117, 109,  98, 101, 114,  32, 102, 111, 114,  32,
104,  44,  32, 107,  44,  32, 108,  44,  32, 111,  98, 115,  44,  32, 115, 105,
103, 109,  97,  32,  97, 114, 101,  32,  63,  32,  58,  58,  32,  84, 104, 101,
116,  97,  32,  99, 111, 108, 117, 109, 110,  32, 110, 117, 109,  98, 101, 114,
 32, 105, 110,  32, 116, 104, 101,  32, 105, 110, 112, 117, 116,  32, 100,  97,
116,  97,  40,  48,  32, 105, 102,  32, 110, 111, 116,  32, 112, 114, 101, 115,
101, 110, 116,  41,  32,  61,  29,  29,  32,  87,  97, 118, 101,  32, 108, 101,
110, 103, 116, 104,  40, 105, 110,  32,  97, 110, 103, 115, 116, 114, 111, 101,
109,  41,  32,  61,  32,  53,  53,  32, 103, 105, 118, 101,  32, 116, 104, 101,
 32, 117, 110, 105, 116,  32,  99, 101, 108, 108,  40,  97, 110, 103, 115, 116,
114, 111, 101, 109,  32,  97, 110, 100,  32, 100, 101, 103, 114, 101, 101, 115,
 32, 111, 114,  32,  99, 111, 115, 105, 110, 117, 115,  41,  19,  19,  32,  73,
110, 112, 117, 116,  32, 102, 105, 108, 101,  32, 110,  97, 109, 101,  32,  61,
 32,  20,  20,  32,  79, 117, 116, 112, 117, 116,  32, 102, 105, 108, 101,  32,
110,  97, 109, 101,  32,  61,  32,  11,  11,  32,  84, 104, 101, 114, 101,  32,
 97, 114, 101,  32,  19,  19,  32, 115, 111, 114, 116, 101, 100,  32, 114, 101,
102, 108, 101, 120, 105, 111, 110, 115,  46,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 480 ) = {
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 320 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern V PAS__f_input;




/* Procedure/Function : " str_get_char "  */
C SORT_str_get_char(V F_st, SL *F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=70; /* line # 70 */
  if ((*F_ip)<((UB *)F_st)[1]) {
    (*F_ip)=(*F_ip)+1;
    Ret=((C *)F_st)[(*F_ip)+1];
  }
  else Ret=59;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_get_real "  */
F SORT_str_get_real(V F_st, SL *F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  UB Rv1;
  C Rv2;
  F Rv3;
  F Rv4;
  SL Rv5;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+60;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=88; /* line # 88 */
  Rv0=(F)0.000000E-01;
  Rv1=0;
  Rv2=32;
  while (Rv2==32||Rv2==9)
  Rv2=SORT_str_get_char(F_st,F_ip);
  if (Rv2==43) {
    Ra.sl[6]=93; /* line # 93 */
    Rv2=SORT_str_get_char(F_st,F_ip);
  }
  else {
    if (Rv2==45) {
      Rv1=1;
      Ra.sl[6]=98; /* line # 98 */
      Rv2=SORT_str_get_char(F_st,F_ip);
    }
  }
  while (Rv2>=48&&Rv2<=57){
    Rv0=Rv0*(F)1.000000E+01+(float)((SL)Rv2-48);
    Ra.sl[6]=103; /* line # 103 */
    Rv2=SORT_str_get_char(F_st,F_ip);
  }
  if (Rv2==46) {
    Rv3=(F)1.000000E-01;
    Ra.sl[6]=108; /* line # 108 */
    Rv2=SORT_str_get_char(F_st,F_ip);
    while (Rv2>=48&&Rv2<=57){
      Rv0=Rv0+Rv3*(float)((SL)Rv2-48);
      Rv3=Rv3*(F)1.000000E-01;
      Ra.sl[6]=113; /* line # 113 */
      Rv2=SORT_str_get_char(F_st,F_ip);
    }
  }
  if (Rv2==101||Rv2==69) {
    Ra.sl[6]=118; /* line # 118 */
    Rv2=SORT_str_get_char(F_st,F_ip);
    Rv3=(F)1.000000E+00;
    Rv4=(F)1.000000E+01;
    Rv5=0;
    if (Rv2==43) Rv2=SORT_str_get_char(F_st,F_ip);
    else {
      Ra.sl[6]=124; /* line # 124 */
      if (Rv2==45) {
        Rv4=(F)1.000000E-01;
        Rv2=SORT_str_get_char(F_st,F_ip);
      }
    }
    while (Rv2>=48&&Rv2<=57){
      Ra.sl[6]=130; /* line # 130 */
      Rv5=Rv5*10+((SL)Rv2-48);
      Rv2=SORT_str_get_char(F_st,F_ip);
    }
    while (Rv5>0)
    if (Rv5&1) {
      Ra.sl[6]=136; /* line # 136 */
      Rv5=Rv5-1;
      Rv3=Rv3*Rv4;
    }
    else {
      Rv4=Rv4*Rv4;
      Rv5=Rv5/2;
    }
    Ra.sl[6]=142; /* line # 142 */
    Rv0=Rv0*Rv3;
  }
  if (Rv1) Rv0= -Rv0;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dist "  */
F SORT_dist(SL F_h, SL F_k, SL F_l){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+74;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=151; /* line # 151 */
  Ret=(F)5.000000E-01*sqrt(((PAS__F_SQR(Rs.f[0]*(float)F_h)+PAS__F_SQR(Rs.f[1]*(float)
  F_k))+PAS__F_SQR(Rs.f[2]*(float)F_l))+(F)2.000000E+00*(((((Rs.f[3]*Rs.f[1])*Rs
  .f[2])*(float)F_k)*(float)F_l+(((Rs.f[4]*Rs.f[2])*Rs.f[0])*(float)F_l)*(float)
  F_h)+(((Rs.f[5]*Rs.f[0])*Rs.f[1])*(float)F_h)*(float)F_k));
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " getnumber "  */
F SORT_getnumber(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  F Rv2;
  SL Rv3;
  register int Rf0;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+80;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=166; /* line # 166 */
  if (Rs.sl[6]==0) {
    PAS__STR_TO_STR(Ri.s,PAS__CON_STR_CHA(Ra.s+28,Ri.s,32));
    Rs.sl[7]=PAS__LENGTH_STR(Ri.s);
    if (Rs.sl[7]<=1) Rs.sl[6]=-1;
    else {
      Ra.sl[6]=172; /* line # 172 */
      Rv0=0;
      Rs.sl[6]=0;
      Rv1=1;
      for( Rf0=Rs.sl[7];Rf0>0;Rf0-- ) {
        if (Rv0&&Ri.c[Rv1+1]<=32) {
          Ra.sl[6]=177; /* line # 177 */
          Rv0=0;
          if (Rs.sl[6]<12) {
            Rs.sl[6]=Rs.sl[6]+1;
            Rs.sl[Rs.sl[6]+7]=Rv1-1;
          }
        }
        else {
          Ra.sl[6]=185; /* line # 185 */
          if (!Rv0&&Ri.c[Rv1+1]>32) Rv0=1;
        }
        Rv1++;
      }
      Rs.sl[7]=Rs.sl[6];
      Rs.sl[6]=1;
    }
  }
  Ra.sl[6]=191; /* line # 191 */
  if (Rs.sl[6]<=0) Rv2=(F)0.000000E-01;
  else {
    if (Rs.sl[6]==1) Rv3=1;
    else Rv3=Rs.sl[(Rs.sl[6]-1)+7]+1;
    Ra.sl[6]=196; /* line # 196 */
    Rv2=SORT_str_get_real(Ri.s,&Rv3);
    Rs.sl[6]=Rs.sl[6]+1;
    if (Rs.sl[6]>Rs.sl[7]) Rs.sl[6]=-1;
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " outtriplet "  */
void SORT_outtriplet(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+91;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=209; /* line # 209 */
  Rv0=F_pt;
  if (((V *)Rv0)[0]!=NULL) SORT_outtriplet(((V *)Rv0)[0]);
  if (Rs.sl[28]<=0) {
    Ra.sl[6]=214; /* line # 214 */
    ((F *)Rv0)[16]=((F *)Rv0)[16]*Rs.f[29];
    if (((F *)Rv0)[16]>=(F)9.999000E-01) ((F *)Rv0)[16]=(F)9.900000E+01;
    else((F *)Rv0)[16]=(float)((double)atan(((F *)Rv0)[16]/sqrt((F)1.000000E+00-
    PAS__F_SQR(((F *)Rv0)[16])))/1.745329310000000E-002);
  }
  PAS__SELECT_OUT(Ri.v[33]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[4],4,0);
  PAS__WRITE_INT(((SL *)Rv0)[5],4,0);
  PAS__WRITE_INT(((SL *)Rv0)[6],4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv0)[7],12,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv0)[8],12,-6,0);
  PAS__WRITE_SNGL(((F *)Rv0)[16],8,3,0);
  Ra.sl[6]=219; /* line # 219 */
  Rv1=1;
  for( Rf0=Rs.sl[30];Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(Ri.v[33]);
    PAS__WRITE_SNGL(((F *)Rv0)[Rv1+8],12,4,0);
    Rv1++;
  }
  PAS__SELECT_OUT(Ri.v[33]);
  PAS__WRITE_EOLN();
  if (((V *)Rv0)[1]!=NULL) SORT_outtriplet(((V *)Rv0)[1]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " sort "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  SL Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  F Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  F Rv17;
  F Rv18;
  F Rv19;
  SL Rv20;
  F Rv21;
  SL Rv22;
  SL Rv23;
  SL Rv24;
  SL Rv25;
  SL Rv26;
  F Rv27;
  F Rv28;
  F Rv29;
  SL Rv30;
  V Rv31;
  register V Rv32;
  SL Rv33;
  V Rv34;
  V Rv35;
  SL Rv36;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[16]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+128;
  Rs.v[17]=Rd.s+103;
  Rs.v[18]=Rd.s+14;
  Rs.sl[38]=226; /* line # 226 */
  PAS__STR_TO_STR(Ri.s+272,Rd.s+109);
  Rv0=NULL;
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+114,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SL(&Rv1,0);
  PAS__READ_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Rs.sl[38]=231; /* line # 231 */
  if (Rv1>20) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+148,-1,-1,32);
    PAS__WRITE_INT(20,12,0);
    PAS__WRITE_STR(Rd.s+165,-1,-1,32);
    PAS__WRITE_EOLN();
    Rv1=20;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+187,-1,-1,32);
  Rs.sl[38]=236; /* line # 236 */
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SL(&Rv2,0);
  PAS__READ_SL(&Rv3,0);
  PAS__READ_SL(&Rv4,0);
  PAS__READ_SL(&Rv5,0);
  PAS__READ_SL(&Rv6,0);
  PAS__READ_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+234,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_SL(Rs.sl+28,0);
  PAS__READ_EOLN();
  Rv7=1;
  for( Rf0=Rv1;Rf0>0;Rf0-- ) {
    Rs.sl[Rv7+38]=-1;
    Rv7++;
  }
  Rs.sl[38]=241; /* line # 241 */
  Rs.sl[Rv2+38]=0;
  Rs.sl[Rv3+38]=0;
  Rs.sl[Rv4+38]=0;
  Rs.sl[Rv5+38]=0;
  Rs.sl[Rv6+38]=0;
  Rs.sl[38]=246; /* line # 246 */
  if (Rs.sl[28]>0) Rs.sl[Rs.sl[28]+38]=0;
  Rv8=1;
  Rv9=1;
  for( Rf0=Rv1;Rf0>0;Rf0-- ) {
    Rs.sl[38]=251; /* line # 251 */
    if (Rs.sl[Rv9+38]<0) {
      Rs.sl[Rv9+38]=Rv8;
      Rv8=Rv8+1;
    }
    Rv9++;
  }
  Rs.sl[38]=257; /* line # 257 */
  Rs.sl[30]=Rv8-1;
  if (Rs.sl[28]<=0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Rs.sl[38]=262; /* line # 262 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+294,-1,-1,32);
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_SNGL(Rs.f+29,0);
    PAS__READ_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+325,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_SNGL(&Rv10,0);
    PAS__READ_SNGL(&Rv11,0);
    PAS__READ_SNGL(&Rv12,0);
    PAS__READ_SNGL(&Rv13,0);
    PAS__READ_SNGL(&Rv14,0);
    PAS__READ_SNGL(&Rv15,0);
    PAS__READ_EOLN();
    if (Rv13>(F)1.000000E+00) Rv13=(float)cos(1.745329310000000E-002*(double)Rv13)
    ;
    Rs.sl[38]=267; /* line # 267 */
    if (Rv14>(F)1.000000E+00) Rv14=(float)cos(1.745329310000000E-002*(double)Rv14)
    ;
    if (Rv15>(F)1.000000E+00) Rv15=(float)cos(1.745329310000000E-002*(double)Rv15)
    ;
    Rv16=Rv13*Rv13;
    Rv17=Rv14*Rv14;
    Rv18=Rv15*Rv15;
    Rv19=((Rv10*Rv11)*Rv12)*sqrt(((((F)1.000000E+00+(((F)2.000000E+00*Rv13)*Rv14)
    *Rv15)-Rv16)-Rv17)-Rv18);
    Rs.sl[38]=273; /* line # 273 */
    Rv16=sqrt((F)1.000000E+00-Rv16);
    Rv17=sqrt((F)1.000000E+00-Rv17);
    Rv18=sqrt((F)1.000000E+00-Rv18);
    Rs.f[3]=(Rv14*Rv15-Rv13)/(Rv17*Rv18);
    Rs.f[4]=(Rv15*Rv13-Rv14)/(Rv18*Rv16);
    Rs.sl[38]=278; /* line # 278 */
    Rs.f[5]=(Rv13*Rv14-Rv15)/(Rv16*Rv17);
    Rs.f[0]=((Rv11*Rv12)*Rv16)/Rv19;
    Rs.f[1]=((Rv12*Rv10)*Rv17)/Rv19;
    Rs.f[2]=((Rv10*Rv11)*Rv18)/Rv19;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Rs.sl[38]=283; /* line # 283 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+380,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_STR(Ri.s+338,0,0);
  PAS__READ_EOLN();
  Rv20=0;
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+401,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_STR(Ri.s+404,0,0);
  PAS__READ_EOLN();
  PAS__OPEN(Ri.v+59,0, Ri.s+338,1,0,-1);
  Rs.sl[38]=288; /* line # 288 */
  PAS__OPEN(Ri.v+33,0, Ri.s+404,2,0,-1);
  while (!PAS__EOF(Ri.v[59])){
    Rv21=(F)0.000000E-01;
    Rv22=0;
    PAS__SELECT_INP(Ri.v[59]);
    PAS__READ_STR(Ri.s,0,0);
    PAS__READ_EOLN();
    Rs.sl[38]=293; /* line # 293 */
    Rs.sl[6]=0;
    Rv23=1;
    while (Rv23<=Rv1){
      Rs.f[Rv23+58]=SORT_getnumber();
      Rv23=Rv23+1;
    }
    Rs.sl[38]=299; /* line # 299 */
    Rv24=PAS__F_ROUND(Rs.f[Rv2+58]);
    Rv25=PAS__F_ROUND(Rs.f[Rv3+58]);
    Rv26=PAS__F_ROUND(Rs.f[Rv4+58]);
    Rv27=Rs.f[Rv5+58];
    Rv28=Rs.f[Rv6+58];
    Rs.sl[38]=304; /* line # 304 */
    if (Rs.sl[28]>0) Rv29=Rs.f[Rs.sl[28]+58];
    else Rv29=SORT_dist(Rv24, Rv25, Rv26);
    Rs.sl[38]=310; /* line # 310 */
    Rv30=1;
    for( Rf0=Rv1;Rf0>0;Rf0-- ) {
      if (Rs.sl[Rv30+38]>0) Rs.f[Rs.sl[Rv30+38]+58]=Rs.f[Rv30+58];
      Rv30++;
    }
    Rv20=Rv20+1;
    Rv31=PAS__NEW(68);
    Rv32=Rv31;
    Rs.sl[38]=316; /* line # 316 */
    ((V *)Rv32)[0]=NULL;
    ((V *)Rv32)[1]=NULL;
    ((SL *)Rv32)[4]=Rv24;
    ((SL *)Rv32)[5]=Rv25;
    ((SL *)Rv32)[6]=Rv26;
    Rs.sl[38]=321; /* line # 321 */
    ((F *)Rv32)[16]=Rv29;
    ((F *)Rv32)[7]=Rv27;
    ((F *)Rv32)[8]=Rv28;
    if (((F *)Rv32)[16]<(F)0.000000E-01) ((F *)Rv32)[16]= -((F *)Rv32)[16];
    Rv33=1;
    for( Rf0=Rs.sl[30];Rf0>0;Rf0-- ) {
      ((F *)Rv32)[Rv33+8]=Rs.f[Rv33+58];
      Rv33++;
    }
    Rs.sl[38]=328; /* line # 328 */
    Rv34=Rv0;
    Rv35=NULL;
    while (Rv34!=NULL){
      Rv36=(SL)(Rv29!=((F *)Rv34)[16]);
      Rs.sl[38]=333; /* line # 333 */
      Rv35=Rv34;
      if (Rv36!=0) {
        if (Rv29<((F *)Rv34)[16]) Rv36=-1;
      }
      if (Rv36<0) Rv34=((V *)Rv34)[0];
      else Rv34=((V *)Rv34)[1];
    }
    Rs.sl[38]=339; /* line # 339 */
    if (Rv35==NULL) Rv0=Rv31;
    else {
      if (Rv36<0) ((V *)Rv35)[0]=Rv31;
      else((V *)Rv35)[1]=Rv31;
    }
  }
  Rs.sl[38]=344; /* line # 344 */
  if (Rv0!=NULL) SORT_outtriplet(Rv0);
  PAS__CLOSE(Ri.v+59,0);
  PAS__CLOSE(Ri.v+33,0);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Rs.sl[38]=349; /* line # 349 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+423,-1,-1,32);
  PAS__WRITE_INT(Rv20,12,0);
  PAS__WRITE_STR(Rd.s+436,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[16];
  PAS__EXIT( 0 );
}
