/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 616 ) = {
  4,   4, 102,  98, 106, 110,  47,  47,  47, 104, 111, 109, 101,  47, 112, 105,
101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107,
105, 116, 115,  47, 109, 120, 100,  95, 115, 114,  99,  47, 109, 120, 100,  95,
114, 116, 108,  46, 112,  97, 115,   8,   8,  98, 101, 115, 115, 101, 108,  95,
106,   9,   9, 115, 116,  95,  99, 114, 101,  97, 116, 101,   7,   7, 115, 116,
 95, 102, 114, 101, 101,  11,  11, 115, 116,  95, 112, 117, 116,  95,  99, 104,
 97, 114,  12,  12, 115, 116,  95, 112, 117, 116,  95, 109,  99, 104,  97, 114,
 12,  12, 115, 116,  95, 112, 117, 116,  95, 112,  97, 115, 116, 114,  13,  13,
115, 116,  95, 112, 117, 116,  95, 115, 116, 114, 105, 110, 103,  12,  12, 115,
116,  95, 112, 117, 116,  95, 105, 100, 101, 110, 116,  12,  12, 115, 116,  95,
119, 114, 116,  95, 102, 108, 111,  97, 116,  12,  12, 115, 116,  95, 112, 117,
116,  95,  98,  95, 105, 110, 116,  10,  10, 115, 116,  95, 112, 117, 116,  95,
105, 110, 116,  12,  12, 115, 116,  95, 115, 105, 122, 101,  95, 114, 101,  97,
108,  12,  12, 115, 116,  95, 112, 117, 116,  95, 102, 108, 111,  97, 116,  12,
 12, 115, 116,  95, 112, 117, 116,  95, 102, 105, 120, 101, 100,   8,   8, 111,
117, 116,  95, 112,  97, 103, 101,   8,   8, 103, 101, 116,  95, 100,  97, 116,
101,   8,   8, 103, 101, 116,  95, 116, 105, 109, 101,  14,  14, 112, 117, 116,
 95, 110, 101, 119, 108, 105, 110, 101, 108, 115, 116,   9,   9,  32, 114, 117,
110,  32, 116, 104, 101,  32,   4,   4,  32,  97, 116,  32,   5,   5, 112,  97,
103, 101,  32,  13,  13, 111, 117, 116, 101, 114, 114, 109, 115, 103, 108, 105,
110, 101,  12,  12,  32,  42,  43,  42,  43,  42,  43,  42,  43,  42,  32,  32,
 12,  12, 111, 112, 101, 110,  95, 108, 105, 115, 116, 105, 110, 103,  46,  46,
 32,  77,  88,  68,  95,  67,  77,  80,  32,  99,  97, 110, 110, 111, 116,  32,
111, 112, 101, 110,  32,  40, 105, 110,  32, 114, 101,  97, 100,  32, 109, 111,
100, 101,  41,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  34,  13,  13,
111, 112, 101, 110, 119,  95, 116, 120, 116, 102, 105, 108, 101,  47,  47,  32,
 77,  88,  68,  95,  67,  77,  80,  32,  99,  97, 110, 110, 111, 116,  32, 111,
112, 101, 110,  32,  40, 105, 110,  32, 119, 114, 105, 116, 101,  32, 109, 111,
100, 101,  41,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  34,  13,  13,
 99, 108, 111, 115, 101,  95, 116, 120, 116, 102, 105, 108, 101,  18,  18, 111,
112, 101, 110,  95, 105, 110, 112, 117, 116,  95, 116, 120, 116, 102, 105, 108,
101,   9,   9,  99, 112, 117,  95,  99, 108, 111,  99, 107,  12,  12, 111, 112,
101, 110,  95, 100, 100, 105, 102, 105, 108, 101,  13,  13,  99, 108, 111, 115,
101,  95, 100, 100, 105, 102, 105, 108, 101,  12,  12, 111, 112, 101, 110,  95,
 98, 100, 116, 102, 105, 108, 101,  13,  13, 111, 112, 101, 110, 114,  95,  98,
100, 116, 102, 105, 108, 101,  13,  13,  99, 108, 111, 115, 101,  95,  98, 100,
116, 102, 105, 108, 101,  12,  12, 111, 112, 101, 110,  95,  98,  99, 102, 102,
105, 108, 101,  13,  13,  99, 108, 111, 115, 101,  95,  98,  99, 102, 102, 105,
108, 101,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern SL PAS__iostatus;
extern V PAS__f_error;

/* Declaration of global variables. */
SL V_linewrt;
SL V_pagenb;
SL V_errcnt;
Blk(V_errmsgspecif, 136 ) = {
132,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
UB V_majorfmode;
UB V_fatalerror;
V V_lst = NULL;
V V_strempty = NULL;

/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);
void PAS__ERROR_GETMSG(SL F_n, V F_msgstr, V F_msgfil);


/* Procedure/Function : " fbjn "  */
F P_fbjn(F *F_dbjn, F F_x, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  F Rv2;
  F Rv3;
  SL Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  register int Rf0;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=174; /* line # 174 */
  if (F_x<(F)1.500000E+01) {
    Ra.sl[6]=176; /* line # 176 */
    F_x=F_x/(F)2.000000E+00;
    Ra.sl[6]=177; /* line # 177 */
    Rv0=(F)1.000000E+00;
    Ra.sl[6]=178; /* line # 178 */
    Rv1=2;
    for( Rf0=F_n-1;Rf0>0;Rf0-- ) {
      Rv0=Rv0/(float)Rv1;
      Rv1++;
    }
    Ra.sl[6]=179; /* line # 179 */
    Rv2=Rv0;
    Rv0=Rv0/(float)(F_n+1);
    Rv3=(F)0.000000E-01;
    Ra.sl[6]=180; /* line # 180 */
    Rv4=1;
    Rv5=F_n+1;
    while (1){
      Ra.sl[6]=182; /* line # 182 */
      Rv6=Rv2;
      Ra.sl[6]=183; /* line # 183 */
      Rv0= -Rv0*F_x;
      Rv3=Rv3+(float)Rv4*Rv0;
      Rv0=Rv0*F_x;
      Ra.sl[6]=184; /* line # 184 */
      Rv2=Rv2+Rv0;
      Rv5=Rv5+1;
      Ra.sl[6]=185; /* line # 185 */
      Rv0=Rv0/(float)Rv5;
      Ra.sl[6]=186; /* line # 186 */
      Rv4=Rv4+1;
      Rv0=Rv0/(float)Rv4;
      if (Rv6==Rv2)  break;
    }
    Ra.sl[6]=188; /* line # 188 */
    if (F_n==0) {
      Ra.sl[6]=190; /* line # 190 */
      Rv7=(F)0.000000E-01;
      Rv8=(F)1.000000E+00;
    }
    else {
      Ra.sl[6]=193; /* line # 193 */
      Rv7=PAS__IFPOWER(F_x,F_n-1);
      Rv8=Rv7*F_x;
    }
    Ra.sl[6]=195; /* line # 195 */
    Ret=Rv8*Rv2;
    Ra.sl[6]=196; /* line # 196 */
    (*F_dbjn)=(((float)F_n*Rv7)*Rv2)*(F)5.000000E-01+Rv8*Rv3;
  }
  else {
    Ra.sl[6]=200; /* line # 200 */
    Rv9=(float)(((double)F_x-7.853981599999999E-001)-(double)F_n*1.570796330000000E+000)
    ;
    Rv3=(float)(7.978845599999999E-001/(double)sqrt(F_x));
    Ra.sl[6]=201; /* line # 201 */
    Rv6=cos(Rv9)*Rv3;
    Ret=Rv6;
    Ra.sl[6]=202; /* line # 202 */
    (*F_dbjn)= -(Rv6/((F)2.000000E+00*F_x)+Rv3*sin(Rv9));
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " bessel_j "  */
F P_bessel_j(SL F_n, F F_x){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+55;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=213; /* line # 213 */
  Ret=P_fbjn(&Rv0, F_x, F_n);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " st_create "  */
V P_st_create(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+65;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=236; /* line # 236 */
  if (V_strempty==NULL) Rv0=PAS__NEW(141);
  else {
    Ra.sl[6]=239; /* line # 239 */
    Rv0=V_strempty;
    V_strempty=((V *)Rv0)[0];
  }
  Ra.sl[6]=241; /* line # 241 */
  Rv1=Rv0;
  Ra.sl[6]=243; /* line # 243 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[6]=244; /* line # 244 */
  ((C *)Rv1)[140]=0;
  Ra.sl[6]=246; /* line # 246 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " st_free "  */
void P_st_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=254; /* line # 254 */
  ((V *)(*F_p))[0]=V_strempty;
  V_strempty=(*F_p);
  Ra.sl[6]=255; /* line # 255 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_char "  */
void P_st_put_char(V F_st, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+85;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=264; /* line # 264 */
  Ra.sl[6]=265; /* line # 265 */
  if (((C *)F_st)[140]<132) {
    Ra.sl[6]=267; /* line # 267 */
    ((C *)F_st)[140]=((C *)F_st)[140]+1;
    Ra.sl[6]=268; /* line # 268 */
    ((C *)F_st)[(SL)((C *)F_st)[140]+7]=F_ch;
  }
  else {
    Ra.sl[6]=270; /* line # 270 */
    ((C *)F_st)[139]=42;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_mchar "  */
void P_st_put_mchar(V F_st, C F_ch, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+98;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=278; /* line # 278 */
  if (F_m>=0) {
    Ra.sl[6]=279; /* line # 279 */
    while (F_m>0){
      Ra.sl[6]=281; /* line # 281 */
      P_st_put_char(F_st,F_ch);
      F_m=F_m-1;
    }
  }
  else {
    Ra.sl[6]=284; /* line # 284 */
    Ra.sl[6]=286; /* line # 286 */
    F_m= -F_m-1;
    Ra.sl[6]=287; /* line # 287 */
    if (F_m>=132) F_m=0;
    Ra.sl[6]=288; /* line # 288 */
    if ((SL)((C *)F_st)[140]>=F_m) {
      Ra.sl[6]=289; /* line # 289 */
      ((C *)F_st)[140]=(C)F_m;
    }
    else while (1){
      Ra.sl[6]=292; /* line # 292 */
      ((C *)F_st)[140]=((C *)F_st)[140]+1;
      Ra.sl[6]=293; /* line # 293 */
      ((C *)F_st)[(SL)((C *)F_st)[140]+7]=F_ch;
      if ((SL)((C *)F_st)[140]==F_m)  break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_pastr "  */
void P_st_put_pastr(V F_trg, V F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+112;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=306; /* line # 306 */
  Rv0=PAS__LENGTH_STR(F_src);
  Ra.sl[6]=307; /* line # 307 */
  if (Rv0>0) {
    Ra.sl[6]=308; /* line # 308 */
    Ra.sl[6]=310; /* line # 310 */
    Rv1=0;
    while (1){
      Ra.sl[6]=312; /* line # 312 */
      if (((C *)F_trg)[140]<132) {
        Ra.sl[6]=314; /* line # 314 */
        ((C *)F_trg)[140]=((C *)F_trg)[140]+1;
        Ra.sl[6]=315; /* line # 315 */
        Rv1=Rv1+1;
        Ra.sl[6]=316; /* line # 316 */
        ((C *)F_trg)[(SL)((C *)F_trg)[140]+7]=((C *)F_src)[Rv1+1];
      }
      else {
        Ra.sl[6]=320; /* line # 320 */
        ((C *)F_trg)[139]=42;
        Ra.sl[6]=321; /* line # 321 */
        Rv1=Rv0;
      }
      if (Rv1>=Rv0)  break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_string "  */
void P_st_put_string(V F_trg, V F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+126;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=334; /* line # 334 */
  Rv0=(SL)((C *)F_src)[140];
  Ra.sl[6]=335; /* line # 335 */
  if (Rv0>0) {
    Ra.sl[6]=336; /* line # 336 */
    Ra.sl[6]=338; /* line # 338 */
    Rv1=0;
    while (1){
      Ra.sl[6]=340; /* line # 340 */
      if (((C *)F_trg)[140]<132) {
        Ra.sl[6]=342; /* line # 342 */
        ((C *)F_trg)[140]=((C *)F_trg)[140]+1;
        Ra.sl[6]=343; /* line # 343 */
        Rv1=Rv1+1;
        Ra.sl[6]=344; /* line # 344 */
        ((C *)F_trg)[(SL)((C *)F_trg)[140]+7]=((C *)F_src)[Rv1+7];
      }
      else {
        Ra.sl[6]=348; /* line # 348 */
        ((C *)F_trg)[139]=42;
        Ra.sl[6]=349; /* line # 349 */
        Rv1=Rv0;
      }
      if (Rv1>=Rv0)  break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_ident "  */
void P_st_put_ident(V F_trg, V F_src, SL F_fld){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+141;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=364; /* line # 364 */
  Rv0=(SL)((C *)F_src)[0];
  Ra.sl[6]=365; /* line # 365 */
  Rv1=(SL)((C *)F_trg)[140];
  Ra.sl[6]=366; /* line # 366 */
  if (F_fld>132-Rv1) F_fld=132-Rv1;
  Ra.sl[6]=367; /* line # 367 */
  Ra.sl[6]=368; /* line # 368 */
  if (F_fld>=Rv0) {
    Ra.sl[6]=371; /* line # 371 */
    Rv2=F_fld-Rv0;
    Ra.sl[6]=372; /* line # 372 */
    if (Rv2>0) {
      Ra.sl[6]=374; /* line # 374 */
      Rv3=Rv2/2;
      Ra.sl[6]=375; /* line # 375 */
      P_st_put_mchar(F_trg,32, Rv3);
      Ra.sl[6]=376; /* line # 376 */
      Rv2=Rv2-Rv3;
    }
    Ra.sl[6]=378; /* line # 378 */
    Rv4=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      P_st_put_char(F_trg,((C *)F_src)[Rv4]);
      Rv4++;
    }
    Ra.sl[6]=379; /* line # 379 */
    if (Rv2>0) P_st_put_mchar(F_trg,32, Rv2);
  }
  else {
    Ra.sl[6]=383; /* line # 383 */
    Rv5=1;
    for( Rf0=F_fld-4;Rf0>0;Rf0-- ) {
      P_st_put_char(F_trg,((C *)F_src)[Rv5]);
      Rv5++;
    }
    Ra.sl[6]=384; /* line # 384 */
    Rv6=Rv0-4;
    for( Rf0=(Rv0+1)-(Rv0-4);Rf0>0;Rf0-- ) {
      P_st_put_char(F_trg,(C)((SL)((C *)F_src)[Rv6]+32));
      Rv6++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_wrt_float "  */
void P_st_wrt_float(F F_dv, SL F_ndig, SL F_pent, V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=401; /* line # 401 */
  Rv0=F_pent>1;
  Ra.sl[6]=403; /* line # 403 */
  F_dv=F_dv+(F)5.000000E-01*PAS__IFPOWER((F)1.000000E+01, -F_ndig);
  Ra.sl[6]=404; /* line # 404 */
  while (F_ndig>0){
    Ra.sl[6]=407; /* line # 407 */
    F_dv=F_dv*(F)1.000000E+01;
    Ra.sl[6]=408; /* line # 408 */
    Rv1=(int)(F_dv);
    Ra.sl[6]=409; /* line # 409 */
    if (Rv0&&Rv1==0) {
      Ra.sl[6]=410; /* line # 410 */
      P_st_put_char(F_st,32);
    }
    else {
      Ra.sl[6]=412; /* line # 412 */
      P_st_put_char(F_st,(C)(Rv1+48));
    }
    Ra.sl[6]=413; /* line # 413 */
    F_dv=F_dv-(float)Rv1;
    Ra.sl[6]=414; /* line # 414 */
    F_ndig=F_ndig-1;
    Ra.sl[6]=415; /* line # 415 */
    F_pent=F_pent-1;
    Ra.sl[6]=416; /* line # 416 */
    Rv0=0;
    Ra.sl[6]=418; /* line # 418 */
    if (F_pent==0&&F_ndig>0) P_st_put_char(F_st,46);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_b_int "  */
void P_st_put_b_int(V F_st, SL F_iv, SL F_ndig, SL F_base){
  /* Define the automatic variable space. */
  Blk( Ra, 96 );

  /* Local variable stored in C variable */
  C Rv0;
  UB Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+169;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=433; /* line # 433 */
  Rv0=32;
  Ra.sl[6]=434; /* line # 434 */
  if (F_iv==0) {
    Ra.sl[6]=436; /* line # 436 */
    Rv1=0;
    Ra.sl[6]=437; /* line # 437 */
    Ra.c[28]=48;
    Rv2=1;
  }
  else {
    Ra.sl[6]=441; /* line # 441 */
    if (F_iv<0) {
      Ra.sl[6]=443; /* line # 443 */
      Rv1=1;
      Ra.sl[6]=444; /* line # 444 */
      F_iv= -F_iv;
    }
    else {
      Ra.sl[6]=445; /* line # 445 */
      Rv1=0;
    }
    Ra.sl[6]=447; /* line # 447 */
    Rv2=0;
    Ra.sl[6]=448; /* line # 448 */
    while (F_iv>0){
      Ra.sl[6]=450; /* line # 450 */
      Rv2=Rv2+1;
      Ra.sl[6]=451; /* line # 451 */
      Rv3=PAS__I_MOD(F_iv,F_base);
      Ra.sl[6]=452; /* line # 452 */
      if (Rv3>9) {
        Ra.sl[6]=453; /* line # 453 */
        Ra.c[Rv2+27]=(C)((Rv3+65)-10);
      }
      else {
        Ra.sl[6]=455; /* line # 455 */
        Ra.c[Rv2+27]=(C)(Rv3+48);
      }
      Ra.sl[6]=456; /* line # 456 */
      F_iv=F_iv/F_base;
    }
  }
  Ra.sl[6]=459; /* line # 459 */
  if (F_ndig==0) {
    Ra.sl[6]=460; /* line # 460 */
    F_ndig=Rv2+(SL)Rv1;
  }
  else {
    Ra.sl[6]=462; /* line # 462 */
    if (F_ndig<0) {
      Ra.sl[6]=464; /* line # 464 */
      Rv0=48;
      F_ndig= -F_ndig;
    }
  }
  Ra.sl[6]=466; /* line # 466 */
  Rv4=F_ndig-Rv2;
  Ra.sl[6]=467; /* line # 467 */
  if (Rv1) Rv4=Rv4-1;
  Ra.sl[6]=468; /* line # 468 */
  if (Rv4>=0) {
    Ra.sl[6]=470; /* line # 470 */
    if (Rv1&&Rv0==48) P_st_put_char(F_st,45);
    Ra.sl[6]=471; /* line # 471 */
    P_st_put_mchar(F_st,Rv0, Rv4);
    Ra.sl[6]=472; /* line # 472 */
    if (Rv1&&Rv0==32) P_st_put_char(F_st,45);
    Ra.sl[6]=473; /* line # 473 */
    while (Rv2>0){
      Ra.sl[6]=475; /* line # 475 */
      P_st_put_char(F_st,Ra.c[Rv2+27]);
      Rv2=Rv2-1;
    }
  }
  else {
    Ra.sl[6]=479; /* line # 479 */
    P_st_put_mchar(F_st,42, F_ndig);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_int "  */
void P_st_put_int(V F_st, SL F_iv, SL F_ndig){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+183;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=487; /* line # 487 */
  P_st_put_b_int(F_st,F_iv, F_ndig,10);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_size_real "  */
UB P_st_size_real(SL *F_iexp, F *F_dv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Rgf;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+195;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=499; /* line # 499 */
  if ((*F_dv)<(F)0.000000E-01) {
    Ra.sl[6]=501; /* line # 501 */
    (*F_dv)= -(*F_dv);
    Ra.sl[6]=502; /* line # 502 */
    Ret=1;
  }
  else {
    Ra.sl[6]=504; /* line # 504 */
    Ret=0;
  }
  Ra.sl[6]=505; /* line # 505 */
  if ((*F_dv)>(F)0.000000E-01) {
    Ra.sl[6]=507; /* line # 507 */
    Rv0=(float)((double)log((*F_dv))/2.302585119999999E+000);
    Ra.sl[6]=508; /* line # 508 */
    (*F_iexp)=PAS__F_ROUND(Rv0-(F)5.000000E-01);
    Ra.sl[6]=509; /* line # 509 */
    if (Rv0-(float)(*F_iexp)>=(F)9.997000E-01) (*F_iexp)=(*F_iexp)+1;
  }
  else {
    Ra.sl[6]=511; /* line # 511 */
    (*F_iexp)=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " st_put_float "  */
void P_st_put_float(V F_st, F F_dv, SL F_fs, SL F_intsz, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  C Rv2;
  C Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+209;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=525; /* line # 525 */
  F_es=abs(F_es);
  Ra.sl[6]=527; /* line # 527 */
  if (F_dcsz==0) F_dcsz=7;
  else F_dcsz=abs(F_dcsz);
  Ra.sl[6]=528; /* line # 528 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[6]=529; /* line # 529 */
  if (F_fs<0) F_fs=abs(F_fs);
  Ra.sl[6]=530; /* line # 530 */
  if (F_intsz<1) F_intsz=1;
  Ra.sl[6]=532; /* line # 532 */
  Rv0=P_st_size_real(&Rv1, &F_dv);
  Ra.sl[6]=535; /* line # 535 */
  if (F_dv!=(F)0.000000E-01) {
    Ra.sl[6]=536; /* line # 536 */
    F_dv=F_dv/PAS__IFPOWER((F)1.000000E+01,Rv1+1);
  }
  Ra.sl[6]=538; /* line # 538 */
  Rv1=(Rv1-F_intsz)+1;
  Ra.sl[6]=540; /* line # 540 */
  if (Rv0) Rv2=45;
  else Rv2=32;
  Ra.sl[6]=542; /* line # 542 */
  if (Rv1>=0) Rv3=43;
  else {
    Ra.sl[6]=545; /* line # 545 */
    Rv1= -Rv1;
    Rv3=45;
  }
  Ra.sl[6]=548; /* line # 548 */
  if (Rv1<10) Rv4=1;
  else {
    Ra.sl[6]=549; /* line # 549 */
    if (Rv1<100) Rv4=2;
    else Rv4=3;
  }
  Ra.sl[6]=551; /* line # 551 */
  if (Rv4>F_es) F_es=Rv4;
  Ra.sl[6]=553; /* line # 553 */
  Rv5=(((F_fs-F_dcsz)-F_es)-F_intsz)-4;
  Ra.sl[6]=554; /* line # 554 */
  if (F_dcsz==0) Rv5=Rv5+1;
  Ra.sl[6]=555; /* line # 555 */
  if (Rv5<0) {
    Ra.sl[6]=557; /* line # 557 */
    while (F_es>Rv4&&Rv5<0){
      Ra.sl[6]=559; /* line # 559 */
      F_es=F_es-1;
      Rv5=Rv5+1;
    }
    Ra.sl[6]=562; /* line # 562 */
    if (Rv5<0&&Rv3==43) {
      Ra.sl[6]=564; /* line # 564 */
      Rv5=Rv5+1;
      Rv3=32;
      F_es=F_es-1;
    }
    Ra.sl[6]=567; /* line # 567 */
    if (Rv5<0&&!Rv0) {
      Ra.sl[6]=569; /* line # 569 */
      Rv2=43;
      Rv5=Rv5+1;
    }
    Ra.sl[6]=572; /* line # 572 */
    if (Rv5<0&&F_dcsz>0) {
      Ra.sl[6]=574; /* line # 574 */
      Rv6=Rv5+F_dcsz;
      Ra.sl[6]=575; /* line # 575 */
      if (Rv6>0) {
        Ra.sl[6]=577; /* line # 577 */
        F_dcsz=Rv6;
        Rv5=0;
      }
      else {
        Ra.sl[6]=580; /* line # 580 */
        if (Rv6==-1&&F_dcsz>0) {
          Ra.sl[6]=582; /* line # 582 */
          F_dcsz=0;
          Rv5=0;
        }
      }
    }
  }
  Ra.sl[6]=586; /* line # 586 */
  if (Rv5<0) {
    Ra.sl[6]=587; /* line # 587 */
    P_st_put_mchar(F_st,42, F_fs);
  }
  else {
    Ra.sl[6]=590; /* line # 590 */
    P_st_put_mchar(F_st,32, Rv5);
    Ra.sl[6]=592; /* line # 592 */
    if (Rv2!=43) P_st_put_char(F_st,Rv2);
    Ra.sl[6]=594; /* line # 594 */
    P_st_wrt_float(F_dv, F_dcsz+F_intsz, F_intsz, F_st);
    Ra.sl[6]=596; /* line # 596 */
    P_st_put_char(F_st,69);
    Ra.sl[6]=598; /* line # 598 */
    if (Rv3!=32) P_st_put_char(F_st,Rv3);
    Ra.sl[6]=600; /* line # 600 */
    P_st_put_int(F_st,Rv1, -F_es);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " st_put_fixed "  */
void P_st_put_fixed(V F_st, F F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  UB Rv1;
  SL Rv2;
  C Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+223;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=618; /* line # 618 */
  if (F_dcsz==0) F_dcsz=7;
  else {
    Ra.sl[6]=619; /* line # 619 */
    F_dcsz=abs(F_dcsz);
  }
  Ra.sl[6]=620; /* line # 620 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[6]=621; /* line # 621 */
  if (F_fs<0) F_fs=abs(F_fs);
  Ra.sl[6]=622; /* line # 622 */
  if (F_dcmin<1) F_dcmin=1;
  Ra.sl[6]=624; /* line # 624 */
  Rv0=F_dv;
  Ra.sl[6]=625; /* line # 625 */
  Rv1=P_st_size_real(&Rv2, &Rv0);
  Ra.sl[6]=627; /* line # 627 */
  if (Rv1) Rv3=45;
  else {
    Ra.sl[6]=628; /* line # 628 */
    Rv3=32;
  }
  Ra.sl[6]=630; /* line # 630 */
  if (Rv2>0) Rv4=Rv2+1;
  else {
    Ra.sl[6]=631; /* line # 631 */
    Rv4=1;
  }
  Ra.sl[6]=633; /* line # 633 */
  Rv5=((F_fs-2)-F_dcsz)-Rv4;
  Ra.sl[6]=635; /* line # 635 */
  Rv6=(F_dcsz+Rv2)+1;
  Ra.sl[6]=636; /* line # 636 */
  Rv7=F_dcsz;
  Ra.sl[6]=637; /* line # 637 */
  if (Rv2<0&&Rv6<F_dcmin) {
    Ra.sl[6]=639; /* line # 639 */
    Rv7=( -Rv2+F_dcmin)-1;
    Ra.sl[6]=640; /* line # 640 */
    Rv5=(F_fs-3)-Rv7;
    Ra.sl[6]=641; /* line # 641 */
    if (Rv5<0) {
      Ra.sl[6]=642; /* line # 642 */
      if (!Rv1&&Rv5==-1) {
        Ra.sl[6]=644; /* line # 644 */
        Rv5=0;
        Rv3=43;
      }
      else {
        Ra.sl[6]=647; /* line # 647 */
        P_st_put_float(F_st,F_dv, F_fs,1, F_dcsz,0);
      }
    }
  }
  else {
    Ra.sl[6]=651; /* line # 651 */
    if (Rv5<0) {
      Ra.sl[6]=652; /* line # 652 */
      if (!Rv1) {
        Ra.sl[6]=654; /* line # 654 */
        Rv3=43;
        Ra.sl[6]=655; /* line # 655 */
        Rv5=Rv5+1;
      }
    }
    Ra.sl[6]=657; /* line # 657 */
    if (Rv5<0) {
      Ra.sl[6]=659; /* line # 659 */
      Rv6=Rv5+Rv7;
      Ra.sl[6]=660; /* line # 660 */
      if (Rv6>=0) {
        Ra.sl[6]=662; /* line # 662 */
        Rv7=Rv6;
        Ra.sl[6]=663; /* line # 663 */
        if (Rv7>0) Rv5=0;
        else {
          Ra.sl[6]=664; /* line # 664 */
          Rv5=1;
        }
      }
      else {
        Ra.sl[6]=667; /* line # 667 */
        if (Rv6==-1) {
          Ra.sl[6]=669; /* line # 669 */
          Rv7=0;
          Rv5=0;
        }
      }
      Ra.sl[6]=672; /* line # 672 */
      if (Rv5<0) P_st_put_float(F_st,F_dv, F_fs,1, F_dcsz,0);
    }
  }
  Ra.sl[6]=675; /* line # 675 */
  if (Rv5>=0) {
    Ra.sl[6]=678; /* line # 678 */
    P_st_put_mchar(F_st,32, Rv5);
    Ra.sl[6]=680; /* line # 680 */
    if (Rv3!=43) P_st_put_char(F_st,Rv3);
    Ra.sl[6]=682; /* line # 682 */
    if (Rv0!=(F)0.000000E-01) {
      Ra.sl[6]=683; /* line # 683 */
      Rv0=Rv0/PAS__IFPOWER((F)1.000000E+01,Rv4);
    }
    Ra.sl[6]=685; /* line # 685 */
    P_st_wrt_float(Rv0, Rv4+Rv7, Rv4, F_st);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_page "  */
void P_out_page(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+237;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=707; /* line # 707 */
  PAS__PAGE((*F_f));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_date "  */
void P_get_date(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+247;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=715; /* line # 715 */
  PAS__DATE_CHT(F_st,11);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_time "  */
void P_get_time(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+257;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=723; /* line # 723 */
  PAS__TIME_CHT(F_st,11);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_newlinelst "  */
void P_put_newlinelst(V F_title){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+267;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=734; /* line # 734 */
  P_out_page(&V_lst);
  Ra.sl[6]=735; /* line # 735 */
  V_linewrt=0;
  Ra.sl[6]=736; /* line # 736 */
  V_pagenb=V_pagenb+1;
  Ra.sl[6]=737; /* line # 737 */
  P_get_date(Ra.s+28);
  P_get_time(Ra.s+39);
  Ra.sl[6]=738; /* line # 738 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(F_title,60,-1,32);
  PAS__WRITE_STR(Rd.s+283,-1,-1,32);
  PAS__WRITE_CHT(Ra.s+28,11,-1,-1,32);
  PAS__WRITE_STR(Rd.s+294,-1,-1,32);
  PAS__WRITE_CHT(Ra.s+39,11,-1,-1,32);
  PAS__WRITE_FCHAR(32,5,-1,1,32);
  PAS__WRITE_STR(Rd.s+300,-1,-1,32);
  PAS__WRITE_INT(V_pagenb,3,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outerrmsgline "  */
void P_outerrmsgline(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );


  /* Code of procedure/function */
  Ra.ub[0]=80;
  Ra.v[11]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+88;
  Ra.v[12]=Rd.s+307;
  Ra.v[13]=Rd.s+6;
  Ra.sl[28]=751; /* line # 751 */
  PAS__ERROR_GETMSG(F_n, Ra.s,V_errmsgspecif.s);
  Ra.sl[28]=752; /* line # 752 */
  if (Ra.ub[1]>0) {
    Ra.sl[28]=754; /* line # 754 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+322,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[28]=755; /* line # 755 */
    V_linewrt=V_linewrt+1;
  }
  PAS__curr_cntx=Ra.v[11];
}


/* Procedure/Function : " open_listing "  */
void P_open_listing(V *F_f, V F_fname, SL F__Sz, SL F_mdflg){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  UL Rv0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+336;
  Ra.v[35]=Rd.s+6;
  Ra.sl[72]=771; /* line # 771 */
  PAS__CHT_TO_STR(Ra.s,F_fname,F__Sz);
  Ra.sl[72]=772; /* line # 772 */
  Rv0=69634;
  Ra.sl[72]=773; /* line # 773 */
  if (F_mdflg==2) Rv0=Rv0|4;
  Ra.sl[72]=774; /* line # 774 */
  PAS__OPEN(F_f,0, Ra.s,Rv0,0,-1);
  Ra.sl[72]=775; /* line # 775 */
  if (PAS__iostatus!=0) {
    Ra.sl[72]=777; /* line # 777 */
    PAS__SELECT_OUT(PAS__f_error);
    PAS__WRITE_STR(Rd.s+350,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_EOLN();
    Ra.sl[72]=778; /* line # 778 */
    PAS__ERROR(PAS__iostatus);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " openw_txtfile "  */
void P_openw_txtfile(V *F_f, V F_fname, SL F_mdflg){
  /* Define the automatic variable space. */
  Blk( Ra, 168 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  UL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=132;
  Ra.v[17]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+136;
  Ra.v[18]=Rd.s+398;
  Ra.v[19]=Rd.s+6;
  Ra.sl[40]=792; /* line # 792 */
  if (F_fname!=NULL) {
    Ra.sl[40]=793; /* line # 793 */
    Rv0=F_fname;
    Ra.sl[40]=795; /* line # 795 */
    Ra.ub[1]=(SL)((C *)Rv0)[140];
    Ra.sl[40]=796; /* line # 796 */
    Rv1=1;
    for( Rf0=(SL)((C *)Rv0)[140];Rf0>0;Rf0-- ) {
      Ra.c[Rv1+1]=((C *)Rv0)[Rv1+7];
      Rv1++;
    }
  }
  Ra.sl[40]=798; /* line # 798 */
  Rv2=69634;
  Ra.sl[40]=799; /* line # 799 */
  if (F_mdflg==2) Rv2=Rv2|4;
  Ra.sl[40]=800; /* line # 800 */
  PAS__OPEN(F_f,0, Ra.s,Rv2,0,-1);
  Ra.sl[40]=801; /* line # 801 */
  if (PAS__iostatus!=0) {
    Ra.sl[40]=803; /* line # 803 */
    PAS__SELECT_OUT(PAS__f_error);
    PAS__WRITE_STR(Rd.s+413,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_EOLN();
    Ra.sl[40]=804; /* line # 804 */
    PAS__ERROR(PAS__iostatus);
  }
  PAS__curr_cntx=Ra.v[17];
}


/* Procedure/Function : " close_txtfile "  */
void P_close_txtfile(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+462;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=814; /* line # 814 */
  PAS__CLOSE(F_f,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " open_input_txtfile "  */
void P_open_input_txtfile(V *F_f, V F_fname, UB *F_bok, UB *F_bprt, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 168 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=132;
  Ra.v[17]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+136;
  Ra.v[18]=Rd.s+477;
  Ra.v[19]=Rd.s+6;
  Ra.sl[40]=834; /* line # 834 */
  if (F_fname!=NULL) {
    Ra.sl[40]=835; /* line # 835 */
    Rv0=F_fname;
    Ra.sl[40]=837; /* line # 837 */
    (*F_bprt)=0;
    Ra.sl[40]=838; /* line # 838 */
    Rv1=4097;
    Ra.sl[40]=839; /* line # 839 */
    if (!V_majorfmode) Rv1=Rv1|65536;
    Ra.sl[40]=840; /* line # 840 */
    Ra.ub[1]=(SL)((C *)Rv0)[140];
    Ra.sl[40]=841; /* line # 841 */
    Rv2=1;
    for( Rf0=(SL)((C *)Rv0)[140];Rf0>0;Rf0-- ) {
      Ra.c[Rv2+1]=((C *)Rv0)[Rv2+7];
      Rv2++;
    }
    Ra.sl[40]=842; /* line # 842 */
    PAS__OPEN(F_f,0, Ra.s,Rv1,0,-1);
    Ra.sl[40]=843; /* line # 843 */
    (*F_ierr)=PAS__iostatus;
    Ra.sl[40]=844; /* line # 844 */
    if ((*F_ierr)==0) {
      Ra.sl[40]=846; /* line # 846 */
      (*F_bprt)=PAS__TTY_FILE((*F_f));
      Ra.sl[40]=847; /* line # 847 */
      (*F_bok)=1;
    }
    else {
      Ra.sl[40]=851; /* line # 851 */
      (*F_bok)=0;
      Ra.sl[40]=852; /* line # 852 */
      if ((*F_ierr)==202||(*F_ierr)==204) (*F_ierr)=-1;
      else {
        Ra.sl[40]=853; /* line # 853 */
        (*F_ierr)=(*F_ierr)+2000;
      }
    }
  }
  PAS__curr_cntx=Ra.v[17];
}


/* Procedure/Function : " cpu_clock "  */
SL P_cpu_clock(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register G Rgg;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+497;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=862; /* line # 862 */
  Ret=PAS__G_ROUND(PAS__CLOCK());
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " open_ddifile "  */
UB P_open_ddifile(V *F_f, V F_spc, UB F_wrt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+508;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=874; /* line # 874 */
  if (F_wrt) {
    Ra.sl[6]=875; /* line # 875 */
    PAS__OPEN(F_f,76, F_spc,2,0,-1);
  }
  else {
    Ra.sl[6]=877; /* line # 877 */
    PAS__OPEN(F_f,76, F_spc,4097,0,-1);
  }
  Ra.sl[6]=878; /* line # 878 */
  Rv0=PAS__iostatus==0;
  Ra.sl[6]=879; /* line # 879 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " close_ddifile "  */
void P_close_ddifile(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+522;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=886; /* line # 886 */
  PAS__CLOSE(F_f,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " open_bdtfile "  */
void P_open_bdtfile(V *F_f, V F_spc){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );


  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+537;
  Ra.v[35]=Rd.s+6;
  Ra.sl[72]=897; /* line # 897 */
  PAS__CHT_TO_STR(Ra.s,F_spc+8,132);
  Ra.sl[72]=898; /* line # 898 */
  PAS__OPEN(F_f,128, Ra.s,2,0,-1);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " openr_bdtfile "  */
UB P_openr_bdtfile(V *F_f, V F_spc){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+551;
  Ra.v[35]=Rd.s+6;
  Ra.sl[72]=908; /* line # 908 */
  PAS__CHT_TO_STR(Ra.s,F_spc+8,132);
  Ra.sl[72]=909; /* line # 909 */
  PAS__OPEN(F_f,128, Ra.s,4097,0,-1);
  Ra.sl[72]=910; /* line # 910 */
  Ret=PAS__iostatus==0;
  PAS__curr_cntx=Ra.v[33];
  return(Ret);
}


/* Procedure/Function : " close_bdtfile "  */
void P_close_bdtfile(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+566;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=917; /* line # 917 */
  PAS__CLOSE(F_f,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " open_bcffile "  */
void P_open_bcffile(V *F_f, V F_spc){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );


  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+581;
  Ra.v[35]=Rd.s+6;
  Ra.sl[72]=927; /* line # 927 */
  PAS__CHT_TO_STR(Ra.s,F_spc+8,132);
  Ra.sl[72]=928; /* line # 928 */
  PAS__OPEN(F_f,32, Ra.s,2,0,-1);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " close_bcffile "  */
void P_close_bcffile(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+595;
  Ra.v[2]=Rd.s+6;
  Ra.sl[6]=935; /* line # 935 */
  PAS__CLOSE(F_f,0);
  PAS__curr_cntx=Ra.v[0];
}
