/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[11];

/* Define the local data section. */
static Blk( Rd, 4288 ) = {
 10,  10, 110, 101, 119, 108, 105, 110, 101, 108, 115, 116,  47,  47,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 109, 120, 100,  95, 115, 114,
 99,  47, 109, 120, 100,  95,  99, 109, 112,  46, 112,  97, 115,  60,  60,  32,
 77,  32,  88,  32,  68,  32,  67,  32,  77,  32,  80,  32,  32,  45,  32,  80,
 46,  87, 111, 108, 102, 101, 114, 115,  32,  83, 111, 102, 116, 119,  97, 114,
101,  58,  32,  77,  88,  68,  32,  86,  51,  46,  57,  45,  69,  32, 111, 102,
 32,  48,  49,  45,  74,  85,  76,  45,  57,  56,  32,   5,   5,  32,  42,  42,
 42,  32,   4,   4,  32,  42,  42,  42,  29,  29,  32,  67, 117, 114, 114, 101,
110, 116,  32, 115, 111, 117, 114,  99, 101,  32, 105, 110, 112, 117, 116,  32,
102, 105, 108, 101,  32,  58,  32,  10,  10, 111, 117, 116, 115, 114,  99, 108,
105, 115, 116,   6,   6,  32,  32,  32,  32,  77,  43,   6,   6,  32,  32,  32,
 32,  80,  43,   5,   5, 101, 114, 114, 111, 114,   6,   6,  32,  70,  65,  84,
 65,  76,   7,   7,  32,  69,  82,  82,  79,  82,  32,   2,   2,  32,  35,   4,
  4,  32,  97, 116,  32,   2,   2,  34,  32,  11,  11, 115, 116,  97, 116, 101,
109, 101, 110, 116,  32,  35,  17,  17,  32,  32,  32, 105, 110,  32, 116, 104,
101,  32, 102, 105, 108, 101,  32,  58,  32,  14,  14,  32,  97, 116,  32, 116,
104, 101,  32, 108, 105, 110, 101,  32,  35,   4,   4,  77,  65,  88,  69,  12,
 12, 114, 101, 115, 101, 116, 116, 120, 116, 102, 105, 108, 101,   4,   4,  79,
 80,  69,  78,  10,  10, 108, 115, 116, 102, 105, 108, 101, 115, 112,  99,  30,
 30,  84, 104, 101,  32, 105, 110, 112, 117, 116,  32, 115, 111, 117, 114,  99,
101,  32, 102, 105, 108, 101,  32, 105, 115,  32, 110, 111, 119,  32,  58,   7,
  7, 114, 100,  95, 108, 105, 110, 101,   5,   5,  32,  77,  88,  68,  62,   4,
  4,  71,  76,  73,  78,   8,   8, 103, 101, 116,  95, 108, 105, 110, 101,   5,
  5, 109,  97, 116,  99, 104,   6,   6, 110, 101, 119, 105, 100, 101,   4,   4,
 78,  69,  87,  73,   8,   8, 115, 101,  97, 114,  99, 104, 105, 100,   7,   7,
110, 101, 119, 100, 102, 116,  98,   4,   4,  78,  69,  87,  84,   7,   7, 102,
114, 101, 100, 102, 116,  98,  10,  10, 115, 101, 116, 110, 101, 119, 102, 102,
114, 109,   8,   8, 102, 114, 101, 101, 116, 101, 120, 116,   7,   7, 102, 114,
101, 101, 105, 100, 101,   8,   8, 115,  97, 118, 101,  99, 110, 116, 120,   4,
  4,  83,  65,  86,  67,   9,   9, 114, 101, 115, 101, 116,  99, 110, 116, 120,
  8,   8, 110, 101, 119, 115,  99, 111, 112, 101,   4,   4,  83,  67,  79,  80,
  8,   8, 114, 101, 108, 115,  99, 111, 112, 101,   7,   7, 103, 101, 116,  99,
104,  97, 114,   5,   5, 105, 110,  99, 104,  97,   7,   7,  99, 111, 109, 109,
101, 110, 116,   6,   6, 105, 110,  99, 104,  97, 114,   7,   7, 112, 117, 116,
 99, 104,  97, 114,   9,   9, 115, 107, 105, 112, 115, 112,  97,  99, 101,   6,
  6, 110, 101, 120, 116,  99, 104,   8,   8, 105, 110, 115, 121, 109,  98, 111,
108,   4,   4,  73,  78,  83,  89,   8,   8,  32,  32,  32,  32,  32,  32,  32,
 32,   8,   8,  32,  32,  32,  32,  32,  32,  32,  32,   7,   7, 105, 110, 112,
 97, 114,  97, 109,   8,   8, 105, 110, 109,  97,  99, 116, 120, 116,   4,   4,
 73,  78,  77,  65,   7,   7, 105, 110, 109,  97,  99, 114, 111,  12,  12,  97,
 99, 116, 105, 118, 101, 109,  97,  99, 112,  97, 114,   4,   4, 115, 107, 105,
112,  10,  10, 108, 111, 111, 107, 115, 121, 109,  98, 111, 108,   4,   4,  76,
 79,  79,  75,   6,   6, 105, 110, 100,  97, 116,  97,   4,   4,  73,  78,  68,
 65,   8,   8, 115, 101, 116, 107, 119, 111, 114, 100,   8,   8, 105, 110, 105,
116,  97,  98, 108, 101,   3,   3,  76,  79,  71,   3,   3,  69,  88,  80,   3,
  3,  83,  73,  78,   3,   3,  67,  79,  83,   4,   4,  83,  81,  82,  84,   3,
  3,  84,  65,  78,   4,   4,  65,  84,  65,  78,   4,   4,  65,  83,  73,  78,
  4,   4,  65,  67,  79,  83,   4,   4,  84,  65,  78,  72,   8,   8,  66,  69,
 83,  83,  69,  76,  95,  74,   6,   6,  83,  69,  76,  69,  67,  84,   6,   6,
 73,  78,  84,  83,  69,  76,   7,   7,  73,  84,  69,  77,  80,  65,  82,   6,
  6,  83,  85,  66,  83,  84,  82,   4,   4,  83,  85,  77,  77,   6,   6,  83,
 85,  77,  72,  75,  76,   6,   6,  83,  84,  82,  73,  78,  71,   6,   6,  76,
 69,  78,  71,  84,  72,   5,   5,  73,  78,  68,  69,  88,   6,   6,  78,  73,
 78,  68,  69,  88,   6,   6,  78,  85,  77,  66,  69,  82,   3,   3,  65,  66,
 83,   5,   5,  82,  79,  85,  78,  68,   6,   6,  77,  79,  68,  85,  76,  79,
 10,  10,  83,  89,  83,  95,  71,  69,  84,  69,  78,  86,   7,   7,  68,  69,
 70,  73,  78,  69,  68,   8,   8,  80,  65,  82,  65,  77,  82,  69,  70,   6,
  6,  80,  82,  65,  71,  77,  65,   6,   6,  82,  69,  80,  69,  65,  84,   5,
  5,  85,  78,  84,  73,  76,   5,   5,  77,  65,  67,  82,  79,   5,   5,  80,
 85,  82,  71,  69,   2,   2,  73,  70,   4,   4,  84,  72,  69,  78,   4,   4,
 69,  76,  83,  69,   3,   3,  69,  78,  68,   5,   5,  69,  78,  68,  73,  70,
  8,   8,  69,  78,  68,  77,  65,  67,  82,  79,   5,   5,  66,  69,  71,  73,
 78,   7,   7,  73,  78,  67,  76,  85,  68,  69,   6,   6,  67,  72,  65,  73,
 78,  69,   8,   8,  77,  65,  67,  82,  79,  76,  73,  66,   9,   9,  77,  65,
 67,  82,  79,  67,  65,  76,  76,   8,   8,  70,  85,  78,  67,  84,  73,  79,
 78,   4,   4,  67,  69,  76,  76,   5,   5,  82,  67,  69,  76,  76,   6,   6,
 83,  89,  77,  84,  82,  89,   6,   6,  67,  69,  78,  84,  69,  82,   8,   8,
 68,  69,  66,  89,  69,  95,  77,  68,   4,   4,  68,  65,  84,  65,   5,   5,
 80,  65,  82,  65,  77,   8,   8,  86,  65,  82,  73,  65,  66,  76,  69,   5,
  5,  70,  73,  88,  69,  68,   7,   7,  85,  78,  70,  73,  88,  69,  68,   7,
  7,  76,  65,  84,  84,  73,  67,  69,   6,   6,  76,  73,  77,  73,  84,  83,
  4,   4,  65,  84,  79,  77,   5,   5,  67,  65,  84,  79,  77,   6,   6,  77,
 79,  77,  69,  78,  84,   6,   6,  77,  68,  83,  68,  83,  80,  12,  12,  67,
 79,  78,  84,  82,  73,  66,  85,  84,  73,  79,  78,   7,   7,  67,  76,  82,
 68,  65,  84,  65,   8,   8,  76,  83,  81,  66,  76,  79,  67,  75,   8,   8,
 70,  70,  65,  83,  83,  73,  71,  78,   6,   6,  79,  80,  84,  73,  79,  78,
  8,   8,  87,  65,  86,  69,  86,  69,  67,  84,   8,   8,  78,  80,  79,  76,
 65,  68,  73,  82,   8,   8,  77,  65,  71,  78,  69,  84,  73,  67,   7,   7,
 83,  79,  80,  84,  73,  79,  78,   7,   7,  69,  78,  68,  70,  73,  76,  69,
  8,   8,  71,  69,  78,  83,  80,  65,  67,  69,   5,   5,  69,  82,  82,  79,
 82,   8,   8,  87,  82,  73,  84,  69,  77,  83,  71,   7,   7,  68,  73,  83,
 80,  76,  65,  89,   5,   5,  82,  69,  80,  76,  89,   8,   8,  79,  80,  69,
 78,  70,  73,  76,  69,   5,   5,  87,  82,  73,  84,  69,   7,   7,  87,  82,
 73,  84,  69,  76,  78,   4,   4,  82,  69,  65,  68,   9,   9,  67,  76,  79,
 83,  69,  70,  73,  76,  69,   7,   7,  76,  73,  83,  84,  73,  78,  71,  12,
 12,  82,  85,  78,  95,  77,  88,  68,  95,  65,  80,  80,  76,   9,   9,  83,
 89,  83,  95,  83,  80,  65,  87,  78,   3,   3,  65,  78,  68,   2,   2,  79,
 82,   3,   3,  78,  79,  84,   2,   2,  36,  72,   2,   2,  36,  75,   2,   2,
 36,  76,   3,   3,  36,  82,  72,   3,   3,  36,  82,  75,   3,   3,  36,  82,
 76,   7,   7,  36,  83,  73,  84,  72,  83,  76,   3,   3,  36,  72,  88,   3,
  3,  36,  72,  89,   3,   3,  36,  72,  90,   3,   3,  36,  81,  88,   3,   3,
 36,  81,  89,   3,   3,  36,  81,  90,   3,   3,  36,  72,  72,   3,   3,  36,
 75,  75,   3,   3,  36,  76,  76,   3,   3,  36,  83,  72,   3,   3,  36,  83,
 75,   3,   3,  36,  83,  76,   4,   4,  36,  79,  66,  83,   4,   4,  36,  83,
 73,  71,   7,   7,  36,  87,  69,  73,  71,  72,  84,   5,   5,  36,  67,  65,
 76,  67,   4,   4,  36,  70,  78,  50,   4,   4,  36,  70,  77,  50,   7,   7,
 36,  70,  50,  80,  79,  76,  65,   6,   6,  36,  78,  80,  79,  76,  65,   6,
  6,  36,  76,  67,  72,  73,  50,   6,   6,  36,  67,  67,  72,  73,  50,   6,
  6,  36,  76,  77,  65,  88,  70,   6,   6,  36,  67,  77,  65,  88,  70,   4,
  4,  36,  70,  78,  82,   4,   4,  36,  70,  78,  73,   5,   5,  36,  70,  77,
 88,  82,   5,   5,  36,  70,  77,  89,  82,   5,   5,  36,  70,  77,  90,  82,
  5,   5,  36,  70,  77,  88,  73,   5,   5,  36,  70,  77,  89,  73,   5,   5,
 36,  70,  77,  90,  73,  11,  11, 100, 101, 102, 115, 116, 114,  99, 111, 110,
115, 116,   8,   8, 100, 101, 102, 110, 119,  99, 116, 101,  10,  10, 103, 101,
110, 115, 121, 115, 112,  97, 114, 109,   4,   4, 105, 110, 105, 116,  18,  18,
 77,  88,  68,  76,  73,  66,  58, 109, 120, 100,  95,  99, 109, 112,  46, 101,
114, 114,   3,   3, 110, 108,  58,  12,  12, 109, 120, 100, 105, 110, 116,  46,
116, 109, 112,  46,  49,  18,  18,  77,  88,  68,  76,  73,  66,  58, 109, 120,
100,  95, 101, 110, 118,  46, 115, 116, 100,  18,  18,  32,  77,  88,  68,  32,
 99,  97, 110, 110, 111, 116,  32, 111, 112, 101, 110,  32,  34,  36,  36,  32,
 61,  62,  32,  77,  88,  68,  32, 110, 111, 116,  32, 105, 110, 105, 116, 105,
 97, 108, 105, 122, 101, 100,  32,  61,  62,  32,  83,  84,  79,  80,  32,  77,
 88,  68,  46,  17,  17,  77,  88,  68,  76,  73,  66,  58, 109, 120, 100, 108,
105,  98,  46, 109, 120, 108,   7,   7,  36,  83,  84,  65,  84,  85,  83,   9,
  9, 112, 117, 116, 114, 101, 102, 105, 116, 109,   4,   4,  80,  85,  84,  82,
  9,   9,  99, 111, 110,  99,  97, 116, 115, 116, 114,   4,   4,  67,  83,  84,
 82,   6,   6, 101, 120, 116, 101, 110, 100,   6,   6,  99, 109, 112, 115, 116,
114,   7,   7,  99, 111, 112, 121, 115, 116, 114,   6,   6, 115, 117,  98, 115,
116, 114,   5,   5, 105, 110, 100, 101, 120,   6,   6, 110, 105, 110, 100, 101,
120,   8,   8, 105, 110, 115, 116, 114, 105, 110, 103,   8,   8, 105, 110, 110,
117, 109,  98, 101, 114,   4,   4,  73,  78,  67,  86,   6,   6,  97, 114,  99,
115, 105, 110,   4,   4,  65,  83,  73,  78,   8,   8, 112, 104,  97, 115, 101,
 97, 114, 103,   8,   8, 110, 120, 116, 112, 111, 105, 110, 116,   8,   8, 105,
110, 116, 101, 114, 112, 111, 108,   4,   4,  73,  78,  84,  69,   7,   7,  99,
111, 110, 118, 105, 110, 116,   7,   7,  99, 111, 110, 118, 115, 116, 114,  10,
 10, 103, 101, 116, 101, 110, 118, 115, 121, 109,  98,   4,   4, 112, 117, 115,
104,   4,   4,  69,  88,  80,  82,   3,   3, 112, 111, 112,   5,   5, 105, 110,
105, 110, 116,   7,   7, 116, 101, 115, 116,  98, 105, 110,   7,   7, 116, 101,
115, 116, 117, 110,  97,   7,   7, 112, 117, 116, 105, 116, 101, 109,   8,   8,
112, 117, 115, 104, 122, 101, 114, 111,   9,   9, 115, 101, 116, 115, 117,  98,
115, 116, 114,   8,   8, 115, 116, 111, 112, 101, 120, 112, 114,   7,   7, 103,
101, 116, 105, 116, 101, 109,  13,  13, 115, 117,  98, 101, 120, 112, 114, 101,
115, 115, 105, 111, 110,  10,  10, 101, 120, 112, 114, 101, 115, 115, 105, 111,
110,  11,  11, 105, 110, 112, 117, 116, 108, 101, 116, 116, 101, 114,  12,  12,
103, 101, 116, 112, 104, 121, 115, 112,  97, 114,  97, 109,  15,  15, 118,  97,
108, 117, 101, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,   7,   7, 103,
101, 116, 105,  99, 116, 101,   4,   4,  71,  73,  78,  84,   7,   7, 103, 101,
116, 110,  99, 116, 101,   4,   4,  71,  78,  67,  84,   8,   8, 103, 101, 116,
118,  97, 114,  98, 108,   4,   4,  71,  86,  65,  82,   7,   7, 103, 101, 116,
115,  99, 116, 101,   4,   4,  71,  83,  84,  82,  11,  11, 108, 111, 111, 107,
115, 101, 109, 105,  99, 111, 108,   4,   4,  76,  83,  69,  77,   9,   9, 116,
114,  97, 110, 115, 118, 101,  99, 116,  10,  10, 110, 101, 119, 112, 104, 121,
115, 105, 116, 109,   4,   4,  71,  73,  84,  77,  14,  14, 100, 101,  99, 108,
 97, 114, 101, 115, 112, 101,  99, 105,  97, 108,   4,   4,  68,  67,  76,  83,
 15,  15, 100, 101,  99, 108,  97, 114, 101, 110, 101, 119, 105, 100, 101, 110,
116,   4,   4,  68,  67,  76,  73,  11,  11, 102, 111, 114, 102, 117, 110, 109,
 97, 116,  99, 104,   8,   8, 117, 115, 101, 114,  99,  97, 108, 108,   4,   4,
 85,  67,  65,  76,   8,   8,  99,  97, 108, 108, 102, 117, 110,  99,   4,   4,
 67,  65,  76,  76,   3,   3, 118,  97, 108,   4,   4,  86,  65,  76,  85,   9,
  9, 103, 101, 116, 110, 117, 109,  98, 101, 114,   4,   4,  71,  78,  66,  82,
 11,  11, 112, 114,  97, 103, 109,  97, 115, 116,  97, 116, 101,   4,   4,  80,
 82,  71,  77,  10,  10, 112, 117, 116, 114,  97, 110, 115, 111, 112, 101,   2,
  2,  32,  49,   9,   9, 111, 117, 116, 110, 119, 108, 105, 110, 101,   9,   9,
102, 111, 114, 109,  97, 108, 100, 101, 102,  11,  11, 102, 117, 110,  99, 116,
105, 111, 110, 100, 101, 102,  13,  13, 102, 117, 110,  99, 116, 105, 111, 110,
115, 116,  97, 116, 101,  11,  11, 114, 101, 112, 101,  97, 116, 115, 116,  97,
116, 101,   4,   4,  82,  80,  84,  69,  10,  10, 109,  97,  99, 114, 111, 115,
116,  97, 116, 101,   4,   4,  77,  65,  67,  82,  10,  10, 112, 117, 114, 103,
101, 115, 116,  97, 116, 101,   4,   4,  80,  82,  71,  77,   9,   9,  99,  97,
108, 108, 109,  97,  99, 114, 111,   7,   7, 105, 102, 115, 116,  97, 116, 101,
 10,  10,  98, 101, 103, 105, 110, 115, 116,  97, 116, 101,  12,  12, 105, 110,
 99, 108, 117, 100, 101, 115, 116,  97, 116, 101,   4,   4,  73,  78,  67,  76,
 18,  18,  32,  42,  42,  42,  32,  82, 101,  97, 100,  32,  78, 111, 119,  32,
111, 110,  32,  34,   2,   2,  34,  46,  12,  12, 109,  97,  99, 114, 108, 105,
 98, 115, 116,  97, 116, 101,   8,   8, 101, 111, 102, 115, 116,  97, 116, 101,
 14,  14,  32,  42,  42,  42,  32,  91,  69,  79,  70,  93,  32,  42,  42,  42,
  4,   4,  69,  78,  68,  70,  10,  10, 109,  99,  97, 108, 108, 115, 116,  97,
116, 101,   4,   4,  77,  67,  65,  76,  18,  18,  32,  42,  42,  42,  32,  67,
 97, 110, 110, 111, 116,  32,  70, 105, 110, 100,  32,  34,   2,   2,  34,  46,
  7,   7, 105, 110, 105, 100,  97, 116,  97,  12,  12, 109, 120, 100, 100, 100,
105,  46,  98, 100, 100,  46,  49,  11,  11, 115, 101, 116, 100,  97, 116,  97,
102, 105, 108, 101,  10,  10, 115,  99, 114, 105, 112, 116, 100,  97, 116,  97,
  9,   9, 100, 101, 102, 115, 121, 109,  98, 111, 108,  12,  12, 100,  97, 116,
 97, 112, 114, 111, 108, 111, 103, 117, 101,   2,   2,  83,  70,   2,   2,  70,
 50,   3,   3,  82,  65,  89,   2,   2,  83,  71,   2,   2,  87,  69,   2,   2,
 73,  72,   2,   2,  73,  75,   2,   2,  73,  76,   2,   2,  73,  83,   3,   3,
 77,  85,  76,   2,   2,  78,  81,   5,   5,  78,  80,  79,  76,  65,   5,   5,
 83,  69,  76,  78,  66,   4,   4,  36,  78,  80,  84,   4,   4,  68,  65,  84,
 65,   7,   7, 100,  97, 116,  97, 109, 110, 103,  22,  22,  32,  82,  69,  70,
 35,  32,  32,  32,  72,  32,  32,  75,  32,  32,  76,  32,  32,  77,  32,  32,
 78,  32,  61,  61,  32,  32,  79,  66,  83,  32,  32,  32,  83,  73,  71,  77,
 65,  32,  32,  32,  87,  69,  73,  71,  72,  84,  32,  32,  32,  32,  49,  47,
 50,  42,  68,  32,  32,  32,  32,  32,  73,  78,  84,  69,  82,  80,  79,  76,
 65,  84,  69,  68,  32,  65,  82,  82,  65,  89,  32,  86,  65,  76,  85,  69,
 83,  32,  32,  34,  32,  73,  83,  32,  83,  69,  84,  32,  65,  83,  32,  67,
 85,  82,  82,  69,  78,  84,  32,  87,  65,  86,  69,  32,  86,  69,  67,  84,
 79,  82,  46,  37,  37,  34,  32,  73,  83,  32,  83,  69,  84,  32,  65,  83,
 32,  67,  85,  82,  82,  69,  78,  84,  32,  80,  79,  76,  65,  82,  73,  90,
 65,  84,  73,  79,  78,  32,  68,  73,  82,  46,  10,  10, 110, 101, 119, 100,
 97, 116,  97, 115, 116,  97,  10,  10, 101, 120, 116, 100,  97, 116,  97, 115,
116,  97,   9,   9, 100,  97, 116,  97, 115, 116,  97, 116, 101,  12,  12,  99,
108, 114, 100,  97, 116,  97, 115, 116,  97, 116, 101,   4,   4,  67,  76,  82,
 68,  12,  12,  99, 111, 110, 116, 114, 105,  98, 115, 116,  97, 116, 101,   4,
  4,  67,  78,  84,  82,  13,  13, 118,  97, 114, 105,  97,  98, 108, 101, 115,
116,  97, 116, 101,   9,   9, 108, 111,  99,  97, 116, 101, 116,  97,  98,   7,
  7, 105, 110, 105, 116, 102, 114, 109,  14,  14,  97, 115, 115, 105, 103, 110,
112,  97, 114, 115, 116,  97, 116, 101,   4,   4,  65,  83,  83,  80,  10,  10,
112,  97, 114,  97, 109, 115, 116,  97, 116, 101,  13,  13,  97, 115, 115, 105,
103, 110, 102, 102, 115, 116,  97, 116, 101,   4,   4,  70,  70,  65,  83,  10,
 10, 102, 105, 120, 101, 100, 115, 116,  97, 116, 101,   4,   4,  70,  73,  88,
 68,  10,  10, 108, 105, 109, 105, 116, 115, 116,  97, 116, 101,   4,   4,  76,
 77,  84,  83,  14,  14,  97, 115, 115, 105, 103, 110, 118,  97, 114, 115, 116,
 97, 116, 101,   4,   4,  65,  83,  83,  86,  10,  10,  97, 116, 111, 109, 101,
115, 116,  97, 116, 101,   4,   4,  65,  84,  79,  77,  11,  11, 109, 111, 109,
101, 110, 116, 115, 116,  97, 116, 101,   4,   4,  77,  79,  77,  69,   7,   7,
 32,  32,  32,  32,  32,  45,  49,  12,  12, 108,  97, 116, 116, 105,  99, 101,
115, 116,  97, 116, 101,   8,   8,  80,  65,  66,  67,  73,  72,  70,  32,   4,
  4,  76,  65,  84,  84,   6,   6, 105, 110, 118, 109,  97, 116,   6,   6, 112,
101, 114, 109, 117, 116,   9,   9,  99, 101, 108, 108, 115, 116,  97, 116, 101,
  4,   4,  67,  69,  76,  76,   2,   2,  36,  65,   3,   3,  36,  65,  35,   2,
  2,  36,  66,   3,   3,  36,  66,  35,   2,   2,  36,  67,   3,   3,  36,  67,
 35,   6,   6,  36,  65,  76,  80,  72,  65,   7,   7,  36,  65,  76,  80,  72,
 65,  35,   5,   5,  36,  66,  69,  84,  65,   6,   6,  36,  66,  69,  84,  65,
 35,   6,   6,  36,  71,  65,  77,  77,  65,   7,   7,  36,  71,  65,  77,  77,
 65,  35,   7,   7,  36,  86,  79,  76,  85,  77,  69,   8,   8,  36,  86,  79,
 76,  85,  77,  69,  35,   6,   6,  36,  84,  77,  68,  88,  88,   6,   6,  36,
 84,  77,  82,  88,  88,   6,   6,  36,  84,  77,  68,  88,  89,   6,   6,  36,
 84,  77,  82,  88,  89,   6,   6,  36,  84,  77,  68,  88,  90,   6,   6,  36,
 84,  77,  82,  88,  90,   6,   6,  36,  84,  77,  68,  89,  88,   6,   6,  36,
 84,  77,  82,  89,  88,   6,   6,  36,  84,  77,  68,  89,  89,   6,   6,  36,
 84,  77,  82,  89,  89,   6,   6,  36,  84,  77,  68,  89,  90,   6,   6,  36,
 84,  77,  82,  89,  90,   6,   6,  36,  84,  77,  68,  90,  88,   6,   6,  36,
 84,  77,  82,  90,  88,   6,   6,  36,  84,  77,  68,  90,  89,   6,   6,  36,
 84,  77,  82,  90,  89,   6,   6,  36,  84,  77,  68,  90,  90,   6,   6,  36,
 84,  77,  82,  90,  90,   9,   9, 119,  97, 118, 101, 115, 116,  97, 116, 101,
  4,   4,  87,  65,  86,  69,  10,  10, 110, 112, 111, 108,  97, 115, 116,  97,
116, 101,   4,   4,  78,  80,  79,  76,  11,  11, 115, 121, 109, 116, 114, 121,
115, 116,  97, 116, 101,   4,   4,  83,  89,  77,  84,  11,  11, 109, 100, 115,
100, 115, 112, 115, 116,  97, 116, 101,   4,   4,  77,  68,  83,  80,  11,  11,
108, 115, 113,  98, 108, 107, 115, 116,  97, 116, 101,   4,   4,  76,  83,  81,
 66,  13,  13, 109,  97, 103, 110, 101, 116, 105,  99, 115, 116,  97, 116, 101,
 11,  11, 111, 112, 116, 105, 111, 110, 115, 116,  97, 116, 101,  12,  12, 115,
111, 112, 116, 105, 111, 110, 115, 116,  97, 116, 101,  10,  10,  99, 108, 111,
115, 101,  95, 111, 112, 101, 110,  13,  13, 111, 112, 101, 110, 102, 105, 108,
101, 115, 116,  97, 116, 101,   4,   4,  79,  80,  69,  78,  14,  14,  99, 108,
111, 115, 101, 102, 105, 108, 101, 115, 116,  97, 116, 101,   4,   4,  67,  76,
 79,  83,   9,   9,  98, 111, 111, 108, 115, 116,  97, 116, 101,   6,   6, 115,
107, 112, 114, 100, 115,   4,   4,  82,  80,  76,  89,  10,  10, 114, 101, 112,
108, 121, 115, 116,  97, 116, 101,  11,  11, 111, 117, 116,  95, 111, 110,  95,
102, 105, 108, 101,  12,  12, 100, 105, 115, 112, 108,  97, 121, 115, 116,  97,
116, 101,   4,   4,  68,  83,  80,  76,  10,  10, 115, 101, 116, 114, 117, 110,
 97, 112, 112, 108,  10,  10, 115, 101, 116, 108, 105, 115, 116, 105, 110, 103,
 10,  10, 115, 112,  97, 119, 110,  95, 116,  97, 115, 107,  10,  10, 101, 114,
114, 111, 114, 115, 116,  97, 116, 101,   4,   4, 117, 101, 114, 114,   9,   9,
115, 116,  97, 116, 101, 109, 101, 110, 116,   4,   4,  83,  84,  65,  84,   9,
  9, 115, 116,  97, 116, 101, 108, 105, 115, 116,   8,   8, 119, 114, 105, 116,
101,  99, 112, 117,   4,   4,  32, 100,  97, 121,   2,   2,  44,  32,   5,   5,
 32, 104, 111, 117, 114,   7,   7,  32, 109, 105, 110, 117, 116, 101,   7,   7,
 32, 115, 101,  99, 111, 110, 100,   8,   8, 103, 101, 110, 115, 112,  97,  99,
101,   8,   8,  46, 101,  46,  46,  46,  46,  46,  46,   8,   8,  46,  99, 101,
110, 116, 101, 114,  46,   8,   8,  46, 103, 101, 110, 115, 112,  99,  46,   4,
  4,  71,  83,  80,  65,   7,   7, 115, 117, 109, 109,  97, 114, 121,  23,  23,
 32,  83, 117, 109, 109,  97, 114, 121,  32,  69, 114, 114, 111, 114,  32,  67,
111, 117, 110, 116,  32,  61,  32,   3,   3,  32,  45,  50,  16,  16, 119, 105,
116, 104,  32, 115, 111, 109, 101,  32,  70,  65,  84,  65,  76,  46,   3,   3,
 32,  45,  49,  15,  15,  32,  69, 114, 114, 111, 114,  32,  67, 111, 117, 110,
116,  32,  61,  32,  16,  16,  32, 119, 105, 116, 104,  32, 115, 111, 109, 101,
 32,  70,  65,  84,  65,  76,   2,   2,  32,  46,  32,  32,  32,  77,  88,  68,
 32,  67, 111, 109, 112, 105, 108, 101, 114,  32,  67,  80,  85,  32, 116, 105,
109, 101,  32, 117, 115, 101, 100,  32, 105, 115,  32,  58,   7,   7, 109, 120,
100,  95,  99, 109, 112,  20,  20,  32,  42,  42,  42,  32,  78, 111, 119,  32,
 77,  88,  68,  32, 115, 116,  97, 114, 116,  32,  34,  14,  14,  34,  32,  97,
112, 112, 108, 105,  99,  97, 116, 105, 111, 110,  46,   0,   0,  52,  52,  42,
 42,  42,  32,  67,  97, 110, 110, 111, 116,  32, 114, 117, 110,  32, 116, 104,
101,  32, 115, 112, 101,  99, 105, 102, 105, 101, 100,  32,  97, 112, 112, 108,
105,  99,  97, 116, 105, 111, 110,  32, 112, 114, 111, 103, 114,  97, 109,  32,
 42,  42,  42,   2,   2,  32,  34,   2,   2,  34,  46,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 272 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  18,  22,   0,   0,   0,   0,  21,  11,
 12,  13,   8,   6,   3,   7,   2,   9,   1,   1,   1,   1,   1,   1,   1,   1,
  1,   1,   5,   4,  19,  14,  20,  15,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,  23,  15,  24,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 132,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 1088 );

static sigjmp_buf G_lb_env;

/* Declaration of external variables. */
extern SL V_linewrt;
extern V V_lst;
extern UB V_fatalerror;
extern SL V_errcnt;
extern V PAS__f_output;
extern SL PAS__argc;
extern Blk(PAS__argv, 1032 );
extern Blk(V_errmsgspecif, 136 );
extern V V_strempty;
extern Blk(PAS__fspc, 264 );
extern SL V_pagenb;
extern UB V_majorfmode;
extern V PAS__f_input;


/* Function/procedure prototypes. */
F P_bessel_j(SL F_n, F F_x);
V P_st_create();
void P_st_free(V *F_p);
void P_st_put_int(V F_st, SL F_iv, SL F_ndig);
void P_st_put_float(V F_st, F F_dv, SL F_fs, SL F_intsz, SL F_dcsz, SL F_es);
void P_st_put_fixed(V F_st, F F_dv, SL F_fs, SL F_dcsz, SL F_dcmin);
void P_put_newlinelst(V F_title);
void P_outerrmsgline(SL F_n);
void P_open_listing(V *F_f, V F_fname, SL F__Sz, SL F_mdflg);
void P_openw_txtfile(V *F_f, V F_fname, SL F_mdflg);
void P_close_txtfile(V *F_f);
void P_open_input_txtfile(V *F_f, V F_fname, UB *F_bok, UB *F_bprt, SL *F_ierr);
SL P_cpu_clock();
UB P_open_ddifile(V *F_f, V F_spc, UB F_wrt);
void P_close_ddifile(V *F_f);
void P_open_bdtfile(V *F_f, V F_spc);
void P_close_bdtfile(V *F_f);
void MXD_CMP_activemacpar(V F_pm, V F_p, UB F_modf);
void MXD_CMP_callfunc(V F_nd);
void MXD_CMP_usercall(V F_nd);
void MXD_CMP_PRC_00000004();
void MXD_CMP_statelist(UB F_stopper);
void MXD_CMP_PRC_00000018(V *F_pfu, UB F_bl);


/* Procedure/Function : " newlinelst "  */
void MXD_CMP_newlinelst(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=872; /* line # 872 */
  V_linewrt=V_linewrt+1;
  Ra.sl[6]=873; /* line # 873 */
  if (V_linewrt>=55) {
    Ra.sl[6]=875; /* line # 875 */
    P_put_newlinelst(Rd.s+61);
    Ra.sl[6]=876; /* line # 876 */
    if (Rs.v[0]!=NULL) {
      Rv0=Rs.v[0];
      Ra.sl[6]=877; /* line # 877 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+123,-1,-1,32);
      PAS__WRITE_CHT(Rv0+8,132,(SL)((C *)Rv0)[140],-1,32);
      PAS__WRITE_STR(Rd.s+130,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=878; /* line # 878 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=879; /* line # 879 */
    Rv1=Ri.v[0];
    Rv2=Rv1+8;
    Rv3=Rv1+80;
    Ra.sl[6]=880; /* line # 880 */
    if (((UB *)Rv3)[16]==3||((UB *)Rv3)[16]==6) {
      Ra.sl[6]=881; /* line # 881 */
      Rv4=((V *)Rv2)[2];
      Ra.sl[6]=882; /* line # 882 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+136,-1,-1,32);
      PAS__WRITE_CHT(Rv4+8,132,(SL)((C *)Rv4)[140],-1,32);
    }
    Ra.sl[6]=883; /* line # 883 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    Ra.sl[6]=884; /* line # 884 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outsrclist "  */
void MXD_CMP_outsrclist(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+167;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=896; /* line # 896 */
  MXD_CMP_newlinelst();
  Ra.sl[6]=897; /* line # 897 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=899; /* line # 899 */
  if (((UB *)Rv2)[16]==4||((UB *)Rv2)[16]==5) Rv3=Rs.v[1];
  else {
    Ra.sl[6]=900; /* line # 900 */
    Rv3=((V *)Rv1)[3];
  }
  Ra.sl[6]=901; /* line # 901 */
  Rv4=Rv3;
  Ra.sl[6]=903; /* line # 903 */
  if (Rs.sl[4]>=Rs.sl[5]) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  else {
    Ra.sl[6]=904; /* line # 904 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rs.sl[5],5,0);
  }
  Ra.sl[6]=905; /* line # 905 */
  Rs.sl[4]=Rs.sl[5];
  Ra.sl[6]=906; /* line # 906 */
  if (((UB *)Rv2)[16]==4||((UB *)Rv2)[16]==5) {
    Ra.sl[6]=907; /* line # 907 */
    if (((UB *)Rv2)[16]==4||((UB *)Rv1)[61]) {
      Ra.sl[6]=908; /* line # 908 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rs.sl[6],3,0);
      PAS__WRITE_STR(Rd.s+179,-1,-1,32);
    }
    else {
      Ra.sl[6]=910; /* line # 910 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rs.sl[6],3,0);
      PAS__WRITE_STR(Rd.s+187,-1,-1,32);
    }
  }
  else {
    Ra.sl[6]=912; /* line # 912 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rs.sl[6],3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv1)[8],5,0);
  }
  Ra.sl[6]=913; /* line # 913 */
  if ((SL)((C *)Rv4)[140]<1) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=914; /* line # 914 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(32,4,-1,1,32);
    PAS__WRITE_CHT(Rv4+8,132,(SL)((C *)Rv4)[140],-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=916; /* line # 916 */
  ((UB *)Rv1)[57]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " error "  */
void MXD_CMP_error(V F_errmdnam, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_errmdnam,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+195;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=933; /* line # 933 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=935; /* line # 935 */
  if (abs(F_n)<1000) {
    Ra.sl[6]=937; /* line # 937 */
    Rv3=!((UB *)Rv1)[60]||((UB *)Rv1)[57];
    Ra.sl[6]=938; /* line # 938 */
    if (Rv3) MXD_CMP_outsrclist();
    Ra.sl[6]=939; /* line # 939 */
    if (((UB *)Rv2)[16]==4||((UB *)Rv2)[16]==5) Rv4=Rs.sl[7];
    else {
      Ra.sl[6]=940; /* line # 940 */
      Rv4=((SL *)Rv1)[12];
    }
    Ra.sl[6]=941; /* line # 941 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(32, Rv4+18,-1,1,32);
    PAS__WRITE_CHAR(94);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=943; /* line # 943 */
  if (F_n<0) {
    Ra.sl[6]=944; /* line # 944 */
    V_fatalerror=1;
    Ra.sl[6]=945; /* line # 945 */
    Ri.ub[8]=1;
    Ra.sl[6]=946; /* line # 946 */
    F_n=abs(F_n);
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+202,-1,-1,32);
  }
  Ra.sl[6]=948; /* line # 948 */
  V_errcnt=V_errcnt+1;
  Ra.sl[6]=949; /* line # 949 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+210,-1,-1,32);
  PAS__WRITE_CHT(Ra.s+28,4,4,-1,32);
  PAS__WRITE_STR(Rd.s+219,-1,-1,32);
  PAS__WRITE_INT(F_n,4,0);
  PAS__WRITE_STR(Rd.s+223,-1,-1,32);
  Ra.sl[6]=950; /* line # 950 */
  if (Rs.v[4]!=NULL) {
    Rv5=Rs.v[4];
    Ra.sl[6]=951; /* line # 951 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_CHT(Rv5+9,16,(SL)((C *)Rv5)[8],-1,32);
    PAS__WRITE_STR(Rd.s+229,-1,-1,32);
  }
  Ra.sl[6]=952; /* line # 952 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+233,-1,-1,32);
  PAS__WRITE_INT(Rs.sl[5],3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=953; /* line # 953 */
  P_outerrmsgline(F_n);
  Ra.sl[6]=954; /* line # 954 */
  V_linewrt=V_linewrt+3;
  Ra.sl[6]=955; /* line # 955 */
  if (((UB *)Rv2)[16]==3||((UB *)Rv2)[16]==6) {
    Ra.sl[6]=956; /* line # 956 */
    if (abs(F_n)<1000) {
      Ra.sl[6]=958; /* line # 958 */
      Rv6=((V *)Rv1)[2];
      Ra.sl[6]=959; /* line # 959 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+246,-1,-1,32);
      PAS__WRITE_CHT(Rv6+8,132,(SL)((C *)Rv6)[140],-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[6]=960; /* line # 960 */
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+265,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv1)[8],5,0);
      PAS__WRITE_EOLN();
      Ra.sl[6]=961; /* line # 961 */
      V_linewrt=V_linewrt+2;
    }
  }
  Ra.sl[6]=963; /* line # 963 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_EOLN();
  Ra.sl[6]=964; /* line # 964 */
  ((UB *)Rv1)[57]=1;
  Ra.sl[6]=966; /* line # 966 */
  if (V_fatalerror) {
    Ra.sl[6]=968; /* line # 968 */
    Rs.c[40]=32;
    Rs.c[41]=32;
    Rs.sl[6]=0;
    Rs.ub[42]=16;
    Ra.sl[6]=969; /* line # 969 */
    ((UB *)Ri.v[0])[67]=1;
  }
  Ra.sl[6]=972; /* line # 972 */
  if (V_errcnt==32) MXD_CMP_error(Rd.s+283,-1000);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " resettxtfile "  */
void MXD_CMP_resettxtfile(V *F_f, V F_fname, UB *F_bok, UB *F_bprt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+287;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=990; /* line # 990 */
  P_open_input_txtfile(F_f,F_fname, F_bok,F_bprt,&Rv0);
  Ra.sl[6]=991; /* line # 991 */
  ((F *)Rs.v[6])[13]=(float)Rv0;
  Ra.sl[6]=992; /* line # 992 */
  if (Rv0==0) {
    Ra.sl[6]=993; /* line # 993 */
    (*F_bok)=1;
  }
  else {
    Ra.sl[6]=996; /* line # 996 */
    (*F_bok)=0;
    Ra.sl[6]=997; /* line # 997 */
    if (Rv0!=-1) MXD_CMP_error(Rd.s+303,Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lstfilespc "  */
void MXD_CMP_lstfilespc(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+307;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1006; /* line # 1006 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Ra.sl[6]=1007; /* line # 1007 */
  if (((UB *)Rv1)[60]&&((SL *)Rv1)[2]>=((SL *)Rv1)[3]) {
    Ra.sl[6]=1009; /* line # 1009 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(32,9,-1,1,32);
    PAS__WRITE_FCHAR(42,11,-1,1,32);
    PAS__WRITE_STR(Rd.s+319,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=1011; /* line # 1011 */
    MXD_CMP_newlinelst();
    Ra.sl[6]=1012; /* line # 1012 */
    Rv2=((V *)Rv1)[2];
    Ra.sl[6]=1013; /* line # 1013 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_FCHAR(32,9,-1,1,32);
    PAS__WRITE_FCHAR(42,11,-1,1,32);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_CHT(Rv2+8,132,(SL)((C *)Rv2)[140],-1,32);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rd_line "  */
void MXD_CMP_rd_line(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+351;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1031; /* line # 1031 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=1033; /* line # 1033 */
  if (((UB *)Rv2)[17]) {
    Ra.sl[6]=1035; /* line # 1035 */
    PAS__SELECT_OUT(((V *)Rv2)[0]);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(((V *)Rv2)[0]);
    PAS__WRITE_STR(Rd.s+360,-1,-1,32);
  }
  Ra.sl[6]=1037; /* line # 1037 */
  Rv3=1;
  Ra.sl[6]=1038; /* line # 1038 */
  while (!PAS__EOF((*F_f))&&!PAS__EOLN((*F_f))){
    Ra.sl[6]=1039; /* line # 1039 */
    Rv4=((V *)Rv1)[3];
    Ra.sl[6]=1041; /* line # 1041 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(Rs.c+40);
    Ra.sl[6]=1042; /* line # 1042 */
    if (Rs.c[40]==9) {
      Ra.sl[6]=1044; /* line # 1044 */
      Rs.c[40]=0;
      while (1){
        Ra.sl[6]=1046; /* line # 1046 */
        ((C *)Rv4)[Rv3+7]=32;
        Ra.sl[6]=1047; /* line # 1047 */
        if (Rv3<132) Rv3=Rv3+1;
        else {
          Ra.sl[6]=1048; /* line # 1048 */
          MXD_CMP_error(Rd.s+369,1);
        }
        if (Rv3>=132||(Rv3&7)==1)  break;
      }
    }
    else {
      Ra.sl[6]=1052; /* line # 1052 */
      if (Rs.c[40]>=32) {
        Ra.sl[6]=1053; /* line # 1053 */
        if (Rv3<=132) {
          Ra.sl[6]=1055; /* line # 1055 */
          ((C *)Rv4)[Rv3+7]=Rs.c[40];
          Rv3=Rv3+1;
        }
        else {
          Ra.sl[6]=1057; /* line # 1057 */
          MXD_CMP_error(Rd.s+369,1);
        }
      }
    }
  }
  Ra.sl[6]=1059; /* line # 1059 */
  Rv3=Rv3 -1;
  Ra.sl[6]=1060; /* line # 1060 */
  ((C *)((V *)Rv1)[3])[140]=(C)Rv3;
  Ra.sl[6]=1061; /* line # 1061 */
  if (PAS__EOF((*F_f))) ((UB *)Rv1)[58]=1;
  else {
    Ra.sl[6]=1062; /* line # 1062 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  Ra.sl[6]=1064; /* line # 1064 */
  ((SL *)Rv1)[8]=((SL *)Rv1)[8]+1;
  Ra.sl[6]=1065; /* line # 1065 */
  ((SL *)Rv1)[12]=((SL *)Rv1)[9];
  Ra.sl[6]=1066; /* line # 1066 */
  ((UB *)Rv1)[59]=((SL *)Rv1)[9]>Rv3;
  Ra.sl[6]=1067; /* line # 1067 */
  if (((UB *)Rv1)[63]&&!((UB *)Rv2)[17]) {
    Ra.sl[6]=1069; /* line # 1069 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+360,-1,-1,32);
    Ra.sl[6]=1070; /* line # 1070 */
    Rv5=((V *)Rv1)[3];
    Ra.sl[6]=1071; /* line # 1071 */
    if (Rv3>0) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHT(Rv5+8,132, Rv3,-1,32);
    }
    Ra.sl[6]=1072; /* line # 1072 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=1074; /* line # 1074 */
  if (Rv3>((SL *)Rv1)[10]) ((SL *)Rv1)[11]=((SL *)Rv1)[10];
  else {
    Ra.sl[6]=1075; /* line # 1075 */
    ((SL *)Rv1)[11]=Rv3;
  }
  Ra.sl[6]=1076; /* line # 1076 */
  if (((UB *)Rv1)[60]&&((SL *)Rv1)[2]>=((SL *)Rv1)[3]) {
    Ra.sl[6]=1077; /* line # 1077 */
    if (Rv3>0||!((UB *)Rv1)[58]) MXD_CMP_outsrclist();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_line "  */
void MXD_CMP_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+373;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1087; /* line # 1087 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=1088; /* line # 1088 */
  if (!((UB *)Rv1)[58]) {
    Ra.sl[6]=1089; /* line # 1089 */
    switch (((UB *)Rv2)[16]) {
      case 3:Ra.sl[6]=1090; /* line # 1090 */
      MXD_CMP_rd_line(((V *)Rv2)+1);
      break;
      case 4:
      case 5:Ra.sl[6]=1092; /* line # 1092 */
      if (((V *)((V *)Rv1)[3])[0]!=NULL) {
        Ra.sl[6]=1094; /* line # 1094 */
        ((V *)Rv1)[3]=((V *)((V *)Rv1)[3])[0];
        Ra.sl[6]=1095; /* line # 1095 */
        ((SL *)Rv1)[11]=(SL)((C *)((V *)Rv1)[3])[140];
        Ra.sl[6]=1096; /* line # 1096 */
        ((SL *)Rv1)[12]=1;
      }
      else {
        Ra.sl[6]=1098; /* line # 1098 */
        ((UB *)Rv1)[58]=1;
      }
      break;
      case 6:Ra.sl[6]=1099; /* line # 1099 */
      MXD_CMP_rd_line(Ri.v+2);
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " match "  */
SL MXD_CMP_match(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  register SL Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_s1,17);
  memcpy( Ra.s+45,F_s2,17);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+383;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1116; /* line # 1116 */
  Rv0=(SL)Ra.c[28];
  Ra.sl[6]=1117; /* line # 1117 */
  Rv1=(SL)Ra.c[45];
  Ra.sl[6]=1118; /* line # 1118 */
  if (Rv1>Rv0) Rv1=Rv0;
  Ra.sl[6]=1119; /* line # 1119 */
  Rv0=1;
  Ra.sl[6]=1120; /* line # 1120 */
  Rv2=1;
  Ra.sl[6]=1121; /* line # 1121 */
  while (Rv0<=Rv1&&Rv2){
    Ra.sl[6]=1123; /* line # 1123 */
    Rv2=Ra.c[Rv0+28]==Ra.c[Rv0+45];
    if (Rv2) Rv0=Rv0+1;
  }
  Ra.sl[6]=1125; /* line # 1125 */
  if (Rv2) {
    Ra.sl[6]=1126; /* line # 1126 */
    if (Ra.c[28]==Ra.c[45]) {
      Ra.sl[6]=1127; /* line # 1127 */
      Ret=0;
    }
    else {
      Ra.sl[6]=1129; /* line # 1129 */
      if (Ra.c[28]>Ra.c[45]) Ret=1;
      else {
        Ra.sl[6]=1130; /* line # 1130 */
        Ret=-1;
      }
    }
  }
  else {
    Ra.sl[6]=1132; /* line # 1132 */
    if (Ra.c[Rv0+28]>Ra.c[Rv0+45]) Ret=1;
    else {
      Ra.sl[6]=1133; /* line # 1133 */
      Ret=-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " newide "  */
V MXD_CMP_newide(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+390;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1144; /* line # 1144 */
  if (Rs.v[7]!=NULL) {
    Ra.sl[6]=1145; /* line # 1145 */
    Rv0=Rs.v[7];
    Rs.v[7]=((V *)Rv0)[4];
  }
  else {
    Ra.sl[6]=1146; /* line # 1146 */
    Rv0=PAS__NEW(72);
  }
  Ra.sl[6]=1147; /* line # 1147 */
  if (Rv0==NULL) MXD_CMP_error(Rd.s+400,-2);
  Ra.sl[6]=1148; /* line # 1148 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " searchid "  */
void MXD_CMP_searchid(V F_s, V *F_p, UB F_create){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_s,17);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+404;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1161; /* line # 1161 */
  Rv0=NULL;
  Ra.sl[6]=1162; /* line # 1162 */
  Rv1=NULL;
  Ra.sl[6]=1163; /* line # 1163 */
  Rv2=-1;
  Ra.sl[6]=1164; /* line # 1164 */
  if (!F_create) {
    Ra.sl[6]=1166; /* line # 1166 */
    Rv0=Rs.v[8];
    Ra.sl[6]=1167; /* line # 1167 */
    while (Rv0!=NULL&&Rv2!=0){
      Ra.sl[6]=1169; /* line # 1169 */
      Rv2=MXD_CMP_match(Ra.s+28,Rv0+8);
      Ra.sl[6]=1171; /* line # 1171 */
      if (((UB *)Rv0)[48]==1) Rv2=-1;
      Ra.sl[6]=1172; /* line # 1172 */
      if (Rv2!=0) Rv0=((V *)Rv0)[4];
    }
  }
  Ra.sl[6]=1175; /* line # 1175 */
  if (Rv2!=0) {
    Ra.sl[6]=1177; /* line # 1177 */
    if (F_create) Rv3=Rs.sl[18]-1;
    else Rv3=-1;
    Ra.sl[6]=1178; /* line # 1178 */
    Rv4=Rs.sl[18];
    Ra.sl[6]=1179; /* line # 1179 */
    while (Rv4>Rv3&&Rv2!=0){
      Ra.sl[6]=1181; /* line # 1181 */
      Rv0=Rs.v[Rv4+10];
      Rv5=NULL;
      Ra.sl[6]=1182; /* line # 1182 */
      while (Rv0!=NULL&&Rv2!=0){
        Ra.sl[6]=1184; /* line # 1184 */
        Rv2=MXD_CMP_match(Ra.s+28,Rv0+8);
        Ra.sl[6]=1185; /* line # 1185 */
        Rv5=Rv0;
        Ra.sl[6]=1186; /* line # 1186 */
        if (Rv2!=0) {
          Ra.sl[6]=1187; /* line # 1187 */
          if (Rv2>0) Rv0=((V *)Rv0)[5];
          else Rv0=((V *)Rv0)[4];
        }
      }
      Ra.sl[6]=1189; /* line # 1189 */
      if (Rv2!=0) {
        Ra.sl[6]=1191; /* line # 1191 */
        if (Rv4==Rs.sl[18]) Rv1=Rv5;
        Ra.sl[6]=1192; /* line # 1192 */
        Rv4=Rv4 -1;
      }
    }
    Ra.sl[6]=1195; /* line # 1195 */
    if (Rv2!=0&&F_create) {
      Ra.sl[6]=1197; /* line # 1197 */
      Rv0=MXD_CMP_newide();
      Ra.sl[6]=1198; /* line # 1198 */
      if (Rv1==NULL) Rs.v[Rs.sl[18]+10]=Rv0;
      else {
        Ra.sl[6]=1200; /* line # 1200 */
        if (Rv2>0) ((V *)Rv1)[5]=Rv0;
        else((V *)Rv1)[4]=Rv0;
      }
      Ra.sl[6]=1201; /* line # 1201 */
      Rv6=Rv0;
      Ra.sl[6]=1203; /* line # 1203 */
      ((SL *)Rv6)[1]=Rs.sl[86];
      Rs.sl[86]=Rs.sl[86]+1;
      Ra.sl[6]=1204; /* line # 1204 */
      ((V *)Rv6)[4]=NULL;
      ((V *)Rv6)[5]=NULL;
      ((SL *)Rv6)[0]=Rs.sl[18];
      memcpy(Rv6+8,Ra.s+28,17);
    }
  }
  Ra.sl[6]=1208; /* line # 1208 */
  (*F_p)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " newdftb "  */
V MXD_CMP_newdftb(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+414;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1219; /* line # 1219 */
  if (Rs.v[44]==NULL) Rv0=PAS__NEW(220);
  else {
    Ra.sl[6]=1222; /* line # 1222 */
    Rv0=Rs.v[44];
    Rs.v[44]=((V *)Rv0)[0];
  }
  Ra.sl[6]=1224; /* line # 1224 */
  if (Rv0==NULL) MXD_CMP_error(Rd.s+425,-2);
  else {
    Ra.sl[6]=1225; /* line # 1225 */
    ((V *)Rv0)[0]=NULL;
  }
  Ra.sl[6]=1226; /* line # 1226 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fredftb "  */
void MXD_CMP_fredftb(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+429;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1237; /* line # 1237 */
  Rv0=Rs.v[44];
  Rv1=NULL;
  Ra.sl[6]=1238; /* line # 1238 */
  while (Rv0!=NULL){
    Ra.sl[6]=1239; /* line # 1239 */
    Rv1=Rv0;
    Rv0=((V *)Rv0)[0];
  }
  Ra.sl[6]=1240; /* line # 1240 */
  if (Rv1==NULL) Rs.v[44]=F_p;
  else((V *)Rv1)[0]=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setnewffrm "  */
SL MXD_CMP_setnewffrm(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+438;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1251; /* line # 1251 */
  Rv0=0;
  Ra.sl[6]=1252; /* line # 1252 */
  while (Rs.v[Rv0+45]!=NULL&&Rv0<15)
  Rv0=Rv0+1;
  Ra.sl[6]=1253; /* line # 1253 */
  if (Rv0==15) {
    Ra.sl[6]=1254; /* line # 1254 */
    if (Rs.v[60]!=NULL) Rv0=-1;
  }
  Ra.sl[6]=1255; /* line # 1255 */
  if (Rv0!=-1) Rs.v[Rv0+45]=F_p;
  Ra.sl[6]=1256; /* line # 1256 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " freetext "  */
void MXD_CMP_freetext(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+450;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1268; /* line # 1268 */
  Rv0=(*F_p);
  Ra.sl[6]=1269; /* line # 1269 */
  while (Rv0!=NULL){
    Ra.sl[6]=1271; /* line # 1271 */
    Rv1=((V *)Rv0)[0];
    Ra.sl[6]=1272; /* line # 1272 */
    P_st_free(&Rv0);
    Ra.sl[6]=1273; /* line # 1273 */
    Rv0=Rv1;
  }
  Ra.sl[6]=1275; /* line # 1275 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " freeide "  */
void MXD_CMP_freeide(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+460;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1286; /* line # 1286 */
  if (F_p!=NULL) {
    Ra.sl[6]=1288; /* line # 1288 */
    Rv0=F_p;
    Ra.sl[6]=1290; /* line # 1290 */
    if (((V *)Rv0)[4]!=NULL) MXD_CMP_freeide(((V *)Rv0)[4]);
    Ra.sl[6]=1291; /* line # 1291 */
    if (((V *)Rv0)[5]!=NULL) MXD_CMP_freeide(((V *)Rv0)[5]);
    Ra.sl[6]=1292; /* line # 1292 */
    switch (((UB *)Rv0)[48]) {
      case 4:
      case 7:
      case 8:
      case 11:
      case 13:
      case 14:
      case 17:break;
      case 12:Ra.sl[6]=1297; /* line # 1297 */
      MXD_CMP_fredftb(((V *)Rv0)[8]);
      Ra.sl[6]=1298; /* line # 1298 */
      if (((SL *)Rv0)[13]>=0) Rs.v[((SL *)Rv0)[13]+45]=NULL;
      break;
      case 10:Ra.sl[6]=1300; /* line # 1300 */
      if (((UB *)Rv0)[49]==1) P_st_free(((V *)Rv0)+7);
      break;
      case 16:Ra.sl[6]=1303; /* line # 1303 */
      Rv1=((V *)Rv0)[7];
      Ra.sl[6]=1304; /* line # 1304 */
      while (Rv1!=NULL){
        Ra.sl[6]=1306; /* line # 1306 */
        ((V *)F_p)[4]=Rs.v[7];
        Rs.v[7]=Rv1;
        Ra.sl[6]=1307; /* line # 1307 */
        if (((UB *)Rv1)[48]==15) Rv1=((V *)Rv1)[8];
        else {
          Ra.sl[6]=1308; /* line # 1308 */
          Rv1=((V *)Rv1)[8];
        }
      }
      break;
      case 0:
      case 1:break;
      case 2:Ra.sl[6]=1312; /* line # 1312 */
      MXD_CMP_freetext(((V *)Rv0)+7);
      break;
      case 3:Ra.sl[6]=1315; /* line # 1315 */
      if (((UB *)Rv0)[48]==3) MXD_CMP_freetext(((V *)Rv0)+8);
      Ra.sl[6]=1316; /* line # 1316 */
      while (((V *)Rv0)[7]!=NULL){
        Ra.sl[6]=1318; /* line # 1318 */
        ((V *)((V *)Rv0)[7])[4]=Rs.v[7];
        Rs.v[7]=((V *)Rv0)[7];
        Ra.sl[6]=1319; /* line # 1319 */
        ((V *)Rv0)[7]=((V *)((V *)Rv0)[7])[8];
      }
      break;
    }
    Ra.sl[6]=1324; /* line # 1324 */
    ((V *)F_p)[4]=Rs.v[7];
    Rs.v[7]=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " savecntx "  */
void MXD_CMP_savecntx(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+469;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1336; /* line # 1336 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Ra.sl[6]=1338; /* line # 1338 */
  ((C *)Rv1)[53]=Rs.c[40];
  ((C *)Rv1)[54]=Rs.c[488];
  ((UB *)Rv1)[55]=Rs.ub[42];
  Ra.sl[6]=1341; /* line # 1341 */
  Rv2=PAS__NEW(98);
  Ra.sl[6]=1342; /* line # 1342 */
  if (Rv2==NULL) MXD_CMP_error(Rd.s+481,-3);
  Ra.sl[6]=1344; /* line # 1344 */
  if (!V_fatalerror) {
    Ra.sl[6]=1345; /* line # 1345 */
    Rv3=Rv2;
    Rv4=Rv3+8;
    Rv5=Rv3+80;
    Ra.sl[6]=1347; /* line # 1347 */
    memcpy(Rv3+8,Ri.v[0]+8,65);
    Ra.sl[6]=1349; /* line # 1349 */
    ((UB *)Rv5)[16]=((UB *)Ri.v[0])[96];
    Ra.sl[6]=1350; /* line # 1350 */
    ((UB *)Rv5)[17]=((UB *)Ri.v[0])[97];
    Ra.sl[6]=1352; /* line # 1352 */
    ((SL *)Rv4)[3]=((SL *)Rv4)[3]+1;
    Ra.sl[6]=1353; /* line # 1353 */
    ((V *)Rv4)[3]=NULL;
    Ra.sl[6]=1354; /* line # 1354 */
    ((V *)Rv4)[2]=NULL;
    Ra.sl[6]=1355; /* line # 1355 */
    ((UB *)Rv4)[57]=0;
    Ra.sl[6]=1356; /* line # 1356 */
    ((SL *)Rv4)[8]=0;
    Ra.sl[6]=1357; /* line # 1357 */
    ((UB *)Rv4)[56]=0;
    Ra.sl[6]=1358; /* line # 1358 */
    ((UB *)Rv4)[59]=1;
    Ra.sl[6]=1359; /* line # 1359 */
    ((SL *)Rv4)[12]=133;
    Ra.sl[6]=1361; /* line # 1361 */
    ((V *)Rv3)[0]=Ri.v[0];
    Ra.sl[6]=1362; /* line # 1362 */
    Ri.v[0]=Rv2;
    Ra.sl[6]=1364; /* line # 1364 */
    Rs.sl[6]=((SL *)Rv4)[3];
    Ra.sl[6]=1365; /* line # 1365 */
    Rs.c[40]=32;
    Ra.sl[6]=1366; /* line # 1366 */
    Rs.c[488]=32;
    Ra.sl[6]=1367; /* line # 1367 */
    Rs.ub[42]=17;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " resetcntx "  */
void MXD_CMP_resetcntx(SL F_lvl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+485;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1379; /* line # 1379 */
  while (Rs.sl[6]>F_lvl){
    Ra.sl[6]=1381; /* line # 1381 */
    Rv0=Ri.v[0];
    Rv1=Rv0+80;
    Ra.sl[6]=1383; /* line # 1383 */
    Rv2=((V *)Rv0)[0];
    Ra.sl[6]=1384; /* line # 1384 */
    if ((((UB *)Rv1)[16]==4||((UB *)Rv1)[16]==5)&&(((UB *)Rv2)[96]==6||((UB *)Rv2)
    [96]==3)) {
      Ra.sl[6]=1388; /* line # 1388 */
      if (((UB *)Rv0)[68]) MXD_CMP_outsrclist();
      Ra.sl[6]=1389; /* line # 1389 */
      ((C *)Rs.v[1])[140]=0;
      Ra.sl[6]=1390; /* line # 1390 */
      Rs.sl[7]=0;
    }
    Ra.sl[6]=1394; /* line # 1394 */
    PAS__DISPOSE(Ri.v);
    Ra.sl[6]=1395; /* line # 1395 */
    Ri.v[0]=Rv2;
    Ra.sl[6]=1397; /* line # 1397 */
    Rv3=Ri.v[0]+8;
    Ra.sl[6]=1399; /* line # 1399 */
    ((UB *)Rv3)[57]=1;
    Ra.sl[6]=1400; /* line # 1400 */
    Rs.sl[6]=((SL *)Rv3)[3];
    Ra.sl[6]=1401; /* line # 1401 */
    if (((UB *)Rv3)[56]) {
      Ra.sl[6]=1403; /* line # 1403 */
      Rs.c[40]=((C *)Rv3)[52];
      Rs.c[488]=Rs.c[40];
      Rs.ub[42]=Ri.ub[Rs.c[488]-8];
    }
    else {
      Ra.sl[6]=1407; /* line # 1407 */
      Rs.c[40]=((C *)Rv3)[53];
      Rs.c[488]=((C *)Rv3)[54];
      Rs.ub[42]=((UB *)Rv3)[55];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " newscope "  */
void MXD_CMP_newscope(UB *F_bok){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1419; /* line # 1419 */
  (*F_bok)=0;
  Ra.sl[6]=1420; /* line # 1420 */
  if (Rs.sl[18]<32) {
    Ra.sl[6]=1422; /* line # 1422 */
    Rs.sl[18]=Rs.sl[18]+1;
    Ra.sl[6]=1423; /* line # 1423 */
    Rs.v[Rs.sl[18]+10]=NULL;
    Ra.sl[6]=1424; /* line # 1424 */
    (*F_bok)=1;
  }
  else {
    Ra.sl[6]=1426; /* line # 1426 */
    MXD_CMP_error(Rd.s+508,-8);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " relscope "  */
void MXD_CMP_relscope(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+512;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1434; /* line # 1434 */
  if (Rs.v[Rs.sl[18]+10]!=NULL) MXD_CMP_freeide(Rs.v[Rs.sl[18]+10]);
  Ra.sl[6]=1435; /* line # 1435 */
  Rs.sl[18]=Rs.sl[18] -1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getchar "  */
void MXD_CMP_getchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+522;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1444; /* line # 1444 */
  Rv0=Ri.v[0]+8;
  Ra.sl[6]=1446; /* line # 1446 */
  if (((UB *)Rv0)[56]) {
    Ra.sl[6]=1448; /* line # 1448 */
    ((UB *)Rv0)[56]=0;
    Rs.c[40]=((C *)Rv0)[53];
    Ra.sl[6]=1449; /* line # 1449 */
    Rs.c[488]=((C *)Rv0)[54];
    Rs.ub[42]=((UB *)Rv0)[55];
  }
  else {
    Ra.sl[6]=1453; /* line # 1453 */
    Rs.c[40]=((C *)((V *)Rv0)[3])[((SL *)Rv0)[12]+7];
    ((SL *)Rv0)[12]=((SL *)Rv0)[12]+1;
  }
  Ra.sl[6]=1456; /* line # 1456 */
  if (Rs.c[40]<32) Rs.c[40]=32;
  Rs.c[488]=Rs.c[40];
  Ra.sl[6]=1457; /* line # 1457 */
  if (Rs.c[488]>95) Rs.c[488]=(C)((SL)Rs.c[488]-32);
  Ra.sl[6]=1458; /* line # 1458 */
  Rs.ub[42]=Ri.ub[Rs.c[488]-8];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " incha "  */
void MXD_CMP_incha(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+531;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1466; /* line # 1466 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=1468; /* line # 1468 */
  if (((SL *)Rv1)[12]>((SL *)Rv1)[11]) {
    Ra.sl[6]=1469; /* line # 1469 */
    if (((UB *)Rv2)[16]==4||((UB *)Rv2)[16]==5) {
      Ra.sl[6]=1471; /* line # 1471 */
      MXD_CMP_get_line();
      Ra.sl[6]=1472; /* line # 1472 */
      if (((UB *)Rv1)[58]) {
        Ra.sl[6]=1475; /* line # 1475 */
        if (((V *)Rv1)[0]!=NULL) {
          Ra.sl[6]=1476; /* line # 1476 */
          if (((UB *)Rv2)[16]==4) ((UB *)((V *)Rv1)[0])[48]=3;
          else {
            Ra.sl[6]=1477; /* line # 1477 */
            ((UB *)((V *)Rv1)[0])[48]=2;
          }
        }
        Ra.sl[6]=1478; /* line # 1478 */
        MXD_CMP_resetcntx(((SL *)Rv1)[3]-1);
      }
      else {
        Ra.sl[6]=1479; /* line # 1479 */
        MXD_CMP_getchar();
      }
    }
    else {
      Ra.sl[6]=1481; /* line # 1481 */
      if (((UB *)Rv1)[58]) {
        Ra.sl[6]=1482; /* line # 1482 */
        Rs.ub[42]=16;
        Rs.c[40]=32;
      }
      else {
        Ra.sl[6]=1484; /* line # 1484 */
        if (((UB *)Rv1)[59]) {
          Ra.sl[6]=1485; /* line # 1485 */
          if (Ri.ub[88]) {
            Ra.sl[6]=1487; /* line # 1487 */
            Rs.c[40]=32;
            Rs.ub[42]=17;
          }
          else {
            while (1){
              Ra.sl[6]=1491; /* line # 1491 */
              MXD_CMP_get_line();
              if (((UB *)Rv1)[58]||!((UB *)Rv1)[59])  break;
            }
            Ra.sl[6]=1493; /* line # 1493 */
            if (((UB *)Rv1)[58]) {
              Ra.sl[6]=1494; /* line # 1494 */
              Rs.ub[42]=16;
              Rs.c[40]=32;
            }
            else {
              Ra.sl[6]=1495; /* line # 1495 */
              MXD_CMP_getchar();
            }
          }
        }
        else {
          Ra.sl[6]=1497; /* line # 1497 */
          ((UB *)Rv1)[59]=1;
          Rs.ub[42]=17;
          Rs.c[40]=32;
        }
      }
    }
  }
  else {
    Ra.sl[6]=1498; /* line # 1498 */
    MXD_CMP_getchar();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " comment "  */
void MXD_CMP_comment(C F_cs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+538;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1510; /* line # 1510 */
  MXD_CMP_incha();
  Ra.sl[6]=1511; /* line # 1511 */
  Rv0=1;
  Ra.sl[6]=1512; /* line # 1512 */
  while (Rv0){
    Ra.sl[6]=1514; /* line # 1514 */
    while (Rs.c[40]!=F_cs&&Rs.ub[42]!=16)
    MXD_CMP_incha();
    Ra.sl[6]=1515; /* line # 1515 */
    Rv0=0;
    Ra.sl[6]=1516; /* line # 1516 */
    if (F_cs==42&&Rs.ub[42]!=16) {
      Ra.sl[6]=1518; /* line # 1518 */
      MXD_CMP_incha();
      Rv0=41!=Rs.c[40];
    }
  }
  Ra.sl[6]=1521; /* line # 1521 */
  Rs.c[488]=32;
  Rs.ub[42]=18;
  Ra.sl[6]=1522; /* line # 1522 */
  Rs.c[40]=32;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inchar "  */
void MXD_CMP_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+547;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1532; /* line # 1532 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=1534; /* line # 1534 */
  if (((UB *)Rv2)[16]==4||((UB *)Rv2)[16]==5) {
    Ra.sl[6]=1535; /* line # 1535 */
    Rv3=Rs.v[1];
    Ra.sl[6]=1536; /* line # 1536 */
    if (Rs.sl[7]>112) {
      Ra.sl[6]=1537; /* line # 1537 */
      Rs.sl[7]=Rs.sl[7]+1;
    }
    else {
      Ra.sl[6]=1540; /* line # 1540 */
      Rs.sl[7]=(SL)((C *)Rv3)[140];
      Ra.sl[6]=1541; /* line # 1541 */
      Rs.sl[7]=Rs.sl[7]+1;
      Ra.sl[6]=1542; /* line # 1542 */
      ((C *)Rv3)[Rs.sl[7]+7]=Rs.c[40];
      ((C *)Rv3)[140]=(C)Rs.sl[7];
    }
  }
  Ra.sl[6]=1544; /* line # 1544 */
  Rs.c[41]=Rs.c[40];
  Ra.sl[6]=1545; /* line # 1545 */
  MXD_CMP_incha();
  Ra.sl[6]=1546; /* line # 1546 */
  if (!Ri.ub[89]) {
    Ra.sl[6]=1547; /* line # 1547 */
    if (Rs.c[40]==123) MXD_CMP_comment(125);
    else {
      Ra.sl[6]=1549; /* line # 1549 */
      if (Rs.c[40]==40&&((SL *)Rv1)[12]<=((SL *)Rv1)[11]) {
        Ra.sl[6]=1550; /* line # 1550 */
        if (((C *)((V *)Rv1)[3])[((SL *)Rv1)[12]+7]==42) {
          Ra.sl[6]=1551; /* line # 1551 */
          ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
          MXD_CMP_comment(42);
        }
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " putchar "  */
void MXD_CMP_putchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+555;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1560; /* line # 1560 */
  if (((C *)Rs.v[62])[140]>=132) {
    Ra.sl[6]=1561; /* line # 1561 */
    ((V *)Rs.v[62])[0]=P_st_create();
    Rs.v[62]=((V *)Rs.v[62])[0];
  }
  Ra.sl[6]=1562; /* line # 1562 */
  Rv0=Rs.v[62];
  Ra.sl[6]=1564; /* line # 1564 */
  ((C *)Rv0)[140]=((C *)Rv0)[140]+1;
  ((C *)Rv0)[(SL)((C *)Rv0)[140]+7]=Rs.c[40];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skipspace "  */
void MXD_CMP_skipspace(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+564;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1573; /* line # 1573 */
  if (Ri.ub[90]&&Ri.ub[91]) {
    Ra.sl[6]=1575; /* line # 1575 */
    MXD_CMP_putchar();
    Ri.ub[91]=0;
  }
  while (1){
    Ra.sl[6]=1578; /* line # 1578 */
    MXD_CMP_inchar();
    if ((Ri.ub[88]&&Rs.ub[42]==17||Rs.ub[42]==16)||Rs.c[40]!=32)  break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " nextch "  */
void MXD_CMP_nextch(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+575;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1590; /* line # 1590 */
  if (Ri.ub[90]) MXD_CMP_putchar();
  Ra.sl[6]=1591; /* line # 1591 */
  MXD_CMP_inchar();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void MXD_CMP_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  C Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  SL Rv6;
  SL Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  C Rv12;
  register V Rv13;
  register V Rv14;
  UB Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+583;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1611; /* line # 1611 */
  Rv0=NULL;
  Ra.sl[6]=1612; /* line # 1612 */
  Rv1=0;
  Ra.sl[6]=1613; /* line # 1613 */
  if ((Rs.c[40]==32&&(!Ri.ub[88]||Rs.ub[42]!=17))&&Rs.ub[42]!=16) {
    Ra.sl[6]=1614; /* line # 1614 */
    MXD_CMP_skipspace();
  }
  Ra.sl[6]=1615; /* line # 1615 */
  Rs.ub[504]=74;
  Ri.ub[91]=0;
  Rs.v[66]=NULL;
  Ri.ub[92]=1;
  Ra.sl[6]=1616; /* line # 1616 */
  switch (Rs.ub[42]) {
    case 1:
    case 2:Ra.sl[6]=1619; /* line # 1619 */
    Rs.ub[504]=16;
    Ra.sl[6]=1621; /* line # 1621 */
    Rv2=(F)0.000000E-01;
    Ra.sl[6]=1622; /* line # 1622 */
    Rv3=(F)1.000000E+01;
    Ra.sl[6]=1623; /* line # 1623 */
    Rv4=(F)1.000000E+00;
    Ra.sl[6]=1624; /* line # 1624 */
    Rs.ub[505]=2;
    Ra.sl[6]=1625; /* line # 1625 */
    while (Rs.ub[42]==1){
      Ra.sl[6]=1627; /* line # 1627 */
      Rv5=(float)((SL)Rs.c[40]-48);
      Ra.sl[6]=1628; /* line # 1628 */
      MXD_CMP_nextch();
      Ra.sl[6]=1629; /* line # 1629 */
      Rv2=Rv2*(F)1.000000E+01+Rv5;
    }
    Ra.sl[6]=1631; /* line # 1631 */
    if (Rs.ub[42]==2) {
      Ra.sl[6]=1633; /* line # 1633 */
      MXD_CMP_nextch();
      Ra.sl[6]=1634; /* line # 1634 */
      Rs.ub[505]=3;
      Ra.sl[6]=1635; /* line # 1635 */
      while (Rs.ub[42]==1){
        Ra.sl[6]=1637; /* line # 1637 */
        Rv5=(float)((SL)Rs.c[40]-48);
        Ra.sl[6]=1638; /* line # 1638 */
        MXD_CMP_nextch();
        Ra.sl[6]=1639; /* line # 1639 */
        Rv4=Rv4/(F)1.000000E+01;
        Ra.sl[6]=1640; /* line # 1640 */
        Rv2=Rv2+Rv4*Rv5;
      }
    }
    Ra.sl[6]=1643; /* line # 1643 */
    if (Rs.c[488]==69) {
      Ra.sl[6]=1645; /* line # 1645 */
      Rs.ub[505]=3;
      Ra.sl[6]=1646; /* line # 1646 */
      MXD_CMP_nextch();
      Ra.sl[6]=1647; /* line # 1647 */
      if (Rs.c[40]==43||Rs.c[40]==45) {
        Ra.sl[6]=1649; /* line # 1649 */
        if (Rs.c[40]==45) Rv3=(F)1.000000E+00/Rv3;
        Ra.sl[6]=1650; /* line # 1650 */
        MXD_CMP_nextch();
      }
      Ra.sl[6]=1652; /* line # 1652 */
      Rv6=0;
      Ra.sl[6]=1653; /* line # 1653 */
      while (Rs.ub[42]==1){
        Ra.sl[6]=1655; /* line # 1655 */
        Rv6=Rv6*10+((SL)Rs.c[40]-48);
        Ra.sl[6]=1656; /* line # 1656 */
        MXD_CMP_nextch();
      }
      Ra.sl[6]=1658; /* line # 1658 */
      if (Rv6>38) MXD_CMP_error(Rd.s+595,11);
      Ra.sl[6]=1659; /* line # 1659 */
      Rv4=(F)1.000000E+00;
      Ra.sl[6]=1660; /* line # 1660 */
      while (Rv6!=0){
        Ra.sl[6]=1661; /* line # 1661 */
        if (Rv6&1) {
          Ra.sl[6]=1662; /* line # 1662 */
          Rv6=Rv6-1;
          Rv4=Rv4*Rv3;
        }
        else {
          Ra.sl[6]=1664; /* line # 1664 */
          Rv6=Rv6/2;
          Rv3=Rv3*Rv3;
        }
      }
      Ra.sl[6]=1665; /* line # 1665 */
      Rv2=Rv2*Rv4;
    }
    Ra.sl[6]=1667; /* line # 1667 */
    if ((Rs.ub[505]==2&&Rv2<=(F)3.276700E+04)&&Rv2>=(F)-3.276800E+04) {
      Ra.sl[6]=1668; /* line # 1668 */
      Rs.f[127]=(float)(int)(Rv2);
      Rs.f[128]=Rs.f[127];
    }
    else {
      Ra.sl[6]=1669; /* line # 1669 */
      Rs.f[127]=(F)0.000000E-01;
      Rs.ub[505]=3;
    }
    Ra.sl[6]=1670; /* line # 1670 */
    Rs.f[128]=Rv2;
    Ra.sl[6]=1671; /* line # 1671 */
    Ri.ub[91]=1;
    break;
    case 0:Ra.sl[6]=1675; /* line # 1675 */
    Ra.sl[6]=1678; /* line # 1678 */
    Rv7=Rs.sl[7];
    Ra.sl[6]=1679; /* line # 1679 */
    if (Ri.ub[90]) {
      Ra.sl[6]=1680; /* line # 1680 */
      Rv0=Rs.v[62];
      Rv1=((C *)Rs.v[62])[140];
    }
    Ra.sl[6]=1681; /* line # 1681 */
    Rv6=0;
    PAS__CHT_TO_CHT(Rs.s+507,16, Rd.s+601,8);
    Ra.sl[6]=1682; /* line # 1682 */
    Rv8=!Ri.ub[93]&&Rs.c[40]==34;
    Ra.sl[6]=1683; /* line # 1683 */
    if (Rv8) MXD_CMP_nextch();
    Ra.sl[6]=1684; /* line # 1684 */
    while ((Rs.ub[42]==0||Rs.ub[42]==1)||Rs.ub[42]==2){
      Ra.sl[6]=1686; /* line # 1686 */
      Rv6=Rv6+1;
      Ra.sl[6]=1687; /* line # 1687 */
      if (Rv6<=16) Rs.c[Rv6+506]=Rs.c[488];
      Ra.sl[6]=1688; /* line # 1688 */
      MXD_CMP_nextch();
    }
    Ra.sl[6]=1690; /* line # 1690 */
    if (Rv6>16) Rv6=16;
    Ra.sl[6]=1691; /* line # 1691 */
    Rs.c[506]=(C)Rv6;
    Ra.sl[6]=1693; /* line # 1693 */
    MXD_CMP_searchid(Rs.s+506,Rs.v+66,0);
    Ra.sl[6]=1694; /* line # 1694 */
    Rs.ub[505]=0;
    Ra.sl[6]=1695; /* line # 1695 */
    if (Rv8) {
      Ra.sl[6]=1696; /* line # 1696 */
      if (Rs.v[66]==NULL) MXD_CMP_error(Rd.s+595,51);
      else {
        Ra.sl[6]=1698; /* line # 1698 */
        Rv9=Rs.v[66];
        Ra.sl[6]=1699; /* line # 1699 */
        if (((UB *)Rv9)[48]!=10) MXD_CMP_error(Rd.s+595,52);
        else {
          Ra.sl[6]=1701; /* line # 1701 */
          if (((UB *)Rv9)[49]!=1) MXD_CMP_error(Rd.s+595,52);
          else {
            Ra.sl[6]=1704; /* line # 1704 */
            PAS__CHT_TO_CHT(Rs.s+507,16, Rd.s+611,8);
            Ra.sl[6]=1705; /* line # 1705 */
            Rv10=(SL)((C *)((V *)Rv9)[7])[140];
            Ra.sl[6]=1706; /* line # 1706 */
            if (Rv10>8) Rv10=8;
            Ra.sl[6]=1707; /* line # 1707 */
            Rv11=1;
            for( Rf0=Rv10;Rf0>0;Rf0-- ) {
              Ra.sl[6]=1709; /* line # 1709 */
              Rv12=((C *)((V *)Rv9)[7])[Rv11+7];
              Ra.sl[6]=1710; /* line # 1710 */
              if (Rv12>95) Rv12=(C)((SL)Rv12-32);
              Ra.sl[6]=1711; /* line # 1711 */
              Rs.c[Rv11+506]=Rv12;
              Rv11++;
            }
            Ra.sl[6]=1713; /* line # 1713 */
            Rs.c[506]=(C)Rv10;
            Ra.sl[6]=1714; /* line # 1714 */
            MXD_CMP_searchid(Rs.s+506,Rs.v+66,0);
          }
        }
      }
    }
    Ra.sl[6]=1716; /* line # 1716 */
    if (Rs.v[66]!=NULL) {
      Ra.sl[6]=1717; /* line # 1717 */
      Rv13=Rs.v[66];
      Ra.sl[6]=1718; /* line # 1718 */
      switch (((UB *)Rv13)[48]) {
        case 5:Ra.sl[6]=1720; /* line # 1720 */
        Rs.ub[504]=((UB *)Rv13)[49];
        Rs.ub[505]=5;
        break;
        case 4:
        case 6:
        case 7:
        case 8:
        case 18:Ra.sl[6]=1722; /* line # 1722 */
        Rs.ub[504]=((UB *)Rv13)[49];
        break;
        case 10:Ra.sl[6]=1724; /* line # 1724 */
        Rs.ub[504]=2;
        break;
        case 12:
        case 13:Ra.sl[6]=1726; /* line # 1726 */
        Rs.ub[504]=1;
        break;
        case 11:Ra.sl[6]=1728; /* line # 1728 */
        Rs.ub[504]=3;
        break;
        case 14:Ra.sl[6]=1730; /* line # 1730 */
        Rs.ub[504]=4;
        break;
        case 16:Ra.sl[6]=1733; /* line # 1733 */
        if (((V *)Rv13)[8]!=Rs.v[66]) Rs.ub[504]=56;
        else {
          Ra.sl[6]=1734; /* line # 1734 */
          Rs.ub[504]=57;
        }
        break;
        case 15:Ra.sl[6]=1736; /* line # 1736 */
        Rs.ub[504]=7;
        break;
        case 17:Ra.sl[6]=1738; /* line # 1738 */
        Rs.ub[504]=5;
        break;
        case 2:Ra.sl[6]=1741; /* line # 1741 */
        if (Ri.ub[90]) {
          Ra.sl[6]=1744; /* line # 1744 */
          if (Rv0!=Rs.v[62]) {
            Ra.sl[6]=1745; /* line # 1745 */
            MXD_CMP_freetext(Rs.v+62);
            Rs.v[62]=Rv0;
          }
          Ra.sl[6]=1746; /* line # 1746 */
          ((C *)Rs.v[62])[140]=Rv1;
        }
        Ra.sl[6]=1749; /* line # 1749 */
        if (((UB *)Ri.v[0])[96]==4||((UB *)Ri.v[0])[96]==5) {
          Ra.sl[6]=1752; /* line # 1752 */
          Rs.sl[7]=Rv7;
          Ra.sl[6]=1753; /* line # 1753 */
          Rv14=Rs.v[1];
          Ra.sl[6]=1755; /* line # 1755 */
          Rv6=(SL)((C *)Rv14)[140];
          Ra.sl[6]=1756; /* line # 1756 */
          if (Rv6>Rs.sl[7]) ((C *)Rv14)[140]=(C)Rs.sl[7];
        }
        Ra.sl[6]=1760; /* line # 1760 */
        if (((V *)Rs.v[66])[7]!=NULL) {
          Ra.sl[6]=1763; /* line # 1763 */
          ((UB *)Rs.v[66])[48]=1;
          Ra.sl[6]=1764; /* line # 1764 */
          MXD_CMP_activemacpar(Rs.v[66],((V *)Rs.v[66])[7],5);
        }
        else {
          Ra.sl[6]=1767; /* line # 1767 */
          Ri.ub[92]=0;
          Rs.ub[504]=74;
        }
        break;
        default:break;
      }
    }
    Ra.sl[6]=1771; /* line # 1771 */
    Ri.ub[91]=1;
    break;
    case 3:
    case 4:
    case 5:
    case 12:
    case 13:
    case 23:
    case 24:Ra.sl[6]=1775; /* line # 1775 */
    Ra.sl[6]=1777; /* line # 1777 */
    Rs.ub[505]=4;
    Rs.ub[506]=Rs.ub[42];
    MXD_CMP_nextch();
    Ra.sl[6]=1778; /* line # 1778 */
    switch (Rs.ub[506]) {
      case 5:Ra.sl[6]=1780; /* line # 1780 */
      if (Rs.ub[42]!=14) Rs.ub[504]=149;
      else {
        Ra.sl[6]=1782; /* line # 1782 */
        Rs.ub[505]=5;
        Rs.ub[506]=14;
        Ra.sl[6]=1783; /* line # 1783 */
        Rs.ub[504]=134;
        MXD_CMP_nextch();
      }
      break;
      case 3:Ra.sl[6]=1786; /* line # 1786 */
      Rs.ub[504]=150;
      break;
      case 12:Ra.sl[6]=1788; /* line # 1788 */
      Rs.ub[504]=151;
      break;
      case 13:Ra.sl[6]=1790; /* line # 1790 */
      Rs.ub[504]=152;
      break;
      case 4:Ra.sl[6]=1792; /* line # 1792 */
      Rs.ub[504]=155;
      break;
      case 23:Ra.sl[6]=1794; /* line # 1794 */
      Rs.ub[504]=153;
      break;
      case 24:Ra.sl[6]=1796; /* line # 1796 */
      Rs.ub[504]=154;
      break;
    }
    break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 14:
    case 19:
    case 20:
    case 21:
    case 22:Ra.sl[6]=1802; /* line # 1802 */
    Ra.sl[6]=1804; /* line # 1804 */
    Rs.ub[505]=5;
    Rs.ub[506]=Rs.ub[42];
    MXD_CMP_nextch();
    Ra.sl[6]=1805; /* line # 1805 */
    switch (Rs.ub[506]) {
      case 6:Ra.sl[6]=1806; /* line # 1806 */
      Rs.ub[504]=17;
      break;
      case 7:Ra.sl[6]=1807; /* line # 1807 */
      Rs.ub[504]=18;
      break;
      case 8:Ra.sl[6]=1808; /* line # 1808 */
      if (Rs.ub[42]!=8) Rs.ub[504]=19;
      else {
        Ra.sl[6]=1809; /* line # 1809 */
        MXD_CMP_nextch();
        Rs.ub[504]=22;
      }
      break;
      case 9:Ra.sl[6]=1810; /* line # 1810 */
      Rs.ub[504]=20;
      break;
      case 22:Ra.sl[6]=1811; /* line # 1811 */
      if (Rs.ub[42]!=22) Rs.ub[504]=136;
      else {
        Ra.sl[6]=1812; /* line # 1812 */
        MXD_CMP_nextch();
        Rs.ub[504]=138;
      }
      break;
      case 21:Ra.sl[6]=1813; /* line # 1813 */
      Rs.ub[504]=135;
      break;
      case 14:Ra.sl[6]=1814; /* line # 1814 */
      Rs.ub[504]=50;
      break;
      case 10:Ra.sl[6]=1815; /* line # 1815 */
      Rs.ub[504]=22;
      break;
      case 19:Ra.sl[6]=1816; /* line # 1816 */
      if (Rs.ub[42]==20) {
        Rs.ub[504]=51;
        MXD_CMP_nextch();
      }
      else {
        Ra.sl[6]=1818; /* line # 1818 */
        if (Rs.ub[42]==14) {
          Ra.sl[6]=1819; /* line # 1819 */
          Rs.ub[504]=53;
          MXD_CMP_nextch();
        }
        else {
          Ra.sl[6]=1820; /* line # 1820 */
          Rs.ub[504]=52;
        }
      }
      break;
      case 20:Ra.sl[6]=1821; /* line # 1821 */
      if (Rs.ub[42]==14) {
        Rs.ub[504]=54;
        MXD_CMP_nextch();
      }
      else {
        Ra.sl[6]=1822; /* line # 1822 */
        Rs.ub[504]=55;
      }
      break;
    }
    break;
    case 11:Ra.sl[6]=1828; /* line # 1828 */
    if (!Ri.ub[93]) Rs.v[64]=P_st_create();
    Ra.sl[6]=1829; /* line # 1829 */
    Ra.sl[6]=1831; /* line # 1831 */
    Rv15=1;
    Rv6=1;
    Ri.ub[89]=1;
    Ra.sl[6]=1832; /* line # 1832 */
    while (Rv15){
      Ra.sl[6]=1834; /* line # 1834 */
      MXD_CMP_nextch();
      Ra.sl[6]=1835; /* line # 1835 */
      if (Rs.ub[42]==17) MXD_CMP_inchar();
      Ra.sl[6]=1836; /* line # 1836 */
      if (Rs.ub[42]==16) Rv15=0;
      Ra.sl[6]=1837; /* line # 1837 */
      if (Rs.c[40]==39) {
        Ra.sl[6]=1839; /* line # 1839 */
        MXD_CMP_nextch();
        Ra.sl[6]=1840; /* line # 1840 */
        if (Rs.c[40]==39) {
          Ra.sl[6]=1841; /* line # 1841 */
          if (!Ri.ub[93]) ((C *)Rs.v[64])[Rv6+7]=Rs.c[40];
        }
        else {
          Ra.sl[6]=1842; /* line # 1842 */
          Rv15=0;
        }
      }
      else {
        Ra.sl[6]=1845; /* line # 1845 */
        if (!Ri.ub[93]) ((C *)Rs.v[64])[Rv6+7]=Rs.c[40];
      }
      Ra.sl[6]=1846; /* line # 1846 */
      if (Rv15&&Rv6<132) Rv6=Rv6+1;
      else {
        Ra.sl[6]=1848; /* line # 1848 */
        if (Rv15) {
          MXD_CMP_error(Rd.s+595,12);
          Rv15=0;
        }
      }
    }
    Ra.sl[6]=1850; /* line # 1850 */
    Ri.ub[89]=0;
    Ra.sl[6]=1851; /* line # 1851 */
    if (!Ri.ub[93]) ((C *)Rs.v[64])[140]=(C)(Rv6-1);
    Ra.sl[6]=1852; /* line # 1852 */
    Rs.ub[505]=1;
    Rs.ub[504]=16;
    break;
    case 15:Ra.sl[6]=1858; /* line # 1858 */
    if (Rs.c[40]!=32) MXD_CMP_error(Rd.s+595,13);
    Ra.sl[6]=1859; /* line # 1859 */
    MXD_CMP_inchar();
    break;
    case 17:Ra.sl[6]=1862; /* line # 1862 */
    Rs.ub[505]=6;
    MXD_CMP_nextch();
    break;
    case 16:Ra.sl[6]=1864; /* line # 1864 */
    Rs.ub[505]=7;
    Rs.ub[504]=102;
    break;
  }
  Ra.sl[6]=1868; /* line # 1868 */
  Rv16=Ri.v[0];
  Rv17=Rv16+8;
  Rv18=Rv16+80;
  Ra.sl[6]=1869; /* line # 1869 */
  if (((UB *)Rv18)[16]==4||((UB *)Rv18)[16]==5) {
    Ra.sl[6]=1870; /* line # 1870 */
    if (Rs.sl[7]>=80||Rs.ub[504]==155) {
      Ra.sl[6]=1872; /* line # 1872 */
      if (((UB *)Rv17)[60]) MXD_CMP_outsrclist();
      Ra.sl[6]=1873; /* line # 1873 */
      ((C *)Rs.v[1])[140]=0;
      Ra.sl[6]=1874; /* line # 1874 */
      Rs.sl[7]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inparam "  */
void MXD_CMP_inparam(V *F_ppar, UB F_bpar){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  C Rv2;
  UB Rv3;
  C Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+619;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1906; /* line # 1906 */
  Rv0=NULL;
  Ra.sl[6]=1907; /* line # 1907 */
  Ri.ub[93]=1;
  Ra.sl[6]=1908; /* line # 1908 */
  Rv1=0;
  Ra.sl[6]=1909; /* line # 1909 */
  Rs.v[62]=P_st_create();
  Ra.sl[6]=1910; /* line # 1910 */
  Ri.ub[90]=1;
  Ra.sl[6]=1911; /* line # 1911 */
  Ri.ub[91]=0;
  Ra.sl[6]=1912; /* line # 1912 */
  if (F_bpar) {
    Ra.sl[6]=1914; /* line # 1914 */
    Rv2=Rs.c[40];
    Rs.c[40]=40;
    MXD_CMP_putchar();
    Rs.c[40]=Rv2;
  }
  Ra.sl[6]=1916; /* line # 1916 */
  (*F_ppar)=NULL;
  Ra.sl[6]=1917; /* line # 1917 */
  if (Rs.ub[504]!=155) MXD_CMP_insymbol();
  Ra.sl[6]=1918; /* line # 1918 */
  Ra.sl[6]=1919; /* line # 1919 */
  if (((Rs.ub[504]!=150&&Rs.ub[504]!=155)&&Rs.ub[504]!=152)&&Rs.ub[505]!=7) {
    Ra.sl[6]=1922; /* line # 1922 */
    (*F_ppar)=Rs.v[62];
    while (1){
      Ra.sl[6]=1924; /* line # 1924 */
      Rv3=0;
      Ra.sl[6]=1925; /* line # 1925 */
      if (Rs.ub[505]==4) {
        Ra.sl[6]=1927; /* line # 1927 */
        if (Rs.ub[506]==12) Rv1=Rv1+1;
        else {
          Ra.sl[6]=1929; /* line # 1929 */
          if (Rv1>0) {
            Ra.sl[6]=1931; /* line # 1931 */
            if (Rs.ub[506]==13) Rv1=Rv1-1;
            else {
              Ra.sl[6]=1932; /* line # 1932 */
              Rv3=Rs.ub[506]==4;
            }
          }
          else {
            Ra.sl[6]=1934; /* line # 1934 */
            Rv3=(Rs.ub[506]==4||Rs.ub[506]==3)||Rs.ub[506]==13;
          }
        }
      }
      Ra.sl[6]=1936; /* line # 1936 */
      if (!Rv3) {
        Ra.sl[6]=1937; /* line # 1937 */
        Rv0=Rs.v[62];
        Rv4=((C *)Rv0)[140];
        MXD_CMP_insymbol();
      }
      if (Rv3||Rs.ub[505]==7)  break;
    }
    Ra.sl[6]=1940; /* line # 1940 */
    ((C *)Rv0)[140]=Rv4;
    Ra.sl[6]=1941; /* line # 1941 */
    if (Rv0!=Rs.v[62]) MXD_CMP_freetext(Rs.v+62);
    Ra.sl[6]=1942; /* line # 1942 */
    Rs.c[41]=Rs.c[40];
    Rs.c[40]=32;
    Ra.sl[6]=1943; /* line # 1943 */
    if (F_bpar) {
      Ra.sl[6]=1944; /* line # 1944 */
      Rv2=Rs.c[40];
      Rs.c[40]=41;
      MXD_CMP_putchar();
      Rs.c[40]=Rv2;
    }
    Ra.sl[6]=1945; /* line # 1945 */
    MXD_CMP_putchar();
    Ra.sl[6]=1946; /* line # 1946 */
    Rs.c[40]=Rs.c[41];
  }
  else {
    Ra.sl[6]=1947; /* line # 1947 */
    MXD_CMP_freetext(F_ppar);
    (*F_ppar)=NULL;
  }
  Ra.sl[6]=1948; /* line # 1948 */
  Ri.ub[90]=0;
  Ri.ub[93]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inmactxt "  */
void MXD_CMP_inmactxt(UB F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+628;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1959; /* line # 1959 */
  Rv0=0;
  Ra.sl[6]=1960; /* line # 1960 */
  Ra.sl[6]=1961; /* line # 1961 */
  while (!Rv0&&Rs.ub[505]!=7){
    Ra.sl[6]=1963; /* line # 1963 */
    if (Rs.ub[505]==0) {
      Ra.sl[6]=1965; /* line # 1965 */
      if (Rs.ub[504]>=110&&Rs.ub[504]<=113) {
        Ra.sl[6]=1967; /* line # 1967 */
        Rv1=Rs.ub[504];
        MXD_CMP_insymbol();
        Ra.sl[6]=1968; /* line # 1968 */
        switch (Rv1) {
          case 110:Ra.sl[6]=1969; /* line # 1969 */
          MXD_CMP_inmactxt(115);
          break;
          case 111:Ra.sl[6]=1970; /* line # 1970 */
          MXD_CMP_inmactxt(116);
          break;
          case 112:Ra.sl[6]=1971; /* line # 1971 */
          MXD_CMP_inmactxt(117);
          break;
          case 113:Ra.sl[6]=1972; /* line # 1972 */
          MXD_CMP_inmactxt(118);
          break;
        }
        Ra.sl[6]=1974; /* line # 1974 */
        MXD_CMP_insymbol();
      }
      else {
        Ra.sl[6]=1977; /* line # 1977 */
        if (Rs.ub[504]==F_nd||Rs.ub[504]==116&&F_nd==119) {
          Ra.sl[6]=1978; /* line # 1978 */
          Rv0=1;
        }
        else {
          Ra.sl[6]=1979; /* line # 1979 */
          MXD_CMP_insymbol();
        }
      }
    }
    else {
      Ra.sl[6]=1980; /* line # 1980 */
      MXD_CMP_insymbol();
    }
  }
  Ra.sl[6]=1982; /* line # 1982 */
  if (Rs.ub[505]==7) MXD_CMP_error(Rd.s+640,-77);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inmacro "  */
void MXD_CMP_inmacro(V *F_ptxt, UB F_bout, UB F_macmd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  C Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+644;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1995; /* line # 1995 */
  Ri.ub[90]=F_bout;
  Ri.ub[93]=1;
  Ri.ub[91]=0;
  Ra.sl[6]=1996; /* line # 1996 */
  if (Ri.ub[90]) Rs.v[62]=P_st_create();
  else {
    Ra.sl[6]=1997; /* line # 1997 */
    Rs.v[62]=NULL;
  }
  Ra.sl[6]=1998; /* line # 1998 */
  (*F_ptxt)=Rs.v[62];
  Ra.sl[6]=1999; /* line # 1999 */
  Ra.sl[6]=2000; /* line # 2000 */
  if (Rs.ub[505]!=7) {
    Ra.sl[6]=2002; /* line # 2002 */
    switch (F_macmd) {
      case 4:Ra.sl[6]=2003; /* line # 2003 */
      MXD_CMP_inmactxt(118);
      break;
      case 1:Ra.sl[6]=2004; /* line # 2004 */
      MXD_CMP_inmactxt(116);
      break;
      case 3:Ra.sl[6]=2005; /* line # 2005 */
      MXD_CMP_inmactxt(117);
      break;
      case 2:Ra.sl[6]=2006; /* line # 2006 */
      MXD_CMP_inmactxt(119);
      break;
      case 0:Ra.sl[6]=2008; /* line # 2008 */
      MXD_CMP_insymbol();
      Ra.sl[6]=2009; /* line # 2009 */
      MXD_CMP_inmactxt(115);
      Ra.sl[6]=2010; /* line # 2010 */
      while (Rs.ub[505]!=7&&Rs.ub[504]!=155){
        Ra.sl[6]=2011; /* line # 2011 */
        MXD_CMP_insymbol();
      }
      break;
    }
    Ra.sl[6]=2014; /* line # 2014 */
    if (F_bout) {
      Ra.sl[6]=2016; /* line # 2016 */
      Rv0=Rs.c[40];
      Rs.c[40]=59;
      Ra.sl[6]=2017; /* line # 2017 */
      if (Ri.ub[90]) MXD_CMP_putchar();
      Rs.c[40]=Rv0;
    }
  }
  Ra.sl[6]=2020; /* line # 2020 */
  Ri.ub[90]=0;
  Ri.ub[93]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " activemacpar "  */
void MXD_CMP_activemacpar(V F_pm, V F_p, UB F_modf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+653;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2028; /* line # 2028 */
  if (F_p!=NULL) {
    Ra.sl[6]=2030; /* line # 2030 */
    MXD_CMP_savecntx();
    Ra.sl[6]=2031; /* line # 2031 */
    Rv0=Ri.v[0];
    Rv1=Rv0+8;
    Rv2=Rv0+80;
    Ra.sl[6]=2033; /* line # 2033 */
    ((V *)Rv1)[0]=F_pm;
    Ra.sl[6]=2034; /* line # 2034 */
    ((UB *)Rv1)[59]=0;
    Ra.sl[6]=2035; /* line # 2035 */
    ((SL *)Rv1)[11]=(SL)((C *)F_p)[140];
    Ra.sl[6]=2036; /* line # 2036 */
    if (!((UB *)Rv1)[60]||((UB *)Rv2)[16]!=4) {
      Ra.sl[6]=2038; /* line # 2038 */
      if (F_modf==4) ((UB *)Rv1)[60]=((UB *)Rv1)[61];
      else {
        Ra.sl[6]=2039; /* line # 2039 */
        ((UB *)Rv1)[60]=((UB *)Rv1)[62];
      }
    }
    Ra.sl[6]=2040; /* line # 2040 */
    ((SL *)Rv1)[9]=1;
    Ra.sl[6]=2041; /* line # 2041 */
    ((SL *)Rv1)[12]=1;
    Ra.sl[6]=2042; /* line # 2042 */
    ((UB *)Rv2)[16]=F_modf;
    Ra.sl[6]=2043; /* line # 2043 */
    ((V *)Rv1)[3]=F_p;
    Ra.sl[6]=2045; /* line # 2045 */
    Rs.ub[42]=18;
    Ra.sl[6]=2046; /* line # 2046 */
    MXD_CMP_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip "  */
void MXD_CMP_skip(UB F_nd, UB F_bps){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+667;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2056; /* line # 2056 */
  Ra.sl[6]=2057; /* line # 2057 */
  while ((Rs.ub[505]!=7&&Rs.ub[504]!=F_nd)&&Rs.ub[504]!=155){
    Ra.sl[6]=2058; /* line # 2058 */
    MXD_CMP_insymbol();
  }
  Ra.sl[6]=2059; /* line # 2059 */
  if (F_bps) {
    Ra.sl[6]=2060; /* line # 2060 */
    if (Rs.ub[505]!=7&&F_nd==Rs.ub[504]) MXD_CMP_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " looksymbol "  */
void MXD_CMP_looksymbol(UB F_nd, SL F_ier, UB F_bps){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+673;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2068; /* line # 2068 */
  Ra.sl[6]=2069; /* line # 2069 */
  if (Rs.ub[504]!=F_nd) MXD_CMP_error(Rd.s+687,F_ier);
  else {
    Ra.sl[6]=2070; /* line # 2070 */
    if (F_bps) MXD_CMP_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " indata "  */
void MXD_CMP_indata(F *F_rv, UB *F_bs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+691;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2083; /* line # 2083 */
  Rv0=0;
  Rv1=0;
  Rv2=0;
  Ra.sl[6]=2084; /* line # 2084 */
  Ra.sl[6]=2086; /* line # 2086 */
  Ri.ub[88]=1;
  Ra.sl[6]=2087; /* line # 2087 */
  if (Rs.ub[505]==5) {
    Ra.sl[6]=2089; /* line # 2089 */
    Rv2=1;
    Ra.sl[6]=2090; /* line # 2090 */
    Rv1=Rs.ub[506]==7;
    Ra.sl[6]=2091; /* line # 2091 */
    if (Rs.ub[506]!=7&&Rs.ub[506]!=6) MXD_CMP_error(Rd.s+701,14);
    else {
      Ra.sl[6]=2092; /* line # 2092 */
      Rv0=1;
    }
    Ra.sl[6]=2093; /* line # 2093 */
    MXD_CMP_insymbol();
  }
  Ra.sl[6]=2095; /* line # 2095 */
  switch (Rs.ub[505]) {
    case 2:
    case 3:Ra.sl[6]=2098; /* line # 2098 */
    Rv2=1;
    Ra.sl[6]=2099; /* line # 2099 */
    Rv0=0;
    Ra.sl[6]=2100; /* line # 2100 */
    (*F_rv)=Rs.f[128];
    if (Rv1) (*F_rv)= -(*F_rv);
    break;
    case 4:Ra.sl[6]=2103; /* line # 2103 */
    if (Rs.ub[506]==3||Rs.ub[506]==4) {
      Ra.sl[6]=2105; /* line # 2105 */
      if (Rv0) Rs.f[127]=(float)((SL)Rv1+1);
    }
    else {
      Ra.sl[6]=2107; /* line # 2107 */
      MXD_CMP_error(Rd.s+701,15);
    }
    break;
    case 5:Ra.sl[6]=2110; /* line # 2110 */
    Rv2=1;
    Ra.sl[6]=2111; /* line # 2111 */
    if (Rv0) {
      Ra.sl[6]=2112; /* line # 2112 */
      if (Rs.ub[506]!=6&&Rs.ub[506]!=7) MXD_CMP_error(Rd.s+701,16);
      else {
        Ra.sl[6]=2113; /* line # 2113 */
        (*F_rv)=(float)(((SL)Rv1+2*(SL)(Rs.ub[506]==7))+4);
      }
    }
    break;
    case 0:break;
    case 1:
    case 8:Ra.sl[6]=2116; /* line # 2116 */
    MXD_CMP_error(Rd.s+701,17);
    break;
    case 6:
    case 7:break;
  }
  Ra.sl[6]=2119; /* line # 2119 */
  if (Rv2) MXD_CMP_insymbol();
  Ra.sl[6]=2121; /* line # 2121 */
  if (Rs.ub[505]==4&&Rs.ub[506]==3) MXD_CMP_insymbol();
  Ra.sl[6]=2122; /* line # 2122 */
  Ri.ub[88]=0;
  Ra.sl[6]=2124; /* line # 2124 */
  (*F_bs)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setkword "  */
void MXD_CMP_setkword(V F_name, UB F_kty, UB F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+705;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2136; /* line # 2136 */
  Rv0=((UB *)F_name)[1];
  Ra.sl[6]=2137; /* line # 2137 */
  Ra.sl[6]=2139; /* line # 2139 */
  Ra.c[28]=(C)Rv0;
  Ra.sl[6]=2140; /* line # 2140 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.c[Rv1+28]=((C *)F_name)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=2141; /* line # 2141 */
  Rv2=Rv0+1;
  for( Rf0=17-(Rv0+1);Rf0>0;Rf0-- ) {
    Ra.c[Rv2+28]=32;
    Rv2++;
  }
  Ra.sl[6]=2143; /* line # 2143 */
  MXD_CMP_searchid(Ra.s+28,&Rv3,1);
  Ra.sl[6]=2144; /* line # 2144 */
  Rv4=Rv3;
  Ra.sl[6]=2145; /* line # 2145 */
  ((UB *)Rv4)[48]=F_kty;
  ((UB *)Rv4)[49]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initable "  */
void MXD_CMP_initable(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+715;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2154; /* line # 2154 */
  MXD_CMP_setkword(Rd.s+725,6,31);
  Ra.sl[6]=2155; /* line # 2155 */
  MXD_CMP_setkword(Rd.s+730,6,30);
  Ra.sl[6]=2156; /* line # 2156 */
  MXD_CMP_setkword(Rd.s+735,6,24);
  Ra.sl[6]=2157; /* line # 2157 */
  MXD_CMP_setkword(Rd.s+740,6,25);
  Ra.sl[6]=2158; /* line # 2158 */
  MXD_CMP_setkword(Rd.s+745,6,32);
  Ra.sl[6]=2159; /* line # 2159 */
  MXD_CMP_setkword(Rd.s+751,6,26);
  Ra.sl[6]=2160; /* line # 2160 */
  MXD_CMP_setkword(Rd.s+756,6,29);
  Ra.sl[6]=2161; /* line # 2161 */
  MXD_CMP_setkword(Rd.s+762,6,27);
  Ra.sl[6]=2162; /* line # 2162 */
  MXD_CMP_setkword(Rd.s+768,6,28);
  Ra.sl[6]=2163; /* line # 2163 */
  MXD_CMP_setkword(Rd.s+774,6,33);
  Ra.sl[6]=2164; /* line # 2164 */
  MXD_CMP_setkword(Rd.s+780,6,36);
  Ra.sl[6]=2165; /* line # 2165 */
  MXD_CMP_setkword(Rd.s+790,7,41);
  Ra.sl[6]=2166; /* line # 2166 */
  MXD_CMP_setkword(Rd.s+798,7,42);
  Ra.sl[6]=2167; /* line # 2167 */
  MXD_CMP_setkword(Rd.s+806,7,63);
  Ra.sl[6]=2168; /* line # 2168 */
  MXD_CMP_setkword(Rd.s+815,7,140);
  Ra.sl[6]=2169; /* line # 2169 */
  MXD_CMP_setkword(Rd.s+823,7,40);
  Ra.sl[6]=2170; /* line # 2170 */
  MXD_CMP_setkword(Rd.s+829,7,43);
  Ra.sl[6]=2171; /* line # 2171 */
  MXD_CMP_setkword(Rd.s+837,6,144);
  Ra.sl[6]=2172; /* line # 2172 */
  MXD_CMP_setkword(Rd.s+845,6,141);
  Ra.sl[6]=2173; /* line # 2173 */
  MXD_CMP_setkword(Rd.s+853,6,142);
  Ra.sl[6]=2174; /* line # 2174 */
  MXD_CMP_setkword(Rd.s+860,6,143);
  Ra.sl[6]=2175; /* line # 2175 */
  MXD_CMP_setkword(Rd.s+868,6,145);
  Ra.sl[6]=2176; /* line # 2176 */
  MXD_CMP_setkword(Rd.s+876,6,35);
  Ra.sl[6]=2177; /* line # 2177 */
  MXD_CMP_setkword(Rd.s+881,6,49);
  Ra.sl[6]=2178; /* line # 2178 */
  MXD_CMP_setkword(Rd.s+888,6,48);
  Ra.sl[6]=2180; /* line # 2180 */
  MXD_CMP_setkword(Rd.s+896,6,148);
  Ra.sl[6]=2182; /* line # 2182 */
  MXD_CMP_setkword(Rd.s+908,18,146);
  Ra.sl[6]=2183; /* line # 2183 */
  MXD_CMP_setkword(Rd.s+917,18,147);
  Ra.sl[6]=2186; /* line # 2186 */
  MXD_CMP_setkword(Rd.s+927,4,103);
  Ra.sl[6]=2187; /* line # 2187 */
  MXD_CMP_setkword(Rd.s+935,4,110);
  Ra.sl[6]=2188; /* line # 2188 */
  MXD_CMP_setkword(Rd.s+943,4,115);
  Ra.sl[6]=2189; /* line # 2189 */
  MXD_CMP_setkword(Rd.s+950,4,112);
  Ra.sl[6]=2190; /* line # 2190 */
  MXD_CMP_setkword(Rd.s+957,4,120);
  Ra.sl[6]=2191; /* line # 2191 */
  MXD_CMP_setkword(Rd.s+964,4,111);
  Ra.sl[6]=2192; /* line # 2192 */
  MXD_CMP_setkword(Rd.s+968,4,114);
  Ra.sl[6]=2193; /* line # 2193 */
  MXD_CMP_setkword(Rd.s+974,4,119);
  Ra.sl[6]=2194; /* line # 2194 */
  MXD_CMP_setkword(Rd.s+980,4,118);
  Ra.sl[6]=2195; /* line # 2195 */
  MXD_CMP_setkword(Rd.s+985,4,116);
  Ra.sl[6]=2196; /* line # 2196 */
  MXD_CMP_setkword(Rd.s+992,4,117);
  Ra.sl[6]=2197; /* line # 2197 */
  MXD_CMP_setkword(Rd.s+1002,4,113);
  Ra.sl[6]=2198; /* line # 2198 */
  MXD_CMP_setkword(Rd.s+1009,4,100);
  Ra.sl[6]=2199; /* line # 2199 */
  MXD_CMP_setkword(Rd.s+1018,4,101);
  Ra.sl[6]=2200; /* line # 2200 */
  MXD_CMP_setkword(Rd.s+1026,4,107);
  Ra.sl[6]=2201; /* line # 2201 */
  MXD_CMP_setkword(Rd.s+1036,4,108);
  Ra.sl[6]=2202; /* line # 2202 */
  MXD_CMP_setkword(Rd.s+1047,4,90);
  Ra.sl[6]=2203; /* line # 2203 */
  MXD_CMP_setkword(Rd.s+1057,4,64);
  Ra.sl[6]=2204; /* line # 2204 */
  MXD_CMP_setkword(Rd.s+1063,4,104);
  Ra.sl[6]=2205; /* line # 2205 */
  MXD_CMP_setkword(Rd.s+1070,4,71);
  Ra.sl[6]=2206; /* line # 2206 */
  MXD_CMP_setkword(Rd.s+1078,4,80);
  Ra.sl[6]=2207; /* line # 2207 */
  MXD_CMP_setkword(Rd.s+1086,4,82);
  Ra.sl[6]=2208; /* line # 2208 */
  MXD_CMP_setkword(Rd.s+1096,4,77);
  Ra.sl[6]=2209; /* line # 2209 */
  MXD_CMP_setkword(Rd.s+1102,4,2);
  Ra.sl[6]=2210; /* line # 2210 */
  MXD_CMP_setkword(Rd.s+1109,4,3);
  Ra.sl[6]=2211; /* line # 2211 */
  MXD_CMP_setkword(Rd.s+1119,4,83);
  Ra.sl[6]=2212; /* line # 2212 */
  MXD_CMP_setkword(Rd.s+1126,4,84);
  Ra.sl[6]=2213; /* line # 2213 */
  MXD_CMP_setkword(Rd.s+1135,4,85);
  Ra.sl[6]=2214; /* line # 2214 */
  MXD_CMP_setkword(Rd.s+1144,4,86);
  Ra.sl[6]=2215; /* line # 2215 */
  MXD_CMP_setkword(Rd.s+1152,4,66);
  Ra.sl[6]=2216; /* line # 2216 */
  MXD_CMP_setkword(Rd.s+1158,4,65);
  Ra.sl[6]=2217; /* line # 2217 */
  MXD_CMP_setkword(Rd.s+1165,4,67);
  Ra.sl[6]=2218; /* line # 2218 */
  MXD_CMP_setkword(Rd.s+1173,4,68);
  Ra.sl[6]=2219; /* line # 2219 */
  MXD_CMP_setkword(Rd.s+1181,4,88);
  Ra.sl[6]=2220; /* line # 2220 */
  MXD_CMP_setkword(Rd.s+1195,4,106);
  Ra.sl[6]=2221; /* line # 2221 */
  MXD_CMP_setkword(Rd.s+1204,4,79);
  Ra.sl[6]=2222; /* line # 2222 */
  MXD_CMP_setkword(Rd.s+1214,4,105);
  Ra.sl[6]=2223; /* line # 2223 */
  MXD_CMP_setkword(Rd.s+1224,4,72);
  Ra.sl[6]=2224; /* line # 2224 */
  MXD_CMP_setkword(Rd.s+1232,4,69);
  Ra.sl[6]=2225; /* line # 2225 */
  MXD_CMP_setkword(Rd.s+1242,4,70);
  Ra.sl[6]=2226; /* line # 2226 */
  MXD_CMP_setkword(Rd.s+1252,4,87);
  Ra.sl[6]=2227; /* line # 2227 */
  MXD_CMP_setkword(Rd.s+1262,4,73);
  Ra.sl[6]=2228; /* line # 2228 */
  MXD_CMP_setkword(Rd.s+1271,4,102);
  Ra.sl[6]=2229; /* line # 2229 */
  MXD_CMP_setkword(Rd.s+1280,4,109);
  Ra.sl[6]=2230; /* line # 2230 */
  MXD_CMP_setkword(Rd.s+1290,4,122);
  Ra.sl[6]=2231; /* line # 2231 */
  MXD_CMP_setkword(Rd.s+1297,4,123);
  Ra.sl[6]=2232; /* line # 2232 */
  MXD_CMP_setkword(Rd.s+1307,4,124);
  Ra.sl[6]=2233; /* line # 2233 */
  MXD_CMP_setkword(Rd.s+1316,4,125);
  Ra.sl[6]=2234; /* line # 2234 */
  MXD_CMP_setkword(Rd.s+1323,4,126);
  Ra.sl[6]=2235; /* line # 2235 */
  MXD_CMP_setkword(Rd.s+1333,4,128);
  Ra.sl[6]=2236; /* line # 2236 */
  MXD_CMP_setkword(Rd.s+1340,4,129);
  Ra.sl[6]=2237; /* line # 2237 */
  MXD_CMP_setkword(Rd.s+1349,4,130);
  Ra.sl[6]=2238; /* line # 2238 */
  MXD_CMP_setkword(Rd.s+1355,4,127);
  Ra.sl[6]=2239; /* line # 2239 */
  MXD_CMP_setkword(Rd.s+1366,4,132);
  Ra.sl[6]=2240; /* line # 2240 */
  MXD_CMP_setkword(Rd.s+1375,4,131);
  Ra.sl[6]=2241; /* line # 2241 */
  MXD_CMP_setkword(Rd.s+1389,4,133);
  Ra.sl[6]=2244; /* line # 2244 */
  MXD_CMP_setkword(Rd.s+1400,5,135);
  Ra.sl[6]=2245; /* line # 2245 */
  MXD_CMP_setkword(Rd.s+1405,5,136);
  Ra.sl[6]=2246; /* line # 2246 */
  MXD_CMP_setkword(Rd.s+1409,5,137);
  Ra.sl[6]=2249; /* line # 2249 */
  MXD_CMP_setkword(Rd.s+1414,8,156);
  Ra.sl[6]=2250; /* line # 2250 */
  MXD_CMP_setkword(Rd.s+1418,8,157);
  Ra.sl[6]=2251; /* line # 2251 */
  MXD_CMP_setkword(Rd.s+1422,8,158);
  Ra.sl[6]=2252; /* line # 2252 */
  MXD_CMP_setkword(Rd.s+1426,8,159);
  Ra.sl[6]=2253; /* line # 2253 */
  MXD_CMP_setkword(Rd.s+1431,8,160);
  Ra.sl[6]=2254; /* line # 2254 */
  MXD_CMP_setkword(Rd.s+1436,8,161);
  Ra.sl[6]=2255; /* line # 2255 */
  MXD_CMP_setkword(Rd.s+1441,8,162);
  Ra.sl[6]=2256; /* line # 2256 */
  MXD_CMP_setkword(Rd.s+1450,8,163);
  Ra.sl[6]=2257; /* line # 2257 */
  MXD_CMP_setkword(Rd.s+1455,8,164);
  Ra.sl[6]=2258; /* line # 2258 */
  MXD_CMP_setkword(Rd.s+1460,8,165);
  Ra.sl[6]=2259; /* line # 2259 */
  MXD_CMP_setkword(Rd.s+1465,8,166);
  Ra.sl[6]=2260; /* line # 2260 */
  MXD_CMP_setkword(Rd.s+1470,8,167);
  Ra.sl[6]=2261; /* line # 2261 */
  MXD_CMP_setkword(Rd.s+1475,8,168);
  Ra.sl[6]=2262; /* line # 2262 */
  MXD_CMP_setkword(Rd.s+1480,8,169);
  Ra.sl[6]=2263; /* line # 2263 */
  MXD_CMP_setkword(Rd.s+1485,8,170);
  Ra.sl[6]=2264; /* line # 2264 */
  MXD_CMP_setkword(Rd.s+1490,8,171);
  Ra.sl[6]=2265; /* line # 2265 */
  MXD_CMP_setkword(Rd.s+1495,8,180);
  Ra.sl[6]=2266; /* line # 2266 */
  MXD_CMP_setkword(Rd.s+1500,8,181);
  Ra.sl[6]=2267; /* line # 2267 */
  MXD_CMP_setkword(Rd.s+1505,8,182);
  Ra.sl[6]=2268; /* line # 2268 */
  MXD_CMP_setkword(Rd.s+1510,8,172);
  Ra.sl[6]=2269; /* line # 2269 */
  MXD_CMP_setkword(Rd.s+1516,8,173);
  Ra.sl[6]=2270; /* line # 2270 */
  MXD_CMP_setkword(Rd.s+1522,8,174);
  Ra.sl[6]=2271; /* line # 2271 */
  MXD_CMP_setkword(Rd.s+1531,8,175);
  Ra.sl[6]=2272; /* line # 2272 */
  MXD_CMP_setkword(Rd.s+1538,8,176);
  Ra.sl[6]=2273; /* line # 2273 */
  MXD_CMP_setkword(Rd.s+1544,8,177);
  Ra.sl[6]=2274; /* line # 2274 */
  MXD_CMP_setkword(Rd.s+1550,8,178);
  Ra.sl[6]=2275; /* line # 2275 */
  MXD_CMP_setkword(Rd.s+1559,8,179);
  Ra.sl[6]=2276; /* line # 2276 */
  MXD_CMP_setkword(Rd.s+1567,8,183);
  Ra.sl[6]=2277; /* line # 2277 */
  MXD_CMP_setkword(Rd.s+1575,8,184);
  Ra.sl[6]=2278; /* line # 2278 */
  MXD_CMP_setkword(Rd.s+1583,8,185);
  Ra.sl[6]=2279; /* line # 2279 */
  MXD_CMP_setkword(Rd.s+1591,8,186);
  Ra.sl[6]=2280; /* line # 2280 */
  MXD_CMP_setkword(Rd.s+1599,8,187);
  Ra.sl[6]=2281; /* line # 2281 */
  MXD_CMP_setkword(Rd.s+1605,8,188);
  Ra.sl[6]=2282; /* line # 2282 */
  MXD_CMP_setkword(Rd.s+1611,8,189);
  Ra.sl[6]=2283; /* line # 2283 */
  MXD_CMP_setkword(Rd.s+1618,8,190);
  Ra.sl[6]=2284; /* line # 2284 */
  MXD_CMP_setkword(Rd.s+1625,8,191);
  Ra.sl[6]=2285; /* line # 2285 */
  MXD_CMP_setkword(Rd.s+1632,8,192);
  Ra.sl[6]=2286; /* line # 2286 */
  MXD_CMP_setkword(Rd.s+1639,8,193);
  Ra.sl[6]=2287; /* line # 2287 */
  MXD_CMP_setkword(Rd.s+1646,8,194);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " defstrconst "  */
V MXD_CMP_defstrconst(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1653;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2301; /* line # 2301 */
  Rv0=P_st_create();
  Ra.sl[6]=2302; /* line # 2302 */
  Rv1=Rv0;
  Ra.sl[6]=2304; /* line # 2304 */
  Rv2=((UB *)F_st)[1];
  Ra.sl[6]=2305; /* line # 2305 */
  ((C *)Rv1)[140]=(C)Rv2;
  Ra.sl[6]=2306; /* line # 2306 */
  while (Rv2>0){
    Ra.sl[6]=2307; /* line # 2307 */
    ((C *)Rv1)[Rv2+7]=((C *)F_st)[Rv2+1];
    Rv2=Rv2 -1;
  }
  Ra.sl[6]=2309; /* line # 2309 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " defnwcte "  */
void MXD_CMP_defnwcte(V F_nam, F F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1666;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2323; /* line # 2323 */
  Rv0=Rs.sl[18];
  Ra.sl[6]=2324; /* line # 2324 */
  Rv1=((UB *)F_nam)[1];
  Ra.sl[6]=2325; /* line # 2325 */
  Rv2=1;
  for( Rf0=Rv1;Rf0>0;Rf0-- ) {
    Ra.c[Rv2+28]=((C *)F_nam)[Rv2+1];
    Rv2++;
  }
  Ra.sl[6]=2326; /* line # 2326 */
  Rv3=Rv1+1;
  for( Rf0=17-(Rv1+1);Rf0>0;Rf0-- ) {
    Ra.c[Rv3+28]=((C *)F_nam)[Rv3+1];
    Rv3++;
  }
  Ra.sl[6]=2327; /* line # 2327 */
  Ra.c[28]=(C)Rv1;
  Ra.sl[6]=2328; /* line # 2328 */
  MXD_CMP_searchid(Ra.s+28,&Rv4,1);
  Ra.sl[6]=2329; /* line # 2329 */
  Rs.sl[18]=Rv0;
  Ra.sl[6]=2330; /* line # 2330 */
  Rv5=Rv4;
  Ra.sl[6]=2332; /* line # 2332 */
  ((UB *)Rv5)[48]=10;
  ((UB *)Rv5)[49]=2;
  Ra.sl[6]=2333; /* line # 2333 */
  ((F *)Rv5)[13]=F_vl;
  Ra.sl[6]=2335; /* line # 2335 */
  Rs.v[67]=Rv4;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gensysparm "  */
void MXD_CMP_gensysparm(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  SL Rv8;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1676;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2348; /* line # 2348 */
  Rv0=0;
  for( Rf1=17;Rf1>0;Rf1-- ) {
    Ra.sl[6]=2350; /* line # 2350 */
    Rv1=Rs.sl[18];
    Ra.sl[6]=2351; /* line # 2351 */
    Ra.c[28]=4;
    Ra.sl[6]=2352; /* line # 2352 */
    Ra.c[29]=36;
    Ra.c[30]=80;
    Ra.sl[6]=2353; /* line # 2353 */
    Rv2=Rv0/10;
    Rv3=Rv0-10*Rv2;
    Ra.sl[6]=2354; /* line # 2354 */
    Ra.c[31]=(C)(Rv2+48);
    Ra.sl[6]=2355; /* line # 2355 */
    Ra.c[32]=(C)(Rv3+48);
    Ra.sl[6]=2356; /* line # 2356 */
    MXD_CMP_searchid(Ra.s+28,&Rv4,1);
    Ra.sl[6]=2357; /* line # 2357 */
    Rs.sl[18]=Rv1;
    Ra.sl[6]=2358; /* line # 2358 */
    Rv5=Rv4;
    Ra.sl[6]=2360; /* line # 2360 */
    ((UB *)Rv5)[48]=10;
    Ra.sl[6]=2361; /* line # 2361 */
    ((UB *)Rv5)[49]=1;
    Ra.sl[6]=2362; /* line # 2362 */
    ((V *)Rv5)[7]=P_st_create();
    Ra.sl[6]=2363; /* line # 2363 */
    Rv6=((V *)Rv5)[7];
    Ra.sl[6]=2365; /* line # 2365 */
    ((C *)Rv6)[140]=0;
    Ra.sl[6]=2366; /* line # 2366 */
    if (Rv0<PAS__argc&&PAS__argv.v[Rv2]!=NULL) {
      Ra.sl[6]=2367; /* line # 2367 */
      Rv7=PAS__argv.v[Rv0];
      Ra.sl[6]=2369; /* line # 2369 */
      ((C *)Rv6)[140]=((C *)Rv7)[1];
      Ra.sl[6]=2370; /* line # 2370 */
      Rv8=1;
      for( Rf0=((UB *)Rv7)[1];Rf0>0;Rf0-- ) {
        ((C *)Rv6)[Rv8+7]=((C *)Rv7)[Rv8+1];
        Rv8++;
      }
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init "  */
void MXD_CMP_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  UB Rv6;
  UB Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1688;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2388; /* line # 2388 */
  Rs.sl[136]=P_cpu_clock();
  Ra.sl[6]=2389; /* line # 2389 */
  PAS__STR_TO_STR(V_errmsgspecif.s,Rd.s+1694);
  Ra.sl[6]=2390; /* line # 2390 */
  Rs.v[4]=NULL;
  Ra.sl[6]=2391; /* line # 2391 */
  Rs.v[8]=NULL;
  Ra.sl[6]=2392; /* line # 2392 */
  Ri.ub[94]=0;
  Ra.sl[6]=2393; /* line # 2393 */
  Ri.ub[95]=0;
  Ri.ub[96]=0;
  Ra.sl[6]=2394; /* line # 2394 */
  V_strempty=NULL;
  Ri.ub[97]=0;
  Ri.ub[98]=1;
  Ra.sl[6]=2396; /* line # 2396 */
  Rs.sl[86]=0;
  Rs.sl[137]=0;
  Ra.sl[6]=2397; /* line # 2397 */
  Rs.sl[6]=0;
  Rs.sl[18]=0;
  Ri.ub[89]=0;
  Ra.sl[6]=2398; /* line # 2398 */
  Ri.ub[90]=0;
  Ri.ub[93]=0;
  Ri.ub[91]=0;
  Ra.sl[6]=2399; /* line # 2399 */
  Rs.c[40]=32;
  Rs.c[41]=32;
  Rs.ub[42]=17;
  Ra.sl[6]=2402; /* line # 2402 */
  P_open_listing(&V_lst, Rd.s+1716,3,1);
  Ra.sl[6]=2403; /* line # 2403 */
  P_open_listing(Ri.v+13,Rd.s+1721,12,0);
  Ra.sl[6]=2405; /* line # 2405 */
  Ri.v[0]=PAS__NEW(98);
  Ra.sl[6]=2406; /* line # 2406 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=2408; /* line # 2408 */
  ((V *)Rv0)[0]=NULL;
  Ra.sl[6]=2409; /* line # 2409 */
  ((SL *)Rv1)[2]=1;
  Ra.sl[6]=2410; /* line # 2410 */
  ((SL *)Rv1)[3]=0;
  Ra.sl[6]=2411; /* line # 2411 */
  ((V *)Rv1)[2]=MXD_CMP_defstrconst(Rd.s+1733);
  Ra.sl[6]=2412; /* line # 2412 */
  ((V *)Rv1)[3]=P_st_create();
  Ra.sl[6]=2413; /* line # 2413 */
  ((SL *)Rv1)[8]=0;
  Ra.sl[6]=2414; /* line # 2414 */
  ((SL *)Rv1)[9]=1;
  Ra.sl[6]=2415; /* line # 2415 */
  ((SL *)Rv1)[10]=120;
  Ra.sl[6]=2416; /* line # 2416 */
  ((SL *)Rv1)[11]=0;
  Ra.sl[6]=2417; /* line # 2417 */
  ((SL *)Rv1)[12]=1;
  Ra.sl[6]=2418; /* line # 2418 */
  ((C *)Rv1)[52]=32;
  Ra.sl[6]=2419; /* line # 2419 */
  ((C *)Rv1)[53]=32;
  Ra.sl[6]=2420; /* line # 2420 */
  ((C *)Rv1)[54]=32;
  Ra.sl[6]=2421; /* line # 2421 */
  ((UB *)Rv1)[55]=18;
  Ra.sl[6]=2422; /* line # 2422 */
  ((UB *)Rv1)[56]=0;
  Ra.sl[6]=2423; /* line # 2423 */
  ((UB *)Rv1)[57]=0;
  Ra.sl[6]=2424; /* line # 2424 */
  ((UB *)Rv1)[58]=0;
  Ra.sl[6]=2425; /* line # 2425 */
  ((UB *)Rv1)[59]=1;
  Ra.sl[6]=2426; /* line # 2426 */
  ((UB *)Rv1)[60]=0;
  Ra.sl[6]=2427; /* line # 2427 */
  ((UB *)Rv1)[61]=0;
  Ra.sl[6]=2428; /* line # 2428 */
  ((UB *)Rv1)[62]=0;
  Ra.sl[6]=2429; /* line # 2429 */
  ((UB *)Rv1)[63]=0;
  Ra.sl[6]=2430; /* line # 2430 */
  ((UB *)Rv1)[64]=0;
  Ra.sl[6]=2432; /* line # 2432 */
  ((UB *)Rv2)[16]=3;
  Ra.sl[6]=2434; /* line # 2434 */
  P_open_input_txtfile(((V *)Rv2)+1,((V *)Rv1)[2],&Rv3,((UB *)Rv2)+17,&Rv4);
  Ra.sl[6]=2435; /* line # 2435 */
  if (!Rv3) {
    Ra.sl[6]=2437; /* line # 2437 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1753,-1,-1,32);
    PAS__WRITE_STR(PAS__fspc.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1773,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=2439; /* line # 2439 */
    siglongjmp(G_lb_env,1);
  }
  else {
    Ra.sl[6]=2442; /* line # 2442 */
    if (((UB *)Rv2)[17]) {
      Ra.sl[6]=2444; /* line # 2444 */
      P_openw_txtfile(((V *)Rv2),((V *)Rv1)[2],1);
    }
  }
  Ra.sl[6]=2446; /* line # 2446 */
  Rs.v[69]=MXD_CMP_defstrconst(Rd.s+1811);
  ((V *)Rs.v[69])[0]=NULL;
  Ra.sl[6]=2447; /* line # 2447 */
  Rs.v[1]=P_st_create();
  Ra.sl[6]=2448; /* line # 2448 */
  Rs.sl[7]=1;
  Ra.sl[6]=2449; /* line # 2449 */
  V_errcnt=0;
  Ri.ub[88]=0;
  Ra.sl[6]=2450; /* line # 2450 */
  Ri.ub[8]=0;
  Ra.sl[6]=2451; /* line # 2451 */
  Rs.sl[5]=0;
  Rs.sl[4]=-1;
  V_pagenb=0;
  Ra.sl[6]=2452; /* line # 2452 */
  V_linewrt=55;
  Ra.sl[6]=2453; /* line # 2453 */
  Rs.v[10]=NULL;
  Rs.v[11]=NULL;
  Ra.sl[6]=2454; /* line # 2454 */
  Rs.v[7]=NULL;
  Ra.sl[6]=2455; /* line # 2455 */
  MXD_CMP_initable();
  Ra.sl[6]=2456; /* line # 2456 */
  Rs.sl[18]=1;
  Ra.sl[6]=2457; /* line # 2457 */
  Rv5=0;
  for( Rf0=16;Rf0>0;Rf0-- ) {
    Rs.v[Rv5+45]=NULL;
    Rv5++;
  }
  Ra.sl[6]=2458; /* line # 2458 */
  Rv6=0;
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Rs.sl[Rv6+140]=0;
    Rv6++;
  }
  Ra.sl[6]=2459; /* line # 2459 */
  Rv7=0;
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Rs.v[Rv7+74]=NULL;
    Rv7++;
  }
  Ra.sl[6]=2460; /* line # 2460 */
  Rs.sl[164]=-1;
  Rs.v[44]=NULL;
  Ra.sl[6]=2461; /* line # 2461 */
  V_majorfmode=0;
  Ra.sl[6]=2462; /* line # 2462 */
  V_fatalerror=0;
  Ra.sl[6]=2463; /* line # 2463 */
  MXD_CMP_gensysparm();
  Ra.sl[6]=2464; /* line # 2464 */
  MXD_CMP_defnwcte(Rd.s+1830,(F)0.000000E-01);
  Ra.sl[6]=2465; /* line # 2465 */
  Rs.v[6]=Rs.v[67];
  Ra.sl[6]=2466; /* line # 2466 */
  Rv8=0;
  for( Rf0=10;Rf0>0;Rf0-- ) {
    Rs.ub[Rv8*24+680]=0;
    Rv8++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " putrefitm "  */
void MXD_CMP_putrefitm(V F_itm, UB F_bk){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1839;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2474; /* line # 2474 */
  Ra.sl[6]=2475; /* line # 2475 */
  if (((UB *)F_itm)[2]!=74) {
    Ra.sl[6]=2476; /* line # 2476 */
    if (((UB *)F_itm)[3]!=4) {
      Ra.sl[6]=2478; /* line # 2478 */
      if (F_bk||((UB *)F_itm)[2]!=16) {
        Ra.sl[6]=2479; /* line # 2479 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT((SL)((UB *)F_itm)[2],4,0);
        PAS__WRITE_CHAR(32);
      }
      Ra.sl[6]=2480; /* line # 2480 */
      switch (((UB *)F_itm)[2]) {
        case 16:Ra.sl[6]=2481; /* line # 2481 */
        if (F_bk) {
          PAS__SELECT_OUT(Ri.v[13]);
          PAS__WRITE_SNGL(((F *)F_itm)[2],12,-6,0);
          PAS__WRITE_EOLN();
        }
        break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 7:Ra.sl[6]=2483; /* line # 2483 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_INT(((SL *)((V *)F_itm)[1])[1],6,0);
        PAS__WRITE_EOLN();
        break;
        case 0:Ra.sl[6]=2484; /* line # 2484 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_INT((SL)((C *)F_itm)[1],4,0);
        PAS__WRITE_EOLN();
        break;
        case 1:Ra.sl[6]=2485; /* line # 2485 */
        Rv0=((V *)F_itm)[1];
        Ra.sl[6]=2487; /* line # 2487 */
        if (((SL *)Rv0)[13]==-1) {
          Ra.sl[6]=2489; /* line # 2489 */
          ((SL *)Rv0)[13]=MXD_CMP_setnewffrm(((V *)F_itm)[1]);
          Ra.sl[6]=2490; /* line # 2490 */
          if (((SL *)Rv0)[13]==-1) MXD_CMP_error(Rd.s+1852,4);
        }
        Ra.sl[6]=2492; /* line # 2492 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_INT(((SL *)Rv0)[13],4,0);
        PAS__WRITE_EOLN();
        break;
      }
      Ra.sl[6]=2495; /* line # 2495 */
      if (F_bk||((UB *)F_itm)[2]!=16) ((UB *)F_itm)[3]=4;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " concatstr "  */
V MXD_CMP_concatstr(V F_ps1, V F_ps2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1856;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2508; /* line # 2508 */
  Rv0=P_st_create();
  Ra.sl[6]=2509; /* line # 2509 */
  memcpy(Rv0+8,F_ps1+8,132);
  ((C *)Rv0)[140]=((C *)F_ps1)[140];
  Ra.sl[6]=2510; /* line # 2510 */
  Rv1=(SL)((C *)Rv0)[140];
  Rv2=(SL)((C *)F_ps2)[140];
  Rv2=Rv2+Rv1;
  Ra.sl[6]=2511; /* line # 2511 */
  if (Rv2>132) {
    Ra.sl[6]=2512; /* line # 2512 */
    MXD_CMP_error(Rd.s+1869,22);
    Rv2=132;
  }
  Ra.sl[6]=2513; /* line # 2513 */
  Rv3=0;
  Ra.sl[6]=2514; /* line # 2514 */
  while (Rv1<Rv2){
    Ra.sl[6]=2516; /* line # 2516 */
    Rv1=Rv1+1;
    Rv3=Rv3+1;
    Ra.sl[6]=2517; /* line # 2517 */
    ((C *)Rv0)[Rv1+7]=((C *)F_ps2)[Rv3+7];
  }
  Ra.sl[6]=2519; /* line # 2519 */
  ((C *)Rv0)[140]=(C)Rv2;
  Ra.sl[6]=2520; /* line # 2520 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " extend "  */
void MXD_CMP_extend(V F_pp, C F_i){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1873;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2527; /* line # 2527 */
  Rv0=F_pp;
  Ra.sl[6]=2528; /* line # 2528 */
  while (((C *)Rv0)[140]<F_i){
    Ra.sl[6]=2529; /* line # 2529 */
    ((C *)Rv0)[140]=((C *)Rv0)[140]+1;
    ((C *)Rv0)[(SL)((C *)Rv0)[140]+7]=32;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmpstr "  */
SL MXD_CMP_cmpstr(V *F_ps1, V *F_ps2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1881;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2546; /* line # 2546 */
  Rv0=(SL)((C *)(*F_ps1))[140];
  Rv1=(SL)((C *)(*F_ps2))[140];
  Ra.sl[6]=2547; /* line # 2547 */
  if (Rv0!=Rv1) {
    Ra.sl[6]=2548; /* line # 2548 */
    if (Rv0>Rv1) MXD_CMP_extend((*F_ps2),((C *)(*F_ps1))[140]);
    else {
      Ra.sl[6]=2549; /* line # 2549 */
      MXD_CMP_extend((*F_ps1),((C *)(*F_ps2))[140]);
      Rv0=Rv1;
    }
  }
  Ra.sl[6]=2550; /* line # 2550 */
  Rv1=1;
  Rv2=1;
  Ra.sl[6]=2551; /* line # 2551 */
  while (Rv1<=Rv0&&Rv2){
    Ra.sl[6]=2552; /* line # 2552 */
    Rv2=((C *)(*F_ps1))[Rv1+7]==((C *)(*F_ps2))[Rv1+7];
    if (Rv2) Rv1=Rv1+1;
  }
  Ra.sl[6]=2553; /* line # 2553 */
  if (Rv2) Ret=0;
  else {
    Ra.sl[6]=2555; /* line # 2555 */
    if (((C *)(*F_ps1))[Rv1+7]>((C *)(*F_ps2))[Rv1+7]) Ret=1;
    else {
      Ra.sl[6]=2556; /* line # 2556 */
      Ret=-1;
    }
  }
  Ra.sl[6]=2557; /* line # 2557 */
  P_st_free(F_ps1);
  P_st_free(F_ps2);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " copystr "  */
void MXD_CMP_copystr(V *F_psr, V F_pss, UB F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1889;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2566; /* line # 2566 */
  if ((*F_psr)==NULL) (*F_psr)=P_st_create();
  Ra.sl[6]=2567; /* line # 2567 */
  memcpy((*F_psr),F_pss,141);
  Ra.sl[6]=2568; /* line # 2568 */
  if (F_bl) P_st_free(&F_pss);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " substr "  */
void MXD_CMP_PRC_00000000(V F_p, SL F_i, SL F_j){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1898;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2580; /* line # 2580 */
  Rv0=F_p;
  Ra.sl[6]=2582; /* line # 2582 */
  Rv1=(SL)((C *)Rv0)[140];
  Ra.sl[6]=2583; /* line # 2583 */
  if (F_i<1) F_i=1;
  Ra.sl[6]=2584; /* line # 2584 */
  if (F_i<=Rv1) {
    Ra.sl[6]=2586; /* line # 2586 */
    if (F_j<=0) F_j=Rv1;
    else {
      Ra.sl[6]=2587; /* line # 2587 */
      if (F_j>Rv1) F_j=Rv1;
    }
    Ra.sl[6]=2588; /* line # 2588 */
    Rv2=0;
    Ra.sl[6]=2589; /* line # 2589 */
    while (F_i<=F_j){
      Ra.sl[6]=2591; /* line # 2591 */
      Rv2=Rv2+1;
      Ra.sl[6]=2592; /* line # 2592 */
      ((C *)Rv0)[Rv2+7]=((C *)Rv0)[F_i+7];
      Ra.sl[6]=2593; /* line # 2593 */
      F_i=F_i+1;
    }
    Ra.sl[6]=2595; /* line # 2595 */
    ((C *)Rv0)[140]=(C)Rv2;
  }
  else {
    Ra.sl[6]=2597; /* line # 2597 */
    ((C *)Rv0)[140]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " index "  */
SL MXD_CMP_PRC_00000001(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  C Rv4;
  register V Rv5;
  SL Rv6;
  SL Rv7;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1906;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2612; /* line # 2612 */
  Rv0=(SL)((C *)F_s1)[140];
  Rv1=(SL)((C *)F_s2)[140];
  Rv2=0;
  Rv3=0;
  Ra.sl[6]=2613; /* line # 2613 */
  if (Rv1>0&&Rv0>=Rv1) {
    Ra.sl[6]=2615; /* line # 2615 */
    Rv4=((C *)F_s2)[8];
    Ra.sl[6]=2616; /* line # 2616 */
    Rv5=F_s1;
    Ra.sl[6]=2617; /* line # 2617 */
    while (Rv3<=Rv0-Rv1&&!Rv2){
      Ra.sl[6]=2619; /* line # 2619 */
      Rv3=Rv3+1;
      Ra.sl[6]=2620; /* line # 2620 */
      if (Rv4==((C *)Rv5)[Rv3+7]) {
        Ra.sl[6]=2622; /* line # 2622 */
        Rv6=Rv3+1;
        Rv7=2;
        Ra.sl[6]=2623; /* line # 2623 */
        while (Rv7<=Rv1&&((C *)Rv5)[Rv6+7]==((C *)F_s2)[Rv7+7]){
          Ra.sl[6]=2624; /* line # 2624 */
          Rv7=Rv7+1;
          Rv6=Rv6+1;
        }
        Ra.sl[6]=2625; /* line # 2625 */
        Rv2=Rv7>Rv1;
      }
    }
  }
  Ra.sl[6]=2629; /* line # 2629 */
  if (Rv2) Ret=Rv3;
  else {
    Ra.sl[6]=2630; /* line # 2630 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " nindex "  */
SL MXD_CMP_nindex(V F_s1, V F_s2, SL F_nb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  C Rv3;
  SL Rv4;
  register V Rv5;
  UB Rv6;
  SL Rv7;
  SL Rv8;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1913;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2644; /* line # 2644 */
  Rv0=0;
  Ra.sl[6]=2645; /* line # 2645 */
  Rv1=(SL)((C *)F_s1)[140];
  Ra.sl[6]=2646; /* line # 2646 */
  Rv2=(SL)((C *)F_s2)[140];
  Ra.sl[6]=2647; /* line # 2647 */
  if (Rv2>0&&Rv1>=Rv2) {
    Ra.sl[6]=2649; /* line # 2649 */
    Rv3=((C *)F_s2)[8];
    Ra.sl[6]=2650; /* line # 2650 */
    Rv4=0;
    Ra.sl[6]=2651; /* line # 2651 */
    if (F_nb<=0) F_nb=Rv1;
    Ra.sl[6]=2652; /* line # 2652 */
    Rv5=F_s1;
    while (1){
      Ra.sl[6]=2654; /* line # 2654 */
      Rv6=0;
      Ra.sl[6]=2655; /* line # 2655 */
      while (Rv4<=Rv1-Rv2&&!Rv6){
        Ra.sl[6]=2657; /* line # 2657 */
        Rv4=Rv4+1;
        Ra.sl[6]=2658; /* line # 2658 */
        if (Rv3==((C *)Rv5)[Rv4+7]) {
          Ra.sl[6]=2660; /* line # 2660 */
          Rv7=Rv4+1;
          Rv8=2;
          Ra.sl[6]=2661; /* line # 2661 */
          while (Rv8<=Rv2&&((C *)Rv5)[Rv7+7]==((C *)F_s2)[Rv8+7]){
            Ra.sl[6]=2662; /* line # 2662 */
            Rv8=Rv8+1;
            Rv7=Rv7+1;
          }
          Ra.sl[6]=2663; /* line # 2663 */
          Rv6=Rv8>Rv2;
        }
      }
      Ra.sl[6]=2666; /* line # 2666 */
      if (Rv6) {
        Ra.sl[6]=2668; /* line # 2668 */
        Rv0=Rv4;
        Ra.sl[6]=2669; /* line # 2669 */
        F_nb=F_nb-1;
      }
      if (F_nb==0||!Rv6)  break;
    }
  }
  Ra.sl[6]=2673; /* line # 2673 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " instring "  */
V MXD_CMP_instring(SL F_iv, SL F_ifl){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  C Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register int Rgi;
  register int Rgj;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1921;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2688; /* line # 2688 */
  Rv0=P_st_create();
  Ra.sl[6]=2689; /* line # 2689 */
  Rv1=Rv0;
  Ra.sl[6]=2691; /* line # 2691 */
  Rv2=abs(F_iv);
  Ra.sl[6]=2692; /* line # 2692 */
  if (F_ifl>0) Rv3=48;
  else Rv3=32;
  Ra.sl[6]=2693; /* line # 2693 */
  Rv4=0;
  Ra.sl[6]=2694; /* line # 2694 */
  if (Rv2==0) {
    Ra.sl[6]=2695; /* line # 2695 */
    Ra.c[28]=Rv3;
    Rv4=Rv4+1;
  }
  else {
    Ra.sl[6]=2697; /* line # 2697 */
    while (Rv2>0){
      Ra.sl[6]=2699; /* line # 2699 */
      Ra.c[Rv4+28]=(C)(PAS__I_MOD(Rv2,10)+48);
      Ra.sl[6]=2700; /* line # 2700 */
      Rv2=Rv2/10;
      Rv4=Rv4+1;
    }
  }
  Ra.sl[6]=2702; /* line # 2702 */
  if (F_iv<0) {
    Ra.sl[6]=2703; /* line # 2703 */
    Ra.c[Rv4+28]=45;
    Rv4=Rv4+1;
  }
  Ra.sl[6]=2705; /* line # 2705 */
  if (F_ifl<Rv4) F_ifl=Rv4;
  else {
    Ra.sl[6]=2706; /* line # 2706 */
    if (F_ifl>Rv4) {
      Ra.sl[6]=2708; /* line # 2708 */
      if (F_ifl>16) F_ifl=16;
      Ra.sl[6]=2709; /* line # 2709 */
      if (Ra.c[(Rv4-1)+28]==45) {
        Ra.sl[6]=2710; /* line # 2710 */
        Ra.c[(F_ifl-1)+28]=Ra.c[(Rv4-1)+28];
      }
      Ra.sl[6]=2711; /* line # 2711 */
      Rv5=Rv4;
      for( Rf0=((F_ifl-1)+1)-Rv4;Rf0>0;Rf0-- ) {
        Ra.c[Rv5+28]=48;
        Rv5++;
      }
    }
  }
  Ra.sl[6]=2713; /* line # 2713 */
  Rv6=1;
  for( Rf0=F_ifl;Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv6+7]=Ra.c[(F_ifl-Rv6)+28];
    Rv6++;
  }
  Ra.sl[6]=2714; /* line # 2714 */
  ((C *)Rv1)[140]=(C)F_ifl;
  Ra.sl[6]=2716; /* line # 2716 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " innumber "  */
SL MXD_CMP_innumber(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  UB Rv4;
  UB Rv5;
  F Rv6;
  C Rv7;
  register F Rgf;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1931;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2732; /* line # 2732 */
  Rv0=(*F_p);
  Ra.sl[6]=2734; /* line # 2734 */
  Rv1=(SL)((C *)Rv0)[140];
  Ra.sl[6]=2735; /* line # 2735 */
  Rv2=1;
  Rv3=0;
  Rv4=0;
  Rv5=0;
  Rv6=(F)0.000000E-01;
  Ra.sl[6]=2736; /* line # 2736 */
  while (Rv2<=Rv1&&!Rv4){
    Ra.sl[6]=2738; /* line # 2738 */
    Rv7=((C *)Rv0)[Rv2+7];
    Rv2=Rv2+1;
    Ra.sl[6]=2739; /* line # 2739 */
    if (Rv7>=48&&Rv7<=57) {
      Ra.sl[6]=2741; /* line # 2741 */
      Rv3=2;
      Rv6=(Rv6*(F)1.000000E+01+(float)((SL)Rv7))-(F)4.800000E+01;
    }
    else {
      Ra.sl[6]=2743; /* line # 2743 */
      if (Rv3<2&&(Rv7==43||Rv7==45)) {
        Ra.sl[6]=2745; /* line # 2745 */
        Rv3=1;
        if (Rv7==45) Rv5=!Rv5;
      }
      else {
        Ra.sl[6]=2747; /* line # 2747 */
        if (Rv3==2) Rv4=1;
        else {
          Ra.sl[6]=2748; /* line # 2748 */
          if (Rv7!=32) MXD_CMP_error(Rd.s+1943,21);
        }
      }
    }
  }
  Ra.sl[6]=2751; /* line # 2751 */
  P_st_free(F_p);
  Ra.sl[6]=2752; /* line # 2752 */
  Ret=(Rv6>0.0?(SL)(Rv6+0.5):(SL)(Rv6-0.5));
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " arcsin "  */
F MXD_CMP_PRC_00000002(F F_v){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1947;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2764; /* line # 2764 */
  if (fabs(F_v)>(F)1.000000E+00) MXD_CMP_error(Rd.s+1957,23);
  else {
    Ra.sl[6]=2767; /* line # 2767 */
    if (fabs(F_v)>(F)9.999900E-01) {
      Ra.sl[6]=2768; /* line # 2768 */
      if (F_v>(F)0.000000E-01) Rv0=(F)9.000000E+01;
      else Rv0=(F)-9.000000E+01;
    }
    else {
      Ra.sl[6]=2770; /* line # 2770 */
      Rv0=(float)((double)atan(F_v/sqrt((F)1.000000E+00-F_v*F_v))/1.745329310000000E-002)
      ;
    }
  }
  Ra.sl[6]=2772; /* line # 2772 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " phasearg "  */
F MXD_CMP_phasearg(F F_ip, F F_rp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1961;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2782; /* line # 2782 */
  Rv0=sqrt(F_ip*F_ip+F_rp*F_rp);
  Ra.sl[6]=2783; /* line # 2783 */
  if (Rv0==(F)0.000000E-01) Ret=(F)0.000000E-01;
  else {
    Ra.sl[6]=2785; /* line # 2785 */
    Rv0=F_ip/Rv0;
    Ra.sl[6]=2786; /* line # 2786 */
    if (F_rp<(F)0.000000E-01) Ret=(F)1.800000E+02-MXD_CMP_PRC_00000002(Rv0);
    else {
      Ra.sl[6]=2787; /* line # 2787 */
      Ret=MXD_CMP_PRC_00000002(Rv0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " nxtpoint "  */
void MXD_CMP_nxtpoint(F *F_x, F *F_y, V *F_p, SL *F_i){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1971;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2808; /* line # 2808 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=2810; /* line # 2810 */
    (*F_i)=(*F_i)+1;
    Ra.sl[6]=2811; /* line # 2811 */
    if ((*F_i)>=((UL *)(*F_p))[4]) {
      Ra.sl[6]=2813; /* line # 2813 */
      (*F_p)=((V *)(*F_p))[0];
      if ((*F_p)==NULL) (*F_i)=-1;
      else (*F_i)=0;
    }
  }
  Ra.sl[6]=2816; /* line # 2816 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=2817; /* line # 2817 */
    Rv0=(*F_p);
    Ra.sl[6]=2818; /* line # 2818 */
    (*F_x)=((F *)Rv0)[2]+(float)(*F_i)*((F *)Rv0)[3];
    (*F_y)=((F *)Rv0)[(*F_i)+5];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " interpol "  */
F MXD_CMP_interpol(V F_par, F *F_vx){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  F Rv2;
  F Rv3;
  SL Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  F Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  F Rv17;
  F Rv18;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1981;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2836; /* line # 2836 */
  if (((UB *)F_par)[48]!=12) MXD_CMP_error(Rd.s+1993,-24);
  else {
    Ra.sl[6]=2838; /* line # 2838 */
    if (((V *)F_par)[8]==NULL) MXD_CMP_error(Rd.s+1993,25);
    else {
      Ra.sl[6]=2840; /* line # 2840 */
      if (((UL *)((V *)F_par)[8])[4]<1) MXD_CMP_error(Rd.s+1993,25);
      else {
        Ra.sl[6]=2843; /* line # 2843 */
        Rv0=((V *)F_par)[8];
        Ra.sl[6]=2844; /* line # 2844 */
        Rv1=Rv0;
        Ra.sl[6]=2846; /* line # 2846 */
        Rv2=((F *)Rv1)[2];
        Rv3=((F *)Rv1)[5];
        Rv4=0;
        Ra.sl[6]=2848; /* line # 2848 */
        Rv5=Rv2+((F *)Rv0)[3];
        Rv6=Rv3;
        Ra.sl[6]=2849; /* line # 2849 */
        Rv7=Rv5+((F *)Rv0)[3];
        Rv8=Rv3;
        Ra.sl[6]=2850; /* line # 2850 */
        Rv9=Rv7+((F *)Rv0)[3];
        Rv10=Rv8;
        Ra.sl[6]=2851; /* line # 2851 */
        MXD_CMP_nxtpoint(&Rv5, &Rv6, &Rv0, &Rv4);
        Ra.sl[6]=2852; /* line # 2852 */
        if (Rv4!=-1) {
          Ra.sl[6]=2854; /* line # 2854 */
          Rv7=Rv5+((F *)Rv0)[3];
          Rv8=Rv6;
          Ra.sl[6]=2855; /* line # 2855 */
          Rv9=Rv7+((F *)Rv0)[3];
          Rv10=Rv8;
          Ra.sl[6]=2856; /* line # 2856 */
          MXD_CMP_nxtpoint(&Rv7, &Rv8, &Rv0, &Rv4);
          Ra.sl[6]=2857; /* line # 2857 */
          if (Rv4!=-1) {
            Ra.sl[6]=2859; /* line # 2859 */
            Rv9=Rv7+((F *)Rv0)[3];
            Rv10=Rv8;
            Ra.sl[6]=2861; /* line # 2861 */
            MXD_CMP_nxtpoint(&Rv9, &Rv10, &Rv0, &Rv4);
          }
        }
        Ra.sl[6]=2864; /* line # 2864 */
        if (Rv4==-1) {
          Ra.sl[6]=2866; /* line # 2866 */
          MXD_CMP_error(Rd.s+1993,26);
        }
        Ra.sl[6]=2868; /* line # 2868 */
        while (Rv4!=-1&&Rv7<(*F_vx)){
          Ra.sl[6]=2870; /* line # 2870 */
          MXD_CMP_nxtpoint(&Rv11, &Rv12, &Rv0, &Rv4);
          Ra.sl[6]=2871; /* line # 2871 */
          if (Rv4!=-1) {
            Ra.sl[6]=2873; /* line # 2873 */
            Rv2=Rv5;
            Rv3=Rv6;
            Rv5=Rv7;
            Rv6=Rv8;
            Ra.sl[6]=2874; /* line # 2874 */
            Rv7=Rv9;
            Rv8=Rv10;
            Rv9=Rv11;
            Rv10=Rv12;
          }
        }
        Ra.sl[6]=2878; /* line # 2878 */
        Rv13=(Rv3-Rv6)/(Rv2-Rv5);
        Ra.sl[6]=2879; /* line # 2879 */
        Rv14=(Rv13-(Rv3-Rv8)/(Rv2-Rv7))/(Rv5-Rv7);
        Ra.sl[6]=2880; /* line # 2880 */
        Rv15=(Rv14-(Rv13-(Rv3-Rv10)/(Rv2-Rv9))/(Rv5-Rv9))/(Rv7-Rv9);
        Ra.sl[6]=2881; /* line # 2881 */
        Rv16=Rv14-((Rv2+Rv5)+Rv7)*Rv15;
        Ra.sl[6]=2882; /* line # 2882 */
        Rv17=(Rv13-(Rv2+Rv5)*Rv16)-((Rv2*Rv2+Rv2*Rv5)+Rv5*Rv5)*Rv15;
        Ra.sl[6]=2883; /* line # 2883 */
        Rv18=Rv3-Rv2*(Rv17+Rv2*(Rv16+Rv2*Rv15));
        Ra.sl[6]=2884; /* line # 2884 */
        Rv18=Rv18+(*F_vx)*(Rv17+(*F_vx)*(Rv16+(*F_vx)*Rv15));
        Ra.sl[6]=2885; /* line # 2885 */
        Ret=Rv18;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " convint "  */
void MXD_CMP_convint(V F_itm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1997;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2896; /* line # 2896 */
  Ra.sl[6]=2898; /* line # 2898 */
  ((F *)F_itm)[1]=(float)MXD_CMP_innumber(((V *)F_itm)+1);
  ((UB *)F_itm)[3]=2;
  ((F *)F_itm)[2]=((F *)F_itm)[1];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " convstr "  */
void MXD_CMP_convstr(V F_itm, SL F_i){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2006;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2912; /* line # 2912 */
  Ra.sl[6]=2914; /* line # 2914 */
  Rv0=PAS__F_ROUND(((F *)F_itm)[2]);
  ((F *)F_itm)[1]=(float)Rv0;
  Ra.sl[6]=2915; /* line # 2915 */
  ((UB *)F_itm)[3]=1;
  Ra.sl[6]=2916; /* line # 2916 */
  ((V *)F_itm)[1]=MXD_CMP_instring(Rv0, F_i);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getenvsymb "  */
void MXD_CMP_getenvsymb(V F_slog){
  /* Define the automatic variable space. */
  Blk( Ra, 304 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=132;
  Ra.ub[134]=132;
  Ra.v[34]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+272;
  Ra.v[35]=Rd.s+2015;
  Ra.v[36]=Rd.s+12;
  Ra.sl[74]=2927; /* line # 2927 */
  Rv0=F_slog;
  Ra.sl[74]=2929; /* line # 2929 */
  Rv1=1;
  for( Rf0=(SL)((C *)Rv0)[140];Rf0>0;Rf0-- ) {
    Ra.c[Rv1+1]=((C *)Rv0)[Rv1+7];
    Rv1++;
  }
  Ra.sl[74]=2930; /* line # 2930 */
  Ra.ub[1]=(SL)((C *)Rv0)[140];
  Ra.sl[74]=2931; /* line # 2931 */
  Rv2=PAS__GETENV(Ra.s+134,Ra.s);
  Ra.sl[74]=2932; /* line # 2932 */
  if (Rv2==0) {
    Ra.sl[74]=2934; /* line # 2934 */
    Rv3=1;
    for( Rf0=Ra.ub[135];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[Rv3+7]=Ra.c[Rv3+135];
      Rv3++;
    }
    Ra.sl[74]=2935; /* line # 2935 */
    ((C *)Rv0)[140]=Ra.c[135];
  }
  else {
    Ra.sl[74]=2936; /* line # 2936 */
    ((C *)Rv0)[140]=0;
  }
  PAS__curr_cntx=Ra.v[34];
}


/* Procedure/Function : " push "  */
void MXD_CMP_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2027;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=2966; /* line # 2966 */
  if (Lx[3].ul[0]==32) MXD_CMP_error(Rd.s+2035,-5);
  else {
    Ra.sl[6]=2967; /* line # 2967 */
    Lx[3].ul[0]=Lx[3].ul[0]+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pop "  */
void MXD_CMP_PRC_00000006(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2039;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3026; /* line # 3026 */
  memcpy(Lx[0].s,(Lx[3].s+Lx[3].ul[0]*16+8),16);
  if (Lx[3].ul[0]>0) Lx[3].ul[0]=Lx[3].ul[0] -1;
  else {
    Ra.sl[6]=3027; /* line # 3027 */
    MXD_CMP_error(Rd.s+2035,-6);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inint "  */
void MXD_CMP_PRC_00000007(V F_obj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2044;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3033; /* line # 3033 */
  Ra.sl[6]=3035; /* line # 3035 */
  ((F *)F_obj)[1]=(F)0.000000E-01;
  Ra.sl[6]=3036; /* line # 3036 */
  if (((F *)F_obj)[2]>=(F)-3.276775E+05&&((F *)F_obj)[2]<=(F)3.276650E+04) {
    Ra.sl[6]=3038; /* line # 3038 */
    if (((F *)F_obj)[2]>=(F)0.000000E-01) ((F *)F_obj)[1]=(float)(int)(((F *)F_obj)
    [2]+(F)5.000000E-01);
    else {
      Ra.sl[6]=3039; /* line # 3039 */
      ((F *)F_obj)[1]=(float)(int)(((F *)F_obj)[2]-(F)5.000000E-01);
    }
    Ra.sl[6]=3040; /* line # 3040 */
    if (((F *)F_obj)[1]!=(F)0.000000E-01) {
      Ra.sl[6]=3041; /* line # 3041 */
      if (fabs((((F *)F_obj)[2]-((F *)F_obj)[1])/((F *)F_obj)[1])<(F)1.000000E-06)
       ((F *)F_obj)[2]=((F *)F_obj)[1];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " testbin "  */
void MXD_CMP_PRC_00000008(UB F_bp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2051;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3049; /* line # 3049 */
  MXD_CMP_PRC_00000006();
  Ra.sl[6]=3050; /* line # 3050 */
  Ra.sl[6]=3052; /* line # 3052 */
  if (F_bp<=1) {
    Ra.sl[6]=3054; /* line # 3054 */
    if (Lx[0].ub[3]==1) MXD_CMP_convint(Lx[0].s);
    Ra.sl[6]=3055; /* line # 3055 */
    if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
  }
  else {
    Ra.sl[6]=3058; /* line # 3058 */
    if (F_bp==2) {
      Ra.sl[6]=3060; /* line # 3060 */
      if (Lx[0].ub[3]==2) MXD_CMP_convstr(Lx[0].s,0);
      Ra.sl[6]=3061; /* line # 3061 */
      if (Rs.ub[907]==2) MXD_CMP_convstr(Rs.s+904,0);
    }
    else {
      Ra.sl[6]=3064; /* line # 3064 */
      if (Lx[0].ub[3]!=Rs.ub[907]) {
        Ra.sl[6]=3066; /* line # 3066 */
        if (Lx[0].ub[3]==2&&Rs.ub[907]==1) {
          Ra.sl[6]=3067; /* line # 3067 */
          MXD_CMP_convstr(Lx[0].s,0);
        }
        else {
          Ra.sl[6]=3069; /* line # 3069 */
          if (Lx[0].ub[3]==1&&Rs.ub[907]==2) {
            Ra.sl[6]=3070; /* line # 3070 */
            MXD_CMP_convstr(Rs.s+904,0);
          }
          else {
            Ra.sl[6]=3072; /* line # 3072 */
            if (F_bp==4) {
              Ra.sl[6]=3074; /* line # 3074 */
              if (Lx[0].ub[3]>=3&&Rs.ub[907]==1) {
                Ra.sl[6]=3075; /* line # 3075 */
                MXD_CMP_convint(Rs.s+904);
              }
              else {
                Ra.sl[6]=3077; /* line # 3077 */
                if (Lx[0].ub[3]==1&&Rs.ub[907]>=3) {
                  Ra.sl[6]=3078; /* line # 3078 */
                  MXD_CMP_convint(Lx[0].s);
                }
              }
            }
          }
        }
      }
    }
  }
  Ra.sl[6]=3081; /* line # 3081 */
  if (Lx[0].ub[3]==2) MXD_CMP_PRC_00000007(Lx[0].s);
  Ra.sl[6]=3082; /* line # 3082 */
  Lx[0].ub[16]=Rs.ub[907]==1&&Lx[0].ub[3]==1;
  Ra.sl[6]=3083; /* line # 3083 */
  Lx[0].ub[17]=Rs.ub[907]==2&&Lx[0].ub[3]==2;
  Ra.sl[6]=3084; /* line # 3084 */
  if (Rs.ub[907]!=Lx[0].ub[3]&&(Rs.ub[907]==1||Lx[0].ub[3]==1)) {
    Ra.sl[6]=3085; /* line # 3085 */
    MXD_CMP_error(Rd.s+2035,-53);
  }
  Ra.sl[6]=3086; /* line # 3086 */
  if (Lx[0].ub[16]&&(F_bp!=2&&F_bp<3)||Lx[0].ub[17]&&F_bp==2) {
    Ra.sl[6]=3088; /* line # 3088 */
    MXD_CMP_error(Rd.s+2035,-53);
  }
  Ra.sl[6]=3089; /* line # 3089 */
  if (Rs.ub[907]==2) {
    Ra.sl[6]=3090; /* line # 3090 */
    Ra.sl[6]=3092; /* line # 3092 */
    MXD_CMP_PRC_00000007(Rs.s+904);
    Ra.sl[6]=3093; /* line # 3093 */
    if (Rs.f[227]==Rs.f[228]&&Lx[0].p[7].ub[2]==22) {
      Ra.sl[6]=3094; /* line # 3094 */
      Lx[0].p[7].ub[2]=23;
      Lx[0].sl[5]=(int)(Rs.f[228]);
    }
  }
  Ra.sl[6]=3096; /* line # 3096 */
  if ((F_bp!=0&&F_bp!=4)&&!(Lx[0].ub[17]||Lx[0].ub[16])) {
    Ra.sl[6]=3097; /* line # 3097 */
    MXD_CMP_error(Rd.s+2035,-54);
  }
  Ra.sl[6]=3098; /* line # 3098 */
  if (!Lx[0].ub[17]&&!Lx[0].ub[16]) {
    Ra.sl[6]=3100; /* line # 3100 */
    MXD_CMP_putrefitm(Lx[0].s,1);
    Ra.sl[6]=3101; /* line # 3101 */
    if (Lx[0].p[7].ub[2]!=23) MXD_CMP_putrefitm(Rs.s+904,1);
    else {
      Ra.sl[6]=3102; /* line # 3102 */
      Rs.ub[907]=4;
    }
    Ra.sl[6]=3103; /* line # 3103 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT((SL)Lx[0].p[7].ub[2],4,0);
    Ra.sl[6]=3104; /* line # 3104 */
    if (Lx[0].p[7].ub[2]==23) {
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Lx[0].sl[5],8,0);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=3105; /* line # 3105 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " testuna "  */
void MXD_CMP_PRC_00000009(UB F_bp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2060;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3113; /* line # 3113 */
  Ra.sl[6]=3115; /* line # 3115 */
  if (F_bp<=1) {
    Ra.sl[6]=3116; /* line # 3116 */
    if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
    else {
      Ra.sl[6]=3118; /* line # 3118 */
      if (F_bp==2) {
        Ra.sl[6]=3119; /* line # 3119 */
        if (Rs.ub[907]==2) MXD_CMP_convstr(Rs.s+904,0);
      }
    }
  }
  Ra.sl[6]=3120; /* line # 3120 */
  Lx[0].ub[16]=Rs.ub[907]==1;
  Ra.sl[6]=3121; /* line # 3121 */
  Lx[0].ub[17]=Rs.ub[907]==2;
  Ra.sl[6]=3122; /* line # 3122 */
  if (Lx[0].ub[16]&&F_bp!=2||Lx[0].ub[17]&&F_bp==2) {
    Ra.sl[6]=3123; /* line # 3123 */
    MXD_CMP_error(Rd.s+2035,-55);
  }
  Ra.sl[6]=3125; /* line # 3125 */
  if (Lx[0].ub[17]) MXD_CMP_PRC_00000007(Rs.s+904);
  Ra.sl[6]=3126; /* line # 3126 */
  if (!(Lx[0].ub[17]||Lx[0].ub[16])) {
    Ra.sl[6]=3127; /* line # 3127 */
    if (F_bp!=0) MXD_CMP_error(Rd.s+2035,-56);
    else {
      Ra.sl[6]=3129; /* line # 3129 */
      MXD_CMP_putrefitm(Rs.s+904,1);
      Ra.sl[6]=3130; /* line # 3130 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT((SL)Lx[0].p[7].ub[2],4,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " putitem "  */
void MXD_CMP_PRC_00000005(V F_oper){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  SL Rv2;
  register int Rgi;
  register int Rgj;
  register F Rgf;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[7]=F_oper;
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+2069;
  Ra.v[5]=Rd.s+12;
  Ra.sl[12]=3135; /* line # 3135 */
  Ra.ub[17]=0;
  Ra.sl[12]=3136; /* line # 3136 */
  Ra.ub[16]=0;
  Ra.sl[12]=3137; /* line # 3137 */
  Ra.sl[12]=3139; /* line # 3139 */
  switch (Ra.p[7].ub[2]) {
    case 74:break;
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 7:
    case 16:Ra.sl[12]=3144; /* line # 3144 */
    if (Rs.ub[906]!=74) {
      Ra.sl[12]=3146; /* line # 3146 */
      MXD_CMP_PRC_00000003();
      Ra.sl[12]=3147; /* line # 3147 */
      memcpy((Lx[3].s+Lx[3].ul[0]*16+8),Rs.s+904,16);
    }
    Ra.sl[12]=3149; /* line # 3149 */
    memcpy(Rs.s+904,Ra.p[7].s,16);
    Ra.sl[12]=3150; /* line # 3150 */
    if (Rs.ub[906]!=16) {
      Ra.sl[12]=3151; /* line # 3151 */
      Rv0=1;
      for( Rf0=Lx[3].ul[0];Rf0>0;Rf0-- ) {
        MXD_CMP_putrefitm((Lx[3].s+Rv0*16+8),1);
        Rv0++;
      }
    }
    break;
    case 17:Ra.sl[12]=3154; /* line # 3154 */
    MXD_CMP_PRC_00000008(0);
    if (Ra.ub[17]) Rs.f[228]=Ra.f[2]+Rs.f[228];
    break;
    case 18:Ra.sl[12]=3156; /* line # 3156 */
    MXD_CMP_PRC_00000008(0);
    if (Ra.ub[17]) Rs.f[228]=Ra.f[2]-Rs.f[228];
    break;
    case 19:Ra.sl[12]=3158; /* line # 3158 */
    MXD_CMP_PRC_00000008(0);
    if (Ra.ub[17]) Rs.f[228]=Ra.f[2]*Rs.f[228];
    break;
    case 20:Ra.sl[12]=3160; /* line # 3160 */
    MXD_CMP_PRC_00000008(0);
    Ra.sl[12]=3161; /* line # 3161 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3162; /* line # 3162 */
      if (fabs(Rs.f[228])<(F)1.000000E-030) MXD_CMP_error(Rd.s+2035,27);
      else {
        Ra.sl[12]=3163; /* line # 3163 */
        Rs.f[228]=Ra.f[2]/Rs.f[228];
      }
    }
    break;
    case 22:
    case 23:Ra.sl[12]=3167; /* line # 3167 */
    MXD_CMP_PRC_00000008(0);
    Ra.sl[12]=3168; /* line # 3168 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3169; /* line # 3169 */
      if (Ra.p[7].ub[2]==23) Rs.f[228]=PAS__IFPOWER(Ra.f[2],Ra.sl[5]);
      else {
        Ra.sl[12]=3171; /* line # 3171 */
        if (Ra.f[2]<(F)0.000000E-01) MXD_CMP_error(Rd.s+2035,28);
        else {
          Ra.sl[12]=3173; /* line # 3173 */
          Rv1=Ra.f[2];
          Rs.f[228]=exp(log(Rv1)*Rs.f[228]);
        }
      }
    }
    break;
    case 138:Ra.sl[12]=3178; /* line # 3178 */
    MXD_CMP_PRC_00000008(2);
    Ra.sl[12]=3179; /* line # 3179 */
    if (Ra.ub[16]) {
      Ra.sl[12]=3180; /* line # 3180 */
      MXD_CMP_copystr(Rs.v+114,MXD_CMP_concatstr(Ra.v[1],Rs.v[114]),1);
      Ra.sl[12]=3181; /* line # 3181 */
      if (Ra.v[1]!=Rs.v[114]) P_st_free(Ra.v+1);
      Ra.sl[12]=3182; /* line # 3182 */
      Ra.v[1]=NULL;
    }
    break;
    case 145:Ra.sl[12]=3188; /* line # 3188 */
    MXD_CMP_PRC_00000009(2);
    Ra.sl[12]=3189; /* line # 3189 */
    if (Ra.ub[16]) MXD_CMP_convint(Rs.s+904);
    break;
    case 144:Ra.sl[12]=3194; /* line # 3194 */
    MXD_CMP_PRC_00000008(1);
    Ra.sl[12]=3195; /* line # 3195 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3197; /* line # 3197 */
      Ra.sl[5]=(int)(Rs.f[227]+(F)5.000000E-01);
      memcpy(Rs.s+904,Ra.s,16);
      MXD_CMP_convstr(Rs.s+904,Ra.sl[5]);
    }
    break;
    case 140:Ra.sl[12]=3202; /* line # 3202 */
    MXD_CMP_PRC_00000008(1);
    Ra.sl[12]=3203; /* line # 3203 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3205; /* line # 3205 */
      Ra.sl[5]=PAS__F_ROUND(Ra.f[1]);
      Rv2=PAS__F_ROUND(Rs.f[227]);
      Ra.sl[12]=3206; /* line # 3206 */
      MXD_CMP_PRC_00000000(Ra.p[7].v[1],Ra.sl[5],Rv2);
      Ra.sl[12]=3207; /* line # 3207 */
      memcpy(Rs.s+904,Ra.p[7].s,16);
      Rs.ub[906]=16;
    }
    break;
    case 35:Ra.sl[12]=3212; /* line # 3212 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]=fabs(Rs.f[228]);
    break;
    case 8:Ra.sl[12]=3215; /* line # 3215 */
    MXD_CMP_PRC_00000009(0);
    break;
    case 139:Ra.sl[12]=3222; /* line # 3222 */
    MXD_CMP_PRC_00000009(1);
    if (Ra.ub[17]) Rs.f[228]=MXD_CMP_interpol(Ra.p[7].v[1],Rs.f+228);
    break;
    case 21:Ra.sl[12]=3226; /* line # 3226 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]= -Rs.f[228];
    break;
    case 24:Ra.sl[12]=3228; /* line # 3228 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]=(float)sin((double)Rs.f[228]*1.745329310000000E-002)
    ;
    break;
    case 25:Ra.sl[12]=3230; /* line # 3230 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]=(float)cos((double)Rs.f[228]*1.745329310000000E-002)
    ;
    break;
    case 26:Ra.sl[12]=3232; /* line # 3232 */
    MXD_CMP_PRC_00000009(0);
    Ra.sl[12]=3233; /* line # 3233 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3234; /* line # 3234 */
      Rs.f[228]=(float)((double)Rs.f[228]*1.745329310000000E-002);
      Rs.f[228]=sin(Rs.f[228])/cos(Rs.f[228]);
    }
    break;
    case 30:Ra.sl[12]=3237; /* line # 3237 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]=exp(Rs.f[228]);
    break;
    case 31:Ra.sl[12]=3239; /* line # 3239 */
    MXD_CMP_PRC_00000009(0);
    Ra.sl[12]=3240; /* line # 3240 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3241; /* line # 3241 */
      if (Rs.f[228]<=(F)0.000000E-01) MXD_CMP_error(Rd.s+2035,29);
      else {
        Ra.sl[12]=3242; /* line # 3242 */
        Rs.f[228]=log(Rs.f[228]);
      }
    }
    break;
    case 33:Ra.sl[12]=3246; /* line # 3246 */
    MXD_CMP_PRC_00000009(0);
    Ra.sl[12]=3247; /* line # 3247 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3249; /* line # 3249 */
      Rv1=exp((F)-2.000000E+00*fabs(Rs.f[228]));
      Ra.sl[12]=3250; /* line # 3250 */
      Rv1=((F)1.000000E+00-Rv1)/((F)1.000000E+00+Rv1);
      Ra.sl[12]=3251; /* line # 3251 */
      if (Rs.f[228]>(F)0.000000E-01) Rs.f[228]=Rv1;
      else Rs.f[228]= -Rv1;
    }
    break;
    case 29:Ra.sl[12]=3256; /* line # 3256 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]=(float)((double)atan(Rs.f[228])/1.745329310000000E-002)
    ;
    break;
    case 27:
    case 28:Ra.sl[12]=3260; /* line # 3260 */
    MXD_CMP_PRC_00000009(0);
    Ra.sl[12]=3261; /* line # 3261 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3263; /* line # 3263 */
      Rs.f[228]=MXD_CMP_PRC_00000002(Rs.f[228]);
      Ra.sl[12]=3264; /* line # 3264 */
      if (Ra.p[7].ub[2]==28) Rs.f[228]=(F)9.000000E+01-Rs.f[228];
    }
    break;
    case 34:Ra.sl[12]=3268; /* line # 3268 */
    MXD_CMP_PRC_00000008(0);
    Ra.sl[12]=3269; /* line # 3269 */
    if (Ra.ub[17]) Rs.f[228]=MXD_CMP_phasearg(Ra.f[2],Rs.f[228]);
    break;
    case 36:Ra.sl[12]=3272; /* line # 3272 */
    MXD_CMP_PRC_00000008(0);
    Ra.sl[12]=3273; /* line # 3273 */
    if (Ra.ub[17]) Rs.f[228]=P_bessel_j(PAS__F_ROUND(Ra.f[2]),Rs.f[228]);
    break;
    case 32:Ra.sl[12]=3276; /* line # 3276 */
    MXD_CMP_PRC_00000009(0);
    Ra.sl[12]=3277; /* line # 3277 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3278; /* line # 3278 */
      if (Rs.f[228]<(F)0.000000E-01) MXD_CMP_error(Rd.s+2035,30);
      else Rs.f[228]=sqrt(Rs.f[228]);
    }
    break;
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:Ra.sl[12]=3282; /* line # 3282 */
    MXD_CMP_PRC_00000008(4);
    Ra.sl[12]=3283; /* line # 3283 */
    if (Ra.ub[17]||Ra.ub[16]) {
      Ra.sl[12]=3285; /* line # 3285 */
      Rs.ub[907]=2;
      Ra.sl[12]=3286; /* line # 3286 */
      if (Ra.ub[16]) Ra.sl[5]=MXD_CMP_cmpstr(Ra.v+1,Rs.v+114);
      else {
        Ra.sl[12]=3289; /* line # 3289 */
        Rs.f[228]=Ra.f[2]-Rs.f[228];
        Ra.sl[12]=3290; /* line # 3290 */
        if (Rs.f[228]==(F)0.000000E-01) Ra.sl[5]=0;
        else {
          Ra.sl[12]=3291; /* line # 3291 */
          if (Rs.f[228]>(F)0.000000E-01) Ra.sl[5]=1;
          else Ra.sl[5]=-1;
        }
      }
      Ra.sl[12]=3293; /* line # 3293 */
      switch (Ra.p[7].ub[2]) {
        case 50:Ra.sl[12]=3294; /* line # 3294 */
        Ra.ub[17]=Ra.sl[5]==0;
        break;
        case 51:Ra.sl[12]=3295; /* line # 3295 */
        Ra.ub[17]=Ra.sl[5]!=0;
        break;
        case 52:Ra.sl[12]=3296; /* line # 3296 */
        Ra.ub[17]=Ra.sl[5]<0;
        break;
        case 53:Ra.sl[12]=3297; /* line # 3297 */
        Ra.ub[17]=Ra.sl[5]<=0;
        break;
        case 54:Ra.sl[12]=3298; /* line # 3298 */
        Ra.ub[17]=Ra.sl[5]>=0;
        break;
        case 55:Ra.sl[12]=3299; /* line # 3299 */
        Ra.ub[17]=Ra.sl[5]>0;
        break;
      }
      Ra.sl[12]=3301; /* line # 3301 */
      Ra.sl[5]=(SL)Ra.ub[17];
      Rs.f[228]=(float)Ra.sl[5];
      Ra.sl[12]=3302; /* line # 3302 */
      Rs.f[227]=Rs.f[228];
    }
    break;
    case 48:Ra.sl[12]=3307; /* line # 3307 */
    MXD_CMP_PRC_00000008(0);
    Ra.sl[12]=3308; /* line # 3308 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3309; /* line # 3309 */
      Rs.f[228]=(float)PAS__I_MOD((int)(Ra.f[1]),(int)(Rs.f[227]));
    }
    break;
    case 49:Ra.sl[12]=3312; /* line # 3312 */
    MXD_CMP_PRC_00000009(0);
    if (Ra.ub[17]) Rs.f[228]=Rs.f[227];
    break;
    case 135:Ra.sl[12]=3315; /* line # 3315 */
    MXD_CMP_PRC_00000008(1);
    Ra.sl[12]=3316; /* line # 3316 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3318; /* line # 3318 */
      if (Ra.f[1]!=(F)0.000000E-01&&Rs.f[228]!=(F)0.000000E-01) Rs.f[228]=(F)1.000000E+00;
      else {
        Ra.sl[12]=3319; /* line # 3319 */
        Rs.f[228]=(F)0.000000E-01;
      }
      Ra.sl[12]=3320; /* line # 3320 */
      Rs.f[227]=Rs.f[228];
    }
    break;
    case 136:Ra.sl[12]=3325; /* line # 3325 */
    MXD_CMP_PRC_00000008(1);
    Ra.sl[12]=3326; /* line # 3326 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3328; /* line # 3328 */
      if (Ra.f[1]!=(F)0.000000E-01||Rs.f[227]!=(F)0.000000E-01) Rs.f[228]=(F)1.000000E+00;
      else {
        Ra.sl[12]=3329; /* line # 3329 */
        Rs.f[228]=(F)0.000000E-01;
      }
      Ra.sl[12]=3330; /* line # 3330 */
      Rs.f[227]=Rs.f[228];
    }
    break;
    case 137:Ra.sl[12]=3335; /* line # 3335 */
    MXD_CMP_PRC_00000009(1);
    Ra.sl[12]=3336; /* line # 3336 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3337; /* line # 3337 */
      if (Rs.f[227]!=(F)0.000000E-01) Rs.f[228]=(F)0.000000E-01;
      else Rs.f[228]=(F)1.000000E+00;
    }
    Ra.sl[12]=3338; /* line # 3338 */
    Rs.f[227]=Rs.f[228];
    break;
    case 141:Ra.sl[12]=3342; /* line # 3342 */
    MXD_CMP_PRC_00000009(2);
    Ra.sl[12]=3343; /* line # 3343 */
    if (Ra.ub[16]) {
      Ra.sl[12]=3345; /* line # 3345 */
      Ra.sl[5]=(SL)((C *)Rs.v[114])[140];
      P_st_free(Rs.v+114);
      Ra.sl[12]=3346; /* line # 3346 */
      Rs.ub[907]=2;
      Rs.f[227]=(float)Ra.sl[5];
      Rs.f[228]=Rs.f[227];
    }
    break;
    case 142:Ra.sl[12]=3351; /* line # 3351 */
    MXD_CMP_PRC_00000008(2);
    Ra.sl[12]=3352; /* line # 3352 */
    if (Ra.ub[16]) {
      Ra.sl[12]=3354; /* line # 3354 */
      Ra.sl[5]=MXD_CMP_PRC_00000001(Ra.v[1],Rs.v[114]);
      Ra.sl[12]=3355; /* line # 3355 */
      P_st_free(Rs.v+114);
      P_st_free(Ra.v+1);
      Ra.sl[12]=3356; /* line # 3356 */
      Rs.ub[907]=2;
      Rs.f[227]=(float)Ra.sl[5];
      Rs.f[228]=Rs.f[227];
    }
    break;
    case 143:Ra.sl[12]=3361; /* line # 3361 */
    MXD_CMP_PRC_00000009(1);
    Ra.sl[12]=3362; /* line # 3362 */
    if (Ra.ub[17]) {
      Ra.sl[12]=3364; /* line # 3364 */
      Ra.sl[5]=PAS__F_ROUND(Rs.f[227]);
      Ra.sl[12]=3365; /* line # 3365 */
      MXD_CMP_PRC_00000006();
      Ra.sl[12]=3366; /* line # 3366 */
      memcpy(Rs.s+904,Ra.s,16);
      Ra.sl[12]=3367; /* line # 3367 */
      MXD_CMP_PRC_00000008(2);
      Ra.sl[12]=3368; /* line # 3368 */
      if (Ra.ub[16]) {
        Ra.sl[12]=3370; /* line # 3370 */
        Ra.sl[5]=MXD_CMP_nindex(Ra.v[1],Rs.v[114],Ra.sl[5]);
        Ra.sl[12]=3371; /* line # 3371 */
        P_st_free(Rs.v+114);
        P_st_free(Ra.v+1);
        Ra.sl[12]=3372; /* line # 3372 */
        Rs.ub[907]=2;
        Rs.f[227]=(float)Ra.sl[5];
        Rs.f[228]=Rs.f[227];
      }
    }
    break;
    case 148:Ra.sl[12]=3378; /* line # 3378 */
    MXD_CMP_PRC_00000009(2);
    Ra.sl[12]=3379; /* line # 3379 */
    if (Ra.ub[16]) MXD_CMP_getenvsymb(Rs.v[114]);
    break;
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " pushzero "  */
void MXD_CMP_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2078;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3392; /* line # 3392 */
  Ra.sl[6]=3394; /* line # 3394 */
  Ra.ub[34]=16;
  Ra.ub[35]=2;
  Ra.f[9]=(F)0.000000E-01;
  Ra.f[10]=(F)0.000000E-01;
  Ra.c[32]=57;
  Ra.sl[6]=3396; /* line # 3396 */
  MXD_CMP_PRC_00000005(Ra.s+32);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setsubstr "  */
void MXD_CMP_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2088;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3423; /* line # 3423 */
  MXD_CMP_insymbol();
  Lx[1].ub[0]=1;
  Ra.sl[6]=3424; /* line # 3424 */
  Ra.sl[6]=3426; /* line # 3426 */
  if (Rs.ub[504]==153) {
    Ra.sl[6]=3427; /* line # 3427 */
    Ra.sl[6]=3429; /* line # 3429 */
    Lx[2].ub[2]=140;
    Ra.sl[6]=3430; /* line # 3430 */
    Lx[1].ub[0]=0;
    MXD_CMP_insymbol();
    MXD_CMP_PRC_00000004();
    Ra.sl[6]=3431; /* line # 3431 */
    if (Rs.ub[504]==149) {
      Ra.sl[6]=3432; /* line # 3432 */
      MXD_CMP_insymbol();
      MXD_CMP_PRC_00000004();
    }
    else {
      Ra.sl[6]=3433; /* line # 3433 */
      MXD_CMP_PRC_00000010();
    }
    Ra.sl[6]=3434; /* line # 3434 */
    if (Rs.ub[504]!=154) MXD_CMP_error(Rd.s+2035,83);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " stopexpr "  */
void MXD_CMP_PRC_00000013(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2099;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3443; /* line # 3443 */
  Lx[2].ub[16]=1;
  Lx[2].c[0]=32;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getitem "  */
void MXD_CMP_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+2109;
  Ra.v[3]=Rd.s+12;
  Ra.sl[8]=3448; /* line # 3448 */
  Lx[2].ub[16]=0;
  Ra.ub[0]=0;
  Ra.sl[8]=3449; /* line # 3449 */
  Ra.sl[8]=3451; /* line # 3451 */
  Lx[2].c[0]=57;
  Ra.sl[8]=3452; /* line # 3452 */
  Lx[2].ub[2]=Rs.ub[504];
  Ra.sl[8]=3453; /* line # 3453 */
  switch (Rs.ub[505]) {
    case 0:Ra.sl[8]=3455; /* line # 3455 */
    if (Lx[2].ub[17]) {
      Ra.sl[8]=3456; /* line # 3456 */
      if (Rs.v[66]!=NULL) {
        Ra.sl[8]=3457; /* line # 3457 */
        Rv0=Rs.v[66];
        Ra.sl[8]=3459; /* line # 3459 */
        Lx[2].ub[17]=0;
        Ra.sl[8]=3460; /* line # 3460 */
        switch (((UB *)Rv0)[48]) {
          case 8:Ra.sl[8]=3463; /* line # 3463 */
          Lx[2].ub[3]=3;
          Lx[2].ub[2]=0;
          Lx[2].v[1]=NULL;
          Ra.sl[8]=3464; /* line # 3464 */
          Lx[2].c[1]=(C)((SL)Rs.ub[504]-156);
          break;
          case 12:Ra.sl[8]=3469; /* line # 3469 */
          Lx[2].v[1]=Rs.v[66];
          Lx[2].ub[3]=3;
          Ra.sl[8]=3470; /* line # 3470 */
          MXD_CMP_insymbol();
          Ra.ub[0]=1;
          Ra.sl[8]=3471; /* line # 3471 */
          if (Rs.ub[504]==153||Rs.ub[504]==151) {
            Ra.sl[8]=3473; /* line # 3473 */
            Lx[2].ub[3]=2;
            Ra.sl[8]=3474; /* line # 3474 */
            if (Rs.ub[504]==153) Lx[2].ub[2]=8;
            else {
              Ra.sl[8]=3475; /* line # 3475 */
              Lx[2].ub[2]=139;
            }
            Ra.sl[8]=3476; /* line # 3476 */
            Ra.ub[0]=0;
            MXD_CMP_insymbol();
            Ra.sl[8]=3477; /* line # 3477 */
            MXD_CMP_PRC_00000004();
            Ra.sl[8]=3478; /* line # 3478 */
            if (Lx[2].ub[2]==139&&Rs.ub[504]!=152) {
              Ra.sl[8]=3479; /* line # 3479 */
              MXD_CMP_error(Rd.s+2035,81);
            }
            else {
              Ra.sl[8]=3481; /* line # 3481 */
              if (Lx[2].ub[2]==8&&Rs.ub[504]!=154) {
                Ra.sl[8]=3482; /* line # 3482 */
                MXD_CMP_error(Rd.s+2035,83);
              }
            }
          }
          break;
          case 10:Ra.sl[8]=3487; /* line # 3487 */
          switch (((UB *)Rv0)[49]) {
            case 1:Ra.sl[8]=3490; /* line # 3490 */
            Lx[2].ub[3]=1;
            Lx[2].ub[2]=16;
            Ra.sl[8]=3491; /* line # 3491 */
            Lx[2].v[1]=NULL;
            MXD_CMP_copystr(Lx[2].v+1,((V *)Rv0)[7],0);
            Ra.sl[8]=3492; /* line # 3492 */
            MXD_CMP_PRC_00000012();
            break;
            case 2:Ra.sl[8]=3496; /* line # 3496 */
            Lx[2].ub[3]=2;
            Lx[2].ub[2]=16;
            Lx[2].f[2]=((F *)Rv0)[13];
            break;
            case 3:
            case 4:Ra.sl[8]=3499; /* line # 3499 */
            Lx[2].ub[3]=3;
            Lx[2].v[1]=Rs.v[66];
            break;
            case 0:Ra.sl[8]=3500; /* line # 3500 */
            MXD_CMP_error(Rd.s+2035,-88);
            break;
          }
          break;
          case 11:
          case 13:
          case 14:
          case 15:
          case 17:Ra.sl[8]=3505; /* line # 3505 */
          Lx[2].ub[3]=3;
          Lx[2].v[1]=Rs.v[66];
          break;
          case 18:Ra.sl[8]=3510; /* line # 3510 */
          MXD_CMP_insymbol();
          Ra.sl[8]=3511; /* line # 3511 */
          MXD_CMP_looksymbol(151,82,1);
          Ra.sl[8]=3512; /* line # 3512 */
          switch (Lx[2].ub[2]) {
            case 146:Ra.sl[8]=3515; /* line # 3515 */
            if (Ri.ub[92]) {
              Ra.sl[8]=3516; /* line # 3516 */
              switch (Rs.ub[505]) {
                case 0:Ra.sl[8]=3518; /* line # 3518 */
                if (Rs.v[66]!=NULL) Lx[2].f[2]=(F)1.000000E+00;
                else {
                  Ra.sl[8]=3519; /* line # 3519 */
                  Lx[2].f[2]=(F)0.000000E-01;
                }
                break;
                case 1:Ra.sl[8]=3520; /* line # 3520 */
                Lx[2].f[2]=(F)3.000000E+00;
                break;
                case 2:
                case 3:Ra.sl[8]=3521; /* line # 3521 */
                Lx[2].f[2]=(F)2.000000E+00;
                break;
                case 5:Ra.sl[8]=3522; /* line # 3522 */
                Lx[2].f[2]=(F)4.000000E+00;
                break;
                default:Ra.sl[8]=3524; /* line # 3524 */
                MXD_CMP_error(Rd.s+2035,55);
                break;
              }
            }
            else {
              Ra.sl[8]=3526; /* line # 3526 */
              Lx[2].f[2]=(F)-1.000000E+00;
            }
            break;
            case 147:Ra.sl[8]=3530; /* line # 3530 */
            Lx[2].f[2]=(F)0.000000E-01;
            Ra.sl[8]=3531; /* line # 3531 */
            if (Rs.v[66]!=NULL) {
              Ra.sl[8]=3532; /* line # 3532 */
              Rv1=Rs.v[66];
              Ra.sl[8]=3534; /* line # 3534 */
              if (((UB *)Rv1)[48]==10) {
                Ra.sl[8]=3535; /* line # 3535 */
                if (((UB *)Rv1)[49]==4) Lx[2].f[2]=(float)((SL *)Rv1)[1];
              }
            }
            break;
            default:break;
          }
          Ra.sl[8]=3539; /* line # 3539 */
          MXD_CMP_insymbol();
          Ra.sl[8]=3540; /* line # 3540 */
          MXD_CMP_looksymbol(152,-81,0);
          Ra.sl[8]=3541; /* line # 3541 */
          Lx[2].ub[2]=16;
          Lx[2].ub[3]=2;
          break;
          case 6:Ra.sl[8]=3546; /* line # 3546 */
          MXD_CMP_insymbol();
          Ra.sl[8]=3547; /* line # 3547 */
          MXD_CMP_looksymbol(151,82,1);
          Ra.sl[8]=3548; /* line # 3548 */
          MXD_CMP_PRC_00000004();
          Ra.sl[8]=3549; /* line # 3549 */
          switch (Lx[2].ub[2]) {
            case 29:Ra.sl[8]=3551; /* line # 3551 */
            if (Rs.ub[504]==150) {
              Ra.sl[8]=3552; /* line # 3552 */
              Lx[2].ub[2]=34;
              Ra.sl[8]=3553; /* line # 3553 */
              MXD_CMP_insymbol();
              MXD_CMP_PRC_00000004();
            }
            break;
            case 144:Ra.sl[8]=3557; /* line # 3557 */
            if (Rs.ub[504]==150) {
              Ra.sl[8]=3558; /* line # 3558 */
              MXD_CMP_insymbol();
              MXD_CMP_PRC_00000004();
            }
            else {
              Ra.sl[8]=3560; /* line # 3560 */
              MXD_CMP_PRC_00000010();
            }
            break;
            case 36:
            case 48:
            case 142:Ra.sl[8]=3565; /* line # 3565 */
            MXD_CMP_looksymbol(150,85,1);
            Ra.sl[8]=3566; /* line # 3566 */
            MXD_CMP_PRC_00000004();
            break;
            case 143:Ra.sl[8]=3571; /* line # 3571 */
            MXD_CMP_looksymbol(150,85,1);
            Ra.sl[8]=3572; /* line # 3572 */
            MXD_CMP_PRC_00000004();
            Ra.sl[8]=3574; /* line # 3574 */
            if (Rs.ub[504]==150) {
              Ra.sl[8]=3576; /* line # 3576 */
              MXD_CMP_insymbol();
              MXD_CMP_PRC_00000004();
            }
            else {
              Ra.sl[8]=3578; /* line # 3578 */
              MXD_CMP_PRC_00000010();
            }
            break;
            default:break;
          }
          Ra.sl[8]=3583; /* line # 3583 */
          Ra.ub[0]=0;
          Ra.sl[8]=3584; /* line # 3584 */
          MXD_CMP_looksymbol(152,-81,0);
          break;
          case 7:
          case 16:Ra.sl[8]=3589; /* line # 3589 */
          if (Lx[2].ub[2]!=140&&Rs.ub[906]!=74) {
            Ra.sl[8]=3591; /* line # 3591 */
            MXD_CMP_PRC_00000003();
            Ra.sl[8]=3592; /* line # 3592 */
            memcpy((Lx[3].s+Lx[3].ul[0]*16+8),Rs.s+904,16);
            Ra.sl[8]=3593; /* line # 3593 */
            Rv2=1;
            for( Rf0=Lx[3].ul[0];Rf0>0;Rf0-- ) {
              MXD_CMP_putrefitm((Lx[3].s+Rv2*16+8),1);
              Rv2++;
            }
            Ra.sl[8]=3595; /* line # 3595 */
            Rs.ub[906]=74;
          }
          Ra.sl[8]=3597; /* line # 3597 */
          if (((UB *)Rv0)[48]==16) MXD_CMP_usercall(Lx[2].s);
          else {
            Ra.sl[8]=3598; /* line # 3598 */
            MXD_CMP_callfunc(Lx[2].s);
          }
          break;
          case 2:break;
          case 3:
          case 4:Ra.sl[8]=3605; /* line # 3605 */
          Lx[2].ub[16]=1;
          Lx[2].c[0]=32;
          break;
          case 0:Ra.sl[8]=3607; /* line # 3607 */
          MXD_CMP_error(Rd.s+2035,-88);
          break;
        }
      }
      else {
        Ra.sl[8]=3610; /* line # 3610 */
        MXD_CMP_error(Rd.s+2035,51);
      }
    }
    else {
      Ra.sl[8]=3611; /* line # 3611 */
      MXD_CMP_PRC_00000013();
    }
    break;
    case 1:Ra.sl[8]=3614; /* line # 3614 */
    if (Lx[2].ub[17]) {
      Ra.sl[8]=3616; /* line # 3616 */
      Lx[2].ub[17]=0;
      Lx[2].ub[3]=1;
      Lx[2].v[1]=Rs.v[64];
      MXD_CMP_PRC_00000012();
    }
    else {
      Ra.sl[8]=3618; /* line # 3618 */
      MXD_CMP_PRC_00000013();
    }
    break;
    case 2:
    case 3:Ra.sl[8]=3621; /* line # 3621 */
    if (Lx[2].ub[17]) {
      Ra.sl[8]=3623; /* line # 3623 */
      Lx[2].ub[17]=0;
      Lx[2].ub[3]=2;
      Lx[2].f[2]=Rs.f[128];
      Lx[2].f[1]=Rs.f[127];
    }
    else {
      Ra.sl[8]=3625; /* line # 3625 */
      MXD_CMP_PRC_00000013();
    }
    break;
    case 5:Ra.sl[8]=3629; /* line # 3629 */
    if (((Lx[2].ub[17]&&Rs.ub[504]!=17)&&Rs.ub[504]!=18)&&Rs.ub[504]!=137) {
      Ra.sl[8]=3632; /* line # 3632 */
      MXD_CMP_error(Rd.s+2035,68);
      Ra.sl[8]=3633; /* line # 3633 */
      Lx[2].ub[16]=1;
      Lx[2].c[0]=32;
    }
    else {
      Ra.sl[8]=3636; /* line # 3636 */
      switch (Rs.ub[504]) {
        case 138:Ra.sl[8]=3637; /* line # 3637 */
        Lx[2].c[0]=53;
        break;
        case 17:
        case 18:Ra.sl[8]=3640; /* line # 3640 */
        if (Lx[2].ub[17]) {
          Ra.sl[8]=3642; /* line # 3642 */
          Lx[2].c[0]=55;
          if (Rs.ub[504]==18) Lx[2].ub[2]=21;
          else {
            Ra.sl[8]=3643; /* line # 3643 */
            Lx[2].ub[2]=74;
          }
        }
        else {
          Ra.sl[8]=3645; /* line # 3645 */
          Lx[2].c[0]=53;
        }
        break;
        case 19:
        case 20:Ra.sl[8]=3647; /* line # 3647 */
        Lx[2].c[0]=54;
        break;
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:Ra.sl[8]=3648; /* line # 3648 */
        Lx[2].c[0]=52;
        break;
        case 135:Ra.sl[8]=3649; /* line # 3649 */
        Lx[2].c[0]=50;
        break;
        case 136:Ra.sl[8]=3650; /* line # 3650 */
        Lx[2].c[0]=49;
        break;
        case 22:Ra.sl[8]=3651; /* line # 3651 */
        Lx[2].c[0]=55;
        break;
        case 137:Ra.sl[8]=3652; /* line # 3652 */
        if (!Lx[2].ub[17]) MXD_CMP_error(Rd.s+2035,67);
        else {
          Ra.sl[8]=3653; /* line # 3653 */
          Lx[2].c[0]=55;
        }
        break;
      }
    }
    Ra.sl[8]=3655; /* line # 3655 */
    Lx[2].ub[17]=1;
    break;
    case 4:Ra.sl[8]=3660; /* line # 3660 */
    Lx[2].c[0]=32;
    Ra.sl[8]=3661; /* line # 3661 */
    if (Rs.ub[504]==151) {
      Ra.sl[8]=3662; /* line # 3662 */
      if (Lx[2].ub[17]) {
        Ra.sl[8]=3664; /* line # 3664 */
        MXD_CMP_insymbol();
        MXD_CMP_PRC_00000004();
        Ra.sl[8]=3665; /* line # 3665 */
        MXD_CMP_looksymbol(152,81,0);
        Ra.sl[8]=3666; /* line # 3666 */
        Lx[2].ub[17]=0;
        Ra.sl[8]=3667; /* line # 3667 */
        Lx[2].c[0]=57;
        Lx[2].ub[2]=74;
      }
      else {
        Ra.sl[8]=3669; /* line # 3669 */
        MXD_CMP_error(Rd.s+2035,67);
      }
    }
    else {
      Ra.sl[8]=3670; /* line # 3670 */
      Lx[2].ub[16]=1;
    }
    break;
    case 6:break;
    case 7:Ra.sl[8]=3674; /* line # 3674 */
    Lx[2].ub[16]=1;
    break;
  }
  Ra.sl[8]=3677; /* line # 3677 */
  if (!(Lx[2].ub[16]||Ra.ub[0])) MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[1];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " subexpression "  */
void MXD_CMP_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  UL Rv0;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+2118;
  Ra.v[5]=Rd.s+12;
  Ra.sl[12]=3682; /* line # 3682 */
  Rv0=Lx[3].ul[134];
  Ra.ub[17]=1;
  Ra.sl[12]=3683; /* line # 3683 */
  Ra.ub[16]=0;
  Ra.sl[12]=3684; /* line # 3684 */
  MXD_CMP_PRC_00000011();
  Ra.sl[12]=3685; /* line # 3685 */
  while ((Lx[3].ul[134]!=Rv0||!Ra.ub[16])&&!V_fatalerror){
    Ra.sl[12]=3686; /* line # 3686 */
    if (Lx[3].ul[134]!=Rv0&&(Ra.c[0]<Lx[3].c[Lx[3].ul[134]*16+544]||Ra.c[0]==Lx[3]
    .c[Lx[3].ul[134]*16+544]&&Ra.c[0]!=55)) {
      Ra.sl[12]=3692; /* line # 3692 */
      MXD_CMP_PRC_00000005((Lx[3].s+Lx[3].ul[134]*16+544));
      Ra.sl[12]=3693; /* line # 3693 */
      Lx[3].ul[134]=Lx[3].ul[134]-1;
    }
    else {
      Ra.sl[12]=3697; /* line # 3697 */
      if (Lx[3].ul[134]==32) MXD_CMP_error(Rd.s+2035,-7);
      else Lx[3].ul[134]=Lx[3].ul[134]+1;
      Ra.sl[12]=3698; /* line # 3698 */
      memcpy((Lx[3].s+Lx[3].ul[134]*16+544),Ra.s,16);
      MXD_CMP_PRC_00000011();
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " expression "  */
void MXD_CMP_expression(){
  /* Define the automatic variable space. */
  Blk( Ra, 1104 );

  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[134]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1072;
  Ra.v[135]=Rd.s+2133;
  Ra.v[136]=Rd.s+12;
  Ra.sl[274]=3704; /* line # 3704 */
  Ra.ul[134]=0;
  Ra.ul[0]=0;
  Ra.sl[274]=3705; /* line # 3705 */
  Ra.c[544]=32;
  Ra.sl[274]=3706; /* line # 3706 */
  Ra.ub[11]=0;
  Ra.sl[274]=3707; /* line # 3707 */
  Rs.ub[907]=0;
  Ra.sl[274]=3708; /* line # 3708 */
  Rs.ub[906]=74;
  Ra.sl[274]=3709; /* line # 3709 */
  MXD_CMP_PRC_00000004();
  PAS__curr_cntx=Ra.v[134];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " inputletter "  */
void MXD_CMP_inputletter(C *F_ic){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2145;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3718; /* line # 3718 */
  Ra.sl[6]=3719; /* line # 3719 */
  if (Rs.ub[505]==0) (*F_ic)=Rs.c[507];
  else {
    Ra.sl[6]=3720; /* line # 3720 */
    if (Rs.ub[505]==1) {
      Ra.sl[6]=3721; /* line # 3721 */
      Rv0=Rs.v[64];
      Ra.sl[6]=3722; /* line # 3722 */
      if (((C *)Rv0)[140]>0) (*F_ic)=((C *)Rv0)[8];
      else (*F_ic)=32;
    }
  }
  Ra.sl[6]=3724; /* line # 3724 */
  if ((*F_ic)>=97&&(*F_ic)<=122) (*F_ic)=(C)((SL)(*F_ic)-32);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getphysparam "  */
void MXD_CMP_getphysparam(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2158;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3732; /* line # 3732 */
  MXD_CMP_expression();
  Ra.sl[6]=3733; /* line # 3733 */
  Ra.sl[6]=3735; /* line # 3735 */
  if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
  Ra.sl[6]=3736; /* line # 3736 */
  if (Rs.ub[906]==74) {
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(74,4,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=3737; /* line # 3737 */
    MXD_CMP_putrefitm(Rs.s+904,1);
  }
  Ra.sl[6]=3739; /* line # 3739 */
  if (Rs.ub[504]==150) MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " valueexpression "  */
void MXD_CMP_valueexpression(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2172;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3750; /* line # 3750 */
  MXD_CMP_expression();
  Ra.sl[6]=3751; /* line # 3751 */
  if (Rs.ub[907]==3) {
    Ra.sl[6]=3752; /* line # 3752 */
    MXD_CMP_putrefitm(Rs.s+904,0);
    Rs.ub[907]=3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " geticte "  */
void MXD_CMP_geticte(SL *F_i){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2189;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3760; /* line # 3760 */
  MXD_CMP_expression();
  Ra.sl[6]=3761; /* line # 3761 */
  Ra.sl[6]=3763; /* line # 3763 */
  if (Rs.ub[906]!=74) {
    Ra.sl[6]=3765; /* line # 3765 */
    if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
    Ra.sl[6]=3766; /* line # 3766 */
    if (Rs.ub[907]!=2) MXD_CMP_error(Rd.s+2200,58);
    else {
      Ra.sl[6]=3768; /* line # 3768 */
      (*F_i)=PAS__F_ROUND(Rs.f[228]);
    }
  }
  Ra.sl[6]=3772; /* line # 3772 */
  if (Rs.ub[504]==150) MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getncte "  */
void MXD_CMP_getncte(F *F_v){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2204;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3780; /* line # 3780 */
  MXD_CMP_expression();
  Ra.sl[6]=3781; /* line # 3781 */
  Ra.sl[6]=3783; /* line # 3783 */
  if (Rs.ub[906]!=74) {
    Ra.sl[6]=3785; /* line # 3785 */
    if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
    Ra.sl[6]=3786; /* line # 3786 */
    if (Rs.ub[907]!=2) MXD_CMP_error(Rd.s+2215,58);
    else (*F_v)=Rs.f[228];
  }
  Ra.sl[6]=3789; /* line # 3789 */
  if (Rs.ub[504]==150) MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getvarbl "  */
void MXD_CMP_getvarbl(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2219;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3797; /* line # 3797 */
  MXD_CMP_expression();
  Ra.sl[6]=3798; /* line # 3798 */
  if (Rs.ub[907]!=3) MXD_CMP_error(Rd.s+2231,59);
  Ra.sl[6]=3799; /* line # 3799 */
  if (Rs.ub[504]==150) MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getscte "  */
void MXD_CMP_getscte(V *F_ps){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2235;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3807; /* line # 3807 */
  (*F_ps)=NULL;
  Ra.sl[6]=3808; /* line # 3808 */
  MXD_CMP_expression();
  Ra.sl[6]=3809; /* line # 3809 */
  Ra.sl[6]=3811; /* line # 3811 */
  if (Rs.ub[907]==2) MXD_CMP_convstr(Rs.s+904,0);
  Ra.sl[6]=3812; /* line # 3812 */
  if (Rs.ub[907]!=1) MXD_CMP_error(Rd.s+2246,60);
  else (*F_ps)=Rs.v[114];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " looksemicol "  */
void MXD_CMP_looksemicol(UB F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2250;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3823; /* line # 3823 */
  Ra.sl[6]=3824; /* line # 3824 */
  if (Rs.ub[504]!=155) {
    Ra.sl[6]=3826; /* line # 3826 */
    MXD_CMP_error(Rd.s+2265,86);
    MXD_CMP_skip(155, F_bl);
  }
  else {
    Ra.sl[6]=3828; /* line # 3828 */
    if (F_bl) MXD_CMP_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " transvect "  */
void MXD_CMP_transvect(V F_mt, F *F_r1, F *F_r2, F *F_r3, F *F_d1, F *F_d2, F *F_d3)
{
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2269;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3836; /* line # 3836 */
  (*F_r1)=(((F *)F_mt)[0]*(*F_d1)+((F *)F_mt)[1]*(*F_d2))+((F *)F_mt)[2]*(*F_d3);
  Ra.sl[6]=3837; /* line # 3837 */
  (*F_r2)=(((F *)F_mt)[3]*(*F_d1)+((F *)F_mt)[4]*(*F_d2))+((F *)F_mt)[5]*(*F_d3);
  Ra.sl[6]=3838; /* line # 3838 */
  (*F_r3)=(((F *)F_mt)[6]*(*F_d1)+((F *)F_mt)[7]*(*F_d2))+((F *)F_mt)[8]*(*F_d3);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " newphysitm "  */
V MXD_CMP_newphysitm(UB F_itp, UB *F_badef, UB F_sep){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  UB Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2280;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3856; /* line # 3856 */
  if (F_sep!=74) {
    Ra.sl[6]=3857; /* line # 3857 */
    Ra.sl[6]=3858; /* line # 3858 */
    if (Rs.ub[504]!=F_sep) MXD_CMP_error(Rd.s+2294,82+3*(SL)(F_sep==150));
    else {
      Ra.sl[6]=3859; /* line # 3859 */
      MXD_CMP_insymbol();
    }
  }
  Ra.sl[6]=3860; /* line # 3860 */
  MXD_CMP_getscte(&Rv0);
  Ra.sl[6]=3861; /* line # 3861 */
  Ra.c[28]=0;
  Ra.sl[6]=3862; /* line # 3862 */
  if (Rv0!=NULL) {
    Ra.sl[6]=3863; /* line # 3863 */
    Rv1=Rv0;
    Ra.sl[6]=3865; /* line # 3865 */
    Rv2=(SL)((C *)Rv1)[140];
    if (Rv2>16) Rv2=16;
    Ra.sl[6]=3866; /* line # 3866 */
    Rv3=1;
    for( Rf0=Rv2;Rf0>0;Rf0-- ) {
      Ra.sl[6]=3867; /* line # 3867 */
      Ra.c[Rv3+28]=((C *)Rv1)[Rv3+7];
      Rv3++;
    }
    Ra.sl[6]=3868; /* line # 3868 */
    Ra.c[28]=(C)Rv2;
    Ra.sl[6]=3869; /* line # 3869 */
    P_st_free(&Rv0);
  }
  Ra.sl[6]=3871; /* line # 3871 */
  Rv4=Rs.v[F_itp+74];
  Ra.sl[6]=3872; /* line # 3872 */
  Rv5=NULL;
  Ra.sl[6]=3873; /* line # 3873 */
  Rv6=0;
  Ra.sl[6]=3874; /* line # 3874 */
  while (!Rv6&&Rv4!=NULL){
    Ra.sl[6]=3876; /* line # 3876 */
    if ((SL)((C *)Rv4)[8]!=Rv2) Rv6=0;
    else {
      Ra.sl[6]=3879; /* line # 3879 */
      Rv7=0;
      Ra.sl[6]=3880; /* line # 3880 */
      Rv6=1;
      Ra.sl[6]=3881; /* line # 3881 */
      while (Rv6&&Rv7<Rv2){
        Ra.sl[6]=3883; /* line # 3883 */
        Rv7=Rv7+1;
        Ra.sl[6]=3884; /* line # 3884 */
        Rv6=((C *)Rv4)[Rv7+8]==Ra.c[Rv7+28];
      }
    }
    Ra.sl[6]=3887; /* line # 3887 */
    Rv5=Rv4;
    Ra.sl[6]=3888; /* line # 3888 */
    if (!Rv6) Rv4=((V *)Rv4)[0];
  }
  Ra.sl[6]=3890; /* line # 3890 */
  (*F_badef)=Rv6;
  Ra.sl[6]=3891; /* line # 3891 */
  if (!Rv6) {
    Ra.sl[6]=3893; /* line # 3893 */
    switch (F_itp) {
      case 0:Ra.sl[6]=3894; /* line # 3894 */
      Rv8=PAS__NEW(56);
      break;
      case 1:Ra.sl[6]=3895; /* line # 3895 */
      Rv8=PAS__NEW(33);
      break;
      case 2:Ra.sl[6]=3896; /* line # 3896 */
      Rv8=PAS__NEW(33);
      break;
      case 4:Ra.sl[6]=3897; /* line # 3897 */
      Rv8=PAS__NEW(33);
      break;
      case 3:Ra.sl[6]=3898; /* line # 3898 */
      Rv8=PAS__NEW(33);
      break;
      case 6:Ra.sl[6]=3899; /* line # 3899 */
      Rv8=PAS__NEW(80);
      break;
      case 5:Ra.sl[6]=3900; /* line # 3900 */
      Rv8=PAS__NEW(89);
      break;
      case 7:Ra.sl[6]=3901; /* line # 3901 */
      Rv8=PAS__NEW(36);
      break;
    }
    Ra.sl[6]=3903; /* line # 3903 */
    Rv9=Rv8;
    Ra.sl[6]=3905; /* line # 3905 */
    ((SL *)Rv9)[7]=Rs.sl[F_itp+140];
    Ra.sl[6]=3906; /* line # 3906 */
    Rs.sl[F_itp+140]=Rs.sl[F_itp+140]+1;
    Ra.sl[6]=3907; /* line # 3907 */
    memcpy(Rv9+8,Ra.s+28,17);
    Ra.sl[6]=3908; /* line # 3908 */
    ((V *)Rv9)[0]=NULL;
    Ra.sl[6]=3910; /* line # 3910 */
    if (Rv5==NULL) Rs.v[F_itp+74]=Rv8;
    else {
      Ra.sl[6]=3911; /* line # 3911 */
      ((V *)Rv5)[0]=Rv8;
    }
    Ra.sl[6]=3912; /* line # 3912 */
    Rv4=Rv8;
  }
  Ra.sl[6]=3914; /* line # 3914 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " declarespecial "  */
void MXD_CMP_declarespecial(UB F_bm, UB *F_br){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2298;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3928; /* line # 3928 */
  (*F_br)=1;
  Ra.sl[6]=3929; /* line # 3929 */
  Ra.sl[6]=3931; /* line # 3931 */
  if (Rs.ub[505]!=0) MXD_CMP_error(Rd.s+2316,61);
  else {
    Ra.sl[6]=3933; /* line # 3933 */
    (*F_br)=Rs.v[66]!=NULL;
    Ra.sl[6]=3934; /* line # 3934 */
    if ((*F_br)) {
      Ra.sl[6]=3935; /* line # 3935 */
      Rv0=Rs.v[66];
      Ra.sl[6]=3936; /* line # 3936 */
      if (((UB *)Rv0)[48]<=5) MXD_CMP_error(Rd.s+2316,62);
      else {
        Ra.sl[6]=3937; /* line # 3937 */
        if (((SL *)Rv0)[0]==-1) MXD_CMP_error(Rd.s+2316,63);
        else (*F_br)=0;
      }
    }
  }
  Ra.sl[6]=3939; /* line # 3939 */
  if (!(*F_br)) {
    Ra.sl[6]=3941; /* line # 3941 */
    Rs.v[66]=MXD_CMP_newide();
    Ra.sl[6]=3942; /* line # 3942 */
    Rv1=Rs.v[66];
    Ra.sl[6]=3944; /* line # 3944 */
    ((SL *)Rv1)[0]=-1;
    memcpy(Rv1+8,Rs.s+506,17);
    ((V *)Rv1)[5]=NULL;
    Ra.sl[6]=3945; /* line # 3945 */
    if (F_bm) ((SL *)Rv1)[1]=-1;
    else {
      Ra.sl[6]=3947; /* line # 3947 */
      ((SL *)Rv1)[1]=Rs.sl[86];
      Rs.sl[86]=Rs.sl[86]+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " declarenewident "  */
void MXD_CMP_declarenewident(UB *F_br){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  register V Rv3;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2320;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=3967; /* line # 3967 */
  Rv0=Rs.sl[18];
  Ra.sl[6]=3968; /* line # 3968 */
  if (Rs.ub[505]==2) {
    Ra.sl[6]=3969; /* line # 3969 */
    Ra.sl[6]=3971; /* line # 3971 */
    Rv1=PAS__F_ROUND(Rs.f[127]);
    Ra.sl[6]=3972; /* line # 3972 */
    if (Rv1==0) Rv1=1;
    else Rv1=Rs.sl[18]-Rv1;
    Ra.sl[6]=3973; /* line # 3973 */
    if (Rv1<1) Rv1=1;
    else {
      Ra.sl[6]=3974; /* line # 3974 */
      if (Rv1>Rs.sl[18]) Rv1=Rs.sl[18];
    }
    Ra.sl[6]=3975; /* line # 3975 */
    MXD_CMP_insymbol();
    Ra.sl[6]=3976; /* line # 3976 */
    Rs.sl[18]=Rv1;
    Ra.sl[6]=3977; /* line # 3977 */
    MXD_CMP_searchid(Rs.s+506,Rs.v+66,0);
  }
  Ra.sl[6]=3979; /* line # 3979 */
  (*F_br)=1;
  Ra.sl[6]=3980; /* line # 3980 */
  Ra.sl[6]=3981; /* line # 3981 */
  if (Rs.ub[505]!=0) MXD_CMP_error(Rd.s+2339,61);
  else {
    Ra.sl[6]=3983; /* line # 3983 */
    Rv2=Rs.v[66]==NULL;
    Ra.sl[6]=3984; /* line # 3984 */
    if (!Rv2) {
      Ra.sl[6]=3985; /* line # 3985 */
      Rv3=Rs.v[66];
      Ra.sl[6]=3986; /* line # 3986 */
      if (((UB *)Rv3)[48]<5) MXD_CMP_error(Rd.s+2339,62);
      else {
        Ra.sl[6]=3987; /* line # 3987 */
        if (((SL *)Rv3)[0]==Rs.sl[18]) MXD_CMP_error(Rd.s+2339,63);
        else {
          Ra.sl[6]=3988; /* line # 3988 */
          Rv2=1;
          Rs.v[66]=NULL;
        }
      }
    }
    Ra.sl[6]=3989; /* line # 3989 */
    if (Rv2) {
      Ra.sl[6]=3991; /* line # 3991 */
      MXD_CMP_searchid(Rs.s+506,Rs.v+66,1);
      (*F_br)=0;
    }
  }
  Ra.sl[6]=3994; /* line # 3994 */
  Rs.sl[18]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " forfunmatch "  */
UB MXD_CMP_PRC_00000014(V F_pfa, V F_pfb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2343;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4016; /* line # 4016 */
  Rv0=((V *)F_pfa)[7];
  Ra.sl[6]=4017; /* line # 4017 */
  Rv1=((V *)F_pfb)[7];
  Ra.sl[6]=4018; /* line # 4018 */
  Rv2=1;
  Ra.sl[6]=4019; /* line # 4019 */
  while ((Rv2&&Rv0!=NULL)&&Rv1!=NULL){
    Ra.sl[6]=4021; /* line # 4021 */
    Rv2=((UB *)Rv0)[48]==((UB *)Rv1)[48];
    Ra.sl[6]=4022; /* line # 4022 */
    if (((UB *)Rv0)[48]==15) Rv0=((V *)Rv0)[8];
    else Rv0=((V *)Rv0)[8];
    Ra.sl[6]=4023; /* line # 4023 */
    if (((UB *)Rv1)[48]==15) Rv1=((V *)Rv1)[8];
    else Rv1=((V *)Rv1)[8];
  }
  Ra.sl[6]=4025; /* line # 4025 */
  if (Rv2) Rv2=Rv0==NULL&&Rv1==NULL;
  Ra.sl[6]=4026; /* line # 4026 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " usercall "  */
void MXD_CMP_usercall(V F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2356;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4030; /* line # 4030 */
  ((UB *)F_nd)[3]=4;
  ((UB *)F_nd)[2]=Rs.ub[504];
  Ra.sl[6]=4031; /* line # 4031 */
  Rv0=Rs.v[66];
  Ra.sl[6]=4032; /* line # 4032 */
  memcpy(Ra.s+32,Rs.s+904,16);
  Ra.sl[6]=4033; /* line # 4033 */
  Rv1=0;
  Ra.sl[6]=4034; /* line # 4034 */
  MXD_CMP_insymbol();
  Ra.sl[6]=4035; /* line # 4035 */
  MXD_CMP_looksymbol(151,82,1);
  Ra.sl[6]=4036; /* line # 4036 */
  Rv2=Rv0;
  Ra.sl[6]=4038; /* line # 4038 */
  Rv3=((V *)Rv2)[7];
  Ra.sl[6]=4040; /* line # 4040 */
  while (Rv3!=NULL){
    Ra.sl[6]=4042; /* line # 4042 */
    if (((UB *)Rv3)[48]==15) {
      Ra.sl[6]=4044; /* line # 4044 */
      MXD_CMP_getphysparam();
      Rv4=((V *)Rv3)[8];
    }
    else {
      Ra.sl[6]=4048; /* line # 4048 */
      if (Rs.ub[505]==0) {
        Ra.sl[6]=4049; /* line # 4049 */
        if (Rs.v[66]!=NULL) {
          Ra.sl[6]=4050; /* line # 4050 */
          if (((UB *)Rs.v[66])[48]==16) {
            Ra.sl[6]=4051; /* line # 4051 */
            if (MXD_CMP_PRC_00000014(Rv3, Rs.v[66])) {
              Ra.sl[6]=4053; /* line # 4053 */
              PAS__SELECT_OUT(Ri.v[13]);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(6,4,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rs.v[66])[1],6,0);
              PAS__WRITE_EOLN();
            }
            else {
              Ra.sl[6]=4055; /* line # 4055 */
              MXD_CMP_error(Rd.s+2368,-442);
            }
          }
          else {
            Ra.sl[6]=4056; /* line # 4056 */
            MXD_CMP_error(Rd.s+2368,-441);
          }
        }
        else {
          Ra.sl[6]=4057; /* line # 4057 */
          MXD_CMP_error(Rd.s+2368,-51);
        }
      }
      else {
        Ra.sl[6]=4058; /* line # 4058 */
        MXD_CMP_error(Rd.s+2368,-61);
      }
      Ra.sl[6]=4059; /* line # 4059 */
      MXD_CMP_insymbol();
      Ra.sl[6]=4060; /* line # 4060 */
      if (Rs.ub[504]==150) MXD_CMP_insymbol();
      Ra.sl[6]=4061; /* line # 4061 */
      Rv4=((V *)Rv3)[8];
    }
    Ra.sl[6]=4063; /* line # 4063 */
    Rv1=Rv1+1;
    Ra.sl[6]=4064; /* line # 4064 */
    Rv3=Rv4;
  }
  Ra.sl[6]=4066; /* line # 4066 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT((SL)((UB *)F_nd)[2],4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(Rv1,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[1],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=4069; /* line # 4069 */
  memcpy(Rs.s+904,Ra.s+32,16);
  Ra.sl[6]=4070; /* line # 4070 */
  ((UB *)F_nd)[2]=3;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " callfunc "  */
void MXD_CMP_callfunc(V F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  UB Rv3;
  V Rv4;
  UB Rv5;
  register V Rv6;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2372;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4089; /* line # 4089 */
  Rv0=0;
  Ra.sl[6]=4090; /* line # 4090 */
  memcpy(Ra.s+32,Rs.s+904,16);
  Ra.sl[6]=4091; /* line # 4091 */
  MXD_CMP_insymbol();
  Ra.sl[6]=4092; /* line # 4092 */
  MXD_CMP_looksymbol(151,82,1);
  Ra.sl[6]=4093; /* line # 4093 */
  Ra.sl[6]=4095; /* line # 4095 */
  switch (((UB *)F_nd)[2]) {
    case 140:Ra.sl[6]=4098; /* line # 4098 */
    MXD_CMP_getscte(Rs.v+114);
    Ra.sl[6]=4099; /* line # 4099 */
    memcpy(F_nd,Rs.s+904,16);
    Ra.sl[6]=4100; /* line # 4100 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
    Ra.sl[6]=4101; /* line # 4101 */
    Rv1=1;
    if (Rs.ub[505]!=4) MXD_CMP_geticte(&Rv1);
    Ra.sl[6]=4102; /* line # 4102 */
    Rv2=132;
    if (Rs.ub[505]!=4) MXD_CMP_geticte(&Rv2);
    Ra.sl[6]=4103; /* line # 4103 */
    Rv2=(Rv1+Rv2)-1;
    Ra.sl[6]=4104; /* line # 4104 */
    MXD_CMP_PRC_00000000(((V *)F_nd)[1],Rv1, Rv2);
    break;
    case 41:
    case 42:Ra.sl[6]=4108; /* line # 4108 */
    Rv1=0;
    while (1){
      Ra.sl[6]=4110; /* line # 4110 */
      MXD_CMP_getphysparam();
      Ra.sl[6]=4111; /* line # 4111 */
      Rv1=Rv1+1;
      if (Rv1>=31||Rs.ub[504]==152)  break;
    }
    Ra.sl[6]=4113; /* line # 4113 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT((SL)((UB *)F_nd)[2],4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv1,4,0);
    PAS__WRITE_EOLN();
    Ra.sl[6]=4114; /* line # 4114 */
    ((UB *)F_nd)[3]=4;
    Ra.sl[6]=4115; /* line # 4115 */
    ((UB *)F_nd)[2]=3;
    break;
    case 43:Ra.sl[6]=4119; /* line # 4119 */
    MXD_CMP_getphysparam();
    ((UB *)F_nd)[3]=4;
    Ra.sl[6]=4120; /* line # 4120 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT((SL)((UB *)F_nd)[2],4,0);
    PAS__WRITE_EOLN();
    ((UB *)F_nd)[2]=3;
    break;
    case 63:Ra.sl[6]=4124; /* line # 4124 */
    MXD_CMP_geticte(&Rv2);
    memcpy(F_nd,Rs.s+904,16);
    Ra.sl[6]=4125; /* line # 4125 */
    Rv1=PAS__I_MOD(Rv2,100);
    Rv2=Rv2/100;
    Ra.sl[6]=4126; /* line # 4126 */
    if (Rv2>=0&&Rv2<=6) {
      Ra.sl[6]=4128; /* line # 4128 */
      switch (Rv2) {
        case 0:Ra.sl[6]=4129; /* line # 4129 */
        Rv3=1;
        Rv0=12;
        break;
        case 1:Ra.sl[6]=4130; /* line # 4130 */
        Rv3=2;
        Rv0=7;
        break;
        case 2:Ra.sl[6]=4131; /* line # 4131 */
        Rv3=3;
        Rv0=8;
        break;
        case 3:Ra.sl[6]=4132; /* line # 4132 */
        Rv3=4;
        Rv0=3;
        break;
        case 4:Ra.sl[6]=4133; /* line # 4133 */
        Rv3=5;
        Rv0=4;
        break;
        case 5:Ra.sl[6]=4134; /* line # 4134 */
        Rv3=7;
        Rv0=2;
        break;
        case 6:Ra.sl[6]=4135; /* line # 4135 */
        Rv3=0;
        Rv0=3;
        break;
      }
      Ra.sl[6]=4137; /* line # 4137 */
      Rv4=MXD_CMP_newphysitm(Rv3, &Rv5,74);
      Ra.sl[6]=4138; /* line # 4138 */
      if (!Rv5) MXD_CMP_error(Rd.s+2384,101);
      Ra.sl[6]=4139; /* line # 4139 */
      if (Rv1<1||Rv1>Rv0) {
        Ra.sl[6]=4141; /* line # 4141 */
        Rv1=1;
        MXD_CMP_error(Rd.s+2384,31);
      }
      Ra.sl[6]=4143; /* line # 4143 */
      if (Rv2<6) {
        Ra.sl[6]=4145; /* line # 4145 */
        ((UB *)F_nd)[3]=4;
        Ra.sl[6]=4146; /* line # 4146 */
        if (Rv5) {
          Ra.sl[6]=4147; /* line # 4147 */
          Ra.sl[6]=4148; /* line # 4148 */
          PAS__SELECT_OUT(Ri.v[13]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT((SL)((UB *)F_nd)[2],4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(Rv2,2,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)Rv4)[7],6,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(Rv1,5,0);
          PAS__WRITE_EOLN();
        }
        Ra.sl[6]=4150; /* line # 4150 */
        ((UB *)F_nd)[2]=3;
      }
      else {
        Ra.sl[6]=4154; /* line # 4154 */
        ((UB *)F_nd)[3]=2;
        Ra.sl[6]=4155; /* line # 4155 */
        if (Rv2==5) {
          Ra.sl[6]=4156; /* line # 4156 */
          switch (Rv1) {
            case 1:Ra.sl[6]=4157; /* line # 4157 */
            ((F *)F_nd)[2]=((F *)Rv4)[8];
            break;
            case 2:Ra.sl[6]=4158; /* line # 4158 */
            ((F *)F_nd)[2]=((F *)Rv4)[9];
            break;
            case 3:Ra.sl[6]=4159; /* line # 4159 */
            ((F *)F_nd)[2]=((F *)Rv4)[10];
            break;
          }
        }
        Ra.sl[6]=4161; /* line # 4161 */
        ((F *)F_nd)[1]=(F)0.000000E-01;
        ((UB *)F_nd)[2]=16;
      }
    }
    else {
      Ra.sl[6]=4163; /* line # 4163 */
      MXD_CMP_error(Rd.s+2384,101);
    }
    break;
    case 40:Ra.sl[6]=4167; /* line # 4167 */
    MXD_CMP_newscope(&Rv5);
    Ra.sl[6]=4168; /* line # 4168 */
    if (Rv5) {
      Ra.sl[6]=4170; /* line # 4170 */
      MXD_CMP_declarenewident(&Rv5);
      Ra.sl[6]=4171; /* line # 4171 */
      Rv5=!Rv5;
    }
    Ra.sl[6]=4173; /* line # 4173 */
    if (Rv5) {
      Ra.sl[6]=4175; /* line # 4175 */
      Rv6=Rs.v[66];
      Ra.sl[6]=4177; /* line # 4177 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(91,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_CHT(Rv6+9,16,(SL)((C *)Rv6)[8],-1,32);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv6)[1],6,0);
      PAS__WRITE_EOLN();
      Ra.sl[6]=4179; /* line # 4179 */
      ((UB *)Rs.v[66])[48]=17;
      Ra.sl[6]=4181; /* line # 4181 */
      MXD_CMP_insymbol();
      Ra.sl[6]=4182; /* line # 4182 */
      MXD_CMP_looksymbol(150,85,1);
      Ra.sl[6]=4184; /* line # 4184 */
      MXD_CMP_getphysparam();
      MXD_CMP_getphysparam();
      MXD_CMP_getphysparam();
      Ra.sl[6]=4185; /* line # 4185 */
      MXD_CMP_getphysparam();
      Ra.sl[6]=4186; /* line # 4186 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(40,4,0);
      PAS__WRITE_EOLN();
      Ra.sl[6]=4187; /* line # 4187 */
      MXD_CMP_relscope();
    }
    else {
      Ra.sl[6]=4188; /* line # 4188 */
      MXD_CMP_error(Rd.s+2384,-444);
    }
    Ra.sl[6]=4189; /* line # 4189 */
    ((UB *)F_nd)[3]=4;
    ((UB *)F_nd)[2]=3;
    break;
  }
  Ra.sl[6]=4192; /* line # 4192 */
  MXD_CMP_looksymbol(152,81,0);
  Ra.sl[6]=4194; /* line # 4194 */
  memcpy(Rs.s+904,Ra.s+32,16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val "  */
F MXD_CMP_val(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  register V Rv2;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2388;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4209; /* line # 4209 */
  Rv0=F_p;
  Ra.sl[6]=4211; /* line # 4211 */
  Rv1=(F)0.000000E-01;
  Ra.sl[6]=4212; /* line # 4212 */
  if (((UB *)Rv0)[48]==0||((UB *)Rv0)[48]==10) Rv1=((F *)Rv0)[13];
  else {
    Ra.sl[6]=4214; /* line # 4214 */
    if (((UB *)Rv0)[48]==2) {
      Ra.sl[6]=4216; /* line # 4216 */
      Rv2=Ri.v[0]+8;
      Ra.sl[6]=4218; /* line # 4218 */
      ((UB *)Rv2)[56]=1;
      ((C *)Rv2)[52]=59;
      Ra.sl[6]=4220; /* line # 4220 */
      ((UB *)F_p)[48]=1;
      Ra.sl[6]=4221; /* line # 4221 */
      memcpy(Ra.s+32,Rs.s+504,32);
      Ra.sl[6]=4222; /* line # 4222 */
      MXD_CMP_activemacpar(F_p,((V *)F_p)[7],5);
      Ra.sl[6]=4223; /* line # 4223 */
      MXD_CMP_expression();
      Ra.sl[6]=4224; /* line # 4224 */
      Ra.sl[6]=4226; /* line # 4226 */
      if (Rs.ub[906]!=74) {
        Ra.sl[6]=4228; /* line # 4228 */
        if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
        Ra.sl[6]=4229; /* line # 4229 */
        if (Rs.ub[907]!=2) MXD_CMP_error(Rd.s+2395,58);
        else Rv1=Rs.f[228];
      }
      Ra.sl[6]=4232; /* line # 4232 */
      memcpy(Rs.s+504,Ra.s+32,32);
    }
    else {
      Ra.sl[6]=4234; /* line # 4234 */
      MXD_CMP_error(Rd.s+2395,-88);
    }
  }
  Ra.sl[6]=4236; /* line # 4236 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " getnumber "  */
void MXD_CMP_getnumber(SL *F_i){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2399;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4244; /* line # 4244 */
  Ra.sl[6]=4245; /* line # 4245 */
  if (Rs.ub[504]==149) {
    Ra.sl[6]=4247; /* line # 4247 */
    MXD_CMP_insymbol();
    Ra.sl[6]=4248; /* line # 4248 */
    MXD_CMP_expression();
    Ra.sl[6]=4249; /* line # 4249 */
    Ra.sl[6]=4251; /* line # 4251 */
    if (Rs.ub[906]!=74) {
      Ra.sl[6]=4253; /* line # 4253 */
      if (Rs.ub[907]==1) MXD_CMP_convint(Rs.s+904);
      Ra.sl[6]=4254; /* line # 4254 */
      if (Rs.ub[907]!=2) MXD_CMP_error(Rd.s+2412,58);
      else {
        Ra.sl[6]=4255; /* line # 4255 */
        (*F_i)=PAS__F_ROUND(Rs.f[228]);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pragmastate "  */
void MXD_CMP_pragmastate(UB F_bincl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  C Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2416;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4276; /* line # 4276 */
  Ra.sl[6]=4279; /* line # 4279 */
  if (Rs.ub[505]==4&&Rs.ub[506]==12) {
    Ra.sl[6]=4281; /* line # 4281 */
    Rv0=1;
    MXD_CMP_insymbol();
  }
  else {
    Ra.sl[6]=4283; /* line # 4283 */
    Rv0=0;
  }
  while (1){
    Ra.sl[6]=4285; /* line # 4285 */
    Rv1=0;
    Ra.sl[6]=4286; /* line # 4286 */
    Rv2=1;
    Ra.sl[6]=4287; /* line # 4287 */
    Rv3=32;
    Ra.sl[6]=4288; /* line # 4288 */
    if (Rv0) {
      Ra.sl[6]=4290; /* line # 4290 */
      Rv4=NULL;
      Ra.sl[6]=4291; /* line # 4291 */
      MXD_CMP_getscte(&Rv4);
      Ra.sl[6]=4292; /* line # 4292 */
      if (Rv4!=NULL) {
        Ra.sl[6]=4293; /* line # 4293 */
        Rv5=Rv4;
        Ra.sl[6]=4294; /* line # 4294 */
        if (((C *)Rv5)[140]>0) Rv3=((C *)Rv5)[8];
      }
      Ra.sl[6]=4295; /* line # 4295 */
      if (Rv3>=97&&Rv3<=122) Rv3=(C)((SL)Rv3-32);
      Ra.sl[6]=4296; /* line # 4296 */
      if (Rs.ub[504]==149) {
        Ra.sl[6]=4298; /* line # 4298 */
        Rv6=-1;
        Ra.sl[6]=4299; /* line # 4299 */
        MXD_CMP_getnumber(&Rv6);
        Ra.sl[6]=4300; /* line # 4300 */
        Rv1=Rv6>=0;
        Ra.sl[6]=4301; /* line # 4301 */
        Rv2=Rv6>0;
      }
    }
    else {
      Ra.sl[6]=4305; /* line # 4305 */
      if (Rs.ub[505]==0||Rs.ub[505]==1) {
        Ra.sl[6]=4307; /* line # 4307 */
        MXD_CMP_inputletter(&Rv3);
        Ra.sl[6]=4308; /* line # 4308 */
        MXD_CMP_insymbol();
        Ra.sl[6]=4309; /* line # 4309 */
        if (Rs.ub[504]==17||Rs.ub[504]==18) {
          Ra.sl[6]=4311; /* line # 4311 */
          Rv1=1;
          Ra.sl[6]=4312; /* line # 4312 */
          Rv2=Rs.ub[504]==17;
          Ra.sl[6]=4313; /* line # 4313 */
          MXD_CMP_insymbol();
        }
      }
    }
    Ra.sl[6]=4317; /* line # 4317 */
    Rv7=Ri.v[0]+8;
    Ra.sl[6]=4318; /* line # 4318 */
    switch (Rv3) {
      case 77:Ra.sl[6]=4319; /* line # 4319 */
      ((UB *)Rv7)[61]=Rv2;
      break;
      case 80:Ra.sl[6]=4321; /* line # 4321 */
      ((UB *)Rv7)[62]=Rv2;
      break;
      case 67:Ra.sl[6]=4323; /* line # 4323 */
      Ri.ub[112]=Rv2;
      break;
      case 69:Ra.sl[6]=4325; /* line # 4325 */
      ((UB *)Rv7)[63]=Rv2;
      break;
      case 68:Ra.sl[6]=4327; /* line # 4327 */
      ((UB *)Rv7)[64]=Rv2;
      break;
      case 78:Ra.sl[6]=4329; /* line # 4329 */
      Ri.ub[94]=Rv2;
      break;
      case 85:Ra.sl[6]=4331; /* line # 4331 */
      V_majorfmode=Rv2;
      break;
      case 70:Ra.sl[6]=4334; /* line # 4334 */
      ((SL *)Rv7)[9]=1;
      ((SL *)Rv7)[10]=120;
      Ra.sl[6]=4335; /* line # 4335 */
      MXD_CMP_getnumber(((SL *)Rv7)+9);
      Ra.sl[6]=4336; /* line # 4336 */
      MXD_CMP_getnumber(((SL *)Rv7)+10);
      Ra.sl[6]=4337; /* line # 4337 */
      if (((SL *)Rv7)[9]<1) ((SL *)Rv7)[9]=1;
      Ra.sl[6]=4338; /* line # 4338 */
      if (((SL *)Rv7)[10]>132) ((SL *)Rv7)[10]=120;
      Ra.sl[6]=4339; /* line # 4339 */
      if (((SL *)Rv7)[10]-((SL *)Rv7)[9]<20) {
        Ra.sl[6]=4340; /* line # 4340 */
        ((SL *)Rv7)[9]=1;
        ((SL *)Rv7)[10]=120;
      }
      break;
      case 76:Ra.sl[6]=4344; /* line # 4344 */
      Rv6=-1;
      Ra.sl[6]=4345; /* line # 4345 */
      MXD_CMP_getnumber(&Rv6);
      Ra.sl[6]=4346; /* line # 4346 */
      if (Rv6>=0) {
        Ra.sl[6]=4348; /* line # 4348 */
        ((SL *)Rv7)[2]=Rv6;
        Ra.sl[6]=4349; /* line # 4349 */
        if (Rv1) ((UB *)Rv7)[60]=Rv2;
      }
      else {
        Ra.sl[6]=4353; /* line # 4353 */
        if (Rv1) ((UB *)Rv7)[60]=Rv2;
        else {
          Ra.sl[6]=4354; /* line # 4354 */
          ((UB *)Rv7)[60]=1;
        }
        Ra.sl[6]=4355; /* line # 4355 */
        if (((UB *)Rv7)[60]) {
          Ra.sl[6]=4356; /* line # 4356 */
          if (F_bincl) ((SL *)Rv7)[2]=Rs.sl[6]+1;
          else {
            Ra.sl[6]=4357; /* line # 4357 */
            ((SL *)Rv7)[2]=Rs.sl[6];
          }
        }
      }
      break;
      case 83:Ra.sl[6]=4362; /* line # 4362 */
      if (Rv6>Rs.sl[86]||Rv6<0) Rs.sl[86]=Rv6;
      break;
      default:Ra.sl[6]=4365; /* line # 4365 */
      MXD_CMP_error(Rd.s+2431,99);
      break;
    }
    Ra.sl[6]=4367; /* line # 4367 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
    if (Rs.ub[505]!=0&&Rs.ub[505]!=1)  break;
  }
  Ra.sl[6]=4369; /* line # 4369 */
  if (Rv0) MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=4371; /* line # 4371 */
  MXD_CMP_looksemicol(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " putransope "  */
void MXD_CMP_putransope(V F_mt){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  F Rv5;
  SL Rv6;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2435;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4383; /* line # 4383 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_STR(Rd.s+2447,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=4384; /* line # 4384 */
  Rv0=1;
  for( Rf2=3;Rf2>0;Rf2-- ) {
    Rv1=1;
    for( Rf1=3;Rf1>0;Rf1-- ) {
      Ra.sl[6]=4386; /* line # 4386 */
      Ra.f[Rv0*3+Rv1+3]=(F)0.000000E-01;
      Ra.sl[6]=4387; /* line # 4387 */
      Rv2=1;
      for( Rf0=3;Rf0>0;Rf0-- ) {
        Ra.f[Rv0*3+Rv1+3]=Ra.f[Rv0*3+Rv1+3]+(float)((SL *)F_mt)[Rv0*4+Rv2-5]*Rs.
        f[Rv1*3+Rv2+226];
        Rv2++;
      }
      Rv1++;
    }
    Rv0++;
  }
  Ra.sl[6]=4389; /* line # 4389 */
  Rv3=1;
  for( Rf2=3;Rf2>0;Rf2-- ) {
    Rv4=1;
    for( Rf1=3;Rf1>0;Rf1-- ) {
      Ra.sl[6]=4391; /* line # 4391 */
      Rv5=(F)0.000000E-01;
      Ra.sl[6]=4392; /* line # 4392 */
      Rv6=1;
      for( Rf0=3;Rf0>0;Rf0-- ) {
        Rv5=Rv5+Rs.f[Rv3*3+Rv6+235]*Ra.f[Rv6*3+Rv4+3];
        Rv6++;
      }
      Ra.sl[6]=4393; /* line # 4393 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(Rv5,12,-6,0);
      Rv4++;
    }
    Rv3++;
  }
  Ra.sl[6]=4395; /* line # 4395 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " outnwline "  */
void MXD_CMP_PRC_00000016(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2451;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4420; /* line # 4420 */
  MXD_CMP_newlinelst();
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_FCHAR(32,12,-1,1,32);
  PAS__WRITE_CHT(Lx[9].s,16,10,-1,32);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " formaldef "  */
void MXD_CMP_PRC_00000019(V F_pfu){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2462;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4446; /* line # 4446 */
  Rv0=NULL;
  Ra.sl[6]=4447; /* line # 4447 */
  Rs.ub[504]=150;
  Ra.sl[6]=4448; /* line # 4448 */
  Lx[4].sl[0]=0;
  ((V *)F_pfu)[7]=NULL;
  Ra.sl[6]=4449; /* line # 4449 */
  Ra.sl[6]=4450; /* line # 4450 */
  while (Rs.ub[504]==150){
    Ra.sl[6]=4452; /* line # 4452 */
    MXD_CMP_insymbol();
    Ra.sl[6]=4453; /* line # 4453 */
    if (Rs.ub[504]==90) {
      Ra.sl[6]=4455; /* line # 4455 */
      MXD_CMP_insymbol();
      Ra.sl[6]=4456; /* line # 4456 */
      Rv1=1;
    }
    else {
      Ra.sl[6]=4457; /* line # 4457 */
      Rv1=0;
    }
    Ra.sl[6]=4458; /* line # 4458 */
    MXD_CMP_declarespecial(0, Lx[4].ub+4);
    Ra.sl[6]=4459; /* line # 4459 */
    Lx[4].ub[4]=!Lx[4].ub[4];
    Ra.sl[6]=4460; /* line # 4460 */
    if (Lx[4].ub[4]) {
      Ra.sl[6]=4462; /* line # 4462 */
      Rv2=Rs.v[66];
      Ra.sl[6]=4463; /* line # 4463 */
      Rv3=Rv2;
      Ra.sl[6]=4465; /* line # 4465 */
      if (Rv1) ((UB *)Rv3)[48]=16;
      else((UB *)Rv3)[48]=15;
      Ra.sl[6]=4467; /* line # 4467 */
      if (((V *)F_pfu)[7]==NULL) {
        Ra.sl[6]=4470; /* line # 4470 */
        if (Lx[4].v[1]==NULL) Rs.v[8]=Rv2;
        else((V *)Lx[4].v[1])[4]=Rv2;
        Ra.sl[6]=4471; /* line # 4471 */
        ((V *)F_pfu)[7]=Rv2;
      }
      else {
        Ra.sl[6]=4475; /* line # 4475 */
        ((V *)Rv0)[4]=Rv2;
        Ra.sl[6]=4476; /* line # 4476 */
        if (((UB *)Rv0)[48]==16) ((V *)Rv0)[8]=Rv2;
        else {
          Ra.sl[6]=4477; /* line # 4477 */
          ((V *)Rv0)[8]=Rv2;
        }
      }
      Ra.sl[6]=4479; /* line # 4479 */
      ((V *)Rv3)[4]=NULL;
      Rv0=Rv2;
      Ra.sl[6]=4480; /* line # 4480 */
      if (Rv1) ((V *)Rv3)[8]=NULL;
      else((V *)Rv3)[8]=NULL;
      Ra.sl[6]=4481; /* line # 4481 */
      if (Rv1) {
        Ra.sl[6]=4482; /* line # 4482 */
        MXD_CMP_PRC_00000018(&Rv2,1);
      }
      else {
        Ra.sl[6]=4485; /* line # 4485 */
        if (!Lx[4].ub[44]) {
          Ra.sl[6]=4486; /* line # 4486 */
          PAS__SELECT_OUT(Ri.v[13]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(89,4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(Rv3+9,16,(SL)((C *)Rv3)[8],-1,32);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)Rv3)[1],6,0);
          PAS__WRITE_EOLN();
        }
      }
    }
    Ra.sl[6]=4490; /* line # 4490 */
    Lx[4].sl[0]=Lx[4].sl[0]+1;
    Ra.sl[6]=4491; /* line # 4491 */
    MXD_CMP_insymbol();
  }
  Ra.sl[6]=4493; /* line # 4493 */
  MXD_CMP_looksymbol(152,81,!Lx[4].ub[44]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " functiondef "  */
void MXD_CMP_PRC_00000018(V *F_pfu, UB F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[44]=F_bl;
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+2473;
  Ra.v[4]=Rd.s+12;
  Ra.sl[10]=4498; /* line # 4498 */
  Ra.sl[0]=0;
  Ra.sl[10]=4499; /* line # 4499 */
  Ra.v[1]=Rs.v[8];
  Ra.sl[10]=4500; /* line # 4500 */
  if (Ra.v[1]!=NULL) {
    Ra.sl[10]=4501; /* line # 4501 */
    while (((V *)Ra.v[1])[4]!=NULL)
    Ra.v[1]=((V *)Ra.v[1])[4];
  }
  Ra.sl[10]=4502; /* line # 4502 */
  if (!Ra.ub[44]) {
    Ra.sl[10]=4504; /* line # 4504 */
    MXD_CMP_declarenewident(Ra.ub+4);
    Ra.sl[10]=4505; /* line # 4505 */
    Ra.ub[4]=!Ra.ub[4];
    Ra.sl[10]=4506; /* line # 4506 */
    if (Ra.ub[4]) (*F_pfu)=Rs.v[66];
  }
  else {
    Ra.sl[10]=4508; /* line # 4508 */
    Ra.ub[4]=1;
  }
  Ra.sl[10]=4509; /* line # 4509 */
  if (Ra.ub[4]) {
    Ra.sl[10]=4510; /* line # 4510 */
    Ra.sl[10]=4512; /* line # 4512 */
    Rv0=(*F_pfu);
    Ra.sl[10]=4514; /* line # 4514 */
    ((UB *)Rv0)[48]=16;
    Ra.sl[10]=4515; /* line # 4515 */
    MXD_CMP_insymbol();
    Ra.sl[10]=4516; /* line # 4516 */
    if (Rs.ub[504]==151) MXD_CMP_PRC_00000019((*F_pfu));
    else {
      Ra.sl[10]=4517; /* line # 4517 */
      ((V *)Rv0)[7]=NULL;
    }
    Ra.sl[10]=4518; /* line # 4518 */
    if (Ra.ub[44]) {
      Ra.sl[10]=4519; /* line # 4519 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(89,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_CHT(Rv0+9,16,(SL)((C *)Rv0)[8],-1,32);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv0)[1],6,0);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[10]=4523; /* line # 4523 */
      ((V *)Rv0)[8]=(*F_pfu);
      Ra.sl[10]=4524; /* line # 4524 */
      MXD_CMP_looksymbol(50,65,1);
      Ra.sl[10]=4525; /* line # 4525 */
      MXD_CMP_getphysparam();
      Ra.sl[10]=4526; /* line # 4526 */
      ((UB *)Rv0)[48]=16;
      Ra.sl[10]=4528; /* line # 4528 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(90,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_CHT(Rv0+9,16,(SL)((C *)Rv0)[8],-1,32);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv0)[1],6,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Ra.sl[0],3,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[10]=4532; /* line # 4532 */
    if (Ra.v[1]==NULL) Rs.v[8]=NULL;
    else((V *)Ra.v[1])[4]=NULL;
  }
  PAS__curr_cntx=Ra.v[2];
  Lx[4]=Lx_Sv;
}


/* Procedure/Function : " functionstate "  */
void MXD_CMP_PRC_00000017(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2486;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4539; /* line # 4539 */
  MXD_CMP_PRC_00000018(&Rv0,0);
  Ra.sl[6]=4540; /* line # 4540 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " repeatstate "  */
void MXD_CMP_PRC_00000020(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  F Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2501;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4556; /* line # 4556 */
  MXD_CMP_inmacro(&Rv0,1,0);
  Ra.sl[6]=4557; /* line # 4557 */
  if (Rs.ub[505]==7) MXD_CMP_error(Rd.s+2516,-72);
  else {
    while (1){
      Ra.sl[6]=4560; /* line # 4560 */
      MXD_CMP_activemacpar(NULL,Rv0,4);
      Ra.sl[6]=4561; /* line # 4561 */
      Rv1=Rs.sl[6];
      Ra.sl[6]=4562; /* line # 4562 */
      MXD_CMP_statelist(115);
      Ra.sl[6]=4563; /* line # 4563 */
      MXD_CMP_getncte(&Rv2);
      Ra.sl[6]=4565; /* line # 4565 */
      if (Rs.sl[6]>=Rv1) MXD_CMP_resetcntx(Rv1-1);
      if (fabs(Rv2)>=(F)5.000000E-01)  break;
    }
    Ra.sl[6]=4567; /* line # 4567 */
    MXD_CMP_insymbol();
  }
  Ra.sl[6]=4569; /* line # 4569 */
  MXD_CMP_freetext(&Rv0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macrostate "  */
void MXD_CMP_PRC_00000021(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2520;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4587; /* line # 4587 */
  MXD_CMP_declarespecial(1, &Rv0);
  Ra.sl[6]=4588; /* line # 4588 */
  if (Rv0) {
    Ra.sl[6]=4590; /* line # 4590 */
    MXD_CMP_error(Rd.s+2534,-98);
    Ra.sl[6]=4591; /* line # 4591 */
    MXD_CMP_inmacro(&Rv1,0,3);
    Ra.sl[6]=4592; /* line # 4592 */
    MXD_CMP_insymbol();
  }
  else {
    Ra.sl[6]=4594; /* line # 4594 */
    Ra.sl[6]=4596; /* line # 4596 */
    Rv2=Rs.v[66];
    Ra.sl[6]=4597; /* line # 4597 */
    Rv3=Rv2;
    Ra.sl[6]=4599; /* line # 4599 */
    ((UB *)Rv3)[48]=3;
    Ra.sl[6]=4600; /* line # 4600 */
    ((V *)Rv3)[4]=Rs.v[8];
    Rs.v[8]=NULL;
    Ra.sl[6]=4602; /* line # 4602 */
    Rv4=0;
    Rv5=NULL;
    Ra.sl[6]=4603; /* line # 4603 */
    MXD_CMP_insymbol();
    Ra.sl[6]=4604; /* line # 4604 */
    Ra.sl[6]=4605; /* line # 4605 */
    while (Rs.ub[505]==0){
      Ra.sl[6]=4607; /* line # 4607 */
      Rv0=0;
      Ra.sl[6]=4608; /* line # 4608 */
      if (Rs.v[66]!=NULL) Rv0=((SL *)Rs.v[66])[0]==-1;
      Ra.sl[6]=4609; /* line # 4609 */
      if (Rv0) MXD_CMP_error(Rd.s+2534,-97);
      Ra.sl[6]=4610; /* line # 4610 */
      Rv6=MXD_CMP_newide();
      Ra.sl[6]=4611; /* line # 4611 */
      if (Rv5==NULL) Rs.v[8]=Rv6;
      else {
        Ra.sl[6]=4614; /* line # 4614 */
        ((V *)Rv5)[4]=Rv6;
        Ra.sl[6]=4615; /* line # 4615 */
        ((V *)Rv5)[8]=Rv6;
      }
      Ra.sl[6]=4617; /* line # 4617 */
      Rv5=Rv6;
      Ra.sl[6]=4618; /* line # 4618 */
      Rv7=Rv6;
      Ra.sl[6]=4620; /* line # 4620 */
      memcpy(Rv7+8,Rs.s+506,17);
      Ra.sl[6]=4621; /* line # 4621 */
      ((SL *)Rv7)[0]=-1;
      ((V *)Rv7)[8]=NULL;
      Ra.sl[6]=4622; /* line # 4622 */
      ((V *)Rv7)[4]=NULL;
      ((V *)Rv7)[5]=NULL;
      Ra.sl[6]=4623; /* line # 4623 */
      ((SL *)Rv7)[1]=Rv4;
      Rv4=Rv4+1;
      Ra.sl[6]=4624; /* line # 4624 */
      ((UB *)Rv7)[48]=0;
      Ra.sl[6]=4625; /* line # 4625 */
      ((V *)Rv7)[7]=NULL;
      Ra.sl[6]=4627; /* line # 4627 */
      MXD_CMP_insymbol();
      Ra.sl[6]=4628; /* line # 4628 */
      if (Rs.ub[504]==150) MXD_CMP_insymbol();
    }
    Ra.sl[6]=4630; /* line # 4630 */
    MXD_CMP_looksemicol(0);
    Ra.sl[6]=4631; /* line # 4631 */
    Rv6=Rs.v[8];
    Ra.sl[6]=4634; /* line # 4634 */
    while (Rv6!=NULL){
      Ra.sl[6]=4636; /* line # 4636 */
      ((UB *)Rv6)[48]=2;
      Ra.sl[6]=4637; /* line # 4637 */
      Rv6=((V *)Rv6)[8];
    }
    Ra.sl[6]=4639; /* line # 4639 */
    ((V *)Rv2)[7]=Rs.v[8];
    Ra.sl[6]=4640; /* line # 4640 */
    Rs.v[8]=Rv2;
    Ra.sl[6]=4644; /* line # 4644 */
    MXD_CMP_inmacro(((V *)Rv2)+8,1,3);
    Ra.sl[6]=4645; /* line # 4645 */
    MXD_CMP_insymbol();
    Ra.sl[6]=4646; /* line # 4646 */
    MXD_CMP_looksemicol(1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " purgestate "  */
void MXD_CMP_PRC_00000022(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2538;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4661; /* line # 4661 */
  Ra.sl[6]=4662; /* line # 4662 */
  while (Rs.ub[505]==0){
    Ra.sl[6]=4665; /* line # 4665 */
    if (Rs.v[66]==NULL) MXD_CMP_error(Rd.s+2552,96);
    else {
      Ra.sl[6]=4666; /* line # 4666 */
      Rv0=Rs.v[66];
      Ra.sl[6]=4667; /* line # 4667 */
      if (((SL *)Rv0)[0]!=-1||((UB *)Rv0)[48]!=3) {
        Ra.sl[6]=4668; /* line # 4668 */
        MXD_CMP_error(Rd.s+2552,95);
      }
      else {
        Ra.sl[6]=4672; /* line # 4672 */
        Rv1=Rs.v[8];
        Rv2=NULL;
        Ra.sl[6]=4673; /* line # 4673 */
        while (Rv1!=Rs.v[66]&&Rv1!=NULL){
          Ra.sl[6]=4675; /* line # 4675 */
          Rv2=Rv1;
          Ra.sl[6]=4676; /* line # 4676 */
          Rv1=((V *)Rv1)[8];
        }
        Ra.sl[6]=4679; /* line # 4679 */
        if (Rv2==NULL) Rs.v[8]=((V *)Rv0)[4];
        else((V *)Rv2)[4]=((V *)Rv0)[4];
        Ra.sl[6]=4681; /* line # 4681 */
        ((V *)Rv0)[4]=NULL;
        ((V *)Rv0)[5]=NULL;
        Ra.sl[6]=4682; /* line # 4682 */
        MXD_CMP_freeide(Rs.v[66]);
      }
    }
    Ra.sl[6]=4684; /* line # 4684 */
    MXD_CMP_insymbol();
    Ra.sl[6]=4685; /* line # 4685 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
  }
  Ra.sl[6]=4687; /* line # 4687 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " callmacro "  */
void MXD_CMP_PRC_00000023(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  V Rv9;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2556;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4699; /* line # 4699 */
  Rv0=Rs.v[66];
  Ra.sl[6]=4700; /* line # 4700 */
  Rv1=((V *)Rv0)[7];
  Ra.sl[6]=4701; /* line # 4701 */
  Rv2=NULL;
  Ra.sl[6]=4702; /* line # 4702 */
  Rv3=Rs.sl[6];
  Ra.sl[6]=4703; /* line # 4703 */
  while (Rv1!=NULL){
    Ra.sl[6]=4704; /* line # 4704 */
    Ra.sl[6]=4705; /* line # 4705 */
    Rv4=Rv1;
    Ra.sl[6]=4707; /* line # 4707 */
    ((V *)Rv4)[7]=NULL;
    Ra.sl[6]=4708; /* line # 4708 */
    MXD_CMP_inparam(((V *)Rv4)+7,0);
    Ra.sl[6]=4709; /* line # 4709 */
    Rv2=Rv1;
    Ra.sl[6]=4710; /* line # 4710 */
    Rv1=((V *)Rv1)[8];
  }
  Ra.sl[6]=4713; /* line # 4713 */
  if (Rs.ub[504]!=155) MXD_CMP_skip(155,0);
  Ra.sl[6]=4714; /* line # 4714 */
  if (Rv2!=NULL) {
    Ra.sl[6]=4716; /* line # 4716 */
    ((V *)Rv2)[4]=Rs.v[8];
    Ra.sl[6]=4717; /* line # 4717 */
    Rs.v[8]=((V *)Rv0)[7];
  }
  Ra.sl[6]=4719; /* line # 4719 */
  Rv5=Ri.v[0];
  Rv6=Rv5+8;
  Rv7=Rv5+80;
  Ra.sl[6]=4721; /* line # 4721 */
  if (((UB *)Rv7)[16]==4||((UB *)Rv7)[16]==5) {
    Ra.sl[6]=4722; /* line # 4722 */
    Rv8=Rs.v[1];
    Ra.sl[6]=4724; /* line # 4724 */
    if (((UB *)Rv6)[60]) MXD_CMP_outsrclist();
    Ra.sl[6]=4725; /* line # 4725 */
    Rs.sl[7]=1;
    Ra.sl[6]=4726; /* line # 4726 */
    ((C *)Rv8)[140]=0;
  }
  Ra.sl[6]=4729; /* line # 4729 */
  MXD_CMP_activemacpar(Rv0,((V *)Rv0)[8],4);
  Ra.sl[6]=4730; /* line # 4730 */
  MXD_CMP_statelist(117);
  Ra.sl[6]=4731; /* line # 4731 */
  MXD_CMP_resetcntx(Rv3);
  Ra.sl[6]=4733; /* line # 4733 */
  if (Rv2!=NULL) {
    Ra.sl[6]=4735; /* line # 4735 */
    Rv1=Rs.v[8];
    Ra.sl[6]=4736; /* line # 4736 */
    Rv9=NULL;
    Ra.sl[6]=4737; /* line # 4737 */
    while (Rv1!=NULL&&Rv1!=((V *)Rv0)[7]){
      Ra.sl[6]=4739; /* line # 4739 */
      Rv9=Rv1;
      Ra.sl[6]=4740; /* line # 4740 */
      Rv1=((V *)Rv1)[4];
    }
    Ra.sl[6]=4744; /* line # 4744 */
    if (Rv9==NULL) Rs.v[8]=((V *)Rv2)[4];
    else {
      Ra.sl[6]=4745; /* line # 4745 */
      ((V *)Rv9)[4]=((V *)Rv2)[4];
    }
    Ra.sl[6]=4746; /* line # 4746 */
    ((V *)Rv2)[4]=NULL;
    Ra.sl[6]=4747; /* line # 4747 */
    while (Rv1!=NULL){
      Ra.sl[6]=4749; /* line # 4749 */
      MXD_CMP_freetext(((V *)Rv1)+7);
      Ra.sl[6]=4750; /* line # 4750 */
      Rv1=((V *)Rv1)[8];
    }
  }
  Ra.sl[6]=4753; /* line # 4753 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ifstate "  */
void MXD_CMP_PRC_00000024(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  UB Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2567;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4769; /* line # 4769 */
  MXD_CMP_getncte(&Rv0);
  Ra.sl[6]=4770; /* line # 4770 */
  Rv1=fabs(Rv0)>=(F)5.000000E-01;
  Ra.sl[6]=4771; /* line # 4771 */
  MXD_CMP_looksymbol(114,-71,1);
  Ra.sl[6]=4772; /* line # 4772 */
  if (!V_fatalerror) {
    Ra.sl[6]=4773; /* line # 4773 */
    if (Rv1) {
      Ra.sl[6]=4775; /* line # 4775 */
      MXD_CMP_statelist(119);
      Ra.sl[6]=4776; /* line # 4776 */
      if (Rs.ub[992]==119) {
        Ra.sl[6]=4778; /* line # 4778 */
        MXD_CMP_inmacro(&Rv2,0,1);
        Ra.sl[6]=4779; /* line # 4779 */
        MXD_CMP_insymbol();
      }
    }
    else {
      Ra.sl[6]=4784; /* line # 4784 */
      MXD_CMP_inmacro(&Rv2,0,2);
      Ra.sl[6]=4785; /* line # 4785 */
      if (Rs.ub[504]==119) {
        Ra.sl[6]=4787; /* line # 4787 */
        MXD_CMP_insymbol();
        Ra.sl[6]=4788; /* line # 4788 */
        MXD_CMP_statelist(116);
      }
      else {
        Ra.sl[6]=4790; /* line # 4790 */
        MXD_CMP_insymbol();
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " beginstate "  */
void MXD_CMP_PRC_00000025(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2576;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4802; /* line # 4802 */
  MXD_CMP_newscope(&Rv0);
  Ra.sl[6]=4803; /* line # 4803 */
  MXD_CMP_statelist(118);
  Ra.sl[6]=4804; /* line # 4804 */
  if (Rv0) MXD_CMP_relscope();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " includestate "  */
void MXD_CMP_PRC_00000026(UB F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  register V Rv3;
  UB Rv4;
  UB Rv5;
  UB Rv6;
  UB Rv7;
  UB Rv8;
  UB Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  UB Rv18;
  register V Rv19;
  register V Rv20;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2588;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4821; /* line # 4821 */
  Rv0=1;
  Ra.sl[6]=4822; /* line # 4822 */
  Rv1=!(F_nd==101);
  Ra.sl[6]=4823; /* line # 4823 */
  Rv2=NULL;
  Ra.sl[6]=4824; /* line # 4824 */
  if (F_nd!=108) MXD_CMP_getscte(&Rv2);
  else {
    Ra.sl[6]=4825; /* line # 4825 */
    MXD_CMP_copystr(&Rv2, Rs.v[69],0);
  }
  Ra.sl[6]=4826; /* line # 4826 */
  Rv0=Rv2!=NULL;
  Ra.sl[6]=4827; /* line # 4827 */
  Rv3=Ri.v[0]+8;
  Ra.sl[6]=4829; /* line # 4829 */
  Rv4=((UB *)Rv3)[60];
  Rv5=((UB *)Rv3)[61];
  Rv6=((UB *)Rv3)[62];
  Ra.sl[6]=4830; /* line # 4830 */
  Rv7=((UB *)Rv3)[63];
  Rv8=((UB *)Rv3)[64];
  Rv9=Ri.ub[94];
  Ra.sl[6]=4831; /* line # 4831 */
  Rv10=((SL *)Rv3)[9];
  Rv11=((SL *)Rv3)[10];
  Rv12=((SL *)Rv3)[2];
  Ra.sl[6]=4833; /* line # 4833 */
  if (F_nd!=108) {
    Ra.sl[6]=4834; /* line # 4834 */
    if (Rs.ub[504]==150) {
      MXD_CMP_insymbol();
      MXD_CMP_pragmastate(Rv1);
    }
    else {
      Ra.sl[6]=4835; /* line # 4835 */
      MXD_CMP_looksemicol(0);
    }
  }
  Ra.sl[6]=4837; /* line # 4837 */
  if (!Rv0) MXD_CMP_error(Rd.s+2604,-18);
  Ra.sl[6]=4839; /* line # 4839 */
  Rv13=Ri.v[0]+80;
  Ra.sl[6]=4840; /* line # 4840 */
  if (((UB *)Rv13)[16]==4||((UB *)Rv13)[16]==5) {
    Ra.sl[6]=4842; /* line # 4842 */
    if (F_nd!=108) {
      Ra.sl[6]=4844; /* line # 4844 */
      MXD_CMP_error(Rd.s+2604,-94);
      Ra.sl[6]=4845; /* line # 4845 */
      Rv0=0;
    }
  }
  Ra.sl[6]=4848; /* line # 4848 */
  if (Rv0&&Rv1) {
    Ra.sl[6]=4850; /* line # 4850 */
    MXD_CMP_savecntx();
    Ra.sl[6]=4851; /* line # 4851 */
    Rv14=Ri.v[0]+8;
    Ra.sl[6]=4853; /* line # 4853 */
    ((V *)Rv14)[3]=P_st_create();
    Ra.sl[6]=4854; /* line # 4854 */
    if (F_nd==108) ((UB *)Rv14)[60]=Ri.ub[112];
  }
  Ra.sl[6]=4858; /* line # 4858 */
  if (V_fatalerror) Rv0=0;
  Ra.sl[6]=4860; /* line # 4860 */
  if (Rv0) {
    Ra.sl[6]=4861; /* line # 4861 */
    Rv15=Ri.v[0];
    Rv16=Rv15+8;
    Rv17=Rv15+80;
    Ra.sl[6]=4863; /* line # 4863 */
    if (!Rv1) {
      Ra.sl[6]=4865; /* line # 4865 */
      P_st_free(((V *)Rv16)+2);
      ((SL *)Rv16)[8]=0;
      Ra.sl[6]=4866; /* line # 4866 */
      Rs.c[40]=32;
      Rs.c[488]=32;
      Rs.ub[42]=17;
    }
    Ra.sl[6]=4868; /* line # 4868 */
    ((V *)Rv16)[2]=Rv2;
    Ra.sl[6]=4869; /* line # 4869 */
    if (Rv1) {
      Ra.sl[6]=4871; /* line # 4871 */
      ((UB *)Rv17)[17]=0;
    }
    Ra.sl[6]=4874; /* line # 4874 */
    ((UB *)Rv17)[16]=0;
    Ra.sl[6]=4875; /* line # 4875 */
    if (F_nd==108) {
      Ra.sl[6]=4877; /* line # 4877 */
      MXD_CMP_resettxtfile(Ri.v+2,Rv2, &Rv0, &Rv18);
      Ra.sl[6]=4878; /* line # 4878 */
      if (Rv0) ((UB *)Rv17)[16]=6;
    }
    else {
      Ra.sl[6]=4882; /* line # 4882 */
      if (!Rv1) {
        Ra.sl[6]=4884; /* line # 4884 */
        if (((UB *)Rv17)[17]) PAS__CLOSE(((V *)Rv17),0);
        Ra.sl[6]=4885; /* line # 4885 */
        PAS__CLOSE(((V *)Rv17)+1,0);
      }
      Ra.sl[6]=4887; /* line # 4887 */
      MXD_CMP_resettxtfile(((V *)Rv17)+1,Rv2, &Rv0,((UB *)Rv17)+17);
      Ra.sl[6]=4888; /* line # 4888 */
      if (((UB *)Rv17)[17]) P_openw_txtfile(((V *)Rv17),Rv2,1);
      Ra.sl[6]=4889; /* line # 4889 */
      if (Rv0) ((UB *)Rv17)[16]=3;
    }
    Ra.sl[6]=4894; /* line # 4894 */
    ((UB *)Ri.v[0])[66]=!Rv0;
    Ra.sl[6]=4896; /* line # 4896 */
    if (((UB *)Rv16)[63]) {
      Ra.sl[6]=4897; /* line # 4897 */
      Rv19=Rv2;
      Ra.sl[6]=4898; /* line # 4898 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2608,-1,-1,32);
      PAS__WRITE_CHT(Rv19+8,132,(SL)((C *)Rv19)[140],-1,32);
      PAS__WRITE_STR(Rd.s+2628,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=4900; /* line # 4900 */
    if (Rv0) {
      Ra.sl[6]=4902; /* line # 4902 */
      ((F *)Rs.v[6])[13]=(F)0.000000E-01;
      Ra.sl[6]=4903; /* line # 4903 */
      MXD_CMP_lstfilespc();
      Ra.sl[6]=4904; /* line # 4904 */
      MXD_CMP_insymbol();
    }
    else {
      Ra.sl[6]=4907; /* line # 4907 */
      if (Ri.ub[94]) MXD_CMP_error(Rd.s+2604,210);
    }
  }
  Ra.sl[6]=4909; /* line # 4909 */
  if (Rv1) {
    Ra.sl[6]=4910; /* line # 4910 */
    Rv20=((V *)Ri.v[0])[0]+8;
    Ra.sl[6]=4912; /* line # 4912 */
    ((UB *)Rv20)[61]=Rv5;
    ((UB *)Rv20)[62]=Rv6;
    Ra.sl[6]=4913; /* line # 4913 */
    ((UB *)Rv20)[63]=Rv7;
    ((UB *)Rv20)[64]=Rv8;
    Ra.sl[6]=4914; /* line # 4914 */
    Ri.ub[94]=Rv9;
    ((SL *)Rv20)[9]=Rv10;
    Ra.sl[6]=4915; /* line # 4915 */
    ((UB *)Rv20)[60]=Rv4;
    Ra.sl[6]=4916; /* line # 4916 */
    ((SL *)Rv20)[10]=Rv11;
    Ra.sl[6]=4917; /* line # 4917 */
    ((F *)Rs.v[6])[13]=(F)1.000000E+00;
    Ra.sl[6]=4918; /* line # 4918 */
    if (F_nd==108) ((SL *)Rv20)[2]=((SL *)Rv20)[3];
    else {
      Ra.sl[6]=4919; /* line # 4919 */
      ((SL *)Rv20)[2]=Rv12;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macrlibstate "  */
void MXD_CMP_PRC_00000027(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2632;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4932; /* line # 4932 */
  Rv0=Rs.v[69];
  Ra.sl[6]=4933; /* line # 4933 */
  if (Rs.ub[505]==4) {
    Ra.sl[6]=4935; /* line # 4935 */
    Rs.v[69]=((V *)Rv0)[0];
    P_st_free(&Rv0);
  }
  else {
    Ra.sl[6]=4939; /* line # 4939 */
    MXD_CMP_getscte(Rs.v+69);
    ((V *)Rs.v[69])[0]=Rv0;
  }
  Ra.sl[6]=4941; /* line # 4941 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " eofstate "  */
void MXD_CMP_PRC_00000028(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2646;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4952; /* line # 4952 */
  Rv0=Ri.v[0];
  Rv1=Rv0+8;
  Rv2=Rv0+80;
  Ra.sl[6]=4953; /* line # 4953 */
  if ((((UB *)Rv2)[16]==3||((UB *)Rv2)[16]==6)||((UB *)Rv2)[16]==0) {
    Ra.sl[6]=4955; /* line # 4955 */
    Rv3=((UB *)Rv2)[16]==6;
    Ra.sl[6]=4956; /* line # 4956 */
    switch (((UB *)Rv2)[16]) {
      case 6:Ra.sl[6]=4957; /* line # 4957 */
      P_close_txtfile(Ri.v+2);
      break;
      case 3:Ra.sl[6]=4958; /* line # 4958 */
      if (!((UB *)Rv2)[17]) P_close_txtfile(((V *)Rv2)+1);
      break;
      default:break;
    }
    Ra.sl[6]=4961; /* line # 4961 */
    ((UB *)Rv2)[16]=0;
    Ra.sl[6]=4963; /* line # 4963 */
    if (((UB *)Rv1)[63]) {
      Ra.sl[6]=4964; /* line # 4964 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2656,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=4966; /* line # 4966 */
    if (Rs.sl[6]>0) {
      Ra.sl[6]=4968; /* line # 4968 */
      P_st_free(((V *)Rv1)+3);
      Ra.sl[6]=4969; /* line # 4969 */
      P_st_free(((V *)Rv1)+2);
      Ra.sl[6]=4970; /* line # 4970 */
      ((V *)Rv1)[2]=((V *)Ri.v[0])[3];
      Ra.sl[6]=4971; /* line # 4971 */
      MXD_CMP_resetcntx(Rs.sl[6]-1);
      Ra.sl[6]=4972; /* line # 4972 */
      if (!Rv3) MXD_CMP_lstfilespc();
      Ra.sl[6]=4973; /* line # 4973 */
      if (!Rv3) MXD_CMP_insymbol();
    }
    else {
      Ra.sl[6]=4975; /* line # 4975 */
      Ri.ub[8]=1;
    }
    Ra.sl[6]=4976; /* line # 4976 */
    ((F *)Rs.v[6])[13]=(F)0.000000E-01;
  }
  else {
    Ra.sl[6]=4979; /* line # 4979 */
    MXD_CMP_error(Rd.s+2674,-93);
    Ra.sl[6]=4980; /* line # 4980 */
    MXD_CMP_skip(155,1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mcallstate "  */
void MXD_CMP_PRC_00000029(){
  /* Define the automatic variable space. */
  Blk( Ra, 1120 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2678;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=4999; /* line # 4999 */
  Rv0=0;
  Ra.sl[6]=5000; /* line # 5000 */
  while (Rs.ub[505]==0){
    Ra.sl[6]=5002; /* line # 5002 */
    Rv1=0;
    Ra.sl[6]=5003; /* line # 5003 */
    Ra.sl[6]=5004; /* line # 5004 */
    if (Rs.v[66]!=NULL) {
      Ra.sl[6]=5005; /* line # 5005 */
      Rv1=((UB *)Rs.v[66])[48]==3;
    }
    Ra.sl[6]=5006; /* line # 5006 */
    if (Rv1) MXD_CMP_error(Rd.s+2692,63);
    else {
      Ra.sl[6]=5008; /* line # 5008 */
      if (Rv0>=64) MXD_CMP_error(Rd.s+2692,-111);
      else {
        Ra.sl[6]=5011; /* line # 5011 */
        Rv0=Rv0+1;
        Ra.sl[6]=5012; /* line # 5012 */
        memcpy((Ra.s+Rv0*17+11),Rs.s+506,17);
        Ra.sl[6]=5013; /* line # 5013 */
        MXD_CMP_insymbol();
      }
    }
    Ra.sl[6]=5015; /* line # 5015 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
  }
  Ra.sl[6]=5017; /* line # 5017 */
  MXD_CMP_looksemicol(0);
  Ra.sl[6]=5018; /* line # 5018 */
  Rv2=0;
  Rv3=Rs.v[69];
  Ra.sl[6]=5019; /* line # 5019 */
  while (Rv2<Rv0&&Rs.v[69]!=NULL){
    Ra.sl[6]=5022; /* line # 5022 */
    MXD_CMP_PRC_00000026(108);
    Ra.sl[6]=5023; /* line # 5023 */
    while (Rv2<Rv0&&Rs.ub[505]!=7){
      Ra.sl[6]=5026; /* line # 5026 */
      Ri.ub[93]=1;
      Ra.sl[6]=5027; /* line # 5027 */
      while (Rs.ub[504]!=112&&Rs.ub[505]!=7){
        Ra.sl[6]=5028; /* line # 5028 */
        MXD_CMP_insymbol();
      }
      Ra.sl[6]=5029; /* line # 5029 */
      if (Rs.ub[505]!=7) {
        Ra.sl[6]=5030; /* line # 5030 */
        Ra.sl[6]=5032; /* line # 5032 */
        MXD_CMP_insymbol();
        Ra.sl[6]=5033; /* line # 5033 */
        Rv4=0;
        Rv1=0;
        Ra.sl[6]=5034; /* line # 5034 */
        while (!Rv1&&Rv4<Rv0){
          Ra.sl[6]=5035; /* line # 5035 */
          Rv4=Rv4+1;
          Ra.sl[6]=5036; /* line # 5036 */
          if (MXD_CMP_match((Ra.s+Rv4*17+11),Rs.s+506)==0) Rv1=1;
        }
        Ra.sl[6]=5038; /* line # 5038 */
        if (!Rv1) {
          Ra.sl[6]=5040; /* line # 5040 */
          MXD_CMP_inmacro(&Rv5,0,3);
        }
        else {
          Ra.sl[6]=5042; /* line # 5042 */
          Ra.c[Rv4*17+12]=32;
          Ra.sl[6]=5043; /* line # 5043 */
          Rs.sl[5]=Rs.sl[5]+1;
          Ra.sl[6]=5044; /* line # 5044 */
          Rv2=Rv2+1;
          Ra.sl[6]=5045; /* line # 5045 */
          MXD_CMP_PRC_00000021();
        }
      }
    }
    Ra.sl[6]=5049; /* line # 5049 */
    MXD_CMP_PRC_00000028();
    Ra.sl[6]=5050; /* line # 5050 */
    Rs.v[69]=((V *)Rs.v[69])[0];
  }
  Ra.sl[6]=5052; /* line # 5052 */
  Rs.v[69]=Rv3;
  Ra.sl[6]=5053; /* line # 5053 */
  if (Rv2<Rv0) {
    Ra.sl[6]=5055; /* line # 5055 */
    MXD_CMP_error(Rd.s+2692,-112);
    Ra.sl[6]=5056; /* line # 5056 */
    Rv6=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[6]=5057; /* line # 5057 */
      Rv7=(Ra.s+Rv6*17+11);
      Ra.sl[6]=5058; /* line # 5058 */
      if (((C *)Rv7)[1]!=32) {
        Ra.sl[6]=5060; /* line # 5060 */
        MXD_CMP_newlinelst();
        Ra.sl[6]=5061; /* line # 5061 */
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_STR(Rd.s+2696,-1,-1,32);
        PAS__WRITE_CHT(Rv7+1,16,(SL)((C *)Rv7)[0],-1,32);
        PAS__WRITE_STR(Rd.s+2716,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Rv6++;
    }
  }
  Ra.sl[6]=5064; /* line # 5064 */
  MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inidata "  */
void MXD_CMP_PRC_00000030(){
  /* Define the automatic variable space. */
  Blk( Ra, 104 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2720;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5077; /* line # 5077 */
  if (Ri.ub[98]) {
    Ra.sl[6]=5079; /* line # 5079 */
    Rs.sl[137]=-1;
    Ra.sl[6]=5080; /* line # 5080 */
    Rv0=NULL;
    Ra.sl[6]=5081; /* line # 5081 */
    Rv1=P_open_ddifile(Ri.v+15,Rd.s+2729,0);
    Ra.sl[6]=5082; /* line # 5082 */
    if (Rv1) {
      Ra.sl[6]=5084; /* line # 5084 */
      while (!PAS__EOF(Ri.v[15])){
        Ra.sl[6]=5086; /* line # 5086 */
        Rv2=PAS__NEW(89);
        Ra.sl[6]=5087; /* line # 5087 */
        if (Rv0==NULL) Rs.v[79]=Rv2;
        else {
          Ra.sl[6]=5088; /* line # 5088 */
          ((V *)Rv0)[0]=Rv2;
        }
        Ra.sl[6]=5089; /* line # 5089 */
        Rv3=Rv2;
        Ra.sl[6]=5091; /* line # 5091 */
        PAS__SELECT_INP(Ri.v[15]);
        PAS__READ_BIN(Ra.s+28);
        Ra.sl[6]=5092; /* line # 5092 */
        ((SL *)Rv3)[7]=Rs.sl[145];
        Ra.sl[6]=5093; /* line # 5093 */
        Rs.sl[145]=Rs.sl[145]+1;
        Ra.sl[6]=5094; /* line # 5094 */
        ((V *)Rv3)[0]=NULL;
        ((UB *)Rv3)[88]=0;
        Ra.sl[6]=5095; /* line # 5095 */
        memcpy(Rv3+8,Ra.s+28,17);
        Ra.sl[6]=5096; /* line # 5096 */
        memcpy(Rv3+32,Ra.s+48,56);
        Ra.sl[6]=5098; /* line # 5098 */
        if (Rs.sl[137]<((SL *)Rv3)[8]) Rs.sl[137]=((SL *)Rv3)[8];
        Ra.sl[6]=5100; /* line # 5100 */
        Rv0=Rv2;
      }
      Ra.sl[6]=5102; /* line # 5102 */
      P_close_ddifile(Ri.v+15);
    }
    Ra.sl[6]=5104; /* line # 5104 */
    Rs.sl[137]=Rs.sl[137]+1;
  }
  Ra.sl[6]=5106; /* line # 5106 */
  Ri.ub[98]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setdatafile "  */
void MXD_CMP_PRC_00000032(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2743;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5131; /* line # 5131 */
  Lx[6].v[0]=MXD_CMP_instring(((SL *)Lx[6].v[1])[8],3);
  Ra.sl[6]=5132; /* line # 5132 */
  Rv0=Lx[6].v[0];
  Ra.sl[6]=5134; /* line # 5134 */
  ((C *)Rv0)[11]=((C *)Rv0)[8];
  ((C *)Rv0)[12]=((C *)Rv0)[9];
  ((C *)Rv0)[13]=((C *)Rv0)[10];
  Ra.sl[6]=5135; /* line # 5135 */
  ((C *)Rv0)[8]=109;
  ((C *)Rv0)[9]=120;
  ((C *)Rv0)[10]=100;
  Ra.sl[6]=5136; /* line # 5136 */
  ((C *)Rv0)[14]=46;
  ((C *)Rv0)[15]=98;
  ((C *)Rv0)[16]=100;
  Ra.sl[6]=5137; /* line # 5137 */
  ((C *)Rv0)[17]=97;
  ((C *)Rv0)[18]=46;
  ((C *)Rv0)[19]=49;
  Ra.sl[6]=5138; /* line # 5138 */
  Rv1=13;
  for( Rf0=120;Rf0>0;Rf0-- ) {
    ((C *)Rv0)[Rv1+7]=32;
    Rv1++;
  }
  Ra.sl[6]=5139; /* line # 5139 */
  ((C *)Rv0)[140]=12;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " scriptdata "  */
void MXD_CMP_PRC_00000033(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2756;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5151; /* line # 5151 */
  Rv0=Lx[6].v[1];
  Ra.sl[6]=5153; /* line # 5153 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(77,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv0+9,16,(SL)((C *)Rv0)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[7],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=5155; /* line # 5155 */
  Rv1=Rv0+32;
  Ra.sl[6]=5157; /* line # 5157 */
  Rv2=(SL)((C *)Lx[6].v[0])[140];
  Ra.sl[6]=5158; /* line # 5158 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(Rv2,3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=5159; /* line # 5159 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHT(Lx[6].v[0]+8,132, Rv2,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=5160; /* line # 5160 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[1],3,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[2],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[3],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=5161; /* line # 5161 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[5],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[4],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[7],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[6],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[9],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv1)[8],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=5164; /* line # 5164 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv1)[10],16,-6,0);
  PAS__WRITE_SNGL(((F *)Rv1)[11],16,-6,0);
  PAS__WRITE_SNGL(((F *)Rv1)[12],16,-6,0);
  PAS__WRITE_SNGL(((F *)Rv1)[13],16,-6,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " defsymbol "  */
void MXD_CMP_PRC_00000035(V F_snam, SL F__L, SL F__U, F F_invl, V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2768;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5192; /* line # 5192 */
  Rv0=(F__U-F__L)+1;
  Ra.sl[6]=5193; /* line # 5193 */
  Ra.c[28]=(C)Rv0;
  Ra.sl[6]=5194; /* line # 5194 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.c[Rv1+28]=((C *)F_snam)[(Rv1-F__L)];
    Rv1++;
  }
  Ra.sl[6]=5195; /* line # 5195 */
  Rv2=Rv0+1;
  for( Rf0=17-(Rv0+1);Rf0>0;Rf0-- ) {
    Ra.c[Rv2+28]=32;
    Rv2++;
  }
  Ra.sl[6]=5196; /* line # 5196 */
  MXD_CMP_searchid(Ra.s+28,F_p,1);
  Ra.sl[6]=5197; /* line # 5197 */
  Rv3=(*F_p);
  Ra.sl[6]=5199; /* line # 5199 */
  ((F *)Rv3)[13]=F_invl;
  Ra.sl[6]=5200; /* line # 5200 */
  ((UB *)Rv3)[49]=2;
  Ra.sl[6]=5201; /* line # 5201 */
  ((UB *)Rv3)[48]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dataprologue "  */
void MXD_CMP_PRC_00000036(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2779;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5213; /* line # 5213 */
  MXD_CMP_newscope(Lx[5].ub);
  Ra.sl[6]=5214; /* line # 5214 */
  Lx[5].sl[1]=Rs.sl[86];
  Ra.sl[6]=5215; /* line # 5215 */
  MXD_CMP_PRC_00000035(Rd.s+2795,1,2, (F)0.000000E-01, Lx[5].v+1);
  MXD_CMP_PRC_00000035(Rd.s+2799,1,2, (F)0.000000E-01, Lx[5].v+1);
  Ra.sl[6]=5216; /* line # 5216 */
  MXD_CMP_PRC_00000035(Rd.s+2803,1,3, (F)0.000000E-01, Lx[5].v+1);
  MXD_CMP_PRC_00000035(Rd.s+2808,1,2, (F)0.000000E-01, Lx[5].v+2);
  Ra.sl[6]=5217; /* line # 5217 */
  MXD_CMP_PRC_00000035(Rd.s+2812,1,2, (F)1.000000E+00, Lx[5].v+3);
  MXD_CMP_PRC_00000035(Rd.s+2816,1,2, (F)0.000000E-01, Lx[5].v+4);
  Ra.sl[6]=5218; /* line # 5218 */
  MXD_CMP_PRC_00000035(Rd.s+2820,1,2, (F)0.000000E-01, Lx[5].v+5);
  MXD_CMP_PRC_00000035(Rd.s+2824,1,2, (F)0.000000E-01, Lx[5].v+6);
  Ra.sl[6]=5219; /* line # 5219 */
  MXD_CMP_PRC_00000035(Rd.s+2828,1,2, (F)1.000000E+00, Lx[5].v+7);
  MXD_CMP_PRC_00000035(Rd.s+2832,1,3, (F)1.000000E+00, Lx[5].v+8);
  Ra.sl[6]=5220; /* line # 5220 */
  MXD_CMP_PRC_00000035(Rd.s+2837,1,2, (F)0.000000E-01, Lx[5].v+9);
  MXD_CMP_PRC_00000035(Rd.s+2841,1,5, (F)0.000000E-01, Lx[5].v+10);
  Ra.sl[6]=5221; /* line # 5221 */
  MXD_CMP_PRC_00000035(Rd.s+2848,1,5, (F)0.000000E-01, Lx[5].v+11);
  Ra.sl[6]=5222; /* line # 5222 */
  MXD_CMP_PRC_00000035(Rd.s+2855,1,4, (F)1.000000E+00, Lx[5].v+12);
  Ra.sl[6]=5223; /* line # 5223 */
  Rv0=Lx[5].v[12];
  Ra.sl[6]=5225; /* line # 5225 */
  ((UB *)Rv0)[48]=10;
  ((UB *)Rv0)[49]=2;
  Ra.sl[6]=5227; /* line # 5227 */
  ((SL *)Lx[6].v[1])[9]=-1;
  Ra.sl[6]=5228; /* line # 5228 */
  Ra.sl[6]=5230; /* line # 5230 */
  if (Rs.ub[504]==152) MXD_CMP_error(Rd.s+2861,151);
  else {
    Ra.sl[6]=5231; /* line # 5231 */
    if (Rs.ub[504]!=150) MXD_CMP_error(Rd.s+2861,85);
    else {
      Ra.sl[6]=5232; /* line # 5232 */
      MXD_CMP_insymbol();
    }
  }
  Ra.sl[6]=5233; /* line # 5233 */
  if (Rs.ub[504]==151) {
    Ra.sl[6]=5235; /* line # 5235 */
    MXD_CMP_insymbol();
    MXD_CMP_getphysparam();
    Ra.sl[6]=5236; /* line # 5236 */
    if (Rs.ub[906]==74) MXD_CMP_error(Rd.s+2861,152);
    Ra.sl[6]=5237; /* line # 5237 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=5238; /* line # 5238 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=5239; /* line # 5239 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=5240; /* line # 5240 */
    if (Rs.ub[504]==152) MXD_CMP_insymbol();
    else {
      Ra.sl[6]=5241; /* line # 5241 */
      MXD_CMP_error(Rd.s+2861,81);
    }
    Ra.sl[6]=5242; /* line # 5242 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
  }
  else {
    Ra.sl[6]=5245; /* line # 5245 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=5246; /* line # 5246 */
    for( Rf0=3;Rf0>0;Rf0-- ) {
      Ra.sl[6]=5247; /* line # 5247 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(74,4,0);
      PAS__WRITE_EOLN();
    }
  }
  Ra.sl[6]=5250; /* line # 5250 */
  Rv1=NULL;
  Ra.sl[6]=5251; /* line # 5251 */
  Ra.sl[6]=5252; /* line # 5252 */
  if (Rs.ub[505]!=4) while (1){
    Ra.sl[6]=5254; /* line # 5254 */
    Lx[5].v[1]=Rs.v[66];
    Ra.sl[6]=5255; /* line # 5255 */
    if (Rs.ub[505]!=0) {
      Ra.sl[6]=5256; /* line # 5256 */
      MXD_CMP_error(Rd.s+2861,61);
      MXD_CMP_insymbol();
    }
    else {
      Ra.sl[6]=5258; /* line # 5258 */
      if (Lx[5].v[1]==NULL) {
        Ra.sl[6]=5259; /* line # 5259 */
        MXD_CMP_error(Rd.s+2861,153);
        MXD_CMP_insymbol();
      }
      else {
        Ra.sl[6]=5262; /* line # 5262 */
        Rv2=Rs.v[66];
        Ra.sl[6]=5263; /* line # 5263 */
        if (((UB *)Rv2)[48]==13&&((SL *)Rv2)[0]!=Rs.sl[18]) {
          Ra.sl[6]=5265; /* line # 5265 */
          MXD_CMP_PRC_00000035(Rv2+9,1,16, (F)0.000000E-01, Lx[5].v+1);
          Ra.sl[6]=5266; /* line # 5266 */
          ((V *)Rv2)[8]=Lx[5].v[1];
        }
        Ra.sl[6]=5268; /* line # 5268 */
        if (((UB *)Lx[5].v[1])[48]!=0) {
          Ra.sl[6]=5269; /* line # 5269 */
          MXD_CMP_error(Rd.s+2861,153);
          MXD_CMP_insymbol();
        }
        else {
          Ra.sl[6]=5271; /* line # 5271 */
          Rv3=Lx[5].v[1];
          Ra.sl[6]=5273; /* line # 5273 */
          ((UB *)Rv3)[48]=1;
          Ra.sl[6]=5274; /* line # 5274 */
          Lx[5].sl[26]=((SL *)Rv3)[1]-Lx[5].sl[1];
          Ra.sl[6]=5275; /* line # 5275 */
          if (Lx[5].sl[26]<3) {
            Ra.sl[6]=5276; /* line # 5276 */
            Rv4=Lx[6].v[1]+32;
            Ra.sl[6]=5278; /* line # 5278 */
            Lx[5].v[14]=Lx[5].v[1];
            Ra.sl[6]=5279; /* line # 5279 */
            if (((SL *)Rv4)[1]==-1) ((SL *)Rv4)[1]=Lx[5].sl[26];
            else MXD_CMP_error(Rd.s+2861,154);
          }
          Ra.sl[6]=5281; /* line # 5281 */
          ((V *)Rv3)[8]=Rv1;
          Rv1=Lx[5].v[1];
          Ra.sl[6]=5282; /* line # 5282 */
          MXD_CMP_insymbol();
          Ra.sl[6]=5283; /* line # 5283 */
          if (Rs.ub[504]!=50) MXD_CMP_error(Rd.s+2861,90);
          else {
            Ra.sl[6]=5284; /* line # 5284 */
            MXD_CMP_inparam(((V *)Rv3)+7,1);
          }
        }
      }
    }
    Ra.sl[6]=5287; /* line # 5287 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
    if (Rs.ub[505]==4)  break;
  }
  Ra.sl[6]=5289; /* line # 5289 */
  if (Rs.ub[504]!=152) MXD_CMP_error(Rd.s+2861,-81);
  Ra.sl[6]=5290; /* line # 5290 */
  while (Rv1!=NULL){
    Ra.sl[6]=5291; /* line # 5291 */
    Rv5=Rv1;
    Ra.sl[6]=5293; /* line # 5293 */
    ((UB *)Rv5)[48]=2;
    Rv1=((V *)Rv5)[8];
  }
  Ra.sl[6]=5295; /* line # 5295 */
  MXD_CMP_insymbol();
  Ra.sl[6]=5297; /* line # 5297 */
  Lx[5].sl[30]=0;
  Ra.sl[6]=5298; /* line # 5298 */
  Ra.sl[6]=5299; /* line # 5299 */
  if (Rs.ub[505]!=0) MXD_CMP_error(Rd.s+2861,-61);
  else while (1){
    Ra.sl[6]=5301; /* line # 5301 */
    Lx[5].v[1]=Rs.v[66];
    Ra.sl[6]=5302; /* line # 5302 */
    if (Rs.v[66]!=NULL) {
      Ra.sl[6]=5303; /* line # 5303 */
      if (((SL *)Rs.v[66])[0]!=Rs.sl[18]) Rs.v[66]=NULL;
    }
    Ra.sl[6]=5304; /* line # 5304 */
    if (Rs.v[66]==NULL) {
      Ra.sl[6]=5306; /* line # 5306 */
      MXD_CMP_searchid(Rs.s+506,Rs.v+66,1);
      Ra.sl[6]=5307; /* line # 5307 */
      Lx[5].v[Lx[5].sl[30]+16]=Rs.v[66];
      Ra.sl[6]=5308; /* line # 5308 */
      if (Lx[5].v[1]!=NULL) {
        if (((UB *)Lx[5].v[1])[48]==13) ((V *)Lx[5].v[1])[8]=Rs.v[66];
      }
      Ra.sl[6]=5309; /* line # 5309 */
      Rv6=Rs.v[66];
      Ra.sl[6]=5311; /* line # 5311 */
      ((UB *)Rv6)[48]=10;
      ((UB *)Rv6)[49]=2;
      ((F *)Rv6)[13]=(F)0.000000E-01;
      Ra.sl[6]=5313; /* line # 5313 */
      Lx[5].f[Lx[5].sl[30]+96]=(F)0.000000E-01;
    }
    else {
      Ra.sl[6]=5315; /* line # 5315 */
      if (((UB *)Rs.v[66])[48]!=0) MXD_CMP_error(Rd.s+2861,-155);
      else {
        Ra.sl[6]=5318; /* line # 5318 */
        if ((Rs.v[66]==Lx[5].v[8]||Rs.v[66]==Lx[5].v[3])||Rs.v[66]==Lx[5].v[7]) {
          Ra.sl[6]=5319; /* line # 5319 */
          Lx[5].f[Lx[5].sl[30]+96]=(F)1.000000E+00;
        }
        else {
          Ra.sl[6]=5320; /* line # 5320 */
          Lx[5].f[Lx[5].sl[30]+96]=(F)0.000000E-01;
        }
        Ra.sl[6]=5321; /* line # 5321 */
        ((UB *)Rs.v[66])[48]=10;
        Ra.sl[6]=5322; /* line # 5322 */
        Lx[5].sl[26]=((SL *)Rs.v[66])[1]-Lx[5].sl[1];
        Lx[5].v[Lx[5].sl[30]+16]=Rs.v[66];
        Ra.sl[6]=5323; /* line # 5323 */
        Ra.sl[6]=5324; /* line # 5324 */
        if (Lx[5].sl[26]<3) {
          Ra.sl[6]=5325; /* line # 5325 */
          Rv7=Lx[6].v[1]+32;
          Ra.sl[6]=5327; /* line # 5327 */
          Lx[5].v[14]=Rs.v[66];
          Ra.sl[6]=5328; /* line # 5328 */
          if (((SL *)Rv7)[1]==-1) ((SL *)Rv7)[1]=Lx[5].sl[26];
          else MXD_CMP_error(Rd.s+2861,154);
        }
      }
    }
    Ra.sl[6]=5331; /* line # 5331 */
    Lx[5].v[1]=Rs.v[66];
    Ra.sl[6]=5332; /* line # 5332 */
    MXD_CMP_insymbol();
    Ra.sl[6]=5333; /* line # 5333 */
    if (Rs.ub[504]==50||Rs.ub[504]==134) {
      Ra.sl[6]=5335; /* line # 5335 */
      MXD_CMP_insymbol();
      MXD_CMP_getncte((Lx[5].f+Lx[5].sl[30]+96));
    }
    else {
      Ra.sl[6]=5338; /* line # 5338 */
      if (Rs.ub[505]!=4) MXD_CMP_error(Rd.s+2861,91);
      else {
        Ra.sl[6]=5340; /* line # 5340 */
        if (Rs.ub[504]==150) MXD_CMP_insymbol();
      }
    }
    Ra.sl[6]=5341; /* line # 5341 */
    Lx[5].sl[30]=Lx[5].sl[30]+1;
    if (Lx[5].sl[30]>31||Rs.ub[505]!=0)  break;
  }
  Ra.sl[6]=5343; /* line # 5343 */
  if (Lx[5].sl[30]>31) MXD_CMP_error(Rd.s+2861,-19);
  Ra.sl[6]=5344; /* line # 5344 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " datamng "  */
void MXD_CMP_PRC_00000037(){
  /* Define the automatic variable space. */
  Blk( Ra, 160 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2865;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5360; /* line # 5360 */
  Rv0=Lx[6].v[1]+32;
  Ra.sl[6]=5362; /* line # 5362 */
  ((F *)Rv0)[11]=(F)0.000000E-01;
  ((F *)Rv0)[13]=(F)0.000000E-01;
  ((F *)Rv0)[10]=(F)0.000000E-01;
  ((F *)Rv0)[12]=(F)0.000000E-01;
  Ra.sl[6]=5363; /* line # 5363 */
  ((SL *)Rv0)[4]=-1000;
  ((SL *)Rv0)[6]=((SL *)Rv0)[4];
  ((SL *)Rv0)[8]=((SL *)Rv0)[4];
  Ra.sl[6]=5364; /* line # 5364 */
  ((SL *)Rv0)[5]=1000;
  ((SL *)Rv0)[7]=((SL *)Rv0)[5];
  ((SL *)Rv0)[9]=((SL *)Rv0)[5];
  Ra.sl[6]=5365; /* line # 5365 */
  ((SL *)Rv0)[2]=0;
  ((SL *)Rv0)[3]=0;
  Ra.sl[6]=5367; /* line # 5367 */
  Lx[5].sl[30]=Lx[5].sl[30]-1;
  Lx[5].sl[128]=0;
  Ra.sl[6]=5368; /* line # 5368 */
  Lx[5].sl[129]=-1;
  Ra.sl[6]=5369; /* line # 5369 */
  Lx[5].sl[130]=-1;
  Ra.sl[6]=5370; /* line # 5370 */
  if (((UB *)Ri.v[0])[72]) {
    Ra.sl[6]=5372; /* line # 5372 */
    MXD_CMP_PRC_00000016();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    Ra.sl[6]=5373; /* line # 5373 */
    MXD_CMP_PRC_00000016();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+2874,-1,-1,32);
    Ra.sl[6]=5374; /* line # 5374 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+2898,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=5376; /* line # 5376 */
    MXD_CMP_PRC_00000016();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=5379; /* line # 5379 */
  while ((Rs.ub[505]!=7&&!Ri.ub[8])&&(Lx[5].sl[128]>0||Rs.ub[504]!=118)){
    Ra.sl[6]=5381; /* line # 5381 */
    Ra.sl[6]=5383; /* line # 5383 */
    if (Rs.ub[505]==0) {
      Ra.sl[6]=5385; /* line # 5385 */
      if (Rs.ub[504]==100) {
        Ra.sl[6]=5387; /* line # 5387 */
        MXD_CMP_insymbol();
        Ra.sl[6]=5388; /* line # 5388 */
        MXD_CMP_PRC_00000026(100);
        Ra.sl[6]=5389; /* line # 5389 */
        Lx[5].sl[128]=Lx[5].sl[128]+1;
      }
      else {
        Ra.sl[6]=5391; /* line # 5391 */
        if (Rs.ub[504]==69) {
          Ra.sl[6]=5393; /* line # 5393 */
          MXD_CMP_insymbol();
          Ra.sl[6]=5394; /* line # 5394 */
          Lx[5].v[66]=MXD_CMP_newphysitm(0, Lx[5].ub,151);
          Ra.sl[6]=5395; /* line # 5395 */
          if (!Lx[5].ub[0]) MXD_CMP_error(Rd.s+2861,-101);
          Ra.sl[6]=5396; /* line # 5396 */
          MXD_CMP_looksymbol(152,81,1);
          Ra.sl[6]=5397; /* line # 5397 */
          MXD_CMP_looksemicol(1);
          Ra.sl[6]=5398; /* line # 5398 */
          Rv1=Lx[5].v[66]+32;
          Ra.sl[6]=5399; /* line # 5399 */
          Lx[5].f[134]=((F *)Rv1)[0];
          Lx[5].f[135]=((F *)Rv1)[1];
          Lx[5].f[136]=((F *)Rv1)[2];
          Ra.sl[6]=5400; /* line # 5400 */
          if (((UB *)Ri.v[0])[72]) {
            Ra.sl[6]=5402; /* line # 5402 */
            MXD_CMP_PRC_00000016();
            Ra.sl[6]=5403; /* line # 5403 */
            Rv2=Lx[5].v[66];
            Ra.sl[6]=5404; /* line # 5404 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_FCHAR(32,10,-1,1,32);
            PAS__WRITE_CHAR(34);
            PAS__WRITE_CHT(Rv2+9,16,(SL)((C *)Rv2)[8],-1,32);
            PAS__WRITE_STR(Rd.s+2961,-1,-1,32);
            PAS__WRITE_EOLN();
          }
          Ra.sl[6]=5407; /* line # 5407 */
          Lx[5].sl[129]=((SL *)Lx[5].v[66])[7];
        }
        else {
          Ra.sl[6]=5409; /* line # 5409 */
          if (Rs.ub[504]==70) {
            Ra.sl[6]=5411; /* line # 5411 */
            MXD_CMP_insymbol();
            Ra.sl[6]=5412; /* line # 5412 */
            Lx[5].v[69]=MXD_CMP_newphysitm(4, Lx[5].ub+560,151);
            Ra.sl[6]=5413; /* line # 5413 */
            if (!Lx[5].ub[560]) MXD_CMP_error(Rd.s+2861,-101);
            Ra.sl[6]=5414; /* line # 5414 */
            if (((UB *)Ri.v[0])[72]) {
              Ra.sl[6]=5416; /* line # 5416 */
              MXD_CMP_PRC_00000016();
              Ra.sl[6]=5417; /* line # 5417 */
              Rv3=Lx[5].v[69];
              Ra.sl[6]=5418; /* line # 5418 */
              PAS__SELECT_OUT(V_lst);
              PAS__WRITE_FCHAR(32,10,-1,1,32);
              PAS__WRITE_CHAR(34);
              PAS__WRITE_CHT(Rv3+9,16,(SL)((C *)Rv3)[8],-1,32);
              PAS__WRITE_STR(Rd.s+2995,-1,-1,32);
              PAS__WRITE_EOLN();
            }
            Ra.sl[6]=5421; /* line # 5421 */
            Lx[5].sl[130]=((SL *)Lx[5].v[69])[7];
            Ra.sl[6]=5422; /* line # 5422 */
            MXD_CMP_looksymbol(152,81,1);
            Ra.sl[6]=5423; /* line # 5423 */
            MXD_CMP_looksemicol(1);
          }
          else {
            Ra.sl[6]=5425; /* line # 5425 */
            if (Rs.ub[504]==118) {
              Ra.sl[6]=5427; /* line # 5427 */
              if (Lx[5].sl[128]>0) {
                Ra.sl[6]=5429; /* line # 5429 */
                Lx[5].sl[128]=Lx[5].sl[128] -1;
                Ra.sl[6]=5430; /* line # 5430 */
                MXD_CMP_PRC_00000028();
              }
            }
            else {
              Ra.sl[6]=5432; /* line # 5432 */
              MXD_CMP_error(Rd.s+2861,-156);
            }
          }
        }
      }
    }
    else {
      Ra.sl[6]=5436; /* line # 5436 */
      Rv4=0;
      for( Rf0=Lx[5].sl[30]+1;Rf0>0;Rf0-- ) {
        Ra.sl[6]=5438; /* line # 5438 */
        Lx[5].f[141]=Lx[5].f[Rv4+96];
        Ra.sl[6]=5439; /* line # 5439 */
        MXD_CMP_indata(Lx[5].f+141,Lx[5].ub+560);
        Ra.sl[6]=5440; /* line # 5440 */
        Rv5=Lx[5].v[Rv4+16];
        Ra.sl[6]=5441; /* line # 5441 */
        ((F *)Rv5)[13]=Lx[5].f[141];
        Ra.sl[6]=5442; /* line # 5442 */
        if (Rv4<Lx[5].sl[30]&&Rs.ub[505]==0) MXD_CMP_error(Rd.s+2861,-157);
        Ra.sl[6]=5443; /* line # 5443 */
        if (Lx[5].ub[560]&&Lx[5].v[Lx[5].sl[30]+16]!=Lx[5].v[10]) MXD_CMP_error(
        Rd.s+2861,-158);
        Rv4++;
      }
      Ra.sl[6]=5446; /* line # 5446 */
      if (Rs.ub[505]!=7&&Rs.ub[505]!=6) {
        Ra.sl[6]=5448; /* line # 5448 */
        while (Rs.ub[42]!=17&&Rs.ub[42]!=16)
        MXD_CMP_inchar();
        Ra.sl[6]=5449; /* line # 5449 */
        Ri.ub[88]=1;
        MXD_CMP_insymbol();
        Ri.ub[88]=0;
      }
      Ra.sl[6]=5452; /* line # 5452 */
      Ra.sl[6]=5454; /* line # 5454 */
      Ra.sl[7]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[4]));
      Ra.sl[6]=5455; /* line # 5455 */
      Ra.sl[8]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[5]));
      Ra.sl[6]=5456; /* line # 5456 */
      Ra.sl[9]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[6]));
      Ra.sl[6]=5457; /* line # 5457 */
      Ra.sl[10]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[8]));
      Ra.sl[6]=5458; /* line # 5458 */
      if (Ra.sl[10]<=0) MXD_CMP_error(Rd.s+2861,159);
      Ra.sl[6]=5459; /* line # 5459 */
      Ra.sl[11]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[9]));
      Ra.sl[6]=5460; /* line # 5460 */
      Ra.sl[12]=Lx[5].sl[129];
      Ra.sl[6]=5461; /* line # 5461 */
      Ra.sl[13]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[7]));
      Ra.sl[6]=5462; /* line # 5462 */
      if (Ra.sl[13]!=0) {
        Ra.sl[6]=5463; /* line # 5463 */
        Rv6=Lx[6].v[1]+32;
        Ra.sl[6]=5465; /* line # 5465 */
        if (Ra.sl[7]>((SL *)Rv6)[4]) ((SL *)Rv6)[4]=Ra.sl[7];
        if (Ra.sl[7]<((SL *)Rv6)[5]) ((SL *)Rv6)[5]=Ra.sl[7];
        Ra.sl[6]=5466; /* line # 5466 */
        if (Ra.sl[8]>((SL *)Rv6)[6]) ((SL *)Rv6)[6]=Ra.sl[8];
        if (Ra.sl[8]<((SL *)Rv6)[7]) ((SL *)Rv6)[7]=Ra.sl[8];
        Ra.sl[6]=5467; /* line # 5467 */
        if (Ra.sl[9]>((SL *)Rv6)[8]) ((SL *)Rv6)[8]=Ra.sl[9];
        if (Ra.sl[9]<((SL *)Rv6)[9]) ((SL *)Rv6)[9]=Ra.sl[9];
        Ra.sl[6]=5468; /* line # 5468 */
        Lx[5].sl[26]=(abs(PAS__F_ROUND(MXD_CMP_val(Lx[5].v[11])))&31)*64;
        Ra.sl[6]=5469; /* line # 5469 */
        if (Ra.sl[13]>0) Ra.sl[13]=(Ra.sl[13]&63)+Lx[5].sl[26];
        else {
          Ra.sl[6]=5470; /* line # 5470 */
          Ra.sl[13]= -(( -Ra.sl[13]&63)+Lx[5].sl[26]);
        }
        Ra.sl[6]=5471; /* line # 5471 */
        Ra.sl[14]=Lx[5].sl[130];
        Ra.sl[6]=5472; /* line # 5472 */
        Ra.sl[15]=PAS__F_ROUND(MXD_CMP_val(Lx[5].v[10]));
        Ra.sl[6]=5473; /* line # 5473 */
        if (Ra.sl[13]>0) {
          Ra.sl[6]=5475; /* line # 5475 */
          ((SL *)Rv6)[3]=((SL *)Rv6)[3]+1;
          Ra.sl[6]=5476; /* line # 5476 */
          Ra.f[20]=MXD_CMP_val(Lx[5].v[14]);
          Ra.f[22]=MXD_CMP_val(Lx[5].v[2]);
          Ra.f[21]=MXD_CMP_val(Lx[5].v[3]);
          Ra.sl[6]=5477; /* line # 5477 */
          ((F *)Rv6)[13]=((F *)Rv6)[13]+Ra.f[20];
          ((F *)Rv6)[11]=((F *)Rv6)[11]+Ra.f[21]*Ra.f[20];
          Ra.sl[6]=5478; /* line # 5478 */
          ((F *)Rv6)[12]=((F *)Rv6)[12]+PAS__F_SQR(Ra.f[20]);
          ((F *)Rv6)[10]=((F *)Rv6)[10]+PAS__F_SQR(Ra.f[21]*Ra.f[20]);
        }
        else {
          Ra.sl[6]=5481; /* line # 5481 */
          Ra.f[20]=(F)0.000000E-01;
          Ra.f[22]=(F)0.000000E-01;
          Ra.f[21]=(F)0.000000E-01;
        }
        Ra.sl[6]=5483; /* line # 5483 */
        Ra.f[16]=(Rs.f[230]*(float)Ra.sl[7]+Rs.f[231]*(float)Ra.sl[8])+Rs.f[232]
        *(float)Ra.sl[9];
        Ra.sl[6]=5484; /* line # 5484 */
        Ra.f[17]=(Rs.f[233]*(float)Ra.sl[7]+Rs.f[234]*(float)Ra.sl[8])+Rs.f[235]
        *(float)Ra.sl[9];
        Ra.sl[6]=5485; /* line # 5485 */
        Ra.f[18]=(Rs.f[236]*(float)Ra.sl[7]+Rs.f[237]*(float)Ra.sl[8])+Rs.f[238]
        *(float)Ra.sl[9];
        Ra.sl[6]=5486; /* line # 5486 */
        if (Lx[5].sl[129]>-1) {
          Ra.sl[6]=5488; /* line # 5488 */
          Lx[5].f[142]=Ra.f[16]+(float)Ra.sl[11]*Lx[5].f[134];
          Ra.sl[6]=5489; /* line # 5489 */
          Lx[5].f[143]=Ra.f[17]+(float)Ra.sl[11]*Lx[5].f[135];
          Ra.sl[6]=5490; /* line # 5490 */
          Lx[5].f[144]=Ra.f[18]+(float)Ra.sl[11]*Lx[5].f[136];
        }
        else {
          Ra.sl[6]=5491; /* line # 5491 */
          Lx[5].f[142]=Ra.f[16];
          Lx[5].f[143]=Ra.f[17];
          Lx[5].f[144]=Ra.f[18];
        }
        Ra.sl[6]=5492; /* line # 5492 */
        Lx[5].f[141]=sqrt((PAS__F_SQR(Lx[5].f[142])+PAS__F_SQR(Lx[5].f[143]))+PAS__F_SQR
        (Lx[5].f[144]))/(F)2.000000E+00;
        Ra.sl[6]=5493; /* line # 5493 */
        Ra.f[19]=Lx[5].f[141];
        Ra.sl[6]=5494; /* line # 5494 */
        Rv7=0;
        for( Rf0=16;Rf0>0;Rf0-- ) {
          Ra.sl[6]=5495; /* line # 5495 */
          if (Rs.v[Rv7+45]!=NULL) {
            Ra.sl[6]=5497; /* line # 5497 */
            Rv8=Rs.v[Rv7+45];
            Ra.sl[6]=5498; /* line # 5498 */
            if (((UB *)Rv8)[48]==13) Lx[5].f[145]=MXD_CMP_val(((V *)Rv8)[8]);
            else {
              Ra.sl[6]=5499; /* line # 5499 */
              Lx[5].f[145]=MXD_CMP_interpol(Rs.v[Rv7+45],Lx[5].f+141);
            }
            Ra.sl[6]=5500; /* line # 5500 */
            Ra.f[Rv7+23]=Lx[5].f[145];
          }
          else {
            Ra.sl[6]=5502; /* line # 5502 */
            Ra.f[Rv7+23]=(F)0.000000E-01;
          }
          Rv7++;
        }
        Ra.sl[6]=5504; /* line # 5504 */
        if (((UB *)Ri.v[0])[72]) {
          Ra.sl[6]=5506; /* line # 5506 */
          MXD_CMP_PRC_00000016();
          Ra.sl[6]=5507; /* line # 5507 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_INT(((SL *)Rv6)[2]+1,5,0);
          PAS__WRITE_CHAR(47);
          PAS__WRITE_INT(Ra.sl[7],3,0);
          PAS__WRITE_INT(Ra.sl[8],3,0);
          PAS__WRITE_INT(Ra.sl[9],3,0);
          PAS__WRITE_INT(Ra.sl[10],3,0);
          PAS__WRITE_INT(Ra.sl[11],3,0);
          Ra.sl[6]=5508; /* line # 5508 */
          if (Ra.sl[13]>=0) {
            Ra.sl[6]=5509; /* line # 5509 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_CHAR(33);
            PAS__WRITE_SNGL(Ra.f[20],7,2,0);
            PAS__WRITE_SNGL(Ra.f[22],7,2,0);
            PAS__WRITE_SNGL(Ra.f[21],10,-6,0);
            PAS__WRITE_CHAR(33);
            PAS__WRITE_INT(Ra.sl[13],2,0);
          }
          else {
            Ra.sl[6]=5511; /* line # 5511 */
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_FCHAR(32,28,-1,1,32);
          }
          Ra.sl[6]=5512; /* line # 5512 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_SNGL(Ra.f[19],7,4,0);
          Ra.sl[6]=5513; /* line # 5513 */
          Rv9=0;
          for( Rf0=7;Rf0>0;Rf0-- ) {
            PAS__SELECT_OUT(V_lst);
            PAS__WRITE_SNGL(Ra.f[Rv9+23],6,2,0);
            Rv9++;
          }
          Ra.sl[6]=5514; /* line # 5514 */
          PAS__SELECT_OUT(V_lst);
          PAS__WRITE_EOLN();
        }
        Ra.sl[6]=5516; /* line # 5516 */
        Lx[5].sl[26]=Ra.sl[13];
      }
      else {
        Ra.sl[6]=5517; /* line # 5517 */
        Lx[5].sl[26]=0;
      }
      Ra.sl[6]=5519; /* line # 5519 */
      if (Lx[5].sl[26]!=0) {
        Ra.sl[6]=5521; /* line # 5521 */
        PAS__SELECT_OUT(Ri.v[16]);
        PAS__WRITE_BIN(Ra.s+28);
        Ra.sl[6]=5522; /* line # 5522 */
        Rv10=Lx[6].v[1]+32;
        Ra.sl[6]=5523; /* line # 5523 */
        ((SL *)Rv10)[2]=((SL *)Rv10)[2]+1;
        ((F *)Lx[5].v[12])[13]=(float)((SL *)Rv10)[2];
      }
      Ra.sl[6]=5525; /* line # 5525 */
      if (Rs.ub[505]==6) MXD_CMP_insymbol();
    }
    Ra.sl[6]=5527; /* line # 5527 */
    if (Rs.ub[505]==0&&Rs.ub[504]==102) Rs.ub[505]=7;
    Ra.sl[6]=5528; /* line # 5528 */
    if (Rs.ub[505]==7&&Lx[5].sl[128]>0) {
      Ra.sl[6]=5529; /* line # 5529 */
      Rs.ub[505]=0;
      Rs.ub[504]=118;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " newdatasta "  */
void MXD_CMP_PRC_00000034(){
  /* Define the automatic variable space. */
  Blk( Ra, 616 );

  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[73]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+584;
  Ra.v[74]=Rd.s+3034;
  Ra.v[75]=Rd.s+12;
  Ra.sl[152]=5536; /* line # 5536 */
  Ri.ub[97]=1;
  Ra.sl[152]=5537; /* line # 5537 */
  MXD_CMP_PRC_00000036();
  Ra.sl[152]=5538; /* line # 5538 */
  MXD_CMP_PRC_00000032();
  Ra.sl[152]=5539; /* line # 5539 */
  P_open_bdtfile(Ri.v+16,Lx[6].v[0]);
  Ra.sl[152]=5540; /* line # 5540 */
  MXD_CMP_PRC_00000037();
  Ra.sl[152]=5541; /* line # 5541 */
  P_close_bdtfile(Ri.v+16);
  Ra.sl[152]=5542; /* line # 5542 */
  MXD_CMP_insymbol();
  Ra.sl[152]=5543; /* line # 5543 */
  MXD_CMP_relscope();
  PAS__curr_cntx=Ra.v[73];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " extdatasta "  */
void MXD_CMP_PRC_00000038(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3046;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5551; /* line # 5551 */
  Ra.sl[6]=5553; /* line # 5553 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=5554; /* line # 5554 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=5556; /* line # 5556 */
  MXD_CMP_getphysparam();
  Ra.sl[6]=5557; /* line # 5557 */
  if (Rs.ub[906]==74) MXD_CMP_error(Rd.s+2861,103);
  Ra.sl[6]=5558; /* line # 5558 */
  MXD_CMP_getphysparam();
  MXD_CMP_getphysparam();
  Ra.sl[6]=5559; /* line # 5559 */
  MXD_CMP_getphysparam();
  Ra.sl[6]=5560; /* line # 5560 */
  MXD_CMP_PRC_00000032();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " datastate "  */
void MXD_CMP_PRC_00000031(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register P Lx_Sv;
  Lx_Sv=Lx[6];
  Lx[6].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+3058;
  Ra.v[4]=Rd.s+12;
  Ra.sl[10]=5566; /* line # 5566 */
  MXD_CMP_PRC_00000030();
  Ra.sl[10]=5567; /* line # 5567 */
  Ra.v[1]=MXD_CMP_newphysitm(5, &Rv0,151);
  Ra.sl[10]=5568; /* line # 5568 */
  if (Rv0) {
    Ra.sl[10]=5570; /* line # 5570 */
    if (((UB *)Ra.v[1])[88]) {
      Ra.sl[10]=5572; /* line # 5572 */
      MXD_CMP_error(Rd.s+2861,-102);
      Ra.sl[10]=5573; /* line # 5573 */
      MXD_CMP_skip(155,0);
    }
    else {
      Ra.sl[10]=5575; /* line # 5575 */
      if (Rs.ub[504]==150) MXD_CMP_PRC_00000034();
      else {
        Ra.sl[10]=5576; /* line # 5576 */
        MXD_CMP_PRC_00000038();
      }
    }
  }
  else {
    Ra.sl[10]=5580; /* line # 5580 */
    Rv1=Ra.v[1];
    Ra.sl[10]=5582; /* line # 5582 */
    ((SL *)Rv1)[8]=Rs.sl[137];
    Ra.sl[10]=5583; /* line # 5583 */
    ((UB *)Rv1)[88]=1;
    Ra.sl[10]=5585; /* line # 5585 */
    Rs.sl[137]=Rs.sl[137]+1;
    Ra.sl[10]=5586; /* line # 5586 */
    MXD_CMP_PRC_00000034();
  }
  Ra.sl[10]=5588; /* line # 5588 */
  MXD_CMP_PRC_00000033();
  Ra.sl[10]=5589; /* line # 5589 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[2];
  Lx[6]=Lx_Sv;
}


/* Procedure/Function : " clrdatastate "  */
void MXD_CMP_PRC_00000039(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3069;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5597; /* line # 5597 */
  if (Ri.ub[98]) Ri.ub[98]=0;
  else {
    Ra.sl[6]=5598; /* line # 5598 */
    MXD_CMP_error(Rd.s+3085,-171);
  }
  Ra.sl[6]=5599; /* line # 5599 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " contribstate "  */
void MXD_CMP_PRC_00000040(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3089;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5615; /* line # 5615 */
  Ra.sl[6]=5616; /* line # 5616 */
  if (Rs.ub[505]!=0) {
    Ra.sl[6]=5618; /* line # 5618 */
    MXD_CMP_error(Rd.s+3105,61);
    MXD_CMP_skip(155,1);
  }
  else {
    Ra.sl[6]=5622; /* line # 5622 */
    Rv0=Rs.v[66]==NULL;
    Rv1=0;
    Ra.sl[6]=5623; /* line # 5623 */
    if (Rv0) {
      Ra.sl[6]=5625; /* line # 5625 */
      MXD_CMP_declarenewident(&Rv0);
      Ra.sl[6]=5626; /* line # 5626 */
      ((UB *)Rs.v[66])[48]=14;
      Ra.sl[6]=5627; /* line # 5627 */
      Rv1=1;
    }
    else {
      Ra.sl[6]=5630; /* line # 5630 */
      if (((UB *)Rs.v[66])[48]!=14) MXD_CMP_error(Rd.s+3105,111);
    }
    Ra.sl[6]=5631; /* line # 5631 */
    Rv2=Rs.v[66];
    Ra.sl[6]=5632; /* line # 5632 */
    MXD_CMP_insymbol();
    while (1){
      Ra.sl[6]=5634; /* line # 5634 */
      Rv3=MXD_CMP_newphysitm(1, &Rv4,74);
      Ra.sl[6]=5635; /* line # 5635 */
      if (!Rv4) MXD_CMP_error(Rd.s+3105,101);
      else {
        Ra.sl[6]=5636; /* line # 5636 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(88,4,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT((SL)Rv1,2,0);
        PAS__WRITE_CHAR(32);
      }
      Ra.sl[6]=5637; /* line # 5637 */
      Rv5=Rv2;
      Ra.sl[6]=5639; /* line # 5639 */
      if (Rv1) {
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_CHT(Rv5+9,16,(SL)((C *)Rv5)[8],-1,32);
        PAS__WRITE_CHAR(32);
      }
      Ra.sl[6]=5640; /* line # 5640 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_INT(((SL *)Rv5)[1],6,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv3)[7],6,0);
      PAS__WRITE_EOLN();
      Ra.sl[6]=5642; /* line # 5642 */
      Rv1=0;
      Ra.sl[6]=5643; /* line # 5643 */
      if (Rs.ub[504]==150) MXD_CMP_insymbol();
      else {
        Ra.sl[6]=5644; /* line # 5644 */
        if (Rs.ub[504]!=155) MXD_CMP_error(Rd.s+3105,87);
      }
      if (Rs.ub[504]==155||Rs.ub[504]==102)  break;
    }
    Ra.sl[6]=5646; /* line # 5646 */
    MXD_CMP_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " variablestate "  */
void MXD_CMP_PRC_00000041(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  F Rv2;
  F Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3109;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5660; /* line # 5660 */
  while (1){
    Ra.sl[6]=5662; /* line # 5662 */
    MXD_CMP_declarenewident(&Rv0);
    Ra.sl[6]=5663; /* line # 5663 */
    if (Rv0) {
      Ra.sl[6]=5664; /* line # 5664 */
      MXD_CMP_skip(150,1);
    }
    else {
      Ra.sl[6]=5667; /* line # 5667 */
      Rv1=Rs.v[66];
      Ra.sl[6]=5668; /* line # 5668 */
      ((UB *)Rv1)[48]=11;
      Rv2=(F)0.000000E-01;
      Rv3=(F)0.000000E-01;
      Ra.sl[6]=5669; /* line # 5669 */
      MXD_CMP_insymbol();
      Ra.sl[6]=5670; /* line # 5670 */
      if (Rs.ub[504]==50||Rs.ub[504]==134) {
        Ra.sl[6]=5672; /* line # 5672 */
        MXD_CMP_insymbol();
        MXD_CMP_getncte(&Rv2);
        Ra.sl[6]=5673; /* line # 5673 */
        if (Rs.ub[504]==149) {
          Ra.sl[6]=5674; /* line # 5674 */
          MXD_CMP_insymbol();
          MXD_CMP_getncte(&Rv3);
        }
      }
      else {
        Ra.sl[6]=5677; /* line # 5677 */
        if (Rs.ub[504]==150) MXD_CMP_insymbol();
      }
      Ra.sl[6]=5678; /* line # 5678 */
      Rv4=Rv1;
      Ra.sl[6]=5679; /* line # 5679 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(75,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_CHT(Rv4+9,16,(SL)((C *)Rv4)[8],-1,32);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv1)[1],6,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(Rv2,12,-6,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(Rv3,12,-6,0);
      PAS__WRITE_EOLN();
    }
    if (Rs.ub[505]!=0&&Rs.ub[505]!=2)  break;
  }
  Ra.sl[6]=5683; /* line # 5683 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " locatetab "  */
void MXD_CMP_PRC_00000043(F *F_x, F *F_y, F *F_lstp, SL *F_ips, V *F_lsp, V *F_crp)
{
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  F Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3124;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5714; /* line # 5714 */
  Rv0=0;
  Ra.sl[6]=5715; /* line # 5715 */
  Rv1=0;
  (*F_lsp)=NULL;
  Ra.sl[6]=5716; /* line # 5716 */
  while (!Rv1&&(*F_crp)!=NULL){
    Ra.sl[6]=5718; /* line # 5718 */
    Rv2=(*F_crp);
    Ra.sl[6]=5720; /* line # 5720 */
    Rv3=((F *)Rv2)[2];
    Rv0=0;
    Ra.sl[6]=5721; /* line # 5721 */
    (*F_lstp)=((F *)Rv2)[3];
    Ra.sl[6]=5722; /* line # 5722 */
    while ((*F_x)>Rv3&&Rv0<((UL *)Rv2)[4]){
      Ra.sl[6]=5723; /* line # 5723 */
      Rv0=Rv0+1;
      Rv3=Rv3+((F *)Rv2)[3];
    }
    Ra.sl[6]=5724; /* line # 5724 */
    Rv1=(*F_x)<=Rv3;
    Ra.sl[6]=5726; /* line # 5726 */
    if (!Rv1) {
      Ra.sl[6]=5728; /* line # 5728 */
      (*F_lsp)=(*F_crp);
      (*F_crp)=((V *)(*F_lsp))[0];
    }
  }
  Ra.sl[6]=5731; /* line # 5731 */
  if (Rv1) {
    Ra.sl[6]=5733; /* line # 5733 */
    (*F_ips)=Rv0;
    (*F_x)=Rv3;
    (*F_y)=((F *)(*F_crp))[Rv0+5];
  }
  else {
    Ra.sl[6]=5735; /* line # 5735 */
    (*F_ips)=-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initfrm "  */
void MXD_CMP_PRC_00000044(V *F_pt, F *F_o, F *F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3135;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5741; /* line # 5741 */
  (*F_pt)=MXD_CMP_newdftb();
  Ra.sl[6]=5742; /* line # 5742 */
  Rv0=(*F_pt);
  Ra.sl[6]=5744; /* line # 5744 */
  ((V *)Rv0)[0]=NULL;
  ((F *)Rv0)[2]=(*F_o);
  ((F *)Rv0)[3]=(*F_st);
  ((UL *)Rv0)[4]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " assignparstate "  */
void MXD_CMP_PRC_00000042(UB F_blst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  F Rv1;
  V Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  register V Rv6;
  V Rv7;
  F Rv8;
  SL Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3144;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5750; /* line # 5750 */
  Rv0=NULL;
  Ra.sl[6]=5751; /* line # 5751 */
  Rv1=(F)0.000000E-01;
  Ra.sl[6]=5752; /* line # 5752 */
  Ra.sl[6]=5754; /* line # 5754 */
  Rv2=Rs.v[66];
  Ra.sl[6]=5755; /* line # 5755 */
  MXD_CMP_insymbol();
  Ra.sl[6]=5756; /* line # 5756 */
  if (Rs.ub[504]==151) {
    Ra.sl[6]=5758; /* line # 5758 */
    MXD_CMP_insymbol();
    Ra.sl[6]=5759; /* line # 5759 */
    Rv3=(F)-1.000000E+00;
    Rv4=(F)1.000000E+00;
    Rv5=(F)1.000000E+00;
    Ra.sl[6]=5760; /* line # 5760 */
    MXD_CMP_getncte(&Rv3);
    MXD_CMP_getncte(&Rv4);
    Rv4=fabs(Rv4);
    Ra.sl[6]=5761; /* line # 5761 */
    if (Rs.ub[504]!=152) MXD_CMP_error(Rd.s+3162,-81);
    else MXD_CMP_insymbol();
    Ra.sl[6]=5762; /* line # 5762 */
    if (Rs.ub[504]!=50&&Rs.ub[504]!=134) MXD_CMP_error(Rd.s+3162,90);
    Ra.sl[6]=5763; /* line # 5763 */
    MXD_CMP_insymbol();
    Ra.sl[6]=5764; /* line # 5764 */
    Rv6=Rv2;
    Ra.sl[6]=5766; /* line # 5766 */
    if (((UB *)Rv6)[48]==10) {
      Ra.sl[6]=5767; /* line # 5767 */
      if (((UB *)Rv6)[49]!=0) MXD_CMP_error(Rd.s+3162,-64);
      else {
        Ra.sl[6]=5769; /* line # 5769 */
        ((UB *)Rv6)[48]=12;
        Ra.sl[6]=5770; /* line # 5770 */
        ((SL *)Rv6)[13]=-1;
        Ra.sl[6]=5771; /* line # 5771 */
        MXD_CMP_PRC_00000044(((V *)Rv6)+8,&Rv3, &Rv4);
        Ra.sl[6]=5772; /* line # 5772 */
        Rv7=NULL;
        Rv0=((V *)Rv6)[8];
      }
    }
    else {
      Ra.sl[6]=5776; /* line # 5776 */
      Rv7=NULL;
      Rv0=((V *)Rv6)[8];
      Rv1=Rv3;
      Ra.sl[6]=5777; /* line # 5777 */
      MXD_CMP_PRC_00000043(&Rv1, &Rv5, &Rv8, &Rv9, &Rv7, &Rv0);
      Ra.sl[6]=5778; /* line # 5778 */
      if (Rv9==0&&Rv7==NULL) {
        Ra.sl[6]=5780; /* line # 5780 */
        ((F *)Rv0)[2]=Rv3;
        ((F *)Rv0)[3]=Rv4;
        Rv1=Rv3;
        Rv8=Rv4;
      }
      Ra.sl[6]=5782; /* line # 5782 */
      if (Rv9>=0) {
        Ra.sl[6]=5784; /* line # 5784 */
        ((UL *)Rv0)[4]=Rv9;
        Ra.sl[6]=5785; /* line # 5785 */
        if (((V *)Rv0)[0]!=NULL) MXD_CMP_fredftb(((V *)Rv0)[0]);
        Ra.sl[6]=5786; /* line # 5786 */
        if (fabs(Rv3-Rv1)>=(F)1.000000E-05||fabs(Rv8-Rv4)>=(F)1.000000E-05) {
          Ra.sl[6]=5787; /* line # 5787 */
          Rv9=-1;
        }
        Ra.sl[6]=5788; /* line # 5788 */
        ((V *)Rv0)[0]=NULL;
        Rv7=Rv0;
      }
      Ra.sl[6]=5790; /* line # 5790 */
      if (Rv9<0) {
        Ra.sl[6]=5792; /* line # 5792 */
        MXD_CMP_PRC_00000044(&Rv0, &Rv3, &Rv4);
        Ra.sl[6]=5793; /* line # 5793 */
        ((V *)Rv7)[0]=Rv0;
      }
    }
    Ra.sl[6]=5797; /* line # 5797 */
    Rv1=Rv3;
    Ra.sl[6]=5798; /* line # 5798 */
    if (Rs.ub[504]!=151) MXD_CMP_error(Rd.s+3162,82);
    else {
      Ra.sl[6]=5799; /* line # 5799 */
      MXD_CMP_insymbol();
    }
    while (1){
      Ra.sl[6]=5801; /* line # 5801 */
      MXD_CMP_getncte(&Rv5);
      Ra.sl[6]=5802; /* line # 5802 */
      if (((UL *)Rv0)[4]>=50) {
        Ra.sl[6]=5803; /* line # 5803 */
        MXD_CMP_PRC_00000044(&Rv7, &Rv1, &Rv4);
        ((V *)Rv0)[0]=Rv7;
        Rv0=Rv7;
      }
      Ra.sl[6]=5804; /* line # 5804 */
      Rv1=Rv1+Rv4;
      Ra.sl[6]=5805; /* line # 5805 */
      Rv10=Rv0;
      Ra.sl[6]=5806; /* line # 5806 */
      ((F *)Rv10)[((UL *)Rv10)[4]+5]=Rv5;
      ((UL *)Rv10)[4]=((UL *)Rv10)[4]+1;
      if (Rs.ub[505]==4||Rs.ub[505]==7)  break;
    }
    Ra.sl[6]=5808; /* line # 5808 */
    if (Rs.ub[504]!=152) MXD_CMP_error(Rd.s+3162,81);
    else MXD_CMP_insymbol();
  }
  else {
    Ra.sl[6]=5811; /* line # 5811 */
    if (((UB *)Rv2)[48]==12) MXD_CMP_error(Rd.s+3162,-64);
    else {
      Ra.sl[6]=5813; /* line # 5813 */
      if (Rs.ub[504]==50||Rs.ub[504]==134) {
        Ra.sl[6]=5815; /* line # 5815 */
        MXD_CMP_insymbol();
        Ra.sl[6]=5816; /* line # 5816 */
        Rv11=Rv2;
        Ra.sl[6]=5817; /* line # 5817 */
        switch (((UB *)Rv11)[49]) {
          case 0:Ra.sl[6]=5820; /* line # 5820 */
          MXD_CMP_valueexpression();
          Ra.sl[6]=5821; /* line # 5821 */
          ((UB *)Rv11)[49]=Rs.ub[907];
          Ra.sl[6]=5822; /* line # 5822 */
          switch (Rs.ub[907]) {
            case 0:Ra.sl[6]=5823; /* line # 5823 */
            MXD_CMP_error(Rd.s+3162,78);
            break;
            case 1:Ra.sl[6]=5824; /* line # 5824 */
            ((V *)Rv11)[7]=Rs.v[114];
            break;
            case 2:Ra.sl[6]=5825; /* line # 5825 */
            ((F *)Rv11)[13]=Rs.f[228];
            break;
            case 3:
            case 4:Ra.sl[6]=5828; /* line # 5828 */
            PAS__SELECT_OUT(Ri.v[13]);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_INT(76,4,0);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_CHT(Rv11+9,16,(SL)((C *)Rv11)[8],-1,32);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_INT(((SL *)Rv11)[1],6,0);
            PAS__WRITE_EOLN();
            Ra.sl[6]=5830; /* line # 5830 */
            ((UB *)Rv11)[49]=4;
            break;
          }
          break;
          case 1:Ra.sl[6]=5836; /* line # 5836 */
          MXD_CMP_getscte(&Rv12);
          Ra.sl[6]=5837; /* line # 5837 */
          P_st_free(((V *)Rv11)+7);
          Ra.sl[6]=5838; /* line # 5838 */
          ((V *)Rv11)[7]=Rv12;
          break;
          case 2:Ra.sl[6]=5840; /* line # 5840 */
          MXD_CMP_getncte(((F *)Rv11)+13);
          break;
          case 3:
          case 4:Ra.sl[6]=5842; /* line # 5842 */
          MXD_CMP_error(Rd.s+3162,79);
          Ra.sl[6]=5843; /* line # 5843 */
          MXD_CMP_skip(150,0);
          break;
        }
      }
      else {
        Ra.sl[6]=5847; /* line # 5847 */
        MXD_CMP_error(Rd.s+3162,65);
      }
    }
  }
  Ra.sl[6]=5849; /* line # 5849 */
  if (F_blst) {
    Ra.sl[6]=5851; /* line # 5851 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
  }
  else {
    Ra.sl[6]=5853; /* line # 5853 */
    MXD_CMP_looksemicol(1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " paramstate "  */
void MXD_CMP_PRC_00000045(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3166;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5865; /* line # 5865 */
  while (1){
    Ra.sl[6]=5867; /* line # 5867 */
    MXD_CMP_declarenewident(&Rv0);
    Ra.sl[6]=5868; /* line # 5868 */
    if (!Rv0) {
      Ra.sl[6]=5870; /* line # 5870 */
      Rv1=Rs.v[66];
      Ra.sl[6]=5871; /* line # 5871 */
      Rv2=Rv1;
      Ra.sl[6]=5872; /* line # 5872 */
      ((UB *)Rv2)[48]=10;
      ((UB *)Rv2)[49]=0;
      Ra.sl[6]=5873; /* line # 5873 */
      MXD_CMP_PRC_00000042(1);
    }
    else {
      Ra.sl[6]=5874; /* line # 5874 */
      MXD_CMP_skip(150,1);
    }
    if (Rs.ub[505]!=0&&Rs.ub[505]!=2)  break;
  }
  Ra.sl[6]=5876; /* line # 5876 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " assignffstate "  */
void MXD_CMP_PRC_00000046(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  UB Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3178;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5892; /* line # 5892 */
  Ra.sl[6]=5893; /* line # 5893 */
  while (Rs.ub[505]==0||Rs.ub[505]==2){
    Ra.sl[6]=5895; /* line # 5895 */
    if (Rs.ub[505]==2) Rv0=NULL;
    else Rv0=Rs.v[66];
    Ra.sl[6]=5896; /* line # 5896 */
    if (Rs.ub[505]==0) {
      Ra.sl[6]=5897; /* line # 5897 */
      if (Rv0!=NULL) {
        Ra.sl[6]=5898; /* line # 5898 */
        Rv1=Rv0;
        Ra.sl[6]=5899; /* line # 5899 */
        if (((SL *)Rv1)[0]!=Rs.sl[6]) {
          Ra.sl[6]=5900; /* line # 5900 */
          if (((UB *)Rv1)[48]!=12&&((UB *)Rv1)[48]!=13) Rv0=NULL;
        }
      }
    }
    Ra.sl[6]=5901; /* line # 5901 */
    if (Rv0==NULL) {
      Ra.sl[6]=5903; /* line # 5903 */
      MXD_CMP_declarenewident(&Rv2);
      Ra.sl[6]=5904; /* line # 5904 */
      if (!Rv2) {
        Ra.sl[6]=5905; /* line # 5905 */
        Rv3=Rs.v[66];
        Ra.sl[6]=5906; /* line # 5906 */
        ((UB *)Rv3)[48]=13;
        ((V *)Rv3)[8]=NULL;
        ((SL *)Rv3)[13]=-1;
      }
    }
    Ra.sl[6]=5908; /* line # 5908 */
    Rv0=Rs.v[66];
    Ra.sl[6]=5909; /* line # 5909 */
    MXD_CMP_insymbol();
    Ra.sl[6]=5910; /* line # 5910 */
    Rv4=0;
    Ra.sl[6]=5911; /* line # 5911 */
    MXD_CMP_getnumber(&Rv4);
    Ra.sl[6]=5912; /* line # 5912 */
    if (Rv0==NULL) MXD_CMP_error(Rd.s+3195,51);
    else {
      Ra.sl[6]=5913; /* line # 5913 */
      Rv5=Rv0;
      Ra.sl[6]=5914; /* line # 5914 */
      if (((UB *)Rv5)[48]!=12&&((UB *)Rv5)[48]!=13) {
        Ra.sl[6]=5915; /* line # 5915 */
        MXD_CMP_error(Rd.s+3195,69);
      }
      else {
        Ra.sl[6]=5918; /* line # 5918 */
        if (((SL *)Rv5)[13]==-1) {
          Ra.sl[6]=5919; /* line # 5919 */
          if (Rv4!=0) {
            Ra.sl[6]=5921; /* line # 5921 */
            if (Rv4<0) Rv4=16+Rv4;
            else Rv4=Rv4-1;
            Ra.sl[6]=5922; /* line # 5922 */
            if (Rv4<=15) {
              Ra.sl[6]=5923; /* line # 5923 */
              if (Rs.v[Rv4+45]==NULL) {
                Ra.sl[6]=5924; /* line # 5924 */
                Rs.v[Rv4+45]=Rv0;
                ((SL *)Rv5)[13]=Rv4;
              }
              else {
                Ra.sl[6]=5925; /* line # 5925 */
                MXD_CMP_error(Rd.s+3195,4);
              }
            }
            else {
              Ra.sl[6]=5926; /* line # 5926 */
              MXD_CMP_error(Rd.s+3195,4);
            }
          }
          else {
            Ra.sl[6]=5930; /* line # 5930 */
            ((SL *)Rv5)[13]=MXD_CMP_setnewffrm(Rv0);
            Ra.sl[6]=5931; /* line # 5931 */
            if (((SL *)Rv5)[13]==-1) MXD_CMP_error(Rd.s+3195,4);
          }
        }
        else {
          Ra.sl[6]=5932; /* line # 5932 */
          MXD_CMP_error(Rd.s+3195,159);
        }
      }
    }
    Ra.sl[6]=5934; /* line # 5934 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
  }
  Ra.sl[6]=5936; /* line # 5936 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " fixedstate "  */
void MXD_CMP_PRC_00000047(UB F_ndsy){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3199;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5947; /* line # 5947 */
  Ra.sl[6]=5948; /* line # 5948 */
  while (Rs.ub[505]==0){
    Ra.sl[6]=5950; /* line # 5950 */
    if (Rs.v[66]==NULL) MXD_CMP_error(Rd.s+3213,51);
    else {
      Ra.sl[6]=5951; /* line # 5951 */
      Rv0=Rs.v[66];
      Ra.sl[6]=5952; /* line # 5952 */
      if (((UB *)Rv0)[48]!=11) MXD_CMP_error(Rd.s+3213,75);
      else {
        Ra.sl[6]=5954; /* line # 5954 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT((SL)F_ndsy,2,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(((SL *)Rv0)[1],6,0);
        PAS__WRITE_EOLN();
      }
    }
    Ra.sl[6]=5956; /* line # 5956 */
    MXD_CMP_insymbol();
    Ra.sl[6]=5957; /* line # 5957 */
    if (Rs.ub[504]==150) MXD_CMP_insymbol();
  }
  Ra.sl[6]=5959; /* line # 5959 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " limitstate "  */
void MXD_CMP_PRC_00000048(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3217;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=5973; /* line # 5973 */
  Rv0=(F)1.000000E+010;
  Ra.sl[6]=5974; /* line # 5974 */
  Rv1= -Rv0;
  Ra.sl[6]=5975; /* line # 5975 */
  Ra.sl[6]=5976; /* line # 5976 */
  if (Rs.ub[504]!=3) {
    Ra.sl[6]=5978; /* line # 5978 */
    MXD_CMP_getncte(&Rv1);
    MXD_CMP_getncte(&Rv0);
    Ra.sl[6]=5979; /* line # 5979 */
    while (Rs.ub[505]==0){
      Ra.sl[6]=5981; /* line # 5981 */
      if (Rs.ub[504]!=3) MXD_CMP_error(Rd.s+3231,75);
      else {
        Ra.sl[6]=5982; /* line # 5982 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_INT(86,4,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(((SL *)Rs.v[66])[1],6,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(Rv1,14,-6,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(Rv0,14,-6,0);
        PAS__WRITE_EOLN();
      }
      Ra.sl[6]=5983; /* line # 5983 */
      MXD_CMP_insymbol();
      Ra.sl[6]=5984; /* line # 5984 */
      if (Rs.ub[504]==150) MXD_CMP_insymbol();
    }
  }
  else {
    Ra.sl[6]=5988; /* line # 5988 */
    Rv2=Rs.v[66];
    MXD_CMP_insymbol();
    Ra.sl[6]=5989; /* line # 5989 */
    if (Rs.ub[504]!=150) MXD_CMP_error(Rd.s+3231,85);
    else {
      Ra.sl[6]=5990; /* line # 5990 */
      MXD_CMP_insymbol();
    }
    Ra.sl[6]=5991; /* line # 5991 */
    MXD_CMP_getncte(&Rv1);
    Ra.sl[6]=5992; /* line # 5992 */
    MXD_CMP_getncte(&Rv0);
    Ra.sl[6]=5993; /* line # 5993 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(86,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv2)[1],6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv1,14,-6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv0,14,-6,0);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=5996; /* line # 5996 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " assignvarstate "  */
void MXD_CMP_PRC_00000049(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  F Rv1;
  F Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3235;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6010; /* line # 6010 */
  Ra.sl[6]=6012; /* line # 6012 */
  Rv0=Rs.v[66];
  Ra.sl[6]=6013; /* line # 6013 */
  MXD_CMP_insymbol();
  Ra.sl[6]=6014; /* line # 6014 */
  if (Rs.ub[504]!=50&&Rs.ub[504]!=134) MXD_CMP_error(Rd.s+3253,90);
  else {
    Ra.sl[6]=6015; /* line # 6015 */
    MXD_CMP_insymbol();
  }
  Ra.sl[6]=6016; /* line # 6016 */
  MXD_CMP_getncte(&Rv1);
  Ra.sl[6]=6017; /* line # 6017 */
  if (Rs.ub[504]==149) {
    Ra.sl[6]=6018; /* line # 6018 */
    MXD_CMP_insymbol();
    MXD_CMP_getncte(&Rv2);
  }
  else Rv2=(F)0.000000E-01;
  Ra.sl[6]=6019; /* line # 6019 */
  MXD_CMP_looksemicol(1);
  Ra.sl[6]=6021; /* line # 6021 */
  Rv3=Rv0;
  Ra.sl[6]=6022; /* line # 6022 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(81,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv3)[1],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rv1,14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rv2,14,-6,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " atomestate "  */
void MXD_CMP_PRC_00000050(UB F_bct){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3257;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6039; /* line # 6039 */
  Rv0=MXD_CMP_newphysitm(1, &Rv1,151);
  Ra.sl[6]=6040; /* line # 6040 */
  if (Rv1) MXD_CMP_error(Rd.s+3271,102);
  Ra.sl[6]=6041; /* line # 6041 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6042; /* line # 6042 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6043; /* line # 6043 */
  Rv1=0;
  Ra.sl[6]=6044; /* line # 6044 */
  for( Rf0=12;Rf0>0;Rf0-- ) {
    Ra.sl[6]=6046; /* line # 6046 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=6047; /* line # 6047 */
    Rv1=Rv1||Rs.ub[906]!=74;
  }
  Ra.sl[6]=6049; /* line # 6049 */
  if (!Rv1) MXD_CMP_error(Rd.s+3271,103);
  Ra.sl[6]=6050; /* line # 6050 */
  Rv2=Rv0;
  Ra.sl[6]=6051; /* line # 6051 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(66-(SL)F_bct,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv2+9,16,(SL)((C *)Rv2)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv2)[7],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6053; /* line # 6053 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " momentstate "  */
void MXD_CMP_PRC_00000051(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3275;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6069; /* line # 6069 */
  Rv0=NULL;
  Ra.sl[6]=6070; /* line # 6070 */
  Rv1=0;
  Ra.sl[6]=6071; /* line # 6071 */
  Rv2=MXD_CMP_newphysitm(2, &Rv3,151);
  Ra.sl[6]=6072; /* line # 6072 */
  if (Rv3) MXD_CMP_error(Rd.s+3290,102);
  Ra.sl[6]=6073; /* line # 6073 */
  Rv4=MXD_CMP_newphysitm(1, &Rv3,150);
  Ra.sl[6]=6074; /* line # 6074 */
  if (!Rv3) MXD_CMP_error(Rd.s+3290,101);
  Ra.sl[6]=6075; /* line # 6075 */
  if (Rs.ub[504]==150) {
    Ra.sl[6]=6077; /* line # 6077 */
    Rv0=MXD_CMP_newphysitm(0, &Rv1,150);
    Ra.sl[6]=6078; /* line # 6078 */
    if (!Rv1) MXD_CMP_error(Rd.s+3290,101);
  }
  Ra.sl[6]=6080; /* line # 6080 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6081; /* line # 6081 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6082; /* line # 6082 */
  Rv3=0;
  Ra.sl[6]=6083; /* line # 6083 */
  for( Rf0=7;Rf0>0;Rf0-- ) {
    Ra.sl[6]=6085; /* line # 6085 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=6086; /* line # 6086 */
    Rv3=Rv3||Rs.ub[906]!=74;
  }
  Ra.sl[6]=6088; /* line # 6088 */
  if (!Rv3) MXD_CMP_error(Rd.s+3290,103);
  Ra.sl[6]=6089; /* line # 6089 */
  Rv5=Rv2;
  Ra.sl[6]=6090; /* line # 6090 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(67,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv5+9,16,(SL)((C *)Rv5)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv5)[7],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv4)[7],6,0);
  Ra.sl[6]=6092; /* line # 6092 */
  if (Rv1) {
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[7],6,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=6093; /* line # 6093 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_STR(Rd.s+3294,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=6094; /* line # 6094 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " latticestate "  */
void MXD_CMP_PRC_00000052(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3303;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6111; /* line # 6111 */
  PAS__CHT_TO_CHT(Ra.s+28,16, Rd.s+3319,8);
  Ra.sl[6]=6112; /* line # 6112 */
  MXD_CMP_inputletter(&Rv0);
  Ra.sl[6]=6113; /* line # 6113 */
  if ((Rv0==82||Rv0==114)||Rv0==104) Rv0=72;
  Ra.sl[6]=6114; /* line # 6114 */
  Rv1=1;
  Ra.sl[6]=6115; /* line # 6115 */
  while (Rv1<8&&Ra.c[Rv1+27]!=Rv0)
  Rv1=Rv1+1;
  Ra.sl[6]=6116; /* line # 6116 */
  if (Rv1<8) {
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(85,4,0);
    PAS__WRITE_INT(Rv1,4,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=6117; /* line # 6117 */
    MXD_CMP_error(Rd.s+3329,-107);
  }
  Ra.sl[6]=6118; /* line # 6118 */
  MXD_CMP_insymbol();
  Ra.sl[6]=6119; /* line # 6119 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " invmat "  */
void MXD_CMP_PRC_00000054(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  register int Rgi;
  register int Rgj;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3333;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6141; /* line # 6141 */
  Rv0=(F)0.000000E-01;
  Ra.sl[6]=6142; /* line # 6142 */
  Rv1=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[6]=6143; /* line # 6143 */
    Rv2=PAS__I_MOD(Rv1,3)+1;
    Rv3=PAS__I_MOD(Rv2,3)+1;
    Ra.sl[6]=6144; /* line # 6144 */
    Rv0=Rv0+Rs.f[Rv1*3+236]*(Rs.f[Rv2*3+237]*Rs.f[Rv3*3+238]-Rs.f[Rv2*3+238]*Rs.
    f[Rv3*3+237]);
    Rv1++;
  }
  Ra.sl[6]=6146; /* line # 6146 */
  Rv4=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Rv5=1;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      Ra.sl[6]=6148; /* line # 6148 */
      Rv2=PAS__I_MOD(Rv4,3)+1;
      Rv3=PAS__I_MOD(Rv2,3)+1;
      Ra.sl[6]=6149; /* line # 6149 */
      Rv6=PAS__I_MOD(Rv5,3)+1;
      Rv7=PAS__I_MOD(Rv6,3)+1;
      Ra.sl[6]=6150; /* line # 6150 */
      Rs.f[Rv4*3+Rv5+226]=(Rs.f[Rv2*3+Rv6+235]*Rs.f[Rv3*3+Rv7+235]-Rs.f[Rv3*3+Rv6+
235]*Rs.f[Rv2*3+Rv7+235])/Rv0;
      Rv5++;
    }
    Rv4++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " permut "  */
void MXD_CMP_PRC_00000055(F *F_r1, F *F_r2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3341;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6159; /* line # 6159 */
  Rv0=(*F_r2);
  (*F_r2)=(*F_r1);
  (*F_r1)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cellstate "  */
void MXD_CMP_PRC_00000053(UB F_brh){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register F Rgf;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3349;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6164; /* line # 6164 */
  Rs.f[249]=(F)0.000000E-01;
  Ra.sl[6]=6165; /* line # 6165 */
  MXD_CMP_getncte(Rs.f+249);
  if (Rs.f[249]==(F)0.000000E-01) MXD_CMP_error(Rd.s+3362,104);
  Ra.sl[6]=6166; /* line # 6166 */
  Rs.f[250]=Rs.f[249];
  Rs.f[251]=Rs.f[249];
  Rs.f[252]=(F)0.000000E-01;
  Ra.sl[6]=6167; /* line # 6167 */
  MXD_CMP_getncte(Rs.f+250);
  MXD_CMP_getncte(Rs.f+251);
  MXD_CMP_getncte(Rs.f+252);
  Ra.sl[6]=6168; /* line # 6168 */
  Rs.f[253]=Rs.f[252];
  Rs.f[254]=Rs.f[252];
  Ra.sl[6]=6169; /* line # 6169 */
  MXD_CMP_getncte(Rs.f+253);
  MXD_CMP_getncte(Rs.f+254);
  Ra.sl[6]=6171; /* line # 6171 */
  if (Rs.f[252]>(F)1.000000E+00) Rs.f[252]=(float)cos(1.745329310000000E-002*(double)
  Rs.f[252]);
  Ra.sl[6]=6172; /* line # 6172 */
  if (Rs.f[253]>(F)1.000000E+00) Rs.f[253]=(float)cos(1.745329310000000E-002*(double)
  Rs.f[253]);
  Ra.sl[6]=6173; /* line # 6173 */
  if (Rs.f[254]>(F)1.000000E+00) Rs.f[254]=(float)cos(1.745329310000000E-002*(double)
  Rs.f[254]);
  Ra.sl[6]=6174; /* line # 6174 */
  Rv0=PAS__F_SQR(Rs.f[252]);
  Rv1=PAS__F_SQR(Rs.f[253]);
  Rv2=PAS__F_SQR(Rs.f[254]);
  Ra.sl[6]=6175; /* line # 6175 */
  Rs.f[255]=((Rs.f[249]*Rs.f[250])*Rs.f[251])*sqrt(((((F)1.000000E+00+(((F)2.000000E+00*
  Rs.f[252])*Rs.f[253])*Rs.f[254])-Rv0)-Rv1)-Rv2);
  Ra.sl[6]=6176; /* line # 6176 */
  if (Rs.f[255]<=(F)0.000000E-01) MXD_CMP_error(Rd.s+3362,-105);
  Ra.sl[6]=6177; /* line # 6177 */
  Rs.f[256]=(F)1.000000E+00/Rs.f[255];
  Ra.sl[6]=6178; /* line # 6178 */
  Rv0=sqrt((F)1.000000E+00-Rv0);
  Ra.sl[6]=6179; /* line # 6179 */
  Rv1=sqrt((F)1.000000E+00-Rv1);
  Ra.sl[6]=6180; /* line # 6180 */
  Rv2=sqrt((F)1.000000E+00-Rv2);
  Ra.sl[6]=6181; /* line # 6181 */
  Rs.f[257]=(Rs.f[253]*Rs.f[254]-Rs.f[252])/(Rv1*Rv2);
  Ra.sl[6]=6182; /* line # 6182 */
  Rs.f[258]=(Rs.f[254]*Rs.f[252]-Rs.f[253])/(Rv2*Rv0);
  Ra.sl[6]=6183; /* line # 6183 */
  Rs.f[259]=(Rs.f[252]*Rs.f[253]-Rs.f[254])/(Rv0*Rv1);
  Ra.sl[6]=6184; /* line # 6184 */
  Rs.f[260]=((Rs.f[250]*Rs.f[251])*Rv0)/Rs.f[255];
  Ra.sl[6]=6185; /* line # 6185 */
  Rs.f[261]=((Rs.f[251]*Rs.f[249])*Rv1)/Rs.f[255];
  Ra.sl[6]=6186; /* line # 6186 */
  Rs.f[262]=((Rs.f[249]*Rs.f[250])*Rv2)/Rs.f[255];
  Ra.sl[6]=6188; /* line # 6188 */
  if (Rs.f[256]>(F)1.000000E+00) {
    Ra.sl[6]=6190; /* line # 6190 */
    MXD_CMP_PRC_00000055(Rs.f+249,Rs.f+260);
    MXD_CMP_PRC_00000055(Rs.f+250,Rs.f+261);
    MXD_CMP_PRC_00000055(Rs.f+251,Rs.f+262);
    Ra.sl[6]=6191; /* line # 6191 */
    MXD_CMP_PRC_00000055(Rs.f+252,Rs.f+257);
    MXD_CMP_PRC_00000055(Rs.f+253,Rs.f+258);
    MXD_CMP_PRC_00000055(Rs.f+254,Rs.f+259);
    Ra.sl[6]=6192; /* line # 6192 */
    MXD_CMP_PRC_00000055(Rs.f+255,Rs.f+256);
  }
  Ra.sl[6]=6195; /* line # 6195 */
  if ((((F_brh&&Rs.f[252]!=Rs.f[253])&&Rs.f[252]!=Rs.f[254])&&Rs.f[249]!=Rs.f[250]
  )&&Rs.f[249]!=Rs.f[251]) {
    Ra.sl[6]=6196; /* line # 6196 */
    MXD_CMP_error(Rd.s+3362,-106);
    F_brh=0;
  }
  Ra.sl[6]=6197; /* line # 6197 */
  if (F_brh) {
    Ra.sl[6]=6199; /* line # 6199 */
    Rv2=sqrt((F)1.000000E+00-Rs.f[252]);
    Rv1=sqrt((F)1.000000E+00+(F)2.000000E+00*Rs.f[252]);
    Ra.sl[6]=6200; /* line # 6200 */
    Rv0=(Rs.f[249]*(Rv1+(F)2.000000E+00*Rv2))/(F)3.000000E+00;
    Rv1=(Rs.f[249]*(Rv1-Rv2))/(F)3.000000E+00;
    Ra.sl[6]=6201; /* line # 6201 */
    Rv3=1;
    for( Rf1=3;Rf1>0;Rf1-- ) {
      Rv4=1;
      for( Rf0=3;Rf0>0;Rf0-- ) {
        Ra.sl[6]=6202; /* line # 6202 */
        if (Rv3==Rv4) Rs.f[Rv3*3+Rv4+235]=Rv0;
        else {
          Ra.sl[6]=6203; /* line # 6203 */
          Rs.f[Rv3*3+Rv4+235]=Rv1;
        }
        Rv4++;
      }
      Rv3++;
    }
  }
  else {
    Ra.sl[6]=6207; /* line # 6207 */
    Rs.f[239]=Rs.f[249];
    Rs.f[242]=(F)0.000000E-01;
    Rs.f[246]=(F)0.000000E-01;
    Ra.sl[6]=6208; /* line # 6208 */
    Rs.f[245]=(F)0.000000E-01;
    Ra.sl[6]=6209; /* line # 6209 */
    Rs.f[240]=Rs.f[250]*Rs.f[254];
    Rs.f[241]=Rs.f[251]*Rs.f[253];
    Ra.sl[6]=6210; /* line # 6210 */
    Rv2=sqrt((F)1.000000E+00-Rs.f[254]*Rs.f[254]);
    Rs.f[243]=Rs.f[250]*Rv2;
    Ra.sl[6]=6211; /* line # 6211 */
    Rv0=(Rs.f[252]-Rs.f[253]*Rs.f[254])/Rv2;
    Ra.sl[6]=6212; /* line # 6212 */
    Rs.f[244]=Rs.f[251]*Rv0;
    Ra.sl[6]=6213; /* line # 6213 */
    Rs.f[247]=Rs.f[251]*sqrt(((F)1.000000E+00-Rv0*Rv0)-Rs.f[253]*Rs.f[253]);
  }
  Ra.sl[6]=6215; /* line # 6215 */
  MXD_CMP_PRC_00000054();
  Ra.sl[6]=6217; /* line # 6217 */
  MXD_CMP_defnwcte(Rd.s+3366,Rs.f[249]);
  MXD_CMP_defnwcte(Rd.s+3370,Rs.f[260]);
  Ra.sl[6]=6218; /* line # 6218 */
  MXD_CMP_defnwcte(Rd.s+3375,Rs.f[250]);
  MXD_CMP_defnwcte(Rd.s+3379,Rs.f[261]);
  Ra.sl[6]=6219; /* line # 6219 */
  MXD_CMP_defnwcte(Rd.s+3384,Rs.f[251]);
  MXD_CMP_defnwcte(Rd.s+3388,Rs.f[262]);
  Ra.sl[6]=6220; /* line # 6220 */
  MXD_CMP_defnwcte(Rd.s+3393,Rs.f[252]);
  MXD_CMP_defnwcte(Rd.s+3401,Rs.f[257]);
  Ra.sl[6]=6221; /* line # 6221 */
  MXD_CMP_defnwcte(Rd.s+3410,Rs.f[253]);
  MXD_CMP_defnwcte(Rd.s+3417,Rs.f[258]);
  Ra.sl[6]=6222; /* line # 6222 */
  MXD_CMP_defnwcte(Rd.s+3425,Rs.f[254]);
  MXD_CMP_defnwcte(Rd.s+3433,Rs.f[259]);
  Ra.sl[6]=6223; /* line # 6223 */
  MXD_CMP_defnwcte(Rd.s+3442,Rs.f[255]);
  MXD_CMP_defnwcte(Rd.s+3451,Rs.f[256]);
  Ra.sl[6]=6224; /* line # 6224 */
  MXD_CMP_defnwcte(Rd.s+3461,Rs.f[239]);
  MXD_CMP_defnwcte(Rd.s+3469,Rs.f[230]);
  Ra.sl[6]=6225; /* line # 6225 */
  MXD_CMP_defnwcte(Rd.s+3477,Rs.f[240]);
  MXD_CMP_defnwcte(Rd.s+3485,Rs.f[231]);
  Ra.sl[6]=6226; /* line # 6226 */
  MXD_CMP_defnwcte(Rd.s+3493,Rs.f[241]);
  MXD_CMP_defnwcte(Rd.s+3501,Rs.f[232]);
  Ra.sl[6]=6227; /* line # 6227 */
  MXD_CMP_defnwcte(Rd.s+3509,Rs.f[242]);
  MXD_CMP_defnwcte(Rd.s+3517,Rs.f[233]);
  Ra.sl[6]=6228; /* line # 6228 */
  MXD_CMP_defnwcte(Rd.s+3525,Rs.f[243]);
  MXD_CMP_defnwcte(Rd.s+3533,Rs.f[234]);
  Ra.sl[6]=6229; /* line # 6229 */
  MXD_CMP_defnwcte(Rd.s+3541,Rs.f[244]);
  MXD_CMP_defnwcte(Rd.s+3549,Rs.f[235]);
  Ra.sl[6]=6230; /* line # 6230 */
  MXD_CMP_defnwcte(Rd.s+3557,Rs.f[245]);
  MXD_CMP_defnwcte(Rd.s+3565,Rs.f[236]);
  Ra.sl[6]=6231; /* line # 6231 */
  MXD_CMP_defnwcte(Rd.s+3573,Rs.f[246]);
  MXD_CMP_defnwcte(Rd.s+3581,Rs.f[237]);
  Ra.sl[6]=6232; /* line # 6232 */
  MXD_CMP_defnwcte(Rd.s+3589,Rs.f[247]);
  MXD_CMP_defnwcte(Rd.s+3597,Rs.f[238]);
  Ra.sl[6]=6234; /* line # 6234 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(64,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[249],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[250],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[251],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[252],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[253],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[254],14,-6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6237; /* line # 6237 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[260],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[261],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[262],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[257],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[258],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[259],14,-6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6239; /* line # 6239 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rs.f[255],14,-6,0);
  PAS__WRITE_SNGL(Rs.f[256],14,-6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6240; /* line # 6240 */
  Rv5=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Rv6=1;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      Ra.sl[6]=6241; /* line # 6241 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(Rs.f[Rv5*3+Rv6+235],14,-6,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(Rs.f[Rv5*3+Rv6+226],14,-6,0);
      PAS__WRITE_EOLN();
      Rv6++;
    }
    Rv5++;
  }
  Ra.sl[6]=6243; /* line # 6243 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wavestate "  */
void MXD_CMP_PRC_00000056(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  C Rv0;
  V Rv1;
  UB Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3605;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6259; /* line # 6259 */
  Rv0=32;
  Ra.sl[6]=6260; /* line # 6260 */
  Rv1=MXD_CMP_newphysitm(0, &Rv2,151);
  Ra.sl[6]=6261; /* line # 6261 */
  if (Rv2) MXD_CMP_error(Rd.s+3618,102);
  Ra.sl[6]=6262; /* line # 6262 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6263; /* line # 6263 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6264; /* line # 6264 */
  Rv3=Rv1+32;
  Ra.sl[6]=6266; /* line # 6266 */
  ((F *)Rv3)[3]=(F)0.000000E-01;
  ((F *)Rv3)[4]=(F)0.000000E-01;
  ((F *)Rv3)[5]=(F)0.000000E-01;
  Ra.sl[6]=6267; /* line # 6267 */
  MXD_CMP_getncte(((F *)Rv3)+3);
  MXD_CMP_getncte(((F *)Rv3)+4);
  MXD_CMP_getncte(((F *)Rv3)+5);
  Ra.sl[6]=6268; /* line # 6268 */
  if (Rs.ub[505]==0||Rs.ub[505]==1) {
    Ra.sl[6]=6269; /* line # 6269 */
    MXD_CMP_inputletter(&Rv0);
    MXD_CMP_insymbol();
  }
  Ra.sl[6]=6270; /* line # 6270 */
  MXD_CMP_transvect(Rs.s+920,((F *)Rv3),((F *)Rv3)+1,((F *)Rv3)+2,((F *)Rv3)+3,(
  (F *)Rv3)+4,((F *)Rv3)+5);
  Ra.sl[6]=6273; /* line # 6273 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(69,4,0);
  Ra.sl[6]=6274; /* line # 6274 */
  Rv4=Rv1;
  Ra.sl[6]=6275; /* line # 6275 */
  Rv5=Rv4+32;
  Ra.sl[6]=6276; /* line # 6276 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv4+9,16,(SL)((C *)Rv4)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv4)[7],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv5)[0],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv5)[1],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv5)[2],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv5)[3],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv5)[4],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(((F *)Rv5)[5],14,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT((SL)(Rv0==82),2,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6282; /* line # 6282 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " npolastate "  */
void MXD_CMP_PRC_00000057(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3622;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6298; /* line # 6298 */
  Rv0=MXD_CMP_newphysitm(4, &Rv1,151);
  Ra.sl[6]=6299; /* line # 6299 */
  if (Rv1) MXD_CMP_error(Rd.s+3636,102);
  Ra.sl[6]=6300; /* line # 6300 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6301; /* line # 6301 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6302; /* line # 6302 */
  Rv2=Rv0;
  Ra.sl[6]=6304; /* line # 6304 */
  for( Rf0=6;Rf0>0;Rf0-- )
  MXD_CMP_getphysparam();
  Ra.sl[6]=6305; /* line # 6305 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(70,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv2+9,16,(SL)((C *)Rv2)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv2)[7],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6308; /* line # 6308 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " symtrystate "  */
void MXD_CMP_PRC_00000058(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  F Rv5;
  SL Rv6;
  register F Rgf;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3640;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6328; /* line # 6328 */
  Rv0=MXD_CMP_newphysitm(6, &Rv1,151);
  Ra.sl[6]=6329; /* line # 6329 */
  if (Rv1) MXD_CMP_error(Rd.s+3655,102);
  Ra.sl[6]=6330; /* line # 6330 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6331; /* line # 6331 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6332; /* line # 6332 */
  Rv2=Rv0;
  Ra.sl[6]=6334; /* line # 6334 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(71,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv2+9,16,(SL)((C *)Rv2)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv2)[7],6,0);
  Ra.sl[6]=6336; /* line # 6336 */
  Rv3=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[6]=6338; /* line # 6338 */
    Rv4=1;
    for( Rf0=4;Rf0>0;Rf0-- ) {
      Ra.sl[6]=6339; /* line # 6339 */
      Rv5=(F)0.000000E-01;
      MXD_CMP_getncte(&Rv5);
      Ra.sl[6]=6340; /* line # 6340 */
      if (Rv4==4) {
        Ra.sl[6]=6341; /* line # 6341 */
        Rv6=PAS__F_ROUND(Rv5*(F)1.200000E+01);
        ((SL *)Rv2)[Rv3*4+Rv4+3]=Rv6;
      }
      else {
        Ra.sl[6]=6344; /* line # 6344 */
        Rv6=(Rv5>0.0?(SL)(Rv5+0.5):(SL)(Rv5-0.5));
        ((SL *)Rv2)[Rv3*4+Rv4+3]=Rv6;
      }
      Ra.sl[6]=6346; /* line # 6346 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rv6,3,0);
      Rv4++;
    }
    Rv3++;
  }
  Ra.sl[6]=6349; /* line # 6349 */
  MXD_CMP_putransope(Rv2+32);
  Ra.sl[6]=6351; /* line # 6351 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mdsdspstate "  */
void MXD_CMP_PRC_00000059(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3659;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6367; /* line # 6367 */
  Rv0=MXD_CMP_newphysitm(3, &Rv1,151);
  Ra.sl[6]=6368; /* line # 6368 */
  if (Rv1) MXD_CMP_error(Rd.s+3674,102);
  Ra.sl[6]=6369; /* line # 6369 */
  Rv2=MXD_CMP_newphysitm(1, &Rv1,150);
  Ra.sl[6]=6370; /* line # 6370 */
  if (!Rv1) MXD_CMP_error(Rd.s+3674,101);
  Ra.sl[6]=6371; /* line # 6371 */
  Rv3=MXD_CMP_newphysitm(0, &Rv1,150);
  Ra.sl[6]=6372; /* line # 6372 */
  if (!Rv1) MXD_CMP_error(Rd.s+3674,101);
  Ra.sl[6]=6373; /* line # 6373 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6374; /* line # 6374 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6375; /* line # 6375 */
  Rv1=0;
  Ra.sl[6]=6376; /* line # 6376 */
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Ra.sl[6]=6378; /* line # 6378 */
    MXD_CMP_getphysparam();
    Ra.sl[6]=6379; /* line # 6379 */
    Rv1=Rv1||Rs.ub[906]!=74;
  }
  Ra.sl[6]=6381; /* line # 6381 */
  if (!Rv1) MXD_CMP_error(Rd.s+3674,103);
  Ra.sl[6]=6383; /* line # 6383 */
  Rv4=Rv0;
  Ra.sl[6]=6384; /* line # 6384 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(68,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv4+9,16,(SL)((C *)Rv4)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv4)[7],6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv2)[7],6,0);
  Ra.sl[6]=6386; /* line # 6386 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv3)[7],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6388; /* line # 6388 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsqblkstate "  */
void MXD_CMP_PRC_00000060(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3678;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6404; /* line # 6404 */
  Rv0=MXD_CMP_newphysitm(7, &Rv1,151);
  Ra.sl[6]=6405; /* line # 6405 */
  if (Rv1) MXD_CMP_error(Rd.s+3693,102);
  Ra.sl[6]=6406; /* line # 6406 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6407; /* line # 6407 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6408; /* line # 6408 */
  MXD_CMP_getphysparam();
  Ra.sl[6]=6409; /* line # 6409 */
  MXD_CMP_getphysparam();
  Ra.sl[6]=6410; /* line # 6410 */
  Rv2=Rv0;
  Ra.sl[6]=6411; /* line # 6411 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(79,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(Rv2+9,16,(SL)((C *)Rv2)[8],-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv2)[7],6,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6413; /* line # 6413 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " magneticstate "  */
void MXD_CMP_PRC_00000061(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3697;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6424; /* line # 6424 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(87,4,0);
  Ra.sl[6]=6425; /* line # 6425 */
  for( Rf0=32;Rf0>0;Rf0-- ) {
    Ra.sl[6]=6427; /* line # 6427 */
    Rv0=1;
    MXD_CMP_geticte(&Rv0);
    Ra.sl[6]=6428; /* line # 6428 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT((SL)(Rv0!=0),1,0);
  }
  Ra.sl[6]=6430; /* line # 6430 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " optionstate "  */
void MXD_CMP_PRC_00000062(){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3712;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6445; /* line # 6445 */
  Ra.sl[6]=6447; /* line # 6447 */
  MXD_CMP_looksymbol(151,82,1);
  Ra.sl[6]=6448; /* line # 6448 */
  Rv0=0;
  MXD_CMP_geticte(&Rv0);
  Ra.sl[6]=6449; /* line # 6449 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6450; /* line # 6450 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6452; /* line # 6452 */
  Rv1=0;
  while (1){
    Ra.sl[6]=6454; /* line # 6454 */
    Rv1=Rv1+1;
    Ra.f[Rv1+6]=(F)0.000000E-01;
    MXD_CMP_getncte((Ra.f+Rv1+6));
    if (Rv1>=8||Rs.ub[504]==155)  break;
  }
  Ra.sl[6]=6456; /* line # 6456 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(72,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(Rv0,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(Rv1,2,0);
  Ra.sl[6]=6457; /* line # 6457 */
  Rv2=1;
  for( Rf0=Rv1;Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Ra.f[Rv2+6],12,-6,0);
    Rv2++;
  }
  Ra.sl[6]=6458; /* line # 6458 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6459; /* line # 6459 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " soptionstate "  */
void MXD_CMP_PRC_00000063(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3725;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6474; /* line # 6474 */
  Ra.sl[6]=6476; /* line # 6476 */
  MXD_CMP_looksymbol(151,82,1);
  Ra.sl[6]=6477; /* line # 6477 */
  Rv0=0;
  MXD_CMP_geticte(&Rv0);
  Ra.sl[6]=6478; /* line # 6478 */
  MXD_CMP_looksymbol(152,81,1);
  Ra.sl[6]=6479; /* line # 6479 */
  MXD_CMP_looksymbol(50,90,1);
  Ra.sl[6]=6481; /* line # 6481 */
  MXD_CMP_getscte(&Rv1);
  Ra.sl[6]=6482; /* line # 6482 */
  if (Rv1!=NULL) {
    Ra.sl[6]=6483; /* line # 6483 */
    Rv2=Rv1;
    Ra.sl[6]=6485; /* line # 6485 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_INT(73,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv0,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT((SL)((C *)Rv2)[140],4,0);
    PAS__WRITE_EOLN();
    Ra.sl[6]=6486; /* line # 6486 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHT(Rv2+8,132,(SL)((C *)Rv2)[140],-1,32);
  }
  Ra.sl[6]=6488; /* line # 6488 */
  if (Rv1!=NULL) {
    Ra.sl[6]=6490; /* line # 6490 */
    if (Rv0==0) MXD_CMP_copystr(Rs.v,Rv1,0);
  }
  Ra.sl[6]=6491; /* line # 6491 */
  P_st_free(&Rv1);
  Ra.sl[6]=6492; /* line # 6492 */
  PAS__SELECT_OUT(Ri.v[13]);
  PAS__WRITE_EOLN();
  Ra.sl[6]=6493; /* line # 6493 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " close_open "  */
void MXD_CMP_PRC_00000064(V F_f, V F_ps, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3739;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6503; /* line # 6503 */
  Ra.sl[6]=6505; /* line # 6505 */
  if (((UB *)F_f)[16]!=0) {
    Ra.sl[6]=6507; /* line # 6507 */
    P_close_txtfile(((V *)F_f)+1);
    Ra.sl[6]=6508; /* line # 6508 */
    if (((UB *)F_f)[17]) PAS__CLOSE(((V *)F_f),0);
  }
  Ra.sl[6]=6510; /* line # 6510 */
  ((UB *)F_f)[16]=0;
  Ra.sl[6]=6511; /* line # 6511 */
  if (F_ps!=NULL) {
    Ra.sl[6]=6512; /* line # 6512 */
    switch (F_ch) {
      case 78:Ra.sl[6]=6513; /* line # 6513 */
      P_open_listing(((V *)F_f)+1,F_ps+8,132,1);
      ((UB *)F_f)[16]=2;
      break;
      case 87:Ra.sl[6]=6514; /* line # 6514 */
      P_open_listing(((V *)F_f)+1,F_ps+8,132,0);
      ((UB *)F_f)[16]=2;
      break;
      case 65:Ra.sl[6]=6515; /* line # 6515 */
      P_open_listing(((V *)F_f)+1,F_ps+8,132,2);
      ((UB *)F_f)[16]=2;
      break;
      case 82:Ra.sl[6]=6517; /* line # 6517 */
      MXD_CMP_resettxtfile(((V *)F_f)+1,F_ps, &Rv0,((UB *)F_f)+17);
      Ra.sl[6]=6518; /* line # 6518 */
      if (Rv0&&((F *)Rs.v[6])[13]==(F)0.000000E-01) {
        Ra.sl[6]=6520; /* line # 6520 */
        if (((UB *)F_f)[17]) P_openw_txtfile(((V *)F_f),F_ps,1);
        Ra.sl[6]=6521; /* line # 6521 */
        ((UB *)F_f)[16]=1;
      }
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " openfilestate "  */
void MXD_CMP_PRC_00000065(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  C Rv1;
  V Rv2;
  UB Rv3;
  register V Rv4;
  SL Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3751;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6543; /* line # 6543 */
  Rv0=1;
  Rv1=87;
  Ra.sl[6]=6544; /* line # 6544 */
  MXD_CMP_getnumber(&Rv0);
  Ra.sl[6]=6545; /* line # 6545 */
  MXD_CMP_getscte(&Rv2);
  Ra.sl[6]=6546; /* line # 6546 */
  if (Rs.ub[504]==150) {
    Ra.sl[6]=6548; /* line # 6548 */
    MXD_CMP_insymbol();
    Ra.sl[6]=6549; /* line # 6549 */
    if (Rs.ub[505]==0||Rs.ub[505]==1) {
      Ra.sl[6]=6550; /* line # 6550 */
      MXD_CMP_inputletter(&Rv1);
      MXD_CMP_insymbol();
    }
    else {
      Ra.sl[6]=6551; /* line # 6551 */
      MXD_CMP_error(Rd.s+3768,-203);
    }
  }
  Ra.sl[6]=6553; /* line # 6553 */
  switch (Rv1) {
    case 73:
    case 82:
    case 105:
    case 114:Ra.sl[6]=6554; /* line # 6554 */
    Rv1=82;
    break;
    case 78:
    case 110:Ra.sl[6]=6555; /* line # 6555 */
    Rv1=78;
    break;
    case 79:
    case 87:
    case 111:
    case 119:Ra.sl[6]=6556; /* line # 6556 */
    Rv1=87;
    break;
    case 65:
    case 97:Ra.sl[6]=6557; /* line # 6557 */
    Rv1=65;
    break;
    default:Ra.sl[6]=6559; /* line # 6559 */
    MXD_CMP_error(Rd.s+3768,-202);
    break;
  }
  Ra.sl[6]=6561; /* line # 6561 */
  Rv3=0;
  Ra.sl[6]=6562; /* line # 6562 */
  if (Rv2!=NULL) {
    Ra.sl[6]=6563; /* line # 6563 */
    Rv4=Rv2;
    Ra.sl[6]=6564; /* line # 6564 */
    if (((C *)Rv4)[140]!=0) {
      Ra.sl[6]=6566; /* line # 6566 */
      Rv5=1;
      Ra.sl[6]=6567; /* line # 6567 */
      while (Rv5<=(SL)((C *)Rv4)[140]){
        Ra.sl[6]=6568; /* line # 6568 */
        if (((C *)Rv4)[Rv5+7]>95) ((C *)Rv4)[Rv5+7]=(C)((SL)((C *)Rv4)[Rv5+7]-32)
        ;
        Ra.sl[6]=6569; /* line # 6569 */
        Rv5=Rv5+1;
      }
      Ra.sl[6]=6571; /* line # 6571 */
      while (Rv5<=132){
        Ra.sl[6]=6572; /* line # 6572 */
        ((C *)Rv4)[Rv5+7]=32;
        Rv5=Rv5+1;
      }
      Ra.sl[6]=6573; /* line # 6573 */
      Rv3=1;
    }
  }
  Ra.sl[6]=6576; /* line # 6576 */
  if (V_fatalerror) ((F *)Rs.v[6])[13]=(F)-2.000000E+00;
  else {
    Ra.sl[6]=6577; /* line # 6577 */
    ((F *)Rs.v[6])[13]=(F)0.000000E-01;
  }
  Ra.sl[6]=6578; /* line # 6578 */
  if (Rv3&&!V_fatalerror) {
    Ra.sl[6]=6579; /* line # 6579 */
    if (Rv0>=0&&Rv0<=9) {
      Ra.sl[6]=6580; /* line # 6580 */
      MXD_CMP_PRC_00000064((Rs.s+Rv0*24+664),Rv2, Rv1);
    }
    else {
      Ra.sl[6]=6582; /* line # 6582 */
      MXD_CMP_error(Rd.s+3768,-201);
    }
  }
  Ra.sl[6]=6583; /* line # 6583 */
  if (Rv2!=NULL) P_st_free(&Rv2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " closefilestate "  */
void MXD_CMP_PRC_00000066(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3772;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6594; /* line # 6594 */
  Rv0=1;
  Ra.sl[6]=6595; /* line # 6595 */
  MXD_CMP_getnumber(&Rv0);
  Ra.sl[6]=6596; /* line # 6596 */
  if (Rv0>=0&&Rv0<=9) {
    Ra.sl[6]=6597; /* line # 6597 */
    MXD_CMP_PRC_00000064((Rs.s+Rv0*24+664),NULL,32);
  }
  else {
    Ra.sl[6]=6599; /* line # 6599 */
    MXD_CMP_error(Rd.s+3790,201);
  }
  Ra.sl[6]=6600; /* line # 6600 */
  ((F *)Rs.v[6])[13]=(F)0.000000E-01;
  Ra.sl[6]=6601; /* line # 6601 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " boolstate "  */
void MXD_CMP_PRC_00000067(UB F_bool){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3794;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6615; /* line # 6615 */
  Rv0=1;
  MXD_CMP_geticte(&Rv0);
  Ra.sl[6]=6616; /* line # 6616 */
  MXD_CMP_looksemicol(1);
  Ra.sl[6]=6617; /* line # 6617 */
  if (F_bool==80) Ri.ub[96]=Rv0>0;
  Ra.sl[6]=6618; /* line # 6618 */
  if (F_bool==109) Ri.ub[95]=Rv0>0;
  else {
    Ra.sl[6]=6621; /* line # 6621 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT((SL)F_bool,4,0);
    PAS__WRITE_CHAR(32);
    Ra.sl[6]=6622; /* line # 6622 */
    PAS__SELECT_OUT(Ri.v[13]);
    PAS__WRITE_INT((SL)(Rv0>0),2,0);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skprds "  */
void MXD_CMP_PRC_00000069(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3805;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6640; /* line # 6640 */
  Rv0=Rs.v[66];
  Ra.sl[6]=6641; /* line # 6641 */
  if (((UB *)Rv0)[49]==1) {
    Ra.sl[6]=6642; /* line # 6642 */
    Rv1=((V *)Rv0)[7];
    Ra.sl[6]=6644; /* line # 6644 */
    Lx[7].sl[0]=1;
    Ra.sl[6]=6645; /* line # 6645 */
    if (PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))) {
      PAS__SELECT_INP((*F_f));
      PAS__READ_EOLN();
    }
    Ra.sl[6]=6646; /* line # 6646 */
    Lx[7].c[4]=32;
    Ra.sl[6]=6647; /* line # 6647 */
    while ((Lx[7].c[4]==32&&!PAS__EOLN((*F_f)))&&!PAS__EOF((*F_f))){
      PAS__SELECT_INP((*F_f));
      PAS__READ_CHAR(Lx[7].c+4);
    }
    Ra.sl[6]=6648; /* line # 6648 */
    while (!PAS__EOF((*F_f))&&!PAS__EOLN((*F_f))){
      Ra.sl[6]=6650; /* line # 6650 */
      ((C *)Rv1)[Lx[7].sl[0]+7]=Lx[7].c[4];
      Lx[7].sl[0]=Lx[7].sl[0]+1;
      PAS__SELECT_INP((*F_f));
      PAS__READ_CHAR(Lx[7].c+4);
    }
    Ra.sl[6]=6652; /* line # 6652 */
    ((C *)Rv1)[Lx[7].sl[0]+7]=Lx[7].c[4];
    Ra.sl[6]=6653; /* line # 6653 */
    ((C *)Rv1)[140]=(C)Lx[7].sl[0];
  }
  else {
    Ra.sl[6]=6656; /* line # 6656 */
    if (((UB *)Rv0)[49]==2) {
      Ra.sl[6]=6658; /* line # 6658 */
      if (PAS__EOLN((*F_f))) {
        PAS__SELECT_INP((*F_f));
        PAS__READ_EOLN();
      }
      Ra.sl[6]=6659; /* line # 6659 */
      if (!PAS__EOF((*F_f))&&!PAS__EOLN((*F_f))) {
        PAS__SELECT_INP((*F_f));
        PAS__READ_SNGL(((F *)Rv0)+13,0);
      }
    }
    else {
      Ra.sl[6]=6660; /* line # 6660 */
      MXD_CMP_error(Rd.s+3815,73);
    }
  }
  Ra.sl[6]=6661; /* line # 6661 */
  if (PAS__EOF((*F_f))) ((F *)Rs.v[6])[13]=(F)-1.000000E+00;
  else {
    Ra.sl[6]=6662; /* line # 6662 */
    ((F *)Rs.v[6])[13]=(F)0.000000E-01;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " replystate "  */
void MXD_CMP_PRC_00000068(UB F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;
  register P Lx_Sv;
  Lx_Sv=Lx[7];
  Lx[7].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+3819;
  Ra.v[3]=Rd.s+12;
  Ra.sl[8]=6667; /* line # 6667 */
  Rv0=1;
  Ra.sl[8]=6668; /* line # 6668 */
  if (F_nd==130) {
    Ra.sl[8]=6670; /* line # 6670 */
    MXD_CMP_getnumber(&Rv0);
    Ra.sl[8]=6671; /* line # 6671 */
    if (Rv0<0||Rv0>9) MXD_CMP_error(Rd.s+3815,-201);
    else {
      Ra.sl[8]=6673; /* line # 6673 */
      if (Rs.ub[Rv0*24+680]!=1) MXD_CMP_error(Rd.s+3815,-204);
    }
  }
  Ra.sl[8]=6675; /* line # 6675 */
  Rv1=0;
  Ra.sl[8]=6676; /* line # 6676 */
  if (!V_fatalerror) {
    Ra.sl[8]=6677; /* line # 6677 */
    while (1){
      Ra.sl[8]=6679; /* line # 6679 */
      if (Rs.ub[505]!=0) MXD_CMP_error(Rd.s+3815,61);
      else {
        Ra.sl[8]=6680; /* line # 6680 */
        if (Rs.v[66]==NULL) MXD_CMP_error(Rd.s+3815,51);
        else {
          Ra.sl[8]=6681; /* line # 6681 */
          Rv2=Rs.v[66];
          Ra.sl[8]=6682; /* line # 6682 */
          if (((UB *)Rv2)[48]!=10) MXD_CMP_error(Rd.s+3815,73);
          else {
            Ra.sl[8]=6683; /* line # 6683 */
            if (F_nd==130) {
              Ra.sl[8]=6684; /* line # 6684 */
              Rv3=(Rs.s+Rv0*24+664);
              Ra.sl[8]=6685; /* line # 6685 */
              if (((UB *)Rv3)[17]) MXD_CMP_PRC_00000069(&PAS__f_input);
              else {
                Ra.sl[8]=6686; /* line # 6686 */
                MXD_CMP_PRC_00000069(((V *)Rv3)+1);
              }
            }
            else {
              Ra.sl[8]=6688; /* line # 6688 */
              MXD_CMP_PRC_00000069(&PAS__f_input);
            }
          }
        }
      }
      Ra.sl[8]=6689; /* line # 6689 */
      MXD_CMP_insymbol();
      Ra.sl[8]=6690; /* line # 6690 */
      if (Rs.ub[504]==150) MXD_CMP_insymbol();
      else Rv1=1;
      if (Rv1)  break;
    }
  }
  Ra.sl[8]=6692; /* line # 6692 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[1];
  Lx[7]=Lx_Sv;
}


/* Procedure/Function : " out_on_file "  */
void MXD_CMP_PRC_00000071(UB F_nd, V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3831;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6716; /* line # 6716 */
  Rv0=F_s;
  Ra.sl[6]=6717; /* line # 6717 */
  switch (F_nd) {
    case 124:Ra.sl[6]=6718; /* line # 6718 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHT(Rv0+8,132,(SL)((C *)Rv0)[140],-1,32);
    break;
    case 123:Ra.sl[6]=6719; /* line # 6719 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHT(Rv0+8,132,(SL)((C *)Rv0)[140],-1,32);
    break;
    case 128:
    case 129:Ra.sl[6]=6721; /* line # 6721 */
    Rv1=(Rs.s+Lx[8].sl[0]*24+664);
    Ra.sl[6]=6722; /* line # 6722 */
    if (((UB *)Rv1)[17]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHT(Rv0+8,132,(SL)((C *)Rv0)[140],-1,32);
    }
    else {
      Ra.sl[6]=6723; /* line # 6723 */
      PAS__SELECT_OUT(((V *)Rv1)[1]);
      PAS__WRITE_CHT(Rv0+8,132,(SL)((C *)Rv0)[140],-1,32);
    }
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " displaystate "  */
void MXD_CMP_PRC_00000070(UB F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  register F Rgf;
  register P Lx_Sv;
  Lx_Sv=Lx[8];
  Lx[8].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+3844;
  Ra.v[3]=Rd.s+12;
  Ra.sl[8]=6729; /* line # 6729 */
  Ra.sl[0]=0;
  Ra.sl[8]=6730; /* line # 6730 */
  if (F_nd==123) MXD_CMP_newlinelst();
  else {
    Ra.sl[8]=6731; /* line # 6731 */
    if (F_nd==124) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[8]=6734; /* line # 6734 */
      Ra.sl[0]=1;
      Ra.sl[8]=6735; /* line # 6735 */
      MXD_CMP_getnumber(Ra.sl);
      Ra.sl[8]=6736; /* line # 6736 */
      if (Ra.sl[0]<1||Ra.sl[0]>9) MXD_CMP_error(Rd.s+3860,-201);
      else {
        Ra.sl[8]=6738; /* line # 6738 */
        if (Rs.ub[Ra.sl[0]*24+680]!=2) MXD_CMP_error(Rd.s+3860,-205);
      }
    }
  }
  Ra.sl[8]=6741; /* line # 6741 */
  if (!V_fatalerror) {
    Ra.sl[8]=6742; /* line # 6742 */
    while (1){
      Ra.sl[8]=6744; /* line # 6744 */
      if (Rs.ub[504]==150) MXD_CMP_insymbol();
      Ra.sl[8]=6745; /* line # 6745 */
      MXD_CMP_expression();
      Ra.sl[8]=6746; /* line # 6746 */
      Ra.sl[8]=6747; /* line # 6747 */
      switch (Rs.ub[907]) {
        case 2:Ra.sl[8]=6750; /* line # 6750 */
        Rv0=Rs.f[228];
        Rv1=0;
        Rv2=0;
        Rv3=0;
        Ra.sl[8]=6751; /* line # 6751 */
        MXD_CMP_getnumber(&Rv3);
        MXD_CMP_getnumber(&Rv2);
        MXD_CMP_getnumber(&Rv1);
        Ra.sl[8]=6752; /* line # 6752 */
        Rv4=P_st_create();
        Ra.sl[8]=6755; /* line # 6755 */
        if (Rv3==0) {
          Ra.sl[8]=6756; /* line # 6756 */
          if (Rv2==0) P_st_put_fixed(Rv4,Rv0,16,7, Rv1);
          else {
            Ra.sl[8]=6757; /* line # 6757 */
            P_st_put_float(Rv4,Rv0,16,1,7,2);
          }
        }
        else {
          Ra.sl[8]=6759; /* line # 6759 */
          if (Rv2==0) P_st_put_int(Rv4,(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5)),Rv3);
          else {
            Ra.sl[8]=6760; /* line # 6760 */
            P_st_put_fixed(Rv4,Rv0, Rv3, Rv2, Rv1);
          }
        }
        Ra.sl[8]=6761; /* line # 6761 */
        MXD_CMP_PRC_00000071(F_nd, Rv4);
        Ra.sl[8]=6762; /* line # 6762 */
        P_st_free(&Rv4);
        break;
        case 1:Ra.sl[8]=6767; /* line # 6767 */
        if (Rs.v[114]!=NULL) {
          Ra.sl[8]=6769; /* line # 6769 */
          if (((C *)Rs.v[114])[140]!=0) MXD_CMP_PRC_00000071(F_nd, Rs.v[114]);
          Ra.sl[8]=6770; /* line # 6770 */
          P_st_free(Rs.v+114);
        }
        break;
        default:Ra.sl[8]=6774; /* line # 6774 */
        MXD_CMP_error(Rd.s+3860,74);
        break;
      }
      if (Rs.ub[504]!=150)  break;
    }
  }
  Ra.sl[8]=6778; /* line # 6778 */
  if (F_nd==124) {
    Ra.sl[8]=6780; /* line # 6780 */
    if (Rs.ub[504]==125) {
      Ra.sl[8]=6782; /* line # 6782 */
      MXD_CMP_insymbol();
      MXD_CMP_PRC_00000068(125);
    }
    else {
      Ra.sl[8]=6786; /* line # 6786 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
      Ra.sl[8]=6787; /* line # 6787 */
      MXD_CMP_looksemicol(1);
    }
  }
  else {
    Ra.sl[8]=6791; /* line # 6791 */
    if (F_nd==123) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[8]=6793; /* line # 6793 */
      if (F_nd==129) {
        Ra.sl[8]=6794; /* line # 6794 */
        Rv5=(Rs.s+Ra.sl[0]*24+664);
        Ra.sl[8]=6795; /* line # 6795 */
        if (((UB *)Rv5)[17]) {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_EOLN();
        }
        else {
          Ra.sl[8]=6796; /* line # 6796 */
          PAS__SELECT_OUT(((V *)Rv5)[1]);
          PAS__WRITE_EOLN();
        }
      }
    }
    Ra.sl[8]=6797; /* line # 6797 */
    if (V_fatalerror) ((F *)Rs.v[6])[13]=(F)0.000000E-01;
    else {
      Ra.sl[8]=6798; /* line # 6798 */
      ((F *)Rs.v[6])[13]=(F)-2.000000E+00;
    }
    Ra.sl[8]=6799; /* line # 6799 */
    MXD_CMP_looksemicol(1);
  }
  PAS__curr_cntx=Ra.v[1];
  Lx[8]=Lx_Sv;
}


/* Procedure/Function : " setrunappl "  */
void MXD_CMP_PRC_00000072(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3864;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6810; /* line # 6810 */
  MXD_CMP_getscte(&Rv0);
  Ra.sl[6]=6811; /* line # 6811 */
  if (Rv0!=NULL) {
    Ra.sl[6]=6812; /* line # 6812 */
    Rv1=Rv0;
    Ra.sl[6]=6814; /* line # 6814 */
    Ri.ub[137]=(SL)((C *)Rv1)[140];
    Ra.sl[6]=6815; /* line # 6815 */
    Rv2=1;
    for( Rf0=Ri.ub[137];Rf0>0;Rf0-- ) {
      Ri.c[Rv2+137]=((C *)Rv1)[Rv2+7];
      Rv2++;
    }
  }
  Ra.sl[6]=6817; /* line # 6817 */
  P_st_free(&Rv0);
  Ra.sl[6]=6818; /* line # 6818 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " setlisting "  */
void MXD_CMP_PRC_00000073(){
  /* Define the automatic variable space. */
  Blk( Ra, 168 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=132;
  Ra.v[17]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+136;
  Ra.v[18]=Rd.s+3876;
  Ra.v[19]=Rd.s+12;
  Ra.sl[40]=6831; /* line # 6831 */
  MXD_CMP_getscte(&Rv0);
  Ra.sl[40]=6832; /* line # 6832 */
  if (Rv0!=NULL) {
    Ra.sl[40]=6834; /* line # 6834 */
    Rv1=Rv0;
    Ra.sl[40]=6836; /* line # 6836 */
    Rv2=1;
    for( Rf0=(SL)((C *)Rv1)[140];Rf0>0;Rf0-- ) {
      Ra.c[Rv2+1]=((C *)Rv1)[Rv2+7];
      Rv2++;
    }
    Ra.sl[40]=6837; /* line # 6837 */
    Ra.ub[1]=(SL)((C *)Rv1)[140];
    Ra.sl[40]=6839; /* line # 6839 */
    P_st_free(&Rv0);
    Ra.sl[40]=6840; /* line # 6840 */
    PAS__CLOSE(&V_lst,0);
    Ra.sl[40]=6841; /* line # 6841 */
    P_open_listing(&V_lst, Ra.s+2,(SL)Ra.ub[1],1);
    Ra.sl[40]=6842; /* line # 6842 */
    V_linewrt=55;
    Ra.sl[40]=6843; /* line # 6843 */
    V_pagenb=0;
  }
  Ra.sl[40]=6845; /* line # 6845 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[17];
}


/* Procedure/Function : " spawn_task "  */
void MXD_CMP_PRC_00000074(){
  /* Define the automatic variable space. */
  Blk( Ra, 168 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=132;
  Ra.v[17]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+136;
  Ra.v[18]=Rd.s+3888;
  Ra.v[19]=Rd.s+12;
  Ra.sl[40]=6858; /* line # 6858 */
  MXD_CMP_getscte(&Rv0);
  Ra.sl[40]=6859; /* line # 6859 */
  if (Rv0!=NULL) {
    Ra.sl[40]=6861; /* line # 6861 */
    Rv1=Rv0;
    Ra.sl[40]=6863; /* line # 6863 */
    Rv2=1;
    for( Rf0=(SL)((C *)Rv1)[140];Rf0>0;Rf0-- ) {
      Ra.c[Rv2+1]=((C *)Rv1)[Rv2+7];
      Rv2++;
    }
    Ra.sl[40]=6864; /* line # 6864 */
    Ra.ub[1]=(SL)((C *)Rv1)[140];
    Ra.sl[40]=6866; /* line # 6866 */
    P_st_free(&Rv0);
    Ra.sl[40]=6867; /* line # 6867 */
    Rv3=PAS__SYSTEM(Ra.s);
  }
  Ra.sl[40]=6869; /* line # 6869 */
  MXD_CMP_looksemicol(1);
  PAS__curr_cntx=Ra.v[17];
}


/* Procedure/Function : " errorstate "  */
void MXD_CMP_PRC_00000075(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3900;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=6880; /* line # 6880 */
  Ri.ub[8]=1;
  Ra.sl[6]=6881; /* line # 6881 */
  MXD_CMP_error(Rd.s+3914,-999);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement "  */
void MXD_CMP_PRC_00000015(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register P Lx_Sv;
  Lx_Sv=Lx[9];
  Lx[9].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+3918;
  Ra.v[4]=Rd.s+12;
  Ra.sl[10]=6886; /* line # 6886 */
  Rs.sl[5]=Rs.sl[5]+1;
  Ra.sl[10]=6887; /* line # 6887 */
  Ra.sl[10]=6888; /* line # 6888 */
  if (Rs.ub[505]==7) {
    Ra.sl[10]=6890; /* line # 6890 */
    MXD_CMP_PRC_00000028();
    Ra.sl[10]=6891; /* line # 6891 */
    Lx[10].ub[0]=Rs.ub[504];
  }
  else {
    Ra.sl[10]=6893; /* line # 6893 */
    if (Rs.ub[505]==0) {
      Ra.sl[10]=6895; /* line # 6895 */
      if (Rs.v[66]!=NULL) {
        Ra.sl[10]=6897; /* line # 6897 */
        memcpy(Ra.s,Rs.s+507,16);
        Ra.sl[10]=6898; /* line # 6898 */
        Rs.v[4]=Rs.v[66];
        Ra.sl[10]=6899; /* line # 6899 */
        Rv0=Rs.v[66];
        Ra.sl[10]=6900; /* line # 6900 */
        Rv1=Rv0;
        Ra.sl[10]=6901; /* line # 6901 */
        if (((UB *)Rv1)[48]==4) {
          Ra.sl[10]=6905; /* line # 6905 */
          if (((UB *)Rv1)[49]!=110) MXD_CMP_insymbol();
          Ra.sl[10]=6906; /* line # 6906 */
          switch (((UB *)Rv1)[49]) {
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:Ra.sl[10]=6908; /* line # 6908 */
            MXD_CMP_error(Rd.s+3931,68);
            MXD_CMP_insymbol();
            break;
            case 103:Ra.sl[10]=6910; /* line # 6910 */
            MXD_CMP_pragmastate(0);
            break;
            case 100:
            case 101:Ra.sl[10]=6912; /* line # 6912 */
            MXD_CMP_PRC_00000026(((UB *)Rv1)[49]);
            break;
            case 113:Ra.sl[10]=6913; /* line # 6913 */
            MXD_CMP_PRC_00000025();
            break;
            case 77:Ra.sl[10]=6914; /* line # 6914 */
            MXD_CMP_PRC_00000031();
            break;
            case 106:Ra.sl[10]=6915; /* line # 6915 */
            MXD_CMP_PRC_00000039();
            break;
            case 88:Ra.sl[10]=6916; /* line # 6916 */
            MXD_CMP_PRC_00000040();
            break;
            case 3:Ra.sl[10]=6917; /* line # 6917 */
            MXD_CMP_PRC_00000041();
            break;
            case 2:Ra.sl[10]=6918; /* line # 6918 */
            MXD_CMP_PRC_00000045();
            break;
            case 86:Ra.sl[10]=6919; /* line # 6919 */
            MXD_CMP_PRC_00000048();
            break;
            case 85:Ra.sl[10]=6920; /* line # 6920 */
            MXD_CMP_PRC_00000052();
            break;
            case 65:
            case 66:Ra.sl[10]=6921; /* line # 6921 */
            MXD_CMP_PRC_00000050(((UB *)Rv1)[49]==65);
            break;
            case 67:Ra.sl[10]=6922; /* line # 6922 */
            MXD_CMP_PRC_00000051();
            break;
            case 64:
            case 104:Ra.sl[10]=6923; /* line # 6923 */
            MXD_CMP_PRC_00000053(((UB *)Rv1)[49]==104);
            break;
            case 69:Ra.sl[10]=6924; /* line # 6924 */
            MXD_CMP_PRC_00000056();
            break;
            case 70:Ra.sl[10]=6925; /* line # 6925 */
            MXD_CMP_PRC_00000057();
            break;
            case 71:Ra.sl[10]=6926; /* line # 6926 */
            MXD_CMP_PRC_00000058();
            break;
            case 68:Ra.sl[10]=6927; /* line # 6927 */
            MXD_CMP_PRC_00000059();
            break;
            case 79:Ra.sl[10]=6928; /* line # 6928 */
            MXD_CMP_PRC_00000060();
            break;
            case 80:
            case 82:
            case 109:Ra.sl[10]=6931; /* line # 6931 */
            MXD_CMP_PRC_00000067(((UB *)Rv1)[49]);
            break;
            case 87:Ra.sl[10]=6932; /* line # 6932 */
            MXD_CMP_PRC_00000061();
            break;
            case 102:Ra.sl[10]=6933; /* line # 6933 */
            MXD_CMP_PRC_00000028();
            break;
            case 83:
            case 84:Ra.sl[10]=6935; /* line # 6935 */
            MXD_CMP_PRC_00000047(((UB *)Rv1)[49]);
            break;
            case 105:Ra.sl[10]=6936; /* line # 6936 */
            MXD_CMP_PRC_00000046();
            break;
            case 72:Ra.sl[10]=6937; /* line # 6937 */
            MXD_CMP_PRC_00000062();
            break;
            case 73:Ra.sl[10]=6938; /* line # 6938 */
            MXD_CMP_PRC_00000063();
            break;
            case 90:Ra.sl[10]=6939; /* line # 6939 */
            MXD_CMP_PRC_00000017();
            break;
            case 110:Ra.sl[10]=6940; /* line # 6940 */
            MXD_CMP_PRC_00000020();
            break;
            case 112:Ra.sl[10]=6941; /* line # 6941 */
            MXD_CMP_PRC_00000021();
            break;
            case 107:Ra.sl[10]=6942; /* line # 6942 */
            MXD_CMP_PRC_00000027();
            break;
            case 108:Ra.sl[10]=6943; /* line # 6943 */
            MXD_CMP_PRC_00000029();
            break;
            case 120:Ra.sl[10]=6944; /* line # 6944 */
            MXD_CMP_PRC_00000022();
            break;
            case 111:Ra.sl[10]=6945; /* line # 6945 */
            MXD_CMP_PRC_00000024();
            break;
            case 126:Ra.sl[10]=6946; /* line # 6946 */
            MXD_CMP_PRC_00000065();
            break;
            case 127:Ra.sl[10]=6947; /* line # 6947 */
            MXD_CMP_PRC_00000066();
            break;
            case 123:
            case 124:
            case 128:
            case 129:Ra.sl[10]=6951; /* line # 6951 */
            MXD_CMP_PRC_00000070(((UB *)Rv1)[49]);
            break;
            case 125:
            case 130:Ra.sl[10]=6952; /* line # 6952 */
            MXD_CMP_PRC_00000068(((UB *)Rv1)[49]);
            break;
            case 131:Ra.sl[10]=6953; /* line # 6953 */
            MXD_CMP_PRC_00000072();
            break;
            case 132:Ra.sl[10]=6954; /* line # 6954 */
            MXD_CMP_PRC_00000073();
            break;
            case 133:Ra.sl[10]=6955; /* line # 6955 */
            MXD_CMP_PRC_00000074();
            break;
            case 122:Ra.sl[10]=6956; /* line # 6956 */
            MXD_CMP_PRC_00000075();
            break;
          }
          Ra.sl[10]=6958; /* line # 6958 */
          if (V_fatalerror) MXD_CMP_skip(155,0);
        }
        else {
          Ra.sl[10]=6961; /* line # 6961 */
          if (((UB *)Rv1)[48]==10||((UB *)Rv1)[48]==12) {
            Ra.sl[10]=6962; /* line # 6962 */
            MXD_CMP_PRC_00000042(0);
          }
          else {
            Ra.sl[10]=6964; /* line # 6964 */
            if (((UB *)Rv1)[48]==11) MXD_CMP_PRC_00000049();
            else {
              Ra.sl[10]=6966; /* line # 6966 */
              if (((UB *)Rv1)[48]==3) MXD_CMP_PRC_00000023();
              else {
                Ra.sl[10]=6968; /* line # 6968 */
                MXD_CMP_error(Rd.s+3931,66);
                MXD_CMP_skip(155,1);
              }
            }
          }
        }
        Ra.sl[10]=6969; /* line # 6969 */
        Lx[10].ub[0]=Rs.ub[504];
      }
      else {
        Ra.sl[10]=6972; /* line # 6972 */
        MXD_CMP_error(Rd.s+3931,66);
        MXD_CMP_skip(155,1);
      }
    }
    else {
      Ra.sl[10]=6976; /* line # 6976 */
      MXD_CMP_looksemicol(1);
      Ra.sl[10]=6977; /* line # 6977 */
      Lx[10].ub[0]=Rs.ub[504];
    }
  }
  PAS__curr_cntx=Ra.v[2];
  Lx[9]=Lx_Sv;
}


/* Procedure/Function : " statelist "  */
void MXD_CMP_statelist(UB F_stopper){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[10];
  Lx[10].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+3935;
  Ra.v[3]=Rd.s+12;
  Ra.sl[8]=6984; /* line # 6984 */
  Ra.ub[0]=Rs.ub[504];
  Ra.sl[8]=6985; /* line # 6985 */
  while ((Ra.ub[0]!=F_stopper&&!Ri.ub[8])&&(Ra.ub[0]!=116||F_stopper!=119)){
    Ra.sl[8]=6987; /* line # 6987 */
    MXD_CMP_PRC_00000015();
  }
  Ra.sl[8]=6988; /* line # 6988 */
  Rs.ub[992]=Ra.ub[0];
  Ra.sl[8]=6989; /* line # 6989 */
  MXD_CMP_insymbol();
  PAS__curr_cntx=Ra.v[1];
  Lx[10]=Lx_Sv;
}


/* Procedure/Function : " writecpu "  */
void MXD_CMP_writecpu(SL F_ti){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  F Rv4;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3946;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=7005; /* line # 7005 */
  Rv0=PAS__I_MOD(F_ti,1000);
  F_ti=F_ti/1000;
  Ra.sl[6]=7006; /* line # 7006 */
  Rv1=PAS__I_MOD(F_ti,60);
  F_ti=F_ti/60;
  Ra.sl[6]=7007; /* line # 7007 */
  Rv2=PAS__I_MOD(F_ti,60);
  F_ti=F_ti/60;
  Ra.sl[6]=7008; /* line # 7008 */
  Rv3=PAS__I_MOD(F_ti,24);
  F_ti=F_ti/24;
  Ra.sl[6]=7009; /* line # 7009 */
  if (F_ti>0) {
    Ra.sl[6]=7011; /* line # 7011 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_INT(F_ti,2,0);
    PAS__WRITE_STR(Rd.s+3956,-1,-1,32);
    Ra.sl[6]=7012; /* line # 7012 */
    if (F_ti>=2) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(115);
    }
    Ra.sl[6]=7013; /* line # 7013 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+3962,-1,-1,32);
  }
  Ra.sl[6]=7015; /* line # 7015 */
  if (Rv3>0) {
    Ra.sl[6]=7017; /* line # 7017 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_INT(Rv3,2,0);
    PAS__WRITE_STR(Rd.s+3966,-1,-1,32);
    Ra.sl[6]=7018; /* line # 7018 */
    if (Rv3>=2) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(115);
    }
    Ra.sl[6]=7019; /* line # 7019 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+3962,-1,-1,32);
  }
  Ra.sl[6]=7021; /* line # 7021 */
  if (Rv2>0) {
    Ra.sl[6]=7023; /* line # 7023 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_INT(Rv2,2,0);
    PAS__WRITE_STR(Rd.s+3973,-1,-1,32);
    Ra.sl[6]=7024; /* line # 7024 */
    if (Rv2>=2) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(115);
    }
    Ra.sl[6]=7025; /* line # 7025 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+3962,-1,-1,32);
  }
  Ra.sl[6]=7027; /* line # 7027 */
  Rv4=(float)Rv1+(float)Rv0/(F)1.000000E+03;
  Ra.sl[6]=7028; /* line # 7028 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_SNGL(Rv4,7,3,0);
  PAS__WRITE_STR(Rd.s+3982,-1,-1,32);
  Ra.sl[6]=7029; /* line # 7029 */
  if (Rv4>=(F)2.000000E+00) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(115);
  }
  Ra.sl[6]=7030; /* line # 7030 */
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_CHAR(46);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " genspace "  */
void MXD_CMP_genspace(){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  UB Rv8;
  UB Rv9;
  UB Rv10;
  V Rv11;
  register V Rv12;
  SL Rv13;
  SL Rv14;
  register V Rv15;
  SL Rv16;
  SL Rv17;
  SL Rv18;
  register int Rgi;
  register int Rgj;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3991;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=7043; /* line # 7043 */
  Rv0=NULL;
  Ra.sl[6]=7044; /* line # 7044 */
  Rv1=Rs.v[80];
  Ra.sl[6]=7045; /* line # 7045 */
  while (Rv1!=NULL){
    Ra.sl[6]=7047; /* line # 7047 */
    Rv2=Rv1;
    Ra.sl[6]=7048; /* line # 7048 */
    Rv3=Rv1;
    Ra.sl[6]=7049; /* line # 7049 */
    while (Rv2!=NULL){
      Ra.sl[6]=7051; /* line # 7051 */
      Rv4=0;
      Ra.sl[6]=7053; /* line # 7053 */
      Rv5=1;
      for( Rf2=3;Rf2>0;Rf2-- ) {
        Rv6=1;
        for( Rf1=3;Rf1>0;Rf1-- ) {
          Ra.sl[6]=7055; /* line # 7055 */
          Ra.sl[Rv5*4+Rv6+2]=0;
          Ra.sl[6]=7056; /* line # 7056 */
          Rv7=1;
          for( Rf0=3;Rf0>0;Rf0-- ) {
            Ra.sl[6]=7057; /* line # 7057 */
            Ra.sl[Rv5*4+Rv6+2]=Ra.sl[Rv5*4+Rv6+2]+((SL *)Rv3)[Rv5*4+Rv7+3]*((SL *)
            Rv2)[Rv7*4+Rv6+3];
            Rv7++;
          }
          Ra.sl[6]=7058; /* line # 7058 */
          if (Ra.sl[Rv5*4+Rv6+2]!=0) Rv4=Rv4+1;
          Rv6++;
        }
        Rv5++;
      }
      Ra.sl[6]=7060; /* line # 7060 */
      Rv8=0;
      Rv9=0;
      Ra.sl[6]=7061; /* line # 7061 */
      if (Rv4==3) {
        Ra.sl[6]=7062; /* line # 7062 */
        if (abs(Ra.sl[7])==1) {
          Ra.sl[6]=7063; /* line # 7063 */
          if (Ra.sl[7]==Ra.sl[12]) {
            Ra.sl[6]=7064; /* line # 7064 */
            if (Ra.sl[7]==Ra.sl[17]) {
              Ra.sl[6]=7065; /* line # 7065 */
              if (Ra.sl[7]>0) Rv9=1;
              else {
                Ra.sl[6]=7066; /* line # 7066 */
                Rv8=1;
              }
            }
          }
        }
      }
      Ra.sl[6]=7067; /* line # 7067 */
      Rv10=Ri.ub[96]&&Rv8;
      Ra.sl[6]=7068; /* line # 7068 */
      Rv11=Rs.v[80];
      Ra.sl[6]=7069; /* line # 7069 */
      while (Rv11!=NULL&&!Rv10){
        Ra.sl[6]=7071; /* line # 7071 */
        Rv12=Rv11;
        Ra.sl[6]=7074; /* line # 7074 */
        Rv13=0;
        Rv14=1;
        while (1){
          Ra.sl[6]=7076; /* line # 7076 */
          Rv13=Rv13+1;
          Ra.sl[6]=7077; /* line # 7077 */
          if (Rv13>3) {
            Ra.sl[6]=7078; /* line # 7078 */
            Rv13=1;
            Rv14=Rv14+1;
          }
          if (Rv14>3||Ra.sl[Rv13*4+Rv14+2]!=((SL *)Rv12)[Rv13*4+Rv14+3])  break;
        }
        Ra.sl[6]=7080; /* line # 7080 */
        if (Rv14<4&&Ri.ub[96]) {
          Ra.sl[6]=7082; /* line # 7082 */
          Rv13=0;
          Rv14=1;
          while (1){
            Ra.sl[6]=7084; /* line # 7084 */
            Rv13=Rv13+1;
            Ra.sl[6]=7085; /* line # 7085 */
            if (Rv13>3) {
              Ra.sl[6]=7086; /* line # 7086 */
              Rv13=1;
              Rv14=Rv14+1;
            }
            if (Rv14>3||Ra.sl[Rv13*4+Rv14+2]!= -((SL *)Rv12)[Rv13*4+Rv14+3])  break;
          }
        }
        Ra.sl[6]=7090; /* line # 7090 */
        if (Rv14==4) Rv10=1;
        else {
          Ra.sl[6]=7092; /* line # 7092 */
          Rv0=Rv11;
          Ra.sl[6]=7093; /* line # 7093 */
          Rv11=((V *)Rv11)[0];
        }
      }
      Ra.sl[6]=7096; /* line # 7096 */
      if (!Rv10) {
        Ra.sl[6]=7098; /* line # 7098 */
        Rv11=PAS__NEW(80);
        Ra.sl[6]=7099; /* line # 7099 */
        Rv15=Rv11;
        Ra.sl[6]=7101; /* line # 7101 */
        if (Rv9) {
          Ra.sl[6]=7103; /* line # 7103 */
          ((V *)Rv15)[0]=Rs.v[80];
          Rs.v[80]=Rv11;
          Ra.sl[6]=7104; /* line # 7104 */
          ((SL *)Rv15)[7]=-1;
          PAS__CHT_TO_CHT(Rv15+9,16, Rd.s+4003,8);
          ((C *)Rv15)[8]=8;
        }
        else {
          Ra.sl[6]=7108; /* line # 7108 */
          ((V *)Rv0)[0]=Rv11;
          ((V *)Rv15)[0]=NULL;
          ((SL *)Rv15)[7]=Rs.sl[146];
          Ra.sl[6]=7109; /* line # 7109 */
          Rs.sl[146]=Rs.sl[146]+1;
          Ra.sl[6]=7110; /* line # 7110 */
          if (Rv8) PAS__CHT_TO_CHT(Rv15+9,16, Rd.s+4013,8);
          else PAS__CHT_TO_CHT(Rv15+9,16, Rd.s+4023,8);
          Ra.sl[6]=7111; /* line # 7111 */
          ((C *)Rv15)[8]=8;
        }
        Ra.sl[6]=7113; /* line # 7113 */
        if (((SL *)Rv15)[7]>=48) {
          Ra.sl[6]=7115; /* line # 7115 */
          MXD_CMP_error(Rd.s+4033,-181);
          Ra.sl[6]=7116; /* line # 7116 */
          ((V *)Rv2)[0]=NULL;
          ((V *)Rv1)[0]=NULL;
        }
        Ra.sl[6]=7118; /* line # 7118 */
        memcpy(Rv15+32,Ra.s+28,48);
        Ra.sl[6]=7119; /* line # 7119 */
        PAS__SELECT_OUT(Ri.v[13]);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(71,4,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_CHT(Rv15+9,16,(SL)((C *)Rv15)[8],-1,32);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(((SL *)Rv15)[7],6,0);
        Ra.sl[6]=7121; /* line # 7121 */
        Rv16=1;
        for( Rf2=3;Rf2>0;Rf2-- ) {
          Ra.sl[6]=7123; /* line # 7123 */
          Rv17=1;
          for( Rf1=3;Rf1>0;Rf1-- ) {
            PAS__SELECT_OUT(Ri.v[13]);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_INT(((SL *)Rv15)[Rv16*4+Rv17+3],3,0);
            Rv17++;
          }
          Ra.sl[6]=7124; /* line # 7124 */
          ((SL *)Rv15)[Rv16*4+7]=((SL *)Rv1)[Rv16*4+7];
          Ra.sl[6]=7125; /* line # 7125 */
          Rv18=1;
          for( Rf1=3;Rf1>0;Rf1-- ) {
            Ra.sl[6]=7126; /* line # 7126 */
            ((SL *)Rv15)[Rv16*4+7]=((SL *)Rv15)[Rv16*4+7]+((SL *)Rv1)[Rv16*4+Rv18+
3]*((SL *)Rv2)[Rv18*4+7];
            Rv18++;
          }
          Ra.sl[6]=7127; /* line # 7127 */
          ((SL *)Rv15)[Rv16*4+7]=PAS__I_MOD(((SL *)Rv15)[Rv16*4+7],12);
          Ra.sl[6]=7128; /* line # 7128 */
          PAS__SELECT_OUT(Ri.v[13]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)Rv15)[Rv16*4+7],3,0);
          Rv16++;
        }
        Ra.sl[6]=7130; /* line # 7130 */
        MXD_CMP_putransope(Ra.s+28);
      }
      Ra.sl[6]=7133; /* line # 7133 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=7135; /* line # 7135 */
    Rv1=((V *)Rv1)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " summary "  */
void MXD_CMP_summary(){
  /* Define the automatic variable space. */
  Blk( Ra, 104 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+4037;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=7149; /* line # 7149 */
  if (Ri.ub[95]) MXD_CMP_genspace();
  Ra.sl[6]=7150; /* line # 7150 */
  if (V_errcnt>0) {
    Ra.sl[6]=7152; /* line # 7152 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7153; /* line # 7153 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+4046,-1,-1,32);
    PAS__WRITE_INT(V_errcnt,12,0);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7154; /* line # 7154 */
    if (V_fatalerror) {
      Ra.sl[6]=7156; /* line # 7156 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_STR(Rd.s+4071,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[6]=7157; /* line # 7157 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+4076,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=7159; /* line # 7159 */
      PAS__SELECT_OUT(Ri.v[13]);
      PAS__WRITE_STR(Rd.s+4094,-1,-1,32);
      PAS__WRITE_EOLN();
    }
  }
  Ra.sl[6]=7161; /* line # 7161 */
  PAS__CLOSE(Ri.v+13,0);
  Ra.sl[6]=7162; /* line # 7162 */
  if (Ri.ub[97]&&!V_fatalerror) {
    Ra.sl[6]=7164; /* line # 7164 */
    P_open_ddifile(Ri.v+15,Rd.s+2729,1);
    Ra.sl[6]=7165; /* line # 7165 */
    Rv0=Rs.v[79];
    Ra.sl[6]=7166; /* line # 7166 */
    while (Rv0!=NULL){
      Ra.sl[6]=7168; /* line # 7168 */
      memcpy(Ra.s+48,Rv0+32,56);
      Ra.sl[6]=7169; /* line # 7169 */
      memcpy(Ra.s+28,Rv0+8,17);
      Ra.sl[6]=7170; /* line # 7170 */
      PAS__SELECT_OUT(Ri.v[15]);
      PAS__WRITE_BIN(Ra.s+28);
      Ra.sl[6]=7171; /* line # 7171 */
      Rv0=((V *)Rv0)[0];
    }
    Ra.sl[6]=7173; /* line # 7173 */
    P_close_ddifile(Ri.v+15);
  }
  Ra.sl[6]=7175; /* line # 7175 */
  if (((UB *)Ri.v[0])[68]) {
    Ra.sl[6]=7177; /* line # 7177 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7178; /* line # 7178 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7179; /* line # 7179 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7180; /* line # 7180 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+4099,-1,-1,32);
    PAS__WRITE_INT(V_errcnt,4,0);
    Ra.sl[6]=7181; /* line # 7181 */
    if (V_fatalerror) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_STR(Rd.s+4116,-1,-1,32);
    }
    Ra.sl[6]=7182; /* line # 7182 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+4134,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7183; /* line # 7183 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7184; /* line # 7184 */
    MXD_CMP_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+4138,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=7185; /* line # 7185 */
    MXD_CMP_writecpu(P_cpu_clock()-Rs.sl[136]);
    Ra.sl[6]=7186; /* line # 7186 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=7189; /* line # 7189 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mxd_cmp "  */
main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  if (sigsetjmp(G_lb_env, 1 )) goto L_l_0;

  Rs.v[132]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+1056;
  Rs.v[133]=Rd.s+4172;
  Rs.v[134]=Rd.s+12;
  Rs.sl[270]=7193; /* line # 7193 */
  MXD_CMP_init();
  Rs.sl[270]=7194; /* line # 7194 */
  MXD_CMP_insymbol();
  Rs.sl[270]=7195; /* line # 7195 */
  MXD_CMP_statelist(118);
  Rs.sl[270]=7196; /* line # 7196 */
  MXD_CMP_summary();
  Rs.sl[270]=7197; /* line # 7197 */
  if (PAS__LENGTH_STR(Ri.s+136)>0) {
    Rs.sl[270]=7199; /* line # 7199 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+4181,-1,-1,32);
    PAS__WRITE_STR(Ri.s+136,-1,-1,32);
    PAS__WRITE_STR(Rd.s+4203,-1,-1,32);
    PAS__WRITE_EOLN();
    Rs.sl[270]=7200; /* line # 7200 */
    PAS__RUN_PROC_1(Rd.s+4219,Ri.s+136,0,NULL);
    Rs.sl[270]=7201; /* line # 7201 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+4221,-1,-1,32);
    PAS__WRITE_EOLN();
    Rs.sl[270]=7202; /* line # 7202 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+4275,-1,-1,32);
    PAS__WRITE_STR(Ri.s+136,-1,-1,32);
    PAS__WRITE_STR(Rd.s+4279,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Rs.s+1056;
L_l_0:
  Rs.sl[270]=7205; /* line # 7205 */
  PAS__curr_cntx=Rs.v[132];
  PAS__EXIT( 0 );
}
