/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#include <stdio.h>
#include <fenv.h>
#include <sys/stat.h>
#include <sys/wait.h>
#define incr_ptr(p,inc) p += inc;
#define cc_wild_pointer( p ) ((V) p)
#define _Open(fn,fl,md) open((char *)(fn),fl,md)
#define _Openr(fn,fl,md) open((char *)(fn),fl,md,"rat=cr","rfm=var")
#define _Remove(fn) remove((char *)(fn))
#define _Getenv(lg) (C *)getenv((char *)(lg))
#define _Setenv(lg,vl,ovw) setenv((char *)(lg),(char *)(vl),ovw)
#define _UnSetenv(lg) unsetenv((char *)(lg))
#define _Putenv(lgl) putenv((char *)(lgl))
#define _Chdir(dir) chdir((char *)dir)
#define _Getdir(dir,sz) (C *)getcwd((char *)(dir),(size_t)(sz))
#define _Execv(f,p) execv((char *)(f),(char **)(p))
#define _Execvp(f,p) execvp((char *)(f),(char **)(p))
#define _Execve(f,p,e) execve((char *)(f),(char **)(p),(char **)(e))
#define _System(cm) system((char *)(cm))
#define _Pipe(chan) pipe((int *)(chan))
#define _Wait(proc) wait((int *)(proc))
#define _GetUid getuid
#define _GetGid getgid
#define _Access(f,acc) access((char *)(f),acc)
#define _Rename(o,n) rename((char *)(o),(char *)(n))
#define _Opendir( dn ) (void *) opendir( (char *)(dn))
#define _Closedir( df ) closedir( (DIR *) df )
#define _Readdir( df ) (void *) readdir( (DIR *)(df))
#define _ReadLink( l, t, s ) readlink( (char*) l, (char*) t, s )
#define _MakeDir( d, m ) mkdir( (char*) d, m )
#define _RemoveDir( d ) rmdir( (char*) d )
#define _Ttyname( df ) (C *)ttyname( df )

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 8 ) = {{
  4,   4,  58,  47,  93,  92,   0,   0
}};
/* Define the local static section. */
static Blk( Rs, 256 );




/* Procedure/Function : " pas__get_env "  */
SL PAS__GET_ENV_ARRAY(V *F_ptr, V F_src){
  /* Local variable stored in C variable */
  SL Rv0;
  C Rv1;
  SL Rv2;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=1;
  for( Rf0=((UB *)F_src)[1];Rf0>0;Rf0-- ) {
    Rv1=((C *)F_src)[Rv0+1];
    if (Rv1>=97&&Rv1<=122) Rv1=(C)((SL)Rv1-32);
    Rs.c[Rv0-1]=Rv1;
    Rv0++;
  }
  Rs.c[(((UB *)F_src)[1]+1)-1]=0;
  (*F_ptr)=_Getenv(Rs.s);
  if ((*F_ptr)==NULL) Rv2=-1;
  else {
    Rv2=0;
    while (((C *)(*F_ptr))[(Rv2+1)-1]!=0)
    Rv2=Rv2+1;
  }
  Ret=Rv2;
  return(Ret);
}


/* Procedure/Function : " pas_$getenv "  */
SL PAS__GETENV(V F_trg, V F_src){
  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  C Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=PAS__GET_ENV_ARRAY(&Rv1, F_src);
  if (Rv0<=0) ((UB *)F_trg)[1]=0;
  else {
    Rv2=1;
    while (1){
      Rv3=((C *)Rv1)[Rv2-1];
      if (Rv3==0||Rv2>((UB *)F_trg)[0])  break;
      ((C *)F_trg)[Rv2+1]=Rv3;
      Rv2=Rv2+1;
    }
    if (Rv2>((UB *)F_trg)[0]) Rv0=-2;
    else Rv0=0;
    ((UB *)F_trg)[1]=Rv2-1;
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " set_env "  */
SL CPAS__LCALS_set_env(V F_log, V F_val, SL F_sz1, SL F_sz2, SL F_ovr){
  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  C Rv3;
  SL Rv4;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  if (F_sz1>0) {
    Rv0=F_sz1+1;
    if (F_sz2>0) Rv0=(Rv0+F_sz2)+1;
    Rv1=PAS__MEM_ALLOC(Rv0);
    Rv2=0;
    for( Rf0=(F_sz1-1)+1;Rf0>0;Rf0-- ) {
      Rv3=((C *)F_log)[Rv2];
      if (Rv3>=97&&Rv3<=122) Rv3=(C)((SL)Rv3-32);
      ((C *)Rv1)[Rv2]=Rv3;
      Rv2++;
    }
    ((C *)Rv1)[F_sz1]=0;
    if (F_sz2>0) {
      if (F_ovr==0) {
        if (_Getenv(Rv1)!=NULL) {
          PAS__MEM_FREE(Rv1);
          Ret=0;
          goto Ret_Label;
        }
      }
      Rv0=F_sz1;
      ((C *)Rv1)[Rv0]=61;
      Rv0=Rv0+1;
      Rv4=0;
      for( Rf0=(F_sz2-1)+1;Rf0>0;Rf0-- ) {
        ((C *)Rv1)[Rv0]=((C *)F_val)[Rv4];
        Rv0=Rv0+1;
        Rv4++;
      }
      ((C *)Rv1)[Rv0]=0;
    }
    Ret=_Putenv(Rv1);
    goto Ret_Label;
  }
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " pas__set_env "  */
SL PAS__SET_ENV_ARRAY(V F_log, V F_val, SL F_dim, SL F_sz, SL F_ovr){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (F_sz<0||F_sz>F_dim) F_sz=F_dim;
  if (F_sz<=0) CPAS__LCALS_set_env(F_log+2,NULL,((UB *)F_log)[1],0,1);
  else Rv0=CPAS__LCALS_set_env(F_log+2,F_val,((UB *)F_log)[1],F_sz, F_ovr);
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " pas_$setenv "  */
SL PAS__SETENV(V F_log, V F_val, SL F_ovr){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (((UB *)F_val)[1]<=0) CPAS__LCALS_set_env(F_log+2,NULL,((UB *)F_log)[1],0,1);
  else Rv0=CPAS__LCALS_set_env(F_log+2,F_val+2,((UB *)F_log)[1],((UB *)F_val)[1]
  ,F_ovr);
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " get_phy_fspc "  */
V CPAS__LCALS_PRC_00000000(V Ret, V F_fsp, SL F_irep, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 1032 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  ((UB *)Ret)[0]=255;
  if (F_irep<=10) {
    PAS__STR_TO_STR(Ra.s,F_fsp);
    Rv0=Ra.ub[1];
    Rv1=PAS__INDEX_CHA(Ra.s+2,(SL)Ra.ub[1],58);
    if (Rv1>0) Ra.ub[1]=Rv1-1;
    else Rv1=Ra.ub[1];
    (*F_ierr)=PAS__GETENV(Ra.s+257,Ra.s);
    Ra.ub[1]=Rv0;
    if ((*F_ierr)!=0) Ra.ub[258]=0;
    if ((*F_ierr)==-1) (*F_ierr)=0;
    if (Ra.ub[258]==0) PAS__STR_TO_STR(Ret,Ra.s);
    else {
      Rv2=PAS__INDEX_CHA(Rd.s+2,4, Ra.c[(Rv1+1)+1]);
      Rv3=PAS__INDEX_CHA(Rd.s+2,4, Ra.c[Ra.ub[258]+258]);
      if (Rv2>0||Rv3>0) {
        if (Rv2==Rv3) Rv1=Rv1+1;
        Rv0=Ra.ub[1]-Rv1;
        if (((UB *)Ret)[0]<Ra.ub[258]+Rv0) (*F_ierr)=-2;
        if (Rv0>0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+771,Ra.s+257,PAS__SUBSTR_STR(
        Ra.s+514,Ra.s,Rv1+1,0)));
        else PAS__STR_TO_STR(Ra.s,Ra.s+257);
      }
      else PAS__STR_TO_STR(Ra.s,Ra.s+257);
      if ((*F_ierr)==0) PAS__STR_TO_STR(Ret,CPAS__LCALS_PRC_00000000(Ra.s+514,Ra.
      s,F_irep+1, F_ierr));
      else PAS__STR_TO_STR(Ret,Ra.s);
    }
  }
  else (*F_ierr)=-100;
  return(Ret);
}


/* Procedure/Function : " get_physic_fspc "  */
SL PAS__GETPHYSIC(V F_trg, V F_spc){
  /* Define the automatic variable space. */
  Blk( Ra, 264 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  PAS__STR_TO_STR(F_trg,CPAS__LCALS_PRC_00000000(Ra.s,F_spc,1, &Rv0));
  Ret=Rv0;
  return(Ret);
}
