/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 72 ) = {
  5,   5, 105, 103, 112, 111, 119,  62,  62,  47, 104, 111, 109, 101,  47, 112,
105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95, 115, 114,  99,
 95,  86,  51,  46,  50,  65,  49,  47,  99, 112,  97, 115,  95,  95, 105, 103,
112, 111, 119,  46, 112,  97, 115,   0
};




/* Procedure/Function : " igpow "  */
G PAS__IGPOWER(G F_z, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=57; /* line # 57 */
  Rv0=1.000000000000000E+000;
  if (F_n<0) {
    F_n= -F_n;
    F_z=Rv0/F_z;
  }
  Ra.sl[6]=62; /* line # 62 */
  while (F_n>0)
  if (F_n&1) {
    F_n=F_n-1;
    Rv0=Rv0*F_z;
  }
  else {
    Ra.sl[6]=69; /* line # 69 */
    F_n=F_n/2;
    F_z=F_z*F_z;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
