/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 3520 ) = {{
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  60,  60,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  51,  47, 112,  99,
109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115, 101, 116,
 95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,   9,   9,
115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  97,
114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,  97, 114,
101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,  99, 111,
109, 112,  95, 115,  99,  97, 108,  97, 114,  13,  13,  99, 104, 105, 108, 100,
114, 101, 110,  95, 116, 121, 112, 101,   9,   9,  99, 111, 109, 112,  95, 116,
121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112, 114, 111,  99,  95,  97,
114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116,
101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,  49,  21,  21, 116, 121,
112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,  95, 114, 101, 108, 101,
 97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,  95, 105, 110,  95,  97,
114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110, 103,  95, 105, 110,  95,
115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16, 105, 110, 105, 116, 105,
 97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,  15,  15, 116, 121, 112,
101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114, 109,   4,   4,  84,  89,
 67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,  95, 115, 101, 116,  95,
118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,  95, 112,  97, 114, 109,
 95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,  12, 105, 110, 105, 116,
 95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100, 121, 110,  95, 114, 101,
 99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,  95, 100, 121, 110,  95,
114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100, 121, 110,  95, 100,   4,
  4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,  95, 100,  95, 100, 121,
110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110, 105, 116,  95, 100,  95,
116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10, 105, 110, 105, 116,  95,
100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,  13,  13, 105, 110, 105,
116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,   4,  73,  68,  83,  84,
 12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97, 114,  98, 108,  11,  11,
101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,   4,   4,  69,  67,  85,
 78,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,  98, 105, 110,   4,   4,
 69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95, 102, 111, 114,  95, 100,
101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,  99,  97, 108, 108,  95,
115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,  76,  76,   3,   3, 119,
114, 116,   0,   0,  33,   0,   0,   0,  17,   0,   9, 102, 111, 114, 109,  95,
 99, 104,  97, 114,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114,
109,  95, 108, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102,
111, 114, 109,  95, 105, 110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 11, 102, 111, 114, 109,  95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,
  0,   0,  11, 102, 111, 114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,
  0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101,
114,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 102, 101, 110, 116,
114, 121,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 105,
108, 101,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
 97, 114, 114,  97, 121,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95,  99, 111, 110, 102,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102,
111, 114, 109,  95, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   0,
  8, 102, 111, 114, 109,  95, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 108, 115, 101, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,
  0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110,
110, 117, 109,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
119, 102, 105, 108, 101,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102,
111, 114, 109,  95, 119, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
 10, 102, 111, 114, 109,  95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,
  0,   0,  12, 102, 111, 114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103,
101,   0,   0,   0,   0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97,
114, 105,  97, 110, 116,   0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95,
111, 114, 103,  97, 110, 105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114,
109,  95,  99, 111, 110, 115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102,
111, 114, 109,  95, 112, 114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,
 12, 102, 111, 114, 109,  95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 117, 118,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 101,
  0,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 110, 117,
108, 108,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95,
115, 116, 114, 105, 110, 103,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 102, 114, 101, 101,   0,   0,   0,   0,   0,   0,   0,   0,   8,   8,
 32,  45,  45,  45,  45,  45,  45,  32,  12,  12, 115, 104, 111, 119,  95, 114,
101, 113, 117, 101, 115, 116,  25,  25,  32,  71, 101, 110, 101, 114, 105,  99,
 95,  83, 101,  97, 114,  99, 104,  32, 102, 111, 114,  32, 110, 112,  32,  61,
 32,   6,   6,  32, 119, 105, 116, 104,  32,  13,  13,  65, 114, 103,  95,  49,
 32, 102,  95, 116, 121, 112, 101,  32,  15,  15,  44,  32,  65, 114, 103,  95,
 50,  32, 102,  95, 116, 121, 112, 101,  32,   7,   7,  78, 111,  32,  97, 114,
103,  46,  10,  10, 115, 104, 111, 119,  95, 101, 110, 116, 114, 121,  16,  16,
 32,  79, 107,  32, 102, 111, 114,  32,  69, 110, 116, 114, 121,  32,  58,  32,
 10,  10,  32,  32,  32,  32,  69, 110, 116, 114, 121,  32,   2,   2,  44,  32,
  4,   4,  32,  45,  62,  32,  11,  11,  32,  45,  62,  32,  99, 111, 100, 101,
 32,  61,  32,   0, 127,   0,   0,   0,  15,   0,   9, 112,  99, 111, 100,  95,
110, 111, 111, 112,   0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
115, 116, 111, 114, 101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
114,  97, 110, 103, 101,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
105, 115, 116, 111, 114, 101,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
102, 115, 116, 111, 114, 101,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
103, 115, 116, 111, 114, 101,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
110, 111, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 97, 110, 100,   0,   0,   0,   0,   0,   0,   0,   7, 112,  99, 111, 100,  95,
111, 114,   0,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
120, 111, 114,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 99, 111, 109,   0,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 98,  97, 110, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 98, 120, 111, 114,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 98, 105,  99,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 98, 105, 115,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 98, 105, 116,   0,   0,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
115, 101, 116, 103, 101, 110,   0,   0,   0,   0,  12, 112,  99, 111, 100,  95,
108, 115, 101, 116, 103, 101, 110,   0,   0,   0,  14, 112,  99, 111, 100,  95,
108, 115, 101, 116,  97, 100, 100, 101, 108,   0,  10, 112,  99, 111, 100,  95,
115, 101, 116, 108, 116,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
115, 101, 116, 108, 101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
115, 101, 116, 103, 101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
115, 101, 116, 103, 116,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
115, 101, 116, 101, 113,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
115, 101, 116, 110, 101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
105, 110, 115, 101, 116,   0,   0,   0,   0,   0,   7, 112,  99, 111, 100,  95,
101, 113,   0,   0,   0,   0,   0,   0,   0,   0,   7, 112,  99, 111, 100,  95,
110, 101,   0,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
117, 108, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
117, 108, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
117, 103, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
117, 103, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
105, 108, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
105, 108, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
105, 103, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
105, 103, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 95, 101, 113,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 95, 110, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
105, 110,  99,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
100, 101,  99,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 97, 115, 104,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
108, 115, 104,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
114, 111, 116,   0,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
115, 117,  99,  99,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
112, 114, 101, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 111, 100, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 110, 101, 103,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105,  97,  98, 115,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 115, 113, 114,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105,  97, 100, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 115, 117,  98,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 109, 117, 108,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 100, 105, 118,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 109, 111, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 114, 101, 109,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
102, 108, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
102, 108, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
102, 103, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
102, 103, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
102, 101, 113,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
102, 110, 101,   0,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 110, 101, 103,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102,  97,  98, 115,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 115, 113, 114,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 118, 105, 102,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 118, 102, 105,   0,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
102, 116, 114, 117, 110,  99,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102,  97, 100, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 115, 117,  98,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 109, 117, 108,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 100, 105, 118,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
103, 108, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
103, 108, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
103, 103, 101,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
103, 103, 116,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
103, 101, 113,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
103, 110, 101,   0,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 110, 101, 103,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103,  97,  98, 115,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 115, 113, 114,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 118, 105, 103,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 118, 103, 105,   0,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
103, 116, 114, 117, 110,  99,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 118, 102, 103,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 118, 103, 102,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103,  97, 100, 100,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 115, 117,  98,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 109, 117, 108,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 100, 105, 118,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
105, 112, 111, 119,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 112, 111, 119,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
102, 105, 112, 119,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
115, 113, 114, 116,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
115, 105, 110,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
 99, 111, 115,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
116,  97, 110,   0,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 97, 115, 105, 110,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 97,  99, 111, 115,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 97, 116,  97, 110,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
112, 104,  97, 115,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
101, 120, 112,   0,   0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,
108, 111, 103,   0,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
115, 105, 110, 104,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
 99, 111, 115, 104,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
116,  97, 110, 104,   0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
 97, 115, 105, 110, 104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
 97,  99, 111, 115, 104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
 97, 116,  97, 110, 104,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 112, 111, 119,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 105, 112, 119,   0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103, 115, 113, 114, 116,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 115, 105, 110,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103,  99, 111, 115,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 116,  97, 110,   0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103,  97, 115, 105, 110,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103,  97,  99, 111, 115,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103,  97, 116,  97, 110,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103, 112, 104,  97, 115,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 101, 120, 112,   0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,
103, 108, 111, 103,   0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103, 115, 105, 110, 104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103,  99, 111, 115, 104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,
103, 116,  97, 110, 104,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
103,  97, 115, 105, 110, 104,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
103,  97,  99, 111, 115, 104,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95,
103,  97, 116,  97, 110, 104,   0,   0,   0,   0,  14, 112,  99, 111, 100,  95,
 95, 103, 101, 110, 115, 116, 114, 108,  49,   0,  15, 112,  99, 111, 100,  95,
 95, 103, 101, 110, 112, 114, 109, 116, 121, 112,   4,   4, 100, 117, 109, 112,
 14,  14, 103, 101, 110, 101, 114, 105,  99,  95, 115, 101,  97, 114,  99, 104,
  4,   4,  71,  69,  78,  83,  11,  11, 101, 120, 112,  95, 103, 101, 110, 111,
112, 101, 114,  13,  13, 103, 101, 110, 101, 114,  97, 116, 101,  95,  99,  97,
108, 108,   9,   9, 101, 120, 112,  95, 103, 101, 110, 111, 112,  13,  13, 108,
103, 116,  95, 103, 101, 110,  95, 115, 116, 111, 114, 101,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 488 ) = {{
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   5,   5,
  0,   0,   0,   0,   0,   5,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   5,   0,   0,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   2,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,
  0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   5,
  0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   0,   3,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,
  0,   0,   0,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   5,   5,   0,   5,   0,   0,
  0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   5,
  0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   0,   0,   5,   0,   5,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   5,   5,
  0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   0,
  0,   0,   0,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
  5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
  5,   5,   5,   5,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 272 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern V PAS__f_output;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000001(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=95; /* line # 95 */
  if (V_sy_sym.ub[0]==5) {
    (*F_nam)=PAS__NEW(32);
    Rv0=(*F_nam);
    Ra.sl[6]=100; /* line # 100 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else((UB *)Rv0)[0]=V_sy_string.ub[1];
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=105; /* line # 105 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+75;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=120; /* line # 120 */
  Rv0=F_pr;
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+90,129,1);
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=126; /* line # 126 */
    ((V *)Rv0)[3]=NULL;
    P_src_error(Rd.s+90,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=141; /* line # 141 */
  V_enm_range=0;
  Rv0=F_ty1==F_ty2;
  if (!Rv0) {
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=146; /* line # 146 */
      if (((((UB *)F_ty1)[92]==((UB *)F_ty2)[92]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) switch ((
      (UB *)F_ty1)[92]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=152; /* line # 152 */
        if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)F_ty2)
        [29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) Rv0=1;
        break;
        case 3:
        case 4:Rv0=1;
        break;
        case 5:
        case 7:
        case 13:Ra.sl[6]=157; /* line # 157 */
        Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
        break;
        case 11:
        case 12:if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) Rv0=P_same_type(((V *)
        F_ty1)[13],((V *)F_ty2)[13]);
        break;
        case 8:
        case 9:Ra.sl[6]=162; /* line # 162 */
        if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
        [25]) {
          if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
          F_ty1)[14],((V *)F_ty2)[14])) Rv0=1;
        }
        break;
        case 22:Ra.sl[6]=168; /* line # 168 */
        Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
        break;
        case 6:Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=173; /* line # 173 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=186; /* line # 186 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Rv0=0;
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=192; /* line # 192 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else Rv0=1;
      if (Rv0) {
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=200; /* line # 200 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Rv0=P_same_type(((V *)Rv1)[4],((V *)Rv2)[4]);
          if (Rv0) {
            Ra.sl[6]=206; /* line # 206 */
            if (((UB *)Rv1)[56]==7) {
              if (((UB *)Rv2)[56]==7) {
                if (((UB *)((V *)Rv1)[9])[104]==3&&((UB *)((V *)Rv2)[9])[104]==3)
                 Rv0=P_compare_entry(((V *)Rv1)[9],((V *)Rv2)[9]);
                else Rv0=0;
              }
              else {
                Ra.sl[6]=211; /* line # 211 */
                Rv0=0;
              }
            }
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=219; /* line # 219 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+120;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=233; /* line # 233 */
  Rv0=0;
  if (F_pgc!=NULL&&F_ent!=NULL) while (F_pgc!=NULL&&!Rv0){
    Ra.sl[6]=238; /* line # 238 */
    Rv1=F_pgc;
    if (!((UB *)Rv1)[8]) {
      Rv2=((V *)Rv1)[2];
      Ra.sl[6]=243; /* line # 243 */
      Rv0=P_compare_entry(Rv2, F_ent);
    }
    if (!Rv0) {
      if (F_pgc==F_pgl) F_pgc=NULL;
      else F_pgc=((V *)F_pgc)[0];
    }
  }
  Ra.sl[6]=250; /* line # 250 */
  if (!Rv0) F_pgc=NULL;
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+140;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=270; /* line # 270 */
  Rv0=4;
  if (F_te==F_tf) Rv0=0;
  else {
    if (F_te!=NULL&&F_tf!=NULL) {
      Rv1=F_te;
      if (((UB *)Rv1)[92]==((UB *)F_tf)[92]) {
        Ra.sl[6]=275; /* line # 275 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          if (((UB *)Rv1)[112]) {
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=281; /* line # 281 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Rv4=F_tf;
          if (((UB *)Rv4)[112]) {
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=286; /* line # 286 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=292; /* line # 292 */
            if (Rv2==Rv5) {
              if (Rv3==Rv6) Rv0=0;
              else Rv0=1;
            }
            else Rv0=2;
          }
          else Rv0=3;
        }
        else {
          Ra.sl[6]=298; /* line # 298 */
          V_enm_range=1;
        }
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " children_type "  */
UB P_children_type(V F_eff, V F_frm, UB F_bpar, UB F_bsym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+153;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=313; /* line # 313 */
  F_bpar=1;
  if (F_frm!=NULL) {
    if (F_bpar) {
      Ra.sl[6]=318; /* line # 318 */
      Rv1=F_eff;
      while (Rv1!=NULL&&Rv1!=F_frm)
      Rv1=((V *)Rv1)[0];
      Rv0=Rv1==F_frm;
      if (!Rv0&&F_bsym) Rv0=P_children_type(F_frm, F_eff, F_bpar,0);
    }
    else {
      Ra.sl[6]=323; /* line # 323 */
      Rv0=F_eff==F_frm;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+168;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=371; /* line # 371 */
  V_enm_range=0;
  Rv0=0;
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=376; /* line # 376 */
    Rv0=P_children_type(F_eff, F_frm,!F_exact,0);
    if (!Rv0) {
      Rv1=F_frm;
      if (((UB *)Rv1)[92]==22) {
        Ra.sl[6]=381; /* line # 381 */
        Rv0=P_comp_type(((V *)Rv1)[0],F_eff, F_exact);
      }
      if (!Rv0) {
        if (((UB *)F_eff)[92]<=21&&((UB *)Rv1)[92]<=21) {
          Ra.sl[6]=386; /* line # 386 */
          Rv2=Ri.ub[((UB *)F_eff)[92]*22+((UB *)Rv1)[92]];
          Ra.sl[6]=394; /* line # 394 */
          switch (Rv2) {
            case 5:Rv0=1;
            break;
            case 1:
            case 2:Ra.sl[6]=399; /* line # 399 */
            switch (((UB *)Rv1)[92]) {
              case 0:
              case 1:
              case 2:if (((UB *)Rv1)[88]) {
                Ra.sl[6]=404; /* line # 404 */
                if (!F_exact) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
                else Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv1)[11]
                ==((SL *)F_eff)[11];
              }
              break;
              case 11:
              case 12:Ra.sl[6]=409; /* line # 409 */
              Rv0=P_comp_type(((V *)F_eff)[13],((V *)Rv1)[13],F_exact);
              break;
              case 8:Rv0=((V *)F_eff)[14]==((V *)Rv1)[14]&&P_comp_type(((V *)F_eff)
              [15],((V *)Rv1)[15],1);
              break;
              case 9:Ra.sl[6]=416; /* line # 416 */
              Rv0=((V *)F_eff)[14]==((V *)Rv1)[14]&&P_comp_type(((V *)F_eff)[15]
              ,((V *)((V *)Rv1)[15])[0],1);
              break;
              case 5:if (((V *)Rv1)[12]==NULL) Rv0=((UB *)F_eff)[92]==5;
              else {
                Ra.sl[6]=421; /* line # 421 */
                Rv0=P_comp_type(((V *)F_eff)[12],((V *)Rv1)[12],1);
              }
              break;
              case 6:if (((V *)Rv1)[13]==NULL) Rv0=((UB *)F_eff)[92]==6;
              else Rv0=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv1)[13]);
              break;
              default:break;
            }
            break;
            case 4:Ra.sl[6]=431; /* line # 431 */
            Rv0=P_comp_type(F_frm, V_typ_std.v[10],0);
            break;
            case 3:if (P_comp_type(F_eff, V_typ_std.v[10],0)) {
              Ra.sl[6]=436; /* line # 436 */
              Rv0=P_comp_type(((V *)((V *)F_eff)[13])[4],F_frm,0);
            }
            break;
            default:break;
          }
        }
      }
    }
  }
  Ra.sl[6]=444; /* line # 444 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+179;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=458; /* line # 458 */
  Rv0=1;
  if (F_epr!=F_fpr) {
    if (F_epr!=NULL&&F_fpr!=NULL) {
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=463; /* line # 463 */
        Rv0=0;
      }
      else {
        Rv1=((V *)F_epr)[8];
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=468; /* line # 468 */
        if (((V *)F_epr)[11]!=NULL) {
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          if (((UB *)Rv2)[56]!=((UB *)Rv1)[56]) Rv0=0;
          else {
            Ra.sl[6]=474; /* line # 474 */
            switch (((UB *)Rv2)[56]) {
              case 5:Rv0=P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],((UB *)Rv2)[66]
              !=8);
              break;
              case 7:Ra.sl[6]=479; /* line # 479 */
              if (P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[9],((V *)Rv2)[9]);
              else Rv0=0;
              break;
              default:break;
            }
          }
          Ra.sl[6]=485; /* line # 485 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
      }
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=491; /* line # 491 */
      Rv0=0;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=510; /* line # 510 */
  if (F_ty!=NULL) {
    Rv0=F_ty;
    Rv1=((V *)Rv0)[4];
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=515; /* line # 515 */
    while (Rv1!=NULL){
      Rv3=Rv1;
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Rv5=Rv4;
      Ra.sl[6]=521; /* line # 521 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+216,132,3);
      else {
        Rv6=((V *)Rv5)[7];
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[4])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[4];
      }
      Ra.sl[6]=526; /* line # 526 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[15];
      ((V *)Rv3)[10]=Rv4;
      ((UB *)Rv3)[64]=1;
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=531; /* line # 531 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      (*F_lghl)=Rv4;
      (*F_count)=(*F_count)+1;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+220;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=550; /* line # 550 */
  Rv0=((V *)F_ty)[4];
  while (Rv0!=NULL){
    Rv1=Rv0;
    ((UB *)Rv1)[64]=0;
    Ra.sl[6]=555; /* line # 555 */
    ((V *)Rv1)[10]=NULL;
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+243;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=573; /* line # 573 */
  if (((V *)F_lgt)[7]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=NULL;
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=578; /* line # 578 */
    Rv4=NULL;
    Rv5=NULL;
    Rv6=0;
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=588; /* line # 588 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      while (Rv4!=NULL){
        Rv5=Rv4;
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=593; /* line # 593 */
        Rv7=Rv5;
        Rv8=NULL;
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=598; /* line # 598 */
          ((V *)Rv2)[0]=Rv8;
        }
        Rv2=Rv8;
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=603; /* line # 603 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    if (Rv3<=0) {
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=608; /* line # 608 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=613; /* line # 613 */
      if (Rv3<=0) Rv3=1;
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else((V *)Rv2)[0]=((V *)Rv0)[7];
      Rv2=((V *)Rv0)[7];
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=618; /* line # 618 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=623; /* line # 623 */
        ((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
      }
      break;
      case 32:Ra.sl[6]=630; /* line # 630 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      if (Rv10==NULL) Rv11=0;
      else Rv11=((UB *)Rv10)[1];
      if (Rv3<=0) {
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=636; /* line # 636 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          if (Rv12!=NULL) {
            Rv13=Rv12;
            if (((UB *)Rv13)[40]==14) {
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=643; /* line # 643 */
      if (Rv3<=0) Rv3=Rv11;
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=648; /* line # 648 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else((SL *)Rv8)[13]=32;
        if (Rv2==NULL) Rv9=Rv8;
        else((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=657; /* line # 657 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    P_val_new(((V *)Rv0)+7,F_ty);
    Rv15=((V *)Rv0)[7];
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=662; /* line # 662 */
    ((SL *)Rv15)[6]=Rv3;
    ((SL *)Rv15)[2]=Rv6;
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=668; /* line # 668 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+260;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=682; /* line # 682 */
  if (((V *)F_lgt)[7]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=((V *)Rv0)[7];
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=687; /* line # 687 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Rv3=((V *)Rv0)[7];
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=694; /* line # 694 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+281;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=706; /* line # 706 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[6];
  ((UW *)Rv0)[32]=((UW *)Rv0)[32]|8;
  P_lgt_new(&Rv2,((V *)Rv0)[4],14,NULL);
  Ra.sl[6]=711; /* line # 711 */
  Rv3=Rv2;
  ((V *)Rv3)[7]=((V *)Rv0)[9];
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=716; /* line # 716 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  if (((UB *)((V *)Rv0)[4])[92]==7||((UB *)((V *)Rv0)[4])[92]==16) Rv2=P_lgt_new_code(3,
  Rv2);
  else {
    Ra.sl[6]=722; /* line # 722 */
    Rv2=P_exp_genop(28, Rv2);
  }
  switch (((UB *)Rv1)[104]) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:Ra.sl[6]=728; /* line # 728 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else((V *)((V *)Rv1)[17])[0]=Rv2;
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+299;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=750; /* line # 750 */
  Rv0=F_lgt;
  switch (((UB *)Rv0)[40]) {
    case 13:Rv1=((V *)Rv0)[6];
    if (((UB *)Rv1)[56]!=2) {
      Ra.sl[6]=756; /* line # 756 */
      P_src_error_s(Rd.s+318,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=762; /* line # 762 */
    Rv2=((V *)Rv0)[1];
    while (Rv2!=NULL){
      P_type_check_parm(Rv2);
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=768; /* line # 768 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=776; /* line # 776 */
      P_src_error(Rd.s+318,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=782; /* line # 782 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+318,203,3);
    break;
    default:P_src_error(Rd.s+318,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000000(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+322;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=809; /* line # 809 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=815; /* line # 815 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+341;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=826; /* line # 826 */
  Rv0=0;
  Rv1=F_lgt;
  Rv2=F_ip;
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=831; /* line # 831 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Rv4=Rv3;
    Rv5=Rv1;
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[4],0)) {
      Ra.sl[6]=838; /* line # 838 */
      P_type_check_parm(Rv1);
      ((UB *)Rv4)[64]=2;
      ((V *)Rv4)[10]=Rv1;
    }
    else {
      Ra.sl[6]=843; /* line # 843 */
      P_src_error_s(Rd.s+358,201,3,((V *)Rv4)[0],NULL);
    }
    Rv1=((V *)Rv1)[0];
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=849; /* line # 849 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+358,998,3);
  if (((UB *)((V *)Rv2)[4])[92]==27) {
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[4])[9],NULL,NULL,0);
    Ra.sl[6]=855; /* line # 855 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else P_src_error(Rd.s+358,222,3);
  }
  else {
    Ra.sl[6]=860; /* line # 860 */
    P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv6);
    Rv7=Rv6;
    ((UB *)Rv7)[89]=1;
    ((V *)Rv7)[0]=((V *)Rv2)[4];
    Ra.sl[6]=865; /* line # 865 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[4])[4];
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[4])[11];
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[4])[10];
    memcpy(Rv7+48,((V *)Rv2)[4]+48,1);
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[4])[10];
    Ra.sl[6]=870; /* line # 870 */
    ((UB *)Rv7)[90]=((UB *)((V *)Rv2)[4])[90];
    V_sy_type_gfirst=((V *)Rv2)[10];
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=875; /* line # 875 */
    PAS_EXPSION_PRC_00000000(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[4])[9]
    );
    switch (((UB *)Rv7)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=880; /* line # 880 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=888; /* line # 888 */
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[4])[12]);
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[4])[14]);
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[4])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=896; /* line # 896 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=910; /* line # 910 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[4])
      [13]);
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=923; /* line # 923 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      if (((V *)((V *)Rv7)[0])[14]!=NULL) ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)
      Rv7)[0])[14]);
      else {
        Ra.sl[6]=928; /* line # 928 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=933; /* line # 933 */
      P_src_error(Rd.s+358,998,3);
      break;
    }
  }
  Ra.sl[6]=939; /* line # 939 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  while (Rv3!=NULL){
    Rv8=Rv3;
    Ra.sl[6]=944; /* line # 944 */
    ((V *)Rv8)[10]=NULL;
    ((UB *)Rv8)[64]=0;
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=950; /* line # 950 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+362;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=984; /* line # 984 */
  Rv0=F_ty;
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Rv1=P_all_new_tmp(V_int_typ, Lx[1].v[4]);
    Ra.sl[6]=991; /* line # 991 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Rv2=P_lgt_new_code(3, Rv1);
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[6]=996; /* line # 996 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    (*F_lgl)=Rv2;
    Rv3=1;
    Ra.sl[6]=1001; /* line # 1001 */
    if (((V *)Rv0)[13]!=NULL) {
      Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
      if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
        Ra.sl[6]=1007; /* line # 1007 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[1].v[4]);
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[6]=1013; /* line # 1013 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else((V *)(*F_lgl))[0]=Rv2;
        (*F_lgl)=Rv2;
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1019; /* line # 1019 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
    }
    if (Lx[1].ub[28]) {
      Ra.sl[6]=1024; /* line # 1024 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
    }
    else P_lgt_new_copy(F_trg, &Rv2);
    Ra.sl[6]=1029; /* line # 1029 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Rv6=Rv2;
    ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
    P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
    Ra.sl[6]=1034; /* line # 1034 */
    Rv7=((V *)Rv0)[14];
    Rv8=Rv2;
    ((V *)Rv8)[6]=F_ty;
    if (((UB *)Rv7)[92]!=10&&((UB *)Rv7)[92]!=23) ((SL *)Rv8)[4]=((SL *)Rv8)[4]+
    ((SL *)Rv7)[10];
    Ra.sl[6]=1039; /* line # 1039 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=1048; /* line # 1048 */
    Rv9=((V *)Rv0)[15];
    if (((UB *)Rv9)[92]!=22) {
      if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
      else Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
      Ra.sl[6]=1053; /* line # 1053 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
    }
    else Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
    Rv12=Rv11;
    Ra.sl[6]=1058; /* line # 1058 */
    PAS_EXPSION_PRC_00000001(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[6]=1069; /* line # 1069 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    ((UB *)Rv5)[41]=5;
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[6]=1074; /* line # 1074 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000004(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+376;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1099; /* line # 1099 */
  Rv0=NULL;
  Rv1=NULL;
  PAS_EXPSION_PRC_00000003(F_ty, Lx[0].v[4],&Rv0, &Rv1);
  if (Rv0!=NULL) {
    Ra.sl[6]=1104; /* line # 1104 */
    if (Rv1!=Rv0) {
      P_lgt_new(&Rv0,NULL,0, Rv0);
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1110; /* line # 1110 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+389;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1116; /* line # 1116 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[12];
  while (Rv1!=NULL){
    Ra.sl[6]=1121; /* line # 1121 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1126; /* line # 1126 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        if (Lx[1].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[4],2, P_lgt_link(Ra.v[4]));
        else P_lgt_new_copy(Ra.v[4],&Rv4);
        Ra.sl[6]=1131; /* line # 1131 */
        Rv5=Rv4;
        ((V *)Rv5)[4]=Rv1;
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[15];
        Ra.sl[6]=1138; /* line # 1138 */
        if (((UB *)Rv3)[92]!=10&&((UB *)Rv3)[92]!=23) ((SL *)Rv5)[4]=((SL *)Rv5)
        [4]+((SL *)((V *)Rv2)[4])[10];
        PAS_EXPSION_PRC_00000001(((V *)Rv2)[4],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1143; /* line # 1143 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[6]=1148; /* line # 1148 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1153; /* line # 1153 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else((V *)(*F_lgl))[0]=Rv6;
    (*F_lgl)=Rv6;
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1159; /* line # 1159 */
    P_lgt_new_copy(Rv7, &Rv4);
    ((V *)Rv6)[1]=Rv4;
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1164; /* line # 1164 */
    Rv6=PAS_EXPSION_PRC_00000004(((V *)Rv7)[3],Rv7);
    ((V *)Rv4)[0]=Rv6;
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1169; /* line # 1169 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    ((V *)Rv6)[0]=Rv4;
    Rv7=((V *)Rv7)[0];
    while (Rv7!=NULL){
      Ra.sl[6]=1174; /* line # 1174 */
      Rv6=PAS_EXPSION_PRC_00000004(((V *)Rv7)[3],Rv7);
      ((V *)Rv4)[0]=Rv6;
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000001(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+403;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1203; /* line # 1203 */
  Rv0=F_ty;
  if (((V *)Rv0)[4]!=NULL) {
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1208; /* line # 1208 */
    Rv2=((V *)Rv0)[7];
    while (Rv1!=NULL&&Rv2!=NULL){
      Rv3=Rv1;
      Ra.sl[6]=1213; /* line # 1213 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[4],2, P_lgt_link(F_trg));
      else P_lgt_new_copy(F_trg, &Rv4);
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1219; /* line # 1219 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
      if (((UB *)Rv6)[92]!=10&&((UB *)Rv6)[92]!=23) ((SL *)Rv5)[4]=((SL *)Rv5)[4]
      -((SL *)Rv6)[10];
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[4],0);
      Ra.sl[6]=1224; /* line # 1224 */
      ((V *)Rv3)[10]=((V *)Rv5)[0];
      ((UB *)Rv3)[64]=1;
      P_lgt_new(&Rv4,((V *)Rv3)[4],6, Rv4);
      Ra.sl[6]=1229; /* line # 1229 */
      ((UB *)Rv4)[41]=3;
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else((V *)(*F_lgl))[0]=Rv4;
      Ra.sl[6]=1234; /* line # 1234 */
      (*F_lgl)=Rv4;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1240; /* line # 1240 */
  if (((UB *)Rv0)[90]) switch (((UB *)Rv0)[92]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
    break;
    case 8:
    case 9:Ra.sl[6]=1246; /* line # 1246 */
    PAS_EXPSION_PRC_00000002(F_ty, F_trg, F_lgh,F_lgl);
    break;
    default:P_src_error(Rd.s+417,131,3);
    break;
  }
  Ra.sl[6]=1252; /* line # 1252 */
  Rv1=((V *)F_ty)[4];
  while (Rv1!=NULL){
    Rv7=Rv1;
    ((V *)Rv7)[10]=NULL;
    Ra.sl[6]=1257; /* line # 1257 */
    ((UB *)Rv7)[64]=0;
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+421;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1265; /* line # 1265 */
  if (((UB *)F_ty)[90]) switch (((UB *)F_ty)[92]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    case 8:
    case 9:Ra.sl[6]=1272; /* line # 1272 */
    PAS_EXPSION_PRC_00000002(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    default:P_src_error(Rd.s+435,131,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000005(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+439;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1305; /* line # 1305 */
  Rv0=F_ty;
  if (((V *)Rv0)[15]!=NULL) {
    Rv1=((V *)Rv0)[15];
    if (((UB *)Rv1)[92]!=22) {
      Ra.sl[6]=1310; /* line # 1310 */
      if (((UB *)Rv1)[112]) Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      else Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
    }
    else {
      Ra.sl[6]=1316; /* line # 1316 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      if (((UB *)Rv3)[40]==14) {
        Rv2=((SL *)((V *)Rv3)[7])[13];
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1322; /* line # 1322 */
        P_src_error(Rd.s+453,142,4);
      }
    }
  }
  else Rv2=0;
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1328; /* line # 1328 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    if (((UB *)Rv3)[40]==14) {
      Rv4=((SL *)((V *)Rv3)[7])[13];
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1334; /* line # 1334 */
      P_src_error(Rd.s+453,142,4);
    }
  }
  else Rv4=((SL *)Rv0)[25];
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1340; /* line # 1340 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1345; /* line # 1345 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    if (Lx[2].v[0]==NULL) Lx[2].v[0]=Rv7;
    else((V *)Lx[2].v[1])[0]=Rv7;
    Lx[2].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1350; /* line # 1350 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+457;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1369; /* line # 1369 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[12];
  while (Rv1!=NULL){
    Ra.sl[6]=1374; /* line # 1374 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1379; /* line # 1379 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[4],0);
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1385; /* line # 1385 */
        if (((SL *)Rv3)[11]>0) {
          Rv4=NULL;
          P_val_new(&Rv4, V_typ_std.v[0]);
          Rv6=Rv4;
          Ra.sl[6]=1391; /* line # 1391 */
          Rv5=((SL *)Rv3)[11];
          ((UB *)Rv6)[48]=31;
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1397; /* line # 1397 */
          Rv5=0;
        }
      }
      if (Rv5>0) {
        (*F_iadr)=(*F_iadr)+Rv5;
        if (Lx[2].v[0]==NULL) Lx[2].v[0]=Rv4;
        else {
          Ra.sl[6]=1402; /* line # 1402 */
          ((V *)Lx[2].v[1])[0]=Rv4;
        }
        Lx[2].v[1]=Rv4;
      }
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[6]=1410; /* line # 1410 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Rv7=((V *)Rv0)[14];
    Rv8=((V *)Rv7)[1];
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1415; /* line # 1415 */
    Rv10=((V *)Rv9)[0];
    Rv11=Rv8;
    Rv12=((SL *)Rv11)[4];
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1420; /* line # 1420 */
      Rv13=((V *)Rv11)[7];
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1426; /* line # 1426 */
      Rv15=NULL;
    }
    if (((V *)Rv0)[4]!=NULL) {
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1431; /* line # 1431 */
      Rv17=Rv16;
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+471,142,3);
      else {
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else Rv18=Rv12-1;
      }
      Ra.sl[6]=1436; /* line # 1436 */
      P_lgt_free(&Rv16);
    }
    Rv19=((V *)Rv10)[0];
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1441; /* line # 1441 */
      Rv19=Rv9;
    }
    else {
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1448; /* line # 1448 */
        while (Rv18>0&&Rv19!=NULL){
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1455; /* line # 1455 */
    if (Rv19!=NULL) {
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000006(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+475;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1466; /* line # 1466 */
  Rv0=F_ty;
  Rv1=0;
  Ra.v[0]=NULL;
  Ra.v[1]=NULL;
  Ra.sl[10]=1471; /* line # 1471 */
  Rv2=NULL;
  Rv3=NULL;
  Rv4=((SL *)Rv0)[11];
  Rv5=0;
  Ra.sl[10]=1476; /* line # 1476 */
  if (((V *)Rv0)[4]!=NULL) {
    Rv6=((V *)Rv0)[4];
    Rv7=((V *)Rv0)[7];
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1481; /* line # 1481 */
      Rv8=Rv6;
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[4],0);
      ((SL *)Rv9)[4]=((SL *)Rv8)[15];
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1486; /* line # 1486 */
        ((V *)Rv3)[0]=Rv9;
      }
      Rv3=Rv9;
      Rv10=((V *)Rv9)[7];
      P_val_new(&Rv10,((V *)Rv8)[4]);
      ((V *)Rv10)[4]=((V *)Rv8)[4];
      Ra.sl[10]=1491; /* line # 1491 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[4])[11];
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else((V *)Ra.v[1])[0]=Rv10;
      Ra.v[1]=Rv10;
      Ra.sl[10]=1496; /* line # 1496 */
      ((V *)Rv8)[10]=Rv9;
      ((UB *)Rv8)[64]=1;
      Rv7=((V *)Rv7)[0];
      Rv6=((V *)Rv8)[3];
      if (((V *)Rv8)[4]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1501; /* line # 1501 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1506; /* line # 1506 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1511; /* line # 1511 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      P_lgt_free(&Rv7);
    }
    else P_src_error(Rd.s+492,147,4);
  }
  Ra.sl[10]=1516; /* line # 1516 */
  if (F_szw>Rv4) Rv4=F_szw;
  if (((UB *)Rv0)[90]) switch (((UB *)Rv0)[92]) {
    case 10:
    case 23:Ra.sl[10]=1521; /* line # 1521 */
    PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
    break;
    case 8:
    case 9:PAS_EXPSION_PRC_00000005(F_ty, &Rv1);
    break;
    default:Ra.sl[10]=1527; /* line # 1527 */
    P_src_error(Rd.s+492,131,3);
    break;
  }
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1534; /* line # 1534 */
    Rv6=((V *)Rv0)[4];
    while (Rv6!=NULL){
      ((UB *)Rv6)[64]=0;
      ((V *)Rv6)[10]=NULL;
      Ra.sl[10]=1539; /* line # 1539 */
      Rv6=((V *)Rv6)[3];
    }
  }
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1545; /* line # 1545 */
  if (Rv4>Rv1) {
    Rv10=NULL;
    P_val_new(&Rv10,NULL);
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1550; /* line # 1550 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.v[1]=Rv10;
    Rv11=Rv10;
    ((UB *)Rv11)[48]=31;
    Ra.sl[10]=1555; /* line # 1555 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    ((SL *)Rv11)[13]=0;
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1580; /* line # 1580 */
  Rv10=NULL;
  P_val_new(&Rv10, F_ty);
  Rv12=Rv10;
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1585; /* line # 1585 */
  ((SL *)Rv12)[6]=Rv4;
  ((V *)Rv12)[7]=Ra.v[0];
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1594; /* line # 1594 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1625; /* line # 1625 */
  Rv0=((V *)F_ip)[4];
  if (!((UB *)Rv0)[89]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[6];
  Ra.sl[6]=1631; /* line # 1631 */
  ((UW *)Rv1)[32]=((UW *)Rv1)[32]|16;
  if ((((UB *)Rv1)[66]==6||((UB *)Rv1)[66]==1)&&((SL *)Rv1)[10]>1) {
    Ra.sl[6]=1636; /* line # 1636 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else Rv4=((V *)Rv2)[4];
    Rv5=NULL;
    Rv6=NULL;
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1641; /* line # 1641 */
    Rv8=Rv4;
    while (Rv7!=NULL){
      Ra.sl[6]=1646; /* line # 1646 */
      P_lgt_new(&Rv9,((V *)Rv4)[4],13,NULL);
      Rv10=Rv9;
      Rv11=Rv8;
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      ((SL *)Rv10)[4]=((SL *)Rv11)[15];
      Ra.sl[6]=1651; /* line # 1651 */
      ((V *)Rv11)[10]=Rv9;
      ((UB *)Rv11)[64]=1;
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1657; /* line # 1657 */
      Rv7=((V *)Rv7)[0];
      Rv8=((V *)Rv8)[3];
      Rv12=P_lgt_new_code(3, Rv9);
      if (Rv5==NULL) Rv5=Rv12;
      else((V *)Rv6)[0]=Rv12;
      Ra.sl[6]=1662; /* line # 1662 */
      Rv6=Rv12;
    }
    if (((UB *)Rv2)[90]) {
      Ra.sl[6]=1667; /* line # 1667 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1672; /* line # 1672 */
    if (Rv5!=NULL) switch (((UB *)Rv3)[104]) {
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
      else {
        Ra.sl[6]=1677; /* line # 1677 */
        ((V *)((V *)Rv3)[17])[0]=Rv5;
      }
      ((V *)Rv3)[17]=Rv6;
      break;
      default:break;
    }
    Ra.sl[6]=1682; /* line # 1682 */
    while (Rv4!=NULL){
      Rv13=Rv4;
      ((V *)Rv13)[10]=NULL;
      ((UB *)Rv13)[64]=0;
      Ra.sl[6]=1687; /* line # 1687 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1692; /* line # 1692 */
    if (((V *)Rv1)[9]==NULL) {
      ((UW *)Rv1)[32]=((UW *)Rv1)[32]|8;
      ((V *)Rv1)[9]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+510;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1714; /* line # 1714 */
  Rv0=F_p;
  if (((V *)Rv0)[5]!=NULL) F_puna=P_exp_val_una(F_puna,((V *)Rv0)[5]);
  Rv1=F_puna;
  Ra.sl[6]=1719; /* line # 1719 */
  if (((UB *)Rv1)[40]==14) {
    Rv2=((V *)Rv1)[7];
    ((UW *)Rv1)[10]=1;
    switch (((UB *)Rv0)[56]) {
      case 6:Ra.sl[6]=1724; /* line # 1724 */
      ((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]<=0);
      break;
      case 43:((SL *)Rv2)[13]=((SL *)Rv2)[13]+1;
      break;
      case 44:((SL *)Rv2)[13]=((SL *)Rv2)[13]-1;
      break;
      case 45:Ra.sl[6]=1730; /* line # 1730 */
      ((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]&1);
      break;
      case 10:if (((UB *)Rv2)[48]==11||((UB *)Rv2)[48]==17) {
        if (((SL *)Rv2)[13]>=0) ((SL *)Rv2)[13]=-1-((SL *)Rv2)[13];
        else {
          Ra.sl[6]=1735; /* line # 1735 */
          ((SL *)Rv2)[13]= -(1+((SL *)Rv2)[13]);
        }
      }
      break;
      case 46:((SL *)Rv2)[13]= -((SL *)Rv2)[13];
      break;
      case 61:
      case 77:((G *)Rv2)[7]=-((G *)Rv2)[7];
      break;
      case 47:Ra.sl[6]=1741; /* line # 1741 */
      ((SL *)Rv2)[13]=abs(((SL *)Rv2)[13]);
      break;
      case 62:
      case 78:((G *)Rv2)[7]=fabs(((G *)Rv2)[7]);
      break;
      case 48:((SL *)Rv2)[13]=PAS__I_SQR(((SL *)Rv2)[13]);
      break;
      case 63:
      case 79:Ra.sl[6]=1747; /* line # 1747 */
      ((G *)Rv2)[7]=PAS__G_SQR(((G *)Rv2)[7]);
      break;
      case 64:
      case 80:((G *)Rv2)[7]=(double)((SL *)Rv2)[13];
      break;
      case 65:
      case 81:Ra.sl[6]=1752; /* line # 1752 */
      ((SL *)Rv2)[13]=PAS__G_ROUND(((G *)Rv2)[7]);
      break;
      case 66:
      case 82:((SL *)Rv2)[13]=(int)(((G *)Rv2)[7]);
      break;
      case 92:
      case 110:Ra.sl[6]=1757; /* line # 1757 */
      if (((G *)Rv2)[7]<0.000000000000000E-001) P_src_error(Rd.s+525,801,2);
      else((G *)Rv2)[7]=sqrt(((G *)Rv2)[7]);
      break;
      case 93:
      case 111:((G *)Rv2)[7]=sin(((G *)Rv2)[7]);
      break;
      case 94:
      case 112:Ra.sl[6]=1763; /* line # 1763 */
      ((G *)Rv2)[7]=cos(((G *)Rv2)[7]);
      break;
      case 95:
      case 113:((G *)Rv2)[7]=tan(((G *)Rv2)[7]);
      break;
      case 96:
      case 114:Ra.sl[6]=1769; /* line # 1769 */
      if (fabs(((G *)Rv2)[7])>1.000000000000000E+000) P_src_error(Rd.s+525,802,2);
      else((G *)Rv2)[7]=asin(((G *)Rv2)[7]);
      break;
      case 97:
      case 115:if (fabs(((G *)Rv2)[7])>1.000000000000000E+000) P_src_error(Rd.s+
525,803,2);
      else {
        Ra.sl[6]=1774; /* line # 1774 */
        ((G *)Rv2)[7]=acos(((G *)Rv2)[7]);
      }
      break;
      case 98:
      case 116:((G *)Rv2)[7]=atan(((G *)Rv2)[7]);
      break;
      case 102:
      case 120:Ra.sl[6]=1779; /* line # 1779 */
      ((G *)Rv2)[7]=PAS__SHG(((G *)Rv2)[7]);
      break;
      case 103:
      case 121:((G *)Rv2)[7]=PAS__CHG(((G *)Rv2)[7]);
      break;
      case 104:
      case 122:((G *)Rv2)[7]=PAS__THG(((G *)Rv2)[7]);
      break;
      case 105:
      case 123:Ra.sl[6]=1786; /* line # 1786 */
      ((G *)Rv2)[7]=PAS__ASHG(((G *)Rv2)[7]);
      break;
      case 106:
      case 124:if (((G *)Rv2)[7]<1.000000000000000E+000) P_src_error(Rd.s+525,805,2);
      else((G *)Rv2)[7]=PAS__ACHG(((G *)Rv2)[7]);
      break;
      case 107:
      case 125:Ra.sl[6]=1793; /* line # 1793 */
      if (fabs(((G *)Rv2)[7])>1.000000000000000E+000) P_src_error(Rd.s+525,806,2);
      else((G *)Rv2)[7]=PAS__ATHG(((G *)Rv2)[7]);
      break;
      case 100:
      case 118:((G *)Rv2)[7]=exp(((G *)Rv2)[7]);
      break;
      case 101:
      case 119:Ra.sl[6]=1800; /* line # 1800 */
      if (((G *)Rv2)[7]<=0.000000000000000E-001) P_src_error(Rd.s+525,804,2);
      else((G *)Rv2)[7]=log(((G *)Rv2)[7]);
      break;
      default:break;
    }
    Ra.sl[6]=1805; /* line # 1805 */
    ((V *)Rv1)[4]=NULL;
    if (((V *)Rv0)[2]==V_typ_std.v[29]||((V *)Rv0)[2]==V_typ_std.v[28]) ((V *)Rv1)
    [3]=((V *)F_puna)[3];
    else((V *)Rv1)[3]=((V *)Rv0)[2];
    Ra.sl[6]=1810; /* line # 1810 */
    ((V *)Rv2)[4]=((V *)Rv1)[3];
    ((UB *)Rv2)[48]=((UB *)((V *)Rv1)[3])[92];
  }
  else {
    Ra.sl[6]=1815; /* line # 1815 */
    if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+525,851,2);
    if (((UB *)Rv0)[56]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])[
11]) {
      P_lgt_new(&Rv3,((V *)Rv0)[2],6, F_puna);
      Ra.sl[6]=1820; /* line # 1820 */
      Rv4=Rv3;
      if (((V *)Rv4)[3]==V_typ_std.v[29]||((V *)Rv4)[3]==V_typ_std.v[28]) ((V *)
      Rv4)[3]=((V *)F_puna)[3];
      Ra.sl[6]=1825; /* line # 1825 */
      ((V *)Rv4)[0]=((V *)F_puna)[0];
      ((UB *)Rv4)[41]=((UB *)Rv0)[56];
      ((UW *)Rv4)[10]=((UW *)F_puna)[10]&~2;
      ((V *)Rv1)[0]=NULL;
      Ra.sl[6]=1830; /* line # 1830 */
      F_puna=Rv3;
    }
    else((V *)F_puna)[3]=((V *)Rv0)[2];
  }
  Ra.sl[6]=1835; /* line # 1835 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  G Rv5;
  register V Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  UL Rv10;
  register V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+529;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1856; /* line # 1856 */
  Rv0=((V *)F_ob1)[0];
  Rv1=F_p;
  if (((V *)Rv1)[5]!=NULL) F_ob1=P_exp_val_una(F_ob1,((V *)Rv1)[5]);
  Ra.sl[6]=1861; /* line # 1861 */
  if (((V *)Rv1)[6]!=NULL) Rv0=P_exp_val_una(Rv0,((V *)Rv1)[6]);
  ((V *)F_ob1)[0]=Rv0;
  if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
    Ra.sl[6]=1866; /* line # 1866 */
    Rv2=((V *)F_ob1)[7];
    Rv3=Rv0;
    switch (((UB *)Rv1)[56]) {
      case 89:((SL *)Rv2)[13]=PAS__IIPOWER(((SL *)Rv2)[13],((SL *)((V *)Rv3)[7])
      [13]);
      break;
      case 90:
      case 108:((G *)Rv2)[7]=pow  (((G *)Rv2)[7],((G *)((V *)Rv3)[7])[7]);
      break;
      case 91:
      case 109:Ra.sl[6]=1872; /* line # 1872 */
      ((G *)Rv2)[7]=PAS__IGPOWER(((G *)Rv2)[7],((SL *)((V *)Rv3)[7])[13]);
      break;
      case 49:((SL *)Rv2)[13]=((SL *)Rv2)[13]+((SL *)((V *)Rv3)[7])[13];
      break;
      case 50:((SL *)Rv2)[13]=((SL *)Rv2)[13]-((SL *)((V *)Rv3)[7])[13];
      break;
      case 51:((SL *)Rv2)[13]=((SL *)Rv2)[13]*((SL *)((V *)Rv3)[7])[13];
      break;
      case 52:Ra.sl[6]=1877; /* line # 1877 */
      ((SL *)Rv2)[13]=((SL *)Rv2)[13]/((SL *)((V *)Rv3)[7])[13];
      break;
      case 53:((SL *)Rv2)[13]=PAS__I_MOD(((SL *)Rv2)[13],((SL *)((V *)Rv3)[7])[13]
      );
      break;
      case 54:((SL *)Rv2)[13]=((SL *)Rv2)[13]%((SL *)((V *)Rv3)[7])[13];
      break;
      case 67:
      case 85:Ra.sl[6]=1882; /* line # 1882 */
      ((G *)Rv2)[7]=((G *)Rv2)[7]+((G *)((V *)Rv3)[7])[7];
      break;
      case 68:
      case 86:((G *)Rv2)[7]=((G *)Rv2)[7]-((G *)((V *)Rv3)[7])[7];
      break;
      case 69:
      case 87:((G *)Rv2)[7]=((G *)Rv2)[7]*((G *)((V *)Rv3)[7])[7];
      break;
      case 70:
      case 88:Ra.sl[6]=1888; /* line # 1888 */
      ((G *)Rv2)[7]=((G *)Rv2)[7]/((G *)((V *)Rv3)[7])[7];
      break;
      case 7:((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]>0&&((SL *)((V *)Rv3)[7])[13]>0)
      ;
      break;
      case 8:((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]>0||((SL *)((V *)Rv3)[7])[13]>0)
      ;
      break;
      case 9:((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]>0!=((SL *)((V *)Rv3)[7])[13]>0)
      ;
      break;
      case 11:Ra.sl[6]=1895; /* line # 1895 */
      ((UL *)Rv2)[13]=((UL *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13];
      break;
      case 12:((UL *)Rv2)[13]=(((UL *)Rv2)[13]|((UL *)((V *)Rv3)[7])[13])&~(((UL
       *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13]);
      break;
      case 13:((UL *)Rv2)[13]=((UL *)Rv2)[13]&~((UL *)((V *)Rv3)[7])[13];
      break;
      case 14:((UL *)Rv2)[13]=((UL *)Rv2)[13]|((UL *)((V *)Rv3)[7])[13];
      break;
      case 15:Ra.sl[6]=1900; /* line # 1900 */
      ((SL *)Rv2)[13]=(SL)((((UL *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13])!=0);
      break;
      case 16:break;
      case 17:break;
      case 18:break;
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:Ra.sl[6]=1909; /* line # 1909 */
      switch (((UB *)Rv1)[56]) {
        case 19:
        case 20:Rv4=(SL)PAS__SET_LE(((UL *)Rv2)[13],((UL *)((V *)Rv3)[7])[13]);
        break;
        case 21:
        case 22:Rv4=(SL)PAS__SET_LE(((UL *)((V *)Rv3)[7])[13],((UL *)Rv2)[13]);
        break;
        case 23:Ra.sl[6]=1914; /* line # 1914 */
        Rv4=(SL)(((UL *)Rv2)[13]!=((UL *)((V *)Rv3)[7])[13]);
        break;
        case 24:Rv4=(SL)(((UL *)Rv2)[13]==((UL *)((V *)Rv3)[7])[13]);
        break;
        default:break;
      }
      ((UB *)Rv2)[48]=1;
      Ra.sl[6]=1919; /* line # 1919 */
      ((SL *)Rv2)[6]=0;
      ((SL *)Rv2)[13]=Rv4;
      break;
      case 25:Rv4=(SL)((1<<((SL *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13])!=0);
      break;
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:Ra.sl[6]=1928; /* line # 1928 */
      Rv4=((SL *)Rv2)[13]-((SL *)((V *)Rv3)[7])[13];
      switch (((UB *)Rv1)[56]) {
        case 28:
        case 32:((SL *)Rv2)[13]=(SL)(Rv4<0);
        break;
        case 29:
        case 33:((SL *)Rv2)[13]=(SL)(Rv4<=0);
        break;
        case 30:
        case 34:((SL *)Rv2)[13]=(SL)(Rv4>=0);
        break;
        case 31:
        case 35:Ra.sl[6]=1933; /* line # 1933 */
        ((SL *)Rv2)[13]=(SL)(Rv4>0);
        break;
        case 27:((SL *)Rv2)[13]=(SL)(Rv4!=0);
        break;
        case 26:((SL *)Rv2)[13]=(SL)(Rv4==0);
        break;
      }
      break;
      case 55:
      case 56:
      case 57:
      case 58:
      case 59:
      case 60:
      case 71:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:Ra.sl[6]=1941; /* line # 1941 */
      Rv5=((G *)Rv2)[7]-((G *)((V *)Rv3)[7])[7];
      switch (((UB *)Rv1)[56]) {
        case 55:
        case 71:((SL *)Rv2)[13]=(SL)(Rv5<0.000000000000000E-001);
        break;
        case 56:
        case 72:((SL *)Rv2)[13]=(SL)(Rv5<=0.000000000000000E-001);
        break;
        case 57:
        case 73:((SL *)Rv2)[13]=(SL)(Rv5>=0.000000000000000E-001);
        break;
        case 58:
        case 74:Ra.sl[6]=1946; /* line # 1946 */
        ((SL *)Rv2)[13]=(SL)(Rv5>0.000000000000000E-001);
        break;
        case 60:
        case 76:((SL *)Rv2)[13]=(SL)(Rv5!=0.000000000000000E-001);
        break;
        case 59:
        case 75:((SL *)Rv2)[13]=(SL)(Rv5==0.000000000000000E-001);
        break;
      }
      break;
      case 36:
      case 37:break;
      case 99:
      case 117:Ra.sl[6]=1958; /* line # 1958 */
      ((G *)Rv2)[7]=atan2(((G *)Rv2)[7],((G *)((V *)Rv3)[7])[7]);
      break;
      default:break;
    }
    Rv6=F_ob1;
    Rv7=((V *)Rv6)[7];
    Ra.sl[6]=1964; /* line # 1964 */
    ((V *)Rv6)[4]=NULL;
    if (((V *)Rv1)[2]==V_typ_std.v[29]||((V *)Rv1)[2]==V_typ_std.v[28]) ((V *)Rv6)
    [3]=((V *)F_ob1)[3];
    else((V *)Rv6)[3]=((V *)Rv1)[2];
    Ra.sl[6]=1969; /* line # 1969 */
    ((V *)Rv7)[4]=((V *)Rv6)[3];
    ((UB *)Rv7)[48]=((UB *)((V *)Rv6)[3])[92];
    ((V *)F_ob1)[0]=NULL;
    P_lgt_free(&Rv0);
  }
  else {
    Ra.sl[6]=1977; /* line # 1977 */
    Rv8=1;
    switch (((UB *)Rv1)[56]) {
      case 25:if (((UB *)F_ob1)[40]==14) {
        Ra.sl[6]=1982; /* line # 1982 */
        Rv9=F_ob1;
        Rv10=((SL *)((V *)Rv9)[7])[13];
        ((V *)Rv9)[3]=((V *)Rv0)[3];
        P_val_free(((V *)Rv9)+7);
        Ra.sl[6]=1987; /* line # 1987 */
        P_val_new(((V *)Rv9)+7,((V *)Rv9)[3]);
        Rv11=((V *)Rv9)[7];
        ((SL *)Rv11)[6]=(Rv10+7)/8;
        ((UL *)Rv11)[13]=1<<Rv10;
        Ra.sl[6]=1994; /* line # 1994 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Rv12=Rv0;
        ((UW *)Rv12)[10]=1;
        ((UB *)Rv12)[41]=15;
        Ra.sl[6]=2000; /* line # 2000 */
        Rv8=0;
      }
      break;
      case 7:if (((UB *)F_ob1)[40]==14) {
        Ra.sl[6]=2005; /* line # 2005 */
        Rv13=F_ob1;
        ((V *)F_ob1)[0]=NULL;
        Rv8=0;
        if (((SL *)((V *)Rv13)[7])[13]<=0) {
          Ra.sl[6]=2011; /* line # 2011 */
          P_lgt_free_tree(&Rv0);
          Rv0=F_ob1;
        }
        else P_lgt_free(&F_ob1);
      }
      else {
        Ra.sl[6]=2018; /* line # 2018 */
        if (((UB *)Rv0)[40]==14) {
          Rv14=Rv0;
          ((V *)F_ob1)[0]=NULL;
          Rv8=0;
          Ra.sl[6]=2023; /* line # 2023 */
          if (((SL *)((V *)Rv14)[7])[13]<=0) P_lgt_free_tree(&F_ob1);
          else {
            P_lgt_free(&Rv0);
            Ra.sl[6]=2028; /* line # 2028 */
            Rv0=F_ob1;
          }
        }
      }
      break;
      case 8:Ra.sl[6]=2033; /* line # 2033 */
      if (((UB *)F_ob1)[40]==14) {
        Rv15=F_ob1;
        ((V *)F_ob1)[0]=NULL;
        Rv8=0;
        Ra.sl[6]=2038; /* line # 2038 */
        if (((SL *)((V *)Rv15)[7])[13]>0) {
          P_lgt_free_tree(&Rv0);
          Rv0=F_ob1;
        }
        else {
          Ra.sl[6]=2044; /* line # 2044 */
          P_lgt_free(&F_ob1);
        }
      }
      else {
        if (((UB *)Rv0)[40]==14) {
          Rv16=Rv0;
          Ra.sl[6]=2050; /* line # 2050 */
          ((V *)F_ob1)[0]=NULL;
          Rv8=0;
          if (((SL *)((V *)Rv16)[7])[13]>0) P_lgt_free_tree(&F_ob1);
          else {
            Ra.sl[6]=2056; /* line # 2056 */
            P_lgt_free(&Rv0);
            Rv0=F_ob1;
          }
        }
      }
      break;
      case 1:
      case 3:
      case 4:
      case 5:Ra.sl[6]=2063; /* line # 2063 */
      Rv17=F_ob1;
      ((UW *)Rv17)[10]=((UW *)Rv17)[10]|8;
      if (!(2&((UW *)Rv17)[10])) P_src_error(Rd.s+544,852,2);
      Ra.sl[6]=2068; /* line # 2068 */
      Rv18=Rv0;
      if (!(1&((UW *)Rv18)[10])) P_src_error(Rd.s+544,851,1);
      if ((((UB *)Rv1)[56]!=1&&((UB *)Rv18)[40]==8)&&((V *)Rv18)[3]!=NULL) {
        Ra.sl[6]=2075; /* line # 2075 */
        Rv19=((V *)Rv18)[6];
        if (((V *)Rv19)[8]!=NULL) {
          if (((UB *)((V *)Rv19)[8])[66]==6) {
            ((V *)F_ob1)[0]=((V *)((V *)Rv18)[1])[0];
            Ra.sl[6]=2080; /* line # 2080 */
            P_lgt_free(((V *)Rv18)+1);
            ((UW *)Rv18)[10]=((UW *)Rv18)[10]|128;
            ((V *)Rv18)[1]=F_ob1;
            Rv8=0;
          }
        }
      }
      break;
      default:Ra.sl[6]=2088; /* line # 2088 */
      if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) P_src_error(Rd.s+544,851,1);
      break;
    }
    if (Rv8) {
      Ra.sl[6]=2093; /* line # 2093 */
      P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
      Rv20=Rv0;
      if (((V *)Rv20)[3]==V_typ_std.v[29]||((V *)Rv20)[3]==V_typ_std.v[28]) ((V *)
      Rv20)[3]=((V *)F_ob1)[3];
      Ra.sl[6]=2098; /* line # 2098 */
      ((UW *)Rv20)[10]=1;
      ((UB *)Rv20)[41]=((UB *)Rv1)[56];
    }
    F_ob1=Rv0;
  }
  Ra.sl[6]=2105; /* line # 2105 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+548;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2120; /* line # 2120 */
  Rv0=F_lgt;
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2125; /* line # 2125 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) Rv0=((V *)Rv1)[1];
    else Rv0=NULL;
  }
  Ra.sl[6]=2131; /* line # 2131 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2137; /* line # 2137 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+569;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2158; /* line # 2158 */
  Rv0=0;
  Rv1=NULL;
  if ((*F_lgt)!=NULL) {
    Rv2=(*F_lgt);
    Ra.sl[6]=2163; /* line # 2163 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Rv3=((V *)Rv2)[1];
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2168; /* line # 2168 */
  if (Rv1!=NULL) {
    Rv4=Rv1;
    Rv5=NULL;
    Rv6=NULL;
    Ra.sl[6]=2173; /* line # 2173 */
    Rv7=((V *)Rv4)[8];
    if (((V *)Rv4)[11]!=NULL) {
      Rv8=((V *)Rv4)[11];
      if (!((UB *)Rv8)[91]) {
        Ra.sl[6]=2184; /* line # 2184 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        ((V *)(*F_lgt))[1]=Rv5;
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2191; /* line # 2191 */
    while (Rv7!=NULL){
      Rv9=NULL;
      Rv10=0;
      Rv11=0;
      Ra.sl[6]=2196; /* line # 2196 */
      Rv12=Rv3;
      Rv13=Rv7;
      if (Rv3!=NULL) {
        Ra.sl[6]=2201; /* line # 2201 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          if (((V *)Rv13)[4]!=NULL) {
            Ra.sl[6]=2206; /* line # 2206 */
            Rv14=((V *)Rv13)[4];
            switch (((UB *)Rv14)[92]) {
              case 10:if (P_comp_type(((V *)Rv13)[4],V_typ_std.v[10],0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1)) {
                Ra.sl[6]=2211; /* line # 2211 */
                if (((UB *)Rv3)[40]==14) {
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  P_val_free(((V *)Rv3)+7);
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2216; /* line # 2216 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Rv16=((V *)Rv3)[7];
                  ((UB *)Rv16)[48]=32;
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2221; /* line # 2221 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2227; /* line # 2227 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  ((V *)Rv3)[0]=Rv17;
                  ((UW *)Rv3)[10]=5;
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2232; /* line # 2232 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2238; /* line # 2238 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0)) {
                Rv10=1;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2243; /* line # 2243 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[4],3, Rv3);
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2250; /* line # 2250 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0)) {
                  Rv10=1;
                  Rv11=1;
                }
              }
              if (((UB *)Rv14)[92]==9) Rv9=((V *)Rv13)[4];
              break;
              case 13:
              case 14:
              case 15:
              case 17:
              case 18:
              case 19:
              case 20:
              case 21:
              case 29:Ra.sl[6]=2259; /* line # 2259 */
              if (Rv6==NULL) Rv6=((V *)Rv3)[3];
              else {
                if (((UB *)Rv6)[91]&&!((UB *)((V *)Rv3)[3])[91]||((SL *)Rv6)[11]
                <((SL *)((V *)Rv3)[3])[11]) Rv6=((V *)Rv3)[3];
              }
              break;
              default:break;
            }
            Ra.sl[6]=2269; /* line # 2269 */
            switch (((UB *)Rv13)[66]) {
              case 7:if (!(4&((UW *)Rv3)[10])) {
                Ra.sl[6]=2274; /* line # 2274 */
                Rv18=Rv3;
                if (64&((UW *)Rv13)[32]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[6]=2280; /* line # 2280 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
              }
              break;
              case 10:Ra.sl[6]=2287; /* line # 2287 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2292; /* line # 2292 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else((V *)Rv5)[0]=Rv3;
              break;
              default:break;
            }
            Ra.sl[6]=2298; /* line # 2298 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2304; /* line # 2304 */
        P_lgt_new(&Rv3,((V *)Rv13)[4],14,NULL);
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else((V *)Rv5)[0]=Rv3;
        Rv0=1;
      }
      Ra.sl[6]=2311; /* line # 2311 */
      if (Rv0) {
        if (8192&((UW *)Rv13)[32]) {
          Rv19=Rv3;
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2316; /* line # 2316 */
          ((V *)Rv19)[3]=((V *)Rv13)[4];
          ((V *)Rv19)[4]=NULL;
        }
        else {
          if (((V *)Rv13)[9]!=NULL) {
            Ra.sl[6]=2321; /* line # 2321 */
            Rv20=Rv3;
            ((UB *)Rv20)[40]=14;
            ((V *)Rv20)[3]=((V *)Rv13)[4];
            ((V *)Rv20)[7]=((V *)Rv13)[9];
            Ra.sl[6]=2326; /* line # 2326 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[4]);
            ((V *)Rv20)[4]=NULL;
          }
          else P_src_error_s(Rd.s+585,854,2,((V *)Rv13)[0],NULL);
        }
      }
      Ra.sl[6]=2331; /* line # 2331 */
      Rv5=Rv3;
      if (Rv9!=NULL) {
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2336; /* line # 2336 */
          Rv21=((V *)Rv9)[15];
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Rv22=Rv12;
            if (((UB *)Rv22)[40]==8) ((UW *)Rv22)[10]=((UW *)Rv22)[10]|128;
            Ra.sl[6]=2342; /* line # 2342 */
            Rv23=((V *)Rv9)[15];
            Rv24=NULL;
            Rv25=NULL;
            if (Rv10) {
              while (1){
                Ra.sl[6]=2349; /* line # 2349 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
              }
              if (Rv11) {
                Ra.sl[6]=2354; /* line # 2354 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Rv7=((V *)Rv7)[3];
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[6]=2359; /* line # 2359 */
                  Rv7=((V *)Rv7)[3];
                }
                else Rv25=Rv24;
              }
              else {
                Ra.sl[6]=2365; /* line # 2365 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Rv25=Rv24;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2371; /* line # 2371 */
                if (((UB *)Rv12)[40]==14) Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)
                Rv12)[7])[6]);
                else {
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[4],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2377; /* line # 2377 */
                  if (!(64&((UW *)Rv7)[32])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[15];
                  if (((V *)Rv17)[3]!=Rv23) {
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2382; /* line # 2382 */
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                Rv7=((V *)Rv7)[3];
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[6]=2387; /* line # 2387 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[6]=2393; /* line # 2393 */
              Rv26=((V *)Rv3)[3];
              if (Rv26!=NULL) while (Rv9!=NULL&&Rv26!=NULL)
              if (((UB *)Rv9)[92]==9&&(((UB *)Rv26)[92]==9||((UB *)Rv26)[92]==8)
              ) {
                Ra.sl[6]=2400; /* line # 2400 */
                Rv27=((V *)Rv26)[15];
                Rv23=((V *)Rv9)[15];
                while (1){
                  if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                  if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
                }
                Ra.sl[6]=2407; /* line # 2407 */
                if (((UB *)Rv27)[92]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                else Rv28=Rv12;
                Ra.sl[6]=2412; /* line # 2412 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  if (((UB *)Rv27)[92]==22) {
                    Rv17=P_lgt_type_eval(((V *)Rv27)[13],Rv28,NULL,0);
                    Ra.sl[6]=2417; /* line # 2417 */
                    if (((SL *)Rv27)[11]!=((SL *)Rv23)[11]) {
                      Rv17=P_lgt_new_code(0, Rv17);
                      ((V *)Rv17)[3]=Rv23;
                    }
                  }
                  else {
                    Ra.sl[6]=2423; /* line # 2423 */
                    Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[29]);
                  }
                  if (Rv25==NULL) Rv24=Rv17;
                  else((V *)Rv25)[0]=Rv17;
                  Rv25=Rv17;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2430; /* line # 2430 */
                if (((UB *)Rv27)[92]==22) {
                  Rv17=P_lgt_type_eval(((V *)Rv27)[14],Rv28,NULL,0);
                  if (Rv27!=Rv23) {
                    Ra.sl[6]=2435; /* line # 2435 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                else Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[30]);
                Ra.sl[6]=2440; /* line # 2440 */
                if (Rv25==NULL) Rv24=Rv17;
                else((V *)Rv25)[0]=Rv17;
                Rv25=Rv17;
                Rv7=((V *)Rv7)[3];
                Rv26=((V *)Rv26)[14];
                Ra.sl[6]=2445; /* line # 2445 */
                Rv9=((V *)Rv9)[14];
              }
              else Rv9=NULL;
              Rv29=Rv3;
              if (((SL *)((V *)Rv29)[3])[10]>0) {
                Ra.sl[6]=2450; /* line # 2450 */
                ((SL *)Rv29)[4]=((SL *)Rv29)[4]+((SL *)((V *)Rv29)[3])[10];
              }
            }
            if (Rv24!=NULL) {
              Ra.sl[6]=2456; /* line # 2456 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              ((V *)Rv3)[0]=Rv24;
              Rv3=Rv25;
            }
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2463; /* line # 2463 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Rv7=((V *)Rv7)[3];
    }
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2468; /* line # 2468 */
      Rv30=(*F_lgt);
      if (((UB *)((V *)Rv4)[11])[92]==29||((UB *)((V *)Rv4)[11])[92]==28) {
        Ra.sl[6]=2473; /* line # 2473 */
        ((V *)Rv30)[3]=Rv6;
        if (!((UB *)Rv6)[91]&&((V *)Rv30)[1]!=NULL) ((V *)((V *)Rv30)[1])[3]=Rv6;
      }
      Ra.sl[6]=2479; /* line # 2479 */
      if (!((UB *)((V *)Rv4)[11])[91]) P_tmpstk_allocate(((V *)Rv30)[1],((V *)((
      V *)Rv30)[1])[3]);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wrt "  */
void PAS_EXPSION_PRC_00000007(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+589;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2525; /* line # 2525 */
  if (F_pt!=NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_ENM(((UB *)F_pt)[92],Rd.s+596,14,-1,32);
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1214,14,-1,32);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_request "  */
void PAS_EXPSION_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1224;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2529; /* line # 2529 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1238,-1,-1,32);
  PAS__WRITE_INT(Lx[3].sl[9],0,0);
  PAS__WRITE_STR(Rd.s+1265,-1,-1,32);
  if (Lx[3].v[5]!=NULL) {
    Rv0=Lx[3].v[5];
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1273,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[3]);
    Ra.sl[6]=2534; /* line # 2534 */
    if (((V *)Rv0)[0]!=NULL) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1288,-1,-1,32);
      PAS_EXPSION_PRC_00000007(((V *)((V *)Rv0)[0])[3]);
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=2539; /* line # 2539 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1305,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_entry "  */
void PAS_EXPSION_PRC_00000009(V F_pg, UB F_bt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1314;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2544; /* line # 2544 */
  Rv0=F_pg;
  if (((UB *)Rv0)[8]&&Lx[3].sl[9]<=2) {
    if (F_bt) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1326,-1,-1,32);
    }
    else {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1344,-1,-1,32);
    }
    Ra.sl[6]=2549; /* line # 2549 */
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[3]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1356,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[4]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1360,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[2]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1366,-1,-1,32);
    PAS__WRITE_ENM(((UB *)Rv0)[56],Rd.s+1380,0,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dump "  */
void PAS_EXPSION_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3434;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2556; /* line # 2556 */
  PAS_EXPSION_PRC_00000008();
  while (Lx[3].v[0]!=NULL){
    Rv0=Lx[3].v[0];
    PAS_EXPSION_PRC_00000009(Lx[3].v[0],0);
    Ra.sl[6]=2561; /* line # 2561 */
    Lx[3].v[0]=((V *)Rv0)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  register V Rv11;
  register V Rv12;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.sl[9]=F_npa;
  Ra.v[5]=F_parm_lst;
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+3440;
  Ra.v[3]=Rd.s+13;
  Ra.sl[8]=2572; /* line # 2572 */
  Ra.v[0]=(*F_pg);
  Ra.sl[8]=2577; /* line # 2577 */
  Rv0=0;
  while (!Rv0&&(*F_pg)!=NULL){
    Rv1=Ra.v[5];
    Rv2=(*F_pg);
    Ra.sl[8]=2582; /* line # 2582 */
    if (((UB *)Rv2)[8]&&Ra.sl[9]<=2) {
      Rv3=Rv1;
      switch (Ra.sl[9]) {
        case 0:Rv0=((V *)Rv2)[3]==NULL&&((V *)Rv2)[4]==NULL;
        break;
        case 1:Ra.sl[8]=2587; /* line # 2587 */
        Rv0=((V *)Rv2)[4]==NULL&&P_comp_type(((V *)Rv3)[3],((V *)Rv2)[3],0);
        break;
        case 2:if (((SL *)((V *)Rv3)[3])[11]>0&&((SL *)((V *)((V *)Rv3)[0])[3])[
11]>0) switch (((UB *)((V *)Rv2)[3])[92]) {
          case 28:Ra.sl[8]=2593; /* line # 2593 */
          Rv0=((P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv3)[3],1)&&((SL *)((V
           *)Rv3)[3])[10]==0)&&((SL *)((V *)Rv3)[3])[11]==((SL *)((V *)((V *)Rv3)
          [0])[3])[11])&&P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv2)[4],0);
          break;
          case 29:Ra.sl[8]=2599; /* line # 2599 */
          Rv0=((P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv3)[3],0)||P_comp_type((
          (V *)Rv3)[3],((V *)((V *)Rv3)[0])[3],0))&&P_comp_type(((V *)Rv3)[3],((
          V *)Rv2)[4],0))&&P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv2)[4],0);
          break;
          case 30:Ra.sl[8]=2605; /* line # 2605 */
          Rv0=(P_comp_type(((V *)((V *)Rv3)[0])[3],V_typ_std.v[19],0)&&P_comp_type((
          (V *)Rv3)[3],((V *)((V *)((V *)Rv3)[0])[3])[13],0))&&P_comp_type(((V *)(
          (V *)Rv3)[0])[3],((V *)Rv2)[4],0);
          break;
          default:Ra.sl[8]=2611; /* line # 2611 */
          Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv2)[3],1)&&P_comp_type(((V *)((V *)
          Rv3)[0])[3],((V *)Rv2)[4],1);
          break;
        }
        break;
      }
    }
    else {
      Ra.sl[8]=2617; /* line # 2617 */
      Rv4=((V *)Rv2)[2];
      if (((SL *)Rv4)[20]>=Ra.sl[9]) {
        Rv5=((V *)Rv4)[8];
        if (((V *)Rv4)[8]!=NULL) {
          Ra.sl[8]=2622; /* line # 2622 */
          if (((UB *)((V *)Rv4)[8])[66]==6) Rv5=((V *)Rv5)[3];
        }
        if ((Ra.sl[9]==2&&((SL *)Rv4)[20]==2)&&(((UB *)Rv4)[104]==1||((UB *)Rv4)
        [104]==2)) {
          Ra.sl[8]=2627; /* line # 2627 */
          Rv6=Rv1;
          switch (((UB *)((V *)Rv5)[4])[92]) {
            case 28:Rv0=(((V *)((V *)Rv6)[0])[3]==((V *)Rv6)[3]&&((SL *)((V *)Rv6)
            [3])[10]==0)&&P_comp_type(((V *)Rv6)[3],((V *)((V *)Rv5)[3])[4],0);
            break;
            case 29:Ra.sl[8]=2636; /* line # 2636 */
            Rv0=((P_comp_type(((V *)((V *)Rv6)[0])[3],((V *)Rv6)[3],0)||P_comp_type((
            (V *)Rv6)[3],((V *)((V *)Rv6)[0])[3],0))&&P_comp_type(((V *)Rv6)[3],(
            (V *)((V *)Rv5)[3])[4],0))&&P_comp_type(((V *)((V *)Rv6)[0])[3],((V *)(
            (V *)Rv5)[3])[4],0);
            break;
            case 30:Ra.sl[8]=2642; /* line # 2642 */
            if (P_comp_type(((V *)((V *)Rv6)[0])[3],V_typ_std.v[19],0)) Rv0=P_comp_type((
            (V *)Rv6)[3],((V *)((V *)((V *)Rv6)[0])[3])[13],0)&&P_comp_type(((V *)(
            (V *)Rv6)[0])[3],((V *)((V *)Rv5)[3])[4],0);
            break;
            default:Ra.sl[8]=2649; /* line # 2649 */
            Rv0=0;
            break;
          }
        }
        if (!Rv0) {
          Ra.sl[8]=2654; /* line # 2654 */
          Rv0=1;
          while (Rv0&&Rv5!=NULL){
            Rv7=0;
            Rv8=Rv5;
            Ra.sl[8]=2659; /* line # 2659 */
            if (Rv1!=NULL) {
              Rv9=Rv1;
              if (((UB *)Rv9)[40]==17) {
                if (((V *)Rv8)[9]==NULL&&!(8192&((UW *)Rv8)[32])) {
                  Ra.sl[8]=2664; /* line # 2664 */
                  Rv0=0;
                }
                else {
                  Rv5=((V *)Rv8)[3];
                  Rv1=((V *)Rv9)[0];
                }
              }
              else {
                Ra.sl[8]=2671; /* line # 2671 */
                Rv10=P_comp_type(((V *)Rv9)[3],((V *)Rv8)[4],((UB *)Rv8)[66]!=8);
                if (!Rv10&&((UB *)Rv9)[40]==14) {
                  Ra.sl[8]=2676; /* line # 2676 */
                  Rv11=((V *)Rv8)[4];
                  switch (((UB *)Rv11)[92]) {
                    case 4:Ra.sl[8]=2685; /* line # 2685 */
                    if (((UB *)((V *)Rv9)[3])[92]==3) {
                      ((V *)Rv9)[3]=V_typ_std.v[4];
                      Rv10=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[8]=2709; /* line # 2709 */
                    if ((P_comp_type(((V *)Rv11)[14],V_typ_std.v[0],1)&&((UB *)(
                    (V *)Rv11)[15])[92]==2)&&((SL *)Rv11)[10]==0) {
                      if (P_comp_type(((V *)Rv9)[3],V_typ_std.v[10],0)) {
                        Ra.sl[8]=2715; /* line # 2715 */
                        if (((UB *)Rv11)[92]==8) {
                          Rv12=((V *)Rv11)[15];
                          Rv10=(((SL *)Rv12)[30]-((SL *)Rv12)[29])+1==((SL *)((V
                           *)Rv9)[7])[6];
                        }
                        else {
                          Ra.sl[8]=2720; /* line # 2720 */
                          Rv10=1;
                        }
                      }
                      else {
                        if (P_comp_type(((V *)Rv9)[3],V_typ_std.v[0],0)) {
                          if (((UB *)Rv11)[92]==9) Rv10=1;
                          else {
                            Ra.sl[8]=2725; /* line # 2725 */
                            Rv10=((SL *)Rv11)[30]==((SL *)Rv11)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[8]=2730; /* line # 2730 */
                if (Rv10) {
                  if (((V *)Rv8)[4]!=NULL) {
                    if (((UB *)((V *)Rv8)[4])[92]==9) Rv7=((SL *)((V *)Rv8)[4])[
24];
                  }
                  Ra.sl[8]=2735; /* line # 2735 */
                  Rv5=((V *)Rv8)[3];
                  Rv1=((V *)Rv9)[0];
                }
                else Rv0=0;
                if (Rv0) {
                  Ra.sl[8]=2741; /* line # 2741 */
                  if (((UB *)Rv8)[66]==8) {
                    if (!(1&((UW *)Rv9)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[8]=2746; /* line # 2746 */
                    if (4&((UW *)Rv9)[10]) {
                      if (32&((UW *)Rv8)[32]) {
                        if (!(1&((UW *)Rv9)[10])) Rv0=0;
                      }
                      if (64&((UW *)Rv8)[32]) {
                        Ra.sl[8]=2751; /* line # 2751 */
                        if (!(2&((UW *)Rv9)[10])) Rv0=0;
                      }
                    }
                    else {
                      if (64&((UW *)Rv8)[32]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[8]=2759; /* line # 2759 */
              if (((V *)Rv8)[9]==NULL&&!(8192&((UW *)Rv8)[32])) Rv0=0;
              else Rv5=((V *)Rv8)[3];
            }
            Ra.sl[8]=2764; /* line # 2764 */
            if (Rv7>0) while (1){
              Rv5=((V *)Rv5)[3];
              Rv7=Rv7-1;
              if (Rv7==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[8]=2771; /* line # 2771 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  if (!Rv0) {
    PAS_EXPSION_PRC_00000010();
    Ra.sl[8]=2776; /* line # 2776 */
    P_src_error_s(Rd.s+3458,113,3, F_id,NULL);
  }
  else Ra.sl[8]=2782; /* line # 2782 */
  PAS__curr_cntx=Ra.v[1];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3462;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2801; /* line # 2801 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  if (F_p!=NULL) {
    Rv1=F_p;
    Ra.sl[6]=2806; /* line # 2806 */
    if (((UB *)Rv1)[8]) {
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else Rv2=P_exp_val_bin(F_oblst, F_p);
      if (((V *)Rv2)[3]==V_typ_std.v[29]) ((V *)Rv2)[3]=((V *)F_oblst)[3];
    }
    else {
      Ra.sl[6]=2814; /* line # 2814 */
      Rv3=((V *)Rv1)[2];
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      if (((V *)Rv3)[11]==V_typ_std.v[29]) ((V *)Rv2)[3]=((V *)F_oblst)[3];
      Ra.sl[6]=2819; /* line # 2819 */
      P_call_setting(&Rv2);
    }
    Ret=Rv2;
  }
  else Ret=F_oblst;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3475;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2838; /* line # 2838 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Rv0=((V *)F_ip)[10];
  if (F_np<=0) {
    Rv1=F_lgp;
    Ra.sl[6]=2843; /* line # 2843 */
    while (Rv1!=NULL){
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Rv2=NULL;
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2848; /* line # 2848 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=2853; /* line # 2853 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      if (((V *)Rv3)[2]!=NULL) {
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        P_call_setting(&Rv2);
        Ra.sl[6]=2858; /* line # 2858 */
        if (((V *)((V *)Rv3)[2])[11]==V_typ_std.v[29]) ((V *)Rv2)[3]=((V *)F_lgp)
        [3];
      }
    }
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3490;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2869; /* line # 2869 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3501;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2884; /* line # 2884 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else Rv0=((V *)V_ope_table.v[28])[3];
  Rv1=((V *)F_prm)[0];
  Rv2=((UW *)F_prm)[10];
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=2889; /* line # 2889 */
  if (F_bovr) {
    ((UW *)F_prm)[10]=Rv2|3;
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=2894; /* line # 2894 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  if (F_bovr) {
    ((UW *)F_prm)[10]=Rv2;
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=2900; /* line # 2900 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
