/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[3];

/* Define the local data section. */
static Blk( Rd, 2608 ) = {{
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 62,  62,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83,
111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,
 47, 112,  99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,  97, 115,
  3,   3,  84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115,
101, 116,  95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,  29,  32,
 84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111, 117, 114,
 99, 101,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,
 17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95, 115,  98,
116, 116, 108,  33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110,
116,  32,  67, 111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100, 117, 108,
101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116, 107,
101, 121, 119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121, 119,
111, 114, 100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120, 111,
114,   3,   3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105, 118,
  3,   3, 109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,   3,
110, 105, 108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116, 111,
  4,   4, 116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14, 117,
115, 101, 114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3, 118,
 97, 114,   6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,  95,
118,  97, 114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,  99,
 99, 101, 115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,  97,
121,   6,   6, 114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,   3,   3,
117, 115, 101,   3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,   7,   7,
100, 105, 115, 112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,   5, 114,
101, 115, 101, 116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,   6,  97,
112, 112, 101, 110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114, 101,  97,
100, 108, 110,   5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114, 105, 116,
101,   7,   7, 119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114, 105, 116,
101, 118,   7,   7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109, 111, 100,
117, 108, 101,   9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,   8,   8,
102, 117, 110,  99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117, 114, 110,
  7,   7, 102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116, 105,
 99,   6,   6, 103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99, 107, 101,
100,   8,   8, 101, 120, 116, 101, 114, 110,  97, 108,   8,   8, 115, 116,  97,
110, 100,  97, 114, 100,   6,   6, 105, 110, 108, 105, 110, 101,   5,   5,  98,
101, 103, 105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,   4,   4,
101, 108, 115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114, 101, 112,
101,  97, 116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111, 114,   4,
  4, 108, 111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,  97, 115,
101,   4,   4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9, 111, 116,
104, 101, 114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100, 111,   2,
  2, 116, 111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37, 100, 101,
102, 105, 110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110, 101,   4,
  4,  37, 108, 101, 116,   3,   3,  37, 105, 102,   6,   6,  37, 105, 102, 100,
101, 102,   8,   8,  37, 105, 102, 117, 110, 100, 101, 102,   5,   5,  37, 116,
104, 101, 110,   5,   5,  37, 101, 108, 115, 101,   6,   6,  37, 101, 110, 100,
105, 102,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,   8,  37, 105, 110,
 99, 108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103, 109,  97,   4,   4,
 37, 101, 111, 102,  16,  16,  99, 114, 101,  97, 116, 101,  95, 109,  97,  99,
 95, 105, 100, 101, 110, 116,   4,   4,  67,  82,  69,  77,   0,   0,   0,   0,
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  7,   7, 115, 111, 114, 116, 109,  99,  49,  15,  15, 114, 101,  98, 117, 105,
108, 100,  95, 109,  99, 116, 114, 101, 101,  49,  14,  14, 114, 101,  98, 117,
105, 108, 100,  95, 109,  99, 116, 114, 101, 101,   6,   6, 110, 101, 120, 116,
 99, 104,   8,   8, 112, 117, 116,  95,  99, 104,  97, 114,   4,   4,  73,  78,
 83,  89,  12,  12, 116, 101, 115, 116,  95, 102, 105, 103, 117, 114, 101, 115,
  7,   7, 102, 105, 103, 117, 114, 101, 115,   4,   4,  70,  73,  71,  85,  11,
 11, 111, 118, 102,  95, 104,  97, 110, 100, 108, 101, 114,  11,  11,  84, 111,
111,  32,  79,  86,  72,  32,  69,  82,  82,  12,  12, 105, 110, 115, 121, 109,
 98, 111, 108,  95, 115, 114,  99,  13,  13, 115, 107, 105, 112,  95, 109,  99,
115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0, 224,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   4,   4,  77,  67,  83,  75,  16,  16,  99,  98,  95, 109,
 97,  99, 114, 111,  95, 109,  97, 110,  97, 103, 101, 114,  13,  13, 109,  97,
 99, 114, 111,  95, 114, 101, 112, 108,  97,  99, 101,   4,   4,  77,  65,  67,
 84,  19,  19, 100, 101, 102, 105, 110, 101,  95, 109,  97,  99, 114, 111,  95,
115, 121, 109,  98, 111, 108,   4,   4,  67,  82,  77,  83,   0,   0,  12,   0,
  0,   0,  12,   0,  21,  21, 117, 110, 100, 101, 102, 105, 110, 101,  95, 109,
 97,  99, 114, 111,  95, 115, 121, 109,  98, 111, 108,   4,   4,  82,  77,  77,
 83,   0,   0,   0,   0,   0,  12,   0,  19,  19, 109,  97,  99, 114, 111,  95,
 97, 115, 115, 105, 103, 110,  95, 115, 121, 109,  98, 111, 108,   4,   4,  65,
 83,  77,  83,   0,   0,   0,  12,   0,   0,   0,   0,   0,   0,   2,   0,   0,
  4,   0,   0,   0,   9,   9, 115, 104, 111, 119,  95, 109, 118,  97, 108,  15,
 15,  32,  69,  88,  80,  95,  73,  68,  69,  78,  84,  32,  45,  62,  32,  91,
  3,   0,   0,   0,   8,   0,   8, 109, 118,  97, 108,  95, 105, 110, 116,   8,
109, 118,  97, 108,  95, 115, 116, 114,   8, 109, 118,  97, 108,  95, 110, 117,
108,   8, 109, 118,  97, 108,  95, 117, 110, 100,   4,   4,  44,  32, 105,  61,
  5,   5,  44,  32, 115,  61,  34,   2,   2,  34,  93,  11,  11, 115, 104, 111,
119,  95, 109, 115, 116,  97,  99, 107,  15,  15,  32, 115, 116,  97,  99, 107,
 58,  32, 115, 116, 107, 112,  32,  61,  32,   2,   2,  32,  91,   4,   4,  93,
 32,  61,  32,   8,   8, 109, 118,  97, 108,  95,  99, 111, 112,   9,   9, 109,
118,  97, 108,  95, 102, 114, 101, 101,   5,   5, 109, 112, 117, 115, 104,   4,
  4,  77,  80,  85,  83,   4,   4, 109, 112, 111, 112,   4,   4,  77,  80,  79,
 80,  15,  15, 103, 101, 116,  95, 109,  97,  99, 114, 111,  95, 118,  97, 108,
117, 101,   9,   9, 109, 101, 120, 112,  95, 105, 110, 116, 118,  11,  11, 109,
101, 120, 112,  95, 118, 108,  95, 115, 116, 114,   9,   9, 109, 101, 120, 112,
 95, 115, 116, 114, 118,   9,   9, 109, 101, 120, 112,  95,  99,  97, 108, 108,
  4,   4,  77,  67,  65,  76,   0,   0,   7, 100, 101, 102, 105, 110, 101, 100,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   1,   0,   0,   0,   6, 115, 117,  98,
115, 116, 114,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 253, 255, 255, 255,
  5, 105, 110, 100, 101, 120,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  2,   0,   0,   0,   5, 108, 101, 110, 103, 116, 104,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   1,   0,   0,   0,   8,  42,  42,  42,  42,  42,  42,  42,
 42,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   0,   9,   9,  32,  76,
101, 110, 103, 116, 104,  40,  34,   6,   6,  34,  41,  32,  45,  62,  32,  10,
 10, 109, 101, 120, 112,  95, 105, 100, 101, 110, 116,   4,   4,  77,  73,  68,
 69,   0,   0,   0,   0,   0,   8,   0,  10,  10, 109, 101, 120, 112,  95,  98,
105, 110, 111, 112,   4,   4,  77,  66,  73,  78,  10,  10, 109, 101, 120, 112,
 95, 117, 110,  97, 111, 112,   4,   4,  77,  85,  78,  65,   8,   8, 109, 101,
120, 112,  95, 117, 110,  97,   4,   4,  77,  69,  88,  80,   8,   8, 109, 101,
120, 112,  95, 109, 117, 108,   8,   8, 109, 101, 120, 112,  95,  97, 100, 100,
  8,   8, 109, 101, 120, 112,  95, 114, 101, 108,   8,   8, 109, 101, 120, 112,
 95, 110, 111, 116,   8,   8, 109, 101, 120, 112,  95,  97, 110, 100,  12,  12,
109,  95, 101, 120, 112, 114,  95, 105, 110, 115, 116, 107,  10,  10, 109, 101,
120, 112, 114,  95, 115, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95,
105, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95,  98, 118,  97, 108,
  9,   9, 105, 102,  95, 109, 115, 116,  97, 116, 101,   4,   4,  77,  67,  73,
 70, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  13,  13, 112, 114,  97, 103, 109,  97,  95, 109, 115, 116,  97, 116,
101,   4,   4,  80,  82,  65,  71,  14,  14, 105, 110,  99, 108, 117, 100, 101,
 95, 109, 115, 116,  97, 116, 101,   4,   4,  46, 112,  97, 115,   4,   4,  73,
 78,  67,  76,  20,  20,  32,  79, 112, 101, 110,  32,  69, 114, 114, 111, 114,
 32,  40,  82,  84,  76,  41,  32,  35,  32,  22,  22,  32, 102, 111, 114,  32,
116, 104, 101,  32,  83, 111, 117, 114,  99, 101,  32, 102, 105, 108, 101,  32,
 34,   2,   2,  34,  46,  15,  15,  32,  82,  84,  76,  32, 109, 101, 115, 115,
 97, 103, 101,  32,  58,  32,  14,  14, 101, 110, 100, 102, 105, 108, 101,  95,
109, 115, 116,  97, 116, 101,   8,   8, 105, 110, 115, 121, 109,  98, 111, 108,
  4,   4,  77,  65,  83,  89,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,  11,  11, 115, 107, 105, 112,  95, 115,
121, 109,  98, 111, 108,  12,  12, 115, 107, 105, 112,  95, 109, 115, 121, 109,
 98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   2,   0,   0,   0, 128,   0,   0,   0,   0,   2,   0,
  0,   0,   0,   0,   0,   0,   4,   0,   9,   9, 105, 110, 115, 121,  95, 105,
110, 105, 116,   0,   0,  53,  53,  32,  80,  32,  65,  32,  83,  32,  45,  32,
 80,  46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,  79,  70,  84,  87,
 65,  82,  69,  58,  32,  86,  51,  46,  49,  45,  66,  53,  32,  79,  70,  32,
 51,  49,  45,  74,  65,  78,  45,  50,  48,  50,  50,  32,  12,  12,  99, 112,
 97, 115,  95,  99, 109, 112,  46, 101, 114, 114,   5,   5,  32,  80,  65,  83,
 62,  48,  48,  32,  42,  42,  42,  32,  80,  67,  77,  80,  45,  67,  80,  65,
 83,  45,  67,  79,  77,  80,  73,  76,  69,  82,  32,  69,  82,  82,  79,  82,
 58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101, 110,  32, 116, 104,
101,  32,  34,  15,  15,  34,  32, 105, 110, 105, 116, 105,  97, 108,  32, 102,
105, 108, 101,  46,  54,  54,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32, 102, 111, 114,  32, 116, 104, 101,  32, 116,  97, 114,
103, 101, 116,  32, 115, 121, 115, 116, 101, 109,  32,  34,  22,  22,  32,  80,
 65,  83,  32,  67,  65,  78,  78,  79,  84,  32,  79,  80,  69,  78,  32,  84,
 72,  69,  32,  34,  23,  23,  34,  32,  79,  85,  84,  80,  85,  84,  32,  77,
 83,  71,  47,  76,  73,  83,  84,  32,  70,  73,  76,  69,  46,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 928 ) = {{
  0,   0,   0,   0,   0,   1,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   4,   5,   6,   7,   7,   7,  15,   6,  16,  17,  10,  18,
 19,  20,   9,  21,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  14,  22,
 11,  12,  13,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  23,
 24,  25,  26,   7,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   4,
  5,   4,   4,   3,  12,  20,  14,  29,  15,  29,   9,  11,  18,  29,   9,  12,
  8,   7,  19,  29,  16,  29,   6,   0,  17,  29,  24,  29,   0,   0,   0,   0,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10, 112,  99, 109, 112, 100, 101,  98,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11, 112,  99, 109, 112, 100, 101,  98,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32
}};

/* Define the local static section. */
static Blk( Rs, 512 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern V V_macsymb_tree;
extern V V_macsymb_frst;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern UB V_sy_attrflg;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern V V_sy_macsymb;
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_src_openerr;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern SL V_sy_maclevel;
extern Blk(V_cpas_ini_dir, 264 );
extern Blk(V_trg_env_fspc, 264 );
extern UB V_cmp_macroexp;
extern UB V_error_result;
extern UB V_emergency_stop;
extern Blk(V_trg_sys_name, 264 );
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp);
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp);
C P_src_return(UB F_bfree);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_set_flags(UL F_flg, UB F_fclr);
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_insymbol();
void P_skip_msymbol(V F_smb, UB F_rec_flg);
void P_binary_objf_close();
void P_generation_pragma();
void PAS_INSMBOL_get_macro_value(V F_vl);
void PAS_INSMBOL_m_expr_instk();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=162; /* line # 162 */
  if (F_icd>=0) {
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+80);
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[72]=168; /* line # 168 */
      if (V_srf_free==NULL) Rv0=PAS__NEW(16);
      else {
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Rv1=Rv0;
      Ra.sl[72]=174; /* line # 174 */
      ((V *)Rv1)[0]=V_srf_list;
      ((V *)Rv1)[1]=NULL;
      P_val_new(((V *)Rv1)+1,NULL);
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[72]=181; /* line # 181 */
      Rv2=V_srf_list;
      P_val_free(((V *)Rv2)+1);
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[72]=186; /* line # 186 */
    Rv3=((V *)V_srf_list)[1];
    ((UB *)Rv3)[48]=29;
    ((SL *)Rv3)[6]=Ra.ub[1];
    Rv4=Ra.ub[1];
    ((V *)Rv3)[7]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[7])[0]=Rv4;
    Ra.sl[72]=191; /* line # 191 */
    PAS__STR_TO_STR(((V *)Rv3)[7],Ra.s);
  }
  else {
    Ra.sl[72]=196; /* line # 196 */
    Rv0=V_srf_list;
    Rv5=Rv0;
    V_srf_list=((V *)Rv5)[0];
    P_val_free(((V *)Rv5)+1);
    Ra.sl[72]=201; /* line # 201 */
    ((V *)Rv5)[0]=V_srf_free;
    V_srf_free=Rv0;
  }
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+85;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=226; /* line # 226 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+104);
  Ra.sl[72]=231; /* line # 231 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.s+
109,Ra.s),Rd.s+140));
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+144;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=249; /* line # 249 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  if (((V *)F_prc)[3]!=NULL) {
    Rv1=((V *)F_prc)[3];
    Ra.sl[72]=255; /* line # 255 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+292,Rv1+1,31,1,((UB *)Rv1)[0]));
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.
    s+163,Ra.s),Rd.s+198));
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+202;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=284; /* line # 284 */
  Rv0=PAS__NEW(50);
  Rv1=Rv0;
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[6]=289; /* line # 289 */
  ((V *)Rv1)[4]=NULL;
  ((V *)Rv1)[5]=NULL;
  ((UB *)Rv1)[48]=F_skw;
  ((UB *)Rv1)[49]=F_opkw;
  Rv3=V_keyword_tree;
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[6]=296; /* line # 296 */
      Rv4=Rv3;
      Rv5=Rv3;
      Rv6=P_match(Rv0,Rv5);
      if (Rv6>0) Rv3=((V *)Rv5)[5];
      else {
        Ra.sl[6]=301; /* line # 301 */
        Rv3=((V *)Rv5)[4];
      }
      if (Rv3==NULL)  break;
    }
    if (Rv6>0) ((V *)Rv4)[5]=Rv0;
    else((V *)Rv4)[4]=Rv0;
  }
  else {
    Ra.sl[6]=307; /* line # 307 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+214;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=313; /* line # 313 */
  PAS_INSMBOL_PRC_00000000(Rd.s+232,13,21);
  PAS_INSMBOL_PRC_00000000(Rd.s+236,13,22);
  PAS_INSMBOL_PRC_00000000(Rd.s+241,12,20);
  PAS_INSMBOL_PRC_00000000(Rd.s+246,6,0);
  PAS_INSMBOL_PRC_00000000(Rd.s+251,8,8);
  Ra.sl[6]=318; /* line # 318 */
  PAS_INSMBOL_PRC_00000000(Rd.s+256,8,9);
  PAS_INSMBOL_PRC_00000000(Rd.s+261,8,10);
  PAS_INSMBOL_PRC_00000000(Rd.s+266,10,23);
  Ra.sl[6]=324; /* line # 324 */
  PAS_INSMBOL_PRC_00000000(Rd.s+270,28,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+275,33,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+282,34,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+288,30,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+294,29,29);
  Ra.sl[6]=329; /* line # 329 */
  PAS_INSMBOL_PRC_00000000(Rd.s+301,32,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+317,31,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+322,36,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+330,37,29);
  Ra.sl[6]=334; /* line # 334 */
  PAS_INSMBOL_PRC_00000000(Rd.s+339,44,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+348,39,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+356,40,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+362,41,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+369,42,29);
  Ra.sl[6]=339; /* line # 339 */
  PAS_INSMBOL_PRC_00000000(Rd.s+377,43,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+382,74,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+387,59,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+392,60,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+398,61,29);
  Ra.sl[6]=344; /* line # 344 */
  PAS_INSMBOL_PRC_00000000(Rd.s+407,62,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+413,63,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+420,64,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+429,65,29);
  Ra.sl[6]=349; /* line # 349 */
  PAS_INSMBOL_PRC_00000000(Rd.s+437,66,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+443,67,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+451,68,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+458,69,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+465,70,29);
  Ra.sl[6]=354; /* line # 354 */
  PAS_INSMBOL_PRC_00000000(Rd.s+474,71,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+482,76,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+491,75,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+499,77,29);
  Ra.sl[6]=359; /* line # 359 */
  PAS_INSMBOL_PRC_00000000(Rd.s+510,78,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+520,79,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+528,80,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+537,87,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+545,82,29);
  Ra.sl[6]=364; /* line # 364 */
  PAS_INSMBOL_PRC_00000000(Rd.s+553,38,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+561,81,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+571,83,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+581,84,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+589,72,29);
  Ra.sl[6]=369; /* line # 369 */
  PAS_INSMBOL_PRC_00000000(Rd.s+596,45,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+600,46,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+606,47,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+612,48,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+619,49,29);
  Ra.sl[6]=374; /* line # 374 */
  PAS_INSMBOL_PRC_00000000(Rd.s+627,50,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+634,51,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+639,55,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+645,56,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+651,57,29);
  Ra.sl[6]=379; /* line # 379 */
  PAS_INSMBOL_PRC_00000000(Rd.s+657,58,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+663,73,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+668,86,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+679,85,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+683,54,29);
  Ra.sl[6]=384; /* line # 384 */
  PAS_INSMBOL_PRC_00000000(Rd.s+687,52,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+691,53,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+699,90,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+708,91,29);
  Ra.sl[6]=389; /* line # 389 */
  PAS_INSMBOL_PRC_00000000(Rd.s+719,92,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+725,93,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+730,94,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+738,95,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+748,96,29);
  Ra.sl[6]=394; /* line # 394 */
  PAS_INSMBOL_PRC_00000000(Rd.s+755,97,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+762,98,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+770,101,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+779,100,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+789,102,29);
  Ra.sl[6]=403; /* line # 403 */
  PAS_INSMBOL_PRC_00000000(Rd.s+798,103,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_mac_ident "  */
V P_create_mac_ident(V F_id, UB F_cmdf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+804;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=423; /* line # 423 */
  Rv0=V_macsymb_tree;
  Rv1=NULL;
  Rv2=1;
  while (Rv0!=NULL&&Rv2!=0){
    Ra.sl[6]=428; /* line # 428 */
    Rv1=Rv0;
    Rv3=Rv0;
    Rv2=P_match(F_id,Rv3);
    if (Rv2!=0) {
      Ra.sl[6]=433; /* line # 433 */
      if (Rv2>0) Rv0=((V *)Rv3)[6];
      else Rv0=((V *)Rv3)[5];
    }
  }
  if (Rv2==0) {
    Ra.sl[6]=438; /* line # 438 */
    if (F_cmdf) Rv4=Rv0;
    else P_src_error_s(Rd.s+824,921,2, F_id,NULL);
  }
  else {
    Rv4=PAS__NEW(80);
    Ra.sl[6]=443; /* line # 443 */
    Rv5=Rv4;
    memcpy(Rv5,F_id,32);
    ((V *)Rv5)[4]=NULL;
    ((V *)Rv5)[5]=NULL;
    Ra.sl[6]=448; /* line # 448 */
    ((V *)Rv5)[6]=NULL;
    ((UB *)Rv5)[56]=0;
    memcpy(Rv5+64,Rd.s+832,16);
    if (Rv1==NULL) {
      Ra.sl[6]=453; /* line # 453 */
      V_macsymb_tree=Rv4;
    }
    else {
      if (Rv2>0) ((V *)Rv1)[6]=Rv4;
      else((V *)Rv1)[5]=Rv4;
    }
  }
  Ra.sl[6]=458; /* line # 458 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sortmc1 "  */
void PAS_INSMBOL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+848;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=485; /* line # 485 */
  Rv0=F_p;
  if (((V *)Rv0)[5]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[5]);
  Rv1=((UB *)Rv0)[0]==0;
  if (!Rv1) {
    Ra.sl[6]=491; /* line # 491 */
    if (V_macsymb_frst==NULL) V_macsymb_frst=F_p;
    else((V *)Lx[0].v[0])[4]=F_p;
    Lx[0].v[0]=F_p;
    ((V *)Rv0)[4]=NULL;
    Lx[0].sl[2]=Lx[0].sl[2]+1;
  }
  Ra.sl[6]=497; /* line # 497 */
  if (((V *)Rv0)[6]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[6]);
  if (Rv1) {
    Rv2=F_p;
    Rv3=Rv2+64;
    Ra.sl[6]=502; /* line # 502 */
    if (((V *)Rv3)[1]!=NULL) PAS__DISPOSE(((V *)Rv3)+1);
    PAS__DISPOSE(&F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rebuild_mctree1 "  */
V PAS_INSMBOL_PRC_00000002(SL F_n, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+857;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=516; /* line # 516 */
  Rv0=(F_n+F_m)/2;
  Rv1=((V *)Lx[0].v[2])[Rv0];
  Rv2=Rv1;
  if (Rv0==F_n) ((V *)Rv2)[5]=NULL;
  else {
    Ra.sl[6]=521; /* line # 521 */
    ((V *)Rv2)[5]=PAS_INSMBOL_PRC_00000002(F_n, Rv0-1);
  }
  if (Rv0==F_m) ((V *)Rv2)[6]=NULL;
  else((V *)Rv2)[6]=PAS_INSMBOL_PRC_00000002(Rv0+1, F_m);
  Ret=Rv1;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rebuild_mctree "  */
void P_rebuild_mctree(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+874;
  Ra.v[5]=Rd.s+16;
  Ra.sl[12]=531; /* line # 531 */
  Ra.sl[2]=0;
  V_macsymb_frst=NULL;
  if (V_macsymb_tree!=NULL) {
    PAS_INSMBOL_PRC_00000001(V_macsymb_tree);
    Ra.sl[12]=536; /* line # 536 */
    if (Ra.sl[2]>0) {
      Ra.v[0]=V_macsymb_frst;
      Rv0=Ra.sl[2];
      Ra.v[2]=PAS__NEW(Rv0*8+8);
      ((SL *)Ra.v[2])[0]=Rv0;
      Rv1=1;
      for( Rf0=Ra.sl[2];Rf0>0;Rf0-- ) {
        Ra.sl[12]=541; /* line # 541 */
        ((V *)Ra.v[2])[Rv1]=Ra.v[0];
        Ra.v[0]=((V *)Ra.v[0])[4];
        Rv1++;
      }
      V_macsymb_tree=PAS_INSMBOL_PRC_00000002(1, Ra.sl[2]);
    }
    else {
      Ra.sl[12]=547; /* line # 547 */
      V_macsymb_tree=NULL;
      V_macsymb_frst=NULL;
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+890;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=635; /* line # 635 */
  V_sy_ch=P_src_inchar();
  V_sy_cmin=V_sy_ch;
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+898;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=644; /* line # 644 */
  if (!Lx[1].ub[0]) {
    if (Lx[1].sl[1]<V_sy_string.ub[0]) {
      V_sy_string.c[Lx[1].sl[1]+1]=V_sy_ch;
      Lx[1].sl[1]=Lx[1].sl[1]+1;
    }
    else {
      Ra.sl[6]=652; /* line # 652 */
      P_src_error(Rd.s+910,12,2);
      Lx[1].ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000005(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+914;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=663; /* line # 663 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    if ((Lx[1].ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else Rv0=-1;
  }
  if (Rv0>=Lx[1].sl[3]) Rv0=-2;
  Ra.sl[6]=668; /* line # 668 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000006(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+928;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=679; /* line # 679 */
  Rv0=PAS_INSMBOL_PRC_00000005(F_ch);
  if (Rv0==-2) {
    Rv0=0;
    P_src_error(Rd.s+939,16,2);
  }
  Ra.sl[6]=684; /* line # 684 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000007(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+943;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=694; /* line # 694 */
  Ri.sl[0]=Ri.sl[0]+1;
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+956,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  if (F_ierr>=20&&F_ierr<=25) {
    if (!Lx[1].ub[16]) {
      Ra.sl[6]=700; /* line # 700 */
      P_src_error(Rd.s+910,11,2);
      Lx[1].g[3]=1.000000000000000E+000;
      Lx[1].g[4]=1.000000000000000E+000;
      Lx[1].ub[16]=1;
    }
    Ret=1;
  }
  else {
    Ra.sl[6]=707; /* line # 707 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register V Rv2;
  G Rv3;
  SL Rv4;
  SL Rv5;
  G Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  C Rv14;
  UB Rv15;
  SL Rv16;
  register V Rv17;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+969;
  Ra.v[7]=Rd.s+16;
  Ra.sl[16]=713; /* line # 713 */
  while (V_sy_ch==32||V_sy_ch==0)
  PAS_INSMBOL_PRC_00000003();
  Rv0=1;
  Rv1=V_sy_attrflg;
  V_sy_attrflg=0;
  Rv2=V_src_control;
  ((SL *)Rv2)[4]=((SL *)Rv2)[5];
  Ra.sl[16]=718; /* line # 718 */
  switch (Ri.ub[V_sy_cmin+4]) {
    case 8:
    case 9:PAS__ESTABLISH(PAS_INSMBOL_PRC_00000007);
    Ra.sl[16]=723; /* line # 723 */
    Ra.ub[16]=0;
    V_sy_sym.ub[0]=20;
    V_sy_sym.ub[1]=29;
    Rv3=0.000000000000000E-001;
    Ra.sl[3]=10;
    Ra.sl[16]=728; /* line # 728 */
    Rv4=0;
    Ra.ub[8]=0;
    while (Ri.ub[V_sy_cmin+4]==8){
      V_sy_sym.ub[0]=2;
      Ra.sl[16]=733; /* line # 733 */
      Rv5=(SL)V_sy_cmin-48;
      if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      while (1){
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_cmin!=95)  break;
      }
      if (!Ra.ub[16]) Rv3=Rv3*1.000000000000000E+001+(double)Rv5;
    }
    Ra.sl[16]=739; /* line # 739 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Rv4=0;
      Ra.sl[3]=(Rv3>0.0?(SL)(Rv3+0.5):(SL)(Rv3-0.5));
      if (Ra.sl[3]<2||Ra.sl[3]>16) {
        Ra.sl[16]=745; /* line # 745 */
        P_src_error(Rd.s+910,14,2);
        Ra.sl[3]=10;
      }
      Ra.ub[8]=1;
      Rv3=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[16]=751; /* line # 751 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
        if ((float)Rv5<(F)0.000000E-01)  break;
        if (!Ra.ub[16]) Rv3=Rv3*(double)Ra.sl[3]+(double)Rv5;
        if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      }
    }
    Ra.sl[16]=760; /* line # 760 */
    Rv6=(double)Ra.sl[3];
    Ra.g[3]=Rv6;
    if (V_sy_ch==46) {
      if (P_src_next_char()==46) {
        Ra.sl[16]=765; /* line # 765 */
        if (V_sy_sym.ub[0]==20) {
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=21;
        }
        else {
          Ra.sl[16]=770; /* line # 770 */
          Rv0=0;
        }
      }
      else {
        while (1){
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Rv6=(double)Ra.sl[3];
        Ra.g[3]=Rv6;
        Ra.g[4]=1.000000000000000E+000;
        Ra.sl[16]=775; /* line # 775 */
        if (PAS_INSMBOL_PRC_00000005(V_sy_cmin)<0) Rv0=0;
        else {
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[16]=781; /* line # 781 */
            if (Ra.g[4]!=1.000000000000000E+000) while (1){
              PAS_INSMBOL_PRC_00000003();
              if (V_sy_cmin!=95)  break;
            }
            Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
            if (Rv5<0)  break;
            Ra.g[4]=Ra.g[4]/Rv6;
            Ra.sl[16]=786; /* line # 786 */
            Rv3=Rv3+Ra.g[4]*(double)Rv5;
            Rv4=Rv4+1;
          }
        }
      }
    }
    Ra.sl[16]=793; /* line # 793 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000003();
    if (V_sy_sym.ub[0]!=20&&V_sy_sym.ub[0]!=21) {
      if (V_sy_cmin==101) {
        Ra.sl[16]=799; /* line # 799 */
        V_sy_sym.ub[0]=4;
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_ch==43||V_sy_ch==45) {
          if (V_sy_ch==45) Ra.g[3]=1.000000000000000E+000/Ra.g[3];
          Ra.sl[16]=804; /* line # 804 */
          PAS_INSMBOL_PRC_00000003();
        }
        Rv7=0;
        while (Ri.ub[V_sy_cmin+4]==8){
          Ra.sl[16]=810; /* line # 810 */
          Rv7=Rv7*10+((SL)V_sy_ch-48);
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[16]=815; /* line # 815 */
        Ra.g[4]=1.000000000000000E+000;
        while (Rv7!=0&&!Ra.ub[16])
        if (Rv7&1) {
          Ra.sl[16]=820; /* line # 820 */
          Rv7=Rv7-1;
          Ra.g[4]=Ra.g[4]*Ra.g[3];
        }
        else {
          Ra.sl[16]=825; /* line # 825 */
          Rv7=Rv7/2;
          Ra.g[3]=PAS__G_SQR(Ra.g[3]);
        }
        if (!Ra.ub[16]) Rv3=Rv3*Ra.g[4];
      }
      Ra.sl[16]=832; /* line # 832 */
      if (Ra.ub[16]) Rv3=0.000000000000000E-001;
      if (V_sy_sym.ub[0]==2) {
        if (Rv3<=4.294967295000001E+009&&Rv3>=-2.147483648000001E+009) {
          Ra.sl[16]=838; /* line # 838 */
          if (Rv3>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rv3)+1;
          else V_sy_ival=(int)(Rv3);
          V_sy_rval=(double)V_sy_ival;
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
            Ra.sl[16]=844; /* line # 844 */
            PAS_INSMBOL_PRC_00000003();
            P_ide_int_label();
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[16]=849; /* line # 849 */
          V_sy_sym.ub[0]=4;
        }
      }
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[16]=854; /* line # 854 */
        V_sy_ival=0;
        if (Rv3>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[16]=859; /* line # 859 */
          if (Ra.sl[3]>2) Rv4=Rv4*(int)(log(Rv6)/6.931471805599453E-001)+2;
          else Rv4=Rv4+2;
          if (Rv4>24) V_sy_sym.ub[0]=4;
          else V_sy_sym.ub[0]=3;
        }
      }
      Ra.sl[16]=866; /* line # 866 */
      V_sy_rval=Rv3;
      Rv0=0;
    }
    PAS__REVERT();
    break;
    case 7:Ra.sl[16]=873; /* line # 873 */
    V_sy_ident.ub[0]=0;
    while (1){
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[16]=880; /* line # 880 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      PAS_INSMBOL_PRC_00000003();
      if (Ri.ub[V_sy_cmin+4]!=7&&Ri.ub[V_sy_cmin+4]!=8)  break;
    }
    Ra.sl[16]=886; /* line # 886 */
    Rv8=V_keyword_tree;
    while (1){
      Rv9=Rv8;
      Rv10=P_match(V_sy_ident.s,Rv9);
      Ra.sl[16]=891; /* line # 891 */
      if (Rv10!=0) {
        if (Rv10>0) Rv8=((V *)Rv9)[5];
        else Rv8=((V *)Rv9)[4];
      }
      if (Rv10==0||Rv8==NULL)  break;
    }
    if (Rv8!=NULL) {
      Ra.sl[16]=896; /* line # 896 */
      memcpy(V_sy_sym.s,Rv8+48,2);
    }
    else {
      V_sy_macsymb=V_macsymb_tree;
      Ra.sl[16]=901; /* line # 901 */
      V_sy_sym.ub[0]=99;
      Rv10=1;
      while (Rv10!=0&&V_sy_macsymb!=NULL){
        Rv11=V_sy_macsymb;
        Ra.sl[16]=906; /* line # 906 */
        Rv10=P_match(V_sy_ident.s,Rv11);
        if (Rv10!=0) {
          if (Rv10>0) V_sy_macsymb=((V *)Rv11)[6];
          else V_sy_macsymb=((V *)Rv11)[5];
        }
      }
      if (Rv10==0) V_sy_sym.ub[0]=99;
      else {
        Ra.sl[16]=913; /* line # 913 */
        if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=1;
        }
        else {
          Ra.sl[16]=920; /* line # 920 */
          if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
          V_sy_sym.ub[0]=0;
        }
      }
      Ra.sl[16]=925; /* line # 925 */
      V_sy_sym.ub[1]=29;
    }
    Rv0=0;
    break;
    case 6:Ra.sl[16]=931; /* line # 931 */
    if (Rv1) {
      V_sy_sym.ub[0]=25;
      V_sy_sym.ub[1]=29;
      Rv1=0;
    }
    else {
      Ra.sl[16]=938; /* line # 938 */
      V_sy_sym.ub[1]=29;
      Rv12=V_src_control;
      Rv13=(524288&((UL *)Rv12)[62])!=0;
      Ra.sl[16]=943; /* line # 943 */
      ((UB *)Rv12)[252]=4;
      ((UL *)Rv12)[62]=((UL *)Rv12)[62]|524288;
      Rv14=V_sy_cmin;
      V_sy_sym.ub[0]=5;
      Ra.sl[16]=948; /* line # 948 */
      Ra.sl[1]=1;
      Ra.ub[0]=0;
      Rv15=1;
      while (Rv15){
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[16]=953; /* line # 953 */
        while (Ri.ub[V_sy_cmin+4]==1)
        PAS_INSMBOL_PRC_00000003();
        if (Ri.ub[V_sy_cmin+4]==2) Rv15=0;
        if (V_sy_ch==Rv14) {
          if (Rv14==P_src_next_char()) {
            Ra.sl[16]=959; /* line # 959 */
            PAS_INSMBOL_PRC_00000003();
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            ((UB *)V_src_control)[252]=0;
            Ra.sl[16]=964; /* line # 964 */
            Rv15=0;
          }
        }
        else {
          if (Rv14==34&&V_sy_ch==92) {
            Ra.sl[16]=970; /* line # 970 */
            PAS_INSMBOL_PRC_00000003();
            switch (V_sy_cmin) {
              case 34:
              case 39:
              case 92:break;
              case 97:V_sy_ch=7;
              break;
              case 98:V_sy_ch=8;
              break;
              case 101:Ra.sl[16]=975; /* line # 975 */
              V_sy_ch=27;
              break;
              case 102:V_sy_ch=12;
              break;
              case 110:V_sy_ch=10;
              break;
              case 114:V_sy_ch=13;
              break;
              case 116:V_sy_ch=9;
              break;
              case 118:Ra.sl[16]=980; /* line # 980 */
              V_sy_ch=11;
              break;
              case 122:V_sy_ch=0;
              break;
              case 48:
              case 49:
              case 50:
              case 51:
              case 52:
              case 53:
              case 54:
              case 55:
              case 56:
              case 57:Rv10=(SL)V_sy_cmin-48;
              PAS_INSMBOL_PRC_00000003();
              Ra.sl[16]=985; /* line # 985 */
              Rv16=3;
              while ((Rv16>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
                Rv10=(Rv10*10+(SL)V_sy_cmin)-48;
                PAS_INSMBOL_PRC_00000003();
              }
              Ra.sl[16]=991; /* line # 991 */
              if (Rv10<=255) V_sy_ch=(C)Rv10;
              else {
                V_sy_ch=32;
                P_src_error(Rd.s+910,17,2);
              }
              break;
              default:V_sy_ch=32;
              P_src_error(Rd.s+910,18,2);
              break;
            }
            Ra.sl[16]=997; /* line # 997 */
            PAS_INSMBOL_PRC_00000004();
          }
          else PAS_INSMBOL_PRC_00000004();
        }
      }
      V_sy_string.ub[1]=Ra.sl[1] -1;
      Ra.sl[16]=1003; /* line # 1003 */
      Rv17=V_src_control;
      if (!Rv13) {
        ((UL *)Rv17)[62]=((UL *)Rv17)[62]&~524288;
        if (Ri.ub[V_sy_cmin+4]==1) V_sy_ch=32;
      }
    }
    break;
    case 14:Ra.sl[16]=1013; /* line # 1013 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[1]=29;
    if (V_sy_ch==61) V_sy_sym.ub[0]=23;
    else {
      V_sy_sym.ub[0]=22;
      Rv0=0;
    }
    break;
    case 11:Ra.sl[16]=1021; /* line # 1021 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[16]=1026; /* line # 1026 */
        V_sy_sym.ub[1]=14;
        Rv0=0;
      }
    }
    break;
    case 13:Ra.sl[16]=1031; /* line # 1031 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      V_sy_sym.ub[1]=17;
      Rv0=0;
    }
    break;
    case 5:Ra.sl[16]=1039; /* line # 1039 */
    Rv14=V_sy_ch;
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==Rv14) {
      V_sy_sym.ub[0]=9;
      V_sy_sym.ub[1]=13;
    }
    else {
      V_sy_sym.ub[0]=13;
      V_sy_sym.ub[1]=21;
      Rv0=0;
    }
    break;
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[16]=1047; /* line # 1047 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    break;
    case 17:
    case 25:
    case 26:memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    Ra.sl[16]=1052; /* line # 1052 */
    PAS_INSMBOL_PRC_00000003();
    if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
    Rv0=0;
    break;
    case 10:Ra.sl[16]=1059; /* line # 1059 */
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      V_sy_sym.ub[0]=8;
      V_sy_sym.ub[1]=6;
      Rv0=0;
    }
    break;
    case 12:Ra.sl[16]=1066; /* line # 1066 */
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=26;
      V_sy_sym.ub[1]=29;
    }
    else {
      V_sy_sym.ub[0]=10;
      V_sy_sym.ub[1]=19;
      Rv0=0;
    }
    break;
    case 2:Ra.sl[16]=1072; /* line # 1072 */
    V_sy_sym.ub[0]=103;
    V_sy_sym.ub[1]=29;
    V_sy_ch=32;
    Rv0=0;
    break;
    case 1:V_sy_sym.ub[0]=88;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[16]=1078; /* line # 1078 */
    V_sy_sym.ub[0]=104;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    if (V_sy_ch!=32) P_src_error(Rd.s+910,13,2);
    V_sy_ch=32;
    break;
  }
  Ra.sl[16]=1085; /* line # 1085 */
  if (Rv0) PAS_INSMBOL_PRC_00000003();
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " skip_mcsymbol "  */
void PAS_INSMBOL_skip_mcsymbol(V F_smb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+983;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1092; /* line # 1092 */
  while (!((PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,105)||V_sy_sym.ub[0]==89)||V_sy_sym
  .ub[0]==103)){
    P_insymbol_src();
    Ra.sl[6]=1097; /* line # 1097 */
    switch (V_sy_sym.ub[0]) {
      case 93:
      case 94:
      case 95:while (PAS__INOP_LSET(V_sy_sym.ub[0],Rd.s+1000,96)){
        PAS_INSMBOL_skip_mcsymbol(Rd.s+1012);
        Ra.sl[6]=1102; /* line # 1102 */
        P_insymbol_src();
      }
      break;
      case 103:Ra.sl[6]=1115; /* line # 1115 */
      P_src_error(Rd.s+1030,932,3);
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cb_macro_manager "  */
V PAS_INSMBOL_cb_macro_manager(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1034;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1126; /* line # 1126 */
  Rv0=F_mcp;
  ((UB *)Rv0)[56]=0;
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " macro_replace "  */
void P_macro_replace(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1052;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1147; /* line # 1147 */
  Rv2=F_mcp;
  Rv3=Rv2+64;
  if (!((UB *)Rv2)[56]) {
    switch (((UB *)Rv3)[0]) {
      case 0:Ra.sl[6]=1154; /* line # 1154 */
      Rv0=PAS__NEW(24);
      ((UB *)Rv0)[0]=22;
      PAS__VWRITE_INIT(Rv0,1);
      PAS__WRITE_INT(((SL *)Rv3)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[6]=1159; /* line # 1159 */
      Rv4=((UB *)((V *)Rv3)[1])[1];
      Rv0=PAS__NEW((SL)Rv4+2);
      ((UB *)Rv0)[0]=Rv4;
      PAS__STR_TO_STR(Rv0,((V *)Rv3)[1]);
      break;
      default:break;
    }
    Ra.sl[6]=1164; /* line # 1164 */
    ((UB *)Rv2)[56]=1;
    Rv1=P_src_macro_open(Rv0, (V)PAS_INSMBOL_cb_macro_manager,F_mcp,1,NULL);
    V_sy_ch=0;
  }
  else {
    Ra.sl[6]=1170; /* line # 1170 */
    P_src_error_s(Rd.s+1069,930,2, F_mcp,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_macro_symbol "  */
void PAS_INSMBOL_define_macro_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1073;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1184; /* line # 1184 */
  P_insymbol_src();
  while (1){
    if (V_sy_sym.ub[0]==99) {
      Ra.sl[6]=1190; /* line # 1190 */
      P_src_error_s(Rd.s+1096,921,2, V_sy_ident.s,NULL);
      P_skip_msymbol((V)Rd.s+1100,0);
    }
    else {
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=1196; /* line # 1196 */
        P_src_error(Rd.s+1096,922,2);
        P_skip_msymbol((V)Rd.s+1104,0);
      }
      else {
        Ra.sl[6]=1201; /* line # 1201 */
        Rv0=P_create_mac_ident(V_sy_ident.s,0);
        P_insymbol_src();
        if (V_sy_sym.ub[0]==23) {
          Rv1=Rv0;
          Ra.sl[6]=1206; /* line # 1206 */
          P_insymbol_src();
          PAS_INSMBOL_get_macro_value(Rv1+64);
        }
      }
    }
    Ra.sl[6]=1219; /* line # 1219 */
    if (V_sy_sym.ub[0]!=18)  break;
    P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1096,21,2);
  else P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " undefine_macro_symbol "  */
void PAS_INSMBOL_undefine_macro_mbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1108;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1235; /* line # 1235 */
  P_insymbol_src();
  while (1){
    if (V_sy_sym.ub[0]!=99) {
      Ra.sl[6]=1241; /* line # 1241 */
      P_src_error(Rd.s+1133,922,2);
      P_skip_msymbol((V)Rd.s+1140,0);
    }
    else {
      Ra.sl[6]=1246; /* line # 1246 */
      if (V_sy_macsymb==NULL) P_src_error_s(Rd.s+1133,923,2, V_sy_ident.s,NULL);
      else {
        Rv0=V_sy_macsymb;
        Ra.sl[6]=1251; /* line # 1251 */
        ((UB *)Rv0)[0]=0;
        if (((V *)Rv0)[9]!=NULL) PAS__DISPOSE(((V *)Rv0)+9);
      }
      P_insymbol_src();
    }
    Ra.sl[6]=1257; /* line # 1257 */
    if (V_sy_sym.ub[0]!=18)  break;
    P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1133,21,2);
  else P_insymbol_src();
  Ra.sl[6]=1263; /* line # 1263 */
  P_rebuild_mctree();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_assign_symbol "  */
void PAS_INSMBOL_macro_assign_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1144;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1276; /* line # 1276 */
  P_insymbol_src();
  if (V_sy_sym.ub[0]!=99) {
    Ra.sl[6]=1281; /* line # 1281 */
    P_src_error(Rd.s+1167,922,2);
    P_skip_msymbol(Rd.s+1172,0);
  }
  else {
    Ra.sl[6]=1286; /* line # 1286 */
    Rv0=V_sy_macsymb;
    P_insymbol_src();
    if (V_sy_sym.ub[0]!=23) P_src_error(Rd.s+1167,32,2);
    else P_insymbol_src();
    Rv1=Rv0;
    Ra.sl[6]=1292; /* line # 1292 */
    if (((V *)Rv1)[9]!=NULL) PAS__DISPOSE(((V *)Rv1)+9);
    PAS_INSMBOL_get_macro_value(Rv1+64);
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1167,21,2);
  else {
    Ra.sl[6]=1297; /* line # 1297 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mval "  */
void PAS_INSMBOL_show_mval(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1188;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1305; /* line # 1305 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1199,-1,-1,32);
  PAS__WRITE_ENM(((UB *)F_vl)[0],Rd.s+1216,0,-1,32);
  PAS__WRITE_STR(Rd.s+1258,-1,-1,32);
  PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
  PAS__WRITE_STR(Rd.s+1264,-1,-1,32);
  if (((V *)F_vl)[1]!=NULL&&((UB *)F_vl)[0]==1) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(((V *)F_vl)[1],-1,-1,32);
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1271,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mstack "  */
void PAS_INSMBOL_show_mstack(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1275;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1312; /* line # 1312 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(F_s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1288,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[39],-2,0);
  PAS__WRITE_EOLN();
  Rv0=Ri.sl[39];
  for( Rf0=Ri.sl[39];Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1305,-1,-1,32);
    PAS__WRITE_INT(Rv0,-2,0);
    PAS__WRITE_STR(Rd.s+1309,-1,-1,32);
    PAS_INSMBOL_show_mval((Rs.s+Rv0*16-16));
    Rv0--;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_cop "  */
void PAS_INSMBOL_mval_cop(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1315;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1323; /* line # 1323 */
  ((UB *)F_dst)[0]=((UB *)F_src)[0];
  ((SL *)F_dst)[1]=((SL *)F_src)[1];
  if (((V *)F_src)[1]!=NULL) {
    Rv0=((UB *)((V *)F_src)[1])[1];
    ((V *)F_dst)[1]=PAS__NEW((SL)Rv0+2);
    ((UB *)((V *)F_dst)[1])[0]=Rv0;
    Ra.sl[6]=1328; /* line # 1328 */
    PAS__STR_TO_STR(((V *)F_dst)[1],((V *)F_src)[1]);
  }
  else((V *)F_dst)[1]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_free "  */
void PAS_INSMBOL_mval_free(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1325;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1337; /* line # 1337 */
  if (((V *)F_vl)[1]!=NULL) PAS__DISPOSE(((V *)F_vl)+1);
  memcpy(F_vl,Rd.s+832,16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpush "  */
void PAS_INSMBOL_mpush(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1336;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1348; /* line # 1348 */
  if (Ri.sl[39]<32) Ri.sl[39]=Ri.sl[39]+1;
  else P_src_error(Rd.s+1345,911,3);
  PAS_INSMBOL_mval_cop(F_vl,(Rs.s+Ri.sl[39]*16-16));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpop "  */
void PAS_INSMBOL_mpop(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1349;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1360; /* line # 1360 */
  if (Ri.sl[39]>0) {
    memcpy(F_vl,(Rs.s+Ri.sl[39]*16-16),16);
    Ri.sl[39]=Ri.sl[39]-1;
  }
  else {
    Ra.sl[6]=1367; /* line # 1367 */
    P_src_error(Rd.s+1357,912,3);
    memcpy(F_vl,Rd.s+832,16);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_macro_value "  */
void PAS_INSMBOL_get_macro_value(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1361;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1386; /* line # 1386 */
  PAS_INSMBOL_m_expr_instk();
  PAS_INSMBOL_mpop(F_vl);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_intv "  */
SL PAS_INSMBOL_mexp_intv(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1378;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1399; /* line # 1399 */
  PAS_INSMBOL_mpop(Ra.s+32);
  if (Ra.ub[32]==0) Rv0=Ra.sl[9];
  else {
    if (Ra.v[5]==NULL) Rv0=0;
    else {
      Ra.sl[6]=1405; /* line # 1405 */
      Rv1=Ra.v[5];
      Rv0=0;
      Rv2=0;
      Rv3=((UB *)Rv1)[1];
      while (Rv2<Rv3&&((C *)Rv1)[Rv2+1]<=32)
      Rv2=Rv2+1;
      while (Rv2<Rv3){
        Ra.sl[6]=1411; /* line # 1411 */
        Rv4=((C *)Rv1)[Rv2+1];
        if ((Rv4<48||Rv4>57)&&Rv4>32)  break;
        if (Rv4>32) Rv0=Rv0*10+((SL)Rv4-48);
        Rv2=Rv2+1;
      }
      Ra.sl[6]=1417; /* line # 1417 */
      PAS__DISPOSE(Ra.v+5);
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexp_vl_str "  */
void PAS_INSMBOL_mexp_vl_str(V F_vl, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1389;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1427; /* line # 1427 */
  if (((UB *)F_vl)[0]==0) {
    PAS__VWRITE_INIT(F_str,1);
    PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__STR_TO_STR(F_str,((V *)F_vl)[1]);
    Ra.sl[6]=1432; /* line # 1432 */
    PAS__DISPOSE(((V *)F_vl)+1);
    ((V *)F_vl)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_strv "  */
void PAS_INSMBOL_mexp_strv(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1402;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1444; /* line # 1444 */
  PAS_INSMBOL_mpop(Ra.s+32);
  PAS_INSMBOL_mexp_vl_str(Ra.s+32,F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_call "  */
void PAS_INSMBOL_mexp_call(UB F_fn, SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 824 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1413;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1461; /* line # 1461 */
  if (F_fn==0) {
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1426,22,2);
    else {
      Ra.sl[140]=1466; /* line # 1466 */
      P_insymbol_src();
    }
    if (V_sy_sym.ub[0]==99&&V_sy_macsymb!=NULL) Ra.sl[1]=1;
    else Ra.sl[1]=0;
    Ra.ub[0]=0;
    Ra.sl[140]=1471; /* line # 1471 */
    P_insymbol_src();
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+1426,23,2);
    PAS_INSMBOL_mpush(Ra.s);
  }
  else {
    Ra.sl[140]=1477; /* line # 1477 */
    Rv0=0;
    if (V_sy_sym.ub[0]==14) {
      V_sy_sym.ub[0]=18;
      while (V_sy_sym.ub[0]==18){
        Ra.sl[140]=1483; /* line # 1483 */
        P_insymbol_src();
        PAS_INSMBOL_m_expr_instk();
        Rv0=Rv0+1;
      }
      if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+1426,23,2);
    }
    Ra.sl[140]=1489; /* line # 1489 */
    if (F_narg>0&&Rv0!=F_narg||F_narg<0&&Rv0> -F_narg) {
      P_src_error_s(Rd.s+1426,925,2,(Rd.s+F_fn*36+1432),NULL);
      for( Rf0=Rv0;Rf0>0;Rf0-- )
      PAS_INSMBOL_mpop(Ra.s);
      Ra.sl[140]=1494; /* line # 1494 */
      PAS_INSMBOL_mpush(Rd.s+832);
    }
    else {
      Ra.sl[140]=1499; /* line # 1499 */
      switch (F_fn) {
        case 3:PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[1]=Ra.ub[17];
        Ra.sl[140]=1504; /* line # 1504 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1612,-1,-1,32);
        PAS__WRITE_STR(Ra.s+16,-1,-1,32);
        PAS__WRITE_STR(Rd.s+1623,-1,-1,32);
        PAS__WRITE_INT(Ra.sl[1],0,0);
        PAS__WRITE_EOLN();
        break;
        case 1:Ra.sl[140]=1509; /* line # 1509 */
        if (F_narg==3) Rv1=PAS_INSMBOL_mexp_intv();
        else Rv1=0;
        if (F_narg>1) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=1;
        if (F_narg>0) PAS_INSMBOL_mexp_strv(Ra.s+16);
        else Ra.ub[17]=0;
        Ra.ub[0]=1;
        Ra.sl[1]=0;
        Ra.sl[140]=1514; /* line # 1514 */
        PAS__STR_TO_STR(Ra.s+273,PAS__SUBSTR_STR(Ra.s+564,Ra.s+16,Rv2, Rv1));
        if (Ra.ub[274]>0) {
          Rv3=Ra.ub[274];
          Ra.v[1]=PAS__NEW((SL)Rv3+2);
          ((UB *)Ra.v[1])[0]=Rv3;
          PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
        }
        break;
        case 2:Ra.sl[140]=1525; /* line # 1525 */
        if (F_narg==3) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=0;
        if (F_narg<2) Ra.ub[274]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+273);
        if (F_narg<1) Ra.ub[17]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[1]=PAS__NINDEX_STR(Ra.s+18,(SL)Ra.ub[17],Ra.s+275,(SL)Ra.ub[274],Rv2,-1,1);
        break;
        default:Ra.sl[140]=1533; /* line # 1533 */
        P_src_error(Rd.s+1426,929,2);
        break;
      }
      PAS_INSMBOL_mpush(Ra.s);
    }
  }
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_ident "  */
void PAS_INSMBOL_mexp_ident(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register UB Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1631;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1553; /* line # 1553 */
  Rv0=1;
  Rv1=1;
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[6]=1560; /* line # 1560 */
    Rv2=0;
    while (Rv2<4){
      if (P_match(V_sy_ident.s,(Rd.s+Rv2*36+1432))==0)  break;
      Rv2=Rv2+1;
    }
    Ra.sl[6]=1566; /* line # 1566 */
    if (Rv2>=4) {
      P_src_error_s(Rd.s+1645,928,3, V_sy_ident.s,NULL);
      P_skip_msymbol((V)Rd.s+1652,0);
    }
    else {
      Ra.sl[6]=1573; /* line # 1573 */
      P_insymbol_src();
      PAS_INSMBOL_mexp_call(Rv2, Rd.sl[Rv2*9+366]);
      Rv1=0;
    }
    break;
    case 99:Ra.sl[6]=1580; /* line # 1580 */
    if (V_sy_macsymb!=NULL) {
      Rv1=0;
      PAS_INSMBOL_mpush(V_sy_macsymb+64);
    }
    else {
      Ra.sl[6]=1587; /* line # 1587 */
      P_src_error_s(Rd.s+1645,923,2, V_sy_ident.s,NULL);
    }
    break;
    case 5:Ra.sl[6]=1592; /* line # 1592 */
    Ra.ub[32]=1;
    Ra.sl[9]=0;
    if (V_sy_string.ub[1]>0) {
      Rv3=V_sy_string.ub[1];
      Ra.v[5]=PAS__NEW((SL)Rv3+2);
      ((UB *)Ra.v[5])[0]=Rv3;
      Ra.sl[6]=1597; /* line # 1597 */
      PAS__STR_TO_STR(Ra.v[5],V_sy_string.s);
    }
    break;
    case 2:Ra.sl[6]=1603; /* line # 1603 */
    Ra.ub[32]=0;
    Ra.sl[9]=V_sy_ival;
    Ra.v[5]=NULL;
    break;
    case 18:
    case 19:Ra.sl[6]=1611; /* line # 1611 */
    memcpy(Ra.s+32,Rd.s+832,16);
    Rv0=0;
    break;
    default:Ra.sl[6]=1616; /* line # 1616 */
    memcpy(Ra.s+32,Rd.s+832,16);
    Rv0=0;
    P_src_error(Rd.s+1645,926,2);
    break;
  }
  if (Rv1) PAS_INSMBOL_mpush(Ra.s+32);
  Ra.sl[6]=1621; /* line # 1621 */
  if (Rv0) P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_binop "  */
void PAS_INSMBOL_mexp_binop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 840 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  SL Rv2;
  register F Rgf;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1656;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1640; /* line # 1640 */
  switch (F_ope) {
    case 6:Rv0=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[140]=1645; /* line # 1645 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()*Rv0;
    break;
    case 7:Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1650; /* line # 1650 */
    Ra.ub[0]=0;
    if (Rv0!=0) Ra.sl[1]=PAS__F_ROUND((float)PAS_INSMBOL_mexp_intv()/(float)Rv0)
    ;
    else Ra.sl[1]=0;
    break;
    case 11:Ra.sl[140]=1656; /* line # 1656 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()+Rv0;
    break;
    case 12:Ra.sl[140]=1662; /* line # 1662 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()-Rv0;
    break;
    case 13:Ra.sl[140]=1668; /* line # 1668 */
    PAS_INSMBOL_mexp_strv(Ra.s+16);
    PAS_INSMBOL_mexp_strv(Ra.s+273);
    PAS__STR_TO_STR(Ra.s+273,PAS__CON_STR_STR(Ra.s+564,Ra.s+273,Ra.s+16));
    Ra.ub[0]=1;
    Ra.sl[1]=0;
    Ra.sl[140]=1673; /* line # 1673 */
    Rv1=Ra.ub[274];
    Ra.v[1]=PAS__NEW((SL)Rv1+2);
    ((UB *)Ra.v[1])[0]=Rv1;
    PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:Ra.sl[140]=1678; /* line # 1678 */
    PAS_INSMBOL_mpop(Ra.s+824);
    PAS_INSMBOL_mpop(Ra.s);
    Ra.ub[0]=0;
    if (Ra.ub[824]==1||Ra.ub[0]==1) {
      Ra.sl[140]=1683; /* line # 1683 */
      PAS_INSMBOL_mexp_vl_str(Ra.s+824,Ra.s+16);
      PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+273);
      Rv2=PAS__MATCH_STR(Ra.s+273,Ra.s+16);
      Ra.v[1]=NULL;
    }
    else {
      Ra.sl[140]=1688; /* line # 1688 */
      Rv2=Ra.sl[1]-Ra.sl[207];
    }
    switch (F_ope) {
      case 14:Ra.sl[1]=(SL)(Rv2<0);
      break;
      case 15:Ra.sl[1]=(SL)(Rv2<=0);
      break;
      case 16:Ra.sl[1]=(SL)(Rv2>=0);
      break;
      case 17:Ra.sl[140]=1693; /* line # 1693 */
      Ra.sl[1]=(SL)(Rv2>0);
      break;
      case 18:Ra.sl[1]=(SL)(Rv2!=0);
      break;
      case 19:Ra.sl[1]=(SL)(Rv2==0);
      break;
    }
    break;
    case 20:Ra.sl[140]=1700; /* line # 1700 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=(SL)(Rv0>0&&Rv2>0);
    break;
    case 21:Ra.sl[140]=1708; /* line # 1708 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=(SL)(Rv0>0||Rv2>0);
    break;
    case 22:Ra.sl[140]=1716; /* line # 1716 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.ub[0]=0;
    Ra.sl[1]=(SL)(Rv0>0&&Rv2<=0||Rv0<=0&&Rv2>0);
    break;
    default:Ra.sl[140]=1725; /* line # 1725 */
    P_src_error(Rd.s+1670,927,3);
    break;
  }
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_unaop "  */
void PAS_INSMBOL_mexp_unaop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+1674;
  Ra.v[4]=Rd.s+16;
  Ra.sl[10]=1743; /* line # 1743 */
  switch (F_ope) {
    case 0:Ra.ub[0]=0;
    Ra.v[1]=NULL;
    Ra.sl[10]=1748; /* line # 1748 */
    Ra.sl[1]=(SL)(PAS_INSMBOL_mexp_intv()<=0);
    break;
    default:P_src_error(Rd.s+1688,927,3);
    break;
  }
  Ra.sl[10]=1755; /* line # 1755 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[2];
}


/* Procedure/Function : " mexp_una "  */
void PAS_INSMBOL_PRC_00000013(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1692;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1798; /* line # 1798 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) V_sy_sym.ub[0]
  =6;
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=1804; /* line # 1804 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else Rv0=29;
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000013();
    if (Rv0!=29) PAS_INSMBOL_mexp_unaop(Rv0);
  }
  else {
    Ra.sl[6]=1811; /* line # 1811 */
    if (V_sy_sym.ub[0]==14) {
      P_insymbol_src();
      PAS_INSMBOL_m_expr_instk();
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else {
        Ra.sl[6]=1816; /* line # 1816 */
        P_src_error(Rd.s+1704,23,3);
      }
    }
    else PAS_INSMBOL_mexp_ident();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_mul "  */
void PAS_INSMBOL_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1708;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1823; /* line # 1823 */
  PAS_INSMBOL_PRC_00000013();
  while (V_sy_sym.ub[0]==8){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1828; /* line # 1828 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000013();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_add "  */
void PAS_INSMBOL_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1718;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1835; /* line # 1835 */
  PAS_INSMBOL_PRC_00000012();
  while (V_sy_sym.ub[0]==9){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1840; /* line # 1840 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000012();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_rel "  */
void PAS_INSMBOL_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1728;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1847; /* line # 1847 */
  PAS_INSMBOL_PRC_00000011();
  while (V_sy_sym.ub[0]==10){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1852; /* line # 1852 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000011();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_not "  */
void PAS_INSMBOL_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1738;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1859; /* line # 1859 */
  PAS_INSMBOL_PRC_00000010();
  if (V_sy_sym.ub[0]==11) {
    Lx[2].ub[0]=V_sy_sym.ub[1];
    Ra.sl[6]=1864; /* line # 1864 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000010();
    PAS_INSMBOL_mexp_unaop(Lx[2].ub[0]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_and "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1748;
  Ra.v[3]=Rd.s+16;
  Ra.sl[8]=1871; /* line # 1871 */
  PAS_INSMBOL_PRC_00000009();
  while (V_sy_sym.ub[0]==12){
    Ra.ub[0]=V_sy_sym.ub[1];
    Ra.sl[8]=1876; /* line # 1876 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000009();
    PAS_INSMBOL_mexp_binop(Ra.ub[0]);
  }
  PAS__curr_cntx=Ra.v[1];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " m_expr_instk "  */
void PAS_INSMBOL_m_expr_instk(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1758;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1883; /* line # 1883 */
  PAS_INSMBOL_PRC_00000008();
  while (V_sy_sym.ub[0]==13){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1888; /* line # 1888 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000008();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_sval "  */
void PAS_INSMBOL_mexpr_sval(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1772;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1898; /* line # 1898 */
  PAS_INSMBOL_m_expr_instk();
  PAS_INSMBOL_mexp_strv(F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_ival "  */
SL PAS_INSMBOL_mexpr_ival(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1784;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1906; /* line # 1906 */
  PAS_INSMBOL_m_expr_instk();
  Ret=PAS_INSMBOL_mexp_intv();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexpr_bval "  */
UB PAS_INSMBOL_mexpr_bval(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1796;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1914; /* line # 1914 */
  PAS_INSMBOL_m_expr_instk();
  Ret=PAS_INSMBOL_mexp_intv()>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " if_mstate "  */
UB PAS_INSMBOL_if_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1808;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1930; /* line # 1930 */
  Rv0=V_sy_sym.ub[0];
  P_insymbol_src();
  switch (Rv0) {
    case 94:
    case 95:Ra.sl[6]=1938; /* line # 1938 */
    Rv1=V_sy_macsymb!=NULL^Rv0==95;
    P_insymbol_src();
    break;
    case 93:Ra.sl[6]=1943; /* line # 1943 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    break;
    default:break;
  }
  if (V_sy_sym.ub[0]!=96) P_src_error(Rd.s+1821,932,2);
  Ra.sl[6]=1948; /* line # 1948 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_pragma_mstate(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1080 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.ub[16]=255;
  PAS__STR_TO_STR(Ra.s+16,Rd.s+1825);
  Ra.ub[273]=255;
  PAS__STR_TO_STR(Ra.s+273,Rd.s+1825);
  Ra.ub[530]=255;
  PAS__STR_TO_STR(Ra.s+530,Rd.s+1825);
  Ra.ub[787]=255;
  PAS__STR_TO_STR(Ra.s+787,Rd.s+1825);
  Ra.v[131]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1048;
  Ra.v[132]=Rd.s+2082;
  Ra.v[133]=Rd.s+16;
  Ra.sl[268]=2026; /* line # 2026 */
  P_insymbol_src();
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=F_p_src;
  Ra.sl[268]=2031; /* line # 2031 */
  Rv2=35&((UL *)Rv1)[62];
  while (V_sy_sym.ub[0]==0){
    Rv3=0;
    Rv4=0;
    while (1){
      Ra.sl[268]=2037; /* line # 2037 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      if (Rv3||Rv4==23)  break;
      Rv4=Rv4+1;
    }
    P_insymbol_src();
    Ra.sl[268]=2042; /* line # 2042 */
    switch (Rv4) {
      case 0:PAS_INSMBOL_get_macro_value(Ra.s);
      if (Ra.ub[0]==1) {
        Ra.sl[268]=2048; /* line # 2048 */
        PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+16);
        if (Ra.ub[17]>0) {
          Rv5=V_lst_current;
          Ra.sl[268]=2053; /* line # 2053 */
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+273,((V *)Rv5)[2]);
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+530,((V *)Rv5)[4]);
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+787,((V *)Rv5)[5]);
          Ra.sl[268]=2059; /* line # 2059 */
          P_lst_open(&V_lst_current, Ra.s+16,Ra.s+273,Ra.s+530,Ra.s+787,132,-1,0,0,0,
          &Rv6);
          Ra.sl[268]=2071; /* line # 2071 */
          if (Rv6!=0) {
            if (!V_sy_init_mod) P_src_error(Rd.s+2099,905,2);
            else {
              Ra.sl[268]=2076; /* line # 2076 */
              Rv2=Rv2&~1;
            }
          }
          else {
            if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[268]=2084; /* line # 2084 */
          Rv2=Rv2&~1;
        }
      }
      if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
      Rv2=Rv2|1;
      break;
      case 1:Ra.sl[268]=2090; /* line # 2090 */
      Rv2=Rv2&~1;
      break;
      case 2:Rv2=Rv2|2;
      break;
      case 3:Rv2=Rv2&~2;
      break;
      case 4:Ra.sl[268]=2095; /* line # 2095 */
      Rv2=Rv2|32;
      break;
      case 5:Rv2=Rv2&~32;
      break;
      case 6:Ra.sl[268]=2100; /* line # 2100 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[8]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2106; /* line # 2106 */
        ((SL *)Rv1)[8]=1;
      }
      break;
      case 7:Ra.sl[268]=2111; /* line # 2111 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[11]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2117; /* line # 2117 */
        ((SL *)Rv1)[11]=1;
      }
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[12]=V_sy_ival;
        P_insymbol_src();
      }
      else((SL *)Rv1)[12]=255;
      break;
      case 8:Ra.sl[268]=2124; /* line # 2124 */
      V_cmp_macf=1;
      break;
      case 9:V_cmp_macf=0;
      break;
      case 10:V_cmp_cobj=1;
      break;
      case 11:V_cmp_cobj=0;
      break;
      case 12:Ra.sl[268]=2131; /* line # 2131 */
      if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[268]=2136; /* line # 2136 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else P_src_error(Rd.s+2099,904,4);
      }
      else {
        Ra.sl[268]=2142; /* line # 2142 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 13:if (V_cmp_objf) {
        Ra.sl[268]=2148; /* line # 2148 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 14:V_cmp_bltt=1;
      break;
      case 15:V_cmp_bltt=0;
      break;
      case 16:Ra.sl[268]=2155; /* line # 2155 */
      if (V_sy_sym.ub[0]==2) {
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[268]=2160; /* line # 2160 */
        P_insymbol_src();
      }
      else P_src_error(Rd.s+2099,906,3);
      break;
      case 17:V_cmp_debugopt=1;
      break;
      case 18:Ra.sl[268]=2165; /* line # 2165 */
      V_cmp_debugopt=0;
      break;
      case 19:V_cmp_range=1;
      break;
      case 20:V_cmp_range=0;
      break;
      case 21:Ra.sl[268]=2170; /* line # 2170 */
      P_generation_pragma();
      break;
      case 22:V_cmp_cmpdbg=1;
      break;
      case 23:V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[268]=2176; /* line # 2176 */
      P_src_error_s(Rd.s+2099,901,1, V_sy_ident.s,NULL);
      break;
    }
    if (V_sy_sym.ub[0]==18) P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+2099,21,2);
  else {
    Ra.sl[268]=2181; /* line # 2181 */
    P_insymbol_src();
  }
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~35|Rv2;
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[131];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_include_mstate(UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+2103;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=2201; /* line # 2201 */
  Rv0=V_sy_sym.ub[0]==100;
  P_insymbol_src();
  PAS_INSMBOL_mexpr_sval(Ra.s);
  Ra.sl[72]=2206; /* line # 2206 */
  Rv1=NULL;
  Rv2=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  if (Rv2==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+292,Ra.s,Rd.s+2119));
  Rv1=P_src_file_open(Ra.s,0,NULL);
  Ra.sl[72]=2211; /* line # 2211 */
  if (V_src_openerr==0) {
    Rv3=Rv1;
    ((V *)Rv3)[1]=V_src_control;
    Ra.sl[72]=2216; /* line # 2216 */
    ((SL *)Rv3)[7]=((SL *)V_src_control)[7];
    if (Rv0) ((SL *)Rv3)[7]=((SL *)Rv3)[7]+1;
    ((SL *)Rv3)[8]=((SL *)V_src_control)[8];
    ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
    ((SL *)Rv3)[11]=((SL *)V_src_control)[11];
    Ra.sl[72]=2221; /* line # 2221 */
    ((SL *)Rv3)[12]=((SL *)V_src_control)[12];
    ((UL *)Rv3)[62]=((UL *)Rv3)[62]|((UL *)V_src_control)[62]&103;
    Ra.sl[72]=2226; /* line # 2226 */
    if (V_sy_sym.ub[0]==18) {
      P_insymbol_src();
      PAS_INSMBOL_pragma_mstate(Rv1);
    }
    else {
      Ra.sl[72]=2232; /* line # 2232 */
      if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+2127,21,2);
    }
    if (!Rv0) P_src_end_of_line();
    V_src_control=Rv1;
    if (V_cmp_trace>0) V_cmp_tracecount=0;
    P_compile_set_title();
    Ra.sl[72]=2237; /* line # 2237 */
    P_set_srcfilespc((SL)Rv0);
    V_sy_ch=32;
    V_sy_sym.ub[0]=101;
    if (!Rv0) {
      Ra.sl[72]=2242; /* line # 2242 */
      Rv4=V_src_control;
      Rv1=((V *)Rv4)[1];
      ((V *)Rv4)[1]=((V *)Rv1)[1];
      Ra.sl[72]=2247; /* line # 2247 */
      P_src_close(&Rv1,1);
    }
  }
  else {
    P_lst_newline();
    Ra.sl[72]=2252; /* line # 2252 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2131,-1,-1,32);
    PAS__WRITE_INT(V_src_openerr,3,0);
    PAS__WRITE_EOLN();
    P_lst_newline();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2153,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2177,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__GET_RTL_MSG(V_src_openerr, Ra.s);
    P_lst_newline();
    Ra.sl[72]=2257; /* line # 2257 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2181,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    while ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=103)
    P_insymbol_src();
    if (F_bnsferr) {
      Ra.sl[72]=2262; /* line # 2262 */
      P_src_error(Rd.s+2127,902,4);
    }
    else P_src_error(Rd.s+2127,902,3);
  }
  Ra.sl[72]=2267; /* line # 2267 */
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_endfile_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2198;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2278; /* line # 2278 */
  Rv0=V_src_control;
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=89;
  else {
    Ra.sl[6]=2283; /* line # 2283 */
    V_sy_ch=P_src_return(1);
    V_sy_sym.ub[0]=104;
    V_sy_ch=32;
    P_set_srcfilespc(-1);
    P_compile_set_title();
  }
  Ra.sl[6]=2290; /* line # 2290 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  if (V_sy_sym.ub[0]==89) V_pas_compile=0;
  else P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2214;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2323; /* line # 2323 */
  P_insymbol_src();
  Rv0=V_src_control;
  while (V_sy_sym.ub[0]>=90){
    switch (V_sy_sym.ub[0]) {
      case 100:
      case 101:Ra.sl[6]=2329; /* line # 2329 */
      PAS_INSMBOL_include_mstate(V_sy_init_mod);
      break;
      case 102:PAS_INSMBOL_pragma_mstate(V_src_control);
      break;
      case 90:Ra.sl[6]=2335; /* line # 2335 */
      PAS_INSMBOL_define_macro_symbol();
      break;
      case 91:PAS_INSMBOL_undefine_macro_mbol();
      break;
      case 92:Ra.sl[6]=2341; /* line # 2341 */
      PAS_INSMBOL_macro_assign_symbol();
      break;
      case 93:
      case 94:
      case 95:if (PAS_INSMBOL_if_mstate()) {
        Ra.sl[6]=2346; /* line # 2346 */
        P_insymbol_src();
        V_sy_maclevel=V_sy_maclevel+1;
      }
      else {
        Ra.sl[6]=2351; /* line # 2351 */
        Rv1=((C *)Rv0)[54];
        ((C *)Rv0)[54]=83;
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2232);
        ((C *)Rv0)[54]=Rv1;
        if (V_sy_sym.ub[0]==97) {
          Ra.sl[6]=2356; /* line # 2356 */
          P_insymbol_src();
          V_sy_maclevel=V_sy_maclevel+1;
        }
        else P_insymbol_src();
      }
      break;
      case 97:Ra.sl[6]=2364; /* line # 2364 */
      V_sy_maclevel=V_sy_maclevel-1;
      Rv1=((C *)Rv0)[54];
      ((C *)Rv0)[54]=83;
      PAS_INSMBOL_skip_mcsymbol(Rd.s+2248);
      P_insymbol_src();
      ((C *)Rv0)[54]=Rv1;
      break;
      case 98:Ra.sl[6]=2373; /* line # 2373 */
      V_sy_maclevel=V_sy_maclevel-1;
      P_insymbol_src();
      break;
      case 99:Ra.sl[6]=2378; /* line # 2378 */
      if (V_sy_macsymb!=NULL) {
        P_macro_replace(V_sy_macsymb);
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2384; /* line # 2384 */
        P_src_error_s(Rd.s+2226,995,3, V_sy_ident.s,NULL);
      }
      break;
      case 103:PAS_INSMBOL_endfile_mstate();
      break;
      default:Ra.sl[6]=2393; /* line # 2393 */
      P_src_error(Rd.s+2226,997,3);
      break;
    }
    if (V_sy_maclevel<0) {
      P_src_error(Rd.s+2226,996,2);
      Ra.sl[6]=2398; /* line # 2398 */
      V_sy_maclevel=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2264;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2408; /* line # 2408 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=89){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 57:Ra.sl[6]=2414; /* line # 2414 */
      if (!F_rec_flg) {
        P_skip_symbol(73,0,0);
        P_insymbol();
      }
      break;
      case 42:Ra.sl[6]=2420; /* line # 2420 */
      P_skip_symbol(73,1,0);
      P_insymbol();
      break;
      case 55:
      case 72:P_skip_symbol(73,0,0);
      P_insymbol();
      break;
      case 14:Ra.sl[6]=2428; /* line # 2428 */
      P_skip_symbol(15,0,0);
      P_insymbol();
      break;
      case 16:P_skip_symbol(17,0,0);
      P_insymbol();
      break;
      case 49:Ra.sl[6]=2436; /* line # 2436 */
      P_skip_symbol(50,0,0);
      P_insymbol();
      break;
      case 73:if (F_tosymbol==47||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_msymbol "  */
void P_skip_msymbol(V F_smb, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2277;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2449; /* line # 2449 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,105)||V_sy_sym.ub[0]==89)){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 57:Ra.sl[6]=2455; /* line # 2455 */
      if (!F_rec_flg) {
        P_skip_msymbol(Rd.s+2292,0);
        P_insymbol();
      }
      break;
      case 42:Ra.sl[6]=2462; /* line # 2462 */
      P_skip_msymbol(Rd.s+2304,1);
      P_insymbol();
      break;
      case 55:
      case 72:Ra.sl[6]=2467; /* line # 2467 */
      P_skip_msymbol(Rd.s+2316,0);
      P_insymbol();
      break;
      case 14:Ra.sl[6]=2472; /* line # 2472 */
      P_skip_msymbol((V)Rd.s+2328,0);
      P_insymbol();
      break;
      case 16:Ra.sl[6]=2477; /* line # 2477 */
      P_skip_msymbol((V)Rd.s+2332,0);
      P_insymbol();
      break;
      case 49:Ra.sl[6]=2482; /* line # 2482 */
      P_skip_msymbol(Rd.s+2336,0);
      P_insymbol();
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2344;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2498; /* line # 2498 */
  P_lst_g_init(Rd.s+2355,Rd.s+2357,&Rv0);
  if (Rv0==0) {
    Ra.sl[6]=2503; /* line # 2503 */
    P_err_init(PAS__CON_STR_STR(Ra.s+28,V_cpas_ini_dir.s,Rd.s+2412));
    P_src_init(Rd.s+2426,V_trg_env_fspc.s);
    if (V_cmp_macroexp) {
      Ra.sl[6]=2508; /* line # 2508 */
      P_src_set_flags(2,0);
    }
    if (V_src_control==NULL) {
      V_error_result=4;
      V_emergency_stop=1;
      Ra.sl[6]=2513; /* line # 2513 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2433,-1,-1,32);
      PAS__WRITE_STR(V_trg_env_fspc.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+2483,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2500,-1,-1,32);
      PAS__WRITE_STR(V_trg_sys_name.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=2522; /* line # 2522 */
      PAS_INSMBOL_set_keyword_tree();
      V_proc_seq=0;
      V_srf_free=NULL;
      V_srf_list=NULL;
      Ra.sl[6]=2527; /* line # 2527 */
      V_sy_maclevel=0;
      P_ide_init();
      Ra.sl[6]=2534; /* line # 2534 */
      P_set_srcfilespc(1);
      V_sy_attrflg=0;
      V_sy_ch=32;
      Ra.sl[6]=2541; /* line # 2541 */
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[6]=2546; /* line # 2546 */
    V_error_result=4;
    V_emergency_stop=1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2556,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2355,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2580,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
