/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[3];

/* Define the local data section. */
static Blk( Rd, 2440 ) = {
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 63,  63,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83,
111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,
 51,  47, 112,  99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,  97,
115,   3,   3,  84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95,
115, 101, 116,  95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,  29,
 32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111, 117,
114,  99, 101,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,
 46,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95, 115,
 98, 116, 116, 108,  33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101,
110, 116,  32,  67, 111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100, 117,
108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116,
107, 101, 121, 119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121,
119, 111, 114, 100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120,
111, 114,   3,   3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105,
118,   3,   3, 109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,
  3, 110, 105, 108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116,
111,   4,   4, 116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14,
117, 115, 101, 114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3,
118,  97, 114,   6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,
 95, 118,  97, 114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,
 99,  99, 101, 115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,
 97, 121,   6,   6, 114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,   3,
  3, 117, 115, 101,   3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,   7,
  7, 100, 105, 115, 112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,   5,
114, 101, 115, 101, 116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,   6,
 97, 112, 112, 101, 110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114, 101,
 97, 100, 108, 110,   5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114, 105,
116, 101,   7,   7, 119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114, 105,
116, 101, 118,   7,   7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109, 111,
100, 117, 108, 101,   9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,   8,
  8, 102, 117, 110,  99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117, 114,
110,   7,   7, 102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116,
105,  99,   6,   6, 103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99, 107,
101, 100,   8,   8, 101, 120, 116, 101, 114, 110,  97, 108,   8,   8, 115, 116,
 97, 110, 100,  97, 114, 100,   6,   6, 105, 110, 108, 105, 110, 101,   5,   5,
 98, 101, 103, 105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,   4,
  4, 101, 108, 115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114, 101,
112, 101,  97, 116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111, 114,
  4,   4, 108, 111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,  97,
115, 101,   4,   4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9, 111,
116, 104, 101, 114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100, 111,
  2,   2, 116, 111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37, 100,
101, 102, 105, 110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110, 101,
  4,   4,  37, 108, 101, 116,   3,   3,  37, 105, 102,   6,   6,  37, 105, 102,
100, 101, 102,   8,   8,  37, 105, 102, 117, 110, 100, 101, 102,   5,   5,  37,
116, 104, 101, 110,   5,   5,  37, 101, 108, 115, 101,   6,   6,  37, 101, 110,
100, 105, 102,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,   8,  37, 105,
110,  99, 108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103, 109,  97,   4,
  4,  37, 101, 111, 102,  16,  16,  99, 114, 101,  97, 116, 101,  95, 109,  97,
 99,  95, 105, 100, 101, 110, 116,   4,   4,  67,  82,  69,  77,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  7,   7, 115, 111, 114, 116, 109,  99,  49,  15,  15, 114, 101,  98, 117, 105,
108, 100,  95, 109,  99, 116, 114, 101, 101,  49,  14,  14, 114, 101,  98, 117,
105, 108, 100,  95, 109,  99, 116, 114, 101, 101,   6,   6, 110, 101, 120, 116,
 99, 104,   8,   8, 112, 117, 116,  95,  99, 104,  97, 114,   4,   4,  73,  78,
 83,  89,  12,  12, 116, 101, 115, 116,  95, 102, 105, 103, 117, 114, 101, 115,
  7,   7, 102, 105, 103, 117, 114, 101, 115,   4,   4,  70,  73,  71,  85,  11,
 11, 111, 118, 102,  95, 104,  97, 110, 100, 108, 101, 114,  11,  11,  84, 111,
111,  32,  79,  86,  72,  32,  69,  82,  82,  12,  12, 105, 110, 115, 121, 109,
 98, 111, 108,  95, 115, 114,  99,  13,  13, 115, 107, 105, 112,  95, 109,  99,
115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0, 224,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,  13,  13, 109,  97,  99, 114, 111,  95, 114, 101, 112, 108,
 97,  99, 101,   4,   4,  77,  65,  67,  84,  19,  19, 100, 101, 102, 105, 110,
101,  95, 109,  97,  99, 114, 111,  95, 115, 121, 109,  98, 111, 108,   4,   4,
 67,  82,  77,  83,   0,   0,  12,   0,   0,   0,  12,   0,  21,  21, 117, 110,
100, 101, 102, 105, 110, 101,  95, 109,  97,  99, 114, 111,  95, 115, 121, 109,
 98, 111, 108,   4,   4,  82,  77,  77,  83,   0,   0,   0,   0,   0,  12,   0,
 19,  19, 109,  97,  99, 114, 111,  95,  97, 115, 115, 105, 103, 110,  95, 115,
121, 109,  98, 111, 108,   4,   4,  65,  83,  77,  83,   0,   0,   0,  12,   0,
  0,   0,   0,   0,   0,   2,   0,   0,   4,   0,   0,   0,   8,   8, 109, 118,
 97, 108,  95,  99, 111, 112,   9,   9, 109, 118,  97, 108,  95, 102, 114, 101,
101,   5,   5, 109, 112, 117, 115, 104,   4,   4,  77,  80,  85,  83,   4,   4,
109, 112, 111, 112,   4,   4,  77,  80,  79,  80,  15,  15, 103, 101, 116,  95,
109,  97,  99, 114, 111,  95, 118,  97, 108, 117, 101,   9,   9, 109, 101, 120,
112,  95, 105, 110, 116, 118,  11,  11, 109, 101, 120, 112,  95, 118, 108,  95,
115, 116, 114,   9,   9, 109, 101, 120, 112,  95, 115, 116, 114, 118,   9,   9,
109, 101, 120, 112,  95,  99,  97, 108, 108,   4,   4,  77,  67,  65,  76,  10,
 10, 109, 101, 120, 112,  95, 105, 100, 101, 110, 116,   4,   4,  77,  73,  68,
 69,   0,   0,   0,   7, 100, 101, 102, 105, 110, 101, 100,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   1,   0,   0,   0,   6, 115, 117,  98, 115, 116, 114,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32, 253, 255, 255, 255,   5, 105, 110, 100,
101, 120,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   2,   0,   0,   0,
  5, 108, 101, 110, 103, 116, 104,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  1,   0,   0,   0,   8,  42,  42,  42,  42,  42,  42,  42,  42,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   0,   0,   0,   0,   0,   0,   8,   0,  10,  10, 109, 101,
120, 112,  95,  98, 105, 110, 111, 112,   4,   4,  77,  66,  73,  78,  10,  10,
109, 101, 120, 112,  95, 117, 110,  97, 111, 112,   4,   4,  77,  85,  78,  65,
  8,   8, 109, 101, 120, 112,  95, 117, 110,  97,   4,   4,  77,  69,  88,  80,
  8,   8, 109, 101, 120, 112,  95, 109, 117, 108,   8,   8, 109, 101, 120, 112,
 95,  97, 100, 100,   8,   8, 109, 101, 120, 112,  95, 114, 101, 108,   8,   8,
109, 101, 120, 112,  95, 110, 111, 116,   8,   8, 109, 101, 120, 112,  95,  97,
110, 100,  12,  12, 109,  95, 101, 120, 112, 114,  95, 105, 110, 115, 116, 107,
 10,  10, 109, 101, 120, 112, 114,  95, 115, 118,  97, 108,  10,  10, 109, 101,
120, 112, 114,  95, 105, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95,
 98, 118,  97, 108,   9,   9, 105, 102,  95, 109, 115, 116,  97, 116, 101,   4,
  4,  77,  67,  73,  70, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,  13,  13, 112, 114,  97, 103, 109,  97,  95, 109,
115, 116,  97, 116, 101,   4,   4,  80,  82,  65,  71,  14,  14, 105, 110,  99,
108, 117, 100, 101,  95, 109, 115, 116,  97, 116, 101,   4,   4,  46, 112,  97,
115,   4,   4,  73,  78,  67,  76,  20,  20,  32,  79, 112, 101, 110,  32,  69,
114, 114, 111, 114,  32,  40,  82,  84,  76,  41,  32,  35,  32,  22,  22,  32,
102, 111, 114,  32, 116, 104, 101,  32,  83, 111, 117, 114,  99, 101,  32, 102,
105, 108, 101,  32,  34,   2,   2,  34,  46,  15,  15,  32,  82,  84,  76,  32,
109, 101, 115, 115,  97, 103, 101,  32,  58,  32,  14,  14, 101, 110, 100, 102,
105, 108, 101,  95, 109, 115, 116,  97, 116, 101,   8,   8, 105, 110, 115, 121,
109,  98, 111, 108,   4,   4,  77,  65,  83,  89,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,  11,  11, 115, 107,
105, 112,  95, 115, 121, 109,  98, 111, 108,  12,  12, 115, 107, 105, 112,  95,
109, 115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0, 128,   0,   0,
  0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   4,   0,   9,   9, 105, 110,
115, 121,  95, 105, 110, 105, 116,   0,   0,  53,  53,  32,  80,  32,  65,  32,
 83,  32,  45,  32,  80,  46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,
 79,  70,  84,  87,  65,  82,  69,  58,  32,  86,  51,  46,  49,  45,  66,  50,
 32,  79,  70,  32,  51,  48,  45,  74,  85,  78,  45,  50,  48,  49,  54,  32,
 12,  12,  99, 112,  97, 115,  95,  99, 109, 112,  46, 101, 114, 114,   5,   5,
 32,  80,  65,  83,  62,  48,  48,  32,  42,  42,  42,  32,  80,  67,  77,  80,
 45,  67,  80,  65,  83,  45,  67,  79,  77,  80,  73,  76,  69,  82,  32,  69,
 82,  82,  79,  82,  58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101,
110,  32, 116, 104, 101,  32,  34,  15,  15,  34,  32, 105, 110, 105, 116, 105,
 97, 108,  32, 102, 105, 108, 101,  46,  54,  54,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32, 102, 111, 114,  32, 116, 104, 101,
 32, 116,  97, 114, 103, 101, 116,  32, 115, 121, 115, 116, 101, 109,  32,  34,
 22,  22,  32,  80,  65,  83,  32,  67,  65,  78,  78,  79,  84,  32,  79,  80,
 69,  78,  32,  84,  72,  69,  32,  34,  23,  23,  34,  32,  79,  85,  84,  80,
 85,  84,  32,  77,  83,  71,  47,  76,  73,  83,  84,  32,  70,  73,  76,  69,
 46,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 928 ) = {
  0,   0,   0,   0,   0,   1,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   4,   5,   6,   7,   7,   7,  15,   6,  16,  17,  10,  18,
 19,  20,   9,  21,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  14,  22,
 11,  12,  13,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  23,
 24,  25,  26,   7,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   4,
  5,   4,   4,   3,  12,  20,  14,  29,  15,  29,   9,  11,  18,  29,   9,  12,
  8,   7,  19,  29,  16,  29,   6,   0,  17,  29,  24,  29,   0,   0,   0,   0,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10, 112,  99, 109, 112, 100, 101,  98,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11, 112,  99, 109, 112, 100, 101,  98,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32
};

/* Define the local static section. */
static Blk( Rs, 512 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern V V_macsymb_tree;
extern V V_macsymb_frst;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern UB V_sy_attrflg;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern V V_sy_macsymb;
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern SL V_sy_maclevel;
extern Blk(V_cpas_ini_dir, 264 );
extern Blk(V_trg_env_fspc, 264 );
extern UB V_cmp_macroexp;
extern UB V_error_result;
extern UB V_emergency_stop;
extern Blk(V_trg_sys_name, 264 );
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr);
void P_src_macro_open(V *F_p, V F_txt, V F_p0, V F_p1, V F_p2, UB F_bact);
C P_src_return(UB F_bfree);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_set_flags(UL F_flg, UB F_fclr);
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_insymbol();
void P_skip_msymbol(V F_smb, UB F_rec_flg);
void P_binary_objf_close();
void P_generation_pragma();
void PAS_INSMBOL_get_macro_value(V F_vl);
void PAS_INSMBOL_m_expr_instk();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=164; /* line # 164 */
  if (F_icd>=0) {
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+81);
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[72]=170; /* line # 170 */
      if (V_srf_free==NULL) Rv0=PAS__NEW(16);
      else {
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Rv1=Rv0;
      Ra.sl[72]=176; /* line # 176 */
      ((V *)Rv1)[0]=V_srf_list;
      ((V *)Rv1)[1]=NULL;
      P_val_new(((V *)Rv1)+1,NULL);
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[72]=183; /* line # 183 */
      Rv2=V_srf_list;
      P_val_free(((V *)Rv2)+1);
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[72]=188; /* line # 188 */
    Rv3=((V *)V_srf_list)[1];
    ((UB *)Rv3)[48]=32;
    ((SL *)Rv3)[6]=Ra.ub[1];
    Rv4=Ra.ub[1];
    ((V *)Rv3)[7]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[7])[0]=Rv4;
    Ra.sl[72]=193; /* line # 193 */
    PAS__STR_TO_STR(((V *)Rv3)[7],Ra.s);
  }
  else {
    Ra.sl[72]=198; /* line # 198 */
    Rv0=V_srf_list;
    Rv5=Rv0;
    V_srf_list=((V *)Rv5)[0];
    P_val_free(((V *)Rv5)+1);
    Ra.sl[72]=203; /* line # 203 */
    ((V *)Rv5)[0]=V_srf_free;
    V_srf_free=Rv0;
  }
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+86;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=228; /* line # 228 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+105);
  Ra.sl[72]=233; /* line # 233 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.s+
110,Ra.s),Rd.s+141));
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+145;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=251; /* line # 251 */
  Rv0=V_lst_current;
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  if (((V *)F_prc)[3]!=NULL) {
    Rv1=((V *)F_prc)[3];
    Ra.sl[72]=257; /* line # 257 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+292,Rv1+1,31,1,((UB *)Rv1)[0]));
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.
    s+164,Ra.s),Rd.s+199));
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+203;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=286; /* line # 286 */
  Rv0=PAS__NEW(50);
  Rv1=Rv0;
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[6]=291; /* line # 291 */
  ((V *)Rv1)[4]=NULL;
  ((V *)Rv1)[5]=NULL;
  ((UB *)Rv1)[48]=F_skw;
  ((UB *)Rv1)[49]=F_opkw;
  Rv3=V_keyword_tree;
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[6]=298; /* line # 298 */
      Rv4=Rv3;
      Rv5=Rv3;
      Rv6=P_match(Rv0,Rv5);
      if (Rv6>0) Rv3=((V *)Rv5)[5];
      else {
        Ra.sl[6]=303; /* line # 303 */
        Rv3=((V *)Rv5)[4];
      }
      if (Rv3==NULL)  break;
    }
    if (Rv6>0) ((V *)Rv4)[5]=Rv0;
    else((V *)Rv4)[4]=Rv0;
  }
  else {
    Ra.sl[6]=309; /* line # 309 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=315; /* line # 315 */
  PAS_INSMBOL_PRC_00000000(Rd.s+233,13,21);
  PAS_INSMBOL_PRC_00000000(Rd.s+237,13,22);
  PAS_INSMBOL_PRC_00000000(Rd.s+242,12,20);
  PAS_INSMBOL_PRC_00000000(Rd.s+247,6,0);
  PAS_INSMBOL_PRC_00000000(Rd.s+252,8,8);
  Ra.sl[6]=320; /* line # 320 */
  PAS_INSMBOL_PRC_00000000(Rd.s+257,8,9);
  PAS_INSMBOL_PRC_00000000(Rd.s+262,8,10);
  PAS_INSMBOL_PRC_00000000(Rd.s+267,10,23);
  Ra.sl[6]=326; /* line # 326 */
  PAS_INSMBOL_PRC_00000000(Rd.s+271,28,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+276,33,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+283,34,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+289,30,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+295,29,29);
  Ra.sl[6]=331; /* line # 331 */
  PAS_INSMBOL_PRC_00000000(Rd.s+302,32,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+318,31,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+323,36,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+331,37,29);
  Ra.sl[6]=336; /* line # 336 */
  PAS_INSMBOL_PRC_00000000(Rd.s+340,44,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+349,39,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+357,40,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+363,41,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+370,42,29);
  Ra.sl[6]=341; /* line # 341 */
  PAS_INSMBOL_PRC_00000000(Rd.s+378,43,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+383,74,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+388,59,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+393,60,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+399,61,29);
  Ra.sl[6]=346; /* line # 346 */
  PAS_INSMBOL_PRC_00000000(Rd.s+408,62,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+414,63,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+421,64,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+430,65,29);
  Ra.sl[6]=351; /* line # 351 */
  PAS_INSMBOL_PRC_00000000(Rd.s+438,66,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+444,67,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+452,68,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+459,69,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+466,70,29);
  Ra.sl[6]=356; /* line # 356 */
  PAS_INSMBOL_PRC_00000000(Rd.s+475,71,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+483,76,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+492,75,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+500,77,29);
  Ra.sl[6]=361; /* line # 361 */
  PAS_INSMBOL_PRC_00000000(Rd.s+511,78,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+521,79,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+529,80,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+538,87,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+546,82,29);
  Ra.sl[6]=366; /* line # 366 */
  PAS_INSMBOL_PRC_00000000(Rd.s+554,38,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+562,81,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+572,83,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+582,84,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+590,72,29);
  Ra.sl[6]=371; /* line # 371 */
  PAS_INSMBOL_PRC_00000000(Rd.s+597,45,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+601,46,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+607,47,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+613,48,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+620,49,29);
  Ra.sl[6]=376; /* line # 376 */
  PAS_INSMBOL_PRC_00000000(Rd.s+628,50,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+635,51,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+640,55,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+646,56,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+652,57,29);
  Ra.sl[6]=381; /* line # 381 */
  PAS_INSMBOL_PRC_00000000(Rd.s+658,58,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+664,73,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+669,86,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+680,85,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+684,54,29);
  Ra.sl[6]=386; /* line # 386 */
  PAS_INSMBOL_PRC_00000000(Rd.s+688,52,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+692,53,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+700,90,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+709,91,29);
  Ra.sl[6]=391; /* line # 391 */
  PAS_INSMBOL_PRC_00000000(Rd.s+720,92,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+726,93,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+731,94,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+739,95,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+749,96,29);
  Ra.sl[6]=396; /* line # 396 */
  PAS_INSMBOL_PRC_00000000(Rd.s+756,97,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+763,98,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+771,101,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+780,100,29);
  PAS_INSMBOL_PRC_00000000(Rd.s+790,102,29);
  Ra.sl[6]=405; /* line # 405 */
  PAS_INSMBOL_PRC_00000000(Rd.s+799,103,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_mac_ident "  */
V P_create_mac_ident(V F_id, UB F_cmdf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+805;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=425; /* line # 425 */
  Rv0=V_macsymb_tree;
  Rv1=NULL;
  Rv2=1;
  while (Rv0!=NULL&&Rv2!=0){
    Ra.sl[6]=430; /* line # 430 */
    Rv1=Rv0;
    Rv3=Rv0;
    Rv2=P_match(F_id,Rv3);
    if (Rv2!=0) {
      Ra.sl[6]=435; /* line # 435 */
      if (Rv2>0) Rv0=((V *)Rv3)[6];
      else Rv0=((V *)Rv3)[5];
    }
  }
  if (Rv2==0) {
    Ra.sl[6]=440; /* line # 440 */
    if (F_cmdf) Rv4=Rv0;
    else P_src_error(Rd.s+825,999,2);
  }
  else {
    Rv4=PAS__NEW(80);
    Ra.sl[6]=445; /* line # 445 */
    Rv5=Rv4;
    memcpy(Rv5,F_id,32);
    ((V *)Rv5)[4]=NULL;
    ((V *)Rv5)[5]=NULL;
    Ra.sl[6]=450; /* line # 450 */
    ((V *)Rv5)[6]=NULL;
    ((UB *)Rv5)[56]=0;
    memcpy(Rv5+64,Rd.s+832,16);
    if (Rv1==NULL) {
      Ra.sl[6]=455; /* line # 455 */
      V_macsymb_tree=Rv4;
    }
    else {
      if (Rv2>0) ((V *)Rv1)[6]=Rv4;
      else((V *)Rv1)[5]=Rv4;
    }
  }
  Ra.sl[6]=460; /* line # 460 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sortmc1 "  */
void PAS_INSMBOL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+848;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=487; /* line # 487 */
  Rv0=F_p;
  if (((V *)Rv0)[5]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[5]);
  Rv1=((UB *)Rv0)[0]==0;
  if (!Rv1) {
    Ra.sl[6]=493; /* line # 493 */
    if (V_macsymb_frst==NULL) V_macsymb_frst=F_p;
    else((V *)Lx[0].v[0])[4]=F_p;
    Lx[0].v[0]=F_p;
    ((V *)Rv0)[4]=NULL;
    Lx[0].sl[2]=Lx[0].sl[2]+1;
  }
  Ra.sl[6]=499; /* line # 499 */
  if (((V *)Rv0)[6]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[6]);
  if (Rv1) {
    Rv2=F_p;
    Rv3=Rv2+64;
    Ra.sl[6]=504; /* line # 504 */
    if (((V *)Rv3)[1]!=NULL) PAS__DISPOSE(((V *)Rv3)+1);
    PAS__DISPOSE(&F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rebuild_mctree1 "  */
V PAS_INSMBOL_PRC_00000002(SL F_n, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+857;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=518; /* line # 518 */
  Rv0=(F_n+F_m)/2;
  Rv1=((V *)Lx[0].v[2])[Rv0];
  Rv2=Rv1;
  if (Rv0==F_n) ((V *)Rv2)[5]=NULL;
  else {
    Ra.sl[6]=523; /* line # 523 */
    ((V *)Rv2)[5]=PAS_INSMBOL_PRC_00000002(F_n, Rv0-1);
  }
  if (Rv0==F_m) ((V *)Rv2)[6]=NULL;
  else((V *)Rv2)[6]=PAS_INSMBOL_PRC_00000002(Rv0+1, F_m);
  Ret=Rv1;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rebuild_mctree "  */
void P_rebuild_mctree(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+874;
  Ra.v[5]=Rd.s+16;
  Ra.sl[12]=533; /* line # 533 */
  Ra.sl[2]=0;
  V_macsymb_frst=NULL;
  if (V_macsymb_tree!=NULL) {
    PAS_INSMBOL_PRC_00000001(V_macsymb_tree);
    Ra.sl[12]=538; /* line # 538 */
    if (Ra.sl[2]>0) {
      Ra.v[0]=V_macsymb_frst;
      Rv0=Ra.sl[2];
      Ra.v[2]=PAS__NEW(Rv0*8+8);
      ((SL *)Ra.v[2])[0]=Rv0;
      Rv1=1;
      for( Rf0=Ra.sl[2];Rf0>0;Rf0-- ) {
        Ra.sl[12]=543; /* line # 543 */
        ((V *)Ra.v[2])[Rv1]=Ra.v[0];
        Ra.v[0]=((V *)Ra.v[0])[4];
        Rv1++;
      }
      V_macsymb_tree=PAS_INSMBOL_PRC_00000002(1, Ra.sl[2]);
    }
    else {
      Ra.sl[12]=549; /* line # 549 */
      V_macsymb_tree=NULL;
      V_macsymb_frst=NULL;
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+890;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=637; /* line # 637 */
  V_sy_ch=P_src_inchar();
  V_sy_cmin=V_sy_ch;
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+898;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=646; /* line # 646 */
  if (!Lx[1].ub[0]) {
    if (Lx[1].sl[1]<V_sy_string.ub[0]) {
      V_sy_string.c[Lx[1].sl[1]+1]=V_sy_ch;
      Lx[1].sl[1]=Lx[1].sl[1]+1;
    }
    else {
      Ra.sl[6]=654; /* line # 654 */
      P_src_error(Rd.s+910,12,2);
      Lx[1].ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000005(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+914;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=665; /* line # 665 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    if ((Lx[1].ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else Rv0=-1;
  }
  if (Rv0>=Lx[1].sl[3]) Rv0=-2;
  Ra.sl[6]=670; /* line # 670 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000006(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+928;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=681; /* line # 681 */
  Rv0=PAS_INSMBOL_PRC_00000005(F_ch);
  if (Rv0==-2) {
    Rv0=0;
    P_src_error(Rd.s+939,16,2);
  }
  Ra.sl[6]=686; /* line # 686 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000007(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+943;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=696; /* line # 696 */
  Ri.sl[0]=Ri.sl[0]+1;
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+956,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  if (F_ierr>=20&&F_ierr<=25) {
    if (!Lx[1].ub[16]) {
      Ra.sl[6]=702; /* line # 702 */
      P_src_error(Rd.s+910,11,2);
      Lx[1].g[3]=1.000000000000000E+000;
      Lx[1].g[4]=1.000000000000000E+000;
      Lx[1].ub[16]=1;
    }
    Ret=1;
  }
  else {
    Ra.sl[6]=709; /* line # 709 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register V Rv2;
  G Rv3;
  SL Rv4;
  SL Rv5;
  G Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  C Rv14;
  UB Rv15;
  SL Rv16;
  register V Rv17;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+969;
  Ra.v[7]=Rd.s+16;
  Ra.sl[16]=715; /* line # 715 */
  while (V_sy_ch==32||V_sy_ch==0)
  PAS_INSMBOL_PRC_00000003();
  Rv0=1;
  Rv1=V_sy_attrflg;
  V_sy_attrflg=0;
  Rv2=V_src_control;
  ((SL *)Rv2)[4]=((SL *)Rv2)[5];
  Ra.sl[16]=720; /* line # 720 */
  switch (Ri.ub[V_sy_cmin+4]) {
    case 8:
    case 9:PAS__ESTABLISH(PAS_INSMBOL_PRC_00000007);
    Ra.sl[16]=725; /* line # 725 */
    Ra.ub[16]=0;
    V_sy_sym.ub[0]=20;
    V_sy_sym.ub[1]=29;
    Rv3=0.000000000000000E-001;
    Ra.sl[3]=10;
    Ra.sl[16]=730; /* line # 730 */
    Rv4=0;
    Ra.ub[8]=0;
    while (Ri.ub[V_sy_cmin+4]==8){
      V_sy_sym.ub[0]=2;
      Ra.sl[16]=735; /* line # 735 */
      Rv5=(SL)V_sy_cmin-48;
      if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      while (1){
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_cmin!=95)  break;
      }
      if (!Ra.ub[16]) Rv3=Rv3*1.000000000000000E+001+(double)Rv5;
    }
    Ra.sl[16]=741; /* line # 741 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Rv4=0;
      Ra.sl[3]=(Rv3>0.0?(SL)(Rv3+0.5):(SL)(Rv3-0.5));
      if (Ra.sl[3]<2||Ra.sl[3]>16) {
        Ra.sl[16]=747; /* line # 747 */
        P_src_error(Rd.s+910,14,2);
        Ra.sl[3]=10;
      }
      Ra.ub[8]=1;
      Rv3=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[16]=753; /* line # 753 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
        if ((float)Rv5<(F)0.000000E-01)  break;
        if (!Ra.ub[16]) Rv3=Rv3*(double)Ra.sl[3]+(double)Rv5;
        if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      }
    }
    Ra.sl[16]=762; /* line # 762 */
    Rv6=(double)Ra.sl[3];
    Ra.g[3]=Rv6;
    if (V_sy_ch==46) {
      if (P_src_next_char()==46) {
        Ra.sl[16]=767; /* line # 767 */
        if (V_sy_sym.ub[0]==20) {
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=21;
        }
        else {
          Ra.sl[16]=772; /* line # 772 */
          Rv0=0;
        }
      }
      else {
        while (1){
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Rv6=(double)Ra.sl[3];
        Ra.g[3]=Rv6;
        Ra.g[4]=1.000000000000000E+000;
        Ra.sl[16]=777; /* line # 777 */
        if (PAS_INSMBOL_PRC_00000005(V_sy_cmin)<0) Rv0=0;
        else {
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[16]=783; /* line # 783 */
            if (Ra.g[4]!=1.000000000000000E+000) while (1){
              PAS_INSMBOL_PRC_00000003();
              if (V_sy_cmin!=95)  break;
            }
            Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
            if (Rv5<0)  break;
            Ra.g[4]=Ra.g[4]/Rv6;
            Ra.sl[16]=788; /* line # 788 */
            Rv3=Rv3+Ra.g[4]*(double)Rv5;
            Rv4=Rv4+1;
          }
        }
      }
    }
    Ra.sl[16]=795; /* line # 795 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000003();
    if (V_sy_sym.ub[0]!=20&&V_sy_sym.ub[0]!=21) {
      if (V_sy_cmin==101) {
        Ra.sl[16]=801; /* line # 801 */
        V_sy_sym.ub[0]=4;
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_ch==43||V_sy_ch==45) {
          if (V_sy_ch==45) Ra.g[3]=1.000000000000000E+000/Ra.g[3];
          Ra.sl[16]=806; /* line # 806 */
          PAS_INSMBOL_PRC_00000003();
        }
        Rv7=0;
        while (Ri.ub[V_sy_cmin+4]==8){
          Ra.sl[16]=812; /* line # 812 */
          Rv7=Rv7*10+((SL)V_sy_ch-48);
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[16]=817; /* line # 817 */
        Ra.g[4]=1.000000000000000E+000;
        while (Rv7!=0&&!Ra.ub[16])
        if (Rv7&1) {
          Ra.sl[16]=822; /* line # 822 */
          Rv7=Rv7-1;
          Ra.g[4]=Ra.g[4]*Ra.g[3];
        }
        else {
          Ra.sl[16]=827; /* line # 827 */
          Rv7=Rv7/2;
          Ra.g[3]=PAS__G_SQR(Ra.g[3]);
        }
        if (!Ra.ub[16]) Rv3=Rv3*Ra.g[4];
      }
      Ra.sl[16]=834; /* line # 834 */
      if (Ra.ub[16]) Rv3=0.000000000000000E-001;
      if (V_sy_sym.ub[0]==2) {
        if (Rv3<=4.294967295000001E+009&&Rv3>=-2.147483648000001E+009) {
          Ra.sl[16]=840; /* line # 840 */
          if (Rv3>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rv3)+1;
          else V_sy_ival=(int)(Rv3);
          V_sy_rval=(double)V_sy_ival;
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
            Ra.sl[16]=846; /* line # 846 */
            PAS_INSMBOL_PRC_00000003();
            P_ide_int_label();
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[16]=851; /* line # 851 */
          V_sy_sym.ub[0]=4;
        }
      }
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[16]=856; /* line # 856 */
        V_sy_ival=0;
        if (Rv3>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[16]=861; /* line # 861 */
          if (Ra.sl[3]>2) Rv4=Rv4*(int)(log(Rv6)/6.931471805599453E-001)+2;
          else Rv4=Rv4+2;
          if (Rv4>24) V_sy_sym.ub[0]=4;
          else V_sy_sym.ub[0]=3;
        }
      }
      Ra.sl[16]=868; /* line # 868 */
      V_sy_rval=Rv3;
      Rv0=0;
    }
    PAS__REVERT();
    break;
    case 7:Ra.sl[16]=875; /* line # 875 */
    V_sy_ident.ub[0]=0;
    while (1){
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[16]=882; /* line # 882 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      PAS_INSMBOL_PRC_00000003();
      if (Ri.ub[V_sy_cmin+4]!=7&&Ri.ub[V_sy_cmin+4]!=8)  break;
    }
    Ra.sl[16]=888; /* line # 888 */
    Rv8=V_keyword_tree;
    while (1){
      Rv9=Rv8;
      Rv10=P_match(V_sy_ident.s,Rv9);
      Ra.sl[16]=893; /* line # 893 */
      if (Rv10!=0) {
        if (Rv10>0) Rv8=((V *)Rv9)[5];
        else Rv8=((V *)Rv9)[4];
      }
      if (Rv10==0||Rv8==NULL)  break;
    }
    if (Rv8!=NULL) {
      Ra.sl[16]=898; /* line # 898 */
      memcpy(V_sy_sym.s,Rv8+48,2);
    }
    else {
      V_sy_macsymb=V_macsymb_tree;
      Ra.sl[16]=903; /* line # 903 */
      V_sy_sym.ub[0]=99;
      Rv10=1;
      while (Rv10!=0&&V_sy_macsymb!=NULL){
        Rv11=V_sy_macsymb;
        Ra.sl[16]=908; /* line # 908 */
        Rv10=P_match(V_sy_ident.s,Rv11);
        if (Rv10!=0) {
          if (Rv10>0) V_sy_macsymb=((V *)Rv11)[6];
          else V_sy_macsymb=((V *)Rv11)[5];
        }
      }
      if (Rv10==0) V_sy_sym.ub[0]=99;
      else {
        Ra.sl[16]=915; /* line # 915 */
        if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=1;
        }
        else {
          Ra.sl[16]=922; /* line # 922 */
          if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
          V_sy_sym.ub[0]=0;
        }
      }
      Ra.sl[16]=927; /* line # 927 */
      V_sy_sym.ub[1]=29;
    }
    Rv0=0;
    break;
    case 6:Ra.sl[16]=933; /* line # 933 */
    if (Rv1) {
      V_sy_sym.ub[0]=25;
      V_sy_sym.ub[1]=29;
      Rv1=0;
    }
    else {
      Ra.sl[16]=940; /* line # 940 */
      V_sy_sym.ub[1]=29;
      Rv12=V_src_control;
      Rv13=(524288&((UL *)Rv12)[62])!=0;
      Ra.sl[16]=945; /* line # 945 */
      ((UB *)Rv12)[252]=4;
      ((UL *)Rv12)[62]=((UL *)Rv12)[62]|524288;
      Rv14=V_sy_cmin;
      V_sy_sym.ub[0]=5;
      Ra.sl[16]=950; /* line # 950 */
      Ra.sl[1]=1;
      Ra.ub[0]=0;
      Rv15=1;
      while (Rv15){
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[16]=955; /* line # 955 */
        while (Ri.ub[V_sy_cmin+4]==1)
        PAS_INSMBOL_PRC_00000003();
        if (Ri.ub[V_sy_cmin+4]==2) Rv15=0;
        if (V_sy_ch==Rv14) {
          if (Rv14==P_src_next_char()) {
            Ra.sl[16]=961; /* line # 961 */
            PAS_INSMBOL_PRC_00000003();
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            ((UB *)V_src_control)[252]=0;
            Ra.sl[16]=966; /* line # 966 */
            Rv15=0;
          }
        }
        else {
          if (Rv14==34&&V_sy_ch==92) {
            Ra.sl[16]=972; /* line # 972 */
            PAS_INSMBOL_PRC_00000003();
            switch (V_sy_cmin) {
              case 34:
              case 39:
              case 92:break;
              case 97:V_sy_ch=7;
              break;
              case 98:V_sy_ch=8;
              break;
              case 101:Ra.sl[16]=977; /* line # 977 */
              V_sy_ch=27;
              break;
              case 102:V_sy_ch=12;
              break;
              case 110:V_sy_ch=10;
              break;
              case 114:V_sy_ch=13;
              break;
              case 116:V_sy_ch=9;
              break;
              case 118:Ra.sl[16]=982; /* line # 982 */
              V_sy_ch=11;
              break;
              case 122:V_sy_ch=0;
              break;
              case 48:
              case 49:
              case 50:
              case 51:
              case 52:
              case 53:
              case 54:
              case 55:
              case 56:
              case 57:Rv10=(SL)V_sy_cmin-48;
              PAS_INSMBOL_PRC_00000003();
              Ra.sl[16]=987; /* line # 987 */
              Rv16=3;
              while ((Rv16>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
                Rv10=(Rv10*10+(SL)V_sy_cmin)-48;
                PAS_INSMBOL_PRC_00000003();
              }
              Ra.sl[16]=993; /* line # 993 */
              if (Rv10<=255) V_sy_ch=(C)Rv10;
              else {
                V_sy_ch=32;
                P_src_error(Rd.s+910,17,2);
              }
              break;
              default:V_sy_ch=32;
              P_src_error(Rd.s+910,18,2);
              break;
            }
            Ra.sl[16]=999; /* line # 999 */
            PAS_INSMBOL_PRC_00000004();
          }
          else PAS_INSMBOL_PRC_00000004();
        }
      }
      V_sy_string.ub[1]=Ra.sl[1] -1;
      Ra.sl[16]=1005; /* line # 1005 */
      Rv17=V_src_control;
      if (!Rv13) {
        ((UL *)Rv17)[62]=((UL *)Rv17)[62]&~524288;
        if (Ri.ub[V_sy_cmin+4]==1) V_sy_ch=32;
      }
    }
    break;
    case 14:Ra.sl[16]=1015; /* line # 1015 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[1]=29;
    if (V_sy_ch==61) V_sy_sym.ub[0]=23;
    else {
      V_sy_sym.ub[0]=22;
      Rv0=0;
    }
    break;
    case 11:Ra.sl[16]=1023; /* line # 1023 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[16]=1028; /* line # 1028 */
        V_sy_sym.ub[1]=14;
        Rv0=0;
      }
    }
    break;
    case 13:Ra.sl[16]=1033; /* line # 1033 */
    PAS_INSMBOL_PRC_00000003();
    V_sy_sym.ub[0]=10;
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      V_sy_sym.ub[1]=17;
      Rv0=0;
    }
    break;
    case 5:Ra.sl[16]=1041; /* line # 1041 */
    Rv14=V_sy_ch;
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==Rv14) {
      V_sy_sym.ub[0]=9;
      V_sy_sym.ub[1]=13;
    }
    else {
      V_sy_sym.ub[0]=13;
      V_sy_sym.ub[1]=21;
      Rv0=0;
    }
    break;
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[16]=1048; /* line # 1048 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    break;
    case 17:
    case 25:
    case 26:memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    Ra.sl[16]=1053; /* line # 1053 */
    PAS_INSMBOL_PRC_00000003();
    if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
    Rv0=0;
    break;
    case 10:Ra.sl[16]=1060; /* line # 1060 */
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      V_sy_sym.ub[0]=8;
      V_sy_sym.ub[1]=6;
      Rv0=0;
    }
    break;
    case 12:Ra.sl[16]=1067; /* line # 1067 */
    PAS_INSMBOL_PRC_00000003();
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=26;
      V_sy_sym.ub[1]=29;
    }
    else {
      V_sy_sym.ub[0]=10;
      V_sy_sym.ub[1]=19;
      Rv0=0;
    }
    break;
    case 2:Ra.sl[16]=1073; /* line # 1073 */
    V_sy_sym.ub[0]=103;
    V_sy_sym.ub[1]=29;
    V_sy_ch=32;
    Rv0=0;
    break;
    case 1:V_sy_sym.ub[0]=88;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[16]=1079; /* line # 1079 */
    V_sy_sym.ub[0]=104;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    if (V_sy_ch!=32) P_src_error(Rd.s+910,13,2);
    V_sy_ch=32;
    break;
  }
  Ra.sl[16]=1086; /* line # 1086 */
  if (Rv0) PAS_INSMBOL_PRC_00000003();
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " skip_mcsymbol "  */
void PAS_INSMBOL_skip_mcsymbol(V F_smb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+983;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1093; /* line # 1093 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,105)||V_sy_sym.ub[0]==89)){
    P_insymbol_src();
    Ra.sl[6]=1098; /* line # 1098 */
    switch (V_sy_sym.ub[0]) {
      case 93:
      case 94:
      case 95:while (PAS__INOP_LSET(V_sy_sym.ub[0],Rd.s+1000,96)){
        PAS_INSMBOL_skip_mcsymbol(Rd.s+1012);
        Ra.sl[6]=1103; /* line # 1103 */
        P_insymbol_src();
      }
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_replace "  */
void P_macro_replace(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1028;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1134; /* line # 1134 */
  Rv2=F_mcp;
  Rv3=Rv2+64;
  if (!((UB *)Rv2)[56]) {
    switch (((UB *)Rv3)[0]) {
      case 0:Ra.sl[6]=1141; /* line # 1141 */
      Rv0=PAS__NEW(24);
      ((UB *)Rv0)[0]=22;
      PAS__VWRITE_INIT(Rv0,1);
      PAS__WRITE_INT(((SL *)Rv3)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[6]=1146; /* line # 1146 */
      Rv4=((UB *)((V *)Rv3)[1])[1];
      Rv0=PAS__NEW((SL)Rv4+2);
      ((UB *)Rv0)[0]=Rv4;
      PAS__STR_TO_STR(Rv0,((V *)Rv3)[1]);
      break;
      default:break;
    }
    Ra.sl[6]=1152; /* line # 1152 */
    P_src_macro_open(&Rv1, Rv0, F_mcp,NULL,NULL,1);
    V_sy_ch=0;
  }
  else P_src_error_s(Rd.s+1045,999,2, F_mcp,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_macro_symbol "  */
void PAS_INSMBOL_define_macro_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1049;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1170; /* line # 1170 */
  P_insymbol_src();
  while (1){
    if (V_sy_sym.ub[0]==99) {
      Ra.sl[6]=1176; /* line # 1176 */
      P_src_error_s(Rd.s+1072,991,2, V_sy_ident.s,NULL);
      P_skip_msymbol((V)Rd.s+1076,0);
    }
    else {
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=1182; /* line # 1182 */
        P_src_error(Rd.s+1072,992,2);
        P_skip_msymbol((V)Rd.s+1080,0);
      }
      else {
        Ra.sl[6]=1187; /* line # 1187 */
        Rv0=P_create_mac_ident(V_sy_ident.s,0);
        P_insymbol_src();
        if (V_sy_sym.ub[0]==23) {
          Rv1=Rv0;
          Ra.sl[6]=1192; /* line # 1192 */
          P_insymbol_src();
          PAS_INSMBOL_get_macro_value(Rv1+64);
        }
      }
    }
    Ra.sl[6]=1205; /* line # 1205 */
    if (V_sy_sym.ub[0]!=18)  break;
    P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1072,21,2);
  else P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " undefine_macro_symbol "  */
void PAS_INSMBOL_undefine_macro_mbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1084;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1221; /* line # 1221 */
  P_insymbol_src();
  while (1){
    if (V_sy_sym.ub[0]!=99) {
      Ra.sl[6]=1227; /* line # 1227 */
      P_src_error(Rd.s+1109,999,2);
      P_skip_msymbol((V)Rd.s+1116,0);
    }
    else {
      Ra.sl[6]=1232; /* line # 1232 */
      if (V_sy_macsymb==NULL) P_src_error(Rd.s+1109,999,2);
      else {
        Rv0=V_sy_macsymb;
        Ra.sl[6]=1237; /* line # 1237 */
        ((UB *)Rv0)[0]=0;
        if (((V *)Rv0)[9]!=NULL) PAS__DISPOSE(((V *)Rv0)+9);
      }
      P_insymbol_src();
    }
    Ra.sl[6]=1243; /* line # 1243 */
    if (V_sy_sym.ub[0]!=18)  break;
    P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1109,21,2);
  else P_insymbol_src();
  Ra.sl[6]=1249; /* line # 1249 */
  P_rebuild_mctree();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_assign_symbol "  */
void PAS_INSMBOL_macro_assign_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1120;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1262; /* line # 1262 */
  P_insymbol_src();
  if (V_sy_sym.ub[0]!=99) {
    Ra.sl[6]=1267; /* line # 1267 */
    P_src_error(Rd.s+1143,999,2);
    P_skip_msymbol(Rd.s+1148,0);
  }
  else {
    Ra.sl[6]=1272; /* line # 1272 */
    Rv0=V_sy_macsymb;
    P_insymbol_src();
    if (V_sy_sym.ub[0]!=23) P_src_error(Rd.s+1143,32,2);
    else P_insymbol_src();
    Rv1=Rv0;
    Ra.sl[6]=1278; /* line # 1278 */
    if (((V *)Rv1)[9]!=NULL) PAS__DISPOSE(((V *)Rv1)+9);
    PAS_INSMBOL_get_macro_value(Rv1+64);
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1143,21,2);
  else {
    Ra.sl[6]=1283; /* line # 1283 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_cop "  */
void PAS_INSMBOL_mval_cop(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1164;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1291; /* line # 1291 */
  ((UB *)F_dst)[0]=((UB *)F_src)[0];
  ((SL *)F_dst)[1]=((SL *)F_src)[1];
  if (((V *)F_src)[1]!=NULL) {
    Rv0=((UB *)((V *)F_src)[1])[1];
    ((V *)F_dst)[1]=PAS__NEW((SL)Rv0+2);
    ((UB *)((V *)F_dst)[1])[0]=Rv0;
    Ra.sl[6]=1296; /* line # 1296 */
    PAS__STR_TO_STR(((V *)F_dst)[1],((V *)F_src)[1]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_free "  */
void PAS_INSMBOL_mval_free(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1174;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1304; /* line # 1304 */
  if (((V *)F_vl)[1]!=NULL) PAS__DISPOSE(((V *)F_vl)+1);
  memcpy(F_vl,Rd.s+832,16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpush "  */
void PAS_INSMBOL_mpush(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1185;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1315; /* line # 1315 */
  if (Ri.sl[39]<32) Ri.sl[39]=Ri.sl[39]+1;
  else P_src_error(Rd.s+1194,999,3);
  PAS_INSMBOL_mval_cop(F_vl,(Rs.s+Ri.sl[39]*16-16));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpop "  */
void PAS_INSMBOL_mpop(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1198;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1327; /* line # 1327 */
  if (Ri.sl[39]>0) {
    memcpy(F_vl,(Rs.s+Ri.sl[39]*16-16),16);
    Ri.sl[39]=Ri.sl[39]-1;
  }
  else {
    Ra.sl[6]=1333; /* line # 1333 */
    P_src_error(Rd.s+1206,999,3);
    memcpy(F_vl,Rd.s+832,16);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_macro_value "  */
void PAS_INSMBOL_get_macro_value(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1210;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1352; /* line # 1352 */
  PAS_INSMBOL_m_expr_instk();
  PAS_INSMBOL_mpop(F_vl);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_intv "  */
SL PAS_INSMBOL_mexp_intv(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1227;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1365; /* line # 1365 */
  PAS_INSMBOL_mpop(Ra.s+32);
  if (Ra.ub[32]==0) Rv0=Ra.sl[9];
  else {
    if (Ra.v[5]==NULL) Rv0=0;
    else {
      Ra.sl[6]=1371; /* line # 1371 */
      Rv1=Ra.v[5];
      Rv0=0;
      Rv2=0;
      Rv3=((UB *)Rv1)[1];
      while (Rv2<Rv3&&((C *)Rv1)[Rv2+1]<=32)
      Rv2=Rv2+1;
      while (Rv2<Rv3){
        Ra.sl[6]=1377; /* line # 1377 */
        Rv4=((C *)Rv1)[Rv2+1];
        if ((Rv4<48||Rv4>57)&&Rv4>32)  break;
        if (Rv4>32) Rv0=Rv0*10+((SL)Rv4-48);
        Rv2=Rv2+1;
      }
      Ra.sl[6]=1383; /* line # 1383 */
      PAS__DISPOSE(Ra.v+5);
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexp_vl_str "  */
void PAS_INSMBOL_mexp_vl_str(V F_vl, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1238;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1393; /* line # 1393 */
  if (((UB *)F_vl)[0]==0) {
    PAS__VWRITE_INIT(F_str,1);
    PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__STR_TO_STR(F_str,((V *)F_vl)[1]);
    Ra.sl[6]=1398; /* line # 1398 */
    PAS__DISPOSE(((V *)F_vl)+1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_strv "  */
void PAS_INSMBOL_mexp_strv(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1251;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1409; /* line # 1409 */
  PAS_INSMBOL_mpop(Ra.s+32);
  PAS_INSMBOL_mexp_vl_str(Ra.s+32,F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_call "  */
void PAS_INSMBOL_mexp_call(UB F_fn, SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 824 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1262;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1426; /* line # 1426 */
  if (F_fn==0) {
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1275,22,2);
    else {
      Ra.sl[140]=1431; /* line # 1431 */
      P_insymbol_src();
    }
    if (V_sy_sym.ub[0]==99&&V_sy_macsymb!=NULL) Ra.sl[1]=1;
    else Ra.sl[1]=0;
    Ra.ub[0]=0;
    P_insymbol_src();
    Ra.sl[140]=1436; /* line # 1436 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+1275,23,2);
    PAS_INSMBOL_mpush(Ra.s);
  }
  else {
    Ra.sl[140]=1441; /* line # 1441 */
    Rv0=0;
    if (V_sy_sym.ub[0]==14) {
      V_sy_sym.ub[0]=18;
      while (V_sy_sym.ub[0]==18){
        Ra.sl[140]=1447; /* line # 1447 */
        P_insymbol_src();
        PAS_INSMBOL_m_expr_instk();
        Rv0=Rv0+1;
      }
      if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+1275,23,2);
    }
    Ra.sl[140]=1453; /* line # 1453 */
    if (F_narg>0&&Rv0!=F_narg||F_narg<0&&Rv0> -F_narg) {
      P_src_error(Rd.s+1275,999,2);
      for( Rf0=Rv0;Rf0>0;Rf0-- )
      PAS_INSMBOL_mpop(Ra.s);
      Ra.sl[140]=1458; /* line # 1458 */
      PAS_INSMBOL_mpush(Rd.s+832);
    }
    else {
      switch (F_fn) {
        case 3:Ra.sl[140]=1465; /* line # 1465 */
        PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[1]=Ra.ub[17];
        break;
        case 1:Ra.sl[140]=1471; /* line # 1471 */
        if (F_narg==3) Rv1=PAS_INSMBOL_mexp_intv();
        else Rv1=0;
        if (F_narg>1) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=1;
        if (F_narg>0) PAS_INSMBOL_mexp_strv(Ra.s+16);
        else Ra.ub[17]=0;
        Ra.ub[0]=1;
        Ra.sl[1]=0;
        Ra.sl[140]=1476; /* line # 1476 */
        PAS__STR_TO_STR(Ra.s+273,PAS__SUBSTR_STR(Ra.s+564,Ra.s+16,Rv2, Rv1));
        if (Ra.ub[274]>0) {
          Rv3=Ra.ub[274];
          Ra.v[1]=PAS__NEW((SL)Rv3+2);
          ((UB *)Ra.v[1])[0]=Rv3;
          PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
        }
        break;
        case 2:Ra.sl[140]=1486; /* line # 1486 */
        if (F_narg==3) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=0;
        if (F_narg<2) Ra.ub[274]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+273);
        if (F_narg<1) Ra.ub[17]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[1]=PAS__NINDEX_STR(Ra.s+18,(SL)Ra.ub[17],Ra.s+275,(SL)Ra.ub[274],Rv2,-1,1);
        break;
        default:Ra.sl[140]=1493; /* line # 1493 */
        P_src_error(Rd.s+1275,999,2);
        break;
      }
      PAS_INSMBOL_mpush(Ra.s);
    }
  }
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_ident "  */
void PAS_INSMBOL_mexp_ident(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1279;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1512; /* line # 1512 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[6]=1517; /* line # 1517 */
    Rv0=0;
    while (Rv0<4){
      if (P_match(V_sy_ident.s,(Rd.s+Rv0*36+1300))==0)  break;
      Rv0=Rv0+1;
    }
    Ra.sl[6]=1523; /* line # 1523 */
    if (Rv0>=4) {
      P_src_error_s(Rd.s+1293,999,3, V_sy_ident.s,NULL);
      P_skip_msymbol((V)Rd.s+1480,0);
    }
    else {
      Ra.sl[6]=1530; /* line # 1530 */
      P_insymbol_src();
      PAS_INSMBOL_mexp_call(Rv0, Rd.sl[Rv0*9+333]);
    }
    break;
    case 99:Ra.sl[6]=1536; /* line # 1536 */
    if (V_sy_macsymb!=NULL) PAS_INSMBOL_mpush(V_sy_macsymb+64);
    else {
      P_src_error(Rd.s+1293,999,2);
      Ra.sl[6]=1541; /* line # 1541 */
      PAS_INSMBOL_mpush(Rd.s+832);
    }
    break;
    case 5:Ra.sl[6]=1546; /* line # 1546 */
    Ra.ub[32]=1;
    Ra.sl[9]=0;
    if (V_sy_string.ub[1]>0) {
      Rv1=V_sy_string.ub[1];
      Ra.v[5]=PAS__NEW((SL)Rv1+2);
      ((UB *)Ra.v[5])[0]=Rv1;
      Ra.sl[6]=1551; /* line # 1551 */
      PAS__STR_TO_STR(Ra.v[5],V_sy_string.s);
    }
    PAS_INSMBOL_mpush(Ra.s+32);
    break;
    case 2:Ra.sl[6]=1558; /* line # 1558 */
    Ra.ub[32]=0;
    Ra.sl[9]=V_sy_ival;
    Ra.v[5]=NULL;
    PAS_INSMBOL_mpush(Ra.s+32);
    break;
    default:Ra.sl[6]=1565; /* line # 1565 */
    P_src_error(Rd.s+1293,999,3);
    break;
  }
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_binop "  */
void PAS_INSMBOL_mexp_binop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 840 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  SL Rv2;
  register F Rgf;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1484;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1584; /* line # 1584 */
  switch (F_ope) {
    case 6:Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()*Rv0;
    break;
    case 7:Ra.sl[140]=1592; /* line # 1592 */
    Rv0=PAS_INSMBOL_mexp_intv();
    if (Rv0!=0) Ra.sl[1]=PAS__F_ROUND((float)PAS_INSMBOL_mexp_intv()/(float)Rv0)
    ;
    else Ra.sl[1]=0;
    break;
    case 11:Ra.sl[140]=1598; /* line # 1598 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()+Rv0;
    break;
    case 12:Ra.sl[140]=1603; /* line # 1603 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()-Rv0;
    break;
    case 13:Ra.sl[140]=1608; /* line # 1608 */
    PAS_INSMBOL_mexp_strv(Ra.s+16);
    PAS_INSMBOL_mexp_strv(Ra.s+273);
    PAS__STR_TO_STR(Ra.s+273,PAS__CON_STR_STR(Ra.s+564,Ra.s+273,Ra.s+16));
    Ra.ub[0]=1;
    Ra.sl[1]=0;
    Ra.sl[140]=1613; /* line # 1613 */
    Rv1=Ra.ub[274];
    Ra.v[1]=PAS__NEW((SL)Rv1+2);
    ((UB *)Ra.v[1])[0]=Rv1;
    PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:Ra.sl[140]=1618; /* line # 1618 */
    PAS_INSMBOL_mpop(Ra.s+824);
    PAS_INSMBOL_mpop(Ra.s);
    if (Ra.ub[824]==1||Ra.ub[0]==1) {
      PAS_INSMBOL_mexp_vl_str(Ra.s+824,Ra.s+16);
      Ra.sl[140]=1623; /* line # 1623 */
      PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+273);
      Ra.ub[0]=0;
      Rv2=PAS__MATCH_STR(Ra.s+273,Ra.s+16);
      Ra.v[1]=NULL;
    }
    else {
      Ra.sl[140]=1628; /* line # 1628 */
      Rv2=Ra.sl[1]-Ra.sl[207];
    }
    switch (F_ope) {
      case 14:Ra.sl[1]=(SL)(Rv2<0);
      break;
      case 15:Ra.sl[1]=(SL)(Rv2<=0);
      break;
      case 16:Ra.sl[1]=(SL)(Rv2>=0);
      break;
      case 17:Ra.sl[140]=1633; /* line # 1633 */
      Ra.sl[1]=(SL)(Rv2>0);
      break;
      case 18:Ra.sl[1]=(SL)(Rv2!=0);
      break;
      case 19:Ra.sl[1]=(SL)(Rv2==0);
      break;
    }
    break;
    case 20:Ra.sl[140]=1640; /* line # 1640 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[1]=(SL)(Rv0>0&&Rv2>0);
    break;
    case 21:Ra.sl[140]=1646; /* line # 1646 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[1]=(SL)(Rv0>0||Rv2>0);
    break;
    case 22:Ra.sl[140]=1652; /* line # 1652 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[1]=(SL)(Rv0>0&&Rv2<=0||Rv0<=0&&Rv2>0);
    break;
    default:Ra.sl[140]=1659; /* line # 1659 */
    P_src_error(Rd.s+1498,999,3);
    break;
  }
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_unaop "  */
void PAS_INSMBOL_mexp_unaop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+1502;
  Ra.v[4]=Rd.s+16;
  Ra.sl[10]=1675; /* line # 1675 */
  switch (F_ope) {
    case 0:Ra.sl[1]=(SL)(PAS_INSMBOL_mexp_intv()<=0);
    break;
    default:P_src_error(Rd.s+1516,999,3);
    break;
  }
  Ra.sl[10]=1681; /* line # 1681 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[2];
}


/* Procedure/Function : " mexp_una "  */
void PAS_INSMBOL_PRC_00000013(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1520;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1724; /* line # 1724 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) V_sy_sym.ub[0]
  =6;
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=1730; /* line # 1730 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else Rv0=29;
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000013();
    if (Rv0!=29) PAS_INSMBOL_mexp_unaop(Rv0);
  }
  else {
    Ra.sl[6]=1737; /* line # 1737 */
    if (V_sy_sym.ub[0]==14) {
      P_insymbol_src();
      PAS_INSMBOL_m_expr_instk();
      if (V_sy_sym.ub[0]==15) P_insymbol();
      else {
        Ra.sl[6]=1742; /* line # 1742 */
        P_src_error(Rd.s+1532,23,3);
      }
    }
    else PAS_INSMBOL_mexp_ident();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_mul "  */
void PAS_INSMBOL_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1536;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1749; /* line # 1749 */
  PAS_INSMBOL_PRC_00000013();
  while (V_sy_sym.ub[0]==10){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1754; /* line # 1754 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000013();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_add "  */
void PAS_INSMBOL_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1546;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1761; /* line # 1761 */
  PAS_INSMBOL_PRC_00000012();
  while (V_sy_sym.ub[0]==9){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1766; /* line # 1766 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000012();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_rel "  */
void PAS_INSMBOL_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1556;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1773; /* line # 1773 */
  PAS_INSMBOL_PRC_00000011();
  while (V_sy_sym.ub[0]==10){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1778; /* line # 1778 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000011();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_not "  */
void PAS_INSMBOL_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1566;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1785; /* line # 1785 */
  PAS_INSMBOL_PRC_00000010();
  if (V_sy_sym.ub[0]==11) {
    Lx[2].ub[0]=V_sy_sym.ub[1];
    Ra.sl[6]=1790; /* line # 1790 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000010();
    PAS_INSMBOL_mexp_unaop(Lx[2].ub[0]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_and "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1576;
  Ra.v[3]=Rd.s+16;
  Ra.sl[8]=1797; /* line # 1797 */
  PAS_INSMBOL_PRC_00000009();
  while (V_sy_sym.ub[0]==12){
    Ra.ub[0]=V_sy_sym.ub[1];
    Ra.sl[8]=1802; /* line # 1802 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000009();
    PAS_INSMBOL_mexp_binop(Ra.ub[0]);
  }
  PAS__curr_cntx=Ra.v[1];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " m_expr_instk "  */
void PAS_INSMBOL_m_expr_instk(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1586;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1809; /* line # 1809 */
  PAS_INSMBOL_PRC_00000008();
  while (V_sy_sym.ub[0]==13){
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1814; /* line # 1814 */
    P_insymbol_src();
    PAS_INSMBOL_PRC_00000008();
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_sval "  */
void PAS_INSMBOL_mexpr_sval(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1600;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1824; /* line # 1824 */
  PAS_INSMBOL_m_expr_instk();
  PAS_INSMBOL_mexp_strv(F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_ival "  */
SL PAS_INSMBOL_mexpr_ival(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1612;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1832; /* line # 1832 */
  PAS_INSMBOL_m_expr_instk();
  Ret=PAS_INSMBOL_mexp_intv();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexpr_bval "  */
UB PAS_INSMBOL_mexpr_bval(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1624;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1840; /* line # 1840 */
  PAS_INSMBOL_m_expr_instk();
  Ret=PAS_INSMBOL_mexp_intv()>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " if_mstate "  */
UB PAS_INSMBOL_if_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1636;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1856; /* line # 1856 */
  Rv0=V_sy_sym.ub[0];
  P_insymbol_src();
  switch (Rv0) {
    case 94:
    case 95:Ra.sl[6]=1864; /* line # 1864 */
    Rv1=V_sy_macsymb!=NULL^Rv0==95;
    P_insymbol_src();
    break;
    case 93:Ra.sl[6]=1869; /* line # 1869 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    break;
    default:break;
  }
  if (V_sy_sym.ub[0]!=96) P_src_error(Rd.s+1649,902,2);
  Ra.sl[6]=1874; /* line # 1874 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_pragma_mstate(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1080 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+832,16);
  Ra.ub[16]=255;
  PAS__STR_TO_STR(Ra.s+16,Rd.s+1653);
  Ra.ub[273]=255;
  PAS__STR_TO_STR(Ra.s+273,Rd.s+1653);
  Ra.ub[530]=255;
  PAS__STR_TO_STR(Ra.s+530,Rd.s+1653);
  Ra.ub[787]=255;
  PAS__STR_TO_STR(Ra.s+787,Rd.s+1653);
  Ra.v[131]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1048;
  Ra.v[132]=Rd.s+1910;
  Ra.v[133]=Rd.s+16;
  Ra.sl[268]=1950; /* line # 1950 */
  P_insymbol_src();
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=F_p_src;
  Ra.sl[268]=1955; /* line # 1955 */
  Rv2=((UL *)Rv1)[62];
  while (V_sy_sym.ub[0]==0){
    Rv3=0;
    Rv4=0;
    while (1){
      Ra.sl[268]=1961; /* line # 1961 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      if (Rv3||Rv4==23)  break;
      Rv4=Rv4+1;
    }
    P_insymbol_src();
    Ra.sl[268]=1966; /* line # 1966 */
    switch (Rv4) {
      case 0:PAS_INSMBOL_get_macro_value(Ra.s);
      if (Ra.ub[0]==1) {
        Ra.sl[268]=1972; /* line # 1972 */
        PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+16);
        if (Ra.ub[17]>0) {
          Rv5=V_lst_current;
          Ra.sl[268]=1977; /* line # 1977 */
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+273,((V *)Rv5)[2]);
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+530,((V *)Rv5)[4]);
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+787,((V *)Rv5)[5]);
          Ra.sl[268]=1983; /* line # 1983 */
          P_lst_open(&V_lst_current, Ra.s+16,Ra.s+273,Ra.s+530,Ra.s+787,132,-1,0,0,0,
          &Rv6);
          Ra.sl[268]=1995; /* line # 1995 */
          if (Rv6!=0) {
            if (!V_sy_init_mod) P_src_error(Rd.s+1927,905,2);
            else {
              Ra.sl[268]=2000; /* line # 2000 */
              Rv2=Rv2&~1;
            }
          }
          else {
            if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[268]=2008; /* line # 2008 */
          Rv2=Rv2&~1;
        }
      }
      else {
        if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
        Ra.sl[268]=2013; /* line # 2013 */
        Rv2=Rv2|1;
      }
      break;
      case 1:Rv2=Rv2&~1;
      break;
      case 2:Ra.sl[268]=2019; /* line # 2019 */
      Rv2=Rv2|2;
      break;
      case 3:Rv2=Rv2&~2;
      break;
      case 4:Rv2=Rv2|32;
      break;
      case 5:Rv2=Rv2&~32;
      break;
      case 6:Ra.sl[268]=2027; /* line # 2027 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[8]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2033; /* line # 2033 */
        ((SL *)Rv1)[8]=1;
      }
      break;
      case 7:Ra.sl[268]=2038; /* line # 2038 */
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[11]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2044; /* line # 2044 */
        ((SL *)Rv1)[11]=1;
      }
      if (V_sy_sym.ub[0]==22) P_insymbol_src();
      if (V_sy_sym.ub[0]==2) {
        ((SL *)Rv1)[12]=V_sy_ival;
        P_insymbol_src();
      }
      else((SL *)Rv1)[12]=255;
      break;
      case 8:Ra.sl[268]=2051; /* line # 2051 */
      V_cmp_macf=1;
      break;
      case 9:V_cmp_macf=0;
      break;
      case 10:V_cmp_cobj=1;
      break;
      case 11:V_cmp_cobj=0;
      break;
      case 12:Ra.sl[268]=2058; /* line # 2058 */
      if (V_sy_sym.ub[0]==5) {
        if (V_sy_ident.ub[0]>0) {
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[268]=2063; /* line # 2063 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else P_src_error(Rd.s+1927,904,4);
      }
      else {
        Ra.sl[268]=2069; /* line # 2069 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 13:if (V_cmp_objf) {
        Ra.sl[268]=2075; /* line # 2075 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 14:V_cmp_bltt=1;
      break;
      case 15:V_cmp_bltt=0;
      break;
      case 16:Ra.sl[268]=2082; /* line # 2082 */
      if (V_sy_sym.ub[0]==2) {
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[268]=2087; /* line # 2087 */
        P_insymbol_src();
      }
      else P_src_error(Rd.s+1927,906,3);
      break;
      case 17:V_cmp_debugopt=1;
      break;
      case 18:Ra.sl[268]=2092; /* line # 2092 */
      V_cmp_debugopt=0;
      break;
      case 19:V_cmp_range=1;
      break;
      case 20:V_cmp_range=0;
      break;
      case 21:Ra.sl[268]=2097; /* line # 2097 */
      P_generation_pragma();
      break;
      case 22:V_cmp_cmpdbg=1;
      break;
      case 23:V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[268]=2103; /* line # 2103 */
      P_src_error_s(Rd.s+1927,901,1, V_sy_ident.s,NULL);
      break;
    }
    if (V_sy_sym.ub[0]==18) P_insymbol_src();
  }
  if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1927,21,2);
  else {
    Ra.sl[268]=2108; /* line # 2108 */
    P_insymbol_src();
  }
  ((UL *)Rv1)[62]=Rv2;
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[131];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_include_mstate(UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+1931;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=2128; /* line # 2128 */
  Rv0=V_sy_sym.ub[0]==100;
  P_insymbol_src();
  PAS_INSMBOL_mexpr_sval(Ra.s);
  Ra.sl[72]=2133; /* line # 2133 */
  Rv1=NULL;
  Rv2=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  if (Rv2==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+292,Ra.s,Rd.s+1947));
  P_src_open(&Rv1, Ra.s,0, &Rv3);
  Ra.sl[72]=2138; /* line # 2138 */
  if (Rv3==0) {
    Rv4=Rv1;
    ((V *)Rv4)[1]=V_src_control;
    Ra.sl[72]=2143; /* line # 2143 */
    ((SL *)Rv4)[7]=((SL *)V_src_control)[7];
    if (Rv0) ((SL *)Rv4)[7]=((SL *)Rv4)[7]+1;
    ((SL *)Rv4)[8]=((SL *)V_src_control)[8];
    ((SL *)Rv4)[6]=((SL *)V_src_control)[6];
    ((SL *)Rv4)[11]=((SL *)V_src_control)[11];
    Ra.sl[72]=2148; /* line # 2148 */
    ((SL *)Rv4)[12]=((SL *)V_src_control)[12];
    ((UL *)Rv4)[62]=((UL *)Rv4)[62]|((UL *)V_src_control)[62]&103;
    Ra.sl[72]=2153; /* line # 2153 */
    if (V_sy_sym.ub[0]==18) {
      P_insymbol_src();
      PAS_INSMBOL_pragma_mstate(Rv1);
    }
    else {
      Ra.sl[72]=2159; /* line # 2159 */
      if (V_sy_sym.ub[0]!=19) P_src_error(Rd.s+1955,21,2);
    }
    if (!Rv0) P_src_end_of_line();
    V_src_control=Rv1;
    if (V_cmp_trace>0) V_cmp_tracecount=0;
    P_compile_set_title();
    Ra.sl[72]=2164; /* line # 2164 */
    P_set_srcfilespc((SL)Rv0);
    V_sy_ch=32;
    V_sy_sym.ub[0]=101;
    if (!Rv0) {
      Ra.sl[72]=2169; /* line # 2169 */
      Rv5=V_src_control;
      Rv1=((V *)Rv5)[1];
      ((V *)Rv5)[1]=((V *)Rv1)[1];
      Ra.sl[72]=2174; /* line # 2174 */
      P_src_close(&Rv1,1);
    }
  }
  else {
    P_lst_newline();
    Ra.sl[72]=2179; /* line # 2179 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1959,-1,-1,32);
    PAS__WRITE_INT(Rv3,3,0);
    PAS__WRITE_EOLN();
    P_lst_newline();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1981,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2005,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__GET_RTL_MSG(Rv3, Ra.s);
    P_lst_newline();
    Ra.sl[72]=2184; /* line # 2184 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2009,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    while ((V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=89)&&V_sy_sym.ub[0]!=103)
    P_insymbol_src();
    if (F_bnsferr) {
      Ra.sl[72]=2189; /* line # 2189 */
      P_src_error(Rd.s+1955,902,4);
    }
    else P_src_error(Rd.s+1955,902,3);
  }
  Ra.sl[72]=2194; /* line # 2194 */
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_endfile_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2026;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2205; /* line # 2205 */
  Rv0=V_src_control;
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=89;
  else {
    Ra.sl[6]=2210; /* line # 2210 */
    V_sy_ch=P_src_return(1);
    V_sy_sym.ub[0]=104;
    V_sy_ch=32;
    P_set_srcfilespc(-1);
    P_compile_set_title();
  }
  Ra.sl[6]=2217; /* line # 2217 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  if (V_sy_sym.ub[0]==89) V_pas_compile=0;
  else P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2042;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2250; /* line # 2250 */
  P_insymbol_src();
  Rv0=V_src_control;
  while (V_sy_sym.ub[0]>=90){
    switch (V_sy_sym.ub[0]) {
      case 100:
      case 101:Ra.sl[6]=2256; /* line # 2256 */
      PAS_INSMBOL_include_mstate(V_sy_init_mod);
      break;
      case 102:PAS_INSMBOL_pragma_mstate(V_src_control);
      break;
      case 90:Ra.sl[6]=2262; /* line # 2262 */
      PAS_INSMBOL_define_macro_symbol();
      break;
      case 91:PAS_INSMBOL_undefine_macro_mbol();
      break;
      case 92:Ra.sl[6]=2268; /* line # 2268 */
      PAS_INSMBOL_macro_assign_symbol();
      break;
      case 93:
      case 94:
      case 95:if (PAS_INSMBOL_if_mstate()) {
        Ra.sl[6]=2273; /* line # 2273 */
        P_insymbol_src();
        V_sy_maclevel=V_sy_maclevel+1;
      }
      else {
        Ra.sl[6]=2278; /* line # 2278 */
        Rv1=((C *)Rv0)[54];
        ((C *)Rv0)[54]=83;
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2060);
        ((C *)Rv0)[54]=Rv1;
        if (V_sy_sym.ub[0]==97) {
          Ra.sl[6]=2283; /* line # 2283 */
          P_insymbol_src();
          V_sy_maclevel=V_sy_maclevel+1;
        }
        else P_insymbol_src();
      }
      break;
      case 97:Ra.sl[6]=2291; /* line # 2291 */
      V_sy_maclevel=V_sy_maclevel-1;
      Rv1=((C *)Rv0)[54];
      ((C *)Rv0)[54]=83;
      PAS_INSMBOL_skip_mcsymbol(Rd.s+2076);
      P_insymbol_src();
      ((C *)Rv0)[54]=Rv1;
      break;
      case 98:Ra.sl[6]=2300; /* line # 2300 */
      V_sy_maclevel=V_sy_maclevel-1;
      P_insymbol_src();
      break;
      case 99:Ra.sl[6]=2305; /* line # 2305 */
      if (V_sy_macsymb!=NULL) {
        P_macro_replace(V_sy_macsymb);
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2311; /* line # 2311 */
        P_src_error_s(Rd.s+2054,995,3, V_sy_ident.s,NULL);
      }
      break;
      case 103:PAS_INSMBOL_endfile_mstate();
      break;
      default:Ra.sl[6]=2320; /* line # 2320 */
      P_src_error(Rd.s+2054,997,3);
      break;
    }
    if (V_sy_maclevel<0) {
      P_src_error(Rd.s+2054,996,2);
      Ra.sl[6]=2325; /* line # 2325 */
      V_sy_maclevel=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2092;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2335; /* line # 2335 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=89){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 57:Ra.sl[6]=2341; /* line # 2341 */
      if (!F_rec_flg) {
        P_skip_symbol(73,0,0);
        P_insymbol();
      }
      break;
      case 42:Ra.sl[6]=2347; /* line # 2347 */
      P_skip_symbol(73,1,0);
      P_insymbol();
      break;
      case 55:
      case 72:P_skip_symbol(73,0,0);
      P_insymbol();
      break;
      case 14:Ra.sl[6]=2355; /* line # 2355 */
      P_skip_symbol(15,0,0);
      P_insymbol();
      break;
      case 16:P_skip_symbol(17,0,0);
      P_insymbol();
      break;
      case 49:Ra.sl[6]=2363; /* line # 2363 */
      P_skip_symbol(50,0,0);
      P_insymbol();
      break;
      case 73:if (F_tosymbol==47||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_msymbol "  */
void P_skip_msymbol(V F_smb, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2105;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2376; /* line # 2376 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,105)||V_sy_sym.ub[0]==89)){
    P_insymbol();
    switch (V_sy_sym.ub[0]) {
      case 57:Ra.sl[6]=2382; /* line # 2382 */
      if (!F_rec_flg) {
        P_skip_msymbol(Rd.s+2120,0);
        P_insymbol();
      }
      break;
      case 42:Ra.sl[6]=2389; /* line # 2389 */
      P_skip_msymbol(Rd.s+2132,1);
      P_insymbol();
      break;
      case 55:
      case 72:Ra.sl[6]=2394; /* line # 2394 */
      P_skip_msymbol(Rd.s+2144,0);
      P_insymbol();
      break;
      case 14:Ra.sl[6]=2399; /* line # 2399 */
      P_skip_msymbol((V)Rd.s+2156,0);
      P_insymbol();
      break;
      case 16:Ra.sl[6]=2404; /* line # 2404 */
      P_skip_msymbol((V)Rd.s+2160,0);
      P_insymbol();
      break;
      case 49:Ra.sl[6]=2409; /* line # 2409 */
      P_skip_msymbol(Rd.s+2164,0);
      P_insymbol();
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2172;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2425; /* line # 2425 */
  P_lst_g_init(Rd.s+2183,Rd.s+2185,&Rv0);
  if (Rv0==0) {
    Ra.sl[6]=2430; /* line # 2430 */
    P_err_init(PAS__CON_STR_STR(Ra.s+28,V_cpas_ini_dir.s,Rd.s+2240));
    P_src_init(Rd.s+2254,V_trg_env_fspc.s);
    if (V_cmp_macroexp) {
      Ra.sl[6]=2435; /* line # 2435 */
      P_src_set_flags(2,0);
    }
    if (V_src_control==NULL) {
      V_error_result=4;
      V_emergency_stop=1;
      Ra.sl[6]=2440; /* line # 2440 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2261,-1,-1,32);
      PAS__WRITE_STR(V_trg_env_fspc.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+2311,-1,-1,32);
      PAS__WRITE_EOLN();
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2328,-1,-1,32);
      PAS__WRITE_STR(V_trg_sys_name.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=2449; /* line # 2449 */
      PAS_INSMBOL_set_keyword_tree();
      V_proc_seq=0;
      V_srf_free=NULL;
      V_srf_list=NULL;
      Ra.sl[6]=2454; /* line # 2454 */
      V_sy_maclevel=0;
      P_ide_init();
      Ra.sl[6]=2461; /* line # 2461 */
      P_set_srcfilespc(1);
      V_sy_attrflg=0;
      V_sy_ch=32;
      Ra.sl[6]=2468; /* line # 2468 */
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[6]=2473; /* line # 2473 */
    V_error_result=4;
    V_emergency_stop=1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2384,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2183,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2408,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
