/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 3488 ) = {
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  61,  61,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  51,  47, 112,
 99, 109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115, 101,
116,  95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,   9,
  9, 115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,
 97, 114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,  97,
114, 101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,  99,
111, 109, 112,  95, 115,  99,  97, 108,  97, 114,   9,   9,  99, 111, 109, 112,
 95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112, 114, 111,  99,
 95,  97, 114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,
 99, 116, 101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,  49,  21,  21,
116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,  95, 114, 101,
108, 101,  97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,  95, 105, 110,
 95,  97, 114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110, 103,  95, 105,
110,  95, 115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16, 105, 110, 105,
116, 105,  97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,  15,  15, 116,
121, 112, 101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114, 109,   4,   4,
 84,  89,  67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,  95, 115, 101,
116,  95, 118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,  95, 112,  97,
114, 109,  95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,  12, 105, 110,
105, 116,  95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100, 121, 110,  95,
114, 101,  99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,  95, 100, 121,
110,  95, 114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100, 121, 110,  95,
100,   4,   4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,  95, 100,  95,
100, 121, 110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110, 105, 116,  95,
100,  95, 116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10, 105, 110, 105,
116,  95, 100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,  13,  13, 105,
110, 105, 116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,   4,  73,  68,
 83,  84,  12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97, 114,  98, 108,
 11,  11, 101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,   4,   4,  69,
 67,  85,  78,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,  98, 105, 110,
  4,   4,  69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95, 102, 111, 114,
 95, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,  99,  97, 108,
108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,  76,  76,   3,
  3, 119, 114, 116,  33,   0,   0,   0,  17,   0,   9, 102, 111, 114, 109,  95,
 99, 104,  97, 114,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114,
109,  95, 108, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102,
111, 114, 109,  95, 105, 110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 11, 102, 111, 114, 109,  95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,
  0,   0,  11, 102, 111, 114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,
  0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101,
114,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 102, 101, 110, 116,
114, 121,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 105,
108, 101,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
 97, 114, 114,  97, 121,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95,  99, 111, 110, 102,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102,
111, 114, 109,  95, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   0,
  8, 102, 111, 114, 109,  95, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 108, 115, 101, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,
  0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110,
110, 117, 109,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
119, 102, 105, 108, 101,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102,
111, 114, 109,  95, 119, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
 10, 102, 111, 114, 109,  95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,
  0,   0,  12, 102, 111, 114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103,
101,   0,   0,   0,   0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97,
114, 105,  97, 110, 116,   0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95,
111, 114, 103,  97, 110, 105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114,
109,  95,  99, 111, 110, 115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102,
111, 114, 109,  95, 112, 114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,
 12, 102, 111, 114, 109,  95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 117, 118,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 101,
  0,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 110, 117,
108, 108,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95,
115, 116, 114, 105, 110, 103,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 102, 114, 101, 101,   0,   0,   0,   0,   0,   0,   0,   0,   8,   8,
 32,  45,  45,  45,  45,  45,  45,  32,  10,  10, 115, 104, 111, 119,  95, 101,
110, 116, 114, 121,  16,  16,  32,  79, 107,  32, 102, 111, 114,  32,  69, 110,
116, 114, 121,  32,  58,  32,  10,  10,  32,  32,  32,  32,  69, 110, 116, 114,
121,  32,   2,   2,  44,  32,   4,   4,  32,  45,  62,  32,  11,  11,  32,  45,
 62,  32,  99, 111, 100, 101,  32,  61,  32,   0,   0,   0, 127,   0,   0,   0,
 15,   0,   9, 112,  99, 111, 100,  95, 110, 111, 111, 112,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 116, 111, 114, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 114,  97, 110, 103, 101,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 105, 115, 116, 111, 114, 101,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 102, 115, 116, 111, 114, 101,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103, 115, 116, 111, 114, 101,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 110, 111, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  97, 110, 100,   0,   0,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 111, 114,   0,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 120, 111, 114,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 109,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  98,  97, 110, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  98, 120, 111, 114,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 115,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 116,   0,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 115, 101, 116, 103, 101, 110,   0,   0,
  0,   0,  12, 112,  99, 111, 100,  95, 108, 115, 101, 116, 103, 101, 110,   0,
  0,   0,  14, 112,  99, 111, 100,  95, 108, 115, 101, 116,  97, 100, 100, 101,
108,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108, 116,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103, 116,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 101, 113,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 110, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 105, 110, 115, 101, 116,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 101, 113,   0,   0,   0,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 110, 101,   0,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  95, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  95, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 110,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 100, 101,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  97, 115, 104,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 108, 115, 104,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 114, 111, 116,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 117,  99,  99,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 112, 114, 101, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 111, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 111, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 114, 101, 109,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 102,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 105,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 102, 116, 114, 117, 110,  99,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 105,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103, 116, 114, 117, 110,  99,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 102,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 105, 112, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 113, 114, 116,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 115, 105, 110,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 115,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 116,  97, 110,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97, 115, 105, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97,  99, 111, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97, 116,  97, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 112, 104,  97, 115,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 101, 120, 112,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 108, 111, 103,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 105, 110, 104,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 111, 115, 104,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 116,  97, 110, 104,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97, 115, 105, 110, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97,  99, 111, 115, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97, 116,  97, 110, 104,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 105, 112, 119,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 113, 114, 116,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 105, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  99, 111, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 116,  97, 110,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 115, 105, 110,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97,  99, 111, 115,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 116,  97, 110,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 112, 104,  97, 115,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 101, 120, 112,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 108, 111, 103,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 105, 110, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  99, 111, 115, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 116,  97, 110, 104,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 115, 105, 110, 104,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97,  99, 111, 115, 104,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 116,  97, 110, 104,   0,   0,
  0,   0,  14, 112,  99, 111, 100,  95,  95, 103, 101, 110, 115, 116, 114, 108,
 49,   0,  15, 112,  99, 111, 100,  95,  95, 103, 101, 110, 112, 114, 109, 116,
121, 112,   4,   4, 100, 117, 109, 112,  25,  25,  32,  71, 101, 110, 101, 114,
105,  99,  95,  83, 101,  97, 114,  99, 104,  32, 102, 111, 114,  32, 110, 112,
 32,  61,  32,   6,   6,  32, 119, 105, 116, 104,  32,  13,  13,  65, 114, 103,
 95,  49,  32, 102,  95, 116, 121, 112, 101,  32,  15,  15,  44,  32,  65, 114,
103,  95,  50,  32, 102,  95, 116, 121, 112, 101,  32,   7,   7,  78, 111,  32,
 97, 114, 103,  46,  14,  14, 103, 101, 110, 101, 114, 105,  99,  95, 115, 101,
 97, 114,  99, 104,   4,   4,  71,  69,  78,  83,  11,  11, 101, 120, 112,  95,
103, 101, 110, 111, 112, 101, 114,  13,  13, 103, 101, 110, 101, 114,  97, 116,
101,  95,  99,  97, 108, 108,   9,   9, 101, 120, 112,  95, 103, 101, 110, 111,
112,  13,  13, 108, 103, 116,  95, 103, 101, 110,  95, 115, 116, 111, 114, 101
};

/* Define the local static Initialized section. */
static Blk( Ri, 488 ) = {
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   5,   5,
  0,   0,   0,   0,   0,   5,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   5,   0,   0,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   2,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,
  0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   5,
  0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   0,   3,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,
  0,   0,   0,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   5,   5,   0,   5,   0,   0,
  0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   0,   0,   0,   0,   0,   5,
  0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   5,   0,   0,   0,   0,   0,   5,   0,   5,   0,   5,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   5,   5,
  0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   0,
  0,   0,   0,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
  5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
  5,   5,   5,   5,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 272 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern V PAS__f_output;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000001(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=95; /* line # 95 */
  if (V_sy_sym.ub[0]==5) {
    (*F_nam)=PAS__NEW(32);
    Rv0=(*F_nam);
    Ra.sl[6]=100; /* line # 100 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else((UB *)Rv0)[0]=V_sy_string.ub[1];
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=105; /* line # 105 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=120; /* line # 120 */
  Rv0=F_pr;
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+91,129,1);
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=126; /* line # 126 */
    ((V *)Rv0)[3]=NULL;
    P_src_error(Rd.s+91,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=141; /* line # 141 */
  V_enm_range=0;
  Rv0=F_ty1==F_ty2;
  if (!Rv0) {
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=146; /* line # 146 */
      if (((((UB *)F_ty1)[92]==((UB *)F_ty2)[92]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) switch ((
      (UB *)F_ty1)[92]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=152; /* line # 152 */
        if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)F_ty2)
        [29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) Rv0=1;
        break;
        case 3:
        case 4:Rv0=1;
        break;
        case 5:
        case 7:
        case 13:Ra.sl[6]=157; /* line # 157 */
        Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
        break;
        case 11:
        case 12:if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) Rv0=P_same_type(((V *)
        F_ty1)[13],((V *)F_ty2)[13]);
        break;
        case 8:
        case 9:Ra.sl[6]=162; /* line # 162 */
        if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
        [25]) {
          if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
          F_ty1)[14],((V *)F_ty2)[14])) Rv0=1;
        }
        break;
        case 22:Ra.sl[6]=168; /* line # 168 */
        Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
        break;
        case 6:Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=173; /* line # 173 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+106;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=186; /* line # 186 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Rv0=0;
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=192; /* line # 192 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else Rv0=1;
      if (Rv0) {
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=200; /* line # 200 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Rv0=P_same_type(((V *)Rv1)[4],((V *)Rv2)[4]);
          if (Rv0) {
            Ra.sl[6]=206; /* line # 206 */
            if (((UB *)Rv1)[56]==7) {
              if (((UB *)Rv2)[56]==7) {
                if (((UB *)((V *)Rv1)[9])[104]==3&&((UB *)((V *)Rv2)[9])[104]==3)
                 Rv0=P_compare_entry(((V *)Rv1)[9],((V *)Rv2)[9]);
                else Rv0=0;
              }
              else {
                Ra.sl[6]=211; /* line # 211 */
                Rv0=0;
              }
            }
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=219; /* line # 219 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=233; /* line # 233 */
  Rv0=0;
  if (F_pgc!=NULL&&F_ent!=NULL) while (F_pgc!=NULL&&!Rv0){
    Ra.sl[6]=238; /* line # 238 */
    Rv1=F_pgc;
    if (!((UB *)Rv1)[8]) {
      Rv2=((V *)Rv1)[2];
      Ra.sl[6]=243; /* line # 243 */
      Rv0=P_compare_entry(Rv2, F_ent);
    }
    if (!Rv0) {
      if (F_pgc==F_pgl) F_pgc=NULL;
      else F_pgc=((V *)F_pgc)[0];
    }
  }
  Ra.sl[6]=250; /* line # 250 */
  if (!Rv0) F_pgc=NULL;
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+141;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=270; /* line # 270 */
  Rv0=4;
  if (F_te==F_tf) Rv0=0;
  else {
    if (F_te!=NULL&&F_tf!=NULL) {
      Rv1=F_te;
      if (((UB *)Rv1)[92]==((UB *)F_tf)[92]) {
        Ra.sl[6]=275; /* line # 275 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          if (((UB *)Rv1)[112]) {
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=281; /* line # 281 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Rv4=F_tf;
          if (((UB *)Rv4)[112]) {
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=286; /* line # 286 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=292; /* line # 292 */
            if (Rv2==Rv5) {
              if (Rv3==Rv6) Rv0=0;
              else Rv0=1;
            }
            else Rv0=2;
          }
          else Rv0=3;
        }
        else {
          Ra.sl[6]=298; /* line # 298 */
          V_enm_range=1;
        }
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  UB Rv4;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+154;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=345; /* line # 345 */
  V_enm_range=0;
  Rv0=F_eff==F_frm;
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=350; /* line # 350 */
    if (!Rv0) {
      Rv1=((V *)F_eff)[0];
      while (1){
        Ra.sl[6]=356; /* line # 356 */
        if (Rv1!=NULL) {
          Rv2=Rv1;
          Rv0=F_frm==Rv1;
          Rv1=((V *)Rv2)[0];
        }
        if (Rv0||Rv1==NULL)  break;
      }
      Ra.sl[6]=364; /* line # 364 */
      if (!Rv0) {
        Rv3=F_frm;
        if (((UB *)Rv3)[92]==22) {
          Ra.sl[6]=369; /* line # 369 */
          Rv0=P_comp_type(((V *)Rv3)[0],F_eff, F_exact);
        }
        if (!Rv0) {
          if (((UB *)F_eff)[92]<=21&&((UB *)Rv3)[92]<=21) {
            Ra.sl[6]=375; /* line # 375 */
            Rv4=Ri.ub[((UB *)F_eff)[92]*22+((UB *)Rv3)[92]];
            Ra.sl[6]=382; /* line # 382 */
            if (!((F_exact&&Rv4==5)&&((UB *)F_eff)[92]!=((UB *)Rv3)[92])) switch (
            Rv4) {
              case 5:Rv0=1;
              break;
              case 1:
              case 2:Ra.sl[6]=387; /* line # 387 */
              switch (((UB *)Rv3)[92]) {
                case 0:
                case 1:
                case 2:if (((UB *)Rv3)[88]) {
                  Ra.sl[6]=392; /* line # 392 */
                  if (!F_exact) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
                  else Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv3)
                  [11]==((SL *)F_eff)[11];
                }
                break;
                case 11:
                case 12:Ra.sl[6]=397; /* line # 397 */
                Rv0=P_comp_type(((V *)F_eff)[13],((V *)Rv3)[13],F_exact);
                break;
                case 8:Rv0=((V *)F_eff)[14]==((V *)Rv3)[14]&&P_comp_type(((V *)F_eff)
                [15],((V *)Rv3)[15],1);
                break;
                case 9:Ra.sl[6]=404; /* line # 404 */
                Rv0=P_comp_type(((V *)F_eff)[14],((V *)Rv3)[14],1)&&P_comp_type((
                (V *)F_eff)[15],((V *)((V *)Rv3)[15])[0],1);
                break;
                case 5:if (((V *)Rv3)[12]==NULL) Rv0=((UB *)F_eff)[92]==5;
                else {
                  Ra.sl[6]=409; /* line # 409 */
                  Rv0=P_comp_type(((V *)F_eff)[12],((V *)Rv3)[12],1);
                }
                break;
                case 6:if (((V *)Rv3)[13]==NULL) Rv0=((UB *)F_eff)[92]==6;
                else Rv0=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv3)[13]);
                break;
                default:break;
              }
              break;
              case 4:Ra.sl[6]=419; /* line # 419 */
              Rv0=P_comp_type(F_frm, V_typ_std.v[10],0);
              break;
              case 3:if (P_comp_type(F_eff, V_typ_std.v[10],0)) {
                Ra.sl[6]=424; /* line # 424 */
                Rv0=P_comp_type(((V *)((V *)F_eff)[13])[4],F_frm,0);
              }
              break;
              default:break;
            }
          }
        }
      }
    }
  }
  Ra.sl[6]=433; /* line # 433 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+165;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=447; /* line # 447 */
  Rv0=1;
  if (F_epr!=F_fpr) {
    if (F_epr!=NULL&&F_fpr!=NULL) {
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=452; /* line # 452 */
        Rv0=0;
      }
      else {
        Rv1=((V *)F_epr)[8];
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=457; /* line # 457 */
        if (((V *)F_epr)[11]!=NULL) {
          if (!((UB *)((V *)F_epr)[11])[91]) {
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
        }
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          Ra.sl[6]=462; /* line # 462 */
          if (((UB *)Rv2)[56]!=((UB *)Rv1)[56]) Rv0=0;
          else switch (((UB *)Rv2)[56]) {
            case 5:Rv0=P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1);
            break;
            case 7:Ra.sl[6]=469; /* line # 469 */
            if (P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1)) Rv0=P_comp_proc_arg((
            (V *)Rv1)[9],((V *)Rv2)[9]);
            else Rv0=0;
            break;
            default:break;
          }
          Ra.sl[6]=475; /* line # 475 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
      }
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=481; /* line # 481 */
      Rv0=0;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+180;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=500; /* line # 500 */
  if (F_ty!=NULL) {
    Rv0=F_ty;
    Rv1=((V *)Rv0)[4];
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=505; /* line # 505 */
    while (Rv1!=NULL){
      Rv3=Rv1;
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Rv5=Rv4;
      Ra.sl[6]=511; /* line # 511 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+202,132,3);
      else {
        Rv6=((V *)Rv5)[7];
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[4])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[4];
      }
      Ra.sl[6]=516; /* line # 516 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[15];
      ((V *)Rv3)[10]=Rv4;
      ((UB *)Rv3)[64]=1;
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=521; /* line # 521 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      (*F_lghl)=Rv4;
      (*F_count)=(*F_count)+1;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+206;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=540; /* line # 540 */
  Rv0=((V *)F_ty)[4];
  while (Rv0!=NULL){
    Rv1=Rv0;
    ((UB *)Rv1)[64]=0;
    Ra.sl[6]=545; /* line # 545 */
    ((V *)Rv1)[10]=NULL;
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+229;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=563; /* line # 563 */
  if (((V *)F_lgt)[7]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=NULL;
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=568; /* line # 568 */
    Rv4=NULL;
    Rv5=NULL;
    Rv6=0;
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=578; /* line # 578 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      while (Rv4!=NULL){
        Rv5=Rv4;
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=583; /* line # 583 */
        Rv7=Rv5;
        Rv8=NULL;
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=588; /* line # 588 */
          ((V *)Rv2)[0]=Rv8;
        }
        Rv2=Rv8;
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=593; /* line # 593 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    if (Rv3<=0) {
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=598; /* line # 598 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=603; /* line # 603 */
      if (Rv3<=0) Rv3=1;
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else((V *)Rv2)[0]=((V *)Rv0)[7];
      Rv2=((V *)Rv0)[7];
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=608; /* line # 608 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=613; /* line # 613 */
        ((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
      }
      break;
      case 32:Ra.sl[6]=620; /* line # 620 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      if (Rv10==NULL) Rv11=0;
      else Rv11=((UB *)Rv10)[1];
      if (Rv3<=0) {
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=626; /* line # 626 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          if (Rv12!=NULL) {
            Rv13=Rv12;
            if (((UB *)Rv13)[40]==14) {
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=633; /* line # 633 */
      if (Rv3<=0) Rv3=Rv11;
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Rv8=NULL;
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=638; /* line # 638 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else((SL *)Rv8)[13]=32;
        if (Rv2==NULL) Rv9=Rv8;
        else((V *)Rv2)[0]=Rv8;
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=647; /* line # 647 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    P_val_new(((V *)Rv0)+7,F_ty);
    Rv15=((V *)Rv0)[7];
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=652; /* line # 652 */
    ((SL *)Rv15)[6]=Rv3;
    ((SL *)Rv15)[2]=Rv6;
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=658; /* line # 658 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+246;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=672; /* line # 672 */
  if (((V *)F_lgt)[7]!=NULL) {
    Rv0=F_lgt;
    Rv1=F_ty;
    Rv2=((V *)Rv0)[7];
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=677; /* line # 677 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Rv3=((V *)Rv0)[7];
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=684; /* line # 684 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+267;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=696; /* line # 696 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[6];
  ((UW *)Rv0)[32]=((UW *)Rv0)[32]|8;
  P_lgt_new(&Rv2,((V *)Rv0)[4],14,NULL);
  Ra.sl[6]=701; /* line # 701 */
  Rv3=Rv2;
  ((V *)Rv3)[7]=((V *)Rv0)[9];
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=706; /* line # 706 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  if (((UB *)((V *)Rv0)[4])[92]==7||((UB *)((V *)Rv0)[4])[92]==16) Rv2=P_lgt_new_code(3,
  Rv2);
  else {
    Ra.sl[6]=712; /* line # 712 */
    Rv2=P_exp_genop(28, Rv2);
  }
  switch (((UB *)Rv1)[104]) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:Ra.sl[6]=718; /* line # 718 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else((V *)((V *)Rv1)[17])[0]=Rv2;
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+285;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=740; /* line # 740 */
  Rv0=F_lgt;
  switch (((UB *)Rv0)[40]) {
    case 13:Rv1=((V *)Rv0)[6];
    if (((UB *)Rv1)[56]!=2) {
      Ra.sl[6]=746; /* line # 746 */
      P_src_error_s(Rd.s+304,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=752; /* line # 752 */
    Rv2=((V *)Rv0)[1];
    while (Rv2!=NULL){
      P_type_check_parm(Rv2);
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=758; /* line # 758 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=766; /* line # 766 */
      P_src_error(Rd.s+304,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=772; /* line # 772 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+304,203,3);
    break;
    default:P_src_error(Rd.s+304,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000000(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+308;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=799; /* line # 799 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=805; /* line # 805 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+327;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=816; /* line # 816 */
  Rv0=0;
  Rv1=F_lgt;
  Rv2=F_ip;
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=821; /* line # 821 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Rv4=Rv3;
    Rv5=Rv1;
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[4],0)) {
      Ra.sl[6]=828; /* line # 828 */
      P_type_check_parm(Rv1);
      ((UB *)Rv4)[64]=2;
      ((V *)Rv4)[10]=Rv1;
    }
    else {
      Ra.sl[6]=833; /* line # 833 */
      P_src_error_s(Rd.s+344,201,3,((V *)Rv4)[0],NULL);
    }
    Rv1=((V *)Rv1)[0];
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=839; /* line # 839 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+344,998,3);
  if (((UB *)((V *)Rv2)[4])[92]==27) {
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[4])[9],NULL,NULL,0);
    Ra.sl[6]=845; /* line # 845 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else P_src_error(Rd.s+344,222,3);
  }
  else {
    Ra.sl[6]=850; /* line # 850 */
    P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv6);
    Rv7=Rv6;
    ((UB *)Rv7)[89]=1;
    ((V *)Rv7)[0]=((V *)Rv2)[4];
    Ra.sl[6]=855; /* line # 855 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[4])[4];
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[4])[11];
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[4])[10];
    memcpy(Rv7+48,((V *)Rv2)[4]+48,1);
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[4])[10];
    Ra.sl[6]=860; /* line # 860 */
    ((UB *)Rv7)[90]=((UB *)((V *)Rv2)[4])[90];
    V_sy_type_gfirst=((V *)Rv2)[10];
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=865; /* line # 865 */
    PAS_EXPSION_PRC_00000000(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[4])[9]
    );
    switch (((UB *)Rv7)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=870; /* line # 870 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=878; /* line # 878 */
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[4])[12]);
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[4])[14]);
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[4])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=886; /* line # 886 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=900; /* line # 900 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      PAS_EXPSION_PRC_00000000(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[4])
      [13]);
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=913; /* line # 913 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      if (((V *)((V *)Rv7)[0])[14]!=NULL) ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)
      Rv7)[0])[14]);
      else {
        Ra.sl[6]=918; /* line # 918 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=923; /* line # 923 */
      P_src_error(Rd.s+344,998,3);
      break;
    }
  }
  Ra.sl[6]=929; /* line # 929 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  while (Rv3!=NULL){
    Rv8=Rv3;
    Ra.sl[6]=934; /* line # 934 */
    ((V *)Rv8)[10]=NULL;
    ((UB *)Rv8)[64]=0;
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=940; /* line # 940 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+348;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=974; /* line # 974 */
  Rv0=F_ty;
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Rv1=P_all_new_tmp(V_int_typ, Lx[1].v[4]);
    Ra.sl[6]=981; /* line # 981 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Rv2=P_lgt_new_code(3, Rv1);
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[6]=986; /* line # 986 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    (*F_lgl)=Rv2;
    Rv3=1;
    Ra.sl[6]=991; /* line # 991 */
    if (((V *)Rv0)[13]!=NULL) {
      Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
      if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
        Ra.sl[6]=997; /* line # 997 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[1].v[4]);
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[6]=1003; /* line # 1003 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else((V *)(*F_lgl))[0]=Rv2;
        (*F_lgl)=Rv2;
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1009; /* line # 1009 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
    }
    if (Lx[1].ub[28]) {
      Ra.sl[6]=1014; /* line # 1014 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
    }
    else P_lgt_new_copy(F_trg, &Rv2);
    Ra.sl[6]=1019; /* line # 1019 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Rv6=Rv2;
    ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
    P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
    Ra.sl[6]=1024; /* line # 1024 */
    Rv7=((V *)Rv0)[14];
    Rv8=Rv2;
    ((V *)Rv8)[6]=F_ty;
    if (((UB *)Rv7)[92]!=10&&((UB *)Rv7)[92]!=23) ((SL *)Rv8)[4]=((SL *)Rv8)[4]+
    ((SL *)Rv7)[10];
    Ra.sl[6]=1029; /* line # 1029 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=1038; /* line # 1038 */
    Rv9=((V *)Rv0)[15];
    if (((UB *)Rv9)[92]!=22) {
      if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
      else Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
      Ra.sl[6]=1043; /* line # 1043 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
    }
    else Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
    Rv12=Rv11;
    Ra.sl[6]=1048; /* line # 1048 */
    PAS_EXPSION_PRC_00000001(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[6]=1059; /* line # 1059 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    ((UB *)Rv5)[41]=5;
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[6]=1064; /* line # 1064 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000004(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+362;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1089; /* line # 1089 */
  Rv0=NULL;
  Rv1=NULL;
  PAS_EXPSION_PRC_00000003(F_ty, Lx[0].v[4],&Rv0, &Rv1);
  if (Rv0!=NULL) {
    Ra.sl[6]=1094; /* line # 1094 */
    if (Rv1!=Rv0) {
      P_lgt_new(&Rv0,NULL,0, Rv0);
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1100; /* line # 1100 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+375;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1106; /* line # 1106 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[12];
  while (Rv1!=NULL){
    Ra.sl[6]=1111; /* line # 1111 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1116; /* line # 1116 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        if (Lx[1].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[4],2, P_lgt_link(Ra.v[4]));
        else P_lgt_new_copy(Ra.v[4],&Rv4);
        Ra.sl[6]=1121; /* line # 1121 */
        Rv5=Rv4;
        ((V *)Rv5)[4]=Rv1;
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[15];
        Ra.sl[6]=1128; /* line # 1128 */
        if (((UB *)Rv3)[92]!=10&&((UB *)Rv3)[92]!=23) ((SL *)Rv5)[4]=((SL *)Rv5)
        [4]+((SL *)((V *)Rv2)[4])[10];
        PAS_EXPSION_PRC_00000001(((V *)Rv2)[4],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1133; /* line # 1133 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[6]=1138; /* line # 1138 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1143; /* line # 1143 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else((V *)(*F_lgl))[0]=Rv6;
    (*F_lgl)=Rv6;
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1149; /* line # 1149 */
    P_lgt_new_copy(Rv7, &Rv4);
    ((V *)Rv6)[1]=Rv4;
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1154; /* line # 1154 */
    Rv6=PAS_EXPSION_PRC_00000004(((V *)Rv7)[3],Rv7);
    ((V *)Rv4)[0]=Rv6;
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1159; /* line # 1159 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    ((V *)Rv6)[0]=Rv4;
    Rv7=((V *)Rv7)[0];
    while (Rv7!=NULL){
      Ra.sl[6]=1164; /* line # 1164 */
      Rv6=PAS_EXPSION_PRC_00000004(((V *)Rv7)[3],Rv7);
      ((V *)Rv4)[0]=Rv6;
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000001(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+389;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1193; /* line # 1193 */
  Rv0=F_ty;
  if (((V *)Rv0)[4]!=NULL) {
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1198; /* line # 1198 */
    Rv2=((V *)Rv0)[7];
    while (Rv1!=NULL&&Rv2!=NULL){
      Rv3=Rv1;
      Ra.sl[6]=1203; /* line # 1203 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[4],2, P_lgt_link(F_trg));
      else P_lgt_new_copy(F_trg, &Rv4);
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1209; /* line # 1209 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
      if (((UB *)Rv6)[92]!=10&&((UB *)Rv6)[92]!=23) ((SL *)Rv5)[4]=((SL *)Rv5)[4]
      -((SL *)Rv6)[10];
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[4],0);
      Ra.sl[6]=1214; /* line # 1214 */
      ((V *)Rv3)[10]=((V *)Rv5)[0];
      ((UB *)Rv3)[64]=1;
      P_lgt_new(&Rv4,((V *)Rv3)[4],6, Rv4);
      Ra.sl[6]=1219; /* line # 1219 */
      ((UB *)Rv4)[41]=3;
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else((V *)(*F_lgl))[0]=Rv4;
      Ra.sl[6]=1224; /* line # 1224 */
      (*F_lgl)=Rv4;
      Rv2=((V *)Rv2)[0];
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1230; /* line # 1230 */
  if (((UB *)Rv0)[90]) switch (((UB *)Rv0)[92]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
    break;
    case 8:
    case 9:Ra.sl[6]=1236; /* line # 1236 */
    PAS_EXPSION_PRC_00000002(F_ty, F_trg, F_lgh,F_lgl);
    break;
    default:P_src_error(Rd.s+403,131,3);
    break;
  }
  Ra.sl[6]=1242; /* line # 1242 */
  Rv1=((V *)F_ty)[4];
  while (Rv1!=NULL){
    Rv7=Rv1;
    ((V *)Rv7)[10]=NULL;
    Ra.sl[6]=1247; /* line # 1247 */
    ((UB *)Rv7)[64]=0;
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+407;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1255; /* line # 1255 */
  if (((UB *)F_ty)[90]) switch (((UB *)F_ty)[92]) {
    case 10:
    case 23:PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    case 8:
    case 9:Ra.sl[6]=1262; /* line # 1262 */
    PAS_EXPSION_PRC_00000002(F_ty, F_trg, F_lgth,F_lgtl);
    break;
    default:P_src_error(Rd.s+421,131,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000005(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+425;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1295; /* line # 1295 */
  Rv0=F_ty;
  if (((V *)Rv0)[15]!=NULL) {
    Rv1=((V *)Rv0)[15];
    if (((UB *)Rv1)[92]!=22) {
      Ra.sl[6]=1300; /* line # 1300 */
      if (((UB *)Rv1)[112]) Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      else Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
    }
    else {
      Ra.sl[6]=1306; /* line # 1306 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      if (((UB *)Rv3)[40]==14) {
        Rv2=((SL *)((V *)Rv3)[7])[13];
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1312; /* line # 1312 */
        P_src_error(Rd.s+439,142,4);
      }
    }
  }
  else Rv2=0;
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1318; /* line # 1318 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    if (((UB *)Rv3)[40]==14) {
      Rv4=((SL *)((V *)Rv3)[7])[13];
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1324; /* line # 1324 */
      P_src_error(Rd.s+439,142,4);
    }
  }
  else Rv4=((SL *)Rv0)[25];
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1330; /* line # 1330 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1335; /* line # 1335 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    if (Lx[2].v[0]==NULL) Lx[2].v[0]=Rv7;
    else((V *)Lx[2].v[1])[0]=Rv7;
    Lx[2].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1340; /* line # 1340 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+443;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1359; /* line # 1359 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[12];
  while (Rv1!=NULL){
    Ra.sl[6]=1364; /* line # 1364 */
    Rv2=Rv1;
    if (((V *)Rv2)[4]!=NULL) {
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1369; /* line # 1369 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[4],0);
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1375; /* line # 1375 */
        if (((SL *)Rv3)[11]>0) {
          Rv4=NULL;
          P_val_new(&Rv4, V_typ_std.v[0]);
          Rv6=Rv4;
          Ra.sl[6]=1381; /* line # 1381 */
          Rv5=((SL *)Rv3)[11];
          ((UB *)Rv6)[48]=31;
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1387; /* line # 1387 */
          Rv5=0;
        }
      }
      if (Rv5>0) {
        (*F_iadr)=(*F_iadr)+Rv5;
        if (Lx[2].v[0]==NULL) Lx[2].v[0]=Rv4;
        else {
          Ra.sl[6]=1392; /* line # 1392 */
          ((V *)Lx[2].v[1])[0]=Rv4;
        }
        Lx[2].v[1]=Rv4;
      }
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else Rv1=((V *)Rv2)[3];
    }
  }
  Ra.sl[6]=1400; /* line # 1400 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Rv7=((V *)Rv0)[14];
    Rv8=((V *)Rv7)[1];
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1405; /* line # 1405 */
    Rv10=((V *)Rv9)[0];
    Rv11=Rv8;
    Rv12=((SL *)Rv11)[4];
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1410; /* line # 1410 */
      Rv13=((V *)Rv11)[7];
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1416; /* line # 1416 */
      Rv15=NULL;
    }
    if (((V *)Rv0)[4]!=NULL) {
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1421; /* line # 1421 */
      Rv17=Rv16;
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+457,142,3);
      else {
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else Rv18=Rv12-1;
      }
      Ra.sl[6]=1426; /* line # 1426 */
      P_lgt_free(&Rv16);
    }
    Rv19=((V *)Rv10)[0];
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1431; /* line # 1431 */
      Rv19=Rv9;
    }
    else {
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1438; /* line # 1438 */
        while (Rv18>0&&Rv19!=NULL){
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1445; /* line # 1445 */
    if (Rv19!=NULL) {
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000006(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+461;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1456; /* line # 1456 */
  Rv0=F_ty;
  Rv1=0;
  Ra.v[0]=NULL;
  Ra.v[1]=NULL;
  Ra.sl[10]=1461; /* line # 1461 */
  Rv2=NULL;
  Rv3=NULL;
  Rv4=((SL *)Rv0)[11];
  Rv5=0;
  Ra.sl[10]=1466; /* line # 1466 */
  if (((V *)Rv0)[4]!=NULL) {
    Rv6=((V *)Rv0)[4];
    Rv7=((V *)Rv0)[7];
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1471; /* line # 1471 */
      Rv8=Rv6;
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[4],0);
      ((SL *)Rv9)[4]=((SL *)Rv8)[15];
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1476; /* line # 1476 */
        ((V *)Rv3)[0]=Rv9;
      }
      Rv3=Rv9;
      Rv10=((V *)Rv9)[7];
      P_val_new(&Rv10,((V *)Rv8)[4]);
      ((V *)Rv10)[4]=((V *)Rv8)[4];
      Ra.sl[10]=1481; /* line # 1481 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[4])[11];
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else((V *)Ra.v[1])[0]=Rv10;
      Ra.v[1]=Rv10;
      Ra.sl[10]=1486; /* line # 1486 */
      ((V *)Rv8)[10]=Rv9;
      ((UB *)Rv8)[64]=1;
      Rv7=((V *)Rv7)[0];
      Rv6=((V *)Rv8)[3];
      if (((V *)Rv8)[4]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1491; /* line # 1491 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1496; /* line # 1496 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1501; /* line # 1501 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      P_lgt_free(&Rv7);
    }
    else P_src_error(Rd.s+478,147,4);
  }
  Ra.sl[10]=1506; /* line # 1506 */
  if (F_szw>Rv4) Rv4=F_szw;
  if (((UB *)Rv0)[90]) switch (((UB *)Rv0)[92]) {
    case 10:
    case 23:Ra.sl[10]=1511; /* line # 1511 */
    PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
    break;
    case 8:
    case 9:PAS_EXPSION_PRC_00000005(F_ty, &Rv1);
    break;
    default:Ra.sl[10]=1517; /* line # 1517 */
    P_src_error(Rd.s+478,131,3);
    break;
  }
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1524; /* line # 1524 */
    Rv6=((V *)Rv0)[4];
    while (Rv6!=NULL){
      ((UB *)Rv6)[64]=0;
      ((V *)Rv6)[10]=NULL;
      Ra.sl[10]=1529; /* line # 1529 */
      Rv6=((V *)Rv6)[3];
    }
  }
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1535; /* line # 1535 */
  if (Rv4>Rv1) {
    Rv10=NULL;
    P_val_new(&Rv10,NULL);
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1540; /* line # 1540 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.v[1]=Rv10;
    Rv11=Rv10;
    ((UB *)Rv11)[48]=31;
    Ra.sl[10]=1545; /* line # 1545 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    ((SL *)Rv11)[13]=0;
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1570; /* line # 1570 */
  Rv10=NULL;
  P_val_new(&Rv10, F_ty);
  Rv12=Rv10;
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1575; /* line # 1575 */
  ((SL *)Rv12)[6]=Rv4;
  ((V *)Rv12)[7]=Ra.v[0];
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1584; /* line # 1584 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+482;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1615; /* line # 1615 */
  Rv0=((V *)F_ip)[4];
  if (!((UB *)Rv0)[89]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[6];
  Ra.sl[6]=1621; /* line # 1621 */
  ((UW *)Rv1)[32]=((UW *)Rv1)[32]|16;
  if ((((UB *)Rv1)[66]==6||((UB *)Rv1)[66]==1)&&((SL *)Rv1)[10]>1) {
    Ra.sl[6]=1626; /* line # 1626 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else Rv4=((V *)Rv2)[4];
    Rv5=NULL;
    Rv6=NULL;
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1631; /* line # 1631 */
    Rv8=Rv4;
    while (Rv7!=NULL){
      Ra.sl[6]=1636; /* line # 1636 */
      P_lgt_new(&Rv9,((V *)Rv4)[4],13,NULL);
      Rv10=Rv9;
      Rv11=Rv8;
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      ((SL *)Rv10)[4]=((SL *)Rv11)[15];
      Ra.sl[6]=1641; /* line # 1641 */
      ((V *)Rv11)[10]=Rv9;
      ((UB *)Rv11)[64]=1;
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1647; /* line # 1647 */
      Rv7=((V *)Rv7)[0];
      Rv8=((V *)Rv8)[3];
      Rv12=P_lgt_new_code(3, Rv9);
      if (Rv5==NULL) Rv5=Rv12;
      else((V *)Rv6)[0]=Rv12;
      Ra.sl[6]=1652; /* line # 1652 */
      Rv6=Rv12;
    }
    if (((UB *)Rv2)[90]) {
      Ra.sl[6]=1657; /* line # 1657 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1662; /* line # 1662 */
    if (Rv5!=NULL) switch (((UB *)Rv3)[104]) {
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
      else {
        Ra.sl[6]=1667; /* line # 1667 */
        ((V *)((V *)Rv3)[17])[0]=Rv5;
      }
      ((V *)Rv3)[17]=Rv6;
      break;
      default:break;
    }
    Ra.sl[6]=1672; /* line # 1672 */
    while (Rv4!=NULL){
      Rv13=Rv4;
      ((V *)Rv13)[10]=NULL;
      ((UB *)Rv13)[64]=0;
      Ra.sl[6]=1677; /* line # 1677 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1682; /* line # 1682 */
    if (((V *)Rv1)[9]==NULL) {
      ((UW *)Rv1)[32]=((UW *)Rv1)[32]|8;
      ((V *)Rv1)[9]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1704; /* line # 1704 */
  Rv0=F_p;
  if (((V *)Rv0)[5]!=NULL) F_puna=P_exp_val_una(F_puna,((V *)Rv0)[5]);
  Rv1=F_puna;
  Ra.sl[6]=1709; /* line # 1709 */
  if (((UB *)Rv1)[40]==14) {
    Rv2=((V *)Rv1)[7];
    ((UW *)Rv1)[10]=1;
    switch (((UB *)Rv0)[56]) {
      case 6:Ra.sl[6]=1714; /* line # 1714 */
      ((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]<=0);
      break;
      case 43:((SL *)Rv2)[13]=((SL *)Rv2)[13]+1;
      break;
      case 44:((SL *)Rv2)[13]=((SL *)Rv2)[13]-1;
      break;
      case 45:Ra.sl[6]=1720; /* line # 1720 */
      ((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]&1);
      break;
      case 10:if (((UB *)Rv2)[48]==11||((UB *)Rv2)[48]==17) {
        if (((SL *)Rv2)[13]>=0) ((SL *)Rv2)[13]=-1-((SL *)Rv2)[13];
        else {
          Ra.sl[6]=1725; /* line # 1725 */
          ((SL *)Rv2)[13]= -(1+((SL *)Rv2)[13]);
        }
      }
      break;
      case 46:((SL *)Rv2)[13]= -((SL *)Rv2)[13];
      break;
      case 61:
      case 77:((G *)Rv2)[7]=-((G *)Rv2)[7];
      break;
      case 47:Ra.sl[6]=1731; /* line # 1731 */
      ((SL *)Rv2)[13]=abs(((SL *)Rv2)[13]);
      break;
      case 62:
      case 78:((G *)Rv2)[7]=fabs(((G *)Rv2)[7]);
      break;
      case 48:((SL *)Rv2)[13]=PAS__I_SQR(((SL *)Rv2)[13]);
      break;
      case 63:
      case 79:Ra.sl[6]=1737; /* line # 1737 */
      ((G *)Rv2)[7]=PAS__G_SQR(((G *)Rv2)[7]);
      break;
      case 64:
      case 80:((G *)Rv2)[7]=(double)((SL *)Rv2)[13];
      break;
      case 65:
      case 81:Ra.sl[6]=1742; /* line # 1742 */
      ((SL *)Rv2)[13]=PAS__G_ROUND(((G *)Rv2)[7]);
      break;
      case 66:
      case 82:((SL *)Rv2)[13]=(int)(((G *)Rv2)[7]);
      break;
      case 92:
      case 110:Ra.sl[6]=1747; /* line # 1747 */
      if (((G *)Rv2)[7]<0.000000000000000E-001) P_src_error(Rd.s+511,801,2);
      else((G *)Rv2)[7]=sqrt(((G *)Rv2)[7]);
      break;
      case 93:
      case 111:((G *)Rv2)[7]=sin(((G *)Rv2)[7]);
      break;
      case 94:
      case 112:Ra.sl[6]=1753; /* line # 1753 */
      ((G *)Rv2)[7]=cos(((G *)Rv2)[7]);
      break;
      case 95:
      case 113:((G *)Rv2)[7]=tan(((G *)Rv2)[7]);
      break;
      case 96:
      case 114:Ra.sl[6]=1759; /* line # 1759 */
      if (fabs(((G *)Rv2)[7])>1.000000000000000E+000) P_src_error(Rd.s+511,802,2);
      else((G *)Rv2)[7]=asin(((G *)Rv2)[7]);
      break;
      case 97:
      case 115:if (fabs(((G *)Rv2)[7])>1.000000000000000E+000) P_src_error(Rd.s+
511,803,2);
      else {
        Ra.sl[6]=1764; /* line # 1764 */
        ((G *)Rv2)[7]=acos(((G *)Rv2)[7]);
      }
      break;
      case 98:
      case 116:((G *)Rv2)[7]=atan(((G *)Rv2)[7]);
      break;
      case 102:
      case 120:Ra.sl[6]=1769; /* line # 1769 */
      ((G *)Rv2)[7]=PAS__SHG(((G *)Rv2)[7]);
      break;
      case 103:
      case 121:((G *)Rv2)[7]=PAS__CHG(((G *)Rv2)[7]);
      break;
      case 104:
      case 122:((G *)Rv2)[7]=PAS__THG(((G *)Rv2)[7]);
      break;
      case 105:
      case 123:Ra.sl[6]=1776; /* line # 1776 */
      ((G *)Rv2)[7]=PAS__ASHG(((G *)Rv2)[7]);
      break;
      case 106:
      case 124:if (((G *)Rv2)[7]<1.000000000000000E+000) P_src_error(Rd.s+511,805,2);
      else((G *)Rv2)[7]=PAS__ACHG(((G *)Rv2)[7]);
      break;
      case 107:
      case 125:Ra.sl[6]=1783; /* line # 1783 */
      if (fabs(((G *)Rv2)[7])>1.000000000000000E+000) P_src_error(Rd.s+511,806,2);
      else((G *)Rv2)[7]=PAS__ATHG(((G *)Rv2)[7]);
      break;
      case 100:
      case 118:((G *)Rv2)[7]=exp(((G *)Rv2)[7]);
      break;
      case 101:
      case 119:Ra.sl[6]=1790; /* line # 1790 */
      if (((G *)Rv2)[7]<=0.000000000000000E-001) P_src_error(Rd.s+511,804,2);
      else((G *)Rv2)[7]=log(((G *)Rv2)[7]);
      break;
      default:break;
    }
    Ra.sl[6]=1795; /* line # 1795 */
    ((V *)Rv1)[4]=NULL;
    if (((V *)Rv0)[2]==V_typ_std.v[29]||((V *)Rv0)[2]==V_typ_std.v[28]) ((V *)Rv1)
    [3]=((V *)F_puna)[3];
    else((V *)Rv1)[3]=((V *)Rv0)[2];
    Ra.sl[6]=1800; /* line # 1800 */
    ((V *)Rv2)[4]=((V *)Rv1)[3];
    ((UB *)Rv2)[48]=((UB *)((V *)Rv1)[3])[92];
  }
  else {
    Ra.sl[6]=1805; /* line # 1805 */
    if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+511,851,2);
    if (((UB *)Rv0)[56]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])[
11]) {
      P_lgt_new(&Rv3,((V *)Rv0)[2],6, F_puna);
      Ra.sl[6]=1810; /* line # 1810 */
      Rv4=Rv3;
      if (((V *)Rv4)[3]==V_typ_std.v[29]||((V *)Rv4)[3]==V_typ_std.v[28]) ((V *)
      Rv4)[3]=((V *)F_puna)[3];
      Ra.sl[6]=1815; /* line # 1815 */
      ((V *)Rv4)[0]=((V *)F_puna)[0];
      ((UB *)Rv4)[41]=((UB *)Rv0)[56];
      ((UW *)Rv4)[10]=((UW *)F_puna)[10]&~2;
      ((V *)Rv1)[0]=NULL;
      Ra.sl[6]=1820; /* line # 1820 */
      F_puna=Rv3;
    }
    else((V *)F_puna)[3]=((V *)Rv0)[2];
  }
  Ra.sl[6]=1825; /* line # 1825 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  G Rv5;
  register V Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  UL Rv10;
  register V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+515;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1846; /* line # 1846 */
  Rv0=((V *)F_ob1)[0];
  Rv1=F_p;
  if (((V *)Rv1)[5]!=NULL) F_ob1=P_exp_val_una(F_ob1,((V *)Rv1)[5]);
  Ra.sl[6]=1851; /* line # 1851 */
  if (((V *)Rv1)[6]!=NULL) Rv0=P_exp_val_una(Rv0,((V *)Rv1)[6]);
  ((V *)F_ob1)[0]=Rv0;
  if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
    Ra.sl[6]=1856; /* line # 1856 */
    Rv2=((V *)F_ob1)[7];
    Rv3=Rv0;
    switch (((UB *)Rv1)[56]) {
      case 89:((SL *)Rv2)[13]=PAS__IIPOWER(((SL *)Rv2)[13],((SL *)((V *)Rv3)[7])
      [13]);
      break;
      case 90:
      case 108:((G *)Rv2)[7]=pow  (((G *)Rv2)[7],((G *)((V *)Rv3)[7])[7]);
      break;
      case 91:
      case 109:Ra.sl[6]=1862; /* line # 1862 */
      ((G *)Rv2)[7]=PAS__IGPOWER(((G *)Rv2)[7],((SL *)((V *)Rv3)[7])[13]);
      break;
      case 49:((SL *)Rv2)[13]=((SL *)Rv2)[13]+((SL *)((V *)Rv3)[7])[13];
      break;
      case 50:((SL *)Rv2)[13]=((SL *)Rv2)[13]-((SL *)((V *)Rv3)[7])[13];
      break;
      case 51:((SL *)Rv2)[13]=((SL *)Rv2)[13]*((SL *)((V *)Rv3)[7])[13];
      break;
      case 52:Ra.sl[6]=1867; /* line # 1867 */
      ((SL *)Rv2)[13]=((SL *)Rv2)[13]/((SL *)((V *)Rv3)[7])[13];
      break;
      case 53:((SL *)Rv2)[13]=PAS__I_MOD(((SL *)Rv2)[13],((SL *)((V *)Rv3)[7])[13]
      );
      break;
      case 54:((SL *)Rv2)[13]=((SL *)Rv2)[13]%((SL *)((V *)Rv3)[7])[13];
      break;
      case 67:
      case 85:Ra.sl[6]=1872; /* line # 1872 */
      ((G *)Rv2)[7]=((G *)Rv2)[7]+((G *)((V *)Rv3)[7])[7];
      break;
      case 68:
      case 86:((G *)Rv2)[7]=((G *)Rv2)[7]-((G *)((V *)Rv3)[7])[7];
      break;
      case 69:
      case 87:((G *)Rv2)[7]=((G *)Rv2)[7]*((G *)((V *)Rv3)[7])[7];
      break;
      case 70:
      case 88:Ra.sl[6]=1878; /* line # 1878 */
      ((G *)Rv2)[7]=((G *)Rv2)[7]/((G *)((V *)Rv3)[7])[7];
      break;
      case 7:((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]>0&&((SL *)((V *)Rv3)[7])[13]>0)
      ;
      break;
      case 8:((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]>0||((SL *)((V *)Rv3)[7])[13]>0)
      ;
      break;
      case 9:((SL *)Rv2)[13]=(SL)(((SL *)Rv2)[13]>0!=((SL *)((V *)Rv3)[7])[13]>0)
      ;
      break;
      case 11:Ra.sl[6]=1885; /* line # 1885 */
      ((UL *)Rv2)[13]=((UL *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13];
      break;
      case 12:((UL *)Rv2)[13]=(((UL *)Rv2)[13]|((UL *)((V *)Rv3)[7])[13])&~(((UL
       *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13]);
      break;
      case 13:((UL *)Rv2)[13]=((UL *)Rv2)[13]&~((UL *)((V *)Rv3)[7])[13];
      break;
      case 14:((UL *)Rv2)[13]=((UL *)Rv2)[13]|((UL *)((V *)Rv3)[7])[13];
      break;
      case 15:Ra.sl[6]=1890; /* line # 1890 */
      ((SL *)Rv2)[13]=(SL)((((UL *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13])!=0);
      break;
      case 16:break;
      case 17:break;
      case 18:break;
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:Ra.sl[6]=1899; /* line # 1899 */
      switch (((UB *)Rv1)[56]) {
        case 19:
        case 20:Rv4=(SL)PAS__SET_LE(((UL *)Rv2)[13],((UL *)((V *)Rv3)[7])[13]);
        break;
        case 21:
        case 22:Rv4=(SL)PAS__SET_LE(((UL *)((V *)Rv3)[7])[13],((UL *)Rv2)[13]);
        break;
        case 23:Ra.sl[6]=1904; /* line # 1904 */
        Rv4=(SL)(((UL *)Rv2)[13]!=((UL *)((V *)Rv3)[7])[13]);
        break;
        case 24:Rv4=(SL)(((UL *)Rv2)[13]==((UL *)((V *)Rv3)[7])[13]);
        break;
        default:break;
      }
      ((UB *)Rv2)[48]=1;
      Ra.sl[6]=1909; /* line # 1909 */
      ((SL *)Rv2)[6]=0;
      ((SL *)Rv2)[13]=Rv4;
      break;
      case 25:Rv4=(SL)((1<<((SL *)Rv2)[13]&((UL *)((V *)Rv3)[7])[13])!=0);
      break;
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:Ra.sl[6]=1918; /* line # 1918 */
      Rv4=((SL *)Rv2)[13]-((SL *)((V *)Rv3)[7])[13];
      switch (((UB *)Rv1)[56]) {
        case 28:
        case 32:((SL *)Rv2)[13]=(SL)(Rv4<0);
        break;
        case 29:
        case 33:((SL *)Rv2)[13]=(SL)(Rv4<=0);
        break;
        case 30:
        case 34:((SL *)Rv2)[13]=(SL)(Rv4>=0);
        break;
        case 31:
        case 35:Ra.sl[6]=1923; /* line # 1923 */
        ((SL *)Rv2)[13]=(SL)(Rv4>0);
        break;
        case 27:((SL *)Rv2)[13]=(SL)(Rv4!=0);
        break;
        case 26:((SL *)Rv2)[13]=(SL)(Rv4==0);
        break;
      }
      break;
      case 55:
      case 56:
      case 57:
      case 58:
      case 59:
      case 60:
      case 71:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:Ra.sl[6]=1931; /* line # 1931 */
      Rv5=((G *)Rv2)[7]-((G *)((V *)Rv3)[7])[7];
      switch (((UB *)Rv1)[56]) {
        case 55:
        case 71:((SL *)Rv2)[13]=(SL)(Rv5<0.000000000000000E-001);
        break;
        case 56:
        case 72:((SL *)Rv2)[13]=(SL)(Rv5<=0.000000000000000E-001);
        break;
        case 57:
        case 73:((SL *)Rv2)[13]=(SL)(Rv5>=0.000000000000000E-001);
        break;
        case 58:
        case 74:Ra.sl[6]=1936; /* line # 1936 */
        ((SL *)Rv2)[13]=(SL)(Rv5>0.000000000000000E-001);
        break;
        case 60:
        case 76:((SL *)Rv2)[13]=(SL)(Rv5!=0.000000000000000E-001);
        break;
        case 59:
        case 75:((SL *)Rv2)[13]=(SL)(Rv5==0.000000000000000E-001);
        break;
      }
      break;
      case 36:
      case 37:break;
      case 99:
      case 117:Ra.sl[6]=1948; /* line # 1948 */
      ((G *)Rv2)[7]=atan2(((G *)Rv2)[7],((G *)((V *)Rv3)[7])[7]);
      break;
      default:break;
    }
    Rv6=F_ob1;
    Rv7=((V *)Rv6)[7];
    Ra.sl[6]=1954; /* line # 1954 */
    ((V *)Rv6)[4]=NULL;
    if (((V *)Rv1)[2]==V_typ_std.v[29]||((V *)Rv1)[2]==V_typ_std.v[28]) ((V *)Rv6)
    [3]=((V *)F_ob1)[3];
    else((V *)Rv6)[3]=((V *)Rv1)[2];
    Ra.sl[6]=1959; /* line # 1959 */
    ((V *)Rv7)[4]=((V *)Rv6)[3];
    ((UB *)Rv7)[48]=((UB *)((V *)Rv6)[3])[92];
    ((V *)F_ob1)[0]=NULL;
    P_lgt_free(&Rv0);
  }
  else {
    Ra.sl[6]=1967; /* line # 1967 */
    Rv8=1;
    switch (((UB *)Rv1)[56]) {
      case 25:if (((UB *)F_ob1)[40]==14) {
        Ra.sl[6]=1972; /* line # 1972 */
        Rv9=F_ob1;
        Rv10=((SL *)((V *)Rv9)[7])[13];
        ((V *)Rv9)[3]=((V *)Rv0)[3];
        P_val_free(((V *)Rv9)+7);
        Ra.sl[6]=1977; /* line # 1977 */
        P_val_new(((V *)Rv9)+7,((V *)Rv9)[3]);
        Rv11=((V *)Rv9)[7];
        ((SL *)Rv11)[6]=(Rv10+7)/8;
        ((UL *)Rv11)[13]=1<<Rv10;
        Ra.sl[6]=1984; /* line # 1984 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Rv12=Rv0;
        ((UW *)Rv12)[10]=1;
        ((UB *)Rv12)[41]=15;
        Ra.sl[6]=1990; /* line # 1990 */
        Rv8=0;
      }
      break;
      case 7:if (((UB *)F_ob1)[40]==14) {
        Ra.sl[6]=1995; /* line # 1995 */
        Rv13=F_ob1;
        ((V *)F_ob1)[0]=NULL;
        Rv8=0;
        if (((SL *)((V *)Rv13)[7])[13]<=0) {
          Ra.sl[6]=2001; /* line # 2001 */
          P_lgt_free_tree(&Rv0);
          Rv0=F_ob1;
        }
        else P_lgt_free(&F_ob1);
      }
      else {
        Ra.sl[6]=2008; /* line # 2008 */
        if (((UB *)Rv0)[40]==14) {
          Rv14=Rv0;
          ((V *)F_ob1)[0]=NULL;
          Rv8=0;
          Ra.sl[6]=2013; /* line # 2013 */
          if (((SL *)((V *)Rv14)[7])[13]<=0) P_lgt_free_tree(&F_ob1);
          else {
            P_lgt_free(&Rv0);
            Ra.sl[6]=2018; /* line # 2018 */
            Rv0=F_ob1;
          }
        }
      }
      break;
      case 8:Ra.sl[6]=2023; /* line # 2023 */
      if (((UB *)F_ob1)[40]==14) {
        Rv15=F_ob1;
        ((V *)F_ob1)[0]=NULL;
        Rv8=0;
        Ra.sl[6]=2028; /* line # 2028 */
        if (((SL *)((V *)Rv15)[7])[13]>0) {
          P_lgt_free_tree(&Rv0);
          Rv0=F_ob1;
        }
        else {
          Ra.sl[6]=2034; /* line # 2034 */
          P_lgt_free(&F_ob1);
        }
      }
      else {
        if (((UB *)Rv0)[40]==14) {
          Rv16=Rv0;
          Ra.sl[6]=2040; /* line # 2040 */
          ((V *)F_ob1)[0]=NULL;
          Rv8=0;
          if (((SL *)((V *)Rv16)[7])[13]>0) P_lgt_free_tree(&F_ob1);
          else {
            Ra.sl[6]=2046; /* line # 2046 */
            P_lgt_free(&Rv0);
            Rv0=F_ob1;
          }
        }
      }
      break;
      case 1:
      case 3:
      case 4:
      case 5:Ra.sl[6]=2053; /* line # 2053 */
      Rv17=F_ob1;
      ((UW *)Rv17)[10]=((UW *)Rv17)[10]|8;
      if (!(2&((UW *)Rv17)[10])) P_src_error(Rd.s+530,852,2);
      Ra.sl[6]=2058; /* line # 2058 */
      Rv18=Rv0;
      if (!(1&((UW *)Rv18)[10])) P_src_error(Rd.s+530,851,1);
      if ((((UB *)Rv1)[56]!=1&&((UB *)Rv18)[40]==8)&&((V *)Rv18)[3]!=NULL) {
        Ra.sl[6]=2065; /* line # 2065 */
        Rv19=((V *)Rv18)[6];
        if (((V *)Rv19)[8]!=NULL) {
          if (((UB *)((V *)Rv19)[8])[66]==6) {
            ((V *)F_ob1)[0]=((V *)((V *)Rv18)[1])[0];
            Ra.sl[6]=2070; /* line # 2070 */
            P_lgt_free(((V *)Rv18)+1);
            ((V *)Rv18)[1]=F_ob1;
            Ra.sl[6]=2075; /* line # 2075 */
            Rv8=0;
          }
        }
      }
      break;
      default:Ra.sl[6]=2080; /* line # 2080 */
      if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) P_src_error(Rd.s+530,851,1);
      break;
    }
    if (Rv8) {
      Ra.sl[6]=2085; /* line # 2085 */
      P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
      Rv20=Rv0;
      if (((V *)Rv20)[3]==V_typ_std.v[29]||((V *)Rv20)[3]==V_typ_std.v[28]) ((V *)
      Rv20)[3]=((V *)F_ob1)[3];
      Ra.sl[6]=2090; /* line # 2090 */
      ((UW *)Rv20)[10]=1;
      ((UB *)Rv20)[41]=((UB *)Rv1)[56];
    }
    F_ob1=Rv0;
  }
  Ra.sl[6]=2097; /* line # 2097 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+534;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2112; /* line # 2112 */
  Rv0=F_lgt;
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2117; /* line # 2117 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) Rv0=((V *)Rv1)[1];
    else Rv0=NULL;
  }
  Ra.sl[6]=2123; /* line # 2123 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2129; /* line # 2129 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  register V Rv28;
  register V Rv29;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+555;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2150; /* line # 2150 */
  Rv0=0;
  Rv1=NULL;
  if ((*F_lgt)!=NULL) {
    Rv2=(*F_lgt);
    Ra.sl[6]=2155; /* line # 2155 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Rv3=((V *)Rv2)[1];
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2160; /* line # 2160 */
  if (Rv1!=NULL) {
    Rv4=Rv1;
    Rv5=NULL;
    Rv6=NULL;
    Ra.sl[6]=2165; /* line # 2165 */
    Rv7=((V *)Rv4)[8];
    if (((V *)Rv4)[11]!=NULL) {
      Rv8=((V *)Rv4)[11];
      if (!((UB *)Rv8)[91]) {
        Ra.sl[6]=2176; /* line # 2176 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        ((V *)(*F_lgt))[1]=Rv5;
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2183; /* line # 2183 */
    while (Rv7!=NULL){
      Rv9=NULL;
      Rv10=0;
      Rv11=0;
      Ra.sl[6]=2188; /* line # 2188 */
      Rv12=Rv3;
      Rv13=Rv7;
      if (Rv3!=NULL) {
        Ra.sl[6]=2193; /* line # 2193 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          if (((V *)Rv13)[4]!=NULL) {
            Ra.sl[6]=2198; /* line # 2198 */
            Rv14=((V *)Rv13)[4];
            switch (((UB *)Rv14)[92]) {
              case 10:if (P_comp_type(((V *)Rv13)[4],V_typ_std.v[10],0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1)) {
                Ra.sl[6]=2203; /* line # 2203 */
                if (((UB *)Rv3)[40]==14) {
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  P_val_free(((V *)Rv3)+7);
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2208; /* line # 2208 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Rv16=((V *)Rv3)[7];
                  ((UB *)Rv16)[48]=32;
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2213; /* line # 2213 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2219; /* line # 2219 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  ((V *)Rv3)[0]=Rv17;
                  ((UW *)Rv3)[10]=5;
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2224; /* line # 2224 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2230; /* line # 2230 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0)) {
                Rv10=1;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2235; /* line # 2235 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[4],3, Rv3);
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2242; /* line # 2242 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0)) {
                  Rv10=1;
                  Rv11=1;
                }
              }
              if (((UB *)Rv14)[92]==9) Rv9=((V *)Rv13)[4];
              break;
              case 13:
              case 14:
              case 15:
              case 17:
              case 18:
              case 19:
              case 20:
              case 21:
              case 29:Ra.sl[6]=2251; /* line # 2251 */
              if (Rv6==NULL) Rv6=((V *)Rv3)[3];
              else {
                if (((UB *)Rv6)[91]&&!((UB *)((V *)Rv3)[3])[91]||((SL *)Rv6)[11]
                <((SL *)((V *)Rv3)[3])[11]) Rv6=((V *)Rv3)[3];
              }
              break;
              default:break;
            }
            Ra.sl[6]=2261; /* line # 2261 */
            switch (((UB *)Rv13)[66]) {
              case 7:if (!(4&((UW *)Rv3)[10])) {
                Ra.sl[6]=2266; /* line # 2266 */
                Rv18=Rv3;
                if (64&((UW *)Rv13)[32]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[6]=2272; /* line # 2272 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else((V *)Rv5)[0]=Rv3;
              }
              break;
              case 10:Ra.sl[6]=2279; /* line # 2279 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2284; /* line # 2284 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else((V *)Rv5)[0]=Rv3;
              break;
              default:break;
            }
            Ra.sl[6]=2290; /* line # 2290 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2296; /* line # 2296 */
        P_lgt_new(&Rv3,((V *)Rv13)[4],14,NULL);
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else((V *)Rv5)[0]=Rv3;
        Rv0=1;
      }
      Ra.sl[6]=2303; /* line # 2303 */
      if (Rv0) {
        if (8192&((UW *)Rv13)[32]) {
          Rv19=Rv3;
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2308; /* line # 2308 */
          ((V *)Rv19)[3]=((V *)Rv13)[4];
          ((V *)Rv19)[4]=NULL;
        }
        else {
          if (((V *)Rv13)[9]!=NULL) {
            Ra.sl[6]=2313; /* line # 2313 */
            Rv20=Rv3;
            ((UB *)Rv20)[40]=14;
            ((V *)Rv20)[3]=((V *)Rv13)[4];
            ((V *)Rv20)[7]=((V *)Rv13)[9];
            Ra.sl[6]=2318; /* line # 2318 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[4]);
            ((V *)Rv20)[4]=NULL;
          }
          else P_src_error_s(Rd.s+571,854,2,((V *)Rv13)[0],NULL);
        }
      }
      Ra.sl[6]=2323; /* line # 2323 */
      Rv5=Rv3;
      if (Rv9!=NULL) {
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2328; /* line # 2328 */
          Rv21=((V *)Rv9)[15];
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Ra.sl[6]=2335; /* line # 2335 */
            Rv22=((V *)Rv9)[15];
            Rv23=NULL;
            Rv24=NULL;
            if (Rv10) {
              while (1){
                Ra.sl[6]=2342; /* line # 2342 */
                if (((V *)Rv22)[0]!=NULL) Rv22=((V *)Rv22)[0];
                if (((V *)Rv22)[0]==NULL||((UB *)Rv22)[92]!=22)  break;
              }
              if (Rv11) {
                Ra.sl[6]=2347; /* line # 2347 */
                Rv23=P_lgt_new_econst(Rv22,1);
                Rv7=((V *)Rv7)[3];
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Rv24=P_lgt_new_econst(Rv22,1);
                  ((V *)Rv23)[0]=Rv24;
                  Ra.sl[6]=2352; /* line # 2352 */
                  Rv7=((V *)Rv7)[3];
                }
                else Rv24=Rv23;
              }
              else {
                Ra.sl[6]=2358; /* line # 2358 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Rv23=P_lgt_new_econst(Rv22,1);
                  Rv24=Rv23;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2364; /* line # 2364 */
                if (((UB *)Rv12)[40]==14) Rv17=P_lgt_new_econst(Rv22,((SL *)((V *)
                Rv12)[7])[6]);
                else {
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[4],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2370; /* line # 2370 */
                  if (!(64&((UW *)Rv7)[32])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[15];
                  if (((V *)Rv17)[3]!=Rv22) {
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2375; /* line # 2375 */
                    ((V *)Rv17)[3]=Rv22;
                  }
                }
                Rv7=((V *)Rv7)[3];
                if (Rv24==NULL) Rv23=Rv17;
                else {
                  Ra.sl[6]=2380; /* line # 2380 */
                  ((V *)Rv24)[0]=Rv17;
                }
                Rv24=Rv17;
              }
            }
            else {
              Ra.sl[6]=2386; /* line # 2386 */
              Rv25=((V *)Rv3)[3];
              if (Rv25!=NULL) while (Rv9!=NULL&&Rv25!=NULL)
              if (((UB *)Rv9)[92]==9&&(((UB *)Rv25)[92]==9||((UB *)Rv25)[92]==8)
              ) {
                Ra.sl[6]=2393; /* line # 2393 */
                Rv26=((V *)Rv25)[15];
                Rv22=((V *)Rv9)[15];
                while (1){
                  if (((V *)Rv22)[0]!=NULL) Rv22=((V *)Rv22)[0];
                  if (((V *)Rv22)[0]==NULL||((UB *)Rv22)[92]!=22)  break;
                }
                Ra.sl[6]=2400; /* line # 2400 */
                if (((UB *)Rv26)[92]==22) Rv27=P_look_for_descriptor(Rv12, Rv26);
                else Rv27=Rv12;
                Ra.sl[6]=2405; /* line # 2405 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  if (((UB *)Rv26)[92]==22) {
                    Rv17=P_lgt_type_eval(((V *)Rv26)[13],Rv27,NULL,0);
                    Ra.sl[6]=2410; /* line # 2410 */
                    if (((SL *)Rv26)[11]!=((SL *)Rv22)[11]) {
                      Rv17=P_lgt_new_code(0, Rv17);
                      ((V *)Rv17)[3]=Rv22;
                    }
                  }
                  else {
                    Ra.sl[6]=2416; /* line # 2416 */
                    Rv17=P_lgt_new_econst(Rv22,((SL *)Rv26)[29]);
                  }
                  if (Rv24==NULL) Rv23=Rv17;
                  else((V *)Rv24)[0]=Rv17;
                  Rv24=Rv17;
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2423; /* line # 2423 */
                if (((UB *)Rv26)[92]==22) {
                  Rv17=P_lgt_type_eval(((V *)Rv26)[14],Rv27,NULL,0);
                  if (Rv26!=Rv22) {
                    Ra.sl[6]=2428; /* line # 2428 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    ((V *)Rv17)[3]=Rv22;
                  }
                }
                else Rv17=P_lgt_new_econst(Rv22,((SL *)Rv26)[30]);
                Ra.sl[6]=2433; /* line # 2433 */
                if (Rv24==NULL) Rv23=Rv17;
                else((V *)Rv24)[0]=Rv17;
                Rv24=Rv17;
                Rv7=((V *)Rv7)[3];
                Rv25=((V *)Rv25)[14];
                Ra.sl[6]=2438; /* line # 2438 */
                Rv9=((V *)Rv9)[14];
              }
              else Rv9=NULL;
              Rv28=Rv3;
              if (((SL *)((V *)Rv28)[3])[10]>0) {
                Ra.sl[6]=2443; /* line # 2443 */
                ((SL *)Rv28)[4]=((SL *)Rv28)[4]+((SL *)((V *)Rv28)[3])[10];
              }
            }
            if (Rv23!=NULL) {
              Ra.sl[6]=2449; /* line # 2449 */
              ((V *)Rv24)[0]=((V *)Rv3)[0];
              ((V *)Rv3)[0]=Rv23;
              Rv3=Rv24;
            }
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2456; /* line # 2456 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Rv7=((V *)Rv7)[3];
    }
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2461; /* line # 2461 */
      Rv29=(*F_lgt);
      if (((UB *)((V *)Rv4)[11])[92]==29||((UB *)((V *)Rv4)[11])[92]==28) {
        Ra.sl[6]=2466; /* line # 2466 */
        ((V *)Rv29)[3]=Rv6;
        if (!((UB *)Rv6)[91]&&((V *)Rv29)[1]!=NULL) ((V *)((V *)Rv29)[1])[3]=Rv6;
      }
      Ra.sl[6]=2472; /* line # 2472 */
      if (!((UB *)((V *)Rv4)[11])[91]) P_tmpstk_allocate(((V *)Rv29)[1],((V *)((
      V *)Rv29)[1])[3]);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wrt "  */
void PAS_EXPSION_PRC_00000007(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+575;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2518; /* line # 2518 */
  if (F_pt!=NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_ENM(((UB *)F_pt)[92],Rd.s+580,14,-1,32);
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1198,14,-1,32);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_entry "  */
void PAS_EXPSION_PRC_00000008(V F_pg, UB F_bt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1208;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2522; /* line # 2522 */
  Rv0=F_pg;
  if (((UB *)Rv0)[8]&&Lx[3].sl[9]<=2) {
    if (F_bt) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1220,-1,-1,32);
    }
    else {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1238,-1,-1,32);
    }
    Ra.sl[6]=2527; /* line # 2527 */
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[3]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1250,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[4]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1254,-1,-1,32);
    PAS_EXPSION_PRC_00000007(((V *)Rv0)[2]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1260,-1,-1,32);
    PAS__WRITE_ENM(((UB *)Rv0)[56],Rd.s+1276,0,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dump "  */
void PAS_EXPSION_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3330;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2535; /* line # 2535 */
  while (Lx[3].v[0]!=NULL){
    Rv1=Lx[3].v[0];
    if (Rv0) {
      Ra.sl[6]=2540; /* line # 2540 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+3336,-1,-1,32);
      PAS__WRITE_INT(Lx[3].sl[9],0,0);
      PAS__WRITE_STR(Rd.s+3363,-1,-1,32);
      if (Lx[3].v[5]!=NULL) {
        Rv2=Lx[3].v[5];
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3371,-1,-1,32);
        PAS_EXPSION_PRC_00000007(((V *)Rv2)[3]);
        Ra.sl[6]=2545; /* line # 2545 */
        if (((V *)Rv2)[0]!=NULL) {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+3386,-1,-1,32);
          PAS_EXPSION_PRC_00000007(((V *)((V *)Rv2)[0])[3]);
        }
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[6]=2550; /* line # 2550 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3403,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Rv0=0;
    }
    PAS_EXPSION_PRC_00000008(Lx[3].v[0],0);
    Lx[3].v[0]=((V *)Rv1)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  register V Rv11;
  register V Rv12;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.sl[9]=F_npa;
  Ra.v[5]=F_parm_lst;
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+3412;
  Ra.v[3]=Rd.s+13;
  Ra.sl[8]=2565; /* line # 2565 */
  Ra.v[0]=(*F_pg);
  Rv0=0;
  Ra.sl[8]=2570; /* line # 2570 */
  while (!Rv0&&(*F_pg)!=NULL){
    Rv1=Ra.v[5];
    Rv2=(*F_pg);
    if (((UB *)Rv2)[8]&&Ra.sl[9]<=2) {
      Ra.sl[8]=2576; /* line # 2576 */
      Rv3=Rv1;
      switch (Ra.sl[9]) {
        case 0:Rv0=((V *)Rv2)[3]==NULL&&((V *)Rv2)[4]==NULL;
        break;
        case 1:Rv0=((V *)Rv2)[4]==NULL&&P_comp_type(((V *)Rv3)[3],((V *)Rv2)[3],0);
        break;
        case 2:Ra.sl[8]=2581; /* line # 2581 */
        if (((SL *)((V *)Rv3)[3])[11]>0&&((SL *)((V *)((V *)Rv3)[0])[3])[11]>0) 
        switch (((UB *)((V *)Rv2)[3])[92]) {
          case 28:Rv0=((P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv3)[3],1)&&((
          SL *)((V *)Rv3)[3])[10]==0)&&((SL *)((V *)Rv3)[3])[11]==((SL *)((V *)(
          (V *)Rv3)[0])[3])[11])&&P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv2)
          [4],0);
          break;
          case 29:Ra.sl[8]=2591; /* line # 2591 */
          Rv0=((P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv3)[3],0)||P_comp_type((
          (V *)Rv3)[3],((V *)((V *)Rv3)[0])[3],0))&&P_comp_type(((V *)Rv3)[3],((
          V *)Rv2)[4],0))&&P_comp_type(((V *)((V *)Rv3)[0])[3],((V *)Rv2)[4],0);
          break;
          case 30:Ra.sl[8]=2597; /* line # 2597 */
          Rv0=(P_comp_type(((V *)((V *)Rv3)[0])[3],V_typ_std.v[19],0)&&P_comp_type((
          (V *)Rv3)[3],((V *)((V *)((V *)Rv3)[0])[3])[13],0))&&P_comp_type(((V *)(
          (V *)Rv3)[0])[3],((V *)Rv2)[4],0);
          break;
          default:Ra.sl[8]=2603; /* line # 2603 */
          Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv2)[3],1)&&P_comp_type(((V *)((V *)
          Rv3)[0])[3],((V *)Rv2)[4],1);
          break;
        }
        break;
      }
    }
    else {
      Ra.sl[8]=2609; /* line # 2609 */
      Rv4=((V *)Rv2)[2];
      if (((SL *)Rv4)[20]>=Ra.sl[9]) {
        Rv5=((V *)Rv4)[8];
        if (((V *)Rv4)[8]!=NULL) {
          Ra.sl[8]=2614; /* line # 2614 */
          if (((UB *)((V *)Rv4)[8])[66]==6) Rv5=((V *)Rv5)[3];
        }
        if ((Ra.sl[9]==2&&((SL *)Rv4)[20]==2)&&(((UB *)Rv4)[104]==1||((UB *)Rv4)
        [104]==2)) {
          Ra.sl[8]=2619; /* line # 2619 */
          Rv6=Rv1;
          switch (((UB *)((V *)Rv5)[4])[92]) {
            case 28:Rv0=(((V *)((V *)Rv6)[0])[3]==((V *)Rv6)[3]&&((SL *)((V *)Rv6)
            [3])[10]==0)&&P_comp_type(((V *)Rv6)[3],((V *)((V *)Rv5)[3])[4],0);
            break;
            case 29:Ra.sl[8]=2628; /* line # 2628 */
            Rv0=((P_comp_type(((V *)((V *)Rv6)[0])[3],((V *)Rv6)[3],0)||P_comp_type((
            (V *)Rv6)[3],((V *)((V *)Rv6)[0])[3],0))&&P_comp_type(((V *)Rv6)[3],(
            (V *)((V *)Rv5)[3])[4],0))&&P_comp_type(((V *)((V *)Rv6)[0])[3],((V *)(
            (V *)Rv5)[3])[4],0);
            break;
            case 30:Ra.sl[8]=2634; /* line # 2634 */
            if (P_comp_type(((V *)((V *)Rv6)[0])[3],V_typ_std.v[19],0)) Rv0=P_comp_type((
            (V *)Rv6)[3],((V *)((V *)((V *)Rv6)[0])[3])[13],0)&&P_comp_type(((V *)(
            (V *)Rv6)[0])[3],((V *)((V *)Rv5)[3])[4],0);
            break;
            default:Ra.sl[8]=2641; /* line # 2641 */
            Rv0=0;
            break;
          }
        }
        if (!Rv0) {
          Ra.sl[8]=2646; /* line # 2646 */
          Rv0=1;
          while (Rv0&&Rv5!=NULL){
            Rv7=0;
            Rv8=Rv5;
            Ra.sl[8]=2651; /* line # 2651 */
            if (Rv1!=NULL) {
              Rv9=Rv1;
              if (((UB *)Rv9)[40]==17) {
                if (((V *)Rv8)[9]==NULL&&!(8192&((UW *)Rv8)[32])) {
                  Ra.sl[8]=2656; /* line # 2656 */
                  Rv0=0;
                }
                else {
                  Rv5=((V *)Rv8)[3];
                  Rv1=((V *)Rv9)[0];
                }
              }
              else {
                Ra.sl[8]=2663; /* line # 2663 */
                Rv10=P_comp_type(((V *)Rv9)[3],((V *)Rv8)[4],((UB *)Rv8)[66]!=8);
                if (!Rv10&&((UB *)Rv9)[40]==14) {
                  Ra.sl[8]=2668; /* line # 2668 */
                  Rv11=((V *)Rv8)[4];
                  switch (((UB *)Rv11)[92]) {
                    case 4:Ra.sl[8]=2677; /* line # 2677 */
                    if (((UB *)((V *)Rv9)[3])[92]==3) {
                      ((V *)Rv9)[3]=V_typ_std.v[4];
                      Rv10=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[8]=2701; /* line # 2701 */
                    if ((P_comp_type(((V *)Rv11)[14],V_typ_std.v[0],1)&&((UB *)(
                    (V *)Rv11)[15])[92]==2)&&((SL *)Rv11)[10]==0) {
                      if (P_comp_type(((V *)Rv9)[3],V_typ_std.v[10],0)) {
                        Ra.sl[8]=2707; /* line # 2707 */
                        if (((UB *)Rv11)[92]==8) {
                          Rv12=((V *)Rv11)[15];
                          Rv10=(((SL *)Rv12)[30]-((SL *)Rv12)[29])+1==((SL *)((V
                           *)Rv9)[7])[6];
                        }
                        else {
                          Ra.sl[8]=2712; /* line # 2712 */
                          Rv10=1;
                        }
                      }
                      else {
                        if (P_comp_type(((V *)Rv9)[3],V_typ_std.v[0],0)) {
                          if (((UB *)Rv11)[92]==9) Rv10=1;
                          else {
                            Ra.sl[8]=2717; /* line # 2717 */
                            Rv10=((SL *)Rv11)[30]==((SL *)Rv11)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[8]=2722; /* line # 2722 */
                if (Rv10) {
                  if (((V *)Rv8)[4]!=NULL) {
                    if (((UB *)((V *)Rv8)[4])[92]==9) Rv7=((SL *)((V *)Rv8)[4])[
24];
                  }
                  Ra.sl[8]=2727; /* line # 2727 */
                  Rv5=((V *)Rv8)[3];
                  Rv1=((V *)Rv9)[0];
                }
                else Rv0=0;
                if (Rv0) {
                  Ra.sl[8]=2733; /* line # 2733 */
                  if (((UB *)Rv8)[66]==8) {
                    if (!(1&((UW *)Rv9)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[8]=2738; /* line # 2738 */
                    if (4&((UW *)Rv9)[10]) {
                      if (32&((UW *)Rv8)[32]) {
                        if (!(1&((UW *)Rv9)[10])) Rv0=0;
                      }
                      if (64&((UW *)Rv8)[32]) {
                        Ra.sl[8]=2743; /* line # 2743 */
                        if (!(2&((UW *)Rv9)[10])) Rv0=0;
                      }
                    }
                    else {
                      if (64&((UW *)Rv8)[32]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[8]=2751; /* line # 2751 */
              if (((V *)Rv8)[9]==NULL&&!(8192&((UW *)Rv8)[32])) Rv0=0;
              else Rv5=((V *)Rv8)[3];
            }
            Ra.sl[8]=2756; /* line # 2756 */
            if (Rv7>0) while (1){
              Rv5=((V *)Rv5)[3];
              Rv7=Rv7-1;
              if (Rv7==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[8]=2763; /* line # 2763 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  if (!Rv0) {
    PAS_EXPSION_PRC_00000009();
    Ra.sl[8]=2768; /* line # 2768 */
    P_src_error_s(Rd.s+3430,113,3, F_id,NULL);
  }
  else Ra.sl[8]=2773; /* line # 2773 */
  PAS__curr_cntx=Ra.v[1];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3434;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2792; /* line # 2792 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  if (F_p!=NULL) {
    Rv1=F_p;
    Ra.sl[6]=2797; /* line # 2797 */
    if (((UB *)Rv1)[8]) {
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else Rv2=P_exp_val_bin(F_oblst, F_p);
      if (((V *)Rv2)[3]==V_typ_std.v[29]) ((V *)Rv2)[3]=((V *)F_oblst)[3];
    }
    else {
      Ra.sl[6]=2805; /* line # 2805 */
      Rv3=((V *)Rv1)[2];
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      if (((V *)Rv3)[11]==V_typ_std.v[29]) ((V *)Rv2)[3]=((V *)F_oblst)[3];
      Ra.sl[6]=2810; /* line # 2810 */
      P_call_setting(&Rv2);
    }
    Ret=Rv2;
  }
  else Ret=F_oblst;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3447;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2829; /* line # 2829 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Rv0=((V *)F_ip)[10];
  if (F_np<=0) {
    Rv1=F_lgp;
    Ra.sl[6]=2834; /* line # 2834 */
    while (Rv1!=NULL){
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Rv2=NULL;
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2839; /* line # 2839 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=2844; /* line # 2844 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      if (((V *)Rv3)[2]!=NULL) {
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        P_call_setting(&Rv2);
        Ra.sl[6]=2849; /* line # 2849 */
        if (((V *)((V *)Rv3)[2])[11]==V_typ_std.v[29]) ((V *)Rv2)[3]=((V *)F_lgp)
        [3];
      }
    }
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3462;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2860; /* line # 2860 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3473;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2875; /* line # 2875 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else Rv0=((V *)V_ope_table.v[28])[3];
  Rv1=((V *)F_prm)[0];
  Rv2=((UW *)F_prm)[10];
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=2880; /* line # 2880 */
  if (F_bovr) {
    ((UW *)F_prm)[10]=Rv2|3;
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=2885; /* line # 2885 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  if (F_bovr) {
    ((UW *)F_prm)[10]=Rv2;
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=2891; /* line # 2891 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
