/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define BASIC_IO   0
#include <sys/stat.h>
#define incr_ptr(p,inc) p += inc;
#define cc_wild_pointer( p ) ((V) p)
#define _Open(fn,fl,md) open((char *)(fn),fl,md)
#define _Openr(fn,fl,md) open((char *)(fn),fl,md,"rat=cr","rfm=var")
#define _Remove(fn) remove((char *)(fn))
#define _Getenv(lg) (C *)getenv((char *)(lg))
#define _Setenv(lg,vl,ovw) setenv((char *)(lg),(char *)(vl),ovw)
#define _UnSetenv(lg) unsetenv((char *)(lg))
#define _Putenv(lgl) putenv((char *)(lgl))
#define _Chdir(dir) chdir((char *)dir)
#define _Getdir(dir,sz) (C *)getcwd((char *)(dir),(size_t)(sz))
#define _Execv(f,p) execv((char *)(f),(char **)(p))
#define _Execvp(f,p) execvp((char *)(f),(char **)(p))
#define _Execve(f,p,e) execve((char *)(f),(char **)(p),(char **)(e))
#define _System(cm) system((char *)(cm))
#define _Pipe(chan) pipe((int *)(chan))
#define _Wait(proc) wait((int *)(proc))
#define _GetUid getuid
#define _GetGid getgid
#define _Access(f,acc) access((char *)(f),acc)
#define _Rename(o,n) rename((char *)(o),(char *)(n))
#define _Opendir( dn ) (void *) opendir( (char *)(dn))
#define _Closedir( df ) closedir( (DIR *) df )
#define _Readdir( df ) (void *) readdir( (DIR *)(df))
#define _ReadLink( l, t, s ) readlink( (char*) l, (char*) t, s )
#define _MakeDir( d, m ) mkdir( (char*) d, m )
#define _RemoveDir( d ) rmdir( (char*) d )
#define _Ttyname( df ) (C *)ttyname( df )

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 120 ) = {
 21,  21,  67,  80,  65,  83,  95,  80,  82,  73,  78,  84,  95,  65,  78,  68,
 95,  82,  69,  77,  79,  86,  69,  10,  10,  67,  80,  65,  83,  95,  80,  82,
 73,  78,  84,   0,   0,   6,   6,  95,  80,  73,  80,  69,  95,   0,   0,   2,
  2,  84,  84,   8,   8,  47, 100, 101, 118,  47, 116, 116, 121,   2,   2,  78,
 76,   9,   9,  47, 100, 101, 118,  47, 110, 117, 108, 108,   9,   9,  83,  89,
 83,  36,  73,  78,  80,  85,  84,  10,  10,  83,  89,  83,  36,  79,  85,  84,
 80,  85,  84,   9,   9,  83,  89,  83,  36,  69,  82,  82,  79,  82,   4,   4,
 80,  65,  84,  72,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 384 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0, 144,  32,   0,   2,  32,  32,  32,  32,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0, 145,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 146,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   1,   0,   0,   0,
  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0, 146,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 2304 );

/* Declaration of external variables. */

/* Declaration of global variables. */
V PAS__first_descr = NULL;
V PAS__last_descr = NULL;
V PAS__curr_iptr = NULL;
V PAS__curr_optr = NULL;
V PAS__f_input;
V PAS__f_output;
V PAS__f_error;
SL PAS__argc;
Blk(PAS__argv, 1032 );
V PAS__env;
SL PAS__iostatus;
Blk(PAS__fspc, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(PAS__file_info, 112 );
SL PAS__heap_isiz = 8192;
SL PAS__heap_incr = 1024;

/* Function/procedure prototypes. */
SL CC_ERROR();
SL CC_Get_File_Info(V F_fs, V F_tbi, SL F_sz, UB F_lnk, UB F_gmt);
SL CC_Get_File_Info(V F_fs, V F_tbi, SL F_sz, UB F_lnk, UB F_gmt);
SL CC_Get_Descr_Info(SL F_descr, V F_tbi, SL F_sz, UB F_lnk, UB F_gmt);
void CC_TRAP_INIT();
void PAS__ERROR(SL F_ierr);
void PAS__ins_proc(V *F_pp, void F_pr(V F_fp));
void PAS__exe_proc(V F_pp, V F_fp);


/* Procedure/Function : " pas_$new "  */
V PAS__NEW(SL F_size){
  register V Ret;

  /* Code of procedure/function */
  Ret=PAS__MEM_ALLOC(F_size);
  return(Ret);
}


/* Procedure/Function : " pas_$dispose "  */
void PAS__DISPOSE(V *F_ptr){

  /* Code of procedure/function */
  PAS__MEM_FREE((*F_ptr));
  (*F_ptr)=NULL;
}


/* Procedure/Function : " alloc_new_heap "  */
void PAS__STD_PRC_00000000(SL F_sz){
  /* Local variable stored in C variable */
  register SL Rv0;
  V Rv1;

  /* Code of procedure/function */
  if (PAS__heap_incr<128) PAS__heap_incr=128;
  F_sz=F_sz+20;
  F_sz=(((F_sz+PAS__heap_incr)-1)/PAS__heap_incr)*PAS__heap_incr;
  F_sz=(F_sz+7)/8;
  Rv0=F_sz;
  Rv1=PAS__NEW((Rv0+1)*8+24);
  ((SL *)Rv1)[0]=Rv0;
  ((SL *)Rv1)[1]=0;
  ((V *)Rv1)[1]=Ri.v[0];
  ((V *)Rv1)[2]=Ri.v[1];
  Ri.v[0]=Rv1;
}


/* Procedure/Function : " heap_alloc "  */
V PAS__HEAP_ALLOC(SL F_size){
  /* Local variable stored in C variable */
  register SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  if (Ri.v[0]==NULL) {
    if (PAS__heap_isiz<128) PAS__heap_isiz=128;
    Rv0=PAS__heap_isiz;
    Ri.v[0]=PAS__NEW((Rv0+1)*8+24);
    ((SL *)Ri.v[0])[0]=Rv0;
    Rv1=Ri.v[0];
    ((SL *)Rv1)[1]=0;
    ((V *)Rv1)[1]=NULL;
    ((V *)Rv1)[2]=NULL;
    Ri.v[1]=NULL;
  }
  Rv2=((SL *)Ri.v[0])[1];
  Rv3=(F_size+7)/8;
  Rv4=Rv2+Rv3;
  if (Rv4>=((SL *)Ri.v[0])[0]) {
    PAS__STD_PRC_00000000(Rv3);
    Rv4=Rv3;
    Rv2=0;
  }
  Rv5=Ri.v[0];
  ((SL *)Rv5)[1]=Rv4;
  Ret=cc_wild_pointer((((G *)Rv5)+Rv2+3));
  return(Ret);
}


/* Procedure/Function : " pas_$mark "  */
void PAS__MARK(){
  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  if (Ri.v[0]!=NULL) {
    Rv0=Ri.v[0];
    Rv1=((SL *)Ri.v[0])[1];
  }
  else {
    Rv0=NULL;
    Rv1=0;
  }
  Rv2=PAS__HEAP_ALLOC(20);
  Rv3=Rv2;
  ((V *)Rv3)[0]=Ri.v[1];
  if (Rv0==NULL) ((V *)Rv3)[1]=Ri.v[0];
  else((V *)Rv3)[1]=Rv0;
  ((SL *)Rv3)[4]=Rv1;
  Ri.v[1]=Rv2;
}


/* Procedure/Function : " pas_$release "  */
void PAS__RELEASE(){
  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;

  /* Code of procedure/function */
  if (Ri.v[0]!=NULL&&Ri.v[1]!=NULL) {
    Rv0=Ri.v[1];
    Rv1=((V *)Rv0)[0];
    Rv2=((V *)Rv0)[1];
    Rv3=((SL *)Rv0)[4];
    if (Rv2!=NULL&&Rv2!=Ri.v[0]) while (Rv2!=Ri.v[0]){
      Rv4=((V *)Ri.v[0])[1];
      PAS__DISPOSE(Ri.v);
      Ri.v[0]=Rv4;
    }
    ((SL *)Ri.v[0])[1]=Rv3;
    Ri.v[1]=Rv1;
  }
}


/* Procedure/Function : " pas__get_env "  */
SL PAS__GET_ENV_ARRAY(V *F_ptr, V F_src){
  /* Local variable stored in C variable */
  SL Rv0;
  C Rv1;
  SL Rv2;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=1;
  for( Rf0=((UB *)F_src)[1];Rf0>0;Rf0-- ) {
    Rv1=((C *)F_src)[Rv0+1];
    if (Rv1>=97&&Rv1<=122) Rv1=(C)((SL)Rv1-32);
    Rs.c[Rv0-1]=Rv1;
    Rv0++;
  }
  Rs.c[(((UB *)F_src)[1]+1)-1]=0;
  (*F_ptr)=_Getenv(Rs.s);
  if ((*F_ptr)==NULL) Rv2=-1;
  else {
    Rv2=0;
    while (((C *)(*F_ptr))[(Rv2+1)-1]!=0)
    Rv2=Rv2+1;
  }
  Ret=Rv2;
  return(Ret);
}


/* Procedure/Function : " pas_$getenv "  */
SL PAS__GETENV(V F_trg, V F_src){
  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  C Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=PAS__GET_ENV_ARRAY(&Rv1, F_src);
  if (Rv0<=0) ((UB *)F_trg)[1]=0;
  else {
    Rv2=1;
    while (1){
      Rv3=((C *)Rv1)[Rv2-1];
      if (Rv3==0||Rv2>((UB *)F_trg)[0])  break;
      ((C *)F_trg)[Rv2+1]=Rv3;
      Rv2=Rv2+1;
    }
    if (Rv2>((UB *)F_trg)[0]) Rv0=-2;
    else Rv0=0;
    ((UB *)F_trg)[1]=Rv2-1;
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " set_env "  */
SL PAS__STD_set_env(V F_log, V F_val, SL F_sz1, SL F_sz2, SL F_ovr){
  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  C Rv3;
  SL Rv4;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  if (F_sz1>0) {
    Rv0=F_sz1+1;
    if (F_sz2>0) Rv0=(Rv0+F_sz2)+1;
    Rv1=PAS__MEM_ALLOC(Rv0);
    Rv2=0;
    for( Rf0=(F_sz1-1)+1;Rf0>0;Rf0-- ) {
      Rv3=((C *)F_log)[Rv2];
      if (Rv3>=97&&Rv3<=122) Rv3=(C)((SL)Rv3-32);
      ((C *)Rv1)[Rv2]=Rv3;
      Rv2++;
    }
    ((C *)Rv1)[F_sz1]=0;
    if (F_sz2>0) {
      if (F_ovr==0) {
        if (_Getenv(Rv1)!=NULL) {
          PAS__MEM_FREE(Rv1);
          Ret=0;
          goto Ret_Label;
        }
      }
      Rv0=F_sz1;
      ((C *)Rv1)[Rv0]=61;
      Rv0=Rv0+1;
      Rv4=0;
      for( Rf0=(F_sz2-1)+1;Rf0>0;Rf0-- ) {
        ((C *)Rv1)[Rv0]=((C *)F_val)[Rv4];
        Rv0=Rv0+1;
        Rv4++;
      }
      ((C *)Rv1)[Rv0]=0;
    }
    Ret=_Putenv(Rv1);
    goto Ret_Label;
  }
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " pas__set_env "  */
SL PAS__SET_ENV_ARRAY(V F_log, V F_val, SL F_dim, SL F_sz, SL F_ovr){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (F_sz<0||F_sz>F_dim) F_sz=F_dim;
  if (F_sz<=0) PAS__STD_set_env(F_log+2,NULL,((UB *)F_log)[1],0,1);
  else Rv0=PAS__STD_set_env(F_log+2,F_val,((UB *)F_log)[1],F_sz, F_ovr);
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " pas_$setenv "  */
SL PAS__SETENV(V F_log, V F_val, SL F_ovr){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (((UB *)F_val)[1]<=0) PAS__STD_set_env(F_log+2,NULL,((UB *)F_log)[1],0,1);
  else Rv0=PAS__STD_set_env(F_log+2,F_val+2,((UB *)F_log)[1],((UB *)F_val)[1],F_ovr);
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " vread_end "  */
void PAS__STD_vread_end(V F_fp){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );


  /* Code of procedure/function */
  Ra.v[0]=Ri.v[6];
  if (Ri.sl[21]>0) {
    if (Ri.v[6]!=NULL) ((SL *)Ra.v[0])[0]=(Ri.sl[20]-Ri.sl[21])+1;
  }
  else {
    Ri.sl[21]=0;
    Ri.v[2]=Ri.s+104;
    Ri.ul[25]=Ri.ul[25]|184549376;
    if (Ri.v[6]!=NULL) ((SL *)Ra.v[0])[0]=-1;
  }
}


/* Procedure/Function : " vread_init "  */
void PAS__VREAD_INIT(V F_str, SL F_sz, SL *F_ip){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  if (((V) F_ip)!=NULL) Rv0=(*F_ip);
  else Rv0=1;
  Ri.v[2]=(((C *)F_str)+Rv0-1);
  Ri.v[3]=F_str;
  Ri.v[6]=((V) F_ip);
  Ri.v[8]=F_str;
  PAS__ins_proc(Ri.v+7,PAS__STD_vread_end);
  Ri.sl[20]=F_sz;
  Ri.sl[21]=(F_sz-Rv0)+1;
  Ri.ul[25]=8337;
  PAS__curr_iptr=Ri.s+16;
}


/* Procedure/Function : " twrite_end "  */
void PAS__STD_twrite_end(V F_fp){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=Ri.v[6];
  if (Ri.v[6]!=NULL) ((SL *)Ra.v[0])[0]=Ri.sl[21];
  else {
    Rv0=Ri.sl[21]+1;
    for( Rf0=(Ri.sl[20]+1)-(Ri.sl[21]+1);Rf0>0;Rf0-- ) {
      ((C *)Ri.v[3])[Rv0]=32;
      Rv0++;
    }
  }
  if (33554432&Ri.ul[25]) PAS__ERROR(54);
  else Ri.ul[25]=Ri.ul[25]|167772160;
}


/* Procedure/Function : " twrite_init "  */
void PAS__TWRITE_INIT(V F_str, SL F_sz, SL *F_ip){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  if (((V) F_ip)!=NULL) Rv0=(*F_ip);
  else Rv0=0;
  Ri.v[2]=(((C *)F_str)+(Rv0+1)-1);
  Ri.v[3]=F_str;
  Ri.v[6]=((V) F_ip);
  Ri.v[8]=F_str;
  PAS__ins_proc(Ri.v+7,PAS__STD_twrite_end);
  Ri.sl[20]=F_sz;
  Ri.sl[21]=Rv0;
  Ri.ul[25]=8338;
  PAS__curr_optr=Ri.s+16;
}


/* Procedure/Function : " vwrite_end "  */
void PAS__STD_vwrite_end(V F_fp){

  /* Code of procedure/function */
  ((UB *)Ri.v[8])[1]=Ri.sl[21];
  if (33554432&Ri.ul[25]) PAS__ERROR(54);
  else Ri.ul[25]=Ri.ul[25]|167772160;
}


/* Procedure/Function : " vwrite_init "  */
void PAS__VWRITE_INIT(V F_str, UB F_bini){

  /* Code of procedure/function */
  Ri.v[3]=F_str+2;
  Ri.v[8]=F_str;
  PAS__ins_proc(Ri.v+7,PAS__STD_vwrite_end);
  Ri.sl[20]=((UB *)F_str)[0];
  if (F_bini) {
    Ri.v[2]=F_str+2;
    Ri.sl[21]=0;
  }
  else {
    Ri.v[2]=(((C *)F_str)+(((UB *)F_str)[1]+1)+1);
    Ri.sl[21]=((UB *)F_str)[1];
  }
  Ri.ul[25]=8338;
  PAS__curr_optr=Ri.s+16;
}


/* Procedure/Function : " buffer_map "  */
void P_buffer_map(V F_fp, SL F_ibuf){
  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=F_fp;
  if (8&((UL *)Rv0)[21]&&((SL *)Rv0)[17]>0) {
    Rv1=lseek(((SL *)Rv0)[14],((SL *)Rv0)[20]*((SL *)Rv0)[16],SEEK_SET);
    Rv2=write(((SL *)Rv0)[14],((V *)Rv0)[1],((SL *)Rv0)[17]);
    ((UL *)Rv0)[21]=(((UL *)Rv0)[21]|67108864)&~8;
  }
  if (F_ibuf>=0) {
    ((SL *)Rv0)[20]=lseek(((SL *)Rv0)[14],F_ibuf*((SL *)Rv0)[16],SEEK_SET)/((SL *)
    Rv0)[16];
    if (1&((UL *)Rv0)[21]) Rv2=read(((SL *)Rv0)[14],((V *)Rv0)[1],((SL *)Rv0)[16]
    );
    else Rv2=0;
    ((SL *)Rv0)[17]=Rv2;
    if (Rv2<0) PAS__ERROR(CC_ERROR());
    else {
      if (Rv2==0) ((UL *)Rv0)[21]=((UL *)Rv0)[21]|134217728;
      else((UL *)Rv0)[21]=((UL *)Rv0)[21]&~201326592;
      ((V *)Rv0)[0]=((V *)Rv0)[1];
      ((SL *)Rv0)[19]=0;
      if (2&((UL *)Rv0)[21]) {
        Rv3=Rv2;
        for( Rf0=((((SL *)Rv0)[16]-1)+1)-Rv2;Rf0>0;Rf0-- ) {
          ((C *)((V *)Rv0)[1])[Rv3]=0;
          Rv3++;
        }
      }
      ((SL *)Rv0)[18]=Rv2;
    }
  }
}


/* Procedure/Function : " uget_elem "  */
void PAS__STD_uget_elem(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=F_fp;
  ((SL *)Rv0)[19]=((SL *)Rv0)[19]+((SL *)Rv0)[15];
  ((SL *)Rv0)[18]=((SL *)Rv0)[18]-((SL *)Rv0)[15];
  if (((SL *)Rv0)[18]<=0) {
    if (((SL *)Rv0)[17]<((SL *)Rv0)[16]) ((UL *)Rv0)[21]=((UL *)Rv0)[21]|134217728;
    else P_buffer_map(F_fp,((SL *)Rv0)[20]+1);
  }
  else incr_ptr(((V *)Rv0)[0],((SL *)Rv0)[15]);
}


/* Procedure/Function : " uput_elem "  */
void PAS__STD_uput_elem(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=F_fp;
  ((UL *)Rv0)[21]=((UL *)Rv0)[21]|8;
  ((SL *)Rv0)[19]=((SL *)Rv0)[19]+((SL *)Rv0)[15];
  if (((SL *)Rv0)[19]>((SL *)Rv0)[17]) {
    ((SL *)Rv0)[18]=(((SL *)Rv0)[18]+((SL *)Rv0)[19])-((SL *)Rv0)[17];
    ((SL *)Rv0)[17]=((SL *)Rv0)[19];
  }
  if (((SL *)Rv0)[19]>=((SL *)Rv0)[16]) P_buffer_map(F_fp,((SL *)Rv0)[20]+1);
  else {
    incr_ptr(((V *)Rv0)[0],((SL *)Rv0)[15]);
    ((SL *)Rv0)[18]=((SL *)Rv0)[18]-((SL *)Rv0)[15];
  }
}


/* Procedure/Function : " pas_$seek "  */
void PAS__SEEK(V F_fp, SL F_irec){
  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (4&((UL *)Rv0)[21]) {
      F_irec=F_irec-1;
      Rv1=((SL *)Rv0)[16]/((SL *)Rv0)[15];
      Rv2=F_irec/Rv1;
      Rv3=F_irec-Rv2*Rv1;
      if (Rv2!=((SL *)Rv0)[20]) P_buffer_map(F_fp, Rv2);
      ((SL *)Rv0)[19]=((SL *)Rv0)[15]*Rv3;
      if (((SL *)Rv0)[19]>((SL *)Rv0)[17]) ((SL *)Rv0)[17]=((SL *)Rv0)[19];
      ((SL *)Rv0)[18]=((SL *)Rv0)[17]-((SL *)Rv0)[19];
      ((V *)Rv0)[0]=(((C *)((V *)Rv0)[1])+((SL *)Rv0)[19]);
      if (((SL *)Rv0)[18]<=0) ((UL *)Rv0)[21]=((UL *)Rv0)[21]|134217728;
      else((UL *)Rv0)[21]=((UL *)Rv0)[21]&~134217728;
    }
    else PAS__ERROR(101);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " put_buffer "  */
void PAS_put_buffer(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Rv0=F_fp;
  Rv1=((SL *)Rv0)[17];
  if (Rv1>0) {
    Rv2=write(((SL *)Rv0)[14],((V *)Rv0)[1],Rv1);
    if (Rv2==-1) PAS__ERROR(CC_ERROR());
  }
  ((V *)Rv0)[0]=((V *)Rv0)[1];
  ((UL *)Rv0)[21]=((UL *)Rv0)[21]&~134217736;
  ((SL *)Rv0)[17]=0;
}


/* Procedure/Function : " put_file_elem "  */
void PAS__STD_put_file_elem(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=F_fp;
  if (4&((UL *)Rv0)[21]) PAS__STD_uput_elem(F_fp);
  else {
    ((SL *)Rv0)[17]=((SL *)Rv0)[17]+((SL *)Rv0)[15];
    if (((SL *)Rv0)[17]>=((SL *)Rv0)[16]) {
      if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],F_fp);
      else PAS_put_buffer(F_fp);
    }
    else {
      if (((!(8192&((UL *)Rv0)[21])&&16&((UL *)Rv0)[21])&&(3200&((UL *)Rv0)[21])
      !=0)&&((C *)((V *)Rv0)[0])[0]==10) PAS_put_buffer(F_fp);
      else {
        ((UL *)Rv0)[21]=((UL *)Rv0)[21]|8;
        incr_ptr(((V *)Rv0)[0],((SL *)Rv0)[15]);
      }
    }
  }
}


/* Procedure/Function : " put_elem "  */
void PAS__PUT(V F_fp){

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    if (2&((UL *)F_fp)[21]) PAS__STD_put_file_elem(F_fp);
    else PAS__ERROR(111);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " flush_assoc_term "  */
void PAS__STD_flush_assoc_term(V F_fp){
  /* Local variable stored in C variable */
  V Rv0;
  register int Rgi;

  /* Code of procedure/function */
  Rv0=((V *)F_fp)[4];
  while (Rv0!=NULL&&Rv0!=F_fp){
    if (26==(26&((UL *)Rv0)[21])) PAS_put_buffer(Rv0);
    Rv0=((V *)Rv0)[4];
  }
}


/* Procedure/Function : " get_buffer "  */
void PAS_get_buffer(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Rv0=F_fp;
  if (!(4&((UL *)Rv0)[21])) {
    if (16&((UL *)Rv0)[21]) {
      if (((V *)Rv0)[4]!=NULL) PAS__STD_flush_assoc_term(F_fp);
    }
    else {
      if (8&((UL *)Rv0)[21]) PAS_put_buffer(F_fp);
    }
  }
  if (1024&((UL *)Rv0)[21]) ((UL *)Rv0)[21]=((UL *)Rv0)[21]&~134217728;
  if (134217728&((UL *)Rv0)[21]) ((SL *)Rv0)[17]=-1;
  else {
    ((V *)Rv0)[0]=((V *)Rv0)[1];
    ((UL *)Rv0)[21]=((UL *)Rv0)[21]&~83886080;
    Rv1=read(((SL *)Rv0)[14],((V *)Rv0)[1],((SL *)Rv0)[16]);
    if (Rv1<0) PAS__ERROR(CC_ERROR());
    if (Rv1==0) {
      if (16&((UL *)Rv0)[21]) {
        ((UL *)Rv0)[21]=((UL *)Rv0)[21]|150994944;
        ((C *)((V *)Rv0)[0])[0]=10;
        Rv1=1;
      }
      else((UL *)Rv0)[21]=((UL *)Rv0)[21]|134217728;
    }
    ((SL *)Rv0)[17]=Rv1;
  }
}


/* Procedure/Function : " get_file_elem "  */
void PAS__STD_get_file_elem(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Rv0=F_fp;
  if (4&((UL *)Rv0)[21]) PAS__STD_uget_elem(F_fp);
  else {
    if (1024&((UL *)Rv0)[21]||!(134217728&((UL *)Rv0)[21])) {
      Rv1=((SL *)Rv0)[17]-((SL *)Rv0)[15];
      if (Rv1>0) {
        ((SL *)Rv0)[17]=Rv1;
        incr_ptr(((V *)Rv0)[0],((SL *)Rv0)[15]);
        if (16&((UL *)Rv0)[21]) {
          if (((C *)((V *)Rv0)[0])[0]==10) {
            ((UL *)Rv0)[21]=((UL *)Rv0)[21]|16777216;
            if (8192&((UL *)Rv0)[21]) ((C *)((V *)Rv0)[0])[0]=32;
          }
          else((UL *)Rv0)[21]=((UL *)Rv0)[21]&~16777216;
        }
      }
      else {
        if (16&((UL *)Rv0)[21]) {
          if (!(256&((UL *)Rv0)[21])||67108864&((UL *)Rv0)[21]) {
            ((SL *)Rv0)[17]=0;
            if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],F_fp);
            else PAS_get_buffer(F_fp);
            if (((SL *)Rv0)[17]>0) {
              if (((C *)((V *)Rv0)[0])[0]==10) {
                ((UL *)Rv0)[21]=((UL *)Rv0)[21]|16777216;
                ((C *)((V *)Rv0)[0])[0]=32;
              }
              else((UL *)Rv0)[21]=((UL *)Rv0)[21]&~16777216;
            }
            if (((SL *)Rv0)[17]<0) PAS__ERROR(104);
          }
          else {
            ((SL *)Rv0)[17]=0;
            if (Rv1==0) ((V *)Rv0)[0]=Ri.s+104;
            ((UL *)Rv0)[21]=(((UL *)Rv0)[21]|67108864)&~16777216;
          }
        }
        else {
          if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],F_fp);
          else PAS_get_buffer(F_fp);
          if (((SL *)Rv0)[17]<0) PAS__ERROR(104);
        }
      }
    }
    else PAS__ERROR(104);
  }
}


/* Procedure/Function : " get_elem "  */
void PAS__GET(V F_fp){

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    if (1&((UL *)F_fp)[21]) PAS__STD_get_file_elem(F_fp);
    else PAS__ERROR(105);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " pas_read_char "  */
void PAS__STD_pas_read_char(V F_fp, C *F_ch){
  /* Local variable stored in C variable */
  register V Rv0;
  register int Rgi;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (17==(17&((UL *)Rv0)[21])) {
      if (67108864&((UL *)Rv0)[21]) PAS__STD_get_file_elem(F_fp);
      (*F_ch)=((C *)((V *)Rv0)[0])[0];
      PAS__STD_get_file_elem(F_fp);
    }
    else PAS__ERROR(108);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " read_char "  */
void PAS__READ_CHAR(C *F_ch){

  /* Code of procedure/function */
  PAS__STD_pas_read_char(PAS__curr_iptr, F_ch);
}


/* Procedure/Function : " next_char "  */
void PAS__NEXT_CHAR(V F_fp, C *F_ch){
  /* Local variable stored in C variable */
  register V Rv0;
  register int Rgi;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (17==(17&((UL *)Rv0)[21])) {
      if ((251658240&((UL *)Rv0)[21])!=0) (*F_ch)=0;
      else (*F_ch)=((C *)((V *)Rv0)[0])[0];
    }
    else PAS__ERROR(108);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " test_eoln "  */
UB PAS__EOLN(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register int Rgi;
  register UB Ret;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (17==(17&((UL *)Rv0)[21])) {
      Rv1=(16777216&((UL *)Rv0)[21])!=0;
      if (!(134217728&((UL *)Rv0)[21])) {
        if (67108864&((UL *)Rv0)[21]) {
          PAS__STD_get_file_elem(F_fp);
          Rv1=(16777216&((UL *)Rv0)[21])!=0;
        }
      }
    }
    else PAS__ERROR(110);
  }
  else PAS__ERROR(100);
  Ret=Rv1;
  return(Ret);
}


/* Procedure/Function : " test_eoln1 "  */
UB PAS__EOLN_INP(){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__EOLN(PAS__f_input);
  return(Ret);
}


/* Procedure/Function : " test_ufb "  */
UB PAS__UFB(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (1&((UL *)Rv0)[21]) Rv1=(67108864&((UL *)Rv0)[21])!=0;
    else PAS__ERROR(106);
  }
  else PAS__ERROR(100);
  Ret=Rv1;
  return(Ret);
}


/* Procedure/Function : " test_ufb1 "  */
UB PAS__UFB_INP(){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__UFB(PAS__f_input);
  return(Ret);
}


/* Procedure/Function : " test_eof "  */
UB PAS__EOF(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register int Rgi;
  register UB Ret;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (1&((UL *)Rv0)[21]) {
      Rv1=(134217728&((UL *)Rv0)[21])!=0;
      if (!Rv1) {
        if (67108880==(67108880&((UL *)Rv0)[21])) {
          PAS__STD_get_file_elem(F_fp);
          Rv1=(134217728&((UL *)Rv0)[21])!=0;
        }
      }
    }
    else PAS__ERROR(106);
  }
  else PAS__ERROR(100);
  Ret=Rv1;
  return(Ret);
}


/* Procedure/Function : " test_eof1 "  */
UB PAS__EOF_INP(){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__EOF(PAS__f_input);
  return(Ret);
}


/* Procedure/Function : " test_curr_eoln "  */
UB PAS__CURR_EOLN(){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__EOLN(PAS__curr_iptr);
  return(Ret);
}


/* Procedure/Function : " test_curr_eof "  */
UB PAS__CURR_EOF(){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__EOF(PAS__curr_iptr);
  return(Ret);
}


/* Procedure/Function : " pas_read_eoln "  */
void PAS__STD_pas_read_eoln(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  register int Rgi;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (17==(17&((UL *)Rv0)[21])) {
      if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],F_fp);
      else {
        if (67108864&((UL *)Rv0)[21]) PAS_get_buffer(F_fp);
        while (!(16777216&((UL *)Rv0)[21]))
        PAS__STD_get_file_elem(F_fp);
        if (!(134217728&((UL *)Rv0)[21])) PAS__STD_get_file_elem(F_fp);
      }
    }
    else PAS__ERROR(108);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " read_eoln "  */
void PAS__READ_EOLN(){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  if (PAS__curr_iptr!=NULL) {
    Rv0=PAS__curr_iptr;
    if (32&((UL *)Rv0)[21]) {
      if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],PAS__curr_iptr);
      else PAS_get_buffer(PAS__curr_iptr);
    }
    else PAS__STD_pas_read_eoln(PAS__curr_iptr);
  }
}


/* Procedure/Function : " read_bin "  */
void PAS__READ_BIN(V F_vp){
  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register int Rgi;
  register int Rf0;

  /* Code of procedure/function */
  if (PAS__curr_iptr!=NULL) {
    Rv0=PAS__curr_iptr;
    if (33==(33&((UL *)Rv0)[21])) {
      Rv1=((V *)Rv0)[0];
      Rv2=0;
      for( Rf0=(((SL *)Rv0)[15]-1)+1;Rf0>0;Rf0-- ) {
        ((C *)F_vp)[Rv2]=((C *)Rv1)[0];
        incr_ptr(Rv1,1);
        Rv2++;
      }
      PAS__STD_get_file_elem(PAS__curr_iptr);
    }
    else PAS__ERROR(107);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " pas_write_char "  */
void PAS__STD_pas_write_char(V F_fp, C F_ch){
  /* Local variable stored in C variable */
  register V Rv0;
  register int Rgi;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (18==(18&((UL *)Rv0)[21])) {
      ((C *)((V *)Rv0)[0])[0]=F_ch;
      PAS__STD_put_file_elem(F_fp);
    }
    else PAS__ERROR(114);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " write_eoln "  */
void PAS__WRITE_EOLN(){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  if (PAS__curr_optr!=NULL) {
    Rv0=PAS__curr_optr;
    if (32&((UL *)Rv0)[21]||PAS__curr_optr==Ri.s+16) {
      if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],PAS__curr_optr);
      else PAS_put_buffer(PAS__curr_optr);
    }
    else PAS__STD_pas_write_char(PAS__curr_optr,10);
  }
}


/* Procedure/Function : " write_char "  */
void PAS__WRITE_CHAR(C F_ch){

  /* Code of procedure/function */
  PAS__STD_pas_write_char(PAS__curr_optr, F_ch);
}


/* Procedure/Function : " write_bin "  */
void PAS__WRITE_BIN(V F_vp){
  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register int Rgi;
  register int Rf0;

  /* Code of procedure/function */
  if (PAS__curr_optr!=NULL) {
    Rv0=PAS__curr_optr;
    if (34==(34&((UL *)Rv0)[21])) {
      Rv1=((V *)Rv0)[0];
      Rv2=0;
      for( Rf0=(((SL *)Rv0)[15]-1)+1;Rf0>0;Rf0-- ) {
        ((C *)Rv1)[0]=((C *)F_vp)[Rv2];
        incr_ptr(Rv1,1);
        Rv2++;
      }
      PAS__STD_put_file_elem(PAS__curr_optr);
    }
    else PAS__ERROR(112);
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " pas_unassociated_file "  */
void PAS__STD_pas_unassociated_file(V F_fp){
  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Rv0=((V *)F_fp)[4];
  if (Rv0!=NULL&&Rv0!=F_fp) {
    while (Rv0!=NULL&&Rv0!=F_fp){
      Rv1=Rv0;
      Rv0=((V *)Rv0)[4];
    }
    ((V *)Rv1)[4]=((V *)F_fp)[4];
    if (((V *)Rv1)[4]==Rv1) ((V *)Rv1)[4]=NULL;
  }
  ((V *)F_fp)[4]=NULL;
}


/* Procedure/Function : " file_close "  */
void PAS__file_close(V *F_fp, UL F_disp){
  /* Define the automatic variable space. */
  Blk( Ra, 776 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rgi;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  if ((*F_fp)!=NULL) {
    Rv0=(*F_fp);
    if (2&((UL *)Rv0)[21]&&((SL *)Rv0)[17]>0) {
      if (4&((UL *)Rv0)[21]) P_buffer_map((*F_fp),-1);
      else {
        if (1040==(1040&((UL *)Rv0)[21])) PAS__STD_pas_write_char((*F_fp),10);
        if (8192&((UL *)Rv0)[21]) PAS__exe_proc(((V *)Rv0)[5],(*F_fp));
        else PAS_put_buffer((*F_fp));
      }
    }
    ((SL *)Rv0)[17]=0;
    if (!(128&((UL *)Rv0)[21])) {
      if (((V *)Rv0)[4]!=NULL) PAS__STD_pas_unassociated_file((*F_fp));
      if (((SL *)Rv0)[14]!=-1) close(((SL *)Rv0)[14]);
      PAS__iostatus=0;
      if (1024&F_disp) ((UL *)Rv0)[21]=((UL *)Rv0)[21]|65536;
      if (2048&F_disp) ((UL *)Rv0)[21]=((UL *)Rv0)[21]|131072;
      if ((((UL *)Rv0)[21]&66048)==66048) {
        if (131072&((UL *)Rv0)[21]) {
          Rv1=PAS__GETENV(Ra.s,Rd.s);
          if (Rv1!=0) PAS__iostatus=150;
        }
        else {
          Rv1=PAS__GETENV(Ra.s,Rd.s+23);
          if (Rv1!=0) PAS__iostatus=151;
        }
        if (Rv1==0) {
          PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+514,PAS__CON_STR_CHA(Ra.s+257,
          Ra.s,32), PAS__fspc.s));
          Rv1=PAS__CREATE_PROC_1(Rd.s+35,Ra.s,0,NULL);
          if (Rv1>0) PAS__WAIT_PROCESS(&Rv1,0);
        }
      }
      else {
        if (131072&((UL *)Rv0)[21]) {
          if (_Remove(PAS__fspc.s+2)!=0) PAS__iostatus=CC_ERROR();
        }
      }
      if (PAS__iostatus!=0&&!(4096&F_disp)) PAS__ERROR(PAS__iostatus);
      if (((V *)Rv0)[1]!=NULL) {
        PAS__DISPOSE(((V *)Rv0)+1);
        ((V *)Rv0)[1]=NULL;
      }
      if (((V *)Rv0)[6]!=NULL) {
        PAS__DISPOSE(((V *)Rv0)+6);
        ((V *)Rv0)[6]=NULL;
      }
      PAS__DISPOSE(F_fp);
      (*F_fp)=NULL;
    }
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " pas_$close "  */
void PAS__CLOSE(V *F_fp, UL F_idisp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  if ((*F_fp)!=NULL) {
    Rv0=(*F_fp);
    if (!(128&((UL *)Rv0)[21])) {
      if (((V *)Rv0)[3]!=NULL) ((V *)((V *)Rv0)[3])[2]=((V *)Rv0)[2];
      if (((V *)Rv0)[2]!=NULL) ((V *)((V *)Rv0)[2])[3]=((V *)Rv0)[3];
      if ((*F_fp)==PAS__last_descr) PAS__last_descr=((V *)Rv0)[3];
    }
    PAS__file_close(F_fp,F_idisp);
    if ((*F_fp)==PAS__curr_iptr) PAS__curr_iptr=PAS__f_input;
    else {
      if ((*F_fp)==PAS__curr_optr) PAS__curr_optr=PAS__f_output;
    }
    if (!(128&((UL *)Rv0)[21])) (*F_fp)=NULL;
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " set_filedef "  */
UB PAS__SET_FILEDEF(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 776 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  SL Rv2;
  C Rv3;
  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Rv0=1;
  if (((C *)F_str)[2]!=47) Rv1=PAS__INDEX_CHA(F_str+2,(SL)((UB *)F_str)[1],58)!=
0;
  else Rv1=1;
  if (!Rv1) {
    PAS__STR_TO_STR(Ra.s,PAS__GET_DEF_DIR(Ra.s+257));
    Rv2=Ra.ub[1];
    if (Rv2>0) {
      if (Ra.c[Rv2+1]!=47) {
        Rv2=Rv2+1;
        PAS__STR_TO_STR(Ra.s,PAS__CON_STR_CHA(Ra.s+257,Ra.s,47));
      }
      Rv3=47;
      if (((C *)F_str)[2]==46&&((C *)F_str)[3]==Rv3) {
        Rv2=(Rv2+((UB *)F_str)[1])-2;
        PAS__STR_TO_STR(F_str,PAS__CON_STR_STR(Ra.s+514,Ra.s,PAS__SUBSTR_STR(Ra.
        s+257,F_str,3,0)));
      }
      else {
        Rv2=Rv2+((UB *)F_str)[1];
        PAS__STR_TO_STR(F_str,PAS__CON_STR_STR(Ra.s+257,Ra.s,F_str));
      }
      if (Rv2>((UB *)F_str)[0]) Rv0=0;
    }
    else Rv0=0;
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " set_filespc "  */
UB PAS__SET_FILESPC(V F_trg, V F_src, UL F_imod){
  /* Define the automatic variable space. */
  Blk( Ra, 264 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  C Rv3;
  UB Rv4;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Rv0=0;
  Rv1=0;
  Rv2=1;
  for( Rf0=((UB *)F_src)[1];Rf0>0;Rf0-- ) {
    Rv3=((C *)F_src)[Rv2+1];
    if (Rv3==0)  break;
    if (65536&F_imod) {
      if (Rv3>=65&&Rv3<=90) Rv3=(C)((SL)Rv3+32);
    }
    if (Rv3==32) {
      if (Rv1==0) Rv1=Rv2-1;
    }
    else Rv1=0;
    if (Rv3>=32) {
      Rv0=Rv0+1;
      Ra.c[Rv0+1]=Rv3;
    }
    Rv2++;
  }
  if (Rv1==0) Ra.ub[1]=Rv0;
  else Ra.ub[1]=Rv1;
  Rv4=1;
  if (!(32768&F_imod)) Rv4=PAS__GETPHYSIC(F_trg,Ra.s)==0;
  else PAS__STR_TO_STR(F_trg,Ra.s);
  if (((UB *)F_trg)[1]>0) {
    PAS__SET_FILEDEF(F_trg);
    if (((UB *)F_trg)[1]>=((UB *)F_trg)[0]) {
      ((UB *)F_trg)[1]=((UB *)F_trg)[0]-1;
      Rv4=0;
    }
    ((C *)F_trg)[(((UB *)F_trg)[1]+1)+1]=0;
  }
  Ret=Rv4;
  return(Ret);
}


/* Procedure/Function : " associate_inter_files "  */
void PAS__ASS_INTERACTIVE_FILES(V F_fd){
  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;

  /* Code of procedure/function */
  if (F_fd!=NULL) {
    Rv0=F_fd;
    if ((3072&((UL *)Rv0)[21])!=0) {
      Rv1=((V *)Rv0)[6];
      Rv2=NULL;
      Rv3=PAS__first_descr;
      while (Rv3!=NULL&&Rv2==NULL){
        if (Rv3!=F_fd&&(3072&((UL *)Rv3)[21])!=0) {
          if (PAS__EQ_STR(((V *)Rv3)[6],Rv1)) Rv2=Rv3;
        }
        Rv3=((V *)Rv3)[2];
      }
      if (Rv2!=NULL) {
        if (((V *)Rv2)[4]==NULL) ((V *)Rv0)[4]=Rv2;
        else((V *)Rv0)[4]=((V *)Rv2)[4];
        ((V *)Rv2)[4]=F_fd;
      }
    }
  }
  else PAS__ERROR(100);
}


/* Procedure/Function : " file_kind "  */
SL PAS__FILE_KIND(SL F_imod){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  if (S_ISDIR(F_imod)!=0) Rv0=0;
  else {
    if (S_ISREG(F_imod)!=0) Rv0=1;
    else {
      if (S_ISLNK(F_imod)!=0) Rv0=2;
      else {
        if (S_ISCHR(F_imod)!=0) Rv0=3;
        else {
          if (S_ISBLK(F_imod)!=0) Rv0=4;
          else {
            if (S_ISFIFO(F_imod)!=0) Rv0=5;
            else {
              if (S_ISSOCK(F_imod)!=0) Rv0=6;
              else Rv0=-1;
            }
          }
        }
      }
    }
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " gf_info "  */
SL PAS__GF_INFO(V F_fst, V F_tbi, SL F_ss, UB F_lnk, UB F_gmt, UL F_umsk){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  if (!PAS__SET_FILESPC(PAS__fspc.s,F_fst,F_umsk)) Rv0=121;
  else {
    if (PAS__fspc.ub[1]==0) Rv0=201;
    else Rv0=CC_Get_File_Info(PAS__fspc.s+2,F_tbi,F_ss, F_lnk, F_gmt);
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " fspc_get_kind "  */
SL PAS__FSPC_GET_KIND(V F_spc, UB F_lnk, UB F_gmt, UL F_umsk){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=PAS__GF_INFO(F_spc,PAS__file_info.s,28, F_lnk, F_gmt, F_umsk);
  if (Rv0==0) Ret=PAS__FILE_KIND(PAS__file_info.sl[0]);
  else Ret=-10;
  return(Ret);
}


/* Procedure/Function : " get_kind_of_file "  */
SL PAS__STD_get_kind_of_file(SL F_c_file){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=CC_Get_Descr_Info(F_c_file, PAS__file_info.s,28,0,0);
  if (Rv0==0) Ret=PAS__FILE_KIND(PAS__file_info.sl[0]);
  else Ret=-10;
  return(Ret);
}


/* Procedure/Function : " init_a_file "  */
void PAS__STD_init_a_file(V F_fd, V F_pfspc){
  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Rv2;
  register V Rv3;
  SL Rv4;
  V Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=0;
  Rv1=F_fd;
  if (PAS__first_descr==NULL) PAS__first_descr=F_fd;
  else((V *)PAS__last_descr)[2]=F_fd;
  ((V *)Rv1)[2]=NULL;
  ((V *)Rv1)[3]=PAS__last_descr;
  PAS__last_descr=F_fd;
  switch (PAS__STD_get_kind_of_file(((SL *)Rv1)[14])) {
    case 3:((UL *)Rv1)[21]=((UL *)Rv1)[21]|256;
    break;
    case 4:((UL *)Rv1)[21]=((UL *)Rv1)[21]|512;
    break;
    case 5:((UL *)Rv1)[21]=((UL *)Rv1)[21]|2304;
    break;
    case 6:((UL *)Rv1)[21]=((UL *)Rv1)[21]|6400;
    break;
    default:break;
  }
  if ((6144&((UL *)Rv1)[21])==0) {
    if (isatty(((SL *)Rv1)[14])!=0) {
      ((UL *)Rv1)[21]=((UL *)Rv1)[21]|1280;
      Rv0=1;
    }
  }
  Rv2=((UB *)F_pfspc)[1]+1;
  ((V *)Rv1)[6]=PAS__NEW((SL)Rv2+2);
  ((UB *)((V *)Rv1)[6])[0]=Rv2;
  Rv3=((V *)Rv1)[6];
  ((UB *)Rv3)[1]=((UB *)F_pfspc)[1];
  Rv4=1;
  for( Rf0=((UB *)Rv3)[1];Rf0>0;Rf0-- ) {
    ((C *)Rv3)[Rv4+1]=((C *)F_pfspc)[Rv4+1];
    Rv4++;
  }
  ((C *)Rv3)[(((UB *)Rv3)[1]+1)+1]=0;
  Rv5=PAS__MEM_ALLOC(((SL *)Rv1)[16]);
  ((V *)Rv1)[0]=Rv5;
  ((V *)Rv1)[1]=Rv5;
  ((V *)Rv1)[4]=NULL;
  ((SL *)Rv1)[17]=0;
  ((SL *)Rv1)[20]=0;
  ((SL *)Rv1)[19]=0;
  ((SL *)Rv1)[18]=0;
  if (!(256&((UL *)Rv1)[21])&&1&((UL *)Rv1)[21]) {
    if (4&((UL *)Rv1)[21]) P_buffer_map(F_fd,0);
    else {
      if (8192&((UL *)Rv1)[21]) PAS__exe_proc(((V *)Rv1)[5],F_fd);
      else PAS_get_buffer(F_fd);
    }
  }
  if (Rv0) PAS__ASS_INTERACTIVE_FILES(F_fd);
}


/* Procedure/Function : " pas_$open "  */
void PAS__OPEN(V *F_fp, SL F_objsize, V F_filespc, UL F_umsk, SL F_ibuf, SL F_iprot)
{
  /* Define the automatic variable space. */
  Blk( Ra, 8 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UL Rv2;
  UL Rv3;
  SL Rv4;
  SL Rv5;
  register UB Rv6;
  V Rv7;
  register V Rv8;
  register F Rgf;

  /* Code of procedure/function */
  Rv0=0;
  Rv1=0;
  Rv2=0;
  Rv3=0;
  PAS__iostatus=0;
  if (F_iprot<0) F_iprot=493;
  if (Rv1==0) {
    if (!PAS__SET_FILESPC(PAS__fspc.s,F_filespc,F_umsk)) Rv1=121;
  }
  if (PAS__fspc.ub[1]==0) Rv1=201;
  if (Rv1==0) {
    Rv1=CC_Get_File_Info(PAS__fspc.s+2,PAS__file_info.s,28,0,0);
    if (Rv1==0) Rv4=PAS__FILE_KIND(PAS__file_info.sl[0]);
    else {
      Rv1=CC_ERROR();
      if (Rv1==202) {
        Rv1=0;
        Rv4=1;
      }
    }
  }
  if (Rv1==0) {
    Ra.ul[0]=F_umsk&7;
    switch (Ra.sl[0]) {
      case 1:Rv3=67108865;
      if ((F_umsk&112)==0) F_umsk=F_umsk|32;
      Rv2=O_RDONLY;
      break;
      case 2:Rv3=2;
      if ((F_umsk&112)==0) F_umsk=F_umsk|16;
      Rv2=O_WRONLY;
      Rv0=!(8&F_umsk);
      break;
      case 3:if (F_objsize>0) {
        Rv3=67108871;
        if ((F_umsk&112)==0) F_umsk=F_umsk|64;
        Rv2=O_RDWR;
      }
      else Rv1=120;
      break;
      case 4:
      case 6:Rv3=2;
      if ((F_umsk&112)==0) F_umsk=F_umsk|64;
      Rv2=O_WRONLY|O_APPEND;
      break;
      default:Rv1=120;
      break;
    }
  }
  if (Rv4==1) {
    if (256&F_umsk) Rv2=Rv2|O_EXCL;
    if (16&F_umsk) Rv2=Rv2|(O_TRUNC|O_CREAT);
    else {
      if (Rv0) Rv2=Rv2|(O_CREAT|O_EXCL);
      else {
        if (64&F_umsk) Rv2=Rv2|O_CREAT;
      }
    }
    if (8&F_umsk) {
      if (F_objsize>0) Rv3=Rv3|4;
    }
    if (1024&F_umsk) Rv3=Rv3|65536;
    if (2048&F_umsk) Rv3=Rv3|131072;
  }
  if (Rv1!=0) {
    PAS__iostatus=Rv1;
    if (!(4096&F_umsk)) PAS__ERROR(Rv1);
  }
  else {
    Rv5=_Open(PAS__fspc.s+2,Rv2, F_iprot);
    if (Rv0&&Rv5<0) {
      Rv1=CC_ERROR();
      if (2&Rv3&&(Rv1==206||Rv1==209)) {
        if (_Remove(PAS__fspc.s+2)==0) {
          Rv5=_Open(PAS__fspc.s+2,Rv2|O_CREAT, F_iprot);
          Rv1=0;
        }
      }
    }
    if (Rv5==-1) {
      Rv1=CC_ERROR();
      PAS__iostatus=Rv1;
      if (!(4096&F_umsk)) PAS__ERROR(Rv1);
    }
  }
  if (Rv1==0) {
    if (F_objsize<=0) {
      F_objsize=1;
      if (F_ibuf<1) F_ibuf=256;
      Rv3=Rv3|16;
    }
    else {
      if (F_ibuf<1) {
        if (F_objsize>=256) F_ibuf=1;
        else F_ibuf=PAS__F_ROUND((F)5.120000E+02/(float)F_objsize);
      }
      Rv3=Rv3|32;
    }
    Rv6=PAS__fspc.ub[1]+1;
    Rv7=PAS__NEW((SL)Rv6+2);
    ((UB *)Rv7)[0]=Rv6;
    PAS__STR_TO_STR(Rv7,PAS__fspc.s);
    (*F_fp)=PAS__NEW(88);
    Rv8=(*F_fp);
    ((SL *)Rv8)[14]=Rv5;
    ((SL *)Rv8)[15]=F_objsize;
    ((SL *)Rv8)[16]=F_objsize*F_ibuf;
    ((UL *)Rv8)[21]=Rv3;
    PAS__STD_init_a_file((*F_fp),PAS__fspc.s);
  }
}


/* Procedure/Function : " create_$pipe "  */
void PAS__CREATE_PIPE(V F_pipe, SL F_id, UB F_ftxt){
  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Rv0=_Pipe(F_pipe);
  if (Rv0!=0) PAS__ERROR(CC_ERROR());
  else((SL *)F_pipe)[2]=F_id;
}


/* Procedure/Function : " open_$pipe "  */
void PAS__OPEN_PIPE(V *F_fp, SL F_objsize, V F_pipe, UL F_umsk, SL F_ibuf){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );

  /* Local variable stored in C variable */
  SL Rv0;
  UL Rv1;
  SL Rv2;
  SL Rv3;
  register UB Rv4;
  V Rv5;
  register V Rv6;
  register F Rgf;

  /* Code of procedure/function */
  Rv0=0;
  Rv1=0;
  PAS__iostatus=0;
  Ra.ul[0]=F_umsk&3;
  switch (Ra.sl[0]) {
    case 1:Rv1=67108865;
    Rv2=((SL *)F_pipe)[0];
    break;
    case 2:Rv1=2;
    Rv2=((SL *)F_pipe)[1];
    break;
    default:Rv0=120;
    break;
  }
  if (Rv0!=0) PAS__ERROR(Rv0);
  else {
    PAS__VWRITE_INIT(PAS__fspc.s,1);
    PAS__WRITE_STR(Rd.s+37,-1,-1,32);
    PAS__WRITE_INT(((SL *)F_pipe)[2],-4,0);
    PAS__WRITE_EOLN();
    if (!(128&F_umsk)) {
      Rv3=dup(Rv2);
      Rv2=Rv3;
    }
    else Rv3=Rv2;
    if (Rv3==-1) {
      Rv0=CC_ERROR();
      PAS__iostatus=Rv0;
      if (!(4096&F_umsk)) PAS__ERROR(Rv0);
    }
  }
  if (Rv0==0) {
    if (F_objsize<=0) {
      F_objsize=1;
      if (F_ibuf<1) F_ibuf=256;
      Rv1=Rv1|16;
    }
    else {
      if (F_ibuf<1) {
        if (F_objsize>=256) F_ibuf=1;
        else F_ibuf=PAS__F_ROUND((F)5.120000E+02/(float)F_objsize);
      }
      Rv1=Rv1|32;
    }
    Rv4=PAS__fspc.ub[1]+1;
    Rv5=PAS__NEW((SL)Rv4+2);
    ((UB *)Rv5)[0]=Rv4;
    PAS__STR_TO_STR(Rv5,PAS__fspc.s);
    (*F_fp)=PAS__NEW(88);
    Rv6=(*F_fp);
    ((SL *)Rv6)[14]=Rv3;
    ((SL *)Rv6)[15]=F_objsize;
    ((SL *)Rv6)[16]=F_objsize*F_ibuf;
    ((UL *)Rv6)[21]=Rv1;
    PAS__STD_init_a_file((*F_fp),Rv5);
  }
}


/* Procedure/Function : " pas_associate_files "  */
void PAS__ASSOCIATE_FILES(V F_fold, V F_fnew){
  register int Rgi;

  /* Code of procedure/function */
  if (F_fold==NULL&&F_fnew==NULL) PAS__ERROR(100);
  if (F_fold!=NULL||F_fnew!=NULL) {
    if (F_fold!=NULL&&F_fnew!=NULL) {
      if (!(2064==(2064&((UL *)F_fold)[21]))) PAS__ERROR(501);
      if (!(2064==(2064&((UL *)F_fnew)[21]))) PAS__ERROR(502);
      if (((V *)F_fnew)[4]==NULL) {
        if (((V *)F_fold)[4]==NULL) ((V *)F_fnew)[4]=F_fold;
        else((V *)F_fnew)[4]=((V *)F_fold)[4];
        ((V *)F_fold)[4]=F_fnew;
      }
    }
    else {
      if (F_fold!=NULL) F_fnew=F_fold;
      PAS__STD_pas_unassociated_file(F_fnew);
    }
  }
}


/* Procedure/Function : " tty_file "  */
UB PAS__TTY_FILE(V F_fp){
  register UB Ret;

  /* Code of procedure/function */
  if (F_fp!=NULL) Ret=(1024&((UL *)F_fp)[21])!=0;
  else PAS__ERROR(100);
  return(Ret);
}


/* Procedure/Function : " tty_clreof "  */
UB PAS__TTY_CLREOF(V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;
  register int Rgi;
  register UB Ret;

  /* Code of procedure/function */
  if (F_fp!=NULL) {
    Rv0=F_fp;
    Ret=(134217728&((UL *)Rv0)[21])!=0;
    if (134218752==(134218752&((UL *)Rv0)[21])) ((UL *)Rv0)[21]=((UL *)Rv0)[21]&~
134217728|67108864;
  }
  else PAS__ERROR(100);
  return(Ret);
}


/* Procedure/Function : " file_state "  */
UL PAS__FILE_STATE(V F_fp){
  register UL Ret;

  /* Code of procedure/function */
  if (F_fp!=NULL) Ret=((UL *)F_fp)[21]&251871207;
  else PAS__ERROR(100);
  return(Ret);
}


/* Procedure/Function : " file_specification "  */
V PAS__FILE_SPC(V Ret, V F_fp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (F_fp!=NULL) {
    Rv0=F_fp;
    if (((V *)Rv0)[6]!=NULL) {
      PAS__STR_TO_STR(Ret,((V *)Rv0)[6]);
      goto Ret_Label;
    }
    else {
      PAS__STR_TO_STR(Ret,Rd.s+45);
      goto Ret_Label;
    }
  }
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " check_descr "  */
void PAS__STD_PRC_00000001(SL F_lun, UL F_fmd, V F_sn){
  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  C Rv3;

  /* Code of procedure/function */
  Rv0=PAS__STD_get_kind_of_file(F_lun);
  Rv1=_Ttyname(F_lun);
  if (Rv1!=NULL) {
    Rv2=0;
    while (1){
      Rv3=((C *)Rv1)[Rv2];
      if (Rv3==0)  break;
      Rv2=Rv2+1;
      ((C *)F_sn)[Rv2+1]=Rv3;
      if (Rv2>=((UB *)F_sn)[0])  break;
    }
    ((UB *)F_sn)[1]=Rv2;
  }
}


/* Procedure/Function : " pas_$init "  */
void PAS__INIT(SL F_parc, V F_parv, V F_penv){
  /* Define the automatic variable space. */
  Blk( Ra, 264 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register UB Rv2;
  register V Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  CC_TRAP_INIT();
  PAS__f_input=Ri.s+112;
  PAS__f_output=Ri.s+200;
  PAS__f_error=Ri.s+288;
  if (PAS__GETENV(Ra.s,Rd.s+47)<=0) PAS__SETENV(Rd.s+47,Rd.s+51,1);
  if (PAS__GETENV(Ra.s,Rd.s+61)<=0) PAS__SETENV(Rd.s+61,Rd.s+65,1);
  Ri.sl[42]=0;
  Ri.sl[43]=1;
  Ri.sl[44]=256;
  Ri.ul[49]=67109009;
  PAS__STR_TO_STR(Ra.s,Rd.s+76);
  PAS__STD_PRC_00000001(Ri.sl[42],O_RDONLY, Ra.s);
  PAS__STD_init_a_file(Ri.s+112,Ra.s);
  Ri.sl[64]=1;
  Ri.sl[65]=1;
  Ri.sl[66]=256;
  Ri.ul[71]=146;
  PAS__STR_TO_STR(Ra.s,Rd.s+87);
  PAS__STD_PRC_00000001(Ri.sl[64],O_WRONLY, Ra.s);
  PAS__STD_init_a_file(Ri.s+200,Ra.s);
  Ri.sl[86]=2;
  Ri.sl[87]=1;
  Ri.sl[88]=256;
  Ri.ul[93]=146;
  PAS__STR_TO_STR(Ra.s,Rd.s+99);
  PAS__STD_PRC_00000001(Ri.sl[86],O_WRONLY, Ra.s);
  PAS__STD_init_a_file(Ri.s+288,Ra.s);
  Ri.sl[18]=-1;
  Ri.sl[19]=1;
  Ri.sl[20]=0;
  Ri.ul[25]=33562768;
  PAS__argc=F_parc;
  Rv0=0;
  for( Rf1=(F_parc-1)+1;Rf1>0;Rf1-- ) {
    Rv1=0;
    while (Rv1<255&&((C *)((V *)F_parv)[Rv0])[Rv1]!=0)
    Rv1=Rv1+1;
    if (Rv1>0) {
      Rv2=Rv1;
      PAS__argv.v[Rv0]=PAS__NEW((SL)Rv2+2);
      ((UB *)PAS__argv.v[Rv0])[0]=Rv2;
      Rv3=PAS__argv.v[Rv0];
      ((UB *)Rv3)[1]=Rv1;
      Rv4=0;
      for( Rf0=(Rv1-1)+1;Rf0>0;Rf0-- ) {
        ((C *)Rv3)[(Rv4+1)+1]=((C *)((V *)F_parv)[Rv0])[Rv4];
        Rv4++;
      }
    }
    else PAS__argv.v[Rv0]=Ri.s+376;
    Rv0++;
  }
  Rv5=F_parc;
  for( Rf1=129-F_parc;Rf1>0;Rf1-- ) {
    PAS__argv.v[Rv5]=NULL;
    Rv5++;
  }
  PAS__env=F_penv;
}


/* Procedure/Function : " pas_$end "  */
void PAS__END(){
  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Rv0=PAS__first_descr;
  while (Rv0!=NULL){
    Rv1=Rv0;
    Rv0=((V *)Rv0)[2];
    PAS__file_close(&Rv1,0);
  }
}


/* Procedure/Function : " pas_$exit "  */
void PAS__EXIT(SL F_ncd){

  /* Code of procedure/function */
  PAS__END();
  exit(F_ncd);
}


/* Procedure/Function : " spawn "  */
UB PAS__SYSTEM(V F_cmd){
  /* Define the automatic variable space. */
  Blk( Ra, 256 );

  register UB Ret;

  /* Code of procedure/function */
  PAS__CHT_TO_CHT(Ra.s,256, F_cmd+2,(SL)((UB *)F_cmd)[1]);
  Ra.c[(((UB *)F_cmd)[1]+1)-1]=0;
  Ret=_System(Ra.s)==0;
  return(Ret);
}


/* Procedure/Function : " read_link "  */
SL PAS__READLINK(V F_fst, V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 256 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=1;
  for( Rf0=((UB *)F_fst)[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv0-1]=((C *)F_fst)[Rv0+1];
    Rv0++;
  }
  Ra.c[(((UB *)F_fst)[1]+1)-1]=0;
  Rv1=_ReadLink(Ra.s,F_trg+2,((UB *)F_trg)[0]);
  if (Rv1>=0) ((UB *)F_trg)[1]=Rv1;
  Ret=Rv1;
  return(Ret);
}


/* Procedure/Function : " file_access "  */
UB PAS__FILE_ACCESS(V F_filespc, SL F_iprv, UL F_umsk){
  /* Local variable stored in C variable */
  UL Rv0;
  SL Rv1;
  register UB Ret;

  /* Code of procedure/function */
  if (F_iprv>0) F_iprv=F_iprv&7;
  if (F_iprv<0) F_iprv=0;
  if (F_iprv==0) Rv0=F_OK;
  else {
    Rv0=0;
    if (F_iprv&1) Rv0=X_OK;
    F_iprv=F_iprv/2;
    if (F_iprv&1) Rv0=Rv0|W_OK;
    F_iprv=F_iprv/2;
    if (F_iprv&1) Rv0=Rv0|R_OK;
  }
  if (!PAS__SET_FILESPC(PAS__fspc.s,F_filespc,F_umsk)) Rv1=121;
  else {
    if (PAS__fspc.ub[1]==0) Rv1=201;
    else {
      if (_Access(PAS__fspc.s+2,Rv0)!=0) Rv1=CC_ERROR();
      else Rv1=0;
    }
  }
  PAS__iostatus=Rv1;
  Ret=Rv1==0;
  return(Ret);
}


/* Procedure/Function : " file_rename "  */
UB PAS__FILE_RENAME(V F_fold, V F_fnew, UL F_oldmd, UL F_newmd){
  /* Define the automatic variable space. */
  Blk( Ra, 264 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  if (!(PAS__SET_FILESPC(PAS__fspc.s,F_fold,F_oldmd)&&PAS__SET_FILESPC(Ra.s,F_fnew,
  F_newmd))) Rv0=121;
  else {
    if (PAS__fspc.ub[1]==0||Ra.ub[1]==0) Rv0=201;
    else {
      if (_Rename(PAS__fspc.s+2,Ra.s+2)!=0) Rv0=CC_ERROR();
      else Rv0=0;
    }
  }
  Ret=Rv0==0;
  return(Ret);
}


/* Procedure/Function : " file_remove "  */
UB PAS__FILE_REMOVE(V F_fspc, UL F_md){
  /* Local variable stored in C variable */
  SL Rv0;
  register UB Ret;

  /* Code of procedure/function */
  if (!PAS__SET_FILESPC(PAS__fspc.s,F_fspc,F_md)) Rv0=121;
  else {
    if (PAS__fspc.ub[1]==0) Rv0=201;
    else {
      if (_Remove(PAS__fspc.s+2)!=0) Rv0=CC_ERROR();
      else Rv0=0;
    }
  }
  PAS__iostatus=Rv0;
  Ret=Rv0==0;
  return(Ret);
}


/* Procedure/Function : " user_uid "  */
SL PAS__USER_UID(){
  register SL Ret;

  /* Code of procedure/function */
  Ret=_GetUid();
  return(Ret);
}


/* Procedure/Function : " user_gid "  */
SL PAS__USER_GID(){
  register SL Ret;

  /* Code of procedure/function */
  Ret=_GetGid();
  return(Ret);
}


/* Procedure/Function : " get_parm_appl "  */
SL PAS__GET_PARM_APPL(V F_tbp, V F_prg, V F_cmd, SL F_imd){
  /* Define the automatic variable space. */
  Blk( Ra, 520 );

  /* Local variable stored in C variable */
  UB Rv0;
  UL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Rv0=1;
  switch (F_imd&7) {
    case 1:Rv1=0;
    break;
    case 2:Rv1=65536;
    break;
    case 3:Rv1=32768;
    break;
    case 4:Rv1=98304;
    break;
    default:Rv0=0;
    Rv1=32768;
    break;
  }
  Rv2=((UB *)F_cmd)[1];
  Rv3=1;
  Rv4=0;
  Rv5=0;
  while (1){
    while (Rv3<Rv2&&((C *)F_cmd)[Rv3+1]<=32)
    Rv3=Rv3+1;
    if (Rv3>Rv2||Rv5>=128)  break;
    Rv6=Rv3+1;
    while (Rv6<=Rv2&&((C *)F_cmd)[Rv6+1]>32)
    Rv6=Rv6+1;
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_STR(Ra.s+257,F_cmd,Rv3, Rv6-Rv3));
    if ((Rv5==0&&((UB *)F_prg)[0]>0)&&((UB *)F_prg)[1]==0) PAS__STR_TO_STR(F_prg,
    Ra.s);
    Rv3=Rv6;
    if (Rv0) {
      if (!PAS__SET_FILESPC(Ra.s,Ra.s,Rv1)) Ra.ub[1]=0;
    }
    Rv6=Ra.ub[1];
    if ((Rv4+Rv6)+1>=1024) goto L_l_0;
    ((V *)F_tbp)[Rv5]=(Rs.c+(Rv4+1)+255);
    Rv7=1;
    for( Rf0=Rv6;Rf0>0;Rf0-- ) {
      Rv4=Rv4+1;
      Rs.c[Rv4+255]=Ra.c[Rv7+1];
      Rv7++;
    }
    Rv4=Rv4+1;
    Rs.c[Rv4+255]=0;
    Rv5=Rv5+1;
  }
L_l_0:
  ((V *)F_tbp)[Rv5]=NULL;
  Ret=Rv5;
  return(Ret);
}


/* Procedure/Function : " set_parm_appl "  */
SL PAS__SET_PARM_APPL(V F_tbp, V F_prg, V F_cmp, SL F_ll, SL F_imd){
  /* Define the automatic variable space. */
  Blk( Ra, 264 );

  /* Local variable stored in C variable */
  UB Rv0;
  UL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Rv0=1;
  switch (F_imd&7) {
    case 1:Rv1=0;
    break;
    case 2:Rv1=65536;
    break;
    case 3:Rv1=32768;
    break;
    case 4:Rv1=98304;
    break;
    default:Rv0=0;
    Rv1=32768;
    break;
  }
  Rv2=1;
  Rv3=1;
  Rv4=0;
  if ((F_ll>0&&((UB *)F_prg)[0]>0)&&((UB *)F_prg)[1]==0) PAS__STR_TO_STR(F_prg,(
  (V *)F_cmp)[0]);
  while ((Rv2<=F_ll&&Rv4<128)&&Rv3<=1024){
    if (Rv0) {
      if (!PAS__SET_FILESPC(Ra.s,((V *)F_cmp)[Rv2-1],Rv1)) Ra.ub[1]=0;
    }
    else PAS__STR_TO_STR(Ra.s,((V *)F_cmp)[Rv2-1]);
    Rv5=Ra.ub[1];
    if ((Rv3+Rv5)+1>=1024) goto L_l_0;
    ((V *)F_tbp)[Rv4]=(Rs.c+Rv3+1279);
    Rv6=1;
    for( Rf0=Rv5;Rf0>0;Rf0-- ) {
      if (Rv3<1024) {
        Rs.c[Rv3+1279]=Ra.c[Rv6+1];
        Rv3=Rv3+1;
      }
      Rv6++;
    }
    Rs.c[Rv3+1279]=0;
    Rv3=Rv3+1;
    Rv2=Rv2+1;
    Rv4=Rv4+1;
  }
L_l_0:
  ((V *)F_tbp)[Rv4]=NULL;
  Ret=Rv4-1;
  return(Ret);
}


/* Procedure/Function : " find_in_path "  */
UB PAS__IN_PATH(V F_prog, V F_upath, C F_psep, SL F_acc){
  /* Define the automatic variable space. */
  Blk( Ra, 1032 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  C Rv2;
  SL Rv3;
  UB Rv4;
  SL Rv5;
  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  if (((UB *)F_upath)[1]==0) Rv0=PAS__GET_ENV_ARRAY(&Rv1, Rd.s+110);
  else {
    Rv1=F_upath+2;
    Rv0=((UB *)F_upath)[1];
  }
  if (F_psep<=32) F_psep=58;
  Rv2=47;
  if (Rv0>0) {
    Rv3=1;
    Rv4=0;
    while (1){
      while (Rv3<=Rv0&&((C *)Rv1)[Rv3-1]==F_psep)
      Rv3=Rv3+1;
      if (Rv3>Rv0)  break;
      Rv5=1;
      Ra.c[2]=((C *)Rv1)[Rv3-1];
      Rv3=Rv3+1;
      while (Rv3<=Rv0&&((C *)Rv1)[Rv3-1]!=F_psep){
        if (Rv5<Ra.ub[0]) Rv5=Rv5+1;
        Ra.c[Rv5+1]=((C *)Rv1)[Rv3-1];
        Rv3=Rv3+1;
      }
      Ra.ub[1]=Rv5;
      if (Ra.c[Ra.ub[1]+1]!=58&&Ra.c[Ra.ub[1]+1]!=Rv2) PAS__STR_TO_STR(Ra.s+257,
      PAS__CON_STR_STR(Ra.s+771,PAS__CON_STR_CHA(Ra.s+514,Ra.s,Rv2), F_prog));
      else PAS__STR_TO_STR(Ra.s+257,PAS__CON_STR_STR(Ra.s+514,Ra.s,F_prog));
      Rv4=PAS__FILE_ACCESS(Ra.s+257,F_acc,0);
      if (Rv4||Rv3>Rv0)  break;
    }
  }
  else Rv4=0;
  Ret=Rv4;
  return(Ret);
}


/* Procedure/Function : " run_proc_0 "  */
UB PAS__RUN_PROC_0(V F_prg, V F_tbp, UB F_pat, V F_env){
  register UB Ret;

  /* Code of procedure/function */
  if (F_pat&&PAS__IN_PATH(F_prg,Rd.s+116,32,1)||PAS__FILE_ACCESS(F_prg,1,0)) {
    PAS__END();
    if (F_env==NULL) _Execv(PAS__fspc.s+2,F_tbp);
    else _Execve(PAS__fspc.s+2,F_tbp,F_env);
    PAS__ERROR(998);
    PAS__END();
    exit(1);
  }
  else Ret=0;
  return(Ret);
}


/* Procedure/Function : " run_proc_1 "  */
UB PAS__RUN_PROC_1(V F_prg, V F_cmd, SL F_imd, V F_env){
  /* Define the automatic variable space. */
  Blk( Ra, 1296 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,F_prg);
  PAS__GET_PARM_APPL(Ra.s+264,Ra.s,F_cmd,F_imd);
  Ret=PAS__RUN_PROC_0(Ra.s,Ra.s+264,F_imd/8==0, F_env);
  return(Ret);
}


/* Procedure/Function : " run_proc_2 "  */
UB PAS__RUN_PROC_2(V F_prg, V F_cmp, SL F_ll, SL F_imd, V F_env){
  /* Define the automatic variable space. */
  Blk( Ra, 1296 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,F_prg);
  PAS__SET_PARM_APPL(Ra.s+264,Ra.s,F_cmp,F_ll, F_imd);
  Ret=PAS__RUN_PROC_0(Ra.s,Ra.s+264,F_imd/8==0, F_env);
  return(Ret);
}


/* Procedure/Function : " create_proc_0 "  */
SL PAS__CREATE_PROC_0(V F_prg, V F_tbp, UB F_pat, V F_env){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register SL Ret;

  /* Code of procedure/function */
  if (F_pat&&PAS__IN_PATH(F_prg,Rd.s+116,32,1)||PAS__FILE_ACCESS(F_prg,1,0)) {
    Rv0=_Fork();
    if (Rv0==0) {
      if (F_env==NULL) Rv1=_Execv(PAS__fspc.s+2,F_tbp);
      else Rv1=_Execve(PAS__fspc.s+2,F_tbp,F_env);
      PAS__ERROR(998);
    }
    else {
      if (Rv0==-1) PAS__ERROR(999);
    }
    Ret=Rv0;
  }
  else Ret=-1;
  return(Ret);
}


/* Procedure/Function : " create_proc_1 "  */
SL PAS__CREATE_PROC_1(V F_prg, V F_cmd, SL F_imd, V F_env){
  /* Define the automatic variable space. */
  Blk( Ra, 1296 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,F_prg);
  PAS__GET_PARM_APPL(Ra.s+264,Ra.s,F_cmd,F_imd);
  Ret=PAS__CREATE_PROC_0(Ra.s,Ra.s+264,F_imd/8==0, F_env);
  return(Ret);
}


/* Procedure/Function : " create_proc_2 "  */
SL PAS__CREATE_PROC_2(V F_prg, V F_cmp, SL F_ll, SL F_imd, V F_env){
  /* Define the automatic variable space. */
  Blk( Ra, 1296 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,F_prg);
  PAS__SET_PARM_APPL(Ra.s+264,Ra.s,F_cmp,F_ll, F_imd);
  Ret=PAS__CREATE_PROC_0(Ra.s,Ra.s+264,F_imd/8==0, F_env);
  return(Ret);
}


/* Procedure/Function : " wait_process "  */
SL PAS__WAIT_PROCESS(SL *F_pro_sta, SL F_proc_id){
  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=_Wait(F_pro_sta);
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " change_dir "  */
UB PAS__CHANGE_DIR(V F_dir, UL F_md){
  /* Local variable stored in C variable */
  SL Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (!PAS__SET_FILESPC(PAS__fspc.s,F_dir,F_md)) Rv0=121;
  else {
    if (PAS__fspc.ub[1]==0) Rv0=201;
    else {
      if (_Chdir(PAS__fspc.s+2)!=0) Rv0=CC_ERROR();
    }
  }
  Ret=Rv0!=0;
  return(Ret);
}


/* Procedure/Function : " get_defdir "  */
V PAS__GET_DEF_DIR(V Ret){
  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  ((UB *)Ret)[1]=0;
  Rv0=_Getdir(((C *)Ret)+2,((UB *)Ret)[0]-1);
  if (Rv0!=NULL) {
    Rv1=1;
    while (Rv1<((UB *)Ret)[0]&&((C *)Ret)[Rv1+1]!=0)
    Rv1=Rv1+1;
    if (Rv1>0) ((UB *)Ret)[1]=Rv1-1;
  }
  return(Ret);
}


/* Procedure/Function : " delay "  */
F PAS__DELAY(F F_sec){
  register F Ret;

  /* Code of procedure/function */
  if (F_sec>(F)0.000000E-01) {
    if (PAS__SET_TIMER(F_sec, (F)0.000000E-01)==0) Ret=PAS__WAIT_TIMER();
    else Ret=(F)-1.000000E+00;
  }
  else Ret=(F)1.000000E+00;
  return(Ret);
}


/* Procedure/Function : " sleep "  */
SL PAS__SLEEP(SL F_sec){
  register F Rgf;
  register SL Ret;

  /* Code of procedure/function */
  Ret=PAS__F_ROUND(PAS__DELAY((float)F_sec));
  return(Ret);
}


/* Procedure/Function : " check_range "  */
SL PAS__RANGE(SL F_iv, SL F_low, SL F_high){
  register SL Ret;

  /* Code of procedure/function */
  if (F_iv<F_low||F_iv>F_high) PAS__ERROR(31);
  Ret=F_iv;
  return(Ret);
}


/* Procedure/Function : " set_le "  */
UB PAS__SET_LE(UL F_s1, UL F_s2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=F_s1==(F_s1&F_s2);
  return(Ret);
}


/* Procedure/Function : " q_sqr "  */
SQ PAS__Q_SQR(SQ F_i){
  register SQ Ret;

  /* Code of procedure/function */
  Ret=F_i*F_i;
  return(Ret);
}


/* Procedure/Function : " i_sqr "  */
SL PAS__I_SQR(SL F_i){
  register SL Ret;

  /* Code of procedure/function */
  Ret=F_i*F_i;
  return(Ret);
}


/* Procedure/Function : " q_mod "  */
SQ PAS__Q_MOD(SQ F_iv, SQ F_jv){
  /* Local variable stored in C variable */
  SQ Rv0;
  SQ Rv1;
  register SQ Ret;

  /* Code of procedure/function */
  Rv0=abs(F_jv);
  Rv1=F_iv%F_jv;
  if (Rv1>=0) Ret=Rv1;
  else Ret=Rv1+Rv0;
  return(Ret);
}


/* Procedure/Function : " i_mod "  */
SL PAS__I_MOD(SL F_iv, SL F_jv){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=abs(F_jv);
  Rv1=F_iv%F_jv;
  if (Rv1>=0) Ret=Rv1;
  else Ret=Rv1+Rv0;
  return(Ret);
}


/* Procedure/Function : " f_sqr "  */
F PAS__F_SQR(F F_f){
  register F Ret;

  /* Code of procedure/function */
  Ret=F_f*F_f;
  return(Ret);
}


/* Procedure/Function : " g_sqr "  */
G PAS__G_SQR(G F_g){
  register G Ret;

  /* Code of procedure/function */
  Ret=F_g*F_g;
  return(Ret);
}


/* Procedure/Function : " fq_round "  */
SQ PAS__FQ_ROUND(F F_fv){
  register SQ Ret;

  /* Code of procedure/function */
  if (F_fv>(F)0.000000E-01) Ret=(int)(F_fv+(F)5.000000E-01);
  else Ret=(int)(F_fv-(F)5.000000E-01);
  return(Ret);
}


/* Procedure/Function : " gq_round "  */
SQ PAS__GQ_ROUND(G F_fv){
  register SQ Ret;

  /* Code of procedure/function */
  if (F_fv>0.000000000000000E-001) Ret=(int)(F_fv+5.000000000000000E-001);
  else Ret=(int)(F_fv-5.000000000000000E-001);
  return(Ret);
}


/* Procedure/Function : " f_round "  */
SL PAS__F_ROUND(F F_fv){
  register SL Ret;

  /* Code of procedure/function */
  if (F_fv>(F)0.000000E-01) Ret=(int)(F_fv+(F)5.000000E-01);
  else Ret=(int)(F_fv-(F)5.000000E-01);
  return(Ret);
}


/* Procedure/Function : " g_round "  */
SL PAS__G_ROUND(G F_fv){
  register SL Ret;

  /* Code of procedure/function */
  if (F_fv>0.000000000000000E-001) Ret=(int)(F_fv+5.000000000000000E-001);
  else Ret=(int)(F_fv-5.000000000000000E-001);
  return(Ret);
}
