/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Declaration of external variables. */
extern V PAS__curr_iptr;




/* Procedure/Function : " read_fchar "  */
void PAS__READ_FCHAR(C *F_ch, SL F_fld){
  /* Local variable stored in C variable */
  C Rv0;

  /* Code of procedure/function */
  PAS__READ_CHAR(F_ch);
  while (F_fld>1&&!PAS__CURR_EOLN()){
    PAS__READ_CHAR(&Rv0);
    F_fld=F_fld-1;
  }
}


/* Procedure/Function : " read_char_array "  */
SL PAS__READ_CHAR_ARRAY(V F_chtb, SL F_len, SL F_fld, UB F_bsep){
  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  C Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (F_fld<=0) F_fld=-1;
  if (F_bsep) {
    Rv1=0;
    while (1){
      if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
      if (PAS__CURR_EOF())  break;
      if (F_fld>0) F_fld=F_fld-1;
      Rv2=((C *)((V *)PAS__curr_iptr)[0])[0];
      if (Rv1&&Rv2<=32)  break;
      if (Rv2>32) {
        Rv0=Rv0+1;
        ((C *)F_chtb)[Rv0-1]=Rv2;
        Rv1=1;
      }
      PAS__GET(PAS__curr_iptr);
      if (F_fld==0||Rv0>=F_len)  break;
    }
  }
  else while ((!PAS__CURR_EOLN()&&Rv0<F_len)&&F_fld!=0){
    if (F_fld>=0) F_fld=F_fld-1;
    Rv0=Rv0+1;
    ((C *)F_chtb)[Rv0-1]=((C *)((V *)PAS__curr_iptr)[0])[0];
    PAS__GET(PAS__curr_iptr);
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " read_string "  */
void PAS__READ_STR(V F_st, SL F_fld, UB F_bsep){

  /* Code of procedure/function */
  ((UB *)F_st)[1]=PAS__READ_CHAR_ARRAY(F_st+2,(UL)((UB *)F_st)[0],F_fld, F_bsep);
}


/* Procedure/Function : " read_charray "  */
void PAS__READ_CHT(V F_chtb, SL F_len, SL F_fld, UB F_bsep){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=PAS__READ_CHAR_ARRAY(F_chtb,F_len, F_fld, F_bsep);
  Rv1=Rv0+1;
  for( Rf0=(F_len+1)-(Rv0+1);Rf0>0;Rf0-- ) {
    ((C *)F_chtb)[Rv1-1]=32;
    Rv1++;
  }
}


/* Procedure/Function : " get_format "  */
void CPAS__IOSTR_get_format(SL F_sz, SL F_p, SL F_f, SL *F_bl, SL *F_md, SL *F_el)
{

  /* Code of procedure/function */
  if (F_f<=0) {
    (*F_md)=F_sz;
    (*F_bl)=0;
    (*F_el)=0;
  }
  else {
    if (F_f<=F_sz) {
      (*F_md)=F_f;
      (*F_bl)=0;
      (*F_el)=0;
    }
    else {
      (*F_md)=F_sz;
      if (F_p<0) {
        (*F_bl)=0;
        (*F_el)=F_f-F_sz;
      }
      else {
        if (F_p>0) {
          (*F_bl)=F_f-F_sz;
          (*F_el)=0;
        }
        else {
          (*F_el)=F_f-F_sz;
          (*F_bl)=(*F_el)/2;
          (*F_el)=(*F_el)-(*F_bl);
        }
      }
    }
  }
}


/* Procedure/Function : " write_mchar "  */
void PAS__WRITE_MCHAR(C F_ch, SL F_rep){
  register int Rf0;

  /* Code of procedure/function */
  for( Rf0=F_rep;Rf0>0;Rf0-- )
  PAS__WRITE_CHAR(F_ch);
}


/* Procedure/Function : " write_string "  */
void PAS__WRITE_STR(V F_st, SL F_f, SL F_p, C F_sp){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  CPAS__IOSTR_get_format(((UB *)F_st)[1],F_p, F_f, &Rv0, &Rv1, &Rv2);
  PAS__WRITE_MCHAR(F_sp, Rv0);
  Rv3=1;
  for( Rf0=Rv1;Rf0>0;Rf0-- ) {
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  PAS__WRITE_MCHAR(F_sp, Rv2);
}


/* Procedure/Function : " write_charray "  */
void PAS__WRITE_CHT(V F_chtb, SL F__Sz, SL F_f, SL F_p, C F_sp){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  CPAS__IOSTR_get_format(F__Sz, F_p, F_f, &Rv0, &Rv1, &Rv2);
  PAS__WRITE_MCHAR(F_sp, Rv0);
  Rv3=1;
  for( Rf0=Rv1;Rf0>0;Rf0-- ) {
    PAS__WRITE_CHAR(((C *)F_chtb)[Rv3-1]);
    Rv3++;
  }
  PAS__WRITE_MCHAR(F_sp, Rv2);
}


/* Procedure/Function : " write_fchar "  */
void PAS__WRITE_FCHAR(C F_ch, SL F_f, SL F_p, SL F_rep, C F_sp){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;

  /* Code of procedure/function */
  if (F_rep<1) F_rep=1;
  CPAS__IOSTR_get_format(F_rep, F_p, F_f, &Rv0, &Rv1, &Rv2);
  PAS__WRITE_MCHAR(F_sp, Rv0);
  PAS__WRITE_MCHAR(F_ch, F_rep);
  PAS__WRITE_MCHAR(F_sp, Rv2);
}


/* Procedure/Function : " skip_page "  */
void PAS__PAGE(V F_fi){

  /* Code of procedure/function */
  PAS__SELECT_OUT(F_fi);
  PAS__WRITE_CHAR(12);
}
