/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long

/* Include the PAS environment file. */
#include "cpas_defs.h"


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " read_ennum "  */
void PAS__READ_ENM(V F_pen, SL F_ensz, V F_imtb, SL F_fld){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=64;
  if (!PAS__CURR_EOF()) {
    PAS__READ_STR(Ra.s,F_fld,1);
    Rv0=1;
    for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
      if (Ra.c[Rv0+1]>=65&&Ra.c[Rv0+1]<=90) Ra.c[Rv0+1]=(C)((SL)Ra.c[Rv0+1]+32);
      Rv0++;
    }
    if (!PAS__CURR_EOF()) {
      Rv1=0;
      while (1){
        if ((SL)((C *)F_imtb)[Rv1*((UL)((UB *)F_imtb)[4]+1)+5]==Ra.ub[1]) {
          Rv2=1;
          while (Rv2<=Ra.ub[1]&&((C *)F_imtb)[Rv1*((UL)((UB *)F_imtb)[4]+1)+Rv2+
5]==Ra.c[Rv2+1])
          Rv2=Rv2+1;
          if (Rv2>Ra.ub[1])  break;
        }
        Rv1=Rv1+1;
        if (Rv1>((SL *)F_imtb)[0])  break;
      }
      if (Rv1>((SL *)F_imtb)[0]) PAS__ERROR(52);
      else {
        Rv3=F_pen;
        switch (F_ensz) {
          case 1:((UB *)Rv3)[0]=Rv1;
          break;
          case 2:((UW *)Rv3)[0]=Rv1;
          break;
          case 4:((UL *)Rv3)[0]=Rv1;
          break;
          default:PAS__ERROR(53);
          break;
        }
      }
    }
  }
}


/* Procedure/Function : " write_ennum "  */
void PAS__WRITE_ENM(UL F_en, V F_imtb, SL F_f, SL F_p, C F_sp){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Rv0=F_en;
  Ra.ub[1]=(SL)((C *)F_imtb)[Rv0*((UL)((UB *)F_imtb)[4]+1)+5];
  Rv1=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv1+1]=((C *)F_imtb)[Rv0*((UL)((UB *)F_imtb)[4]+1)+Rv1+5];
    Rv1++;
  }
  PAS__WRITE_STR(Ra.s,F_f, F_p, F_sp);
}
