/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 72 ) = {
  5,   5, 105, 102, 112, 111, 119,  60,  60,  47, 104, 111, 109, 101,  47, 112,
105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95,  86,  51,  95,
 65,  95, 115, 114,  99,  47,  99, 112,  97, 115,  95,  95, 105, 102, 112, 111,
119,  46, 112,  97, 115,   0,   0,   0
};




/* Procedure/Function : " ifpow "  */
F PAS__IFPOWER(F F_z, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=59; /* line # 59 */
  Rv0=(F)1.000000E+00;
  if (F_n<0) {
    F_n= -F_n;
    F_z=(F)1.000000E+00/F_z;
  }
  Ra.sl[6]=64; /* line # 64 */
  while (F_n>0)
  if (F_n&1) {
    F_n=F_n-1;
    Rv0=Rv0*F_z;
  }
  else {
    Ra.sl[6]=71; /* line # 71 */
    F_n=F_n/2;
    F_z=F_z*F_z;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
