%pragma trace 1;
program COPY_TO_BIN;

%include 'PASENV:cpas_d__sdir_env';

const
  TAB = CHR(  9 );
  LF  = CHR( 10 );

  max_line   =   80;                   { Size of Verbose line }
  std_nexcl  =   22;                   { Number of excluded file type (in standrard) }

  ftmp = 'cp2b__output.tmp_tmp';


type
  ext_ptr = ^ext_rec;                  { Pointer of extension definition }

  ext_rec( sz: integer ) = record      { Define an extension file record }
                             nxt: ext_ptr;
                             ext: array[1..sz] of char
                           end;


var
  ll, inat, inats, prot, cnt: integer; { Object Nature, Object Protection }
  dspc,                                { Input File Specification }
  fdst,                                { Output File Directory Specification }
  fout,                                { Output File Specification }
  fext,                                { Output File extension (type) }
  fnam:            string;             { Current entry of the directory }
  deflt:           efb_ptr;            { Complet Filtre pointer definition }
  ch:              char;

  cline:           string(255);        { Current text line }

  excl_tab:  string( 255 ) :=          { List of excluded cp2B file types }
   '.a/.o/.bak/.bmp/.com/.doc/.drwfnt/.err/.exe/.gif/.ico/.jpg/.pdf/.png/.ppt/.rc/.tar/.tgz/.xls/.1/';

  estd_tab: array[1..std_nexcl] of string( 7 ) := [
                  '.drwfnt',   '.a',   '.o', '.bak', '.bmp', '.com', '.doc', '.err', { 01..08 }
                     '.exe', '.gif', '.ico', '.jpg', '.png',  'pdf', '.ppt',  '.rc', { 09..16 }
                     '.tar',  '.gz', '.tgz', '.zip', '.xls', '.sxw'                  { 17..22 }
            ];

  p,                                   { Current Extension record pointer }
  exti_frst,
  exti_last,
  exte_frst,
  exte_last:       ext_ptr := nil;     { Header of extension lists (enabled ans disabled) }

  bverb,                               { TO flag the Verbose mode }
  bnoop,                               { To disable the file operation }
  bnoext:          boolean;            { To disable the operationon no filme type file }

  inp:             text;               { Input Text file }
  out:             file of char;       { Output file in Unix text file }



  procedure SET_EXTENSION( bexc: boolean; in_var ext: string );
  var
    p: ext_ptr;

  begin
    if ext.length > 0 then
    begin
      NEW( p, ext.length );
      p^.nxt := nil;
      p^.ext := ext;
      if bexc then
      begin
        if exti_frst = nil then exti_frst := p
                           else exti_last^.nxt := p;
        exti_last := p
      end
      else
      begin
        if exte_frst = nil then exte_frst := p
                           else exte_last^.nxt := p;
        exte_last := p
      end
    end
  end SET_EXTENSION;



  procedure GET_PARAM;
  var
    cp, cf, ii, ij, ik: integer;
    st, ext:             string;
    b_stnd:             boolean;
    p:                  ext_ptr;

  begin
    b_stnd :=  true;                   { Default to load the standard extension }
    bverb  := false;                   { Default to not verbose }
    bnoop  := false;                   { Default is to work }
    bnoext := (sys_unix > 0);          { Disable the cp2b run on Non filetype file for linux }
    dspc := '*';                       { Default Source is the current directory }
    fdst.length := 0;                  { The default target directory is the source directory }
    cp := 1; cf := 0;
    while argc > cp do
    begin
      st := argv[cp]^; cp := cp + 1;
      if st[1] = '-' then
        case st[2] of
          'u', 'U':                    { Option to do not change any file without file-type (extension) }
            bnoext :=  true;
          'n', 'N':                    { Scan and adapt the end of line of a file without file-type (extension) }
            bnoext := false;
          'd', 'D':                    { Scan the directory but do not any thing }
            bnoop  :=  true;
          'p', 'P':                    { To Disable the Standard extrensions }
            b_stnd := false;
          'v', 'V':                    { SET Verbose mode }
            bverb  :=  true;
          'i', 'I':                    { Specify extension(s) to ignore }
            begin
              ii := INDEX( st, '.' );
              ik := 1;
              while ii > 0 do
              begin
                ik := ik + 1;
                ij := INDEX( st, '.', ik );
                if ij > 0 then ext := SUBSTR( st, ii, ij - ii )
                          else ext := SUBSTR( st, ii );
                ii := ij;
                SET_EXTENSION( true, ext )
              end
            end;
          'e', 'E':                    { Specify extension(s) to handle }
            begin
              ii := INDEX( st, '.' );
              ik := 1;
              while ii > 0 do
              begin
                ik := ik + 1;
                ij := INDEX( st, '.', ik );
                if ij > 0 then ext := SUBSTR( st, ii, ij - ii )
                          else ext := SUBSTR( st, ii );
                ii := ij;
                SET_EXTENSION( false, ext )
              end
            end;

        otherwise
          WRITELN;
          WRITELN( ' CP2B Program to change the end-of-line of ASCII files from Windows to Unix form.' );
          WRITELN;
          WRITELN( ' The cp2b command syntax is :' );
          WRITELN( '   cp2b [ <opt_list> ] [ <Source_directory> [ <target_directory> ] ]' );
          WRITELN;
          WRITELN( '   The possible options are :' );
          WRITELN( '     -u        To disable the operation on file without extension,' );
          WRITELN( '     -n        To enable the operation on file without extension,' );
          WRITELN( '     -d        To disable all file the operation.' );
          WRITELN( '     -v        To set the verbose mode.' );
          WRITELN( '     -p        To inib the standard extensions.' );
          WRITELN( '     -i<ext1>[<ext2>...]' );
          WRITELN( '     -e<ext1>[<ext2>...]' );
          WRITELN( '               To operate (-e) or ignore (-i) on the files with the specified extension(s).' );
          WRITELN( '               example : -e.sh.pas.for to change the end of file of files with the type ".sh", ".pas" and ".for"' );
          WRITELN;
          PASCAL_EXIT( 0 )
        end
      else
      begin
        case cf of
          0: dspc := st;               { Set the Source directory }
          1: fdst := st;               { Set the Target Directory }
        otherwise
          { Ignore any supplementary parameter }
        end;
        cf := cf + 1
     end
    end;

    { Set the Standard exclusion Table }
    if b_stnd then
      for i := 1 to std_nexcl do
        SET_EXTENSION( true, estd_tab[i] );

    if bverb then
    begin
      p := exte_frst;
      ik := 0;
      WRITELN;
      WRITELN( ' We scan on all files with the extension (or file-types) as : ' );
      while p <> nil do
      with p^ do
      begin
        if ik > max_line then begin  WRITELN; ik := 0  end;
        WRITE( '  ', ext:sz ); ik := ik + sz + 2;
        p := nxt
      end;
      WRITELN;
      p := exti_frst;
      ik := 0;
      WRITELN;
      WRITELN( ' But we ignore all files with the extension (or file-types) as : ' );
      while p <> nil do
      with p^ do
      begin
        if ik > max_line then begin  WRITELN; ik := 0  end;
        WRITE( '  ', ext:sz ); ik := ik + sz + 2;
        p := nxt
      end;
      WRITELN
    end
  end GET_PARAM;



begin { COPY_TO_BIN }
  GET_PARAM;
  cnt := 0;
  deflt := FSPC_OPEN( dspc );
  if deflt <> nil then
  loop
    FSPC_SCAN( deflt, fnam, inat );
  exit if inat < 0;
    { Test files types for binary file exclusion }
    fext := SUBSTR( fnam, INDEX( fnam, '.', -1 ) );
    if (INDEX( fext, '/' ) <> 0) or (INDEX( fext, '\' ) <> 0) or
       (INDEX( fext, ']' ) <> 0) or (INDEX( fext, ':' ) <> 0) then fext.length := 0;

    if (fext.length > 0) or not bnoext then
    begin
      for i := 1 to fext.length do
        if (fext[i] >= 'A') and (fext[i] <= 'Z') then fext[i] := CHR( ORD( fext[i] ) + 32 );
      inats := inat;
(*
      fext := fext||'/';
      if INDEX( excl_tab, fext ) <> 0 then int := 0;
*)
      p := exti_frst;
      while p <> nil do
      begin
        if p^.ext = fext then begin  inats :=    0; exit  end;
        p := p^.nxt
      end;

      p := exte_frst;
      while p <> nil do
      begin
        if p^.ext = fext then begin  inats := inat; exit  end;
        p := p^.nxt
      end;
      if bverb and (inats <> 1) then WRITELN( ' Ignore File "', fnam, '"' );
      if inats = 1 then
      begin
        prot := fspc_file_info[1] mod (8**4);
        if not bnoop then
        begin
          OPEN( inp, fnam, [read_file,error_file,case_ena_file] );
          if iostatus <> 0 then { Open fail }
          begin
            WRITELN( ' *** cp2b cannot read the file "', fnam,'", it was skiped.' );
            goto ET_CONT
          end;
          OPEN( out, 'cp2b__output.tmp_tmp', [write_file,error_file] );
          if iostatus <> 0 then { Open fail }
          begin
            WRITELN( ' *** cp2b cannot write new the file(s) => stop Process.' );
            PASCAL_EXIT( 2 )
          end;
          { The two files are opened now }
          ll := 0;
          while not EOF( inp ) do
          begin
            READ( inp, cline ); ll := ll + 1;
            IF NOT EOF( inp ) then READLN( inp );
            for ii := 1 to cline.length do
            begin
              ch := cline[ii];
              if (ch >= ' ') or (ch = TAB) then
              begin
                out^ := ch; PUT( out )
              end
            end;
            out^ := LF; PUT( out )
          end;
          CLOSE( inp );
          CLOSE( out );
          if fdst.length = 0 then
            if FILE_RENAME( fnam,  fnam||'.bak', [case_ena_file], [case_ena_file] ) then
              FILE_RENAME( ftmp,  fnam, [case_ena_file], [case_ena_file] )
            else
            begin  WRITELN( ' STOP we cannot rename the files.' );
                   PASCAL_EXIT( 2 )
            end
          else
            FILE_RENAME( ftmp,  fdst||fnam, [case_ena_file], [case_ena_file] );
        end else WRITE( ' not done : ' );
        WRITELN( '$ cp2b ', fnam, ' -> ', fdst||fnam )
      end;
ET_CONT:
    end
  end;
  FSPC_CLOSE( deflt );

  WRITELN( ' Normal End.' )
end COPY_TO_BIN.
