{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                     ---  RUN-TIME KERNEL  ---                         *
*         ---  Floatting Point Exceptions Definitions  ---              *
*               --- Version  3.1-B6 - 03-07-2022 ---                    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
module BASIC_ENV_LST;
*)

type
    FpExceptFlag   = (FPE_Inexa, FPE_Dzero, FPE_Overf, FPE_Inval, FPE__Under);
    FpExceptFlags  = set of FpExceptFlag use 32;

    FloatClass     = (FP_Normal, FP_SubNormal, FP_PInf, FP_NInf, FP_Nan);


function PAS__FP_CLASSIFY( v: single ): FloatClass; external 'Pas__FpClassify_F';
function PAS__FP_CLASSIFY( v: double ): FloatClass; external 'Pas__FpClassify_D';

function PAS__CHECK_FPEXC: FpExceptFlags; external 'Pas__Check_Fpexc';
procedure PAS__FLOAT_TRAP; external 'Pas__Float_Trap';


(*
end.
*)
