/*  P A S - P. WOLFERS SOFTWARE: V3.1-A1 OF 30-NOV-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 576 ) = {
 12,  12, 115, 116, 114,  95,  99, 111, 112, 121,  95, 108, 105, 109,  63,  63,
 47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  45,  49,  45,  65,  50,  47,
 99, 112,  97, 115,  95,  98,  95,  95, 108, 115, 116,  46, 112,  97, 115,   8,
  8, 108, 115, 116,  95, 105, 110, 105, 116,  12,  12, 108, 115, 116,  95,  97,
108, 108, 111,  99,  97, 116, 101,   8,   8, 108, 115, 116,  95, 102, 114, 101,
101,   9,   9, 108, 115, 116,  95,  99, 108, 111, 115, 101,  18,  18, 108, 115,
116,  95,  99, 104,  97, 110, 103, 101,  95, 104, 101,  97, 100, 105, 110, 103,
  8,   8,  82, 117, 110,  32, 116, 104, 101,  32,   4,   4,  32,  97, 116,  32,
  9,   9,  92,  72,  69,  65,  68,  73,  78,  71,  32,   3,   3,  32,  45,  32,
  9,   9,  92,  72,  69,  65,  68,  73,  78,  71,  32,  16,  16, 108, 115, 116,
 95,  99, 104,  97, 110, 103, 101,  95, 116, 105, 116, 108, 101,   7,   7,  92,
 84,  73,  84,  76,  69,  32,   8,   8,  92,  84,  73,  84,  76,  69,  32,  48,
 19,  19, 108, 115, 116,  95,  99, 104,  97, 110, 103, 101,  95, 115, 117,  98,
116, 105, 116, 108, 101,  10,  10,  92,  83,  85,  66,  84,  73,  84,  76,  69,
 32,  11,  11,  92,  83,  85,  66,  84,  73,  84,  76,  69,  32,  48,   8,   8,
108, 115, 116,  95, 111, 112, 101, 110,   0,   0,   0,   0,   0,   0,  11,  11,
108, 115, 116,  95, 110, 101, 119, 108, 105, 110, 101,   5,   5,  80,  97, 103,
101,  32,   8,   8, 108, 115, 116,  95, 101, 111, 108, 110,  15,  15, 108, 115,
116,  95,  98, 114, 101,  97, 107, 111, 117, 116, 112, 117, 116,   8,   8, 108,
115, 116,  95, 112,  97, 103, 101,  14,  14, 108, 115, 116,  95, 115, 101, 116,
 95,  99, 111, 108, 117, 109, 110,  14,  14, 108, 115, 116,  95, 115, 101, 116,
 95, 109,  97, 114, 103, 105, 110,  13,  13, 108, 115, 116,  95, 115, 107, 105,
112,  95, 108, 105, 110, 101,  10,  10,  92,  83,  75,  73,  80,  76,  73,  78,
 69,  32,  17,  17, 108, 115, 116,  95, 115, 101, 116,  95,  99, 104,  97, 114,
 95,  97, 116, 116, 114,   3,   3,  78,  78,  78,   3,   3,  78,  78,  78,  11,
 11,  92,  67,  72,  65,  82,  95,  65,  84,  84,  82,  32,  13,  13, 108, 115,
116,  95, 116, 101, 115, 116,  95, 108, 105, 110, 101,  11,  11,  92,  84,  69,
 83,  84,  95,  76,  73,  78,  69,  32,  12,  12, 108, 115, 116,  95, 112, 117,
116,  95,  99, 104,  97, 114,  13,  13, 108, 115, 116,  95, 112, 117, 116,  95,
109,  99, 104,  97, 114,  14,  14, 108, 115, 116,  95, 112, 117, 116,  95, 115,
116, 114, 105, 110, 103,  11,  11, 108, 115, 116,  95, 112, 117, 116,  95, 105,
110, 116,  13,  13, 108, 115, 116,  95, 112, 117, 116,  95, 102, 108, 111,  97,
116,  13,  13, 108, 115, 116,  95, 112, 117, 116,  95, 102, 105, 120, 101, 100,
 10,  10, 108, 115, 116,  95, 103,  95, 105, 110, 105, 116,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;

/* Declaration of global variables. */
V V_lst_current = NULL;
V V_lst_hde = NULL;
UL V_lst_spc_mode = 0;
Blk(V_lst_date, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_lst_time, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };

/* Function/procedure prototypes. */
void P_vls_nextstring();


/* Procedure/Function : " str_copy_lim "  */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=181; /* line # 181 */
  Rv0=((UB *)F_src)[1];
  if (F_lim==0) F_lim=Rv0;
  else {
    if (Rv0>F_lim) Rv0=F_lim;
  }
  if ((*F_trg)!=NULL) PAS__DISPOSE(F_trg);
  if (Rv0>0) {
    Ra.sl[3]=187; /* line # 187 */
    Rv1=Rv0;
    (*F_trg)=PAS__NEW((SL)Rv1+2);
    ((UB *)(*F_trg))[0]=Rv1;
    PAS__STR_TO_STR((*F_trg),F_src);
  }
  else (*F_trg)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_init "  */
void P_lst_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+79;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=198; /* line # 198 */
  Rv0=F_p;
  ((V *)Rv0)[1]=NULL;
  ((V *)Rv0)[2]=NULL;
  Ra.sl[3]=203; /* line # 203 */
  ((V *)Rv0)[4]=NULL;
  ((V *)Rv0)[5]=NULL;
  ((SL *)Rv0)[6]=0;
  ((SL *)Rv0)[7]=0;
  ((SL *)Rv0)[8]=0;
  Ra.sl[3]=208; /* line # 208 */
  ((SL *)Rv0)[9]=0;
  ((SL *)Rv0)[10]=0;
  ((SL *)Rv0)[11]=0;
  ((UB *)Rv0)[48]=0;
  _FILE_CLEAR(((V *)Rv0)[13]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_allocate "  */
V P_lst_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+89;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=223; /* line # 223 */
  Rv0=PAS__NEW(56);
  ((V *)Rv0)[0]=V_lst_hde;
  V_lst_hde=Rv0;
  ((V *)Rv0)[3]=PAS__NEW(34);
  ((UB *)((V *)Rv0)[3])[0]=32;
  P_lst_init(Rv0);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lst_free "  */
void P_lst_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=239; /* line # 239 */
  Rv0=NULL;
  if ((*F_p)!=NULL) {
    Rv1=V_lst_hde;
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[3]=245; /* line # 245 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Rv2=(*F_p);
    Ra.sl[3]=251; /* line # 251 */
    if (((V *)Rv2)[1]!=NULL) PAS__DISPOSE(((V *)Rv2)+1);
    if (((V *)Rv2)[3]!=NULL) PAS__DISPOSE(((V *)Rv2)+3);
    if (((V *)Rv2)[2]!=NULL) PAS__DISPOSE(((V *)Rv2)+2);
    if (((V *)Rv2)[4]!=NULL) PAS__DISPOSE(((V *)Rv2)+4);
    if (((V *)Rv2)[5]!=NULL) PAS__DISPOSE(((V *)Rv2)+5);
    Ra.sl[3]=256; /* line # 256 */
    if (Rv0==NULL) V_lst_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_close "  */
void P_lst_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+113;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=271; /* line # 271 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (1&((UB *)Rv0)[48]) Rv1=1024;
    else {
      Ra.sl[3]=276; /* line # 276 */
      Rv1=0;
    }
    if ((68&((UB *)Rv0)[48])==0) PAS__CLOSE(((V *)Rv0)+13,Rv1);
    PAS__DISPOSE(((V *)Rv0)+1);
    ((V *)Rv0)[1]=NULL;
    if (((V *)Rv0)[2]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+2);
      ((V *)Rv0)[2]=NULL;
    }
    Ra.sl[3]=281; /* line # 281 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+4);
      ((V *)Rv0)[4]=NULL;
    }
    if (((V *)Rv0)[5]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+5);
      ((V *)Rv0)[5]=NULL;
    }
    if (F_bfree) P_lst_free(F_p);
    else P_lst_init((*F_p));
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_heading "  */
void P_lst_change_heading(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+124;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=297; /* line # 297 */
  Rv0=V_lst_current;
  Rv1=((((SL *)Rv0)[10]-32)-4)-12;
  Ra.sl[3]=302; /* line # 302 */
  if (Rv1<60) Rv1=60;
  P_str_copy_lim(((V *)Rv0)+2,F_str,Rv1);
  PAS__DATE_STR(V_lst_date.s);
  PAS__TIME_STR(V_lst_time.s);
  PAS__VWRITE_INIT(((V *)Rv0)[3],1);
  PAS__WRITE_STR(Rd.s+144,-1,-1,32);
  PAS__WRITE_STR(V_lst_date.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+154,-1,-1,32);
  PAS__WRITE_STR(V_lst_time.s,-1,-1,32);
  PAS__WRITE_EOLN();
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=308; /* line # 308 */
    if (((V *)Rv0)[2]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+160,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[2])[1]+((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
      PAS__WRITE_STR(Rd.s+171,-1,-1,32);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+176,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=313; /* line # 313 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_title "  */
void P_lst_change_title(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+187;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=323; /* line # 323 */
  Rv0=V_lst_current;
  P_str_copy_lim(((V *)Rv0)+4,F_str,((SL *)Rv0)[10]-1);
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=328; /* line # 328 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+205,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[4])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+214,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_subtitle "  */
void P_lst_change_subtitle(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+224;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=340; /* line # 340 */
  Rv0=V_lst_current;
  P_str_copy_lim(((V *)Rv0)+5,F_str,((SL *)Rv0)[10]-1);
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=345; /* line # 345 */
    if (((V *)Rv0)[5]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+245,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[5])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+257,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_open "  */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  register UB Rv3;
  SL Rv4;
  UB Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  Ra.v[193]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+772;
  Ra.v[194]=Rd.s+270;
  Ra.v[195]=Rd.s+14;
  Ra.sl[196]=387; /* line # 387 */
  if (F_heading!=NULL) PAS__STR_TO_STR(Ra.s,F_heading);
  else PAS__STR_TO_STR(Ra.s,Rd.s+280);
  if (F_title!=NULL) PAS__STR_TO_STR(Ra.s+257,F_title);
  else PAS__STR_TO_STR(Ra.s+257,Rd.s+282);
  if (F_sbttl!=NULL) PAS__STR_TO_STR(Ra.s+514,F_sbttl);
  else PAS__STR_TO_STR(Ra.s+514,Rd.s+284);
  Ra.sl[196]=392; /* line # 392 */
  Rv0=(*F_p)!=NULL;
  if ((*F_p)==NULL) (*F_p)=P_lst_allocate();
  else P_lst_close(F_p,0);
  Rv1=(*F_p);
  Ra.sl[196]=397; /* line # 397 */
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[13],PAS__f_output);
    ((UB *)Rv1)[48]=4;
    PAS__iostatus=0;
  }
  else {
    Ra.sl[196]=405; /* line # 405 */
    Rv2=4098|V_lst_spc_mode;
    if (F_bprint) ((UB *)Rv1)[48]=1;
    if (F_bappend) Rv2=Rv2|4;
    if (F_bunknown) Rv2=Rv2|64;
    PAS__OPEN(((V *)Rv1)+13,0, F_fspc,Rv2,0,-1);
  }
  Ra.sl[196]=412; /* line # 412 */
  if (PAS__iostatus==0) {
    if (PAS__TTY_FILE(((V *)Rv1)[13])) {
      ((UB *)Rv1)[48]=((UB *)Rv1)[48]|2;
      Ra.sl[196]=417; /* line # 417 */
      ((UB *)Rv1)[48]=((UB *)Rv1)[48]&~1;
      if (F_lnsize<0) F_lnsize=80;
      if (F_pgsize<0) F_pgsize=0;
    }
    else {
      Ra.sl[196]=423; /* line # 423 */
      if (F_lnsize<0) F_lnsize=132;
      if (F_pgsize<0) F_pgsize=-1;
    }
    Rv3=F_lnsize;
    ((V *)Rv1)[1]=PAS__NEW((SL)Rv3+2);
    ((UB *)((V *)Rv1)[1])[0]=Rv3;
    Ra.sl[196]=428; /* line # 428 */
    ((UB *)((V *)Rv1)[1])[1]=0;
    Rv4=F_lnsize-1;
    ((SL *)Rv1)[11]=F_pgsize;
    ((SL *)Rv1)[10]=F_lnsize;
    ((SL *)Rv1)[9]=((SL *)Rv1)[10];
    Ra.sl[196]=433; /* line # 433 */
    ((SL *)Rv1)[6]=((SL *)Rv1)[11];
    Rv5=0;
    if (Ra.ub[1]>0) {
      Rv5=1;
      P_lst_change_heading(Ra.s,0);
    }
    if (Ra.ub[258]>0) {
      Rv5=1;
      P_lst_change_title(Ra.s+257,0);
    }
    Ra.sl[196]=438; /* line # 438 */
    if (Ra.ub[515]>0) {
      Rv5=1;
      P_lst_change_subtitle(Ra.s+514,1);
    }
    if (Rv5&&((SL *)Rv1)[11]<0) {
      PAS__SELECT_OUT(((V *)Rv1)[13]);
      PAS__WRITE_EOLN();
    }
    (*F_ierr)=0;
  }
  else (*F_ierr)=2000+PAS__iostatus;
  Ra.sl[196]=444; /* line # 444 */
  if ((*F_ierr)!=0) {
    if (!Rv0) P_lst_free(F_p);
  }
  PAS__curr_cntx=Ra.v[193];
}


/* Procedure/Function : " lst_newline "  */
void P_lst_newline(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+286;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=454; /* line # 454 */
  Rv0=V_lst_current;
  if (!(64&((UB *)Rv0)[48])) {
    if (((SL *)Rv0)[11]>=10) {
      ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
      Ra.sl[3]=459; /* line # 459 */
      if (((SL *)Rv0)[6]>=((SL *)Rv0)[11]) {
        ((SL *)Rv0)[6]=0;
        ((SL *)Rv0)[7]=((SL *)Rv0)[7]+1;
        PAS__PAGE(((V *)Rv0)[13]);
        Ra.sl[3]=464; /* line # 464 */
        if (((V *)Rv0)[2]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
          if (((SL *)Rv0)[10]<110) {
            ((SL *)Rv0)[6]=1;
            PAS__SELECT_OUT(((V *)Rv0)[13]);
            PAS__WRITE_EOLN();
          }
          else {
            PAS__SELECT_OUT(((V *)Rv0)[13]);
            PAS__WRITE_STR(Rd.s+171,-1,-1,32);
          }
          Ra.sl[3]=469; /* line # 469 */
          PAS__DATE_STR(V_lst_date.s);
          PAS__TIME_STR(V_lst_time.s);
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
          PAS__WRITE_FCHAR(32,4,-1,1,32);
          PAS__WRITE_STR(Rd.s+299,-1,-1,32);
          PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
          PAS__WRITE_EOLN();
        }
        if (((V *)Rv0)[4]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
        }
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_EOLN();
        Ra.sl[3]=474; /* line # 474 */
        if (((V *)Rv0)[5]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_EOLN();
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
          PAS__WRITE_EOLN();
          ((SL *)Rv0)[6]=((SL *)Rv0)[6]+2;
        }
        Ra.sl[3]=480; /* line # 480 */
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_EOLN();
        ((SL *)Rv0)[6]=((SL *)Rv0)[6]+3;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_eoln "  */
void P_lst_eoln(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+306;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=493; /* line # 493 */
  P_lst_newline();
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (64&((UB *)Rv0)[48]) {
    Ra.sl[3]=498; /* line # 498 */
    P_vls_nextstring();
    ((UB *)Rv0)[48]=((UB *)Rv0)[48]&~8;
  }
  else {
    Ra.sl[3]=503; /* line # 503 */
    if (((UB *)Rv1)[1]>0) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      ((UB *)Rv1)[1]=0;
    }
    Ra.sl[3]=508; /* line # 508 */
    if (8&((UB *)Rv0)[48]) ((UB *)Rv0)[48]=((UB *)Rv0)[48]&~8;
    else {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  while (((UB *)Rv1)[1]<((SL *)Rv0)[8]){
    Ra.sl[3]=513; /* line # 513 */
    ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
    ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_breakoutput "  */
void P_lst_breakoutput(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+316;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=525; /* line # 525 */
  Rv0=V_lst_current;
  ((UB *)Rv0)[48]=((UB *)Rv0)[48]|8;
  P_lst_eoln();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_page "  */
void P_lst_page(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+333;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=537; /* line # 537 */
  P_lst_eoln();
  Rv0=V_lst_current;
  if (((SL *)Rv0)[11]>=10) ((SL *)Rv0)[6]=((SL *)Rv0)[11];
  else {
    if (!(64&((UB *)Rv0)[48])) PAS__PAGE(((V *)Rv0)[13]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_column "  */
void P_lst_set_column(SL F_col){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+343;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=549; /* line # 549 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (F_col>((SL *)Rv0)[9]) P_lst_eoln();
  else {
    Ra.sl[3]=554; /* line # 554 */
    F_col=F_col-1;
    if (((UB *)Rv1)[1]>F_col) P_lst_eoln();
    while (((UB *)Rv1)[1]<F_col){
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      Ra.sl[3]=559; /* line # 559 */
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_margin "  */
void P_lst_set_margin(SL F_lm, SL F_rm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+359;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=572; /* line # 572 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if ((F_lm>=0&&F_rm>F_lm)&&F_rm<=((SL *)Rv0)[10]) {
    Rv2=((SL *)Rv0)[8];
    ((SL *)Rv0)[8]=F_lm;
    Ra.sl[3]=577; /* line # 577 */
    ((SL *)Rv0)[9]=F_rm;
    if (((UB *)Rv1)[1]>Rv2) P_lst_eoln();
    else while (((UB *)Rv1)[1]<F_lm){
      Ra.sl[3]=583; /* line # 583 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_skip_line "  */
void P_lst_skip_line(SL F_nli){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+375;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=594; /* line # 594 */
  if (((SL *)V_lst_current)[11]<0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+390,-1,-1,32);
    PAS__WRITE_INT(F_nli,0,0);
    PAS__WRITE_EOLN();
  }
  else while (F_nli>0){
    Ra.sl[3]=599; /* line # 599 */
    P_lst_eoln();
    F_nli=F_nli-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_char_attr "  */
void P_lst_set_char_attr(V F_sattr){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+402;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=612; /* line # 612 */
  Rv0=V_lst_current;
  if (((SL *)Rv0)[11]<0) {
    Rv1=1;
    PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+423,3);
    Ra.sl[3]=617; /* line # 617 */
    Rv2=1;
    for( Rf0=((UB *)F_sattr)[1];Rf0>0;Rf0-- ) {
      switch (((C *)F_sattr)[Rv2+1]) {
        case 43:Rv1=1;
        break;
        case 45:Rv1=0;
        break;
        case 66:
        case 71:
        case 98:
        case 103:Ra.sl[3]=624; /* line # 624 */
        if (Rv1) Ra.c[16]=66;
        else Ra.c[16]=78;
        break;
        case 73:
        case 105:if (Rv1) Ra.c[17]=73;
        else Ra.c[17]=78;
        break;
        case 83:
        case 85:
        case 115:
        case 117:Ra.sl[3]=631; /* line # 631 */
        if (Rv1) Ra.c[18]=83;
        else Ra.c[18]=78;
        break;
        case 78:
        case 110:Rv1=1;
        PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+428,3);
        break;
        default:break;
      }
      Rv2++;
    }
    Ra.sl[3]=638; /* line # 638 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+431,-1,-1,32);
    PAS__WRITE_STR(F_sattr,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_test_line "  */
void P_lst_test_line(SL F_iskip, SL F_tstli){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+444;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=647; /* line # 647 */
  Rv0=V_lst_current;
  if (((SL *)Rv0)[11]>10) {
    if (F_tstli>((SL *)Rv0)[11]/2) F_tstli=((SL *)Rv0)[11]/2;
    if (F_iskip>F_tstli) F_iskip=F_tstli;
    Ra.sl[3]=652; /* line # 652 */
    if (((SL *)Rv0)[11]-((SL *)Rv0)[6]>=F_tstli) P_lst_skip_line(F_iskip);
    else((SL *)Rv0)[6]=((SL *)Rv0)[11]+1;
  }
  else {
    if (((SL *)Rv0)[11]<0) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+459,-1,-1,32);
      PAS__WRITE_INT(F_iskip,0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_tstli,0,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_char "  */
void P_lst_put_char(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+472;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=667; /* line # 667 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((UB *)Rv1)[1]>=((SL *)Rv0)[9]) P_lst_eoln();
  ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
  ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_mchar "  */
void P_lst_put_mchar(C F_ch, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+486;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=679; /* line # 679 */
  Rv0=V_lst_current;
  if (F_m>0) while (F_m>0){
    Ra.sl[3]=684; /* line # 684 */
    P_lst_put_char(F_ch);
    F_m=F_m-1;
  }
  else {
    Rv1=((V *)Rv0)[1];
    Ra.sl[3]=690; /* line # 690 */
    F_m= -F_m-1;
    if (F_m>=((UB *)Rv1)[0]) F_m=0;
    if (((UB *)Rv1)[1]>F_m) P_lst_eoln();
    while (((UB *)Rv1)[1]<F_m){
      Ra.sl[3]=695; /* line # 695 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_string "  */
void P_lst_put_string(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+501;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=712; /* line # 712 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((UB *)F_str)[1]>0) {
    Rv2=((SL *)Rv0)[9]-((SL *)Rv0)[8];
    Ra.sl[3]=717; /* line # 717 */
    if (Rv2>=((UB *)F_str)[1]) {
      if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<((UB *)F_str)[1]) P_lst_eoln();
      Ra.sl[3]=722; /* line # 722 */
      Rv3=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        P_lst_put_char(((C *)F_str)[Rv3+1]);
        Rv3++;
      }
    }
    else {
      Rv4=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[3]=727; /* line # 727 */
        P_lst_put_char(((C *)F_str)[Rv4+1]);
        Rv4++;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_int "  */
void P_lst_put_int(SL F_int, SL F_size, SL F_base){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=34;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+517;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=739; /* line # 739 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<abs(F_size)) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_INT(F_int, F_size, F_base);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_put_float "  */
void P_lst_put_float(G F_dv, SL F_fs, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+530;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=755; /* line # 755 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_es);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_put_fixed "  */
void P_lst_put_fixed(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+545;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=771; /* line # 771 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_dcmin);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_g_init "  */
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+560;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=793; /* line # 793 */
  V_lst_hde=NULL;
  V_lst_current=NULL;
  P_lst_open(&V_lst_current, F_def_lst,F_def_heading,Rd.s+572,Rd.s+572,132,-1,0,0,0,
  F_ierr);
  PAS__curr_cntx=Ra.v[0];
}
