/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 1624 ) = {
  7,   7, 116,  97,  98,  95, 110, 101, 119,  59,  59,  47, 104, 111, 109, 101,
 47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115,
104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95,  86,
 51,  95,  65,  95, 115, 114,  99,  47, 112,  99, 109, 112,  95, 105, 100, 101,
110, 116,  46, 112,  97, 115,   8,   8, 116,  97,  98,  95, 102, 114, 101, 101,
  8,   8, 115, 116, 114,  95,  99, 111, 112, 121,  11,  11, 115, 114,  99,  95,
101, 114, 114, 111, 114,  95, 115,   7,   7, 118,  97, 108,  95, 110, 101, 119,
  8,   8, 118,  97, 108,  95, 102, 114, 101, 101,   4,   4,  86,  70,  82,  69,
 13,  13, 118,  97, 108,  95, 102, 114, 101, 101,  95, 116, 114, 101, 101,   8,
  8, 118,  97, 108,  95,  99, 111, 112, 121,   7,   7,  97, 108, 108,  95, 110,
101, 119,   8,   8,  97, 108, 108,  95, 102, 114, 101, 101,   7,   7, 108, 103,
116,  95, 110, 101, 119,  11,  11,  97, 108, 108,  95, 110, 101, 119,  95, 116,
109, 112,  12,  12, 108, 103, 116,  95, 110, 101, 119,  95,  99, 111, 112, 121,
 13,  13, 108, 103, 116,  95,  99, 111, 112, 121,  95, 116, 114, 101, 101,   8,
  8, 108, 103, 116,  95, 102, 114, 101, 101,  13,  13, 108, 103, 116,  95, 102,
114, 101, 101,  95, 116, 114, 101, 101,  14,  14, 108, 103, 116,  95, 110, 101,
119,  95, 101,  99, 111, 110, 115, 116,  15,  15, 108, 103, 116,  95, 110, 101,
119,  95, 101,  99, 111, 110, 115, 116, 114,  14,  14, 108, 103, 116,  95, 103,
101, 116,  95, 101,  99, 111, 110, 115, 116,  11,  11, 108, 103, 116,  95, 105,
109,  97, 115, 107, 112,  50,  12,  12, 108, 103, 116,  95, 110, 101, 119,  95,
 99, 111, 100, 101,  12,  12, 108, 103, 116,  95, 110, 101, 119,  95,  99,  97,
108, 108,   8,   8, 108, 103, 116,  95, 108, 105, 110, 107,  13,  13, 108, 103,
116,  95, 110, 101, 119,  95, 105, 100, 114, 101, 102,  10,  10, 108, 103, 116,
 95, 116, 109, 112, 114, 101, 102,  14,  14, 108, 103, 116,  95, 110, 101, 119,
 95,  97, 100, 100, 115, 117,  98,  14,  14, 110, 101, 119,  95, 100, 105, 115,
112,  95, 108, 101, 118, 101, 108,   4,   4,  78,  68,  76,  86,  16,  16, 105,
100, 101,  95, 114, 101, 115, 101, 114, 118, 101,  95, 100, 105, 115, 112,   5,
  5, 109,  97, 116,  99, 104,  12,  12, 110, 101, 119,  95, 105, 110, 116,  95,
110,  97, 109, 101,  12,  12, 108, 101, 118, 101, 108,  95, 115, 101,  97, 114,
 99, 104,  10,  10, 108, 101, 120,  95, 115, 101,  97, 114,  99, 104,   9,   9,
 97, 110, 121,  95,  99, 108,  97, 115, 115,   7,   7, 105, 100, 101,  95, 110,
101, 119,   4,   4,  78,  69,  87,  73, 102,  29,  10,  10, 105, 100, 101,  95,
115, 101,  97, 114,  99, 104,   4,   4,  83,  82,  67,  73,  11,  11, 103, 101,
110,  95,  99, 110, 116, 120, 118,  97, 114,  12,  12, 108, 103, 116,  95, 110,
101, 119,  95, 108, 105, 110, 101,  13,  13, 103, 101, 110,  95, 108, 105, 110,
101, 116, 114,  97,  99, 101,  11,  11, 108,  97,  98, 101, 108,  95, 112, 117,
114, 103, 101,   4,   4,  76,  65,  66,  80,  14,  14, 116, 121, 112,  95,  97,
108, 105, 103, 110, 101, 109, 101, 110, 116,  13,  13, 105, 100, 101,  95, 116,
121, 112,  95,  97, 108, 105, 103, 110,  16,  16,  97, 108, 108,  95, 116, 121,
112,  95,  97, 108, 108, 111,  99,  97, 116, 101,  12,  12,  99, 116, 101,  95,
 97, 108, 108, 111,  99,  97, 116, 101,  11,  11, 105, 100, 101,  95, 110, 101,
119,  95, 116, 121, 112,  17,  17, 105, 100, 101,  95, 110, 101, 119,  95, 116,
121, 112,  95, 114,  97, 110, 103, 101,  15,  15, 116, 109, 112, 115, 116, 107,
 95,  97, 108, 108, 111,  99,  97, 116, 101,  11,  11, 116, 109, 112, 115, 116,
107,  95, 102, 114, 101, 101,  13,  13, 102, 114, 101, 101,  95, 105, 100, 101,
 95, 108, 105, 115, 116,  13,  13, 102, 114, 101, 101,  95, 116, 121, 112,  95,
108, 105, 115, 116,  13,  13, 102, 114, 101, 101,  95, 111, 112, 101,  95, 108,
105, 115, 116,  17,  17, 102, 114, 101, 101,  95, 103, 101, 110, 101, 114, 105,
 99,  95, 108, 105, 115, 116,  12,  12, 105, 100, 101,  95, 102, 114, 101, 101,
 95, 108, 101, 120,  15,  15, 105, 100, 101,  95,  99, 114, 101,  97, 116, 101,
 95, 110,  97, 109, 101,  13,  13, 105, 100, 101,  95, 105, 110, 116,  95, 108,
 97,  98, 101, 108,   4,   4,  73,  76,  65,  66,  22,  22, 105, 100, 101,  95,
115, 101,  97, 114,  99, 104,  95, 102, 114, 111, 109,  95, 110,  97, 109, 101,
105, 100,  15,  15, 115, 101, 116,  95, 103,  98, 108,  95, 100, 101, 102,  95,
110,  97, 109,  16,  16, 115, 101, 116,  95, 101, 110, 118,  95, 102, 105, 108,
101,  95, 115, 112,  99,  13,  13, 119, 105, 101, 119,  95, 111, 112, 101, 114,
 95, 100, 101, 102,  15,  15,  32,  42,  32,  72, 101, 114, 101,  32, 105, 115,
 32, 116, 104, 101,  32,  23,  23,  32, 101, 110, 116, 114, 121,  32, 100, 101,
102, 105, 110, 105, 116, 105, 111, 110,  32, 108, 105, 115, 116,  58,   0,   0,
 33,   0,   0,   0,  17,   9, 102, 111, 114, 109,  95,  99, 104,  97, 114,   0,
  0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 108, 105, 116,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 105,
110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,
 95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,   0,   0,  11, 102, 111,
114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,   0,   0,   0,   0,  12,
102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101, 114,   0,   0,   0,   0,
  0,   9, 102, 111, 114, 109,  95, 102, 105, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   0,  10, 102, 111, 114, 109,  95,  97, 114, 114,  97, 121,   0,   0,
  0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95,  99, 111, 110, 102,   0,
  0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 114, 101,  99,
111, 114, 100,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 115,
101, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,
 95, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111,
114, 109,  95, 102, 101, 110, 116, 114, 121,   0,   0,   0,   0,   0,   0,   8,
102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,   0,   0,   0,   0,   0,
  0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110, 110, 117, 109,   0,   0,
  0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 119, 102, 105, 108, 101,
  0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 115, 101,
116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 119,
108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,
 95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,  12, 102, 111,
114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   9,
102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,   0,   0,   0,   0,   0,
  0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103, 101,   0,   0,   0,   0,
  0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97, 114, 105,  97, 110, 116,
  0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95, 111, 114, 103,  97, 110,
105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114, 109,  95,  99, 111, 110,
115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102, 111, 114, 109,  95, 112,
114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,  12, 102, 111, 114, 109,
 95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,   0,   0,   9, 102, 111,
114, 109,  95, 101, 113, 117, 118,   0,   0,   0,   0,   0,   0,   0,   0,   9,
102, 111, 114, 109,  95, 101, 113, 115, 101,   0,   0,   0,   0,   0,   0,   0,
  0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 116,   0,   0,   0,   0,   0,
  0,   0,   0,   9, 102, 111, 114, 109,  95, 110, 117, 108, 108,   0,   0,   0,
  0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 115, 116, 114, 105, 110,
103,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 114, 101,
101,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,  44,  32,   4,   4,  32,
 61,  62,  32,  10,  10,  80, 114, 111,  99, 101, 100, 117, 114, 101,  32,   9,
  9,  70, 117, 110,  99, 116, 105, 111, 110,  32,   2,   2,  58,  32,   5,   5,
 60,  70,  82,  77,  61,   2,   2,  44,  32,   2,   2,  58,  32,   5,   5,  60,
 70,  82,  77,  61,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 264 ) = {
  0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern V V_val_free_list;
extern SL V_curr_lex;
extern V V_all_free_list;
extern V V_pro_current;
extern UB V_cmp_genenv;
extern V V_lgt_free_list;
extern V V_int_typ;
extern SL V_curr_disp;
extern Blk(V_lex_ident_tree, 2344 );
extern V V_curr_ident;
extern Blk(V_sy_ident, 32 );
extern SL V_ident_disp;
extern Blk(V_lex_ident_level, 128 );
extern SL V_cprc_disp;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern UB V_sy_var_init_mod;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_std_err_file;
extern Blk(V_sy_string, 264 );
extern UB V_err_prt;
extern Blk(V_ide_udptr, 64 );
extern V V_cntx_varbl;
extern V V_cntx_typ;
extern SL V_cmp_trace;
extern V V_src_control;
extern SL V_cmp_tracecount;
extern UB V_cntx_srinf;
extern Blk(V_typ_std, 136 );
extern V V_srf_list;
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_all_fdata;
extern V V_all_ldata;
extern SL V_inte_size;
extern V V_wildtmp_stk;
extern V V_wildtmp_typ;
extern Blk(V_wildtmp_pal, 8 );
extern SL V_wildtmp_psz;
extern Blk(V_ope_table, 120 );
extern SL V_sy_ival;
extern Blk(V_sy_sym, 8 );
extern V V_env_first;
extern V V_env_last;
extern V PAS__f_output;
extern Blk(V_opname, 960 );


/* Function/procedure prototypes. */
void P_err_put_symbol(V F_symb, SL F_len);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_val_free_tree(V *F_p);
void P_free_typ_list(V *F_p);
void P_free_generic_list(V *F_f, V *F_l);


/* Procedure/Function : " tab_new "  */
V P_tab_new(SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=92; /* line # 92 */
  Ret=PAS__NEW(F_sz*4);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " tab_free "  */
void P_tab_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+70;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=101; /* line # 101 */
  PAS__DISPOSE(F_p);
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_copy "  */
void P_str_copy(V *F_target, V *F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+80;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=114; /* line # 114 */
  if ((*F_target)!=(*F_src)) {
    if ((*F_src)==NULL) {
      if ((*F_target)!=NULL) ((UB *)(*F_target))[1]=0;
    }
    else {
      Ra.sl[3]=122; /* line # 122 */
      if (((UB *)(*F_src))[1]>0&&(*F_target)==NULL) {
        Rv0=((UB *)(*F_src))[1];
        (*F_target)=PAS__NEW((SL)Rv0+2);
        ((UB *)(*F_target))[0]=Rv0;
      }
      (*F_target)=(*F_src);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error_s "  */
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+52,F_modulesy,4);
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+90;
  Ra.v[11]=Rd.s+9;
  Ra.sl[12]=138; /* line # 138 */
  if (F_id1!=NULL) {
    Ra.ub[1]=((UB *)F_id1)[0];
    Rv0=1;
    for( Rf0=((UB *)F_id1)[0];Rf0>0;Rf0-- ) {
      Ra.c[Rv0+1]=((C *)F_id1)[Rv0];
      Rv0++;
    }
    Ra.sl[12]=143; /* line # 143 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  if (F_id2!=NULL) {
    Ra.sl[12]=148; /* line # 148 */
    Ra.ub[1]=((UB *)F_id2)[0];
    Rv1=1;
    for( Rf0=((UB *)F_id2)[0];Rf0>0;Rf0-- ) {
      Ra.c[Rv1+1]=((C *)F_id2)[Rv1];
      Rv1++;
    }
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  P_src_error(Ra.s+52,F_number, F_severity);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " val_new "  */
void P_val_new(V *F_p, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=161; /* line # 161 */
  if ((*F_p)==NULL) {
    if (V_val_free_list==NULL) (*F_p)=PAS__NEW(48);
    else {
      Ra.sl[3]=167; /* line # 167 */
      (*F_p)=V_val_free_list;
      V_val_free_list=((V *)(*F_p))[0];
    }
    Rv0=(*F_p);
    Ra.sl[3]=172; /* line # 172 */
    ((V *)Rv0)[0]=NULL;
    ((SL *)Rv0)[1]=0;
    ((SL *)Rv0)[2]=1;
    ((UW *)Rv0)[6]=16416;
    ((SL *)Rv0)[4]=-1;
    Ra.sl[3]=177; /* line # 177 */
    ((SL *)Rv0)[5]=0;
    ((SL *)Rv0)[6]=V_curr_lex;
    ((V *)Rv0)[7]=F_ty;
    ((V *)Rv0)[8]=NULL;
    if (F_ty==NULL) ((UB *)Rv0)[36]=31;
    else {
      Ra.sl[3]=184; /* line # 184 */
      ((UB *)Rv0)[36]=((UB *)F_ty)[52];
      switch (((UB *)Rv0)[36]) {
        case 0:
        case 1:
        case 2:
        case 14:
        case 15:
        case 22:((SL *)Rv0)[10]=0;
        break;
        case 3:
        case 4:Ra.sl[3]=190; /* line # 190 */
        ((G *)Rv0)[5]=0.000000000000000E-001;
        break;
        case 32:((V *)Rv0)[10]=NULL;
        break;
        case 7:
        case 8:
        case 9:((V *)Rv0)[10]=NULL;
        break;
        case 11:
        case 18:Ra.sl[3]=196; /* line # 196 */
        ((V *)Rv0)[10]=NULL;
        break;
        case 12:((V *)Rv0)[10]=NULL;
        break;
        case 21:((V *)Rv0)[10]=NULL;
        break;
        default:break;
      }
    }
  }
  else {
    Ra.sl[3]=207; /* line # 207 */
    Rv1=(*F_p);
    ((SL *)Rv1)[2]=((SL *)Rv1)[2]+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_free "  */
void P_val_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+112;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=217; /* line # 217 */
  Rv0=(*F_p);
  if (((SL *)Rv0)[2]==1&&((UB *)Rv0)[36]!=33) {
    switch (((UB *)Rv0)[36]) {
      case 32:if (((V *)Rv0)[10]!=NULL) PAS__DISPOSE(((V *)Rv0)+10);
      break;
      case 7:
      case 8:
      case 9:Ra.sl[3]=223; /* line # 223 */
      P_val_free_tree(((V *)Rv0)+10);
      break;
      case 21:if (((V *)Rv0)[10]!=NULL) P_tab_free(((V *)Rv0)+10);
      break;
      case 11:if (((V *)Rv0)[10]!=NULL) PAS__DISPOSE(((V *)Rv0)+10);
      break;
      default:break;
    }
    Ra.sl[3]=228; /* line # 228 */
    ((SL *)Rv0)[2]=0;
    ((UB *)Rv0)[36]=33;
    ((V *)Rv0)[0]=V_val_free_list;
    ((SL *)Rv0)[1]=0;
    V_val_free_list=(*F_p);
  }
  else {
    Ra.sl[3]=235; /* line # 235 */
    if (((SL *)Rv0)[2]>1) ((SL *)Rv0)[2]=((SL *)Rv0)[2]-1;
    else P_src_error(Rd.s+124,998,1);
  }
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_free_tree "  */
void P_val_free_tree(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+128;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=249; /* line # 249 */
  Rv0=(*F_p);
  (*F_p)=NULL;
  while (Rv0!=NULL){
    Rv1=Rv0;
    Ra.sl[3]=254; /* line # 254 */
    if (((SL *)Rv0)[2]>1) Rv0=NULL;
    else Rv0=((V *)Rv0)[0];
    P_val_free(&Rv1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_copy "  */
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+143;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=272; /* line # 272 */
  if ((*F_v2)!=NULL) P_val_free(F_v2);
  if ((*F_v1)==NULL) (*F_v2)=NULL;
  else {
    if (F_bfree&&((SL *)(*F_v1))[2]==1) {
      Ra.sl[3]=277; /* line # 277 */
      (*F_v2)=(*F_v1);
      (*F_v1)=NULL;
    }
    else {
      P_val_new(F_v2,((V *)(*F_v1))[7]);
      Ra.sl[3]=282; /* line # 282 */
      memcpy((*F_v2),(*F_v1),48);
      Rv0=(*F_v2);
      ((V *)Rv0)[0]=NULL;
      ((SL *)Rv0)[2]=1;
      Ra.sl[3]=287; /* line # 287 */
      ((SL *)Rv0)[6]=V_curr_lex;
      switch (((UB *)Rv0)[36]) {
        case 32:if (((V *)Rv0)[10]!=NULL) {
          Ra.sl[3]=292; /* line # 292 */
          ((V *)Rv0)[10]=NULL;
          P_str_copy(((V *)Rv0)+10,((V *)(*F_v1))+10);
        }
        break;
        case 7:
        case 8:
        case 9:Ra.sl[3]=297; /* line # 297 */
        if (((V *)Rv0)[10]!=NULL) {
          Rv1=((V *)Rv0)[10];
          ((SL *)Rv1)[2]=((SL *)Rv1)[2]+1;
        }
        break;
        case 21:Ra.sl[3]=303; /* line # 303 */
        ((V *)Rv0)[10]=P_tab_new(((SL *)Rv0)[5]);
        Rv2=((V *)(*F_v1))[10];
        Rv3=0;
        for( Rf0=(((SL *)Rv0)[5]-1)+1;Rf0>0;Rf0-- ) {
          ((SL *)((V *)Rv0)[10])[Rv3]=((SL *)Rv2)[Rv3];
          Rv3++;
        }
        break;
        default:break;
      }
      Ra.sl[3]=312; /* line # 312 */
      if (F_bfree) P_val_free(F_v1);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_new "  */
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+153;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=323; /* line # 323 */
  if (V_all_free_list==NULL) (*F_p)=PAS__NEW(68);
  else {
    (*F_p)=V_all_free_list;
    V_all_free_list=((V *)(*F_p))[0];
  }
  Ra.sl[3]=328; /* line # 328 */
  Rv0=(*F_p);
  Rv1=F_ty;
  ((V *)Rv0)[0]=NULL;
  ((V *)Rv0)[1]=NULL;
  memcpy(Rv0+8,Rv1+28,1);
  Ra.sl[3]=333; /* line # 333 */
  ((V *)Rv0)[3]=F_ty;
  ((UW *)Rv0)[8]=0;
  ((UB *)Rv0)[18]=F_kind;
  ((V *)Rv0)[5]=V_pro_current;
  ((SL *)Rv0)[6]=-1;
  Ra.sl[3]=338; /* line # 338 */
  ((SL *)Rv0)[7]=abs(((SL *)Rv1)[6]);
  ((SL *)Rv0)[8]=-1;
  ((SL *)Rv0)[9]=V_curr_lex;
  ((SL *)Rv0)[10]=-1;
  ((SL *)Rv0)[11]=-1;
  Ra.sl[3]=343; /* line # 343 */
  ((V *)Rv0)[12]=NULL;
  ((V *)Rv0)[13]=NULL;
  ((V *)Rv0)[14]=NULL;
  ((V *)Rv0)[15]=F_id;
  ((V *)Rv0)[16]=NULL;
  Ra.sl[3]=349; /* line # 349 */
  if (F_id!=NULL&&((SL *)Rv1)[6]>0) {
    Rv2=F_id;
    ((SL *)Rv0)[9]=((SL *)Rv2)[5];
    ((V *)Rv0)[5]=((V *)Rv2)[6];
    Ra.sl[3]=354; /* line # 354 */
    switch (((UB *)Rv2)[28]) {
      case 7:((UW *)Rv0)[8]=16384;
      if (((V *)Rv2)[9]!=NULL) {
        Ra.sl[3]=359; /* line # 359 */
        if (1024&((UW *)((V *)Rv2)[9])[4]) ((UW *)Rv0)[8]=((UW *)Rv0)[8]|4;
      }
      break;
      case 5:Ra.sl[3]=364; /* line # 364 */
      ((SL *)Rv0)[6]=((SL *)Rv2)[8];
      ((UW *)Rv0)[8]=((UW *)Rv2)[18];
      break;
      case 4:Ra.sl[3]=370; /* line # 370 */
      if (((V *)Rv2)[8]!=NULL) {
        Rv3=((V *)Rv2)[8];
        ((SL *)Rv0)[6]=((SL *)Rv3)[4];
        ((UW *)Rv0)[8]=((UW *)Rv3)[6]|1;
      }
      else {
        Ra.sl[3]=377; /* line # 377 */
        ((UW *)Rv0)[8]=16417;
      }
      if (V_curr_lex!=((SL *)Rv0)[9]) ((UW *)Rv0)[8]=((UW *)Rv0)[8]|4;
      break;
      default:break;
    }
  }
  else {
    Ra.sl[3]=388; /* line # 388 */
    ((UW *)Rv0)[8]=97;
    if (V_curr_lex>1||!V_cmp_genenv) ((UW *)Rv0)[8]=((UW *)Rv0)[8]|16384;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_free "  */
void P_all_free(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+162;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=402; /* line # 402 */
  Rv0=F_p;
  Rv1=((V *)Rv0)[5];
  if (((V *)Rv0)[1]!=NULL) ((V *)((V *)Rv0)[1])[0]=((V *)Rv0)[0];
  else {
    Ra.sl[3]=407; /* line # 407 */
    switch (((UB *)Rv0)[18]) {
      case 2:
      case 3:break;
      default:Ra.sl[3]=412; /* line # 412 */
      if (((V *)Rv1)[26]==F_p) ((V *)Rv1)[26]=((V *)Rv0)[0];
      if (((V *)Rv1)[27]==F_p) ((V *)Rv1)[27]=((V *)Rv0)[1];
      break;
    }
  }
  Ra.sl[3]=417; /* line # 417 */
  if (((V *)Rv0)[16]!=NULL) P_val_free(((V *)Rv0)+16);
  if (F_p!=NULL) {
    Ra.sl[3]=422; /* line # 422 */
    ((V *)F_p)[0]=V_all_free_list;
    V_all_free_list=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new "  */
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+172;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=436; /* line # 436 */
  (*F_p)=NULL;
  if (V_lgt_free_list==NULL) (*F_p)=PAS__NEW(36);
  else {
    (*F_p)=V_lgt_free_list;
    V_lgt_free_list=((V *)V_lgt_free_list)[0];
  }
  Ra.sl[3]=442; /* line # 442 */
  Rv0=(*F_p);
  ((V *)Rv0)[0]=NULL;
  ((V *)Rv0)[1]=F_prm;
  ((SL *)Rv0)[2]=0;
  Ra.sl[3]=447; /* line # 447 */
  ((UW *)Rv0)[6]=3;
  ((V *)Rv0)[4]=F_ty;
  ((V *)Rv0)[5]=NULL;
  ((UB *)Rv0)[24]=F_knd;
  switch (F_knd) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 16:
    case 24:
    case 25:Ra.sl[3]=458; /* line # 458 */
    if (F_prm!=NULL) ((UW *)Rv0)[6]=((UW *)F_prm)[6]|4;
    else((UW *)Rv0)[6]=5;
    ((V *)Rv0)[7]=NULL;
    break;
    case 18:Ra.sl[3]=465; /* line # 465 */
    ((V *)Rv0)[7]=NULL;
    ((V *)Rv0)[8]=NULL;
    break;
    case 15:Ra.sl[3]=470; /* line # 470 */
    ((SL *)Rv0)[7]=0;
    break;
    case 0:((UB *)Rv0)[25]=0;
    Ra.sl[3]=475; /* line # 475 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 6:((UB *)Rv0)[25]=0;
    break;
    case 20:Ra.sl[3]=482; /* line # 482 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 17:
    case 19:
    case 21:
    case 22:
    case 23:((SL *)Rv0)[7]=0;
    break;
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:Ra.sl[3]=490; /* line # 490 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 13:((V *)Rv0)[7]=NULL;
    Ra.sl[3]=495; /* line # 495 */
    ((V *)Rv0)[8]=NULL;
    break;
    case 14:Ra.sl[3]=500; /* line # 500 */
    ((V *)Rv0)[7]=NULL;
    ((V *)Rv0)[8]=NULL;
    ((UW *)Rv0)[6]=1;
    if (F_ty!=NULL) {
      if (!((UB *)F_ty)[51]) ((UW *)Rv0)[6]=5;
    }
    break;
    default:Ra.sl[3]=509; /* line # 509 */
    ((V *)Rv0)[7]=NULL;
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_new_tmp "  */
V P_all_new_tmp(V F_ty, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+181;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=525; /* line # 525 */
  if (V_all_free_list==NULL) Rv0=PAS__NEW(68);
  else {
    Rv0=V_all_free_list;
    V_all_free_list=((V *)Rv0)[0];
  }
  Ra.sl[3]=530; /* line # 530 */
  P_lgt_new(&Rv1, F_ty,13,NULL);
  ((V *)Rv1)[8]=Rv0;
  Rv2=Rv0;
  Rv3=F_ty;
  ((V *)Rv2)[0]=NULL;
  Ra.sl[3]=535; /* line # 535 */
  ((V *)Rv2)[1]=NULL;
  memcpy(Rv2+8,Rv3+28,1);
  ((V *)Rv2)[3]=F_ty;
  ((UW *)Rv2)[8]=16481;
  ((UB *)Rv2)[18]=0;
  Ra.sl[3]=540; /* line # 540 */
  if (F_id==NULL) {
    ((V *)Rv2)[5]=V_pro_current;
    ((SL *)Rv2)[9]=V_curr_lex;
  }
  else {
    Ra.sl[3]=547; /* line # 547 */
    ((V *)Rv2)[5]=((V *)F_id)[6];
    ((SL *)Rv2)[9]=((SL *)F_id)[5];
  }
  ((SL *)Rv2)[6]=-1;
  ((SL *)Rv2)[7]=abs(((SL *)Rv3)[6]);
  Ra.sl[3]=552; /* line # 552 */
  ((SL *)Rv2)[8]=-1;
  ((SL *)Rv2)[10]=-1;
  ((SL *)Rv2)[11]=-1;
  ((V *)Rv2)[12]=NULL;
  ((V *)Rv2)[13]=NULL;
  Ra.sl[3]=557; /* line # 557 */
  ((V *)Rv2)[14]=NULL;
  ((V *)Rv2)[15]=NULL;
  ((V *)Rv2)[16]=NULL;
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_copy "  */
void P_lgt_new_copy(V F_model, V *F_copy){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=570; /* line # 570 */
  (*F_copy)=NULL;
  if (V_lgt_free_list==NULL) (*F_copy)=PAS__NEW(36);
  else {
    (*F_copy)=V_lgt_free_list;
    V_lgt_free_list=((V *)V_lgt_free_list)[0];
  }
  Ra.sl[3]=576; /* line # 576 */
  memcpy((*F_copy),F_model,36);
  Rv0=(*F_copy);
  if (((UB *)Rv0)[24]==14) {
    if (((V *)Rv0)[8]!=NULL) {
      Rv1=((V *)Rv0)[8];
      ((SL *)Rv1)[2]=((SL *)Rv1)[2]+1;
    }
  }
  ((V *)(*F_copy))[0]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_copy_tree "  */
void P_lgt_copy_tree(V F_src, V *F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+208;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=591; /* line # 591 */
  if (F_src!=NULL) {
    if (((UB *)F_src)[24]==16) P_lgt_copy_tree(((V *)F_src)[1],F_dst);
    else {
      Rv0=((V *)F_src)[1];
      Ra.sl[3]=596; /* line # 596 */
      Rv1=NULL;
      while (Rv0!=NULL){
        P_lgt_copy_tree(Rv0, &Rv2);
        if (Rv1==NULL) Rv1=Rv2;
        else {
          Ra.sl[3]=601; /* line # 601 */
          ((V *)Rv3)[0]=Rv2;
        }
        Rv3=Rv2;
        Rv0=((V *)Rv0)[0];
      }
      P_lgt_new_copy(F_src, F_dst);
      Ra.sl[3]=606; /* line # 606 */
      ((V *)(*F_dst))[1]=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_free "  */
void P_lgt_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+223;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=616; /* line # 616 */
  Rv0=(*F_p);
  if (((UB *)Rv0)[24]!=25) {
    if (((UB *)Rv0)[24]==14) {
      if (((V *)Rv0)[8]!=NULL) P_val_free(((V *)Rv0)+8);
    }
    Ra.sl[3]=621; /* line # 621 */
    ((V *)Rv0)[0]=V_lgt_free_list;
    ((UB *)Rv0)[24]=25;
    V_lgt_free_list=(*F_p);
  }
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_free_tree "  */
void P_lgt_free_tree(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+233;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=637; /* line # 637 */
  Rv0=(*F_p);
  while (Rv0!=NULL)
  if (((UB *)Rv0)[24]==25) Rv0=NULL;
  else {
    if (((UB *)Rv0)[24]!=16) {
      Ra.sl[3]=642; /* line # 642 */
      P_lgt_free_tree(((V *)Rv0)+1);
    }
    Rv1=((V *)Rv0)[0];
    P_lgt_free(&Rv0);
    Rv0=Rv1;
  }
  Ra.sl[3]=647; /* line # 647 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new_econst "  */
V P_lgt_new_econst(V F_ty, SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+248;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=659; /* line # 659 */
  P_lgt_new(&Rv0, F_ty,14,NULL);
  Rv1=Rv0;
  ((V *)Rv1)[8]=NULL;
  P_val_new(((V *)Rv1)+8,F_ty);
  Ra.sl[3]=664; /* line # 664 */
  ((SL *)((V *)Rv1)[8])[10]=F_iv;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_econstr "  */
V P_lgt_new_econstr(V F_ty, G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+264;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=678; /* line # 678 */
  P_lgt_new(&Rv0, F_ty,14,NULL);
  Rv1=Rv0;
  ((V *)Rv1)[8]=NULL;
  P_val_new(((V *)Rv1)+8,F_ty);
  Ra.sl[3]=683; /* line # 683 */
  ((G *)((V *)Rv1)[8])[5]=F_rv;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_get_econst "  */
SL P_lgt_get_econst(V F_lgt, SL F_idf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+281;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=697; /* line # 697 */
  Rv0=F_idf;
  if (F_lgt!=NULL) {
    Rv1=F_lgt;
    if (((UB *)Rv1)[24]==14&&((V *)Rv1)[8]!=NULL) {
      Rv2=((V *)Rv1)[8];
      Ra.sl[3]=702; /* line # 702 */
      switch (((UB *)Rv2)[36]) {
        case 0:
        case 1:
        case 2:Rv0=((SL *)Rv2)[10];
        break;
        default:break;
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_imaskp2 "  */
SL P_lgt_imaskp2(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+297;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=720; /* line # 720 */
  Rv0=-1;
  if (F_lgt!=NULL) {
    Rv1=F_lgt;
    if (((UB *)Rv1)[24]==14&&((V *)Rv1)[8]!=NULL) {
      Rv2=((V *)Rv1)[8];
      Ra.sl[3]=726; /* line # 726 */
      switch (((UB *)Rv2)[36]) {
        case 0:
        case 1:
        case 2:Rv3=((SL *)Rv2)[10];
        if (Rv3!=0) {
          Ra.sl[3]=732; /* line # 732 */
          Rv0=0;
          while (!(Rv3&1)){
            Rv3=Rv3/2;
            Rv0=Rv0+1;
          }
          if (Rv3==1) {
            Ra.sl[3]=737; /* line # 737 */
            Rv3=((SL *)Rv2)[10]-1;
            ((SL *)Rv2)[10]=Rv3;
          }
          else Rv0=-1;
        }
        break;
        default:break;
      }
    }
  }
  Ra.sl[3]=746; /* line # 746 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_code "  */
V P_lgt_new_code(UB F_pcd, V F_par){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+310;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=758; /* line # 758 */
  P_lgt_new(&Rv0, V_int_typ,6, F_par);
  ((UB *)Rv0)[25]=F_pcd;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_call "  */
V P_lgt_new_call(V F_pty, V F_pro, V F_par){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+324;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=772; /* line # 772 */
  P_lgt_new(&Rv0, F_pty,8, F_par);
  if (F_pty!=NULL) {
    if (!((UB *)F_pty)[51]) {
      Rv1=Rv0;
      ((UW *)Rv1)[6]=((UW *)Rv1)[6]|4;
    }
  }
  Ra.sl[3]=777; /* line # 777 */
  ((V *)Rv0)[7]=F_pro;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_link "  */
V P_lgt_link(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+338;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=790; /* line # 790 */
  P_lgt_new(&Rv0,((V *)F_lgt)[4],16, F_lgt);
  ((UW *)Rv0)[6]=((UW *)F_lgt)[6];
  ((UW *)F_lgt)[6]=((UW *)F_lgt)[6]|256;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_idref "  */
V P_lgt_new_idref(V F_id, V F_lnk){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+348;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=805; /* line # 805 */
  Rv0=NULL;
  Rv1=F_id;
  switch (((UB *)Rv1)[28]) {
    case 5:Ra.sl[3]=811; /* line # 811 */
    P_lgt_new(&Rv0,((V *)Rv1)[4],13,NULL);
    Rv2=Rv0;
    ((V *)Rv2)[0]=F_lnk;
    ((V *)Rv2)[5]=F_id;
    Ra.sl[3]=816; /* line # 816 */
    ((V *)Rv2)[7]=F_id;
    ((UW *)Rv1)[18]=((UW *)Rv1)[18]|1;
    ((V *)Rv2)[8]=((V *)F_id)[12];
    ((UW *)Rv2)[6]=4;
    if (32&((UW *)Rv1)[18]) ((UW *)Rv2)[6]=((UW *)Rv2)[6]|1;
    Ra.sl[3]=821; /* line # 821 */
    if (64&((UW *)Rv1)[18]) ((UW *)Rv2)[6]=((UW *)Rv2)[6]|2;
    break;
    case 4:Ra.sl[3]=827; /* line # 827 */
    P_lgt_new(&Rv0,((V *)Rv1)[4],14,NULL);
    Rv3=Rv0;
    ((V *)Rv3)[0]=F_lnk;
    ((V *)Rv3)[5]=F_id;
    Ra.sl[3]=832; /* line # 832 */
    if (((V *)Rv3)[4]!=NULL) {
      if (((UB *)((V *)Rv3)[4])[51]) {
        P_val_copy(((V *)Rv1)+8,((V *)Rv3)+8,0);
        Rv4=((V *)Rv3)[8];
        Ra.sl[3]=838; /* line # 838 */
        ((V *)Rv4)[7]=((V *)Rv3)[4];
        ((UB *)Rv4)[36]=((UB *)((V *)Rv3)[4])[52];
      }
    }
    if (((V *)Rv3)[8]==NULL) {
      Ra.sl[3]=844; /* line # 844 */
      ((V *)Rv3)[8]=((V *)Rv1)[8];
      P_val_new(((V *)Rv3)+8,NULL);
    }
    break;
    default:break;
  }
  Ra.sl[3]=865; /* line # 865 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_tmpref "  */
V P_lgt_tmpref(V F_ty, UB F_nwt, UB F_frt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+363;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=876; /* line # 876 */
  P_lgt_new(&Rv0, F_ty,18,NULL);
  Rv1=Rv0;
  ((V *)Rv1)[7]=NULL;
  ((V *)Rv1)[8]=NULL;
  Ra.sl[3]=881; /* line # 881 */
  if (F_nwt) ((UW *)Rv1)[6]=((UW *)Rv1)[6]|512;
  if (F_frt) ((UW *)Rv1)[6]=((UW *)Rv1)[6]|1024;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_addsub "  */
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+375;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=897; /* line # 897 */
  Rv0=NULL;
  Rv1=((V *)F_lgt1)[4];
  if (((UB *)F_lgt1)[24]==14) {
    Rv2=((SL *)((V *)F_lgt1)[8])[10];
    Ra.sl[3]=902; /* line # 902 */
    if (((UB *)F_lgt2)[24]==14) {
      Rv3=((SL *)((V *)F_lgt2)[8])[10];
      if (F_bsub) Rv0=P_lgt_new_econst(Rv1, Rv2-Rv3);
      else Rv0=P_lgt_new_econst(Rv1, Rv2+Rv3);
      Ra.sl[3]=907; /* line # 907 */
      if (F_bfree) {
        P_lgt_free(&F_lgt1);
        P_lgt_free(&F_lgt2);
      }
    }
    else {
      Ra.sl[3]=913; /* line # 913 */
      if (Rv2==0) {
        if (F_bfree) P_lgt_free(&F_lgt1);
        if (F_bsub) Rv0=P_lgt_new_code(46, F_lgt2);
        else Rv0=F_lgt2;
      }
    }
  }
  else {
    Ra.sl[3]=921; /* line # 921 */
    if (((UB *)F_lgt2)[24]==14) {
      if (((SL *)((V *)F_lgt2)[8])[10]==0) {
        Rv0=F_lgt1;
        if (F_bfree) P_lgt_free(&F_lgt2);
      }
    }
  }
  Ra.sl[3]=928; /* line # 928 */
  if (Rv0==NULL) {
    ((V *)F_lgt1)[0]=F_lgt2;
    if (F_bsub) Rv0=P_lgt_new_code(50, F_lgt1);
    else Rv0=P_lgt_new_code(49, F_lgt1);
  }
  Ra.sl[3]=934; /* line # 934 */
  ((V *)Rv0)[4]=Rv1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_disp_level "  */
void P_new_disp_level(V F_ow, UB F_kind){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+391;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=947; /* line # 947 */
  if (V_curr_disp<64) {
    V_curr_disp=V_curr_disp+1;
    if (V_curr_disp>0) memcpy((V_lex_ident_tree.s+V_curr_disp*36),(V_lex_ident_tree
    .s+(V_curr_disp-1)*36),36);
    Ra.sl[3]=952; /* line # 952 */
    Rv0=(V_lex_ident_tree.s+V_curr_disp*36);
    ((SL *)Rv0)[6]=V_curr_lex;
    if (F_ow!=NULL) ((V *)Rv0)[0]=F_ow;
    Ra.sl[3]=957; /* line # 957 */
    ((V *)Rv0)[1]=NULL;
    ((V *)Rv0)[2]=NULL;
    ((UB *)Rv0)[12]=F_kind;
    ((V *)Rv0)[4]=NULL;
    ((V *)Rv0)[5]=NULL;
    Ra.sl[3]=962; /* line # 962 */
    ((SL *)Rv0)[8]=0;
  }
  else P_src_error(Rd.s+409,1001,3);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_reserve_disp "  */
void P_ide_reserve_disp(SL F_prv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+413;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=976; /* line # 976 */
  Rv0=V_lex_ident_tree.v[V_curr_disp*9];
  if (Rv0!=NULL) {
    Ra.sl[3]=981; /* line # 981 */
    Rv1=(V_lex_ident_tree.s+V_curr_disp*36);
    Rv2=Rv0;
    if (((V *)Rv1)[4]!=NULL) {
      ((V *)((V *)Rv1)[4])[3]=((V *)Rv2)[22];
      ((V *)Rv2)[22]=((V *)Rv1)[1];
    }
  }
  Ra.sl[3]=987; /* line # 987 */
  V_curr_disp=F_prv;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " match "  */
SL P_match(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+431;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1000; /* line # 1000 */
  if (((UB *)F_s1)[0]<((UB *)F_s2)[0]) Rv0=((UB *)F_s1)[0];
  else Rv0=((UB *)F_s2)[0];
  Rv1=1;
  Rv2=0;
  while (Rv1<=Rv0&&Rv2==0){
    Ra.sl[3]=1006; /* line # 1006 */
    Rv2=(SL)((C *)F_s1)[Rv1]-(SL)((C *)F_s2)[Rv1];
    Rv1=Rv1+1;
  }
  if (Rv1>Rv0&&Rv2==0) Rv2=((UB *)F_s1)[0]-((UB *)F_s2)[0];
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_int_name "  */
V P_new_int_name(V F_head, SL *F_nbs){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_head,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+438;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1026; /* line # 1026 */
  Rv0=NULL;
  Rv0=PAS__NEW(32);
  Rv1=Rv0;
  Rv2=1;
  for( Rf0=4;Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=Ra.c[Rv2+15];
    Rv2++;
  }
  Ra.sl[3]=1031; /* line # 1031 */
  Rv3=12;
  ((UB *)Rv1)[0]=Rv3;
  Rv4=(*F_nbs);
  while (Rv3>4){
    ((C *)Rv1)[Rv3]=(C)(48+PAS__I_MOD(Rv4,10));
    Ra.sl[3]=1036; /* line # 1036 */
    Rv4=Rv4/10;
    Rv3=Rv3-1;
  }
  (*F_nbs)=(*F_nbs)+1;
  Ra.sl[3]=1041; /* line # 1041 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " level_search "  */
V P_level_search(V F_fp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+452;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1055; /* line # 1055 */
  Rv0=F_fp;
  Rv1=0;
  Rs.v[0]=NULL;
  while (!Rv1&&Rv0!=NULL){
    Rv2=Rv0;
    Ra.sl[3]=1061; /* line # 1061 */
    Rs.v[0]=Rv0;
    if (V_curr_ident==NULL) Rv3=P_match(((V *)Rv2)[0],V_sy_ident.s);
    else Rv3=P_match(((V *)Rv2)[0],V_curr_ident);
    if (Rv3==0) Rv1=1;
    else {
      if (Rv3>0) {
        Ra.sl[3]=1066; /* line # 1066 */
        Rs.ub[4]=1;
        Rv0=((V *)Rv0)[1];
      }
      else {
        Rs.ub[4]=0;
        Ra.sl[3]=1071; /* line # 1071 */
        Rv0=((V *)Rv0)[2];
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lex_search "  */
V P_lex_search(SL F_disp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+466;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1087; /* line # 1087 */
  V_ident_disp=F_disp;
  if (V_lex_ident_tree.ub[V_ident_disp*36+12]==4) Rv0=4;
  else Rv0=6;
  while (1){
    Rv1=P_level_search(V_lex_ident_tree.v[V_ident_disp*9+1]);
    Ra.sl[3]=1092; /* line # 1092 */
    if (V_ident_disp==F_disp) {
      Rv2=Rs.v[0];
      Rv3=Rs.ub[4];
    }
    V_ident_disp=V_ident_disp-1;
    if ((Rv1!=NULL||V_ident_disp<V_lex_ident_level.sl[V_curr_lex])||Rv0!=V_lex_ident_tree
    .ub[V_ident_disp*36+12])  break;
  }
  Ra.sl[3]=1099; /* line # 1099 */
  Rs.v[0]=Rv2;
  Rs.ub[4]=Rv3;
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " any_class "  */
UB P_any_class(UW F_fs){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+478;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1112; /* line # 1112 */
  Rv0=0;
  if (F_fs!=0) while (!(1<<Rv0&F_fs))
  Rv0=Rv0+1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_new "  */
void P_ide_new(UB F_fc, V F_ty, V *F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  SL Rv13;
  register V Rv14;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+489;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1137; /* line # 1137 */
  if (F_fc==3) Rv0=V_cprc_disp;
  else Rv0=V_curr_disp;
  Rv1=P_lex_search(Rv0);
  Ra.sl[3]=1146; /* line # 1146 */
  if (Rv1!=NULL) {
    Rv2=Rv1;
    switch (((UB *)Rv2)[28]) {
      case 5:Rv3=((UB *)Rv2)[38]==4;
      break;
      case 4:Ra.sl[3]=1151; /* line # 1151 */
      Rv3=((UB *)Rv2)[40]==4;
      break;
      default:Rv3=0;
      break;
    }
    Ra.sl[3]=1156; /* line # 1156 */
    if (!(Rv3&&V_cmp_twicedclon)) {
      V_cmp_twicedcl=1;
      P_src_error_s(Rd.s+500,101,2, V_sy_ident.s,NULL);
    }
    else {
      Ra.sl[3]=1162; /* line # 1162 */
      ((V *)Rv1)[3]=NULL;
    }
  }
  else {
    Rv1=NULL;
    Ra.sl[3]=1167; /* line # 1167 */
    switch (F_fc) {
      case 3:Rv1=PAS__NEW(52);
      Rv4=Rv1;
      Ra.sl[3]=1172; /* line # 1172 */
      ((UB *)Rv4)[29]=0;
      ((V *)Rv4)[8]=NULL;
      ((V *)Rv4)[9]=NULL;
      ((V *)Rv4)[10]=NULL;
      ((SL *)Rv4)[11]=0;
      Ra.sl[3]=1177; /* line # 1177 */
      ((SL *)Rv4)[12]=-1;
      break;
      case 10:Ra.sl[3]=1183; /* line # 1183 */
      Rv1=PAS__NEW(40);
      Rv5=Rv1;
      ((V *)Rv5)[8]=NULL;
      ((V *)Rv5)[9]=NULL;
      break;
      case 7:Ra.sl[3]=1193; /* line # 1193 */
      Rv1=PAS__NEW(44);
      Rv6=Rv1;
      ((V *)Rv6)[8]=NULL;
      ((V *)Rv6)[9]=NULL;
      Ra.sl[3]=1198; /* line # 1198 */
      ((V *)Rv6)[10]=NULL;
      break;
      case 1:
      case 8:
      case 9:Ra.sl[3]=1205; /* line # 1205 */
      Rv1=PAS__NEW(48);
      Rv7=Rv1;
      ((V *)Rv7)[8]=NULL;
      ((V *)Rv7)[9]=NULL;
      Ra.sl[3]=1210; /* line # 1210 */
      ((V *)Rv7)[10]=NULL;
      ((V *)Rv7)[11]=NULL;
      break;
      case 4:Ra.sl[3]=1216; /* line # 1216 */
      Rv1=PAS__NEW(41);
      Rv8=Rv1;
      ((V *)Rv8)[8]=NULL;
      ((V *)Rv8)[9]=NULL;
      Ra.sl[3]=1221; /* line # 1221 */
      ((UB *)Rv8)[40]=11;
      break;
      case 2:Ra.sl[3]=1226; /* line # 1226 */
      Rv1=PAS__NEW(52);
      Rv9=Rv1;
      ((SL *)Rv9)[8]=0;
      ((UB *)Rv9)[36]=0;
      Ra.sl[3]=1231; /* line # 1231 */
      ((V *)Rv9)[10]=NULL;
      ((V *)Rv9)[11]=NULL;
      ((V *)Rv9)[12]=NULL;
      break;
      case 5:Ra.sl[3]=1238; /* line # 1238 */
      Rv1=PAS__NEW(52);
      Rv10=Rv1;
      if (V_curr_lex>1) {
        Ra.sl[3]=1243; /* line # 1243 */
        ((SL *)Rv10)[8]=-1;
        ((UW *)Rv10)[18]=16384;
      }
      else {
        Ra.sl[3]=1248; /* line # 1248 */
        ((SL *)Rv10)[8]=V_cmp_igenv;
        ((UW *)Rv10)[18]=0;
      }
      ((UB *)Rv10)[38]=0;
      ((V *)Rv10)[10]=NULL;
      Ra.sl[3]=1253; /* line # 1253 */
      ((V *)Rv10)[11]=NULL;
      ((V *)Rv10)[12]=NULL;
      if (V_sy_var_init_mod) {
        if (V_std_inp_file==NULL) V_std_inp_file=Rv1;
        else {
          Ra.sl[3]=1259; /* line # 1259 */
          if (V_std_out_file==NULL) V_std_out_file=Rv1;
          else {
            if (V_std_err_file==NULL) V_std_err_file=Rv1;
          }
        }
      }
      break;
      case 6:Ra.sl[3]=1265; /* line # 1265 */
      Rv1=PAS__NEW(36);
      ((SL *)Rv1)[8]=0;
      break;
      case 12:Ra.sl[3]=1270; /* line # 1270 */
      Rv1=PAS__NEW(30);
      ((UB *)Rv1)[29]=0;
      break;
      case 0:Ra.sl[3]=1275; /* line # 1275 */
      Rv1=PAS__NEW(31);
      memcpy(Rv1+29,Rd.s+504,2);
      break;
    }
    Ra.sl[3]=1282; /* line # 1282 */
    Rv11=Rv1;
    ((UB *)Rv11)[28]=F_fc;
    ((V *)Rv11)[0]=PAS__NEW(32);
    Rv12=((V *)Rv11)[0];
    Ra.sl[3]=1288; /* line # 1288 */
    ((UB *)Rv12)[0]=V_sy_ident.ub[0];
    Rv13=1;
    for( Rf0=((UB *)Rv12)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv12)[Rv13]=V_sy_ident.c[Rv13];
      Rv13++;
    }
    ((V *)Rv11)[1]=NULL;
    ((V *)Rv11)[2]=NULL;
    Ra.sl[3]=1293; /* line # 1293 */
    ((V *)Rv11)[3]=NULL;
    ((V *)Rv11)[4]=F_ty;
    ((SL *)Rv11)[5]=V_curr_lex;
    ((V *)Rv11)[6]=V_lex_ident_tree.v[Rv0*9];
    Ra.sl[3]=1300; /* line # 1300 */
    if (Rs.v[0]==NULL) V_lex_ident_tree.v[Rv0*9+1]=Rv1;
    else {
      if (Rs.ub[4]) ((V *)Rs.v[0])[1]=Rv1;
      else((V *)Rs.v[0])[2]=Rv1;
    }
    Rv14=(V_lex_ident_tree.s+Rv0*36);
    Ra.sl[3]=1306; /* line # 1306 */
    if (((V *)Rv14)[4]!=NULL) ((V *)((V *)Rv14)[4])[3]=Rv1;
    ((V *)Rv14)[4]=Rv1;
    V_cmp_twicedcl=0;
  }
  Ra.sl[3]=1312; /* line # 1312 */
  if (Ri.ub[0]) {
    PAS__STR_TO_STR(V_sy_string.s,Ri.s+1);
    Ri.ub[0]=0;
  }
  Ra.sl[3]=1317; /* line # 1317 */
  (*F_ip)=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search "  */
V P_ide_search(UW F_fs){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+506;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1341; /* line # 1341 */
  V_ident_disp=V_curr_disp;
  while (1){
    Rv0=P_level_search(V_lex_ident_tree.v[V_ident_disp*9+1]);
    if (Rv0!=NULL) {
      Ra.sl[3]=1346; /* line # 1346 */
      if (!(1<<((UB *)Rv0)[28]&F_fs)) {
        if (V_err_prt) P_src_error_s(Rd.s+520,103,2, V_sy_ident.s,NULL);
        Rv0=NULL;
        V_ident_disp=V_ident_disp -1;
      }
    }
    else {
      Ra.sl[3]=1353; /* line # 1353 */
      V_ident_disp=V_ident_disp -1;
    }
    if (Rv0!=NULL||V_ident_disp<0)  break;
  }
  if (Rv0==NULL&&V_err_prt) {
    P_src_error_s(Rd.s+520,104,3, V_sy_ident.s,NULL);
    Ra.sl[3]=1359; /* line # 1359 */
    Rv0=V_ide_udptr.v[P_any_class(F_fs)];
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_cntxvar "  */
void P_gen_cntxvar(V F_pr, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+524;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1371; /* line # 1371 */
  Rv0=F_pr;
  ((V *)Rv0)[23]=PAS__NEW(52);
  V_cntx_varbl=((V *)Rv0)[23];
  Rv1=((V *)Rv0)[23];
  Ra.sl[3]=1377; /* line # 1377 */
  ((V *)Rv1)[0]=F_id;
  ((V *)Rv1)[1]=NULL;
  ((V *)Rv1)[2]=NULL;
  ((V *)Rv1)[3]=NULL;
  ((V *)Rv1)[4]=V_cntx_typ;
  Ra.sl[3]=1382; /* line # 1382 */
  ((SL *)Rv1)[5]=V_curr_lex;
  ((V *)Rv1)[6]=F_pr;
  ((UB *)Rv1)[28]=5;
  ((SL *)Rv1)[8]=-1;
  ((UW *)Rv1)[18]=16385;
  Ra.sl[3]=1387; /* line # 1387 */
  if (V_curr_lex<=1) ((UB *)Rv1)[38]=2;
  else((UB *)Rv1)[38]=1;
  ((V *)Rv1)[10]=NULL;
  ((V *)Rv1)[11]=((V *)Rv0)[3];
  ((V *)Rv1)[12]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new_line "  */
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  UB Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register UB Rv16;
  register V Rv17;
  register V Rv18;
  SL Rv19;
  register V Rv20;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+537;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1415; /* line # 1415 */
  Rv0=NULL;
  Rv1=0;
  Rv2=0;
  if (V_cmp_trace>0) {
    Rv3=V_src_control;
    Rv4=F_pr;
    Ra.sl[3]=1421; /* line # 1421 */
    if (V_cmp_tracecount<=((SL *)Rv3)[8]||F_icd!=0) {
      if (V_cntx_srinf&&F_icd==0) F_icd=1;
      switch (F_icd) {
        case 0:
        case 1:
        case 2:Ra.sl[3]=1428; /* line # 1428 */
        if (F_lgp==((V *)Rv4)[16]&&F_lgp!=NULL) switch (((SL *)F_lgp)[7]) {
          case 0:
          case 1:
          case 2:
          case 4:Rv1=1;
          break;
          default:break;
        }
        Ra.sl[3]=1433; /* line # 1433 */
        Rv2=V_cntx_srinf;
        break;
        case 3:
        case 5:Rv2=1;
        break;
        default:break;
      }
      Ra.sl[3]=1441; /* line # 1441 */
      V_cntx_srinf=0;
      if (Rv2) {
        P_lgt_new(&Rv0, V_typ_std.v[9],14,NULL);
        Ra.sl[3]=1446; /* line # 1446 */
        Rv5=Rv0;
        Rv6=V_srf_list;
        ((V *)Rv5)[8]=((V *)Rv6)[1];
        P_val_new(((V *)Rv5)+8,V_typ_std.v[9]);
        Rv7=((V *)Rv5)[8];
        Ra.sl[3]=1451; /* line # 1451 */
        if (((SL *)Rv7)[2]<=2) {
          ((V *)Rv7)[7]=((V *)Rv5)[4];
          ((UB *)Rv7)[36]=32;
          ((SL *)Rv7)[5]=((UB *)((V *)Rv7)[10])[1];
        }
      }
      Ra.sl[3]=1460; /* line # 1460 */
      if (Rv1) {
        Rv8=F_lgp;
        if (((V *)Rv8)[1]!=NULL) {
          Ra.sl[3]=1465; /* line # 1465 */
          ((SL *)Rv8)[2]=((SL *)Rv3)[8];
          if (Rv2) {
            if (((SL *)Rv8)[7]<2) {
              Rv9=((V *)Rv8)[1];
              Ra.sl[3]=1470; /* line # 1470 */
              if (((V *)Rv9)[1]!=NULL) P_lgt_free_tree(((V *)Rv9)+1);
              ((V *)Rv9)[1]=Rv0;
            }
            else {
              Rv10=((V *)Rv8)[1];
              Ra.sl[3]=1475; /* line # 1475 */
              if (((V *)Rv10)[1]!=NULL) {
                Rv11=((V *)Rv10)[1];
                if (((V *)Rv11)[1]!=NULL) P_lgt_free_tree(((V *)Rv11)+1);
                ((V *)Rv11)[1]=Rv0;
              }
            }
          }
        }
      }
      else {
        Ra.sl[3]=1485; /* line # 1485 */
        if (F_icd==3||F_icd==5) {
          P_lgt_new(&Rv12, V_typ_std.v[9],14,NULL);
          Rv13=Rv12;
          Ra.sl[3]=1490; /* line # 1490 */
          ((V *)Rv13)[8]=NULL;
          P_val_new(((V *)Rv13)+8,V_typ_std.v[9]);
          Rv14=((V *)Rv13)[8];
          Rv15=V_cntx_varbl;
          ((UB *)Rv14)[36]=32;
          Ra.sl[3]=1495; /* line # 1495 */
          Rv16=((UB *)((V *)Rv15)[0])[0];
          ((V *)Rv14)[10]=PAS__NEW((SL)Rv16+2);
          ((UB *)((V *)Rv14)[10])[0]=Rv16;
          Rv17=((V *)Rv14)[10];
          Rv18=((V *)Rv15)[0];
          ((UB *)Rv17)[1]=((UB *)Rv17)[0];
          Rv19=1;
          for( Rf0=((UB *)Rv17)[0];Rf0>0;Rf0-- ) {
            ((C *)Rv17)[Rv19+1]=((C *)Rv18)[Rv19];
            Rv19++;
          }
          Ra.sl[3]=1500; /* line # 1500 */
          ((SL *)Rv14)[5]=((UB *)Rv17)[0];
          ((V *)Rv12)[0]=Rv0;
          Ra.sl[3]=1505; /* line # 1505 */
          Rv0=Rv12;
        }
        Rv0=P_lgt_new_idref(V_cntx_varbl, Rv0);
        P_lgt_new(&Rv0,NULL,23, Rv0);
        Rv20=Rv0;
        Ra.sl[3]=1511; /* line # 1511 */
        ((SL *)Rv20)[2]=((SL *)Rv3)[8];
        ((SL *)Rv20)[7]=F_icd;
        ((V *)F_pr)[16]=Rv0;
      }
      Ra.sl[3]=1516; /* line # 1516 */
      V_cmp_tracecount=((SL *)Rv3)[8]+V_cmp_trace;
    }
  }
  if (Rv1) Ret=NULL;
  else Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_linetrace "  */
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+551;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1531; /* line # 1531 */
  if ((*F_lgh)==NULL) (*F_lgl)=NULL;
  Rv0=P_lgt_new_line(F_pr, (*F_lgl),F_icd);
  if (Rv0!=NULL) {
    if ((*F_lgh)==NULL) (*F_lgh)=Rv0;
    else {
      Ra.sl[3]=1536; /* line # 1536 */
      ((V *)(*F_lgl))[0]=Rv0;
    }
    (*F_lgl)=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " label_purge "  */
void P_label_purge(V *F_prv_cntx){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+566;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1553; /* line # 1553 */
  Rv0=V_cntx_label;
  V_cntx_label=(*F_prv_cntx);
  while (Rv0!=(*F_prv_cntx)&&Rv0!=NULL){
    Rv1=Rv0;
    Ra.sl[3]=1559; /* line # 1559 */
    Rv2=((V *)Rv1)[9];
    if (16&((UB *)Rv1)[29]) {
      Ra.sl[3]=1564; /* line # 1564 */
      ((UB *)Rv1)[29]=((UB *)Rv1)[29]|32;
      ((V *)Rv1)[9]=NULL;
    }
    else {
      Ra.sl[3]=1569; /* line # 1569 */
      if (8&((UB *)Rv1)[29]) P_src_error_s(Rd.s+581,67,3,((V *)Rv1)[0],NULL);
      ((V *)Rv1)[9]=V_cntx_label;
      V_cntx_label=Rv0;
    }
    Ra.sl[3]=1576; /* line # 1576 */
    Rv0=Rv2;
  }
  V_cntx_lblvl=V_cntx_lblvl-1;
  (*F_prv_cntx)=V_cntx_label;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " typ_alignement "  */
SL P_typ_alignement(SL F_iaddr, V F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+24,F_aln,1);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+585;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1591; /* line # 1591 */
  Ra.sl[4]=F_iaddr+Ra.ub[24];
  Ra.sl[5]=Ra.ub[24];
  Ra.ul[4]=Ra.ul[4]&~Ra.ul[5];
  Ret=Ra.sl[4];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_typ_align "  */
SL P_ide_typ_align(SL F_iaddr, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+601;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1608; /* line # 1608 */
  Rv0=F_ty;
  Ra.sl[4]=F_iaddr+((UB *)Rv0)[28];
  Ra.sl[5]=((UB *)Rv0)[28];
  Ra.ul[4]=Ra.ul[4]&~Ra.ul[5];
  Ret=Ra.sl[4];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " all_typ_allocate "  */
void P_all_typ_allocate(SL *F_iaddr, V F_al){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+616;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1625; /* line # 1625 */
  Rv0=F_al;
  Ra.sl[4]=(*F_iaddr)+((UB *)Rv0)[8];
  Ra.sl[5]=((UB *)Rv0)[8];
  Ra.ul[4]=Ra.ul[4]&~Ra.ul[5];
  Ra.sl[3]=1630; /* line # 1630 */
  ((SL *)Rv0)[11]=Ra.sl[4];
  (*F_iaddr)=Ra.sl[4]+abs(((SL *)Rv0)[7]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cte_allocate "  */
void P_cte_allocate(V F_vp, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+634;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1645; /* line # 1645 */
  if (F_id==NULL) Rv0=((V *)F_vp)[7];
  else Rv0=((V *)F_id)[4];
  if (Rv0!=NULL) {
    Rv1=Rv0;
    Rv2=F_vp;
    if (!((UB *)Rv1)[51]&&((UB *)Rv2)[36]!=21) {
      Ra.sl[3]=1651; /* line # 1651 */
      Rv3=((SL *)Rv1)[6];
      if (((SL *)Rv2)[5]>0) {
        if (Rv0==V_typ_std.v[9]) ((SL *)Rv1)[6]=((SL *)Rv2)[5]+((SL *)Rv1)[5];
        else {
          Ra.sl[3]=1656; /* line # 1656 */
          ((SL *)Rv1)[6]=((SL *)Rv2)[5];
        }
      }
      else((SL *)Rv1)[6]=0;
      P_all_new(((V *)Rv2)+8,Rv0, F_id,11);
      if (F_id!=NULL) ((V *)F_id)[9]=((V *)Rv2)[8];
      ((SL *)Rv1)[6]=Rv3;
      Ra.sl[3]=1661; /* line # 1661 */
      if (V_all_fdata==NULL) V_all_fdata=((V *)Rv2)[8];
      else((V *)V_all_ldata)[0]=((V *)Rv2)[8];
      ((V *)((V *)Rv2)[8])[1]=V_all_ldata;
      V_all_ldata=((V *)Rv2)[8];
      Rv4=((V *)Rv2)[8];
      Ra.sl[3]=1667; /* line # 1667 */
      ((V *)Rv4)[16]=F_vp;
      Rv5=((V *)Rv4)[16];
      ((SL *)Rv5)[2]=((SL *)Rv5)[2]+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_new_typ "  */
void P_ide_new_typ(UB F_frm, V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+648;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1679; /* line # 1679 */
  (*F_p)=PAS__NEW(76);
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    ((V *)Rv0)[0]=NULL;
    Ra.sl[3]=1684; /* line # 1684 */
    ((V *)Rv0)[1]=NULL;
    Rv1=(V_lex_ident_tree.s+V_curr_disp*36);
    ((V *)Rv0)[2]=((V *)Rv1)[5];
    ((V *)Rv1)[5]=(*F_p);
    Ra.sl[3]=1690; /* line # 1690 */
    ((V *)Rv0)[3]=NULL;
    ((V *)Rv0)[4]=NULL;
    ((SL *)Rv0)[5]=0;
    ((SL *)Rv0)[6]=V_inte_size;
    ((UB *)Rv0)[28]=0;
    Ra.sl[3]=1695; /* line # 1695 */
    ((V *)Rv0)[8]=NULL;
    ((V *)Rv0)[9]=NULL;
    ((V *)Rv0)[10]=NULL;
    ((V *)Rv0)[11]=NULL;
    ((UB *)Rv0)[48]=0;
    Ra.sl[3]=1700; /* line # 1700 */
    ((UB *)Rv0)[49]=0;
    ((UB *)Rv0)[50]=0;
    switch (F_frm) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 10:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 19:
      case 22:
      case 29:Ra.sl[3]=1707; /* line # 1707 */
      ((UB *)Rv0)[51]=1;
      break;
      default:((UB *)Rv0)[51]=0;
      break;
    }
    ((UB *)Rv0)[52]=F_frm;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_new_typ_range "  */
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+661;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1723; /* line # 1723 */
  P_ide_new_typ(2, F_typ);
  Rv0=(*F_typ);
  ((V *)Rv0)[14]=NULL;
  ((V *)Rv0)[15]=NULL;
  Ra.sl[3]=1728; /* line # 1728 */
  if (F_parent!=NULL) {
    ((V *)Rv0)[0]=F_parent;
    ((UB *)Rv0)[52]=((UB *)F_parent)[52];
    ((SL *)Rv0)[6]=((SL *)F_parent)[6];
    Ra.sl[3]=1733; /* line # 1733 */
    memcpy(Rv0+28,F_parent+28,1);
    ((UB *)Rv0)[64]=((UB *)F_parent)[64];
  }
  else {
    Ra.sl[3]=1738; /* line # 1738 */
    ((UB *)Rv0)[28]=0;
    ((UB *)Rv0)[64]=F_min>=0;
    ((SL *)Rv0)[6]=4;
  }
  ((UB *)Rv0)[48]=1;
  Ra.sl[3]=1743; /* line # 1743 */
  ((SL *)Rv0)[17]=F_min;
  ((SL *)Rv0)[18]=F_max;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tmpstk_allocate "  */
void P_tmpstk_allocate(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+680;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1755; /* line # 1755 */
  Rv0=PAS__NEW(16);
  ((V *)Rv0)[0]=V_wildtmp_stk;
  ((V *)Rv0)[1]=F_lgt;
  if (V_wildtmp_stk!=NULL) ((SL *)Rv0)[3]=((SL *)V_wildtmp_stk)[2];
  else {
    Ra.sl[3]=1761; /* line # 1761 */
    ((SL *)Rv0)[3]=0;
  }
  ((SL *)Rv0)[2]=P_typ_alignement(((SL *)Rv0)[3],F_ty+28);
  ((SL *)F_lgt)[2]=((SL *)Rv0)[2];
  Ra.sl[3]=1769; /* line # 1769 */
  ((SL *)Rv0)[2]=((SL *)Rv0)[2]+abs(((SL *)F_ty)[6]);
  if (((UB *)V_wildtmp_typ)[28]<((UB *)F_ty)[28]) {
    memcpy(V_wildtmp_pal.s,V_wildtmp_typ+28,1);
    Ra.sl[3]=1774; /* line # 1774 */
    memcpy(V_wildtmp_typ+28,F_ty+28,1);
  }
  if (((SL *)V_wildtmp_typ)[6]<((SL *)Rv0)[2]) {
    Ra.sl[3]=1779; /* line # 1779 */
    V_wildtmp_psz=((SL *)V_wildtmp_typ)[6];
    ((SL *)V_wildtmp_typ)[6]=((SL *)Rv0)[2];
  }
  V_wildtmp_stk=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tmpstk_free "  */
void P_tmpstk_free(V F_stkp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+697;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1793; /* line # 1793 */
  while (F_stkp!=V_wildtmp_stk&&V_wildtmp_stk!=NULL){
    Rv0=V_wildtmp_stk;
    V_wildtmp_stk=((V *)V_wildtmp_stk)[0];
    PAS__DISPOSE(&Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_ide_list "  */
void P_free_ide_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+710;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1812; /* line # 1812 */
  while ((*F_p)!=NULL){
    Rv0=(*F_p);
    Rv1=((V *)(*F_p))[3];
    Ra.sl[3]=1817; /* line # 1817 */
    switch (((UB *)Rv0)[28]) {
      case 3:
      case 13:PAS__DISPOSE(F_p);
      break;
      case 4:Ra.sl[3]=1823; /* line # 1823 */
      P_val_free(((V *)Rv0)+8);
      PAS__DISPOSE(F_p);
      break;
      case 2:Ra.sl[3]=1828; /* line # 1828 */
      if (((V *)Rv0)[12]!=NULL) P_val_free(((V *)Rv0)+12);
      PAS__DISPOSE(F_p);
      break;
      case 5:Ra.sl[3]=1835; /* line # 1835 */
      if (((V *)Rv0)[10]!=NULL) P_val_free(((V *)Rv0)+10);
      PAS__DISPOSE(F_p);
      break;
      case 6:Ra.sl[3]=1840; /* line # 1840 */
      PAS__DISPOSE(F_p);
      break;
      case 10:Rv2=((V *)Rv0)[8];
      Ra.sl[3]=1845; /* line # 1845 */
      while (Rv2!=NULL){
        Rv2=((V *)((V *)Rv0)[8])[0];
        PAS__DISPOSE(((V *)Rv0)+8);
        Ra.sl[3]=1850; /* line # 1850 */
        ((V *)Rv0)[8]=Rv2;
      }
      PAS__DISPOSE(F_p);
      break;
      case 7:Ra.sl[3]=1857; /* line # 1857 */
      Rv3=((V *)Rv0)[9];
      P_free_ide_list(((V *)Rv3)+8);
      P_free_typ_list(((V *)Rv3)+13);
      Ra.sl[3]=1862; /* line # 1862 */
      PAS__DISPOSE(((V *)Rv0)+9);
      PAS__DISPOSE(F_p);
      break;
      case 0:PAS__DISPOSE(F_p);
      break;
      case 1:
      case 8:
      case 9:Ra.sl[3]=1872; /* line # 1872 */
      P_free_generic_list(((V *)Rv0)+10,((V *)Rv0)+11);
      PAS__DISPOSE(F_p);
      break;
      default:break;
    }
    Ra.sl[3]=1878; /* line # 1878 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_typ_list "  */
void P_free_typ_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+725;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1891; /* line # 1891 */
  while ((*F_p)!=NULL){
    Rv0=(*F_p);
    if (((V *)Rv0)[11]!=NULL) {
      Ra.sl[3]=1896; /* line # 1896 */
      P_val_free(((V *)Rv0)+11);
    }
    P_free_ide_list(((V *)Rv0)+4);
    P_lgt_free_tree(((V *)Rv0)+10);
    Rv1=((V *)Rv0)[2];
    switch (((UB *)Rv0)[52]) {
      case 0:
      case 1:
      case 2:Ra.sl[3]=1904; /* line # 1904 */
      P_free_ide_list(((V *)Rv0)+14);
      P_lgt_free(((V *)Rv0)+15);
      break;
      case 7:P_lgt_free_tree(((V *)Rv0)+16);
      break;
      case 9:
      case 23:Ra.sl[3]=1910; /* line # 1910 */
      if (((UB *)Rv0)[52]==9) P_free_ide_list(((V *)Rv0)+14);
      P_lgt_free_tree(((V *)Rv0)+16);
      break;
      case 22:Ra.sl[3]=1915; /* line # 1915 */
      if (((V *)Rv0)[14]!=NULL) P_lgt_free_tree(((V *)Rv0)+14);
      if (((V *)Rv0)[15]!=NULL) P_lgt_free_tree(((V *)Rv0)+15);
      if (((V *)Rv0)[16]!=NULL) P_lgt_free_tree(((V *)Rv0)+16);
      break;
      case 12:Ra.sl[3]=1920; /* line # 1920 */
      Rv2=((V *)Rv0)[15];
      P_free_ide_list(((V *)Rv2)+8);
      P_free_typ_list(((V *)Rv2)+13);
      Ra.sl[3]=1925; /* line # 1925 */
      PAS__DISPOSE(((V *)Rv0)+15);
      break;
      default:break;
    }
    P_lgt_free_tree(((V *)Rv0)+8);
    Ra.sl[3]=1930; /* line # 1930 */
    PAS__DISPOSE(F_p);
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_ope_list "  */
void PAS_IDENT_free_ope_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+740;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1945; /* line # 1945 */
  while ((*F_p)!=NULL){
    Rv0=(*F_p);
    V_ope_table.v[((UB *)Rv0)[0]]=((V *)Rv0)[3];
    Ra.sl[3]=1950; /* line # 1950 */
    P_free_generic_list(((V *)Rv0)+4,((V *)Rv0)+5);
    Rv1=((V *)Rv0)[2];
    PAS__DISPOSE(F_p);
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_generic_list "  */
void P_free_generic_list(V *F_f, V *F_l){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+755;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=1967; /* line # 1967 */
  if ((*F_f)!=NULL) while (1){
    Rv0=(*F_f);
    Rv1=Rv0;
    if (!((UB *)Rv1)[4]) {
      Ra.sl[3]=1973; /* line # 1973 */
      Rv2=((V *)Rv1)[2];
      if (((UB *)Rv2)[56]==10) {
        P_free_ide_list(((V *)Rv2)+24);
        Ra.sl[3]=1978; /* line # 1978 */
        P_free_ide_list(((V *)Rv2)+22);
        P_free_typ_list(((V *)Rv2)+25);
        PAS_IDENT_free_ope_list(((V *)Rv2)+20);
      }
      P_free_ide_list(((V *)Rv2)+8);
      Ra.sl[3]=1983; /* line # 1983 */
      P_free_typ_list(((V *)Rv2)+13);
      if (((UB *)Rv2)[56]==9) {
        Ra.sl[3]=1988; /* line # 1988 */
        if (((V *)Rv2)[26]!=NULL) {
          ((V *)((V *)Rv2)[27])[0]=V_all_free_list;
          V_all_free_list=((V *)Rv2)[26];
        }
      }
      Ra.sl[3]=1995; /* line # 1995 */
      PAS__DISPOSE(((V *)Rv1)+2);
    }
    if ((*F_f)!=(*F_l)) (*F_f)=((V *)(*F_f))[0];
    PAS__DISPOSE(&Rv0);
    if ((*F_f)==(*F_l))  break;
  }
  Ra.sl[3]=2000; /* line # 2000 */
  (*F_f)=NULL;
  (*F_l)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_free_lex "  */
void P_ide_free_lex(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+774;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2012; /* line # 2012 */
  if (F_p!=NULL) {
    Rv0=F_p;
    if (((UB *)Rv0)[56]!=10) {
      Ra.sl[3]=2017; /* line # 2017 */
      P_free_ide_list(((V *)Rv0)+24);
      P_free_ide_list(((V *)Rv0)+22);
      P_free_typ_list(((V *)Rv0)+25);
      PAS_IDENT_free_ope_list(((V *)Rv0)+20);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_create_name "  */
void P_ide_create_name(V F_name){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+788;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2033; /* line # 2033 */
  PAS__STR_TO_STR(Ri.s+1,V_sy_string.s);
  Ri.ub[0]=1;
  Rv0=PAS__LENGTH_STR(F_name);
  if (Rv0>31) Rv0=31;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.sl[3]=2038; /* line # 2038 */
    V_sy_ident.c[Rv1]=((C *)F_name)[Rv1+1];
    Rv1++;
  }
  V_sy_ident.ub[0]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_int_label "  */
void P_ide_int_label(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+805;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2054; /* line # 2054 */
  Rv0=V_sy_ival;
  if (Rv0<=0||Rv0>9999) {
    P_src_error(Rd.s+822,68,3);
    Rv0=0;
  }
  Ra.sl[3]=2060; /* line # 2060 */
  Rv1=5;
  while (Rv1>1){
    V_sy_ident.c[Rv1]=(C)(PAS__I_MOD(Rv0,10)+48);
    Rv1=Rv1-1;
    Ra.sl[3]=2065; /* line # 2065 */
    Rv0=Rv0/10;
  }
  V_sy_ident.c[1]=46;
  V_sy_ident.ub[0]=5;
  V_sy_sym.ub[0]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search_from_nameid "  */
V P_ide_search_from_nameid(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+826;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2084; /* line # 2084 */
  Rv0=NULL;
  if (F_ip!=NULL) {
    Rv1=F_ip;
    if (((V *)Rv1)[0]!=NULL) {
      Ra.sl[3]=2089; /* line # 2089 */
      V_curr_ident=((V *)F_ip)[0];
      Rv0=P_ide_search(1<<((UB *)Rv1)[28]);
      V_curr_ident=NULL;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " set_gbl_def_nam "  */
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+850;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2105; /* line # 2105 */
  (*F_trg)=PAS__NEW(32);
  Rv0=(*F_trg);
  ((C *)Rv0)[1]=F_ach;
  ((C *)Rv0)[2]=95;
  if (((UB *)F_src)[0]<=29) {
    Ra.sl[3]=2111; /* line # 2111 */
    Rv1=1;
    for( Rf0=((UB *)F_src)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv1+2)]=((C *)F_src)[Rv1];
      Rv1++;
    }
    ((UB *)Rv0)[0]=((UB *)F_src)[0]+2;
  }
  else {
    Ra.sl[3]=2116; /* line # 2116 */
    Rv2=1;
    for( Rf0=27;Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv2+2)]=((C *)F_src)[Rv2];
      Rv2++;
    }
    Rv3=((UB *)F_src)[0]-3;
    for( Rf0=(((UB *)F_src)[0]+1)-(((UB *)F_src)[0]-3);Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv3+2)]=((C *)F_src)[Rv3];
      Rv3++;
    }
    ((UB *)Rv0)[0]=31;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_env_file_spc "  */
void P_set_env_file_spc(V F_pcur){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+867;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2135; /* line # 2135 */
  Rv0=0;
  Rv1=V_env_first;
  Rv2=NULL;
  Rv3=NULL;
  Rv4=V_sy_string.ub[1];
  Rv3=PAS__NEW((SL)Rv4+2);
  ((UB *)Rv3)[0]=Rv4;
  Ra.sl[3]=2140; /* line # 2140 */
  PAS__STR_TO_STR(Rv3,V_sy_string.s);
  while (!Rv0&&Rv1!=NULL)
  if (PAS__MATCH_STR(Rv3,((V *)Rv1)[1])==0) Rv0=1;
  else {
    Ra.sl[3]=2146; /* line # 2146 */
    Rv2=Rv1;
    Rv1=((V *)Rv1)[0];
  }
  Ra.sl[3]=2151; /* line # 2151 */
  if (Rv0) PAS__DISPOSE(&Rv3);
  else {
    Rv1=PAS__NEW(16);
    Rv5=Rv1;
    Ra.sl[3]=2157; /* line # 2157 */
    ((V *)Rv5)[0]=F_pcur;
    ((V *)Rv5)[1]=Rv3;
    ((SL *)Rv5)[3]=0;
    if (F_pcur!=NULL) {
      Ra.sl[3]=2163; /* line # 2163 */
      if (F_pcur==V_env_first) V_env_first=Rv1;
    }
    else {
      if (V_env_first==NULL) V_env_first=Rv1;
      else {
        Ra.sl[3]=2168; /* line # 2168 */
        ((V *)V_env_last)[0]=Rv1;
      }
      V_env_last=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wiew_oper_def "  */
void P_wiew_oper_def(UB F_op){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+885;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=2183; /* line # 2183 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+900,-1,-1,32);
  PAS__WRITE_CHT((V_opname.s+F_op*32+1),31, V_opname.ub[F_op*32],-1,32);
  PAS__WRITE_STR(Rd.s+917,-1,-1,32);
  PAS__WRITE_EOLN();
  Rv0=((V *)V_ope_table.v[F_op])[4];
  while (Rv0!=NULL){
    Rv1=Rv0;
    Ra.sl[3]=2188; /* line # 2188 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    if (((UB *)Rv1)[4]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(40);
      if (((V *)Rv1)[3]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_ENM(((UB *)((V *)Rv1)[3])[52],Rd.s+944,0,-1,32);
      }
      Ra.sl[3]=2193; /* line # 2193 */
      if (((V *)Rv1)[4]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1561,-1,-1,32);
        PAS__WRITE_ENM(((UB *)((V *)Rv1)[4])[52],Rd.s+944,0,-1,32);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(41);
      if (((V *)Rv1)[2]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1565,-1,-1,32);
        PAS__WRITE_ENM(((UB *)((V *)Rv1)[2])[52],Rd.s+944,0,-1,32);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=2199; /* line # 2199 */
      Rv2=((V *)Rv1)[2];
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      if (((V *)Rv2)[12]==NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1571,-1,-1,32);
      }
      else {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1583,-1,-1,32);
      }
      Ra.sl[3]=2204; /* line # 2204 */
      Rv3=((V *)Rv2)[3];
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHT(Rv3+1,31,((UB *)Rv3)[0],-1,32);
      PAS__WRITE_CHAR(40);
      Rv4=((V *)Rv2)[8];
      while (Rv4!=NULL){
        Rv5=Rv4;
        Ra.sl[3]=2209; /* line # 2209 */
        if (((UB *)Rv5)[38]!=6) {
          Rv6=((V *)Rv5)[0];
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
          PAS__WRITE_STR(Rd.s+1594,-1,-1,32);
          Rv7=((V *)Rv5)[4];
          if (((V *)Rv7)[3]!=NULL) {
            Ra.sl[3]=2214; /* line # 2214 */
            Rv8=((V *)((V *)Rv7)[3])[0];
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_CHT(Rv8+1,31,((UB *)Rv8)[0],-1,32);
          }
          else {
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_STR(Rd.s+1598,-1,-1,32);
            PAS__WRITE_ENM(((UB *)Rv7)[52],Rd.s+944,0,-1,32);
            PAS__WRITE_CHAR(62);
          }
          if (((V *)Rv5)[3]!=NULL) {
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_STR(Rd.s+1605,-1,-1,32);
          }
        }
        Ra.sl[3]=2219; /* line # 2219 */
        Rv4=((V *)Rv5)[3];
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(41);
      if (((V *)Rv2)[12]!=NULL) {
        Rv9=((V *)Rv2)[12];
        Ra.sl[3]=2225; /* line # 2225 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1609,-1,-1,32);
        if (((V *)Rv9)[3]!=NULL) {
          Rv10=((V *)((V *)Rv9)[3])[0];
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHT(Rv10+1,31,((UB *)Rv10)[0],-1,32);
        }
        else {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+1613,-1,-1,32);
          PAS__WRITE_ENM(((UB *)Rv9)[52],Rd.s+944,0,-1,32);
          PAS__WRITE_CHAR(62);
        }
      }
      Ra.sl[3]=2231; /* line # 2231 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(59);
      PAS__WRITE_EOLN();
    }
    Rv0=((V *)Rv1)[0];
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}
