{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               C P A S   P O R T A B L E   S H E L L                   *
*                                                                       *
*                                by                                     *
*                                                                       *
*               ---  Version  3.1-B5 -- 31/07/2019 ---                  *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*                                                                       *
*        Portable CPAS SHELL -  Version V1.7B -  31-JUL-2019            *
*                                                                       *
*                                                                       *
*                                                                       *
*            Common Cpas Shell (cpsh) environment Definitions           *
*         ( must be inserted by any cpsh compatible interpreter )       *
*                                                                       *
*************************************************************************

////////////////////////////////////////////////////////////////////////
//                                                                     //
//                Global Public License (GPL)                          //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{ We load the Source file environment }
%include 'pasenv:cpas_b__src_env';

const
  pi           = 4*ARCTAN( 1 );
  inrd         = pi/180.0;

  str_maxsize  = 255;          { Used size of a command string }
  ide_maxsize  =  32;          { Used size of a command word }

  idm_mac_all  = 4096;         { Allocation increment for macro code }

  unsmax       =  2.0**32-1.0; { 32 bits unsigned maximum value }
  intmin       = -2.0**31;     { 32 bits integer minimum value }
  intmax       =  2.0**31-1.0; { 32 bits integer maximum value }
  max_dblpow   = 307;          { Maximum for exponent for double precision }
  max_fltpow   =  38;          { Maximum for exponent for single precision }
  max_single   =   7;          { Maximum of figure for a single prec. number }

  max_display  =  15;          { Maximum of nesting display identifier }
  max_stk      =  64;          { Maximum of expression stack }
  max_lun      = 10;           { Maximum number of usable I/O file }

  TAB          = CHR(   9 );   { Tabulation ASCII Character }
  DEL          = CHR( 127 );   { DEL ASCII Character }
  SOH          = CHR(   0 );   { NULL ASCII Character }

type

  pstring = ^string;           { Define the pointer of string type }

  shreal  = double;            { Define the used type of real }

  { Define a wild ennum type for user specific type }
  wennum  = new $wild_ennum use integer"size*8;

  str_string  = string( str_maxsize );
  ide_string  = string( ide_maxsize );

  optid_name = packed array[1..16] of char;


  symbol = ( identsy,            { identifier }
             intconst,           { Integer constant }
             singleconst,        { Single precision constant }
             doubleconst,        { Double precision constant }
             stringconst,        { String constant }

             unaop,              { unary classe operator }
             powop,              { power class operator }
             mulop,              { multiply class operator }
             addop,              { addition class operator }
             relop,              { relation class operator }
             notop,              { not class operator }
             lgandop,            { logical and class operator }
             lgorop,             { logical or class operator }

             {**** separator symbol definitions ****}

             lparen, rparen,     { ( and ) }
             lbrack, rbrack,     { [ and ] }
             comma,              { , }
             semicolon,          { ; }
             period,             { . }
             twodot,             { .. }
             colon,              { : }
             becomes,            { := }

             indirsign,          { ^ }
             attrsign,           { " }                  
             implic,             { => }


             {**** keywords symbol definition ****}

             intsy,              { Integer parameter definition }
             floatsy,            { Floating parameter definition }
             stringsy,           { String parameter definition }
             enumsy,             { Enumeration declaration (integer cte. list) }

             ifsy,               { if STATEMENT }
             thensy,             { then keyword }
             elsesy,             { else clause of a if STATEMENT }
             whilesy,            { while directive }
             dosy,               { do keyword }
             repeatsy,           { repeat directive }
             untilsy,            { until for repeat end }
             forsy,              { for directive }
             tosy,               { to symbol }
             downtosy,           { downto symbol }

             loopsy,             { loop STATEMENT }

             sequencesy,         { begin of sequence }
             casesy,             { Case constructor }
             whensy,             { When keyword }
             othersy,            { Otherwise case }
             beginsy,            { begin of dynamic block }
             endsy,              { end of procedure/begin/if/loop/case/with }

             displaysy,          { Write to output }
             replysy,            { Read from input }
             writemsgsy,         { Write to listing }
             readsy,             { Read from an opened file }
             writesy,            { Write to an opened file }
             writelnsy,          { Writeln to an opened file }
             open_inpsy,         { Open file for input }
             open_outsy,         { Open file for output }
             open_appsy,         { Open file for output in append mode }
             closesy,            { close an opened file }

             macrosy,            { Macro definition }
             purgesy,            { macro destruction }

             specific0sy,        { Any User Specific Symbol for 256 codes }
             specific1sy,        { Any User Suplementary Specific Symbol (+ 256 other codes) }

             {**** micellious symbol ****}    

             eomcsy,             { end of macro code }
             eolnsy,             { end of line seen - for data mode only }
             eofsy,              { end of source }

             {**** pre-processor STATEMENT symbol ****}

             includesy,          { %include a source file }
             chainesy,           { %chaine a source file }
             pragmasy,           { %pragma to compiler option setting }
             peofsy,             { end of file seen or %endfile symbol }

             nothing             { null definition }
           );

const
  specificsy = specific0sy;      { Synonyme Defined for compatibility }



type

  operator = (                   { Operator definitions }
             not_op,             { classe: unary = unaop }
             pow_op,             { power = powop }
             mul_op,    div_op,
             idiv_op,   imod_op,
             irem_op,            { multiply = mulop }
             add_op,    sub_op,
             concat_op,          { additional = addop }
             lt_op,     le_op,
             ge_op,     gt_op,
             ne_op,     eq_op,   { relational = relop }
             and_op,             { logical-and = lgandop }
             or_op,              { logical-or = lgorop }
             xor_op,             { logical-xor = lgorop }
             in_op,              { in operator (included test) }
             ass_op,             { assignation operator }
             stp_op,             { stop sequence operator /used as a flag }
             no_op               { to flag no operator syntax unit }
           );

  sym_rec = record               { Symbol record type }
    sy:   symbol;                { The current symbol kind }
    op: operator                 { The current operator code }
  end;


  symc_ptr = ^symc_rec;          { Symbol context record pointer type }

  symc_rec = record              { Symbol context record }
    symc_ch,                     { To save sy_ch and ... }
    symc_cmin:   char;           { sy_cmin characters }
    symc_svall:  boolean;        { Flag the INSYMBOL result save on RESTORE}
    symc_prv:    symc_ptr;       { Pointer to previous context in the stack }
    symc_sym:    sym_rec;        { saved context }
    symc_ival:   integer;        { Save integer value }
    symc_rval:   shreal;         { Save float value }
    symc_string: ^string         { Save identifier name or string value }
  end;




      {***********************************}
      { Identifiers information Structure }
      {***********************************}


  ide_kinds = ( ide_funct,       { Builtin function }
                ide_functsp,     { Builtin function specific }
                ide_parstr,      { String identifier }
                ide_parint,      { Integer identifier }
                ide_parflt,      { Floatting number identifier }
                ide_tabstr,      { String array identifier }
                ide_tabint,      { Integer array identifier }
                ide_tabflt       { Floatting number array identifier }
              );

  exp_kinds = ( exp_valstr,      { String identifier }
                exp_valint,      { Integer identifier }
                exp_valflt,      { Floatting number identifier }
                exp_telstr,      { String as array element }
                exp_tabstr,      { Array of string }
                exp_telint,      { Integer as array element }
                exp_tabint,      { Array of integer }
                exp_telflt,      { Floatting number as array element }
                exp_tabflt,      { Array of float }
                exp_valnull      { No expression }
              );

  ide_bltfnc = (                 { Builtin function codes definition }
                blt_abs,         { abs( x ) }
                blt_filespc,     { set file specification to system conventions }
                blt_filspcm,     { set file specification to system conventions with shell space management }
                blt_round,       { round( x ) }
                blt_trunc,       { trunc( x ) }
                blt_string,      { string( x[, f[, b]] ) }
                blt_substr,      { substr( s [, i [, j ]] ) }
                blt_nindex,      { index( s1, s2 [, n ] ) }
                blt_checkch,     { check_char( s1, s2 [, i ] ) }
                blt_checknst,    { check for numeric string }
                blt_selement,    { element( il, sep, s ) }
                blt_slength,     { length( s ) }
                blt_setcase,     { setcase( s [, i ] ) }

                blt_exit,        { exit form Shell }
                blt_time,        { Get Current Time }
                blt_date,        { Get Current Date }
                blt_dfdir,       { Get Default Directory }
                blt_spawn,       { spawn a child process }
                blt_run,         { Exit from cpsh and run an other program }
                blt_exec,        { Run an other program as a New Process }
                blt_wait,        { Wait for process complexion }
                blt_chdir,       { Change Default Directory }
                blt_getenv,      { Get environment variable }
                blt_setenv,      { To Change, Create or Delete an environment variable }
                blt_getpath,     { Get a path environment variable }
                blt_setpath,     { Set a path environment variable }
                blt_f_exist,     { Test if file exist }
                blt_f_rename,    { Rename a file }
                blt_f_delete,    { Delete a file }

                blt_id_exist,    { Test if identifier is known }
                blt_mid_exist,   { Test if Macro identifier is known }

                blt_fidl_insert, { Insert specified identifier in the furf list }
                blt_fidl_remove, { Remove specified identifier from the furf list }
                blt_fidl_replace,{ Substitute fonction in a string }

                blt_supcomment,  { to suppress comment of a line string }

                blt_sqrt,        { Square root function }

                blt_sin,         { Circular function - in radians }
                blt_cos,
                blt_tan,
                blt_asin,        { Circular inverse function - in radians }
                blt_acos,
                blt_atan,
                blt_sind,        { Circular function - in degrees }
                blt_cosd,
                blt_tand,
                blt_asind,       { Circular inverse function - in degrees }
                blt_acosd,
                blt_atand,
                blt_ln,          { Naturel log }
                blt_exp,         { exp }

                blt_arsearch,    { Search in object in array }
                blt_chardim,     { Change array dimension }
                blt_ardim,       { Get the array dimension }
                blt_aradd,       { Add array or number to array/worksp }
                blt_arsub,       { Substract array or number to array/worksp }
                blt_armul,       { Multilply array or number to array/worksp }
                blt_ardiv,       { Divide an array/worksp by an array/number }

                blt_noop         { No Op }
              ) use integer"size*8;

  idm_kinds = ( idm_list,        { Macro Stream list }
                idm_parm,        { Macro Parameter }
                idm_temp,        { Temporary Macro parameter }
                idm_macro,       { Macro Identifier }
                idm_undef        { Macro undefined }
              );


  { *** Array operator definitions *** }

  arr_ope = ( ar_mov,            { Array move: src -> dst }
              ar_add,            { Array add:  dst + src -> dst }
              ar_sub,            { Array sub:  dst - src -> dst }
              ar_mul,            { Array mul:  dst * src -> dst }
              ar_div             { Array div:  dst / src -> dst }
            );


  ide_ptr = ^ide_rec;            { Identifier pointer }

  ide_arrstr( ide_all: integer ) = record
    ide_stb: array[1..ide_all] of pstring;
  end;


  ide_arrint( ide_all: integer ) = record
    ide_itb: array[1..ide_all] of integer;
  end;


  ide_arrflt( ide_all: integer ) = record
    ide_ftb: array[1..ide_all] of shreal;
  end;

  idedim_ptr = ^ idedim_rec;     { Pointer to an array definition record }

  idedim_rec = record            { Array definition record definition }
    idedim_nxt: idedim_ptr;      { Link to a sub array definition }
    idedim_stp,                  { index step for the array }
    idedim_siz: integer          { index maximum for the array }
  end;

  ide_rec = record               { Identifier definition pointer }
    ide_name: pstring;           { Identifier name pointer }
    ide_nrlnk, ide_prlnk,        { Link for Referencable identifiers }
    ide_nxt,                     { List identifier link }
    ide_left, ide_right: ide_ptr;{ Left and right identifier link }
    ide_adm: idedim_ptr;         { Array defintion records }
    ide_ronly,                   { Readonly Flag }
    ide_lock: boolean;           { Lock array definition flag }
    case ide_kind: ide_kinds of
      ide_functsp,
      ide_funct:(  ide_fnc: wennum;
                   ide_nparm, ide_nparmax: short_integer );
      ide_parstr:( ide_str: pstring );
      ide_parint:( ide_int: integer );
      ide_parflt:( ide_flt: shreal );
      ide_tabstr:( ide_aas: ^ide_arrstr );
      ide_tabint:( ide_aai: ^ide_arrint );
      ide_tabflt:( ide_aaf: ^ide_arrflt )
  end;


  exp_rec = record
    exp_ref: ide_ptr;                    { Identifier pointer for object ref. }
    exp_adm: idedim_ptr;                 { Array definition pointer }
    exp_edim,                            { copy of dimension for sub-array }
    exp_shift: integer;                  { Array shift for reference }
    case exp_kind: exp_kinds of          { type of expression }
      exp_telstr,
      exp_valstr:( exp_str: pstring );   { String expression }
      exp_telint,
      exp_valint:( exp_int: integer );   { Integer expression }
      exp_telflt,
      exp_valflt:( exp_flt: shreal );    { Float expression }
      exp_tabstr:( exp_aas: ^ide_arrstr);{ Array of string expression }
      exp_tabint:( exp_aai: ^ide_arrint);{ Array of integer expression }
      exp_tabflt:( exp_aaf: ^ide_arrflt) { Array of float expression }
  end;

  { display table definition }
  cpsh_dsptab = array[0..max_display] of ide_ptr;


  idm_ptr = ^idm_rec;            { Macro Identifier pointers }
  idm_apt = ^idm_str;


  idm_str( idm_size: integer := idm_mac_all ) = record
    idm_use: integer;
    idm_ctb: packed array[1..idm_size] of char
  end;

  idm_rec = record
    idm_name: pstring;           { Macro Identifier name pointer }
    idm_parl,                    { Pointer to related parameter list }
    idm_cntx,                    { Pointer to the previous macro context }
    idm_nxt,                     { Pointer to next stack macro definition }
    idm_prv:  idm_ptr;           { Pointer to previous stack macro definition }
    idm_kind: idm_kinds;         { Type of macro symbol }
    idm_nch:  integer;           { Index of next character }
    idm_tab:  idm_apt;           { Macro code reference }
    idm_run:  boolean            { Flag for active code }
  end;




{ ****************************************************************************** }
{ ***  Global Variables of Cpas Shell environment declared here as external  *** }
{ ****************************************************************************** }

[external] var
  sy_ival:              integer; { INSYMBOL: Last readden integer number }
  sy_rval:               shreal; { INSYMBOL: Last readden floatting number }

  sy_noexec,                     { INSYMBOL: To flag the no exec mode }
  sy_nomacrflg:         boolean; { INSYMBOL: Flag to disable the mac. parm replace }
  sy_macro:             idm_ptr; { INSYMBOL: Last readen macro symbol pointer }

  sy_maclst,                     { INSYMBOL: Macro Expenssion Source Line }
  sy_string:         str_string; { INSYMBOL: Last readden string }
  sy_ident:          ide_string; { INSYMBOL: Last readden identifier }
  sy_cmin,                       { INSYMBOL: Last readden character in major }
  sy_ch:                   char; { INSYMBOL: Last readden character }
  sy_sym:               sym_rec; { INSYMBOL: Symbol found }
  sy_idenew:            ide_ptr; { IDE_NEW:  Pointer to the last created symbol }
  sy_endsy,                      { INSYMBOL: related End Symbol or nothing }
  lastsymb:              symbol; { Last symbol in source }

  symc_stk:            symc_ptr; { Symbol context pointer }

  debug_macsrc,                  { Debug Macro Source }
  debug_mac,                     { Debug of macro }
  debug_sym,                     { Debug on Input syntax unit flag }
  debug_exp,                     { Debug on Expression element flag }
  debug_dat:            boolean; { Debug on Data Management }


  sy_init_mod:          boolean; { Program init flag mode }

  { Display tables for identifiers }
  last_ident,                    { Current last identifier table }
  disptab:          cpsh_dsptab;

  curr_disp,                     { Current top of lex display }
  curr_idlex:           integer; { Current identifier lex }

  ierr:                 integer; { General error code }

  data_mode,                     { macro mode flag for insymbol }
  fatal_error:          boolean; { General flag for fatal error }

  pasenv_dir,                    { Pascal environment directory }
  env_path_search:       string; { System related environment path search }

  io_libpath,                    { Path to *env.std and *.err files }
  io_err,                        { Open File Error variable }
  io_count,                      { Array input count identifier pointer }
  io_eoln,                       { EOLN flag identifier pointer }
  io_eof:               ide_ptr; { EOF flag identifer pointer }






{ ****************************************************************************** }
{ ***  Utility Routines of Cpas Shell environment declared here as external  *** }
{ ****************************************************************************** }



{ Error message procedure with one or two string to insert in the message }
procedure SRC_ERROR_S( modulesy:   error_mdnam;
                       number:     integer;
                       severity:   error_sev;
                       var id1, id2: [optional] string ); external;

{ Procedures/functions to manage macros and sequences }
procedure ACTIVE_MACRO_CODE( p: idm_ptr; svall: boolean := false ); external;
procedure RET_OF_MACRO_CODE( p: idm_ptr ); external;
function  NEW_MACRO_LIST( mcmd: symbol ): idm_ptr; external;
procedure EXECUTE_MACRO_CODE( pmc: idm_ptr; stopper: symbol ); external;
function  NEW_MACRO_EXPR: idm_ptr; external;
procedure PURGE_MACRO_EXPR( var p: idm_ptr ); external;
function  GET_INT_VALUE( pa: idm_ptr ): integer; external;
function  GET_FLT_VALUE( pa: idm_ptr ): double; external;
procedure GET_STR_VALUE( var st: string; pa: idm_ptr ); external;

{ Procedures/functions to manage identifiers }
procedure DISPLAY_NEW; external;
procedure DISPLAY_FREE; external;
function  LEVEL_SEARCH( fp: ide_ptr ): ide_ptr; external;
function  IDE_SEARCH( berr: boolean ): ide_ptr; external;
function  IDE_NEW( knd: ide_kinds; ilvl: integer := 0 ): ide_ptr; external;

{ Procedures/functions to manage the user identifiers in the strings }
procedure USR_IDE_APPEND( p: ide_ptr ); external;
procedure USR_IDE_REMOVE( p: ide_ptr ); external;
function  USR_IDE_LOCATE( in_var id_name: string ): ide_ptr; external;

{ Procedures/functions to read the source files }
procedure INCLUDE_STATE( bincl: boolean ); external;
procedure ENDFILE_STATE; external;
procedure INSYMBOL; external;
procedure SKIP_SYMBOL( tosymbol: symbol ); external;

procedure STATELIST( stopper: symbol ); external;

{ Procedures/functions to perform Element_Subtitutions/Extract_Element/Suppress_Comment
  in the user strings to create powerfull command language }
procedure USR_IDE_SUBSTITUTE( in_var src: string; var dst: string; ch: char );
external;
procedure USR_S_ELEMENT(    var dst: string;  { The extracted element string }
                         in_var src: string;  { The string }
                                iel: integer; { The element number starting from 0 }
                                csp,          { The separator character }
                                cst: char;    { The string character (or space) }
                                bss: boolean := false ); { the string expanding flag }
external;
procedure USR_SUPPRESS_COMMENT( in_var src: string; var dst: string; cc, cs: char );
external;

function  USR_NUMERIC_STRING( in_var str: string ): boolean;
external;

{ Procedures/functions to manage the expressions }
procedure GET_EXPRESSION; external;
function  EXP_GETKINDS( ish: integer ): exp_kinds; external;
procedure POP_EXP_REFER( var rec: exp_rec ); external;
procedure GET_EXP_REFER( var rec: exp_rec ); external;
procedure POP_EXP_VALUE( var knd: exp_kinds; var iv: integer;
                                             var rv: shreal;
                                             var st: string ); external;
procedure GET_EXP_VALUE( var knd: exp_kinds; var iv: integer;
                                             var rv: double;
                                             var st: string ); external;
procedure POP_NUMEXPR( var bflt: boolean;
                       var   iv: integer;
                       var   rv:  shreal ); external;
procedure GET_NUMEXPR( var bflt: boolean;
                       var   iv: integer;
                       var   rv:  double ); external;
function  POP_INTEXPR( iv: integer ): integer; external;
function  GET_INTEXPR( iv: integer ): integer; external;
function  POP_FLTEXPR( rv: shreal ): shreal; external;
function  GET_FLTEXPR( rv: double ): double; external;
procedure POP_STREXPR( var st: string ); external;
procedure GET_STREXPR( var st: string ); external;
procedure EXP_PUTINT( iv: integer ); external;
procedure EXP_PUTFLT( rv: shreal ); external;
procedure EXP_PUTSTR( in_var st: string ); external;

{ Function To check the access/existance of a specified file (does not use PATH) }
function  FILE_EXIST_CHECK( in_var fspc: string ): boolean; external;

