/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 152 ) = {{
 14,  14, 102, 115, 112,  99,  95, 110, 101, 119,  95, 101, 110, 116, 114, 121,
 75,  75,  47, 114, 117, 110,  47, 109, 101, 100, 105,  97,  47, 112, 105, 101,
114, 114, 101,  47,  83,  83,  68,  95,  83,  97, 118, 101,  45,  49,  47,  99,
112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,
 95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  54,  47,  99, 112,  97, 115,
 95, 100,  95,  95, 115, 100, 105, 114,  49,  46, 112,  97, 115,   0,   0,   0,
  0,   0,   0,   0,  18,  18, 102, 115, 112,  99,  95,  99, 114, 101,  97, 116,
101,  95, 102, 105, 108, 116, 101, 114,  16,  16, 102, 115, 112,  99,  95, 102,
114, 101, 101,  95, 102, 105, 108, 116, 101, 114,  10,  10, 102, 115, 112,  99,
 95, 109,  97, 116,  99, 104,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 64 );




/* Procedure/Function : " fspc_new_entry "  */
V PAS__SCIR_1_PRC_00000000(UB F_bstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=93; /* line # 93 */
  if (F_bstr) Rv0=PAS__NEW(32);
  else Rv0=PAS__NEW(56);
  Rv1=Rv0;
  Ra.sl[6]=98; /* line # 98 */
  ((V *)Rv1)[0]=Rs.v[0];
  Rs.v[0]=Rv0;
  if (Rs.sl[2]==0) ((V *)Rv1)[1]=NULL;
  else((V *)Rv1)[1]=Rs.v[2];
  ((SB *)Rv1)[16]=0;
  Ra.sl[6]=103; /* line # 103 */
  ((UB *)Rv1)[20]=F_bstr;
  ((UB *)Rv1)[18]=Rs.sl[6];
  ((UB *)Rv1)[19]=0;
  ((UB *)Rv1)[17]=Rs.sl[6];
  if (F_bstr) ((V *)Rv1)[3]=NULL;
  else {
    Ra.sl[6]=108; /* line # 108 */
    PAS__ASSIGN_LSET(Rv1+24,256, (V)Rd.s+96,4);
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fspc_create_filter "  */
V P_fspc_create_filter(V F_filtre){
  /* Define the automatic variable space. */
  Blk( Ra, 360 );

  /* Local variable stored in C variable */
  C Rv0;
  register V Rv1;
  register UB Rv2;
  register V Rv3;
  C Rv4;
  C Rv5;
  C Rv6;
  register V Rv7;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+100;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=114; /* line # 114 */
  Rs.v[4]=NULL;
  Rs.v[0]=NULL;
  Rs.sl[6]=0;
  Rs.v[5]=NULL;
  Rs.v[2]=NULL;
  Ra.sl[72]=119; /* line # 119 */
  Rs.sl[2]=1;
  Rs.sl[12]=1;
  Rs.ub[52]=0;
  while (1){
    Ra.sl[72]=124; /* line # 124 */
    if (Rs.sl[12]>((UB *)F_filtre)[1])  break;
    Rv0=((C *)F_filtre)[Rs.sl[12]+1];
    Rs.sl[12]=Rs.sl[12]+1;
    switch (Rv0) {
      case 91:if (Rs.sl[12]<((UB *)F_filtre)[1]) {
        Ra.sl[72]=131; /* line # 131 */
        Rs.v[5]=PAS__SCIR_1_PRC_00000000(0);
        Rv3=Rs.v[5];
        Rs.sl[6]=Rs.sl[6]+1;
        ((UB *)Rv3)[17]=Rs.sl[6];
        Ra.sl[72]=136; /* line # 136 */
        ((SB *)Rv3)[16]=Rs.sl[2];
        Rv4=((C *)F_filtre)[Rs.sl[12]+1];
        Rs.sl[12]=Rs.sl[12]+1;
        if (Rv4==33) {
          Ra.sl[72]=141; /* line # 141 */
          Rs.ub[60]=1;
          Rv4=((C *)F_filtre)[Rs.sl[12]+1];
          Rs.sl[12]=Rs.sl[12]+1;
        }
        else Rs.ub[60]=0;
        while (1){
          Ra.sl[72]=147; /* line # 147 */
          if (Rs.sl[12]>((UB *)F_filtre)[1])  break;
          Rv0=((C *)F_filtre)[Rs.sl[12]+1];
          Rs.sl[12]=Rs.sl[12]+1;
          if (Rv0==45) {
            Ra.sl[72]=152; /* line # 152 */
            if (Rs.sl[12]>((UB *)F_filtre)[1])  break;
            Rv5=((C *)F_filtre)[Rs.sl[12]+1];
            Rs.sl[12]=Rs.sl[12]+1;
            Rv6=Rv4;
            for( Rf0=(Rv5+1)-Rv4;Rf0>0;Rf0-- ) {
              memcpy(Rv3+24,PAS__BIS_LSET(Ra.s+324,Rv3+24,32, PAS__SET_GENERATOR(
              Ra.s+292,256, Rv6), 32),32);
              Rv6++;
            }
            if (Rs.sl[12]>=((UB *)F_filtre)[1])  break;
            Ra.sl[72]=157; /* line # 157 */
            Rv0=((C *)F_filtre)[Rs.sl[12]+1];
            Rs.sl[12]=Rs.sl[12]+1;
          }
          else memcpy(Rv3+24,PAS__BIS_LSET(Ra.s+324,Rv3+24,32, PAS__SET_GENERATOR(
          Ra.s+292,256, Rv4), 32),32);
          Ra.sl[72]=162; /* line # 162 */
          if (Rv0==93||Rs.sl[12]>((UB *)F_filtre)[1])  break;
          Rv4=((C *)F_filtre)[Rs.sl[12]+1];
          Rs.sl[12]=Rs.sl[12]+1;
        }
        if (Rs.ub[60]) memcpy(Rv3+24,PAS__COM_LSET(Ra.s+292,Rv3+24,256),32);
        Ra.sl[72]=167; /* line # 167 */
        if (Rs.sl[2]==0) {
          Rs.v[2]=Rs.v[5];
          Rs.sl[2]=1;
        }
        Ra.sl[72]=172; /* line # 172 */
        Rs.sl[2]=Rs.sl[2]+Rs.sl[6];
        Rs.sl[6]=0;
      }
      break;
      case 63:if (Rs.v[5]==NULL) {
        Ra.sl[72]=177; /* line # 177 */
        Rs.sl[6]=Rs.sl[6]+1;
      }
      else {
        ((UB *)Rs.v[5])[19]=((UB *)Rs.v[5])[19]+1;
        ((UB *)Rs.v[5])[17]=((UB *)Rs.v[5])[17]+1;
        Ra.sl[72]=182; /* line # 182 */
        Rs.sl[2]=Rs.sl[2]+1;
      }
      break;
      case 42:if (Rs.sl[6]!=0) {
        Ra.sl[72]=188; /* line # 188 */
        Rs.v[5]=PAS__SCIR_1_PRC_00000000(1);
      }
      Rs.v[5]=NULL;
      Rs.sl[6]=0;
      Rs.sl[2]=0;
      break;
      default:Ra.sl[72]=196; /* line # 196 */
      Rs.v[5]=PAS__SCIR_1_PRC_00000000(1);
      Rs.sl[14]=0;
      while (1){
        Rs.sl[14]=Rs.sl[14]+1;
        Ra.sl[72]=201; /* line # 201 */
        Ra.c[Rs.sl[14]+1]=Rv0;
        if (Rs.sl[12]>((UB *)F_filtre)[1])  break;
        Rv0=((C *)F_filtre)[Rs.sl[12]+1];
        if ((Rv0==42||Rv0==63)||Rv0==91)  break;
        Rs.sl[12]=Rs.sl[12]+1;
      }
      Ra.sl[72]=207; /* line # 207 */
      Ra.ub[1]=Rs.sl[14];
      Rs.sl[6]=Rs.sl[6]+Rs.sl[14];
      Rv1=Rs.v[5];
      ((SB *)Rv1)[16]=Rs.sl[2];
      Ra.sl[72]=212; /* line # 212 */
      ((UB *)Rv1)[17]=Rs.sl[6];
      if (Rs.v[2]!=NULL) ((V *)Rv1)[1]=Rs.v[2];
      Rv2=Rs.sl[14];
      ((V *)Rv1)[3]=PAS__NEW((SL)Rv2+2);
      ((UB *)((V *)Rv1)[3])[0]=Rv2;
      PAS__STR_TO_STR(((V *)Rv1)[3],Ra.s);
      if (Rs.sl[2]==0) {
        Ra.sl[72]=218; /* line # 218 */
        Rs.v[2]=Rs.v[5];
        Rs.sl[2]=1;
      }
      Rs.sl[2]=Rs.sl[2]+Rs.sl[6];
      Rs.sl[6]=0;
      break;
    }
  }
  Ra.sl[72]=227; /* line # 227 */
  Rs.sl[2]=0;
  Rs.v[4]=NULL;
  Rs.ub[52]=Rs.v[5]!=NULL;
  while (Rs.v[0]!=NULL){
    Rv7=Rs.v[0];
    Ra.sl[72]=233; /* line # 233 */
    if (Rs.ub[52]) {
      if (((SB *)Rv7)[16]==0) Rs.ub[52]=0;
      Rs.sl[2]=Rs.sl[2]-((UB *)Rv7)[17];
      ((V *)Rv7)[1]=NULL;
      Ra.sl[72]=238; /* line # 238 */
      ((SB *)Rv7)[16]=Rs.sl[2];
    }
    Rs.v[5]=Rs.v[0];
    Rs.v[0]=((V *)Rv7)[0];
    ((V *)Rv7)[0]=Rs.v[4];
    Ra.sl[72]=243; /* line # 243 */
    Rs.v[4]=Rs.v[5];
  }
  Ra.sl[72]=278; /* line # 278 */
  Ret=Rs.v[4];
  PAS__curr_cntx=Ra.v[33];
  return(Ret);
}


/* Procedure/Function : " fspc_free_filter "  */
void P_fspc_free_filter(V *F_hp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+120;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=288; /* line # 288 */
  Rv0=(*F_hp);
  (*F_hp)=NULL;
  while (Rv0!=NULL){
    Rv1=Rv0;
    Ra.sl[6]=294; /* line # 294 */
    if (((UB *)Rv1)[20]) {
      if (((V *)Rv1)[3]!=NULL) PAS__DISPOSE(((V *)Rv1)+3);
    }
    Rv2=((V *)Rv1)[0];
    PAS__DISPOSE(&Rv0);
    Ra.sl[6]=299; /* line # 299 */
    Rv0=Rv2;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " fspc_match "  */
UB P_fspc_match(V F_pf, V F_spc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+138;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=314; /* line # 314 */
  Rv0=1;
  Rv1=((UB *)F_spc)[1]+1;
  Rv2=1;
  Ra.sl[6]=321; /* line # 321 */
  while (F_pf!=NULL&&Rv0){
    Rv3=F_pf;
    Rv0=0;
    if (Rv2+((UB *)Rv3)[17]>Rv1)  break;
    Ra.sl[6]=327; /* line # 327 */
    Rv2=Rv2+((UB *)Rv3)[18];
    Rv4=Rv1-((UB *)Rv3)[19];
    if (((UB *)Rv3)[20]) {
      if (((V *)Rv3)[3]!=NULL) {
        Ra.sl[6]=333; /* line # 333 */
        if (((SB *)Rv3)[16]==0) {
          Rv2=PAS__NINDEX_STR(F_spc+2,(SL)((UB *)F_spc)[1],((V *)Rv3)[3]+2,(SL)(
          (UB *)((V *)Rv3)[3])[1],1, Rv2,1);
          if (Rv2==0)  break;
          Ra.sl[6]=338; /* line # 338 */
          Rv2=Rv2+((UB *)((V *)Rv3)[3])[1];
          if (Rv2>=Rv4)  break;
        }
        else {
          Ra.sl[6]=343; /* line # 343 */
          if (((SB *)Rv3)[16]<0) Rv2=Rv1+((SB *)Rv3)[16];
          Rv5=1;
          for( Rf0=((UB *)((V *)Rv3)[3])[1];Rf0>0;Rf0-- ) {
            if (((C *)((V *)Rv3)[3])[Rv5+1]!=((C *)F_spc)[Rv2+1]) {
              if (((V *)Rv3)[1]!=NULL) {
                F_pf=((V *)Rv3)[1];
                Rv0=1;
                goto L_l_0;
              }
              else {
                Ra.sl[6]=348; /* line # 348 */
                goto L_l_1;
              }
            }
            else Rv2=Rv2+1;
            Rv5++;
          }
        }
      }
    }
    else {
      Ra.sl[6]=355; /* line # 355 */
      if (((SB *)Rv3)[16]==0) {
        while (1){
          if (PAS__INOP_LSET(((C *)F_spc)[Rv2+1],Rv3+24,256))  break;
          Rv2=Rv2+1;
          if (Rv2>=Rv4)  break;
        }
        Ra.sl[6]=361; /* line # 361 */
        if (Rv2>=Rv4)  break;
        Rv2=Rv2+1;
      }
      else {
        Ra.sl[6]=367; /* line # 367 */
        if (((SB *)Rv3)[16]<0) Rv2=Rv1+((SB *)Rv3)[16];
        if (PAS__INOP_LSET(((C *)F_spc)[Rv2+1],Rv3+24,256)) Rv2=Rv2+1;
        else {
          Ra.sl[6]=372; /* line # 372 */
          if (((V *)Rv3)[1]!=NULL) {
            F_pf=((V *)Rv3)[1];
            Rv0=1;
            goto L_l_0;
          }
          else  break;
        }
      }
    }
    Ra.sl[6]=377; /* line # 377 */
    Rv2=Rv2+((UB *)Rv3)[19];
    Rv0=1;
    F_pf=((V *)Rv3)[0];
L_l_0:
    Ra.sl[6]=381; /* line # 381 */
  }
L_l_1: ;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
