/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {{
  0,   1,   2,   3,   4,   0,   0,   0
}};


/* Function/procedure prototypes. */
SL CC__FloatClassify_F(F F_v);
SL CC__FloatClassify_D(G F_v);
UL CC__GetFloatExcept();
void PAS__ERROR(SL F_ierr);


/* Procedure/Function : " pas__fp_classify "  */
UB Pas__FpClassify_F(F F_v){
  register UB Ret;

  /* Code of procedure/function */
  Ret=Ri.ub[CC__FloatClassify_F(F_v)];
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " pas__fp_classify "  */
UB Pas__FpClassify_D(G F_v){
  register UB Ret;

  /* Code of procedure/function */
  Ret=Ri.ub[CC__FloatClassify_D(F_v)];
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " pas__check_fpexc "  */
UL Pas__Check_Fpexc(){
  register UL Ret;

  /* Code of procedure/function */
  Ret=CC__GetFloatExcept();
  goto Ret_Label;
  Ret_Label: ;
  return(Ret);
}


/* Procedure/Function : " pas__float_trap "  */
void Pas__Float_Trap(){
  /* Local variable stored in C variable */
  UL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Rv0=CC__GetFloatExcept()&14;
  if (Rv0!=0) {
    if (Rv0==2) Rv1=22;
    else {
      if (Rv0==4) Rv1=24;
      else {
        if (Rv0==8) Rv1=27;
        else Rv1=20;
      }
    }
    PAS__ERROR(Rv1);
  }
}
