%pragma trace 1;
(** CPAS === Version 1.0 B **)

{ mxd error message file generator }
{ use open/close file and random access }
program GEN_MSGFILE;

{ to generate a standart error message file for mxdcmp }

label FINISH;          { Label for parameter Error }

const
  maxmaxdir  = 100;    { maximum possible size of directory in record }
  defmaxdir  =  10;    { default of maximum size of directory in record }
  maxerrline =  80;    { size of record (or error message line) }

type
  keytyp = short_unsigned;

const
  maxerrkey = maxerrline div keytyp"size;


type
  filespc = string( 128 );

  err_rec = record case boolean of
    false:( msg:packed array[1..maxerrline] of char);  { message line }
    true:(  key:packed array[1..maxerrkey] of keytyp); { array of key }
  end;


var
  maxdir,
  maxmsg,
  nerr,
  ialloc,
  i, j, k, ip, ir, is, ipos, jpos: integer;

  memdir: array[1..maxmaxdir] of err_rec;
  cline:  err_rec;

  outmsg, found:  boolean;

  errmsg: file of err_rec;

  inp: text;	{ input file }


procedure SET_PARAMETERS;
{ To set the GEN_MSGFILE parameters }
var
  inpnam, outnam: filespc := '';

begin
  maxdir := 0;
  { Get the GEN_MSGFILE Process Parameters }
  if argc > 1 then
  begin
    inpnam := argv[1]^;
    if argc > 2 then outnam := argv[2]^;
    if argc > 3 then READV( argv[3]^, maxdir )
                else maxdir := defmaxdir;
    outmsg := false
  end
  else outmsg := true;
  if inpnam.length = 0 then
  begin
    WRITELN; WRITE( ' Input File = ' ); READLN( inpnam );
  end;
  if outnam.length = 0 then
  begin
    WRITELN; WRITE( ' Output File = ' ); READLN( outnam );
  end;
  if maxdir < defmaxdir then
  begin
    WRITELN; WRITELN( ' Error Index Size (in [', defmaxdir:0, '..',
                                                 maxmaxdir:0,'] in record) : ' );
    READLN( maxdir )
  end;
  { Size the index arrea in the message file }
  if maxdir < defmaxdir then maxdir := defmaxdir
                        else if maxdir > maxmaxdir then maxdir := maxmaxdir;
  maxmsg := maxdir * maxerrkey; { get the maximum number of msg. }

  { Open the input file, and the message file }
  OPEN( inp, inpnam, [read_file,error_file] );
  if iostatus <> 0 then
  begin
    WRITELN( ' Cannot Open the input file "', inpnam, '".' );
    goto FINISH
  end;
  OPEN( errmsg, outnam, [read_file,write_file,direct_file,error_file] );
  { if the file is existing, the old file is supershed }
  if iostatus <> 0 then
  begin
    WRITELN( ' Cannot Open the output file "', outnam, '".' );
    goto FINISH
  end;

  { Clear indexed file directory (built in memory) }
  for ip := 1 to maxdir do
    for ir := 1 to maxerrkey do
      memdir[ip].key[ir] := 0
end SET_PARAMETERS;



procedure READ_MESSAGE;
var
  ch: char;

begin
  READ( inp, nerr );       { get error number }
  { Skip all trailing character until ";" }
  ch := ' ';
  while not EOLN( inp ) and (ch <> ';') do READ( inp, ch );
  READLN( inp, cline.msg ) { Read the message }
end READ_MESSAGE;


begin { main GEN_MSGFILE }
  SET_PARAMETERS; { Set the program parameters }

  { Set the directory size as the first entry }
  memdir[1].key[1] := maxdir;

  ialloc := maxdir;      { The directory is allocated }
  ipos := 1; jpos := 2;  { Init the indexes in the directory }

  while not EOF( inp ) do
  begin
    { read input specification }
    ip := 1;
    READ_MESSAGE;

    { find if it is already existing in directory }
    j := 2; { Skip the first entry (reserved for maxdir) }
    k := 1; { Start search from the first directory record }

    found := false;      { Assume not found until shown otherwise }
    ipos  := maxdir + 1; { Initialize the record count behind the directory }
    while ipos <= ialloc do
    begin
      found := (nerr = memdir[k].key[j]);
    exit if found;
      ipos := ipos + 1;
      j    := j + 1;
      if j > maxerrkey then
      { Skip to next directory record }
      begin  j := 1; k := k + 1  end
    end;

    if found then { edit mode }
    begin
      if outmsg then WRITELN( ' *CHANGE ', nerr:6, ipos:6, cline.msg:80 );
      SEEK( errmsg, ipos );
      WRITE( errmsg, cline )
    end
    else { create a new message }
      if ialloc < maxmsg then
      begin
        { complete directory }
        memdir[k].key[j] := nerr;
        ialloc := ialloc + 1;
        if outmsg then
          WRITELN( '     NEW ', nerr:6, ipos:6, cline.msg:80 );
        SEEK( errmsg, ialloc );
        WRITE( errmsg, cline )
      end
  end;

  { write the indexed file directory }
  for i := 1 to maxdir do
  begin
    SEEK( errmsg, i );
    WRITE( errmsg, memdir[i] )
  end;

  { Close the message file }
  CLOSE( errmsg );

FINISH:
end.
