/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 728 ) = {{
 12,  12, 108, 103, 116,  95, 109,  97, 107, 101,  95,  98, 105,  99,  59,  59,
 47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  47, 112,
 99, 109, 112,  95, 108, 103, 116,  46, 112,  97, 115,  15,  15, 118,  97, 114,
105,  97, 110, 116,  95, 105, 110,  95, 101, 120, 101,  99,  11,  11, 108, 103,
116,  95, 115, 117,  98, 115,  99,  97, 110,   4,   4,  83,  69,  86,  76,  15,
 15,  32,  99, 116, 108, 102, 108, 111, 119,  32, 115, 116, 109,  32,  61,  32,
 13,   0,   0,   0,  13,   0,  12, 115, 116, 109,  95, 112,  97, 114,  97, 108,
108, 101, 108,   0,  13, 115, 116, 109,  95,  97, 108, 116, 101, 114, 110,  97,
116, 101,  12, 115, 116, 109,  95, 115, 101, 113, 117, 101, 110,  99, 101,   0,
  8, 115, 116, 109,  95,  99,  97, 115, 101,   0,   0,   0,   0,   0,   8, 115,
116, 109,  95, 108, 111, 111, 112,   0,   0,   0,   0,   0,   7, 115, 116, 109,
 95, 102, 111, 114,   0,   0,   0,   0,   0,   0,   8, 115, 116, 109,  95, 101,
120, 105, 116,   0,   0,   0,   0,   0,  10, 115, 116, 109,  95, 114, 101, 116,
117, 114, 110,   0,   0,   0,   6, 115, 116, 109,  95, 105, 102,   0,   0,   0,
  0,   0,   0,   0,   8, 115, 116, 109,  95, 103, 111, 116, 111,   0,   0,   0,
  0,   0,   8, 115, 116, 109,  95, 106, 117, 109, 112,   0,   0,   0,   0,   0,
 13, 115, 116, 109,  95, 101, 120,  99, 101, 112, 116, 105, 111, 110,   9, 115,
116, 109,  95, 114,  97, 105, 115, 101,   0,   0,   0,   0,  10, 115, 116, 109,
 95, 114, 101, 118, 101, 114, 116,   0,   0,   0,  13,  13, 108, 103, 116,  95,
116, 121, 112, 101,  95, 115,  99,  97, 110,  15,  15, 108, 103, 116,  95, 103,
101, 110,  95, 114, 111, 117, 116, 105, 110, 101,  13,  13, 108, 103, 116,  95,
116, 121, 112, 101,  95, 101, 118,  97, 108,  10,  10,  32,  45,  45,  45,  32,
 84,  82,  69,  69,  32,   9,   9,  32,  45,  45,  45,  32,  79,  66,  74,  32,
  4,   4,  69,  86,  65,  76,   4,   4,  32,  82,  69,  83,  16,  16, 108, 103,
116,  95, 116, 121, 112, 101,  95,  99, 111, 109, 112, 117, 116, 101,  12,  12,
108, 103, 116,  95,  99, 118,  97, 108,  95, 117, 110,  97,   4,   4,  67,  85,
 86,  76,  12,  12, 108, 103, 116,  95,  99, 118,  97, 108,  95,  98, 105, 110,
 13,  13, 108, 103, 116,  95, 100, 111,  95, 105, 110, 115, 101, 114, 116,  10,
 10, 108, 103, 116,  95, 105, 110, 115, 101, 114, 116,   8,   8, 108, 103, 116,
 95, 109,  99, 111, 112,  14,  14, 108, 103, 116,  95, 105, 110, 108, 105, 110,
101,  95, 101, 120, 112,  18,  18, 101, 120, 116, 114,  97,  99, 116,  95, 100,
 97, 116,  97,  95, 118,  97, 108, 117, 101,  15,  15, 108, 103, 116,  95, 101,
120, 116, 114,  97,  99, 116,  95,  99, 116, 101,  22,  22, 108, 103, 116,  95,
101, 120, 116, 114,  97,  99, 116,  95, 115, 105, 109, 112, 108, 101,  95,  99,
116, 101,  14,  14, 108, 103, 116,  95, 115,  99,  97, 110,  95,  98, 108, 111,
 99, 107,  13,  13, 108, 103, 116,  95, 115,  99,  97, 110,  95,  99,  97, 115,
101,  13,  13, 108, 103, 116,  95,  99, 104, 101,  99, 107,  95, 117, 110,  97,
 13,  13, 108, 103, 116,  95, 112,  97, 115, 115,  95, 108, 105, 110, 107,  12,
 12, 108, 103, 116,  95, 105, 115,  95,  99, 111, 110, 115, 116,  12,  12, 108,
103, 116,  95,  99, 116, 101,  95, 105, 110,  95,  50,   8,   8, 108, 103, 116,
 95, 115,  99,  97, 110,  13,  13, 108, 103, 116,  95,  97, 108, 108,  95, 102,
112,  97, 114, 109,  15,  15, 108, 103, 116,  95,  97, 108, 108,  95, 100, 121,
110,  97, 109, 105,  99,  17,  17, 108, 103, 116,  95, 112,  97, 115, 115,  49,
 95,  99, 111, 109, 112, 108, 101, 116
}};

/* Define the local static section. */
static Blk( Rs, 48 );

/* Declaration of external variables. */
extern V V_comp_typ_ptr;
extern V V_int_typ;
extern UB V_tcas_flag;
extern UB V_cmp_cmpdbg;
extern V V_lst_current;
extern Blk(V_typ_std, 248 );
extern SL V_srv_count;
extern V V_srv_first;
extern V V_srv_last;
extern V V_lgt_inslst;
extern V V_lgt_inshde;
extern SL V_stri_descrsz;
extern SL V_stri_stroffset;
extern UB V_binline;
extern V V_all_fdata;
extern V V_all_ldata;
extern SL V_curr_lex;
extern V V_all_fextern;
extern V V_all_lextern;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_val_new(V *F_p, V F_ty);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_econstr(V F_ty, G F_rv);
SL P_lgt_imaskp2(V F_lgt);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_lgt_scan(V F_head);
void P_lgt_write(SL F_icol, SL F_is, V F_p1);
V PAS_LGT_lgt_type_scan(V F_lgp, UB F_sb);


/* Procedure/Function : " lgt_make_bic "  */
SL PAS_LGT_lgt_make_bic(SL F_i1, SL F_i2){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=86; /* line # 86 */
  Ra.sl[7]=F_i1;
  Ra.sl[8]=F_i2;
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ret=Ra.sl[7];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " variant_in_exec "  */
V PAS_LGT_PRC_00000000(V F_lgtw, UB F_dyn){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+75;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=110; /* line # 110 */
  Rv0=F_lgtw;
  if (((V *)Rv0)[1]==NULL&&((UB *)Rv0)[40]==16) {
    V_comp_typ_ptr=((V *)Rv0)[3];
    if (((V *)Rv0)[3]!=NULL) {
      Ra.sl[6]=115; /* line # 115 */
      Rv1=((V *)Rv0)[3];
      if (((SL *)Rv1)[11]>0) Rv2=P_lgt_new_econst(V_int_typ,((SL *)Rv1)[11]);
      else Rv2=PAS_LGT_lgt_type_scan(((V *)Rv1)[9],1);
    }
    else Rv2=P_lgt_new_econst(V_int_typ,0);
  }
  else {
    Ra.sl[6]=122; /* line # 122 */
    Rv2=PAS_LGT_lgt_type_scan(F_lgtw,1);
    V_comp_typ_ptr=((V *)Rv2)[3];
  }
  if (F_dyn&&Rs.ub[0]) {
    Ra.sl[6]=127; /* line # 127 */
    Rv3=Rv2;
    if (((UB *)Rv3)[40]==22&&((SL *)Rv3)[11]==0) {
      ((UB *)Rv3)[40]=16;
      ((V *)Rv3)[3]=NULL;
    }
    else {
      Ra.sl[6]=132; /* line # 132 */
      P_lgt_new(&Rv4, V_int_typ,22,NULL);
      ((V *)Rv4)[0]=Rv2;
      P_lgt_new(&Rv2, V_int_typ,6, Rv4);
      ((UB *)Rv2)[41]=3;
    }
  }
  Ra.sl[6]=138; /* line # 138 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_subscan "  */
V PAS_LGT_PRC_00000001(V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  UB Rv12;
  SL Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+92;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=165; /* line # 165 */
  Rv0=NULL;
  Rv1=0;
  if (F_lgp!=NULL) {
    Rv2=F_lgp;
    switch (((UB *)Rv2)[40]) {
      case 16:Ra.sl[6]=170; /* line # 170 */
      if (((V *)Rv2)[1]!=NULL) Rv0=PAS_LGT_PRC_00000001(((V *)Rv2)[1]);
      else Rv0=F_lgp;
      break;
      case 13:Rv3=((V *)Rv2)[6];
      Ra.sl[6]=175; /* line # 175 */
      if (((UB *)Rv3)[56]==2) {
        if (Rs.ub[0]) {
          P_lgt_new(&Rv0, V_int_typ,22,NULL);
          Rv1=-1;
          Ra.sl[6]=180; /* line # 180 */
          Rv4=Rs.v[1];
          while (Rv4!=NULL&&Rv4!=((V *)Rv2)[6]){
            Rv4=((V *)Rv4)[3];
            Rv1=Rv1-1;
          }
          if (Rv4!=NULL) ((SL *)Rv0)[11]=Rv1;
          else((SL *)Rv0)[11]=0;
        }
        else {
          Ra.sl[6]=187; /* line # 187 */
          if (Rs.v[2]!=NULL) {
            P_lgt_copy_tree(Rs.v[2],&Rv0);
            if ((((UB *)Rv0)[40]==13||((UB *)Rv0)[40]==2)||((UB *)Rv0)[40]==3) {
              Ra.sl[6]=197; /* line # 197 */
              ((V *)Rv0)[3]=((V *)Rv2)[3];
            }
            else P_lgt_new(&Rv0,((V *)Rv2)[3],3, Rv0);
            Rv5=Rv0;
            Ra.sl[6]=202; /* line # 202 */
            ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
          }
          else {
            Ra.sl[6]=207; /* line # 207 */
            switch (((UB *)Rv3)[64]) {
              case 0:if (((V *)Rv3)[11]!=NULL) Rv1=((SL *)((V *)Rv3)[11])[13];
              else Rv0=F_lgp;
              break;
              case 1:Ra.sl[6]=212; /* line # 212 */
              Rv0=PAS_LGT_PRC_00000001(((V *)Rv3)[10]);
              break;
              case 2:if (((UB *)((V *)Rv3)[10])[40]==14) Rv1=((SL *)((V *)((V *)
              Rv3)[10])[7])[13];
              else {
                Ra.sl[6]=219; /* line # 219 */
                Rv0=P_lgt_link(((V *)Rv3)[10]);
                ((V *)Rv0)[3]=((V *)Rv3)[4];
              }
              break;
              default:break;
            }
          }
        }
      }
      else {
        Ra.sl[6]=225; /* line # 225 */
        if (((UB *)((V *)Rv2)[3])[92]<=2||((UB *)((V *)Rv2)[3])[92]==22) P_lgt_new_copy(
        F_lgp, &Rv0);
      }
      break;
      case 14:Rv6=((V *)Rv2)[7];
      Ra.sl[6]=230; /* line # 230 */
      if (((UB *)Rv6)[48]<=2) Rv1=((SL *)Rv6)[13];
      else P_src_error(Rd.s+107,111,3);
      break;
      case 20:Ra.sl[6]=236; /* line # 236 */
      Rv7=((V *)Rv2)[1];
      Rv8=NULL;
      while (Rv7!=NULL){
        Rv0=PAS_LGT_PRC_00000001(Rv7);
        Ra.sl[6]=241; /* line # 241 */
        if (Rv8==NULL) Rv8=Rv0;
        else((V *)Rv9)[0]=Rv0;
        Rv9=Rv0;
        Rv7=((V *)Rv7)[0];
      }
      Ra.sl[6]=246; /* line # 246 */
      P_lgt_new_copy(F_lgp, &Rv0);
      ((V *)Rv0)[1]=Rv8;
      break;
      case 6:Ra.sl[6]=251; /* line # 251 */
      if (((V *)Rv2)[1]!=NULL) {
        Rv8=PAS_LGT_PRC_00000001(((V *)Rv2)[1]);
        Rv9=NULL;
        Rv10=NULL;
        Rv11=((V *)Rv2)[1];
        Ra.sl[6]=256; /* line # 256 */
        if (((V *)Rv11)[0]!=NULL) {
          Rv9=PAS_LGT_PRC_00000001(((V *)Rv11)[0]);
          if (((V *)((V *)Rv11)[0])[0]!=NULL) Rv10=PAS_LGT_PRC_00000001(((V *)((
          V *)Rv11)[0])[0]);
        }
        Ra.sl[6]=262; /* line # 262 */
        Rv12=1;
        if (((UB *)Rv8)[40]!=14) Rv12=0;
        else {
          if (Rv9!=NULL) {
            if (((UB *)Rv9)[40]!=14) Rv12=0;
            else {
              Ra.sl[6]=268; /* line # 268 */
              if (Rv10!=NULL) {
                if (((UB *)Rv10)[40]!=14) Rv12=0;
              }
            }
          }
        }
        if (Rv12) {
          Ra.sl[6]=273; /* line # 273 */
          Rv13=((SL *)((V *)Rv8)[7])[13];
          P_lgt_free(&Rv8);
          if (Rv9!=NULL) {
            Rv14=((SL *)((V *)Rv9)[7])[13];
            P_lgt_free(&Rv9);
            if (Rv10!=NULL) {
              Ra.sl[6]=279; /* line # 279 */
              Rv15=((SL *)((V *)Rv10)[7])[13];
              P_lgt_free(&Rv10);
            }
          }
          switch (((UB *)Rv2)[41]) {
            case 0:Ra.sl[6]=284; /* line # 284 */
            Rv1=Rv13;
            break;
            case 46:Rv1= -Rv13;
            break;
            case 38:
            case 43:Rv1=Rv13+1;
            break;
            case 39:
            case 44:Ra.sl[6]=290; /* line # 290 */
            Rv1=Rv13-1;
            break;
            case 6:Rv1=1-Rv13;
            break;
            case 45:Rv1=(SL)(Rv13&1);
            break;
            case 47:Rv1=abs(Rv13);
            break;
            case 48:Ra.sl[6]=295; /* line # 295 */
            Rv1=Rv13*Rv13;
            break;
            case 49:Rv1=Rv13+Rv14;
            break;
            case 50:Rv1=Rv13-Rv14;
            break;
            case 51:Rv1=Rv13*Rv14;
            break;
            case 52:Ra.sl[6]=300; /* line # 300 */
            if (Rv14!=0) Rv1=Rv13/Rv14;
            else Rv1=2147483647;
            break;
            case 53:if (Rv14!=0) Rv1=PAS__I_MOD(Rv13,Rv14);
            else Rv1=0;
            break;
            case 89:Ra.sl[6]=305; /* line # 305 */
            if (Rv13!=0) Rv1=PAS__IIPOWER(Rv13,Rv14);
            else Rv1=0;
            break;
            case 7:Rv1=(SL)(Rv13!=0&&Rv14!=0);
            break;
            case 8:Rv1=(SL)(Rv13!=0||Rv14!=0);
            break;
            case 9:Ra.sl[6]=310; /* line # 310 */
            Rv1=(SL)((Rv13!=0)!=(Rv14!=0));
            break;
            case 13:Rv1=PAS_LGT_lgt_make_bic(Rv13, Rv14);
            break;
            case 26:
            case 27:
            case 28:
            case 29:
            case 30:
            case 31:
            case 32:
            case 33:
            case 34:
            case 35:Ra.sl[6]=317; /* line # 317 */
            Rv13=Rv13-Rv14;
            switch (((UB *)Rv2)[41]) {
              case 28:
              case 32:Rv1=(SL)(Rv13<0);
              break;
              case 29:
              case 33:Rv1=(SL)(Rv13<=0);
              break;
              case 30:
              case 34:Rv1=(SL)(Rv13>=0);
              break;
              case 31:
              case 35:Ra.sl[6]=322; /* line # 322 */
              Rv1=(SL)(Rv13>0);
              break;
              case 27:Rv1=(SL)(Rv13!=0);
              break;
              case 26:Rv1=(SL)(Rv13==0);
              break;
            }
            break;
            case 2:Ra.sl[6]=330; /* line # 330 */
            Rv1=Rv13;
            if (Rv1<Rv14||Rv1>Rv15) P_src_error(Rd.s+107,112,3);
            break;
            default:break;
          }
        }
        else {
          Ra.sl[6]=339; /* line # 339 */
          if (Rv9!=NULL) {
            ((V *)Rv8)[0]=Rv9;
            if (Rv10!=NULL) ((V *)Rv9)[0]=Rv10;
          }
          Ra.sl[6]=344; /* line # 344 */
          P_lgt_new(&Rv0,((V *)Rv2)[3],6, Rv8);
          ((UB *)Rv0)[41]=((UB *)Rv2)[41];
        }
      }
      break;
      case 0:Ra.sl[6]=350; /* line # 350 */
      if (((UB *)Rv2)[41]==3) {
        V_tcas_flag=1;
        Rv8=((V *)Rv2)[1];
        Rv13=((SL *)Rv8)[4];
        Ra.sl[6]=355; /* line # 355 */
        Rv14=(((SL *)((V *)Rv8)[7])[6]+Rv13)-1;
        Rv16=((V *)((V *)Rv8)[7])[7];
        Rv8=((V *)Rv8)[0];
        Rv7=((V *)Rv8)[0];
        Rv9=PAS_LGT_PRC_00000001(Rv7);
        Ra.sl[6]=360; /* line # 360 */
        Rv7=((V *)Rv7)[0];
        if (((UB *)Rv9)[40]==14) {
          Rv1=((SL *)((V *)Rv9)[7])[13];
          P_lgt_free(&Rv9);
          Ra.sl[6]=365; /* line # 365 */
          if (Rv1<Rv13||Rv1>Rv14) Rv7=Rv8;
          else {
            Rv1=((SL *)Rv16)[(Rv1-Rv13)];
            if (Rv1<0) Lx[0].v[0]=Rv8;
            else {
              Ra.sl[6]=371; /* line # 371 */
              while (Rv1>0&&Rv7!=NULL){
                Rv7=((V *)Rv7)[0];
                Rv1=Rv1-1;
              }
              Ra.sl[6]=376; /* line # 376 */
              if (Rv7==NULL) Rv7=Rv8;
            }
          }
          Rv0=PAS_LGT_PRC_00000000(Rv7,0);
        }
        else {
          Ra.sl[6]=383; /* line # 383 */
          P_lgt_new_copy(F_lgp, &Rv0);
          P_lgt_new_copy(((V *)Rv2)[1],((V *)Rv0)+1);
          Rv8=((V *)Rv0)[1];
          P_val_copy(((V *)((V *)Rv2)[1])+7,((V *)Rv8)+7,0);
          Rv7=((V *)((V *)Rv2)[1])[0];
          Ra.sl[6]=388; /* line # 388 */
          ((V *)Rv8)[0]=PAS_LGT_PRC_00000000(Rv7,1);
          ((V *)((V *)Rv8)[0])[0]=Rv9;
          Rv7=((V *)((V *)Rv7)[0])[0];
          while (Rv7!=NULL){
            Ra.sl[6]=393; /* line # 393 */
            ((V *)Rv9)[0]=PAS_LGT_PRC_00000000(Rv7,1);
            Rv9=((V *)Rv9)[0];
            Rv7=((V *)Rv7)[0];
          }
          if (Rs.ub[0]) {
            Ra.sl[6]=399; /* line # 399 */
            Lx[0].v[1]=Rv0;
            P_lgt_new(&Rv0, V_int_typ,22,NULL);
            ((SL *)Rv0)[11]=0;
          }
        }
      }
      else {
        Ra.sl[6]=407; /* line # 407 */
        if (!(((UB *)Rv2)[41]==8)) {
          Ra.sl[6]=413; /* line # 413 */
          if (V_cmp_cmpdbg) {
            PAS__SELECT_OUT(((V *)V_lst_current)[10]);
            PAS__WRITE_STR(Rd.s+111,-1,-1,32);
            PAS__WRITE_ENM(((UB *)Rv2)[41],Rd.s+128,0,-1,32);
            PAS__WRITE_EOLN();
          }
          P_src_error(Rd.s+107,995,3);
        }
      }
      break;
      default:Ra.sl[6]=420; /* line # 420 */
      P_src_error(Rd.s+107,994,3);
      break;
    }
  }
  if (Rv0==NULL) Rv0=P_lgt_new_econst(V_int_typ, Rv1);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_type_scan "  */
V PAS_LGT_lgt_type_scan(V F_lgp, UB F_sb){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+330;
  Ra.v[4]=Rd.s+14;
  Ra.sl[10]=429; /* line # 429 */
  Ra.v[1]=NULL;
  Rv0=PAS_LGT_PRC_00000001(F_lgp);
  if (Ra.v[1]!=NULL) {
    if (F_sb) {
      Ra.sl[10]=434; /* line # 434 */
      Rv1=Rv0;
      if (((UB *)Rv1)[40]==22&&((SL *)Rv1)[11]==0) {
        ((UB *)Rv1)[40]=16;
        ((V *)Rv1)[3]=NULL;
      }
      else {
        Ra.sl[10]=439; /* line # 439 */
        P_lgt_new(Ra.v,V_int_typ,22,NULL);
        ((V *)Ra.v[0])[0]=Rv0;
        P_lgt_new(&Rv0, V_int_typ,6, Ra.v[0]);
        ((UB *)Rv0)[41]=3;
      }
    }
    else {
      Ra.sl[10]=444; /* line # 444 */
      P_lgt_new(&Rv0, V_int_typ,21, Rv0);
    }
    ((V *)Ra.v[1])[0]=Rv0;
    P_lgt_new(&Rv0,NULL,0, Ra.v[1]);
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[10]=450; /* line # 450 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[2];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " lgt_gen_routine "  */
void P_lgt_gen_routine(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+345;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=464; /* line # 464 */
  Rs.ub[0]=1;
  Rs.v[2]=NULL;
  Rv0=F_ty;
  if (((V *)Rv0)[8]==NULL) {
    Ra.sl[6]=470; /* line # 470 */
    Rv1=NULL;
    Rs.v[1]=((V *)Rv0)[4];
    Rv2=Rs.v[1];
    Rv3=NULL;
    while (Rv2!=NULL){
      Ra.sl[6]=475; /* line # 475 */
      Rv4=Rv2;
      Rv5=PAS__NEW(16);
      Rv6=Rv5;
      Ra.sl[6]=480; /* line # 480 */
      ((V *)Rv6)[0]=NULL;
      ((V *)Rv6)[1]=((V *)Rv4)[4];
      if (Rv1==NULL) Rv1=Rv5;
      else((V *)Rv7)[0]=Rv5;
      Rv7=Rv5;
      Ra.sl[6]=485; /* line # 485 */
      Rv8=P_lgt_link(((V *)Rv4)[9]);
      if (Rv3==NULL) Rv3=Rv8;
      else((V *)Rv9)[0]=Rv8;
      Rv9=Rv8;
      Rv2=((V *)Rv4)[3];
    }
    Ra.sl[6]=492; /* line # 492 */
    Rs.v[3]=PAS__NEW(16);
    Rv10=Rs.v[3];
    ((V *)Rv10)[0]=NULL;
    ((V *)Rv10)[1]=V_typ_std.v[2];
    Ra.sl[6]=497; /* line # 497 */
    Rv8=PAS_LGT_lgt_type_scan(((V *)Rv0)[9],0);
    Rv11=PAS__NEW(48);
    Rv12=Rv11;
    ((V *)Rv12)[0]=NULL;
    Ra.sl[6]=502; /* line # 502 */
    ((V *)Rv12)[2]=V_int_typ;
    V_srv_count=V_srv_count+1;
    ((SL *)Rv12)[2]= -V_srv_count;
    ((V *)Rv12)[3]=Rv8;
    ((V *)Rv12)[4]=Rs.v[3];
    Ra.sl[6]=507; /* line # 507 */
    ((V *)Rv12)[5]=Rv1;
    if (V_srv_first==NULL) V_srv_first=Rv11;
    else((V *)V_srv_last)[0]=Rv11;
    Ra.sl[6]=512; /* line # 512 */
    V_srv_last=Rv11;
    P_lgt_new(((V *)Rv0)+8,V_int_typ,20, Rv3);
    ((V *)((V *)Rv0)[8])[6]=Rv11;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_type_eval "  */
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  SL Rv5;
  UB Rv6;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+362;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=535; /* line # 535 */
  if (V_cmp_cmpdbg) {
    PAS__SELECT_OUT(((V *)V_lst_current)[10]);
    PAS__WRITE_STR(Rd.s+377,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lgt_write(8,0, F_troot);
    PAS__SELECT_OUT(((V *)V_lst_current)[10]);
    PAS__WRITE_STR(Rd.s+389,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=540; /* line # 540 */
    if (F_prm_actual!=NULL) P_lgt_write(8,0, F_prm_actual);
  }
  Rs.sl[8]=0;
  Rs.ub[0]=0;
  Rs.v[2]=F_prm_actual;
  Ra.sl[6]=547; /* line # 547 */
  if (F_elm_arr&&Rs.v[2]!=NULL) {
    Rv0=Rs.v[2];
    if (((V *)Rv0)[3]!=NULL) {
      Rv1=((V *)Rv0)[3];
      if (((UB *)Rv1)[92]==8) Rs.sl[8]=((SL *)Rv1)[10];
    }
  }
  Ra.sl[6]=553; /* line # 553 */
  Rv2=PAS_LGT_lgt_type_scan(F_troot,0);
  if (F_ty!=NULL) {
    Rv3=F_ty;
    Rv4=Rv2;
    Ra.sl[6]=558; /* line # 558 */
    if (((UB *)Rv4)[40]==14&&((V *)Rv4)[3]==V_int_typ) {
      Rv5=((SL *)((V *)Rv4)[7])[13];
      if (((UB *)Rv3)[112]) Rv6=Rv5<((UL *)Rv3)[29]||Rv5>((UL *)Rv3)[30];
      else Rv6=Rv5<((SL *)Rv3)[29]||Rv5>((SL *)Rv3)[30];
      Ra.sl[6]=563; /* line # 563 */
      if (Rv6) P_src_error(Rd.s+402,112,3);
    }
  }
  Ra.sl[6]=571; /* line # 571 */
  if (V_cmp_cmpdbg) {
    PAS__SELECT_OUT(((V *)V_lst_current)[10]);
    PAS__WRITE_STR(Rd.s+406,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lgt_write(8,0, Rv2);
  }
  Ra.sl[6]=577; /* line # 577 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_type_compute "  */
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+412;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=595; /* line # 595 */
  if (F_expe==NULL) Rv0=P_lgt_new_econst(V_int_typ, F_dvl);
  else {
    Rv0=P_lgt_type_eval(F_expe, F_obj,NULL,0);
    Ra.sl[6]=600; /* line # 600 */
    if (Rv0!=NULL&&F_expr!=NULL) {
      if (((UB *)Rv0)[40]!=14) {
        Ra.sl[6]=605; /* line # 605 */
        P_lgt_free_tree(&Rv0);
        Rv1=F_expr;
        if (((V *)Rv1)[6]!=NULL) {
          Rv2=((V *)Rv1)[6];
          Ra.sl[6]=610; /* line # 610 */
          if (((SL *)Rv2)[2]<0) ((SL *)Rv2)[2]=abs(((SL *)Rv2)[2]);
        }
        Rv0=P_lgt_type_eval(F_expr, F_obj,NULL,0);
      }
    }
  }
  Ra.sl[6]=615; /* line # 615 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_cval_una "  */
V PAS_LGT_lgt_cval_una(V F_lop, V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+430;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=628; /* line # 628 */
  Rv0=F_pobj;
  Rv1=((V *)Rv0)[7];
  switch (((UB *)F_lop)[41]) {
    case 6:((SL *)Rv1)[13]=(SL)(((SL *)Rv1)[13]<=0);
    break;
    case 45:Ra.sl[6]=633; /* line # 633 */
    ((SL *)Rv1)[13]=(SL)(((SL *)Rv1)[13]&1);
    break;
    case 43:((SL *)Rv1)[13]=((SL *)Rv1)[13]+1;
    break;
    case 44:((SL *)Rv1)[13]=((SL *)Rv1)[13]-1;
    break;
    case 10:Ra.sl[6]=639; /* line # 639 */
    ((SL *)Rv1)[13]=-1-((SL *)Rv1)[13];
    break;
    case 46:((SL *)Rv1)[13]= -((SL *)Rv1)[13];
    break;
    case 61:
    case 77:Ra.sl[6]=644; /* line # 644 */
    ((G *)Rv1)[7]=-((G *)Rv1)[7];
    break;
    case 47:((SL *)Rv1)[13]=abs(((SL *)Rv1)[13]);
    break;
    case 62:
    case 78:((G *)Rv1)[7]=fabs(((G *)Rv1)[7]);
    break;
    case 48:Ra.sl[6]=650; /* line # 650 */
    ((SL *)Rv1)[13]=PAS__I_SQR(((SL *)Rv1)[13]);
    break;
    case 63:
    case 79:((G *)Rv1)[7]=PAS__G_SQR(((G *)Rv1)[7]);
    break;
    case 64:
    case 80:Ra.sl[6]=655; /* line # 655 */
    ((G *)Rv1)[7]=(double)((SL *)Rv1)[13];
    break;
    case 65:
    case 81:((SL *)Rv1)[13]=PAS__G_ROUND(((G *)Rv1)[7]);
    break;
    case 66:
    case 82:Ra.sl[6]=661; /* line # 661 */
    ((SL *)Rv1)[13]=(int)(((G *)Rv1)[7]);
    break;
    case 92:
    case 110:if (((G *)Rv1)[7]<0.000000000000000E-001) P_src_error(Rd.s+446,801,2);
    else((G *)Rv1)[7]=sqrt(((G *)Rv1)[7]);
    break;
    case 93:
    case 111:Ra.sl[6]=668; /* line # 668 */
    ((G *)Rv1)[7]=sin(((G *)Rv1)[7]);
    break;
    case 94:
    case 112:((G *)Rv1)[7]=cos(((G *)Rv1)[7]);
    break;
    case 95:
    case 113:((G *)Rv1)[7]=tan(((G *)Rv1)[7]);
    break;
    case 96:
    case 114:Ra.sl[6]=676; /* line # 676 */
    if (fabs(((G *)Rv1)[7])>1.000000000000000E+000) P_src_error(Rd.s+446,802,2);
    else((G *)Rv1)[7]=asin(((G *)Rv1)[7]);
    break;
    case 97:
    case 115:if (fabs(((G *)Rv1)[7])>1.000000000000000E+000) P_src_error(Rd.s+446,803,2);
    else {
      Ra.sl[6]=681; /* line # 681 */
      ((G *)Rv1)[7]=acos(((G *)Rv1)[7]);
    }
    break;
    case 98:
    case 116:((G *)Rv1)[7]=atan(((G *)Rv1)[7]);
    break;
    case 100:
    case 118:Ra.sl[6]=686; /* line # 686 */
    ((G *)Rv1)[7]=exp(((G *)Rv1)[7]);
    break;
    case 101:
    case 119:if (((G *)Rv1)[7]<=0.000000000000000E-001) P_src_error(Rd.s+446,804,2);
    else((G *)Rv1)[7]=log(((G *)Rv1)[7]);
    break;
    case 102:
    case 120:Ra.sl[6]=693; /* line # 693 */
    ((G *)Rv1)[7]=PAS__SHG(((G *)Rv1)[7]);
    break;
    case 103:
    case 121:((G *)Rv1)[7]=PAS__CHG(((G *)Rv1)[7]);
    break;
    case 104:
    case 122:((G *)Rv1)[7]=PAS__THG(((G *)Rv1)[7]);
    break;
    case 105:
    case 123:Ra.sl[6]=700; /* line # 700 */
    ((G *)Rv1)[7]=PAS__ASHG(((G *)Rv1)[7]);
    break;
    case 106:
    case 124:if (((G *)Rv1)[7]>1.000000000000000E+000) P_src_error(Rd.s+446,805,2);
    else((G *)Rv1)[7]=PAS__ACHG(((G *)Rv1)[7]);
    break;
    case 107:
    case 125:Ra.sl[6]=706; /* line # 706 */
    if (fabs(((G *)Rv1)[7])>1.000000000000000E+000) P_src_error(Rd.s+446,806,2);
    else((G *)Rv1)[7]=PAS__ATHG(((G *)Rv1)[7]);
    break;
    default:break;
  }
  Ra.sl[6]=712; /* line # 712 */
  ((V *)Rv0)[3]=((V *)F_lop)[3];
  ((SL *)Rv0)[4]=((SL *)F_lop)[4];
  ((UW *)Rv0)[10]=((UW *)F_lop)[10];
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_cval_bin "  */
V PAS_LGT_lgt_cval_bin(V F_lop, V F_ob1, V F_ob2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  G Rv3;
  register V Rv4;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+450;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=726; /* line # 726 */
  Rv0=((V *)F_ob1)[7];
  Rv1=F_ob2;
  switch (((UB *)F_lop)[41]) {
    case 89:((SL *)Rv0)[13]=PAS__IIPOWER(((SL *)Rv0)[13],((SL *)((V *)Rv1)[7])[13]
    );
    break;
    case 90:
    case 108:Ra.sl[6]=732; /* line # 732 */
    ((G *)Rv0)[7]=pow  (((G *)Rv0)[7],((G *)((V *)Rv1)[7])[7]);
    break;
    case 91:
    case 109:((G *)Rv0)[7]=PAS__IGPOWER(((G *)Rv0)[7],((SL *)((V *)Rv1)[7])[13])
    ;
    break;
    case 49:Ra.sl[6]=737; /* line # 737 */
    ((SL *)Rv0)[13]=((SL *)Rv0)[13]+((SL *)((V *)Rv1)[7])[13];
    break;
    case 50:((SL *)Rv0)[13]=((SL *)Rv0)[13]-((SL *)((V *)Rv1)[7])[13];
    break;
    case 51:((SL *)Rv0)[13]=((SL *)Rv0)[13]*((SL *)((V *)Rv1)[7])[13];
    break;
    case 52:((SL *)Rv0)[13]=((SL *)Rv0)[13]/((SL *)((V *)Rv1)[7])[13];
    break;
    case 53:((SL *)Rv0)[13]=PAS__I_MOD(((SL *)Rv0)[13],((SL *)((V *)Rv1)[7])[13]
    );
    break;
    case 67:
    case 85:Ra.sl[6]=744; /* line # 744 */
    ((G *)Rv0)[7]=((G *)Rv0)[7]+((G *)((V *)Rv1)[7])[7];
    break;
    case 68:
    case 86:((G *)Rv0)[7]=((G *)Rv0)[7]-((G *)((V *)Rv1)[7])[7];
    break;
    case 69:
    case 87:((G *)Rv0)[7]=((G *)Rv0)[7]*((G *)((V *)Rv1)[7])[7];
    break;
    case 70:
    case 88:Ra.sl[6]=750; /* line # 750 */
    ((G *)Rv0)[7]=((G *)Rv0)[7]/((G *)((V *)Rv1)[7])[7];
    break;
    case 7:((SL *)Rv0)[13]=(SL)(((SL *)Rv0)[13]>0&&((SL *)((V *)Rv1)[7])[13]>0);
    break;
    case 8:((SL *)Rv0)[13]=(SL)(((SL *)Rv0)[13]>0||((SL *)((V *)Rv1)[7])[13]>0);
    break;
    case 9:((SL *)Rv0)[13]=(SL)(((SL *)Rv0)[13]>0!=((SL *)((V *)Rv1)[7])[13]>0);
    break;
    case 11:Ra.sl[6]=757; /* line # 757 */
    ((UL *)Rv0)[13]=((UL *)Rv0)[13]&((UL *)((V *)Rv1)[7])[13];
    break;
    case 12:((UL *)Rv0)[13]=(((UL *)Rv0)[13]|((UL *)((V *)Rv1)[7])[13])&~(((UL *)
    Rv0)[13]&((UL *)((V *)Rv1)[7])[13]);
    break;
    case 13:((UL *)Rv0)[13]=((UL *)Rv0)[13]&~((UL *)((V *)Rv1)[7])[13];
    break;
    case 14:((UL *)Rv0)[13]=((UL *)Rv0)[13]|((UL *)((V *)Rv1)[7])[13];
    break;
    case 15:Ra.sl[6]=762; /* line # 762 */
    ((SL *)Rv0)[13]=(SL)((((UL *)Rv0)[13]&((UL *)((V *)Rv1)[7])[13])!=0);
    break;
    case 16:break;
    case 17:break;
    case 18:break;
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[6]=772; /* line # 772 */
    switch (((UB *)F_lop)[41]) {
      case 19:
      case 20:Rv2=(SL)PAS__SET_LE(((UL *)Rv0)[13],((UL *)((V *)Rv1)[7])[13]);
      break;
      case 21:
      case 22:Rv2=(SL)PAS__SET_LE(((UL *)((V *)Rv1)[7])[13],((UL *)Rv0)[13]);
      break;
      case 23:Ra.sl[6]=777; /* line # 777 */
      Rv2=(SL)(((UL *)Rv0)[13]!=((UL *)((V *)Rv1)[7])[13]);
      break;
      case 24:Rv2=(SL)(((UL *)Rv0)[13]==((UL *)((V *)Rv1)[7])[13]);
      break;
      default:break;
    }
    ((UB *)Rv0)[48]=1;
    Ra.sl[6]=782; /* line # 782 */
    ((SL *)Rv0)[6]=0;
    ((SL *)Rv0)[13]=Rv2;
    break;
    case 25:Rv2=(SL)((1<<((SL *)Rv0)[13]&((UL *)((V *)Rv1)[7])[13])!=0);
    break;
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:Ra.sl[6]=791; /* line # 791 */
    Rv2=((SL *)Rv0)[13]-((SL *)((V *)Rv1)[7])[13];
    switch (PAS__I_MOD((SL)((UB *)F_lop)[41]-28,6)) {
      case 0:((SL *)Rv0)[13]=(SL)(Rv2<0);
      break;
      case 1:((SL *)Rv0)[13]=(SL)(Rv2<=0);
      break;
      case 2:((SL *)Rv0)[13]=(SL)(Rv2>=0);
      break;
      case 3:Ra.sl[6]=796; /* line # 796 */
      ((SL *)Rv0)[13]=(SL)(Rv2>0);
      break;
      case 4:((SL *)Rv0)[13]=(SL)(Rv2!=0);
      break;
      case 5:((SL *)Rv0)[13]=(SL)(Rv2==0);
      break;
    }
    break;
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:Ra.sl[6]=805; /* line # 805 */
    Rv3=((G *)Rv0)[7]-((G *)((V *)Rv1)[7])[7];
    switch (PAS__I_MOD((SL)((UB *)F_lop)[41]-55,6)) {
      case 0:((SL *)Rv0)[13]=(SL)(Rv3<0.000000000000000E-001);
      break;
      case 1:((SL *)Rv0)[13]=(SL)(Rv3<=0.000000000000000E-001);
      break;
      case 2:((SL *)Rv0)[13]=(SL)(Rv3>=0.000000000000000E-001);
      break;
      case 3:Ra.sl[6]=810; /* line # 810 */
      ((SL *)Rv0)[13]=(SL)(Rv3>0.000000000000000E-001);
      break;
      case 4:((SL *)Rv0)[13]=(SL)(Rv3!=0.000000000000000E-001);
      break;
      case 5:((SL *)Rv0)[13]=(SL)(Rv3==0.000000000000000E-001);
      break;
    }
    break;
    case 36:
    case 37:break;
    case 99:
    case 117:Ra.sl[6]=822; /* line # 822 */
    ((G *)Rv0)[7]=atan2(((G *)Rv0)[7],((G *)((V *)Rv1)[7])[7]);
    break;
    default:break;
  }
  Rv4=F_ob1;
  Ra.sl[6]=828; /* line # 828 */
  ((V *)Rv4)[3]=((V *)F_lop)[3];
  ((SL *)Rv4)[4]=((SL *)F_lop)[4];
  ((UW *)Rv4)[10]=((UW *)F_lop)[10];
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_do_insert "  */
void PAS_LGT_lgt_do_insert(V F_lgt_head, UB F_bfirst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+464;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=839; /* line # 839 */
  Rv0=F_lgt_head;
  if (F_bfirst) {
    ((V *)V_lgt_inslst)[0]=((V *)Rv0)[1];
    ((V *)Rv0)[1]=V_lgt_inshde;
  }
  else {
    Ra.sl[6]=847; /* line # 847 */
    ((V *)V_lgt_inslst)[0]=((V *)Rv0)[0];
    ((V *)Rv0)[0]=V_lgt_inshde;
  }
  V_lgt_inslst=NULL;
  V_lgt_inshde=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_insert "  */
void PAS_LGT_lgt_insert(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+479;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=857; /* line # 857 */
  if (V_lgt_inslst==NULL) V_lgt_inshde=F_lgt;
  else((V *)V_lgt_inslst)[0]=F_lgt;
  V_lgt_inslst=F_lgt;
  ((V *)F_lgt)[0]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_mcop "  */
V PAS_LGT_PRC_00000002(V F_troot){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  SL Rv16;
  SL Rv17;
  V Rv18;
  V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+491;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=888; /* line # 888 */
  Rv0=NULL;
  Rv1=0;
  if (F_troot!=NULL) {
    Rv2=F_troot;
    switch (((UB *)Rv2)[40]) {
      case 24:break;
      case 17:Ra.sl[6]=895; /* line # 895 */
      P_lgt_new_copy(F_troot, &Rv0);
      break;
      case 16:P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=900; /* line # 900 */
      ((V *)Rv0)[1]=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
      break;
      case 13:if (((V *)Rv2)[6]!=NULL) {
        Ra.sl[6]=905; /* line # 905 */
        Rv3=((V *)Rv2)[6];
        if (((V *)Rv3)[6]==Lx[1].v[0]) switch (((UB *)Rv3)[94]) {
          case 1:Ra.sl[6]=914; /* line # 914 */
          P_lgt_new_copy(F_troot, &Rv0);
          Rv4=Rv0;
          if (((V *)Rv3)[10]==NULL) {
            P_all_new(((V *)Rv3)+10,((V *)Rv4)[3],NULL,1);
            Ra.sl[6]=919; /* line # 919 */
            ((UW *)((V *)Rv3)[10])[16]=((UW *)Rv3)[46];
            ((V *)Rv4)[7]=((V *)Rv3)[10];
            Ra.sl[6]=924; /* line # 924 */
            Rv5=((V *)Rv4)[7];
            if (!(4&((UW *)Rv3)[46])) ((UW *)Rv5)[16]=((UW *)Rv5)[16]|1;
            Ra.sl[6]=929; /* line # 929 */
            ((V *)Rv5)[10]=Rv0;
            ((V *)Rv5)[11]=Rv0;
          }
          else {
            Ra.sl[6]=934; /* line # 934 */
            ((V *)Rv0)[7]=((V *)Rv3)[10];
            ((V *)((V *)((V *)Rv3)[10])[11])[1]=Rv0;
            ((V *)((V *)Rv3)[10])[11]=Rv0;
          }
          break;
          case 7:
          case 8:
          case 10:Ra.sl[6]=942; /* line # 942 */
          Rv6=((V *)Rv3)[10];
          if (((V *)Rv2)[3]==((V *)((V *)Rv6)[10])[3]&&((SL *)Rv2)[4]==0) {
            Ra.sl[6]=948; /* line # 948 */
            Rv0=((V *)Rv6)[10];
          }
          else {
            if (((UB *)((V *)Rv6)[10])[40]==13) {
              Ra.sl[6]=954; /* line # 954 */
              Rv7=((V *)Rv6)[10];
              P_lgt_new_copy(F_troot, &Rv0);
              ((V *)Rv0)[6]=((V *)Rv7)[6];
              ((V *)Rv0)[7]=((V *)Rv7)[7];
              Ra.sl[6]=959; /* line # 959 */
              ((SL *)Rv0)[4]=((SL *)Rv0)[4]+((SL *)Rv7)[4];
              Rv8=((V *)Rv7)[7];
              if (((V *)Rv8)[10]==NULL) ((V *)Rv8)[10]=Rv0;
              if (((V *)Rv8)[11]!=NULL) ((V *)((V *)Rv8)[11])[1]=Rv0;
              Ra.sl[6]=964; /* line # 964 */
              ((V *)Rv8)[11]=Rv0;
            }
            else {
              Ra.sl[6]=969; /* line # 969 */
              P_lgt_new_copy(F_troot, &Rv0);
              ((UB *)Rv0)[40]=3;
              ((V *)Rv0)[1]=((V *)Rv6)[10];
            }
          }
          Ra.sl[6]=974; /* line # 974 */
          ((V *)Rv6)[11]=Rv0;
          break;
          case 6:Ra.sl[6]=979; /* line # 979 */
          if (((V *)Rv2)[3]==((V *)Lx[1].v[1])[3]&&((SL *)Rv2)[4]==0) Rv0=Lx[1].
          v[1];
          else {
            Ra.sl[6]=985; /* line # 985 */
            if (((UB *)Lx[1].v[1])[40]==13) {
              Rv9=Lx[1].v[1];
              P_lgt_new_copy(F_troot, &Rv0);
              ((V *)Rv0)[6]=((V *)Rv9)[6];
              Ra.sl[6]=990; /* line # 990 */
              ((V *)Rv0)[7]=((V *)Rv9)[7];
              ((SL *)Rv0)[4]=((SL *)Rv0)[4]+((SL *)Rv9)[4];
              Rv10=((V *)Rv9)[7];
              if (((V *)Rv10)[10]==NULL) ((V *)Rv10)[10]=Rv0;
              Ra.sl[6]=995; /* line # 995 */
              if (((V *)Rv10)[11]!=NULL) ((V *)((V *)Rv10)[11])[1]=Rv0;
              ((V *)Rv10)[11]=Rv0;
            }
            else {
              Ra.sl[6]=1001; /* line # 1001 */
              P_lgt_new_copy(Lx[1].v[1],&Rv0);
              Rv11=Rv0;
              ((V *)Rv11)[3]=((V *)F_troot)[3];
              ((SL *)Rv11)[4]=((SL *)Rv11)[4]+((SL *)F_troot)[4];
            }
          }
          break;
          default:Ra.sl[6]=1015; /* line # 1015 */
          P_lgt_new_copy(F_troot, &Rv0);
          break;
        }
        else {
          Ra.sl[6]=1020; /* line # 1020 */
          P_lgt_new_copy(F_troot, &Rv0);
        }
      }
      else {
        P_lgt_new_copy(F_troot, &Rv0);
        Ra.sl[6]=1025; /* line # 1025 */
        P_all_new(((V *)Rv0)+7,((V *)Rv2)[3],NULL,0);
        Rv12=((V *)Rv0)[7];
        ((V *)Rv12)[10]=Rv0;
        ((V *)Rv12)[11]=Rv0;
      }
      break;
      case 8:Ra.sl[6]=1033; /* line # 1033 */
      P_lgt_new_copy(F_troot, &Rv0);
      Rv13=((V *)Rv2)[1];
      Rv14=NULL;
      while (Rv13!=NULL){
        Ra.sl[6]=1039; /* line # 1039 */
        Rv15=PAS_LGT_PRC_00000002(Rv13);
        Rv13=((V *)Rv13)[0];
        if (Rv14==NULL) ((V *)Rv0)[1]=Rv15;
        else((V *)Rv14)[0]=Rv15;
        Ra.sl[6]=1044; /* line # 1044 */
        Rv14=Rv15;
      }
      break;
      case 11:break;
      case 12:Ra.sl[6]=1052; /* line # 1052 */
      Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv14;
      break;
      case 14:Ra.sl[6]=1057; /* line # 1057 */
      P_lgt_new_copy(F_troot, &Rv0);
      break;
      case 2:
      case 3:
      case 4:
      case 5:P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=1062; /* line # 1062 */
      ((V *)Rv0)[1]=PAS_LGT_PRC_00000002(((V *)F_troot)[1]);
      break;
      case 1:Ra.sl[6]=1067; /* line # 1067 */
      P_lgt_new_copy(F_troot, &Rv0);
      Rv14=Rv0;
      Rv15=((V *)F_troot)[1];
      ((V *)Rv14)[1]=PAS_LGT_PRC_00000002(Rv15);
      Rv14=((V *)Rv14)[1];
      Rv15=((V *)Rv15)[0];
      Ra.sl[6]=1073; /* line # 1073 */
      ((V *)Rv14)[0]=PAS_LGT_PRC_00000002(Rv15);
      Rv14=((V *)Rv14)[0];
      Rv15=((V *)Rv15)[0];
      ((V *)Rv14)[0]=PAS_LGT_PRC_00000002(Rv15);
      break;
      case 23:Ra.sl[6]=1082; /* line # 1082 */
      P_lgt_new_copy(F_troot, &Rv0);
      Rv13=((V *)Rv2)[1];
      Rv14=NULL;
      while (Rv13!=NULL){
        Ra.sl[6]=1087; /* line # 1087 */
        Rv15=PAS_LGT_PRC_00000002(Rv13);
        if (Rv14==NULL) ((V *)F_troot)[1]=Rv15;
        else((V *)Rv14)[0]=Rv15;
        Rv14=Rv15;
        Rv13=((V *)Rv13)[0];
      }
      break;
      case 6:Ra.sl[6]=1097; /* line # 1097 */
      Rv1=0;
      Rv13=NULL;
      Rv0=((V *)Rv2)[1];
      while (Rv0!=NULL){
        Ra.sl[6]=1102; /* line # 1102 */
        Rv14=PAS_LGT_PRC_00000002(Rv0);
        if (Rv13==NULL) Rv13=Rv14;
        else((V *)Rv15)[0]=Rv14;
        Rv15=Rv14;
        if (((UB *)Rv14)[40]==14&&Rv1>=0) Rv1=Rv1+1;
        else {
          Ra.sl[6]=1107; /* line # 1107 */
          Rv1=-1;
        }
        Rv0=((V *)Rv0)[0];
      }
      switch (Rv1) {
        case 1:Ra.sl[6]=1112; /* line # 1112 */
        Rv0=PAS_LGT_lgt_cval_una(F_troot, Rv13);
        break;
        case 2:Rv0=PAS_LGT_lgt_cval_bin(F_troot, Rv13, Rv15);
        break;
        default:Ra.sl[6]=1118; /* line # 1118 */
        P_lgt_new_copy(F_troot, &Rv0);
        ((V *)Rv0)[1]=Rv13;
        break;
      }
      break;
      case 0:Ra.sl[6]=1125; /* line # 1125 */
      switch (((UB *)Rv2)[41]) {
        case 3:Rv14=((V *)Rv2)[1];
        Ra.sl[6]=1130; /* line # 1130 */
        Rv16=((SL *)Rv14)[4];
        Rv17=(((SL *)((V *)Rv14)[7])[6]+Rv16)-1;
        Rv18=((V *)((V *)Rv14)[7])[7];
        Rv14=((V *)Rv14)[0];
        Ra.sl[6]=1135; /* line # 1135 */
        Rv13=((V *)Rv14)[0];
        Rv15=PAS_LGT_PRC_00000002(Rv13);
        Rv13=((V *)Rv13)[0];
        if (((UB *)Rv15)[40]==14) {
          Ra.sl[6]=1140; /* line # 1140 */
          Rv1=((SL *)((V *)Rv15)[7])[13];
          P_lgt_free(&Rv15);
          if (Rv1<Rv16||Rv1>Rv17) Rv13=Rv14;
          else {
            Rv1=((SL *)Rv18)[(Rv1-Rv16)];
            Ra.sl[6]=1145; /* line # 1145 */
            if (Rv1<0) Rv13=Rv14;
            else while (Rv1>0&&Rv13!=NULL){
              Rv13=((V *)Rv13)[0];
              Ra.sl[6]=1150; /* line # 1150 */
              Rv1=Rv1-1;
            }
          }
          Rv0=PAS_LGT_PRC_00000002(Rv13);
        }
        else {
          Ra.sl[6]=1157; /* line # 1157 */
          P_lgt_new_copy(F_troot, &Rv0);
          P_lgt_new_copy(((V *)Rv2)[1],((V *)Rv0)+1);
          Rv14=((V *)Rv0)[1];
          P_val_copy(((V *)((V *)Rv2)[1])+7,((V *)Rv14)+7,0);
          Rv13=((V *)((V *)Rv2)[1])[0];
          Ra.sl[6]=1162; /* line # 1162 */
          ((V *)Rv14)[0]=PAS_LGT_PRC_00000002(Rv13);
          ((V *)((V *)Rv14)[0])[0]=Rv15;
          Rv13=((V *)((V *)Rv13)[0])[0];
          while (Rv13!=NULL){
            Ra.sl[6]=1167; /* line # 1167 */
            ((V *)Rv15)[0]=PAS_LGT_PRC_00000002(Rv13);
            Rv15=((V *)Rv15)[0];
            Rv13=((V *)Rv13)[0];
          }
        }
        break;
        case 0:
        case 2:
        case 4:Ra.sl[6]=1175; /* line # 1175 */
        P_lgt_new_copy(F_troot, &Rv0);
        Rv19=((V *)Rv2)[0];
        ((V *)Rv2)[0]=Rv0;
        Rv13=((V *)Rv2)[1];
        Rv14=NULL;
        while (Rv13!=NULL){
          Ra.sl[6]=1180; /* line # 1180 */
          Rv15=PAS_LGT_PRC_00000002(Rv13);
          Rv13=((V *)Rv13)[0];
          if (Rv15!=NULL) {
            if (Rv14==NULL) ((V *)Rv0)[1]=Rv15;
            else {
              Ra.sl[6]=1186; /* line # 1186 */
              ((V *)Rv14)[0]=Rv15;
            }
            Rv14=Rv15;
          }
        }
        ((V *)Rv2)[0]=Rv19;
        break;
        case 7:Ra.sl[6]=1195; /* line # 1195 */
        Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
        if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv14;
        break;
        case 6:Ra.sl[6]=1202; /* line # 1202 */
        Rv15=PAS_LGT_PRC_00000002(((V *)((V *)Rv2)[1])[0]);
        Rv13=((V *)Rv2)[1];
        if (Rv15!=NULL) {
          Rv20=Rv15;
          if (((UB *)Rv20)[40]==14&&((SL *)((V *)Rv20)[7])[13]==0) {
            Ra.sl[6]=1207; /* line # 1207 */
            Rv13=NULL;
          }
        }
        if (Rv13!=NULL) {
          P_lgt_new_copy(F_troot, &Rv0);
          P_lgt_new_copy(Rv13, &Rv14);
          Ra.sl[6]=1212; /* line # 1212 */
          ((V *)Rv0)[1]=Rv14;
          ((V *)Rv14)[0]=Rv15;
          Rv21=Rv14;
          if (((UB *)Rv21)[40]==11) {
            if (((V *)Rv21)[6]==Lx[1].v[0]) {
              Ra.sl[6]=1218; /* line # 1218 */
              ((V *)Rv14)[1]=Lx[1].v[3];
              Lx[1].v[3]=Rv14;
            }
          }
          else {
            Ra.sl[6]=1224; /* line # 1224 */
            ((V *)Rv14)[1]=((V *)((V *)Rv13)[1])[0];
          }
        }
        break;
        case 5:Ra.sl[6]=1230; /* line # 1230 */
        Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
        Rv13=((V *)((V *)Rv2)[1])[0];
        if (Rv13!=NULL) {
          Ra.sl[6]=1235; /* line # 1235 */
          Rv22=Rv14;
          if (((UB *)Rv22)[40]==14) {
            Rv1=((SL *)((V *)Rv22)[7])[13];
            if (Rv1<1) {
              Ra.sl[6]=1241; /* line # 1241 */
              P_lgt_free(&Rv14);
              P_lgt_free_tree(&Rv13);
              Rv0=NULL;
            }
            else {
              if (Rv1==1) {
                Ra.sl[6]=1247; /* line # 1247 */
                P_lgt_free(&Rv14);
                Rv14=NULL;
                P_lgt_new(&Rv0,NULL,0,NULL);
                ((UB *)Rv0)[41]=2;
              }
              else {
                Ra.sl[6]=1253; /* line # 1253 */
                P_lgt_new(&Rv0,NULL,0, Rv14);
                ((UB *)Rv0)[41]=5;
              }
            }
          }
          else {
            Ra.sl[6]=1259; /* line # 1259 */
            P_lgt_new(&Rv0,NULL,0, Rv14);
            ((UB *)Rv0)[41]=5;
          }
          if (Rv0!=NULL) {
            Ra.sl[6]=1265; /* line # 1265 */
            Rv19=((V *)Rv2)[0];
            ((V *)Rv2)[0]=Rv0;
            while (Rv13!=NULL){
              Rv15=PAS_LGT_PRC_00000002(Rv13);
              Rv13=((V *)Rv13)[0];
              if (Rv15!=NULL) {
                Ra.sl[6]=1271; /* line # 1271 */
                if (Rv14==NULL) ((V *)Rv0)[1]=Rv15;
                else((V *)Rv14)[0]=Rv15;
                Rv15=Rv14;
              }
            }
            Ra.sl[6]=1278; /* line # 1278 */
            ((V *)Rv2)[0]=Rv19;
          }
        }
        else P_lgt_free_tree(&Rv14);
        break;
        case 8:Ra.sl[6]=1287; /* line # 1287 */
        Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
        if (Rv14!=NULL) {
          Lx[1].v[4]=((V *)((V *)Rv2)[1])[0];
          if (((UB *)Rv14)[40]==14) {
            Ra.sl[6]=1293; /* line # 1293 */
            if (((SL *)((V *)Rv14)[7])[13]>0) Rv0=PAS_LGT_PRC_00000002(((V *)Rv14)
            [0]);
            else {
              Rv23=((V *)Rv14)[0];
              if (((V *)Rv23)[0]!=NULL) {
                Ra.sl[6]=1298; /* line # 1298 */
                Rv0=PAS_LGT_PRC_00000002(((V *)Rv23)[0]);
              }
            }
          }
          else {
            ((V *)Rv14)[1]=PAS_LGT_PRC_00000002(Lx[1].v[4]);
            Ra.sl[6]=1303; /* line # 1303 */
            if (((V *)Lx[1].v[4])[0]!=NULL) ((V *)((V *)Rv14)[1])[0]=PAS_LGT_PRC_00000002((
            (V *)Lx[1].v[4])[0]);
            P_lgt_new_copy(F_troot, &Rv0);
            ((V *)Rv0)[1]=Rv14;
          }
        }
        break;
        default:break;
      }
      break;
      default:break;
    }
  }
  Ra.sl[6]=1319; /* line # 1319 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_inline_exp "  */
void PAS_LGT_lgt_inline_exp(V F_callnode){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+501;
  Ra.v[7]=Rd.s+14;
  Ra.sl[16]=1325; /* line # 1325 */
  Ra.v[0]=((V *)F_callnode)[6];
  Ra.v[2]=NULL;
  Rv0=Ra.v[0];
  Ra.v[3]=NULL;
  Ra.sl[16]=1331; /* line # 1331 */
  Rv1=((V *)F_callnode)[1];
  Rv2=((V *)Rv0)[8];
  if (((V *)Rv0)[11]!=NULL) {
    if (((V *)Rv0)[8]!=NULL) {
      if (((UB *)((V *)Rv0)[8])[94]==6) {
        Ra.sl[16]=1338; /* line # 1338 */
        P_lgt_scan(Rv1);
        Ra.v[2]=Rv1;
        Rv3=Rv1;
        if (((V *)Rv3)[6]==NULL) {
          Rv4=((V *)Rv3)[7];
          Ra.sl[16]=1343; /* line # 1343 */
          if (((V *)Rv4)[10]==((V *)Rv4)[11]) {
            ((V *)Rv4)[10]=NULL;
            ((V *)Rv4)[11]=NULL;
          }
        }
        Ra.v[1]=Rv1;
        Rv5=Rv1;
        Ra.sl[16]=1348; /* line # 1348 */
        Rv2=((V *)Rv2)[3];
        Rv1=((V *)Rv1)[0];
        ((V *)Rv5)[0]=NULL;
      }
    }
  }
  Ra.sl[16]=1353; /* line # 1353 */
  while (Rv1!=NULL){
    Rv6=Rv2;
    Rv7=((V *)Rv6)[10];
    P_lgt_scan(Rv1);
    Ra.sl[16]=1358; /* line # 1358 */
    ((V *)Rv7)[10]=Rv1;
    ((V *)Rv7)[11]=NULL;
    Rv5=Rv1;
    Rv2=((V *)Rv2)[3];
    Rv1=((V *)Rv1)[0];
    Ra.sl[16]=1363; /* line # 1363 */
    ((V *)Rv5)[0]=NULL;
  }
  Rv2=((V *)Rv0)[23];
  Ra.sl[16]=1368; /* line # 1368 */
  while (Rv2!=NULL){
    Rv8=Rv2;
    switch (((UB *)Rv8)[94]) {
      case 1:Ra.sl[16]=1373; /* line # 1373 */
      ((V *)Rv8)[10]=NULL;
      break;
      default:break;
    }
    Ra.sl[16]=1378; /* line # 1378 */
    Rv2=((V *)Rv2)[3];
  }
  Rv5=PAS_LGT_PRC_00000002(((V *)Rv0)[16]);
  Ra.sl[16]=1384; /* line # 1384 */
  if (Ra.v[3]!=NULL) while (1){
    Rv1=Ra.v[3];
    Ra.v[3]=((V *)Ra.v[3])[1];
    Ra.sl[16]=1389; /* line # 1389 */
    Rv9=Rv1;
    ((UB *)Rv9)[40]=16;
    ((V *)Rv9)[1]=Rv5;
    if (Ra.v[3]==NULL)  break;
  }
  Ra.sl[16]=1396; /* line # 1396 */
  Rv2=((V *)Ra.v[0])[8];
  if (((V *)Rv0)[11]!=NULL) {
    if (Ra.v[2]!=NULL) {
      Ra.sl[16]=1401; /* line # 1401 */
      Rv10=Rv5;
      ((V *)Rv10)[3]=((V *)Rv0)[11];
      ((UW *)Rv10)[10]=19;
      Ra.sl[16]=1406; /* line # 1406 */
      P_lgt_new(((V *)Rv10),((V *)Rv10)[3],13,NULL);
      ((V *)((V *)Rv10)[0])[6]=NULL;
      ((V *)((V *)Rv10)[0])[7]=((V *)Ra.v[1])[7];
      ((V *)((V *)Ra.v[1])[7])[11]=((V *)Rv10)[0];
      ((V *)((V *)((V *)Rv0)[8])[10])[10]=NULL;
      Ra.sl[16]=1412; /* line # 1412 */
      Rv2=((V *)Rv2)[3];
    }
  }
  Ra.sl[16]=1420; /* line # 1420 */
  while (Rv2!=NULL){
    Rv11=((V *)Rv2)[10];
    if (!(((V *)Rv11)[11]!=NULL)) {
      Ra.sl[16]=1427; /* line # 1427 */
      P_lgt_free_tree(((V *)Rv11)+10);
    }
    Rv2=((V *)Rv2)[3];
  }
  Ra.sl[16]=1432; /* line # 1432 */
  Rv12=F_callnode;
  ((UB *)Rv12)[40]=0;
  ((UB *)Rv12)[41]=2;
  ((V *)Rv12)[1]=Rv5;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " extract_data_value "  */
void PAS_LGT_PRC_00000003(V *F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+517;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1459; /* line # 1459 */
  Lx[2].v[0]=NULL;
  if ((*F_pv)!=NULL) {
    Rv0=(*F_pv);
    if (((V *)Rv0)[4]!=NULL) {
      Rv1=((V *)Rv0)[4];
      Ra.sl[6]=1465; /* line # 1465 */
      Lx[2].sl[2]=P_ide_typ_align(Lx[2].sl[2],((V *)Rv0)[4]);
      if (((SL *)Rv1)[11]>0) Rv2=Lx[2].sl[2]+((SL *)Rv1)[11];
      else {
        Ra.sl[6]=1470; /* line # 1470 */
        Rv2=Lx[2].sl[2]+((SL *)Rv0)[6];
        if (((UB *)Rv0)[48]==29&&((UB *)Rv1)[92]==10) Rv2=Rv2+((SL *)Rv1)[10];
      }
      Ra.sl[6]=1476; /* line # 1476 */
      if (Lx[2].sl[3]>=Rv2) {
        Lx[2].sl[2]=Rv2;
        (*F_pv)=((V *)Rv0)[0];
        goto Ret_Label;
      }
      Ra.sl[6]=1485; /* line # 1485 */
      if (((((UB *)Rv0)[48]==29&&((UB *)Rv1)[92]==8)&&((V *)Rv1)[14]==V_typ_std.
      v[0])&&Lx[2].v[2]==V_typ_std.v[0]) {
        P_val_new(Lx[2].v,Lx[2].v[2]);
        ((SL *)Lx[2].v[0])[13]=(SL)((C *)((V *)Rv0)[7])[((Lx[2].sl[3]-Lx[2].sl[2]
        )+1)+1];
        Ra.sl[6]=1490; /* line # 1490 */
        goto Ret_Label;
      }
      Ra.sl[6]=1495; /* line # 1495 */
      switch (((UB *)Rv0)[48]) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 11:
        case 13:
        case 14:
        case 15:
        case 17:
        case 19:
        case 22:Ra.sl[6]=1500; /* line # 1500 */
        P_val_copy(F_pv,Lx[2].v,0);
        goto Ret_Label;
        break;
        case 29:Ra.sl[6]=1506; /* line # 1506 */
        Rv3=Lx[2].sl[3]-Lx[2].sl[2];
        P_val_new(Lx[2].v,Lx[2].v[2]);
        if (Rv3<V_stri_descrsz) ((SL *)Lx[2].v[0])[13]=((UB *)((V *)Rv0)[7])[0];
        else {
          Ra.sl[6]=1511; /* line # 1511 */
          if (Rv3<V_stri_stroffset) ((SL *)Lx[2].v[0])[13]=((UB *)((V *)Rv0)[7])
          [1];
          else((SL *)Lx[2].v[0])[13]=(SL)((C *)((V *)Rv0)[7])[(Rv3-(V_stri_stroffset-
1))+1];
        }
        goto Ret_Label;
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=1520; /* line # 1520 */
        Rv4=((V *)Rv0)[7];
        Rv3=((SL *)Rv0)[2];
        while (Rv4!=NULL&&Lx[2].v[0]==NULL){
          Rv5=Rv4;
          Ra.sl[6]=1525; /* line # 1525 */
          if (Rv3==0&&((UB *)Rv5)[48]==8) Lx[2].sl[2]=P_ide_typ_align(Lx[2].sl[2]
          ,((V *)Rv1)[14]);
          PAS_LGT_PRC_00000003(&Rv4);
          if (Rv3>0) Rv3=Rv3-1;
        }
        break;
        default:break;
      }
    }
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_extract_cte "  */
void PAS_LGT_lgt_extract_cte(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+537;
  Ra.v[5]=Rd.s+14;
  Ra.sl[12]=1540; /* line # 1540 */
  Rv0=F_lgt;
  if (((V *)Rv0)[7]!=NULL&&((V *)Rv0)[3]!=NULL) {
    Ra.sl[2]=0;
    Ra.sl[3]=((SL *)Rv0)[4];
    Ra.sl[12]=1545; /* line # 1545 */
    Ra.v[2]=((V *)Rv0)[3];
    Rv1=((V *)Rv0)[7];
    Ra.v[0]=NULL;
    PAS_LGT_PRC_00000003(&Rv1);
    if (Ra.v[0]!=NULL) ((V *)Rv0)[7]=Ra.v[0];
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " lgt_extract_simple_cte "  */
void P_lgt_extract_simple_cte(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+554;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1558; /* line # 1558 */
  if (F_lgt!=NULL) {
    Rv0=F_lgt;
    if ((((UB *)Rv0)[40]==14&&((V *)Rv0)[3]!=NULL)&&((V *)Rv0)[7]!=NULL) {
      if (((UB *)((V *)Rv0)[3])[91]&&((V *)((V *)Rv0)[7])[4]!=NULL) {
        if (!((UB *)((V *)((V *)Rv0)[7])[4])[91]) {
          Ra.sl[6]=1563; /* line # 1563 */
          PAS_LGT_lgt_extract_cte(F_lgt);
        }
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_scan_block "  */
void PAS_LGT_PRC_00000004(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+578;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1585; /* line # 1585 */
  Lx[3].v[0]=V_lgt_inshde;
  Lx[3].v[1]=V_lgt_inslst;
  V_lgt_inslst=NULL;
  V_lgt_inshde=NULL;
  P_lgt_scan(F_lgt);
  if (V_lgt_inslst!=NULL) {
    if (((UB *)F_lgt)[40]!=0||((UB *)F_lgt)[41]!=2) {
      Ra.sl[6]=1591; /* line # 1591 */
      P_lgt_new_copy(F_lgt, &Rv0);
      Rv1=F_lgt;
      ((UB *)Rv1)[40]=0;
      ((UB *)Rv1)[41]=2;
      Ra.sl[6]=1596; /* line # 1596 */
      ((V *)Rv1)[1]=V_lgt_inshde;
      ((V *)V_lgt_inslst)[0]=Rv0;
    }
    else {
      Ra.sl[6]=1601; /* line # 1601 */
      PAS_LGT_lgt_do_insert(F_lgt,1);
    }
  }
  V_lgt_inshde=Lx[3].v[0];
  V_lgt_inslst=Lx[3].v[1];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_scan_case "  */
void PAS_LGT_PRC_00000005(V F_lgt, SL F_ncase){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+594;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1615; /* line # 1615 */
  Rv0=F_lgt;
  Rv1=((V *)Rv0)[7];
  Rv2=((SL *)Rv0)[4];
  Rv3=((SL *)Rv1)[6];
  Rv4=((V *)Rv1)[7];
  Rv5=((V *)Rv0)[0];
  Ra.sl[6]=1620; /* line # 1620 */
  if (((UB *)Rv5)[40]!=16) PAS_LGT_PRC_00000004(Rv5);
  Rv6=((V *)Rv5)[0];
  P_lgt_scan(Rv6);
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1625; /* line # 1625 */
  while (Rv7!=NULL){
    PAS_LGT_PRC_00000004(Rv7);
    Rv7=((V *)Rv7)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_check_una "  */
UB PAS_LGT_PRC_00000006(V *F_lgt, UB F_pcd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  register V Rv6;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+609;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1647; /* line # 1647 */
  Rv0=(*F_lgt);
  Rv1=(*F_lgt);
  Rv2=1;
  Rv3=0;
  Rv4=0;
  Ra.sl[6]=1652; /* line # 1652 */
  while (Rv2&&Rv0!=NULL){
    Rv5=Rv0;
    switch (((UB *)Rv5)[40]) {
      case 6:Ra.sl[6]=1658; /* line # 1658 */
      if (((UB *)Rv5)[41]==F_pcd) {
        Rv4=1;
        Rv3=!Rv3;
      }
      else {
        Ra.sl[6]=1664; /* line # 1664 */
        Rv2=0;
      }
      break;
      case 14:if (((V *)Rv5)[7]!=NULL) {
        Ra.sl[6]=1669; /* line # 1669 */
        Rv6=((V *)Rv5)[7];
        switch (F_pcd) {
          case 46:if (((SL *)Rv6)[13]<0) {
            ((SL *)Rv6)[13]= -((SL *)Rv6)[13];
            Rv3=!Rv3;
          }
          break;
          case 49:Ra.sl[6]=1674; /* line # 1674 */
          if (((SL *)Rv6)[13]<0) {
            ((SL *)Rv6)[13]= -((SL *)Rv6)[13];
            Rv3=!Rv3;
          }
          break;
          case 61:
          case 77:if (((G *)Rv6)[7]<0.000000000000000E-001) {
            ((G *)Rv6)[7]=-((G *)Rv6)[7];
            Rv3=!Rv3;
          }
          break;
          case 67:
          case 85:Ra.sl[6]=1680; /* line # 1680 */
          if (((G *)Rv6)[7]<0.000000000000000E-001) {
            ((G *)Rv6)[7]=-((G *)Rv6)[7];
            Rv3=!Rv3;
          }
          break;
          default:break;
        }
        Rv2=0;
      }
      break;
      case 16:break;
      default:Ra.sl[6]=1690; /* line # 1690 */
      Rv2=0;
      break;
    }
    if (Rv2) Rv0=((V *)Rv5)[1];
  }
  if (Rv4) {
    Ra.sl[6]=1696; /* line # 1696 */
    P_lgt_scan(Rv0);
    (*F_lgt)=P_lgt_link(Rv0);
    ((V *)Rv0)[0]=Rv1;
  }
  else P_lgt_scan((*F_lgt));
  Ra.sl[6]=1701; /* line # 1701 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_pass_link "  */
V PAS_LGT_PRC_00000007(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+624;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1708; /* line # 1708 */
  if (F_lgt!=NULL) {
    Rv0=F_lgt;
    if (((UB *)Rv0)[40]==16) Ret=PAS_LGT_PRC_00000007(((V *)Rv0)[1]);
    else Ret=F_lgt;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_is_const "  */
V PAS_LGT_PRC_00000008(V F_lgt, V *F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+639;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1721; /* line # 1721 */
  F_lgt=PAS_LGT_PRC_00000007(F_lgt);
  if (F_lgt!=NULL) {
    Rv0=F_lgt;
    if (((UB *)Rv0)[40]==14) Ret=((V *)Rv0)[7];
    else Ret=NULL;
  }
  else {
    Ra.sl[6]=1726; /* line # 1726 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_cte_in_2 "  */
V PAS_LGT_PRC_00000009(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+653;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1737; /* line # 1737 */
  Rv0=((V *)(*F_lgt))[1];
  Rv1=PAS_LGT_PRC_00000008(Rv0, NULL);
  Rv2=((V *)(*F_lgt))[0];
  Rv3=PAS_LGT_PRC_00000008(Rv2, NULL);
  if (Rv1!=NULL) {
    Ra.sl[6]=1742; /* line # 1742 */
    Rv4=(*F_lgt);
    if (Rv3==NULL||((UB *)Rv2)[40]==16) {
      ((V *)Rv4)[1]=Rv2;
      ((V *)Rv2)[0]=Rv0;
      ((V *)Rv0)[0]=NULL;
      Ret=Rv1;
    }
    else {
      Ra.sl[6]=1750; /* line # 1750 */
      switch (((UB *)Rv4)[41]) {
        case 49:if (((UB *)((V *)Rv4)[3])[112]) ((V *)Rv4)[1]=P_lgt_new_econst((
        (V *)Rv4)[3],((UL *)Rv1)[13]+((UL *)Rv3)[13]);
        else {
          Ra.sl[6]=1755; /* line # 1755 */
          ((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)[3],((SL *)Rv1)[13]+((SL *)Rv3)
          [13]);
        }
        break;
        case 67:
        case 85:((V *)Rv4)[1]=P_lgt_new_econstr(((V *)Rv4)[3],((G *)Rv1)[7]+((G *)
        Rv3)[7]);
        break;
        case 51:Ra.sl[6]=1760; /* line # 1760 */
        if (((UB *)((V *)Rv4)[3])[112]) ((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)
        [3],((UL *)Rv1)[13]*((UL *)Rv3)[13]);
        else((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)[3],((SL *)Rv1)[13]*((SL *)
        Rv3)[13]);
        break;
        case 69:
        case 87:Ra.sl[6]=1766; /* line # 1766 */
        ((V *)Rv4)[1]=P_lgt_new_econstr(((V *)Rv4)[3],((G *)Rv1)[7]*((G *)Rv3)[7]
        );
        break;
        default:break;
      }
      P_lgt_free(&Rv0);
      P_lgt_free(&Rv2);
      Ret=NULL;
    }
  }
  else {
    Ra.sl[6]=1773; /* line # 1773 */
    Ret=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_scan "  */
void P_lgt_scan(V F_head){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  SL Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+667;
  Ra.v[4]=Rd.s+14;
  Ra.sl[10]=1815; /* line # 1815 */
  if (F_head!=NULL) {
    Rv0=F_head;
    switch (((UB *)Rv0)[40]) {
      case 24:Ra.sl[10]=1821; /* line # 1821 */
      Rv1=((V *)Rv0)[1];
      while (Rv1!=NULL){
        P_lgt_scan(Rv1);
        Ra.sl[10]=1826; /* line # 1826 */
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 0:Ra.sl[10]=1832; /* line # 1832 */
      switch (((UB *)Rv0)[41]) {
        case 3:PAS_LGT_PRC_00000005(((V *)Rv0)[1],((SL *)Rv0)[4]);
        break;
        case 8:Ra.sl[10]=1837; /* line # 1837 */
        if (((V *)Rv0)[1]!=NULL) {
          P_lgt_scan(((V *)Rv0)[1]);
          Rv1=((V *)((V *)Rv0)[1])[0];
          while (Rv1!=NULL){
            Ra.sl[10]=1843; /* line # 1843 */
            if (((V *)Rv0)[3]==NULL) PAS_LGT_PRC_00000004(Rv1);
            else P_lgt_scan(Rv1);
            Rv1=((V *)Rv1)[0];
          }
        }
        break;
        case 9:break;
        case 0:
        case 2:
        case 4:
        case 5:Ra.sl[10]=1855; /* line # 1855 */
        Rv1=((V *)Rv0)[1];
        Rv2=NULL;
        if (((UB *)Rv0)[41]==5||((UB *)Rv0)[41]==4) {
          P_lgt_scan(Rv1);
          Rv2=Rv1;
          Rv1=((V *)Rv1)[0];
        }
        Ra.sl[10]=1862; /* line # 1862 */
        Ra.v[0]=V_lgt_inshde;
        Ra.v[1]=V_lgt_inslst;
        V_lgt_inslst=NULL;
        V_lgt_inshde=NULL;
        while (Rv1!=NULL){
          P_lgt_scan(Rv1);
          Ra.sl[10]=1867; /* line # 1867 */
          if (V_lgt_inslst!=NULL) {
            if (Rv2==NULL) PAS_LGT_lgt_do_insert(F_head,1);
            else PAS_LGT_lgt_do_insert(Rv2,0);
          }
          Rv2=Rv1;
          Rv1=((V *)Rv1)[0];
        }
        Ra.sl[10]=1873; /* line # 1873 */
        V_lgt_inshde=Ra.v[0];
        V_lgt_inslst=Ra.v[1];
        break;
        case 6:Ra.sl[10]=1878; /* line # 1878 */
        Rv1=((V *)Rv0)[1];
        Rv2=((V *)Rv1)[1];
        while (Rv2!=NULL)
        if (((UB *)Rv2)[40]==23) Rv2=((V *)Rv2)[0];
        else {
          Ra.sl[10]=1885; /* line # 1885 */
          ((V *)Rv1)[1]=Rv2;
          Rv2=NULL;
        }
        P_lgt_scan(((V *)Rv1)[0]);
        break;
        case 7:Ra.sl[10]=1891; /* line # 1891 */
        P_lgt_scan(((V *)Rv0)[1]);
        break;
        default:break;
      }
      break;
      case 23:Ra.sl[10]=1899; /* line # 1899 */
      Rv1=((V *)Rv0)[1];
      while (Rv1!=NULL){
        P_lgt_scan(Rv1);
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 6:Ra.sl[10]=1908; /* line # 1908 */
      if (((V *)Rv0)[1]!=NULL) switch (((UB *)Rv0)[41]) {
        case 49:Ra.sl[10]=1913; /* line # 1913 */
        P_lgt_scan(((V *)Rv0)[1]);
        if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),46)) ((UB *)Rv0)[41]=50;
        break;
        case 67:Ra.sl[10]=1919; /* line # 1919 */
        P_lgt_scan(((V *)Rv0)[1]);
        if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),61)) ((UB *)Rv0)[41]=68;
        break;
        case 85:Ra.sl[10]=1925; /* line # 1925 */
        P_lgt_scan(((V *)Rv0)[1]);
        if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),77)) ((UB *)Rv0)[41]=86;
        break;
        case 50:Ra.sl[10]=1932; /* line # 1932 */
        P_lgt_scan(((V *)Rv0)[1]);
        if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),46)) ((UB *)Rv0)[41]=49;
        break;
        case 68:Ra.sl[10]=1938; /* line # 1938 */
        P_lgt_scan(((V *)Rv0)[1]);
        if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),61)) ((UB *)Rv0)[41]=67;
        break;
        case 86:Ra.sl[10]=1944; /* line # 1944 */
        P_lgt_scan(((V *)Rv0)[1]);
        if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),77)) ((UB *)Rv0)[41]=85;
        break;
        case 46:Ra.sl[10]=1950; /* line # 1950 */
        if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,46)) ((UB *)Rv0)[41]=0;
        break;
        case 61:if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,61)) ((UB *)Rv0)[41]=0;
        break;
        case 77:Ra.sl[10]=1956; /* line # 1956 */
        if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,77)) ((UB *)Rv0)[41]=0;
        break;
        case 6:if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,6)) {
          Ra.sl[10]=1961; /* line # 1961 */
          ((UB *)Rv0)[41]=0;
        }
        break;
        case 10:if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,10)) ((UB *)Rv0)[41]=0;
        break;
        case 53:Ra.sl[10]=1968; /* line # 1968 */
        Rv1=((V *)Rv0)[1];
        if (Rv1!=NULL) {
          P_lgt_scan(Rv1);
          Rv1=((V *)Rv1)[0];
          if (Rv1!=NULL) {
            Ra.sl[10]=1974; /* line # 1974 */
            P_lgt_scan(Rv1);
            if (P_lgt_imaskp2(Rv1)>=0) ((UB *)Rv0)[41]=11;
          }
        }
        break;
        default:Ra.sl[10]=1981; /* line # 1981 */
        Rv1=((V *)Rv0)[1];
        while (Rv1!=NULL){
          P_lgt_scan(Rv1);
          Rv1=((V *)Rv1)[0];
        }
        break;
      }
      break;
      case 5:Ra.sl[10]=1991; /* line # 1991 */
      Rv1=((V *)Rv0)[1];
      if ((!V_binline&&Rv1!=NULL)&&((V *)Rv0)[3]!=NULL) {
        if (((UB *)Rv1)[40]==14) {
          ((V *)Rv0)[1]=NULL;
          Ra.sl[10]=1996; /* line # 1996 */
          ((UB *)Rv0)[40]=14;
          ((SL *)Rv0)[4]=((SL *)Rv0)[4]+((SL *)Rv1)[4];
          if (256&((UW *)Rv1)[10]) {
            ((V *)Rv0)[7]=NULL;
            Ra.sl[10]=2001; /* line # 2001 */
            P_val_copy(((V *)Rv1)+7,((V *)Rv0)+7,0);
          }
          else {
            ((V *)Rv0)[7]=((V *)Rv1)[7];
            Ra.sl[10]=2006; /* line # 2006 */
            P_val_new(((V *)Rv0)+7,((V *)Rv0)[3]);
            P_lgt_free(&Rv1);
          }
          if (((V *)Rv0)[7]!=NULL) {
            Ra.sl[10]=2011; /* line # 2011 */
            Rv3=((V *)Rv0)[7];
            if (((V *)Rv3)[5]==NULL) {
              P_all_new(((V *)Rv3)+5,((V *)Rv0)[3],((V *)Rv0)[4],11);
              if (V_all_fdata==NULL) V_all_fdata=((V *)Rv3)[5];
              else {
                Ra.sl[10]=2016; /* line # 2016 */
                ((V *)V_all_ldata)[0]=((V *)Rv3)[5];
              }
              ((V *)((V *)Rv3)[5])[1]=V_all_ldata;
              V_all_ldata=((V *)Rv3)[5];
              Rv4=((V *)Rv3)[5];
              Ra.sl[10]=2021; /* line # 2021 */
              ((V *)Rv4)[13]=((V *)Rv0)[7];
              Rv5=((V *)Rv4)[13];
              ((SL *)Rv5)[3]=((SL *)Rv5)[3]+1;
              ((V *)Rv4)[10]=F_head;
              ((V *)Rv4)[11]=F_head;
            }
            else {
              Ra.sl[10]=2028; /* line # 2028 */
              Rv6=((V *)Rv3)[5];
              if (((V *)Rv6)[10]==NULL) ((V *)Rv6)[10]=F_head;
              else((V *)((V *)Rv6)[11])[1]=F_head;
              ((V *)Rv6)[11]=F_head;
            }
          }
        }
        else {
          Ra.sl[10]=2037; /* line # 2037 */
          P_lgt_scan(Rv1);
          ((SL *)Rv0)[4]=P_ide_typ_align(Rs.sl[9],((V *)Rv0)[3]);
          Rs.sl[9]=((SL *)Rv0)[4]+((SL *)((V *)Rv0)[3])[11];
          if (Rs.sl[10]<Rs.sl[9]) Rs.sl[10]=Rs.sl[9];
        }
      }
      break;
      case 1:
      case 2:
      case 3:
      case 4:
      case 9:
      case 20:Ra.sl[10]=2046; /* line # 2046 */
      Rv1=((V *)Rv0)[1];
      Ra.sl[10]=2054; /* line # 2054 */
      while (Rv1!=NULL){
        P_lgt_scan(Rv1);
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 17:break;
      case 16:break;
      case 7:
      case 8:Ra.sl[10]=2068; /* line # 2068 */
      Rv7=((V *)Rv0)[6];
      if (1&((UW *)Rv7)[8]) PAS_LGT_lgt_inline_exp(F_head);
      else {
        Rv8=Rs.sl[9];
        Ra.sl[10]=2073; /* line # 2073 */
        Rv9=((V *)Rv7)[8];
        Rv1=((V *)Rv0)[1];
        if (((UB *)Rv0)[40]==7) {
          P_lgt_scan(Rv1);
          Ra.sl[10]=2078; /* line # 2078 */
          Rv1=((V *)Rv1)[0];
        }
        else {
          ((UW *)Rv7)[8]=((UW *)Rv7)[8]|8;
          Ra.sl[10]=2083; /* line # 2083 */
          if ((((UW *)Rv7)[8]&768)==0) ((UW *)Rv7)[8]=((UW *)Rv7)[8]|256;
          if (((UB *)Rv7)[104]==3) {
            if (V_curr_lex!=((SL *)Rv7)[18]) ((UW *)Rv7)[8]=((UW *)Rv7)[8]|1024;
          }
        }
        Ra.sl[10]=2089; /* line # 2089 */
        while (Rv1!=NULL){
          P_lgt_scan(Rv1);
          if (((V *)Rv1)[3]!=NULL) {
            Ra.sl[10]=2094; /* line # 2094 */
            if (256&((UW *)Rv9)[46]) {
              Rv10=((V *)Rv1)[3];
              switch (((UB *)Rv10)[92]) {
                case 1:Ra.sl[10]=2099; /* line # 2099 */
                if (((V *)Rv10)[13]!=NULL) P_lgt_scan(((V *)Rv10)[13]);
                break;
                case 11:
                case 12:if (((V *)Rv10)[13]!=NULL) {
                  Rv11=((V *)Rv10)[13];
                  if (1<<((UB *)Rv11)[92]&7) {
                    Ra.sl[10]=2104; /* line # 2104 */
                    if (((V *)Rv11)[13]!=NULL) P_lgt_scan(((V *)Rv11)[13]);
                  }
                }
                break;
                default:break;
              }
            }
          }
          Rv9=((V *)Rv9)[3];
          Ra.sl[10]=2109; /* line # 2109 */
          Rv1=((V *)Rv1)[0];
        }
        Rs.sl[9]=Rv8;
      }
      break;
      case 11:Ra.sl[10]=2115; /* line # 2115 */
      Rv12=((V *)Rv0)[6];
      ((UW *)Rv12)[8]=((UW *)Rv12)[8]|8;
      if (!(512&((UW *)Rv12)[8])) ((UW *)Rv12)[8]=((UW *)Rv12)[8]|256;
      Ra.sl[10]=2120; /* line # 2120 */
      if (V_curr_lex!=((SL *)Rv12)[18]) ((UW *)Rv12)[8]=((UW *)Rv12)[8]|1024;
      break;
      case 12:
      case 21:Ra.sl[10]=2125; /* line # 2125 */
      P_lgt_scan(((V *)Rv0)[1]);
      break;
      case 13:if (!V_binline) {
        Ra.sl[10]=2130; /* line # 2130 */
        if (((V *)Rv0)[6]!=NULL) {
          Rv13=((V *)Rv0)[6];
          Ra.sl[10]=2135; /* line # 2135 */
          if (((V *)Rv13)[10]==NULL) {
            Ra.sl[10]=2142; /* line # 2142 */
            ((UW *)Rv13)[46]=((UW *)Rv13)[46]|1;
            if (V_curr_lex!=((SL *)Rv13)[10]) ((UW *)Rv13)[46]=((UW *)Rv13)[46]|
4;
            P_all_new(((V *)Rv13)+10,((V *)Rv13)[4],((V *)Rv0)[6],((UB *)Rv13)[94]
            );
            if (4&((UW *)Rv13)[46]) {
              Ra.sl[10]=2147; /* line # 2147 */
              ((V *)((V *)Rv13)[10])[10]=NULL;
            }
            else((V *)((V *)Rv13)[10])[10]=F_head;
            switch (((UB *)Rv13)[94]) {
              case 4:
              case 5:
              case 12:Ra.sl[10]=2155; /* line # 2155 */
              if (V_all_fextern==NULL) V_all_fextern=((V *)Rv13)[10];
              else((V *)V_all_lextern)[0]=((V *)Rv13)[10];
              ((V *)((V *)Rv13)[10])[1]=V_all_lextern;
              V_all_lextern=((V *)Rv13)[10];
              break;
              case 3:Ra.sl[10]=2163; /* line # 2163 */
              ((V *)((V *)Rv13)[10])[13]=((V *)Rv13)[8];
              if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv13)[10];
              else((V *)V_all_lglobal)[0]=((V *)Rv13)[10];
              ((V *)((V *)Rv13)[10])[1]=V_all_lglobal;
              V_all_lglobal=((V *)Rv13)[10];
              break;
              case 0:
              case 1:Ra.sl[10]=2172; /* line # 2172 */
              if (((SL *)Rv13)[10]<=1) {
                ((V *)((V *)Rv13)[10])[13]=((V *)Rv13)[8];
                if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv13)[10];
                else((V *)V_all_lstatic)[0]=((V *)Rv13)[10];
                Ra.sl[10]=2177; /* line # 2177 */
                ((V *)((V *)Rv13)[10])[1]=V_all_lstatic;
                V_all_lstatic=((V *)Rv13)[10];
              }
              else {
                Rv14=((V *)Rv13)[6];
                Ra.sl[10]=2183; /* line # 2183 */
                if (((V *)Rv14)[25]==NULL) ((V *)Rv14)[25]=((V *)Rv13)[10];
                else((V *)((V *)Rv14)[26])[0]=((V *)Rv13)[10];
                ((V *)((V *)Rv13)[10])[1]=((V *)Rv14)[26];
                ((V *)Rv14)[26]=((V *)Rv13)[10];
              }
              break;
              case 2:Ra.sl[10]=2191; /* line # 2191 */
              ((V *)((V *)Rv13)[10])[13]=((V *)Rv13)[8];
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv13)[10];
              else((V *)V_all_lstatic)[0]=((V *)Rv13)[10];
              ((V *)((V *)Rv13)[10])[1]=V_all_lstatic;
              V_all_lstatic=((V *)Rv13)[10];
              break;
              default:break;
            }
          }
          else {
            Ra.sl[10]=2201; /* line # 2201 */
            Rv15=((V *)Rv13)[10];
            switch (((UB *)Rv13)[94]) {
              case 1:
              case 2:
              case 3:
              case 4:
              case 5:
              case 12:if (((V *)Rv15)[11]!=NULL&&((V *)Rv15)[11]!=F_head) {
                Ra.sl[10]=2206; /* line # 2206 */
                ((V *)((V *)Rv15)[11])[1]=F_head;
              }
              break;
              case 7:
              case 8:((UW *)Rv13)[46]=((UW *)Rv13)[46]|1;
              Ra.sl[10]=2211; /* line # 2211 */
              if (V_curr_lex!=((SL *)Rv13)[10]) ((UW *)Rv13)[46]=((UW *)Rv13)[46]
              |4;
              ((UW *)Rv15)[16]=((UW *)Rv13)[46];
              break;
              default:break;
            }
          }
          Ra.sl[10]=2218; /* line # 2218 */
          ((V *)Rv0)[7]=((V *)Rv13)[10];
          ((V *)((V *)Rv13)[10])[11]=F_head;
        }
        else {
          Ra.sl[10]=2223; /* line # 2223 */
          if (((V *)Rv0)[7]==NULL) P_all_new(((V *)Rv0)+7,((V *)Rv0)[3],NULL,0);
          Rv16=((V *)Rv0)[7];
          if (((V *)Rv16)[10]==NULL) {
            Ra.sl[10]=2228; /* line # 2228 */
            if (((SL *)Rv16)[15]<=1) {
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv0)[7];
              else((V *)V_all_lstatic)[0]=((V *)Rv0)[7];
              ((V *)((V *)Rv0)[7])[1]=V_all_lstatic;
              Ra.sl[10]=2233; /* line # 2233 */
              V_all_lstatic=((V *)Rv0)[7];
            }
            else {
              Rv17=((V *)Rv16)[5];
              Ra.sl[10]=2238; /* line # 2238 */
              if (((V *)Rv17)[25]==NULL) ((V *)Rv17)[25]=((V *)Rv0)[7];
              else((V *)((V *)Rv17)[26])[0]=((V *)Rv0)[7];
              ((V *)((V *)Rv0)[7])[1]=((V *)Rv17)[26];
              ((V *)Rv17)[26]=((V *)Rv0)[7];
            }
            Ra.sl[10]=2243; /* line # 2243 */
            ((V *)Rv16)[10]=F_head;
            ((V *)Rv16)[11]=F_head;
            Rv18=((V *)Rv0)[3];
            if (((SL *)Rv18)[10]>0&&((V *)Rv18)[4]!=NULL) {
              Ra.sl[10]=2249; /* line # 2249 */
              Rv9=((V *)Rv18)[4];
              while (Rv9!=NULL){
                P_lgt_new_copy(F_head, &Rv2);
                Ra.sl[10]=2254; /* line # 2254 */
                ((V *)Rv2)[3]=((V *)Rv9)[4];
                ((SL *)Rv2)[4]=((SL *)Rv9)[15];
                ((V *)Rv2)[0]=P_lgt_new_econst(((V *)Rv9)[4],((SL *)((V *)Rv9)[11]
                )[13]);
                Rv1=P_lgt_new_code(3, Rv2);
                Ra.sl[10]=2259; /* line # 2259 */
                if (V_lgt_inshde==NULL) V_lgt_inshde=Rv1;
                else((V *)V_lgt_inslst)[0]=Rv1;
                V_lgt_inslst=Rv1;
                Rv9=((V *)Rv9)[3];
              }
            }
          }
          else {
            Ra.sl[10]=2268; /* line # 2268 */
            if (((V *)Rv16)[10]==NULL) ((V *)Rv16)[10]=F_head;
            else((V *)((V *)Rv16)[11])[1]=F_head;
            ((V *)Rv16)[11]=F_head;
          }
        }
      }
      break;
      case 15:Ra.sl[10]=2278; /* line # 2278 */
      Rv1=((V *)Rv0)[1];
      P_lgt_scan(Rv1);
      Rv1=((V *)Rv1)[0];
      if (Rv1!=NULL) Rv1=((V *)Rv1)[0];
      while (Rv1!=NULL){
        Ra.sl[10]=2284; /* line # 2284 */
        P_lgt_scan(Rv1);
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 14:Ra.sl[10]=2289; /* line # 2289 */
      if (!V_binline) {
        Ra.sl[10]=2294; /* line # 2294 */
        if (((V *)Rv0)[7]!=NULL) {
          Rv19=((V *)Rv0)[7];
          if (((V *)Rv19)[4]!=NULL) {
            Rv20=((V *)Rv19)[4];
            Ra.sl[10]=2299; /* line # 2299 */
            if (!((UB *)Rv20)[91]) {
              if (((UB *)((V *)Rv0)[3])[91]) PAS_LGT_lgt_extract_cte(F_head);
              else {
                Ra.sl[10]=2305; /* line # 2305 */
                if (((V *)Rv19)[5]==NULL) {
                  Rv21=((SL *)Rv20)[11];
                  if (((SL *)Rv19)[6]>0) {
                    if (((V *)Rv0)[3]==V_typ_std.v[10]) {
                      Ra.sl[10]=2310; /* line # 2310 */
                      ((SL *)Rv20)[11]=((SL *)Rv19)[6]+((SL *)Rv20)[10];
                    }
                    else((SL *)Rv20)[11]=((SL *)Rv19)[6];
                  }
                  P_all_new(((V *)Rv19)+5,((V *)Rv0)[3],((V *)Rv0)[4],11);
                  ((SL *)Rv20)[11]=Rv21;
                  Ra.sl[10]=2315; /* line # 2315 */
                  if (V_all_fdata==NULL) V_all_fdata=((V *)Rv19)[5];
                  else((V *)V_all_ldata)[0]=((V *)Rv19)[5];
                  ((V *)((V *)Rv19)[5])[1]=V_all_ldata;
                  V_all_ldata=((V *)Rv19)[5];
                  Rv22=((V *)Rv19)[5];
                  Ra.sl[10]=2321; /* line # 2321 */
                  ((V *)Rv22)[13]=((V *)Rv0)[7];
                  Rv23=((V *)Rv22)[13];
                  ((SL *)Rv23)[3]=((SL *)Rv23)[3]+1;
                  ((V *)Rv22)[10]=F_head;
                  ((V *)Rv22)[11]=F_head;
                }
              }
            }
          }
          Ra.sl[10]=2330; /* line # 2330 */
          if (!((UB *)((V *)Rv0)[3])[91]) {
            if (((UB *)Rv19)[48]!=21) {
              if (!(((V *)Rv19)[5]==NULL)) {
                Ra.sl[10]=2337; /* line # 2337 */
                Rv24=((V *)Rv19)[5];
                if (((V *)Rv24)[10]==NULL) ((V *)Rv24)[10]=F_head;
                else((V *)((V *)Rv24)[11])[1]=F_head;
                ((V *)Rv24)[11]=F_head;
              }
            }
          }
        }
      }
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " lgt_all_fparm "  */
void P_lgt_all_fparm(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+677;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=2360; /* line # 2360 */
  Rv0=F_pr;
  Rv1=((V *)Rv0)[8];
  while (Rv1!=NULL){
    Ra.sl[6]=2365; /* line # 2365 */
    Rv2=Rv1;
    if (((UB *)Rv2)[56]==7) {
      P_all_new(((V *)Rv2)+10,V_typ_std.v[13],Rv1,9);
      ((V *)((V *)Rv2)[9])[14]=((V *)Rv2)[10];
    }
    else {
      Ra.sl[6]=2373; /* line # 2373 */
      P_all_new(((V *)Rv2)+10,V_typ_std.v[13],Rv1,((UB *)Rv2)[94]);
      if (((V *)Rv2)[4]!=NULL) {
        Rv3=((V *)Rv2)[4];
        if ((!((UB *)Rv3)[91]&&((UB *)Rv2)[94]==8)&&((SL *)Rv3)[11]<0) {
          Ra.sl[6]=2380; /* line # 2380 */
          Rv4=P_lgt_new_idref(Rv1,NULL);
          ((V *)((V *)Rv2)[10])[9]=P_lgt_type_eval(((V *)Rv3)[9],Rv4,NULL,0);
        }
      }
    }
    Rv1=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_all_dynamic "  */
void PAS_LGT_lgt_all_dynamic(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+692;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=2398; /* line # 2398 */
  Rv0=NULL;
  Rv1=F_pr;
  Rv2=((V *)Rv1)[8];
  while (Rv2!=NULL){
    Ra.sl[6]=2404; /* line # 2404 */
    Rv3=Rv2;
    if (((UB *)Rv3)[56]==5&&((V *)Rv3)[10]!=NULL) {
      Rv4=((V *)Rv3)[10];
      if (((V *)Rv4)[9]!=NULL) {
        Ra.sl[6]=2411; /* line # 2411 */
        Rv5=((V *)Rv4)[9];
        if (Rv0==NULL) Rv0=Rv5;
        else((V *)Rv6)[0]=Rv5;
        Rv6=Rv5;
      }
    }
    Ra.sl[6]=2416; /* line # 2416 */
    Rv2=((V *)Rv2)[3];
  }
  if (Rv0!=NULL) {
    Ra.sl[6]=2422; /* line # 2422 */
    P_lgt_new(&Rv5,NULL,24, Rv0);
    if (((V *)Rv1)[16]==NULL) ((V *)Rv1)[16]=Rv5;
    else {
      Ra.sl[6]=2427; /* line # 2427 */
      Rv7=((V *)Rv1)[16];
      if (((UB *)Rv7)[40]==0&&((UB *)Rv7)[41]==2) {
        ((V *)Rv5)[0]=((V *)Rv7)[1];
        ((V *)Rv7)[1]=Rv5;
      }
      else {
        Ra.sl[6]=2435; /* line # 2435 */
        ((V *)Rv5)[0]=((V *)Rv1)[16];
        P_lgt_new(((V *)Rv1)+16,NULL,0, Rv5);
        ((UB *)((V *)Rv1)[16])[41]=2;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_pass1_complet "  */
void P_lgt_pass1_complet(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+709;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=2448; /* line # 2448 */
  V_lgt_inshde=NULL;
  V_lgt_inslst=NULL;
  Rs.sl[10]=0;
  Rs.sl[9]=0;
  Ra.sl[6]=2453; /* line # 2453 */
  Rv0=F_pr;
  ((UW *)Rv0)[8]=((UW *)Rv0)[8]|512;
  V_binline=((UB *)Rv0)[104]==10;
  Ra.sl[6]=2458; /* line # 2458 */
  PAS_LGT_lgt_all_dynamic(F_pr);
  P_lgt_scan(((V *)Rv0)[16]);
  ((SL *)Rv0)[59]=Rs.sl[10];
  PAS__curr_cntx=Ra.v[0];
}
