/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 600 ) = {
 11,  11, 115, 114,  99,  95, 109, 101, 120, 112, 101, 110, 100,  63,  63,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  52,  47,  99,
112,  97, 115,  95,  98,  95,  95, 115, 114,  99,  46, 112,  97, 115,  10,  10,
115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  12,  12, 115, 114,  99,  95,
 97, 108, 108, 111,  99,  97, 116, 101,   8,   8, 115, 114,  99,  95, 102, 114,
101, 101,   9,   9, 115, 114,  99,  95,  99, 108, 111, 115, 101,  13,  13, 115,
114,  99,  95, 102, 105, 108, 101,  95, 111, 112, 101, 110,  17,  17, 115, 114,
 99,  95,  97,  99, 116, 105, 118, 101,  95, 115, 111, 117, 114,  99, 101,  14,
 14, 115, 114,  99,  95, 109,  97,  99, 114, 111,  95, 111, 112, 101, 110,  10,
 10, 115, 114,  99,  95, 114, 101, 116, 117, 114, 110,  17,  17, 115, 114,  99,
 95, 111, 117, 116,  95, 116, 101, 120, 116,  95, 108, 105, 110, 101,  11,  11,
115, 114,  99,  95, 111, 117, 116, 108, 105, 110, 101,  17,  17, 115, 114,  99,
 95, 111, 117, 116, 101, 114, 114,  95,  98,  97, 110, 110, 101, 114,  40,  40,
 32,  37,  42,  43,  42,  43,  42,  32, 101, 114, 114, 111, 114,  40, 115,  41,
 32, 119,  97, 115,  32, 100, 101, 116, 101,  99, 116, 101, 100,  32,  97, 116,
 32, 108, 105, 110, 101,  32,  35,  32,  16,  16,  32, 105, 110,  32, 116, 104,
101,  32, 102, 105, 108, 101,  32,  58,  32,  34,  13,  13, 115, 114,  99,  95,
111, 117, 116,  95, 101, 114, 114, 111, 114,  35,  35,  10,  32,  60,  60,  60,
 32,  42,  42,  42,  32,  77,  97, 120, 105, 109, 117, 109,  32, 110, 117, 109,
 98, 101, 114,  32, 111, 102,  32, 101, 114, 114, 111, 114,  32,  40,  31,  31,
 41,  32, 105, 115,  32, 114, 101,  97,  99, 104, 101, 100,  46,  32,  83,  82,
 67,  95,  76, 105,  98, 114,  97, 114, 121,  32, 115, 116, 111, 112,  32,  10,
 10,  46,  32,  42,  42,  42,  32,  62,  62,  62,  10,  17,  17, 115, 114,  99,
 95, 111, 117, 116,  95, 109,  97,  99,  95, 101, 114, 114, 111, 114,   9,   9,
115, 114,  99,  95, 101, 114, 114, 111, 114,  17,  17, 115, 114,  99,  95, 103,
101, 116,  95, 105, 110, 112, 117, 116, 108, 105, 110, 101,  14,  14, 115, 114,
 99,  95, 112, 117, 116,  95, 112, 114, 111, 109, 112, 116,  12,  12, 115, 114,
 99,  95, 103, 101, 116,  95, 108, 105, 110, 101,  15,  15, 115, 114,  99,  95,
101, 110, 100,  95, 111, 102,  95, 108, 105, 110, 101,   4,   4,  83,  95,  71,
 76,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95,  99, 104,  97, 114,  12,
 12, 115, 107, 105, 112,  95,  99, 111, 109, 109, 101, 110, 116,  10,  10, 115,
114,  99,  95, 105, 110,  99, 104,  97, 114,  13,  13, 115, 114,  99,  95, 110,
101, 120, 116,  95,  99, 104,  97, 114,  15,  15, 115, 114,  99,  95, 115, 101,
 97, 114,  99, 104,  95,  99, 104,  97, 114,  13,  13, 115, 114,  99,  95, 115,
101, 116,  95, 102, 108,  97, 103, 115,   8,   8, 115, 114,  99,  95, 105, 110,
105, 116,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 16 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Global C type definitions */
typedef  V (*Re0)(V);

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
Blk(V_src_jobname, 32 ) = {
 30,  10,  80, 114, 111,  99, 101, 115,
115, 105, 110, 103,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
SL V_src_openerr;
SL V_src_maxerror;
SL V_src_lstinsnb;
V V_src_control;
V V_src_cont_base;
V V_src_hde;
V V_src_listing;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);
void P_vsr_nextstring();


/* Procedure/Function : " src_mexpend "  */
void BASIC_SRC_src_mexpend(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register SL Rv2;
  V Rv3;
  SL Rv4;
  register V Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=149; /* line # 149 */
  if (Ri.v[0]==NULL) {
    Ri.v[0]=PAS__NEW(1036);
    ((SL *)Ri.v[0])[0]=1024;
    Rv0=Ri.v[0];
    ((SL *)Rv0)[1]=0;
    ((SL *)Rv0)[2]=0;
  }
  else {
    Ra.sl[6]=156; /* line # 156 */
    if (((SL *)Ri.v[0])[0]<=((SL *)Ri.v[0])[1]) {
      Rv1=Ri.v[0];
      Rv2=((SL *)Rv1)[0]+1024;
      Rv3=PAS__NEW(Rv2+12);
      ((SL *)Rv3)[0]=Rv2;
      Ra.sl[6]=161; /* line # 161 */
      ((SL *)Rv3)[1]=((SL *)Rv1)[1];
      ((SL *)Rv3)[2]=((SL *)Rv1)[2];
      Rv4=1;
      for( Rf0=((SL *)Rv1)[1];Rf0>0;Rf0-- ) {
        ((C *)Rv3)[Rv4+11]=((C *)Rv1)[Rv4+11];
        Rv4++;
      }
      PAS__DISPOSE(Ri.v);
      Ra.sl[6]=166; /* line # 166 */
      Ri.v[0]=Rv3;
    }
  }
  Rv5=Ri.v[0];
  ((SL *)Rv5)[1]=((SL *)Rv5)[1]+1;
  ((C *)Rv5)[((SL *)Rv5)[1]+11]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_r_init "  */
void BASIC_SRC_src_r_init(V F_p, UB F_macflg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+78;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=179; /* line # 179 */
  if (F_p!=NULL) {
    Rv0=F_p;
    ((V *)Rv0)[0]=V_src_hde;
    Ra.sl[6]=184; /* line # 184 */
    ((V *)Rv0)[1]=NULL;
    ((SL *)Rv0)[4]=0;
    ((SL *)Rv0)[5]=0;
    ((SL *)Rv0)[6]=0;
    ((SL *)Rv0)[7]=0;
    Ra.sl[6]=189; /* line # 189 */
    ((SL *)Rv0)[8]=0;
    ((SL *)Rv0)[9]=0;
    ((SL *)Rv0)[10]=0;
    ((SL *)Rv0)[11]=1;
    ((SL *)Rv0)[12]=255;
    Ra.sl[6]=194; /* line # 194 */
    ((C *)Rv0)[52]=0;
    ((C *)Rv0)[53]=1;
    if (F_macflg) ((C *)Rv0)[54]=77;
    else((C *)Rv0)[54]=32;
    ((C *)Rv0)[55]=32;
    Ra.sl[6]=199; /* line # 199 */
    Rv1=1;
    for( Rf0=8;Rf0>0;Rf0-- ) {
      ((V *)Rv0)[Rv1*3+6]=NULL;
      Rv1++;
    }
    if (!F_macflg) {
      Ra.sl[6]=204; /* line # 204 */
      if (32768&((UL *)Rv0)[62]) {
        ((V *)Rv0)[32]=NULL;
        ((V *)Rv0)[34]=NULL;
        ((V *)Rv0)[33]=NULL;
      }
      Ra.sl[6]=210; /* line # 210 */
      ((UL *)Rv0)[62]=2120;
      ((UB *)Rv0)[252]=0;
      if (((V *)Rv0)[32]==NULL) {
        ((V *)Rv0)[32]=PAS__NEW(257);
        ((UB *)((V *)Rv0)[32])[0]=255;
      }
      ((UB *)((V *)Rv0)[32])[1]=0;
      if (((V *)Rv0)[33]!=NULL) {
        Ra.sl[6]=215; /* line # 215 */
        PAS__DISPOSE(((V *)Rv0)+33);
        ((V *)Rv0)[33]=NULL;
      }
    }
    else {
      if (!(32768&((UL *)Rv0)[62])) {
        Ra.sl[6]=221; /* line # 221 */
        if (((V *)Rv0)[32]!=NULL) PAS__DISPOSE(((V *)Rv0)+32);
        if (((V *)Rv0)[33]!=NULL) PAS__DISPOSE(((V *)Rv0)+33);
      }
      ((UL *)Rv0)[62]=34880;
      ((UB *)Rv0)[252]=4;
      Ra.sl[6]=226; /* line # 226 */
      ((V *)Rv0)[32]=NULL;
      ((V *)Rv0)[33]=NULL;
      ((V *)Rv0)[34]=NULL;
      ((SL *)Rv0)[70]=0;
    }
  }
  Ra.sl[6]=232; /* line # 232 */
  V_src_hde=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V BASIC_SRC_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+90;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=244; /* line # 244 */
  Rv0=PAS__NEW(288);
  Rv1=Rv0;
  ((UL *)Rv1)[62]=32768;
  ((V *)Rv1)[32]=NULL;
  Ra.sl[6]=249; /* line # 249 */
  ((V *)Rv1)[33]=NULL;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+104;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=263; /* line # 263 */
  Rv0=NULL;
  if ((*F_p)!=NULL) {
    Rv1=V_src_hde;
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[6]=269; /* line # 269 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Ra.sl[6]=274; /* line # 274 */
    Rv2=(*F_p);
    if (!(32768&((UL *)Rv2)[62])) {
      if (((V *)Rv2)[32]!=NULL) PAS__DISPOSE(((V *)Rv2)+32);
      Ra.sl[6]=279; /* line # 279 */
      if (((V *)Rv2)[33]!=NULL) PAS__DISPOSE(((V *)Rv2)+33);
    }
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    Ra.sl[6]=285; /* line # 285 */
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+114;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=299; /* line # 299 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (16384&((UL *)Rv0)[62]) {
      Ra.sl[6]=305; /* line # 305 */
      if (32768&((UL *)Rv0)[62]) {
        ((V *)Rv0)[32]=NULL;
        ((V *)Rv0)[34]=NULL;
        ((V *)Rv0)[33]=NULL;
      }
      else {
        Ra.sl[6]=313; /* line # 313 */
        if (128&((UL *)Rv0)[62]) Rv1=2048;
        else Rv1=0;
        PAS__CLOSE(((V *)Rv0)+35,Rv1);
        if (8&((UL *)Rv0)[62]) PAS__CLOSE(((V *)Rv0)+34,0);
        if (((V *)Rv0)[33]!=NULL) {
          Ra.sl[6]=319; /* line # 319 */
          PAS__DISPOSE(((V *)Rv0)+33);
          ((V *)Rv0)[33]=NULL;
        }
      }
      if (((V *)Rv0)[1]!=NULL&&V_src_control==(*F_p)) {
        Ra.sl[6]=324; /* line # 324 */
        V_src_control=((V *)Rv0)[1];
      }
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~16384;
    }
    Ra.sl[6]=329; /* line # 329 */
    if (F_bfree) P_src_free(F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_file_open "  */
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+125;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=354; /* line # 354 */
  V_src_openerr=0;
  if (F_srcp==NULL) {
    Rv0=0;
    F_srcp=BASIC_SRC_src_allocate();
  }
  else {
    Ra.sl[6]=362; /* line # 362 */
    Rv0=1;
    P_src_close(&F_srcp,0);
  }
  BASIC_SRC_src_r_init(F_srcp,0);
  Ra.sl[6]=367; /* line # 367 */
  Rv1=F_srcp;
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[35],PAS__f_input);
    Ra.sl[6]=372; /* line # 372 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16;
    PAS__iostatus=0;
  }
  else PAS__OPEN(((V *)Rv1)+35,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  Ra.sl[6]=377; /* line # 377 */
  if (PAS__iostatus==0) {
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~8;
    if (PAS__TTY_FILE(((V *)Rv1)[35])) {
      Ra.sl[6]=383; /* line # 383 */
      if (((UB *)F_fspc)[1]==0) {
        _FILE_DUPLICATE(((V *)Rv1)[34],PAS__f_output);
        PAS__iostatus=0;
      }
      else {
        Ra.sl[6]=388; /* line # 388 */
        PAS__OPEN(((V *)Rv1)+34,0, F_fspc,4098,0,-1);
      }
      if (PAS__iostatus!=0) {
        V_src_openerr=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+35,0);
      }
      else {
        Ra.sl[6]=395; /* line # 395 */
        ((V *)Rv1)[33]=PAS__NEW(65);
        ((UB *)((V *)Rv1)[33])[0]=63;
        PAS__STR_TO_STR(((V *)Rv1)[33],V_def_prompt);
        ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16392;
      }
    }
    else {
      Ra.sl[6]=402; /* line # 402 */
      if (F_bdel) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|128;
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
    }
  }
  else V_src_openerr=PAS__iostatus;
  Ra.sl[6]=407; /* line # 407 */
  if (V_src_openerr!=0) {
    if (Rv0) BASIC_SRC_src_r_init(F_srcp,0);
    else P_src_free(&F_srcp);
  }
  Ret=F_srcp;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_active_source "  */
void P_src_active_source(V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+140;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=423; /* line # 423 */
  if (F_srcp!=NULL&&V_src_control!=NULL) {
    Rv0=V_src_control;
    Ra.sl[6]=430; /* line # 430 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|262144;
    Rv1=F_srcp;
    ((V *)Rv1)[1]=V_src_control;
    Ra.sl[6]=435; /* line # 435 */
    ((SL *)Rv1)[6]=((SL *)V_src_control)[6];
    ((SL *)Rv1)[7]=((SL *)V_src_control)[7];
    ((SL *)Rv1)[8]=((SL *)Rv1)[7];
    ((C *)Rv1)[52]=0;
    ((C *)Rv1)[53]=((C *)V_src_control)[52];
    Ra.sl[6]=440; /* line # 440 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|65536;
    V_src_control=F_srcp;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_macro_open "  */
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+159;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=469; /* line # 469 */
  if (F_srcp==NULL) {
    Rv0=0;
    F_srcp=BASIC_SRC_src_allocate();
  }
  else {
    Ra.sl[6]=476; /* line # 476 */
    Rv0=1;
    P_src_close(&F_srcp,0);
  }
  BASIC_SRC_src_r_init(F_srcp,1);
  Rv1=F_srcp;
  Ra.sl[6]=482; /* line # 482 */
  if (F_mtxt!=NULL) {
    ((V *)Rv1)[32]=F_mtxt;
    ((SL *)Rv1)[12]=((UB *)F_mtxt)[1];
    if (((SL *)Rv1)[12]>0) {
      Ra.sl[6]=488; /* line # 488 */
      ((C *)Rv1)[53]=0;
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~2048;
    }
  }
  ((V *)Rv1)[34]=F_uobj;
  Ra.sl[6]=493; /* line # 493 */
  if (F_ucbf!=NULL) ((V *)Rv1)[33]=F_ucbf;
  else((V *)Rv1)[33]=Ri.v[1];
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
  if (F_fact&&V_src_control!=NULL) P_src_active_source(F_srcp);
  Ra.sl[6]=499; /* line # 499 */
  Ret=F_srcp;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_return "  */
C P_src_return(UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  register V Rv3;
  register V Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+175;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=515; /* line # 515 */
  Rv0=V_src_control;
  if (Rv0!=NULL) Rv1=((V *)Rv0)[1];
  if (Rv0!=NULL&&Rv1!=NULL) {
    Ra.sl[6]=525; /* line # 525 */
    Rv2=1;
    Rv3=Rv0;
    if (32768&((UL *)Rv3)[62]) {
      Ra.sl[6]=530; /* line # 530 */
      if (((V *)Rv3)[33]!=NULL) {
        ((V *)Rv3)[32]=(*(Re0)((V *)Rv3)[33])(((V *)Rv3)[34]);
        Rv2=((V *)Rv3)[32]==NULL;
      }
      else {
        Ra.sl[6]=535; /* line # 535 */
        ((V *)Rv3)[32]=NULL;
      }
    }
    ((UL *)Rv3)[62]=((UL *)Rv3)[62]&~65536;
    if (Rv2) {
      Ra.sl[6]=540; /* line # 540 */
      Rv4=Rv1;
      ((C *)Rv4)[52]=((C *)Rv0)[52];
      V_src_control=Rv1;
      P_src_close(&Rv0, F_bfree);
      Ra.sl[6]=545; /* line # 545 */
      Ret=((C *)Rv4)[53];
    }
  }
  else Ret=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SRC_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+187;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=560; /* line # 560 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Rv1=V_lst_current;
  if (F_bterm) Rv2=80;
  else Rv2=((SL *)Rv1)[16];
  Ra.sl[6]=565; /* line # 565 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    if (Rv0>Rv2) {
      Ra.sl[6]=570; /* line # 570 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      if (!F_bterm) ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[6]=576; /* line # 576 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SRC_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+206;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=588; /* line # 588 */
  Rv0=V_src_control;
  if (V_src_lstinsnb!=((SL *)Rv0)[6]) {
    V_src_lstinsnb=((SL *)Rv0)[6];
    Ra.sl[6]=593; /* line # 593 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[6],5,0);
  }
  else {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[54]);
  PAS__WRITE_CHAR(((C *)Rv0)[55]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[6]=598; /* line # 598 */
  Rv1=((V *)Rv0)[32];
  Rv2=V_lst_current;
  if (F_bterm) Rv3=80;
  else Rv3=((SL *)Rv2)[16];
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[10],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[6]=603; /* line # 603 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Rv4=20;
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=608; /* line # 608 */
      Rv4=Rv4+1;
      if (Rv4>Rv3) {
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        if (!F_bterm) ((SL *)Rv2)[12]=((SL *)Rv2)[12]+1;
        Ra.sl[6]=613; /* line # 613 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=619; /* line # 619 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[32],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SRC_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+219;
  Ra.v[35]=Rd.s+13;
  Ra.sl[72]=638; /* line # 638 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.ub[1]=Ra.ub[0];
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[72]=644; /* line # 644 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[11]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Rv5=(((S *)Rv0)+Rv4*24+32);
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  if (((UB *)((V *)Rv0)[32])[1]>((SL *)Rv0)[12]) {
    Ra.sl[72]=651; /* line # 651 */
    Rv6=((SL *)Rv0)[12]+1;
    for( Rf0=(((UB *)((V *)Rv0)[32])[1]+1)-(((SL *)Rv0)[12]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.ub[1]=((UB *)((V *)Rv0)[32])[1];
  }
  else Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[9]*6+8];
  Ra.sl[72]=656; /* line # 656 */
  BASIC_SRC_src_out_text_line(F_f,Ra.s,F_bterm);
  if (F_bterm) {
    P_lst_newline();
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
  }
  Ra.sl[72]=662; /* line # 662 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+238,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[10],5,0);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+280,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+292,((V *)Rv0)[35]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SRC_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+298;
  Ra.v[35]=Rd.s+13;
  Ra.sl[72]=674; /* line # 674 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if ((1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7])&&!(64&((UB *)Rv1)[72])
  ) {
    Ra.sl[72]=679; /* line # 679 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
    BASIC_SRC_src_outerr_banner(((V *)Rv1)+10,0);
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[72]=684; /* line # 684 */
      P_lst_newline();
      ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      P_err_display(((V *)Rv1)+10,Rv2,(((S *)Rv0)+Rv2*24+32));
      Rv2++;
    }
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[10]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[72]=690; /* line # 690 */
  if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) {
    if (!F_bmac) BASIC_SRC_src_outline(&PAS__f_output,1);
    BASIC_SRC_src_outerr_banner(&PAS__f_output,1);
    Rv3=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[72]=695; /* line # 695 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*24+32));
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[72]=700; /* line # 700 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*3+6));
    Rv4++;
  }
  if (Rs.sl[0]>V_src_maxerror) {
    Rv5=V_lst_current;
    Rv6=V_src_control;
    Ra.sl[72]=705; /* line # 705 */
    PAS__VWRITE_INIT(Ra.s,1);
    PAS__WRITE_STR(Rd.s+313,-1,-1,32);
    PAS__WRITE_INT(V_src_maxerror,0,0);
    PAS__WRITE_STR(Rd.s+350,-1,-1,32);
    PAS__WRITE_STR(V_src_jobname.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+383,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv5)[10]);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    if (64&((UL *)Rv6)[62]||64&((UB *)Rv5)[72]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[72]=710; /* line # 710 */
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+395;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=719; /* line # 719 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (((SL *)Rv0)[9]>0) {
    if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) (*F_out_mac_line)(&PAS__f_output,1);
    BASIC_SRC_src_out_error(1);
    Ra.sl[6]=724; /* line # 724 */
    ((SL *)Rv0)[9]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+414;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=740; /* line # 740 */
  Rv0=V_src_control;
  if (((SL *)Rv0)[4]<((SL *)Rv0)[11]) ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  else {
    if (((SL *)Rv0)[4]>((SL *)Rv0)[12]) ((SL *)Rv0)[4]=((SL *)Rv0)[12];
  }
  Ra.sl[6]=746; /* line # 746 */
  if (((SL *)Rv0)[9]>=8) {
    ((SL *)Rv0)[9]=8;
    Rv1=0;
  }
  else {
    Ra.sl[6]=752; /* line # 752 */
    Rv1=1;
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      if (((SL *)Rv0)[4]==((SL *)Rv0)[Rv2*6+8]) Rv1=0;
      Rv2++;
    }
    if (Rv1) ((SL *)Rv0)[9]=((SL *)Rv0)[9]+1;
  }
  Ra.sl[6]=758; /* line # 758 */
  if (Rv1) {
    Rv3=(((S *)Rv0)+((SL *)Rv0)[9]*24+32);
    ((SL *)Rv3)[0]=((SL *)Rv0)[4];
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[6]=763; /* line # 763 */
    ((SL *)Rv3)[1]=F_number;
    ((UB *)Rv3)[8]=F_severity;
    memcpy(Rv3+9,Ra.s+28,4);
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[9]*24+32));
  }
  else {
    Ra.sl[6]=770; /* line # 770 */
    if (((UB *)Rv0)[((SL *)Rv0)[9]*24+40]<F_severity) ((UB *)Rv0)[((SL *)Rv0)[9]
    *24+40]=F_severity;
  }
  if (!(32768&((UL *)Rv0)[62]||PAS__TTY_FILE(((V *)Rv0)[35]))) {
    if (PAS__EOF(((V *)Rv0)[35])) BASIC_SRC_src_out_error(0);
  }
  Ra.sl[6]=775; /* line # 775 */
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  if (F_severity>1) Rs.sl[0]=Rs.sl[0]+1;
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+425;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=799; /* line # 799 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[6]=804; /* line # 804 */
  ((UB *)Rv0)[1]=0;
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    if (Rv2==9) while (1){
      Ra.sl[6]=810; /* line # 810 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      if (Rv2>=32) {
        Ra.sl[6]=815; /* line # 815 */
        if (((UB *)Rv0)[1]<255) {
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[6]=820; /* line # 820 */
          ((UL *)Rv1)[62]=((UL *)Rv1)[62]|256;
        }
      }
    }
  }
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|8192;
  else {
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  ((SL *)Rv1)[10]=((SL *)Rv1)[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+444;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=834; /* line # 834 */
  if (F_pstr!=NULL) {
    Rv0=V_src_control;
    if (8&((UL *)Rv0)[62]) {
      Ra.sl[6]=839; /* line # 839 */
      PAS__SELECT_OUT(((V *)Rv0)[34]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SRC_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+460;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=850; /* line # 850 */
  Rv0=V_src_control;
  ((SL *)Rv0)[5]=((SL *)Rv0)[11]-1;
  ((SL *)Rv0)[9]=0;
  Ra.sl[6]=855; /* line # 855 */
  if (32768&((UL *)Rv0)[62]) {
    P_vsr_nextstring();
    ((SL *)Rv0)[10]=((SL *)Rv0)[10]+1;
  }
  else {
    Ra.sl[6]=863; /* line # 863 */
    if (8&((UL *)Rv0)[62]) P_src_put_prompt(((V *)Rv0)[33]);
    P_src_get_inputline(((V *)Rv0)+35,((V *)Rv0)+32);
    if (32&((UL *)Rv0)[62]) {
      Ra.sl[6]=868; /* line # 868 */
      if (8&((UL *)Rv0)[62]) P_lst_put_string(((V *)Rv0)[33]);
      P_lst_put_string(((V *)Rv0)[32]);
      P_lst_eoln();
    }
  }
  Ra.sl[6]=873; /* line # 873 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+474;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=884; /* line # 884 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (256&((UL *)Rv0)[62]) {
    Ra.sl[6]=889; /* line # 889 */
    ((SL *)Rv0)[4]=((SL *)Rv0)[12]-1;
    P_src_error(Rd.s+493,1,2);
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~256;
  }
  if (1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7]) {
    if (!(64&((UB *)Rv1)[72])) {
      Ra.sl[6]=896; /* line # 896 */
      P_lst_newline();
      BASIC_SRC_src_outline(((V *)Rv1)+10,0);
    }
  }
  if (((SL *)Rv0)[9]>0) BASIC_SRC_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SRC_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+497;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=910; /* line # 910 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  while (!(8192&((UL *)Rv0)[62])&&2048&((UL *)Rv0)[62]){
    Ra.sl[6]=917; /* line # 917 */
    if (((SL *)Rv0)[10]>0&&!(1048576&((UL *)Rv0)[62])) P_src_end_of_line();
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~1050624;
    BASIC_SRC_src_get_line();
    Ra.sl[6]=923; /* line # 923 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|512;
    if (((C *)Rv0)[54]!=67) {
      Rs.c[4]=((C *)Rv0)[54];
      ((C *)Rv0)[54]=67;
    }
  }
  if (!(8192&((UL *)Rv0)[62])) {
    Ra.sl[6]=928; /* line # 928 */
    if (((SL *)Rv0)[5]>=((SL *)Rv0)[12]||((SL *)Rv0)[5]>=((UB *)Rv1)[1]) {
      if (1048576&((UL *)Rv0)[62]&&((SL *)Rv0)[10]>0) P_src_end_of_line();
      if ((525312&((UL *)Rv0)[62])!=0) {
        Ra.sl[6]=933; /* line # 933 */
        Rv2=1;
      }
      else Rv2=32;
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|2048;
    }
    else {
      Ra.sl[6]=938; /* line # 938 */
      ((SL *)Rv0)[5]=((SL *)Rv0)[5]+1;
      Rv2=((C *)Rv1)[((SL *)Rv0)[5]+1];
    }
  }
  else {
    Ra.sl[6]=946; /* line # 946 */
    if (65536&((UL *)Rv0)[62]&&((V *)Rv0)[1]!=NULL) Rv2=P_src_return(!(131072&((
    UL *)Rv0)[62]));
    else {
      Ra.sl[6]=958; /* line # 958 */
      Rv2=4;
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|4096;
    }
  }
  Ra.sl[6]=963; /* line # 963 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SRC_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+511;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=975; /* line # 975 */
  Rv0=0;
  Rv1=V_src_control;
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|1024;
  Ra.sl[6]=980; /* line # 980 */
  Rv2=((UB *)Rv1)[252];
  ((UB *)Rv1)[252]=4;
  while (1){
    while (1){
      Rv3=BASIC_SRC_src_get_char();
      if ((Rv3==4||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    Ra.sl[6]=986; /* line # 986 */
    switch (Rv2) {
      case 0:Rv0=F_stp==125&&Rv3==F_stp||Rv3==4;
      if (F_stp==42&&Rv3!=4) {
        Ra.sl[6]=992; /* line # 992 */
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) {
          Rv0=((C *)((V *)Rv1)[32])[(((SL *)Rv1)[5]+1)+1]==41;
          if (Rv0) Rv3=BASIC_SRC_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[6]=1001; /* line # 1001 */
      if (Rv3!=4) {
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) Rv3=BASIC_SRC_src_get_char();
        Rv0=Rv3==47;
      }
      else Rv0=1;
      break;
      case 2:
      case 3:
      case 4:Ra.sl[6]=1010; /* line # 1010 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[6]=1015; /* line # 1015 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~1024;
  ((UB *)Rv1)[252]=Rv2;
  if (Rv3!=4) {
    if (Rv3==1&&!(524288&((UL *)Rv1)[62])||Rv3>1) {
      Ra.sl[6]=1020; /* line # 1020 */
      Rv3=32;
    }
  }
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+525;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1036; /* line # 1036 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Rv2=BASIC_SRC_src_get_char();
  switch (((UB *)Rv0)[252]) {
    case 0:Ra.sl[6]=1042; /* line # 1042 */
    if (Rv2==123) Rv2=BASIC_SRC_skip_comment(125,0);
    else {
      if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
          Rv2=BASIC_SRC_src_get_char();
          Ra.sl[6]=1047; /* line # 1047 */
          Rv2=BASIC_SRC_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=1052; /* line # 1052 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
        Rv2=BASIC_SRC_src_get_char();
        Rv2=BASIC_SRC_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[6]=1059; /* line # 1059 */
    if (Rv2==59) Rv2=BASIC_SRC_skip_comment(59,1);
    break;
    case 2:if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==45) {
        Ra.sl[6]=1064; /* line # 1064 */
        Rv2=BASIC_SRC_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[6]=1069; /* line # 1069 */
    break;
  }
  if (512&((UL *)Rv0)[62]) {
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[6]=1074; /* line # 1074 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~512;
      if (((C *)Rv0)[54]==67) ((C *)Rv0)[54]=Rs.c[4];
    }
  }
  ((C *)Rv0)[52]=((C *)Rv0)[53];
  Ra.sl[6]=1079; /* line # 1079 */
  ((C *)Rv0)[53]=Rv2;
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+537;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1094; /* line # 1094 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  if (((SL *)Rv0)[5]>=((UB *)Rv1)[1]||((SL *)Rv0)[5]>=((SL *)Rv0)[12]) Ret=32;
  else Ret=((C *)Rv1)[(((SL *)Rv0)[5]+1)+1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+552;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1113; /* line # 1113 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Rv2=((SL *)Rv0)[5];
  Rv3=1;
  while (Rv3){
    Ra.sl[6]=1118; /* line # 1118 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[12]) {
      Rv4=((C *)Rv1)[Rv2+1];
      if (Rv4==32) Rv2=Rv2+1;
      else Rv3=0;
    }
    else {
      Ra.sl[6]=1126; /* line # 1126 */
      Rv3=0;
      Rv4=32;
    }
  }
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_set_flags "  */
void P_src_set_flags(UL F_flg, UB F_fclr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+569;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1143; /* line # 1143 */
  Rv0=V_src_control;
  if (F_fclr) ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~F_flg;
  else((UL *)Rv0)[62]=((UL *)Rv0)[62]|F_flg;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+584;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1164; /* line # 1164 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Rv0=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv0]=0;
    Rv0++;
  }
  V_error_result=0;
  Ra.sl[6]=1169; /* line # 1169 */
  V_src_control=NULL;
  if (((UB *)F_def_src)[1]>0) V_src_control=P_src_file_open(F_def_src,0,NULL);
  if (V_src_openerr==0) {
    Rv1=V_src_control;
    Ra.sl[6]=1175; /* line # 1175 */
    ((SL *)Rv1)[7]=1;
    ((SL *)Rv1)[8]=1;
  }
  else V_src_control=NULL;
  V_src_hde=V_src_control;
  Ra.sl[6]=1180; /* line # 1180 */
  V_src_cont_base=V_src_control;
  V_src_maxerror=31;
  PAS__curr_cntx=Ra.v[0];
}
