/*  P A S - P. WOLFERS SOFTWARE: V3.1-A4 OF 15-DEC-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 88 ) = {
  8,   8, 100,  97, 116, 101,  95, 115, 116, 114,  64,  64,  47, 104, 111, 109,
101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112,
115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95,
115, 114,  99,  95,  86,  51,  46,  49,  65,  52,  99,  47,  99, 112,  97, 115,
 95,  95, 116, 105, 109, 115, 116, 114,  46, 112,  97, 115,   8,   8, 116, 105,
109, 101,  95, 115, 116, 114,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 40 ) = {
 74,  65,  78,  70,  69,  66,  77,  65,  82,  65,  80,  82,  77,  65,  89,  74,
 85,  78,  74,  85,  76,  65,  85,  71,  83,  69,  80,  79,  67,  84,  78,  79,
 86,  68,  69,  67,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(PAS__curtim, 40 );


/* Function/procedure prototypes. */
void PAS__N_TIME(V F_tmtb, SL F_ss, UB F_gmt);


/* Procedure/Function : " date_str "  */
void PAS__DATE_STR(V F_t){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+10;
  Ra.sl[6]=72; /* line # 72 */
  PAS__N_TIME(PAS__curtim.s,9,0);
  Rv0=PAS__curtim.sl[3];
  Rv1=PAS__curtim.sl[4];
  Rv2=PAS__curtim.sl[5];
  Rv3=F_t;
  Ra.sl[6]=77; /* line # 77 */
  if (((UB *)Rv3)[0]>=11) {
    ((C *)Rv3)[2]=(C)(Rv0/10+48);
    ((C *)Rv3)[3]=(C)(PAS__I_MOD(Rv0,10)+48);
    ((C *)Rv3)[4]=45;
    Ra.sl[6]=82; /* line # 82 */
    ((C *)Rv3)[5]=Ri.c[Rv1*3-3];
    ((C *)Rv3)[6]=Ri.c[Rv1*3-2];
    ((C *)Rv3)[7]=Ri.c[Rv1*3-1];
    ((C *)Rv3)[8]=45;
    ((C *)Rv3)[9]=(C)(Rv2/1000+48);
    Rv2=PAS__I_MOD(Rv2,1000);
    Ra.sl[6]=87; /* line # 87 */
    ((C *)Rv3)[10]=(C)(Rv2/100+48);
    Rv2=PAS__I_MOD(Rv2,100);
    ((C *)Rv3)[11]=(C)(Rv2/10+48);
    ((C *)Rv3)[12]=(C)(PAS__I_MOD(Rv2,10)+48);
    ((UB *)Rv3)[1]=11;
  }
  else {
    Ra.sl[6]=92; /* line # 92 */
    ((UB *)Rv3)[1]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " time_str "  */
void PAS__TIME_STR(V F_t){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+10;
  Ra.sl[6]=102; /* line # 102 */
  PAS__N_TIME(PAS__curtim.s,9,0);
  Rv0=PAS__curtim.sl[0];
  Rv1=PAS__curtim.sl[1];
  Rv2=PAS__curtim.sl[2];
  Rv3=F_t;
  Ra.sl[6]=107; /* line # 107 */
  if (((UB *)Rv3)[0]>=8) {
    ((C *)Rv3)[2]=(C)(Rv2/10+48);
    ((C *)Rv3)[3]=(C)(PAS__I_MOD(Rv2,10)+48);
    ((C *)Rv3)[4]=58;
    Ra.sl[6]=112; /* line # 112 */
    ((C *)Rv3)[5]=(C)(Rv1/10+48);
    ((C *)Rv3)[6]=(C)(PAS__I_MOD(Rv1,10)+48);
    ((C *)Rv3)[7]=58;
    ((C *)Rv3)[8]=(C)(Rv0/10+48);
    ((C *)Rv3)[9]=(C)(PAS__I_MOD(Rv0,10)+48);
    Ra.sl[6]=117; /* line # 117 */
    ((UB *)Rv3)[1]=8;
  }
  else((UB *)Rv3)[1]=0;
  PAS__curr_cntx=Ra.v[0];
}
