/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 1096 ) = {
  5,   5, 101, 114, 114, 111, 114,  53,  53,  47, 104, 111, 109, 101,  47, 112,
105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47, 109, 120, 100,  95, 115, 114,  99,  47, 115,  97, 116,
101, 108, 108, 105, 116, 101,  95, 108, 105,  98,  46, 112,  97, 115,  22,  22,
 32,  42,  42,  42,  32,  71, 101, 110,  95,  83, 112,  97,  99, 101,  32,  69,
114, 114, 111, 114,  32,  40,   4,   4,  41,  32,  58,  32,   5,   5,  46,  32,
 42,  42,  42,   2,   2,  32,  34,   2,   2,  34,  46,   5,   5, 101, 114, 114,
111, 114,  22,  22,  32,  42,  42,  42,  32,  71, 101, 110,  95,  83, 112,  97,
 99, 101,  32,  69, 114, 114, 111, 114,  32,  40,   4,   4,  41,  32,  58,  32,
  5,   5,  46,  32,  42,  42,  42,   2,   2,  32,  34,   2,   2,  34,  46,   7,
  7, 119,  97, 114, 110, 105, 110, 103,  24,  24,  32,  42,  42,  42,  32,  71,
101, 110,  95,  83, 112,  97,  99, 101,  32,  87,  97, 114, 110, 105, 110, 103,
 32,  40,   4,   4,  41,  32,  58,  32,   5,   5,  46,  32,  42,  42,  42,   2,
  2,  32,  34,   2,   2,  34,  46,   7,   7, 119,  97, 114, 110, 105, 110, 103,
 24,  24,  32,  42,  42,  42,  32,  71, 101, 110,  95,  83, 112,  97,  99, 101,
 32,  87,  97, 114, 110, 105, 110, 103,  32,  40,   4,   4,  41,  32,  58,  32,
  5,   5,  46,  32,  42,  42,  42,   2,   2,  32,  34,   2,   2,  34,  46,   9,
  9, 105, 100, 101,  95, 109,  97, 116,  99, 104,  10,  10, 105, 100, 101,  95,
115, 101,  97, 114,  99, 104,  10,  10, 105, 100, 101,  95, 115, 101,  97, 114,
 99, 104,  10,  10, 105, 100, 101,  95, 115, 101,  97, 114,  99, 104,  17,  17,
105, 110, 112,  95, 103, 101, 116,  99, 104,  95, 105, 110,  95, 102, 105, 108,
101,   9,   9, 105, 110, 112,  95, 103, 101, 116,  99, 104,   8,   8, 105, 110,
115, 121, 109,  98, 111, 108,  31,  31,  32,  42,  42,  42,  32,  71, 101, 110,
 95,  83, 112,  97,  99, 101,  32,  58,  32,  73, 108, 108, 101, 103,  97, 108,
 32,  99, 104,  97, 114,  32,  58,  10,  10,  32, 105, 110,  32, 105, 110, 112,
117, 116,  46,  11,  11, 115, 107, 105, 112,  95, 115, 121, 109,  98, 111, 108,
 11,  11, 105, 110, 112,  95, 105, 110, 113, 117, 105, 114, 101,  11,  11, 105,
110, 112,  95, 114,  95, 118,  97, 108, 117, 101,   4,   4,  82,  86,  65,  76,
 18,  18,  73, 108, 108, 101, 103,  97, 108,  32, 115, 101, 112,  97, 114,  97,
116, 111, 114,  46,   4,   4,  82,  86,  65,  76,  44,  44,  73, 108, 108, 101,
103,  97, 108,  32, 102, 114,  97,  99, 116, 105, 111, 110,  32,  58,  32,  69,
120, 112, 101,  99, 116, 101, 100,  32, 102, 111, 114, 109,  32,  60, 105, 110,
116,  62,  47,  60, 105, 110, 116,  62,  11,  11, 105, 110, 112,  95, 105,  95,
118,  97, 108, 117, 101,   4,   4,  73,  86,  65,  76,  18,  18,  73, 108, 108,
101, 103,  97, 108,  32, 115, 101, 112,  97, 114,  97, 116, 111, 114,  46,   4,
  4,  73,  86,  65,  76,  36,  36,  82, 111, 117, 110, 100,  32, 111, 102,  32,
 70, 108, 111,  97, 116, 116, 105, 110, 103,  32,  86,  97, 108, 117, 101,  32,
116, 111,  32,  73, 110, 116, 101, 103, 101, 114,  46,   4,   4,  73,  86,  65,
 76,  52,  52,  70, 108, 111,  97, 116, 116, 105, 110, 103,  32,  77,  97, 103,
110, 105, 116, 117, 100, 101,  32, 116, 111,  32,  76,  97, 114, 103, 101,  32,
102, 111, 114,  32,  73, 110, 116, 101, 103, 101, 114,  32,  67, 111, 110, 118,
101, 114, 115, 105, 111, 110,  46,  11,  11, 105, 110, 112,  95, 115,  95, 118,
 97, 108, 117, 101,   4,   4,  83,  86,  65,  76,  18,  18,  73, 108, 108, 101,
103,  97, 108,  32, 115, 101, 112,  97, 114,  97, 116, 111, 114,  46,   9,   9,
105, 110, 112,  95, 115, 101, 112,  97, 114,  11,  11, 101, 120, 112,  95, 100,
111,  95, 111, 112, 101, 114,   4,   4,  69,  88,  80,  82,  32,  32,  73, 108,
108, 101, 103,  97, 108,  32, 109, 117, 108, 116, 105,  45, 115, 121, 109,  98,
111, 108,  32, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  46,  30,  30,
 73, 108, 108, 101, 103,  97, 108,  32,  68, 105, 118, 105, 115, 105, 111, 110,
 32,  98, 121,  32, 116, 104, 101,  32, 115, 121, 109,  98, 111, 108,  39,  39,
 73, 108, 108, 101, 103,  97, 108,  32,  68, 105, 118, 105, 100, 101,  32,  98,
121,  32,  97,  32, 110, 117, 109,  98, 101, 114,  32,  99, 108, 111, 115, 101,
 32, 111, 102,  32,  48,  46,  48,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  10,  10, 101, 120, 112,  95, 117, 110,  97, 111, 112,
101,  36,  36,  73, 108, 108, 101, 103,  97, 108,  32,  69, 120, 112, 114, 101,
115, 115, 105, 111, 110,  32, 111, 112, 101, 114,  97, 116, 111, 114,  32, 111,
114,  32, 116, 101, 114, 109,  46,  31,  31,  82, 105, 103, 104, 116,  32, 112,
 97, 114, 101, 110, 116, 104, 101, 115, 121, 115,  32, 119,  97, 115,  32, 101,
120, 112, 101,  99, 116, 101, 100,  46,  10,  10, 101, 120, 112,  95, 109, 117,
108, 100, 105, 118,  10,  10, 101, 120, 112,  95,  97, 100, 100, 115, 117,  98,
 14,  14, 105, 110, 112,  95, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,
 17,  17, 105, 110, 112,  95, 108, 111, 111, 107, 115, 101, 109, 105,  99, 111,
108, 111, 110,  11,  11,  99, 104,  97, 110, 103, 101,  95,  99,  97, 115, 101,
  9,   9, 111, 117, 116,  95, 118,  97, 108, 117, 101,   9,   9, 111, 117, 116,
 95, 118,  97, 108, 117, 101,   9,   9, 111, 117, 116,  95, 118,  97, 108, 117,
101,  12,  12, 102, 111, 114, 109,  97, 116,  95, 118,  97, 108, 117, 101,  16,
 16, 102, 111, 114, 109,  97, 116, 116, 101, 100,  95, 111, 117, 116, 112, 117,
116,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 128 ) = {
  0,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
  3,  14,   6,   7,   5,   5,  15,   6,   8,   9,  18,  16,  24,  17,  25,  19,
  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,  26,  27,  22,  21,  23,   3,
  5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
  5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,  10,  28,  11,  20,   5,
  3,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
  5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,  12,  14,  13,   3,   2
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern V PAS__f_input;

/* Declaration of global variables. */
Blk(V_inp_prompt, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_inp_prompt2, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_inp_string, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_inpf, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_outf, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
UB V_inp_string_flg = 0;
UB V_inp_file_req = 0;
UB V_inp_file_flg = 0;
UB V_out_file_flg = 0;
C V_inp_ch = 32;
UB V_inp_symb = 1;
Blk(V_inp_ident, 24 );
SL V_inp_code;
Blk(V_inp_str, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
F V_inp_real;
SL V_inp_string_idx;
SL V_inp_int;
V V_inp_csmbtb = NULL;
Blk(V_out_ellist, 1024 );
V V_out_frmstr = NULL;
SL V_out_list_sz = 0;
V V_inp_file = NULL;
V V_out_file = NULL;

/* Function/procedure prototypes. */
V SATELLITE_PRC_00000003(V Ret);


/* Procedure/Function : " error "  */
void GS_ERROR_IDE(V F_mdnam, V F_msg, V F_parm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=149; /* line # 149 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+62,-1,-1,32);
  PAS__WRITE_STR(F_mdnam,-1,-1,32);
  PAS__WRITE_STR(Rd.s+86,-1,-1,32);
  PAS__WRITE_STR(F_msg,-1,-1,32);
  if (F_parm==NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+92,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+99,-1,-1,32);
    PAS__WRITE_CHT(F_parm+5,16,((UB *)F_parm)[4],-1,32);
    PAS__WRITE_STR(Rd.s+103,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__EXIT(2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " error "  */
void GS_ERROR_STR(V F_mdnam, V F_msg, V F_parm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=161; /* line # 161 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+114,-1,-1,32);
  PAS__WRITE_STR(F_mdnam,-1,-1,32);
  PAS__WRITE_STR(Rd.s+138,-1,-1,32);
  PAS__WRITE_STR(F_msg,-1,-1,32);
  if (F_parm==NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+144,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+151,-1,-1,32);
    PAS__WRITE_STR(F_parm,-1,-1,32);
    PAS__WRITE_STR(Rd.s+155,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__EXIT(2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " warning "  */
void GS_WARNING_IDE(V F_mdnam, V F_msg, V F_parm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+159;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=173; /* line # 173 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+168,-1,-1,32);
  PAS__WRITE_STR(F_mdnam,-1,-1,32);
  PAS__WRITE_STR(Rd.s+194,-1,-1,32);
  PAS__WRITE_STR(F_msg,-1,-1,32);
  if (F_parm==NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+200,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+207,-1,-1,32);
    PAS__WRITE_CHT(F_parm+5,16,((UB *)F_parm)[4],-1,32);
    PAS__WRITE_STR(Rd.s+211,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " warning "  */
void GS_WARNING_STR(V F_mdnam, V F_msg, V F_parm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=184; /* line # 184 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+224,-1,-1,32);
  PAS__WRITE_STR(F_mdnam,-1,-1,32);
  PAS__WRITE_STR(Rd.s+250,-1,-1,32);
  PAS__WRITE_STR(F_msg,-1,-1,32);
  if (F_parm==NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+256,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+263,-1,-1,32);
    PAS__WRITE_STR(F_parm,-1,-1,32);
    PAS__WRITE_STR(Rd.s+267,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_match "  */
UB P_ide_match(V F_id1, V F_id2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+271;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=198; /* line # 198 */
  if (((UB *)F_id1)[4]==((UB *)F_id2)[4]) {
    Rv0=1;
    while (Rv0<=((UB *)F_id1)[4]&&((C *)F_id1)[Rv0+4]==((C *)F_id2)[Rv0+4])
    Rv0=Rv0+1;
    Ret=Rv0>((UB *)F_id1)[4];
  }
  else {
    Ra.sl[6]=204; /* line # 204 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_search "  */
SL GS_ISEARCH_STR(V F_idetab, SL F_sz, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+282;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=217; /* line # 217 */
  Rv0=((UB *)F_id)[1];
  if (Rv0>16) Rv0=16;
  while (((C *)F_id)[Rv0+1]<=32)
  Rv0=Rv0-1;
  if (Rv0>0) {
    Ra.sl[6]=222; /* line # 222 */
    Ra.ub[32]=Rv0;
    while (Rv0>0){
      Ra.c[Rv0+32]=((C *)F_id)[Rv0+1];
      Rv0=Rv0-1;
    }
    Rv0=1;
    while (Rv0<=F_sz&&!P_ide_match((((S *)F_idetab)+Rv0*24-24),Ra.s+28))
    Rv0=Rv0+1;
    if (Rv0>F_sz) Ret=0;
    else {
      Ra.sl[6]=227; /* line # 227 */
      Ret=((SL *)F_idetab)[Rv0*6-6];
    }
  }
  else Ret=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_search "  */
SL GS_ISEARCH_IDE1(V F_idetab, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+294;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=241; /* line # 241 */
  Rv0=1;
  while (Rv0<=((SL *)F_idetab)[0]&&!P_ide_match((((S *)F_idetab)+Rv0*24-20),F_ide))

  Rv0=Rv0+1;
  if (Rv0>((SL *)F_idetab)[0]) Ret=0;
  else Ret=((SL *)F_idetab)[Rv0*6-5];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_search "  */
SL GS_ISEARCH_IDE(V F_idetab, SL F_sz, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+306;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=257; /* line # 257 */
  Rv0=1;
  while (Rv0<=F_sz&&!P_ide_match((((S *)F_idetab)+Rv0*24-24),F_ide))
  Rv0=Rv0+1;
  if (Rv0>F_sz) Ret=0;
  else Ret=((SL *)F_idetab)[Rv0*6-6];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " inp_getch_in_file "  */
void SATELLITE_PRC_00000000(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+318;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=316; /* line # 316 */
  if (V_inp_string_flg) {
    if (V_inp_string_idx<=V_inp_string.ub[1]) {
      V_inp_ch=V_inp_string.c[V_inp_string_idx+1];
      V_inp_string_idx=V_inp_string_idx+1;
    }
    else {
      Ra.sl[6]=322; /* line # 322 */
      V_inp_ch=0;
    }
  }
  else {
    if (PAS__EOF((*F_f))) V_inp_ch=0;
    else {
      if (PAS__EOLN((*F_f))) {
        Ra.sl[6]=327; /* line # 327 */
        PAS__GET((*F_f));
        Rs.ub[0]=1;
        V_inp_ch=1;
      }
      else {
        V_inp_ch=((C *)((V *)(*F_f))[0])[0];
        PAS__GET((*F_f));
        if (V_inp_ch<=32) V_inp_ch=32;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_getch "  */
void SATELLITE_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+337;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=338; /* line # 338 */
  if (V_inp_file_flg) SATELLITE_PRC_00000000(&V_inp_file);
  else {
    if (PAS__UFB(PAS__f_input)) {
      Ra.sl[6]=343; /* line # 343 */
      if (V_inp_prompt2.ub[1]>0) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(V_inp_prompt2.s,-1,-1,32);
      }
      else {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(V_inp_prompt.s,-1,-1,32);
      }
    }
    SATELLITE_PRC_00000000(&PAS__f_input);
  }
  Rs.ub[0]=Ri.ub[V_inp_ch];
  Ra.sl[6]=348; /* line # 348 */
  if (V_inp_ch>=65&&V_inp_ch<=90) Rs.c[1]=(C)((SL)V_inp_ch+32);
  else Rs.c[1]=V_inp_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  G Rv2;
  G Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  G Rv7;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+348;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=358; /* line # 358 */
  Rv0=1;
  while (V_inp_ch==32)
  SATELLITE_PRC_00000001();
  while (1){
    Rv1=1;
    switch (Rs.ub[0]) {
      case 7:Ra.sl[6]=365; /* line # 365 */
      while (Rs.ub[0]!=0&&Rs.ub[0]!=1)
      SATELLITE_PRC_00000001();
      if (Rs.ub[0]!=0) while (1){
        SATELLITE_PRC_00000001();
        if (V_inp_ch!=32)  break;
      }
      Ra.sl[6]=370; /* line # 370 */
      Rv1=0;
      break;
      case 12:Ra.sl[6]=375; /* line # 375 */
      while (Rs.ub[0]!=0&&Rs.ub[0]!=13)
      SATELLITE_PRC_00000001();
      if (Rs.ub[0]!=0) while (1){
        SATELLITE_PRC_00000001();
        if (V_inp_ch!=32)  break;
      }
      Ra.sl[6]=380; /* line # 380 */
      Rv1=0;
      break;
      case 6:Ra.sl[6]=385; /* line # 385 */
      V_inp_str.ub[1]=0;
      Rs.c[2]=V_inp_ch;
      while (1){
        SATELLITE_PRC_00000001();
        if (Rs.ub[0]==0)  break;
        Ra.sl[6]=390; /* line # 390 */
        if (Rs.ub[0]==1) SATELLITE_PRC_00000001();
        if (V_inp_ch==Rs.c[2]) {
          SATELLITE_PRC_00000001();
          Ra.sl[6]=395; /* line # 395 */
          if (V_inp_ch!=Rs.c[2])  break;
        }
        if (V_inp_str.ub[1]<V_inp_str.ub[0]) V_inp_str.ub[1]=V_inp_str.ub[1]+1;
        Ra.sl[6]=400; /* line # 400 */
        V_inp_str.c[V_inp_str.ub[1]+1]=V_inp_ch;
      }
      V_inp_symb=3;
      Rv0=0;
      break;
      case 5:Ra.sl[6]=407; /* line # 407 */
      V_inp_ident.ub[4]=0;
      while (1){
        if (V_inp_ident.ub[4]<16) {
          Ra.sl[6]=412; /* line # 412 */
          V_inp_ident.ub[4]=V_inp_ident.ub[4]+1;
        }
        V_inp_ident.c[V_inp_ident.ub[4]+4]=Rs.c[1];
        SATELLITE_PRC_00000001();
        if (Rs.ub[0]!=5&&Rs.ub[0]!=4||V_inp_ident.ub[4]>=16)  break;
      }
      V_inp_symb=2;
      Ra.sl[6]=417; /* line # 417 */
      Rv0=0;
      if (V_inp_csmbtb!=NULL) V_inp_code=GS_ISEARCH_IDE(V_inp_csmbtb+4,((SL *)V_inp_csmbtb)
      [0],V_inp_ident.s);
      else V_inp_code=0;
      break;
      case 4:
      case 25:Ra.sl[6]=426; /* line # 426 */
      Rv2=0.000000000000000E-001;
      Rv3=1.000000000000000E+000;
      Rv4=0;
      V_inp_symb=4;
      while (Rs.ub[0]==4){
        Rv5=(SL)V_inp_ch-48;
        Ra.sl[6]=431; /* line # 431 */
        if (Rv5==0) Rv4=Rv4+1;
        else Rv4=0;
        Rv2=Rv2*1.000000000000000E+001+(double)Rv5;
        SATELLITE_PRC_00000001();
      }
      Ra.sl[6]=436; /* line # 436 */
      if (Rs.ub[0]==25) {
        Rv4=0;
        SATELLITE_PRC_00000001();
        V_inp_symb=5;
        Ra.sl[6]=441; /* line # 441 */
        while (Rs.ub[0]==4){
          Rv5=(SL)V_inp_ch-48;
          Rv3=Rv3*1.000000000000000E-001;
          Rv2=Rv2+(double)Rv5*Rv3;
          Ra.sl[6]=446; /* line # 446 */
          SATELLITE_PRC_00000001();
        }
      }
      if (Rs.c[1]==101) {
        Ra.sl[6]=451; /* line # 451 */
        SATELLITE_PRC_00000001();
        Rv6=0;
        Rv7=1.000000000000000E+001;
        if (V_inp_ch==43||V_inp_ch==45) {
          Ra.sl[6]=456; /* line # 456 */
          if (V_inp_ch==45) Rv7=1.000000000000000E-001;
          SATELLITE_PRC_00000001();
        }
        while (Rs.ub[0]==4){
          Ra.sl[6]=461; /* line # 461 */
          Rv5=(SL)V_inp_ch-48;
          Rv6=Rv6*10+Rv5;
          SATELLITE_PRC_00000001();
        }
        Rv3=1.000000000000000E+000;
        Ra.sl[6]=466; /* line # 466 */
        while (Rv6!=0)
        if (Rv6&1) {
          Rv6=Rv6-1;
          Rv3=Rv3*Rv7;
        }
        else {
          Rv6=Rv6/2;
          Rv7=Rv7*Rv7;
        }
        Ra.sl[6]=472; /* line # 472 */
        if (Rv4-Rv6<0) V_inp_symb=5;
        Rv2=Rv2*Rv3;
      }
      if (Rv2<=2.147483647000000E+009&&Rv2>=-2.147483648000000E+009) {
        Ra.sl[6]=477; /* line # 477 */
        Rv6=(Rv2>0.0?(SL)(Rv2+0.5):(SL)(Rv2-0.5));
      }
      else {
        Rv6=0;
        V_inp_symb=5;
      }
      V_inp_real=(float)Rv2;
      V_inp_int=Rv6;
      Rv0=0;
      break;
      case 14:Ra.sl[6]=483; /* line # 483 */
      V_inp_symb=17;
      break;
      case 15:V_inp_symb=18;
      break;
      case 16:V_inp_symb=6;
      break;
      case 17:V_inp_symb=7;
      break;
      case 18:Ra.sl[6]=488; /* line # 488 */
      SATELLITE_PRC_00000001();
      if (Rs.ub[0]==18) V_inp_symb=10;
      else {
        V_inp_symb=8;
        Rv0=0;
      }
      break;
      case 19:V_inp_symb=9;
      break;
      case 20:Ra.sl[6]=493; /* line # 493 */
      V_inp_symb=10;
      break;
      case 21:V_inp_symb=11;
      break;
      case 22:SATELLITE_PRC_00000001();
      if (Rs.ub[0]==23) V_inp_symb=12;
      else {
        Ra.sl[6]=498; /* line # 498 */
        if (Rs.ub[0]==21) V_inp_symb=14;
        else {
          V_inp_symb=13;
          Rv0=0;
        }
      }
      break;
      case 23:SATELLITE_PRC_00000001();
      Ra.sl[6]=503; /* line # 503 */
      if (Rs.ub[0]==21) V_inp_symb=15;
      else {
        V_inp_symb=16;
        Rv0=0;
      }
      break;
      case 10:V_inp_symb=21;
      break;
      case 11:V_inp_symb=22;
      break;
      case 8:Ra.sl[6]=508; /* line # 508 */
      V_inp_symb=19;
      break;
      case 9:V_inp_symb=20;
      break;
      case 24:V_inp_symb=23;
      break;
      case 26:V_inp_symb=24;
      break;
      case 27:Ra.sl[6]=513; /* line # 513 */
      V_inp_symb=25;
      break;
      case 28:V_inp_symb=26;
      break;
      case 1:V_inp_ch=32;
      Rs.c[1]=32;
      Rv0=0;
      Ra.sl[6]=518; /* line # 518 */
      V_inp_symb=1;
      break;
      case 0:if (PAS__TTY_CLREOF(PAS__f_input)&&PAS__UFB(PAS__f_input)) {
        Ra.sl[6]=524; /* line # 524 */
        V_inp_ch=1;
        Rs.ub[0]=1;
        Rs.c[1]=1;
        Rv0=0;
      }
      V_inp_symb=0;
      break;
      default:Ra.sl[6]=531; /* line # 531 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+358,-1,-1,32);
      PAS__WRITE_CHAR(V_inp_ch);
      PAS__WRITE_STR(Rd.s+391,-1,-1,32);
      PAS__WRITE_EOLN();
      SATELLITE_PRC_00000001();
      V_inp_symb=27;
      break;
    }
    if (Rv1)  break;
  }
  Ra.sl[6]=536; /* line # 536 */
  if (Rv0) SATELLITE_PRC_00000001();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_ts){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Rv0=27;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+403;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=546; /* line # 546 */
  while (V_inp_symb!=0&&V_inp_symb!=F_ts){
    switch (F_ts) {
      case 19:P_skip_symbol(20);
      break;
      case 21:P_skip_symbol(22);
      break;
      case 1:Ra.sl[6]=551; /* line # 551 */
      if (F_ts==25) goto L_l_0;
      break;
      case 25:if (F_ts==20||F_ts==22) goto L_l_0;
      break;
      default:break;
    }
    Rv0=F_ts;
    Ra.sl[6]=556; /* line # 556 */
    P_insymbol();
    if (Rv0==23&&V_inp_symb==1) P_insymbol();
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_inquire "  */
void P_inp_inquire(V F_name){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+416;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=566; /* line # 566 */
  while (V_inp_symb==1){
    PAS__STR_TO_STR(V_inp_prompt2.s,F_name);
    P_insymbol();
    V_inp_prompt2.ub[1]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_r_value "  */
void P_inp_r_value(V F_name, F *F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  SL Rv3;
  F Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+429;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=584; /* line # 584 */
  Rv0=0;
  Rv1=0;
  Rv2=1;
  P_inp_inquire(F_name);
  while (1){
    Ra.sl[6]=589; /* line # 589 */
    switch (V_inp_symb) {
      case 6:break;
      case 7:Rv1=!Rv1;
      break;
      case 4:Ra.sl[6]=595; /* line # 595 */
      Rv3=V_inp_int;
      P_insymbol();
      if (V_inp_symb==9) {
        P_insymbol();
        Ra.sl[6]=600; /* line # 600 */
        if (V_inp_symb!=4) GS_ERROR_STR(Rd.s+468,Rd.s+474,NULL);
        Rv4=(float)Rv3/(float)V_inp_int;
        Rv0=1;
      }
      else {
        Ra.sl[6]=607; /* line # 607 */
        Rv4=(float)Rv3;
        Rv0=1;
        Rv2=0;
      }
      if (Rv1) (*F_rv)= -Rv4;
      else (*F_rv)=Rv4;
      break;
      case 5:Ra.sl[6]=615; /* line # 615 */
      Rv0=1;
      if (Rv1) (*F_rv)= -V_inp_real;
      else (*F_rv)=V_inp_real;
      break;
      case 1:
      case 23:
      case 24:
      case 25:Ra.sl[6]=622; /* line # 622 */
      Rv2=0;
      Rv0=1;
      break;
      default:GS_ERROR_STR(Rd.s+442,Rd.s+448,NULL);
      break;
    }
    Ra.sl[6]=628; /* line # 628 */
    if (Rv2) P_insymbol();
    if (Rv0||V_inp_symb==0)  break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_i_value "  */
void P_inp_i_value(V F_name, SL *F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+520;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=641; /* line # 641 */
  Rv0=0;
  Rv1=0;
  Rv2=1;
  P_inp_inquire(F_name);
  while (1){
    Ra.sl[6]=646; /* line # 646 */
    switch (V_inp_symb) {
      case 6:break;
      case 7:Rv1=!Rv1;
      break;
      case 4:Ra.sl[6]=652; /* line # 652 */
      if (Rv1) (*F_iv)= -V_inp_int;
      else (*F_iv)=V_inp_int;
      Rv0=1;
      break;
      case 5:Ra.sl[6]=657; /* line # 657 */
      if (V_inp_real<=(F)2.147484E+09||V_inp_real>=(F)-2.147484E+09) {
        if (Rv1) (*F_iv)=(Rgf= -V_inp_real,Rgf>0.0?(SL)(Rgf+0.5):(SL)(Rgf-0.5));
        else (*F_iv)=(V_inp_real>0.0?(SL)(V_inp_real+0.5):(SL)(V_inp_real-0.5));
        Ra.sl[6]=662; /* line # 662 */
        GS_WARNING_STR(Rd.s+559,Rd.s+565,NULL);
        Rv0=1;
      }
      else GS_ERROR_STR(Rd.s+603,Rd.s+609,NULL);
      break;
      case 1:
      case 23:
      case 24:
      case 25:Ra.sl[6]=670; /* line # 670 */
      Rv2=0;
      Rv0=1;
      break;
      default:GS_ERROR_STR(Rd.s+533,Rd.s+539,NULL);
      break;
    }
    Ra.sl[6]=676; /* line # 676 */
    if (Rv2) P_insymbol();
    if (Rv0||V_inp_symb==0)  break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_s_value "  */
void P_inp_s_value(V F_name, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+663;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=688; /* line # 688 */
  Rv0=0;
  Rv1=1;
  P_inp_inquire(F_name);
  while (1){
    switch (V_inp_symb) {
      case 3:Ra.sl[6]=694; /* line # 694 */
      if (V_inp_str.ub[1]>((UB *)F_str)[0]) ((UB *)F_str)[1]=((UB *)F_str)[0];
      else((UB *)F_str)[1]=V_inp_str.ub[1];
      Rv2=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[6]=699; /* line # 699 */
        ((C *)F_str)[Rv2+1]=V_inp_str.c[Rv2+1];
        Rv2++;
      }
      Rv0=1;
      break;
      case 1:
      case 23:
      case 24:
      case 25:Ra.sl[6]=705; /* line # 705 */
      Rv1=0;
      Rv0=1;
      break;
      default:GS_ERROR_STR(Rd.s+676,Rd.s+682,NULL);
      break;
    }
    Ra.sl[6]=711; /* line # 711 */
    if (Rv1) P_insymbol();
    if (Rv0||V_inp_symb==0)  break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_separ "  */
UB P_inp_separ(UB F_sep){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+702;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=720; /* line # 720 */
  if (V_inp_symb==F_sep) {
    P_insymbol();
    Ret=1;
  }
  else Ret=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_do_oper "  */
void SATELLITE_PRC_00000002(UB F_op, V F_v1, V F_v2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+713;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=738; /* line # 738 */
  if (fabs(((F *)F_v2)[1])>(F)1.000000E-05) {
    if (fabs(((F *)F_v1)[1])>(F)1.000000E-05) {
      if (F_op!=6&&F_op!=7||!P_ide_match(F_v1+8,F_v2+8)) {
        Ra.sl[6]=743; /* line # 743 */
        GS_ERROR_IDE(Rd.s+726,Rd.s+732,F_v2+8);
      }
    }
    else memcpy(F_v1+8,F_v2+8,21);
  }
  Ra.sl[6]=748; /* line # 748 */
  switch (F_op) {
    case 6:((F *)F_v1)[0]=((F *)F_v1)[0]+((F *)F_v2)[0];
    ((F *)F_v1)[1]=((F *)F_v1)[1]+((F *)F_v2)[1];
    break;
    case 7:Ra.sl[6]=757; /* line # 757 */
    ((F *)F_v1)[0]=((F *)F_v1)[0]-((F *)F_v2)[0];
    ((F *)F_v1)[1]=((F *)F_v1)[1]-((F *)F_v2)[1];
    break;
    case 8:Ra.sl[6]=763; /* line # 763 */
    ((F *)F_v1)[0]=((F *)F_v1)[0]*((F *)F_v2)[0];
    ((F *)F_v1)[1]=((F *)F_v1)[1]*((F *)F_v2)[0];
    break;
    case 9:Ra.sl[6]=768; /* line # 768 */
    if (((F *)F_v2)[1]>(F)1.000000E-05) GS_ERROR_IDE(Rd.s+726,Rd.s+766,F_v2+8);
    else {
      if (fabs(((F *)F_v2)[0])<(F)1.000000E-05) GS_ERROR_STR(Rd.s+726,Rd.s+798,NULL);
      else {
        Ra.sl[6]=775; /* line # 775 */
        ((F *)F_v1)[0]=((F *)F_v1)[0]/((F *)F_v2)[0];
        ((F *)F_v1)[1]=((F *)F_v1)[1]/((F *)F_v2)[0];
      }
    }
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_unaope "  */
V SATELLITE_PRC_00000005(V Ret){
  /* Define the automatic variable space. */
  Blk( Ra, 96 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Rv0=0;
  memcpy(Ra.s,Rd.s+840,29);
  Ra.v[4]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+32;
  Ra.v[5]=Rd.s+869;
  Ra.v[6]=Rd.s+7;
  Ra.sl[14]=802; /* line # 802 */
  while (V_inp_symb==6||V_inp_symb==7){
    if (V_inp_symb==7) Rv0=!Rv0;
    P_insymbol();
  }
  Ra.sl[14]=807; /* line # 807 */
  switch (V_inp_symb) {
    case 4:
    case 5:Ra.f[0]=V_inp_real;
    P_insymbol();
    break;
    case 2:Ra.sl[14]=812; /* line # 812 */
    Ra.f[1]=(F)1.000000E+00;
    memcpy(Ra.s+8,V_inp_ident.s,21);
    P_insymbol();
    break;
    case 19:P_insymbol();
    memcpy(Ra.s,SATELLITE_PRC_00000003(Ra.s+60),29);
    Ra.sl[14]=817; /* line # 817 */
    if (V_inp_symb==20) P_insymbol();
    else GS_ERROR_STR(Rd.s+726,Rd.s+919,NULL);
    break;
    default:Ra.sl[14]=822; /* line # 822 */
    GS_ERROR_STR(Rd.s+726,Rd.s+881,NULL);
    break;
  }
  if (Rv0) {
    Ra.f[0]= -Ra.f[0];
    Ra.sl[14]=827; /* line # 827 */
    Ra.f[1]= -Ra.f[1];
  }
  memcpy(Ret,Ra.s,29);
  PAS__curr_cntx=Ra.v[4];
  return(Ret);
}


/* Procedure/Function : " exp_muldiv "  */
V SATELLITE_PRC_00000004(V Ret){
  /* Define the automatic variable space. */
  Blk( Ra, 128 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+952;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=833; /* line # 833 */
  memcpy(Ra.s+28,SATELLITE_PRC_00000005(Ra.s+60),29);
  while (V_inp_symb==8||V_inp_symb==9){
    Rv0=V_inp_symb;
    P_insymbol();
    memcpy(Ra.s+92,SATELLITE_PRC_00000005(Ra.s+60),29);
    Ra.sl[6]=838; /* line # 838 */
    SATELLITE_PRC_00000002(Rv0, Ra.s+28,Ra.s+92);
  }
  memcpy(Ret,Ra.s+28,29);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_addsub "  */
V SATELLITE_PRC_00000003(V Ret){
  /* Define the automatic variable space. */
  Blk( Ra, 128 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+964;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=844; /* line # 844 */
  memcpy(Ra.s+28,SATELLITE_PRC_00000004(Ra.s+60),29);
  while (V_inp_symb==6||V_inp_symb==7){
    Rv0=V_inp_symb;
    P_insymbol();
    memcpy(Ra.s+92,SATELLITE_PRC_00000004(Ra.s+60),29);
    Ra.sl[6]=849; /* line # 849 */
    SATELLITE_PRC_00000002(Rv0, Ra.s+28,Ra.s+92);
  }
  memcpy(Ret,Ra.s+28,29);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " inp_expression "  */
void P_inp_expression(F *F_fac, F *F_cte, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 320 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+976;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=855; /* line # 855 */
  memcpy(Ra.s+28,SATELLITE_PRC_00000003(Ra.s+60),29);
  (*F_fac)=Ra.f[8];
  (*F_cte)=Ra.f[7];
  Ra.sl[6]=860; /* line # 860 */
  PAS__STR_TO_STR(F_str,PAS__SUBSTR_CHT(Ra.s+60,Ra.s+41,16,1, Ra.ub[40]));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inp_looksemicolon "  */
UB P_inp_looksemicolon(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+992;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=869; /* line # 869 */
  Ret=V_inp_symb==25||V_inp_symb==1;
  if (V_inp_symb==25) P_insymbol();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " change_case "  */
void P_change_case(V F_s, UB F_bmaj, SL F_ibg, SL F_ind){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  C Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1011;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=885; /* line # 885 */
  if (F_ind<=0||F_ind>((UB *)F_s)[1]) F_ind=((UB *)F_s)[1];
  if (F_ibg<=0) F_ibg=1;
  Rv0=F_ibg;
  for( Rf0=(F_ind+1)-F_ibg;Rf0>0;Rf0-- ) {
    Rv1=((C *)F_s)[Rv0+1];
    Ra.sl[6]=890; /* line # 890 */
    if (F_bmaj) {
      if (Rv1>=97&&Rv1<=122) ((C *)F_s)[Rv0+1]=(C)((SL)Rv1-32);
    }
    else {
      Ra.sl[6]=895; /* line # 895 */
      if (Rv1>=65&&Rv1<=90) ((C *)F_s)[Rv0+1]=(C)((SL)Rv1+32);
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_value "  */
void OUT_VALUE_IV(SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1024;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=909; /* line # 909 */
  if (V_out_list_sz<64) V_out_list_sz=V_out_list_sz+1;
  Rv0=(V_out_ellist.s+V_out_list_sz*16-16);
  ((UB *)Rv0)[0]=0;
  ((SL *)Rv0)[1]=F_iv;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_value "  */
void OUT_VALUE_RV(F F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1035;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=921; /* line # 921 */
  if (V_out_list_sz<64) V_out_list_sz=V_out_list_sz+1;
  Rv0=(V_out_ellist.s+V_out_list_sz*16-16);
  ((UB *)Rv0)[0]=1;
  ((F *)Rv0)[1]=F_rv;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_value "  */
void OUT_VALUE_SV(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1046;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=933; /* line # 933 */
  if (V_out_list_sz<64) V_out_list_sz=V_out_list_sz+1;
  Rv0=(V_out_ellist.s+V_out_list_sz*16-16);
  ((UB *)Rv0)[0]=2;
  ((V *)Rv0)[1]=F_str;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " format_value "  */
void P_format_value(V F_frm, SL *F_ii, SL *F_iv, SL *F_jv, C *F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1057;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=948; /* line # 948 */
  (*F_iv)=0;
  (*F_jv)=0;
  Rv0=0;
  (*F_ch)=((C *)F_frm)[(*F_ii)+1];
  (*F_ii)=(*F_ii)+1;
  while ((*F_ch)==45&&(*F_ii)<((UB *)F_frm)[1]){
    (*F_ch)=((C *)F_frm)[(*F_ii)+1];
    (*F_ii)=(*F_ii)+1;
    Rv0=!Rv0;
  }
  Ra.sl[6]=954; /* line # 954 */
  while (((*F_ch)>=48&&(*F_ch)<=57)&&(*F_ii)<=((UB *)F_frm)[1]){
    (*F_iv)=((*F_iv)*10+(SL)(*F_ch))-48;
    (*F_ch)=((C *)F_frm)[(*F_ii)+1];
    (*F_ii)=(*F_ii)+1;
  }
  Ra.sl[6]=959; /* line # 959 */
  if (Rv0) (*F_iv)= -(*F_iv);
  if ((*F_ch)==46) {
    (*F_ch)=((C *)F_frm)[(*F_ii)+1];
    (*F_ii)=(*F_ii)+1;
    Rv0=0;
    Ra.sl[6]=964; /* line # 964 */
    while ((*F_ch)==45&&(*F_ii)<=((UB *)F_frm)[1]){
      (*F_ch)=((C *)F_frm)[(*F_ii)+1];
      (*F_ii)=(*F_ii)+1;
      Rv0=!Rv0;
    }
    while (((*F_ch)>=48&&(*F_ch)<=57)&&(*F_ii)<=((UB *)F_frm)[1]){
      Ra.sl[6]=970; /* line # 970 */
      (*F_jv)=((*F_jv)*10+(SL)(*F_ch))-48;
      (*F_ch)=((C *)F_frm)[(*F_ii)+1];
      (*F_ii)=(*F_ii)+1;
    }
    if (Rv0) (*F_jv)= -(*F_jv);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " formatted_output "  */
void P_formatted_output(V *F_f, V F_frm, SL F_nb0, SL F_nb1, SL F_nb2, SL F_nb3, 
UB F_oflg){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  C Rv5;
  SL Rv6;
  SL Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1071;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=1019; /* line # 1019 */
  Rv0=1;
  Rv1=1;
  Rv2=0;
  Rv3=0;
  Rv4=0;
  while (1){
    Ra.sl[6]=1025; /* line # 1025 */
    Rv5=((C *)F_frm)[Rv0+1];
    Rv0=Rv0+1;
    if (Rv5==37&&Rv0<=((UB *)F_frm)[1]) {
      P_format_value(F_frm,&Rv0, &Rv6, &Rv7, &Rv5);
      if (Rv5>=65&&Rv5<=90) {
        Ra.sl[6]=1030; /* line # 1030 */
        Rv5=(C)((SL)Rv5+32);
      }
      switch (Rv5) {
        case 41:if (Rv3>0) {
          Ra.sl[6]=1035; /* line # 1035 */
          Ra.ub[Rv3*2+27]=Ra.ub[Rv3*2+27]-1;
          if (Ra.ub[Rv3*2+27]>0) Rv0=Ra.ub[Rv3*2+26];
          else Rv3=Rv3-1;
        }
        break;
        case 40:Ra.sl[6]=1042; /* line # 1042 */
        if (Rv3<4) Rv3=Rv3+1;
        Ra.ub[Rv3*2+26]=Rv0;
        Ra.ub[Rv3*2+27]=Rv6;
        break;
        case 37:Ra.sl[6]=1047; /* line # 1047 */
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_CHAR(37);
        break;
        case 108:while (1){
          PAS__SELECT_OUT((*F_f));
          PAS__WRITE_EOLN();
          Rv6=Rv6-1;
          if (Rv6<=0)  break;
        }
        break;
        case 120:Ra.sl[6]=1053; /* line # 1053 */
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32, Rv6,-1,1,32);
        break;
        case 35:if (F_oflg||Rv7<0) {
          Ra.sl[6]=1058; /* line # 1058 */
          Rv7=abs(Rv7);
          if (Rv7<2||Rv7>16) Rv7=10;
          switch (Rv4) {
            case 0:PAS__SELECT_OUT((*F_f));
            PAS__WRITE_INT(F_nb0, Rv6, Rv7);
            break;
            case 1:PAS__SELECT_OUT((*F_f));
            PAS__WRITE_INT(F_nb1, Rv6, Rv7);
            break;
            case 2:PAS__SELECT_OUT((*F_f));
            PAS__WRITE_INT(F_nb2, Rv6, Rv7);
            break;
            case 3:Ra.sl[6]=1063; /* line # 1063 */
            PAS__SELECT_OUT((*F_f));
            PAS__WRITE_INT(F_nb3, Rv6, Rv7);
            break;
          }
          Rv4=Rv4+1&3;
        }
        else {
          PAS__SELECT_OUT((*F_f));
          PAS__WRITE_FCHAR(32, Rv6,-1,1,32);
        }
        break;
        case 105:Ra.sl[6]=1071; /* line # 1071 */
        if (Rv2>=V_out_list_sz) goto L_l_0;
        Rv2=Rv2+1;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_INT(V_out_ellist.sl[Rv2*4-3],Rv6, Rv7);
        break;
        case 102:
        case 118:Ra.sl[6]=1078; /* line # 1078 */
        if (Rv2>=V_out_list_sz) goto L_l_0;
        Rv2=Rv2+1;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_SNGL(V_out_ellist.f[Rv2*4-3],Rv6, Rv7,0);
        break;
        case 115:
        case 116:Ra.sl[6]=1085; /* line # 1085 */
        if (Rv2>=V_out_list_sz) goto L_l_0;
        Rv2=Rv2+1;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_STR(V_out_ellist.v[Rv2*2-1],Rv6, Rv7,32);
        break;
        default:break;
      }
    }
    else {
      Ra.sl[6]=1093; /* line # 1093 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(Rv5);
    }
    if (Rv0>((UB *)F_frm)[1])  break;
  }
L_l_0: ;
  V_out_list_sz=0;
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}
