/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 696 ) = {
  5,   5, 105, 110, 105, 103, 101,  47,  47,  47, 104, 111, 109, 101,  47, 112,
105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47, 109, 120, 100,  95, 115, 114,  99,  47, 109, 120, 100,
 95, 108, 115, 108,  46, 112,  97, 115,  12,  12, 109, 120, 100, 105, 110, 116,
 46, 116, 109, 112,  46,  49,  56,  56,  32,  42,  42,  42,  32,  70,  65,  84,
 65,  76,  32,  69,  82,  82,  79,  82,  32,  61,  61,  32,  67,  97, 110, 110,
111, 116,  32, 111, 112, 101, 110,  32, 116, 104, 101,  32,  34, 109, 120, 100,
105, 110, 116,  46, 116, 109, 112,  46,  49,  34,  32, 102, 105, 108, 101,  46,
 10,  10, 110, 101, 119, 108, 105, 110, 101, 108, 115, 116,   9,   9,  32, 114,
117, 110,  32, 116, 104, 101,  32,   4,   4,  32,  97, 116,  32,   5,   5, 112,
 97, 103, 101,  32,   5,   5, 101, 114, 114, 111, 114,   6,   6,  70,  65,  84,
 65,  76,  32,   8,   8,  87,  65,  82,  78,  73,  78,  71,  47,   7,   7,  69,
 82,  82,  79,  82,  32,  35,  15,  15, 111, 112, 101, 110,  95, 115, 116,  95,
108, 105, 115, 116, 105, 110, 103,   9,   9, 117, 110, 100, 101, 114, 108, 105,
110, 101,   8,   8, 115, 107, 105, 112, 108, 105, 110, 101,  13,  13, 110, 101,
119, 112,  97, 114,  97, 103, 114,  97, 112, 104, 101,   8,   8, 119, 114, 105,
116, 101,  99, 112, 117,   4,   4,  32, 100,  97, 121,   2,   2,  44,  32,   5,
  5,  32, 104, 111, 117, 114,   7,   7,  32, 109, 105, 110, 117, 116, 101,   7,
  7,  32, 115, 101,  99, 111, 110, 100,  11,  11,  98, 117, 105, 108, 100, 115,
121, 109,  98, 111, 108,   6,   6, 105, 110, 105, 116,  97,  98,   4,   4,  46,
 85,  50,  51,   4,   4,  46,  85,  49,  51,   4,   4,  46,  85,  49,  50,   4,
  4,  46,  85,  51,  51,   4,   4,  46,  85,  50,  50,   4,   4,  46,  85,  49,
 49,   2,   2,  46,  90,   2,   2,  46,  89,   2,   2,  46,  88,   3,   3,  46,
 80,  80,   5,   5,  46,  73,  68,  73,  70,   5,   5,  46,  82,  68,  73,  70,
  4,   4,  46,  73,  77,  90,   4,   4,  46,  73,  77,  89,   4,   4,  46,  73,
 77,  88,   4,   4,  46,  82,  77,  90,   4,   4,  46,  82,  77,  89,   4,   4,
 46,  82,  77,  88,   4,   4,  46,  77,  68,  70,   4,   4,  46,  73,  85,  90,
  4,   4,  46,  73,  85,  89,   4,   4,  46,  73,  85,  88,   4,   4,  46,  82,
 85,  90,   4,   4,  46,  82,  85,  89,   4,   4,  46,  82,  85,  88,   4,   4,
 46,  80,  80,  72,   4,   4,  46,  80,  80,  77,   6,   6,  46,  83,  67,  65,
 76,  69,   5,   5,  46,  69,  70,  70,  77,   5,   5,  46,  69,  70,  70,  80,
  5,   5,  46,  90,  80,  79,  76,   5,   5,  46,  89,  80,  79,  76,   5,   5,
 46,  88,  80,  79,  76,   5,   5,  46,  67,  70,  78,  50,   5,   5,  46,  67,
 70,  77,  50,   5,   5,  36,  67,  65,  76,  67,   4,   4,  36,  70,  78,  50,
  4,   4,  36,  70,  77,  50,   6,   6,  36,  70,  50,  80,  79,  76,   4,   4,
 46,  68,  87,  67,   4,   4,  46,  68,  77,  80,   4,   4,  46,  77,  82,  81,
  5,   5,  46,  67,  80,  79,  76,   7,   7, 115,  99, 104, 105, 116, 101, 109,
  4,   4, 112, 117, 115, 104,   3,   3, 112, 111, 112,   6,   6, 114, 101,  97,
100, 105, 100,   7,   7, 114, 101,  97, 100, 115, 116, 114,   7,   7, 110, 101,
119, 105, 116, 101, 109,  12,  12, 103, 101, 116, 118, 105, 114, 116, 118,  97,
114,  98, 108,   6,   6, 112,  97, 114, 112, 111, 112,  10,  10,  98, 117, 105,
108, 100, 115, 116, 114, 117,  99,   9,   9,  98, 117, 105, 108, 100, 116, 114,
101, 101,   8,   8, 112, 104,  97, 115, 101,  97, 114, 103,   4,   4, 116,  97,
110, 104,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V V_lst;
extern SL V_pagenb;
extern SL V_linewrt;
extern V PAS__f_output;

/* Declaration of global variables. */
Blk(V_program_name, 8 );
SL V_elpstim;
SL V_topcpu;
V V_pageheadpt1;
V V_pageheadpt2;
V V_sbttlpt;
V V_sumhhde;
V V_gvarhde;
V V_varhde;
V V_contrhde;
V V_parhde;
V V_usfuncthde;
V V_formalhde;
V V_loopidxhde;
V V_atomhde;
V V_atmshde;
V V_wavhde;
V V_polhde;
V V_momhde;
V V_dsphde;
V V_freeblk;
V V_blkhde;
V V_symhde;
V V_datahde;
Blk(V_pardhde, 56 );
F V_hh;
F V_kk;
F V_ll;
F V_hc;
F V_kc;
F V_lc;
F V_hr;
F V_kr;
F V_lr;
F V_h1;
F V_k1;
F V_l1;
F V_h2;
F V_k2;
F V_l2;
F V_da;
F V_db;
F V_dc;
F V_dal;
F V_dbe;
F V_dga;
F V_ra;
F V_rb;
F V_rc;
F V_ral;
F V_rbe;
F V_rga;
F V_dvol;
F V_rvol;
Blk(V_tmd, 40 );
Blk(V_tmr, 40 );
SL V_refcatsv;
SL V_nbfixed;
SL V_latticenb;
SL V_nbcoll;
SL V_ncpobs;
UB V_bfmagnetic;
UB V_bflimited;
UB V_buiso;
UB V_bcentric;
V V_pttl;
V V_psav;
F V_rgf;
F V_igf;
F V_fnr;
F V_fni;
F V_fxr;
F V_fyr;
F V_fzr;
F V_fxi;
F V_fyi;
F V_fzi;
F V_rp1;
F V_ip1;
F V_fmxr;
F V_fmyr;
F V_fmzr;
F V_fmxi;
F V_fmyi;
F V_fmzi;
F V_fnucl2;
F V_fmag2;
F V_fcalc2s;
F V_fcalc2;
F V_fstr;
F V_delta;
F V_curint;
V V_cvariable;
V V_cformula;
V V_cparam;
V V_ccontr;
V V_catome;
V V_csymtry;
V V_cmoment;
V V_cmdsdsp;
V V_cwave;
V V_cnpola;
V V_cdata;
UL V_cselect;
SL V_iqwave;
SL V_mxcateg;
SL V_ccateg;
UB V_bstop;
UB V_b132;
UB V_bshortlst;
SL V_varnb;
Blk(V_magsel, 32 );
Blk(V_namtab, 344 );
Blk(V_virtvtab, 32 );
Blk(V_cdrec, 128 );
Blk(V_crrec, 32 );
V V_intf = NULL;
V V_idat = NULL;

/* Function/procedure prototypes. */
V P_st_create();
void P_st_free(V *F_p);
void P_st_put_pastr(V F_trg, V F_src);
void P_out_page(V *F_f);
void P_get_date(V F_st);
void P_get_time(V F_st);
void P_outerrmsgline(SL F_n);
void P_open_listing(V *F_f, V F_fname, SL F__Sz, SL F_mdflg);
void P_close_txtfile(V *F_f);
void P_open_input_txtfile(V *F_f, V F_fname, UB *F_bok, UB *F_bprt, SL *F_ierr);
SL P_cpu_clock();
void P_setoption(SL F_i, SL F_id);


/* Procedure/Function : " inige "  */
UB P_inige(V F_mxdnam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=381; /* line # 381 */
  V_topcpu=P_cpu_clock();
  V_pageheadpt1=P_st_create();
  V_pageheadpt2=P_st_create();
  P_st_put_pastr(V_pageheadpt2,Rd.s+56);
  Ra.sl[6]=386; /* line # 386 */
  P_open_input_txtfile(&V_intf, V_pageheadpt2, &Rv0, &Rv1, &Rv2);
  ((C *)V_pageheadpt2)[140]=0;
  if (Rv0) {
    Ra.sl[6]=391; /* line # 391 */
    P_open_listing(&V_lst, F_mxdnam+2,(SL)((UB *)F_mxdnam)[1],1);
    V_bstop=0;
    V_psav=NULL;
    V_pttl=NULL;
    V_sbttlpt=NULL;
    V_iqwave=-1;
    Ra.sl[6]=396; /* line # 396 */
    V_nbcoll=0;
    V_nbfixed=0;
    V_bflimited=0;
    V_bfmagnetic=0;
    Rv3=1;
    for( Rf0=4;Rf0>0;Rf0-- ) {
      V_virtvtab.v[Rv3-1]=NULL;
      Rv3++;
    }
    Ra.sl[6]=402; /* line # 402 */
    V_sumhhde=NULL;
    V_wavhde=NULL;
    V_polhde=NULL;
    V_contrhde=NULL;
    V_atomhde=NULL;
    V_momhde=NULL;
    V_dsphde=NULL;
    V_parhde=NULL;
    V_gvarhde=NULL;
    V_freeblk=NULL;
    V_usfuncthde=NULL;
    V_loopidxhde=NULL;
    V_formalhde=NULL;
    Ra.sl[6]=407; /* line # 407 */
    V_cselect=0;
    V_datahde=NULL;
    V_blkhde=NULL;
    V_symhde=NULL;
    Ra.sl[6]=412; /* line # 412 */
    V_pagenb=0;
    V_linewrt=56;
    V_buiso=1;
    V_latticenb=1;
    Ra.sl[6]=417; /* line # 417 */
    V_bcentric=0;
    V_bshortlst=1;
    V_b132=0;
    Rv4=0;
    for( Rf0=32;Rf0>0;Rf0-- ) {
      V_magsel.ub[Rv4]=1;
      Rv4++;
    }
    Ra.sl[6]=422; /* line # 422 */
    V_mxcateg=64;
    V_sbttlpt=PAS__NEW(141);
    ((C *)V_sbttlpt)[140]=0;
  }
  else {
    Ra.sl[6]=427; /* line # 427 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+70,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " newlinelst "  */
void P_newlinelst(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+128;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=441; /* line # 441 */
  V_linewrt=V_linewrt+1;
  if (V_linewrt>=55) {
    V_linewrt=0;
    P_out_page(&V_lst);
    Ra.sl[6]=446; /* line # 446 */
    V_pagenb=V_pagenb+1;
    P_get_date(Ra.s+28);
    P_get_time(Ra.s+39);
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_CHT(V_pageheadpt1+8,132,60,-1,32);
    if (!V_b132) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_EOLN();
      V_linewrt=1;
    }
    Ra.sl[6]=451; /* line # 451 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+140,-1,-1,32);
    PAS__WRITE_CHT(Ra.s+28,11,-1,-1,32);
    PAS__WRITE_STR(Rd.s+151,-1,-1,32);
    PAS__WRITE_CHT(Ra.s+39,11,-1,-1,32);
    PAS__WRITE_FCHAR(32,5,-1,1,32);
    Rv0=V_pageheadpt2;
    if ((SL)((C *)Rv0)[140]>0) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHT(Rv0+8,132,(SL)((C *)Rv0)[140],-1,32);
    }
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+157,-1,-1,32);
    PAS__WRITE_INT(V_pagenb,3,0);
    PAS__WRITE_EOLN();
    if (V_pttl!=NULL) {
      Ra.sl[6]=456; /* line # 456 */
      Rv1=V_pttl;
      if (((C *)Rv1)[140]!=0) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHT(Rv1+8,132,(SL)((C *)Rv1)[140],-1,32);
      }
    }
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    if (V_sbttlpt!=NULL) {
      Rv2=V_sbttlpt;
      if (((C *)Rv2)[140]!=0) {
        PAS__SELECT_OUT(V_lst);
        PAS__WRITE_CHT(Rv2+8,132,(SL)((C *)Rv2)[140],-1,32);
      }
    }
    Ra.sl[6]=461; /* line # 461 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " error "  */
void P_error(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+164;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=472; /* line # 472 */
  P_newlinelst();
  V_bstop=F_n<0;
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHT(V_program_name.s,6,-1,-1,32);
  PAS__WRITE_CHAR(32);
  if (F_n<0) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+171,-1,-1,32);
  }
  else {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+179,-1,-1,32);
  }
  Ra.sl[6]=477; /* line # 477 */
  F_n=abs(F_n);
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_STR(Rd.s+189,-1,-1,32);
  PAS__WRITE_INT(F_n,4,0);
  PAS__WRITE_EOLN();
  P_outerrmsgline(F_n);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " open_st_listing "  */
void P_open_st_listing(V *F_f, V F_ps, SL F_mdflg){
  /* Define the automatic variable space. */
  Blk( Ra, 168 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=132;
  Ra.v[17]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+136;
  Ra.v[18]=Rd.s+198;
  Ra.v[19]=Rd.s+7;
  Ra.sl[40]=490; /* line # 490 */
  Rv0=F_ps;
  Rv1=1;
  for( Rf0=(SL)((C *)Rv0)[140];Rf0>0;Rf0-- ) {
    Ra.c[Rv1+1]=((C *)Rv0)[Rv1+7];
    Rv1++;
  }
  Ra.ub[1]=(SL)((C *)Rv0)[140];
  Ra.sl[40]=495; /* line # 495 */
  P_open_listing(&V_lst, Ra.s+2,(SL)Ra.ub[1],F_mdflg);
  PAS__curr_cntx=Ra.v[17];
}


/* Procedure/Function : " underline "  */
void P_underline(SL F_i, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=503; /* line # 503 */
  P_newlinelst();
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_FCHAR(32, F_i+1,-1,1,32);
  while (F_n>0){
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(45);
    F_n=F_n-1;
  }
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skipline "  */
void P_skipline(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+226;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=517; /* line # 517 */
  if (F_n+V_linewrt>=55) V_linewrt=56;
  else while (F_n>0){
    Ra.sl[6]=523; /* line # 523 */
    P_newlinelst();
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_EOLN();
    F_n=F_n-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " newparagraphe "  */
void P_newparagraphe(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+236;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=535; /* line # 535 */
  if (V_linewrt+F_n>=52) V_linewrt=56;
  else {
    if (V_bshortlst) P_skipline(1);
    else P_skipline(3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " writecpu "  */
void P_writecpu(SL F_ti){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  F Rv4;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+251;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=554; /* line # 554 */
  Rv0=(Rgi=F_ti%1000,Rgi>=0?Rgi:Rgi+1000);
  F_ti=F_ti/1000;
  Rv1=(Rgi=F_ti%60,Rgi>=0?Rgi:Rgi+60);
  F_ti=F_ti/60;
  Rv2=(Rgi=F_ti%60,Rgi>=0?Rgi:Rgi+60);
  F_ti=F_ti/60;
  Rv3=(Rgi=F_ti%24,Rgi>=0?Rgi:Rgi+24);
  F_ti=F_ti/24;
  Rv4=(float)Rv1+(float)Rv0/(F)1.000000E+03;
  Ra.sl[6]=559; /* line # 559 */
  if (F_ti>0) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_INT(F_ti,2,0);
    PAS__WRITE_STR(Rd.s+261,-1,-1,32);
    if (F_ti>=2) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(115);
    }
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+267,-1,-1,32);
  }
  if (Rv3>0) {
    Ra.sl[6]=565; /* line # 565 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_INT(Rv3,2,0);
    PAS__WRITE_STR(Rd.s+271,-1,-1,32);
    if (Rv3>=2) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(115);
    }
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+267,-1,-1,32);
  }
  if (Rv2>0) {
    Ra.sl[6]=571; /* line # 571 */
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_INT(Rv2,2,0);
    PAS__WRITE_STR(Rd.s+278,-1,-1,32);
    if (Rv2>=2) {
      PAS__SELECT_OUT(V_lst);
      PAS__WRITE_CHAR(115);
    }
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_STR(Rd.s+267,-1,-1,32);
  }
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_SNGL(Rv4,7,3,0);
  PAS__WRITE_STR(Rd.s+287,-1,-1,32);
  Ra.sl[6]=576; /* line # 576 */
  if (Rv4>=(F)2.000000E+00) {
    PAS__SELECT_OUT(V_lst);
    PAS__WRITE_CHAR(115);
  }
  PAS__SELECT_OUT(V_lst);
  PAS__WRITE_CHAR(46);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " buildsymbol "  */
V P_buildsymbol(V F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+296;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=596; /* line # 596 */
  Rv0=PAS__NEW(17);
  Rv1=Rv0;
  Rv2=((UB *)F_symb)[1];
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv3]=((C *)F_symb)[Rv3+1];
    Rv3++;
  }
  Ra.sl[6]=601; /* line # 601 */
  ((C *)Rv1)[0]=(C)Rv2;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " initab "  */
void P_initab(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+309;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=611; /* line # 611 */
  V_namtab.v[0]=P_buildsymbol(Rd.s+317);
  V_namtab.v[1]=P_buildsymbol(Rd.s+323);
  V_namtab.v[2]=P_buildsymbol(Rd.s+329);
  V_namtab.v[3]=P_buildsymbol(Rd.s+335);
  V_namtab.v[4]=P_buildsymbol(Rd.s+341);
  V_namtab.v[5]=P_buildsymbol(Rd.s+347);
  V_namtab.v[6]=P_buildsymbol(Rd.s+353);
  V_namtab.v[7]=P_buildsymbol(Rd.s+357);
  V_namtab.v[8]=P_buildsymbol(Rd.s+361);
  V_namtab.v[9]=P_buildsymbol(Rd.s+365);
  Ra.sl[6]=616; /* line # 616 */
  V_namtab.v[10]=P_buildsymbol(Rd.s+370);
  V_namtab.v[11]=P_buildsymbol(Rd.s+377);
  V_namtab.v[12]=P_buildsymbol(Rd.s+384);
  V_namtab.v[13]=P_buildsymbol(Rd.s+390);
  V_namtab.v[14]=P_buildsymbol(Rd.s+396);
  V_namtab.v[15]=P_buildsymbol(Rd.s+402);
  V_namtab.v[16]=P_buildsymbol(Rd.s+408);
  V_namtab.v[17]=P_buildsymbol(Rd.s+414);
  V_namtab.v[18]=P_buildsymbol(Rd.s+420);
  V_namtab.v[19]=P_buildsymbol(Rd.s+426);
  Ra.sl[6]=621; /* line # 621 */
  V_namtab.v[20]=P_buildsymbol(Rd.s+432);
  V_namtab.v[21]=P_buildsymbol(Rd.s+438);
  V_namtab.v[22]=P_buildsymbol(Rd.s+444);
  V_namtab.v[23]=P_buildsymbol(Rd.s+450);
  V_namtab.v[24]=P_buildsymbol(Rd.s+456);
  V_namtab.v[25]=P_buildsymbol(Rd.s+462);
  V_namtab.v[26]=P_buildsymbol(Rd.s+468);
  V_namtab.v[27]=P_buildsymbol(Rd.s+474);
  V_namtab.v[28]=P_buildsymbol(Rd.s+482);
  V_namtab.v[29]=P_buildsymbol(Rd.s+489);
  Ra.sl[6]=626; /* line # 626 */
  V_namtab.v[30]=P_buildsymbol(Rd.s+496);
  V_namtab.v[31]=P_buildsymbol(Rd.s+503);
  V_namtab.v[32]=P_buildsymbol(Rd.s+510);
  V_namtab.v[33]=P_buildsymbol(Rd.s+517);
  V_namtab.v[34]=P_buildsymbol(Rd.s+524);
  V_namtab.v[35]=P_buildsymbol(Rd.s+531);
  V_namtab.v[36]=P_buildsymbol(Rd.s+538);
  V_namtab.v[37]=P_buildsymbol(Rd.s+544);
  V_namtab.v[38]=P_buildsymbol(Rd.s+550);
  V_namtab.v[39]=P_buildsymbol(Rd.s+558);
  Ra.sl[6]=631; /* line # 631 */
  V_namtab.v[40]=P_buildsymbol(Rd.s+564);
  V_namtab.v[41]=P_buildsymbol(Rd.s+570);
  V_namtab.v[42]=P_buildsymbol(Rd.s+576);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " schitem "  */
V P_schitem(V F_h, UB F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  UB Rv2;
  V Rv3;
  register F Rgf;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+583;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=649; /* line # 649 */
  if (!F_bl) {
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(&Rv0,0);
  }
  else {
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(&Rv1,0);
    Rv0=(Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5));
  }
  Rv2=0;
  Rv3=F_h;
  Ra.sl[6]=654; /* line # 654 */
  while (Rv3!=NULL&&!Rv2){
    Rv2=((SL *)Rv3)[6]==Rv0;
    if (!Rv2) Rv3=((V *)Rv3)[1];
  }
  Ra.sl[6]=659; /* line # 659 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " push "  */
void MXDLSRT_PRC_00000000(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+592;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=684; /* line # 684 */
  if (Lx[0].sl[0]>63) P_error(-1);
  else Lx[0].sl[0]=Lx[0].sl[0]+1;
  Lx[0].v[Lx[0].sl[0]+1]=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pop "  */
V MXDLSRT_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+598;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=693; /* line # 693 */
  Ret=Lx[0].v[Lx[0].sl[0]+1];
  if (Lx[0].sl[0]<0) P_error(-2);
  else Lx[0].sl[0]=Lx[0].sl[0] -1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " readid "  */
void MXDLSRT_PRC_00000002(V *F_pid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+603;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=705; /* line # 705 */
  (*F_pid)=PAS__NEW(17);
  Rv0=(*F_pid);
  PAS__SELECT_INP(V_intf);
  PAS__READ_CHAR(&Rv1);
  while (Rv1==32&&!PAS__EOF(V_intf)){
    PAS__SELECT_INP(V_intf);
    PAS__READ_CHAR(&Rv1);
  }
  Ra.sl[6]=710; /* line # 710 */
  Rv2=0;
  while ((!PAS__EOF(V_intf)&&!PAS__EOLN(V_intf))&&Rv1>32){
    if (Rv2<16) Rv2=Rv2+1;
    ((C *)Rv0)[Rv2]=Rv1;
    Ra.sl[6]=715; /* line # 715 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_CHAR(&Rv1);
  }
  ((C *)Rv0)[0]=(C)Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " readstr "  */
V MXDLSRT_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+611;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=730; /* line # 730 */
  Rv0=PAS__NEW(141);
  Rv1=Rv0;
  PAS__SELECT_INP(V_intf);
  PAS__READ_SL(&Rv2,0);
  PAS__READ_EOLN();
  if (Rv2>=132) Rv2=131;
  ((C *)Rv1)[140]=(C)Rv2;
  Ra.sl[6]=735; /* line # 735 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    PAS__SELECT_INP(V_intf);
    PAS__READ_CHAR((((C *)Rv1)+Rv3+7));
    Rv3++;
  }
  ((C *)Rv1)[(Rv2+1)+7]=0;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " newitem "  */
void MXDLSRT_PRC_00000004(V *F_h, V *F_p, UB F_itp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+620;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=752; /* line # 752 */
  switch (F_itp) {
    case 0:(*F_p)=PAS__NEW(64);
    break;
    case 1:(*F_p)=PAS__NEW(56);
    break;
    case 2:(*F_p)=PAS__NEW(72);
    break;
    case 5:(*F_p)=PAS__NEW(48);
    break;
    case 4:Ra.sl[6]=757; /* line # 757 */
    (*F_p)=PAS__NEW(48);
    break;
    case 3:(*F_p)=PAS__NEW(36);
    break;
    case 6:(*F_p)=PAS__NEW(154);
    break;
    case 7:(*F_p)=PAS__NEW(57);
    break;
    case 8:(*F_p)=PAS__NEW(80);
    break;
    case 9:Ra.sl[6]=762; /* line # 762 */
    (*F_p)=PAS__NEW(104);
    break;
    case 10:(*F_p)=PAS__NEW(112);
    break;
    case 12:(*F_p)=PAS__NEW(64);
    break;
    case 13:(*F_p)=PAS__NEW(88);
    break;
    case 11:(*F_p)=PAS__NEW(84);
    break;
  }
  Ra.sl[6]=768; /* line # 768 */
  if ((*F_h)==NULL) (*F_h)=(*F_p);
  else {
    Rv0=(*F_h);
    while (((V *)Rv0)[1]!=NULL)
    Rv0=((V *)Rv0)[1];
    ((V *)Rv0)[1]=(*F_p);
  }
  Ra.sl[6]=774; /* line # 774 */
  Rv1=(*F_p);
  switch (F_itp) {
    case 0:((UB *)Rv1)[0]=39;
    break;
    case 1:((UB *)Rv1)[0]=40;
    break;
    case 2:Ra.sl[6]=779; /* line # 779 */
    ((UB *)Rv1)[0]=41;
    break;
    case 3:((UB *)Rv1)[0]=23;
    break;
    case 4:((UB *)Rv1)[0]=25;
    break;
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:Ra.sl[6]=784; /* line # 784 */
    ((UB *)Rv1)[0]=42;
    break;
  }
  ((V *)Rv1)[1]=NULL;
  MXDLSRT_PRC_00000002(((V *)(*F_p))+2);
  Ra.sl[6]=789; /* line # 789 */
  PAS__SELECT_INP(V_intf);
  PAS__READ_SL(((SL *)(*F_p))+6,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " getvirtvarbl "  */
V MXDLSRT_PRC_00000005(SL F_sqnb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+629;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=800; /* line # 800 */
  if (V_virtvtab.v[F_sqnb-1]==NULL) {
    Rv0=PAS__NEW(56);
    Rv1=Rv0;
    Ra.sl[6]=805; /* line # 805 */
    ((UB *)Rv1)[0]=40;
    ((V *)Rv1)[1]=NULL;
    ((V *)Rv1)[2]=V_namtab.v[(F_sqnb+34)];
    ((SL *)Rv1)[6]= -F_sqnb;
    ((SL *)Rv1)[9]= -F_sqnb;
    Ra.sl[6]=810; /* line # 810 */
    ((F *)Rv1)[12]=(F)0.000000E-01;
    ((F *)Rv1)[13]=(F)0.000000E-01;
    ((V *)Rv1)[5]=NULL;
    V_virtvtab.v[F_sqnb-1]=Rv0;
  }
  Ra.sl[6]=815; /* line # 815 */
  Ret=V_virtvtab.v[F_sqnb-1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " parpop "  */
V MXDLSRT_PRC_00000006(SL F_idv, V F_ph){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+643;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=827; /* line # 827 */
  Rv0=MXDLSRT_PRC_00000001();
  if (Rv0==NULL) Ret=NULL;
  else {
    if (((UB *)Rv0)[0]==39) Ret=Rv0;
    else {
      Ra.sl[6]=832; /* line # 832 */
      Rv1=PAS__NEW(64);
      if (V_parhde==NULL) V_parhde=Rv1;
      else {
        Rv2=V_parhde;
        while (((V *)Rv2)[1]!=NULL)
        Rv2=((V *)Rv2)[1];
        Ra.sl[6]=837; /* line # 837 */
        ((V *)Rv2)[1]=Rv1;
      }
      Rv3=Rv1;
      ((UB *)Rv3)[0]=39;
      Ra.sl[6]=842; /* line # 842 */
      ((V *)Rv3)[1]=NULL;
      ((V *)Rv3)[2]=V_namtab.v[F_idv];
      ((V *)Rv3)[3]=F_ph;
      ((V *)Rv3)[5]=NULL;
      ((V *)Rv3)[4]=Rv0;
      ((F *)Rv3)[12]=(F)0.000000E-01;
      Ra.sl[6]=848; /* line # 848 */
      Ret=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " buildstruc "  */
void MXDLSRT_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  SL Rv16;
  SL Rv17;
  V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  register V Rv25;
  SL Rv26;
  register V Rv27;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+651;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=864; /* line # 864 */
  switch (Lx[0].sl[130]) {
    case 64:PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(&V_da,0);
    PAS__READ_SNGL(&V_db,0);
    PAS__READ_SNGL(&V_dc,0);
    PAS__READ_SNGL(&V_dal,0);
    PAS__READ_SNGL(&V_dbe,0);
    PAS__READ_SNGL(&V_dga,0);
    PAS__READ_EOLN();
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(&V_ra,0);
    PAS__READ_SNGL(&V_rb,0);
    PAS__READ_SNGL(&V_rc,0);
    PAS__READ_SNGL(&V_ral,0);
    PAS__READ_SNGL(&V_rbe,0);
    PAS__READ_SNGL(&V_rga,0);
    PAS__READ_EOLN();
    Ra.sl[6]=869; /* line # 869 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(&V_dvol,0);
    PAS__READ_SNGL(&V_rvol,0);
    Rv0=1;
    for( Rf1=3;Rf1>0;Rf1-- ) {
      Rv1=1;
      for( Rf0=3;Rf0>0;Rf0-- ) {
        PAS__SELECT_INP(V_intf);
        PAS__READ_EOLN();
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL((V_tmd.f+Rv0*3+Rv1-4),0);
        PAS__READ_SNGL((V_tmr.f+Rv0*3+Rv1-4),0);
        Rv1++;
      }
      Rv0++;
    }
    break;
    case 65:
    case 66:Ra.sl[6]=879; /* line # 879 */
    MXDLSRT_PRC_00000004(&V_atomhde, Lx[0].v+66,6);
    Rv2=Lx[0].v[66];
    ((UB *)Rv2)[152]=Lx[0].sl[130]==65;
    ((V *)Rv2)[6]=NULL;
    Rv3=0;
    for( Rf1=12;Rf1>0;Rf1-- ) {
      ((V *)Rv2)[(12-Rv3)+6]=MXDLSRT_PRC_00000006(Rv3, Lx[0].v[66]);
      Rv3++;
    }
    Ra.sl[6]=884; /* line # 884 */
    ((V *)Rv2)[4]=NULL;
    ((V *)Rv2)[5]=NULL;
    ((UB *)Rv2)[153]=((V *)Rv2)[14]!=NULL&&((V *)Rv2)[15]!=NULL;
    break;
    case 67:Ra.sl[6]=891; /* line # 891 */
    MXDLSRT_PRC_00000004(&V_momhde, Lx[0].v+66,9);
    Rv4=Lx[0].v[66];
    Rv5=P_schitem(V_atomhde,0);
    ((V *)Rv4)[5]=NULL;
    Ra.sl[6]=896; /* line # 896 */
    Rv6=Rv5;
    if (((V *)Rv6)[4]==NULL) ((V *)Rv6)[4]=Lx[0].v[66];
    else {
      Lx[0].v[67]=((V *)Rv6)[4];
      while (((V *)Lx[0].v[67])[5]!=NULL)
      Lx[0].v[67]=((V *)Lx[0].v[67])[5];
      Ra.sl[6]=901; /* line # 901 */
      ((V *)Lx[0].v[67])[5]=Lx[0].v[66];
    }
    ((V *)Rv4)[4]=P_schitem(V_wavhde,0);
    Rv7=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((V *)Rv4)[(7-Rv7)+5]=MXDLSRT_PRC_00000006(Rv7+12, Lx[0].v[66]);
      Rv7++;
    }
    break;
    case 68:Ra.sl[6]=910; /* line # 910 */
    MXDLSRT_PRC_00000004(&V_dsphde, Lx[0].v+66,10);
    Rv8=Lx[0].v[66];
    Rv5=P_schitem(V_atomhde,0);
    ((V *)Rv8)[4]=P_schitem(V_wavhde,0);
    Ra.sl[6]=915; /* line # 915 */
    ((V *)Rv8)[5]=NULL;
    Rv9=Rv5;
    if (((V *)Rv9)[5]==NULL) ((V *)Rv9)[5]=Lx[0].v[66];
    else {
      Lx[0].v[67]=((V *)Rv9)[5];
      Ra.sl[6]=920; /* line # 920 */
      while (((V *)Lx[0].v[67])[5]!=NULL)
      Lx[0].v[67]=((V *)Lx[0].v[67])[5];
      ((V *)Lx[0].v[67])[5]=Lx[0].v[66];
    }
    Rv10=0;
    for( Rf1=8;Rf1>0;Rf1-- ) {
      ((V *)Rv8)[(8-Rv10)+5]=MXDLSRT_PRC_00000006(Rv10+19, Lx[0].v[66]);
      Rv10++;
    }
    break;
    case 69:Ra.sl[6]=929; /* line # 929 */
    MXDLSRT_PRC_00000004(&V_wavhde, Lx[0].v+66,7);
    V_iqwave=V_iqwave+1;
    Rv11=Lx[0].v[66];
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(((F *)Rv11)+11,0);
    PAS__READ_SNGL(((F *)Rv11)+12,0);
    PAS__READ_SNGL(((F *)Rv11)+13,0);
    PAS__READ_SNGL(((F *)Rv11)+8,0);
    PAS__READ_SNGL(((F *)Rv11)+9,0);
    PAS__READ_SNGL(((F *)Rv11)+10,0);
    PAS__READ_SL(&Rv12,0);
    Ra.sl[6]=934; /* line # 934 */
    ((UB *)Rv11)[56]=Rv12>0;
    break;
    case 70:Ra.sl[6]=940; /* line # 940 */
    MXDLSRT_PRC_00000004(&V_polhde, Lx[0].v+66,8);
    Rv13=Lx[0].v[66];
    ((V *)Rv13)[9]=MXDLSRT_PRC_00000006(42, Lx[0].v[66]);
    Rv14=1;
    for( Rf1=5;Rf1>0;Rf1-- ) {
      ((V *)Rv13)[(6-Rv14)+3]=MXDLSRT_PRC_00000006(27+Rv14, Lx[0].v[66]);
      Rv14++;
    }
    break;
    case 71:Ra.sl[6]=950; /* line # 950 */
    MXDLSRT_PRC_00000004(&V_symhde, Lx[0].v+66,13);
    Rv15=Lx[0].v[66];
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(((SL *)Rv15)+8,0);
    PAS__READ_SL(((SL *)Rv15)+9,0);
    PAS__READ_SL(((SL *)Rv15)+10,0);
    PAS__READ_SL(((SL *)Rv15)+11,0);
    PAS__READ_SL(((SL *)Rv15)+12,0);
    PAS__READ_SL(((SL *)Rv15)+13,0);
    PAS__READ_SL(((SL *)Rv15)+14,0);
    PAS__READ_SL(((SL *)Rv15)+15,0);
    PAS__READ_SL(((SL *)Rv15)+16,0);
    PAS__READ_SL(((SL *)Rv15)+17,0);
    PAS__READ_SL(((SL *)Rv15)+18,0);
    PAS__READ_SL(((SL *)Rv15)+19,0);
    PAS__READ_SL(&Rv12,0);
    Ra.sl[6]=956; /* line # 956 */
    if (Rv12!=0) {
      ((V *)Rv15)[10]=PAS__NEW(36);
      PAS__SELECT_INP(V_intf);
      PAS__READ_EOLN();
      Rv16=1;
      for( Rf1=3;Rf1>0;Rf1-- ) {
        Rv17=1;
        for( Rf0=3;Rf0>0;Rf0-- ) {
          PAS__SELECT_INP(V_intf);
          PAS__READ_SNGL((((F *)((V *)Rv15)[10])+Rv16*3+Rv17-4),0);
          Rv17++;
        }
        Rv16++;
      }
    }
    else((V *)Rv15)[10]=NULL;
    break;
    case 72:Ra.sl[6]=966; /* line # 966 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(Lx[0].sl+136,0);
    PAS__READ_SL(&Rv12,0);
    if (Lx[0].sl[136]>0||Lx[0].sl[136]<-100) P_setoption(Lx[0].sl[136],Rv12);
    else {
      Ra.sl[6]=971; /* line # 971 */
      Lx[0].f[137]=(F)0.000000E-01;
      if (Rv12>0) {
        PAS__SELECT_INP(V_intf);
        PAS__READ_SNGL(Lx[0].f+137,0);
      }
      if (Lx[0].sl[136]==-1) V_b132=Lx[0].f[137]>(F)5.000000E-01;
      else {
        if (Lx[0].sl[136]==0) V_bshortlst=Lx[0].f[137]>(F)5.000000E-01;
      }
    }
    break;
    case 73:Ra.sl[6]=981; /* line # 981 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(Lx[0].sl+136,0);
    Rv18=MXDLSRT_PRC_00000003();
    switch (Lx[0].sl[136]) {
      case 1:V_psav=Rv18;
      break;
      case 0:Ra.sl[6]=986; /* line # 986 */
      V_pttl=Rv18;
      break;
      case -1:PAS__CLOSE(&V_lst,0);
      P_open_st_listing(&V_lst, Rv18,1);
      P_st_free(&Rv18);
      break;
      default:break;
    }
    break;
    case 74:Ra.sl[6]=996; /* line # 996 */
    Lx[0].v[69]=NULL;
    MXDLSRT_PRC_00000000(Lx[0].v[69]);
    break;
    case 75:MXDLSRT_PRC_00000004(&V_gvarhde, Lx[0].v+66,1);
    Rv19=Lx[0].v[66];
    Ra.sl[6]=1001; /* line # 1001 */
    ((F *)Rv19)[13]=(F)0.000000E-01;
    ((V *)Rv19)[5]=NULL;
    Lx[0].v[70]=Lx[0].v[66];
    ((SL *)Rv19)[8]=((SL *)Rv19)[6];
    ((SL *)Rv19)[9]=1;
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(((F *)Rv19)+12,0);
    PAS__READ_SNGL(((F *)Rv19)+13,0);
    break;
    case 76:Ra.sl[6]=1010; /* line # 1010 */
    MXDLSRT_PRC_00000004(&V_parhde, Lx[0].v+66,0);
    Rv20=Lx[0].v[66];
    ((V *)Rv20)[4]=MXDLSRT_PRC_00000001();
    ((F *)Rv20)[12]=(F)0.000000E-01;
    ((V *)Rv20)[7]=Lx[0].v[66];
    ((V *)Rv20)[5]=NULL;
    break;
    case 77:Ra.sl[6]=1019; /* line # 1019 */
    MXDLSRT_PRC_00000004(&V_datahde, Lx[0].v+66,11);
    V_nbcoll=V_nbcoll+1;
    Rv21=Lx[0].v[66];
    ((V *)Rv21)[5]=MXDLSRT_PRC_00000006(39, Lx[0].v[66]);
    ((V *)Rv21)[7]=MXDLSRT_PRC_00000006(34, Lx[0].v[66]);
    Ra.sl[6]=1024; /* line # 1024 */
    ((V *)Rv21)[6]=MXDLSRT_PRC_00000006(33, Lx[0].v[66]);
    ((V *)Rv21)[8]=MXDLSRT_PRC_00000006(27, Lx[0].v[66]);
    ((V *)Rv21)[4]=MXDLSRT_PRC_00000003();
    PAS__SELECT_INP(V_intf);
    PAS__READ_EOLN();
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(((SL *)Rv21)+18,0);
    PAS__READ_SL(((SL *)Rv21)+19,0);
    PAS__READ_SL(((SL *)Rv21)+20,0);
    PAS__SELECT_INP(V_intf);
    PAS__READ_EOLN();
    Ra.sl[6]=1029; /* line # 1029 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_EOLN();
    break;
    case 79:Ra.sl[6]=1035; /* line # 1035 */
    MXDLSRT_PRC_00000004(&V_blkhde, Lx[0].v+66,12);
    Rv22=Lx[0].v[66];
    ((V *)Rv22)[6]=MXDLSRT_PRC_00000006(41, Lx[0].v[66]);
    ((V *)Rv22)[5]=MXDLSRT_PRC_00000006(40, Lx[0].v[66]);
    Ra.sl[6]=1040; /* line # 1040 */
    ((V *)Rv22)[7]=Lx[0].v[70];
    break;
    case 80:Ra.sl[6]=1045; /* line # 1045 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(Lx[0].sl+136,0);
    V_bcentric=Lx[0].sl[136]>0;
    break;
    case 81:Lx[0].v[66]=P_schitem(V_gvarhde,0);
    Ra.sl[6]=1050; /* line # 1050 */
    Rv23=Lx[0].v[66];
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(((F *)Rv23)+12,0);
    PAS__READ_SNGL(((F *)Rv23)+13,0);
    break;
    case 82:PAS__SELECT_INP(V_intf);
    PAS__READ_SL(Lx[0].sl+136,0);
    V_buiso=Lx[0].sl[136]>0;
    break;
    case 83:Ra.sl[6]=1058; /* line # 1058 */
    Lx[0].v[66]=P_schitem(V_gvarhde,0);
    if (((SL *)Lx[0].v[66])[9]!=0) V_nbfixed=V_nbfixed+1;
    ((SL *)Lx[0].v[66])[9]=0;
    break;
    case 84:Ra.sl[6]=1065; /* line # 1065 */
    Lx[0].v[66]=P_schitem(V_gvarhde,0);
    if (((SL *)Lx[0].v[66])[9]==0) V_nbfixed=V_nbfixed-1;
    ((SL *)Lx[0].v[66])[9]=1;
    break;
    case 85:Ra.sl[6]=1071; /* line # 1071 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(&V_latticenb,0);
    break;
    case 86:Lx[0].v[66]=P_schitem(V_gvarhde,0);
    Ra.sl[6]=1076; /* line # 1076 */
    Rv24=Lx[0].v[66];
    ((V *)Rv24)[5]=PAS__NEW(8);
    V_bflimited=1;
    Rv25=((V *)Rv24)[5];
    PAS__SELECT_INP(V_intf);
    PAS__READ_SNGL(((F *)Rv25),0);
    PAS__READ_SNGL(((F *)Rv25)+1,0);
    break;
    case 87:Ra.sl[6]=1083; /* line # 1083 */
    V_bfmagnetic=1;
    Rv26=0;
    for( Rf1=32;Rf1>0;Rf1-- ) {
      PAS__SELECT_INP(V_intf);
      PAS__READ_SL(Lx[0].sl+142,0);
      V_magsel.ub[Rv26]=Lx[0].sl[142]>0;
      Rv26++;
    }
    break;
    case 88:Ra.sl[6]=1092; /* line # 1092 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(&Rv12,0);
    if (Rv12>0) {
      MXDLSRT_PRC_00000004(&V_contrhde, Lx[0].v+66,2);
      ((F *)Lx[0].v[66])[8]=(F)0.000000E-01;
    }
    else {
      Ra.sl[6]=1098; /* line # 1098 */
      Lx[0].v[66]=P_schitem(V_contrhde,0);
    }
    Rv5=P_schitem(V_atomhde,0);
    ((V *)Rv5)[6]=Lx[0].v[66];
    break;
    case 89:Ra.sl[6]=1105; /* line # 1105 */
    MXDLSRT_PRC_00000004(&V_formalhde, Lx[0].v+66,4);
    MXDLSRT_PRC_00000000(Lx[0].v[66]);
    break;
    case 90:Ra.sl[6]=1111; /* line # 1111 */
    MXDLSRT_PRC_00000004(&V_usfuncthde, Lx[0].v+66,5);
    Rv27=Lx[0].v[66];
    ((V *)Rv27)[5]=MXDLSRT_PRC_00000001();
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(Lx[0].sl+136,0);
    Ra.sl[6]=1116; /* line # 1116 */
    ((V *)Rv27)[4]=NULL;
    while (Lx[0].sl[136]!=0){
      Rv5=MXDLSRT_PRC_00000001();
      ((V *)Rv5)[4]=((V *)Rv27)[4];
      ((V *)Rv27)[4]=Rv5;
      Lx[0].sl[136]=Lx[0].sl[136]-1;
    }
    break;
    case 91:Ra.sl[6]=1126; /* line # 1126 */
    MXDLSRT_PRC_00000004(&V_loopidxhde, Lx[0].v+66,3);
    MXDLSRT_PRC_00000000(Lx[0].v[66]);
    break;
    case 78:
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:break;
  }
  Ra.sl[6]=1132; /* line # 1132 */
  PAS__SELECT_INP(V_intf);
  PAS__READ_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " buildtree "  */
void P_buildtree(){
  /* Define the automatic variable space. */
  Blk( Ra, 608 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register V Rv3;
  register V Rv4;
  SL Rv5;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[72]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+576;
  Ra.v[73]=Rd.s+663;
  Ra.v[74]=Rd.s+7;
  Ra.sl[150]=1137; /* line # 1137 */
  if (V_parhde==NULL) P_initab();
  Ra.sl[0]=-1;
  Ra.v[70]=NULL;
  while (1){
    Ra.sl[150]=1142; /* line # 1142 */
    PAS__SELECT_INP(V_intf);
    PAS__READ_SL(Ra.sl+130,0);
    Rv0=0;
    Rv1=0;
    Rv2=0;
    if (Ra.sl[130]>=0) {
      if (Ra.sl[130]<=63) {
        Ra.sl[150]=1148; /* line # 1148 */
        switch (Ra.sl[130]) {
          case 0:
          case 2:
          case 3:
          case 4:
          case 5:
          case 6:
          case 7:
          case 63:Rv0=1;
          break;
          case 1:Ra.v[69]=PAS__NEW(8);
          break;
          case 16:Ra.sl[150]=1153; /* line # 1153 */
          Ra.v[69]=PAS__NEW(8);
          break;
          case 17:
          case 18:
          case 48:
          case 50:
          case 51:
          case 52:
          case 53:
          case 54:
          case 55:Ra.v[69]=PAS__NEW(24);
          break;
          case 19:
          case 20:
          case 22:
          case 34:Ra.v[69]=PAS__NEW(32);
          break;
          case 21:
          case 49:Ra.sl[150]=1159; /* line # 1159 */
          Ra.v[69]=PAS__NEW(16);
          break;
          case 24:
          case 25:
          case 26:
          case 27:
          case 28:
          case 29:
          case 30:
          case 31:
          case 32:
          case 33:
          case 35:Ra.v[69]=PAS__NEW(20);
          break;
          case 23:Ra.sl[150]=1164; /* line # 1164 */
          Ra.v[69]=PAS__NEW(24);
          break;
          case 36:Ra.v[69]=PAS__NEW(28);
          break;
          case 43:Ra.sl[150]=1170; /* line # 1170 */
          Ra.v[69]=PAS__NEW(24);
          Ra.v[67]=V_sumhhde;
          if (Ra.v[67]==NULL) V_sumhhde=Ra.v[69];
          else {
            while (((V *)Ra.v[67])[1]!=NULL)
            Ra.v[67]=((V *)Ra.v[67])[1];
            Ra.sl[150]=1175; /* line # 1175 */
            ((V *)Ra.v[67])[1]=Ra.v[69];
          }
          break;
          case 41:
          case 42:
          case 56:
          case 57:Ra.sl[150]=1181; /* line # 1181 */
          PAS__SELECT_INP(V_intf);
          PAS__READ_SL(Ra.sl+136,0);
          if (Ra.sl[130]>42) Ra.sl[136]=Ra.sl[136]+1;
          switch (Ra.sl[136]) {
            case 0:
            case 1:
            case 2:Ra.v[69]=PAS__NEW(32);
            break;
            case 3:
            case 4:Ra.v[69]=PAS__NEW(48);
            break;
            case 5:
            case 6:
            case 7:
            case 8:Ra.sl[150]=1187; /* line # 1187 */
            Ra.v[69]=PAS__NEW(80);
            break;
            case 9:
            case 10:
            case 11:
            case 12:
            case 13:
            case 14:
            case 15:
            case 16:Ra.v[69]=PAS__NEW(144);
            break;
            case 17:
            case 18:
            case 19:
            case 20:
            case 21:
            case 22:
            case 23:
            case 24:
            case 25:
            case 26:
            case 27:
            case 28:
            case 29:
            case 30:
            case 31:
            case 32:Ra.v[69]=PAS__NEW(272);
            break;
          }
          Ra.sl[150]=1193; /* line # 1193 */
          ((SL *)Ra.v[69])[2]=Ra.sl[136];
          break;
          case 40:Ra.v[69]=PAS__NEW(48);
          break;
          default:break;
        }
        Ra.sl[150]=1200; /* line # 1200 */
        if (Rv0) switch (Ra.sl[130]) {
          case 0:PAS__SELECT_INP(V_intf);
          PAS__READ_SL(Ra.sl+136,0);
          if (Ra.sl[136]>=19&&Ra.sl[136]<=22) {
            Ra.sl[150]=1205; /* line # 1205 */
            Ra.v[69]=MXDLSRT_PRC_00000005(Ra.sl[136]-18);
          }
          else {
            Ra.v[69]=PAS__NEW(8);
            Rv3=Ra.v[69];
            Ra.sl[150]=1211; /* line # 1211 */
            ((UB *)Rv3)[0]=35;
            ((SL *)Rv3)[1]=Ra.sl[136];
            if (Ra.sl[136]>19) ((SL *)Rv3)[1]=((SL *)Rv3)[1]-4;
          }
          break;
          case 2:Ra.sl[150]=1216; /* line # 1216 */
          Ra.v[69]=P_schitem(V_parhde,0);
          break;
          case 3:Ra.v[69]=P_schitem(V_gvarhde,0);
          break;
          case 4:Ra.v[69]=P_schitem(V_contrhde,0);
          break;
          case 5:Ra.v[69]=P_schitem(V_loopidxhde,0);
          break;
          case 6:Ra.v[69]=P_schitem(V_usfuncthde,0);
          break;
          case 7:Ra.sl[150]=1221; /* line # 1221 */
          Ra.v[69]=P_schitem(V_formalhde,0);
          break;
          case 63:PAS__SELECT_INP(V_intf);
          PAS__READ_SL(Ra.sl+136,0);
          switch (Ra.sl[136]) {
            case 0:Ra.sl[150]=1226; /* line # 1226 */
            Ra.v[69]=P_schitem(V_atomhde,0);
            break;
            case 1:Ra.v[69]=P_schitem(V_momhde,0);
            break;
            case 2:Ra.v[69]=P_schitem(V_dsphde,0);
            break;
            case 3:Ra.v[69]=P_schitem(V_polhde,0);
            break;
            case 4:Ra.v[69]=P_schitem(V_datahde,0);
            break;
            case 5:Ra.sl[150]=1231; /* line # 1231 */
            Ra.v[69]=P_schitem(V_blkhde,0);
            break;
          }
          PAS__SELECT_INP(V_intf);
          PAS__READ_SL(Ra.sl+142,0);
          if (Ra.sl[136]<4) Ra.v[69]=((V *)Ra.v[69])[Ra.sl[142]+6];
          else {
            Ra.sl[150]=1236; /* line # 1236 */
            if (Ra.sl[142]==4) switch (Ra.sl[142]) {
              case 1:Ra.v[69]=((V *)Ra.v[69])[8];
              break;
              case 2:Ra.v[69]=((V *)Ra.v[69])[6];
              break;
              case 3:Ra.v[69]=((V *)Ra.v[69])[7];
              break;
              case 4:Ra.sl[150]=1241; /* line # 1241 */
              Ra.v[69]=((V *)Ra.v[69])[5];
              break;
            }
            else {
              if (Ra.sl[142]==1) Ra.v[69]=((V *)Ra.v[69])[5];
              else Ra.v[69]=((V *)Ra.v[69])[6];
            }
          }
          break;
        }
        else {
          Ra.sl[150]=1249; /* line # 1249 */
          Rv4=Ra.v[69];
          switch (Ra.sl[130]) {
            case 1:((UB *)Rv4)[0]=34;
            PAS__SELECT_INP(V_intf);
            PAS__READ_SL(((SL *)Rv4)+1,0);
            break;
            case 8:
            case 9:
            case 10:
            case 11:
            case 12:
            case 13:
            case 14:
            case 15:break;
            case 16:Ra.sl[150]=1254; /* line # 1254 */
            ((UB *)Rv4)[0]=33;
            PAS__SELECT_INP(V_intf);
            PAS__READ_SNGL(((F *)Rv4)+1,0);
            break;
            case 17:((UB *)Rv4)[0]=0;
            Rv1=1;
            break;
            case 18:((UB *)Rv4)[0]=1;
            Rv1=1;
            break;
            case 19:((UB *)Rv4)[0]=2;
            Rv1=1;
            break;
            case 20:((UB *)Rv4)[0]=3;
            Rv1=1;
            break;
            case 21:Ra.sl[150]=1259; /* line # 1259 */
            ((UB *)Rv4)[0]=5;
            Rv2=1;
            break;
            case 22:((UB *)Rv4)[0]=4;
            Rv1=1;
            break;
            case 23:((UB *)Rv4)[0]=16;
            PAS__SELECT_INP(V_intf);
            PAS__READ_SL(((SL *)Rv4)+5,0);
            ((V *)Rv4)[1]=MXDLSRT_PRC_00000001();
            break;
            case 24:((UB *)Rv4)[0]=9;
            Rv2=1;
            break;
            case 25:Ra.sl[150]=1264; /* line # 1264 */
            ((UB *)Rv4)[0]=10;
            Rv2=1;
            break;
            case 26:((UB *)Rv4)[0]=11;
            Rv2=1;
            break;
            case 27:((UB *)Rv4)[0]=12;
            Rv2=1;
            break;
            case 28:((UB *)Rv4)[0]=13;
            Rv2=1;
            break;
            case 29:((UB *)Rv4)[0]=14;
            Rv2=1;
            break;
            case 30:Ra.sl[150]=1269; /* line # 1269 */
            ((UB *)Rv4)[0]=8;
            Rv2=1;
            break;
            case 31:((UB *)Rv4)[0]=7;
            Rv2=1;
            break;
            case 32:((UB *)Rv4)[0]=6;
            Rv2=1;
            break;
            case 33:((UB *)Rv4)[0]=15;
            Rv2=1;
            break;
            case 34:((UB *)Rv4)[0]=17;
            Rv1=1;
            break;
            case 35:Ra.sl[150]=1274; /* line # 1274 */
            ((UB *)Rv4)[0]=18;
            Rv2=1;
            break;
            case 36:((UB *)Rv4)[0]=21;
            ((V *)Rv4)[2]=MXDLSRT_PRC_00000001();
            ((V *)Rv4)[1]=MXDLSRT_PRC_00000001();
            ((F *)Rv4)[6]=(F)0.000000E-01;
            break;
            case 37:
            case 38:
            case 39:break;
            case 40:Ra.sl[150]=1282; /* line # 1282 */
            ((UB *)Rv4)[0]=22;
            ((V *)Rv4)[5]=MXDLSRT_PRC_00000001();
            ((V *)Rv4)[3]=MXDLSRT_PRC_00000001();
            ((V *)Rv4)[2]=MXDLSRT_PRC_00000001();
            ((V *)Rv4)[1]=MXDLSRT_PRC_00000001();
            ((V *)Rv4)[4]=MXDLSRT_PRC_00000001();
            break;
            case 41:((UB *)Rv4)[0]=36;
            break;
            case 42:Ra.sl[150]=1287; /* line # 1287 */
            ((UB *)Rv4)[0]=37;
            break;
            case 43:((UB *)Rv4)[0]=38;
            ((V *)Rv4)[2]=MXDLSRT_PRC_00000001();
            break;
            case 44:
            case 45:
            case 46:
            case 47:break;
            case 48:((UB *)Rv4)[0]=20;
            Rv1=1;
            break;
            case 49:((UB *)Rv4)[0]=19;
            Rv2=1;
            break;
            case 50:Ra.sl[150]=1292; /* line # 1292 */
            ((UB *)Rv4)[0]=27;
            Rv1=1;
            break;
            case 51:((UB *)Rv4)[0]=28;
            Rv1=1;
            break;
            case 52:((UB *)Rv4)[0]=29;
            Rv1=1;
            break;
            case 53:((UB *)Rv4)[0]=30;
            Rv1=1;
            break;
            case 54:((UB *)Rv4)[0]=31;
            Rv1=1;
            break;
            case 55:Ra.sl[150]=1297; /* line # 1297 */
            ((UB *)Rv4)[0]=32;
            Rv1=1;
            break;
            case 56:
            case 57:((SL *)Rv4)[2]=((SL *)Rv4)[2]-1;
            if (Ra.sl[130]==56) {
              Ra.sl[150]=1303; /* line # 1303 */
              ((UB *)Rv4)[0]=26;
              ((V *)Rv4)[((SL *)Rv4)[2]+2]=P_schitem(V_formalhde,0);
            }
            else {
              ((UB *)Rv4)[0]=24;
              Ra.sl[150]=1308; /* line # 1308 */
              ((V *)Rv4)[((SL *)Rv4)[2]+2]=P_schitem(V_usfuncthde,0);
            }
            break;
          }
          PAS__SELECT_INP(V_intf);
          PAS__READ_EOLN();
          Ra.sl[150]=1313; /* line # 1313 */
          if (Rv1) {
            ((V *)Rv4)[2]=MXDLSRT_PRC_00000001();
            ((V *)Rv4)[1]=MXDLSRT_PRC_00000001();
          }
          else {
            if (Rv2) ((V *)Rv4)[1]=MXDLSRT_PRC_00000001();
            else {
              Ra.sl[150]=1318; /* line # 1318 */
              if (((((UB *)Rv4)[0]==36||((UB *)Rv4)[0]==37)||((UB *)Rv4)[0]==24)
              ||((UB *)Rv4)[0]==26) {
                Rv5=((SL *)Rv4)[2]-1;
                for( Rf0=(((SL *)Rv4)[2]-1)+1;Rf0>0;Rf0-- ) {
                  ((V *)Rv4)[Rv5+2]=MXDLSRT_PRC_00000001();
                  Rv5--;
                }
              }
            }
          }
        }
        MXDLSRT_PRC_00000000(Ra.v[69]);
      }
      else {
        Ra.sl[150]=1325; /* line # 1325 */
        MXDLSRT_PRC_00000007();
      }
    }
    else {
      if (Ra.sl[130]==-1) P_error(90);
      else P_error(-89);
      PAS__SELECT_INP(V_intf);
      PAS__READ_EOLN();
    }
    if (PAS__EOF(V_intf)||V_bstop)  break;
  }
  Ra.sl[150]=1332; /* line # 1332 */
  if (!V_bshortlst) V_b132=1;
  P_close_txtfile(&V_intf);
  PAS__curr_cntx=Ra.v[72];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " phasearg "  */
F P_phasearg(F F_ip, F F_rp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+674;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=1348; /* line # 1348 */
  Rv0=sqrt(F_ip*F_ip+F_rp*F_rp);
  if (Rv0==(F)0.000000E-01) Ret=(F)0.000000E-01;
  else {
    Rv0=F_ip/Rv0;
    Ra.sl[6]=1353; /* line # 1353 */
    if (F_rp<(F)0.000000E-01) Ret=(F)1.800000E+02-asin(Rv0);
    else Ret=asin(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " tanh "  */
F MXD_TANH(F F_v){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+684;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=1367; /* line # 1367 */
  Rv0=exp((F)-2.000000E+00*fabs(F_v));
  Rv0=((F)1.000000E+00-Rv0)/((F)1.000000E+00+Rv0);
  if (F_v>=(F)0.000000E-01) Ret=Rv0;
  else Ret= -Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
