/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 432 ) = {
 10,  10, 115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  60,  60,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95,  86,  51,  95,  65,  95, 115, 114,  99,  47,  99, 112,  97, 115,  95,
 98,  95,  95, 115, 114,  99,  46, 112,  97, 115,  12,  12, 115, 114,  99,  95,
 97, 108, 108, 111,  99,  97, 116, 101,   8,   8, 115, 114,  99,  95, 102, 114,
101, 101,   9,   9, 115, 114,  99,  95,  99, 108, 111, 115, 101,   8,   8, 115,
114,  99,  95, 111, 112, 101, 110,  17,  17, 115, 114,  99,  95, 111, 117, 116,
 95, 116, 101, 120, 116,  95, 108, 105, 110, 101,  11,  11, 115, 114,  99,  95,
111, 117, 116, 108, 105, 110, 101,  17,  17, 115, 114,  99,  95, 111, 117, 116,
101, 114, 114,  95,  98,  97, 110, 110, 101, 114,  40,  40,  32,  37,  42,  43,
 42,  43,  42,  32, 101, 114, 114, 111, 114,  40, 115,  41,  32, 119,  97, 115,
 32, 100, 101, 116, 101,  99, 116, 101, 100,  32,  97, 116,  32, 108, 105, 110,
101,  32,  35,  32,  16,  16,  32, 105, 110,  32, 116, 104, 101,  32, 102, 105,
108, 101,  32,  58,  32,  34,  13,  13, 115, 114,  99,  95, 111, 117, 116,  95,
101, 114, 114, 111, 114,  17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 109,
 97,  99,  95, 101, 114, 114, 111, 114,   9,   9, 115, 114,  99,  95, 101, 114,
114, 111, 114,  17,  17, 115, 114,  99,  95, 103, 101, 116,  95, 105, 110, 112,
117, 116, 108, 105, 110, 101,  14,  14, 115, 114,  99,  95, 112, 117, 116,  95,
112, 114, 111, 109, 112, 116,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95,
108, 105, 110, 101,  15,  15, 115, 114,  99,  95, 101, 110, 100,  95, 111, 102,
 95, 108, 105, 110, 101,   4,   4,  83,  95,  71,  76,  12,  12, 115, 114,  99,
 95, 103, 101, 116,  95,  99, 104,  97, 114,  12,  12, 115, 107, 105, 112,  95,
 99, 111, 109, 109, 101, 110, 116,  10,  10, 115, 114,  99,  95, 105, 110,  99,
104,  97, 114,  13,  13, 115, 114,  99,  95, 110, 101, 120, 116,  95,  99, 104,
 97, 114,  15,  15, 115, 114,  99,  95, 115, 101,  97, 114,  99, 104,  95,  99,
104,  97, 114,   8,   8, 115, 114,  99,  95, 105, 110, 105, 116,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
SL V_src_maxerror;
SL V_src_lstinsnb;
V V_src_control;
V V_src_cont_base;
V V_src_hde;
V V_src_listing;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);
void P_vsr_nextstring();


/* Procedure/Function : " src_r_init "  */
void BASIC_SRC_src_r_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=184; /* line # 184 */
  Rv0=F_p;
  ((V *)Rv0)[1]=NULL;
  ((SL *)Rv0)[5]=0;
  Ra.sl[6]=189; /* line # 189 */
  ((SL *)Rv0)[6]=0;
  ((SL *)Rv0)[7]=0;
  ((SL *)Rv0)[9]=0;
  ((SL *)Rv0)[10]=0;
  ((SL *)Rv0)[11]=1;
  Ra.sl[6]=194; /* line # 194 */
  ((C *)Rv0)[53]=32;
  ((C *)Rv0)[54]=32;
  ((C *)Rv0)[52]=1;
  ((SL *)Rv0)[12]=255;
  Rv1=1;
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Ra.sl[6]=199; /* line # 199 */
    ((V *)Rv0)[Rv1*3+6]=NULL;
    Rv1++;
  }
  ((UL *)Rv0)[62]=16456;
  Ra.sl[6]=204; /* line # 204 */
  ((UB *)Rv0)[252]=0;
  ((UB *)((V *)Rv0)[32])[1]=0;
  P_str_copy_lim(((V *)Rv0)+33,V_def_prompt,64);
  _FILE_CLEAR(((V *)Rv0)[35]);
  Ra.sl[6]=209; /* line # 209 */
  _FILE_CLEAR(((V *)Rv0)[34]);
  V_src_maxerror=31;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V P_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+74;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=224; /* line # 224 */
  Rv0=PAS__NEW(288);
  Rv1=Rv0;
  ((V *)Rv1)[0]=V_src_hde;
  ((V *)Rv1)[32]=PAS__NEW(257);
  ((UB *)((V *)Rv1)[32])[0]=255;
  ((UB *)((V *)Rv1)[32])[1]=0;
  Ra.sl[6]=229; /* line # 229 */
  ((V *)Rv1)[33]=PAS__NEW(257);
  ((UB *)((V *)Rv1)[33])[0]=255;
  ((UB *)((V *)Rv1)[33])[1]=0;
  BASIC_SRC_src_r_init(Rv0);
  V_src_hde=Rv0;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+88;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=244; /* line # 244 */
  Rv0=NULL;
  if (F_p!=NULL) {
    Rv1=V_src_hde;
    while (Rv1!=F_p&&Rv1!=NULL){
      Ra.sl[6]=250; /* line # 250 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Ra.sl[6]=255; /* line # 255 */
    Rv2=F_p;
    PAS__DISPOSE(((V *)Rv2)+32);
    if (!(512&((UL *)Rv2)[62])) PAS__DISPOSE(((V *)Rv2)+33);
    Ra.sl[6]=261; /* line # 261 */
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    PAS__DISPOSE(&F_p);
    F_p=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+98;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=278; /* line # 278 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (128&((UL *)Rv0)[62]) Rv1=2048;
    else Rv1=0;
    Ra.sl[6]=283; /* line # 283 */
    PAS__CLOSE(((V *)Rv0)+35,Rv1);
    if (8&((UL *)Rv0)[62]) PAS__CLOSE(((V *)Rv0)+34,0);
  }
  if (!F_bfree) BASIC_SRC_src_r_init((*F_p));
  else P_src_free((*F_p));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_open "  */
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+109;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=305; /* line # 305 */
  (*F_ierr)=0;
  if ((*F_p)==NULL) {
    Rv0=0;
    (*F_p)=P_src_allocate();
  }
  else {
    Ra.sl[6]=310; /* line # 310 */
    Rv0=1;
    P_src_close(F_p,0);
  }
  Rv1=(*F_p);
  Ra.sl[6]=315; /* line # 315 */
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[35],PAS__f_input);
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16;
    PAS__iostatus=0;
  }
  else {
    Ra.sl[6]=321; /* line # 321 */
    PAS__OPEN(((V *)Rv1)+35,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  }
  if (PAS__iostatus==0) {
    Ra.sl[6]=326; /* line # 326 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~8;
    if (PAS__TTY_FILE(((V *)Rv1)[35])) {
      if (((UB *)F_fspc)[1]==0) {
        Ra.sl[6]=331; /* line # 331 */
        _FILE_DUPLICATE(((V *)Rv1)[34],PAS__f_output);
        PAS__iostatus=0;
      }
      else PAS__OPEN(((V *)Rv1)+34,0, F_fspc,4098,0,-1);
      if (PAS__iostatus!=0) {
        Ra.sl[6]=336; /* line # 336 */
        (*F_ierr)=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+35,0);
      }
      else((UL *)Rv1)[62]=((UL *)Rv1)[62]|8;
    }
    if (!(8&((UL *)Rv1)[62])) {
      Ra.sl[6]=341; /* line # 341 */
      if (F_bdelete) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|128;
    }
  }
  else (*F_ierr)=PAS__iostatus;
  if ((*F_ierr)!=0) {
    if (Rv0) BASIC_SRC_src_r_init((*F_p));
    else {
      Ra.sl[6]=346; /* line # 346 */
      P_src_free((*F_p));
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SRC_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+119;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=359; /* line # 359 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Rv1=V_lst_current;
  if (F_bterm) Rv2=80;
  else Rv2=((SL *)Rv1)[16];
  Ra.sl[6]=364; /* line # 364 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    if (Rv0>Rv2) {
      Ra.sl[6]=369; /* line # 369 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      if (!F_bterm) ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[6]=375; /* line # 375 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SRC_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+138;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=387; /* line # 387 */
  Rv0=V_src_control;
  if (V_src_lstinsnb!=((SL *)Rv0)[6]) {
    V_src_lstinsnb=((SL *)Rv0)[6];
    Ra.sl[6]=392; /* line # 392 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[6],5,0);
  }
  else {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[53]);
  PAS__WRITE_CHAR(((C *)Rv0)[54]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[6]=397; /* line # 397 */
  Rv1=((V *)Rv0)[32];
  Rv2=V_lst_current;
  if (F_bterm) Rv3=80;
  else Rv3=((SL *)Rv2)[16];
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[10],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[6]=402; /* line # 402 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Rv4=20;
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=407; /* line # 407 */
      Rv4=Rv4+1;
      if (Rv4>Rv3) {
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        if (!F_bterm) ((SL *)Rv2)[12]=((SL *)Rv2)[12]+1;
        Ra.sl[6]=412; /* line # 412 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=418; /* line # 418 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[32],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SRC_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+151;
  Ra.v[35]=Rd.s+12;
  Ra.sl[72]=437; /* line # 437 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.ub[1]=Ra.ub[0];
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[72]=443; /* line # 443 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[11]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Rv5=(((S *)Rv0)+Rv4*24+32);
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  if (((UB *)((V *)Rv0)[32])[1]>((SL *)Rv0)[12]) {
    Ra.sl[72]=450; /* line # 450 */
    Rv6=((SL *)Rv0)[12]+1;
    for( Rf0=(((UB *)((V *)Rv0)[32])[1]+1)-(((SL *)Rv0)[12]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.ub[1]=((UB *)((V *)Rv0)[32])[1];
  }
  else Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[9]*6+8];
  Ra.sl[72]=455; /* line # 455 */
  BASIC_SRC_src_out_text_line(F_f,Ra.s,F_bterm);
  if (F_bterm) {
    P_lst_newline();
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
  }
  Ra.sl[72]=461; /* line # 461 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+170,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[10],5,0);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+212,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+292,((V *)Rv0)[35]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SRC_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+230;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=470; /* line # 470 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if ((1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7])&&!(64&((UB *)Rv1)[72])
  ) {
    Ra.sl[6]=475; /* line # 475 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
    BASIC_SRC_src_outerr_banner(((V *)Rv1)+10,0);
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=480; /* line # 480 */
      P_lst_newline();
      ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      P_err_display(((V *)Rv1)+10,Rv2,(((S *)Rv0)+Rv2*24+32));
      Rv2++;
    }
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[10]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=486; /* line # 486 */
  if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) {
    if (!F_bmac) BASIC_SRC_src_outline(&PAS__f_output,1);
    BASIC_SRC_src_outerr_banner(&PAS__f_output,1);
    Rv3=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=491; /* line # 491 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*24+32));
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[6]=496; /* line # 496 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*3+6));
    Rv4++;
  }
  if (Rs.sl[0]>V_src_maxerror) PAS__EXIT(4);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+245;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=506; /* line # 506 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (((SL *)Rv0)[9]>0) {
    if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) (*F_out_mac_line)(&PAS__f_output,1);
    BASIC_SRC_src_out_error(1);
    Ra.sl[6]=511; /* line # 511 */
    ((SL *)Rv0)[9]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+264;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=527; /* line # 527 */
  Rv0=V_src_control;
  if (((SL *)Rv0)[4]<((SL *)Rv0)[11]) ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  else {
    if (((SL *)Rv0)[4]>((SL *)Rv0)[12]) ((SL *)Rv0)[4]=((SL *)Rv0)[12];
  }
  Ra.sl[6]=533; /* line # 533 */
  if (((SL *)Rv0)[9]>=8) {
    ((SL *)Rv0)[9]=8;
    Rv1=0;
  }
  else {
    Ra.sl[6]=539; /* line # 539 */
    Rv1=1;
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      if (((SL *)Rv0)[4]==((SL *)Rv0)[Rv2*6+8]) Rv1=0;
      Rv2++;
    }
    if (Rv1) ((SL *)Rv0)[9]=((SL *)Rv0)[9]+1;
  }
  Ra.sl[6]=545; /* line # 545 */
  if (Rv1) {
    Rv3=(((S *)Rv0)+((SL *)Rv0)[9]*24+32);
    ((SL *)Rv3)[0]=((SL *)Rv0)[4];
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[6]=550; /* line # 550 */
    ((SL *)Rv3)[1]=F_number;
    ((UB *)Rv3)[8]=F_severity;
    memcpy(Rv3+9,Ra.s+28,4);
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[9]*24+32));
  }
  else {
    Ra.sl[6]=556; /* line # 556 */
    ((UB *)Rv0)[((SL *)Rv0)[9]*24+40]=F_severity;
  }
  if (!(512&((UL *)Rv0)[62]||PAS__TTY_FILE(((V *)Rv0)[35]))) {
    if (PAS__EOF(((V *)Rv0)[35])) BASIC_SRC_src_out_error(0);
  }
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  Ra.sl[6]=561; /* line # 561 */
  if (F_severity>1) Rs.sl[0]=Rs.sl[0]+1;
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+275;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=584; /* line # 584 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[6]=589; /* line # 589 */
  ((UB *)Rv0)[1]=0;
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    if (Rv2==9) while (1){
      Ra.sl[6]=595; /* line # 595 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      if (Rv2>=32) {
        Ra.sl[6]=600; /* line # 600 */
        if (((UB *)Rv0)[1]<255) {
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[6]=605; /* line # 605 */
          ((UL *)Rv1)[62]=((UL *)Rv1)[62]|256;
        }
      }
    }
  }
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|65536;
  else {
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  ((SL *)Rv1)[10]=((SL *)Rv1)[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+294;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=619; /* line # 619 */
  if (F_pstr!=NULL) {
    Rv0=V_src_control;
    if (8&((UL *)Rv0)[62]) {
      Ra.sl[6]=624; /* line # 624 */
      PAS__SELECT_OUT(((V *)Rv0)[34]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SRC_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+310;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=635; /* line # 635 */
  Rv0=V_src_control;
  ((SL *)Rv0)[5]=((SL *)Rv0)[11]-1;
  ((SL *)Rv0)[9]=0;
  Ra.sl[6]=640; /* line # 640 */
  if (512&((UL *)Rv0)[62]) {
    P_vsr_nextstring();
    ((SL *)Rv0)[10]=((SL *)Rv0)[10]+1;
  }
  else {
    Ra.sl[6]=648; /* line # 648 */
    if (8&((UL *)Rv0)[62]) P_src_put_prompt(((V *)Rv0)[33]);
    P_src_get_inputline(((V *)Rv0)+35,((V *)Rv0)+32);
    if (32&((UL *)Rv0)[62]) {
      Ra.sl[6]=653; /* line # 653 */
      if (8&((UL *)Rv0)[62]) P_lst_put_string(((V *)Rv0)[33]);
      P_lst_put_string(((V *)Rv0)[32]);
      P_lst_eoln();
    }
  }
  Ra.sl[6]=658; /* line # 658 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+324;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=669; /* line # 669 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (256&((UL *)Rv0)[62]) {
    Ra.sl[6]=674; /* line # 674 */
    ((SL *)Rv0)[4]=((SL *)Rv0)[12]-1;
    P_src_error(Rd.s+343,1,2);
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~256;
  }
  if (1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7]) {
    if (!(64&((UB *)Rv1)[72])) {
      Ra.sl[6]=681; /* line # 681 */
      P_lst_newline();
      BASIC_SRC_src_outline(((V *)Rv1)+10,0);
    }
  }
  if (((SL *)Rv0)[9]>0) BASIC_SRC_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SRC_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+347;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=695; /* line # 695 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  while (!(65536&((UL *)Rv0)[62])&&16384&((UL *)Rv0)[62]){
    Ra.sl[6]=702; /* line # 702 */
    if (((SL *)Rv0)[10]>0&&!(2048&((UL *)Rv0)[62])) P_src_end_of_line();
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~18432;
    BASIC_SRC_src_get_line();
    Ra.sl[6]=708; /* line # 708 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|4096;
  }
  if (!(65536&((UL *)Rv0)[62])) {
    if (((SL *)Rv0)[5]>=((SL *)Rv0)[12]||((SL *)Rv0)[5]>=((UB *)Rv1)[1]) {
      Ra.sl[6]=713; /* line # 713 */
      if (2048&((UL *)Rv0)[62]&&((SL *)Rv0)[10]>0) P_src_end_of_line();
      if ((9216&((UL *)Rv0)[62])!=0) Rv2=1;
      else Rv2=32;
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|16384;
    }
    else {
      Ra.sl[6]=721; /* line # 721 */
      ((SL *)Rv0)[5]=((SL *)Rv0)[5]+1;
      Rv2=((C *)Rv1)[((SL *)Rv0)[5]+1];
    }
  }
  else {
    Rv2=0;
    Ra.sl[6]=726; /* line # 726 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|32768;
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SRC_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+361;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=741; /* line # 741 */
  Rv0=0;
  Rv1=V_src_control;
  if (4096&((UL *)Rv1)[62]&&((C *)Rv1)[53]==32) {
    Ra.sl[6]=746; /* line # 746 */
    ((C *)Rv1)[53]=67;
  }
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|8192;
  Rv2=((UB *)Rv1)[252];
  ((UB *)Rv1)[252]=4;
  while (1){
    while (1){
      Ra.sl[6]=752; /* line # 752 */
      Rv3=BASIC_SRC_src_get_char();
      if ((Rv3==0||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    switch (Rv2) {
      case 0:Ra.sl[6]=757; /* line # 757 */
      Rv0=F_stp==125&&Rv3==F_stp||Rv3==0;
      if (F_stp==42&&Rv3!=0) {
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) {
          Ra.sl[6]=762; /* line # 762 */
          Rv0=((C *)((V *)Rv1)[32])[(((SL *)Rv1)[5]+1)+1]==41;
          if (Rv0) Rv3=BASIC_SRC_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[6]=769; /* line # 769 */
      if (Rv3!=0) {
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) Rv3=BASIC_SRC_src_get_char();
        Rv0=Rv3==47;
      }
      else Rv0=1;
      break;
      case 2:
      case 3:
      case 4:Ra.sl[6]=778; /* line # 778 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[6]=783; /* line # 783 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~8192;
  ((UB *)Rv1)[252]=Rv2;
  if (Rv3!=0) {
    if (Rv3==1&&!(1024&((UL *)Rv1)[62])||Rv3>1) {
      Ra.sl[6]=789; /* line # 789 */
      Rv3=32;
    }
  }
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+375;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=804; /* line # 804 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Rv2=BASIC_SRC_src_get_char();
  switch (((UB *)Rv0)[252]) {
    case 0:Ra.sl[6]=810; /* line # 810 */
    if (Rv2==123) Rv2=BASIC_SRC_skip_comment(125,0);
    else {
      if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
          Rv2=BASIC_SRC_src_get_char();
          Ra.sl[6]=815; /* line # 815 */
          Rv2=BASIC_SRC_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=820; /* line # 820 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
        Rv2=BASIC_SRC_src_get_char();
        Rv2=BASIC_SRC_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[6]=827; /* line # 827 */
    if (Rv2==59) Rv2=BASIC_SRC_skip_comment(59,1);
    break;
    case 2:if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==45) {
        Ra.sl[6]=832; /* line # 832 */
        Rv2=BASIC_SRC_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[6]=837; /* line # 837 */
    break;
  }
  if (4096&((UL *)Rv0)[62]) {
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[6]=842; /* line # 842 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~4096;
      if (((C *)Rv0)[53]==67) ((C *)Rv0)[53]=32;
    }
  }
  ((C *)Rv0)[52]=Rv2;
  Ra.sl[6]=847; /* line # 847 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+387;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=856; /* line # 856 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  if (((SL *)Rv0)[5]>=((UB *)Rv1)[1]||((SL *)Rv0)[5]>=((SL *)Rv0)[12]) Ret=32;
  else Ret=((C *)Rv1)[(((SL *)Rv0)[5]+1)+1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+402;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=873; /* line # 873 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Rv2=((SL *)Rv0)[5];
  Rv3=1;
  while (Rv3){
    Ra.sl[6]=878; /* line # 878 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[12]) {
      Rv4=((C *)Rv1)[Rv2+1];
      if (Rv4==32) Rv2=Rv2+1;
      else Rv3=0;
    }
    else {
      Ra.sl[6]=886; /* line # 886 */
      Rv3=0;
      Rv4=32;
    }
  }
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=-1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+419;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=912; /* line # 912 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Rv1=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv1]=0;
    Rv1++;
  }
  V_error_result=0;
  Ra.sl[6]=917; /* line # 917 */
  V_src_control=NULL;
  if (((UB *)F_def_src)[1]>0) P_src_open(&V_src_control, F_def_src,0, &Rv0);
  if (Rv0==0) {
    Rv2=V_src_control;
    Ra.sl[6]=923; /* line # 923 */
    ((SL *)Rv2)[7]=1;
    ((SL *)Rv2)[8]=1;
  }
  else V_src_control=NULL;
  V_src_hde=V_src_control;
  Ra.sl[6]=928; /* line # 928 */
  V_src_cont_base=V_src_control;
  PAS__curr_cntx=Ra.v[0];
}
