/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 320 ) = {
 11,  11, 102, 112, 117,  95, 104,  97, 110, 100, 108, 101, 114,  50,  50,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95,  86,  51,  95, 115, 114,  99,  47, 102, 112, 101,  46, 112,  97,
115,   9,   9,  32,  69, 114, 114, 111, 114,  32,  35,  32,  11,  11,  32, 100,
101, 116, 101,  99, 116, 101, 100,  32,  33,  32,  32,  32,  82, 117, 110,  32,
 84, 105, 109, 101,  32,  76, 105,  98, 114,  97, 114, 121,  32, 109, 101, 115,
115,  97, 103, 101,  32, 105, 115,  32,  58,  32,  60,  14,  14, 116, 101, 115,
116,  95, 102, 112, 117,  95, 101, 114, 114, 111, 114,  13,  13,  32, 111, 112,
101,  44,  32,  97,  44,  32,  98,  32,  61,  32,  23,  23,  32,  80, 101, 114,
102, 111, 114, 109,  32, 116, 104, 101,  32, 111, 112, 101, 114,  97, 116, 105,
111, 110,  32,  22,  22,  32,  85, 110, 107, 110, 111, 119, 110,  32, 111, 112,
101, 114,  97, 116, 105, 111, 110,  32,  33,  33,  33,   3,   3,  32,  61,  32,
  3,   3,  32,  61,  32,   3,   3,  32,  61,  32,   3,   3,  32,  61,  32,   7,
  7,  32,  83,  81,  82,  84,  40,  32,   3,   3,  32,  41,  42,   3,   3,  32,
 61,  32,   5,   5,  32,  76,  78,  40,  32,   3,   3,  32,  41,  42,   3,   3,
 32,  61,  32,   5,   5,  32, 100, 105, 118,  32,   3,   3,  32,  61,  32,   3,
  3,  32,  42,  32,   3,   3,  32,  61,  32,  31,  31,  32,  72,  97, 110, 100,
108, 101, 114,  32,  97, 115,  32, 100, 101, 116, 101,  99, 116, 101, 100,  32,
 97, 110,  32,  69, 114, 114, 111, 114,  32,  33,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 32 );

static sigjmp_buf G_lb_env;

/* Declaration of external variables. */
extern V PAS__f_output;
extern V PAS__f_input;




/* Procedure/Function : " fpu_handler "  */
SL TEST_FPRROR_fpu_handler(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s;
  Ra.v[35]=Rd.s+13;
  Ra.sl[72]=15; /* line # 15 */
  Ra.ub[1]=0;
  PAS__GET_RTLMSG(F_ierr, Ra.s);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+65,-1,-1,32);
  PAS__WRITE_INT(F_ierr,0,0);
  PAS__WRITE_STR(Rd.s+76,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+89,-1,-1,32);
  PAS__WRITE_STR(Ra.s,-1,-1,32);
  PAS__WRITE_CHAR(62);
  PAS__WRITE_EOLN();
  siglongjmp(G_lb_env,1);
  Ra.sl[72]=20; /* line # 20 */
  Ret=0;
  PAS__curr_cntx=Ra.v[33];
  return(Ret);
}


/* Procedure/Function : " test_fpu_error "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register F Rgf;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  if (sigsetjmp(G_lb_env, 1 )) goto L_l_0;

  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+123;
  Rs.v[2]=Rd.s+13;
  Rs.sl[6]=25; /* line # 25 */
  PAS__ESTABLISH(TEST_FPRROR_fpu_handler);
L_l_1:
  while (1){
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+139,-1,-1,32);
    PAS__SELECT_INP(PAS__f_input);
    PAS__READ_STR(Ri.s,0,1);
    PAS__READ_SNGL(&Rv0,0);
    PAS__READ_SNGL(&Rv1,0);
    PAS__READ_EOLN();
    if (Ri.ub[1]>0)  break;
  }
  Rs.sl[6]=32; /* line # 32 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+154,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,16,-6,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(Ri.s,-1,-1,32);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_SNGL(Rv1,16,-6,0);
  PAS__WRITE_EOLN();
  switch (Ri.c[2]) {
    case 43:Rv2=Rv0+Rv1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_SNGL(Rv0,16,-6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv1,16,-6,0);
    PAS__WRITE_STR(Rd.s+203,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,16,-6,0);
    PAS__WRITE_EOLN();
    break;
    case 45:Rv2=Rv0-Rv1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_SNGL(Rv0,16,-6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv1,16,-6,0);
    PAS__WRITE_STR(Rd.s+208,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,16,-6,0);
    PAS__WRITE_EOLN();
    break;
    case 42:Rv2=Rv0*Rv1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_SNGL(Rv0,16,-6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv1,16,-6,0);
    PAS__WRITE_STR(Rd.s+213,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,16,-6,0);
    PAS__WRITE_EOLN();
    break;
    case 47:Rs.sl[6]=37; /* line # 37 */
    Rv2=Rv0/Rv1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_SNGL(Rv0,16,-6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(Rv1,16,-6,0);
    PAS__WRITE_STR(Rd.s+218,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,16,-6,0);
    PAS__WRITE_EOLN();
    break;
    case 83:
    case 115:Rv2=sqrt(Rv0)*Rv1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+223,-1,-1,32);
    PAS__WRITE_SNGL(Rv0,16,-6,0);
    PAS__WRITE_STR(Rd.s+232,-1,-1,32);
    PAS__WRITE_SNGL(Rv1,16,-6,0);
    PAS__WRITE_STR(Rd.s+237,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,16,-6,0);
    PAS__WRITE_EOLN();
    break;
    case 76:
    case 108:Rv2=log(Rv0)*Rv1;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+242,-1,-1,32);
    PAS__WRITE_SNGL(Rv0,16,-6,0);
    PAS__WRITE_STR(Rd.s+249,-1,-1,32);
    PAS__WRITE_SNGL(Rv1,16,-6,0);
    PAS__WRITE_STR(Rd.s+254,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,16,-6,0);
    PAS__WRITE_EOLN();
    break;
    case 68:
    case 100:Rs.sl[6]=44; /* line # 44 */
    Rv3=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
    Rv4=(Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5));
    Rv5=Rv3/Rv4;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv3,0,0);
    PAS__WRITE_STR(Rd.s+259,-1,-1,32);
    PAS__WRITE_INT(Rv4,0,0);
    PAS__WRITE_STR(Rd.s+266,-1,-1,32);
    PAS__WRITE_INT(Rv5,0,0);
    PAS__WRITE_EOLN();
    break;
    case 77:
    case 109:Rs.sl[6]=49; /* line # 49 */
    Rv3=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
    Rv4=(Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5));
    Rv5=Rv3*Rv4;
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv3,0,0);
    PAS__WRITE_STR(Rd.s+271,-1,-1,32);
    PAS__WRITE_INT(Rv4,0,0);
    PAS__WRITE_STR(Rd.s+276,-1,-1,32);
    PAS__WRITE_INT(Rv5,0,0);
    PAS__WRITE_EOLN();
    break;
    default:PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+179,-1,-1,32);
    PAS__WRITE_EOLN();
    break;
  }
  Rs.sl[6]=55; /* line # 55 */
  goto L_l_2;
  PAS__curr_cntx=Rs.s;
L_l_0:
  Rs.sl[6]=57; /* line # 57 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+281,-1,-1,32);
  PAS__WRITE_EOLN();
L_l_2:
  Rs.sl[6]=60; /* line # 60 */
  if (Rv0!=(F)-1.000000E+00) goto L_l_1;
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
