{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*       ---  Source Error Message Generator Environment  ---            *
*              ---  Version  3.1-B1 -- 31/07/2016 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
[inherit (   'LIB:BASIC_ENV_STR',	{ String manager }
             'LIB:BASIC_ENV_TXF',	{ Text file manager }
             'LIB:BASIC_ENV_LST'),	{ List file manager }
 environment('LIB:BASIC_ENV_SRC')]	{ Create the environment file }

module BASIC_ENV_SRC( input,output );	{ Use input and output }
*)

{ basic environment for source input operation }

{
    by :
	P. WOLFERS
	Laboratoire de cristallographie C.N.R.S.,
	B.P. 166 X 38042 GRENOBLE CEDEX
				 FRANCE


}

type

  err_filspc = string( 128 );           { Error file specificatrion string definition }

  error_sev = ( e_success,              { Severity degrees definition }
                e_warning,
                  e_error,
                 e_severe,
                  e_fatal
              );

  { Severity error count definion }
  error_tbcnt = array[e_success..e_fatal] of integer;


  { Module name definition }
  error_mdnam = packed array[1..4] of char;


  { Source error entry definition }
  error_entry = record
    err_pos,                            { Shift in char from the previous error on the same line }
    err_code:                  integer; { Error code }
    err_sv:                  error_sev; { Error severity }
    err_mdn:               error_mdnam; { Compiler/Task detector module name }
    err_msg:                   ^string  { Error message string address }
  end;


[external]
var

  usr_err_flg:                 boolean; { User error file setting flag }

  usr_err_file_spc,                     { User error message file specif. }
  msg_err_file_spc:         err_filspc; { Meaning error msg file specif. }

  error_result:              error_sev; { Final error severity }
  error_cnt:	           error_tbcnt; { Total error count }





{******************************************************}
{*********    Error managment procedures  *************}
{******************************************************}


procedure ERR_PUT_SYMBOL( in_var symb: packed array[len:integer] of char );
{ To specify a symbol to insert in the error message }
external;


procedure ERR_CLR_SYMBTAB;
{ To Clear the message symbol table }
external;


procedure ERR_GETMSG( var erren: error_entry );
{ To get an informative line related to the error code <n> }
{ No effect if the error entry is not find or if open fails }
external;




procedure ERR_DISPLAY( var f: text; ie: integer; var erren: error_entry );
{ Display one error message on the current listing file }
{ It is assumed that the message length is <= 80 characters }
external;



{*******************************************************}
{*********    common initialization routine    *********}
{*******************************************************}

procedure ERR_INIT( in_var errf_str: string );
{ Common command source initialization routine }
{ Must be called after lst_txf_st_init procedure(s).
  this call open the default listing file as current listing,
  here we assume that this current file is the output error message file.
}
external;



(*
end.
*)
