/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 272 ) = {
 15,  15, 112,  97, 115,  95,  95, 103, 101, 116,  95, 100, 111, 117,  98, 108,
101,  62,  62,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  50,  65,
 49,  47,  99, 112,  97, 115,  95,  95, 105, 111, 110, 117, 109,  46, 112,  97,
115,  11,  11, 114, 101,  97, 100,  95, 100, 111, 117,  98, 108, 101,  11,  11,
114, 101,  97, 100,  95, 115, 105, 110, 103, 108, 101,   8,   8, 114, 101,  97,
100,  95, 105, 110, 116,   7,   7, 114, 101,  97, 100,  95, 117, 108,   7,   7,
114, 101,  97, 100,  95, 115, 119,   7,   7, 114, 101,  97, 100,  95, 117, 119,
  7,   7, 114, 101,  97, 100,  95, 115,  98,   7,   7, 114, 101,  97, 100,  95,
117,  98,   9,   9, 119, 114, 105, 116, 101,  95, 117, 110, 115,   9,   9, 119,
114, 105, 116, 101,  95, 105, 110, 116,  11,  11, 112, 117, 116,  95, 100, 101,
 99, 105, 109,  97, 108,  11,  11, 115, 105, 122, 101,  95, 100, 111, 117,  98,
108, 101,  15,  15, 112,  97, 115,  95,  95, 112, 117, 116,  95, 101,  95, 100,
 98, 108, 101,  15,  15, 112,  97, 115,  95,  95, 112, 117, 116,  95, 102,  95,
100,  98, 108, 101,  10,  10, 119, 114, 105, 116, 101,  95, 100,  98, 108, 101,
 10,  10, 119, 114, 105, 116, 101,  95, 115, 110, 103, 108,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__curr_iptr;


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " pas__get_double "  */
void P_pas__get_double(G *F_fl, SL F_fld){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  SL Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  C Rv6;
  SL Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=96; /* line # 96 */
  Rv0=0.000000000000000E-001;
  Ra.sl[6]=97; /* line # 97 */
  Rv1=1.000000000000000E-001;
  Ra.sl[6]=98; /* line # 98 */
  Rv2=0;
  Ra.sl[6]=99; /* line # 99 */
  Rv3=0;
  Ra.sl[6]=100; /* line # 100 */
  Rv4=0;
  Ra.sl[6]=101; /* line # 101 */
  Rv5=0;
  while (1){
    Ra.sl[6]=104; /* line # 104 */
    if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
    Ra.sl[6]=105; /* line # 105 */
    if (PAS__CURR_EOF()||Rv5>0&&PAS__CURR_EOLN())  break;
    Ra.sl[6]=107; /* line # 107 */
    if (F_fld>=0) F_fld=F_fld-1;
    Ra.sl[6]=108; /* line # 108 */
    Rv6=((C *)((V *)PAS__curr_iptr)[0])[0];
    Ra.sl[6]=112; /* line # 112 */
    switch (Rv6) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:Ra.sl[6]=113; /* line # 113 */
      if (Rv5>0) goto L_l_0;
      break;
      case 43:
      case 45:Ra.sl[6]=116; /* line # 116 */
      switch (Rv5) {
        case 0:Ra.sl[6]=117; /* line # 117 */
        Rv5=1;
        if (Rv6==45) Rv3=1;
        break;
        case 4:Ra.sl[6]=118; /* line # 118 */
        Rv5=5;
        if (Rv6==45) Rv4=1;
        break;
        default:Ra.sl[6]=120; /* line # 120 */
        goto L_l_0;
        break;
      }
      break;
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:Ra.sl[6]=125; /* line # 125 */
      Rv7=(SL)Rv6-48;
      Ra.sl[6]=126; /* line # 126 */
      switch (Rv5) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=129; /* line # 129 */
        Rv0=Rv0*1.000000000000000E+001+(double)Rv7;
        Ra.sl[6]=130; /* line # 130 */
        if (Rv5<2) Rv5=2;
        break;
        case 3:Ra.sl[6]=132; /* line # 132 */
        Rv0=Rv0+Rv1*(double)Rv7;
        Rv1=Rv1*1.000000000000000E-001;
        break;
        case 4:
        case 5:Ra.sl[6]=135; /* line # 135 */
        Rv2=Rv2*10+Rv7;
        Ra.sl[6]=136; /* line # 136 */
        if (Rv5<5) Rv5=5;
        break;
        default:break;
      }
      break;
      case 46:Ra.sl[6]=142; /* line # 142 */
      if (Rv5<3) Rv5=3;
      else goto L_l_0;
      break;
      case 68:
      case 69:
      case 100:
      case 101:Ra.sl[6]=145; /* line # 145 */
      if (Rv5<4) {
        Ra.sl[6]=146; /* line # 146 */
        if (Rv5<2) Rv0=1.000000000000000E+000;
        Rv5=4;
      }
      else {
        Ra.sl[6]=147; /* line # 147 */
        goto L_l_0;
      }
      break;
      default:Ra.sl[6]=150; /* line # 150 */
      if (Rv5>0) goto L_l_0;
      Ra.sl[6]=151; /* line # 151 */
      PAS__ERROR(51);
      break;
    }
    Ra.sl[6]=153; /* line # 153 */
    PAS__GET(PAS__curr_iptr);
    if (F_fld==0)  break;
  }
L_l_0: ;
  Ra.sl[6]=156; /* line # 156 */
  if (Rv5==0) PAS__ERROR(51);
  Ra.sl[6]=159; /* line # 159 */
  if (Rv2!=0) {
    Ra.sl[6]=161; /* line # 161 */
    if (Rv4) Rv2= -Rv2;
    Ra.sl[6]=162; /* line # 162 */
    Rv0=Rv0*PAS__IGPOWER(1.000000000000000E+001,Rv2);
  }
  Ra.sl[6]=164; /* line # 164 */
  if (Rv3) Rv0=-Rv0;
  Ra.sl[6]=165; /* line # 165 */
  (*F_fl)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_double "  */
void PAS__READ_DBLE(G *F_fl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+81;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=173; /* line # 173 */
  P_pas__get_double(F_fl,F_f);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_single "  */
void PAS__READ_SNGL(F *F_fl, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=181; /* line # 181 */
  P_pas__get_double(&Rv0, F_f);
  Ra.sl[6]=182; /* line # 182 */
  (*F_fl)=(float)Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_int "  */
void PAS__READ_SL(SL *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=196; /* line # 196 */
  P_pas__get_double(&Rv0, F_f);
  Ra.sl[6]=197; /* line # 197 */
  (*F_iv)=(Rv0>0.0?(SL)(Rv0+0.5):(SL)(Rv0-0.5));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_ul "  */
void PAS__READ_UL(UL *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+117;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=205; /* line # 205 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_sw "  */
void PAS__READ_SW(SW *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+126;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=213; /* line # 213 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_uw "  */
void PAS__READ_UW(UW *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+135;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=221; /* line # 221 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_sb "  */
void PAS__READ_SB(SB *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+144;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=229; /* line # 229 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_ub "  */
void PAS__READ_UB(UB *F_iv, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+153;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=237; /* line # 237 */
  PAS__READ_SL(&Rv0, F_f);
  (*F_iv)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_uns "  */
void PAS__WRITE_UNS(UL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 96 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+162;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=254; /* line # 254 */
  Rv0=32;
  Ra.sl[6]=255; /* line # 255 */
  if (F_iv==0) {
    Ra.sl[6]=257; /* line # 257 */
    Ra.c[28]=48;
    Rv1=1;
  }
  else {
    Ra.sl[6]=261; /* line # 261 */
    if (F_b<2||F_b>16) F_b=10;
    Ra.sl[6]=262; /* line # 262 */
    Rv1=0;
    Ra.sl[6]=263; /* line # 263 */
    while (F_iv!=0){
      Ra.sl[6]=265; /* line # 265 */
      Rv1=Rv1+1;
      Ra.sl[6]=266; /* line # 266 */
      Rv2=F_iv%F_b;
      Ra.sl[6]=267; /* line # 267 */
      if (Rv2>9) {
        Ra.sl[6]=268; /* line # 268 */
        Ra.c[Rv1+27]=(C)((Rv2+65)-10);
      }
      else {
        Ra.sl[6]=270; /* line # 270 */
        Ra.c[Rv1+27]=(C)(Rv2+48);
      }
      Ra.sl[6]=271; /* line # 271 */
      F_iv=F_iv/F_b;
    }
  }
  Ra.sl[6]=274; /* line # 274 */
  if (F_f==0) F_f=Rv1;
  else {
    Ra.sl[6]=276; /* line # 276 */
    if (F_f<0) {
      Ra.sl[6]=278; /* line # 278 */
      Rv0=48;
      F_f= -F_f;
    }
  }
  Ra.sl[6]=280; /* line # 280 */
  Rv3=F_f-Rv1;
  Ra.sl[6]=281; /* line # 281 */
  if (Rv3>=0) {
    Ra.sl[6]=283; /* line # 283 */
    for( Rf0=Rv3;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    Ra.sl[6]=284; /* line # 284 */
    while (Rv1>0){
      Ra.sl[6]=286; /* line # 286 */
      PAS__WRITE_CHAR(Ra.c[Rv1+27]);
      Rv1=Rv1-1;
    }
  }
  else {
    Ra.sl[6]=290; /* line # 290 */
    for( Rf0=F_f;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_int "  */
void PAS__WRITE_INT(SL F_iv, SL F_f, SL F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 96 );

  /* Local variable stored in C variable */
  C Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+173;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=306; /* line # 306 */
  Rv0=32;
  Ra.sl[6]=307; /* line # 307 */
  if (F_iv==0) {
    Ra.sl[6]=309; /* line # 309 */
    Ra.c[28]=48;
    Rv1=1;
    Rv2=0;
  }
  else {
    Ra.sl[6]=313; /* line # 313 */
    Rv2=F_iv<0;
    Ra.sl[6]=314; /* line # 314 */
    if (F_b<2||F_b>16) F_b=10;
    Ra.sl[6]=315; /* line # 315 */
    Rv1=0;
    Ra.sl[6]=316; /* line # 316 */
    while (F_iv!=0){
      Ra.sl[6]=318; /* line # 318 */
      Rv1=Rv1+1;
      Ra.sl[6]=319; /* line # 319 */
      Rv3=abs(F_iv%F_b);
      Ra.sl[6]=320; /* line # 320 */
      if (Rv3>9) {
        Ra.sl[6]=321; /* line # 321 */
        Ra.c[Rv1+27]=(C)((Rv3+65)-10);
      }
      else {
        Ra.sl[6]=323; /* line # 323 */
        Ra.c[Rv1+27]=(C)(Rv3+48);
      }
      Ra.sl[6]=324; /* line # 324 */
      F_iv=F_iv/F_b;
    }
  }
  Ra.sl[6]=327; /* line # 327 */
  if (F_f==0) {
    Ra.sl[6]=328; /* line # 328 */
    F_f=Rv1+(SL)Rv2;
  }
  else {
    Ra.sl[6]=330; /* line # 330 */
    if (F_f<0) {
      Ra.sl[6]=332; /* line # 332 */
      Rv0=48;
      F_f= -F_f;
    }
  }
  Ra.sl[6]=334; /* line # 334 */
  Rv4=F_f-Rv1;
  Ra.sl[6]=335; /* line # 335 */
  if (Rv2) Rv4=Rv4-1;
  Ra.sl[6]=336; /* line # 336 */
  if (Rv4>=0) {
    Ra.sl[6]=338; /* line # 338 */
    if (Rv2&&Rv0==48) PAS__WRITE_CHAR(45);
    Ra.sl[6]=339; /* line # 339 */
    for( Rf0=Rv4;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv0);
    Ra.sl[6]=340; /* line # 340 */
    if (Rv2&&Rv0==32) PAS__WRITE_CHAR(45);
    Ra.sl[6]=341; /* line # 341 */
    while (Rv1>0){
      Ra.sl[6]=343; /* line # 343 */
      PAS__WRITE_CHAR(Ra.c[Rv1+27]);
      Rv1=Rv1-1;
    }
  }
  else {
    Ra.sl[6]=347; /* line # 347 */
    for( Rf0=F_f;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_decimal "  */
void CPAS__RWNUM_put_decimal(G F_dv, SL F_ndig, SL F_pent, UB F_bneg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+184;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=366; /* line # 366 */
  Rv0=1;
  Ra.sl[6]=367; /* line # 367 */
  while (F_ndig>0){
    Ra.sl[6]=369; /* line # 369 */
    Rv1=(int)(F_dv*1.000000000000000E+001);
    Ra.sl[6]=370; /* line # 370 */
    F_dv=F_dv*1.000000000000000E+001-(double)Rv1;
    Ra.sl[6]=371; /* line # 371 */
    if (Rv0) {
      Ra.sl[6]=372; /* line # 372 */
      if (Rv1==0&&F_pent>1) {
        Ra.sl[6]=373; /* line # 373 */
        PAS__WRITE_CHAR(32);
      }
      else {
        Ra.sl[6]=376; /* line # 376 */
        Rv0=0;
        Ra.sl[6]=377; /* line # 377 */
        if (F_bneg) PAS__WRITE_CHAR(45);
      }
    }
    Ra.sl[6]=381; /* line # 381 */
    if (!Rv0) PAS__WRITE_CHAR((C)(Rv1+48));
    Ra.sl[6]=382; /* line # 382 */
    F_ndig=F_ndig-1;
    Ra.sl[6]=383; /* line # 383 */
    F_pent=F_pent-1;
    Ra.sl[6]=385; /* line # 385 */
    if (F_pent==0&&F_ndig>0) PAS__WRITE_CHAR(46);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " size_double "  */
void CPAS__RWNUM_size_double(G *F_dv, SL *F_iexp, UB *F_bneg, UB F_bfix){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+197;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=399; /* line # 399 */
  if ((*F_dv)<0.000000000000000E-001) {
    Ra.sl[6]=401; /* line # 401 */
    (*F_dv)=-(*F_dv);
    Ra.sl[6]=402; /* line # 402 */
    (*F_bneg)=1;
  }
  else {
    Ra.sl[6]=404; /* line # 404 */
    (*F_bneg)=0;
  }
  Ra.sl[6]=405; /* line # 405 */
  if ((*F_dv)>0.000000000000000E-001) {
    Ra.sl[6]=407; /* line # 407 */
    (*F_iexp)=0;
    Rv0=(*F_dv);
    Ra.sl[6]=408; /* line # 408 */
    if ((*F_dv)>0.000000000000000E-001) {
      Ra.sl[6]=409; /* line # 409 */
      if ((*F_dv)>=1.000000000000000E+000) {
        Ra.sl[6]=410; /* line # 410 */
        while (Rv0>1.000000000000000E+000){
          Rv0=Rv0/1.000000000000000E+001;
          (*F_iexp)=(*F_iexp)+1;
        }
      }
      else {
        Ra.sl[6]=412; /* line # 412 */
        while (Rv0<1.000000000000000E-001){
          Rv0=Rv0*1.000000000000000E+001;
          (*F_iexp)=(*F_iexp)-1;
        }
      }
    }
    Ra.sl[6]=419; /* line # 419 */
    if (Rv0>=1.000000000000000E+000) {
      Ra.sl[6]=421; /* line # 421 */
      Rv0=Rv0*1.000000000000000E-001;
      (*F_iexp)=(*F_iexp)+1;
    }
    else {
      Ra.sl[6]=424; /* line # 424 */
      if (Rv0<1.000000000000000E-001) {
        Ra.sl[6]=426; /* line # 426 */
        Rv0=Rv0*1.000000000000000E+001;
        (*F_iexp)=(*F_iexp)-1;
      }
    }
    Ra.sl[6]=428; /* line # 428 */
    if (F_bfix&&(*F_iexp)<=0) (*F_dv)=(*F_dv)*1.000000000000000E-001;
    else {
      Ra.sl[6]=429; /* line # 429 */
      (*F_dv)=Rv0;
    }
  }
  else {
    Ra.sl[6]=431; /* line # 431 */
    (*F_iexp)=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pas__put_e_dble "  */
void P_pas__put_e_dble(G F_dv, SL F_fs, SL F_intsz, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UB Rv2;
  C Rv3;
  SL Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+210;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=447; /* line # 447 */
  F_es=abs(F_es);
  Ra.sl[6]=449; /* line # 449 */
  if (F_dcsz==-1) F_dcsz=7;
  else F_dcsz=abs(F_dcsz);
  Ra.sl[6]=450; /* line # 450 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[6]=451; /* line # 451 */
  if (F_fs<0) {
    Rv0=1;
    F_fs=abs(F_fs);
  }
  else {
    Ra.sl[6]=452; /* line # 452 */
    Rv0=0;
  }
  Ra.sl[6]=453; /* line # 453 */
  if (F_fs==0) F_fs=22;
  Ra.sl[6]=454; /* line # 454 */
  if (F_intsz<1) F_intsz=1;
  Ra.sl[6]=456; /* line # 456 */
  CPAS__RWNUM_size_double(&F_dv, &Rv1, &Rv2,0);
  Ra.sl[6]=460; /* line # 460 */
  Rv1=Rv1-F_intsz;
  Ra.sl[6]=462; /* line # 462 */
  if (Rv1>=0) Rv3=43;
  else {
    Ra.sl[6]=465; /* line # 465 */
    Rv1= -Rv1;
    Rv3=45;
  }
  Ra.sl[6]=468; /* line # 468 */
  if (Rv1<10) Rv4=2;
  else {
    Ra.sl[6]=469; /* line # 469 */
    if (Rv1<100) Rv4=3;
    else Rv4=4;
  }
  Ra.sl[6]=471; /* line # 471 */
  if (Rv4>F_es) F_es=Rv4;
  Ra.sl[6]=473; /* line # 473 */
  Rv5=F_dcsz>0;
  Ra.sl[6]=474; /* line # 474 */
  Rv6=(((((F_fs-F_dcsz)-F_es)-F_intsz)-(SL)Rv2)-2)-(SL)Rv5;
  Ra.sl[6]=475; /* line # 475 */
  if (Rv6<0) {
    Ra.sl[6]=478; /* line # 478 */
    if (Rv6<0&&Rv3==43) {
      Ra.sl[6]=480; /* line # 480 */
      Rv6=Rv6+1;
      Rv3=32;
    }
    Ra.sl[6]=483; /* line # 483 */
    while (F_es>Rv4&&Rv6<0){
      Ra.sl[6]=485; /* line # 485 */
      F_es=F_es-1;
      Rv6=Rv6+1;
    }
    Ra.sl[6]=488; /* line # 488 */
    if (Rv6<0&&F_dcsz>0) {
      Ra.sl[6]=490; /* line # 490 */
      Rv7=Rv6+F_dcsz;
      Ra.sl[6]=491; /* line # 491 */
      if (Rv7>0) {
        Ra.sl[6]=493; /* line # 493 */
        F_dcsz=Rv7;
        Rv6=0;
      }
      else {
        Ra.sl[6]=496; /* line # 496 */
        if (Rv7==-1&&Rv5) {
          Ra.sl[6]=498; /* line # 498 */
          F_dcsz=0;
          Rv6=0;
          Ra.sl[6]=499; /* line # 499 */
          Rv5=0;
        }
      }
    }
  }
  Ra.sl[6]=504; /* line # 504 */
  Rv8=F_dcsz+F_intsz;
  Ra.sl[6]=505; /* line # 505 */
  F_dv=F_dv+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
  Ra.sl[6]=506; /* line # 506 */
  if (F_dv>=1.000000000000000E+000) {
    Ra.sl[6]=508; /* line # 508 */
    F_dv=F_dv*1.000000000000000E-001;
    Ra.sl[6]=509; /* line # 509 */
    if (Rv3==45) {
      Ra.sl[6]=511; /* line # 511 */
      Rv1=Rv1-1;
      Ra.sl[6]=512; /* line # 512 */
      if (Rv1==0) Rv3=43;
    }
    else {
      Ra.sl[6]=516; /* line # 516 */
      Rv1=Rv1+1;
      Ra.sl[6]=517; /* line # 517 */
      if (Rv1>=10) {
        Ra.sl[6]=519; /* line # 519 */
        if (Rv3==43) {
          Ra.sl[6]=521; /* line # 521 */
          Rv3=32;
          Rv6=Rv6+1;
        }
        Ra.sl[6]=523; /* line # 523 */
        if (Rv1==10&&F_es==1) {
          Ra.sl[6]=524; /* line # 524 */
          F_es=2;
          Rv6=Rv6-1;
        }
        else {
          Ra.sl[6]=526; /* line # 526 */
          if (Rv1==100&&F_es==2) {
            Ra.sl[6]=527; /* line # 527 */
            F_es=3;
            Rv6=Rv6-1;
          }
        }
      }
      Ra.sl[6]=530; /* line # 530 */
      if (Rv6<0) {
        Ra.sl[6]=532; /* line # 532 */
        if (Rv8>1) {
          Ra.sl[6]=534; /* line # 534 */
          Rv8=Rv8-1;
          Ra.sl[6]=535; /* line # 535 */
          if (F_intsz<=Rv8) {
            Ra.sl[6]=537; /* line # 537 */
            if (Rv8==F_intsz) {
              Ra.sl[6]=539; /* line # 539 */
              Rv5=0;
              Rv6=Rv6+1;
            }
          }
          else {
            Ra.sl[6]=544; /* line # 544 */
            F_intsz=F_intsz-1;
            Ra.sl[6]=545; /* line # 545 */
            Rv1=Rv1+1;
          }
          Ra.sl[6]=547; /* line # 547 */
          Rv6=Rv6+1;
        }
      }
    }
  }
  Ra.sl[6]=553; /* line # 553 */
  if (Rv6<0) {
    Ra.sl[6]=554; /* line # 554 */
    for( Rf0=F_fs;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  else {
    Ra.sl[6]=557; /* line # 557 */
    if (Rv0) Rv6=0;
    Ra.sl[6]=558; /* line # 558 */
    if (Rv6>0) {
      Ra.sl[6]=559; /* line # 559 */
      for( Rf0=Rv6;Rf0>0;Rf0-- )
      PAS__WRITE_CHAR(32);
    }
    Ra.sl[6]=561; /* line # 561 */
    CPAS__RWNUM_put_decimal(F_dv, Rv8, F_intsz, Rv2);
    Ra.sl[6]=563; /* line # 563 */
    PAS__WRITE_CHAR(69);
    Ra.sl[6]=565; /* line # 565 */
    if (Rv3!=32) PAS__WRITE_CHAR(Rv3);
    Ra.sl[6]=567; /* line # 567 */
    PAS__WRITE_INT(Rv1, -F_es,10);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pas__put_f_dble "  */
void P_pas__put_f_dble(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  UB Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+227;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=584; /* line # 584 */
  if (F_dcsz==-1) F_dcsz=7;
  else {
    Ra.sl[6]=585; /* line # 585 */
    F_dcsz=abs(F_dcsz);
  }
  Ra.sl[6]=586; /* line # 586 */
  if (F_dcsz>20) F_dcsz=20;
  Ra.sl[6]=587; /* line # 587 */
  if (F_fs<0) F_fs=abs(F_fs);
  Ra.sl[6]=588; /* line # 588 */
  if (F_fs==0) F_fs=20;
  Ra.sl[6]=589; /* line # 589 */
  if (F_dcmin<0) F_dcmin=abs(F_dcmin);
  Ra.sl[6]=592; /* line # 592 */
  Rv0=F_dv;
  Ra.sl[6]=593; /* line # 593 */
  CPAS__RWNUM_size_double(&Rv0, &Rv1, &Rv2,1);
  Ra.sl[6]=596; /* line # 596 */
  if (Rv1>1) Rv3=Rv1;
  else {
    Ra.sl[6]=597; /* line # 597 */
    Rv3=1;
  }
  Ra.sl[6]=598; /* line # 598 */
  Rv4=F_dcsz>0;
  Ra.sl[6]=601; /* line # 601 */
  Rv5=(((F_fs-(SL)Rv2)-F_dcsz)-Rv3)-(SL)Rv4;
  Ra.sl[6]=603; /* line # 603 */
  Rv6=F_dcsz+Rv1;
  Ra.sl[6]=604; /* line # 604 */
  Rv7=F_dcsz;
  Ra.sl[6]=605; /* line # 605 */
  if ((Rv1<=0&&Rv6<F_dcmin)&&F_dcmin>0) {
    Ra.sl[6]=607; /* line # 607 */
    Rv7= -Rv1+F_dcmin;
    Ra.sl[6]=608; /* line # 608 */
    Rv5=((F_fs-Rv7)-2)-(SL)Rv2;
    Ra.sl[6]=609; /* line # 609 */
    if (!Rv4&&Rv7>0) {
      Ra.sl[6]=610; /* line # 610 */
      Rv5=Rv5-1;
      Rv4=1;
    }
  }
  else {
    Ra.sl[6]=614; /* line # 614 */
    if (Rv5<0) {
      Ra.sl[6]=616; /* line # 616 */
      Rv6=Rv5+Rv7;
      Ra.sl[6]=617; /* line # 617 */
      if (Rv6>=0) {
        Ra.sl[6]=619; /* line # 619 */
        Rv7=Rv6;
        Ra.sl[6]=620; /* line # 620 */
        if (Rv7>0) Rv5=0;
        else {
          Ra.sl[6]=622; /* line # 622 */
          Rv4=0;
          Rv5=1;
        }
      }
      else {
        Ra.sl[6]=625; /* line # 625 */
        if (Rv6==-1&&Rv4) {
          Ra.sl[6]=627; /* line # 627 */
          Rv7=0;
          Rv5=0;
          Ra.sl[6]=628; /* line # 628 */
          Rv4=0;
        }
      }
    }
  }
  Ra.sl[6]=633; /* line # 633 */
  if (Rv5>=0) {
    Ra.sl[6]=635; /* line # 635 */
    Rv8=Rv3+Rv7;
    Ra.sl[6]=636; /* line # 636 */
    Rv0=Rv0+5.000000000000000E-001*PAS__IGPOWER(1.000000000000000E+001, -Rv8);
    Ra.sl[6]=637; /* line # 637 */
    if (Rv0>=1.000000000000000E+000) {
      Ra.sl[6]=639; /* line # 639 */
      Rv0=Rv0*1.000000000000000E-001;
      Ra.sl[6]=640; /* line # 640 */
      Rv3=Rv3+1;
      Ra.sl[6]=641; /* line # 641 */
      Rv5=Rv5-1;
      Rv8=Rv8+1;
    }
  }
  Ra.sl[6]=646; /* line # 646 */
  if (Rv5<0) {
    Ra.sl[6]=647; /* line # 647 */
    P_pas__put_e_dble(F_dv, F_fs,1, F_dcsz,0);
  }
  else {
    Ra.sl[6]=651; /* line # 651 */
    for( Rf0=Rv5;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(32);
    Ra.sl[6]=653; /* line # 653 */
    CPAS__RWNUM_put_decimal(Rv0, Rv8, Rv3, Rv2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_dble "  */
void PAS__WRITE_DBLE(G F_fl, SL F_f, SL F_d, SL F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+244;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=661; /* line # 661 */
  if (F_f==0) F_f=-22;
  Ra.sl[6]=662; /* line # 662 */
  if (F_d<0||F_f<0) {
    Ra.sl[6]=663; /* line # 663 */
    P_pas__put_e_dble(F_fl, F_f,1, F_d,3);
  }
  else {
    Ra.sl[6]=664; /* line # 664 */
    P_pas__put_f_dble(F_fl, F_f, F_d, F_s);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_sngl "  */
void PAS__WRITE_SNGL(F F_fl, SL F_f, SL F_d, SL F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+256;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=671; /* line # 671 */
  if (F_f==0) F_f=-16;
  Ra.sl[6]=672; /* line # 672 */
  if (F_d<0||F_f<0) {
    Ra.sl[6]=673; /* line # 673 */
    P_pas__put_e_dble((double)F_fl, F_f,1, F_d,2);
  }
  else {
    Ra.sl[6]=674; /* line # 674 */
    P_pas__put_f_dble((double)F_fl, F_f, F_d, F_s);
  }
  PAS__curr_cntx=Ra.v[0];
}
