{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                    ---  RUN-TIME KERNEL  ---                          *
*       ---  Large String management Library Environment  ---           *
*              ---  Version  2.0--0 -- 31/03/2006 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
module cpas__dyn_string;
*)

const
  dstr_maxsize   =     word_natural"last;      { Define the maximum size of a long string }
  dstr_capacity  =  2*$wild_pointer"size;      { Define the Capacity when the string is in the lstring descriptor }

type
  dstr_array = packed array[word_natural] of char;

  dstr_rec( cap: word_natural ) = record       { * dstring container record definition * }
                 nuse: word_unsigned;          { Number of string reference }
                 chtb: packed array[1..cap] of char    { The charactere table }
               end;

  { Define the local string body array (for string length <= dstr_capacity) }
  dstr_locstr = packed array[1..dstr_capacity] of char;

  dstr_aptr   =   ^dstr_array;                 { Define the Acces Pointer type of Character Array }

  dstr_rptr   =     ^dstr_rec;                 { Define the Acces Pointer type of String Container }

  dstr_flgty  = (    dstr_loc,                 { String is Local (for length <= dstr_capacity) }
                     dstr_fix,                 { String container has a fixed size (and should not be freed) }
                     dstr_tmp,                 { String is temporary }
                     dstr_srf,                 { String is a sub-reference }
                     dstr_nfr,                 { String is link to not free-able array of char (it is not necessarly a container) }
                     dstr_ovr,                 { String Reference Overflow flag }
                     dstr_ovs                  { String Size Overflow flag }
                );

  dstr_sflags = set of dstr_flgty use 16,16;   { Flags set type (forced to use two bytes /one word/) }

  dstr = record                                { * Large String Descriptor Definition Record * }
    length:        word_unsigned;              { Length of the string }
    flags:     set of dstr_flgty;              { String Flags }
    case boolean of
      false:( body:  dstr_locstr);             { Local (For Short String) string body }
      true: ( arr:     dstr_aptr;              { Table of character Access Pointer }
              rec:     dstr_rptr)              { String Container Access Pointer }
  end
       := [0, [dstr_tmp], true, nil, nil];

  dstring = new dst := [0, [dstr_tmp], true, nil, nil];{ The Long string type is a variant of dstr type }
  lstring = new dst := [0, [], true, nil, nil];{ The Long string type is a variant of dstr type }


const
  dstring_empty = dstring[0, [dstr_tmp], true, nil, nil];      { Empty dstring }
  lstring_empty = lstring[0, [], true, nil, nil];              { Empty lstring }


procedure LSTRING_CREATE( var st: dstr; size: integer := 0; btmp, bfix: boolean := false );
external 'PAS_DSTR__CREATE';

procedure LSTRING_FREE( var str: lstring );
external 'PAS_DSTR__FREE';


function  LSTRING( ch: char; btmp: boolean := false ): dstr;
external 'PAS_DSTR__STRING_C';

function  LSTRING( in_var strg: string; i, j: integer := 0; btmp: boolean := false ): dstr;
external 'PAS_DSTR__STRING_S';

function  LSTRING( in_var strg: packed array[sz: integer] of char; i, j: integer := 0; btmp: boolean := false
                 ): dstr; external 'PAS_DSTR__STRING_A';

function  SUBSTR( str: dstr; i, j: integer := 0 ): dstr;
external 'PAS_DSTR__SUBSTR'; { The dstring SUBSTR function }

procedure LSTRING_COPY( var dst, src: dstr ); external 'PAS_DSTR__COPY';

procedure PAS$$SELECT_INP( var st: dstr; var ip: [optional] integer ); external 'PAS_DSTR__SEL_INPUT';
procedure PAS$$SELECT_OUT( var st: dstr; bini: boolean := true ); external 'PAS_DSTR__SEL_OUTPUT';

procedure READ$OBJECT(  var st: dstr; var ip: integer; asz: integer := 255 ); external 'PAS_DSTR__READ';
procedure WRITE$OBJECT( var st: dstr; f, p: integer := -1; sp: char := ' ' ); external 'PAS_DSTR__WRITE';

function  || ( var s1, s2: dstr ): dstr; external 'PAS_DSTR__CONCAT_LL';
function  || ( var s1: dstr; c2: char ): dstr; external 'PAS_DSTR__CONCAT_LC';
function  || ( var s1: dstr; var st: string ): dstr; external 'PAS_DSTR__CONCAT_LS';
function  || ( var s1: dstr; in_var a2: packed array[sz: integer] of char ): dstr; external 'PAS_DSTR__CONCAT_LA';
function  || ( var c1: char; s2: dstr ): dstr; external 'PAS_DSTR__CONCAT_CL';
function  || ( var st: string; var s2: dstr ): dstr; external 'PAS_DSTR__CONCAT_SL';
function  || ( in_var a1: packed array[sz: integer] of char; var s2: dstr ): dstr; external 'PAS_DSTR__CONCAT_AL';

function  GET_CHAR( in_var src: dstr; i: integer ): char; external 'PAS_DSTR__GET_CHAR';

function  INDEX( var st: dstr; ch: char ): integer; external 'PAS_DSTR__INDEX_LC';

function  INDEX( var s1, s2: dstr ): integer; external 'PAS_DSTR__INDEX_LL';

function  INDEX( var s1: lstring; in_var sa: packed array[sz: integer] of char ): integer;
external 'PAS_DSTR__INDEX_LA';

function  NINDEX( var st: dstr; ch: char; nb: integer; ip: integer := -1; nc: boolean := true ): integer;
external 'PAS_DSTR__NINDEX_LC';

function  NINDEX( var s1, s2: dstr; nb: integer; ip: integer := -1; nc: boolean := true ): integer;
external 'PAS_DSTR__NINDEX_LL';

function  NINDEX( var s1: dstr; in_var sa: packed array[sz: integer] of char;
                  nb: integer; ip: integer := -1; nc: boolean := true ): integer;
external 'PAS_DSTR__NINDEX_LA';


function LENGTH( var s: dstr ): integer; external 'PAS__DSTR_LENGTH';


function MATCH( var s1, s2: dstr ): integer; external 'PAS__DSTR_MATCH_LL';

function MATCH( var s1: dstr; in_var sa: packed array[sz: integer] of char ): integer;
external 'PAS__DSTR_MATCH_LA';

function MATCH( in_var sa: packed array[sz: integer] of char; var  s2: dstr ): integer;
external 'PAS__DSTR_MATCH_AL';

function MATCH( var s1: dstr; in_var st: string ): integer; external 'PAS__DSTR_MATCH_LS';

function MATCH( in_var st: string; var s2: dstr ): integer; external 'PAS__DSTR_MATCH_SL';


procedure STRING_LOCATE_SEP( var st: dstr; var sp: packed array[sz: integer] of char;
                             var tp: array[nsp:integer] of byte; var ie: integer );
external 'PAS_DSTR__LSEP_LA';


function <  ( var s1, s2: dstr ): boolean; external 'PAS_DSTR__LT_CHLL';
function <= ( var s1, s2: dstr ): boolean; external 'PAS_DSTR__LE_CHLL';
function >= ( var s1, s2: dstr ): boolean; external 'PAS_DSTR__GE_CHLL';
function >  ( var s1, s2: dstr ): boolean; external 'PAS_DSTR__GT_CHLL';
function =  ( var s1, s2: dstr ): boolean; external 'PAS_DSTR__EQ_CHLL';
function <> ( var s1, s2: dstr ): boolean; external 'PAS_DSTR__NE_CHLL';


procedure := ( var trg: lstring; src: char ); external 'PAS_DSTR__ASSIGN_LC';
procedure := ( var trg: lstring; in_var src: packed array[sz: integer] of char ); external 'PAS_DSTR__ASSIGN_LA';
procedure := ( var trg: lstring; in_var src: string ); external 'PAS_DSTR__ASSIGN_LS';
procedure := ( var trg: lstring; var src: dstr ); external 'PAS_DSTR__ASSIGN_LL';
procedure := ( var trg: string; src: dstr ); external 'PAS_DSTR__ASSIGN_SL';
procedure := ( var trg: packed array[sz: integer] of char; src: dstr ); external 'PAS_DSTR__ASSIGN_AL';


(*
end.
*)
