/*  P A S - P. WOLFERS SOFTWARE: V3.1-A4 OF 15-DEC-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 184 ) = {
 13,  13, 114, 101,  97, 100,  95, 108, 111, 110, 103,  95, 118,  97, 108,  65,
 65,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111,
102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97,
115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  65,  52,  99,
 47,  99, 112,  97, 115,  95,  95, 105, 111, 108, 103, 110, 117, 109,  46, 112,
 97, 115,  18,  18, 114, 101,  97, 100,  95, 108, 111, 110, 103,  95, 117, 110,
115, 105, 103, 110, 101, 100,  17,  17, 114, 101,  97, 100,  95, 108, 111, 110,
103,  95, 105, 110, 116, 101, 103, 101, 114,  14,  14, 119, 114, 105, 116, 101,
 95, 108, 111, 110, 103,  95, 118,  97, 108,  19,  19, 119, 114, 105, 116, 101,
 95, 108, 111, 110, 103,  95, 117, 110, 115, 105, 103, 110, 101, 100,  18,  18,
119, 114, 105, 116, 101,  95, 108, 111, 110, 103,  95, 105, 110, 116, 101, 103,
101, 114,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__curr_iptr;




/* Procedure/Function : " read_long_val "  */
void PAS__QUD_IO_read_long_val(V F_lv, SL F_fld, UB F_base, UB F_bs, UB F_bu){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  C Rv6;

  /* Code of procedure/function */
  Rv0=0;
  Rv1=0;
  Rv2=0;
  Rv3=0;
  Rv4=0;
  Rv5=0;
  while (1){
    Ra.v[0]=PAS__curr_cntx;
    PAS__curr_cntx=Ra.s;
    Ra.v[1]=Rd.s;
    Ra.v[2]=Rd.s+15;
    Ra.sl[6]=105; /* line # 105 */
    if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
    if (PAS__CURR_EOF()||Rv0>0&&PAS__CURR_EOLN())  break;
    Rv6=((C *)((V *)PAS__curr_iptr)[0])[0];
    if (Rv6>=97&&Rv6<=102) Rv6=(C)((SL)Rv6-32);
    if (Rv0<2) {
      Ra.sl[6]=110; /* line # 110 */
      switch (Rv6) {
        case 95:if (!F_bs) Rv0=2;
        break;
        case 43:
        case 45:Ra.sl[6]=115; /* line # 115 */
        if (Rv0==0) {
          if (Rv6==45) {
            if (F_bu) {
              Rv0=2;
              Rv1=1;
            }
            else {
              Rv0=1;
              Rv2=1;
            }
          }
        }
        else {
          Ra.sl[6]=121; /* line # 121 */
          Rv0=2;
        }
        break;
        case 48:
        case 49:
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 57:
        case 65:
        case 66:
        case 67:
        case 68:
        case 69:
        case 70:Ra.sl[6]=126; /* line # 126 */
        if (Rv6>57) Rv3=((SL)Rv6-65)+10;
        else Rv3=(SL)Rv6-48;
        if (Rv3>=F_base) Rv0=2;
        else {
          Ra.sl[6]=131; /* line # 131 */
          Rv0=1;
          if (Rv3>0||Rv4>0) {
            if (F_bu) ((UQ *)F_lv)[0]=((UQ *)F_lv)[0]*F_base+Rv3;
            else {
              Ra.sl[6]=136; /* line # 136 */
              ((SQ *)F_lv)[0]=((SQ *)F_lv)[0]*F_base+Rv3;
            }
            Rv4=Rv4+1;
          }
        }
        break;
        default:Ra.sl[6]=143; /* line # 143 */
        if (Rv0>0) Rv0=2;
        break;
      }
    }
    Rv5=Rv5+1;
    if (Rv5==F_fld||F_fld==0&&Rv0==2)  break;
  }
  if (F_bu) {
    if (Rv2) ((SQ *)F_lv)[0]= -((SQ *)F_lv)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_long_unsigned "  */
void PAS__READ_LUNS(UQ *F_lv, SL F_fld, UB F_base, UB F_bs){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+82;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=163; /* line # 163 */
  PAS__QUD_IO_read_long_val(Ra.s+28,F_fld, F_base, F_bs,1);
  (*F_lv)=Ra.uq[3];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_long_integer "  */
void PAS__READ_LINT(SQ *F_lv, SL F_fld, UB F_base, UB F_bs){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+102;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=179; /* line # 179 */
  PAS__QUD_IO_read_long_val(Ra.s+28,F_fld, F_base, F_bs,0);
  (*F_lv)=Ra.sq[3];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_long_val "  */
void PAS__QUD_IO_write_long_val(V F_lv, SL F_fld, UB F_base, UB F_frq, C F_sch, 
UB F_bu){
  /* Define the automatic variable space. */
  Blk( Ra, 104 );

  /* Local variable stored in C variable */
  UB Rv0;
  C Rv1;
  SL Rv2;
  SL Rv3;
  SQ Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+93,F_lv,8);
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=195; /* line # 195 */
  Rv1=32;
  if (Ra.sq[11]==0) {
    Ra.sl[6]=200; /* line # 200 */
    Ra.c[28]=48;
    Rv2=1;
    Rv0=0;
  }
  else {
    if (!F_bu) {
      if (Ra.sq[11]<0) Rv0=1;
    }
    Ra.sl[6]=205; /* line # 205 */
    if (F_base<2||F_base>16) F_base=10;
    if (F_bu) {
      Rv3=abs(Ra.uq[11]%F_base);
      Rv4=Ra.uq[11]/F_base;
    }
    else {
      Rv3=abs(Ra.uq[11]%F_base);
      Rv4=Ra.sq[11]/F_base;
    }
    if (Rv3>9) Ra.c[28]=(C)((Rv3+65)-10);
    else Ra.c[28]=(C)(Rv3+48);
    Ra.sl[6]=210; /* line # 210 */
    Rv2=1;
    Rv5=1;
    while (Rv4!=0){
      if (Rv5==F_frq) {
        Ra.c[Rv2+27]=F_sch;
        Rv2=Rv2+1;
        Rv5=0;
      }
      Ra.sl[6]=215; /* line # 215 */
      Rv2=Rv2+1;
      Rv5=Rv5+1;
      Rv3=abs(Rv4%F_base);
      if (Rv3>9) Ra.c[Rv2+27]=(C)((Rv3+65)-10);
      else {
        Ra.sl[6]=220; /* line # 220 */
        Ra.c[Rv2+27]=(C)(Rv3+48);
      }
      Rv4=Rv4/F_base;
    }
  }
  if (F_fld==0) {
    Ra.sl[6]=225; /* line # 225 */
    F_fld=Rv2+(SL)Rv0;
  }
  else {
    if (F_fld<0) {
      Rv1=48;
      F_fld= -F_fld;
    }
  }
  Ra.sl[6]=231; /* line # 231 */
  Rv6=F_fld-Rv2;
  if (Rv0) Rv6=Rv6-1;
  if (Rv6>=0) {
    if (Rv0&&Rv1==48) PAS__WRITE_CHAR(45);
    Ra.sl[6]=236; /* line # 236 */
    for( Rf0=Rv6;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv1);
    if (Rv0&&Rv1==32) PAS__WRITE_CHAR(45);
    while (Rv2>0){
      PAS__WRITE_CHAR(Ra.c[Rv2+27]);
      Rv2=Rv2-1;
    }
  }
  else {
    Ra.sl[6]=244; /* line # 244 */
    for( Rf0=F_fld;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(42);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_long_unsigned "  */
void PAS__WRITE_LUNS(UQ F_lv, SL F_f, UB F_ba, UB F_fr, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+137;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=261; /* line # 261 */
  Ra.uq[3]=F_lv;
  PAS__QUD_IO_write_long_val(Ra.s+28,F_f, F_ba, F_fr, F_ch,1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_long_integer "  */
void PAS__WRITE_LINT(SQ F_lv, SL F_f, UB F_ba, UB F_fr, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+158;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=278; /* line # 278 */
  Ra.sq[3]=F_lv;
  PAS__QUD_IO_write_long_val(Ra.s+28,F_f, F_ba, F_fr, F_ch,0);
  PAS__curr_cntx=Ra.v[0];
}
