#
#  To Define/select the related target directory of CPAS installation.
#
# DIR_NAM is the related KIT directory logical name (ex: MXD).
# DIR_ENV is the related KIT Environment when it is different DIR_NAM.
# PAS_DIR is the deduced Pascal Environnement directory (ex: /usr/local/cpas).
# INC_DIR is the deduced Pascal Include directory (ex: /usr/local/include).
# KIT_DIR is the deduced KIT target directory (ex: /usr/local/mxd).
# ENV_DIR is the deduced KIT environment directory (ex: /usr/local/mxd).
#
# Example of setting:
#   DIR_NAM="mxd"
#  as result KIT_DIR is the selected directory (ex: /usr/local/mxd )
#  and KIT_ENV = KIT_DIR.
#
#
#  *** Set The Local Directory to use for the product ***
#
DEF_TREE="$USR_LOCAL"
if ! test $DEF_TREE
then
  DEF_TREE="/usr/local"
fi
echo -n " Give the local target Directory [default is $DEF_TREE] "
read LOCAL_DIR
if ! test "$LOCAL_DIR"
then
  LOCAL_DIR="$DEF_TREE"
fi
if ! test -d "$LOCAL_DIR"
then
  echo -n " Do you want create it (Possible answerd Y/N) [default is Y] "
  read REP
  if test "$REP" = "n"
  then
    REP = "N"
  fi
  if test "$REP" = "N"
  then
#
# Error the local directories does not exit and do not create it.
#
    echo "$LOCAL_DIR cannot be found or created."
    exit 2
  fi
  mkdir $LOCAL_DIR
  echo " The $DIR_NAM target product directory $LOCAL_DIR is created."
fi
export LOCAL_DIR
#
#  *** Set The Local Directory for the currently installed CPAS ***
#
if test "$DIR_NAM" = "cpas"
then
#   When the Product to install is a CPAS product (cpas_lib or cpas).
  PAS_TREE="$LOCAL_DIR"
  PAS_DIR="$PAS_TREE/cpas"
  PAS_INC="$PAS_TREE/include"
  PAS_LIB="$PAS_TREE/lib"
else
  if test "$LOCAL_DIR" != "$DEF_TREE"
  then
    if test "$CPAS_TREE"
    then
      DEF_TREE="$CPAS_TREE"
    fi
    echo -n " Give the C-Pascal Directory to use [default is $DEF_TREE] "
    read PAS_TREE
    if ! test "$PAS_TREE"
    then
      PAS_TREE="$DEF_TREE"
    fi
  else
    PAS_TREE="$LOCAL_DIR"
  fi
  PAS_DIR="$PAS_TREE/cpas"
  PAS_INC="$PAS_TREE/include"
  PAS_LIB="$PAS_TREE/lib"
  if ! test -d "$PAS_DIR" -a -e "$PAS_INC/cpas_defs.h" -a -e "$PAS_LIB/libcpas.a"
  then
    echo " The $PAS_DIR directory does not exit, or"
    echo " the $PAS_LIB/libcpas.a Pascal Library does not exit, or"
    echo " the $PAS_INC/cpas_defs.h file does not exist. => Stop Installation."
    exit 2
  fi
fi
export PAS_TREE
export PAS_DIR
export PAS_INC
export PAS_LIB
#
#  *** Set The current CPAS_LIB definition for PASLIB_VER ***
#
if test -e "$PAS_DIR/cpas_lib_version.sh"
then
  . "$PAS_DIR"/cpas_lib_version.sh
else
  PASLIB_VER="V1"
fi
export PASLIB_VER
#
#
#  *** Set The KIT_DIR, LIB_DIR, BIN_DIR, INC_DIR and ENV_DIR definitions ***
#
echo " We use the directory $LOCAL_DIR."
#
if test "$DIR_NAM"
then
  KIT_DIR="$LOCAL_DIR/$DIR_NAM"
  if ! test -d "$KIT_DIR" 
  then
    mkdir "$KIT_DIR"
    echo " The $DIR_NAM product directory $KIT_DIR is created."
  else
    echo " The $DIR_NAM product directory is $KIT_DIR."
  fi
  export KIT_DIR
fi
#
LIB_DIR="$LOCAL_DIR/lib"
if ! test -d "$LIB_DIR" 
then
  mkdir "$LIB_DIR"
  echo " The library directory $LIB_DIR is created."
else
  echo " The library directory is $LIB_DIR."
fi
export LIB_DIR
#
BIN_DIR="$LOCAL_DIR/bin"
if ! test -d "$BIN_DIR" 
then
  mkdir "$BIN_DIR"
  echo " The binary directory $BIN_DIR is created."
else
  echo " The binary directory is $BIN_DIR."
fi
export BIN_DIR
#
INC_DIR="$LOCAL_DIR/include"
if ! test -d $INC_DIR 
then
  mkdir $INC_DIR
  echo " The include directory $INC_DIR is created."
else
  echo " The include directory is $INC_DIR."
fi
export INC_DIR
#
if test "$DIR_ENV"
then
  ENV_DIR="$LOCAL_DIR/$DIR_ENV"
  if ! test -d "$ENV_DIR" 
  then
    mkdir "$ENV_DIR"
    echo " The environment directory $ENV_DIR is created."
  fi
else
  ENV_DIR="$KIT_DIR"
fi
if test "$ENV_DIR"
then
  echo " The environment directory is $ENV_DIR."
  export "ENV_DIR"
fi
#

