{%pragma trace 1; debug_on;}
program ESSAI_0;
type
  real = single;

  tbty( lwl, hgl: integer ) = array[lwl..hgl] of real;

  ptb = ^tbty;

var
  i,j: integer;

  tab: tbty(1,10);
    p: ptb;

function err_hdl( ierr: cc__int ): cc__int;
var
  msg: string( 128 ) := '';

begin
  WRITELN( err, 'L''erreur # ', ierr, ' a ete detectee.' );
  GET_RTL_MESSAGE( ierr, msg );
  if msg.length > 0 then
    WRITELN( ' The RTL msg is "', msg, '".' );
  err_hdl := 1 { The execution must continue. }
(*
  err_hdl := -1
*)
end err_hdl;


  procedure FILL_TAB( var tb: tbty );
  var
    n, m: integer;

  begin
    m := tb.lwl - tb.hgl + 1;
    for i := tb.lwl+1 to tb.hgl do
      tb[i] := (i - tb.lwl)/m;
  end FILL_TAB;

  procedure TEST_RANGE( in_var tb: tbty; d, e: integer := -100 );
  begin
    if d = -100 then d := tb.lwl;
    if e = -100 then e := tb.hgl;
    for i := d to e do
    begin
      WRITELN( ' Table[', i:-3, '] = ', tb[i] )
    end 
  end TEST_RANGE;


begin { main }
  FILL_TAB( tab );
  NEW( p, -3, 3 );
  FILL_TAB( p^ );

  establish( err_hdl );

  TEST_RANGE( tab );
  WRITELN( ' Test Range Error for 11 and 12' );
  TEST_RANGE( tab, 8, 12 );
  TEST_RANGE( p^ );
  WRITELN( ' Test Range Error for -4, 4 and 5' );
  TEST_RANGE( p^, -4, 5 )

end { ESSAI_1 }.
