

program String_Table;

type
    TabString( n: integer; c: byte ) = array[1..n] of string( c );

    TbSt_4_14 = TabString( 4, 14 );


const
    Month = TabString[ 12, 12, 'Janvier',
                               'Février',
                               'Mars',
                               'Avril',
                               'Mai',
                               'Juin',
                               'Juillet',
                               'Août',
                               'Septembre',
                               'Octobre',
                               'Novembre',
                               'Décembre'
                     ];


var
    Jours: TabString( 7, 14) := [   'lundi',
                                    'mardi',
                                    'mercredi',
                                    'jeudi',
                                    'vendredi',
                                    'samedi',
                                    'dimanche'
                                ];

    Saisons: TbSt_4_14;


begin
    {                            123456789ABCDEF}
    Jours[1] := 'LUNDI';

    Saisons := TbSt_4_14[ 'Printemps',
                          'Eté',
                          'Automne',
                          'Hiver'
                        ];

    WRITELN( "\n Liste des saisons d'une année :" );
    for i := 1 to Saisons.n do
        WRITELN( ' Mois # ', i:0, '/ ', Saisons[i] );


    WRITELN( "\n Liste des mois de l'année :" );
    for i := 1 to Month.n do
        WRITELN( ' Mois # ', i:2, '/ ', Month[i] );

    WRITELN( "\n Liste des jours de la semaine :" );
    for i := 1 to Jours.n do
        WRITELN( ' Jour # ', i:0, '/ "', Jours[i], '"' );


end String_Table.
