/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 432 ) = {{
 10,  10,  79,  95,  36, 111, 112, 101,  95,  97, 115, 115,  65,  65,  47, 104,
111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47, 116,
101, 115, 116,  95, 115,  99, 104, 101, 109, 101,  50,  46, 112,  97, 115,  11,
 11,  79,  95,  36, 111, 112, 101,  95, 109, 117, 108, 116,   9,   9, 116, 114,
 97, 110, 115, 112, 111, 115, 101,  10,  10,  79,  95,  36, 111, 112, 101,  95,
 97, 115, 115,  10,  10, 115, 111, 109,  95, 109,  97, 116, 114, 105, 120,   9,
  9,  32,  83,  79,  77,  77,  69,  32,  61,  32,  12,  12, 119, 114, 105, 116,
101,  36, 111,  98, 106, 101,  99, 116,   2,   2, 124,  32,   2,   2,  44,  32,
  2,   2,  32, 124,   8,   8, 109,  97, 116, 104, 119, 111, 114, 107,   0,   0,
  2,   0,   0,   0,   2,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   1,   0,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,
  0,   0,   0,   0, 255, 255, 255, 255,   1,   0,   0,   0,   0,   0,   0,   0,
  3,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  14,  14,   9,  32,
109, 120,  32, 105, 110, 105, 116, 105,  97, 108,  32,  91,   2,   2,  46,  46,
  4,   4,  93,  32,  58,  10,  21,  21,  32,  82, 101, 115, 117, 108, 116,  97,
116,  32, 100,  97, 110, 115,  32, 112, 109,  94,  32,  58,  10,  10,  10,  32,
 77,  97, 116, 114, 105,  99, 101,  32,  91,   2,   2,  93,  10,  22,  22,  32,
 77,  97, 116, 114, 105,  99, 101,  32, 116, 114,  97, 110, 115, 112, 111, 115,
195, 169, 101,  32,  91,   2,   2,  93,  10,  11,  11, 116, 101, 115, 116,  95,
115,  99, 104, 101, 109, 101,  11,  11,  10,  32,  32,  32,  32,  32, 109,  48,
 32,  61,  10,   2,   2,  10,  10,  12,  12,  10,  32,  32,  32,  32,  32, 109,
120, 121,  32,  61,  10,   2,   2,  10,  10,  11,  11,  10,  32,  32,  32,  32,
 32, 109,  49,  32,  61,  10,   2,   2,  10,  10,   0,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 80 ) = {{
  2,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,
  3,   0,   0,   0,   4,   0,   0,   0,   5,   0,   0,   0,   6,   0,   0,   0,
  3,   0,   0,   0,   2,   0,   0,   0,   1,   0,   0,   0,   2,   0,   0,   0,
  3,   0,   0,   0,   5,   0,   0,   0,   8,   0,   0,   0,  13,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 32 );

/* Declaration of external variables. */
extern V PAS__f_output;




/* Procedure/Function :  TEST_SCHEME_PRC_00000000*/
void TEST_SCHEME_PRC_00000000(V F_tg, V F_sr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=31; /* line # 31 */
  Rv0=1;
  for( Rf1=2;Rf1>0;Rf1-- ) {
    Rv1=1;
    for( Rf0=2;Rf0>0;Rf0-- ) {
      ((SL *)F_tg)[Rv0*2+Rv1-1]=((SL *)F_sr)[Rv0*2+Rv1-1];
      Rv1++;
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function :  TEST_SCHEME_PRC_00000001*/
V TEST_SCHEME_PRC_00000001(V Ret, V F_mb, V F_mc){
  /* Define the automatic variable space. */
  Blk( Ra, 104 );

  /* Local variable stored in C variable */
  register SL Rv0;
  register SL Rv1;
  SL Rv2;
  SL Rv3;
  F Rv4;
  SL Rv5;
  register F Rgf;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+52,F_mb,24);
  memcpy( Ra.s+76,F_mc,24);
  Ra.sl[0]=2;
  Ra.sl[1]=2;
  Rv0=0;
  for( Rf2=Ra.sl[0];Rf2>0;Rf2-- )
  Rv0++;
  ((SL *)Ret)[0]=2;
  ((SL *)Ret)[1]=2;
  Rv1=0;
  for( Rf2=((SL *)Ret)[0];Rf2>0;Rf2-- )
  Rv1++;
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+79;
  Ra.v[5]=Rd.s+12;
  Ra.sl[12]=70; /* line # 70 */
  Rv2=1;
  for( Rf2=2;Rf2>0;Rf2-- ) {
    Rv3=1;
    for( Rf1=2;Rf1>0;Rf1-- ) {
      Rv4=(F)0.000000E-01;
      Rv5=1;
      for( Rf0=2;Rf0>0;Rf0-- ) {
        Ra.sl[12]=76; /* line # 76 */
        Rv4=Rv4+(float)(Ra.sl[Rv2*2+Rv5+12]*Ra.sl[Rv5*2+Rv3+18]);
        Ra.sl[12]=84; /* line # 84 */
        Ra.sl[Rv2*2+Rv3-1]=(Rv4>0.0?(SL)(Rv4+0.5):(SL)(Rv4-0.5));
        Rv5++;
      }
      Rv3++;
    }
    Rv2++;
  }
  Ra.sl[12]=92; /* line # 92 */
  TEST_SCHEME_PRC_00000000(Ret,Ra.s);
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[3];
  return(Ret);
}


/* Procedure/Function : " transpose "  */
V TEST_SCHEME_transpose(V Ret, V F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  ((SL *)Ret)[0]=4;
  ((SL *)Ret)[1]=4;
  Rv0=0;
  for( Rf1=((SL *)Ret)[0];Rf1>0;Rf1-- )
  Rv0++;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+92;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=104; /* line # 104 */
  if (((SL *)F_m)[0]<((SL *)F_m)[1]) Rv1=((SL *)F_m)[0];
  else Rv1=((SL *)F_m)[1];
  Rv2=1;
  for( Rf1=Rv1;Rf1>0;Rf1-- ) {
    Rv3=1;
    for( Rf0=Rv1;Rf0>0;Rf0-- ) {
      ((SL *)Ret)[Rv3*4+Rv2-3]=((SL *)F_m)[Rv2*4+Rv3-3];
      Rv3++;
    }
    Rv2++;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function :  TEST_SCHEME_PRC_00000002*/
void TEST_SCHEME_PRC_00000002(V F_tg, V F_sr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=117; /* line # 117 */
  if (((SL *)F_tg)[0]<((SL *)F_sr)[0]) Rv0=((SL *)F_tg)[0];
  else Rv0=((SL *)F_sr)[0];
  if (((SL *)F_tg)[1]<((SL *)F_sr)[1]) Rv1=((SL *)F_tg)[1];
  else Rv1=((SL *)F_sr)[1];
  if (((SL *)F_tg)[0]==((SL *)F_sr)[0]&&((SL *)F_tg)[1]==((SL *)F_sr)[1]) {
    Rv2=1;
    for( Rf1=((SL *)F_tg)[0];Rf1>0;Rf1-- ) {
      Rv3=1;
      for( Rf0=((SL *)F_tg)[1];Rf0>0;Rf0-- ) {
        Ra.sl[6]=122; /* line # 122 */
        ((SL *)F_tg)[(Rv2-1)*((SL *)F_tg)[1]+Rv3+1]=((SL *)F_sr)[(Rv2-1)*((SL *)
        F_sr)[1]+Rv3+1];
        Rv3++;
      }
      Rv2++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " som_matrix "  */
void TEST_SCHEME_som_matrix(V F_ma){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Rv0=(F)0.000000E-01;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+115;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=159; /* line # 159 */
  Rv1=1;
  for( Rf1=((SL *)F_ma)[0];Rf1>0;Rf1-- ) {
    Rv2=1;
    for( Rf0=((SL *)F_ma)[1];Rf0>0;Rf0-- ) {
      Rv0=Rv0+(float)((SL *)F_ma)[(Rv1-1)*((SL *)F_ma)[1]+Rv2+1];
      Rv2++;
    }
    Rv1++;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+127,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,4,-6,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_Object "  */
void TEST_SCHEME_PRC_00000003(V F_ma){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+138;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=172; /* line # 172 */
  Rv0=((SL *)F_ma)[0];
  Rv1=((SL *)F_ma)[1];
  Rv2=1;
  for( Rf1=Rv0;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    Rv3=1;
    for( Rf0=((SL *)F_ma)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=178; /* line # 178 */
      if (Rv3==1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+152,-1,-1,32);
      }
      else {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+156,-1,-1,32);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_INT(((SL *)F_ma)[(Rv2-1)*((SL *)F_ma)[1]+Rv3+1],4,0);
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+160,-1,-1,32);
    PAS__WRITE_EOLN();
    Rv2++;
  }
  Ra.sl[6]=183; /* line # 183 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mathwork "  */
void TEST_SCHEME_mathwork(){
  /* Define the automatic variable space. */
  Blk( Ra, 224 );

  /* Local variable stored in C variable */
  register SL Rv0;
  register SL Rv1;
  register SL Rv2;
  register SL Rv3;
  V Rv4;
  register SL Rv5;
  SL Rv6;
  register SL Rv7;
  register SL Rv8;
  register SL Rv9;
  register SL Rv10;
  SL Rv11;
  SL Rv12;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.sl[0]=2;
  Ra.sl[1]=2;
  Rv0=0;
  for( Rf2=Ra.sl[0];Rf2>0;Rf2-- )
  Rv0++;
  Ra.sl[6]=2;
  Ra.sl[7]=2;
  Rv1=0;
  for( Rf2=Ra.sl[6];Rf2>0;Rf2-- )
  Rv1++;
  Ra.sl[12]=3;
  Ra.sl[13]=3;
  Rv2=0;
  for( Rf2=Ra.sl[12];Rf2>0;Rf2-- )
  Rv2++;
  Ra.sl[23]=2;
  Ra.sl[24]=2;
  Rv3=0;
  for( Rf2=Ra.sl[23];Rf2>0;Rf2-- )
  Rv3++;
  Rv4=NULL;
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+164;
  Ra.v[17]=Rd.s+12;
  Ra.sl[36]=202; /* line # 202 */
  TEST_SCHEME_PRC_00000002(Ra.s,Rd.s+176);
  TEST_SCHEME_PRC_00000002(Ra.s+24,Rd.s+200);
  TEST_SCHEME_PRC_00000002(Ra.s+48,Rd.s+224);
  Ra.sl[36]=209; /* line # 209 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+268,-1,-1,32);
  PAS__WRITE_INT(Ra.sl[23],0,0);
  PAS__WRITE_STR(Rd.s+284,-1,-1,32);
  PAS__WRITE_INT(Ra.sl[24],0,0);
  PAS__WRITE_STR(Rd.s+288,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ra.s+92);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  Rv4=PAS__NEW(24);
  ((SL *)Rv4)[0]=2;
  ((SL *)Rv4)[1]=2;
  Rv5=0;
  for( Rf2=2;Rf2>0;Rf2-- )
  Rv5++;
  TEST_SCHEME_PRC_00000002(Ra.s+92,TEST_SCHEME_PRC_00000001(Ra.s+148,Ra.s,Ra.s+24));
  Ra.sl[36]=215; /* line # 215 */
  TEST_SCHEME_PRC_00000002(Rv4,Ra.s+92);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+294,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Rv4);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  PAS__DISPOSE(&Rv4);
  Ra.sl[36]=221; /* line # 221 */
  Rv6=2;
  for( Rf2=3;Rf2>0;Rf2-- ) {
    Rv7=Rv6;
    Rv8=Rv6;
    Rv4=PAS__NEW(Rv7*(Rv8*4)+8);
    ((SL *)Rv4)[0]=Rv7;
    ((SL *)Rv4)[1]=Rv8;
    Rv9=0;
    Rv10=Rv8*4;
    for( Rf1=Rv7;Rf1>0;Rf1-- )
    Rv9++;
    Rv11=1;
    for( Rf1=Rv6;Rf1>0;Rf1-- ) {
      Rv12=1;
      for( Rf0=Rv6;Rf0>0;Rf0-- ) {
        Ra.sl[36]=226; /* line # 226 */
        ((SL *)Rv4)[(Rv11-1)*((SL *)Rv4)[1]+Rv12+1]=Rv11*10+Rv12;
        Rv12++;
      }
      Rv11++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+317,-1,-1,32);
    PAS__WRITE_INT(Rv6,0,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_INT(Rv6,0,0);
    PAS__WRITE_STR(Rd.s+329,-1,-1,32);
    TEST_SCHEME_PRC_00000003(Rv4);
    PAS__WRITE_CHAR(10);
    PAS__WRITE_EOLN();
    if (Rv6==4) {
      Ra.sl[36]=232; /* line # 232 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+333,-1,-1,32);
      PAS__WRITE_INT(Rv6,0,0);
      PAS__WRITE_CHAR(44);
      PAS__WRITE_INT(Rv6,0,0);
      PAS__WRITE_STR(Rd.s+357,-1,-1,32);
      TEST_SCHEME_PRC_00000003(TEST_SCHEME_transpose(Ra.s+148,Rv4));
      PAS__WRITE_CHAR(10);
      PAS__WRITE_EOLN();
    }
    PAS__DISPOSE(&Rv4);
    Rv6++;
  }
  PAS__curr_cntx=Ra.v[15];
}


/* Procedure/Function : " test_scheme "  */
int main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+361;
  Rs.v[2]=Rd.s+12;
  Rs.sl[6]=243; /* line # 243 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+374,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ri.s);
  PAS__WRITE_STR(Rd.s+387,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+391,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ri.s+24);
  PAS__WRITE_STR(Rd.s+405,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+409,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ri.s+48);
  PAS__WRITE_STR(Rd.s+422,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[6]=249; /* line # 249 */
  TEST_SCHEME_som_matrix(Ri.s+48);
  TEST_SCHEME_mathwork();
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
