/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 400 ) = {{
 10,  10,  79,  95,  36, 111, 112, 101,  95,  97, 115, 115,  64,  64,  47, 104,
111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47, 116,
101, 115, 116,  95, 115,  99, 104, 101, 109, 101,  46, 112,  97, 115,  11,  11,
 79,  95,  36, 111, 112, 101,  95, 109, 117, 108, 116,  10,  10,  79,  95,  36,
111, 112, 101,  95,  97, 115, 115,  10,  10, 115, 111, 109,  95, 109,  97, 116,
114, 105, 120,   9,   9,  32,  83,  79,  77,  77,  69,  32,  61,  32,   2,   2,
 10,  10,  12,  12, 119, 114, 105, 116, 101,  36, 111,  98, 106, 101,  99, 116,
  2,   2, 124,  32,   2,   2,  44,  32,   2,   2,  32, 124,   8,   8, 109,  97,
116, 104, 119, 111, 114, 107,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,
  0,   0,   0,  63, 215, 179,  93, 191, 215, 179,  93,  63,   0,   0,   0,  63,
  2,   0,   0,   0,   2,   0,   0,   0, 215, 179,  93,  63,   0,   0,   0, 191,
  0,   0,   0,  63, 215, 179,  93,  63,   3,   0,   0,   0,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0, 128,  63,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,  14,  14,   9,  32, 109, 120,  32, 105, 110, 105, 116, 105,
 97, 108,  32,  91,   2,   2,  46,  46,   4,   4,  93,  32,  58,  10,  20,  20,
 32, 100, 105, 109, 101, 110, 115, 105, 111, 110, 115,  32, 112, 109,  94,  32,
 58,  32,  32,  91,   2,   2,  44,  32,   2,   2,  93,  10,  12,  12,  32,  82,
101, 115, 117, 108, 116,  97, 116,  32,  58,  10,  11,  11, 116, 101, 115, 116,
 95, 115,  99, 104, 101, 109, 101,  11,  11,  10,  32,  32,  32,  32,  32, 109,
 48,  32,  61,  10,   2,   2,  10,  10,  12,  12,  10,  32,  32,  32,  32,  32,
109, 120, 121,  32,  61,  10,   2,   2,  10,  10,  11,  11,  10,  32,  32,  32,
 32,  32, 109,  49,  32,  61,  10,   2,   2,  10,  10,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 80 ) = {{
  2,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,
  0,   0,  64,  64,   0,   0, 128,  64,   0,   0, 160,  64,   0,   0, 192,  64,
  3,   0,   0,   0,   2,   0,   0,   0,   0,   0, 128,  63,   0,   0,  32,  64,
  0,   0,  64,  64,   0,   0, 144,  64,   0,   0, 160,  64,   0,   0, 176,  64
}};

/* Define the local static section. */
static Blk( Rs, 32 );

/* Declaration of external variables. */
extern V PAS__f_output;




/* Procedure/Function :  TEST_SCHEME_PRC_00000000*/
void TEST_SCHEME_PRC_00000000(V F_tg, V F_sr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=37; /* line # 37 */
  Rv0=1;
  for( Rf1=2;Rf1>0;Rf1-- ) {
    Rv1=1;
    for( Rf0=2;Rf0>0;Rf0-- ) {
      ((F *)F_tg)[Rv0*2+Rv1-1]=((F *)F_sr)[Rv0*2+Rv1-1];
      Rv1++;
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function :  TEST_SCHEME_PRC_00000001*/
V TEST_SCHEME_PRC_00000001(V Ret, V F_mb, V F_mc){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  SL Rv2;
  F Rv3;
  SL Rv4;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_mb,24);
  memcpy( Ra.s+52,F_mc,24);
  ((SL *)Ret)[0]=2;
  ((SL *)Ret)[1]=2;
  Rv0=0;
  for( Rf2=((SL *)Ret)[0];Rf2>0;Rf2-- )
  Rv0++;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+78;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=77; /* line # 77 */
  Rv1=1;
  for( Rf2=2;Rf2>0;Rf2-- ) {
    Rv2=1;
    for( Rf1=2;Rf1>0;Rf1-- ) {
      Rv3=(F)0.000000E-01;
      Rv4=1;
      for( Rf0=2;Rf0>0;Rf0-- ) {
        Ra.sl[6]=83; /* line # 83 */
        Rv3=Rv3+Ra.f[Rv1*2+Rv4+6]*Ra.f[Rv4*2+Rv2+12];
        ((F *)Ret)[Rv1*2+Rv2-1]=Rv3;
        Rv4++;
      }
      Rv2++;
    }
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function :  TEST_SCHEME_PRC_00000002*/
void TEST_SCHEME_PRC_00000002(V F_tg, V F_sr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+91;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=97; /* line # 97 */
  if (((SL *)F_tg)[0]<((SL *)F_sr)[0]) Rv0=((SL *)F_tg)[0];
  else Rv0=((SL *)F_sr)[0];
  if (((SL *)F_tg)[1]<((SL *)F_sr)[1]) Rv1=((SL *)F_tg)[1];
  else Rv1=((SL *)F_sr)[1];
  if (((SL *)F_tg)[0]==((SL *)F_sr)[0]&&((SL *)F_tg)[1]==((SL *)F_sr)[1]) {
    Rv2=1;
    for( Rf1=((SL *)F_tg)[0];Rf1>0;Rf1-- ) {
      Rv3=1;
      for( Rf0=((SL *)F_tg)[1];Rf0>0;Rf0-- ) {
        Ra.sl[6]=102; /* line # 102 */
        ((F *)F_tg)[(Rv2-1)*((SL *)F_tg)[1]+Rv3+1]=((F *)F_sr)[(Rv2-1)*((SL *)F_sr)
        [1]+Rv3+1];
        Rv3++;
      }
      Rv2++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " som_matrix "  */
void TEST_SCHEME_som_matrix(V F_ma){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Rv0=(F)0.000000E-01;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=139; /* line # 139 */
  Rv1=1;
  for( Rf1=((SL *)F_ma)[0];Rf1>0;Rf1-- ) {
    Rv2=1;
    for( Rf0=((SL *)F_ma)[1];Rf0>0;Rf0-- ) {
      Rv0=Rv0+((F *)F_ma)[(Rv1-1)*((SL *)F_ma)[1]+Rv2+1];
      Rv2++;
    }
    Rv1++;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+115,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,5,2,0);
  PAS__WRITE_STR(Rd.s+126,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_Object "  */
void TEST_SCHEME_PRC_00000003(V F_ma){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+130;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=152; /* line # 152 */
  Rv0=((SL *)F_ma)[0];
  Rv1=((SL *)F_ma)[1];
  Rv2=1;
  for( Rf1=Rv0;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    Rv3=1;
    for( Rf0=((SL *)F_ma)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=158; /* line # 158 */
      if (Rv3==1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+144,-1,-1,32);
      }
      else {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+148,-1,-1,32);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_SNGL(((F *)F_ma)[(Rv2-1)*((SL *)F_ma)[1]+Rv3+1],6,4,0);
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+152,-1,-1,32);
    PAS__WRITE_EOLN();
    Rv2++;
  }
  Ra.sl[6]=163; /* line # 163 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mathwork "  */
void TEST_SCHEME_mathwork(){
  /* Define the automatic variable space. */
  Blk( Ra, 176 );

  /* Local variable stored in C variable */
  register SL Rv0;
  register SL Rv1;
  register SL Rv2;
  register SL Rv3;
  V Rv4;
  register SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.sl[0]=2;
  Ra.sl[1]=2;
  Rv0=0;
  for( Rf0=Ra.sl[0];Rf0>0;Rf0-- )
  Rv0++;
  Ra.sl[6]=2;
  Ra.sl[7]=2;
  Rv1=0;
  for( Rf0=Ra.sl[6];Rf0>0;Rf0-- )
  Rv1++;
  Ra.sl[12]=3;
  Ra.sl[13]=3;
  Rv2=0;
  for( Rf0=Ra.sl[12];Rf0>0;Rf0-- )
  Rv2++;
  Ra.sl[23]=2;
  Ra.sl[24]=2;
  Rv3=0;
  for( Rf0=Ra.sl[23];Rf0>0;Rf0-- )
  Rv3++;
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+156;
  Ra.v[17]=Rd.s+12;
  Ra.sl[36]=180; /* line # 180 */
  TEST_SCHEME_PRC_00000002(Ra.s,Rd.s+168);
  TEST_SCHEME_PRC_00000002(Ra.s+24,Rd.s+192);
  TEST_SCHEME_PRC_00000002(Ra.s+48,Rd.s+216);
  Ra.sl[36]=187; /* line # 187 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+260,-1,-1,32);
  PAS__WRITE_INT(Ra.sl[23],0,0);
  PAS__WRITE_STR(Rd.s+276,-1,-1,32);
  PAS__WRITE_INT(Ra.sl[24],0,0);
  PAS__WRITE_STR(Rd.s+280,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ra.s+92);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  Rv4=PAS__NEW(24);
  ((SL *)Rv4)[0]=2;
  ((SL *)Rv4)[1]=2;
  Rv5=0;
  for( Rf0=2;Rf0>0;Rf0-- )
  Rv5++;
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+286,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv4)[0],12,0);
  PAS__WRITE_STR(Rd.s+308,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv4)[1],12,0);
  PAS__WRITE_STR(Rd.s+312,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[36]=193; /* line # 193 */
  TEST_SCHEME_PRC_00000002(Ra.s+92,TEST_SCHEME_PRC_00000001(Ra.s+148,Ra.s,Ra.s+24));
  TEST_SCHEME_PRC_00000002(Rv4,Ra.s+92);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+316,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ra.s+92);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  Ra.sl[36]=199; /* line # 199 */
  PAS__DISPOSE(&Rv4);
  PAS__curr_cntx=Ra.v[15];
}


/* Procedure/Function : " test_scheme "  */
int main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+330;
  Rs.v[2]=Rd.s+12;
  Rs.sl[6]=207; /* line # 207 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+343,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ri.s);
  PAS__WRITE_STR(Rd.s+356,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+360,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ri.s+24);
  PAS__WRITE_STR(Rd.s+374,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+378,-1,-1,32);
  TEST_SCHEME_PRC_00000003(Ri.s+48);
  PAS__WRITE_STR(Rd.s+391,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[6]=213; /* line # 213 */
  TEST_SCHEME_som_matrix(Ri.s+48);
  TEST_SCHEME_mathwork();
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
