/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 384 ) = {{
 11,  11,  79,  95,  36, 111, 112, 101,  95, 109, 117, 108, 116,  61,  61,  47,
104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47,
116, 101, 115, 116,  95, 102, 110,  99,  46, 112,  97, 115,  10,  10,  79,  95,
 36, 111, 112, 101,  95,  97, 115, 115,  12,  12, 119, 114, 105, 116, 101,  36,
111,  98, 106, 101,  99, 116,   2,   2, 124,  32,   2,   2,  44,  32,   2,   2,
 32, 124,   9,   9, 116, 101, 115, 116,  95, 102, 110,  99,  49,   0,   0,   0,
  2,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,
  3,   0,   0,   0,   3,   0,   0,   0,   1,   0,   0,   0,   2,   0,   0,   0,
  3,   0,   0,   0,   4,   0,   0,   0,   5,   0,   0,   0,   6,   0,   0,   0,
  7,   0,   0,   0,   8,   0,   0,   0,   9,   0,   0,   0,  17,  17,  10,  32,
 32,  32, 112,  50,  50,  94,  32,  40,  61, 109,  51,  41,  32,  61,  10,   2,
  2,  10,  10,  11,  11,  10,  32,  32,  32, 103, 110,  51,  51,  32,  61,  10,
  3,   0,   0,   0,   3,   0,   0,   0,  11,   0,   0,   0,  12,   0,   0,   0,
 13,   0,   0,   0,  21,   0,   0,   0,  22,   0,   0,   0,  23,   0,   0,   0,
 31,   0,   0,   0,  32,   0,   0,   0,  33,   0,   0,   0,   2,   2,  10,  10,
 11,  11,  10,  32,  32,  32, 103, 109,  51,  51,  32,  61,  10,   2,   2,  10,
 10,  11,  11,  10,  32,  32,  32,  32,  32, 109,  50,  32,  61,  10,   2,   2,
 10,  10,  11,  11,  10,  32,  32,  32,  32,  32, 109,  51,  32,  61,  10,   2,
  2,  10,  10,  20,  20,  10,  32,  32,  32,  32,  32, 109,  49,  32,  61,  32,
109,  50,  42, 109,  51,  32,  61,  32,  10,   2,   2,  10,  10,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 128 ) = {{
  2,   0,   0,   0,   2,   0,   0,   0,   1,   0,   0,   0, 255, 255, 255, 255,
255, 255, 255, 255,   1,   0,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,
  1,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   1,   0,   0,   0,
  2,   0,   0,   0,   2,   0,   0,   0,   1,   0,   0,   0, 255, 255, 255, 255,
255, 255, 255, 255,   1,   0,   0,   0,   3,   0,   0,   0,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 56 );

/* Declaration of external variables. */
extern V PAS__f_output;




/* Procedure/Function :  TEST_FNC1_PRC_00000000*/
V TEST_FNC1_PRC_00000000(V Ret, V F_mb, V F_mc){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_mb,24);
  memcpy( Ra.s+52,F_mc,24);
  ((SL *)Ret)[0]=2;
  ((SL *)Ret)[1]=2;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=41; /* line # 41 */
  Rv0=1;
  for( Rf2=2;Rf2>0;Rf2-- ) {
    Rv1=1;
    for( Rf1=2;Rf1>0;Rf1-- ) {
      Rv2=0;
      Rv3=1;
      for( Rf0=2;Rf0>0;Rf0-- ) {
        Ra.sl[6]=46; /* line # 46 */
        Rv2=Rv2+Ra.sl[Rv0*2+Rv3+6]*Ra.sl[Rv3*2+Rv1+12];
        Rv3++;
      }
      ((SL *)Ret)[Rv0*2+Rv1-1]=Rv2;
      Rv1++;
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function :  TEST_FNC1_PRC_00000001*/
void TEST_FNC1_PRC_00000001(V F_tg, V F_sr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=56; /* line # 56 */
  if (((SL *)F_tg)[1]==((SL *)F_sr)[1]&&((SL *)F_tg)[0]==((SL *)F_sr)[0]) {
    Rv0=1;
    for( Rf1=((SL *)F_tg)[1];Rf1>0;Rf1-- ) {
      Rv1=1;
      for( Rf0=((SL *)F_tg)[0];Rf0>0;Rf0-- ) {
        ((SL *)F_tg)[(Rv0-1)*((SL *)F_tg)[0]+Rv1+1]=((SL *)F_sr)[(Rv0-1)*((SL *)
        F_sr)[0]+Rv1+1];
        Rv1++;
      }
      Rv0++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_Object "  */
void TEST_FNC1_PRC_00000002(V F_ma, SL F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+88;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=80; /* line # 80 */
  Rv0=((SL *)F_ma)[1];
  Rv1=((SL *)F_ma)[0];
  Rv2=1;
  for( Rf1=Rv0;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    Rv3=1;
    for( Rf0=((SL *)F_ma)[0];Rf0>0;Rf0-- ) {
      Ra.sl[6]=86; /* line # 86 */
      if (Rv3==1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+102,-1,-1,32);
      }
      else {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+106,-1,-1,32);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_INT(((SL *)F_ma)[(Rv2-1)*((SL *)F_ma)[0]+Rv3+1],F_f,0);
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+110,-1,-1,32);
    PAS__WRITE_EOLN();
    Rv2++;
  }
  Ra.sl[6]=91; /* line # 91 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_fnc1 "  */
int main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+114;
  Rs.v[2]=Rd.s+13;
  Rs.sl[6]=98; /* line # 98 */
  TEST_FNC1_PRC_00000001(Ri.s,Rd.s+128);
  TEST_FNC1_PRC_00000001(Ri.s+24,Rd.s+152);
  Rs.sl[6]=103; /* line # 103 */
  TEST_FNC1_PRC_00000001(Ri.s+48,TEST_FNC1_PRC_00000000(Rs.s+28,Ri.s,Ri.s+24));
  TEST_FNC1_PRC_00000001(Ri.s+72,Rd.s+176);
  Rs.sl[6]=110; /* line # 110 */
  Ri.v[15]=PAS__NEW(24);
  ((SL *)Ri.v[15])[0]=2;
  ((SL *)Ri.v[15])[1]=2;
  TEST_FNC1_PRC_00000001(Ri.v[15],Ri.s+24);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+220,-1,-1,32);
  TEST_FNC1_PRC_00000002(Ri.v[15],4);
  PAS__WRITE_STR(Rd.s+239,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[6]=115; /* line # 115 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+243,-1,-1,32);
  TEST_FNC1_PRC_00000002(Rd.s+256,4);
  PAS__WRITE_STR(Rd.s+300,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+304,-1,-1,32);
  TEST_FNC1_PRC_00000002(Ri.s+72,4);
  PAS__WRITE_STR(Rd.s+317,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+321,-1,-1,32);
  TEST_FNC1_PRC_00000002(Ri.s,4);
  PAS__WRITE_STR(Rd.s+334,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[6]=121; /* line # 121 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+338,-1,-1,32);
  TEST_FNC1_PRC_00000002(Ri.s+24,4);
  PAS__WRITE_STR(Rd.s+351,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+355,-1,-1,32);
  TEST_FNC1_PRC_00000002(Ri.s+48,4);
  PAS__WRITE_STR(Rd.s+377,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
