{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*                     ---   MAIN PASCAL MODULE   ---                    *
*                                                                       *
*                ---  Version  3.1-B5-3 -- 30/06/2024 ---               *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*             www.pierre.wolfers.fr                                     *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


}

{************     CPAS  version 3.1-B5-3   *************}

{
        *** Modification(s) from major version ***


			----

		       nothing

			----

}

(*
[inherit( 'lib:cpas_b__src',           { Use basic string definitions }
          'lib:pas_env' )]             { Use PAS definitions }
 *)
{ The main parameters are just put for Pascal compatibility }
program PAS( input, output );

  { Import the global type/variable definitions, and
    the main entry external definitions }
  %include 'passrc:pcmp_global_def';

 { %include 'passrc:cpas_system_name_init.cpas'; { Get the current system name in the variable system_name (from kit_builder) }



function SYS_ERROR_HANDLER( ierr: cc__int ): cc__int;
begin
  SRC_END_OF_LINE;                     { Stop the Source Parsing with error message editing }
  WRITELN;
  WRITELN( ierr, 'Compiler Fatal Error => Stop Compiler.' );
  WRITELN;
  SYS_ERROR_HANDLER := 0               { Continue Standard Error Process }
end SYS_ERROR_HANDLER;



procedure LOCATE_EXTENSION( var fnm: [readonly] string; var ie, ip: integer );
{ Look for the extension and directory position in a file specification.
  fnm is the file specification,
  ie is the returned position of the dot mark before the extension or 0,
  ip is the returned position of the end of directory (or device) specification or 0.
  The meaning of 0 result is not found.
}
var
  i: integer;

begin
  i := fnm.length;
  ie := 0;
  ip := 0;
  while i > 0 do
  begin
    case fnm.body[i] of
      '.':                ie := i;
      '/', '\', ']', ':': begin  ip := i; i := 0  end;
    otherwise
    end;
    i := i - 1;
    if ip > ie then ie := 0
  end
end LOCATE_EXTENSION;



procedure SET_COMPILER_PARM;
{ Procedure to set the compiler options and file specifications }
var
  sp:                           srf_ptr;
  mc:                       macsymb_ptr;
  ierr, i, j, md:               integer;
  pcurr, src, lst, obj:  str_ptr := nil;
  str, sjob, s1, s2, s3:  string( 255 );
  cff, lff:            boolean := false;
  mid:                          id_name;
  ch:                              char;

begin
  ierr := 0;
  cmp_objf := true;
  pas_compile := true;                 { Set the To Compile flag }
  i  := 1;                             { Skip the # 0 parameter }
  md := 0;                             { Begining with the source file }
  cmp_traceopt := 5;                   { Set the default tracing to 5 lines }
  cmp_listlvl  := 1;                   { Set the default listing level to one }
  while i < argc do
  begin
    if argv[i] <> nil then
    with argv[i]^ do
    if length > 0 then                 { It is a real parameter }
    begin
      pcurr := argv[i];
      if pcurr^[1] = '-' then
      begin
        with pcurr^ do
        if length > 1 then
        case body[2] of { * Get an Option }
          'M', 'm': { Create Macro symbol }
            begin
               if length > 2 then
               begin
                 s1 := SUBSTR( pcurr^, 3 );   { Get the symbol and its possible value }
                 j := INDEX( s1, '=' );
                 if j > 0 then
                 begin
                   s2 := SUBSTR( s1, j + 1 );
                   j := j - 1;
                   s1.length := j
                 end
                 else s2.length := 0;
                 j := s1.length;
                 if j > id_maxsize then j := id_maxsize;
                 mid.l := j;
                 for jj := 1 to j do
                 begin
                   ch := s1[jj];
                   if (ch >= 'A') and (ch <= 'Z') then ch := CHR( ORD( ch ) + 32 );
                   mid.s[jj] := ch
                 end;
                 mc := CREATE_MAC_IDENT( mid, true );
                 if mc <> nil then
                 with mc^, value do
                 begin
                   mvl_typ := mval_str;
                   if mvl_str <> nil then DISPOSE( mvl_str );
                   NEW( mvl_str, s2.length ); mvl_str^ := s2
                 end
               end
             end;
          'F', 'f': { File specification }
             begin
               if length > 2 then
               begin
                 ch := body[3];
                 if (ch = 'L') or (ch = 'l') then lff := true
                 else
                 if (ch = 'C') or (ch = 'c') then cff := true
               end
               else cff := true
             end;
          'O', 'o': { Optimize level }
             begin
               if length > 2 then
               case body[3] of
                 '+': j := 1;
                 '-': j := 0;
                 '0','1','2','3','4','5','6','7','8','9':
                    j := ORD( body[3] ) - ORD( '0' );
               otherwise
               end
               else j := 1;
               cmp_optimizelvl := j
             end;
          'T', 't': { * Error Tracing }
             begin
               if length > 2 then
               case body[3] of
                 '+': j := 1;
                 '-': j := 0;
                 '0','1','2','3','4','5','6','7','8','9':
                    j := ORD( body[3] ) - ORD( '0' );
               otherwise
               end
               else j := 1;
               cmp_traceopt := j
             end;
          'L', 'l': { * Listing Level Setting/Macro listing }
             begin
               if length > 2 then
                 case body[3] of
                 'm', 'M':
                   begin  cmp_macroexp := true; j := cmp_listlvl  end;
                 '+': j := 10;
                 '-': j :=  1;
                 '0','1','2','3','4','5','6','7','8','9':
                    j := ORD( body[3] ) - ORD( '0' );
               otherwise
               end
               else j := 1;
               cmp_listlvl := j
            end;
          'D', 'd': { * Debug Generation }
             begin
               cmp_debugopt := true;
               cmp_traceopt := 1
             end;
          'N', 'n': { * No  code Generation }
             begin
               cmp_traceopt := 0;
               cmp_objf     := true
             end;
          'R', 'r': { * Check range Generation }
               cmp_range    := true;
          'V', 'v': { * Check Variant record range }
               cmp_fsctest  := true;
          'C', 'c': { * Tree Output Code Enable }
               cmp_macf     := true;

          'X', 'x': { Specify a cross-compilation target system (already managed before) }
             ;

          'H', 'h': { * The Help Information }
             begin
               WRITELN;
               WRITELN( ' The general form of a cpas command is:' );
               WRITELN( '    cpas [<option(s)>] <pascal_file> [<listing_file> [<c_file>]]' );
               WRITELN( '    When the <listing_file> is specified the Listing mode is Enabled.' );
               WRITELN( '    The default <listing_file> is TT: with listing disable and' );
               WRITELN( '    the default <c_file> is the <pascal_file> with the ".c" type.' );
               WRITELN;
               WRITELN( ' The cpas <option(s)> are (major or minor letter) :' );
               WRITELN( '    -tn To set the error tracing precision to n lines,' );
               WRITELN( '        where n is a single digit 0 to 9 and + or - .' );
               WRITELN( '        -t0 and -t- disable the error tracing,' );
               WRITELN( '        -t+ is equivalent to -t1 and the default is -t5,' );
               WRITELN( '        this options is equivalent to "%pragma trace:<n>;" .' );
               WRITELN( '    -ln To set the listing output level to list the included' );
               WRITELN( '        source listing with n in the range 1..9 (default is -l1).' );
               WRITELN( '    -lm To set the listing of macro expanssion (default is no macro lsiting).' ); 
               WRITELN( '    -r  To enable the value out of range error detection' );
               WRITELN( '        (usefull to detect the out of array index range).' );
               WRITELN( '    -n  To disable the code generation for checking code purpose.' );
               WRITELN( '    -d  To enable the future debug generation mode;' );
               WRITELN( '        this options induces the -t1 tracing mode.' );
               WRITELN( '    -c  To enable the logical tree output. The effect is' );
               WRITELN( '        equivalent to the macro statement "%pragma cp_list_on;" .' );
               WRITELN( '    -f <Cfile> or -fc <Cfile>  and' );
               WRITELN( '    -fl <Lfile>' );
               WRITELN( '        To specify the C resulting file <Cfile> or the listing of source' );
               WRITELN( '        listing file <Lfile> in any ordering.' );
               WRITELN( '        When we use these options only source file should be directly specified.' );
               WRITELN( '    -m<Name>' );
               WRITELN( '    -m<name>=<value>' );
               WRITELN( '        To define the <Name> with, if specified, the string value <value>' );
               WRITELN( '        else with the null string value.' );
               WRITELN( '    -x<system_name>' );
               WRITELN( '        To specify a particular executing operating system <system_name> to' );
               WRITELN( '        perform cross-compilation. The default is to use the current executing' );
               WRITELN( '        operating system.' );
               WRITELN;
               WRITELN( '    -h  To output this help text.' );
               WRITELN;
               PASCAL_EXIT( 0 )
             end;
        otherwise
          { Ignore Unknown Options }
          WRITELN( ' Pascal Ignore unknown Command Option.' )
        end
      end
      else
      begin { * Get a filename }
        if cff then
        { Object C File Specification }
        begin  obj := pcurr; cff := false  end
        else
        if lff then
        { Listing File Specification }
        begin  lst := pcurr; lff := false  end
        else
        case md of
          0: { Source File Specification }
            begin  md := 1; src := pcurr  end;
          1: { Listing File Specification }
            begin  md := 2; lst := pcurr  end;
          2: { Object C File Specification }
            begin  md := 3; obj := pcurr  end;
        otherwise
          { Ignore other extra parameters }
          WRITELN( ' Pascal Ignore all Extra Command Parameter(s).' )
        end
      end
    end;
    i := i + 1
  end;

  { Now Open the specified Source, Listing, and object File }
  if src = nil then
  begin
    WRITELN( ' No Specified Pascal Source => Stop.' );
    emergency_stop := true
  end
  else
  begin
    str := src^;
    LOCATE_EXTENSION( str, i, j );
    if i = 0 then
    begin
      sjob := SUBSTR( str, j + 1 );    { Keep the file name without type }
      str  := str||'.pas'              { Set the Pascal filetype }
    end
    else sjob := SUBSTR( str, j + 1, i - j - 1 );
    src_control := SRC_FILE_OPEN( str, false, src_control );
    if src_openerr = 0 then
    begin { Source is open }
      SET_SRCFILESPC( 0 );             { Set the tracing structure }
      { Define and set The Listing File Specification }
      with src_control^, lst_current^ do
        if lst = nil then
          src_flags := src_flags - [src_blist]
        else
        begin
          str := lst^;
          if str.length = 3 then
            if ((str[1] = 't') or (str[1] = 'T')) and
               ((str[2] = 't') or (str[2] = 'T')) and
               (str[3] = ':') then str.length := 0;
          if str.length > 0 then
          begin
            LOCATE_EXTENSION( str, i, j );
            if i = 0 then
            begin
              if j = str.length then str := str||sjob;
              str := str||'.lis'
            end
          end;
          if lst_heading <> nil then s1 := lst_heading^ else s1 := '';
          if lst_title   <> nil then s2 := lst_title^   else s2 := '';
          COMPILE_SET_SBTTL( nil ); s3 := ' ';
          LST_OPEN( lst_current, str, s1, s2, s3,
                    132,               { 132 char. / line }
                    -1,                { tty/no => dis./ena. page managment }
                    false,             { New version mode }
                    false,             { No print on close time }
                    false,             { No append }
                    ierr );
          if ierr = 0 then
          begin
            src_flags := src_flags + [src_blist];
            if src_lstmxlev < src_level then src_lstmxlev := src_level;
          end else src_flags := src_flags - [src_blist]
        end;

      { Define and set The Object File Specification }
      if obj = nil then
        if sjob.length > 0 then str := sjob
                           else
                           begin
                             WRITELN( ' Pascal Creates the "pascal.c" file.' );
                             str := 'pascal.c'
                           end
      else str := obj^;
      LOCATE_EXTENSION( str, i, j );
      if i = 0 then
      begin
        if j = str.length then str := str||sjob;
        str := str||'.c'
      end;
      NEW( pas_obj, str.length );
      pas_obj^ := str
    end
    else
    begin                              { Cannot Open a Source File }
      WRITELN( ' Pascal Cannot Open The Pascal Source File.' );
      emergency_stop := true
    end
  end
end SET_COMPILER_PARM;



[global]
function SEARCH_IN_PATH( in_var path: string; fspc: string; dsep: char := '/' ): string;
{ Routine to search the file specified file (fspc), in the path (path arg.).
  On success, the complete file specification is returned (else a null string).
  Note: A file without read access is equivalent to a none existing file.
}
var
  ib, ie, n:   integer;
  dir, nam:     string;
  fnd:         boolean;

begin
  ib  :=     1;
  n   :=     1;
  fnd := false;
  while not fnd and (ib <> 0) do                                    { Loop on all PATH entries }
  begin
    ie := INDEX( path, ';', n ); n := n + 1;
    if ie = 0 then                                                  { When we take the last path entry ... }
    begin  dir := SUBSTR( path, ib ); ib := 0  end                  { ... we get it ... }
    else
    begin  dir := SUBSTR( path, ib, ie - ib ); ib := ie + 1  end;   { ... else we get the current entry without the semicolon separator }
    if (dir[dir.length] <> dsep) and
       (dir[dir.length] <> ':' ) then                               { We complete the current entry with a directory separator if it is not present }
    begin  dir.length := dir.length + 1; dir[dir.length] := dsep  end;
    nam := dir||fspc;                                               { Build a possible complete setup file specification }
    fnd := FILE_ACCESS_CHECK( nam, 4 {Read access} )                { Test it as existing with free access to read }
  end;                                                              { End of search loop }

  if fnd then begin  path_search_index := n - 1; SEARCH_IN_PATH := dir  end
         else begin  path_search_index := 0; SEARCH_IN_PATH := ''  end
end SEARCH_IN_PATH;



procedure CPAS_INIT_PATH_SEARCH;
{ Procedure to locate the compiler setup file }
var
  upath,   nam:         string;
  defenv:      boolean := true;

begin
  upath := PASCAL_PATH_ENV; {  Select the appropriate setup path to search the setup file }
  nam := SEARCH_IN_PATH( upath, cpas_init_file );
  if nam.length = 0 then                                { When the setup is not found, signal it and stop }
  begin
    WRITELN( ' *** PCMP-CPAS-COMPILER INIT PATH ERROR: Cannot find or open the init file "', cpas_init_file, '". ***' );
    PASCAL_EXIT( 2 )
  end
  else
  begin
    cpas_envdir_idx := path_search_index;       { Keep a copy of the path search index }
    { Extract the system environment setup  directory from the found setup file specification }
    cpas_ini_dir := SUBSTR( nam, 1, nam.length - cpas_init_file.length );

    GET_LOGICAL( cpas_env_dir, 'PAS_ENV' );
    if cpas_env_dir.length > 0 then
    begin
      if not FILE_ACCESS_CHECK( 'PAS_ENV:', 4 { Read access } ) then
      begin
        WRITELN( ' *** PCMP-CPAS-COMPILER ENVIRONMENT PATH ERROR: Probably du to a bad PAS_ENV logical definition. ***' );
        PASCAL_EXIT( 2 )
      end;
      defenv := false
    end
    else
    begin
      if cpas_envdir_idx > 1 then { If the first system path entry was not used (CPAS_ENV not defined) ... }
                                  { ... extract the CPAS ROOT directory and set file CPAS environment library path, ... }
          cpas_env_dir := SUBSTR( cpas_ini_dir, 1, INDEX( cpas_ini_dir, '/', -3 ) )||'cpas/'
      else  { ... else when CPAS_ENV is defined, all file must be located in the same directory. }
        cpas_env_dir := cpas_ini_dir
    end;

(*
WRITELN( ' CPAS_INIT = "', cpas_ini_dir, '",' );
WRITELN( ' PASENV    = "', cpas_env_dir, '",' );    
*)
    { Now we can define the initial and user PASCAL environment path in Logical sysmbols. }
    SET_LOGICAL( 'CPAS_SETUP', cpas_ini_dir );  { Set the init directory path }
    if defenv then SET_LOGICAL( 'PAS_ENV', cpas_env_dir );     { Set the CPAS Pascal environment library path }
    SET_LOGICAL( 'PASENV', cpas_env_dir )       { OLd name Keep for transition. }
  end
end CPAS_INIT_PATH_SEARCH;



procedure GET_TARGET_SYS_ENV;
var
  i, j:        integer;
  c1, c2:         char;
  st:           string;

begin
  trg_env_fspc.length := 0;
  i := 1;
  while i < argc do                                             { Loop to search the -x option (if specified) }
  with argv[i]^ do
  begin
    if length > 2 then
  exit if (body[1] = '-') and ((body[2] = 'x') or (body[2] = 'X'));
    i := i + 1
  end;
  if i < argc then trg_sys_name := SUBSTR( argv[i]^, 3 )        { When -x<system> is specified, get the system name }
  else
  begin
    trg_sys_name := system_name;                                { When -x is not specified, try to find the logical specification of system or environment }
    i := GET_LOGICAL( trg_env_fspc, 'CPAS_SYS_ENV' );
    if (i = 0) and (trg_env_fspc.length > 0) then
    begin
      { If a system name is specified by logical }
      if INDEX( trg_env_fspc, '.cpas_init', -1 ) = 0 then       { When a system name is specified, set it ... }
      begin
        trg_sys_name := trg_env_fspc; 
        trg_env_fspc.length := 0
      end
      else
      begin                                                     { ... else when an environment file path is specified get it and try to deduce ...  }
        i := INDEX( trg_env_fspc, 'cpas_env_', -1 ) + 9;
        j := INDEX( trg_env_fspc, '.', -1 ) - i;                { ... a system name. }
        if (i > 9) and (j > 0) then trg_sys_name := SUBSTR( trg_env_fspc, i, j )
                               else trg_sys_name := '***Undefined**'
      end
    end
  end;
  if trg_env_fspc.length = 0 then { Deduce the environment file specification from the target system name }
    trg_env_fspc := cpas_ini_dir||'cpas_env_'||trg_sys_name||'.cpas_init';

  if not FILE_ACCESS_CHECK( trg_env_fspc, 4 {Read access} ) then
  begin
    WRITELN;
    WRITELN( ' *** PCMP-CPAS-COMPILER SYS_ENV ERROR: Cannot found the file "', trg_env_fspc, '"' );
    WRITELN( ' *** for the target system "', trg_sys_name, '"' );
    WRITELN;
    PASCAL_EXIT( 2 )
  end
(*
;WRITELN( ' PCP use env file "', trg_env_fspc, '" for the system "', trg_sys_name, '"' )
*)
end GET_TARGET_SYS_ENV;





begin { PAS main }
  CPAS_INIT_PATH_SEARCH;               { Look for the PASROOT tree }

  GET_TARGET_SYS_ENV;                  { Locate the "cpas_env<sys_name>.cpas_init" target environment file }

  CMP_INIT;                            { Initialize the PAS compiler }

  if not emergency_stop then
    SET_COMPILER_PARM;                 { Set the Compiler Parameters and Options }

  { EXE_INIT;                          { Initialize the PAS processor }

  if not emergency_stop then           { if no initialize error then }
  begin
    { Set the System Error Handler }
    ESTABLISH( SYS_ERROR_HANDLER );

    CMP_COMPILE( true );               { Compile pas.ini and linked source(s) }

    if pas_main <> nil then
      if pas_main^.pro_pkind = pro_main then
        GENERATE_START                 { Set the start addess when specified }
  end
end PAS { The main }.
