/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 2792 ) = {{
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 64,  64,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,
 45,  51,  47, 112,  99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,
 97, 115,   3,   3,  84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,
 95, 115, 101, 116,  95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,
 29,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111,
117, 114,  99, 101,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,
 34,  46,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95,
115,  98, 116, 116, 108,  45,  45,  32,  84, 104, 101,  32,  67, 117, 114, 114,
101, 110, 116,  32,  67, 111, 109, 112, 105, 108, 101, 100,  32, 112, 114, 111,
 99, 101, 100, 117, 114, 101,  47, 102, 117, 110,  99, 116, 105, 111, 110,  32,
105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116, 107, 101, 121,
119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121, 119, 111, 114,
100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120, 111, 114,   3,
  3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105, 118,   3,   3,
109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,   3, 110, 105,
108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116, 111,   4,   4,
116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14, 117, 115, 101,
114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3, 118,  97, 114,
  6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,  95, 118,  97,
114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,  99,  99, 101,
115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,  97, 121,   6,
  6, 114, 101,  99, 111, 114, 100,   6,   6, 112,  97,  99, 107, 101, 100,   3,
  3, 115, 101, 116,   3,   3, 117, 115, 101,   3,   3, 110, 101, 119,   4,   4,
110, 101, 119, 104,   7,   7, 100, 105, 115, 112, 111, 115, 101,   4,   4, 111,
112, 101, 110,   5,   5, 114, 101, 115, 101, 116,   7,   7, 114, 101, 119, 114,
105, 116, 101,   6,   6,  97, 112, 112, 101, 110, 100,   4,   4, 114, 101,  97,
100,   6,   6, 114, 101,  97, 100, 108, 110,   5,   5, 114, 101,  97, 100, 118,
  5,   5, 119, 114, 105, 116, 101,   7,   7, 119, 114, 105, 116, 101, 108, 110,
  6,   6, 119, 114, 105, 116, 101, 118,   7,   7, 112, 114, 111, 103, 114,  97,
109,   6,   6, 109, 111, 100, 117, 108, 101,   9,   9, 112, 114, 111,  99, 101,
100, 117, 114, 101,   8,   8, 102, 117, 110,  99, 116, 105, 111, 110,   6,   6,
105, 110, 108, 105, 110, 101,   6,   6, 114, 101, 116, 117, 114, 110,   7,   7,
102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116, 105,  99,   6,
  6, 104, 105, 100, 100, 101, 110,   6,   6, 101, 120, 112, 111, 114, 116,   6,
  6, 103, 108, 111,  98,  97, 108,   8,   8, 101, 120, 116, 101, 114, 110,  97,
108,   8,   8, 115, 116,  97, 110, 100,  97, 114, 100,   5,   5,  98, 101, 103,
105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,   4,   4, 101, 108,
115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114, 101, 112, 101,  97,
116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111, 114,   4,   4, 108,
111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,  97, 115, 101,   4,
  4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9, 111, 116, 104, 101,
114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100, 111,   2,   2, 116,
111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37, 100, 101, 102, 105,
110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110, 101,   4,   4,  37,
108, 101, 116,   3,   3,  37, 105, 102,   6,   6,  37, 105, 102, 100, 101, 102,
  8,   8,  37, 105, 102, 117, 110, 100, 101, 102,   5,   5,  37, 116, 104, 101,
110,   5,   5,  37, 101, 108, 115, 101,   5,   5,  37, 101, 108, 105, 102,   6,
  6,  37, 101, 110, 100, 105, 102,   8,   8,  37, 109, 101, 115, 115,  97, 103,
101,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,   8,  37, 105, 110,  99,
108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103, 109,  97,   4,   4,  37,
101, 111, 102,  16,  16,  99, 114, 101,  97, 116, 101,  95, 109,  97,  99,  95,
105, 100, 101, 110, 116,   4,   4,  67,  82,  69,  77,   0,   0,   0,   0,   0,
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  7,   7, 115, 111, 114, 116, 109,  99,  49,  15,  15, 114, 101,  98, 117, 105,
108, 100,  95, 109,  99, 116, 114, 101, 101,  49,  14,  14, 114, 101,  98, 117,
105, 108, 100,  95, 109,  99, 116, 114, 101, 101,   6,   6, 110, 101, 120, 116,
 99, 104,   8,   8, 112, 117, 116,  95,  99, 104,  97, 114,   4,   4,  73,  78,
 83,  89,  12,  12, 116, 101, 115, 116,  95, 102, 105, 103, 117, 114, 101, 115,
  7,   7, 102, 105, 103, 117, 114, 101, 115,   4,   4,  70,  73,  71,  85,  11,
 11, 111, 118, 102,  95, 104,  97, 110, 100, 108, 101, 114,  11,  11,  84, 111,
111,  32,  79,  86,  72,  32,  69,  82,  82,  12,  12, 105, 110, 115, 121, 109,
 98, 111, 108,  95, 115, 114,  99,  13,  13, 115, 107, 105, 112,  95, 109,  99,
115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0, 192,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,  16,   0,   0,   0,   4,   4,  77,  67,  83,  75,  16,  16,
 99,  98,  95, 109,  97,  99, 114, 111,  95, 109,  97, 110,  97, 103, 101, 114,
 13,  13, 109,  97,  99, 114, 111,  95, 114, 101, 112, 108,  97,  99, 101,   4,
  4,  77,  65,  67,  84,  19,  19, 100, 101, 102, 105, 110, 101,  95, 109,  97,
 99, 114, 111,  95, 115, 121, 109,  98, 111, 108,   4,   4,  67,  82,  77,  83,
  0,   0,   6,   0,   0,   0,   6,   0,  21,  21, 117, 110, 100, 101, 102, 105,
110, 101,  95, 109,  97,  99, 114, 111,  95, 115, 121, 109,  98, 111, 108,   4,
  4,  82,  77,  77,  83,   0,   0,   0,   0,   0,   6,   0,  19,  19, 109,  97,
 99, 114, 111,  95,  97, 115, 115, 105, 103, 110,  95, 115, 121, 109,  98, 111,
108,   4,   4,  65,  83,  77,  83,   0,   0,   0,   6,   0,   0,   0,   0,   0,
  0,   1,   0,   0,  16,   0,   0,   0,   9,   9, 115, 104, 111, 119,  95, 109,
118,  97, 108,  15,  15,  32,  69,  88,  80,  95,  73,  68,  69,  78,  84,  32,
 45,  62,  32,  91,   3,   0,   0,   0,   8,   0,   8, 109, 118,  97, 108,  95,
105, 110, 116,   8, 109, 118,  97, 108,  95, 115, 116, 114,   8, 109, 118,  97,
108,  95, 110, 117, 108,   8, 109, 118,  97, 108,  95, 117, 110, 100,   4,   4,
 44,  32, 105,  61,   5,   5,  44,  32, 115,  61,  34,   2,   2,  34,  93,  11,
 11, 115, 104, 111, 119,  95, 109, 115, 116,  97,  99, 107,  15,  15,  32, 115,
116,  97,  99, 107,  58,  32, 115, 116, 107, 112,  32,  61,  32,   2,   2,  32,
 91,   4,   4,  93,  32,  61,  32,   8,   8, 109, 118,  97, 108,  95,  99, 111,
112,   9,   9, 109, 118,  97, 108,  95, 102, 114, 101, 101,   5,   5, 109, 112,
117, 115, 104,   4,   4,  77,  80,  85,  83,   4,   4, 109, 112, 111, 112,   4,
  4,  77,  80,  79,  80,  15,  15, 103, 101, 116,  95, 109,  97,  99, 114, 111,
 95, 118,  97, 108, 117, 101,   9,   9, 109, 101, 120, 112,  95, 105, 110, 116,
118,  11,  11, 109, 101, 120, 112,  95, 118, 108,  95, 115, 116, 114,   9,   9,
109, 101, 120, 112,  95, 115, 116, 114, 118,   9,   9, 109, 101, 120, 112,  95,
 99,  97, 108, 108,   4,   4,  77,  67,  65,  76,   0,   0,   7, 100, 101, 102,
105, 110, 101, 100,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   1,   0,   0,   0,
  6, 115, 117,  98, 115, 116, 114,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
253, 255, 255, 255,   5, 105, 110, 100, 101, 120,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   2,   0,   0,   0,   5, 108, 101, 110, 103, 116, 104,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   1,   0,   0,   0,   8,  42,  42,  42,
 42,  42,  42,  42,  42,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   0,
 10,  10, 109, 101, 120, 112,  95, 105, 100, 101, 110, 116,   4,   4,  77,  73,
 68,  69,   0,   0,   0,   0,   4,   0,  10,  10, 109, 101, 120, 112,  95,  98,
105, 110, 111, 112,   4,   4,  77,  66,  73,  78,  10,  10, 109, 101, 120, 112,
 95, 117, 110,  97, 111, 112,   4,   4,  77,  85,  78,  65,   8,   8, 109, 101,
120, 112,  95, 117, 110,  97,   4,   4,  77,  69,  88,  80,   8,   8, 109, 101,
120, 112,  95, 109, 117, 108,   8,   8, 109, 101, 120, 112,  95,  97, 100, 100,
  8,   8, 109, 101, 120, 112,  95, 114, 101, 108,   8,   8, 109, 101, 120, 112,
 95,  97, 110, 100,  12,  12, 109,  95, 101, 120, 112, 114,  95, 105, 110, 115,
116, 107,  10,  10, 109, 101, 120, 112, 114,  95, 115, 118,  97, 108,  10,  10,
109, 101, 120, 112, 114,  95, 105, 118,  97, 108,  10,  10, 109, 101, 120, 112,
114,  95,  98, 118,  97, 108, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,  13,  13, 112, 114,  97, 103, 109,  97,  95,
109, 115, 116,  97, 116, 101,   4,   4,  80,  82,  65,  71,  14,  14, 105, 110,
 99, 108, 117, 100, 101,  95, 109, 115, 116,  97, 116, 101,   4,   4,  46, 112,
 97, 115,   4,   4,  73,  78,  67,  76,  35,  35,  32,  42,  32,  84, 104, 101,
 32,  99, 117, 114, 114, 101, 110, 116,  32, 115, 111, 117, 114,  99, 101,  32,
102, 105, 108, 101,  32, 105, 115,  32, 110, 111, 119,  32,  34,  20,  20,  32,
 79, 112, 101, 110,  32,  69, 114, 114, 111, 114,  32,  40,  82,  84,  76,  41,
 32,  35,  32,  22,  22,  32, 102, 111, 114,  32, 116, 104, 101,  32,  83, 111,
117, 114,  99, 101,  32, 102, 105, 108, 101,  32,  58,  15,  15,  32,  82,  84,
 76,  32, 109, 101, 115, 115,  97, 103, 101,  32,  58,  32,  14,  14, 101, 110,
100, 102, 105, 108, 101,  95, 109, 115, 116,  97, 116, 101,  35,  35,  32,  42,
 32,  84, 104, 101,  32,  99, 117, 114, 114, 101, 110, 116,  32, 115, 111, 117,
114,  99, 101,  32, 102, 105, 108, 101,  32, 105, 115,  32, 110, 111, 119,  32,
 34,   8,   8,  99, 110, 100,  95, 112, 117, 115, 104,   4,   4,  71,  66,  83,
 89,   7,   7,  99, 110, 100,  95, 112, 111, 112,   9,   9,  99, 110, 100,  95,
 99, 104, 101,  99, 107,  10,  10, 109, 105, 102,  95, 109, 115, 116,  97, 116,
101,   4,   4,  77,  67,  73,  70,   8,   8, 105, 110, 115, 121, 109,  98, 111,
108,   4,   4,  77,  83,  89,  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,  28,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,  16,   0,   0,   0,  15,  15,  42,  42,  42,  32,  77, 101,
115, 115,  97, 103, 101,  32,  42,  42,  42,  21,  21,  32,  78, 111,  86,  97,
108,  32, 102, 111, 114,  32, 109,  97,  99,  32, 115, 121, 109,  98,  32,  34,
 11,  11, 115, 107, 105, 112,  95, 115, 121, 109,  98, 111, 108,  12,  12, 115,
107, 105, 112,  95, 109, 115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  0,  64,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   2,   0,
  9,   9, 105, 110, 115, 121,  95, 105, 110, 105, 116,   0,   0,  55,  55,  32,
 80,  32,  65,  32,  83,  32,  45,  32,  80,  46,  32,  87,  79,  76,  70,  69,
 82,  83,  32,  83,  79,  70,  84,  87,  65,  82,  69,  58,  32,  86,  51,  46,
 49,  45,  66,  53,  45,  51,  32,  79,  70,  32,  51,  48,  45,  74,  85,  78,
 45,  50,  48,  50,  52,  32,  12,  12,  99, 112,  97, 115,  95,  99, 109, 112,
 46, 101, 114, 114,   5,   5,  32,  80,  65,  83,  62,  48,  48,  32,  42,  42,
 42,  32,  80,  67,  77,  80,  45,  67,  80,  65,  83,  45,  67,  79,  77,  80,
 73,  76,  69,  82,  32,  69,  82,  82,  79,  82,  58,  32,  67,  97, 110, 110,
111, 116,  32, 111, 112, 101, 110,  32, 116, 104, 101,  32,  34,  15,  15,  34,
 32, 105, 110, 105, 116, 105,  97, 108,  32, 102, 105, 108, 101,  46,  54,  54,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 102,
111, 114,  32, 116, 104, 101,  32, 116,  97, 114, 103, 101, 116,  32, 115, 121,
115, 116, 101, 109,  32,  34,  22,  22,  32,  80,  65,  83,  32,  67,  65,  78,
 78,  79,  84,  32,  79,  80,  69,  78,  32,  84,  72,  69,  32,  34,  23,  23,
 34,  32,  79,  85,  84,  80,  85,  84,  32,  77,  83,  71,  47,  76,  73,  83,
 84,  32,  70,  73,  76,  69,  46,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 1192 ) = {{
  0,   0,   0,   0,   0,   1,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   4,   5,   6,   7,   7,   7,  15,   6,  16,  17,  10,  18,
 19,  20,   9,  21,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  14,  22,
 11,  12,  13,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  23,
 24,  25,  26,   7,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   4,
  5,   4,   4,   3,  11,  20,  13,  29,  14,  29,   9,  11,  17,  29,   9,  12,
  8,   7,  18,  29,  15,  29,   6,   0,  16,  29,  23,  29,   0,   0,   0,   0,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10, 112,  99, 109, 112, 100, 101,  98,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11, 112,  99, 109, 112, 100, 101,  98,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  0,   0,   0,   0, 254,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 648 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern V V_macsymb_tree;
extern V V_macsymb_frst;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern UB V_sy_attrflg;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern V V_sy_macsymb;
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_src_openerr;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern Blk(V_cpas_ini_dir, 264 );
extern Blk(V_trg_env_fspc, 264 );
extern UB V_error_result;
extern UB V_emergency_stop;
extern Blk(V_trg_sys_name, 264 );
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp);
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp);
C P_src_return(UB F_bfree);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_skip_msymbol(V F_smb, UB F_rec_flg);
void P_binary_objf_close();
void P_generation_pragma();
void PAS_INSMBOL_get_macro_value(V F_vl);
void PAS_INSMBOL_m_expr_instk();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=171; /* line # 171 */
  if (F_icd>=0) {
    Ra.sl[72]=173; /* line # 173 */
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
    Ra.sl[72]=174; /* line # 174 */
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+82);
    Ra.sl[72]=175; /* line # 175 */
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[72]=177; /* line # 177 */
      if (V_srf_free==NULL) {
        Ra.sl[72]=178; /* line # 178 */
        Rv0=PAS__NEW(16);
      }
      else {
        Ra.sl[72]=180; /* line # 180 */
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Ra.sl[72]=181; /* line # 181 */
      Rv1=Rv0;
      Ra.sl[72]=183; /* line # 183 */
      ((V *)Rv1)[0]=V_srf_list;
      Ra.sl[72]=184; /* line # 184 */
      ((V *)Rv1)[1]=NULL;
      Ra.sl[72]=185; /* line # 185 */
      P_val_new(((V *)Rv1)+1,NULL);
      Ra.sl[72]=187; /* line # 187 */
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[72]=190; /* line # 190 */
      Rv2=V_srf_list;
      Ra.sl[72]=192; /* line # 192 */
      P_val_free(((V *)Rv2)+1);
      Ra.sl[72]=193; /* line # 193 */
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[72]=195; /* line # 195 */
    Rv3=((V *)V_srf_list)[1];
    Ra.sl[72]=197; /* line # 197 */
    ((UB *)Rv3)[48]=29;
    Ra.sl[72]=198; /* line # 198 */
    ((SL *)Rv3)[6]=Ra.ub[1];
    Ra.sl[72]=199; /* line # 199 */
    Rv4=Ra.ub[1];
    ((V *)Rv3)[7]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[7])[0]=Rv4;
    Ra.sl[72]=200; /* line # 200 */
    PAS__STR_TO_STR(((V *)Rv3)[7],Ra.s);
  }
  else {
    Ra.sl[72]=205; /* line # 205 */
    Rv0=V_srf_list;
    Ra.sl[72]=206; /* line # 206 */
    Rv5=Rv0;
    Ra.sl[72]=208; /* line # 208 */
    V_srf_list=((V *)Rv5)[0];
    Ra.sl[72]=209; /* line # 209 */
    P_val_free(((V *)Rv5)+1);
    Ra.sl[72]=210; /* line # 210 */
    ((V *)Rv5)[0]=V_srf_free;
    Ra.sl[72]=212; /* line # 212 */
    V_srf_free=Rv0;
  }
  Ra.sl[72]=214; /* line # 214 */
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+87;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=235; /* line # 235 */
  Rv0=V_lst_current;
  Ra.sl[72]=237; /* line # 237 */
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  Ra.sl[72]=238; /* line # 238 */
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
  Ra.sl[72]=239; /* line # 239 */
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+106);
  Ra.sl[72]=240; /* line # 240 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.s+
111,Ra.s),Rd.s+142));
  Ra.sl[72]=241; /* line # 241 */
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  Ra.sl[72]=242; /* line # 242 */
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register UB Rv6;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+146;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=260; /* line # 260 */
  Rv2=V_lst_current;
  Ra.sl[72]=262; /* line # 262 */
  if (((V *)Rv2)[5]!=NULL) {
    Ra.sl[72]=264; /* line # 264 */
    PAS__DISPOSE(((V *)Rv2)+5);
    Ra.sl[72]=265; /* line # 265 */
    ((V *)Rv2)[5]=NULL;
  }
  Ra.sl[72]=267; /* line # 267 */
  if (F_prc!=NULL) {
    Ra.sl[72]=268; /* line # 268 */
    Rv3=F_prc;
    Ra.sl[72]=270; /* line # 270 */
    if (((V *)Rv3)[5]!=NULL) Rv0=((V *)((V *)Rv3)[5])[0];
    Ra.sl[72]=271; /* line # 271 */
    Rv1=((V *)Rv3)[3];
  }
  Ra.sl[72]=273; /* line # 273 */
  if (Rv0!=NULL||Rv1!=NULL) {
    Ra.sl[72]=275; /* line # 275 */
    PAS__VWRITE_INIT(Ra.s,1);
    PAS__WRITE_STR(Rd.s+165,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[72]=276; /* line # 276 */
    if (Rv0!=NULL) {
      Ra.sl[72]=277; /* line # 277 */
      Rv4=Rv0;
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHT(Rv4+1,31,((UB *)Rv4)[0],-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[72]=278; /* line # 278 */
    if (Rv1!=NULL) {
      Ra.sl[72]=279; /* line # 279 */
      Rv5=Rv1;
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHAR(40);
      PAS__WRITE_CHT(Rv5+1,31,((UB *)Rv5)[0],-1,32);
      PAS__WRITE_CHAR(41);
      PAS__WRITE_EOLN();
    }
    Ra.sl[72]=280; /* line # 280 */
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_STR(Rd.s+212,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[72]=281; /* line # 281 */
    Rv6=Ra.ub[1];
    ((V *)Rv2)[5]=PAS__NEW((SL)Rv6+2);
    ((UB *)((V *)Rv2)[5])[0]=Rv6;
    Ra.sl[72]=282; /* line # 282 */
    PAS__STR_TO_STR(((V *)Rv2)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+216;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=308; /* line # 308 */
  Rv0=PAS__NEW(50);
  Ra.sl[6]=309; /* line # 309 */
  Rv1=Rv0;
  Ra.sl[6]=311; /* line # 311 */
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Ra.sl[6]=312; /* line # 312 */
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[6]=313; /* line # 313 */
  ((V *)Rv1)[4]=NULL;
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=314; /* line # 314 */
  ((UB *)Rv1)[48]=F_skw;
  ((UB *)Rv1)[49]=F_opkw;
  Ra.sl[6]=316; /* line # 316 */
  Rv3=V_keyword_tree;
  Ra.sl[6]=317; /* line # 317 */
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[6]=320; /* line # 320 */
      Rv4=Rv3;
      Ra.sl[6]=321; /* line # 321 */
      Rv5=Rv3;
      Ra.sl[6]=323; /* line # 323 */
      Rv6=P_match(Rv0,Rv5);
      Ra.sl[6]=324; /* line # 324 */
      if (Rv6>0) Rv3=((V *)Rv5)[5];
      else {
        Ra.sl[6]=325; /* line # 325 */
        Rv3=((V *)Rv5)[4];
      }
      if (Rv3==NULL)  break;
    }
    Ra.sl[6]=328; /* line # 328 */
    if (Rv6>0) ((V *)Rv4)[5]=Rv0;
    else {
      Ra.sl[6]=329; /* line # 329 */
      ((V *)Rv4)[4]=Rv0;
    }
  }
  else {
    Ra.sl[6]=331; /* line # 331 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+228;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=337; /* line # 337 */
  PAS_INSMBOL_PRC_00000000(Rd.s+246,12,21);
  Ra.sl[6]=338; /* line # 338 */
  PAS_INSMBOL_PRC_00000000(Rd.s+250,12,22);
  Ra.sl[6]=339; /* line # 339 */
  PAS_INSMBOL_PRC_00000000(Rd.s+255,11,20);
  Ra.sl[6]=340; /* line # 340 */
  PAS_INSMBOL_PRC_00000000(Rd.s+260,6,0);
  Ra.sl[6]=341; /* line # 341 */
  PAS_INSMBOL_PRC_00000000(Rd.s+265,8,8);
  Ra.sl[6]=342; /* line # 342 */
  PAS_INSMBOL_PRC_00000000(Rd.s+270,8,9);
  Ra.sl[6]=343; /* line # 343 */
  PAS_INSMBOL_PRC_00000000(Rd.s+275,8,10);
  Ra.sl[6]=344; /* line # 344 */
  PAS_INSMBOL_PRC_00000000(Rd.s+280,10,23);
  Ra.sl[6]=348; /* line # 348 */
  PAS_INSMBOL_PRC_00000000(Rd.s+284,27,29);
  Ra.sl[6]=349; /* line # 349 */
  PAS_INSMBOL_PRC_00000000(Rd.s+289,32,29);
  Ra.sl[6]=350; /* line # 350 */
  PAS_INSMBOL_PRC_00000000(Rd.s+296,33,29);
  Ra.sl[6]=351; /* line # 351 */
  PAS_INSMBOL_PRC_00000000(Rd.s+302,29,29);
  Ra.sl[6]=352; /* line # 352 */
  PAS_INSMBOL_PRC_00000000(Rd.s+308,28,29);
  Ra.sl[6]=353; /* line # 353 */
  PAS_INSMBOL_PRC_00000000(Rd.s+315,31,29);
  Ra.sl[6]=355; /* line # 355 */
  PAS_INSMBOL_PRC_00000000(Rd.s+331,30,29);
  Ra.sl[6]=356; /* line # 356 */
  PAS_INSMBOL_PRC_00000000(Rd.s+336,35,29);
  Ra.sl[6]=357; /* line # 357 */
  PAS_INSMBOL_PRC_00000000(Rd.s+344,36,29);
  Ra.sl[6]=358; /* line # 358 */
  PAS_INSMBOL_PRC_00000000(Rd.s+353,43,29);
  Ra.sl[6]=359; /* line # 359 */
  PAS_INSMBOL_PRC_00000000(Rd.s+362,38,29);
  Ra.sl[6]=360; /* line # 360 */
  PAS_INSMBOL_PRC_00000000(Rd.s+370,39,29);
  Ra.sl[6]=361; /* line # 361 */
  PAS_INSMBOL_PRC_00000000(Rd.s+376,40,29);
  Ra.sl[6]=362; /* line # 362 */
  PAS_INSMBOL_PRC_00000000(Rd.s+383,41,29);
  Ra.sl[6]=363; /* line # 363 */
  PAS_INSMBOL_PRC_00000000(Rd.s+391,37,29);
  Ra.sl[6]=364; /* line # 364 */
  PAS_INSMBOL_PRC_00000000(Rd.s+399,42,29);
  Ra.sl[6]=365; /* line # 365 */
  PAS_INSMBOL_PRC_00000000(Rd.s+404,73,29);
  Ra.sl[6]=366; /* line # 366 */
  PAS_INSMBOL_PRC_00000000(Rd.s+409,58,29);
  Ra.sl[6]=367; /* line # 367 */
  PAS_INSMBOL_PRC_00000000(Rd.s+414,59,29);
  Ra.sl[6]=368; /* line # 368 */
  PAS_INSMBOL_PRC_00000000(Rd.s+420,60,29);
  Ra.sl[6]=369; /* line # 369 */
  PAS_INSMBOL_PRC_00000000(Rd.s+429,61,29);
  Ra.sl[6]=370; /* line # 370 */
  PAS_INSMBOL_PRC_00000000(Rd.s+435,62,29);
  Ra.sl[6]=371; /* line # 371 */
  PAS_INSMBOL_PRC_00000000(Rd.s+442,63,29);
  Ra.sl[6]=372; /* line # 372 */
  PAS_INSMBOL_PRC_00000000(Rd.s+451,64,29);
  Ra.sl[6]=374; /* line # 374 */
  PAS_INSMBOL_PRC_00000000(Rd.s+459,65,29);
  Ra.sl[6]=375; /* line # 375 */
  PAS_INSMBOL_PRC_00000000(Rd.s+465,66,29);
  Ra.sl[6]=376; /* line # 376 */
  PAS_INSMBOL_PRC_00000000(Rd.s+473,67,29);
  Ra.sl[6]=377; /* line # 377 */
  PAS_INSMBOL_PRC_00000000(Rd.s+480,68,29);
  Ra.sl[6]=378; /* line # 378 */
  PAS_INSMBOL_PRC_00000000(Rd.s+487,69,29);
  Ra.sl[6]=379; /* line # 379 */
  PAS_INSMBOL_PRC_00000000(Rd.s+496,70,29);
  Ra.sl[6]=381; /* line # 381 */
  PAS_INSMBOL_PRC_00000000(Rd.s+504,75,29);
  Ra.sl[6]=382; /* line # 382 */
  PAS_INSMBOL_PRC_00000000(Rd.s+513,74,29);
  Ra.sl[6]=383; /* line # 383 */
  PAS_INSMBOL_PRC_00000000(Rd.s+521,76,29);
  Ra.sl[6]=384; /* line # 384 */
  PAS_INSMBOL_PRC_00000000(Rd.s+532,77,29);
  Ra.sl[6]=385; /* line # 385 */
  PAS_INSMBOL_PRC_00000000(Rd.s+542,86,29);
  Ra.sl[6]=386; /* line # 386 */
  PAS_INSMBOL_PRC_00000000(Rd.s+550,78,29);
  Ra.sl[6]=387; /* line # 387 */
  PAS_INSMBOL_PRC_00000000(Rd.s+558,79,29);
  Ra.sl[6]=389; /* line # 389 */
  PAS_INSMBOL_PRC_00000000(Rd.s+567,80,29);
  Ra.sl[6]=390; /* line # 390 */
  PAS_INSMBOL_PRC_00000000(Rd.s+575,81,29);
  Ra.sl[6]=391; /* line # 391 */
  PAS_INSMBOL_PRC_00000000(Rd.s+583,82,29);
  Ra.sl[6]=392; /* line # 392 */
  PAS_INSMBOL_PRC_00000000(Rd.s+591,84,29);
  Ra.sl[6]=393; /* line # 393 */
  PAS_INSMBOL_PRC_00000000(Rd.s+599,83,29);
  Ra.sl[6]=394; /* line # 394 */
  PAS_INSMBOL_PRC_00000000(Rd.s+609,85,29);
  Ra.sl[6]=396; /* line # 396 */
  PAS_INSMBOL_PRC_00000000(Rd.s+619,71,29);
  Ra.sl[6]=397; /* line # 397 */
  PAS_INSMBOL_PRC_00000000(Rd.s+626,44,29);
  Ra.sl[6]=398; /* line # 398 */
  PAS_INSMBOL_PRC_00000000(Rd.s+630,45,29);
  Ra.sl[6]=399; /* line # 399 */
  PAS_INSMBOL_PRC_00000000(Rd.s+636,46,29);
  Ra.sl[6]=400; /* line # 400 */
  PAS_INSMBOL_PRC_00000000(Rd.s+642,47,29);
  Ra.sl[6]=401; /* line # 401 */
  PAS_INSMBOL_PRC_00000000(Rd.s+649,48,29);
  Ra.sl[6]=402; /* line # 402 */
  PAS_INSMBOL_PRC_00000000(Rd.s+657,49,29);
  Ra.sl[6]=403; /* line # 403 */
  PAS_INSMBOL_PRC_00000000(Rd.s+664,50,29);
  Ra.sl[6]=404; /* line # 404 */
  PAS_INSMBOL_PRC_00000000(Rd.s+669,54,29);
  Ra.sl[6]=405; /* line # 405 */
  PAS_INSMBOL_PRC_00000000(Rd.s+675,55,29);
  Ra.sl[6]=406; /* line # 406 */
  PAS_INSMBOL_PRC_00000000(Rd.s+681,56,29);
  Ra.sl[6]=407; /* line # 407 */
  PAS_INSMBOL_PRC_00000000(Rd.s+687,57,29);
  Ra.sl[6]=408; /* line # 408 */
  PAS_INSMBOL_PRC_00000000(Rd.s+693,72,29);
  Ra.sl[6]=409; /* line # 409 */
  PAS_INSMBOL_PRC_00000000(Rd.s+698,88,29);
  Ra.sl[6]=410; /* line # 410 */
  PAS_INSMBOL_PRC_00000000(Rd.s+709,87,29);
  Ra.sl[6]=411; /* line # 411 */
  PAS_INSMBOL_PRC_00000000(Rd.s+713,53,29);
  Ra.sl[6]=412; /* line # 412 */
  PAS_INSMBOL_PRC_00000000(Rd.s+717,51,29);
  Ra.sl[6]=413; /* line # 413 */
  PAS_INSMBOL_PRC_00000000(Rd.s+721,52,29);
  Ra.sl[6]=415; /* line # 415 */
  PAS_INSMBOL_PRC_00000000(Rd.s+729,91,29);
  Ra.sl[6]=416; /* line # 416 */
  PAS_INSMBOL_PRC_00000000(Rd.s+738,92,29);
  Ra.sl[6]=417; /* line # 417 */
  PAS_INSMBOL_PRC_00000000(Rd.s+749,93,29);
  Ra.sl[6]=418; /* line # 418 */
  PAS_INSMBOL_PRC_00000000(Rd.s+755,94,29);
  Ra.sl[6]=419; /* line # 419 */
  PAS_INSMBOL_PRC_00000000(Rd.s+760,95,29);
  Ra.sl[6]=420; /* line # 420 */
  PAS_INSMBOL_PRC_00000000(Rd.s+768,96,29);
  Ra.sl[6]=421; /* line # 421 */
  PAS_INSMBOL_PRC_00000000(Rd.s+778,97,29);
  Ra.sl[6]=422; /* line # 422 */
  PAS_INSMBOL_PRC_00000000(Rd.s+785,98,29);
  Ra.sl[6]=423; /* line # 423 */
  PAS_INSMBOL_PRC_00000000(Rd.s+792,99,29);
  Ra.sl[6]=424; /* line # 424 */
  PAS_INSMBOL_PRC_00000000(Rd.s+799,100,29);
  Ra.sl[6]=426; /* line # 426 */
  PAS_INSMBOL_PRC_00000000(Rd.s+807,102,29);
  Ra.sl[6]=427; /* line # 427 */
  PAS_INSMBOL_PRC_00000000(Rd.s+817,104,29);
  Ra.sl[6]=428; /* line # 428 */
  PAS_INSMBOL_PRC_00000000(Rd.s+826,103,29);
  Ra.sl[6]=429; /* line # 429 */
  PAS_INSMBOL_PRC_00000000(Rd.s+836,105,29);
  Ra.sl[6]=434; /* line # 434 */
  PAS_INSMBOL_PRC_00000000(Rd.s+845,106,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_mac_ident "  */
V P_create_mac_ident(V F_id, UB F_cmdf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+851;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=454; /* line # 454 */
  Rv0=V_macsymb_tree;
  Ra.sl[6]=455; /* line # 455 */
  Rv1=NULL;
  Ra.sl[6]=456; /* line # 456 */
  Rv2=1;
  Ra.sl[6]=457; /* line # 457 */
  while (Rv0!=NULL&&Rv2!=0){
    Ra.sl[6]=459; /* line # 459 */
    Rv1=Rv0;
    Ra.sl[6]=460; /* line # 460 */
    Rv3=Rv0;
    Ra.sl[6]=462; /* line # 462 */
    Rv2=P_match(F_id,Rv3);
    Ra.sl[6]=463; /* line # 463 */
    if (Rv2!=0) {
      Ra.sl[6]=464; /* line # 464 */
      if (Rv2>0) Rv0=((V *)Rv3)[6];
      else {
        Ra.sl[6]=465; /* line # 465 */
        Rv0=((V *)Rv3)[5];
      }
    }
  }
  Ra.sl[6]=468; /* line # 468 */
  if (Rv2==0) {
    Ra.sl[6]=469; /* line # 469 */
    if (F_cmdf) Rv4=Rv0;
    else {
      Ra.sl[6]=470; /* line # 470 */
      P_src_error_s(Rd.s+871,921,2, F_id,NULL);
    }
  }
  else {
    Ra.sl[6]=473; /* line # 473 */
    Rv4=PAS__NEW(80);
    Ra.sl[6]=474; /* line # 474 */
    Rv5=Rv4;
    Ra.sl[6]=476; /* line # 476 */
    memcpy(Rv5,F_id,32);
    Ra.sl[6]=477; /* line # 477 */
    ((V *)Rv5)[4]=NULL;
    Ra.sl[6]=478; /* line # 478 */
    ((V *)Rv5)[5]=NULL;
    Ra.sl[6]=479; /* line # 479 */
    ((V *)Rv5)[6]=NULL;
    Ra.sl[6]=480; /* line # 480 */
    ((UB *)Rv5)[56]=0;
    Ra.sl[6]=481; /* line # 481 */
    memcpy(Rv5+64,Rd.s+880,16);
    Ra.sl[6]=483; /* line # 483 */
    if (Rv1==NULL) {
      Ra.sl[6]=484; /* line # 484 */
      V_macsymb_tree=Rv4;
    }
    else {
      Ra.sl[6]=486; /* line # 486 */
      if (Rv2>0) ((V *)Rv1)[6]=Rv4;
      else {
        Ra.sl[6]=487; /* line # 487 */
        ((V *)Rv1)[5]=Rv4;
      }
    }
  }
  Ra.sl[6]=489; /* line # 489 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sortmc1 "  */
void PAS_INSMBOL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+896;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=516; /* line # 516 */
  Rv0=F_p;
  Ra.sl[6]=518; /* line # 518 */
  if (((V *)Rv0)[5]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[5]);
  Ra.sl[6]=519; /* line # 519 */
  Rv1=((UB *)Rv0)[0]==0;
  Ra.sl[6]=520; /* line # 520 */
  if (!Rv1) {
    Ra.sl[6]=522; /* line # 522 */
    if (V_macsymb_frst==NULL) V_macsymb_frst=F_p;
    else {
      Ra.sl[6]=523; /* line # 523 */
      ((V *)Lx[0].v[0])[4]=F_p;
    }
    Ra.sl[6]=524; /* line # 524 */
    Lx[0].v[0]=F_p;
    Ra.sl[6]=525; /* line # 525 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=526; /* line # 526 */
    Lx[0].sl[2]=Lx[0].sl[2]+1;
  }
  Ra.sl[6]=528; /* line # 528 */
  if (((V *)Rv0)[6]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[6]);
  Ra.sl[6]=530; /* line # 530 */
  if (Rv1) {
    Ra.sl[6]=532; /* line # 532 */
    Rv2=F_p;
    Rv3=Rv2+64;
    Ra.sl[6]=533; /* line # 533 */
    if (((V *)Rv3)[1]!=NULL) PAS__DISPOSE(((V *)Rv3)+1);
    Ra.sl[6]=534; /* line # 534 */
    PAS__DISPOSE(&F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rebuild_mctree1 "  */
V PAS_INSMBOL_PRC_00000002(SL F_n, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+905;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=547; /* line # 547 */
  Rv0=(F_n+F_m)/2;
  Ra.sl[6]=548; /* line # 548 */
  Rv1=((V *)Lx[0].v[2])[Rv0];
  Ra.sl[6]=549; /* line # 549 */
  Rv2=Rv1;
  Ra.sl[6]=551; /* line # 551 */
  if (Rv0==F_n) ((V *)Rv2)[5]=NULL;
  else {
    Ra.sl[6]=552; /* line # 552 */
    ((V *)Rv2)[5]=PAS_INSMBOL_PRC_00000002(F_n, Rv0-1);
  }
  Ra.sl[6]=553; /* line # 553 */
  if (Rv0==F_m) ((V *)Rv2)[6]=NULL;
  else {
    Ra.sl[6]=554; /* line # 554 */
    ((V *)Rv2)[6]=PAS_INSMBOL_PRC_00000002(Rv0+1, F_m);
  }
  Ra.sl[6]=556; /* line # 556 */
  Ret=Rv1;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rebuild_mctree "  */
void P_rebuild_mctree(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+922;
  Ra.v[5]=Rd.s+16;
  Ra.sl[12]=562; /* line # 562 */
  Ra.sl[2]=0;
  Ra.sl[12]=563; /* line # 563 */
  V_macsymb_frst=NULL;
  Ra.sl[12]=564; /* line # 564 */
  if (V_macsymb_tree!=NULL) {
    Ra.sl[12]=566; /* line # 566 */
    PAS_INSMBOL_PRC_00000001(V_macsymb_tree);
    Ra.sl[12]=567; /* line # 567 */
    if (Ra.sl[2]>0) {
      Ra.sl[12]=569; /* line # 569 */
      Ra.v[0]=V_macsymb_frst;
      Ra.sl[12]=570; /* line # 570 */
      Rv0=Ra.sl[2];
      Ra.v[2]=PAS__NEW(Rv0*8+8);
      ((SL *)Ra.v[2])[0]=Rv0;
      Ra.sl[12]=571; /* line # 571 */
      Rv1=1;
      for( Rf0=Ra.sl[2];Rf0>0;Rf0-- ) {
        Ra.sl[12]=572; /* line # 572 */
        ((V *)Ra.v[2])[Rv1]=Ra.v[0];
        Ra.v[0]=((V *)Ra.v[0])[4];
        Rv1++;
      }
      Ra.sl[12]=574; /* line # 574 */
      V_macsymb_tree=PAS_INSMBOL_PRC_00000002(1, Ra.sl[2]);
    }
    else {
      Ra.sl[12]=578; /* line # 578 */
      V_macsymb_tree=NULL;
      Ra.sl[12]=579; /* line # 579 */
      V_macsymb_frst=NULL;
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+938;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=670; /* line # 670 */
  V_sy_ch=P_src_inchar();
  Ra.sl[6]=671; /* line # 671 */
  V_sy_cmin=V_sy_ch;
  Ra.sl[6]=672; /* line # 672 */
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  Ra.sl[6]=673; /* line # 673 */
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+946;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=679; /* line # 679 */
  if (!Rs.ub[0]) {
    Ra.sl[6]=680; /* line # 680 */
    if (Rs.sl[1]<V_sy_string.ub[0]) {
      Ra.sl[6]=682; /* line # 682 */
      V_sy_string.c[Rs.sl[1]+1]=V_sy_ch;
      Ra.sl[6]=683; /* line # 683 */
      Rs.sl[1]=Rs.sl[1]+1;
    }
    else {
      Ra.sl[6]=687; /* line # 687 */
      P_src_error(Rd.s+958,12,2);
      Ra.sl[6]=688; /* line # 688 */
      Rs.ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000005(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+962;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=698; /* line # 698 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    Ra.sl[6]=700; /* line # 700 */
    if ((Rs.ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else {
      Ra.sl[6]=701; /* line # 701 */
      Rv0=-1;
    }
  }
  Ra.sl[6]=702; /* line # 702 */
  if (Rv0>=Rs.sl[3]) Rv0=-2;
  Ra.sl[6]=703; /* line # 703 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000006(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+976;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=714; /* line # 714 */
  Rv0=PAS_INSMBOL_PRC_00000005(F_ch);
  Ra.sl[6]=715; /* line # 715 */
  if (Rv0==-2) {
    Ra.sl[6]=717; /* line # 717 */
    Rv0=0;
    P_src_error(Rd.s+987,16,2);
  }
  Ra.sl[6]=719; /* line # 719 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000007(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+991;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=729; /* line # 729 */
  Ri.sl[0]=Ri.sl[0]+1;
  Ra.sl[6]=730; /* line # 730 */
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1004,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  Ra.sl[6]=731; /* line # 731 */
  if (F_ierr>=20&&F_ierr<=25) {
    Ra.sl[6]=733; /* line # 733 */
    if (!Rs.ub[16]) {
      Ra.sl[6]=735; /* line # 735 */
      P_src_error(Rd.s+958,11,2);
      Ra.sl[6]=736; /* line # 736 */
      Rs.g[3]=1.000000000000000E+000;
      Rs.g[4]=1.000000000000000E+000;
      Ra.sl[6]=737; /* line # 737 */
      Rs.ub[16]=1;
    }
    Ra.sl[6]=739; /* line # 739 */
    Ret=1;
  }
  else {
    Ra.sl[6]=742; /* line # 742 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1017;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=748; /* line # 748 */
  while (V_sy_ch==32||V_sy_ch==0)
  PAS_INSMBOL_PRC_00000003();
  Ra.sl[6]=749; /* line # 749 */
  Rs.ub[40]=1;
  Ra.sl[6]=750; /* line # 750 */
  Rs.ub[41]=V_sy_attrflg;
  Ra.sl[6]=751; /* line # 751 */
  V_sy_attrflg=0;
  Ra.sl[6]=752; /* line # 752 */
  Rv0=V_src_control;
  ((SL *)Rv0)[4]=((SL *)Rv0)[5];
  Ra.sl[6]=753; /* line # 753 */
  Ra.sl[6]=754; /* line # 754 */
  switch (Ri.ub[V_sy_cmin+4]) {
    case 8:
    case 9:Ra.sl[6]=757; /* line # 757 */
    PAS__ESTABLISH(PAS_INSMBOL_PRC_00000007);
    Ra.sl[6]=758; /* line # 758 */
    Rs.ub[16]=0;
    Ra.sl[6]=759; /* line # 759 */
    V_sy_sym.ub[0]=19;
    Ra.sl[6]=760; /* line # 760 */
    V_sy_sym.ub[1]=29;
    Ra.sl[6]=761; /* line # 761 */
    Rs.g[6]=0.000000000000000E-001;
    Ra.sl[6]=762; /* line # 762 */
    Rs.sl[3]=10;
    Ra.sl[6]=763; /* line # 763 */
    Rs.sl[14]=0;
    Ra.sl[6]=764; /* line # 764 */
    Rs.ub[8]=0;
    Ra.sl[6]=765; /* line # 765 */
    while (Ri.ub[V_sy_cmin+4]==8){
      Ra.sl[6]=767; /* line # 767 */
      V_sy_sym.ub[0]=2;
      Ra.sl[6]=768; /* line # 768 */
      Rs.sl[15]=(SL)V_sy_cmin-48;
      Ra.sl[6]=769; /* line # 769 */
      if (Rs.sl[14]>0||Rs.sl[15]>0) Rs.sl[14]=Rs.sl[14]+1;
      while (1){
        Ra.sl[6]=770; /* line # 770 */
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_cmin!=95)  break;
      }
      Ra.sl[6]=771; /* line # 771 */
      if (!Rs.ub[16]) Rs.g[6]=Rs.g[6]*1.000000000000000E+001+(double)Rs.sl[15];
    }
    Ra.sl[6]=774; /* line # 774 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Ra.sl[6]=776; /* line # 776 */
      Rs.sl[14]=0;
      Ra.sl[6]=777; /* line # 777 */
      Rs.sl[3]=PAS__G_ROUND(Rs.g[6]);
      Ra.sl[6]=778; /* line # 778 */
      if (Rs.sl[3]<2||Rs.sl[3]>16) {
        Ra.sl[6]=780; /* line # 780 */
        P_src_error(Rd.s+958,14,2);
        Ra.sl[6]=781; /* line # 781 */
        Rs.sl[3]=10;
      }
      Ra.sl[6]=783; /* line # 783 */
      Rs.ub[8]=1;
      Ra.sl[6]=784; /* line # 784 */
      Rs.g[6]=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[6]=786; /* line # 786 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Ra.sl[6]=787; /* line # 787 */
        Rs.sl[15]=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
        Ra.sl[6]=788; /* line # 788 */
        if ((float)Rs.sl[15]<(F)0.000000E-01)  break;
        Ra.sl[6]=789; /* line # 789 */
        if (!Rs.ub[16]) Rs.g[6]=Rs.g[6]*(double)Rs.sl[3]+(double)Rs.sl[15];
        Ra.sl[6]=790; /* line # 790 */
        if (Rs.sl[14]>0||Rs.sl[15]>0) Rs.sl[14]=Rs.sl[14]+1;
      }
    }
    Ra.sl[6]=795; /* line # 795 */
    Rs.g[8]=(double)Rs.sl[3];
    Rs.g[3]=Rs.g[8];
    Ra.sl[6]=797; /* line # 797 */
    if (V_sy_ch==46) {
      Ra.sl[6]=799; /* line # 799 */
      if (P_src_next_char()==46) {
        Ra.sl[6]=800; /* line # 800 */
        if (V_sy_sym.ub[0]==19) {
          Ra.sl[6]=802; /* line # 802 */
          PAS_INSMBOL_PRC_00000003();
          Ra.sl[6]=803; /* line # 803 */
          V_sy_sym.ub[0]=20;
        }
        else {
          Ra.sl[6]=805; /* line # 805 */
          Rs.ub[40]=0;
        }
      }
      else {
        while (1){
          Ra.sl[6]=808; /* line # 808 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Ra.sl[6]=809; /* line # 809 */
        Rs.g[8]=(double)Rs.sl[3];
        Rs.g[3]=Rs.g[8];
        Rs.g[4]=1.000000000000000E+000;
        Ra.sl[6]=810; /* line # 810 */
        if (PAS_INSMBOL_PRC_00000005(V_sy_cmin)<0) {
          Ra.sl[6]=811; /* line # 811 */
          Rs.ub[40]=0;
        }
        else {
          Ra.sl[6]=814; /* line # 814 */
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[6]=816; /* line # 816 */
            if (Rs.g[4]!=1.000000000000000E+000) while (1){
              Ra.sl[6]=817; /* line # 817 */
              PAS_INSMBOL_PRC_00000003();
              if (V_sy_cmin!=95)  break;
            }
            Ra.sl[6]=818; /* line # 818 */
            Rs.sl[15]=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
            Ra.sl[6]=819; /* line # 819 */
            if (Rs.sl[15]<0)  break;
            Ra.sl[6]=820; /* line # 820 */
            Rs.g[4]=Rs.g[4]/Rs.g[8];
            Ra.sl[6]=821; /* line # 821 */
            Rs.g[6]=Rs.g[6]+Rs.g[4]*(double)Rs.sl[15];
            Ra.sl[6]=822; /* line # 822 */
            Rs.sl[14]=Rs.sl[14]+1;
          }
        }
      }
    }
    Ra.sl[6]=828; /* line # 828 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=830; /* line # 830 */
    if (V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=20) {
      Ra.sl[6]=832; /* line # 832 */
      if (V_sy_cmin==101) {
        Ra.sl[6]=834; /* line # 834 */
        V_sy_sym.ub[0]=4;
        Ra.sl[6]=835; /* line # 835 */
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[6]=836; /* line # 836 */
        if (V_sy_ch==43||V_sy_ch==45) {
          Ra.sl[6]=838; /* line # 838 */
          if (V_sy_ch==45) Rs.g[3]=1.000000000000000E+000/Rs.g[3];
          Ra.sl[6]=839; /* line # 839 */
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[6]=841; /* line # 841 */
        Rs.sl[18]=0;
        Ra.sl[6]=843; /* line # 843 */
        while (Ri.ub[V_sy_cmin+4]==8){
          Ra.sl[6]=845; /* line # 845 */
          Rs.sl[18]=Rs.sl[18]*10+((SL)V_sy_ch-48);
          Ra.sl[6]=846; /* line # 846 */
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[6]=850; /* line # 850 */
        Rs.g[4]=1.000000000000000E+000;
        Ra.sl[6]=851; /* line # 851 */
        while (Rs.sl[18]!=0&&!Rs.ub[16]){
          Ra.sl[6]=853; /* line # 853 */
          if (Rs.sl[18]&1) {
            Ra.sl[6]=855; /* line # 855 */
            Rs.sl[18]=Rs.sl[18]-1;
            Ra.sl[6]=856; /* line # 856 */
            Rs.g[4]=Rs.g[4]*Rs.g[3];
          }
          else {
            Ra.sl[6]=860; /* line # 860 */
            Rs.sl[18]=Rs.sl[18]/2;
            Ra.sl[6]=861; /* line # 861 */
            Rs.g[3]=PAS__G_SQR(Rs.g[3]);
          }
        }
        Ra.sl[6]=864; /* line # 864 */
        if (!Rs.ub[16]) Rs.g[6]=Rs.g[6]*Rs.g[4];
      }
      Ra.sl[6]=867; /* line # 867 */
      if (Rs.ub[16]) Rs.g[6]=0.000000000000000E-001;
      Ra.sl[6]=869; /* line # 869 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[6]=871; /* line # 871 */
        if (Rs.g[6]<=4.294967295000001E+009&&Rs.g[6]>=-2.147483648000001E+009) {
          Ra.sl[6]=873; /* line # 873 */
          if (Rs.g[6]>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rs.g[6])+1;
          else {
            Ra.sl[6]=874; /* line # 874 */
            V_sy_ival=(int)(Rs.g[6]);
          }
          Ra.sl[6]=875; /* line # 875 */
          V_sy_rval=(double)V_sy_ival;
          Ra.sl[6]=876; /* line # 876 */
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
            Ra.sl[6]=879; /* line # 879 */
            PAS_INSMBOL_PRC_00000003();
            Ra.sl[6]=880; /* line # 880 */
            P_ide_int_label();
            Ra.sl[6]=881; /* line # 881 */
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[6]=884; /* line # 884 */
          V_sy_sym.ub[0]=4;
        }
      }
      Ra.sl[6]=887; /* line # 887 */
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[6]=889; /* line # 889 */
        V_sy_ival=0;
        Ra.sl[6]=890; /* line # 890 */
        if (Rs.g[6]>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[6]=894; /* line # 894 */
          if (Rs.sl[3]>2) Rs.sl[14]=Rs.sl[14]*(int)(log(Rs.g[8])/6.931471805599453E-001)
          +2;
          else {
            Ra.sl[6]=895; /* line # 895 */
            Rs.sl[14]=Rs.sl[14]+2;
          }
          Ra.sl[6]=897; /* line # 897 */
          if (Rs.sl[14]>24) V_sy_sym.ub[0]=4;
          else {
            Ra.sl[6]=898; /* line # 898 */
            V_sy_sym.ub[0]=3;
          }
        }
      }
      Ra.sl[6]=901; /* line # 901 */
      V_sy_rval=Rs.g[6];
      Ra.sl[6]=902; /* line # 902 */
      Rs.ub[40]=0;
    }
    Ra.sl[6]=904; /* line # 904 */
    PAS__REVERT();
    break;
    case 7:Ra.sl[6]=908; /* line # 908 */
    Ra.sl[6]=910; /* line # 910 */
    V_sy_ident.ub[0]=0;
    while (1){
      Ra.sl[6]=912; /* line # 912 */
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[6]=915; /* line # 915 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        Ra.sl[6]=916; /* line # 916 */
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      Ra.sl[6]=918; /* line # 918 */
      PAS_INSMBOL_PRC_00000003();
      if (Ri.ub[V_sy_cmin+4]!=7&&Ri.ub[V_sy_cmin+4]!=8)  break;
    }
    Ra.sl[6]=921; /* line # 921 */
    Rs.v[10]=V_keyword_tree;
    while (1){
      Ra.sl[6]=923; /* line # 923 */
      Rv1=Rs.v[10];
      Ra.sl[6]=925; /* line # 925 */
      Rs.sl[22]=P_match(V_sy_ident.s,Rv1);
      Ra.sl[6]=926; /* line # 926 */
      if (Rs.sl[22]!=0) {
        Ra.sl[6]=927; /* line # 927 */
        if (Rs.sl[22]>0) Rs.v[10]=((V *)Rv1)[5];
        else Rs.v[10]=((V *)Rv1)[4];
      }
      if (Rs.sl[22]==0||Rs.v[10]==NULL)  break;
    }
    Ra.sl[6]=930; /* line # 930 */
    if (Rs.v[10]!=NULL) {
      Ra.sl[6]=931; /* line # 931 */
      memcpy(V_sy_sym.s,Rs.v[10]+48,2);
    }
    else {
      Ra.sl[6]=934; /* line # 934 */
      V_sy_macsymb=V_macsymb_tree;
      Ra.sl[6]=936; /* line # 936 */
      V_sy_sym.ub[0]=101;
      Ra.sl[6]=937; /* line # 937 */
      Rs.sl[22]=1;
      Ra.sl[6]=938; /* line # 938 */
      while (Rs.sl[22]!=0&&V_sy_macsymb!=NULL){
        Ra.sl[6]=939; /* line # 939 */
        Rv2=V_sy_macsymb;
        Ra.sl[6]=941; /* line # 941 */
        Rs.sl[22]=P_match(V_sy_ident.s,Rv2);
        Ra.sl[6]=942; /* line # 942 */
        if (Rs.sl[22]!=0) {
          Ra.sl[6]=943; /* line # 943 */
          if (Rs.sl[22]>0) V_sy_macsymb=((V *)Rv2)[6];
          else V_sy_macsymb=((V *)Rv2)[5];
        }
      }
      Ra.sl[6]=945; /* line # 945 */
      if (Rs.sl[22]==0) V_sy_sym.ub[0]=101;
      else {
        Ra.sl[6]=948; /* line # 948 */
        if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
          Ra.sl[6]=951; /* line # 951 */
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=1;
        }
        else {
          Ra.sl[6]=955; /* line # 955 */
          if (Ri.ub[V_sy_cmin+4]==6) {
            Ra.sl[6]=956; /* line # 956 */
            V_sy_attrflg=1;
          }
          Ra.sl[6]=957; /* line # 957 */
          V_sy_sym.ub[0]=0;
        }
      }
      Ra.sl[6]=960; /* line # 960 */
      V_sy_sym.ub[1]=29;
    }
    Ra.sl[6]=962; /* line # 962 */
    Rs.ub[40]=0;
    break;
    case 6:Ra.sl[6]=966; /* line # 966 */
    if (Rs.ub[41]) {
      Ra.sl[6]=968; /* line # 968 */
      V_sy_sym.ub[0]=24;
      V_sy_sym.ub[1]=29;
      Ra.sl[6]=969; /* line # 969 */
      Rs.ub[41]=0;
    }
    else {
      Ra.sl[6]=973; /* line # 973 */
      V_sy_sym.ub[1]=29;
      Ra.sl[6]=975; /* line # 975 */
      Rv3=V_src_control;
      Ra.sl[6]=977; /* line # 977 */
      Rs.ub[92]=(524288&((UL *)Rv3)[62])!=0;
      Ra.sl[6]=978; /* line # 978 */
      ((UB *)Rv3)[252]=4;
      Ra.sl[6]=979; /* line # 979 */
      ((UL *)Rv3)[62]=((UL *)Rv3)[62]|524288;
      Ra.sl[6]=981; /* line # 981 */
      Rs.c[93]=V_sy_cmin;
      Ra.sl[6]=982; /* line # 982 */
      V_sy_sym.ub[0]=5;
      Ra.sl[6]=983; /* line # 983 */
      Rs.sl[1]=1;
      Rs.ub[0]=0;
      Ra.sl[6]=984; /* line # 984 */
      Rs.ub[94]=1;
      Ra.sl[6]=985; /* line # 985 */
      while (Rs.ub[94]){
        Ra.sl[6]=987; /* line # 987 */
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[6]=988; /* line # 988 */
        while (Ri.ub[V_sy_cmin+4]==1)
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[6]=989; /* line # 989 */
        if (Ri.ub[V_sy_cmin+4]==2) Rs.ub[94]=0;
        Ra.sl[6]=990; /* line # 990 */
        if (V_sy_ch==Rs.c[93]) {
          Ra.sl[6]=992; /* line # 992 */
          if (Rs.c[93]==P_src_next_char()) {
            Ra.sl[6]=994; /* line # 994 */
            PAS_INSMBOL_PRC_00000003();
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            Ra.sl[6]=998; /* line # 998 */
            ((UB *)V_src_control)[252]=0;
            Ra.sl[6]=999; /* line # 999 */
            Rs.ub[94]=0;
          }
        }
        else {
          Ra.sl[6]=1003; /* line # 1003 */
          if (Rs.c[93]==34&&V_sy_ch==92) {
            Ra.sl[6]=1005; /* line # 1005 */
            PAS_INSMBOL_PRC_00000003();
            Ra.sl[6]=1006; /* line # 1006 */
            switch (V_sy_cmin) {
              case 34:
              case 39:
              case 92:break;
              case 97:Ra.sl[6]=1008; /* line # 1008 */
              V_sy_ch=7;
              break;
              case 98:Ra.sl[6]=1009; /* line # 1009 */
              V_sy_ch=8;
              break;
              case 101:Ra.sl[6]=1010; /* line # 1010 */
              V_sy_ch=27;
              break;
              case 102:Ra.sl[6]=1011; /* line # 1011 */
              V_sy_ch=12;
              break;
              case 110:Ra.sl[6]=1012; /* line # 1012 */
              V_sy_ch=10;
              break;
              case 114:Ra.sl[6]=1013; /* line # 1013 */
              V_sy_ch=13;
              break;
              case 116:Ra.sl[6]=1014; /* line # 1014 */
              V_sy_ch=9;
              break;
              case 118:Ra.sl[6]=1015; /* line # 1015 */
              V_sy_ch=11;
              break;
              case 122:Ra.sl[6]=1016; /* line # 1016 */
              V_sy_ch=0;
              break;
              case 48:
              case 49:
              case 50:
              case 51:
              case 52:
              case 53:
              case 54:
              case 55:
              case 56:
              case 57:Ra.sl[6]=1019; /* line # 1019 */
              Rs.sl[22]=(SL)V_sy_cmin-48;
              PAS_INSMBOL_PRC_00000003();
              Ra.sl[6]=1020; /* line # 1020 */
              Rs.sl[24]=3;
              Ra.sl[6]=1021; /* line # 1021 */
              while ((Rs.sl[24]>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
                Ra.sl[6]=1023; /* line # 1023 */
                Rs.sl[22]=(Rs.sl[22]*10+(SL)V_sy_cmin)-48;
                Ra.sl[6]=1024; /* line # 1024 */
                PAS_INSMBOL_PRC_00000003();
              }
              Ra.sl[6]=1026; /* line # 1026 */
              if (Rs.sl[22]<=255) V_sy_ch=(C)Rs.sl[22];
              else {
                Ra.sl[6]=1027; /* line # 1027 */
                V_sy_ch=32;
                P_src_error(Rd.s+958,17,2);
              }
              break;
              default:Ra.sl[6]=1030; /* line # 1030 */
              V_sy_ch=32;
              P_src_error(Rd.s+958,18,2);
              break;
            }
            Ra.sl[6]=1032; /* line # 1032 */
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            Ra.sl[6]=1034; /* line # 1034 */
            PAS_INSMBOL_PRC_00000004();
          }
        }
      }
      Ra.sl[6]=1036; /* line # 1036 */
      V_sy_string.ub[1]=Rs.sl[1] -1;
      Ra.sl[6]=1038; /* line # 1038 */
      Rv4=V_src_control;
      Ra.sl[6]=1039; /* line # 1039 */
      if (!Rs.ub[92]) {
        Ra.sl[6]=1041; /* line # 1041 */
        ((UL *)Rv4)[62]=((UL *)Rv4)[62]&~524288;
        Ra.sl[6]=1042; /* line # 1042 */
        if (Ri.ub[V_sy_cmin+4]==1) V_sy_ch=32;
      }
    }
    break;
    case 14:Ra.sl[6]=1048; /* line # 1048 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1049; /* line # 1049 */
    V_sy_sym.ub[1]=29;
    Ra.sl[6]=1050; /* line # 1050 */
    if (V_sy_ch==61) V_sy_sym.ub[0]=22;
    else {
      Ra.sl[6]=1051; /* line # 1051 */
      V_sy_sym.ub[0]=21;
      Rs.ub[40]=0;
    }
    break;
    case 11:Ra.sl[6]=1056; /* line # 1056 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1057; /* line # 1057 */
    V_sy_sym.ub[0]=10;
    Ra.sl[6]=1058; /* line # 1058 */
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      Ra.sl[6]=1060; /* line # 1060 */
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[6]=1061; /* line # 1061 */
        V_sy_sym.ub[1]=14;
        Rs.ub[40]=0;
      }
    }
    break;
    case 13:Ra.sl[6]=1066; /* line # 1066 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1067; /* line # 1067 */
    V_sy_sym.ub[0]=10;
    Ra.sl[6]=1068; /* line # 1068 */
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      Ra.sl[6]=1069; /* line # 1069 */
      V_sy_sym.ub[1]=17;
      Rs.ub[40]=0;
    }
    break;
    case 5:Ra.sl[6]=1074; /* line # 1074 */
    Rs.c[93]=V_sy_ch;
    Ra.sl[6]=1075; /* line # 1075 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1076; /* line # 1076 */
    if (V_sy_ch==Rs.c[93]) {
      V_sy_sym.ub[0]=9;
      V_sy_sym.ub[1]=13;
    }
    else {
      Ra.sl[6]=1077; /* line # 1077 */
      V_sy_sym.ub[0]=12;
      V_sy_sym.ub[1]=21;
      Rs.ub[40]=0;
    }
    break;
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[6]=1082; /* line # 1082 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    break;
    case 17:
    case 25:
    case 26:Ra.sl[6]=1086; /* line # 1086 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    Ra.sl[6]=1087; /* line # 1087 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1088; /* line # 1088 */
    if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
    Ra.sl[6]=1089; /* line # 1089 */
    Rs.ub[40]=0;
    break;
    case 10:Ra.sl[6]=1094; /* line # 1094 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1095; /* line # 1095 */
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      Ra.sl[6]=1096; /* line # 1096 */
      V_sy_sym.ub[0]=8;
      V_sy_sym.ub[1]=6;
      Rs.ub[40]=0;
    }
    break;
    case 12:Ra.sl[6]=1101; /* line # 1101 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1102; /* line # 1102 */
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=25;
      V_sy_sym.ub[1]=29;
    }
    else {
      Ra.sl[6]=1103; /* line # 1103 */
      V_sy_sym.ub[0]=10;
      V_sy_sym.ub[1]=19;
      Rs.ub[40]=0;
    }
    break;
    case 2:Ra.sl[6]=1107; /* line # 1107 */
    V_sy_sym.ub[0]=106;
    V_sy_sym.ub[1]=29;
    V_sy_ch=32;
    Rs.ub[40]=0;
    break;
    case 1:Ra.sl[6]=1110; /* line # 1110 */
    V_sy_sym.ub[0]=89;
    V_sy_sym.ub[1]=29;
    Rs.ub[40]=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[6]=1113; /* line # 1113 */
    V_sy_sym.ub[0]=107;
    Ra.sl[6]=1114; /* line # 1114 */
    V_sy_sym.ub[1]=29;
    Ra.sl[6]=1115; /* line # 1115 */
    Rs.ub[40]=0;
    Ra.sl[6]=1116; /* line # 1116 */
    if (V_sy_ch!=32) P_src_error(Rd.s+958,13,2);
    Ra.sl[6]=1117; /* line # 1117 */
    V_sy_ch=32;
    break;
  }
  Ra.sl[6]=1120; /* line # 1120 */
  if (Rs.ub[40]) PAS_INSMBOL_PRC_00000003();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_mcsymbol "  */
void PAS_INSMBOL_skip_mcsymbol(V F_smb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1031;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1149; /* line # 1149 */
  Ra.sl[6]=1150; /* line # 1150 */
  if (!PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,108)) {
    Ra.sl[6]=1152; /* line # 1152 */
    while (!((PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,108)||V_sy_sym.ub[0]==90)||V_sy_sym
    .ub[0]==106)){
      Ra.sl[6]=1154; /* line # 1154 */
      P_insymbol_src();
      Ra.sl[6]=1155; /* line # 1155 */
      switch (V_sy_sym.ub[0]) {
        case 94:
        case 95:
        case 96:Ra.sl[6]=1157; /* line # 1157 */
        while (PAS__INOP_LSET(V_sy_sym.ub[0],Rd.s+1048,97)){
          Ra.sl[6]=1159; /* line # 1159 */
          PAS_INSMBOL_skip_mcsymbol(Rd.s+1064);
          Ra.sl[6]=1160; /* line # 1160 */
          P_insymbol_src();
        }
        break;
        case 106:Ra.sl[6]=1173; /* line # 1173 */
        P_src_error(Rd.s+1082,932,3);
        break;
        default:break;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cb_macro_manager "  */
V PAS_INSMBOL_cb_macro_manager(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1086;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1184; /* line # 1184 */
  Rv0=F_mcp;
  Ra.sl[6]=1186; /* line # 1186 */
  ((UB *)Rv0)[56]=0;
  Ra.sl[6]=1188; /* line # 1188 */
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " macro_replace "  */
void P_macro_replace(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1104;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1205; /* line # 1205 */
  Rv2=F_mcp;
  Rv3=Rv2+64;
  Ra.sl[6]=1206; /* line # 1206 */
  if (!((UB *)Rv2)[56]) {
    Ra.sl[6]=1209; /* line # 1209 */
    switch (((UB *)Rv3)[0]) {
      case 0:Ra.sl[6]=1212; /* line # 1212 */
      Rv0=PAS__NEW(24);
      ((UB *)Rv0)[0]=22;
      Ra.sl[6]=1213; /* line # 1213 */
      PAS__VWRITE_INIT(Rv0,1);
      PAS__WRITE_INT(((SL *)Rv3)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[6]=1217; /* line # 1217 */
      Rv4=((UB *)((V *)Rv3)[1])[1];
      Rv0=PAS__NEW((SL)Rv4+2);
      ((UB *)Rv0)[0]=Rv4;
      Ra.sl[6]=1218; /* line # 1218 */
      PAS__STR_TO_STR(Rv0,((V *)Rv3)[1]);
      break;
      default:break;
    }
    Ra.sl[6]=1222; /* line # 1222 */
    ((UB *)Rv2)[56]=1;
    Ra.sl[6]=1224; /* line # 1224 */
    Rv1=P_src_macro_open(Rv0, (V)PAS_INSMBOL_cb_macro_manager,F_mcp,1,NULL);
    Ra.sl[6]=1225; /* line # 1225 */
    V_sy_ch=0;
  }
  else {
    Ra.sl[6]=1228; /* line # 1228 */
    P_src_error_s(Rd.s+1121,930,2, F_mcp,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_macro_symbol "  */
void PAS_INSMBOL_define_macro_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1125;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1242; /* line # 1242 */
  Ra.sl[6]=1244; /* line # 1244 */
  P_insymbol_src();
  while (1){
    Ra.sl[6]=1246; /* line # 1246 */
    if (V_sy_sym.ub[0]==101) {
      Ra.sl[6]=1248; /* line # 1248 */
      P_src_error_s(Rd.s+1148,921,2, V_sy_ident.s,NULL);
      Ra.sl[6]=1249; /* line # 1249 */
      P_skip_msymbol((V)Rd.s+1152,0);
    }
    else {
      Ra.sl[6]=1252; /* line # 1252 */
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=1254; /* line # 1254 */
        P_src_error(Rd.s+1148,922,2);
        Ra.sl[6]=1255; /* line # 1255 */
        P_skip_msymbol((V)Rd.s+1156,0);
      }
      else {
        Ra.sl[6]=1259; /* line # 1259 */
        Rv0=P_create_mac_ident(V_sy_ident.s,0);
        Ra.sl[6]=1260; /* line # 1260 */
        P_insymbol_src();
        Ra.sl[6]=1261; /* line # 1261 */
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=1262; /* line # 1262 */
          Rv1=Rv0;
          Ra.sl[6]=1264; /* line # 1264 */
          P_insymbol_src();
          Ra.sl[6]=1265; /* line # 1265 */
          PAS_INSMBOL_get_macro_value(Rv1+64);
        }
      }
    }
    Ra.sl[6]=1277; /* line # 1277 */
    if (V_sy_sym.ub[0]!=17)  break;
    Ra.sl[6]=1278; /* line # 1278 */
    P_insymbol_src();
  }
  Ra.sl[6]=1280; /* line # 1280 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1148,21,2);
  else {
    Ra.sl[6]=1281; /* line # 1281 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " undefine_macro_symbol "  */
void PAS_INSMBOL_undefine_macro_mbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1160;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1293; /* line # 1293 */
  Ra.sl[6]=1295; /* line # 1295 */
  P_insymbol_src();
  while (1){
    Ra.sl[6]=1297; /* line # 1297 */
    if (V_sy_sym.ub[0]!=101) {
      Ra.sl[6]=1299; /* line # 1299 */
      P_src_error(Rd.s+1185,922,2);
      Ra.sl[6]=1300; /* line # 1300 */
      P_skip_msymbol((V)Rd.s+1192,0);
    }
    else {
      Ra.sl[6]=1304; /* line # 1304 */
      if (V_sy_macsymb==NULL) {
        Ra.sl[6]=1305; /* line # 1305 */
        P_src_error_s(Rd.s+1185,923,2, V_sy_ident.s,NULL);
      }
      else {
        Ra.sl[6]=1307; /* line # 1307 */
        Rv0=V_sy_macsymb;
        Ra.sl[6]=1309; /* line # 1309 */
        ((UB *)Rv0)[0]=0;
        Ra.sl[6]=1310; /* line # 1310 */
        if (((V *)Rv0)[9]!=NULL) {
          Ra.sl[6]=1311; /* line # 1311 */
          PAS__DISPOSE(((V *)Rv0)+9);
        }
      }
      Ra.sl[6]=1313; /* line # 1313 */
      P_insymbol_src();
    }
    Ra.sl[6]=1315; /* line # 1315 */
    if (V_sy_sym.ub[0]!=17)  break;
    Ra.sl[6]=1316; /* line # 1316 */
    P_insymbol_src();
  }
  Ra.sl[6]=1318; /* line # 1318 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1185,21,2);
  else {
    Ra.sl[6]=1319; /* line # 1319 */
    P_insymbol_src();
  }
  Ra.sl[6]=1321; /* line # 1321 */
  P_rebuild_mctree();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_assign_symbol "  */
void PAS_INSMBOL_macro_assign_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1196;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1334; /* line # 1334 */
  Ra.sl[6]=1336; /* line # 1336 */
  P_insymbol_src();
  Ra.sl[6]=1337; /* line # 1337 */
  if (V_sy_sym.ub[0]!=101) {
    Ra.sl[6]=1339; /* line # 1339 */
    P_src_error(Rd.s+1219,922,2);
    Ra.sl[6]=1340; /* line # 1340 */
    P_skip_msymbol(Rd.s+1224,0);
  }
  else {
    Ra.sl[6]=1344; /* line # 1344 */
    Rv0=V_sy_macsymb;
    Ra.sl[6]=1345; /* line # 1345 */
    P_insymbol_src();
    Ra.sl[6]=1346; /* line # 1346 */
    if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1219,32,2);
    else {
      Ra.sl[6]=1347; /* line # 1347 */
      P_insymbol_src();
    }
    Ra.sl[6]=1348; /* line # 1348 */
    Rv1=Rv0;
    Ra.sl[6]=1350; /* line # 1350 */
    if (((V *)Rv1)[9]!=NULL) PAS__DISPOSE(((V *)Rv1)+9);
    Ra.sl[6]=1351; /* line # 1351 */
    PAS_INSMBOL_get_macro_value(Rv1+64);
  }
  Ra.sl[6]=1354; /* line # 1354 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1219,21,2);
  else {
    Ra.sl[6]=1355; /* line # 1355 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mval "  */
void PAS_INSMBOL_show_mval(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1240;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1363; /* line # 1363 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1251,-1,-1,32);
  PAS__WRITE_ENM(((UB *)F_vl)[0],Rd.s+1268,0,-1,32);
  PAS__WRITE_STR(Rd.s+1310,-1,-1,32);
  PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
  PAS__WRITE_STR(Rd.s+1316,-1,-1,32);
  Ra.sl[6]=1364; /* line # 1364 */
  if (((V *)F_vl)[1]!=NULL&&((UB *)F_vl)[0]==1) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(((V *)F_vl)[1],-1,-1,32);
  }
  Ra.sl[6]=1365; /* line # 1365 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1323,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mstack "  */
void PAS_INSMBOL_show_mstack(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1327;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1370; /* line # 1370 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(F_s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1340,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[39],-2,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=1371; /* line # 1371 */
  Rv0=Ri.sl[39];
  for( Rf0=Ri.sl[39];Rf0>0;Rf0-- ) {
    Ra.sl[6]=1373; /* line # 1373 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1357,-1,-1,32);
    PAS__WRITE_INT(Rv0,-2,0);
    PAS__WRITE_STR(Rd.s+1361,-1,-1,32);
    PAS_INSMBOL_show_mval((Rs.s+Rv0*16+88));
    Rv0--;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_cop "  */
void PAS_INSMBOL_mval_cop(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1367;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1381; /* line # 1381 */
  ((UB *)F_dst)[0]=((UB *)F_src)[0];
  Ra.sl[6]=1382; /* line # 1382 */
  ((SL *)F_dst)[1]=((SL *)F_src)[1];
  Ra.sl[6]=1383; /* line # 1383 */
  if (((V *)F_src)[1]!=NULL) {
    Ra.sl[6]=1385; /* line # 1385 */
    Rv0=((UB *)((V *)F_src)[1])[1];
    ((V *)F_dst)[1]=PAS__NEW((SL)Rv0+2);
    ((UB *)((V *)F_dst)[1])[0]=Rv0;
    Ra.sl[6]=1386; /* line # 1386 */
    PAS__STR_TO_STR(((V *)F_dst)[1],((V *)F_src)[1]);
  }
  else {
    Ra.sl[6]=1388; /* line # 1388 */
    ((V *)F_dst)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_free "  */
void PAS_INSMBOL_mval_free(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1377;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1395; /* line # 1395 */
  if (((V *)F_vl)[1]!=NULL) PAS__DISPOSE(((V *)F_vl)+1);
  Ra.sl[6]=1396; /* line # 1396 */
  memcpy(F_vl,Rd.s+880,16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpush "  */
void PAS_INSMBOL_mpush(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1388;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1406; /* line # 1406 */
  if (Ri.sl[39]<32) Ri.sl[39]=Ri.sl[39]+1;
  else {
    Ra.sl[6]=1407; /* line # 1407 */
    P_src_error(Rd.s+1397,911,3);
  }
  Ra.sl[6]=1408; /* line # 1408 */
  PAS_INSMBOL_mval_cop(F_vl,(Rs.s+Ri.sl[39]*16+88));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpop "  */
void PAS_INSMBOL_mpop(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1401;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1418; /* line # 1418 */
  if (Ri.sl[39]>0) {
    Ra.sl[6]=1420; /* line # 1420 */
    memcpy(F_vl,(Rs.s+Ri.sl[39]*16+88),16);
    Ra.sl[6]=1421; /* line # 1421 */
    Ri.sl[39]=Ri.sl[39]-1;
  }
  else {
    Ra.sl[6]=1425; /* line # 1425 */
    P_src_error(Rd.s+1409,912,3);
    Ra.sl[6]=1426; /* line # 1426 */
    memcpy(F_vl,Rd.s+880,16);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_macro_value "  */
void PAS_INSMBOL_get_macro_value(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1413;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1444; /* line # 1444 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1445; /* line # 1445 */
  PAS_INSMBOL_mpop(F_vl);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_intv "  */
SL PAS_INSMBOL_mexp_intv(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1430;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1457; /* line # 1457 */
  PAS_INSMBOL_mpop(Ra.s+32);
  Ra.sl[6]=1458; /* line # 1458 */
  Ra.sl[6]=1459; /* line # 1459 */
  if (Ra.ub[32]==0) Rv0=Ra.sl[9];
  else {
    Ra.sl[6]=1460; /* line # 1460 */
    if (Ra.v[5]==NULL) Rv0=0;
    else {
      Ra.sl[6]=1463; /* line # 1463 */
      Rv1=Ra.v[5];
      Ra.sl[6]=1465; /* line # 1465 */
      Rv0=0;
      Rv2=0;
      Rv3=((UB *)Rv1)[1];
      Ra.sl[6]=1466; /* line # 1466 */
      while (Rv2<Rv3&&((C *)Rv1)[Rv2+1]<=32)
      Rv2=Rv2+1;
      Ra.sl[6]=1467; /* line # 1467 */
      while (Rv2<Rv3){
        Ra.sl[6]=1469; /* line # 1469 */
        Rv4=((C *)Rv1)[Rv2+1];
        Ra.sl[6]=1470; /* line # 1470 */
        if ((Rv4<48||Rv4>57)&&Rv4>32)  break;
        Ra.sl[6]=1471; /* line # 1471 */
        if (Rv4>32) Rv0=Rv0*10+((SL)Rv4-48);
        Ra.sl[6]=1472; /* line # 1472 */
        Rv2=Rv2+1;
      }
      Ra.sl[6]=1475; /* line # 1475 */
      PAS__DISPOSE(Ra.v+5);
    }
  }
  Ra.sl[6]=1477; /* line # 1477 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexp_vl_str "  */
void PAS_INSMBOL_mexp_vl_str(V F_vl, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1441;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1485; /* line # 1485 */
  Ra.sl[6]=1486; /* line # 1486 */
  if (((UB *)F_vl)[0]==0) {
    PAS__VWRITE_INIT(F_str,1);
    PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=1489; /* line # 1489 */
    PAS__STR_TO_STR(F_str,((V *)F_vl)[1]);
    Ra.sl[6]=1490; /* line # 1490 */
    PAS__DISPOSE(((V *)F_vl)+1);
    Ra.sl[6]=1491; /* line # 1491 */
    ((V *)F_vl)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_strv "  */
void PAS_INSMBOL_mexp_strv(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1454;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1502; /* line # 1502 */
  PAS_INSMBOL_mpop(Ra.s+32);
  Ra.sl[6]=1503; /* line # 1503 */
  PAS_INSMBOL_mexp_vl_str(Ra.s+32,F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_call "  */
void PAS_INSMBOL_mexp_call(UB F_fn, SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 824 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+880,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1465;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1519; /* line # 1519 */
  Ra.sl[140]=1521; /* line # 1521 */
  if (F_fn==0) {
    Ra.sl[140]=1523; /* line # 1523 */
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1478,22,2);
    else {
      Ra.sl[140]=1524; /* line # 1524 */
      P_insymbol_src();
    }
    Ra.sl[140]=1525; /* line # 1525 */
    if (V_sy_sym.ub[0]==101&&V_sy_macsymb!=NULL) Ra.sl[1]=1;
    else {
      Ra.sl[140]=1526; /* line # 1526 */
      Ra.sl[1]=0;
    }
    Ra.sl[140]=1527; /* line # 1527 */
    Ra.ub[0]=0;
    Ra.sl[140]=1529; /* line # 1529 */
    P_insymbol_src();
    Ra.sl[140]=1530; /* line # 1530 */
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1478,23,2);
    Ra.sl[140]=1531; /* line # 1531 */
    PAS_INSMBOL_mpush(Ra.s);
  }
  else {
    Ra.sl[140]=1535; /* line # 1535 */
    Rv0=0;
    Ra.sl[140]=1536; /* line # 1536 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[140]=1538; /* line # 1538 */
      V_sy_sym.ub[0]=17;
      Ra.sl[140]=1539; /* line # 1539 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[140]=1541; /* line # 1541 */
        P_insymbol_src();
        Ra.sl[140]=1542; /* line # 1542 */
        PAS_INSMBOL_m_expr_instk();
        Ra.sl[140]=1543; /* line # 1543 */
        Rv0=Rv0+1;
      }
      Ra.sl[140]=1545; /* line # 1545 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1478,23,2);
    }
    Ra.sl[140]=1547; /* line # 1547 */
    if (F_narg>0&&Rv0!=F_narg||F_narg<0&&Rv0> -F_narg) {
      Ra.sl[140]=1550; /* line # 1550 */
      P_src_error_s(Rd.s+1478,925,2,(Rd.s+F_fn*36+1484),NULL);
      Ra.sl[140]=1551; /* line # 1551 */
      for( Rf0=Rv0;Rf0>0;Rf0-- )
      PAS_INSMBOL_mpop(Ra.s);
      Ra.sl[140]=1552; /* line # 1552 */
      PAS_INSMBOL_mpush(Rd.s+880);
    }
    else {
      Ra.sl[140]=1557; /* line # 1557 */
      switch (F_fn) {
        case 3:Ra.sl[140]=1560; /* line # 1560 */
        PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[140]=1561; /* line # 1561 */
        Ra.sl[1]=Ra.ub[17];
        break;
        case 1:Ra.sl[140]=1567; /* line # 1567 */
        if (F_narg==3) Rv1=PAS_INSMBOL_mexp_intv();
        else Rv1=0;
        Ra.sl[140]=1568; /* line # 1568 */
        if (F_narg>1) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=1;
        Ra.sl[140]=1569; /* line # 1569 */
        if (F_narg>0) PAS_INSMBOL_mexp_strv(Ra.s+16);
        else Ra.ub[17]=0;
        Ra.sl[140]=1570; /* line # 1570 */
        Ra.ub[0]=1;
        Ra.sl[140]=1571; /* line # 1571 */
        Ra.sl[1]=0;
        Ra.sl[140]=1572; /* line # 1572 */
        memcpy(Ra.s+273,PAS__SUBSTR_STR(Ra.s+564,Ra.s+16,Rv2, Rv1),257);
        Ra.sl[140]=1573; /* line # 1573 */
        if (Ra.ub[274]>0) {
          Ra.sl[140]=1575; /* line # 1575 */
          Rv3=Ra.ub[274];
          Ra.v[1]=PAS__NEW((SL)Rv3+2);
          ((UB *)Ra.v[1])[0]=Rv3;
          Ra.sl[140]=1576; /* line # 1576 */
          PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
        }
        break;
        case 2:Ra.sl[140]=1583; /* line # 1583 */
        if (F_narg==3) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=0;
        Ra.sl[140]=1584; /* line # 1584 */
        if (F_narg<2) Ra.ub[274]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+273);
        Ra.sl[140]=1585; /* line # 1585 */
        if (F_narg<1) Ra.ub[17]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[140]=1586; /* line # 1586 */
        Ra.sl[1]=PAS__NINDEX_STR(Ra.s+18,(SL)Ra.ub[17],Ra.s+275,(SL)Ra.ub[274],Rv2,-1,1);
        break;
        default:Ra.sl[140]=1591; /* line # 1591 */
        P_src_error(Rd.s+1478,929,2);
        break;
      }
      Ra.sl[140]=1593; /* line # 1593 */
      PAS_INSMBOL_mpush(Ra.s);
    }
  }
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_ident "  */
void PAS_INSMBOL_mexp_ident(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register UB Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1664;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1611; /* line # 1611 */
  Rv0=1;
  Ra.sl[6]=1612; /* line # 1612 */
  Rv1=1;
  Ra.sl[6]=1613; /* line # 1613 */
  Ra.sl[6]=1615; /* line # 1615 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[6]=1618; /* line # 1618 */
    Rv2=0;
    Ra.sl[6]=1619; /* line # 1619 */
    while (Rv2<4){
      Ra.sl[6]=1621; /* line # 1621 */
      if (P_match(V_sy_ident.s,(Rd.s+Rv2*36+1484))==0)  break;
      Ra.sl[6]=1622; /* line # 1622 */
      Rv2=Rv2+1;
    }
    Ra.sl[6]=1624; /* line # 1624 */
    if (Rv2>=4) {
      Ra.sl[6]=1626; /* line # 1626 */
      P_src_error_s(Rd.s+1678,928,3, V_sy_ident.s,NULL);
      Ra.sl[6]=1627; /* line # 1627 */
      P_skip_msymbol((V)Rd.s+1684,0);
    }
    else {
      Ra.sl[6]=1631; /* line # 1631 */
      P_insymbol_src();
      Ra.sl[6]=1632; /* line # 1632 */
      PAS_INSMBOL_mexp_call(Rv2, Rd.sl[Rv2*9+379]);
      Ra.sl[6]=1633; /* line # 1633 */
      Rv1=0;
    }
    break;
    case 101:Ra.sl[6]=1638; /* line # 1638 */
    if (V_sy_macsymb!=NULL) {
      Ra.sl[6]=1640; /* line # 1640 */
      Rv1=0;
      Ra.sl[6]=1641; /* line # 1641 */
      PAS_INSMBOL_mpush(V_sy_macsymb+64);
    }
    else {
      Ra.sl[6]=1645; /* line # 1645 */
      P_src_error_s(Rd.s+1678,923,2, V_sy_ident.s,NULL);
    }
    break;
    case 5:Ra.sl[6]=1650; /* line # 1650 */
    Ra.ub[32]=1;
    Ra.sl[6]=1651; /* line # 1651 */
    Ra.sl[9]=0;
    Ra.sl[6]=1652; /* line # 1652 */
    if (V_sy_string.ub[1]>0) {
      Ra.sl[6]=1654; /* line # 1654 */
      Rv3=V_sy_string.ub[1];
      Ra.v[5]=PAS__NEW((SL)Rv3+2);
      ((UB *)Ra.v[5])[0]=Rv3;
      Ra.sl[6]=1655; /* line # 1655 */
      PAS__STR_TO_STR(Ra.v[5],V_sy_string.s);
    }
    break;
    case 2:Ra.sl[6]=1661; /* line # 1661 */
    Ra.ub[32]=0;
    Ra.sl[6]=1662; /* line # 1662 */
    Ra.sl[9]=V_sy_ival;
    Ra.sl[6]=1663; /* line # 1663 */
    Ra.v[5]=NULL;
    break;
    case 17:
    case 18:Ra.sl[6]=1669; /* line # 1669 */
    memcpy(Ra.s+32,Rd.s+880,16);
    Ra.sl[6]=1670; /* line # 1670 */
    Rv0=0;
    break;
    default:Ra.sl[6]=1674; /* line # 1674 */
    memcpy(Ra.s+32,Rd.s+880,16);
    Ra.sl[6]=1675; /* line # 1675 */
    Rv0=0;
    Ra.sl[6]=1676; /* line # 1676 */
    P_src_error(Rd.s+1678,926,2);
    break;
  }
  Ra.sl[6]=1678; /* line # 1678 */
  if (Rv1) PAS_INSMBOL_mpush(Ra.s+32);
  Ra.sl[6]=1679; /* line # 1679 */
  if (Rv0) P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_binop "  */
void PAS_INSMBOL_mexp_binop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 840 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  SL Rv2;
  register F Rgf;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+880,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1688;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1698; /* line # 1698 */
  switch (F_ope) {
    case 6:Ra.sl[140]=1701; /* line # 1701 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1702; /* line # 1702 */
    Ra.ub[0]=0;
    Ra.sl[140]=1703; /* line # 1703 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()*Rv0;
    break;
    case 7:Ra.sl[140]=1707; /* line # 1707 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1708; /* line # 1708 */
    Ra.ub[0]=0;
    Ra.sl[140]=1709; /* line # 1709 */
    if (Rv0!=0) Ra.sl[1]=PAS__F_ROUND((float)PAS_INSMBOL_mexp_intv()/(float)Rv0)
    ;
    else {
      Ra.sl[140]=1710; /* line # 1710 */
      Ra.sl[1]=0;
    }
    break;
    case 11:Ra.sl[140]=1714; /* line # 1714 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1715; /* line # 1715 */
    Ra.ub[0]=0;
    Ra.sl[140]=1716; /* line # 1716 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()+Rv0;
    break;
    case 12:Ra.sl[140]=1720; /* line # 1720 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1721; /* line # 1721 */
    Ra.ub[0]=0;
    Ra.sl[140]=1722; /* line # 1722 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()-Rv0;
    break;
    case 13:Ra.sl[140]=1726; /* line # 1726 */
    PAS_INSMBOL_mexp_strv(Ra.s+16);
    Ra.sl[140]=1727; /* line # 1727 */
    PAS_INSMBOL_mexp_strv(Ra.s+273);
    Ra.sl[140]=1728; /* line # 1728 */
    memcpy(Ra.s+273,PAS__CON_STR_STR(Ra.s+564,Ra.s+273,Ra.s+16),257);
    Ra.sl[140]=1729; /* line # 1729 */
    Ra.ub[0]=1;
    Ra.sl[140]=1730; /* line # 1730 */
    Ra.sl[1]=0;
    Ra.sl[140]=1731; /* line # 1731 */
    Rv1=Ra.ub[274];
    Ra.v[1]=PAS__NEW((SL)Rv1+2);
    ((UB *)Ra.v[1])[0]=Rv1;
    Ra.sl[140]=1732; /* line # 1732 */
    PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:Ra.sl[140]=1736; /* line # 1736 */
    PAS_INSMBOL_mpop(Ra.s+824);
    Ra.sl[140]=1737; /* line # 1737 */
    PAS_INSMBOL_mpop(Ra.s);
    Ra.sl[140]=1738; /* line # 1738 */
    Ra.ub[0]=0;
    Ra.sl[140]=1739; /* line # 1739 */
    if (Ra.ub[824]==1||Ra.ub[0]==1) {
      Ra.sl[140]=1741; /* line # 1741 */
      PAS_INSMBOL_mexp_vl_str(Ra.s+824,Ra.s+16);
      Ra.sl[140]=1742; /* line # 1742 */
      PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+273);
      Ra.sl[140]=1743; /* line # 1743 */
      Rv2=PAS__MATCH_STR(Ra.s+273,Ra.s+16);
      Ra.sl[140]=1744; /* line # 1744 */
      Ra.v[1]=NULL;
    }
    else {
      Ra.sl[140]=1746; /* line # 1746 */
      Rv2=Ra.sl[1]-Ra.sl[207];
    }
    Ra.sl[140]=1747; /* line # 1747 */
    switch (F_ope) {
      case 14:Ra.sl[140]=1748; /* line # 1748 */
      Ra.sl[1]=(SL)(Rv2<0);
      break;
      case 15:Ra.sl[140]=1749; /* line # 1749 */
      Ra.sl[1]=(SL)(Rv2<=0);
      break;
      case 16:Ra.sl[140]=1750; /* line # 1750 */
      Ra.sl[1]=(SL)(Rv2>=0);
      break;
      case 17:Ra.sl[140]=1751; /* line # 1751 */
      Ra.sl[1]=(SL)(Rv2>0);
      break;
      case 18:Ra.sl[140]=1752; /* line # 1752 */
      Ra.sl[1]=(SL)(Rv2!=0);
      break;
      case 19:Ra.sl[140]=1753; /* line # 1753 */
      Ra.sl[1]=(SL)(Rv2==0);
      break;
    }
    break;
    case 20:Ra.sl[140]=1758; /* line # 1758 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1759; /* line # 1759 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1760; /* line # 1760 */
    Ra.ub[0]=0;
    Ra.sl[140]=1761; /* line # 1761 */
    Ra.sl[1]=(SL)(Rv0>0&&Rv2>0);
    break;
    case 21:Ra.sl[140]=1766; /* line # 1766 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1767; /* line # 1767 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1768; /* line # 1768 */
    Ra.ub[0]=0;
    Ra.sl[140]=1769; /* line # 1769 */
    Ra.sl[1]=(SL)(Rv0>0||Rv2>0);
    break;
    case 22:Ra.sl[140]=1774; /* line # 1774 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1775; /* line # 1775 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1776; /* line # 1776 */
    Ra.ub[0]=0;
    Ra.sl[140]=1777; /* line # 1777 */
    Ra.sl[1]=(SL)(Rv0>0&&Rv2<=0||Rv0<=0&&Rv2>0);
    break;
    default:Ra.sl[140]=1783; /* line # 1783 */
    P_src_error(Rd.s+1702,927,3);
    break;
  }
  Ra.sl[140]=1785; /* line # 1785 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_unaop "  */
void PAS_INSMBOL_mexp_unaop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+880,16);
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+1706;
  Ra.v[4]=Rd.s+16;
  Ra.sl[10]=1801; /* line # 1801 */
  switch (F_ope) {
    case 0:Ra.sl[10]=1804; /* line # 1804 */
    Ra.ub[0]=0;
    Ra.sl[10]=1805; /* line # 1805 */
    Ra.v[1]=NULL;
    Ra.sl[10]=1806; /* line # 1806 */
    Ra.sl[1]=(SL)(PAS_INSMBOL_mexp_intv()<=0);
    break;
    case 12:Ra.sl[10]=1810; /* line # 1810 */
    Ra.ub[0]=0;
    Ra.sl[10]=1811; /* line # 1811 */
    Ra.v[1]=NULL;
    Ra.sl[10]=1812; /* line # 1812 */
    Ra.sl[1]= -PAS_INSMBOL_mexp_intv();
    break;
    default:Ra.sl[10]=1816; /* line # 1816 */
    P_src_error(Rd.s+1720,927,3);
    break;
  }
  Ra.sl[10]=1819; /* line # 1819 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[2];
}


/* Procedure/Function : " mexp_una "  */
void PAS_INSMBOL_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1724;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1854; /* line # 1854 */
  Ra.sl[6]=1856; /* line # 1856 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) {
    Ra.sl[6]=1857; /* line # 1857 */
    V_sy_sym.ub[0]=6;
  }
  Ra.sl[6]=1858; /* line # 1858 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=1860; /* line # 1860 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else {
      Ra.sl[6]=1861; /* line # 1861 */
      Rv0=29;
    }
    Ra.sl[6]=1862; /* line # 1862 */
    P_insymbol_src();
    Ra.sl[6]=1863; /* line # 1863 */
    PAS_INSMBOL_PRC_00000012();
    Ra.sl[6]=1864; /* line # 1864 */
    if (Rv0!=29) PAS_INSMBOL_mexp_unaop(Rv0);
  }
  else {
    Ra.sl[6]=1867; /* line # 1867 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1869; /* line # 1869 */
      P_insymbol_src();
      Ra.sl[6]=1870; /* line # 1870 */
      PAS_INSMBOL_m_expr_instk();
      Ra.sl[6]=1871; /* line # 1871 */
      if (V_sy_sym.ub[0]==14) P_insymbol_src();
      else {
        Ra.sl[6]=1872; /* line # 1872 */
        P_src_error(Rd.s+1736,23,3);
      }
    }
    else {
      Ra.sl[6]=1874; /* line # 1874 */
      PAS_INSMBOL_mexp_ident();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_mul "  */
void PAS_INSMBOL_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1740;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1879; /* line # 1879 */
  PAS_INSMBOL_PRC_00000012();
  Ra.sl[6]=1880; /* line # 1880 */
  Ra.sl[6]=1881; /* line # 1881 */
  while (V_sy_sym.ub[0]==8){
    Ra.sl[6]=1883; /* line # 1883 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1884; /* line # 1884 */
    P_insymbol_src();
    Ra.sl[6]=1885; /* line # 1885 */
    PAS_INSMBOL_PRC_00000012();
    Ra.sl[6]=1886; /* line # 1886 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_add "  */
void PAS_INSMBOL_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1750;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1891; /* line # 1891 */
  PAS_INSMBOL_PRC_00000011();
  Ra.sl[6]=1892; /* line # 1892 */
  Ra.sl[6]=1893; /* line # 1893 */
  while (V_sy_sym.ub[0]==9){
    Ra.sl[6]=1895; /* line # 1895 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1896; /* line # 1896 */
    P_insymbol_src();
    Ra.sl[6]=1897; /* line # 1897 */
    PAS_INSMBOL_PRC_00000011();
    Ra.sl[6]=1898; /* line # 1898 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_rel "  */
void PAS_INSMBOL_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1760;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1903; /* line # 1903 */
  PAS_INSMBOL_PRC_00000010();
  Ra.sl[6]=1904; /* line # 1904 */
  Ra.sl[6]=1905; /* line # 1905 */
  while (V_sy_sym.ub[0]==10){
    Ra.sl[6]=1907; /* line # 1907 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1908; /* line # 1908 */
    P_insymbol_src();
    Ra.sl[6]=1909; /* line # 1909 */
    PAS_INSMBOL_PRC_00000010();
    Ra.sl[6]=1910; /* line # 1910 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_and "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1770;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1915; /* line # 1915 */
  PAS_INSMBOL_PRC_00000009();
  Ra.sl[6]=1916; /* line # 1916 */
  Ra.sl[6]=1917; /* line # 1917 */
  while (V_sy_sym.ub[0]==11){
    Ra.sl[6]=1919; /* line # 1919 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1920; /* line # 1920 */
    P_insymbol_src();
    Ra.sl[6]=1921; /* line # 1921 */
    PAS_INSMBOL_PRC_00000009();
    Ra.sl[6]=1922; /* line # 1922 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " m_expr_instk "  */
void PAS_INSMBOL_m_expr_instk(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1780;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1927; /* line # 1927 */
  PAS_INSMBOL_PRC_00000008();
  Ra.sl[6]=1928; /* line # 1928 */
  Ra.sl[6]=1929; /* line # 1929 */
  while (V_sy_sym.ub[0]==12){
    Ra.sl[6]=1931; /* line # 1931 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1932; /* line # 1932 */
    P_insymbol_src();
    Ra.sl[6]=1933; /* line # 1933 */
    PAS_INSMBOL_PRC_00000008();
    Ra.sl[6]=1934; /* line # 1934 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_sval "  */
void PAS_INSMBOL_mexpr_sval(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1794;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1942; /* line # 1942 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1943; /* line # 1943 */
  PAS_INSMBOL_mexp_strv(F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_ival "  */
SL PAS_INSMBOL_mexpr_ival(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1806;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1950; /* line # 1950 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1951; /* line # 1951 */
  Ret=PAS_INSMBOL_mexp_intv();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexpr_bval "  */
UB PAS_INSMBOL_mexpr_bval(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1818;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1958; /* line # 1958 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1959; /* line # 1959 */
  Ret=PAS_INSMBOL_mexp_intv()>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_pragma_mstate(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1080 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+880,16);
  Ra.ub[16]=255;
  memcpy(Ra.s+16,Rd.s+1830,257);
  Ra.ub[273]=255;
  memcpy(Ra.s+273,Rd.s+1830,257);
  Ra.ub[530]=255;
  memcpy(Ra.s+530,Rd.s+1830,257);
  Ra.ub[787]=255;
  memcpy(Ra.s+787,Rd.s+1830,257);
  Ra.v[131]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1048;
  Ra.v[132]=Rd.s+2087;
  Ra.v[133]=Rd.s+16;
  Ra.sl[268]=2038; /* line # 2038 */
  P_insymbol_src();
  Ra.sl[268]=2039; /* line # 2039 */
  Rv0=V_sy_label_flag;
  Ra.sl[268]=2040; /* line # 2040 */
  V_sy_label_flag=0;
  Ra.sl[268]=2041; /* line # 2041 */
  Rv1=F_p_src;
  Ra.sl[268]=2043; /* line # 2043 */
  Rv2=35&((UL *)Rv1)[62];
  Ra.sl[268]=2044; /* line # 2044 */
  while (V_sy_sym.ub[0]==0){
    Ra.sl[268]=2046; /* line # 2046 */
    Rv3=0;
    Ra.sl[268]=2047; /* line # 2047 */
    Rv4=0;
    while (1){
      Ra.sl[268]=2049; /* line # 2049 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      Ra.sl[268]=2050; /* line # 2050 */
      if (Rv3||Rv4==23)  break;
      Ra.sl[268]=2051; /* line # 2051 */
      Rv4=Rv4+1;
    }
    Ra.sl[268]=2053; /* line # 2053 */
    P_insymbol_src();
    Ra.sl[268]=2054; /* line # 2054 */
    switch (Rv4) {
      case 0:Ra.sl[268]=2057; /* line # 2057 */
      PAS_INSMBOL_get_macro_value(Ra.s);
      Ra.sl[268]=2058; /* line # 2058 */
      if (Ra.ub[0]==1) {
        Ra.sl[268]=2060; /* line # 2060 */
        PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+16);
        Ra.sl[268]=2061; /* line # 2061 */
        if (Ra.ub[17]>0) {
          Ra.sl[268]=2062; /* line # 2062 */
          Rv5=V_lst_current;
          Ra.sl[268]=2065; /* line # 2065 */
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          Ra.sl[268]=2067; /* line # 2067 */
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+273,((V *)Rv5)[2]);
          Ra.sl[268]=2068; /* line # 2068 */
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+530,((V *)Rv5)[4]);
          Ra.sl[268]=2069; /* line # 2069 */
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+787,((V *)Rv5)[5]);
          Ra.sl[268]=2071; /* line # 2071 */
          P_lst_open(&V_lst_current, Ra.s+16,Ra.s+273,Ra.s+530,Ra.s+787,132,-1,0,0,0,
          &Rv6);
          Ra.sl[268]=2083; /* line # 2083 */
          if (Rv6!=0) {
            Ra.sl[268]=2084; /* line # 2084 */
            if (!V_sy_init_mod) {
              Ra.sl[268]=2086; /* line # 2086 */
              P_src_error(Rd.s+2104,905,2);
            }
            else {
              Ra.sl[268]=2088; /* line # 2088 */
              Rv2=Rv2&~1;
            }
          }
          else {
            Ra.sl[268]=2091; /* line # 2091 */
            if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
            Ra.sl[268]=2092; /* line # 2092 */
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[268]=2096; /* line # 2096 */
          Rv2=Rv2&~1;
        }
      }
      Ra.sl[268]=2098; /* line # 2098 */
      if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
      Ra.sl[268]=2099; /* line # 2099 */
      Rv2=Rv2|1;
      break;
      case 1:Ra.sl[268]=2102; /* line # 2102 */
      Rv2=Rv2&~1;
      break;
      case 2:Ra.sl[268]=2104; /* line # 2104 */
      Rv2=Rv2|2;
      break;
      case 3:Ra.sl[268]=2105; /* line # 2105 */
      Rv2=Rv2&~2;
      break;
      case 4:Ra.sl[268]=2107; /* line # 2107 */
      Rv2=Rv2|32;
      break;
      case 5:Ra.sl[268]=2108; /* line # 2108 */
      Rv2=Rv2&~32;
      break;
      case 6:Ra.sl[268]=2112; /* line # 2112 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2113; /* line # 2113 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2115; /* line # 2115 */
        ((SL *)Rv1)[8]=V_sy_ival;
        Ra.sl[268]=2116; /* line # 2116 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2118; /* line # 2118 */
        ((SL *)Rv1)[8]=1;
      }
      break;
      case 7:Ra.sl[268]=2123; /* line # 2123 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2124; /* line # 2124 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2126; /* line # 2126 */
        ((SL *)Rv1)[11]=V_sy_ival;
        Ra.sl[268]=2127; /* line # 2127 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2129; /* line # 2129 */
        ((SL *)Rv1)[11]=1;
      }
      Ra.sl[268]=2130; /* line # 2130 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2131; /* line # 2131 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2132; /* line # 2132 */
        ((SL *)Rv1)[12]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2133; /* line # 2133 */
        ((SL *)Rv1)[12]=255;
      }
      break;
      case 8:Ra.sl[268]=2136; /* line # 2136 */
      V_cmp_macf=1;
      break;
      case 9:Ra.sl[268]=2137; /* line # 2137 */
      V_cmp_macf=0;
      break;
      case 10:Ra.sl[268]=2139; /* line # 2139 */
      V_cmp_cobj=1;
      break;
      case 11:Ra.sl[268]=2140; /* line # 2140 */
      V_cmp_cobj=0;
      break;
      case 12:Ra.sl[268]=2143; /* line # 2143 */
      if (V_sy_sym.ub[0]==5) {
        Ra.sl[268]=2144; /* line # 2144 */
        if (V_sy_ident.ub[0]>0) {
          Ra.sl[268]=2146; /* line # 2146 */
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Ra.sl[268]=2147; /* line # 2147 */
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[268]=2148; /* line # 2148 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          Ra.sl[268]=2149; /* line # 2149 */
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else {
          Ra.sl[268]=2151; /* line # 2151 */
          P_src_error(Rd.s+2104,904,4);
        }
      }
      else {
        Ra.sl[268]=2154; /* line # 2154 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 13:Ra.sl[268]=2158; /* line # 2158 */
      if (V_cmp_objf) {
        Ra.sl[268]=2160; /* line # 2160 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 14:Ra.sl[268]=2163; /* line # 2163 */
      V_cmp_bltt=1;
      break;
      case 15:Ra.sl[268]=2164; /* line # 2164 */
      V_cmp_bltt=0;
      break;
      case 16:Ra.sl[268]=2167; /* line # 2167 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2171; /* line # 2171 */
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[268]=2172; /* line # 2172 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2174; /* line # 2174 */
        P_src_error(Rd.s+2104,906,3);
      }
      break;
      case 17:Ra.sl[268]=2176; /* line # 2176 */
      V_cmp_debugopt=1;
      break;
      case 18:Ra.sl[268]=2177; /* line # 2177 */
      V_cmp_debugopt=0;
      break;
      case 19:Ra.sl[268]=2179; /* line # 2179 */
      V_cmp_range=1;
      break;
      case 20:Ra.sl[268]=2180; /* line # 2180 */
      V_cmp_range=0;
      break;
      case 21:Ra.sl[268]=2182; /* line # 2182 */
      P_generation_pragma();
      break;
      case 22:Ra.sl[268]=2184; /* line # 2184 */
      V_cmp_cmpdbg=1;
      break;
      case 23:Ra.sl[268]=2185; /* line # 2185 */
      V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[268]=2188; /* line # 2188 */
      P_src_error_s(Rd.s+2104,901,1, V_sy_ident.s,NULL);
      break;
    }
    Ra.sl[268]=2190; /* line # 2190 */
    if (V_sy_sym.ub[0]==17) P_insymbol_src();
  }
  Ra.sl[268]=2192; /* line # 2192 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+2104,21,2);
  else {
    Ra.sl[268]=2193; /* line # 2193 */
    P_insymbol_src();
  }
  Ra.sl[268]=2194; /* line # 2194 */
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~35|Rv2;
  Ra.sl[268]=2196; /* line # 2196 */
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[131];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_include_mstate(UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 800 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=254;
  Ra.ub[256]=254;
  Ra.v[64]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+512;
  Ra.v[65]=Rd.s+2108;
  Ra.v[66]=Rd.s+16;
  Ra.sl[134]=2214; /* line # 2214 */
  Ra.sl[134]=2216; /* line # 2216 */
  Rv0=V_sy_sym.ub[0]==103;
  Ra.sl[134]=2217; /* line # 2217 */
  P_insymbol_src();
  Ra.sl[134]=2218; /* line # 2218 */
  PAS_INSMBOL_mexpr_sval(Ra.s);
  Ra.sl[134]=2219; /* line # 2219 */
  Rv1=NULL;
  Ra.sl[134]=2220; /* line # 2220 */
  Rv2=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  Ra.sl[134]=2221; /* line # 2221 */
  if (Rv2==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+540,Ra.s,Rd.s+2124));
  Ra.sl[134]=2223; /* line # 2223 */
  Rv1=P_src_file_open(Ra.s,0,NULL);
  Ra.sl[134]=2224; /* line # 2224 */
  if (V_src_openerr==0) {
    Ra.sl[134]=2226; /* line # 2226 */
    Rv3=Rv1;
    Ra.sl[134]=2228; /* line # 2228 */
    ((V *)Rv3)[1]=V_src_control;
    Ra.sl[134]=2229; /* line # 2229 */
    ((SL *)Rv3)[7]=((SL *)V_src_control)[7];
    Ra.sl[134]=2230; /* line # 2230 */
    if (Rv0) ((SL *)Rv3)[7]=((SL *)Rv3)[7]+1;
    Ra.sl[134]=2231; /* line # 2231 */
    ((SL *)Rv3)[8]=((SL *)V_src_control)[8];
    Ra.sl[134]=2232; /* line # 2232 */
    ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
    Ra.sl[134]=2233; /* line # 2233 */
    ((SL *)Rv3)[11]=((SL *)V_src_control)[11];
    Ra.sl[134]=2234; /* line # 2234 */
    ((SL *)Rv3)[12]=((SL *)V_src_control)[12];
    Ra.sl[134]=2235; /* line # 2235 */
    ((UL *)Rv3)[62]=((UL *)Rv3)[62]|((UL *)V_src_control)[62]&103;
    Ra.sl[134]=2239; /* line # 2239 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[134]=2241; /* line # 2241 */
      P_insymbol_src();
      Ra.sl[134]=2242; /* line # 2242 */
      PAS_INSMBOL_pragma_mstate(Rv1);
    }
    else {
      Ra.sl[134]=2245; /* line # 2245 */
      if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+2132,21,2);
    }
    Ra.sl[134]=2246; /* line # 2246 */
    if (!Rv0) P_src_end_of_line();
    Ra.sl[134]=2247; /* line # 2247 */
    V_src_control=Rv1;
    Ra.sl[134]=2248; /* line # 2248 */
    if (V_cmp_trace>0) V_cmp_tracecount=0;
    Ra.sl[134]=2249; /* line # 2249 */
    P_compile_set_title();
    Ra.sl[134]=2250; /* line # 2250 */
    P_set_srcfilespc((SL)Rv0);
    Ra.sl[134]=2251; /* line # 2251 */
    V_sy_ch=32;
    Ra.sl[134]=2252; /* line # 2252 */
    V_sy_sym.ub[0]=104;
    Ra.sl[134]=2253; /* line # 2253 */
    if (!Rv0) {
      Ra.sl[134]=2255; /* line # 2255 */
      Rv4=V_src_control;
      Ra.sl[134]=2257; /* line # 2257 */
      Rv1=((V *)Rv4)[1];
      Ra.sl[134]=2258; /* line # 2258 */
      ((V *)Rv4)[1]=((V *)Rv1)[1];
      Ra.sl[134]=2260; /* line # 2260 */
      P_src_close(&Rv1,1);
    }
    Ra.sl[134]=2262; /* line # 2262 */
    Rv5=V_src_control;
    Ra.sl[134]=2263; /* line # 2263 */
    if (((SL *)Rv5)[7]<=((SL *)Rv5)[8]) {
      Ra.sl[134]=2264; /* line # 2264 */
      if (1&((UL *)Rv5)[62]) {
        Ra.sl[134]=2266; /* line # 2266 */
        P_lst_newline();
        Ra.sl[134]=2267; /* line # 2267 */
        PAS__VWRITE_INIT(Ra.s+256,1);
        PAS__WRITE_STR(Rd.s+2136,-1,-1,32);
        PAS__WRITE_STR(Ra.s,-1,-1,32);
        PAS__WRITE_CHAR(34);
        PAS__WRITE_EOLN();
        Ra.sl[134]=2268; /* line # 2268 */
        P_lst_put_string(Ra.s+256);
      }
    }
  }
  else {
    Ra.sl[134]=2272; /* line # 2272 */
    P_lst_newline();
    Ra.sl[134]=2273; /* line # 2273 */
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Rd.s+2173,-1,-1,32);
    PAS__WRITE_INT(V_src_openerr,3,0);
    PAS__WRITE_STR(Rd.s+2195,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[134]=2274; /* line # 2274 */
    P_lst_put_string(Ra.s+256);
    Ra.sl[134]=2275; /* line # 2275 */
    P_lst_newline();
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_put_string(Ra.s+256);
    Ra.sl[134]=2276; /* line # 2276 */
    PAS__GET_RTL_MSG(V_src_openerr, Ra.s);
    Ra.sl[134]=2277; /* line # 2277 */
    P_lst_newline();
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Rd.s+2219,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_eoln();
    Ra.sl[134]=2286; /* line # 2286 */
    while ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=106){
      Ra.sl[134]=2288; /* line # 2288 */
      P_insymbol_src();
    }
    Ra.sl[134]=2289; /* line # 2289 */
    if (F_bnsferr) {
      Ra.sl[134]=2290; /* line # 2290 */
      P_src_error(Rd.s+2132,902,4);
    }
    else {
      Ra.sl[134]=2292; /* line # 2292 */
      P_src_error(Rd.s+2132,902,3);
    }
  }
  Ra.sl[134]=2295; /* line # 2295 */
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[64];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_endfile_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 544 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.ub[0]=254;
  Ra.v[32]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+256;
  Ra.v[33]=Rd.s+2236;
  Ra.v[34]=Rd.s+16;
  Ra.sl[70]=2307; /* line # 2307 */
  Rv0=V_src_control;
  Ra.sl[70]=2309; /* line # 2309 */
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=90;
  else {
    Ra.sl[70]=2312; /* line # 2312 */
    if (((SL *)Rv0)[7]<=((SL *)Rv0)[8]&&1&((UL *)Rv0)[62]) {
      Ra.sl[70]=2314; /* line # 2314 */
      PAS__VWRITE_INIT(Ra.s,1);
      PAS__WRITE_STR(Rd.s+2252,-1,-1,32);
      PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+284,((V *)((V *)Rv0)[1])[35]),-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
      Ra.sl[70]=2317; /* line # 2317 */
      P_lst_put_string(Ra.s);
      Ra.sl[70]=2318; /* line # 2318 */
      P_lst_newline();
    }
    Ra.sl[70]=2320; /* line # 2320 */
    V_sy_ch=P_src_return(1);
    Ra.sl[70]=2321; /* line # 2321 */
    V_sy_sym.ub[0]=107;
    Ra.sl[70]=2322; /* line # 2322 */
    V_sy_ch=32;
    Ra.sl[70]=2323; /* line # 2323 */
    P_set_srcfilespc(-1);
    Ra.sl[70]=2324; /* line # 2324 */
    P_compile_set_title();
  }
  Ra.sl[70]=2327; /* line # 2327 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  Ra.sl[70]=2328; /* line # 2328 */
  if (V_sy_sym.ub[0]==90) V_pas_compile=0;
  else {
    Ra.sl[70]=2329; /* line # 2329 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[32];
}


/* Procedure/Function : " cnd_push "  */
UB PAS_INSMBOL_cnd_push(UB F_cds){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2289;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2338; /* line # 2338 */
  if (Ri.sl[232]<32) {
    Ra.sl[6]=2340; /* line # 2340 */
    Ri.sl[232]=Ri.sl[232]+1;
    Ra.sl[6]=2341; /* line # 2341 */
    Rs.ub[Ri.sl[232]+615]=F_cds;
  }
  else {
    Ra.sl[6]=2345; /* line # 2345 */
    P_src_error(Rd.s+2301,950,4);
    Ra.sl[6]=2346; /* line # 2346 */
    Rv0=0;
  }
  Ra.sl[6]=2348; /* line # 2348 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cnd_pop "  */
UB PAS_INSMBOL_cnd_pop(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2305;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2355; /* line # 2355 */
  if (Ri.sl[232]<=0) {
    Ra.sl[6]=2357; /* line # 2357 */
    P_src_error(Rd.s+2301,951,4);
    Ra.sl[6]=2358; /* line # 2358 */
    Rv0=0;
  }
  else {
    Ra.sl[6]=2360; /* line # 2360 */
    Ri.sl[232]=Ri.sl[232]-1;
  }
  Ra.sl[6]=2361; /* line # 2361 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cnd_check "  */
UB PAS_INSMBOL_cnd_check(UB F_cds){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2314;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2369; /* line # 2369 */
  if (Ri.sl[232]>0) {
    Ra.sl[6]=2371; /* line # 2371 */
    if (F_cds>=Rs.ub[Ri.sl[232]+615]) Rs.ub[Ri.sl[232]+615]=F_cds;
    else {
      Ra.sl[6]=2372; /* line # 2372 */
      Rv0=0;
    }
  }
  else {
    Ra.sl[6]=2373; /* line # 2373 */
    Rv0=0;
  }
  Ra.sl[6]=2375; /* line # 2375 */
  if (!Rv0) P_src_error(Rd.s+2301,952,4);
  Ra.sl[6]=2376; /* line # 2376 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mif_mstate "  */
UB PAS_INSMBOL_mif_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2325;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2391; /* line # 2391 */
  Ra.sl[6]=2393; /* line # 2393 */
  Rv0=V_sy_sym.ub[0];
  Ra.sl[6]=2394; /* line # 2394 */
  P_insymbol_src();
  Ra.sl[6]=2395; /* line # 2395 */
  switch (Rv0) {
    case 95:
    case 96:Ra.sl[6]=2399; /* line # 2399 */
    Rv1=V_sy_macsymb!=NULL^Rv0==96;
    Ra.sl[6]=2400; /* line # 2400 */
    P_insymbol_src();
    Ra.sl[6]=2401; /* line # 2401 */
    PAS_INSMBOL_cnd_push(0);
    break;
    case 94:Ra.sl[6]=2406; /* line # 2406 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    Ra.sl[6]=2407; /* line # 2407 */
    PAS_INSMBOL_cnd_push(0);
    break;
    case 99:Ra.sl[6]=2412; /* line # 2412 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    Ra.sl[6]=2413; /* line # 2413 */
    PAS_INSMBOL_cnd_check(1);
    break;
    default:break;
  }
  Ra.sl[6]=2418; /* line # 2418 */
  if (V_sy_sym.ub[0]!=97) P_src_error(Rd.s+2339,932,2);
  Ra.sl[6]=2420; /* line # 2420 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;
  UB Rv2;
  UB Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2343;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2452; /* line # 2452 */
  P_insymbol_src();
  Ra.sl[6]=2453; /* line # 2453 */
  Rv0=V_src_control;
  Ra.sl[6]=2454; /* line # 2454 */
  while (V_sy_sym.ub[0]>=91){
    Ra.sl[6]=2456; /* line # 2456 */
    switch (V_sy_sym.ub[0]) {
      case 103:
      case 104:Ra.sl[6]=2458; /* line # 2458 */
      PAS_INSMBOL_include_mstate(V_sy_init_mod);
      break;
      case 105:Ra.sl[6]=2461; /* line # 2461 */
      PAS_INSMBOL_pragma_mstate(V_src_control);
      break;
      case 91:Ra.sl[6]=2464; /* line # 2464 */
      PAS_INSMBOL_define_macro_symbol();
      break;
      case 92:Ra.sl[6]=2467; /* line # 2467 */
      PAS_INSMBOL_undefine_macro_mbol();
      break;
      case 93:Ra.sl[6]=2470; /* line # 2470 */
      PAS_INSMBOL_macro_assign_symbol();
      break;
      case 94:
      case 95:
      case 96:Ra.sl[6]=2474; /* line # 2474 */
      Rv1=((C *)Rv0)[54];
      while (1){
        Ra.sl[6]=2476; /* line # 2476 */
        Rv2=PAS_INSMBOL_mif_mstate();
        Ra.sl[6]=2477; /* line # 2477 */
        if (Rv2)  break;
        Ra.sl[6]=2479; /* line # 2479 */
        ((C *)Rv0)[54]=83;
        Ra.sl[6]=2480; /* line # 2480 */
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2360);
        Ra.sl[6]=2481; /* line # 2481 */
        ((C *)Rv0)[54]=Rv1;
        if (V_sy_sym.ub[0]!=99)  break;
      }
      Ra.sl[6]=2483; /* line # 2483 */
      if (Rv2||V_sy_sym.ub[0]==98) {
        Ra.sl[6]=2485; /* line # 2485 */
        ((C *)Rv0)[54]=Rv1;
        Ra.sl[6]=2486; /* line # 2486 */
        PAS_INSMBOL_cnd_check(2);
        Ra.sl[6]=2487; /* line # 2487 */
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2491; /* line # 2491 */
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2376);
        Ra.sl[6]=2492; /* line # 2492 */
        PAS_INSMBOL_cnd_pop();
        Ra.sl[6]=2493; /* line # 2493 */
        ((C *)Rv0)[54]=Rv1;
        Ra.sl[6]=2494; /* line # 2494 */
        if (V_sy_sym.ub[0]==100) P_insymbol_src();
        else {
          Ra.sl[6]=2495; /* line # 2495 */
          P_src_error(Rd.s+2355,953,4);
        }
      }
      break;
      case 98:
      case 99:
      case 100:Ra.sl[6]=2501; /* line # 2501 */
      Rv1=((C *)Rv0)[54];
      ((C *)Rv0)[54]=83;
      Ra.sl[6]=2502; /* line # 2502 */
      PAS_INSMBOL_skip_mcsymbol(Rd.s+2392);
      Ra.sl[6]=2503; /* line # 2503 */
      P_insymbol_src();
      Ra.sl[6]=2504; /* line # 2504 */
      ((C *)Rv0)[54]=Rv1;
      Ra.sl[6]=2505; /* line # 2505 */
      PAS_INSMBOL_cnd_pop();
      break;
      case 101:Ra.sl[6]=2509; /* line # 2509 */
      if (V_sy_macsymb!=NULL) {
        Ra.sl[6]=2511; /* line # 2511 */
        P_macro_replace(V_sy_macsymb);
        Ra.sl[6]=2512; /* line # 2512 */
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2515; /* line # 2515 */
        P_src_error_s(Rd.s+2355,995,3, V_sy_ident.s,NULL);
      }
      break;
      case 102:Ra.sl[6]=2519; /* line # 2519 */
      P_insymbol_src();
      Ra.sl[6]=2520; /* line # 2520 */
      if (V_sy_sym.ub[0]==13) P_insymbol_src();
      else P_src_error(Rd.s+2355,955,2);
      Ra.sl[6]=2521; /* line # 2521 */
      PAS__VWRITE_INIT(Ri.s+932,1);
      PAS__WRITE_STR(Rd.s+2408,-1,-1,32);
      PAS__WRITE_EOLN();
      while (1){
        Ra.sl[6]=2523; /* line # 2523 */
        P_insymbol_src();
        Ra.sl[6]=2524; /* line # 2524 */
        switch (V_sy_sym.ub[0]) {
          case 5:Ra.sl[6]=2526; /* line # 2526 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(V_sy_string.s,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          case 101:Ra.sl[6]=2530; /* line # 2530 */
          Rv3=1;
          Ra.sl[6]=2531; /* line # 2531 */
          if (V_sy_macsymb!=NULL) {
            Rv4=V_sy_macsymb+64;
            Ra.sl[6]=2532; /* line # 2532 */
            switch (((UB *)Rv4)[0]) {
              case 0:Ra.sl[6]=2533; /* line # 2533 */
              PAS__VWRITE_INIT(Ri.s+932,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rv4)[1],0,0);
              PAS__WRITE_EOLN();
              break;
              case 1:Ra.sl[6]=2534; /* line # 2534 */
              PAS__VWRITE_INIT(Ri.s+932,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_STR(((V *)Rv4)[1],-1,-1,32);
              PAS__WRITE_EOLN();
              break;
              default:Ra.sl[6]=2536; /* line # 2536 */
              Rv3=0;
              break;
            }
          }
          else {
            Ra.sl[6]=2538; /* line # 2538 */
            Rv3=0;
          }
          Ra.sl[6]=2539; /* line # 2539 */
          if (Rv3) {
            PAS__VWRITE_INIT(Ri.s+932,0);
            PAS__WRITE_STR(Rd.s+2425,-1,-1,32);
            PAS__WRITE_CHT(V_sy_ident.s+1,31, V_sy_ident.ub[0],-1,32);
            PAS__WRITE_CHAR(34);
            PAS__WRITE_EOLN();
          }
          break;
          case 0:Ra.sl[6]=2543; /* line # 2543 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(V_sy_ident.s+1,31, V_sy_ident.ub[0],-1,32);
          PAS__WRITE_EOLN();
          break;
          case 2:Ra.sl[6]=2546; /* line # 2546 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(V_sy_ival,12,0);
          PAS__WRITE_EOLN();
          break;
          case 3:Ra.sl[6]=2548; /* line # 2548 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(V_sy_rval,24,-15,0);
          PAS__WRITE_CHAR(70);
          PAS__WRITE_EOLN();
          break;
          case 4:Ra.sl[6]=2550; /* line # 2550 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(V_sy_rval,24,-15,0);
          PAS__WRITE_CHAR(68);
          PAS__WRITE_EOLN();
          break;
          default:Ra.sl[6]=2553; /* line # 2553 */
          P_src_error(Rd.s+2355,956,2);
          break;
        }
        Ra.sl[6]=2556; /* line # 2556 */
        P_insymbol_src();
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=2558; /* line # 2558 */
      P_lst_newline();
      P_lst_put_string(Ri.s+932);
      P_lst_eoln();
      Ra.sl[6]=2559; /* line # 2559 */
      if (V_sy_sym.ub[0]==14) P_insymbol_src();
      else {
        Ra.sl[6]=2560; /* line # 2560 */
        P_src_error(Rd.s+2355,957,2);
      }
      break;
      case 106:Ra.sl[6]=2566; /* line # 2566 */
      PAS_INSMBOL_endfile_mstate();
      break;
      default:Ra.sl[6]=2571; /* line # 2571 */
      P_src_error(Rd.s+2355,997,3);
      Ra.sl[6]=2572; /* line # 2572 */
      P_insymbol_src();
      break;
    }
    Ra.sl[6]=2574; /* line # 2574 */
    if (Ri.sl[232]<0) {
      Ra.sl[6]=2576; /* line # 2576 */
      P_src_error(Rd.s+2355,996,2);
      Ra.sl[6]=2577; /* line # 2577 */
      Ri.sl[232]=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2448;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2587; /* line # 2587 */
  Ra.sl[6]=2588; /* line # 2588 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=90){
    Ra.sl[6]=2590; /* line # 2590 */
    P_insymbol();
    Ra.sl[6]=2591; /* line # 2591 */
    switch (V_sy_sym.ub[0]) {
      case 56:Ra.sl[6]=2593; /* line # 2593 */
      if (!F_rec_flg) {
        Ra.sl[6]=2595; /* line # 2595 */
        P_skip_symbol(72,0,0);
        P_insymbol();
      }
      break;
      case 41:Ra.sl[6]=2599; /* line # 2599 */
      P_skip_symbol(72,1,0);
      P_insymbol();
      break;
      case 54:
      case 71:Ra.sl[6]=2603; /* line # 2603 */
      P_skip_symbol(72,0,0);
      P_insymbol();
      break;
      case 13:Ra.sl[6]=2607; /* line # 2607 */
      P_skip_symbol(14,0,0);
      P_insymbol();
      break;
      case 15:Ra.sl[6]=2611; /* line # 2611 */
      P_skip_symbol(16,0,0);
      P_insymbol();
      break;
      case 48:Ra.sl[6]=2615; /* line # 2615 */
      P_skip_symbol(49,0,0);
      P_insymbol();
      break;
      case 72:Ra.sl[6]=2618; /* line # 2618 */
      if (F_tosymbol==46||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_msymbol "  */
void P_skip_msymbol(V F_smb, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2461;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2628; /* line # 2628 */
  Ra.sl[6]=2629; /* line # 2629 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,108)||V_sy_sym.ub[0]==90)){
    Ra.sl[6]=2631; /* line # 2631 */
    P_insymbol();
    Ra.sl[6]=2632; /* line # 2632 */
    switch (V_sy_sym.ub[0]) {
      case 56:Ra.sl[6]=2634; /* line # 2634 */
      if (!F_rec_flg) {
        Ra.sl[6]=2636; /* line # 2636 */
        P_skip_msymbol(Rd.s+2476,0);
        P_insymbol();
      }
      break;
      case 41:Ra.sl[6]=2641; /* line # 2641 */
      P_skip_msymbol(Rd.s+2488,1);
      P_insymbol();
      break;
      case 54:
      case 71:Ra.sl[6]=2646; /* line # 2646 */
      P_skip_msymbol(Rd.s+2500,0);
      P_insymbol();
      break;
      case 13:Ra.sl[6]=2651; /* line # 2651 */
      P_skip_msymbol((V)Rd.s+2512,0);
      P_insymbol();
      break;
      case 15:Ra.sl[6]=2656; /* line # 2656 */
      P_skip_msymbol((V)Rd.s+2516,0);
      P_insymbol();
      break;
      case 48:Ra.sl[6]=2661; /* line # 2661 */
      P_skip_msymbol(Rd.s+2520,0);
      P_insymbol();
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2528;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2677; /* line # 2677 */
  P_lst_g_init(Rd.s+2539,Rd.s+2541,&Rv0);
  Ra.sl[6]=2679; /* line # 2679 */
  if (Rv0==0) {
    Ra.sl[6]=2682; /* line # 2682 */
    P_err_init(PAS__CON_STR_STR(Ra.s+28,V_cpas_ini_dir.s,Rd.s+2598));
    Ra.sl[6]=2685; /* line # 2685 */
    P_src_init(Rd.s+2612,V_trg_env_fspc.s);
    Ra.sl[6]=2687; /* line # 2687 */
    if (V_src_control==NULL) {
      Ra.sl[6]=2689; /* line # 2689 */
      V_error_result=4;
      V_emergency_stop=1;
      Ra.sl[6]=2690; /* line # 2690 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2619,-1,-1,32);
      PAS__WRITE_STR(V_trg_env_fspc.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+2669,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[6]=2691; /* line # 2691 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2686,-1,-1,32);
      PAS__WRITE_STR(V_trg_sys_name.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=2699; /* line # 2699 */
      PAS_INSMBOL_set_keyword_tree();
      Ra.sl[6]=2701; /* line # 2701 */
      V_proc_seq=0;
      Ra.sl[6]=2702; /* line # 2702 */
      V_srf_free=NULL;
      Ra.sl[6]=2703; /* line # 2703 */
      V_srf_list=NULL;
      Ra.sl[6]=2704; /* line # 2704 */
      Ri.sl[232]=0;
      Ra.sl[6]=2708; /* line # 2708 */
      P_ide_init();
      Ra.sl[6]=2711; /* line # 2711 */
      P_set_srcfilespc(1);
      Ra.sl[6]=2714; /* line # 2714 */
      V_sy_attrflg=0;
      Ra.sl[6]=2715; /* line # 2715 */
      V_sy_ch=32;
      Ra.sl[6]=2718; /* line # 2718 */
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[6]=2723; /* line # 2723 */
    V_error_result=4;
    V_emergency_stop=1;
    Ra.sl[6]=2724; /* line # 2724 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2742,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2539,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2766,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
