/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 1176 ) = {{
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  62,  62,  47,
104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47,
112,  99, 109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115,
101, 116,  95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,
  9,   9, 115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109,
112,  97, 114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,
 97, 114, 101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,
 99, 111, 109, 112,  95, 115,  99,  97, 108,  97, 114,  13,  13,  99, 104, 105,
108, 100, 114, 101, 110,  95, 116, 121, 112, 101,  13,  13, 115, 117,  98,  95,
 99, 111, 109, 112,  95, 116, 121, 112, 101,   1,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   3,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   4,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,
  0,   0,   0,   0,   4,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   1,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   0,   0,   4,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   4,   4,   4,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   4,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,
  0,   0,   4,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,
  4,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   4,   4,   4,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   9,   9,  99,
111, 109, 112,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112,
114, 111,  99,  95,  97, 114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97,
114, 109,  95,  99, 116, 101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,
 49,  21,  21, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,
 95, 114, 101, 108, 101,  97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,
 95, 105, 110,  95,  97, 114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110,
103,  95, 105, 110,  95, 115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16,
105, 110, 105, 116, 105,  97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,
 15,  15, 116, 121, 112, 101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114,
109,   4,   4,  84,  89,  67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,
 95, 115, 101, 116,  95, 118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,
 95, 112,  97, 114, 109,  95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,
 12, 105, 110, 105, 116,  95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100,
121, 110,  95, 114, 101,  99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,
 95, 100, 121, 110,  95, 114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100,
121, 110,  95, 100,   4,   4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,
 95, 100,  95, 100, 121, 110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110,
105, 116,  95, 100,  95, 116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10,
105, 110, 105, 116,  95, 100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,
 13,  13, 105, 110, 105, 116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,
  4,  73,  68,  83,  84,  12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97,
114,  98, 108,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,
  4,   4,  69,  88,  80,  85,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,
 98, 105, 110,   4,   4,  69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95,
102, 111, 114,  95, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,
 99,  97, 108, 108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,
 76,  76,   6,   6,  97,  99,  99, 115, 101, 116,  14,  14, 103, 101, 110, 101,
114, 105,  99,  95, 115, 101,  97, 114,  99, 104,   4,   4,  71,  69,  78,  83,
 11,  11, 101, 120, 112,  95, 103, 101, 110, 111, 112, 101, 114,  13,  13, 103,
101, 110, 101, 114,  97, 116, 101,  95,  99,  97, 108, 108,   9,   9, 101, 120,
112,  95, 103, 101, 110, 111, 112,  13,  13, 108, 103, 116,  95, 103, 101, 110,
 95, 115, 116, 111, 114, 101,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {{
 29,   0,   0,   0,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 248 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern Blk(V_oparg_cvtab, 56 );
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=97; /* line # 97 */
  if (V_sy_sym.ub[0]==5) {
    Ra.sl[6]=99; /* line # 99 */
    (*F_nam)=PAS__NEW(32);
    Ra.sl[6]=100; /* line # 100 */
    Rv0=(*F_nam);
    Ra.sl[6]=102; /* line # 102 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else {
      Ra.sl[6]=103; /* line # 103 */
      ((UB *)Rv0)[0]=V_sy_string.ub[1];
    }
    Ra.sl[6]=104; /* line # 104 */
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[6]=105; /* line # 105 */
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=107; /* line # 107 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=122; /* line # 122 */
  Rv0=F_pr;
  Ra.sl[6]=124; /* line # 124 */
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+92,129,1);
  Ra.sl[6]=125; /* line # 125 */
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=128; /* line # 128 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[6]=129; /* line # 129 */
    P_src_error(Rd.s+92,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+96;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=143; /* line # 143 */
  V_enm_range=0;
  Ra.sl[6]=144; /* line # 144 */
  Rv0=F_ty1==F_ty2;
  Ra.sl[6]=146; /* line # 146 */
  if (!Rv0) {
    Ra.sl[6]=147; /* line # 147 */
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=148; /* line # 148 */
      if (((((UB *)F_ty1)[93]==((UB *)F_ty2)[93]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) {
        Ra.sl[6]=152; /* line # 152 */
        switch (((UB *)F_ty1)[93]) {
          case 0:
          case 1:
          case 2:Ra.sl[6]=154; /* line # 154 */
          if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)
          F_ty2)[29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) {
            Ra.sl[6]=156; /* line # 156 */
            Rv0=1;
          }
          break;
          case 3:
          case 4:Ra.sl[6]=157; /* line # 157 */
          Rv0=1;
          break;
          case 5:
          case 7:
          case 13:Ra.sl[6]=159; /* line # 159 */
          Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
          break;
          case 11:
          case 12:Ra.sl[6]=161; /* line # 161 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) {
            Ra.sl[6]=162; /* line # 162 */
            Rv0=P_same_type(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          }
          break;
          case 8:
          case 9:Ra.sl[6]=164; /* line # 164 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
          [25]) {
            Ra.sl[6]=166; /* line # 166 */
            if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
            F_ty1)[14],((V *)F_ty2)[14])) {
              Ra.sl[6]=168; /* line # 168 */
              Rv0=1;
            }
          }
          break;
          case 22:Ra.sl[6]=170; /* line # 170 */
          Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
          break;
          case 6:Ra.sl[6]=172; /* line # 172 */
          Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          break;
          default:break;
        }
      }
    }
  }
  Ra.sl[6]=175; /* line # 175 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=188; /* line # 188 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Ra.sl[6]=191; /* line # 191 */
    Rv0=0;
    Ra.sl[6]=192; /* line # 192 */
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=194; /* line # 194 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else {
        Ra.sl[6]=195; /* line # 195 */
        Rv0=1;
      }
      Ra.sl[6]=196; /* line # 196 */
      if (Rv0) {
        Ra.sl[6]=198; /* line # 198 */
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=202; /* line # 202 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Ra.sl[6]=205; /* line # 205 */
          Rv0=P_same_type(((V *)Rv1)[5],((V *)Rv2)[5]);
          Ra.sl[6]=206; /* line # 206 */
          if (Rv0) {
            Ra.sl[6]=208; /* line # 208 */
            if (((UB *)Rv1)[53]==7) {
              Ra.sl[6]=209; /* line # 209 */
              if (((UB *)Rv2)[53]==7) {
                Ra.sl[6]=210; /* line # 210 */
                if (((UB *)((V *)Rv1)[8])[104]==4&&((UB *)((V *)Rv2)[8])[104]==4)
                 {
                  Ra.sl[6]=211; /* line # 211 */
                  Rv0=P_compare_entry(((V *)Rv1)[8],((V *)Rv2)[8]);
                }
                else {
                  Ra.sl[6]=212; /* line # 212 */
                  Rv0=0;
                }
              }
              else {
                Ra.sl[6]=213; /* line # 213 */
                Rv0=0;
              }
            }
            Ra.sl[6]=214; /* line # 214 */
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        Ra.sl[6]=217; /* line # 217 */
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=221; /* line # 221 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+122;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=235; /* line # 235 */
  Rv0=0;
  Ra.sl[6]=236; /* line # 236 */
  if (F_pgc!=NULL&&F_ent!=NULL) {
    Ra.sl[6]=239; /* line # 239 */
    while (F_pgc!=NULL&&!Rv0){
      Ra.sl[6]=240; /* line # 240 */
      Rv1=F_pgc;
      Ra.sl[6]=242; /* line # 242 */
      if (!((UB *)Rv1)[8]) {
        Ra.sl[6]=244; /* line # 244 */
        Rv2=((V *)Rv1)[2];
        Ra.sl[6]=245; /* line # 245 */
        Rv0=P_compare_entry(Rv2, F_ent);
      }
      Ra.sl[6]=247; /* line # 247 */
      if (!Rv0) {
        Ra.sl[6]=248; /* line # 248 */
        if (F_pgc==F_pgl) F_pgc=NULL;
        else {
          Ra.sl[6]=249; /* line # 249 */
          F_pgc=((V *)F_pgc)[0];
        }
      }
    }
  }
  Ra.sl[6]=252; /* line # 252 */
  if (!Rv0) F_pgc=NULL;
  Ra.sl[6]=253; /* line # 253 */
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+142;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=272; /* line # 272 */
  Rv0=4;
  Ra.sl[6]=273; /* line # 273 */
  if (F_te==F_tf) Rv0=0;
  else {
    Ra.sl[6]=274; /* line # 274 */
    if (F_te!=NULL&&F_tf!=NULL) {
      Ra.sl[6]=275; /* line # 275 */
      Rv1=F_te;
      Ra.sl[6]=276; /* line # 276 */
      if (((UB *)Rv1)[93]==((UB *)F_tf)[93]) {
        Ra.sl[6]=277; /* line # 277 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          Ra.sl[6]=280; /* line # 280 */
          if (((UB *)Rv1)[112]) {
            Ra.sl[6]=281; /* line # 281 */
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=283; /* line # 283 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Ra.sl[6]=284; /* line # 284 */
          Rv4=F_tf;
          Ra.sl[6]=285; /* line # 285 */
          if (((UB *)Rv4)[112]) {
            Ra.sl[6]=286; /* line # 286 */
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=288; /* line # 288 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          Ra.sl[6]=290; /* line # 290 */
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          Ra.sl[6]=292; /* line # 292 */
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=294; /* line # 294 */
            if (Rv2==Rv5) {
              Ra.sl[6]=295; /* line # 295 */
              if (Rv3==Rv6) Rv0=0;
              else {
                Ra.sl[6]=296; /* line # 296 */
                Rv0=1;
              }
            }
            else {
              Ra.sl[6]=297; /* line # 297 */
              Rv0=2;
            }
          }
          else {
            Ra.sl[6]=298; /* line # 298 */
            Rv0=3;
          }
        }
        else {
          Ra.sl[6]=300; /* line # 300 */
          V_enm_range=1;
        }
      }
    }
  }
  Ra.sl[6]=301; /* line # 301 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " children_type "  */
UB P_children_type(V F_eff, V F_frm, UB F_bpar, UB F_bsym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=315; /* line # 315 */
  if (F_frm!=NULL) {
    Ra.sl[6]=317; /* line # 317 */
    F_bpar=1;
    Ra.sl[6]=318; /* line # 318 */
    if (F_bpar) {
      Ra.sl[6]=320; /* line # 320 */
      Rv1=F_eff;
      Ra.sl[6]=321; /* line # 321 */
      while (Rv1!=NULL&&Rv1!=F_frm)
      Rv1=((V *)Rv1)[0];
      Ra.sl[6]=322; /* line # 322 */
      Rv0=Rv1==F_frm;
      Ra.sl[6]=323; /* line # 323 */
      if (!Rv0&&F_bsym) Rv0=P_children_type(F_frm, F_eff, F_bpar,0);
    }
    else {
      Ra.sl[6]=325; /* line # 325 */
      Rv0=F_eff==F_frm;
    }
  }
  Ra.sl[6]=327; /* line # 327 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sub_comp_type "  */
UB PAS_EXPSION_PRC_00000000(V F_eff, V F_frm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=383; /* line # 383 */
  Rv0=0;
  Ra.sl[6]=384; /* line # 384 */
  Rv1=F_frm;
  Ra.sl[6]=385; /* line # 385 */
  switch (Rd.ub[((UB *)F_eff)[93]*22+((UB *)Rv1)[93]+185]) {
    case 4:Ra.sl[6]=386; /* line # 386 */
    Rv0=1;
    break;
    case 1:Ra.sl[6]=389; /* line # 389 */
    switch (((UB *)Rv1)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=393; /* line # 393 */
      if (((UB *)Rv1)[89]) {
        Ra.sl[6]=394; /* line # 394 */
        if (!Lx[0].ub[28]) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
        else {
          Ra.sl[6]=395; /* line # 395 */
          Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv1)[11]==((SL *)
          F_eff)[11];
        }
      }
      break;
      case 11:
      case 12:Ra.sl[6]=399; /* line # 399 */
      Rv0=P_comp_type(((V *)F_eff)[13],((V *)Rv1)[13],Lx[0].ub[28],0);
      break;
      case 8:Ra.sl[6]=402; /* line # 402 */
      Rv0=((V *)F_eff)[14]==((V *)Rv1)[14]&&P_comp_type(((V *)F_eff)[15],((V *)Rv1)
      [15],1,1);
      break;
      case 9:Ra.sl[6]=406; /* line # 406 */
      Rv0=P_comp_type(((V *)F_eff)[14],((V *)Rv1)[14],1,0)&&P_comp_type(((V *)F_eff)
      [15],((V *)((V *)Rv1)[15])[0],1,1);
      break;
      case 5:Ra.sl[6]=410; /* line # 410 */
      if (((V *)Rv1)[12]==NULL) Rv0=1;
      else {
        Ra.sl[6]=411; /* line # 411 */
        Rv0=P_comp_type(((V *)F_eff)[12],((V *)Rv1)[12],1,1);
      }
      break;
      case 6:Ra.sl[6]=414; /* line # 414 */
      if (((V *)Rv1)[13]==NULL) Rv0=1;
      else {
        Ra.sl[6]=415; /* line # 415 */
        Rv0=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv1)[13]);
      }
      break;
      default:break;
    }
    break;
    case 3:Ra.sl[6]=421; /* line # 421 */
    Rv0=P_comp_type(F_frm, V_typ_std.v[10],0,0);
    break;
    case 2:Ra.sl[6]=424; /* line # 424 */
    if (P_comp_type(F_eff, V_typ_std.v[10],0,0)) {
      Ra.sl[6]=426; /* line # 426 */
      Rv0=P_comp_type(((V *)((V *)F_eff)[13])[5],F_frm,0,0);
    }
    break;
    default:break;
  }
  Ra.sl[6]=431; /* line # 431 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_exact;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+669;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=436; /* line # 436 */
  V_enm_range=0;
  Ra.sl[6]=438; /* line # 438 */
  Rv0=0;
  Ra.sl[6]=439; /* line # 439 */
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=441; /* line # 441 */
    Rv0=P_children_type(F_eff, F_frm,!Ra.ub[28],F_sym);
    Ra.sl[6]=442; /* line # 442 */
    if (!Rv0) {
      Ra.sl[6]=443; /* line # 443 */
      Rv1=F_frm;
      Ra.sl[6]=445; /* line # 445 */
      if (((UB *)Rv1)[93]==22) {
        Ra.sl[6]=446; /* line # 446 */
        Rv0=P_comp_type(((V *)Rv1)[0],F_eff, Ra.ub[28],0);
      }
      Ra.sl[6]=448; /* line # 448 */
      if (!Rv0) {
        Ra.sl[6]=449; /* line # 449 */
        if (((UB *)F_eff)[93]<=21&&((UB *)Rv1)[93]<=21) {
          Ra.sl[6]=451; /* line # 451 */
          Rv0=PAS_EXPSION_PRC_00000000(F_eff, F_frm);
          Ra.sl[6]=452; /* line # 452 */
          if (!Rv0&&F_sym) Rv0=PAS_EXPSION_PRC_00000000(F_frm, F_eff);
        }
      }
    }
  }
  Ra.sl[6]=456; /* line # 456 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+680;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=470; /* line # 470 */
  Rv0=1;
  Ra.sl[6]=471; /* line # 471 */
  if (F_epr!=F_fpr) {
    Ra.sl[6]=472; /* line # 472 */
    if (F_epr!=NULL&&F_fpr!=NULL) {
      Ra.sl[6]=474; /* line # 474 */
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=475; /* line # 475 */
        Rv0=0;
      }
      else {
        Ra.sl[6]=478; /* line # 478 */
        Rv1=((V *)F_epr)[8];
        Ra.sl[6]=479; /* line # 479 */
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=480; /* line # 480 */
        if (((V *)F_epr)[11]!=NULL) {
          Ra.sl[6]=481; /* line # 481 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        Ra.sl[6]=482; /* line # 482 */
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          Ra.sl[6]=484; /* line # 484 */
          if (((UB *)Rv2)[53]!=((UB *)Rv1)[53]) Rv0=0;
          else {
            Ra.sl[6]=486; /* line # 486 */
            switch (((UB *)Rv2)[53]) {
              case 5:Ra.sl[6]=488; /* line # 488 */
              Rv0=P_comp_type(((V *)Rv1)[5],((V *)Rv2)[5],((UB *)Rv2)[86]!=9,0);
              break;
              case 7:Ra.sl[6]=491; /* line # 491 */
              if (P_comp_type(((V *)Rv1)[5],((V *)Rv2)[5],1,0)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[8],((V *)Rv2)[8]);
              else {
                Ra.sl[6]=492; /* line # 492 */
                Rv0=0;
              }
              break;
              default:break;
            }
          }
          Ra.sl[6]=497; /* line # 497 */
          Rv1=((V *)Rv1)[3];
          Ra.sl[6]=498; /* line # 498 */
          Rv2=((V *)Rv2)[3];
        }
      }
      Ra.sl[6]=501; /* line # 501 */
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=503; /* line # 503 */
      Rv0=0;
    }
  }
  Ra.sl[6]=504; /* line # 504 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+695;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=522; /* line # 522 */
  if (F_ty!=NULL) {
    Ra.sl[6]=523; /* line # 523 */
    Rv0=F_ty;
    Ra.sl[6]=525; /* line # 525 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=526; /* line # 526 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=527; /* line # 527 */
    while (Rv1!=NULL){
      Ra.sl[6]=528; /* line # 528 */
      Rv3=Rv1;
      Ra.sl[6]=530; /* line # 530 */
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Ra.sl[6]=531; /* line # 531 */
      Rv5=Rv4;
      Ra.sl[6]=533; /* line # 533 */
      ((V *)Rv5)[3]=((V *)Rv3)[5];
      Ra.sl[6]=534; /* line # 534 */
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+717,132,3);
      else {
        Ra.sl[6]=536; /* line # 536 */
        Rv6=((V *)Rv5)[7];
        Ra.sl[6]=537; /* line # 537 */
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[5])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[5];
      }
      Ra.sl[6]=538; /* line # 538 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[14];
      Ra.sl[6]=540; /* line # 540 */
      ((V *)Rv3)[9]=Rv4;
      Ra.sl[6]=541; /* line # 541 */
      ((UB *)Rv3)[60]=1;
      Ra.sl[6]=542; /* line # 542 */
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=543; /* line # 543 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      Ra.sl[6]=544; /* line # 544 */
      (*F_lghl)=Rv4;
      Ra.sl[6]=545; /* line # 545 */
      (*F_count)=(*F_count)+1;
      Ra.sl[6]=546; /* line # 546 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=547; /* line # 547 */
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+721;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=562; /* line # 562 */
  Rv0=((V *)F_ty)[4];
  Ra.sl[6]=563; /* line # 563 */
  while (Rv0!=NULL){
    Ra.sl[6]=564; /* line # 564 */
    Rv1=Rv0;
    Ra.sl[6]=566; /* line # 566 */
    ((UB *)Rv1)[60]=0;
    Ra.sl[6]=567; /* line # 567 */
    ((V *)Rv1)[9]=NULL;
    Ra.sl[6]=568; /* line # 568 */
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+744;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=585; /* line # 585 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=586; /* line # 586 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=588; /* line # 588 */
    Rv2=NULL;
    Ra.sl[6]=589; /* line # 589 */
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=590; /* line # 590 */
    Rv4=NULL;
    Ra.sl[6]=591; /* line # 591 */
    Rv5=NULL;
    Ra.sl[6]=592; /* line # 592 */
    Rv6=0;
    Ra.sl[6]=593; /* line # 593 */
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=600; /* line # 600 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      Ra.sl[6]=601; /* line # 601 */
      while (Rv4!=NULL){
        Ra.sl[6]=603; /* line # 603 */
        Rv5=Rv4;
        Ra.sl[6]=604; /* line # 604 */
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=605; /* line # 605 */
        Rv7=Rv5;
        Ra.sl[6]=607; /* line # 607 */
        Rv8=NULL;
        Ra.sl[6]=608; /* line # 608 */
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        Ra.sl[6]=609; /* line # 609 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=610; /* line # 610 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=611; /* line # 611 */
        Rv2=Rv8;
        Ra.sl[6]=613; /* line # 613 */
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=615; /* line # 615 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    Ra.sl[6]=618; /* line # 618 */
    if (Rv3<=0) {
      Ra.sl[6]=619; /* line # 619 */
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=620; /* line # 620 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    Ra.sl[6]=622; /* line # 622 */
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=625; /* line # 625 */
      if (Rv3<=0) Rv3=1;
      Ra.sl[6]=626; /* line # 626 */
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else {
        Ra.sl[6]=627; /* line # 627 */
        ((V *)Rv2)[0]=((V *)Rv0)[7];
      }
      Ra.sl[6]=628; /* line # 628 */
      Rv2=((V *)Rv0)[7];
      Ra.sl[6]=629; /* line # 629 */
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=630; /* line # 630 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Ra.sl[6]=632; /* line # 632 */
        Rv8=NULL;
        Ra.sl[6]=633; /* line # 633 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=634; /* line # 634 */
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=635; /* line # 635 */
        ((V *)Rv2)[0]=Rv8;
        Ra.sl[6]=636; /* line # 636 */
        Rv2=Rv8;
      }
      break;
      case 29:Ra.sl[6]=642; /* line # 642 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      Ra.sl[6]=643; /* line # 643 */
      if (Rv10==NULL) Rv11=0;
      else {
        Ra.sl[6]=644; /* line # 644 */
        Rv11=((UB *)Rv10)[1];
      }
      Ra.sl[6]=645; /* line # 645 */
      if (Rv3<=0) {
        Ra.sl[6]=646; /* line # 646 */
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=648; /* line # 648 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          Ra.sl[6]=649; /* line # 649 */
          if (Rv12!=NULL) {
            Ra.sl[6]=650; /* line # 650 */
            Rv13=Rv12;
            Ra.sl[6]=651; /* line # 651 */
            if (((UB *)Rv13)[40]==14) {
              Ra.sl[6]=652; /* line # 652 */
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=655; /* line # 655 */
      if (Rv3<=0) Rv3=Rv11;
      Ra.sl[6]=656; /* line # 656 */
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Ra.sl[6]=658; /* line # 658 */
        Rv8=NULL;
        Ra.sl[6]=659; /* line # 659 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=660; /* line # 660 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else {
          Ra.sl[6]=661; /* line # 661 */
          ((SL *)Rv8)[13]=32;
        }
        Ra.sl[6]=662; /* line # 662 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=663; /* line # 663 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=664; /* line # 664 */
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=669; /* line # 669 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    Ra.sl[6]=670; /* line # 670 */
    P_val_new(((V *)Rv0)+7,F_ty);
    Ra.sl[6]=671; /* line # 671 */
    Rv15=((V *)Rv0)[7];
    Ra.sl[6]=673; /* line # 673 */
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=674; /* line # 674 */
    ((SL *)Rv15)[6]=Rv3;
    Ra.sl[6]=675; /* line # 675 */
    ((SL *)Rv15)[2]=Rv6;
    Ra.sl[6]=678; /* line # 678 */
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=680; /* line # 680 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+761;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=694; /* line # 694 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=695; /* line # 695 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=697; /* line # 697 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=698; /* line # 698 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=699; /* line # 699 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Ra.sl[6]=700; /* line # 700 */
    Rv3=((V *)Rv0)[7];
    Ra.sl[6]=702; /* line # 702 */
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    Ra.sl[6]=703; /* line # 703 */
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=706; /* line # 706 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+782;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=718; /* line # 718 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[4];
  Ra.sl[6]=720; /* line # 720 */
  ((UW *)Rv0)[42]=((UW *)Rv0)[42]|8;
  Ra.sl[6]=722; /* line # 722 */
  P_lgt_new(&Rv2,((V *)Rv0)[5],14,NULL);
  Ra.sl[6]=723; /* line # 723 */
  Rv3=Rv2;
  Ra.sl[6]=725; /* line # 725 */
  ((V *)Rv3)[7]=((V *)Rv0)[7];
  Ra.sl[6]=726; /* line # 726 */
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=728; /* line # 728 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  Ra.sl[6]=731; /* line # 731 */
  if (((UB *)((V *)Rv0)[5])[93]==7||((UB *)((V *)Rv0)[5])[93]==16) {
    Ra.sl[6]=732; /* line # 732 */
    Rv2=P_lgt_new_code(3, Rv2);
  }
  else {
    Ra.sl[6]=734; /* line # 734 */
    Rv2=P_exp_genop(28, Rv2);
  }
  Ra.sl[6]=737; /* line # 737 */
  switch (((UB *)Rv1)[104]) {
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:Ra.sl[6]=740; /* line # 740 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else {
      Ra.sl[6]=741; /* line # 741 */
      ((V *)((V *)Rv1)[17])[0]=Rv2;
    }
    Ra.sl[6]=742; /* line # 742 */
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+800;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=762; /* line # 762 */
  Rv0=F_lgt;
  Ra.sl[6]=763; /* line # 763 */
  switch (((UB *)Rv0)[40]) {
    case 13:Ra.sl[6]=765; /* line # 765 */
    Rv1=((V *)Rv0)[6];
    Ra.sl[6]=766; /* line # 766 */
    if (((UB *)Rv1)[53]!=2) {
      Ra.sl[6]=768; /* line # 768 */
      P_src_error_s(Rd.s+819,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=774; /* line # 774 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[6]=775; /* line # 775 */
    while (Rv2!=NULL){
      Ra.sl[6]=777; /* line # 777 */
      P_type_check_parm(Rv2);
      Ra.sl[6]=778; /* line # 778 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=780; /* line # 780 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=788; /* line # 788 */
      P_src_error(Rd.s+819,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=794; /* line # 794 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+819,203,3);
    break;
    default:Ra.sl[6]=798; /* line # 798 */
    P_src_error(Rd.s+819,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000001(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+823;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=827; /* line # 827 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    Ra.sl[6]=830; /* line # 830 */
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    Ra.sl[6]=831; /* line # 831 */
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=833; /* line # 833 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        Ra.sl[6]=835; /* line # 835 */
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        Ra.sl[6]=836; /* line # 836 */
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+842;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=844; /* line # 844 */
  Rv0=0;
  Ra.sl[6]=845; /* line # 845 */
  Rv1=F_lgt;
  Ra.sl[6]=846; /* line # 846 */
  Rv2=F_ip;
  Ra.sl[6]=848; /* line # 848 */
  Rv3=((V *)((V *)Rv2)[5])[4];
  Ra.sl[6]=849; /* line # 849 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Ra.sl[6]=852; /* line # 852 */
    Rv4=Rv3;
    Rv5=Rv1;
    Ra.sl[6]=853; /* line # 853 */
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[5],0,0)) {
      Ra.sl[6]=856; /* line # 856 */
      P_type_check_parm(Rv1);
      Ra.sl[6]=857; /* line # 857 */
      ((UB *)Rv4)[60]=2;
      Ra.sl[6]=858; /* line # 858 */
      ((V *)Rv4)[9]=Rv1;
    }
    else {
      Ra.sl[6]=861; /* line # 861 */
      P_src_error_s(Rd.s+859,201,3,((V *)Rv4)[0],NULL);
    }
    Ra.sl[6]=863; /* line # 863 */
    Rv1=((V *)Rv1)[0];
    Ra.sl[6]=864; /* line # 864 */
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=867; /* line # 867 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+859,998,3);
  Ra.sl[6]=869; /* line # 869 */
  if (((UB *)((V *)Rv2)[5])[93]==27) {
    Ra.sl[6]=871; /* line # 871 */
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[5])[9],NULL,NULL,0);
    Ra.sl[6]=873; /* line # 873 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else {
      Ra.sl[6]=874; /* line # 874 */
      P_src_error(Rd.s+859,222,3);
    }
  }
  else {
    Ra.sl[6]=878; /* line # 878 */
    P_ide_new_typ(((UB *)((V *)Rv2)[5])[93],&Rv6);
    Ra.sl[6]=879; /* line # 879 */
    Rv7=Rv6;
    Ra.sl[6]=881; /* line # 881 */
    ((UB *)Rv7)[90]=1;
    Ra.sl[6]=882; /* line # 882 */
    ((V *)Rv7)[0]=((V *)Rv2)[5];
    Ra.sl[6]=883; /* line # 883 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[5])[4];
    Ra.sl[6]=884; /* line # 884 */
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[5])[11];
    Ra.sl[6]=885; /* line # 885 */
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[5])[10];
    Ra.sl[6]=886; /* line # 886 */
    memcpy(Rv7+48,((V *)Rv2)[5]+48,1);
    Ra.sl[6]=887; /* line # 887 */
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[5])[10];
    Ra.sl[6]=888; /* line # 888 */
    ((UB *)Rv7)[91]=((UB *)((V *)Rv2)[5])[91];
    Ra.sl[6]=890; /* line # 890 */
    V_sy_type_gfirst=((V *)Rv2)[10];
    Ra.sl[6]=891; /* line # 891 */
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=893; /* line # 893 */
    PAS_EXPSION_PRC_00000001(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[5])[9]
    );
    Ra.sl[6]=895; /* line # 895 */
    switch (((UB *)Rv7)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=898; /* line # 898 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      Ra.sl[6]=899; /* line # 899 */
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      Ra.sl[6]=900; /* line # 900 */
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      Ra.sl[6]=901; /* line # 901 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=906; /* line # 906 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[5])[12]);
      Ra.sl[6]=907; /* line # 907 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[5])[14]);
      Ra.sl[6]=908; /* line # 908 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[5])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=914; /* line # 914 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:Ra.sl[6]=917; /* line # 917 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=928; /* line # 928 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      Ra.sl[6]=929; /* line # 929 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[5])
      [13]);
      Ra.sl[6]=931; /* line # 931 */
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      Ra.sl[6]=932; /* line # 932 */
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=941; /* line # 941 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      Ra.sl[6]=942; /* line # 942 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      Ra.sl[6]=943; /* line # 943 */
      if (((V *)((V *)Rv7)[0])[14]!=NULL) {
        Ra.sl[6]=944; /* line # 944 */
        ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)Rv7)[0])[14]);
      }
      else {
        Ra.sl[6]=946; /* line # 946 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=951; /* line # 951 */
      P_src_error(Rd.s+859,998,3);
      break;
    }
  }
  Ra.sl[6]=957; /* line # 957 */
  Rv3=((V *)((V *)Rv2)[5])[4];
  Ra.sl[6]=959; /* line # 959 */
  while (Rv3!=NULL){
    Ra.sl[6]=960; /* line # 960 */
    Rv8=Rv3;
    Ra.sl[6]=962; /* line # 962 */
    ((V *)Rv8)[9]=NULL;
    Ra.sl[6]=963; /* line # 963 */
    ((UB *)Rv8)[60]=0;
    Ra.sl[6]=964; /* line # 964 */
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=968; /* line # 968 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+863;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1002; /* line # 1002 */
  Rv0=F_ty;
  Ra.sl[6]=1003; /* line # 1003 */
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=1004; /* line # 1004 */
    if (((UB *)((V *)Rv0)[14])[91]) {
      Ra.sl[6]=1007; /* line # 1007 */
      Rv1=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
      Ra.sl[6]=1010; /* line # 1010 */
      ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
      Ra.sl[6]=1011; /* line # 1011 */
      Rv2=P_lgt_new_code(3, Rv1);
      Ra.sl[6]=1014; /* line # 1014 */
      if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
      else {
        Ra.sl[6]=1015; /* line # 1015 */
        ((V *)(*F_lgl))[0]=Rv2;
      }
      Ra.sl[6]=1016; /* line # 1016 */
      (*F_lgl)=Rv2;
      Ra.sl[6]=1019; /* line # 1019 */
      Rv3=1;
      Ra.sl[6]=1020; /* line # 1020 */
      if (((V *)Rv0)[13]!=NULL) {
        Ra.sl[6]=1022; /* line # 1022 */
        Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
        Ra.sl[6]=1023; /* line # 1023 */
        if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
          Ra.sl[6]=1026; /* line # 1026 */
          Rv2=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
          Ra.sl[6]=1029; /* line # 1029 */
          ((V *)Rv2)[0]=Rv4;
          Rv4=P_lgt_link(Rv2);
          Ra.sl[6]=1030; /* line # 1030 */
          Rv2=P_lgt_new_code(3, Rv2);
          Ra.sl[6]=1032; /* line # 1032 */
          if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
          else {
            Ra.sl[6]=1033; /* line # 1033 */
            ((V *)(*F_lgl))[0]=Rv2;
          }
          Ra.sl[6]=1034; /* line # 1034 */
          (*F_lgl)=Rv2;
          Ra.sl[6]=1035; /* line # 1035 */
          Rv3=0;
        }
      }
      else {
        Ra.sl[6]=1038; /* line # 1038 */
        Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
      }
      Ra.sl[6]=1041; /* line # 1041 */
      if (Lx[2].ub[28]) {
        Ra.sl[6]=1043; /* line # 1043 */
        P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
        Ra.sl[6]=1044; /* line # 1044 */
        ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
      }
      else {
        Ra.sl[6]=1046; /* line # 1046 */
        P_lgt_new_copy(F_trg, &Rv2);
      }
      Ra.sl[6]=1048; /* line # 1048 */
      Rv5=P_lgt_link(Rv1);
      ((V *)Rv5)[0]=Rv4;
      ((V *)Rv2)[0]=Rv5;
      Ra.sl[6]=1051; /* line # 1051 */
      Rv6=Rv2;
      ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
      Ra.sl[6]=1052; /* line # 1052 */
      P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
      Ra.sl[6]=1053; /* line # 1053 */
      Rv7=((V *)Rv0)[14];
      Rv8=Rv2;
      Ra.sl[6]=1055; /* line # 1055 */
      ((V *)Rv8)[6]=F_ty;
      Ra.sl[6]=1056; /* line # 1056 */
      if (((UB *)Rv7)[93]!=10&&((UB *)Rv7)[93]!=23) {
        Ra.sl[6]=1057; /* line # 1057 */
        ((SL *)Rv8)[4]=((SL *)Rv8)[4]+((SL *)Rv7)[10];
      }
      Ra.sl[6]=1058; /* line # 1058 */
      ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
      Ra.sl[6]=1067; /* line # 1067 */
      Rv9=((V *)Rv0)[15];
      Ra.sl[6]=1068; /* line # 1068 */
      if (((UB *)Rv9)[93]!=22) {
        Ra.sl[6]=1070; /* line # 1070 */
        if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
        else {
          Ra.sl[6]=1071; /* line # 1071 */
          Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
        }
        Ra.sl[6]=1072; /* line # 1072 */
        Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
      }
      else {
        Ra.sl[6]=1074; /* line # 1074 */
        Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
      }
      Ra.sl[6]=1076; /* line # 1076 */
      Rv12=Rv11;
      Ra.sl[6]=1077; /* line # 1077 */
      PAS_EXPSION_PRC_00000002(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
      Ra.sl[6]=1080; /* line # 1080 */
      ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
      Ra.sl[6]=1088; /* line # 1088 */
      P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
      Ra.sl[6]=1089; /* line # 1089 */
      ((UB *)Rv5)[41]=5;
      Ra.sl[6]=1092; /* line # 1092 */
      if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
      else {
        Ra.sl[6]=1093; /* line # 1093 */
        ((V *)(*F_lgl))[0]=Rv5;
      }
      Ra.sl[6]=1094; /* line # 1094 */
      (*F_lgl)=Rv5;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000005(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+877;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1118; /* line # 1118 */
  Rv0=NULL;
  Ra.sl[6]=1119; /* line # 1119 */
  Rv1=NULL;
  Ra.sl[6]=1120; /* line # 1120 */
  PAS_EXPSION_PRC_00000004(F_ty, Lx[1].v[4],&Rv0, &Rv1);
  Ra.sl[6]=1121; /* line # 1121 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1123; /* line # 1123 */
    if (Rv1!=Rv0) {
      Ra.sl[6]=1125; /* line # 1125 */
      P_lgt_new(&Rv0,NULL,0, Rv0);
      Ra.sl[6]=1126; /* line # 1126 */
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1129; /* line # 1129 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+890;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1135; /* line # 1135 */
  Rv0=F_ty;
  Ra.sl[6]=1137; /* line # 1137 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1139; /* line # 1139 */
  while (Rv1!=NULL){
    Ra.sl[6]=1140; /* line # 1140 */
    Rv2=Rv1;
    Ra.sl[6]=1142; /* line # 1142 */
    if (((V *)Rv2)[5]!=NULL) {
      Ra.sl[6]=1143; /* line # 1143 */
      Rv3=((V *)Rv2)[5];
      Ra.sl[6]=1145; /* line # 1145 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[91]) {
        Ra.sl[6]=1148; /* line # 1148 */
        if (Lx[2].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[5],2, P_lgt_link(Ra.v[4]));
        else {
          Ra.sl[6]=1149; /* line # 1149 */
          P_lgt_new_copy(Ra.v[4],&Rv4);
        }
        Ra.sl[6]=1150; /* line # 1150 */
        Rv5=Rv4;
        Ra.sl[6]=1152; /* line # 1152 */
        ((V *)Rv5)[4]=Rv1;
        Ra.sl[6]=1154; /* line # 1154 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[14];
        Ra.sl[6]=1157; /* line # 1157 */
        if (((UB *)Rv3)[93]!=10&&((UB *)Rv3)[93]!=23) {
          Ra.sl[6]=1158; /* line # 1158 */
          ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)((V *)Rv2)[5])[10];
        }
        Ra.sl[6]=1160; /* line # 1160 */
        PAS_EXPSION_PRC_00000002(((V *)Rv2)[5],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1162; /* line # 1162 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1163; /* line # 1163 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1167; /* line # 1167 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1170; /* line # 1170 */
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1172; /* line # 1172 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else {
      Ra.sl[6]=1173; /* line # 1173 */
      ((V *)(*F_lgl))[0]=Rv6;
    }
    Ra.sl[6]=1174; /* line # 1174 */
    (*F_lgl)=Rv6;
    Ra.sl[6]=1175; /* line # 1175 */
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1178; /* line # 1178 */
    P_lgt_new_copy(Rv7, &Rv4);
    Ra.sl[6]=1179; /* line # 1179 */
    ((V *)Rv6)[1]=Rv4;
    Ra.sl[6]=1180; /* line # 1180 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1183; /* line # 1183 */
    Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
    Ra.sl[6]=1184; /* line # 1184 */
    ((V *)Rv4)[0]=Rv6;
    Ra.sl[6]=1185; /* line # 1185 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1188; /* line # 1188 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1189; /* line # 1189 */
    ((V *)Rv6)[0]=Rv4;
    Ra.sl[6]=1190; /* line # 1190 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1191; /* line # 1191 */
    while (Rv7!=NULL){
      Ra.sl[6]=1193; /* line # 1193 */
      Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
      Ra.sl[6]=1194; /* line # 1194 */
      ((V *)Rv4)[0]=Rv6;
      Ra.sl[6]=1195; /* line # 1195 */
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+904;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1222; /* line # 1222 */
  Rv0=F_ty;
  Ra.sl[6]=1224; /* line # 1224 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1226; /* line # 1226 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1227; /* line # 1227 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=1228; /* line # 1228 */
    while (Rv1!=NULL&&Rv2!=NULL){
      Ra.sl[6]=1229; /* line # 1229 */
      Rv3=Rv1;
      Ra.sl[6]=1232; /* line # 1232 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[5],2, P_lgt_link(F_trg));
      else {
        Ra.sl[6]=1233; /* line # 1233 */
        P_lgt_new_copy(F_trg, &Rv4);
      }
      Ra.sl[6]=1236; /* line # 1236 */
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1238; /* line # 1238 */
      ((V *)Rv5)[3]=((V *)Rv3)[5];
      Ra.sl[6]=1239; /* line # 1239 */
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[14];
      Ra.sl[6]=1240; /* line # 1240 */
      if (((UB *)Rv6)[93]!=10&&((UB *)Rv6)[93]!=23) {
        Ra.sl[6]=1241; /* line # 1241 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]-((SL *)Rv6)[10];
      }
      Ra.sl[6]=1242; /* line # 1242 */
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[5],0);
      Ra.sl[6]=1243; /* line # 1243 */
      ((V *)Rv3)[9]=((V *)Rv5)[0];
      Ra.sl[6]=1245; /* line # 1245 */
      ((UB *)Rv3)[60]=1;
      Ra.sl[6]=1247; /* line # 1247 */
      P_lgt_new(&Rv4,((V *)Rv3)[5],6, Rv4);
      Ra.sl[6]=1248; /* line # 1248 */
      ((UB *)Rv4)[41]=3;
      Ra.sl[6]=1251; /* line # 1251 */
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else {
        Ra.sl[6]=1252; /* line # 1252 */
        ((V *)(*F_lgl))[0]=Rv4;
      }
      Ra.sl[6]=1253; /* line # 1253 */
      (*F_lgl)=Rv4;
      Ra.sl[6]=1254; /* line # 1254 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=1255; /* line # 1255 */
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1259; /* line # 1259 */
  if (((UB *)Rv0)[91]) {
    Ra.sl[6]=1260; /* line # 1260 */
    switch (((UB *)Rv0)[93]) {
      case 10:
      case 23:Ra.sl[6]=1262; /* line # 1262 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgh,F_lgl);
      break;
      case 8:
      case 9:Ra.sl[6]=1265; /* line # 1265 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
      break;
      default:Ra.sl[6]=1268; /* line # 1268 */
      P_src_error(Rd.s+918,131,3);
      break;
    }
  }
  Ra.sl[6]=1271; /* line # 1271 */
  Rv1=((V *)F_ty)[4];
  Ra.sl[6]=1272; /* line # 1272 */
  while (Rv1!=NULL){
    Ra.sl[6]=1273; /* line # 1273 */
    Rv7=Rv1;
    Ra.sl[6]=1275; /* line # 1275 */
    ((V *)Rv7)[9]=NULL;
    Ra.sl[6]=1276; /* line # 1276 */
    ((UB *)Rv7)[60]=0;
    Ra.sl[6]=1277; /* line # 1277 */
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+922;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1284; /* line # 1284 */
  if (((UB *)F_ty)[91]) {
    Ra.sl[6]=1286; /* line # 1286 */
    switch (((UB *)F_ty)[93]) {
      case 10:
      case 23:Ra.sl[6]=1288; /* line # 1288 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      case 8:
      case 9:Ra.sl[6]=1291; /* line # 1291 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      default:Ra.sl[6]=1294; /* line # 1294 */
      P_src_error(Rd.s+936,131,3);
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+940;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1324; /* line # 1324 */
  Rv0=F_ty;
  Ra.sl[6]=1326; /* line # 1326 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=1327; /* line # 1327 */
    Rv1=((V *)Rv0)[15];
    Ra.sl[6]=1328; /* line # 1328 */
    if (((UB *)Rv1)[93]!=22) {
      Ra.sl[6]=1329; /* line # 1329 */
      if (((UB *)Rv1)[112]) {
        Ra.sl[6]=1330; /* line # 1330 */
        Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      }
      else {
        Ra.sl[6]=1332; /* line # 1332 */
        Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1335; /* line # 1335 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      Ra.sl[6]=1336; /* line # 1336 */
      if (((UB *)Rv3)[40]==14) {
        Ra.sl[6]=1338; /* line # 1338 */
        Rv2=((SL *)((V *)Rv3)[7])[13];
        Ra.sl[6]=1339; /* line # 1339 */
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1341; /* line # 1341 */
        P_src_error(Rd.s+954,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1343; /* line # 1343 */
    Rv2=0;
  }
  Ra.sl[6]=1345; /* line # 1345 */
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1347; /* line # 1347 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    Ra.sl[6]=1348; /* line # 1348 */
    if (((UB *)Rv3)[40]==14) {
      Ra.sl[6]=1350; /* line # 1350 */
      Rv4=((SL *)((V *)Rv3)[7])[13];
      Ra.sl[6]=1351; /* line # 1351 */
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1353; /* line # 1353 */
      P_src_error(Rd.s+954,142,4);
    }
  }
  else {
    Ra.sl[6]=1355; /* line # 1355 */
    Rv4=((SL *)Rv0)[25];
  }
  Ra.sl[6]=1357; /* line # 1357 */
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1359; /* line # 1359 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Ra.sl[6]=1361; /* line # 1361 */
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=1363; /* line # 1363 */
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1364; /* line # 1364 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    Ra.sl[6]=1365; /* line # 1365 */
    if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv7;
    else {
      Ra.sl[6]=1366; /* line # 1366 */
      ((V *)Lx[3].v[1])[0]=Rv7;
    }
    Ra.sl[6]=1367; /* line # 1367 */
    Lx[3].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1369; /* line # 1369 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000007(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+958;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1388; /* line # 1388 */
  Rv0=F_ty;
  Ra.sl[6]=1390; /* line # 1390 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1392; /* line # 1392 */
  while (Rv1!=NULL){
    Ra.sl[6]=1393; /* line # 1393 */
    Rv2=Rv1;
    Ra.sl[6]=1395; /* line # 1395 */
    if (((V *)Rv2)[5]!=NULL) {
      Ra.sl[6]=1396; /* line # 1396 */
      Rv3=((V *)Rv2)[5];
      Ra.sl[6]=1398; /* line # 1398 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[91]) {
        Ra.sl[6]=1400; /* line # 1400 */
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[5],0);
        Ra.sl[6]=1401; /* line # 1401 */
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1404; /* line # 1404 */
        if (((SL *)Rv3)[11]>0) {
          Ra.sl[6]=1406; /* line # 1406 */
          Rv4=NULL;
          Ra.sl[6]=1407; /* line # 1407 */
          P_val_new(&Rv4, V_typ_std.v[0]);
          Ra.sl[6]=1408; /* line # 1408 */
          Rv6=Rv4;
          Ra.sl[6]=1410; /* line # 1410 */
          Rv5=((SL *)Rv3)[11];
          Ra.sl[6]=1411; /* line # 1411 */
          ((UB *)Rv6)[48]=28;
          Ra.sl[6]=1412; /* line # 1412 */
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          Ra.sl[6]=1413; /* line # 1413 */
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1416; /* line # 1416 */
          Rv5=0;
        }
      }
      Ra.sl[6]=1417; /* line # 1417 */
      if (Rv5>0) {
        Ra.sl[6]=1419; /* line # 1419 */
        (*F_iadr)=(*F_iadr)+Rv5;
        Ra.sl[6]=1420; /* line # 1420 */
        if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv4;
        else {
          Ra.sl[6]=1421; /* line # 1421 */
          ((V *)Lx[3].v[1])[0]=Rv4;
        }
        Ra.sl[6]=1422; /* line # 1422 */
        Lx[3].v[1]=Rv4;
      }
      Ra.sl[6]=1424; /* line # 1424 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1425; /* line # 1425 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1429; /* line # 1429 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1430; /* line # 1430 */
    Rv7=((V *)Rv0)[14];
    Ra.sl[6]=1432; /* line # 1432 */
    Rv8=((V *)Rv7)[1];
    Ra.sl[6]=1433; /* line # 1433 */
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1434; /* line # 1434 */
    Rv10=((V *)Rv9)[0];
    Ra.sl[6]=1435; /* line # 1435 */
    Rv11=Rv8;
    Ra.sl[6]=1437; /* line # 1437 */
    Rv12=((SL *)Rv11)[4];
    Ra.sl[6]=1438; /* line # 1438 */
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1439; /* line # 1439 */
      Rv13=((V *)Rv11)[7];
      Ra.sl[6]=1442; /* line # 1442 */
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Ra.sl[6]=1443; /* line # 1443 */
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1445; /* line # 1445 */
      Rv15=NULL;
    }
    Ra.sl[6]=1447; /* line # 1447 */
    if (((V *)Rv0)[4]!=NULL) {
      Ra.sl[6]=1449; /* line # 1449 */
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1450; /* line # 1450 */
      Rv17=Rv16;
      Ra.sl[6]=1451; /* line # 1451 */
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+972,142,3);
      else {
        Ra.sl[6]=1453; /* line # 1453 */
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else {
          Ra.sl[6]=1454; /* line # 1454 */
          Rv18=Rv12-1;
        }
      }
      Ra.sl[6]=1455; /* line # 1455 */
      P_lgt_free(&Rv16);
    }
    Ra.sl[6]=1458; /* line # 1458 */
    Rv19=((V *)Rv10)[0];
    Ra.sl[6]=1459; /* line # 1459 */
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1460; /* line # 1460 */
      Rv19=Rv9;
    }
    else {
      Ra.sl[6]=1463; /* line # 1463 */
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      Ra.sl[6]=1464; /* line # 1464 */
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1467; /* line # 1467 */
        while (Rv18>0&&Rv19!=NULL){
          Ra.sl[6]=1469; /* line # 1469 */
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        Ra.sl[6]=1471; /* line # 1471 */
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1474; /* line # 1474 */
    if (Rv19!=NULL) {
      Ra.sl[6]=1475; /* line # 1475 */
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000007(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+976;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1485; /* line # 1485 */
  Rv0=F_ty;
  Ra.sl[10]=1487; /* line # 1487 */
  Rv1=0;
  Ra.sl[10]=1488; /* line # 1488 */
  Ra.v[0]=NULL;
  Ra.sl[10]=1489; /* line # 1489 */
  Ra.v[1]=NULL;
  Ra.sl[10]=1490; /* line # 1490 */
  Rv2=NULL;
  Ra.sl[10]=1491; /* line # 1491 */
  Rv3=NULL;
  Ra.sl[10]=1492; /* line # 1492 */
  Rv4=((SL *)Rv0)[11];
  Ra.sl[10]=1493; /* line # 1493 */
  Rv5=0;
  Ra.sl[10]=1495; /* line # 1495 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1497; /* line # 1497 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1498; /* line # 1498 */
    Rv7=((V *)Rv0)[7];
    Ra.sl[10]=1499; /* line # 1499 */
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1500; /* line # 1500 */
      Rv8=Rv6;
      Ra.sl[10]=1502; /* line # 1502 */
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[5],0);
      Ra.sl[10]=1503; /* line # 1503 */
      ((SL *)Rv9)[4]=((SL *)Rv8)[14];
      Ra.sl[10]=1504; /* line # 1504 */
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1505; /* line # 1505 */
        ((V *)Rv3)[0]=Rv9;
      }
      Ra.sl[10]=1506; /* line # 1506 */
      Rv3=Rv9;
      Ra.sl[10]=1507; /* line # 1507 */
      Rv10=((V *)Rv9)[7];
      Ra.sl[10]=1508; /* line # 1508 */
      P_val_new(&Rv10,((V *)Rv8)[5]);
      Ra.sl[10]=1509; /* line # 1509 */
      ((V *)Rv10)[4]=((V *)Rv8)[5];
      Ra.sl[10]=1510; /* line # 1510 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[5])[11];
      Ra.sl[10]=1511; /* line # 1511 */
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else {
        Ra.sl[10]=1512; /* line # 1512 */
        ((V *)Ra.v[1])[0]=Rv10;
      }
      Ra.sl[10]=1513; /* line # 1513 */
      Ra.v[1]=Rv10;
      Ra.sl[10]=1515; /* line # 1515 */
      ((V *)Rv8)[9]=Rv9;
      Ra.sl[10]=1516; /* line # 1516 */
      ((UB *)Rv8)[60]=1;
      Ra.sl[10]=1517; /* line # 1517 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[10]=1518; /* line # 1518 */
      Rv6=((V *)Rv8)[3];
      Ra.sl[10]=1519; /* line # 1519 */
      if (((V *)Rv8)[5]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[5])[11];
      Ra.sl[10]=1520; /* line # 1520 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1525; /* line # 1525 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Ra.sl[10]=1527; /* line # 1527 */
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    Ra.sl[10]=1528; /* line # 1528 */
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1530; /* line # 1530 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      Ra.sl[10]=1531; /* line # 1531 */
      P_lgt_free(&Rv7);
    }
    else {
      Ra.sl[10]=1532; /* line # 1532 */
      P_src_error(Rd.s+993,147,4);
    }
  }
  Ra.sl[10]=1535; /* line # 1535 */
  if (F_szw>Rv4) Rv4=F_szw;
  Ra.sl[10]=1537; /* line # 1537 */
  if (((UB *)Rv0)[91]) {
    Ra.sl[10]=1538; /* line # 1538 */
    switch (((UB *)Rv0)[93]) {
      case 10:
      case 23:Ra.sl[10]=1540; /* line # 1540 */
      PAS_EXPSION_PRC_00000007(F_ty, &Rv1);
      break;
      case 8:
      case 9:Ra.sl[10]=1543; /* line # 1543 */
      PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
      break;
      default:Ra.sl[10]=1546; /* line # 1546 */
      P_src_error(Rd.s+993,131,3);
      break;
    }
  }
  Ra.sl[10]=1550; /* line # 1550 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1553; /* line # 1553 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1554; /* line # 1554 */
    while (Rv6!=NULL){
      Ra.sl[10]=1556; /* line # 1556 */
      ((UB *)Rv6)[60]=0;
      Ra.sl[10]=1557; /* line # 1557 */
      ((V *)Rv6)[9]=NULL;
      Ra.sl[10]=1558; /* line # 1558 */
      Rv6=((V *)Rv6)[3];
    }
  }
  Ra.sl[10]=1561; /* line # 1561 */
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1564; /* line # 1564 */
  if (Rv4>Rv1) {
    Ra.sl[10]=1566; /* line # 1566 */
    Rv10=NULL;
    Ra.sl[10]=1567; /* line # 1567 */
    P_val_new(&Rv10,NULL);
    Ra.sl[10]=1568; /* line # 1568 */
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1569; /* line # 1569 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.sl[10]=1570; /* line # 1570 */
    Ra.v[1]=Rv10;
    Ra.sl[10]=1571; /* line # 1571 */
    Rv11=Rv10;
    Ra.sl[10]=1573; /* line # 1573 */
    ((UB *)Rv11)[48]=28;
    Ra.sl[10]=1574; /* line # 1574 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    Ra.sl[10]=1575; /* line # 1575 */
    ((SL *)Rv11)[13]=0;
    Ra.sl[10]=1576; /* line # 1576 */
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1599; /* line # 1599 */
  Rv10=NULL;
  Ra.sl[10]=1600; /* line # 1600 */
  P_val_new(&Rv10, F_ty);
  Ra.sl[10]=1601; /* line # 1601 */
  Rv12=Rv10;
  Ra.sl[10]=1603; /* line # 1603 */
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1604; /* line # 1604 */
  ((SL *)Rv12)[6]=Rv4;
  Ra.sl[10]=1605; /* line # 1605 */
  ((V *)Rv12)[7]=Ra.v[0];
  Ra.sl[10]=1606; /* line # 1606 */
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1613; /* line # 1613 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+997;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1650; /* line # 1650 */
  Rv0=((V *)F_ip)[5];
  Ra.sl[6]=1652; /* line # 1652 */
  if (!((UB *)Rv0)[90]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Ra.sl[6]=1654; /* line # 1654 */
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[4];
  Ra.sl[6]=1656; /* line # 1656 */
  ((UW *)Rv1)[42]=((UW *)Rv1)[42]|16;
  Ra.sl[6]=1657; /* line # 1657 */
  if ((((UB *)Rv1)[86]==7||((UB *)Rv1)[86]==1)&&((SL *)Rv1)[12]>1) {
    Ra.sl[6]=1661; /* line # 1661 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else {
      Ra.sl[6]=1662; /* line # 1662 */
      Rv4=((V *)Rv2)[4];
    }
    Ra.sl[6]=1663; /* line # 1663 */
    Rv5=NULL;
    Ra.sl[6]=1664; /* line # 1664 */
    Rv6=NULL;
    Ra.sl[6]=1665; /* line # 1665 */
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1666; /* line # 1666 */
    Rv8=Rv4;
    Ra.sl[6]=1668; /* line # 1668 */
    while (Rv7!=NULL){
      Ra.sl[6]=1671; /* line # 1671 */
      P_lgt_new(&Rv9,((V *)Rv4)[5],13,NULL);
      Ra.sl[6]=1672; /* line # 1672 */
      Rv10=Rv9;
      Rv11=Rv8;
      Ra.sl[6]=1674; /* line # 1674 */
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      Ra.sl[6]=1675; /* line # 1675 */
      ((SL *)Rv10)[4]=((SL *)Rv11)[14];
      Ra.sl[6]=1676; /* line # 1676 */
      ((V *)Rv11)[9]=Rv9;
      Ra.sl[6]=1677; /* line # 1677 */
      ((UB *)Rv11)[60]=1;
      Ra.sl[6]=1680; /* line # 1680 */
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1682; /* line # 1682 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[6]=1683; /* line # 1683 */
      Rv8=((V *)Rv8)[3];
      Ra.sl[6]=1684; /* line # 1684 */
      Rv12=P_lgt_new_code(3, Rv9);
      Ra.sl[6]=1685; /* line # 1685 */
      if (Rv5==NULL) Rv5=Rv12;
      else {
        Ra.sl[6]=1686; /* line # 1686 */
        ((V *)Rv6)[0]=Rv12;
      }
      Ra.sl[6]=1687; /* line # 1687 */
      Rv6=Rv12;
    }
    Ra.sl[6]=1690; /* line # 1690 */
    if (((UB *)Rv2)[91]) {
      Ra.sl[6]=1692; /* line # 1692 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      Ra.sl[6]=1693; /* line # 1693 */
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      Ra.sl[6]=1694; /* line # 1694 */
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1697; /* line # 1697 */
    if (Rv5!=NULL) {
      Ra.sl[6]=1698; /* line # 1698 */
      switch (((UB *)Rv3)[104]) {
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:Ra.sl[6]=1701; /* line # 1701 */
        if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
        else {
          Ra.sl[6]=1702; /* line # 1702 */
          ((V *)((V *)Rv3)[17])[0]=Rv5;
        }
        Ra.sl[6]=1703; /* line # 1703 */
        ((V *)Rv3)[17]=Rv6;
        break;
        default:break;
      }
    }
    Ra.sl[6]=1707; /* line # 1707 */
    while (Rv4!=NULL){
      Ra.sl[6]=1708; /* line # 1708 */
      Rv13=Rv4;
      Ra.sl[6]=1710; /* line # 1710 */
      ((V *)Rv13)[9]=NULL;
      Ra.sl[6]=1711; /* line # 1711 */
      ((UB *)Rv13)[60]=0;
      Ra.sl[6]=1712; /* line # 1712 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1717; /* line # 1717 */
    if (((V *)Rv1)[7]==NULL) {
      Ra.sl[6]=1719; /* line # 1719 */
      ((UW *)Rv1)[42]=((UW *)Rv1)[42]|8;
      Ra.sl[6]=1720; /* line # 1720 */
      ((V *)Rv1)[7]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1011;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1739; /* line # 1739 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1740; /* line # 1740 */
    Rv0=F_p;
    Rv1=((V *)Rv0)[3]+8;
    Ra.sl[6]=1743; /* line # 1743 */
    if (((UB *)Rv1)[8]!=0) F_puna=P_exp_val_una(F_puna, V_oparg_cvtab.v[((UB *)Rv1)
    [8]]);
    Ra.sl[6]=1744; /* line # 1744 */
    Rv2=F_puna;
    Ra.sl[6]=1745; /* line # 1745 */
    if (((UB *)Rv2)[40]==14) {
      Ra.sl[6]=1746; /* line # 1746 */
      Rv3=((V *)Rv2)[7];
      Ra.sl[6]=1748; /* line # 1748 */
      ((UW *)Rv2)[10]=1;
      Ra.sl[6]=1749; /* line # 1749 */
      switch (((UB *)Rv0)[9]) {
        case 6:Ra.sl[6]=1750; /* line # 1750 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]<=0);
        break;
        case 43:Ra.sl[6]=1752; /* line # 1752 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]+1;
        break;
        case 44:Ra.sl[6]=1754; /* line # 1754 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]-1;
        break;
        case 45:Ra.sl[6]=1756; /* line # 1756 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]&1);
        break;
        case 10:Ra.sl[6]=1758; /* line # 1758 */
        if (((UB *)Rv3)[48]==11||((UB *)Rv3)[48]==17) {
          Ra.sl[6]=1759; /* line # 1759 */
          if (((SL *)Rv3)[13]>=0) {
            Ra.sl[6]=1760; /* line # 1760 */
            ((SL *)Rv3)[13]=-1-((SL *)Rv3)[13];
          }
          else {
            Ra.sl[6]=1761; /* line # 1761 */
            ((SL *)Rv3)[13]= -(1+((SL *)Rv3)[13]);
          }
        }
        break;
        case 46:Ra.sl[6]=1763; /* line # 1763 */
        ((SL *)Rv3)[13]= -((SL *)Rv3)[13];
        break;
        case 61:
        case 77:Ra.sl[6]=1765; /* line # 1765 */
        ((G *)Rv3)[7]=-((G *)Rv3)[7];
        break;
        case 47:Ra.sl[6]=1767; /* line # 1767 */
        ((SL *)Rv3)[13]=abs(((SL *)Rv3)[13]);
        break;
        case 62:
        case 78:Ra.sl[6]=1769; /* line # 1769 */
        ((G *)Rv3)[7]=fabs(((G *)Rv3)[7]);
        break;
        case 48:Ra.sl[6]=1771; /* line # 1771 */
        ((SL *)Rv3)[13]=PAS__I_SQR(((SL *)Rv3)[13]);
        break;
        case 63:
        case 79:Ra.sl[6]=1773; /* line # 1773 */
        ((G *)Rv3)[7]=PAS__G_SQR(((G *)Rv3)[7]);
        break;
        case 64:
        case 80:Ra.sl[6]=1776; /* line # 1776 */
        ((G *)Rv3)[7]=(double)((SL *)Rv3)[13];
        break;
        case 65:
        case 81:Ra.sl[6]=1778; /* line # 1778 */
        ((SL *)Rv3)[13]=PAS__G_ROUND(((G *)Rv3)[7]);
        break;
        case 66:
        case 82:Ra.sl[6]=1780; /* line # 1780 */
        ((SL *)Rv3)[13]=(int)(((G *)Rv3)[7]);
        break;
        case 92:
        case 110:Ra.sl[6]=1783; /* line # 1783 */
        if (((G *)Rv3)[7]<0.000000000000000E-001) P_src_error(Rd.s+1026,801,2);
        else {
          Ra.sl[6]=1784; /* line # 1784 */
          ((G *)Rv3)[7]=sqrt(((G *)Rv3)[7]);
        }
        break;
        case 93:
        case 111:Ra.sl[6]=1787; /* line # 1787 */
        ((G *)Rv3)[7]=sin(((G *)Rv3)[7]);
        break;
        case 94:
        case 112:Ra.sl[6]=1789; /* line # 1789 */
        ((G *)Rv3)[7]=cos(((G *)Rv3)[7]);
        break;
        case 95:
        case 113:Ra.sl[6]=1791; /* line # 1791 */
        ((G *)Rv3)[7]=tan(((G *)Rv3)[7]);
        break;
        case 96:
        case 114:Ra.sl[6]=1795; /* line # 1795 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,802,2);
        else {
          Ra.sl[6]=1796; /* line # 1796 */
          ((G *)Rv3)[7]=asin(((G *)Rv3)[7]);
        }
        break;
        case 97:
        case 115:Ra.sl[6]=1799; /* line # 1799 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,803,2);
        else {
          Ra.sl[6]=1800; /* line # 1800 */
          ((G *)Rv3)[7]=acos(((G *)Rv3)[7]);
        }
        break;
        case 98:
        case 116:Ra.sl[6]=1802; /* line # 1802 */
        ((G *)Rv3)[7]=atan(((G *)Rv3)[7]);
        break;
        case 102:
        case 120:Ra.sl[6]=1805; /* line # 1805 */
        ((G *)Rv3)[7]=PAS__SHG(((G *)Rv3)[7]);
        break;
        case 103:
        case 121:Ra.sl[6]=1807; /* line # 1807 */
        ((G *)Rv3)[7]=PAS__CHG(((G *)Rv3)[7]);
        break;
        case 104:
        case 122:Ra.sl[6]=1809; /* line # 1809 */
        ((G *)Rv3)[7]=PAS__THG(((G *)Rv3)[7]);
        break;
        case 105:
        case 123:Ra.sl[6]=1812; /* line # 1812 */
        ((G *)Rv3)[7]=PAS__ASHG(((G *)Rv3)[7]);
        break;
        case 106:
        case 124:Ra.sl[6]=1815; /* line # 1815 */
        if (((G *)Rv3)[7]<1.000000000000000E+000) P_src_error(Rd.s+1026,805,2);
        else {
          Ra.sl[6]=1816; /* line # 1816 */
          ((G *)Rv3)[7]=PAS__ACHG(((G *)Rv3)[7]);
        }
        break;
        case 107:
        case 125:Ra.sl[6]=1819; /* line # 1819 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,806,2);
        else {
          Ra.sl[6]=1820; /* line # 1820 */
          ((G *)Rv3)[7]=PAS__ATHG(((G *)Rv3)[7]);
        }
        break;
        case 100:
        case 118:Ra.sl[6]=1823; /* line # 1823 */
        ((G *)Rv3)[7]=exp(((G *)Rv3)[7]);
        break;
        case 101:
        case 119:Ra.sl[6]=1826; /* line # 1826 */
        if (((G *)Rv3)[7]<=0.000000000000000E-001) P_src_error(Rd.s+1026,804,2);
        else {
          Ra.sl[6]=1827; /* line # 1827 */
          ((G *)Rv3)[7]=log(((G *)Rv3)[7]);
        }
        break;
        default:break;
      }
      Ra.sl[6]=1831; /* line # 1831 */
      ((V *)Rv2)[4]=NULL;
      Ra.sl[6]=1833; /* line # 1833 */
      if (64&((UW *)Rv1)[5]) ((V *)Rv2)[3]=((V *)Rv1)[0];
      else {
        Ra.sl[6]=1834; /* line # 1834 */
        ((V *)Rv2)[3]=((V *)Rv0)[2];
      }
      Ra.sl[6]=1835; /* line # 1835 */
      ((V *)Rv3)[4]=((V *)Rv2)[3];
      Ra.sl[6]=1836; /* line # 1836 */
      ((UB *)Rv3)[48]=((UB *)((V *)Rv2)[3])[93];
    }
    else {
      Ra.sl[6]=1840; /* line # 1840 */
      if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+1026,851,2);
      Ra.sl[6]=1841; /* line # 1841 */
      if (((UB *)Rv0)[9]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])
      [11]) {
        Ra.sl[6]=1844; /* line # 1844 */
        P_lgt_new(&Rv4,((V *)Rv0)[2],6, F_puna);
        Ra.sl[6]=1845; /* line # 1845 */
        Rv5=Rv4;
        Ra.sl[6]=1847; /* line # 1847 */
        if (64&((UW *)Rv1)[5]) ((V *)Rv5)[3]=((V *)Rv1)[0];
        Ra.sl[6]=1848; /* line # 1848 */
        ((V *)Rv5)[0]=((V *)F_puna)[0];
        Ra.sl[6]=1849; /* line # 1849 */
        ((UB *)Rv5)[41]=((UB *)Rv0)[9];
        Ra.sl[6]=1850; /* line # 1850 */
        ((UW *)Rv5)[10]=((UW *)F_puna)[10]&~2;
        Ra.sl[6]=1852; /* line # 1852 */
        ((V *)Rv2)[0]=NULL;
        Ra.sl[6]=1853; /* line # 1853 */
        F_puna=Rv4;
      }
      else {
        Ra.sl[6]=1855; /* line # 1855 */
        ((V *)F_puna)[3]=((V *)Rv0)[2];
      }
    }
  }
  Ra.sl[6]=1858; /* line # 1858 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  G Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  register V Rv12;
  UL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1030;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1880; /* line # 1880 */
  Rv0=((V *)F_ob1)[0];
  Ra.sl[6]=1881; /* line # 1881 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1882; /* line # 1882 */
    Rv1=F_p;
    Ra.sl[6]=1884; /* line # 1884 */
    Rv2=((V *)Rv1)[2];
    Ra.sl[6]=1886; /* line # 1886 */
    Rv3=((V *)Rv1)[3]+8;
    Ra.sl[6]=1887; /* line # 1887 */
    if (64&((UW *)Rv3)[5]) Rv2=((V *)Rv3)[0];
    else {
      Ra.sl[6]=1889; /* line # 1889 */
      if (((UB *)Rv3)[8]!=0) F_ob1=P_exp_val_una(F_ob1, V_oparg_cvtab.v[((UB *)Rv3)
      [8]]);
    }
    Ra.sl[6]=1890; /* line # 1890 */
    Rv4=((V *)Rv1)[3]+24;
    Ra.sl[6]=1891; /* line # 1891 */
    if (64&((UW *)Rv4)[5]) Rv2=((V *)Rv4)[0];
    else {
      Ra.sl[6]=1893; /* line # 1893 */
      if (((UB *)Rv4)[8]!=0) Rv0=P_exp_val_una(Rv0, V_oparg_cvtab.v[((UB *)Rv4)[
8]]);
    }
    Ra.sl[6]=1894; /* line # 1894 */
    ((V *)F_ob1)[0]=Rv0;
    Ra.sl[6]=1895; /* line # 1895 */
    if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
      Ra.sl[6]=1898; /* line # 1898 */
      Rv5=((V *)F_ob1)[7];
      Rv6=Rv0;
      Ra.sl[6]=1899; /* line # 1899 */
      switch (((UB *)Rv1)[9]) {
        case 89:Ra.sl[6]=1900; /* line # 1900 */
        ((SL *)Rv5)[13]=PAS__IIPOWER(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 90:
        case 108:Ra.sl[6]=1902; /* line # 1902 */
        ((G *)Rv5)[7]=pow  (((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        case 91:
        case 109:Ra.sl[6]=1904; /* line # 1904 */
        ((G *)Rv5)[7]=PAS__IGPOWER(((G *)Rv5)[7],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 49:Ra.sl[6]=1906; /* line # 1906 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]+((SL *)((V *)Rv6)[7])[13];
        break;
        case 50:Ra.sl[6]=1907; /* line # 1907 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        break;
        case 51:Ra.sl[6]=1908; /* line # 1908 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]*((SL *)((V *)Rv6)[7])[13];
        break;
        case 52:Ra.sl[6]=1909; /* line # 1909 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]/((SL *)((V *)Rv6)[7])[13];
        break;
        case 53:Ra.sl[6]=1910; /* line # 1910 */
        ((SL *)Rv5)[13]=PAS__I_MOD(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 54:Ra.sl[6]=1911; /* line # 1911 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]%((SL *)((V *)Rv6)[7])[13];
        break;
        case 67:
        case 85:Ra.sl[6]=1914; /* line # 1914 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]+((G *)((V *)Rv6)[7])[7];
        break;
        case 68:
        case 86:Ra.sl[6]=1916; /* line # 1916 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        break;
        case 69:
        case 87:Ra.sl[6]=1918; /* line # 1918 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]*((G *)((V *)Rv6)[7])[7];
        break;
        case 70:
        case 88:Ra.sl[6]=1920; /* line # 1920 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]/((G *)((V *)Rv6)[7])[7];
        break;
        case 7:Ra.sl[6]=1922; /* line # 1922 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0&&((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 8:Ra.sl[6]=1923; /* line # 1923 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0||((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 9:Ra.sl[6]=1924; /* line # 1924 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0!=((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 11:Ra.sl[6]=1927; /* line # 1927 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13];
        break;
        case 12:Ra.sl[6]=1928; /* line # 1928 */
        ((UL *)Rv5)[13]=(((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13])&~(((UL *)Rv5)
        [13]&((UL *)((V *)Rv6)[7])[13]);
        break;
        case 13:Ra.sl[6]=1930; /* line # 1930 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&~((UL *)((V *)Rv6)[7])[13];
        break;
        case 14:Ra.sl[6]=1931; /* line # 1931 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13];
        break;
        case 15:Ra.sl[6]=1932; /* line # 1932 */
        ((SL *)Rv5)[13]=(SL)((((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 16:break;
        case 17:break;
        case 18:break;
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:Ra.sl[6]=1941; /* line # 1941 */
        switch (((UB *)Rv1)[9]) {
          case 19:
          case 20:Ra.sl[6]=1943; /* line # 1943 */
          Rv7=(SL)PAS__SET_LE(((UL *)Rv5)[13],((UL *)((V *)Rv6)[7])[13]);
          break;
          case 21:
          case 22:Ra.sl[6]=1945; /* line # 1945 */
          Rv7=(SL)PAS__SET_LE(((UL *)((V *)Rv6)[7])[13],((UL *)Rv5)[13]);
          break;
          case 23:Ra.sl[6]=1946; /* line # 1946 */
          Rv7=(SL)(((UL *)Rv5)[13]!=((UL *)((V *)Rv6)[7])[13]);
          break;
          case 24:Ra.sl[6]=1947; /* line # 1947 */
          Rv7=(SL)(((UL *)Rv5)[13]==((UL *)((V *)Rv6)[7])[13]);
          break;
          default:break;
        }
        Ra.sl[6]=1950; /* line # 1950 */
        ((UB *)Rv5)[48]=1;
        Ra.sl[6]=1951; /* line # 1951 */
        ((SL *)Rv5)[6]=0;
        Ra.sl[6]=1952; /* line # 1952 */
        ((SL *)Rv5)[13]=Rv7;
        break;
        case 25:Ra.sl[6]=1955; /* line # 1955 */
        Rv7=(SL)((1<<((SL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:Ra.sl[6]=1960; /* line # 1960 */
        Rv7=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        Ra.sl[6]=1961; /* line # 1961 */
        switch (((UB *)Rv1)[9]) {
          case 28:
          case 32:Ra.sl[6]=1962; /* line # 1962 */
          ((SL *)Rv5)[13]=(SL)(Rv7<0);
          break;
          case 29:
          case 33:Ra.sl[6]=1963; /* line # 1963 */
          ((SL *)Rv5)[13]=(SL)(Rv7<=0);
          break;
          case 30:
          case 34:Ra.sl[6]=1964; /* line # 1964 */
          ((SL *)Rv5)[13]=(SL)(Rv7>=0);
          break;
          case 31:
          case 35:Ra.sl[6]=1965; /* line # 1965 */
          ((SL *)Rv5)[13]=(SL)(Rv7>0);
          break;
          case 27:Ra.sl[6]=1966; /* line # 1966 */
          ((SL *)Rv5)[13]=(SL)(Rv7!=0);
          break;
          case 26:Ra.sl[6]=1967; /* line # 1967 */
          ((SL *)Rv5)[13]=(SL)(Rv7==0);
          break;
        }
        break;
        case 55:
        case 56:
        case 57:
        case 58:
        case 59:
        case 60:
        case 71:
        case 72:
        case 73:
        case 74:
        case 75:
        case 76:Ra.sl[6]=1973; /* line # 1973 */
        Rv8=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        Ra.sl[6]=1974; /* line # 1974 */
        switch (((UB *)Rv1)[9]) {
          case 55:
          case 71:Ra.sl[6]=1975; /* line # 1975 */
          ((SL *)Rv5)[13]=(SL)(Rv8<0.000000000000000E-001);
          break;
          case 56:
          case 72:Ra.sl[6]=1976; /* line # 1976 */
          ((SL *)Rv5)[13]=(SL)(Rv8<=0.000000000000000E-001);
          break;
          case 57:
          case 73:Ra.sl[6]=1977; /* line # 1977 */
          ((SL *)Rv5)[13]=(SL)(Rv8>=0.000000000000000E-001);
          break;
          case 58:
          case 74:Ra.sl[6]=1978; /* line # 1978 */
          ((SL *)Rv5)[13]=(SL)(Rv8>0.000000000000000E-001);
          break;
          case 60:
          case 76:Ra.sl[6]=1979; /* line # 1979 */
          ((SL *)Rv5)[13]=(SL)(Rv8!=0.000000000000000E-001);
          break;
          case 59:
          case 75:Ra.sl[6]=1980; /* line # 1980 */
          ((SL *)Rv5)[13]=(SL)(Rv8==0.000000000000000E-001);
          break;
        }
        break;
        case 36:
        case 37:break;
        case 99:
        case 117:Ra.sl[6]=1990; /* line # 1990 */
        ((G *)Rv5)[7]=atan2(((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        default:break;
      }
      Ra.sl[6]=1994; /* line # 1994 */
      Rv9=F_ob1;
      Rv10=((V *)Rv9)[7];
      Ra.sl[6]=1996; /* line # 1996 */
      ((V *)Rv9)[4]=NULL;
      Ra.sl[6]=1998; /* line # 1998 */
      ((V *)Rv9)[3]=Rv2;
      Ra.sl[6]=1999; /* line # 1999 */
      ((V *)Rv10)[4]=((V *)Rv9)[3];
      Ra.sl[6]=2000; /* line # 2000 */
      ((UB *)Rv10)[48]=((UB *)((V *)Rv9)[3])[93];
      Ra.sl[6]=2002; /* line # 2002 */
      ((V *)F_ob1)[0]=NULL;
      Ra.sl[6]=2003; /* line # 2003 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=2007; /* line # 2007 */
      Rv11=1;
      Ra.sl[6]=2008; /* line # 2008 */
      switch (((UB *)Rv1)[9]) {
        case 25:Ra.sl[6]=2010; /* line # 2010 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2012; /* line # 2012 */
          Rv12=F_ob1;
          Ra.sl[6]=2014; /* line # 2014 */
          Rv13=((SL *)((V *)Rv12)[7])[13];
          Ra.sl[6]=2015; /* line # 2015 */
          ((V *)Rv12)[3]=((V *)Rv0)[3];
          Ra.sl[6]=2016; /* line # 2016 */
          P_val_free(((V *)Rv12)+7);
          Ra.sl[6]=2017; /* line # 2017 */
          P_val_new(((V *)Rv12)+7,((V *)Rv12)[3]);
          Ra.sl[6]=2018; /* line # 2018 */
          Rv14=((V *)Rv12)[7];
          Ra.sl[6]=2020; /* line # 2020 */
          ((SL *)Rv14)[6]=(Rv13+7)/8;
          Ra.sl[6]=2021; /* line # 2021 */
          ((UL *)Rv14)[13]=1<<Rv13;
          Ra.sl[6]=2024; /* line # 2024 */
          P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
          Ra.sl[6]=2025; /* line # 2025 */
          Rv15=Rv0;
          Ra.sl[6]=2027; /* line # 2027 */
          ((UW *)Rv15)[10]=1;
          Ra.sl[6]=2028; /* line # 2028 */
          ((UB *)Rv15)[41]=15;
          Ra.sl[6]=2030; /* line # 2030 */
          Rv11=0;
        }
        break;
        case 7:Ra.sl[6]=2034; /* line # 2034 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2035; /* line # 2035 */
          Rv16=F_ob1;
          Ra.sl[6]=2037; /* line # 2037 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2038; /* line # 2038 */
          Rv11=0;
          Ra.sl[6]=2039; /* line # 2039 */
          if (((SL *)((V *)Rv16)[7])[13]<=0) {
            Ra.sl[6]=2041; /* line # 2041 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2042; /* line # 2042 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2045; /* line # 2045 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2048; /* line # 2048 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2049; /* line # 2049 */
            Rv17=Rv0;
            Ra.sl[6]=2051; /* line # 2051 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2052; /* line # 2052 */
            Rv11=0;
            Ra.sl[6]=2053; /* line # 2053 */
            if (((SL *)((V *)Rv17)[7])[13]<=0) {
              Ra.sl[6]=2054; /* line # 2054 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2057; /* line # 2057 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2058; /* line # 2058 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 8:Ra.sl[6]=2063; /* line # 2063 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2064; /* line # 2064 */
          Rv18=F_ob1;
          Ra.sl[6]=2066; /* line # 2066 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2067; /* line # 2067 */
          Rv11=0;
          Ra.sl[6]=2068; /* line # 2068 */
          if (((SL *)((V *)Rv18)[7])[13]>0) {
            Ra.sl[6]=2070; /* line # 2070 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2071; /* line # 2071 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2074; /* line # 2074 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2077; /* line # 2077 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2078; /* line # 2078 */
            Rv19=Rv0;
            Ra.sl[6]=2080; /* line # 2080 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2081; /* line # 2081 */
            Rv11=0;
            Ra.sl[6]=2082; /* line # 2082 */
            if (((SL *)((V *)Rv19)[7])[13]>0) {
              Ra.sl[6]=2083; /* line # 2083 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2086; /* line # 2086 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2087; /* line # 2087 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 1:
        case 3:
        case 4:
        case 5:Ra.sl[6]=2093; /* line # 2093 */
        Rv20=F_ob1;
        Ra.sl[6]=2095; /* line # 2095 */
        ((UW *)Rv20)[10]=((UW *)Rv20)[10]|8;
        Ra.sl[6]=2096; /* line # 2096 */
        if (!(2&((UW *)Rv20)[10])) P_src_error(Rd.s+1045,852,2);
        Ra.sl[6]=2098; /* line # 2098 */
        Rv21=Rv0;
        Ra.sl[6]=2100; /* line # 2100 */
        if (!(1&((UW *)Rv21)[10])) {
          Ra.sl[6]=2101; /* line # 2101 */
          P_src_error(Rd.s+1045,851,1);
        }
        Ra.sl[6]=2102; /* line # 2102 */
        if ((((UB *)Rv1)[9]!=1&&((UB *)Rv21)[40]==8)&&((V *)Rv21)[3]!=NULL) {
          Ra.sl[6]=2105; /* line # 2105 */
          Rv22=((V *)Rv21)[6];
          Ra.sl[6]=2106; /* line # 2106 */
          if (((V *)Rv22)[8]!=NULL) {
            Ra.sl[6]=2107; /* line # 2107 */
            if (((UB *)((V *)Rv22)[8])[86]==7) {
              Ra.sl[6]=2109; /* line # 2109 */
              ((V *)F_ob1)[0]=((V *)((V *)Rv21)[1])[0];
              Ra.sl[6]=2110; /* line # 2110 */
              P_lgt_free(((V *)Rv21)+1);
              Ra.sl[6]=2111; /* line # 2111 */
              ((UW *)Rv21)[10]=((UW *)Rv21)[10]|128;
              Ra.sl[6]=2112; /* line # 2112 */
              ((V *)Rv21)[1]=F_ob1;
              Ra.sl[6]=2113; /* line # 2113 */
              Rv11=0;
            }
          }
        }
        break;
        default:Ra.sl[6]=2118; /* line # 2118 */
        if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) {
          Ra.sl[6]=2119; /* line # 2119 */
          P_src_error(Rd.s+1045,851,1);
        }
        break;
      }
      Ra.sl[6]=2121; /* line # 2121 */
      if (Rv11) {
        Ra.sl[6]=2123; /* line # 2123 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Ra.sl[6]=2124; /* line # 2124 */
        Rv23=Rv0;
        Ra.sl[6]=2126; /* line # 2126 */
        ((V *)Rv23)[3]=Rv2;
        Ra.sl[6]=2127; /* line # 2127 */
        ((UW *)Rv23)[10]=1;
        Ra.sl[6]=2128; /* line # 2128 */
        ((UB *)Rv23)[41]=((UB *)Rv1)[9];
      }
      Ra.sl[6]=2131; /* line # 2131 */
      F_ob1=Rv0;
    }
  }
  Ra.sl[6]=2134; /* line # 2134 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1049;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2149; /* line # 2149 */
  Rv0=F_lgt;
  Ra.sl[6]=2150; /* line # 2150 */
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Ra.sl[6]=2151; /* line # 2151 */
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=2153; /* line # 2153 */
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2154; /* line # 2154 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) {
      Ra.sl[6]=2157; /* line # 2157 */
      Rv0=((V *)Rv1)[1];
    }
    else {
      Ra.sl[6]=2158; /* line # 2158 */
      Rv0=NULL;
    }
  }
  Ra.sl[6]=2160; /* line # 2160 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2166; /* line # 2166 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1070;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2188; /* line # 2188 */
  Rv0=0;
  Ra.sl[6]=2189; /* line # 2189 */
  Rv1=NULL;
  Ra.sl[6]=2190; /* line # 2190 */
  if ((*F_lgt)!=NULL) {
    Ra.sl[6]=2191; /* line # 2191 */
    Rv2=(*F_lgt);
    Ra.sl[6]=2193; /* line # 2193 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Ra.sl[6]=2194; /* line # 2194 */
    Rv3=((V *)Rv2)[1];
    Ra.sl[6]=2195; /* line # 2195 */
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2198; /* line # 2198 */
  if (Rv1!=NULL) {
    Ra.sl[6]=2199; /* line # 2199 */
    Rv4=Rv1;
    Ra.sl[6]=2201; /* line # 2201 */
    Rv5=NULL;
    Ra.sl[6]=2202; /* line # 2202 */
    Rv6=NULL;
    Ra.sl[6]=2203; /* line # 2203 */
    Rv7=((V *)Rv4)[8];
    Ra.sl[6]=2204; /* line # 2204 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2205; /* line # 2205 */
      Rv8=((V *)Rv4)[11];
      Ra.sl[6]=2206; /* line # 2206 */
      if (!((UB *)Rv8)[92]) {
        Ra.sl[6]=2214; /* line # 2214 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        Ra.sl[6]=2215; /* line # 2215 */
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        Ra.sl[6]=2216; /* line # 2216 */
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        Ra.sl[6]=2217; /* line # 2217 */
        ((V *)(*F_lgt))[1]=Rv5;
        Ra.sl[6]=2218; /* line # 2218 */
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2221; /* line # 2221 */
    while (Rv7!=NULL){
      Ra.sl[6]=2223; /* line # 2223 */
      Rv9=NULL;
      Ra.sl[6]=2224; /* line # 2224 */
      Rv10=0;
      Ra.sl[6]=2225; /* line # 2225 */
      Rv11=0;
      Ra.sl[6]=2226; /* line # 2226 */
      Rv12=Rv3;
      Ra.sl[6]=2227; /* line # 2227 */
      Rv13=Rv7;
      Ra.sl[6]=2229; /* line # 2229 */
      if (Rv3!=NULL) {
        Ra.sl[6]=2231; /* line # 2231 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          Ra.sl[6]=2234; /* line # 2234 */
          if (((V *)Rv13)[5]!=NULL) {
            Ra.sl[6]=2236; /* line # 2236 */
            Rv14=((V *)Rv13)[5];
            Ra.sl[6]=2237; /* line # 2237 */
            switch (((UB *)Rv14)[93]) {
              case 10:Ra.sl[6]=2239; /* line # 2239 */
              if (P_comp_type(((V *)Rv13)[5],V_typ_std.v[10],0,0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1,0)) {
                Ra.sl[6]=2241; /* line # 2241 */
                if (((UB *)Rv3)[40]==14) {
                  Ra.sl[6]=2243; /* line # 2243 */
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  Ra.sl[6]=2244; /* line # 2244 */
                  P_val_free(((V *)Rv3)+7);
                  Ra.sl[6]=2245; /* line # 2245 */
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2246; /* line # 2246 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Ra.sl[6]=2247; /* line # 2247 */
                  Rv16=((V *)Rv3)[7];
                  Ra.sl[6]=2249; /* line # 2249 */
                  ((UB *)Rv16)[48]=29;
                  Ra.sl[6]=2250; /* line # 2250 */
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2251; /* line # 2251 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  Ra.sl[6]=2252; /* line # 2252 */
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2257; /* line # 2257 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Ra.sl[6]=2258; /* line # 2258 */
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  Ra.sl[6]=2259; /* line # 2259 */
                  ((V *)Rv3)[0]=Rv17;
                  Ra.sl[6]=2260; /* line # 2260 */
                  ((UW *)Rv3)[10]=5;
                  Ra.sl[6]=2261; /* line # 2261 */
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2262; /* line # 2262 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2268; /* line # 2268 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0,0)) {
                Ra.sl[6]=2271; /* line # 2271 */
                Rv10=1;
                Ra.sl[6]=2272; /* line # 2272 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2273; /* line # 2273 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[5],3, Rv3);
                Ra.sl[6]=2274; /* line # 2274 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2275; /* line # 2275 */
                  ((V *)Rv5)[0]=Rv3;
                }
                Ra.sl[6]=2276; /* line # 2276 */
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[14];
                Ra.sl[6]=2277; /* line # 2277 */
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2280; /* line # 2280 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0,0)) {
                  Ra.sl[6]=2281; /* line # 2281 */
                  Rv10=1;
                  Rv11=1;
                }
              }
              Ra.sl[6]=2282; /* line # 2282 */
              if (((UB *)Rv14)[93]==9) Rv9=((V *)Rv13)[5];
              break;
              default:break;
            }
            Ra.sl[6]=2297; /* line # 2297 */
            if (64&((UW *)Rv13)[44]&&Rv6==NULL) Rv6=((V *)Rv3)[3];
            Ra.sl[6]=2300; /* line # 2300 */
            switch (((UB *)Rv13)[86]) {
              case 8:Ra.sl[6]=2303; /* line # 2303 */
              if (!(4&((UW *)Rv3)[10])) {
                Ra.sl[6]=2305; /* line # 2305 */
                Rv18=Rv3;
                Ra.sl[6]=2306; /* line # 2306 */
                if (64&((UW *)Rv13)[42]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Ra.sl[6]=2307; /* line # 2307 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2308; /* line # 2308 */
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                Ra.sl[6]=2309; /* line # 2309 */
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[6]=2311; /* line # 2311 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2312; /* line # 2312 */
                  ((V *)Rv5)[0]=Rv3;
                }
              }
              break;
              case 11:Ra.sl[6]=2318; /* line # 2318 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              Ra.sl[6]=2319; /* line # 2319 */
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              Ra.sl[6]=2320; /* line # 2320 */
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              Ra.sl[6]=2321; /* line # 2321 */
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2323; /* line # 2323 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else {
                Ra.sl[6]=2324; /* line # 2324 */
                ((V *)Rv5)[0]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=2329; /* line # 2329 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2335; /* line # 2335 */
        P_lgt_new(&Rv3,((V *)Rv13)[5],14,NULL);
        Ra.sl[6]=2337; /* line # 2337 */
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else {
          Ra.sl[6]=2338; /* line # 2338 */
          ((V *)Rv5)[0]=Rv3;
        }
        Ra.sl[6]=2339; /* line # 2339 */
        Rv0=1;
      }
      Ra.sl[6]=2342; /* line # 2342 */
      if (Rv0) {
        Ra.sl[6]=2343; /* line # 2343 */
        if (8192&((UW *)Rv13)[42]) {
          Ra.sl[6]=2344; /* line # 2344 */
          Rv19=Rv3;
          Ra.sl[6]=2346; /* line # 2346 */
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2347; /* line # 2347 */
          ((V *)Rv19)[3]=((V *)Rv13)[5];
          Ra.sl[6]=2348; /* line # 2348 */
          ((V *)Rv19)[4]=NULL;
        }
        else {
          Ra.sl[6]=2351; /* line # 2351 */
          if (((V *)Rv13)[7]!=NULL) {
            Ra.sl[6]=2352; /* line # 2352 */
            Rv20=Rv3;
            Ra.sl[6]=2354; /* line # 2354 */
            ((UB *)Rv20)[40]=14;
            Ra.sl[6]=2355; /* line # 2355 */
            ((V *)Rv20)[3]=((V *)Rv13)[5];
            Ra.sl[6]=2356; /* line # 2356 */
            ((V *)Rv20)[7]=((V *)Rv13)[7];
            Ra.sl[6]=2357; /* line # 2357 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[5]);
            Ra.sl[6]=2358; /* line # 2358 */
            ((V *)Rv20)[4]=NULL;
          }
          else {
            Ra.sl[6]=2360; /* line # 2360 */
            P_src_error_s(Rd.s+1086,854,2,((V *)Rv13)[0],NULL);
          }
        }
      }
      Ra.sl[6]=2362; /* line # 2362 */
      Rv5=Rv3;
      Ra.sl[6]=2365; /* line # 2365 */
      if (Rv9!=NULL) {
        Ra.sl[6]=2366; /* line # 2366 */
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2367; /* line # 2367 */
          Rv21=((V *)Rv9)[15];
          Ra.sl[6]=2368; /* line # 2368 */
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Ra.sl[6]=2370; /* line # 2370 */
            Rv22=Rv12;
            Ra.sl[6]=2371; /* line # 2371 */
            if (((UB *)Rv22)[40]==8) ((UW *)Rv22)[10]=((UW *)Rv22)[10]|128;
            Ra.sl[6]=2373; /* line # 2373 */
            Rv23=((V *)Rv9)[15];
            Ra.sl[6]=2374; /* line # 2374 */
            Rv24=NULL;
            Rv25=NULL;
            Ra.sl[6]=2376; /* line # 2376 */
            if (Rv10) {
              while (1){
                Ra.sl[6]=2380; /* line # 2380 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[93]!=22)  break;
              }
              Ra.sl[6]=2383; /* line # 2383 */
              if (Rv11) {
                Ra.sl[6]=2385; /* line # 2385 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Ra.sl[6]=2386; /* line # 2386 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2387; /* line # 2387 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2389; /* line # 2389 */
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[6]=2390; /* line # 2390 */
                  Rv7=((V *)Rv7)[3];
                }
                else {
                  Ra.sl[6]=2392; /* line # 2392 */
                  Rv25=Rv24;
                }
              }
              else {
                Ra.sl[6]=2396; /* line # 2396 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2398; /* line # 2398 */
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Ra.sl[6]=2399; /* line # 2399 */
                  Rv25=Rv24;
                  Ra.sl[6]=2400; /* line # 2400 */
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2402; /* line # 2402 */
                if (((UB *)Rv12)[40]==14) {
                  Ra.sl[6]=2403; /* line # 2403 */
                  Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)Rv12)[7])[6]);
                }
                else {
                  Ra.sl[6]=2406; /* line # 2406 */
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[5],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2408; /* line # 2408 */
                  if (!(64&((UW *)Rv7)[42])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[14];
                  Ra.sl[6]=2410; /* line # 2410 */
                  if (((V *)Rv17)[3]!=Rv23) {
                    Ra.sl[6]=2412; /* line # 2412 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2413; /* line # 2413 */
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                Ra.sl[6]=2416; /* line # 2416 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2417; /* line # 2417 */
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[6]=2418; /* line # 2418 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Ra.sl[6]=2419; /* line # 2419 */
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[6]=2424; /* line # 2424 */
              Rv26=((V *)Rv3)[3];
              Ra.sl[6]=2425; /* line # 2425 */
              if (Rv26!=NULL) {
                Ra.sl[6]=2426; /* line # 2426 */
                while (Rv9!=NULL&&Rv26!=NULL){
                  Ra.sl[6]=2427; /* line # 2427 */
                  if (((UB *)Rv9)[93]==9&&(((UB *)Rv26)[93]==9||((UB *)Rv26)[93]
                  ==8)) {
                    Ra.sl[6]=2431; /* line # 2431 */
                    Rv27=((V *)Rv26)[15];
                    Ra.sl[6]=2432; /* line # 2432 */
                    Rv23=((V *)Rv9)[15];
                    while (1){
                      Ra.sl[6]=2435; /* line # 2435 */
                      if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                      if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[93]!=22)  break;
                    }
                    Ra.sl[6]=2438; /* line # 2438 */
                    if (((UB *)Rv27)[93]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                    else {
                      Ra.sl[6]=2439; /* line # 2439 */
                      Rv28=Rv12;
                    }
                    Ra.sl[6]=2443; /* line # 2443 */
                    if (((UB *)((V *)Rv21)[13])[40]!=14) {
                      Ra.sl[6]=2445; /* line # 2445 */
                      if (((UB *)Rv27)[93]==22) {
                        Ra.sl[6]=2447; /* line # 2447 */
                        Rv17=P_lgt_type_eval(((V *)Rv27)[13],Rv28,NULL,0);
                        Ra.sl[6]=2448; /* line # 2448 */
                        if (((SL *)Rv27)[11]!=((SL *)Rv23)[11]) {
                          Ra.sl[6]=2450; /* line # 2450 */
                          Rv17=P_lgt_new_code(0, Rv17);
                          Ra.sl[6]=2451; /* line # 2451 */
                          ((V *)Rv17)[3]=Rv23;
                        }
                      }
                      else {
                        Ra.sl[6]=2454; /* line # 2454 */
                        Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[29]);
                      }
                      Ra.sl[6]=2455; /* line # 2455 */
                      if (Rv25==NULL) Rv24=Rv17;
                      else {
                        Ra.sl[6]=2456; /* line # 2456 */
                        ((V *)Rv25)[0]=Rv17;
                      }
                      Ra.sl[6]=2457; /* line # 2457 */
                      Rv25=Rv17;
                      Ra.sl[6]=2458; /* line # 2458 */
                      Rv7=((V *)Rv7)[3];
                    }
                    Ra.sl[6]=2461; /* line # 2461 */
                    if (((UB *)Rv27)[93]==22) {
                      Ra.sl[6]=2463; /* line # 2463 */
                      Rv17=P_lgt_type_eval(((V *)Rv27)[14],Rv28,NULL,0);
                      Ra.sl[6]=2464; /* line # 2464 */
                      if (Rv27!=Rv23) {
                        Ra.sl[6]=2466; /* line # 2466 */
                        Rv17=P_lgt_new_code(0, Rv17);
                        Ra.sl[6]=2467; /* line # 2467 */
                        ((V *)Rv17)[3]=Rv23;
                      }
                    }
                    else {
                      Ra.sl[6]=2470; /* line # 2470 */
                      Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[30]);
                    }
                    Ra.sl[6]=2471; /* line # 2471 */
                    if (Rv25==NULL) Rv24=Rv17;
                    else {
                      Ra.sl[6]=2472; /* line # 2472 */
                      ((V *)Rv25)[0]=Rv17;
                    }
                    Ra.sl[6]=2473; /* line # 2473 */
                    Rv25=Rv17;
                    Ra.sl[6]=2474; /* line # 2474 */
                    Rv7=((V *)Rv7)[3];
                    Ra.sl[6]=2475; /* line # 2475 */
                    Rv26=((V *)Rv26)[14];
                    Ra.sl[6]=2476; /* line # 2476 */
                    Rv9=((V *)Rv9)[14];
                  }
                  else {
                    Ra.sl[6]=2477; /* line # 2477 */
                    Rv9=NULL;
                  }
                }
              }
              Ra.sl[6]=2479; /* line # 2479 */
              Rv29=Rv3;
              Ra.sl[6]=2480; /* line # 2480 */
              if (((SL *)((V *)Rv29)[3])[10]>0) {
                Ra.sl[6]=2481; /* line # 2481 */
                ((SL *)Rv29)[4]=((SL *)Rv29)[4]+((SL *)((V *)Rv29)[3])[10];
              }
            }
            Ra.sl[6]=2485; /* line # 2485 */
            if (Rv24!=NULL) {
              Ra.sl[6]=2487; /* line # 2487 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              Ra.sl[6]=2488; /* line # 2488 */
              ((V *)Rv3)[0]=Rv24;
              Ra.sl[6]=2489; /* line # 2489 */
              Rv3=Rv25;
            }
            Ra.sl[6]=2491; /* line # 2491 */
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2494; /* line # 2494 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Ra.sl[6]=2495; /* line # 2495 */
      Rv7=((V *)Rv7)[3];
    }
    Ra.sl[6]=2498; /* line # 2498 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2499; /* line # 2499 */
      Rv30=(*F_lgt);
      Ra.sl[6]=2501; /* line # 2501 */
      if (Rv6!=NULL) {
        Ra.sl[6]=2503; /* line # 2503 */
        ((V *)Rv30)[3]=Rv6;
        Ra.sl[6]=2504; /* line # 2504 */
        if (!((UB *)Rv6)[92]&&((V *)Rv30)[1]!=NULL) {
          Ra.sl[6]=2505; /* line # 2505 */
          ((V *)((V *)Rv30)[1])[3]=Rv6;
        }
      }
      Ra.sl[6]=2509; /* line # 2509 */
      if (!((UB *)((V *)Rv4)[11])[92]) {
        Ra.sl[6]=2510; /* line # 2510 */
        P_tmpstk_allocate(((V *)Rv30)[1],((V *)((V *)Rv30)[1])[3]);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " accset "  */
UW PAS_EXPSION_PRC_00000008(UW F_opf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UW Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1090;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2675; /* line # 2675 */
  if (2&F_opf) Ret=3;
  else {
    Ra.sl[6]=2676; /* line # 2676 */
    if (1&F_opf) Ret=2;
    else {
      Ra.sl[6]=2677; /* line # 2677 */
      Ret=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  UW Rv5;
  register V Rv6;
  UW Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  SL Rv12;
  register V Rv13;
  register V Rv14;
  UB Rv15;
  register V Rv16;
  register V Rv17;
  register int Rgi;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1098;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2689; /* line # 2689 */
  Rv0=0;
  Ra.sl[6]=2690; /* line # 2690 */
  while (!Rv0&&(*F_pg)!=NULL){
    Ra.sl[6]=2692; /* line # 2692 */
    Rv1=F_parm_lst;
    Ra.sl[6]=2693; /* line # 2693 */
    Rv2=(*F_pg);
    Ra.sl[6]=2694; /* line # 2694 */
    if (((UB *)Rv2)[8]&&F_npa<=2) {
      Ra.sl[6]=2696; /* line # 2696 */
      Rv3=Rv1;
      Ra.sl[6]=2697; /* line # 2697 */
      switch (F_npa) {
        case 0:Ra.sl[6]=2698; /* line # 2698 */
        Rv0=((V *)Rv2)[3]==NULL;
        break;
        case 1:Ra.sl[6]=2700; /* line # 2700 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[6]=2701; /* line # 2701 */
          if (((SL *)((V *)Rv2)[3])[0]==1) {
            Ra.sl[6]=2702; /* line # 2702 */
            Rv4=((V *)Rv2)[3]+8;
            Ra.sl[6]=2704; /* line # 2704 */
            Rv5=PAS_EXPSION_PRC_00000008(((UW *)Rv4)[5]);
            Ra.sl[6]=2705; /* line # 2705 */
            if (Rv5==(Rv5&((UW *)Rv3)[10])) {
              Ra.sl[6]=2706; /* line # 2706 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv4)[0],(8&((UW *)Rv4)[5])!=0,0);
            }
          }
        }
        break;
        case 2:Ra.sl[6]=2716; /* line # 2716 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[6]=2717; /* line # 2717 */
          if ((((SL *)((V *)Rv2)[3])[0]==2&&((SL *)((V *)Rv3)[3])[11]>0)&&((SL *)(
          (V *)((V *)Rv3)[0])[3])[11]>0) {
            Ra.sl[6]=2718; /* line # 2718 */
            Rv6=((V *)Rv2)[3]+8;
            Ra.sl[6]=2720; /* line # 2720 */
            memcpy(Ra.s+32,((V *)Rv2)[3]+24,12);
            Ra.sl[6]=2721; /* line # 2721 */
            Rv5=PAS_EXPSION_PRC_00000008(((UW *)Rv6)[5]);
            Rv7=PAS_EXPSION_PRC_00000008(Ra.uw[21]);
            Ra.sl[6]=2722; /* line # 2722 */
            if (Rv5==(Rv5&((UW *)Rv3)[10])&&Rv7==(Rv7&((UW *)((V *)Rv3)[0])[10])
            ) {
              Ra.sl[6]=2723; /* line # 2723 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv6)[0],(8&((UW *)Rv6)[5])!=0,0)&&
              P_comp_type(((V *)((V *)Rv3)[0])[3],Ra.v[4],(8&Ra.uw[21])!=0,0);
            }
            Ra.sl[6]=2735; /* line # 2735 */
            if (Rv0) {
              Ra.sl[6]=2736; /* line # 2736 */
              if (4&((UW *)Rv6)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V *)((
              V *)Rv3)[0])[3])[13],0,0);
              else {
                Ra.sl[6]=2738; /* line # 2738 */
                if (16&((UW *)Rv6)[5]) Rv0=((V *)Rv3)[3]==((V *)((V *)Rv3)[0])[3]
                ;
                else {
                  Ra.sl[6]=2740; /* line # 2740 */
                  if (32&((UW *)Rv6)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V
                   *)Rv3)[0])[3],8&((UW *)Rv6)[5]||8&Ra.uw[21],1);
                }
              }
            }
          }
        }
        break;
      }
    }
    else {
      Ra.sl[6]=2746; /* line # 2746 */
      Rv8=((V *)Rv2)[2];
      Ra.sl[6]=2747; /* line # 2747 */
      if (((SL *)Rv8)[20]>=F_npa) {
        Ra.sl[6]=2749; /* line # 2749 */
        Rv9=((V *)Rv8)[8];
        Ra.sl[6]=2750; /* line # 2750 */
        if (Rv9!=NULL) {
          Ra.sl[6]=2751; /* line # 2751 */
          if (((UB *)Rv9)[86]==7) {
            Ra.sl[6]=2752; /* line # 2752 */
            Rv9=((V *)Rv9)[3];
          }
        }
        Ra.sl[6]=2755; /* line # 2755 */
        if ((F_npa==2&&((SL *)Rv8)[20]==2)&&(((UB *)Rv8)[104]==1||((UB *)Rv8)[104]
        ==3)) {
          Ra.sl[6]=2757; /* line # 2757 */
          Rv10=Rv1;
          Ra.sl[6]=2759; /* line # 2759 */
          Rv11=((V *)Rv9)[3];
          Ra.sl[6]=2760; /* line # 2760 */
          Rv0=P_comp_type(((V *)Rv10)[3],((V *)Rv9)[5],8&((UW *)Rv9)[44]||((UB *)
          Rv9)[86]!=9,0)&&P_comp_type(((V *)((V *)Rv10)[0])[3],((V *)Rv11)[5],8&
          ((UW *)Rv11)[44]||((UB *)Rv11)[86]!=9,0);
          Ra.sl[6]=2764; /* line # 2764 */
          if (Rv0) {
            Ra.sl[6]=2765; /* line # 2765 */
            if (4&((UW *)Rv9)[44]) Rv0=P_comp_type(((V *)Rv10)[3],((V *)((V *)((
            V *)Rv10)[0])[3])[13],0,0);
            else {
              Ra.sl[6]=2767; /* line # 2767 */
              if (16&((UW *)Rv9)[44]) Rv0=((V *)Rv10)[3]==((V *)((V *)Rv10)[0])[
3]&&((SL *)((V *)Rv10)[3])[10]==0;
              else {
                Ra.sl[6]=2769; /* line # 2769 */
                if (32&((UW *)Rv9)[44]) Rv0=P_comp_type(((V *)Rv10)[3],((V *)((V
                 *)Rv10)[0])[3],8&((UW *)Rv9)[44]||8&((UW *)Rv11)[44],0);
              }
            }
          }
        }
        Ra.sl[6]=2797; /* line # 2797 */
        if (!Rv0) {
          Ra.sl[6]=2799; /* line # 2799 */
          Rv0=1;
          Ra.sl[6]=2800; /* line # 2800 */
          while (Rv0&&Rv9!=NULL){
            Ra.sl[6]=2802; /* line # 2802 */
            Rv12=0;
            Ra.sl[6]=2803; /* line # 2803 */
            Rv13=Rv9;
            Ra.sl[6]=2804; /* line # 2804 */
            if (Rv1!=NULL) {
              Ra.sl[6]=2805; /* line # 2805 */
              Rv14=Rv1;
              Ra.sl[6]=2807; /* line # 2807 */
              if (((UB *)Rv14)[40]==17) {
                Ra.sl[6]=2808; /* line # 2808 */
                if (((V *)Rv13)[7]==NULL&&!(8192&((UW *)Rv13)[42])) {
                  Ra.sl[6]=2809; /* line # 2809 */
                  Rv0=0;
                }
                else {
                  Ra.sl[6]=2812; /* line # 2812 */
                  Rv9=((V *)Rv13)[3];
                  Rv1=((V *)Rv14)[0];
                }
              }
              else {
                Ra.sl[6]=2816; /* line # 2816 */
                Rv15=P_comp_type(((V *)Rv14)[3],((V *)Rv13)[5],((UB *)Rv13)[86]!=
9,0);
                Ra.sl[6]=2819; /* line # 2819 */
                if (!Rv15&&((UB *)Rv14)[40]==14) {
                  Ra.sl[6]=2821; /* line # 2821 */
                  Rv16=((V *)Rv13)[5];
                  Ra.sl[6]=2822; /* line # 2822 */
                  switch (((UB *)Rv16)[93]) {
                    case 4:Ra.sl[6]=2830; /* line # 2830 */
                    if (((UB *)((V *)Rv14)[3])[93]==3) {
                      Ra.sl[6]=2832; /* line # 2832 */
                      ((V *)Rv14)[3]=V_typ_std.v[4];
                      Rv15=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[6]=2854; /* line # 2854 */
                    if ((P_comp_type(((V *)Rv16)[14],V_typ_std.v[0],1,0)&&((UB *)(
                    (V *)Rv16)[15])[93]==2)&&((SL *)Rv16)[10]==0) {
                      Ra.sl[6]=2857; /* line # 2857 */
                      if (P_comp_type(((V *)Rv14)[3],V_typ_std.v[10],0,0)) {
                        Ra.sl[6]=2860; /* line # 2860 */
                        if (((UB *)Rv16)[93]==8) {
                          Ra.sl[6]=2861; /* line # 2861 */
                          Rv17=((V *)Rv16)[15];
                          Ra.sl[6]=2862; /* line # 2862 */
                          Rv15=(((SL *)Rv17)[30]-((SL *)Rv17)[29])+1==((SL *)((V
                           *)Rv14)[7])[6];
                        }
                        else {
                          Ra.sl[6]=2865; /* line # 2865 */
                          Rv15=1;
                        }
                      }
                      else {
                        Ra.sl[6]=2867; /* line # 2867 */
                        if (P_comp_type(((V *)Rv14)[3],V_typ_std.v[0],0,0)) {
                          Ra.sl[6]=2869; /* line # 2869 */
                          if (((UB *)Rv16)[93]==9) Rv15=1;
                          else {
                            Ra.sl[6]=2870; /* line # 2870 */
                            Rv15=((SL *)Rv16)[30]==((SL *)Rv16)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=2875; /* line # 2875 */
                if (Rv15) {
                  Ra.sl[6]=2877; /* line # 2877 */
                  if (((V *)Rv13)[5]!=NULL) {
                    Ra.sl[6]=2878; /* line # 2878 */
                    if (((UB *)((V *)Rv13)[5])[93]==9) {
                      Ra.sl[6]=2879; /* line # 2879 */
                      Rv12=((SL *)((V *)Rv13)[5])[24];
                    }
                  }
                  Ra.sl[6]=2880; /* line # 2880 */
                  Rv9=((V *)Rv13)[3];
                  Rv1=((V *)Rv14)[0];
                }
                else {
                  Ra.sl[6]=2881; /* line # 2881 */
                  Rv0=0;
                }
                Ra.sl[6]=2884; /* line # 2884 */
                if (Rv0) {
                  Ra.sl[6]=2886; /* line # 2886 */
                  if (((UB *)Rv13)[86]==9) {
                    Ra.sl[6]=2888; /* line # 2888 */
                    if (!(1&((UW *)Rv14)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[6]=2891; /* line # 2891 */
                    if (4&((UW *)Rv14)[10]) {
                      Ra.sl[6]=2893; /* line # 2893 */
                      if (32&((UW *)Rv13)[42]) {
                        Ra.sl[6]=2894; /* line # 2894 */
                        if (!(1&((UW *)Rv14)[10])) Rv0=0;
                      }
                      Ra.sl[6]=2895; /* line # 2895 */
                      if (64&((UW *)Rv13)[42]) {
                        Ra.sl[6]=2896; /* line # 2896 */
                        if (!(2&((UW *)Rv14)[10])) Rv0=0;
                      }
                    }
                    else {
                      Ra.sl[6]=2899; /* line # 2899 */
                      if (64&((UW *)Rv13)[42]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[6]=2904; /* line # 2904 */
              if (((V *)Rv13)[7]==NULL&&!(8192&((UW *)Rv13)[42])) {
                Ra.sl[6]=2905; /* line # 2905 */
                Rv0=0;
              }
              else {
                Ra.sl[6]=2907; /* line # 2907 */
                Rv9=((V *)Rv13)[3];
              }
            }
            Ra.sl[6]=2909; /* line # 2909 */
            if (Rv12>0) while (1){
              Ra.sl[6]=2911; /* line # 2911 */
              Rv9=((V *)Rv9)[3];
              Rv12=Rv12-1;
              if (Rv12==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[6]=2916; /* line # 2916 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  Ra.sl[6]=2918; /* line # 2918 */
  if (!Rv0) {
    Ra.sl[6]=2925; /* line # 2925 */
    P_src_error_s(Rd.s+1116,113,3, F_id,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1120;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2950; /* line # 2950 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  Ra.sl[6]=2951; /* line # 2951 */
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  Ra.sl[6]=2952; /* line # 2952 */
  if (F_p!=NULL) {
    Ra.sl[6]=2953; /* line # 2953 */
    Rv1=F_p;
    Ra.sl[6]=2955; /* line # 2955 */
    if (((UB *)Rv1)[8]) {
      Ra.sl[6]=2957; /* line # 2957 */
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else {
        Ra.sl[6]=2958; /* line # 2958 */
        Rv2=P_exp_val_bin(F_oblst, F_p);
      }
    }
    else {
      Ra.sl[6]=2963; /* line # 2963 */
      Rv3=((V *)Rv1)[2];
      Ra.sl[6]=2965; /* line # 2965 */
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      Ra.sl[6]=2968; /* line # 2968 */
      P_call_setting(&Rv2);
    }
    Ra.sl[6]=2970; /* line # 2970 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=2971; /* line # 2971 */
    Ret=F_oblst;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1133;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2987; /* line # 2987 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Ra.sl[6]=2988; /* line # 2988 */
  Rv0=((V *)F_ip)[10];
  Ra.sl[6]=2989; /* line # 2989 */
  if (F_np<=0) {
    Ra.sl[6]=2991; /* line # 2991 */
    Rv1=F_lgp;
    Ra.sl[6]=2992; /* line # 2992 */
    while (Rv1!=NULL){
      Ra.sl[6]=2993; /* line # 2993 */
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Ra.sl[6]=2995; /* line # 2995 */
  Rv2=NULL;
  Ra.sl[6]=2996; /* line # 2996 */
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2997; /* line # 2997 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    Ra.sl[6]=3001; /* line # 3001 */
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=3002; /* line # 3002 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      Ra.sl[6]=3003; /* line # 3003 */
      if (((V *)Rv3)[2]!=NULL) {
        Ra.sl[6]=3005; /* line # 3005 */
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        Ra.sl[6]=3006; /* line # 3006 */
        P_call_setting(&Rv2);
      }
    }
  }
  Ra.sl[6]=3010; /* line # 3010 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1148;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=3019; /* line # 3019 */
  Ri.ub[0]=F_op;
  Ra.sl[6]=3021; /* line # 3021 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1159;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=3036; /* line # 3036 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else {
    Ra.sl[6]=3037; /* line # 3037 */
    Rv0=((V *)V_ope_table.v[28])[3];
  }
  Ra.sl[6]=3038; /* line # 3038 */
  Rv1=((V *)F_prm)[0];
  Ra.sl[6]=3039; /* line # 3039 */
  Rv2=((UW *)F_prm)[10];
  Ra.sl[6]=3040; /* line # 3040 */
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=3041; /* line # 3041 */
  if (F_bovr) {
    Ra.sl[6]=3043; /* line # 3043 */
    ((UW *)F_prm)[10]=Rv2|3;
    Ra.sl[6]=3044; /* line # 3044 */
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=3046; /* line # 3046 */
  Ri.ub[0]=28;
  Ra.sl[6]=3047; /* line # 3047 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  Ra.sl[6]=3048; /* line # 3048 */
  if (F_bovr) {
    Ra.sl[6]=3050; /* line # 3050 */
    ((UW *)F_prm)[10]=Rv2;
    Ra.sl[6]=3051; /* line # 3051 */
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=3053; /* line # 3053 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
