/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[6];

/* Define the local data section. */
static Blk( Rd, 1376 ) = {{
 15,  15, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  95, 116, 121, 112,
101,  62,  62,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,
 47,  83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,
 53,  45,  51,  47, 112,  99, 109, 112,  95,  99, 111, 109, 112,  46, 112,  97,
115,   4,   4,  69,  88,  80,  84,  10,  10, 101, 120, 112,  95, 103, 101, 110,
110, 117, 109,   4,   4,  69,  71,  67,  84,   9,   9,  97, 116, 116, 114,  95,
116, 121, 112, 101,   4,   4,  65,  84,  84,  89,   7,   7,  36, 115, 105, 110,
103, 108, 101,   7,   7,  36, 100, 111, 117,  98, 108, 101,   6,   6,  36,  97,
116, 116, 114,  95,  14,  14,  98, 117, 105, 108, 100,  95,  97, 114, 103,  95,
108, 105, 115, 116,   4,   4,  66,  65,  82,  71,  16,  16,  99,  97, 108, 108,
 95, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,   4,   4,  70,  67,
 65,  76,  18,  18,  99,  97, 108, 108,  95, 105, 110, 100, 105, 114, 101,  99,
116,  95, 112, 114, 111,  99,  12,  12,  99,  97, 108, 108,  95, 103, 101, 110,
101, 114, 105,  99,   4,   4,  67,  65,  76,  71,   9,   9, 111, 112, 101, 110,
 95,  99,  97, 108, 108,   4,   4,  79,  80,  69,  78,  14,  14, 114, 101,  97,
100, 119, 114, 105, 116, 101,  95,  99,  97, 108, 108,   4,   4,  82,  87,  73,
 79,  18,  18, 103, 101, 116,  95, 115, 116,  97, 116, 101,  95, 101, 102, 102,
 95, 108, 105, 115, 116,  15,  15, 117, 115, 101, 114,  95, 115, 116,  97, 116,
101,  95,  99,  97, 108, 108,   4,   4,  85,  83,  84,  65,   8,   8, 110, 101,
119,  95,  99,  97, 108, 108,   4,   4,  78,  69,  87,  67,  12,  12, 100, 105,
115, 112, 111, 115, 101,  95,  99,  97, 108, 108,   4,   4,  70,  82,  69,  69,
 20,  20, 103, 101, 110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,
 97, 116,  95, 115, 101, 116,   4,   4,  83,  65,  71,  82,  20,  20, 103, 101,
110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 116,
 97,  98,   4,   4,  84,  65,  71,  82,  20,  20, 103, 101, 110,  95, 108, 105,
115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 114, 101,  99,   4,   4,
 82,  65,  71,  82,  12,  12, 103, 101, 116,  95,  97, 103, 114, 101, 103,  97,
116, 101,   4,   4,  65,  71,  82,  69,  13,  13, 101, 120, 112,  95,  99, 111,
110, 115, 116,  95, 115, 101, 116,   4,   4,  67,  83,  69,  84,  11,  11, 103,
101, 116,  95, 112, 114, 111,  99, 114, 101, 102,   4,   4,  71,  80,  82,  79,
 15,  15, 101, 120, 112,  95, 103, 101, 110, 101, 114, 105,  99,  95, 114, 101,
102,   4,   4,  69,  88,  71,  69,  14,  14, 101, 120, 112,  95, 105, 100, 101,
110, 116, 105, 102, 105, 101, 114,   4,   4,  82,  70,  79,  66,   9,   9, 101,
120, 112,  95, 105, 110, 100, 105, 114,   4,   4,  73,  78,  68,  73,   9,   9,
101, 120, 112,  95, 102, 105, 101, 108, 100,   4,   4,  71,  70,  76,  68,   9,
  9, 101, 120, 112,  95, 105, 110, 100, 101, 120,   4,   4,  73,  78,  68,  88,
  7,   7, 101, 120, 112,  95, 117, 110,  97,   4,   4,  69,  88,  80,  82,   7,
  7, 101, 120, 112,  95, 112, 111, 119,   7,   7, 101, 120, 112,  95, 109, 117,
108,   7,   7, 101, 120, 112,  95,  97, 100, 100,   7,   7, 101, 120, 112,  95,
114, 101, 108,   7,   7, 101, 120, 112,  95,  97, 110, 100,  10,  10, 101, 120,
112, 114, 101, 115, 115, 105, 111, 110,  14,  14,  99,  97, 115, 101,  95, 119,
111, 114, 107,  95, 108, 105, 115, 116,   4,   4,  67,  65,  83,  68,  15,  15,
 99,  97, 115, 101,  95, 100, 101, 102, 105, 110, 105, 116, 105, 111, 110,  17,
 17, 115, 101, 116,  95,  97, 108, 105, 103, 110, 109, 101, 110, 116,  95, 115,
112,  99,   4,   4,  65,  76,  71,  78,  14,  14,  99, 111, 110, 102, 111, 114,
109,  97, 110, 116,  95, 100, 101, 102,   4,   4,  67,  78,  70,  65,   9,   9,
 97, 114, 114,  97, 121,  95, 100, 101, 102,   4,   4,  65,  82,  82,  89,   8,
  8, 116, 121, 112, 101,  95, 115, 112,  99,   4,   4,  84,  89,  80,  83,  18,
 18, 115, 101, 116,  95, 100, 101,  99, 108,  95,  97, 116, 116, 114, 105,  98,
117, 116, 101,   4,   4,  68,  65,  84,  84,  13,  13, 118,  97, 114,  98, 108,
 95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  86,  65,  82,  66,  10,  10,
 99, 111, 110, 115, 116,  95, 100, 101,  99, 108,   4,   4,  67,  79,  78,  68,
  9,   9, 116, 121, 112, 101,  95, 100, 101,  99, 108,   4,   4,  84,  89,  80,
 68,  10,  10, 118,  97, 114,  98, 108,  95, 100, 101,  99, 108,  10,  10, 108,
 97,  98, 101, 108,  95, 100, 101,  99, 108,   4,   4,  76,  65,  66,  68,  14,
 14, 115, 116,  97, 116, 101, 109, 101, 110, 116,  95, 100, 101,  99, 108,   4,
  4,  83,  84,  65,  68,  13,  13,  97, 114, 103, 117, 109, 101, 110, 116,  95,
108, 105, 115, 116,   4,   4,  65,  82,  71,  76,   3,   3,  46, 114, 118,  16,
 16, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,  95, 100, 101,  99,
108,   4,   4,  70,  80,  68,  69,  15,  15, 102, 111, 114, 109,  97, 108,  95,
112, 114, 111,  99,  95, 112, 116, 114,   4,   4,  70,  80,  68,  69,  18,  18,
105, 110, 115, 101, 114, 116,  95, 110, 101, 119,  95, 103, 101, 110, 101, 114,
105,  99,   4,   4,  73,  71,  69,  78,   9,   9, 112, 114, 111,  99,  95, 100,
101,  99, 108,   4,   4,  68,  80,  82,  79,   4,   4,  80,  82,  67,  95,   4,
  4,  80,  82,  67,  95,   9,   9, 112, 114, 111,  99,  95,  98, 111, 100, 121,
  4,   4,  71,  69,  78,  68,   9,   9, 103, 101, 110, 101,  95, 100, 101,  99,
108,  10,  10, 103, 101, 110,  95,  97, 115, 115, 105, 103, 110,   4,   4,  71,
 65,  83,  83,  12,  12, 114, 101, 116, 117, 114, 110,  95, 115, 116,  97, 116,
101,   4,   4,  82,  69,  84,  85,  16,  16,  97, 115, 115, 105, 103, 110, 109,
101, 110, 116,  95, 115, 116,  97, 116, 101,   4,   4,  65,  83,  83,  73,  10,
 10, 119, 105, 116, 104,  95, 115, 116,  97, 116, 101,   4,   4,  87,  73,  84,
 72,   8,   8, 105, 102,  95, 115, 116,  97, 116, 101,   4,   4,  73,  70,  83,
 84,  10,  10, 101, 120, 105, 116,  95, 115, 116,  97, 116, 101,   4,   4,  69,
 88,  83,  84,  10,  10, 108, 111, 111, 112,  95, 115, 116,  97, 116, 101,   4,
  4,  76,  79,  79,  80,   9,   9, 102, 111, 114,  95, 115, 116,  97, 116, 101,
  4,   4,  70,  79,  82,  95,  10,  10, 103, 111, 116, 111,  95, 115, 116,  97,
116, 101,   4,   4,  71,  84,  79,  76,  11,  11,  98, 101, 103, 105, 110,  95,
115, 116,  97, 116, 101,   4,   4,  66,  69,  71,  83,  12,  12, 108,  97,  98,
101, 108,  95,  97, 116, 116,  97,  99, 104,   9,   9, 115, 116,  97, 116, 101,
109, 101, 110, 116,   4,   4,  83,  84,  65,  84,   9,   9, 115, 116,  97, 116,
101, 108, 105, 115, 116,   4,   4,  83,  84,  76,  73,   9,   9,  99, 109, 112,
 95,  98, 108, 111,  99, 107,   4,   4,  66,  76,  79,  67,   5,   5,  46, 116,
101, 109, 112,   8,   8,  99, 109, 112,  95, 105, 110, 105, 116,   9,   9,  99,
109, 112,  95, 112,  97, 115, 115,  50,  11,  11,  99, 109, 112,  95,  99, 111,
109, 112, 105, 108, 101,   4,   4,  67,  77,  80,  77,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 64 ) = {{
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern Blk(V_typ_std, 248 );
extern UB V_cmp_range;
extern V V_curr_descr;
extern UB V_enm_range;
extern Blk(V_sy_sym, 8 );
extern V V_attr_list;
extern Blk(V_sy_ident, 32 );
extern V V_ima_typ;
extern V V_int_typ;
extern Blk(V_ide_udptr, 120 );
extern V V_iof_std_open;
extern UB V_sy_label_flag;
extern SL V_dst_seti;
extern SL V_dst_seta;
extern SL V_dst_setw;
extern V V_set_entry_proc;
extern SL V_stri_stroffset;
extern V V_sy_search;
extern UB V_lastsymb;
extern Blk(V_lex_ident_tree, 4160 );
extern SL V_ident_disp;
extern SL V_sy_ival;
extern G V_sy_rval;
extern Blk(V_sy_string, 264 );
extern SL V_curr_disp;
extern UB V_sy_casedef;
extern UB V_err_prt;
extern V V_sy_type_gfirst;
extern UB V_sy_init_mod;
extern UB V_sy_fix_range_ctl;
extern SL V_fptr_size;
extern SL V_stri_descrsz;
extern SL V_stri_lengthsz;
extern V V_usi_tab;
extern V V_csi_tab;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;
extern SL V_inte_size;
extern V V_uns_typ;
extern SL V_sngl_size;
extern SL V_dble_size;
extern UB V_tcas_flag;
extern SL V_curr_lex;
extern UB V_error_result;
extern UB V_cmp_dynamic;
extern Blk(V_lex_ident_level, 128 );
extern UB V_sy_generic_qmod;
extern V V_pro_d_first;
extern V V_pro_d_last;
extern Blk(V_opname, 960 );
extern SL V_proc_seq;
extern SL V_cmp_traceopt;
extern SL V_cmp_trace;
extern UB V_cmp_objf;
extern V V_pro_last;
extern V V_pro_first;
extern V V_new_entry_proc;
extern V V_newh_entry_proc;
extern V V_dispose_entry_proc;
extern V V_iof_std_close;
extern V V_inp_std_sel;
extern V V_inp_std_gene;
extern V V_inp_std_eoln;
extern V V_inp_std_bin;
extern V V_out_std_sel;
extern V V_out_std_gene;
extern V V_out_std_eoln;
extern V V_out_std_bin;
extern V V_gen_std_string1;
extern V V_gen_std_cnfardsc;
extern Blk(V_ope_table, 240 );
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_wildtmp_stk;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_src_control;
extern UB V_emergency_stop;
extern V V_pro_current;
extern SL V_cprc_disp;
extern UB V_sy_var_init_mod;
extern V V_cntx_varbl;
extern V V_wildtmp_typ;
extern V V_wildtmp_ide;
extern SL V_wildtmp_psz;
extern Blk(V_wildtmp_pal, 8 );
extern UB V_opt_exec;
extern UB V_cmp_cmpdbg;
extern UB V_cmp_genenv;
extern SL V_cmp_listlvl;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern UB V_cmp_bltt;
extern UB V_cmp_opt;
extern UB V_cmp_debugopt;
extern UB V_cmp_debug;
extern SL V_cmp_tracecount;
extern SL V_cntx_procname;
extern SL V_cntx_srcfname;
extern SL V_cntx_linenbr;
extern SL V_cntx_size;
extern V V_cntx_typ;
extern V V_env_file;
extern V V_env_first;
extern V V_env_last;
extern C V_sy_ch;
extern V V_pas_main;


/* Function/procedure prototypes. */
void P_lst_page();
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_search_char();
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_data_format_set(V F_ty);
V P_tab_new(SL F_sz);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_all_free(V F_p);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
SL P_lgt_get_econst(V F_lgt, SL F_idf);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2);
void P_new_disp_level(V F_ow, UB F_kind);
void P_ide_reserve_disp(SL F_prv);
SL P_match(V F_s1, V F_s2);
V P_new_int_name(V F_head, SL *F_nbs);
V P_level_search(V F_fp);
V P_lex_search(SL F_disp);
V P_ide_search(UW F_fs);
void P_ide_new(UB F_fc, V F_ty, V *F_ip);
void P_gen_cntxvar(V F_pr, V F_id);
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd);
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd);
void P_label_purge(V *F_prv_cntx);
SL P_typ_alignement(SL F_iaddr, V F_aln);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_cte_allocate(V F_vp, V F_id);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ);
void P_tmpstk_free(V F_stkp);
void P_free_typ_list(V *F_p);
void P_free_ide_list(V *F_p);
void P_ide_create_name(V F_name);
void P_ide_int_label();
V P_ide_search_from_nameid(V F_ip);
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach);
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2);
void P_compile_set_title();
void P_compile_set_sbttl(V F_prc);
void P_insymbol();
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rflg);
void P_insy_init();
void P_set_strname(V *F_nam);
void P_set_stdname(V F_pr);
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent);
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count);
void P_type_parm_cte_release(V F_ty);
void P_string_in_array(V F_lgt, V F_ty);
void P_string_in_substring(V F_lgt, V F_ty);
void P_call_setting(V *F_lgt);
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst);
V P_exp_genoper(V F_id, V F_p, V F_oblst);
V P_exp_genop(UB F_op, V F_oblst);
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
void P_initialize_varbl(V F_ip);
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide);
void P_init_d_varbl(V F_ip);
void P_type_check_parm(V F_lgt);
V P_type_parm_set(V F_ip, V F_lgt);
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void P_lgt_gen_routine(V F_ty);
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj);
void P_lgt_extract_simple_cte(V F_lgt);
void P_lgt_all_fparm(V F_pr);
void P_lgt_pass1_complet(V F_pr);
void P_lgt_dump_proc(V F_pr);
void P_lgt_dump_static(V F_pr);
void P_generation_setting();
void P_generate_code_p1(V F_proc);
void P_generate_code_p2();
void P_add_inherit_file(V F_fenv);
void P_pas_read_env_file();
void P_pas_write_env_file();
void PAS_COMILER_cmp_pass2(V F_pr);
V PAS_COMILER_PRC_00000000();
V PAS_COMILER_PRC_00000001(UB F_isfunction);
V PAS_COMILER_PRC_00000002(UB F_isfunction, V F_owid);
V PAS_COMILER_PRC_00000019(V F_ty);
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg);
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ);
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty);
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg, V F_owid);


/* Procedure/Function : " expression_type "  */
V PAS_COMILER_PRC_00000005(V F_it, UB F_exact, UB F_no_def, UB F_no_check){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  C Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=186; /* line # 186 */
  Rv0=0;
  Ra.sl[6]=187; /* line # 187 */
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=188; /* line # 188 */
  if (Rv1!=NULL) {
    Ra.sl[6]=189; /* line # 189 */
    Rv2=Rv1;
    Rv3=F_it;
    Ra.sl[6]=190; /* line # 190 */
    if (((V *)Rv2)[3]!=F_it) {
      Ra.sl[6]=192; /* line # 192 */
      if (((UB *)Rv2)[40]==14) {
        Ra.sl[6]=194; /* line # 194 */
        if (((V *)Rv2)[3]==V_typ_std.v[13]&&P_comp_type(((V *)Rv2)[3],F_it,0,0))
         {
          Ra.sl[6]=195; /* line # 195 */
          ((V *)Rv2)[3]=F_it;
          Rv0=1;
        }
        else {
          Ra.sl[6]=197; /* line # 197 */
          if (P_comp_type(((V *)Rv2)[3],V_typ_std.v[10],0,0)||P_comp_type(((V *)
          Rv2)[3],V_typ_std.v[0],1,0)) {
            Ra.sl[6]=200; /* line # 200 */
            if ((((UB *)Rv3)[93]==10&&((UB *)((V *)Rv2)[3])[93]==0)&&P_comp_type((
            (V *)Rv2)[3],F_it, F_exact,0)) {
              Ra.sl[6]=204; /* line # 204 */
              if (((V *)Rv2)[7]!=NULL) Rv4=(C)((SL *)((V *)Rv2)[7])[13];
              else Rv4=32;
              Ra.sl[6]=205; /* line # 205 */
              P_val_free(((V *)Rv2)+7);
              Ra.sl[6]=206; /* line # 206 */
              P_val_new(((V *)Rv2)+7,V_typ_std.v[10]);
              Ra.sl[6]=207; /* line # 207 */
              ((V *)Rv2)[3]=V_typ_std.v[10];
              Ra.sl[6]=208; /* line # 208 */
              Rv5=((V *)Rv2)[7];
              Ra.sl[6]=210; /* line # 210 */
              ((UB *)Rv5)[48]=29;
              Ra.sl[6]=211; /* line # 211 */
              ((SL *)Rv5)[6]=1;
              Ra.sl[6]=212; /* line # 212 */
              ((V *)Rv5)[7]=PAS__NEW(3);
              ((UB *)((V *)Rv5)[7])[0]=1;
              Ra.sl[6]=213; /* line # 213 */
              PAS__CHA_TO_STR(((V *)Rv5)[7],Rv4);
              Ra.sl[6]=215; /* line # 215 */
              Rv0=1;
            }
            else {
              Ra.sl[6]=218; /* line # 218 */
              if (((UB *)Rv3)[93]==8&&((V *)Rv3)[14]==V_typ_std.v[0]) {
                Ra.sl[6]=221; /* line # 221 */
                P_string_in_array(Rv1, F_it);
                Ra.sl[6]=222; /* line # 222 */
                Rv0=1;
              }
              else {
                Ra.sl[6]=225; /* line # 225 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=227; /* line # 227 */
                  P_string_in_substring(Rv1, F_it);
                  Ra.sl[6]=228; /* line # 228 */
                  Rv0=1;
                }
              }
            }
          }
          else {
            Ra.sl[6]=232; /* line # 232 */
            if (((V *)((V *)Rv2)[3])[0]==F_it) Rv0=1;
            else {
              Ra.sl[6]=234; /* line # 234 */
              switch (((UB *)Rv3)[93]) {
                case 0:
                case 1:
                case 2:Ra.sl[6]=236; /* line # 236 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=238; /* line # 238 */
                  if (((V *)Rv2)[7]!=NULL) {
                    Ra.sl[6]=239; /* line # 239 */
                    Rv6=((V *)Rv2)[7];
                    Ra.sl[6]=241; /* line # 241 */
                    if (((UB *)Rv3)[112]) {
                      Ra.sl[6]=243; /* line # 243 */
                      if (((UL *)Rv3)[29]<=((UL *)Rv6)[13]&&((UL *)Rv3)[30]>=((UL
                       *)Rv6)[13]) {
                        Ra.sl[6]=244; /* line # 244 */
                        ((V *)Rv2)[3]=F_it;
                        ((V *)Rv6)[4]=F_it;
                        Rv0=1;
                      }
                    }
                    else {
                      Ra.sl[6]=247; /* line # 247 */
                      if (((SL *)Rv3)[29]<=((SL *)Rv6)[13]&&((SL *)Rv3)[30]>=((SL
                       *)Rv6)[13]) {
                        Ra.sl[6]=248; /* line # 248 */
                        ((V *)Rv2)[3]=F_it;
                        ((V *)Rv6)[4]=F_it;
                        Rv0=1;
                      }
                    }
                    Ra.sl[6]=250; /* line # 250 */
                    if (!Rv0) P_src_error(Rd.s+83,154,2);
                  }
                }
                break;
                case 22:Ra.sl[6]=254; /* line # 254 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=256; /* line # 256 */
                  if (((V *)Rv2)[7]!=NULL) {
                    Ra.sl[6]=257; /* line # 257 */
                    Rv7=((V *)Rv2)[7];
                    Ra.sl[6]=258; /* line # 258 */
                    if (((SL *)((V *)Rv2)[3])[11]<=((SL *)Rv3)[11]) {
                      Ra.sl[6]=260; /* line # 260 */
                      ((V *)Rv2)[3]=F_it;
                      Ra.sl[6]=261; /* line # 261 */
                      ((V *)Rv7)[4]=F_it;
                      Ra.sl[6]=262; /* line # 262 */
                      if (V_cmp_range&&!F_no_check) {
                        Ra.sl[6]=264; /* line # 264 */
                        Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
                        Ra.sl[6]=266; /* line # 266 */
                        ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,
                        NULL,0);
                        Ra.sl[6]=267; /* line # 267 */
                        ((V *)Rv1)[0]=Rv8;
                        Ra.sl[6]=268; /* line # 268 */
                        Rv1=P_lgt_new_code(2, Rv1);
                        Ra.sl[6]=269; /* line # 269 */
                        ((V *)Rv1)[3]=F_it;
                      }
                      Ra.sl[6]=271; /* line # 271 */
                      Rv0=1;
                    }
                  }
                }
                break;
                case 3:
                case 4:Ra.sl[6]=275; /* line # 275 */
                Rv9=((V *)Rv2)[7];
                Ra.sl[6]=277; /* line # 277 */
                if (((V *)Rv2)[3]!=NULL) {
                  Ra.sl[6]=278; /* line # 278 */
                  switch (((UB *)((V *)Rv2)[3])[93]) {
                    case 2:Ra.sl[6]=279; /* line # 279 */
                    ((G *)Rv9)[7]=(double)((SL *)Rv9)[13];
                    Rv0=1;
                    break;
                    case 3:
                    case 4:Ra.sl[6]=280; /* line # 280 */
                    Rv0=1;
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=283; /* line # 283 */
                if (Rv0) {
                  Ra.sl[6]=285; /* line # 285 */
                  ((UB *)Rv9)[48]=((UB *)Rv3)[93];
                  Ra.sl[6]=286; /* line # 286 */
                  ((V *)Rv9)[4]=F_it;
                  Ra.sl[6]=287; /* line # 287 */
                  ((V *)Rv2)[3]=F_it;
                }
                break;
                default:break;
              }
            }
          }
        }
      }
      Ra.sl[6]=300; /* line # 300 */
      if (!Rv0) {
        Ra.sl[6]=301; /* line # 301 */
        if (!P_comp_type(((V *)Rv2)[3],F_it, F_exact,0)) {
          Ra.sl[6]=303; /* line # 303 */
          P_src_error(Rd.s+83,109,3);
          Ra.sl[6]=304; /* line # 304 */
          ((V *)Rv1)[3]=F_it;
        }
        else {
          Ra.sl[6]=307; /* line # 307 */
          if (V_cmp_range&&!F_no_check) {
            Ra.sl[6]=308; /* line # 308 */
            switch (((UB *)Rv3)[93]) {
              case 0:
              case 1:
              case 2:Ra.sl[6]=310; /* line # 310 */
              if (V_enm_range) {
                Ra.sl[6]=312; /* line # 312 */
                Rv8=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[29]);
                Ra.sl[6]=313; /* line # 313 */
                ((V *)Rv8)[0]=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[30]);
                Ra.sl[6]=314; /* line # 314 */
                ((V *)Rv1)[0]=Rv8;
                Ra.sl[6]=315; /* line # 315 */
                Rv1=P_lgt_new_code(2, Rv1);
                Ra.sl[6]=316; /* line # 316 */
                ((V *)Rv1)[3]=F_it;
              }
              break;
              case 22:Ra.sl[6]=321; /* line # 321 */
              Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
              Ra.sl[6]=322; /* line # 322 */
              ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,NULL,0);
              Ra.sl[6]=323; /* line # 323 */
              ((V *)Rv1)[0]=Rv8;
              Ra.sl[6]=324; /* line # 324 */
              Rv1=P_lgt_new_code(2, Rv1);
              Ra.sl[6]=325; /* line # 325 */
              ((V *)Rv1)[3]=F_it;
              break;
              default:break;
            }
          }
        }
      }
    }
  }
  Ra.sl[6]=331; /* line # 331 */
  if (F_no_def) {
    Ra.sl[6]=332; /* line # 332 */
    if (((UB *)Rv1)[40]==17) P_src_error(Rd.s+83,181,2);
  }
  Ra.sl[6]=333; /* line # 333 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_gennum "  */
SL PAS_COMILER_PRC_00000006(V *F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+87;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=348; /* line # 348 */
  Rv0=PAS_COMILER_PRC_00000005((*F_ty),0,0,0);
  Ra.sl[6]=349; /* line # 349 */
  Rv1=Rv0;
  Ra.sl[6]=351; /* line # 351 */
  (*F_ty)=((V *)Rv1)[3];
  Ra.sl[6]=352; /* line # 352 */
  if (((UB *)Rv1)[40]==14) {
    Ra.sl[6]=353; /* line # 353 */
    Ret=((SL *)((V *)Rv1)[7])[13];
  }
  else {
    Ra.sl[6]=356; /* line # 356 */
    P_src_error(Rd.s+101,853,2);
    Ra.sl[6]=357; /* line # 357 */
    Ret=((SL *)(*F_ty))[29];
  }
  Ra.sl[6]=360; /* line # 360 */
  P_lgt_free_tree(&Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " attr_type "  */
V PAS_COMILER_PRC_00000007(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=31;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+105;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=385; /* line # 385 */
  Rv0=NULL;
  Ra.sl[16]=386; /* line # 386 */
  Rv1=F_ty;
  Ra.sl[16]=388; /* line # 388 */
  P_insymbol();
  Ra.sl[16]=389; /* line # 389 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[16]=391; /* line # 391 */
    Rv2=P_level_search(V_attr_list);
    Ra.sl[16]=392; /* line # 392 */
    if (Rv2==NULL) P_src_error_s(Rd.s+118,105,3, V_sy_ident.s,NULL);
    else {
      Ra.sl[16]=394; /* line # 394 */
      switch (((UB *)Rv2)[54]) {
        case 0:Ra.sl[16]=402; /* line # 402 */
        if (F_lgt==NULL) P_src_error_s(Rd.s+118,161,3, V_sy_ident.s,NULL);
        Ra.sl[16]=403; /* line # 403 */
        P_lgt_new(&Rv0, V_typ_std.v[13],4, F_lgt);
        Ra.sl[16]=404; /* line # 404 */
        F_lgt=NULL;
        break;
        case 1:Ra.sl[16]=408; /* line # 408 */
        if (((SL *)Rv1)[11]>=0) {
          Ra.sl[16]=409; /* line # 409 */
          Rv0=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[11]);
        }
        else {
          Ra.sl[16]=412; /* line # 412 */
          Rv0=P_lgt_type_compute(((V *)Rv1)[8],((V *)Rv1)[9],((SL *)Rv1)[11],F_lgt);
          Ra.sl[16]=413; /* line # 413 */
          if (F_lgt!=NULL) {
            Ra.sl[16]=415; /* line # 415 */
            if (((UB *)F_lgt)[40]!=14) F_lgt=NULL;
          }
        }
        break;
        case 8:
        case 9:Ra.sl[16]=421; /* line # 421 */
        if (P_comp_type(F_ty, V_typ_std.v[10],1,0)) F_ty=((V *)((V *)F_ty)[13])[
5];
        Ra.sl[16]=422; /* line # 422 */
        switch (((UB *)F_ty)[93]) {
          case 8:
          case 9:Ra.sl[16]=425; /* line # 425 */
          Rv3=((V *)F_ty)[15];
          Ra.sl[16]=426; /* line # 426 */
          if (((UB *)Rv3)[93]==22) {
            Ra.sl[16]=428; /* line # 428 */
            if (((UB *)Rv2)[54]==8) Rv0=((V *)Rv3)[13];
            else {
              Ra.sl[16]=429; /* line # 429 */
              Rv0=((V *)Rv3)[14];
            }
            Ra.sl[16]=435; /* line # 435 */
            Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
            Ra.sl[16]=436; /* line # 436 */
            ((V *)Rv0)[3]=((V *)Rv3)[0];
          }
          else {
            Ra.sl[16]=440; /* line # 440 */
            if (((UB *)Rv2)[54]==8) Rv4=((SL *)Rv3)[29];
            else {
              Ra.sl[16]=441; /* line # 441 */
              Rv4=((SL *)Rv3)[30];
            }
            Ra.sl[16]=442; /* line # 442 */
            Rv0=P_lgt_new_econst(((V *)F_ty)[15],Rv4);
          }
          break;
          default:Ra.sl[16]=445; /* line # 445 */
          P_src_error(Rd.s+118,158,3);
          Ra.sl[16]=446; /* line # 446 */
          Rv0=P_lgt_new_econst(V_typ_std.v[15],1);
          break;
        }
        break;
        case 2:
        case 3:Ra.sl[16]=452; /* line # 452 */
        if (((UB *)Rv1)[93]<=2) {
          Ra.sl[16]=453; /* line # 453 */
          if (((UB *)Rv2)[54]==2) Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[29]);
          else {
            Ra.sl[16]=454; /* line # 454 */
            Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[30]);
          }
        }
        else {
          Ra.sl[16]=456; /* line # 456 */
          if (((UB *)Rv1)[93]==22) {
            Ra.sl[16]=458; /* line # 458 */
            if (((UB *)Rv2)[54]==2) Rv0=((V *)Rv1)[13];
            else {
              Ra.sl[16]=459; /* line # 459 */
              Rv0=((V *)Rv1)[14];
            }
            Ra.sl[16]=460; /* line # 460 */
            Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
          }
        }
        break;
        case 4:Ra.sl[16]=464; /* line # 464 */
        if (F_lgt!=NULL) {
          Ra.sl[16]=466; /* line # 466 */
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
          Ra.sl[16]=467; /* line # 467 */
          Rv0=P_exp_genop(11, F_lgt);
          F_lgt=NULL;
        }
        break;
        case 5:Ra.sl[16]=471; /* line # 471 */
        if (F_lgt!=NULL) {
          Ra.sl[16]=473; /* line # 473 */
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
          Ra.sl[16]=474; /* line # 474 */
          Rv0=P_exp_genop(12, F_lgt);
          F_lgt=NULL;
        }
        break;
        case 6:Ra.sl[16]=478; /* line # 478 */
        switch (((UB *)Rv1)[93]) {
          case 1:Ra.sl[16]=480; /* line # 480 */
          if (F_lgt==NULL) {
            Ra.sl[16]=482; /* line # 482 */
            Rv0=P_lgt_link(((V *)Rv1)[13]);
          }
          else {
            Ra.sl[16]=485; /* line # 485 */
            P_lgt_new(&Rv0,((V *)V_ima_typ)[14],1, P_lgt_link(((V *)Rv1)[13]));
            Ra.sl[16]=487; /* line # 487 */
            ((V *)((V *)Rv0)[1])[0]=F_lgt;
            Ra.sl[16]=488; /* line # 488 */
            ((V *)F_lgt)[0]=P_lgt_new_econst(V_int_typ,((SL *)((V *)((V *)Rv1)[13]
            )[3])[25]);
          }
          break;
          case 11:
          case 12:Ra.sl[16]=492; /* line # 492 */
          if (((V *)Rv1)[13]!=NULL) {
            Ra.sl[16]=493; /* line # 493 */
            Rv5=((V *)Rv1)[13];
            Ra.sl[16]=494; /* line # 494 */
            if (F_lgt==NULL) {
              Ra.sl[16]=497; /* line # 497 */
              if (((V *)Rv5)[13]==NULL) {
                Ra.sl[16]=498; /* line # 498 */
                Rv0=P_lgt_link(((V *)Rv5)[13]);
              }
            }
          }
          break;
          default:break;
        }
        break;
        case 7:Ra.sl[16]=506; /* line # 506 */
        if (F_ty==V_typ_std.v[7]) Rv4=0;
        else {
          Ra.sl[16]=508; /* line # 508 */
          if (((UB *)Rv1)[93]==7&&((V *)Rv1)[12]!=NULL) Rv4=((SL *)((V *)Rv1)[12]
          )[11];
          else {
            Ra.sl[16]=509; /* line # 509 */
            Rv4=2147483647;
          }
        }
        Ra.sl[16]=510; /* line # 510 */
        Rv0=P_lgt_new_econst(V_typ_std.v[2],Rv4);
        break;
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:Ra.sl[16]=519; /* line # 519 */
        Ra.sl[16]=522; /* line # 522 */
        Ra.ub[1]=0;
        Ra.sl[16]=523; /* line # 523 */
        switch (((UB *)Rv1)[93]) {
          case 3:Ra.sl[16]=524; /* line # 524 */
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+122,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          case 4:Ra.sl[16]=525; /* line # 525 */
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+131,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          default:break;
        }
        Ra.sl[16]=528; /* line # 528 */
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_STR(Rd.s+140,-1,-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[16]=529; /* line # 529 */
        Rv6=((V *)Rv2)[0];
        Ra.sl[16]=530; /* line # 530 */
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[16]=532; /* line # 532 */
        P_ide_create_name(Ra.s);
        Ra.sl[16]=533; /* line # 533 */
        Rv7=P_lex_search(0);
        Ra.sl[16]=534; /* line # 534 */
        if (Rv7!=NULL) {
          Ra.sl[16]=535; /* line # 535 */
          Rv8=Rv7;
          Ra.sl[16]=536; /* line # 536 */
          if (((UB *)Rv8)[53]==4) {
            Ra.sl[16]=538; /* line # 538 */
            P_lgt_new(&Rv0,((V *)Rv8)[5],14,NULL);
            Ra.sl[16]=539; /* line # 539 */
            Rv9=Rv0;
            Ra.sl[16]=541; /* line # 541 */
            ((V *)Rv9)[7]=((V *)Rv8)[7];
            Ra.sl[16]=542; /* line # 542 */
            P_val_new(((V *)Rv9)+7,((V *)Rv8)[5]);
          }
        }
        Ra.sl[16]=545; /* line # 545 */
        if (Rv0==NULL) {
          Ra.sl[16]=547; /* line # 547 */
          Rv0=P_lgt_new_econst(V_typ_std.v[2],0);
          Ra.sl[16]=548; /* line # 548 */
          P_src_error_s(Rd.s+118,164,2,((V *)Rv2)[0],NULL);
        }
        break;
        case 16:Ra.sl[16]=553; /* line # 553 */
        if (((UB *)Rv1)[93]==11||((UB *)Rv1)[93]==12) {
          Ra.sl[16]=554; /* line # 554 */
          Rv0=P_lgt_new_econst(V_int_typ,((SL *)Rv1)[24]);
        }
        break;
        default:break;
      }
    }
    Ra.sl[16]=558; /* line # 558 */
    P_insymbol();
  }
  else {
    Ra.sl[16]=562; /* line # 562 */
    P_src_error(Rd.s+118,162,2);
  }
  Ra.sl[16]=564; /* line # 564 */
  if (F_lgt!=NULL) P_lgt_free(&F_lgt);
  Ra.sl[16]=565; /* line # 565 */
  if (Rv0!=NULL) Ret=Rv0;
  else {
    Ra.sl[16]=568; /* line # 568 */
    P_src_error(Rd.s+118,169,2);
    Ra.sl[16]=569; /* line # 569 */
    Ret=P_lgt_new_econst(V_typ_std.v[2],1);
  }
  PAS__curr_cntx=Ra.v[5];
  return(Ret);
}


/* Procedure/Function : " build_arg_list "  */
V PAS_COMILER_PRC_00000008(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+148;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=589; /* line # 589 */
  Rv0=F_pr;
  Ra.sl[6]=591; /* line # 591 */
  Rv1=NULL;
  Ra.sl[6]=592; /* line # 592 */
  Rv2=((V *)Rv0)[8];
  Ra.sl[6]=593; /* line # 593 */
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[6]=594; /* line # 594 */
    if (!((UB *)((V *)Rv0)[11])[92]) Rv2=((V *)Rv2)[3];
  }
  Ra.sl[6]=595; /* line # 595 */
  if (Rv2!=NULL) {
    Ra.sl[6]=597; /* line # 597 */
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+166,22,2);
    else {
      Ra.sl[6]=598; /* line # 598 */
      P_insymbol();
    }
    Ra.sl[6]=599; /* line # 599 */
    while (Rv2!=NULL){
      Ra.sl[6]=601; /* line # 601 */
      if (((UB *)Rv2)[53]==7) {
        Ra.sl[6]=603; /* line # 603 */
        Rv3=0;
        Ra.sl[6]=604; /* line # 604 */
        Rv4=((V *)Rv2)[8];
        Ra.sl[6]=605; /* line # 605 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=607; /* line # 607 */
          Rv5=P_ide_search(928);
          Ra.sl[6]=608; /* line # 608 */
          if (Rv5!=V_ide_udptr.v[5]) {
            Ra.sl[6]=611; /* line # 611 */
            Rv6=Rv5;
            Ra.sl[6]=613; /* line # 613 */
            if (((UB *)Rv6)[53]==5) {
              Ra.sl[6]=615; /* line # 615 */
              Rv7=NULL;
              Ra.sl[6]=616; /* line # 616 */
              if (((V *)Rv6)[5]!=NULL) {
                Ra.sl[6]=617; /* line # 617 */
                Rv8=((V *)Rv6)[5];
                Ra.sl[6]=618; /* line # 618 */
                if (((UB *)Rv8)[93]==6) Rv7=((V *)Rv8)[13];
              }
              Ra.sl[6]=619; /* line # 619 */
              if (Rv7!=NULL) {
                Ra.sl[6]=621; /* line # 621 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=622; /* line # 622 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else {
                    Ra.sl[6]=624; /* line # 624 */
                    P_src_error_s(Rd.s+166,120,3, V_sy_ident.s,NULL);
                  }
                }
              }
            }
            else {
              Ra.sl[6]=627; /* line # 627 */
              if (((UB *)Rv6)[53]==7) {
                Ra.sl[6]=629; /* line # 629 */
                Rv7=((V *)Rv6)[8];
                Ra.sl[6]=631; /* line # 631 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=632; /* line # 632 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else {
                    Ra.sl[6]=634; /* line # 634 */
                    P_src_error_s(Rd.s+166,121,3, V_sy_ident.s,NULL);
                  }
                }
              }
              else {
                Ra.sl[6]=638; /* line # 638 */
                Rv9=P_compare_proc_argid(((V *)Rv5)[10],((V *)Rv5)[11],Rv4);
                Ra.sl[6]=643; /* line # 643 */
                Rv9=((V *)Rv5)[10];
                Ra.sl[6]=645; /* line # 645 */
                while (Rv9!=NULL&&!Rv3){
                  Ra.sl[6]=646; /* line # 646 */
                  Rv10=Rv9;
                  Ra.sl[6]=648; /* line # 648 */
                  if (!((UB *)Rv10)[8]) {
                    Ra.sl[6]=650; /* line # 650 */
                    Rv7=((V *)Rv10)[2];
                    Ra.sl[6]=651; /* line # 651 */
                    Rv3=P_comp_proc_arg(Rv7, Rv4);
                  }
                  Ra.sl[6]=653; /* line # 653 */
                  Rv9=((V *)Rv10)[0];
                }
                Ra.sl[6]=655; /* line # 655 */
                if (!Rv3) P_src_error_s(Rd.s+166,122,3, V_sy_ident.s,((V *)Rv2)[
0]);
              }
            }
          }
          Ra.sl[6]=658; /* line # 658 */
          P_insymbol();
        }
        else {
          Ra.sl[6]=662; /* line # 662 */
          Rv7=((V *)Rv2)[7];
          Ra.sl[6]=663; /* line # 663 */
          if (Rv7==NULL) P_src_error_s(Rd.s+166,148,3,((V *)Rv2)[0],NULL);
          else {
            Ra.sl[6]=665; /* line # 665 */
            if (Rv4!=NULL) Rv3=P_comp_proc_arg(Rv7, Rv4);
            else {
              Ra.sl[6]=666; /* line # 666 */
              P_src_error_s(Rd.s+166,123,3,((V *)Rv2)[0],NULL);
            }
          }
        }
        Ra.sl[6]=669; /* line # 669 */
        if (Rv3) {
          Ra.sl[6]=671; /* line # 671 */
          P_lgt_new(&Rv11,((V *)Rv7)[11],11,NULL);
          Ra.sl[6]=672; /* line # 672 */
          ((V *)Rv11)[6]=Rv7;
          Ra.sl[6]=673; /* line # 673 */
          if (((V *)Rv7)[11]!=((V *)Rv4)[11]&&((V *)Rv4)[11]!=NULL) {
            Ra.sl[6]=674; /* line # 674 */
            if (!P_comp_type(((V *)Rv7)[11],((V *)Rv4)[11],1,0)) {
              Ra.sl[6]=675; /* line # 675 */
              P_src_error_s(Rd.s+166,124,3,((V *)Rv5)[0],((V *)Rv2)[0]);
            }
          }
        }
      }
      else {
        Ra.sl[6]=680; /* line # 680 */
        Rv11=PAS_COMILER_PRC_00000005(((V *)Rv2)[5],((UB *)Rv2)[86]!=9,0,0);
        Ra.sl[6]=681; /* line # 681 */
        Rv12=Rv11;
        Ra.sl[6]=682; /* line # 682 */
        if (((UB *)Rv12)[40]==17) {
          Ra.sl[6]=683; /* line # 683 */
          if (((V *)Rv2)[7]==NULL) {
            Ra.sl[6]=685; /* line # 685 */
            P_src_error_s(Rd.s+166,854,3,((V *)Rv2)[0],NULL);
          }
          else {
            Ra.sl[6]=688; /* line # 688 */
            ((UB *)Rv12)[40]=14;
            Ra.sl[6]=689; /* line # 689 */
            ((V *)Rv12)[3]=((V *)Rv2)[5];
            Ra.sl[6]=690; /* line # 690 */
            ((V *)Rv12)[7]=((V *)Rv2)[7];
            Ra.sl[6]=691; /* line # 691 */
            P_val_new(((V *)Rv12)+7,NULL);
            Ra.sl[6]=692; /* line # 692 */
            ((V *)Rv12)[4]=NULL;
          }
        }
      }
      Ra.sl[6]=697; /* line # 697 */
      if (Rv1!=NULL) ((V *)Rv13)[0]=Rv11;
      else {
        Ra.sl[6]=698; /* line # 698 */
        Rv1=Rv11;
      }
      Ra.sl[6]=699; /* line # 699 */
      Rv13=Rv11;
      Ra.sl[6]=701; /* line # 701 */
      Rv2=((V *)Rv2)[3];
      Ra.sl[6]=702; /* line # 702 */
      if (V_sy_sym.ub[0]==17) P_insymbol();
    }
    Ra.sl[6]=704; /* line # 704 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=705; /* line # 705 */
      P_src_error(Rd.s+166,23,3);
    }
  }
  Ra.sl[6]=708; /* line # 708 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_formal_proc "  */
V PAS_COMILER_PRC_00000009(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=724; /* line # 724 */
  Rv0=F_ip;
  Ra.sl[6]=726; /* line # 726 */
  switch (((UB *)Rv0)[53]) {
    case 7:Ra.sl[6]=728; /* line # 728 */
    Rv1=((V *)F_ip)[8];
    break;
    case 8:Ra.sl[6]=731; /* line # 731 */
    Rv1=((V *)((V *)Rv0)[10])[2];
    break;
    default:Ra.sl[6]=734; /* line # 734 */
    Rv1=NULL;
    break;
  }
  Ra.sl[6]=737; /* line # 737 */
  if (Rv1!=NULL) {
    Ra.sl[6]=738; /* line # 738 */
    Ra.sl[6]=740; /* line # 740 */
    Rv2=PAS_COMILER_PRC_00000008(Rv1);
    Ra.sl[6]=741; /* line # 741 */
    Rv2=P_lgt_new_call(((V *)Rv1)[11],Rv1, Rv2);
    Ra.sl[6]=742; /* line # 742 */
    P_call_setting(&Rv2);
  }
  else {
    Ra.sl[6]=746; /* line # 746 */
    P_src_error(Rd.s+190,998,3);
    Ra.sl[6]=747; /* line # 747 */
    Rv2=NULL;
  }
  Ra.sl[6]=749; /* line # 749 */
  if (Rv2==NULL) {
    Ra.sl[6]=751; /* line # 751 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    Ra.sl[6]=753; /* line # 753 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      Ra.sl[6]=755; /* line # 755 */
      P_src_error(Rd.s+190,73,3);
      Ra.sl[6]=756; /* line # 756 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=758; /* line # 758 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_indirect_proc "  */
V PAS_COMILER_PRC_00000010(V F_lge){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=772; /* line # 772 */
  Rv0=NULL;
  Ra.sl[6]=773; /* line # 773 */
  if (F_lge!=NULL) {
    Ra.sl[6]=774; /* line # 774 */
    Rv1=F_lge;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=776; /* line # 776 */
    Rv3=((V *)Rv2)[13];
    Ra.sl[6]=777; /* line # 777 */
    if (Rv3!=NULL) {
      Ra.sl[6]=778; /* line # 778 */
      Rv4=Rv3;
      Ra.sl[6]=780; /* line # 780 */
      ((V *)F_lge)[0]=PAS_COMILER_PRC_00000008(Rv3);
      Ra.sl[6]=781; /* line # 781 */
      P_lgt_new(&Rv0,((V *)Rv4)[11],7, F_lge);
      Ra.sl[6]=782; /* line # 782 */
      Rv5=Rv0;
      Ra.sl[6]=784; /* line # 784 */
      if (((V *)Rv4)[11]!=NULL) {
        Ra.sl[6]=786; /* line # 786 */
        if (!((UB *)((V *)Rv4)[11])[92]) {
          Ra.sl[6]=787; /* line # 787 */
          ((UW *)Rv5)[10]=((UW *)Rv5)[10]|4;
        }
      }
      else {
        Ra.sl[6]=789; /* line # 789 */
        ((V *)Rv0)[3]=V_typ_std.v[28];
      }
      Ra.sl[6]=790; /* line # 790 */
      ((V *)Rv5)[6]=Rv3;
    }
  }
  Ra.sl[6]=794; /* line # 794 */
  if (Rv0==NULL) {
    Ra.sl[6]=795; /* line # 795 */
    Rv0=P_lgt_new_econst(V_typ_std.v[21],0);
  }
  Ra.sl[6]=796; /* line # 796 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_generic "  */
V PAS_COMILER_PRC_00000011(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+214;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=812; /* line # 812 */
  Rv0=NULL;
  Ra.sl[6]=813; /* line # 813 */
  Rv1=0;
  Ra.sl[6]=814; /* line # 814 */
  Ra.sl[6]=817; /* line # 817 */
  if (V_sy_sym.ub[0]==13) {
    while (1){
      Ra.sl[6]=820; /* line # 820 */
      P_insymbol();
      Ra.sl[6]=821; /* line # 821 */
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=823; /* line # 823 */
      if (Rv0==NULL) Rv0=Rv2;
      else((V *)Rv3)[0]=Rv2;
      Ra.sl[6]=824; /* line # 824 */
      Rv3=Rv2;
      Ra.sl[6]=825; /* line # 825 */
      Rv1=Rv1+1;
      Ra.sl[6]=826; /* line # 826 */
      if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
        Ra.sl[6]=827; /* line # 827 */
        P_src_error(Rd.s+230,24,2);
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=829; /* line # 829 */
    P_insymbol();
  }
  Ra.sl[6]=831; /* line # 831 */
  Rv2=P_generate_call(F_ip, Rv0, Rv1,0);
  Ra.sl[6]=833; /* line # 833 */
  if (Rv2==NULL) {
    Ra.sl[6]=835; /* line # 835 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    Ra.sl[6]=837; /* line # 837 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      Ra.sl[6]=839; /* line # 839 */
      P_src_error(Rd.s+230,73,3);
      Ra.sl[6]=840; /* line # 840 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=842; /* line # 842 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " open_call "  */
V PAS_COMILER_PRC_00000012(SL F_ifnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+234;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=863; /* line # 863 */
  Rv0=NULL;
  Ra.sl[6]=864; /* line # 864 */
  Rv1=P_ide_search_from_nameid(V_iof_std_open);
  Ra.sl[6]=865; /* line # 865 */
  if (Rv1!=NULL) {
    Ra.sl[6]=866; /* line # 866 */
    Ra.sl[6]=868; /* line # 868 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[6]=869; /* line # 869 */
      P_src_error(Rd.s+247,22,2);
    }
    Ra.sl[6]=871; /* line # 871 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[16],0,0,0);
    Ra.sl[6]=873; /* line # 873 */
    Rv3=((V *)((V *)Rv2)[3])[12];
    Ra.sl[6]=874; /* line # 874 */
    if (((V *)Rv2)[3]==V_typ_std.v[7]) {
      Ra.sl[6]=875; /* line # 875 */
      Rv4=0;
    }
    else {
      Ra.sl[6]=878; /* line # 878 */
      if (Rv3!=NULL) Rv4=abs(((SL *)Rv3)[11]);
      Ra.sl[6]=879; /* line # 879 */
      if (Rv4==0) Rv4=1;
    }
    Ra.sl[6]=881; /* line # 881 */
    Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv4);
    Ra.sl[6]=882; /* line # 882 */
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=883; /* line # 883 */
    Rv6=2;
    Ra.sl[6]=885; /* line # 885 */
    switch (F_ifnc) {
      case 1:Ra.sl[6]=886; /* line # 886 */
      Rv7=1;
      break;
      case 2:Ra.sl[6]=887; /* line # 887 */
      Rv7=2;
      break;
      case 3:Ra.sl[6]=888; /* line # 888 */
      Rv7=6;
      break;
      default:Ra.sl[6]=890; /* line # 890 */
      Rv7=0;
      break;
    }
    Ra.sl[6]=892; /* line # 892 */
    if (Rv7!=0) {
      Ra.sl[6]=894; /* line # 894 */
      if (V_sy_sym.ub[0]==17) {
        Ra.sl[6]=896; /* line # 896 */
        P_insymbol();
        Ra.sl[6]=898; /* line # 898 */
        Rv8=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=899; /* line # 899 */
        ((V *)Rv5)[0]=Rv8;
        Ra.sl[6]=900; /* line # 900 */
        Rv5=Rv8;
        Ra.sl[6]=901; /* line # 901 */
        Rv6=Rv6+1;
      }
      Ra.sl[6]=903; /* line # 903 */
      Rv8=P_lgt_new_econst(V_typ_std.v[2],Rv7);
      Ra.sl[6]=904; /* line # 904 */
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=905; /* line # 905 */
      Rv5=Rv8;
      Ra.sl[6]=906; /* line # 906 */
      Rv6=Rv6+1;
    }
    Ra.sl[6]=909; /* line # 909 */
    while (V_sy_sym.ub[0]==17){
      Ra.sl[6]=911; /* line # 911 */
      P_insymbol();
      Ra.sl[6]=912; /* line # 912 */
      Rv8=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=913; /* line # 913 */
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=914; /* line # 914 */
      Rv5=Rv8;
      Ra.sl[6]=915; /* line # 915 */
      Rv6=Rv6+1;
    }
    Ra.sl[6]=917; /* line # 917 */
    Rv9=((V *)Rv1)[10];
    Ra.sl[6]=919; /* line # 919 */
    P_generic_search(((V *)Rv1)[0],Rv6, &Rv9, Rv2);
    Ra.sl[6]=920; /* line # 920 */
    if (Rv9!=NULL) {
      Rv10=Rv9;
      Ra.sl[6]=921; /* line # 921 */
      if (((V *)Rv10)[2]!=NULL) {
        Ra.sl[6]=923; /* line # 923 */
        Rv0=P_lgt_new_call(((V *)((V *)Rv10)[2])[11],((V *)Rv10)[2],Rv2);
        Ra.sl[6]=924; /* line # 924 */
        P_call_setting(&Rv0);
      }
    }
    Ra.sl[6]=927; /* line # 927 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=928; /* line # 928 */
      P_src_error(Rd.s+247,23,2);
    }
  }
  Ra.sl[6]=930; /* line # 930 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " readwrite_call "  */
V PAS_COMILER_PRC_00000013(V F_dfi, V F_psel, V F_pio1, V F_pio2, V F_peoln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+251;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=948; /* line # 948 */
  Rv0=NULL;
  Ra.sl[6]=949; /* line # 949 */
  Rv1=NULL;
  Ra.sl[6]=950; /* line # 950 */
  Rv2=0;
  Ra.sl[6]=951; /* line # 951 */
  V_sy_label_flag=0;
  Ra.sl[6]=953; /* line # 953 */
  Ra.sl[6]=955; /* line # 955 */
  Rv3=F_pio1;
  Ra.sl[6]=956; /* line # 956 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=958; /* line # 958 */
    Rv4=0;
    Ra.sl[6]=959; /* line # 959 */
    Rv5=1;
    Ra.sl[6]=960; /* line # 960 */
    Rv2=1;
    Ra.sl[6]=961; /* line # 961 */
    P_insymbol();
    Ra.sl[6]=962; /* line # 962 */
    Rv6=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=963; /* line # 963 */
    if (F_dfi==NULL) {
      Ra.sl[6]=965; /* line # 965 */
      Rv1=Rv6;
      Ra.sl[6]=966; /* line # 966 */
      Rv7=1;
      Ra.sl[6]=967; /* line # 967 */
      if (V_sy_sym.ub[0]==21) {
        Ra.sl[6]=969; /* line # 969 */
        Rv8=Rv1;
        Ra.sl[6]=970; /* line # 970 */
        while (V_sy_sym.ub[0]==21){
          Ra.sl[6]=972; /* line # 972 */
          P_insymbol();
          Ra.sl[6]=973; /* line # 973 */
          Rv9=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=974; /* line # 974 */
          ((V *)Rv8)[0]=Rv9;
          Ra.sl[6]=975; /* line # 975 */
          Rv8=Rv9;
          Ra.sl[6]=976; /* line # 976 */
          Rv7=Rv7+1;
        }
      }
      Ra.sl[6]=979; /* line # 979 */
      if (V_sy_sym.ub[0]==14) {
        Ra.sl[6]=981; /* line # 981 */
        Rv2=0;
        P_insymbol();
      }
      else {
        Ra.sl[6]=983; /* line # 983 */
        if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+269,29,2);
      }
      Ra.sl[6]=984; /* line # 984 */
      Rv5=0;
    }
    else {
      Ra.sl[6]=988; /* line # 988 */
      if (P_comp_type(((V *)Rv6)[3],V_typ_std.v[16],0,0)) {
        Ra.sl[6]=990; /* line # 990 */
        Rv1=Rv6;
        Ra.sl[6]=992; /* line # 992 */
        if (((V *)Rv1)[3]!=V_typ_std.v[7]) Rv3=F_pio2;
        Ra.sl[6]=994; /* line # 994 */
        if (V_sy_sym.ub[0]==14) {
          Ra.sl[6]=995; /* line # 995 */
          Rv2=0;
          P_insymbol();
        }
        else {
          Ra.sl[6]=997; /* line # 997 */
          if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+269,29,2);
        }
        Ra.sl[6]=999; /* line # 999 */
        Rv5=0;
      }
    }
  }
  else {
    Ra.sl[6]=1004; /* line # 1004 */
    if (F_dfi==NULL) P_src_error(Rd.s+269,22,2);
  }
  Ra.sl[6]=1006; /* line # 1006 */
  if (F_psel!=NULL) F_psel=P_ide_search_from_nameid(F_psel);
  Ra.sl[6]=1007; /* line # 1007 */
  if (Rv3!=NULL) Rv3=P_ide_search_from_nameid(Rv3);
  Ra.sl[6]=1008; /* line # 1008 */
  if (F_peoln!=NULL) F_peoln=P_ide_search_from_nameid(F_peoln);
  Ra.sl[6]=1010; /* line # 1010 */
  if (Rv1==NULL) Rv1=P_lgt_new_idref(F_dfi,NULL);
  Ra.sl[6]=1013; /* line # 1013 */
  Rv0=P_exp_genoper(((V *)F_psel)[0],((V *)F_psel)[10],Rv1);
  Ra.sl[6]=1014; /* line # 1014 */
  Rv8=Rv0;
  Ra.sl[6]=1016; /* line # 1016 */
  if (Rv2) {
    Ra.sl[6]=1018; /* line # 1018 */
    while (Rv5||V_sy_sym.ub[0]==17){
      Ra.sl[6]=1020; /* line # 1020 */
      if (!Rv5) {
        Ra.sl[6]=1022; /* line # 1022 */
        P_insymbol();
        Ra.sl[6]=1023; /* line # 1023 */
        Rv6=PAS_COMILER_PRC_00000000();
      }
      else {
        Ra.sl[6]=1025; /* line # 1025 */
        Rv5=0;
      }
      Ra.sl[6]=1026; /* line # 1026 */
      Rv10=NULL;
      Ra.sl[6]=1027; /* line # 1027 */
      Rv7=1;
      Ra.sl[6]=1028; /* line # 1028 */
      while (V_sy_sym.ub[0]==21){
        Ra.sl[6]=1030; /* line # 1030 */
        P_insymbol();
        Ra.sl[6]=1031; /* line # 1031 */
        Rv9=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=1032; /* line # 1032 */
        if (Rv10==NULL) Rv10=Rv9;
        else {
          Ra.sl[6]=1033; /* line # 1033 */
          ((V *)Rv11)[0]=Rv9;
        }
        Ra.sl[6]=1034; /* line # 1034 */
        Rv11=Rv9;
        Ra.sl[6]=1035; /* line # 1035 */
        Rv7=Rv7+1;
      }
      Ra.sl[6]=1037; /* line # 1037 */
      ((V *)Rv6)[0]=Rv10;
      Ra.sl[6]=1038; /* line # 1038 */
      Rv12=((V *)Rv3)[10];
      Ra.sl[6]=1040; /* line # 1040 */
      P_generic_search(((V *)Rv3)[0],Rv7, &Rv12, Rv6);
      Ra.sl[6]=1041; /* line # 1041 */
      if (Rv12!=NULL) {
        Rv13=Rv12;
        Ra.sl[6]=1043; /* line # 1043 */
        if (((V *)Rv13)[2]!=NULL) {
          Ra.sl[6]=1045; /* line # 1045 */
          Rv10=P_lgt_new_call(((V *)((V *)Rv13)[2])[11],((V *)Rv13)[2],Rv6);
          Ra.sl[6]=1046; /* line # 1046 */
          P_call_setting(&Rv10);
        }
        Ra.sl[6]=1048; /* line # 1048 */
        ((V *)Rv8)[0]=Rv10;
        Ra.sl[6]=1049; /* line # 1049 */
        Rv8=Rv10;
      }
    }
    Ra.sl[6]=1052; /* line # 1052 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=1053; /* line # 1053 */
      P_src_error(Rd.s+269,23,2);
    }
  }
  Ra.sl[6]=1057; /* line # 1057 */
  if (F_peoln!=NULL) {
    Ra.sl[6]=1059; /* line # 1059 */
    Rv12=((V *)F_peoln)[10];
    Ra.sl[6]=1061; /* line # 1061 */
    P_generic_search(((V *)F_peoln)[0],0, &Rv12,NULL);
    Ra.sl[6]=1062; /* line # 1062 */
    if (Rv12!=NULL) {
      Rv14=Rv12;
      Ra.sl[6]=1064; /* line # 1064 */
      if (((V *)Rv14)[2]!=NULL) {
        Ra.sl[6]=1066; /* line # 1066 */
        Rv10=P_lgt_new_call(((V *)((V *)Rv14)[2])[11],((V *)Rv14)[2],NULL);
        Ra.sl[6]=1067; /* line # 1067 */
        P_call_setting(&Rv10);
      }
      Ra.sl[6]=1069; /* line # 1069 */
      ((V *)Rv8)[0]=Rv10;
      Ra.sl[6]=1070; /* line # 1070 */
      Rv8=Rv10;
    }
  }
  Ra.sl[6]=1074; /* line # 1074 */
  if (Rv8!=Rv0) {
    Ra.sl[6]=1076; /* line # 1076 */
    P_lgt_new(&Rv0,NULL,0, Rv0);
    Ra.sl[6]=1077; /* line # 1077 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[6]=1079; /* line # 1079 */
  V_sy_label_flag=1;
  Ra.sl[6]=1080; /* line # 1080 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_state_eff_list "  */
V PAS_COMILER_PRC_00000015(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+273;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1104; /* line # 1104 */
  Rv0=NULL;
  Ra.sl[6]=1105; /* line # 1105 */
  Rv1=NULL;
  Ra.sl[6]=1106; /* line # 1106 */
  Lx[0].sl[0]=0;
  Ra.sl[6]=1107; /* line # 1107 */
  Ra.sl[6]=1109; /* line # 1109 */
  V_sy_sym.ub[0]=21;
  Ra.sl[6]=1110; /* line # 1110 */
  while (V_sy_sym.ub[0]==21){
    Ra.sl[6]=1112; /* line # 1112 */
    P_insymbol();
    Ra.sl[6]=1113; /* line # 1113 */
    Rv2=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=1114; /* line # 1114 */
    if (Rv1==NULL) Rv0=Rv2;
    else {
      Ra.sl[6]=1115; /* line # 1115 */
      ((V *)Rv1)[0]=Rv2;
    }
    Ra.sl[6]=1116; /* line # 1116 */
    Rv1=Rv2;
    Ra.sl[6]=1117; /* line # 1117 */
    Lx[0].sl[0]=Lx[0].sl[0]+1;
  }
  Ra.sl[6]=1120; /* line # 1120 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " user_state_call "  */
V PAS_COMILER_PRC_00000014(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  UB Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+293;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=1125; /* line # 1125 */
  Rv0=NULL;
  Ra.sl[8]=1126; /* line # 1126 */
  Rv1=NULL;
  Ra.sl[8]=1127; /* line # 1127 */
  Rv2=NULL;
  Ra.sl[8]=1128; /* line # 1128 */
  Rv3=NULL;
  Ra.sl[8]=1129; /* line # 1129 */
  Rv4=0;
  Ra.sl[8]=1130; /* line # 1130 */
  Rv5=0;
  Ra.sl[8]=1131; /* line # 1131 */
  Rv6=0;
  Ra.sl[8]=1132; /* line # 1132 */
  V_sy_label_flag=0;
  Ra.sl[8]=1133; /* line # 1133 */
  Rv7=((V *)F_ip)[7];
  Ra.sl[8]=1134; /* line # 1134 */
  Ra.sl[8]=1136; /* line # 1136 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[8]=1138; /* line # 1138 */
    Rv4=1;
    Ra.sl[8]=1139; /* line # 1139 */
    Rv3=PAS_COMILER_PRC_00000015();
  }
  Ra.sl[8]=1142; /* line # 1142 */
  while (Rv7!=NULL){
    Ra.sl[8]=1143; /* line # 1143 */
    Rv8=Rv7;
    Ra.sl[8]=1146; /* line # 1146 */
    if (((V *)Rv8)[2]==NULL||Rv3==NULL)  break;
    Ra.sl[8]=1148; /* line # 1148 */
    Rv5=P_comp_type(((V *)Rv3)[3],((V *)Rv8)[2],0,0);
    Ra.sl[8]=1149; /* line # 1149 */
    if (Rv5)  break;
    Ra.sl[8]=1151; /* line # 1151 */
    if (((V *)Rv8)[3]!=NULL)  break;
    Ra.sl[8]=1152; /* line # 1152 */
    Rv7=((V *)Rv8)[0];
  }
  Ra.sl[8]=1155; /* line # 1155 */
  if (Rv7==NULL) {
    Ra.sl[8]=1157; /* line # 1157 */
    P_src_error_s(Rd.s+312,41,3,((V *)F_ip)[0],NULL);
    Ra.sl[8]=1158; /* line # 1158 */
    P_skip_symbol(14,0,0);
    Ra.sl[8]=1159; /* line # 1159 */
    Ret=NULL;
  }
  else {
    Ra.sl[8]=1162; /* line # 1162 */
    Rv9=Rv7;
    Ra.sl[8]=1165; /* line # 1165 */
    if (((V *)Rv9)[4]!=NULL) Rv10=P_ide_search_from_nameid(((V *)Rv9)[4]);
    else {
      Ra.sl[8]=1166; /* line # 1166 */
      Rv10=NULL;
    }
    Ra.sl[8]=1167; /* line # 1167 */
    if (((V *)Rv9)[5]!=NULL) Rv11=P_ide_search_from_nameid(((V *)Rv9)[5]);
    else {
      Ra.sl[8]=1168; /* line # 1168 */
      Rv11=NULL;
    }
    Ra.sl[8]=1169; /* line # 1169 */
    if (((V *)Rv9)[6]!=NULL) Rv12=P_ide_search_from_nameid(((V *)Rv9)[6]);
    else {
      Ra.sl[8]=1170; /* line # 1170 */
      Rv12=NULL;
    }
    Ra.sl[8]=1173; /* line # 1173 */
    if (Rv4&&V_sy_sym.ub[0]==14) {
      Ra.sl[8]=1174; /* line # 1174 */
      P_insymbol();
      Rv4=0;
    }
    Ra.sl[8]=1176; /* line # 1176 */
    if (Rv5) {
      Ra.sl[8]=1178; /* line # 1178 */
      Rv2=Rv3;
      Ra.sl[8]=1179; /* line # 1179 */
      Rv13=Rv2;
      Ra.sl[8]=1180; /* line # 1180 */
      Rv3=NULL;
      Ra.sl[8]=1181; /* line # 1181 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+312,29,2);
    }
    else {
      Ra.sl[8]=1184; /* line # 1184 */
      if (((V *)Rv9)[3]!=NULL) {
        Ra.sl[8]=1186; /* line # 1186 */
        Ra.sl[0]=1;
        Ra.sl[8]=1187; /* line # 1187 */
        if (((UB *)Rv9)[8]) {
          ((UB *)Rv9)[8]=0;
          Rv13=((V *)Rv9)[3];
        }
        else {
          Ra.sl[8]=1188; /* line # 1188 */
          Rv13=P_lgt_link(((V *)Rv9)[3]);
        }
      }
      else {
        Ra.sl[8]=1191; /* line # 1191 */
        Ra.sl[0]=0;
        Rv13=NULL;
      }
    }
    Ra.sl[8]=1193; /* line # 1193 */
    if (Rv10!=NULL) {
      Ra.sl[8]=1195; /* line # 1195 */
      Rv0=P_generate_call(Rv10, Rv13, Ra.sl[0],0);
      Ra.sl[8]=1196; /* line # 1196 */
      Rv1=Rv0;
      Ra.sl[8]=1197; /* line # 1197 */
      if (Rv5) Rv6=1;
    }
    Ra.sl[8]=1201; /* line # 1201 */
    if (Rv4) {
      while (1){
        Ra.sl[8]=1205; /* line # 1205 */
        if (Rv3==NULL) Rv3=PAS_COMILER_PRC_00000015();
        Ra.sl[8]=1206; /* line # 1206 */
        if (((UB *)Rv9)[9]) {
          Ra.sl[8]=1208; /* line # 1208 */
          if (Rv5) {
            Ra.sl[8]=1209; /* line # 1209 */
            if (Rv6) Rv13=P_lgt_link(Rv2);
            else {
              Ra.sl[8]=1210; /* line # 1210 */
              Rv6=1;
              Rv13=Rv2;
            }
          }
          else {
            Ra.sl[8]=1212; /* line # 1212 */
            if (((UB *)Rv9)[8]) {
              ((UB *)Rv9)[8]=0;
              Rv13=((V *)Rv9)[3];
            }
            else {
              Ra.sl[8]=1213; /* line # 1213 */
              Rv13=P_lgt_link(((V *)Rv9)[3]);
            }
          }
          Ra.sl[8]=1214; /* line # 1214 */
          ((V *)Rv13)[0]=Rv3;
          Ra.sl[8]=1215; /* line # 1215 */
          Rv3=Rv13;
        }
        Ra.sl[8]=1218; /* line # 1218 */
        Rv13=P_generate_call(Rv11, Rv3, Ra.sl[0],0);
        Ra.sl[8]=1220; /* line # 1220 */
        if (Rv13!=NULL) {
          Ra.sl[8]=1222; /* line # 1222 */
          if (Rv1==NULL) Rv0=Rv13;
          else {
            Ra.sl[8]=1223; /* line # 1223 */
            ((V *)Rv1)[0]=Rv13;
          }
          Ra.sl[8]=1224; /* line # 1224 */
          Rv1=Rv13;
        }
        Ra.sl[8]=1226; /* line # 1226 */
        Rv3=NULL;
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[8]=1229; /* line # 1229 */
      if (V_sy_sym.ub[0]!=14) {
        Ra.sl[8]=1231; /* line # 1231 */
        P_src_error(Rd.s+312,34,3);
        Ra.sl[8]=1232; /* line # 1232 */
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[8]=1233; /* line # 1233 */
        P_insymbol();
      }
    }
    Ra.sl[8]=1236; /* line # 1236 */
    if (Rv12!=NULL) {
      Ra.sl[8]=1238; /* line # 1238 */
      if (((UB *)Rv9)[9]) {
        Ra.sl[8]=1240; /* line # 1240 */
        Ra.sl[0]=1;
        Ra.sl[8]=1241; /* line # 1241 */
        if (Rv5) {
          Ra.sl[8]=1242; /* line # 1242 */
          if (Rv6) Rv3=P_lgt_link(Rv2);
          else {
            Ra.sl[8]=1243; /* line # 1243 */
            Rv6=1;
            Rv3=Rv2;
          }
        }
        else {
          Ra.sl[8]=1245; /* line # 1245 */
          if (((UB *)Rv9)[8]) {
            ((UB *)Rv9)[8]=0;
            Rv3=((V *)Rv9)[3];
          }
          else {
            Ra.sl[8]=1246; /* line # 1246 */
            Rv3=P_lgt_link(((V *)Rv9)[3]);
          }
        }
      }
      else {
        Ra.sl[8]=1249; /* line # 1249 */
        Ra.sl[0]=0;
        Rv3=NULL;
      }
      Ra.sl[8]=1250; /* line # 1250 */
      Rv13=P_generate_call(Rv12, Rv3, Ra.sl[0],0);
      Ra.sl[8]=1251; /* line # 1251 */
      if (Rv1==NULL) Rv0=Rv13;
      else {
        Ra.sl[8]=1252; /* line # 1252 */
        ((V *)Rv1)[0]=Rv13;
      }
      Ra.sl[8]=1253; /* line # 1253 */
      Rv1=Rv13;
    }
  }
  Ra.sl[8]=1257; /* line # 1257 */
  if (Rv1!=Rv0) {
    Ra.sl[8]=1259; /* line # 1259 */
    P_lgt_new(&Rv0,NULL,0, Rv0);
    Ra.sl[8]=1260; /* line # 1260 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[8]=1263; /* line # 1263 */
  V_sy_label_flag=1;
  Ra.sl[8]=1264; /* line # 1264 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " new_call "  */
V PAS_COMILER_PRC_00000016(V F_new_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  V Rv16;
  V Rv17;
  V Rv18;
  register V Rv19;
  SL Rv20;
  SL Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  register V Rv25;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+316;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1285; /* line # 1285 */
  Rv0=NULL;
  Ra.sl[6]=1286; /* line # 1286 */
  Rv1=NULL;
  Ra.sl[6]=1287; /* line # 1287 */
  Rv2=NULL;
  Ra.sl[6]=1288; /* line # 1288 */
  Rv3=NULL;
  Ra.sl[6]=1289; /* line # 1289 */
  Ra.sl[6]=1291; /* line # 1291 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[6]=1292; /* line # 1292 */
    P_src_error(Rd.s+328,22,2);
  }
  Ra.sl[6]=1294; /* line # 1294 */
  Rv4=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Ra.sl[6]=1295; /* line # 1295 */
  if (Rv4!=NULL) {
    Ra.sl[6]=1296; /* line # 1296 */
    Rv5=Rv4;
    Ra.sl[6]=1297; /* line # 1297 */
    if (2&((UW *)Rv5)[10]) {
      Ra.sl[6]=1298; /* line # 1298 */
      Rv6=((V *)Rv5)[3];
    }
  }
  Ra.sl[6]=1299; /* line # 1299 */
  if (Rv6!=NULL) {
    Ra.sl[6]=1300; /* line # 1300 */
    Rv7=Rv6;
    Ra.sl[6]=1301; /* line # 1301 */
    if (((UB *)Rv7)[93]==5) Rv3=((V *)Rv7)[12];
    else {
      Ra.sl[6]=1302; /* line # 1302 */
      Rv3=NULL;
    }
  }
  Ra.sl[6]=1304; /* line # 1304 */
  if (Rv3!=NULL) {
    Ra.sl[6]=1305; /* line # 1305 */
    Rv8=Rv3;
    Ra.sl[6]=1308; /* line # 1308 */
    if (((V *)Rv8)[4]!=NULL||((UB *)Rv8)[91]) {
      Ra.sl[6]=1310; /* line # 1310 */
      if (((UB *)Rv8)[90]) {
        Ra.sl[6]=1312; /* line # 1312 */
        Rv9=((V *)Rv8)[7];
        Ra.sl[6]=1313; /* line # 1313 */
        Rv10=((V *)((V *)Rv8)[0])[4];
      }
      else {
        Ra.sl[6]=1315; /* line # 1315 */
        Rv10=((V *)Rv8)[4];
      }
      Ra.sl[6]=1317; /* line # 1317 */
      Rv11=Rv10;
      Ra.sl[6]=1318; /* line # 1318 */
      while (Rv11!=NULL){
        Ra.sl[6]=1319; /* line # 1319 */
        Rv12=Rv11;
        Ra.sl[6]=1321; /* line # 1321 */
        if (((UB *)Rv8)[90]) {
          Ra.sl[6]=1323; /* line # 1323 */
          Rv13=Rv9;
          Ra.sl[6]=1324; /* line # 1324 */
          Rv9=((V *)Rv9)[0];
        }
        else {
          Ra.sl[6]=1328; /* line # 1328 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          Ra.sl[6]=1329; /* line # 1329 */
          Rv14=PAS_COMILER_PRC_00000005(((V *)Rv12)[5],0,0,0);
          Ra.sl[6]=1330; /* line # 1330 */
          if (((UB *)Rv14)[40]==17) {
            Ra.sl[6]=1331; /* line # 1331 */
            Rv15=Rv14;
            Ra.sl[6]=1333; /* line # 1333 */
            ((UB *)Rv15)[40]=14;
            Ra.sl[6]=1334; /* line # 1334 */
            ((V *)Rv15)[7]=((V *)Rv12)[10];
            Ra.sl[6]=1335; /* line # 1335 */
            if (((V *)Rv15)[7]==NULL) {
              Ra.sl[6]=1336; /* line # 1336 */
              P_src_error(Rd.s+328,126,3);
            }
            Ra.sl[6]=1337; /* line # 1337 */
            P_val_new(((V *)Rv15)+7,NULL);
            Ra.sl[6]=1338; /* line # 1338 */
            ((V *)Rv15)[4]=NULL;
            Ra.sl[6]=1339; /* line # 1339 */
            ((V *)Rv15)[3]=((V *)Rv12)[5];
          }
          Ra.sl[6]=1342; /* line # 1342 */
          if (((UB *)Rv14)[40]!=14) {
            Ra.sl[6]=1344; /* line # 1344 */
            P_lgt_new(&Rv13,((V *)Rv12)[5],13,NULL);
            Ra.sl[6]=1345; /* line # 1345 */
            ((V *)Rv13)[0]=Rv14;
            Ra.sl[6]=1346; /* line # 1346 */
            P_all_new(((V *)Rv13)+7,((V *)Rv12)[5],NULL,0);
            Ra.sl[6]=1347; /* line # 1347 */
            P_lgt_new(&Rv14,((V *)Rv12)[5],6, Rv13);
            Ra.sl[6]=1348; /* line # 1348 */
            ((UB *)Rv14)[41]=3;
            Ra.sl[6]=1350; /* line # 1350 */
            if (Rv0==NULL) Rv0=Rv14;
            else {
              Ra.sl[6]=1351; /* line # 1351 */
              ((V *)Rv16)[0]=Rv14;
            }
            Ra.sl[6]=1352; /* line # 1352 */
            Rv16=Rv14;
          }
          else {
            Ra.sl[6]=1354; /* line # 1354 */
            Rv13=Rv14;
          }
        }
        Ra.sl[6]=1358; /* line # 1358 */
        ((V *)Rv12)[9]=Rv13;
        ((UB *)Rv12)[60]=2;
        Ra.sl[6]=1360; /* line # 1360 */
        P_lgt_new(&Rv17,((V *)Rv12)[5],2, P_lgt_link(Rv4));
        Ra.sl[6]=1361; /* line # 1361 */
        ((SL *)Rv17)[4]=((SL *)Rv12)[14];
        Ra.sl[6]=1362; /* line # 1362 */
        if (((UB *)Rv13)[40]==14) ((V *)Rv17)[0]=Rv13;
        else {
          Ra.sl[6]=1363; /* line # 1363 */
          ((V *)Rv17)[0]=P_lgt_link(Rv13);
        }
        Ra.sl[6]=1364; /* line # 1364 */
        P_lgt_new(&Rv13,((V *)Rv12)[5],6, Rv17);
        Ra.sl[6]=1365; /* line # 1365 */
        ((UB *)Rv13)[41]=3;
        Ra.sl[6]=1366; /* line # 1366 */
        if (Rv1==NULL) Rv1=Rv13;
        else {
          Ra.sl[6]=1367; /* line # 1367 */
          ((V *)Rv18)[0]=Rv13;
        }
        Ra.sl[6]=1368; /* line # 1368 */
        Rv18=Rv13;
        Ra.sl[6]=1370; /* line # 1370 */
        if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
          Ra.sl[6]=1371; /* line # 1371 */
          P_src_error(Rd.s+328,34,2);
        }
        Ra.sl[6]=1373; /* line # 1373 */
        Rv11=((V *)Rv12)[3];
      }
      Ra.sl[6]=1376; /* line # 1376 */
      Rv14=P_lgt_type_compute(((V *)Rv8)[8],((V *)Rv8)[9],((SL *)Rv8)[11],NULL);
      Ra.sl[6]=1378; /* line # 1378 */
      if (((UB *)Rv8)[91]) P_init_d_dyn(Rv3, Rv4, &Rv1, &Rv18,1,NULL);
      Ra.sl[6]=1380; /* line # 1380 */
      Rv11=Rv10;
      Ra.sl[6]=1381; /* line # 1381 */
      while (Rv11!=NULL){
        Ra.sl[6]=1382; /* line # 1382 */
        Rv19=Rv11;
        Ra.sl[6]=1384; /* line # 1384 */
        ((UB *)Rv19)[60]=0;
        Ra.sl[6]=1385; /* line # 1385 */
        ((V *)Rv19)[9]=NULL;
        Ra.sl[6]=1386; /* line # 1386 */
        Rv11=((V *)Rv19)[3];
      }
      Ra.sl[6]=1390; /* line # 1390 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv14);
      Ra.sl[6]=1393; /* line # 1393 */
      ((V *)Rv4)[0]=Rv2;
      Ra.sl[6]=1394; /* line # 1394 */
      P_lgt_new(&Rv2, Rv6,6, Rv4);
      Ra.sl[6]=1395; /* line # 1395 */
      ((UB *)Rv2)[41]=3;
      Ra.sl[6]=1398; /* line # 1398 */
      if (Rv0==NULL) Rv0=Rv2;
      else {
        Ra.sl[6]=1399; /* line # 1399 */
        ((V *)Rv16)[0]=Rv2;
      }
      Ra.sl[6]=1400; /* line # 1400 */
      ((V *)Rv2)[0]=Rv1;
      Ra.sl[6]=1401; /* line # 1401 */
      P_lgt_new(&Rv1,NULL,0, Rv0);
      Ra.sl[6]=1402; /* line # 1402 */
      ((UB *)Rv1)[41]=2;
    }
    else {
      Ra.sl[6]=1412; /* line # 1412 */
      Rv20=((SL *)Rv8)[11];
      Ra.sl[6]=1413; /* line # 1413 */
      if (Rv20<=0) P_src_error(Rd.s+328,130,3);
      Ra.sl[6]=1414; /* line # 1414 */
      if (((UB *)Rv8)[93]==10) {
        Ra.sl[6]=1416; /* line # 1416 */
        Rv14=((V *)Rv8)[14];
        Ra.sl[6]=1417; /* line # 1417 */
        if (Rv14!=NULL) {
          Ra.sl[6]=1418; /* line # 1418 */
          if (((UB *)Rv14)[40]==16) Rv14=((V *)Rv14)[1];
        }
        Ra.sl[6]=1419; /* line # 1419 */
        while (V_sy_sym.ub[0]==17&&Rv14!=NULL){
          Ra.sl[6]=1421; /* line # 1421 */
          Rv2=((V *)Rv14)[1];
          Ra.sl[6]=1422; /* line # 1422 */
          Rv17=((V *)Rv2)[0];
          Ra.sl[6]=1423; /* line # 1423 */
          P_insymbol();
          Ra.sl[6]=1425; /* line # 1425 */
          Rv13=PAS_COMILER_PRC_00000005(((V *)((V *)Rv17)[0])[3],0,0,0);
          Ra.sl[6]=1426; /* line # 1426 */
          Rv21=-1;
          Ra.sl[6]=1427; /* line # 1427 */
          Rv22=Rv13;
          Ra.sl[6]=1429; /* line # 1429 */
          if (((UB *)Rv22)[40]==14) {
            Ra.sl[6]=1430; /* line # 1430 */
            Rv21=((SL *)((V *)Rv22)[7])[13];
          }
          else {
            Ra.sl[6]=1432; /* line # 1432 */
            P_src_error(Rd.s+328,181,2);
          }
          Ra.sl[6]=1433; /* line # 1433 */
          P_lgt_free_tree(&Rv13);
          Ra.sl[6]=1435; /* line # 1435 */
          Rv23=Rv2;
          Rv24=((V *)Rv23)[7];
          Ra.sl[6]=1437; /* line # 1437 */
          Rv21=Rv21-((SL *)Rv23)[4];
          Ra.sl[6]=1438; /* line # 1438 */
          if (Rv21>=0&&Rv21<((SL *)Rv24)[6]) {
            Ra.sl[6]=1440; /* line # 1440 */
            Rv21=((SL *)((V *)((V *)Rv2)[7])[7])[Rv21];
            Ra.sl[6]=1441; /* line # 1441 */
            if (Rv21>=0) {
              Ra.sl[6]=1442; /* line # 1442 */
              Rv17=((V *)((V *)Rv17)[0])[0];
            }
            Ra.sl[6]=1443; /* line # 1443 */
            while (Rv21>0&&Rv17!=NULL){
              Ra.sl[6]=1445; /* line # 1445 */
              Rv21=Rv21-1;
              Ra.sl[6]=1446; /* line # 1446 */
              Rv17=((V *)Rv17)[0];
            }
            Ra.sl[6]=1448; /* line # 1448 */
            if (Rv17==NULL) Rv17=((V *)Rv2)[0];
          }
          Ra.sl[6]=1451; /* line # 1451 */
          Rv25=((V *)Rv17)[3];
          Ra.sl[6]=1453; /* line # 1453 */
          Rv14=((V *)Rv25)[14];
          Ra.sl[6]=1454; /* line # 1454 */
          Rv20=((SL *)Rv25)[11];
        }
      }
      Ra.sl[6]=1459; /* line # 1459 */
      P_lgt_new(&Rv1, Rv6,6, Rv4);
      Ra.sl[6]=1460; /* line # 1460 */
      ((UB *)Rv1)[41]=3;
      Ra.sl[6]=1461; /* line # 1461 */
      Rv14=P_lgt_new_econst(V_typ_std.v[2],Rv20);
      Ra.sl[6]=1463; /* line # 1463 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv14);
      Ra.sl[6]=1464; /* line # 1464 */
      ((V *)Rv4)[0]=Rv2;
    }
  }
  else {
    Ra.sl[6]=1469; /* line # 1469 */
    P_lgt_free_tree(&Rv4);
    Ra.sl[6]=1470; /* line # 1470 */
    P_src_error(Rd.s+328,180,3);
  }
  Ra.sl[6]=1473; /* line # 1473 */
  if (V_sy_sym.ub[0]==14) {
    Ra.sl[6]=1474; /* line # 1474 */
    P_insymbol();
  }
  else {
    Ra.sl[6]=1477; /* line # 1477 */
    P_src_error(Rd.s+328,23,2);
    Ra.sl[6]=1478; /* line # 1478 */
    P_skip_symbol(14,0,0);
  }
  Ra.sl[6]=1481; /* line # 1481 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dispose_call "  */
V PAS_COMILER_PRC_00000017(V F_free_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+332;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1494; /* line # 1494 */
  Ra.sl[6]=1496; /* line # 1496 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[6]=1497; /* line # 1497 */
    P_src_error(Rd.s+348,22,2);
  }
  Ra.sl[6]=1499; /* line # 1499 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Ra.sl[6]=1500; /* line # 1500 */
  Rv1=P_lgt_new_call(NULL,F_free_fnc, Rv0);
  Ra.sl[6]=1501; /* line # 1501 */
  if (V_sy_sym.ub[0]==17) P_skip_symbol(14,0,0);
  Ra.sl[6]=1502; /* line # 1502 */
  if (V_sy_sym.ub[0]==14) P_insymbol();
  else {
    Ra.sl[6]=1503; /* line # 1503 */
    P_src_error(Rd.s+348,23,2);
    Ra.sl[6]=1504; /* line # 1504 */
    P_skip_symbol(14,0,0);
  }
  Ra.sl[6]=1507; /* line # 1507 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_set "  */
V PAS_COMILER_PRC_00000018(V F_ty, UB F_bcte){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  UL Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+352;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1527; /* line # 1527 */
  Rv0=1;
  Ra.sl[6]=1528; /* line # 1528 */
  P_insymbol();
  Ra.sl[6]=1529; /* line # 1529 */
  Ra.sl[6]=1530; /* line # 1530 */
  if (V_sy_sym.ub[0]==16) {
    Ra.sl[6]=1532; /* line # 1532 */
    P_lgt_new(&Rv1, V_typ_std.v[19],14,NULL);
    Ra.sl[6]=1533; /* line # 1533 */
    if (F_ty!=NULL) ((V *)Rv1)[3]=F_ty;
    Ra.sl[6]=1534; /* line # 1534 */
    P_val_new(((V *)Rv1)+7,((V *)Rv1)[3]);
    Ra.sl[6]=1535; /* line # 1535 */
    Rv2=((V *)Rv1)[7];
    Ra.sl[6]=1537; /* line # 1537 */
    ((SL *)Rv2)[6]=0;
    Ra.sl[6]=1538; /* line # 1538 */
    ((UL *)Rv2)[13]=0;
  }
  else {
    Ra.sl[6]=1543; /* line # 1543 */
    Rv1=NULL;
    Ra.sl[6]=1544; /* line # 1544 */
    Rv3=NULL;
    Ra.sl[6]=1545; /* line # 1545 */
    Rv4=NULL;
    Ra.sl[6]=1546; /* line # 1546 */
    Rv5=0;
    Ra.sl[6]=1547; /* line # 1547 */
    Rv6=-1;
    Ra.sl[6]=1548; /* line # 1548 */
    Rv7=0;
    for( Rf0=(V_dst_seti-1)+1;Rf0>0;Rf0-- ) {
      Ra.ul[Rv7+7]=0;
      Rv7++;
    }
    Ra.sl[6]=1549; /* line # 1549 */
    Rv8=F_ty;
    Ra.sl[6]=1550; /* line # 1550 */
    Rv9=NULL;
    Ra.sl[6]=1551; /* line # 1551 */
    if (F_ty!=NULL) {
      Ra.sl[6]=1552; /* line # 1552 */
      Rv10=F_ty;
      Ra.sl[6]=1554; /* line # 1554 */
      Rv9=((V *)Rv10)[13];
      Ra.sl[6]=1555; /* line # 1555 */
      Rv11=((SL *)Rv10)[24];
    }
    while (1){
      Ra.sl[6]=1560; /* line # 1560 */
      if (Rv0) Rv0=0;
      else {
        Ra.sl[6]=1561; /* line # 1561 */
        P_insymbol();
      }
      Ra.sl[6]=1563; /* line # 1563 */
      if (Rv9==NULL) {
        Ra.sl[6]=1566; /* line # 1566 */
        Rv12=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
        Ra.sl[6]=1567; /* line # 1567 */
        if (((UB *)Rv12)[40]==17) {
          Ra.sl[6]=1569; /* line # 1569 */
          P_src_error(Rd.s+376,137,2);
          Ra.sl[6]=1570; /* line # 1570 */
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1574; /* line # 1574 */
          Rv9=((V *)Rv12)[3];
          Ra.sl[6]=1575; /* line # 1575 */
          if (Rv9!=NULL) {
            Ra.sl[6]=1577; /* line # 1577 */
            Rv11=-1;
            Ra.sl[6]=1578; /* line # 1578 */
            while (Rv9!=NULL&&Rv11<0){
              Ra.sl[6]=1579; /* line # 1579 */
              switch (((UB *)Rv9)[93]) {
                case 0:
                case 1:
                case 2:Ra.sl[6]=1580; /* line # 1580 */
                Rv11=((SL *)Rv9)[30];
                break;
                case 22:Ra.sl[6]=1581; /* line # 1581 */
                Rv9=((V *)Rv9)[0];
                break;
                default:Ra.sl[6]=1583; /* line # 1583 */
                P_src_error(Rd.s+376,110,2);
                Ra.sl[6]=1584; /* line # 1584 */
                Rv9=V_typ_std.v[2];
                Ra.sl[6]=1585; /* line # 1585 */
                Rv11=0;
                break;
              }
            }
            Ra.sl[6]=1587; /* line # 1587 */
            if (Rv11<0) P_src_error(Rd.s+376,110,2);
            else {
              Ra.sl[6]=1590; /* line # 1590 */
              if (Rv11>=V_dst_seta) Rv11=V_dst_seta-1;
            }
          }
          Ra.sl[6]=1592; /* line # 1592 */
          if (Rv11<0) Rv9=NULL;
          Ra.sl[6]=1595; /* line # 1595 */
          if (F_ty==NULL&&Rv9!=NULL) {
            Ra.sl[6]=1597; /* line # 1597 */
            if (Rv11<V_dst_setw) P_ide_new_typ(11, &Rv8);
            else {
              Ra.sl[6]=1598; /* line # 1598 */
              P_ide_new_typ(12, &Rv8);
            }
            Ra.sl[6]=1599; /* line # 1599 */
            Rv13=Rv8;
            Ra.sl[6]=1601; /* line # 1601 */
            ((V *)Rv13)[13]=Rv9;
            Ra.sl[6]=1602; /* line # 1602 */
            ((SL *)Rv13)[24]=Rv11+1;
            Ra.sl[6]=1603; /* line # 1603 */
            if (Rv11<V_dst_setw) {
              Ra.sl[6]=1604; /* line # 1604 */
              memcpy(Rv13+48,V_typ_std.v[17]+48,1);
            }
            else {
              Ra.sl[6]=1606; /* line # 1606 */
              memcpy(Rv13+48,V_typ_std.v[18]+48,1);
            }
            Ra.sl[6]=1608; /* line # 1608 */
            Rv14=((((SL *)Rv13)[24]+V_dst_setw)-1)/V_dst_setw;
            Ra.sl[6]=1610; /* line # 1610 */
            ((SL *)Rv13)[11]=(Rv14*V_dst_setw+7)/8;
          }
        }
      }
      else {
        Ra.sl[6]=1616; /* line # 1616 */
        Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
      }
      Ra.sl[6]=1618; /* line # 1618 */
      if (((UB *)Rv12)[40]==14) {
        Ra.sl[6]=1620; /* line # 1620 */
        Rv5=1;
        Ra.sl[6]=1621; /* line # 1621 */
        Rv14=P_lgt_get_econst(Rv12,-1);
        Ra.sl[6]=1622; /* line # 1622 */
        P_lgt_free(&Rv12);
        Ra.sl[6]=1623; /* line # 1623 */
        if (V_sy_sym.ub[0]==20) {
          Ra.sl[6]=1625; /* line # 1625 */
          P_insymbol();
          Ra.sl[6]=1626; /* line # 1626 */
          Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
          Ra.sl[6]=1627; /* line # 1627 */
          if (((UB *)Rv12)[40]!=14) {
            Ra.sl[6]=1629; /* line # 1629 */
            P_src_error(Rd.s+376,53,2);
            Ra.sl[6]=1630; /* line # 1630 */
            Rv15=Rv14;
          }
          else {
            Ra.sl[6]=1632; /* line # 1632 */
            Rv15=P_lgt_get_econst(Rv12, Rv14);
          }
          Ra.sl[6]=1633; /* line # 1633 */
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1634; /* line # 1634 */
          Rv15=Rv14;
        }
        Ra.sl[6]=1635; /* line # 1635 */
        if (((Rv14<0||Rv14>Rv11)||Rv15<Rv14)||Rv15>Rv11) {
          Ra.sl[6]=1637; /* line # 1637 */
          P_src_error(Rd.s+376,138,2);
          Ra.sl[6]=1638; /* line # 1638 */
          Rv15=Rv14-1;
        }
        Ra.sl[6]=1640; /* line # 1640 */
        Rv16=Rv14;
        for( Rf0=(Rv15+1)-Rv14;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1642; /* line # 1642 */
          if (Rv16>Rv6) Rv6=Rv16;
          Ra.sl[6]=1643; /* line # 1643 */
          Rv17=Rv16/V_dst_setw;
          Ra.sl[6]=1644; /* line # 1644 */
          Rv18=Rv16%V_dst_setw;
          Ra.sl[6]=1645; /* line # 1645 */
          if (1<<Rv18&Ra.ul[Rv17+7]) P_src_error(Rd.s+376,139,2);
          else {
            Ra.sl[6]=1646; /* line # 1646 */
            Ra.ul[Rv17+7]=Ra.ul[Rv17+7]|1<<Rv18;
          }
          Rv16++;
        }
      }
      else {
        Ra.sl[6]=1649; /* line # 1649 */
        if (((UB *)Rv12)[40]!=17) {
          Ra.sl[6]=1651; /* line # 1651 */
          if (F_bcte) P_src_error(Rd.s+376,140,3);
          Ra.sl[6]=1652; /* line # 1652 */
          if (((UB *)Rv8)[92]) {
            Ra.sl[6]=1654; /* line # 1654 */
            Rv12=P_lgt_new_code(16, Rv12);
            Ra.sl[6]=1655; /* line # 1655 */
            ((V *)Rv12)[3]=Rv8;
            Ra.sl[6]=1656; /* line # 1656 */
            if (Rv1!=NULL) {
              Ra.sl[6]=1658; /* line # 1658 */
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1659; /* line # 1659 */
              Rv1=P_lgt_new_code(14, Rv1);
              Ra.sl[6]=1660; /* line # 1660 */
              ((V *)Rv1)[3]=Rv8;
            }
            else {
              Ra.sl[6]=1662; /* line # 1662 */
              Rv1=Rv12;
            }
          }
          else {
            Ra.sl[6]=1666; /* line # 1666 */
            Rv12=P_lgt_new_call(Rv8, V_set_entry_proc, Rv12);
            Ra.sl[6]=1667; /* line # 1667 */
            P_call_setting(&Rv12);
            Ra.sl[6]=1668; /* line # 1668 */
            if (Rv1!=NULL) {
              Ra.sl[6]=1670; /* line # 1670 */
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1671; /* line # 1671 */
              Rv1=P_exp_genop(11, Rv1);
              Ra.sl[6]=1672; /* line # 1672 */
              ((V *)Rv1)[3]=Rv8;
            }
            else {
              Ra.sl[6]=1674; /* line # 1674 */
              Rv1=Rv12;
            }
          }
        }
        else {
          Ra.sl[6]=1679; /* line # 1679 */
          P_src_error(Rd.s+376,141,2);
          Ra.sl[6]=1680; /* line # 1680 */
          P_lgt_free(&Rv12);
        }
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=1684; /* line # 1684 */
    if (Rv5) {
      Ra.sl[6]=1686; /* line # 1686 */
      if ((Rv1==NULL&&Rv8!=NULL)&&F_ty==NULL) {
        Ra.sl[6]=1687; /* line # 1687 */
        Rv19=Rv8;
        Ra.sl[6]=1689; /* line # 1689 */
        ((SL *)Rv19)[24]=Rv6+1;
        Ra.sl[6]=1690; /* line # 1690 */
        Rv11=Rv6;
        Ra.sl[6]=1691; /* line # 1691 */
        if (Rv6>=V_dst_setw) {
          Ra.sl[6]=1693; /* line # 1693 */
          ((UB *)Rv19)[92]=0;
          Ra.sl[6]=1694; /* line # 1694 */
          ((UB *)Rv19)[93]=12;
          Ra.sl[6]=1695; /* line # 1695 */
          ((SL *)Rv19)[11]=(((((SL *)Rv19)[24]+V_dst_setw)-1)/V_dst_setw)*((SL *)
          V_typ_std.v[17])[11];
          Ra.sl[6]=1697; /* line # 1697 */
          ((UB *)Rv19)[48]=((UB *)V_typ_std.v[18])[48];
        }
        else {
          Ra.sl[6]=1701; /* line # 1701 */
          ((UB *)Rv19)[92]=1;
          Ra.sl[6]=1702; /* line # 1702 */
          ((UB *)Rv19)[93]=11;
          Ra.sl[6]=1703; /* line # 1703 */
          ((SL *)Rv19)[11]=(((SL *)Rv19)[24]+7)/8;
          Ra.sl[6]=1704; /* line # 1704 */
          switch (((SL *)Rv19)[11]) {
            case 1:Ra.sl[6]=1705; /* line # 1705 */
            ((UB *)Rv19)[48]=0;
            break;
            case 2:Ra.sl[6]=1706; /* line # 1706 */
            ((UB *)Rv19)[48]=1;
            break;
            default:Ra.sl[6]=1708; /* line # 1708 */
            ((SL *)Rv19)[11]=4;
            Ra.sl[6]=1709; /* line # 1709 */
            ((UB *)Rv19)[48]=((UB *)V_typ_std.v[17])[48];
            break;
          }
        }
      }
      Ra.sl[6]=1714; /* line # 1714 */
      if (Rv11<V_dst_setw) {
        Ra.sl[6]=1716; /* line # 1716 */
        Rv12=P_lgt_new_econst(Rv8, Ra.sl[7]);
      }
      else {
        Ra.sl[6]=1720; /* line # 1720 */
        P_lgt_new(&Rv12, Rv8,14,NULL);
        Ra.sl[6]=1721; /* line # 1721 */
        P_val_new(((V *)Rv12)+7,Rv8);
        Ra.sl[6]=1722; /* line # 1722 */
        Rv20=((V *)Rv12)[7];
        Ra.sl[6]=1724; /* line # 1724 */
        ((V *)Rv20)[7]=PAS__NEW(32);
        Ra.sl[6]=1725; /* line # 1725 */
        ((SL *)Rv20)[6]=(Rv6+V_dst_setw)/V_dst_setw;
        Ra.sl[6]=1726; /* line # 1726 */
        Rv21=0;
        for( Rf0=(((SL *)Rv20)[6]-1)+1;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1727; /* line # 1727 */
          ((SL *)((V *)Rv20)[7])[Rv21]=Ra.sl[Rv21+7];
          Rv21++;
        }
      }
    }
    Ra.sl[6]=1732; /* line # 1732 */
    if (Rv6>=0) {
      Ra.sl[6]=1733; /* line # 1733 */
      if (Rv1==NULL) {
        Ra.sl[6]=1734; /* line # 1734 */
        Rv1=Rv12;
      }
      else {
        Ra.sl[6]=1737; /* line # 1737 */
        ((V *)Rv12)[0]=Rv1;
        Ra.sl[6]=1738; /* line # 1738 */
        Rv1=P_exp_genop(11, Rv12);
        Ra.sl[6]=1739; /* line # 1739 */
        ((V *)Rv1)[3]=Rv8;
      }
    }
  }
  Ra.sl[6]=1742; /* line # 1742 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_tab "  */
void PAS_COMILER_PRC_00000020(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+380;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1774; /* line # 1774 */
  Ra.sl[6]=1776; /* line # 1776 */
  Rv0=F_ty;
  Ra.sl[6]=1778; /* line # 1778 */
  Rv1=((V *)Rv0)[15];
  Ra.sl[6]=1779; /* line # 1779 */
  Rv2=((V *)Rv0)[14];
  Ra.sl[6]=1782; /* line # 1782 */
  if (Rv1!=NULL) {
    Ra.sl[6]=1783; /* line # 1783 */
    Rv3=Rv1;
    Ra.sl[6]=1784; /* line # 1784 */
    if (((UB *)Rv3)[93]!=22) {
      Ra.sl[6]=1785; /* line # 1785 */
      if (((UB *)Rv3)[112]) {
        Ra.sl[6]=1786; /* line # 1786 */
        Lx[1].sl[0]=(((UL *)Rv3)[30]+1)-((UL *)Rv3)[29];
      }
      else {
        Ra.sl[6]=1788; /* line # 1788 */
        Lx[1].sl[0]=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1791; /* line # 1791 */
      Rv4=P_lgt_type_eval(((V *)Rv3)[12],NULL,NULL,0);
      Ra.sl[6]=1792; /* line # 1792 */
      if (((UB *)Rv4)[40]==14) {
        Ra.sl[6]=1794; /* line # 1794 */
        Lx[1].sl[0]=((SL *)((V *)Rv4)[7])[13];
        Ra.sl[6]=1795; /* line # 1795 */
        P_lgt_free(&Rv4);
      }
      else {
        Ra.sl[6]=1797; /* line # 1797 */
        P_src_error(Rd.s+404,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1799; /* line # 1799 */
    Lx[1].sl[0]=0;
  }
  Ra.sl[6]=1800; /* line # 1800 */
  Rv5=F_ty;
  Ra.sl[6]=1801; /* line # 1801 */
  if (((V *)Rv5)[13]!=NULL) {
    Ra.sl[6]=1803; /* line # 1803 */
    Rv4=P_lgt_type_eval(((V *)Rv5)[13],NULL,NULL,0);
    Ra.sl[6]=1804; /* line # 1804 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=1806; /* line # 1806 */
      Lx[1].sl[1]=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=1807; /* line # 1807 */
      P_lgt_free(&Rv4);
    }
    else {
      Ra.sl[6]=1809; /* line # 1809 */
      P_src_error(Rd.s+404,142,4);
    }
  }
  else {
    Ra.sl[6]=1811; /* line # 1811 */
    Lx[1].sl[1]=((SL *)Rv5)[25];
  }
  Ra.sl[6]=1813; /* line # 1813 */
  if (Rv2==NULL) Lx[1].sl[0]=0;
  Ra.sl[6]=1815; /* line # 1815 */
  Rv6=0;
  Ra.sl[6]=1816; /* line # 1816 */
  V_sy_sym.ub[0]=17;
  Ra.sl[6]=1817; /* line # 1817 */
  while (Rv6<Lx[1].sl[0]&&V_sy_sym.ub[0]==17){
    Ra.sl[6]=1819; /* line # 1819 */
    P_insymbol();
    Ra.sl[6]=1820; /* line # 1820 */
    Rv6=Rv6+1;
    Ra.sl[6]=1821; /* line # 1821 */
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1823; /* line # 1823 */
      Rv4=PAS_COMILER_PRC_00000019(((V *)F_ty)[14]);
    }
    else {
      Ra.sl[6]=1825; /* line # 1825 */
      Rv4=PAS_COMILER_PRC_00000005(((V *)F_ty)[14],0,0,0);
    }
    Ra.sl[6]=1826; /* line # 1826 */
    if (((UB *)Rv4)[40]!=14) Lx[1].ub[8]=0;
    Ra.sl[6]=1828; /* line # 1828 */
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv4;
    else {
      Ra.sl[6]=1829; /* line # 1829 */
      ((V *)Lx[1].v[3])[0]=Rv4;
    }
    Ra.sl[6]=1830; /* line # 1830 */
    Lx[1].v[3]=Rv4;
  }
  Ra.sl[6]=1832; /* line # 1832 */
  if (Rv6<Lx[1].sl[0]) {
    Ra.sl[6]=1833; /* line # 1833 */
    P_src_error(Rd.s+404,144,3);
  }
  else {
    Ra.sl[6]=1835; /* line # 1835 */
    if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
      Ra.sl[6]=1837; /* line # 1837 */
      P_src_error(Rd.s+404,146,2);
      Ra.sl[6]=1838; /* line # 1838 */
      P_skip_symbol(Lx[1].ub[32],0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_list_agregat_rec "  */
void PAS_COMILER_PRC_00000021(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+408;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1857; /* line # 1857 */
  Rv0=F_ty;
  Ra.sl[6]=1859; /* line # 1859 */
  V_sy_sym.ub[0]=17;
  Ra.sl[6]=1860; /* line # 1860 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1862; /* line # 1862 */
  while (V_sy_sym.ub[0]==17&&Rv1!=NULL){
    Ra.sl[6]=1864; /* line # 1864 */
    P_insymbol();
    Ra.sl[6]=1865; /* line # 1865 */
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1867; /* line # 1867 */
      Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
    }
    else {
      Ra.sl[6]=1870; /* line # 1870 */
      Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[5],0,0,0);
    }
    Ra.sl[6]=1872; /* line # 1872 */
    if (((UB *)Rv2)[40]!=14) Lx[1].ub[8]=0;
    Ra.sl[6]=1874; /* line # 1874 */
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
    else {
      Ra.sl[6]=1875; /* line # 1875 */
      ((V *)Lx[1].v[3])[0]=Rv2;
    }
    Ra.sl[6]=1876; /* line # 1876 */
    Lx[1].v[3]=Rv2;
    Ra.sl[6]=1877; /* line # 1877 */
    if (Rv1==((V *)Rv0)[13]) Rv1=NULL;
    else {
      Ra.sl[6]=1878; /* line # 1878 */
      Rv1=((V *)Rv1)[3];
    }
  }
  Ra.sl[6]=1882; /* line # 1882 */
  Rv3=((V *)Rv0)[14];
  Ra.sl[6]=1883; /* line # 1883 */
  if (Rv3!=NULL) {
    Ra.sl[6]=1884; /* line # 1884 */
    if (((UB *)Rv3)[40]==16) Rv3=((V *)Rv3)[1];
  }
  Ra.sl[6]=1886; /* line # 1886 */
  if (Rv3==NULL) {
    Ra.sl[6]=1888; /* line # 1888 */
    if (Rv1!=NULL) {
      Ra.sl[6]=1889; /* line # 1889 */
      P_src_error(Rd.s+432,144,3);
    }
    else {
      Ra.sl[6]=1891; /* line # 1891 */
      if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
        Ra.sl[6]=1893; /* line # 1893 */
        P_src_error(Rd.s+432,146,2);
        Ra.sl[6]=1894; /* line # 1894 */
        P_skip_symbol(Lx[1].ub[32],0,0);
      }
    }
    Ra.sl[6]=1896; /* line # 1896 */
    goto Ret_Label;
  }
  Ra.sl[6]=1899; /* line # 1899 */
  Rv4=Rv3;
  Ra.sl[6]=1901; /* line # 1901 */
  Rv5=((V *)Rv4)[1];
  Ra.sl[6]=1902; /* line # 1902 */
  Rv6=((V *)Rv5)[0];
  Ra.sl[6]=1903; /* line # 1903 */
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1904; /* line # 1904 */
  Rv8=Rv5;
  Ra.sl[6]=1906; /* line # 1906 */
  Rv9=((SL *)Rv8)[4];
  Ra.sl[6]=1907; /* line # 1907 */
  if (((V *)Rv8)[7]!=NULL) {
    Ra.sl[6]=1908; /* line # 1908 */
    Rv10=((V *)Rv8)[7];
    Ra.sl[6]=1910; /* line # 1910 */
    Rv11=(((SL *)Rv10)[6]+Rv9)-1;
    Ra.sl[6]=1911; /* line # 1911 */
    Rv12=((V *)Rv10)[7];
  }
  else {
    Ra.sl[6]=1913; /* line # 1913 */
    Rv12=NULL;
  }
  Ra.sl[6]=1915; /* line # 1915 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1917; /* line # 1917 */
    Rv2=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1918; /* line # 1918 */
    Rv13=Rv2;
    Ra.sl[6]=1919; /* line # 1919 */
    if (((UB *)Rv13)[40]!=14) P_src_error(Rd.s+432,142,3);
    else {
      Ra.sl[6]=1921; /* line # 1921 */
      if (((V *)Rv13)[7]!=NULL) Rv14=((SL *)((V *)Rv13)[7])[13];
      else {
        Ra.sl[6]=1922; /* line # 1922 */
        Rv14=Rv9-1;
      }
    }
    Ra.sl[6]=1923; /* line # 1923 */
    P_lgt_free(&Rv2);
  }
  else {
    Ra.sl[6]=1927; /* line # 1927 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else {
      Ra.sl[6]=1928; /* line # 1928 */
      P_src_error(Rd.s+432,29,3);
    }
    Ra.sl[6]=1930; /* line # 1930 */
    Rv14=PAS_COMILER_PRC_00000006(((V *)Rv7)+3);
    Ra.sl[6]=1931; /* line # 1931 */
    if (((V *)Rv7)[4]!=NULL) {
      Ra.sl[6]=1933; /* line # 1933 */
      Rv15=((SL *)((V *)Rv7)[4])[14];
      Ra.sl[6]=1934; /* line # 1934 */
      Rv2=P_lgt_new_econst(((V *)Rv7)[3],Rv14);
      Ra.sl[6]=1936; /* line # 1936 */
      ((SL *)Rv2)[4]=Rv15;
      Ra.sl[6]=1938; /* line # 1938 */
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
      else {
        Ra.sl[6]=1939; /* line # 1939 */
        ((V *)Lx[1].v[3])[0]=Rv2;
      }
      Ra.sl[6]=1940; /* line # 1940 */
      Lx[1].v[3]=Rv2;
    }
  }
  Ra.sl[6]=1944; /* line # 1944 */
  Rv16=((V *)Rv7)[0];
  Ra.sl[6]=1945; /* line # 1945 */
  if (Rv14<Rv9||Rv14>Rv11) {
    Ra.sl[6]=1946; /* line # 1946 */
    Rv16=Rv6;
  }
  else {
    Ra.sl[6]=1949; /* line # 1949 */
    Rv14=((SL *)Rv12)[(Rv14-Rv9)];
    Ra.sl[6]=1950; /* line # 1950 */
    if (Rv14<0) Rv16=Rv6;
    else {
      Ra.sl[6]=1953; /* line # 1953 */
      while (Rv14>0&&Rv16!=NULL){
        Ra.sl[6]=1955; /* line # 1955 */
        Rv16=((V *)Rv16)[0];
        Rv14=Rv14-1;
      }
      Ra.sl[6]=1957; /* line # 1957 */
      if (Rv16==NULL) Rv16=Rv6;
    }
  }
  Ra.sl[6]=1960; /* line # 1960 */
  if (Rv16!=NULL) {
    Ra.sl[6]=1961; /* line # 1961 */
    if (((V *)Rv16)[3]!=NULL) PAS_COMILER_PRC_00000021(((V *)Rv16)[3]);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_agregate "  */
V PAS_COMILER_PRC_00000019(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+436;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=1969; /* line # 1969 */
  Rv0=F_ty;
  Ra.sl[16]=1970; /* line # 1970 */
  if (((UB *)Rv0)[93]==11||((UB *)Rv0)[93]==12) {
    Ra.sl[16]=1972; /* line # 1972 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+452,25,2);
    Ra.sl[16]=1973; /* line # 1973 */
    Rv1=PAS_COMILER_PRC_00000018(F_ty,0);
    Ra.sl[16]=1974; /* line # 1974 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else {
      Ra.sl[16]=1975; /* line # 1975 */
      P_src_error(Rd.s+452,26,2);
    }
  }
  else {
    Ra.sl[16]=1978; /* line # 1978 */
    if (((UB *)Rv0)[92]) {
      Ra.sl[16]=1979; /* line # 1979 */
      P_src_error(Rd.s+452,131,3);
    }
    else {
      Ra.sl[16]=1982; /* line # 1982 */
      Ra.ub[8]=1;
      Ra.sl[16]=1983; /* line # 1983 */
      Rv1=NULL;
      Ra.sl[16]=1984; /* line # 1984 */
      Ra.v[2]=NULL;
      Ra.sl[16]=1985; /* line # 1985 */
      Ra.v[3]=NULL;
      Ra.sl[16]=1986; /* line # 1986 */
      if (V_sy_sym.ub[0]==13) Ra.ub[32]=14;
      else {
        Ra.sl[16]=1987; /* line # 1987 */
        Ra.ub[32]=16;
      }
      Ra.sl[16]=1988; /* line # 1988 */
      Rv2=((SL *)Rv0)[11];
      Ra.sl[16]=1989; /* line # 1989 */
      Rv3=0;
      Ra.sl[16]=1990; /* line # 1990 */
      V_sy_sym.ub[0]=17;
      Ra.sl[16]=1992; /* line # 1992 */
      if (((V *)Rv0)[4]!=NULL) {
        Ra.sl[16]=1994; /* line # 1994 */
        Rv4=((V *)Rv0)[4];
        Ra.sl[16]=1995; /* line # 1995 */
        if (((UB *)Rv0)[90]) {
          Ra.sl[16]=1998; /* line # 1998 */
          P_type_parm_cte_init(F_ty, Ra.v+2,Ra.v+3,&Rv3);
        }
        else while (1){
          Ra.sl[16]=2004; /* line # 2004 */
          P_insymbol();
          Ra.sl[16]=2005; /* line # 2005 */
          Rv5=Rv4;
          Ra.sl[16]=2007; /* line # 2007 */
          Rv6=((V *)Rv5)[5];
          Ra.sl[16]=2009; /* line # 2009 */
          Rv7=PAS_COMILER_PRC_00000005(Rv6,0,0,0);
          Ra.sl[16]=2010; /* line # 2010 */
          Rv8=Rv7;
          Ra.sl[16]=2012; /* line # 2012 */
          if (((UB *)Rv8)[40]==17) {
            Ra.sl[16]=2014; /* line # 2014 */
            ((UB *)Rv8)[40]=14;
            Ra.sl[16]=2015; /* line # 2015 */
            ((V *)Rv8)[7]=((V *)Rv5)[10];
            Ra.sl[16]=2017; /* line # 2017 */
            if (((V *)Rv8)[7]==NULL) P_src_error_s(Rd.s+452,157,3,((V *)Rv4)[0],
            NULL);
            Ra.sl[16]=2018; /* line # 2018 */
            P_val_new(((V *)Rv8)+7,Rv6);
            Ra.sl[16]=2019; /* line # 2019 */
            ((V *)Rv8)[4]=NULL;
            Ra.sl[16]=2020; /* line # 2020 */
            ((V *)Rv8)[3]=Rv6;
          }
          else {
            Ra.sl[16]=2023; /* line # 2023 */
            if (((UB *)Rv8)[40]!=14) P_src_error(Rd.s+452,132,3);
          }
          Ra.sl[16]=2024; /* line # 2024 */
          ((SL *)Rv8)[4]=((SL *)Rv5)[14];
          Ra.sl[16]=2028; /* line # 2028 */
          ((V *)Rv5)[9]=Rv7;
          Ra.sl[16]=2029; /* line # 2029 */
          ((UB *)Rv5)[60]=1;
          Ra.sl[16]=2031; /* line # 2031 */
          if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
          else {
            Ra.sl[16]=2032; /* line # 2032 */
            ((V *)Ra.v[3])[0]=Rv7;
          }
          Ra.sl[16]=2033; /* line # 2033 */
          Ra.v[3]=Rv7;
          Ra.sl[16]=2035; /* line # 2035 */
          Rv4=((V *)Rv4)[3];
          Ra.sl[16]=2036; /* line # 2036 */
          Rv3=Rv3+1;
          if (Rv4==NULL||V_sy_sym.ub[0]!=17)  break;
        }
      }
      Ra.sl[16]=2042; /* line # 2042 */
      if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
        Ra.sl[16]=2044; /* line # 2044 */
        Rv9=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
        Ra.sl[16]=2045; /* line # 2045 */
        if (((UB *)Rv9)[40]==14) {
          Ra.sl[16]=2047; /* line # 2047 */
          Rv2=((SL *)((V *)Rv9)[7])[13];
          Ra.sl[16]=2048; /* line # 2048 */
          P_lgt_free(&Rv9);
        }
        else {
          Ra.sl[16]=2049; /* line # 2049 */
          P_src_error(Rd.s+452,142,3);
        }
      }
      Ra.sl[16]=2053; /* line # 2053 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+452,29,2);
      Ra.sl[16]=2055; /* line # 2055 */
      switch (((UB *)Rv0)[93]) {
        case 11:
        case 12:Ra.sl[16]=2058; /* line # 2058 */
        if (V_sy_sym.ub[0]==13) P_src_error(Rd.s+452,133,2);
        Ra.sl[16]=2059; /* line # 2059 */
        Rv7=PAS_COMILER_PRC_00000018(F_ty,0);
        Ra.sl[16]=2060; /* line # 2060 */
        if (((UB *)Rv7)[40]!=14) Ra.ub[8]=0;
        Ra.sl[16]=2062; /* line # 2062 */
        if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
        else {
          Ra.sl[16]=2063; /* line # 2063 */
          ((V *)Ra.v[3])[0]=Rv7;
        }
        Ra.sl[16]=2064; /* line # 2064 */
        Ra.v[3]=Rv7;
        break;
        case 10:
        case 23:Ra.sl[16]=2068; /* line # 2068 */
        PAS_COMILER_PRC_00000021(F_ty);
        break;
        case 8:Ra.sl[16]=2071; /* line # 2071 */
        PAS_COMILER_PRC_00000020(F_ty);
        break;
        default:Ra.sl[16]=2074; /* line # 2074 */
        P_src_error(Rd.s+452,131,3);
        Ra.sl[16]=2075; /* line # 2075 */
        P_skip_symbol(Ra.ub[32],0,0);
        break;
      }
      Ra.sl[16]=2078; /* line # 2078 */
      if (V_sy_sym.ub[0]==Ra.ub[32]) P_insymbol();
      else {
        Ra.sl[16]=2079; /* line # 2079 */
        P_src_error(Rd.s+452,26,2);
      }
      Ra.sl[16]=2081; /* line # 2081 */
      if (((V *)Rv0)[4]!=NULL) P_type_parm_cte_release(F_ty);
      Ra.sl[16]=2084; /* line # 2084 */
      if (Ra.ub[8]) {
        Ra.sl[16]=2086; /* line # 2086 */
        P_lgt_new(&Rv1, F_ty,14,NULL);
        Ra.sl[16]=2087; /* line # 2087 */
        switch (((UB *)F_ty)[93]) {
          case 8:
          case 9:
          case 10:Ra.sl[16]=2090; /* line # 2090 */
          P_val_new(((V *)Rv1)+7,F_ty);
          Ra.sl[16]=2091; /* line # 2091 */
          ((V *)((V *)Rv1)[7])[7]=NULL;
          Ra.sl[16]=2092; /* line # 2092 */
          Rv10=NULL;
          Ra.sl[16]=2093; /* line # 2093 */
          Rv11=Rv1;
          Rv12=((V *)Rv11)[7];
          Ra.sl[16]=2095; /* line # 2095 */
          ((SL *)Rv12)[2]=Rv3;
          Ra.sl[16]=2096; /* line # 2096 */
          ((SL *)Rv12)[6]=Rv2;
          Ra.sl[16]=2097; /* line # 2097 */
          while (Ra.v[2]!=NULL){
            Ra.sl[16]=2098; /* line # 2098 */
            Ra.sl[16]=2100; /* line # 2100 */
            Rv7=Ra.v[2];
            Ra.sl[16]=2101; /* line # 2101 */
            Rv13=NULL;
            Ra.sl[16]=2102; /* line # 2102 */
            P_val_copy(((V *)Rv7)+7,&Rv13,1);
            Ra.sl[16]=2103; /* line # 2103 */
            if (Rv10==NULL) ((V *)((V *)Rv1)[7])[7]=Rv13;
            else {
              Ra.sl[16]=2104; /* line # 2104 */
              ((V *)Rv10)[0]=Rv13;
            }
            Ra.sl[16]=2105; /* line # 2105 */
            if (((UB *)F_ty)[93]!=10) {
              Ra.sl[16]=2107; /* line # 2107 */
              if (Rv3>0) Rv3=Rv3-1;
              else {
                Ra.sl[16]=2108; /* line # 2108 */
                if (((UB *)Rv13)[48]==29) ((SL *)Rv13)[6]=Ra.sl[1]-V_stri_stroffset;
                else {
                  Ra.sl[16]=2109; /* line # 2109 */
                  ((SL *)Rv13)[6]=Ra.sl[1];
                }
              }
            }
            Ra.sl[16]=2110; /* line # 2110 */
            Rv10=Rv13;
            Ra.sl[16]=2111; /* line # 2111 */
            Ra.v[2]=((V *)Ra.v[2])[0];
            Ra.sl[16]=2112; /* line # 2112 */
            ((V *)Rv7)[7]=NULL;
            Ra.sl[16]=2113; /* line # 2113 */
            P_lgt_free(&Rv7);
          }
          break;
          default:Ra.sl[16]=2119; /* line # 2119 */
          P_val_copy(((V *)Ra.v[2])+7,((V *)Rv1)+7,1);
          Ra.sl[16]=2120; /* line # 2120 */
          ((SL *)((V *)Rv1)[7])[2]=Rv3;
          break;
        }
      }
      else {
        Ra.sl[16]=2126; /* line # 2126 */
        P_src_error(Rd.s+452,143,3);
        Ra.sl[16]=2127; /* line # 2127 */
        P_lgt_free_tree(Ra.v+2);
        Ra.sl[16]=2128; /* line # 2128 */
        Rv1=P_lgt_new_econst(V_typ_std.v[21],0);
      }
    }
  }
  Ra.sl[16]=2131; /* line # 2131 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " exp_const_set "  */
V PAS_COMILER_PRC_00000022(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+456;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2144; /* line # 2144 */
  Rv0=PAS_COMILER_PRC_00000018(NULL,0);
  Ra.sl[6]=2145; /* line # 2145 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else {
    Ra.sl[6]=2146; /* line # 2146 */
    P_src_error(Rd.s+473,26,2);
  }
  Ra.sl[6]=2147; /* line # 2147 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_procref "  */
V PAS_COMILER_PRC_00000023(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+477;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2160; /* line # 2160 */
  Rv0=NULL;
  Ra.sl[6]=2161; /* line # 2161 */
  Rv1=Lx[5].v[13];
  Ra.sl[6]=2162; /* line # 2162 */
  while (Rv1!=NULL&&Rv0==NULL){
    Ra.sl[6]=2163; /* line # 2163 */
    switch (((UB *)Rv1)[104]) {
      case 6:
      case 9:
      case 10:
      case 11:Ra.sl[6]=2165; /* line # 2165 */
      Rv0=Rv1;
      break;
      case 5:Ra.sl[6]=2167; /* line # 2167 */
      Rv1=((V *)Rv1)[14];
      break;
      default:Ra.sl[6]=2170; /* line # 2170 */
      P_src_error(Rd.s+492,171,3);
      Ra.sl[6]=2171; /* line # 2171 */
      Rv1=NULL;
      break;
    }
  }
  Ra.sl[6]=2173; /* line # 2173 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_generic_ref "  */
V PAS_COMILER_PRC_00000024(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2193; /* line # 2193 */
  Rv0=NULL;
  Ra.sl[6]=2194; /* line # 2194 */
  P_insymbol();
  Ra.sl[6]=2195; /* line # 2195 */
  Ra.sl[6]=2196; /* line # 2196 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2198; /* line # 2198 */
    Rv1=P_ide_search(898);
    Ra.sl[6]=2199; /* line # 2199 */
    if (Rv1!=V_ide_udptr.v[1]) {
      Ra.sl[6]=2200; /* line # 2200 */
      Rv2=Rv1;
      Ra.sl[6]=2202; /* line # 2202 */
      P_insymbol();
      Ra.sl[6]=2203; /* line # 2203 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=2204; /* line # 2204 */
        P_src_error(Rd.s+515,26,2);
      }
      Ra.sl[6]=2205; /* line # 2205 */
      switch (((UB *)Rv2)[53]) {
        case 1:
        case 8:
        case 9:Ra.sl[6]=2208; /* line # 2208 */
        Rv3=((V *)Rv2)[10];
        Ra.sl[6]=2209; /* line # 2209 */
        while (Rv3!=NULL&&!P_comp_proc_arg(((V *)Rv3)[2],((V *)F_ty)[13]))
        Rv3=((V *)Rv3)[0];
        Ra.sl[6]=2210; /* line # 2210 */
        if (Rv3==NULL) Rv0=NULL;
        else {
          Ra.sl[6]=2211; /* line # 2211 */
          Rv0=((V *)Rv3)[2];
        }
        Ra.sl[6]=2212; /* line # 2212 */
        if (((SL *)Rv0)[18]>1) P_src_error_s(Rd.s+515,401,2,((V *)Rv2)[0],NULL);
        break;
        case 7:Ra.sl[6]=2216; /* line # 2216 */
        if (P_comp_proc_arg(((V *)Rv2)[8],((V *)F_ty)[13])) Rv0=((V *)Rv2)[8];
        else {
          Ra.sl[6]=2217; /* line # 2217 */
          Rv0=NULL;
        }
        break;
        default:break;
      }
      Ra.sl[6]=2221; /* line # 2221 */
      if (Rv0!=NULL) {
        Ra.sl[6]=2223; /* line # 2223 */
        P_lgt_new(&Rv4, F_ty,10,NULL);
        Ra.sl[6]=2224; /* line # 2224 */
        ((V *)Rv4)[6]=Rv0;
      }
    }
  }
  Ra.sl[6]=2228; /* line # 2228 */
  if (Rv0==NULL) {
    Ra.sl[6]=2230; /* line # 2230 */
    P_src_error(Rd.s+515,402,3);
    Ra.sl[6]=2231; /* line # 2231 */
    Rv4=P_lgt_new_econst(V_typ_std.v[13],0);
  }
  Ra.sl[6]=2233; /* line # 2233 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_identifier "  */
V PAS_COMILER_PRC_00000025(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register UB Rv16;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+519;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2250; /* line # 2250 */
  Ra.sl[6]=2252; /* line # 2252 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2254; /* line # 2254 */
    if (V_sy_search==NULL) {
      Ra.sl[6]=2256; /* line # 2256 */
      Rv0=P_ide_search(1014);
      Ra.sl[6]=2258; /* line # 2258 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=2262; /* line # 2262 */
      Rv0=V_sy_search;
      Ra.sl[6]=2263; /* line # 2263 */
      V_sy_sym.ub[0]=V_lastsymb;
      Ra.sl[6]=2264; /* line # 2264 */
      V_sy_search=NULL;
    }
    Ra.sl[6]=2267; /* line # 2267 */
    if (Rv0!=NULL) {
      Ra.sl[6]=2269; /* line # 2269 */
      Rv1=Rv0;
      Ra.sl[6]=2270; /* line # 2270 */
      switch (((UB *)Rv1)[53]) {
        case 1:Ra.sl[6]=2273; /* line # 2273 */
        if (Rv0==V_ide_udptr.v[1]) {
          Ra.sl[6]=2275; /* line # 2275 */
          Rv2=P_lgt_new_econst(V_typ_std.v[21],0);
        }
        else {
          Ra.sl[6]=2277; /* line # 2277 */
          switch (V_sy_sym.ub[0]) {
            case 24:Ra.sl[6]=2278; /* line # 2278 */
            Rv2=PAS_COMILER_PRC_00000007(NULL,((V *)Rv1)[5]);
            break;
            case 13:Ra.sl[6]=2280; /* line # 2280 */
            if (((V *)Rv1)[10]!=NULL) Rv2=PAS_COMILER_PRC_00000011(Rv0,1);
            else {
              Ra.sl[6]=2281; /* line # 2281 */
              Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
            }
            break;
            case 15:Ra.sl[6]=2283; /* line # 2283 */
            if (((V *)Rv1)[5]!=NULL) {
              Ra.sl[6]=2284; /* line # 2284 */
              if (((UB *)((V *)Rv1)[5])[93]==6) Rv2=PAS_COMILER_PRC_00000024(((V
               *)Rv1)[5]);
              else {
                Ra.sl[6]=2285; /* line # 2285 */
                Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
              }
            }
            break;
            default:Ra.sl[6]=2287; /* line # 2287 */
            P_src_error(Rd.s+537,36,3);
            break;
          }
        }
        break;
        case 7:
        case 8:Ra.sl[6]=2292; /* line # 2292 */
        Rv2=PAS_COMILER_PRC_00000009(Rv0,1);
        break;
        case 9:Ra.sl[6]=2295; /* line # 2295 */
        Rv2=PAS_COMILER_PRC_00000011(Rv0,1);
        break;
        case 2:Ra.sl[6]=2299; /* line # 2299 */
        switch (((UB *)Rv1)[60]) {
          case 2:Ra.sl[6]=2301; /* line # 2301 */
          if (((V *)Rv1)[10]!=NULL) {
            Ra.sl[6]=2303; /* line # 2303 */
            P_lgt_new(&Rv2,((V *)Rv1)[5],14,NULL);
            Ra.sl[6]=2304; /* line # 2304 */
            Rv3=Rv2;
            Ra.sl[6]=2306; /* line # 2306 */
            ((V *)Rv3)[7]=((V *)Rv1)[10];
            Ra.sl[6]=2307; /* line # 2307 */
            P_val_new(((V *)Rv3)+7,((V *)Rv1)[5]);
          }
          else {
            Ra.sl[6]=2312; /* line # 2312 */
            Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[5],0,0,0);
          }
          break;
          case 0:Ra.sl[6]=2316; /* line # 2316 */
          P_lgt_new(&Rv2,((V *)Rv1)[5],13,NULL);
          Ra.sl[6]=2317; /* line # 2317 */
          if (((V *)Rv1)[8]==NULL) ((V *)Rv1)[8]=Rv2;
          Ra.sl[6]=2321; /* line # 2321 */
          ((V *)Rv1)[9]=NULL;
          Ra.sl[6]=2322; /* line # 2322 */
          Rv4=Rv2;
          Ra.sl[6]=2324; /* line # 2324 */
          ((V *)Rv4)[6]=Rv0;
          Ra.sl[6]=2325; /* line # 2325 */
          ((UW *)Rv4)[10]=1;
          break;
          case 3:Ra.sl[6]=2330; /* line # 2330 */
          Rv5=(V_lex_ident_tree.s+V_ident_disp*64);
          Ra.sl[6]=2331; /* line # 2331 */
          if (((UB *)Rv5)[24]==1) {
            Ra.sl[6]=2333; /* line # 2333 */
            P_lgt_new_copy(((V *)Rv5)[2],&Rv2);
            Ra.sl[6]=2334; /* line # 2334 */
            Rv6=Rv2;
            Ra.sl[6]=2336; /* line # 2336 */
            ((V *)Rv6)[3]=((V *)Rv1)[5];
            Ra.sl[6]=2337; /* line # 2337 */
            ((SL *)Rv6)[4]=((SL *)Rv6)[4]+((SL *)Rv1)[14];
          }
          else {
            Ra.sl[6]=2342; /* line # 2342 */
            P_lgt_new_copy(((V *)Rv5)[2],&Rv2);
            Ra.sl[6]=2343; /* line # 2343 */
            P_lgt_new(&Rv2,((V *)Rv1)[5],2, Rv2);
            Ra.sl[6]=2344; /* line # 2344 */
            ((SL *)Rv2)[4]=((SL *)Rv1)[14];
            Ra.sl[6]=2345; /* line # 2345 */
            if (((SL *)Rv5)[13]>=0) {
              Ra.sl[6]=2346; /* line # 2346 */
              ((SL *)Rv5)[13]=((SL *)Rv5)[13]+1;
            }
            else {
              Ra.sl[6]=2348; /* line # 2348 */
              Rv7=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
              Ra.sl[6]=2349; /* line # 2349 */
              ((SL *)Rv7)[13]=((SL *)Rv7)[13]+1;
            }
          }
          break;
          default:break;
        }
        Ra.sl[6]=2354; /* line # 2354 */
        ((V *)Rv2)[4]=Rv0;
        Ra.sl[6]=2355; /* line # 2355 */
        ((UW *)Rv2)[10]=1;
        break;
        case 5:Ra.sl[6]=2361; /* line # 2361 */
        Rv2=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=2362; /* line # 2362 */
        Rv8=Rv2;
        Ra.sl[6]=2364; /* line # 2364 */
        if (((SL *)Lx[5].v[13])[18]>=((SL *)Rv1)[12]) {
          Ra.sl[6]=2365; /* line # 2365 */
          ((UW *)Rv1)[42]=((UW *)Rv1)[42]|4;
        }
        Ra.sl[6]=2367; /* line # 2367 */
        switch (((UB *)Rv1)[86]) {
          case 1:
          case 2:
          case 4:
          case 7:Ra.sl[6]=2374; /* line # 2374 */
          if ((((UB *)((V *)Rv1)[5])[90]||((UB *)((V *)Rv1)[5])[91])&&!(16&((UW *)
          Rv1)[42])) {
            Ra.sl[6]=2376; /* line # 2376 */
            P_init_d_varbl(Rv0);
          }
          Ra.sl[6]=2380; /* line # 2380 */
          if (((((UB *)Rv1)[86]==1&&((SL *)Rv1)[12]>1)&&((V *)Rv1)[7]!=NULL)&&!(
8&((UW *)Rv1)[42])) {
            Ra.sl[6]=2384; /* line # 2384 */
            P_initialize_varbl(Rv0);
          }
          break;
          case 11:Ra.sl[6]=2390; /* line # 2390 */
          ((V *)Rv8)[3]=V_typ_std.v[13];
          Ra.sl[6]=2391; /* line # 2391 */
          ((UW *)Rv8)[10]=1;
          break;
          default:break;
        }
        Ra.sl[6]=2398; /* line # 2398 */
        ((V *)Rv2)[4]=Rv0;
        break;
        case 4:Ra.sl[6]=2403; /* line # 2403 */
        Rv2=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=2404; /* line # 2404 */
        ((V *)Rv2)[4]=Rv0;
        break;
        case 6:Ra.sl[6]=2408; /* line # 2408 */
        Rv9=(V_lex_ident_tree.s+V_ident_disp*64);
        Ra.sl[6]=2410; /* line # 2410 */
        P_lgt_new_copy(((V *)Rv9)[2],&Rv2);
        Ra.sl[6]=2411; /* line # 2411 */
        if (((UB *)Rv9)[24]==1) {
          Ra.sl[6]=2413; /* line # 2413 */
          if (((SL *)((V *)Rv2)[3])[10]>0) V_curr_descr=Rv2;
          Ra.sl[6]=2414; /* line # 2414 */
          P_lgt_new(&Rv2,((V *)Rv1)[5],3, Rv2);
          Ra.sl[6]=2415; /* line # 2415 */
          ((SL *)Rv2)[4]=((SL *)Rv1)[14];
        }
        else {
          Ra.sl[6]=2419; /* line # 2419 */
          Rv10=Rv2;
          Ra.sl[6]=2420; /* line # 2420 */
          if (((UB *)((V *)Rv10)[3])[93]==24) {
            Ra.sl[6]=2422; /* line # 2422 */
            Rv11=((V *)((V *)((V *)Rv10)[3])[0])[3];
            Ra.sl[6]=2423; /* line # 2423 */
            ((V *)Rv10)[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[14]);
            Ra.sl[6]=2424; /* line # 2424 */
            if (Rv11!=NULL) {
              Ra.sl[6]=2425; /* line # 2425 */
              Rv2=P_exp_genoper(((V *)Rv11)[0],((V *)Rv11)[10],Rv2);
            }
            else {
              Ra.sl[6]=2427; /* line # 2427 */
              P_src_error(Rd.s+537,998,3);
            }
            Ra.sl[6]=2428; /* line # 2428 */
            ((V *)Rv2)[3]=((V *)Rv1)[5];
          }
          else {
            Ra.sl[6]=2432; /* line # 2432 */
            P_lgt_new(&Rv2,((V *)((V *)Rv2)[3])[12],2, Rv2);
            Ra.sl[6]=2433; /* line # 2433 */
            if (((SL *)((V *)Rv2)[3])[10]>0) V_curr_descr=Rv2;
            Ra.sl[6]=2434; /* line # 2434 */
            Ra.sl[6]=2435; /* line # 2435 */
            P_lgt_new(&Rv2,((V *)Rv1)[5],3, Rv2);
            Ra.sl[6]=2436; /* line # 2436 */
            ((SL *)Rv2)[4]=((SL *)Rv1)[14];
          }
          Ra.sl[6]=2438; /* line # 2438 */
          if (((SL *)Rv9)[13]>=0) {
            Ra.sl[6]=2439; /* line # 2439 */
            ((SL *)Rv9)[13]=((SL *)Rv9)[13]+1;
          }
          else {
            Ra.sl[6]=2441; /* line # 2441 */
            Rv12=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
            Ra.sl[6]=2442; /* line # 2442 */
            ((SL *)Rv12)[13]=((SL *)Rv12)[13]+1;
          }
        }
        Ra.sl[6]=2444; /* line # 2444 */
        Rv13=Rv2;
        Ra.sl[6]=2446; /* line # 2446 */
        ((UW *)Rv13)[10]=((UW *)((V *)Rv9)[2])[10]|4;
        Ra.sl[6]=2447; /* line # 2447 */
        ((V *)Rv13)[4]=Rv0;
        break;
      }
    }
    else {
      Ra.sl[6]=2454; /* line # 2454 */
      P_src_error(Rd.s+537,107,3);
      Ra.sl[6]=2455; /* line # 2455 */
      Rv2=P_lgt_new_econst(V_typ_std.v[21],0);
    }
  }
  else {
    Ra.sl[6]=2460; /* line # 2460 */
    switch (V_sy_sym.ub[0]) {
      case 27:Ra.sl[6]=2461; /* line # 2461 */
      Rv2=P_lgt_new_econst(V_typ_std.v[13],0);
      break;
      case 2:Ra.sl[6]=2462; /* line # 2462 */
      Rv2=P_lgt_new_econst(V_typ_std.v[2],V_sy_ival);
      break;
      case 3:Ra.sl[6]=2465; /* line # 2465 */
      Rv2=P_lgt_new_econst(V_typ_std.v[3],0);
      Ra.sl[6]=2466; /* line # 2466 */
      ((G *)((V *)Rv2)[7])[7]=V_sy_rval;
      break;
      case 4:Ra.sl[6]=2470; /* line # 2470 */
      Rv2=P_lgt_new_econst(V_typ_std.v[4],0);
      Ra.sl[6]=2471; /* line # 2471 */
      ((G *)((V *)Rv2)[7])[7]=V_sy_rval;
      break;
      case 5:Ra.sl[6]=2475; /* line # 2475 */
      Rv2=P_lgt_new_econst(V_typ_std.v[0],(SL)V_sy_string.c[2]);
      Ra.sl[6]=2477; /* line # 2477 */
      if (V_sy_string.ub[1]!=1) {
        Ra.sl[6]=2478; /* line # 2478 */
        Rv14=Rv2;
        Rv15=((V *)Rv14)[7];
        Ra.sl[6]=2481; /* line # 2481 */
        ((V *)Rv14)[3]=V_typ_std.v[10];
        Ra.sl[6]=2482; /* line # 2482 */
        ((UB *)Rv15)[48]=29;
        Ra.sl[6]=2483; /* line # 2483 */
        ((SL *)Rv15)[6]=V_sy_string.ub[1];
        Ra.sl[6]=2484; /* line # 2484 */
        ((V *)Rv15)[4]=((V *)Rv14)[3];
        Ra.sl[6]=2485; /* line # 2485 */
        if (V_sy_string.ub[1]>0) {
          Ra.sl[6]=2487; /* line # 2487 */
          Rv16=V_sy_string.ub[1];
          ((V *)Rv15)[7]=PAS__NEW((SL)Rv16+2);
          ((UB *)((V *)Rv15)[7])[0]=Rv16;
          Ra.sl[6]=2488; /* line # 2488 */
          PAS__STR_TO_STR(((V *)Rv15)[7],V_sy_string.s);
        }
        else {
          Ra.sl[6]=2490; /* line # 2490 */
          ((V *)Rv15)[7]=NULL;
        }
      }
      break;
      default:Ra.sl[6]=2495; /* line # 2495 */
      if (Ri.ub[0]) P_src_error(Rd.s+537,44,2);
      Ra.sl[6]=2496; /* line # 2496 */
      P_lgt_new(&Rv2, V_typ_std.v[21],17,NULL);
      break;
    }
    Ra.sl[6]=2500; /* line # 2500 */
    if (((UB *)Rv2)[40]!=17) P_insymbol();
  }
  Ra.sl[6]=2503; /* line # 2503 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_indir "  */
V PAS_COMILER_PRC_00000026(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+541;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2516; /* line # 2516 */
  Rv0=F_pobj;
  Ra.sl[6]=2517; /* line # 2517 */
  Rv1=((V *)F_pobj)[3];
  Ra.sl[6]=2519; /* line # 2519 */
  switch (((UB *)Rv1)[93]) {
    case 7:Ra.sl[6]=2522; /* line # 2522 */
    ((V *)F_pobj)[3]=V_typ_std.v[13];
    Ra.sl[6]=2523; /* line # 2523 */
    P_lgt_new(&Rv0, V_typ_std.v[13],2, F_pobj);
    Ra.sl[6]=2524; /* line # 2524 */
    Rv2=Rv0;
    ((UW *)Rv2)[10]=((UW *)Rv2)[10]|4;
    Ra.sl[6]=2525; /* line # 2525 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, Rv0);
    break;
    case 5:Ra.sl[6]=2530; /* line # 2530 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, F_pobj);
    break;
    case 6:Ra.sl[6]=2536; /* line # 2536 */
    Rv0=PAS_COMILER_PRC_00000010(F_pobj);
    break;
    default:Ra.sl[6]=2540; /* line # 2540 */
    P_src_error(Rd.s+554,151,3);
    break;
  }
  Ra.sl[6]=2542; /* line # 2542 */
  if (((UB *)Rv1)[93]!=6) {
    Ra.sl[6]=2543; /* line # 2543 */
    Rv3=Rv0;
    ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
  }
  Ra.sl[6]=2545; /* line # 2545 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_field "  */
V PAS_COMILER_PRC_00000027(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+558;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2561; /* line # 2561 */
  Rv0=0;
  Ra.sl[6]=2562; /* line # 2562 */
  Rv1=NULL;
  Ra.sl[6]=2563; /* line # 2563 */
  Rv2=0;
  Ra.sl[6]=2564; /* line # 2564 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2566; /* line # 2566 */
    Rv3=F_pobj;
    Rv4=((V *)Rv3)[3];
    Ra.sl[6]=2568; /* line # 2568 */
    if (((V *)Rv4)[4]!=NULL) {
      Ra.sl[6]=2570; /* line # 2570 */
      Rv1=P_level_search(((V *)Rv4)[4]);
      Ra.sl[6]=2571; /* line # 2571 */
      if (Rv1!=NULL) {
        Ra.sl[6]=2572; /* line # 2572 */
        Rv5=Rv1;
        Ra.sl[6]=2574; /* line # 2574 */
        if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
        Ra.sl[6]=2576; /* line # 2576 */
        ((UW *)Rv3)[10]=(((UW *)Rv3)[10]|1)&~2;
        Ra.sl[6]=2577; /* line # 2577 */
        Rv2=((SL *)Rv5)[14];
      }
    }
    Ra.sl[6]=2581; /* line # 2581 */
    if (Rv1==NULL) {
      Ra.sl[6]=2582; /* line # 2582 */
      if (((UB *)Rv4)[93]!=10) {
        Ra.sl[6]=2584; /* line # 2584 */
        F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
        Ra.sl[6]=2585; /* line # 2585 */
        P_src_error(Rd.s+571,152,3);
        Ra.sl[6]=2586; /* line # 2586 */
        Rv0=1;
      }
      else {
        Ra.sl[6]=2590; /* line # 2590 */
        Rv1=P_level_search(((V *)Rv4)[12]);
        Ra.sl[6]=2591; /* line # 2591 */
        if (Rv1!=NULL) {
          Ra.sl[6]=2592; /* line # 2592 */
          Rv6=Rv1;
          Ra.sl[6]=2594; /* line # 2594 */
          if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
          Ra.sl[6]=2595; /* line # 2595 */
          Rv2=((SL *)Rv6)[14];
        }
        else Ra.sl[6]=2598; /* line # 2598 */
      }
    }
    Ra.sl[6]=2600; /* line # 2600 */
    if (Rv1!=NULL) {
      Ra.sl[6]=2601; /* line # 2601 */
      Rv7=Rv1;
      Ra.sl[6]=2603; /* line # 2603 */
      if (Rv2!=0&&V_curr_descr==F_pobj) {
        Ra.sl[6]=2604; /* line # 2604 */
        if (((UB *)Rv3)[40]==14) {
          P_lgt_new_copy(F_pobj, &F_pobj);
          ((V *)F_pobj)[3]=((V *)Rv7)[5];
        }
        else {
          Ra.sl[6]=2606; /* line # 2606 */
          P_lgt_new(&F_pobj,((V *)Rv7)[5],3, F_pobj);
          Ra.sl[6]=2607; /* line # 2607 */
          ((UW *)F_pobj)[10]=((UW *)((V *)F_pobj)[1])[10];
        }
      }
      else {
        Ra.sl[6]=2610; /* line # 2610 */
        Rv2=((SL *)Rv3)[4]+Rv2;
        ((V *)Rv3)[3]=((V *)Rv7)[5];
      }
      Ra.sl[6]=2611; /* line # 2611 */
      ((SL *)F_pobj)[4]=((SL *)Rv3)[4]+Rv2;
    }
    else {
      Ra.sl[6]=2615; /* line # 2615 */
      F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
      Ra.sl[6]=2616; /* line # 2616 */
      P_src_error_s(Rd.s+571,153,2, V_sy_ident.s,NULL);
      Ra.sl[6]=2617; /* line # 2617 */
      Rv0=1;
    }
    Ra.sl[6]=2620; /* line # 2620 */
    P_insymbol();
  }
  else {
    Ra.sl[6]=2624; /* line # 2624 */
    P_src_error(Rd.s+571,156,3);
    Ra.sl[6]=2625; /* line # 2625 */
    Rv0=1;
  }
  Ra.sl[6]=2628; /* line # 2628 */
  Rv8=F_pobj;
  Ra.sl[6]=2629; /* line # 2629 */
  if (Rv0) ((V *)Rv8)[3]=V_typ_std.v[21];
  else {
    Ra.sl[6]=2632; /* line # 2632 */
    ((SL *)Rv8)[4]=Rv2;
    Ra.sl[6]=2633; /* line # 2633 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=2634; /* line # 2634 */
    if (((UB *)Rv8)[40]==14) {
      Ra.sl[6]=2635; /* line # 2635 */
      if (((V *)Rv8)[3]!=NULL) {
        Ra.sl[6]=2636; /* line # 2636 */
        if (((UB *)((V *)Rv8)[3])[92]) P_lgt_extract_simple_cte(F_pobj);
      }
    }
  }
  Ra.sl[6]=2639; /* line # 2639 */
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_index "  */
V PAS_COMILER_PRC_00000028(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+575;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2653; /* line # 2653 */
  Rv0=F_pobj;
  Ra.sl[6]=2656; /* line # 2656 */
  if (P_comp_type(((V *)F_pobj)[3],V_typ_std.v[10],1,0)) {
    Ra.sl[6]=2658; /* line # 2658 */
    V_curr_descr=F_pobj;
    Ra.sl[6]=2659; /* line # 2659 */
    P_lgt_new(&Rv0,((V *)((V *)V_typ_std.v[10])[13])[5],3, F_pobj);
    Ra.sl[6]=2660; /* line # 2660 */
    ((SL *)Rv0)[4]=((SL *)((V *)V_typ_std.v[10])[13])[14];
  }
  else {
    Ra.sl[6]=2663; /* line # 2663 */
    Rv1=F_pobj;
    Ra.sl[6]=2664; /* line # 2664 */
    if (((SL *)((V *)F_pobj)[3])[10]>0) {
      Ra.sl[6]=2666; /* line # 2666 */
      V_curr_descr=F_pobj;
      Ra.sl[6]=2667; /* line # 2667 */
      P_lgt_new(&Rv0,((V *)F_pobj)[3],3, F_pobj);
      Ra.sl[6]=2668; /* line # 2668 */
      ((SL *)Rv0)[4]=((SL *)F_pobj)[4]+((SL *)((V *)F_pobj)[3])[10];
    }
    else {
      Ra.sl[6]=2670; /* line # 2670 */
      Rv0=F_pobj;
    }
  }
  Ra.sl[6]=2672; /* line # 2672 */
  Rv2=Rv0;
  Ra.sl[6]=2674; /* line # 2674 */
  Rv3=((V *)Rv2)[3];
  Ra.sl[6]=2675; /* line # 2675 */
  if (((UB *)Rv3)[93]==8||((UB *)Rv3)[93]==9) {
    Ra.sl[6]=2678; /* line # 2678 */
    Rv4=PAS_COMILER_PRC_00000005(((V *)Rv3)[15],0,0,0);
    Ra.sl[6]=2679; /* line # 2679 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=2681; /* line # 2681 */
      Rv5=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=2682; /* line # 2682 */
      P_lgt_free(&Rv4);
    }
    Ra.sl[6]=2684; /* line # 2684 */
    Rv6=NULL;
    Ra.sl[6]=2685; /* line # 2685 */
    Rv7=NULL;
    Ra.sl[6]=2686; /* line # 2686 */
    Rv8=NULL;
    Ra.sl[6]=2688; /* line # 2688 */
    Rv9=((V *)Rv3)[15];
    Ra.sl[6]=2689; /* line # 2689 */
    if (((UB *)Rv9)[93]==22) {
      Ra.sl[6]=2690; /* line # 2690 */
      if (((UB *)((V *)Rv9)[13])[40]==14) {
        Ra.sl[6]=2692; /* line # 2692 */
        Rv10=((SL *)((V *)((V *)Rv9)[13])[7])[13];
        Ra.sl[6]=2693; /* line # 2693 */
        Rv7=((V *)Rv9)[14];
      }
      else {
        Ra.sl[6]=2697; /* line # 2697 */
        Rv6=P_lgt_type_eval(((V *)Rv9)[13],V_curr_descr,NULL,0);
        Ra.sl[6]=2704; /* line # 2704 */
        if (((UB *)((V *)Rv9)[14])[40]==14) {
          Ra.sl[6]=2706; /* line # 2706 */
          Rv11=((SL *)((V *)((V *)Rv9)[14])[7])[13];
          Ra.sl[6]=2707; /* line # 2707 */
          Rv7=((V *)Rv9)[14];
        }
      }
    }
    else {
      Ra.sl[6]=2712; /* line # 2712 */
      Rv10=((SL *)Rv9)[29];
      Ra.sl[6]=2713; /* line # 2713 */
      Rv11=((SL *)Rv9)[30];
    }
    Ra.sl[6]=2716; /* line # 2716 */
    if (((SL *)Rv3)[25]>0) Rv12=((SL *)Rv3)[25];
    else {
      Ra.sl[6]=2719; /* line # 2719 */
      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
      Ra.sl[6]=2720; /* line # 2720 */
      if (Rv8!=NULL) {
        Ra.sl[6]=2721; /* line # 2721 */
        Rv13=Rv8;
        Ra.sl[6]=2722; /* line # 2722 */
        if (((UB *)Rv13)[40]==14) {
          Ra.sl[6]=2724; /* line # 2724 */
          Rv12=((SL *)((V *)Rv13)[7])[13];
          Ra.sl[6]=2725; /* line # 2725 */
          P_lgt_free(&Rv8);
        }
      }
    }
    Ra.sl[6]=2729; /* line # 2729 */
    if (Rv4==NULL&&Rv6==NULL) {
      Ra.sl[6]=2731; /* line # 2731 */
      if (Rv5<Rv10||Rv7==NULL&&Rv5>Rv11) {
        Ra.sl[6]=2732; /* line # 2732 */
        P_src_error(Rd.s+588,154,2);
      }
      Ra.sl[6]=2733; /* line # 2733 */
      Rv5=Rv5-Rv10;
      Ra.sl[6]=2734; /* line # 2734 */
      if (Rv8==NULL) {
        Ra.sl[6]=2736; /* line # 2736 */
        Rv14=Rv0;
        Ra.sl[6]=2737; /* line # 2737 */
        ((SL *)Rv14)[4]=((SL *)Rv2)[4]+Rv5*Rv12;
        Ra.sl[6]=2738; /* line # 2738 */
        ((V *)Rv14)[3]=((V *)Rv3)[14];
      }
      else {
        Ra.sl[6]=2742; /* line # 2742 */
        Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        Ra.sl[6]=2743; /* line # 2743 */
        ((V *)Rv0)[0]=Rv4;
        Ra.sl[6]=2744; /* line # 2744 */
        ((V *)Rv4)[0]=Rv8;
        Ra.sl[6]=2745; /* line # 2745 */
        P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
        Ra.sl[6]=2746; /* line # 2746 */
        ((UW *)Rv14)[10]=((UW *)Rv0)[10];
        Ra.sl[6]=2747; /* line # 2747 */
        ((V *)Rv14)[6]=((V *)Rv2)[3];
      }
    }
    else {
      Ra.sl[6]=2752; /* line # 2752 */
      P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
      Ra.sl[6]=2753; /* line # 2753 */
      ((V *)Rv14)[6]=((V *)Rv2)[3];
      Ra.sl[6]=2754; /* line # 2754 */
      if (Rv8==NULL) {
        Ra.sl[6]=2756; /* line # 2756 */
        if (Rv4==NULL) {
          Ra.sl[6]=2758; /* line # 2758 */
          Rv4=P_lgt_new_code(46, Rv6);
          Ra.sl[6]=2759; /* line # 2759 */
          ((SL *)Rv14)[4]=Rv5*Rv12;
        }
        else {
          Ra.sl[6]=2763; /* line # 2763 */
          if (Rv6==NULL) {
            Ra.sl[6]=2764; /* line # 2764 */
            ((SL *)Rv14)[4]= -Rv10*Rv12;
          }
          else {
            Ra.sl[6]=2768; /* line # 2768 */
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2769; /* line # 2769 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        Ra.sl[6]=2772; /* line # 2772 */
        ((V *)Rv4)[0]=P_lgt_new_econst(V_int_typ, Rv12);
      }
      else {
        Ra.sl[6]=2776; /* line # 2776 */
        if (Rv4==NULL) {
          Ra.sl[6]=2778; /* line # 2778 */
          if (Rv5!=0) {
            Ra.sl[6]=2779; /* line # 2779 */
            Rv4=P_lgt_new_econst(V_int_typ, Rv5);
          }
        }
        else {
          Ra.sl[6]=2782; /* line # 2782 */
          if (Rv6==NULL) {
            Ra.sl[6]=2783; /* line # 2783 */
            if (Rv10!=0) {
              Ra.sl[6]=2784; /* line # 2784 */
              Rv6=P_lgt_new_econst(V_int_typ, Rv10);
            }
          }
        }
        Ra.sl[6]=2786; /* line # 2786 */
        if (Rv4==NULL) {
          Ra.sl[6]=2787; /* line # 2787 */
          Rv4=P_lgt_new_code(46, Rv4);
        }
        else {
          Ra.sl[6]=2789; /* line # 2789 */
          if (Rv6!=NULL) {
            Ra.sl[6]=2791; /* line # 2791 */
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2792; /* line # 2792 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        Ra.sl[6]=2794; /* line # 2794 */
        ((V *)Rv4)[0]=Rv8;
      }
      Ra.sl[6]=2796; /* line # 2796 */
      ((V *)Rv0)[0]=Rv4;
    }
  }
  else {
    Ra.sl[6]=2801; /* line # 2801 */
    P_src_error(Rd.s+588,155,3);
    Ra.sl[6]=2802; /* line # 2802 */
    ((V *)Rv2)[3]=V_typ_std.v[21];
    Ra.sl[6]=2803; /* line # 2803 */
    ((V *)Rv2)[1]=NULL;
    Ra.sl[6]=2804; /* line # 2804 */
    Rv14=F_pobj;
    Ra.sl[6]=2805; /* line # 2805 */
    P_skip_symbol(16,0,0);
  }
  Ra.sl[6]=2808; /* line # 2808 */
  Rv15=Rv14;
  Ra.sl[6]=2819; /* line # 2819 */
  ((UW *)Rv15)[10]=((UW *)Rv15)[10]|4;
  Ra.sl[6]=2820; /* line # 2820 */
  if (((UB *)Rv15)[40]==14) {
    Ra.sl[6]=2821; /* line # 2821 */
    if (((V *)Rv15)[3]!=NULL) {
      Ra.sl[6]=2822; /* line # 2822 */
      if (((UB *)((V *)Rv15)[3])[92]) P_lgt_extract_simple_cte(Rv14);
    }
  }
  Ra.sl[6]=2825; /* line # 2825 */
  Ret=Rv14;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_una "  */
V PAS_COMILER_PRC_00000034(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  UB Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+592;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2870; /* line # 2870 */
  Ra.sl[6]=2872; /* line # 2872 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) {
    Ra.sl[6]=2873; /* line # 2873 */
    V_sy_sym.ub[0]=6;
  }
  Ra.sl[6]=2874; /* line # 2874 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=2876; /* line # 2876 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else {
      Ra.sl[6]=2877; /* line # 2877 */
      Rv0=29;
    }
    Ra.sl[6]=2878; /* line # 2878 */
    P_insymbol();
    Ra.sl[6]=2879; /* line # 2879 */
    Rv1=PAS_COMILER_PRC_00000034();
    Ra.sl[6]=2880; /* line # 2880 */
    if (Rv0!=29) {
      Ra.sl[6]=2881; /* line # 2881 */
      if (((UB *)Rv1)[40]!=17) {
        Ra.sl[6]=2882; /* line # 2882 */
        Rv1=P_exp_genop(Rv0, Rv1);
      }
    }
  }
  else {
    Ra.sl[6]=2884; /* line # 2884 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=2886; /* line # 2886 */
      P_insymbol();
      Ra.sl[6]=2887; /* line # 2887 */
      Rv1=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=2888; /* line # 2888 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=2889; /* line # 2889 */
        P_src_error(Rd.s+603,23,3);
      }
    }
    else {
      Ra.sl[6]=2891; /* line # 2891 */
      if (V_sy_sym.ub[0]==15) {
        Ra.sl[6]=2892; /* line # 2892 */
        Rv1=PAS_COMILER_PRC_00000022();
      }
      else {
        Ra.sl[6]=2896; /* line # 2896 */
        Rv1=PAS_COMILER_PRC_00000025();
        Ra.sl[6]=2897; /* line # 2897 */
        Rv2=((UB *)Rv1)[40]!=17;
        Ra.sl[6]=2898; /* line # 2898 */
        if (((SL *)((V *)Rv1)[3])[10]>0) V_curr_descr=Rv1;
        Ra.sl[6]=2899; /* line # 2899 */
        while (Rv2){
          Ra.sl[6]=2900; /* line # 2900 */
          switch (V_sy_sym.ub[0]) {
            case 23:Ra.sl[6]=2903; /* line # 2903 */
            P_insymbol();
            Ra.sl[6]=2904; /* line # 2904 */
            Rv1=PAS_COMILER_PRC_00000026(Rv1);
            Ra.sl[6]=2905; /* line # 2905 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            break;
            case 15:Ra.sl[6]=2910; /* line # 2910 */
            V_sy_sym.ub[0]=17;
            Ra.sl[6]=2911; /* line # 2911 */
            while (V_sy_sym.ub[0]==17){
              Ra.sl[6]=2913; /* line # 2913 */
              P_insymbol();
              Ra.sl[6]=2914; /* line # 2914 */
              Rv1=PAS_COMILER_PRC_00000028(Rv1);
              Ra.sl[6]=2915; /* line # 2915 */
              if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            }
            Ra.sl[6]=2917; /* line # 2917 */
            if (V_sy_sym.ub[0]==16) P_insymbol();
            else {
              Ra.sl[6]=2918; /* line # 2918 */
              P_src_error(Rd.s+603,26,2);
            }
            break;
            case 19:Ra.sl[6]=2923; /* line # 2923 */
            P_insymbol();
            Ra.sl[6]=2924; /* line # 2924 */
            Rv1=PAS_COMILER_PRC_00000027(Rv1);
            Ra.sl[6]=2925; /* line # 2925 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            break;
            case 24:Ra.sl[6]=2929; /* line # 2929 */
            Rv1=PAS_COMILER_PRC_00000007(Rv1,((V *)Rv1)[3]);
            break;
            default:Ra.sl[6]=2932; /* line # 2932 */
            Rv2=0;
            break;
          }
        }
      }
    }
  }
  Ra.sl[6]=2937; /* line # 2937 */
  Ri.ub[0]=0;
  Ra.sl[6]=2938; /* line # 2938 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_pow "  */
V PAS_COMILER_PRC_00000033(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+607;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2942; /* line # 2942 */
  Rv0=PAS_COMILER_PRC_00000034();
  Ra.sl[6]=2943; /* line # 2943 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=2944; /* line # 2944 */
    Ra.sl[6]=2945; /* line # 2945 */
    if (V_sy_sym.ub[0]==7) {
      Ra.sl[6]=2947; /* line # 2947 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=2948; /* line # 2948 */
      P_insymbol();
      Ra.sl[6]=2949; /* line # 2949 */
      Ri.ub[0]=1;
      Ra.sl[6]=2950; /* line # 2950 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000034();
      Ra.sl[6]=2951; /* line # 2951 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=2953; /* line # 2953 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_mul "  */
V PAS_COMILER_PRC_00000032(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+616;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2957; /* line # 2957 */
  Rv0=PAS_COMILER_PRC_00000033();
  Ra.sl[6]=2958; /* line # 2958 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=2959; /* line # 2959 */
    Ra.sl[6]=2960; /* line # 2960 */
    while (V_sy_sym.ub[0]==8){
      Ra.sl[6]=2962; /* line # 2962 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=2963; /* line # 2963 */
      P_insymbol();
      Ra.sl[6]=2964; /* line # 2964 */
      Ri.ub[0]=1;
      Ra.sl[6]=2965; /* line # 2965 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000033();
      Ra.sl[6]=2966; /* line # 2966 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=2968; /* line # 2968 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_add "  */
V PAS_COMILER_PRC_00000031(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+625;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2972; /* line # 2972 */
  Rv0=PAS_COMILER_PRC_00000032();
  Ra.sl[6]=2973; /* line # 2973 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=2974; /* line # 2974 */
    Ra.sl[6]=2975; /* line # 2975 */
    while (V_sy_sym.ub[0]==9){
      Ra.sl[6]=2977; /* line # 2977 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=2978; /* line # 2978 */
      P_insymbol();
      Ra.sl[6]=2979; /* line # 2979 */
      Ri.ub[0]=1;
      Ra.sl[6]=2980; /* line # 2980 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000032();
      Ra.sl[6]=2981; /* line # 2981 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=2983; /* line # 2983 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_rel "  */
V PAS_COMILER_PRC_00000030(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+634;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2987; /* line # 2987 */
  Rv0=PAS_COMILER_PRC_00000031();
  Ra.sl[6]=2988; /* line # 2988 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=2989; /* line # 2989 */
    Ra.sl[6]=2990; /* line # 2990 */
    while (V_sy_sym.ub[0]==10){
      Ra.sl[6]=2992; /* line # 2992 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=2993; /* line # 2993 */
      P_insymbol();
      Ra.sl[6]=2994; /* line # 2994 */
      Ri.ub[0]=1;
      Ra.sl[6]=2995; /* line # 2995 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000031();
      Ra.sl[6]=2996; /* line # 2996 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=2998; /* line # 2998 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_and "  */
V PAS_COMILER_PRC_00000029(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+643;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3001; /* line # 3001 */
  Rv0=PAS_COMILER_PRC_00000030();
  Ra.sl[6]=3002; /* line # 3002 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3003; /* line # 3003 */
    Ra.sl[6]=3004; /* line # 3004 */
    while (V_sy_sym.ub[0]==11){
      Ra.sl[6]=3006; /* line # 3006 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3007; /* line # 3007 */
      P_insymbol();
      Ra.sl[6]=3008; /* line # 3008 */
      Ri.ub[0]=1;
      Ra.sl[6]=3009; /* line # 3009 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000030();
      Ra.sl[6]=3010; /* line # 3010 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3012; /* line # 3012 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " expression "  */
V PAS_COMILER_PRC_00000000(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+652;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3016; /* line # 3016 */
  Rv0=PAS_COMILER_PRC_00000029();
  Ra.sl[6]=3017; /* line # 3017 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3018; /* line # 3018 */
    Ra.sl[6]=3019; /* line # 3019 */
    while (V_sy_sym.ub[0]==12){
      Ra.sl[6]=3021; /* line # 3021 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3022; /* line # 3022 */
      P_insymbol();
      Ra.sl[6]=3023; /* line # 3023 */
      Ri.ub[0]=1;
      Ra.sl[6]=3024; /* line # 3024 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000029();
      Ra.sl[6]=3025; /* line # 3025 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3027; /* line # 3027 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_work_list "  */
V PAS_COMILER_PRC_00000039(UB F_mode, V F_ty, UB F_blist){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+664;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3119; /* line # 3119 */
  Rv0=NULL;
  Ra.sl[6]=3120; /* line # 3120 */
  Ra.sl[6]=3121; /* line # 3121 */
  switch (F_mode) {
    case 2:
    case 29:Ra.sl[6]=3124; /* line # 3124 */
    P_lgt_new(&Rv0,NULL,16,NULL);
    Ra.sl[6]=3125; /* line # 3125 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+3,0,NULL,0,0,NULL);
    Ra.sl[6]=3126; /* line # 3126 */
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3127; /* line # 3127 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
    case 41:Ra.sl[6]=3131; /* line # 3131 */
    Rv2=F_ty;
    Ra.sl[6]=3133; /* line # 3133 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[6]=3134; /* line # 3134 */
      P_src_error(Rd.s+682,22,2);
    }
    Ra.sl[6]=3135; /* line # 3135 */
    P_ide_new_typ(23, &Rv3);
    Ra.sl[6]=3136; /* line # 3136 */
    P_lgt_new(&Rv0, Rv3,16,NULL);
    Ra.sl[6]=3137; /* line # 3137 */
    Rv4=Rv3;
    Ra.sl[6]=3139; /* line # 3139 */
    ((SL *)Rv4)[11]=Lx[2].sl[0];
    Ra.sl[6]=3140; /* line # 3140 */
    ((V *)Rv4)[12]=NULL;
    Ra.sl[6]=3141; /* line # 3141 */
    ((V *)Rv4)[13]=NULL;
    Ra.sl[6]=3142; /* line # 3142 */
    ((V *)Rv4)[14]=NULL;
    Ra.sl[6]=3143; /* line # 3143 */
    PAS_COMILER_PRC_00000037(6,((SL *)Rv4)+11,&Rv5, Rv3);
    Ra.sl[6]=3144; /* line # 3144 */
    if (Lx[2].v[1]==NULL) {
      Ra.sl[6]=3145; /* line # 3145 */
      ((V *)Rv4)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    }
    else {
      Ra.sl[6]=3147; /* line # 3147 */
      ((V *)Rv4)[12]=((V *)Lx[2].v[1])[3];
    }
    Ra.sl[6]=3148; /* line # 3148 */
    if (((V *)Rv4)[13]==NULL) {
      Ra.sl[6]=3149; /* line # 3149 */
      ((V *)Rv4)[13]=V_lex_ident_tree.v[V_curr_disp*8+4];
    }
    Ra.sl[6]=3150; /* line # 3150 */
    Lx[2].v[1]=((V *)Rv4)[13];
    Ra.sl[6]=3153; /* line # 3153 */
    if (((SL *)Rv3)[11]>((SL *)Rv2)[11]) ((SL *)Rv2)[11]=((SL *)Rv3)[11];
    else {
      Ra.sl[6]=3154; /* line # 3154 */
      if (((SL *)Rv3)[11]<0) ((SL *)Rv2)[11]=-1;
    }
    Ra.sl[6]=3156; /* line # 3156 */
    if (Rv5>((UB *)Rv2)[48]) ((UB *)Rv2)[48]=Rv5;
    Ra.sl[6]=3157; /* line # 3157 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=3158; /* line # 3158 */
      P_src_error(Rd.s+682,23,2);
    }
    break;
    case 22:Ra.sl[6]=3163; /* line # 3163 */
    Rv0=PAS_COMILER_PRC_00000005(F_ty,0,0,0);
    Ra.sl[6]=3164; /* line # 3164 */
    if ((V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3165; /* line # 3165 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
    default:Ra.sl[6]=3169; /* line # 3169 */
    if (F_blist) Rv0=PAS_COMILER_PRC_00000035(72,1);
    else {
      Ra.sl[6]=3170; /* line # 3170 */
      Rv0=PAS_COMILER_PRC_00000036(NULL,1);
    }
    Ra.sl[6]=3171; /* line # 3171 */
    if (Rv0==NULL) {
      Ra.sl[6]=3173; /* line # 3173 */
      P_lgt_new(&Rv0,NULL,16,NULL);
      Ra.sl[6]=3174; /* line # 3174 */
      if (F_blist) {
        Ra.sl[6]=3175; /* line # 3175 */
        Rv1=Rv0;
        Ra.sl[6]=3176; /* line # 3176 */
        ((UW *)Rv1)[10]=((UW *)Rv1)[10]|2048;
      }
    }
    Ra.sl[6]=3178; /* line # 3178 */
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3179; /* line # 3179 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
  }
  Ra.sl[6]=3181; /* line # 3181 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_definition "  */
V PAS_COMILER_PRC_00000004(UB F_mode, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 2096 );

  /* Local variable stored in C variable */
  V Rv0;
  C Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  UB Rv14;
  UB Rv15;
  UB Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  SL Rv25;
  register int Rf0;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+686;
  Ra.v[4]=Rd.s+17;
  Ra.sl[10]=3186; /* line # 3186 */
  Ra.sl[10]=3188; /* line # 3188 */
  if (F_mode==41) {
    Ra.sl[10]=3189; /* line # 3189 */
    Ra.sl[0]=abs(((SL *)F_ty)[11]);
  }
  else {
    Ra.sl[10]=3191; /* line # 3191 */
    Ra.sl[0]=0;
  }
  Ra.sl[10]=3192; /* line # 3192 */
  Rv0=NULL;
  Ra.sl[10]=3193; /* line # 3193 */
  if (F_mode==41) {
    Ra.sl[10]=3196; /* line # 3196 */
    if (F_ty!=NULL) {
      Ra.sl[10]=3197; /* line # 3197 */
      Ra.v[1]=((V *)F_ty)[13];
    }
    Ra.sl[10]=3198; /* line # 3198 */
    V_sy_casedef=1;
    Ra.sl[10]=3199; /* line # 3199 */
    Rv1=P_src_search_char();
    Ra.sl[10]=3200; /* line # 3200 */
    if (Rv1==58) {
      Ra.sl[10]=3202; /* line # 3202 */
      P_ide_new(6,NULL,&Rv2);
      Ra.sl[10]=3203; /* line # 3203 */
      Ra.v[1]=Rv2;
      Ra.sl[10]=3204; /* line # 3204 */
      P_insymbol();
      Ra.sl[10]=3205; /* line # 3205 */
      if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+682,29,2);
      else {
        Ra.sl[10]=3206; /* line # 3206 */
        P_insymbol();
      }
      Ra.sl[10]=3208; /* line # 3208 */
      Rv3=1;
    }
    else {
      Ra.sl[10]=3210; /* line # 3210 */
      Rv3=0;
    }
    Ra.sl[10]=3213; /* line # 3213 */
    V_err_prt=0;
    Ra.sl[10]=3214; /* line # 3214 */
    Rv4=P_ide_search(2);
    Ra.sl[10]=3215; /* line # 3215 */
    V_err_prt=1;
    Ra.sl[10]=3216; /* line # 3216 */
    if (!Rv3&&Rv4!=NULL) {
      Ra.sl[10]=3218; /* line # 3218 */
      Rv1=P_src_search_char();
      Ra.sl[10]=3219; /* line # 3219 */
      if (Rv1==34||Rv1==40) Rv4=NULL;
    }
    Ra.sl[10]=3221; /* line # 3221 */
    if (Rv4!=NULL) {
      Ra.sl[10]=3223; /* line # 3223 */
      Rv0=((V *)Rv4)[5];
      Ra.sl[10]=3224; /* line # 3224 */
      if (!P_comp_type(Rv0, V_typ_std.v[15],0,0)) {
        Ra.sl[10]=3227; /* line # 3227 */
        P_src_error(Rd.s+682,60,2);
        Ra.sl[10]=3228; /* line # 3228 */
        Rv0=V_typ_std.v[2];
      }
      Ra.sl[10]=3230; /* line # 3230 */
      if (Rv3) {
        Ra.sl[10]=3231; /* line # 3231 */
        Rv5=Rv2;
        Ra.sl[10]=3233; /* line # 3233 */
        ((V *)Rv5)[5]=Rv0;
        Ra.sl[10]=3234; /* line # 3234 */
        ((SL *)Rv5)[14]=P_ide_typ_align(Ra.sl[0],Rv0);
        Ra.sl[10]=3235; /* line # 3235 */
        Ra.sl[0]=((SL *)Rv5)[14]+((SL *)Rv0)[11];
        Ra.sl[10]=3237; /* line # 3237 */
        if (((UB *)Rv0)[48]>((UB *)F_ty)[48]) {
          Ra.sl[10]=3238; /* line # 3238 */
          ((UB *)F_ty)[48]=((UB *)Rv0)[48];
        }
      }
      Ra.sl[10]=3241; /* line # 3241 */
      P_lgt_new(&Rv6, Rv0,16,NULL);
      Ra.sl[10]=3242; /* line # 3242 */
      if (Rv3) ((V *)Rv6)[4]=Rv2;
      Ra.sl[10]=3243; /* line # 3243 */
      P_insymbol();
    }
  }
  Ra.sl[10]=3247; /* line # 3247 */
  if (Rv0==NULL) {
    Ra.sl[10]=3250; /* line # 3250 */
    Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
    Ra.sl[10]=3251; /* line # 3251 */
    if (F_mode==29||F_mode==41) {
      Ra.sl[10]=3252; /* line # 3252 */
      P_type_check_parm(Rv6);
    }
    else {
      Ra.sl[10]=3253; /* line # 3253 */
      if (F_mode==2) {
        Ra.sl[10]=3254; /* line # 3254 */
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[10]=3256; /* line # 3256 */
          P_src_error(Rd.s+682,61,3);
        }
      }
    }
    Ra.sl[10]=3257; /* line # 3257 */
    Rv0=((V *)Rv6)[3];
  }
  Ra.sl[10]=3260; /* line # 3260 */
  if (V_sy_sym.ub[0]!=87) P_src_error(Rd.s+682,51,2);
  Ra.sl[10]=3262; /* line # 3262 */
  P_lgt_new(&Rv7,((V *)Rv6)[3],14,NULL);
  Ra.sl[10]=3263; /* line # 3263 */
  Rv8=Rv7;
  Ra.sl[10]=3265; /* line # 3265 */
  ((V *)Rv8)[0]=Rv6;
  Ra.sl[10]=3266; /* line # 3266 */
  P_val_new(((V *)Rv8)+7,NULL);
  Ra.sl[10]=3267; /* line # 3267 */
  ((UB *)((V *)Rv8)[7])[48]=21;
  Ra.sl[10]=3269; /* line # 3269 */
  P_lgt_new(&Rv9,((V *)Rv6)[3],0, Rv7);
  Ra.sl[10]=3270; /* line # 3270 */
  ((UB *)Rv9)[41]=3;
  Ra.sl[10]=3271; /* line # 3271 */
  Rv10=0;
  for( Rf0=512;Rf0>0;Rf0-- ) {
    Ra.sl[Rv10+11]=-1;
    Rv10++;
  }
  Ra.sl[10]=3272; /* line # 3272 */
  Rv11=0;
  Rv12=1;
  Rv13=0;
  Ra.sl[10]=3273; /* line # 3273 */
  Rv14=0;
  Ra.sl[10]=3274; /* line # 3274 */
  Rv15=1;
  Ra.sl[10]=3275; /* line # 3275 */
  Rv16=V_sy_label_flag;
  while (1){
    Ra.sl[10]=3277; /* line # 3277 */
    if (Rv15) V_sy_sym.ub[0]=17;
    Ra.sl[10]=3278; /* line # 3278 */
    V_sy_label_flag=0;
    Ra.sl[10]=3279; /* line # 3279 */
    while (V_sy_sym.ub[0]==17||!Rv15){
      Ra.sl[10]=3281; /* line # 3281 */
      if (Rv15) P_insymbol();
      else {
        Ra.sl[10]=3282; /* line # 3282 */
        Rv15=1;
      }
      Ra.sl[10]=3284; /* line # 3284 */
      Rv17=PAS_COMILER_PRC_00000006(&Rv0);
      Ra.sl[10]=3285; /* line # 3285 */
      if (V_sy_sym.ub[0]==20) {
        Ra.sl[10]=3287; /* line # 3287 */
        P_insymbol();
        Rv18=PAS_COMILER_PRC_00000006(&Rv0);
        Ra.sl[10]=3288; /* line # 3288 */
        if (Rv18<Rv17) {
          Ra.sl[10]=3290; /* line # 3290 */
          Rv18=Rv17;
          P_src_error(Rd.s+682,62,2);
        }
      }
      else {
        Ra.sl[10]=3292; /* line # 3292 */
        Rv18=Rv17;
      }
      while (1){
        Ra.sl[10]=3294; /* line # 3294 */
        if (Rv12>Rv13) {
          Ra.sl[10]=3296; /* line # 3296 */
          Rv12=Rv17;
          Rv13=Rv17;
          Rv19=Rv17;
          Ra.sl[10]=3297; /* line # 3297 */
          Ra.sl[11]=Rv11;
        }
        else {
          Ra.sl[10]=3301; /* line # 3301 */
          if (Rv17>Rv13) Rv13=Rv17;
          else {
            Ra.sl[10]=3302; /* line # 3302 */
            if (Rv17<Rv12) Rv12=Rv17;
          }
          Ra.sl[10]=3303; /* line # 3303 */
          Rv20=Rv17-Rv19;
          Ra.sl[10]=3304; /* line # 3304 */
          if (Rv20<0) Rv20=(Rv20+511)+1;
          Ra.sl[10]=3305; /* line # 3305 */
          if (Rv20<0||Rv20>511) {
            Ra.sl[10]=3307; /* line # 3307 */
            P_src_error(Rd.s+682,63,3);
          }
          else {
            Ra.sl[10]=3311; /* line # 3311 */
            if (Ra.sl[Rv20+11]!=-1) {
              Ra.sl[10]=3312; /* line # 3312 */
              P_src_error(Rd.s+682,64,2);
            }
            else {
              Ra.sl[10]=3314; /* line # 3314 */
              Ra.sl[Rv20+11]=Rv11;
            }
          }
        }
        Ra.sl[10]=3317; /* line # 3317 */
        Rv17=Rv17+1;
        if (Rv17>Rv18)  break;
      }
    }
    Ra.sl[10]=3320; /* line # 3320 */
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+682,31,2);
    Ra.sl[10]=3321; /* line # 3321 */
    V_sy_label_flag=Rv16;
    Ra.sl[10]=3323; /* line # 3323 */
    Rv21=PAS_COMILER_PRC_00000039(F_mode, F_ty,0);
    Ra.sl[10]=3324; /* line # 3324 */
    if (V_sy_sym.ub[0]==18) {
      Ra.sl[10]=3326; /* line # 3326 */
      V_sy_label_flag=0;
      Ra.sl[10]=3327; /* line # 3327 */
      P_insymbol();
      Ra.sl[10]=3328; /* line # 3328 */
      Rv15=0;
    }
    Ra.sl[10]=3331; /* line # 3331 */
    if (Rv21==NULL) P_lgt_new(&Rv21,NULL,16,NULL);
    Ra.sl[10]=3332; /* line # 3332 */
    ((V *)Rv6)[0]=Rv21;
    Rv6=Rv21;
    Ra.sl[10]=3333; /* line # 3333 */
    Rv11=Rv11+1;
    if (((V_sy_sym.ub[0]==88||V_sy_sym.ub[0]==72)||V_sy_sym.ub[0]==14)||V_sy_sym
    .ub[0]==90)  break;
  }
  Ra.sl[10]=3335; /* line # 3335 */
  V_sy_label_flag=Rv16;
  Ra.sl[10]=3336; /* line # 3336 */
  if (V_sy_sym.ub[0]==88) {
    Ra.sl[10]=3338; /* line # 3338 */
    P_insymbol();
    Ra.sl[10]=3339; /* line # 3339 */
    Rv6=PAS_COMILER_PRC_00000039(F_mode, F_ty,1);
  }
  else {
    Ra.sl[10]=3343; /* line # 3343 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Ra.sl[10]=3344; /* line # 3344 */
    if (F_mode==41) {
      Ra.sl[10]=3346; /* line # 3346 */
      P_ide_new_typ(23,((V *)Rv6)+3);
      Ra.sl[10]=3347; /* line # 3347 */
      Rv22=((V *)Rv6)[3];
      Ra.sl[10]=3349; /* line # 3349 */
      ((V *)Rv22)[12]=NULL;
      Ra.sl[10]=3350; /* line # 3350 */
      ((V *)Rv22)[13]=NULL;
      Ra.sl[10]=3351; /* line # 3351 */
      ((V *)Rv22)[14]=NULL;
      Ra.sl[10]=3352; /* line # 3352 */
      ((SL *)Rv22)[11]=Ra.sl[0];
    }
  }
  Ra.sl[10]=3356; /* line # 3356 */
  Rv21=((V *)Rv7)[0];
  Ra.sl[10]=3357; /* line # 3357 */
  ((V *)Rv6)[0]=Rv21;
  Ra.sl[10]=3358; /* line # 3358 */
  ((V *)Rv7)[0]=Rv6;
  Ra.sl[10]=3359; /* line # 3359 */
  if (F_mode!=41) P_insymbol();
  Ra.sl[10]=3361; /* line # 3361 */
  ((SL *)Rv9)[4]=Rv11;
  Ra.sl[10]=3362; /* line # 3362 */
  Rv23=Rv7;
  Rv24=((V *)Rv23)[7];
  Ra.sl[10]=3364; /* line # 3364 */
  ((SL *)Rv23)[4]=Rv12;
  Ra.sl[10]=3365; /* line # 3365 */
  ((SL *)Rv24)[6]=(Rv13-Rv12)+1;
  Ra.sl[10]=3366; /* line # 3366 */
  ((V *)Rv24)[7]=P_tab_new(((SL *)Rv24)[6]);
  Ra.sl[10]=3367; /* line # 3367 */
  Rv17=Rv12-Rv19;
  Ra.sl[10]=3368; /* line # 3368 */
  if (Rv17<0) Rv17=(Rv17+511)+1;
  Ra.sl[10]=3369; /* line # 3369 */
  Rv25=0;
  for( Rf0=(Rv13-Rv12)+1;Rf0>0;Rf0-- ) {
    Ra.sl[10]=3371; /* line # 3371 */
    ((SL *)((V *)Rv24)[7])[Rv25]=Ra.sl[Rv17+11];
    Ra.sl[10]=3372; /* line # 3372 */
    Rv17=Rv17+1;
    Ra.sl[10]=3373; /* line # 3373 */
    if (Rv17>511) Rv17=0;
    Rv25++;
  }
  Ra.sl[10]=3377; /* line # 3377 */
  V_sy_casedef=0;
  Ra.sl[10]=3378; /* line # 3378 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " set_alignment_spc "  */
void PAS_COMILER_PRC_00000040(SL *F_sz, SL *F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+703;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3392; /* line # 3392 */
  Ra.sl[6]=3395; /* line # 3395 */
  if (Rs.sl[0]>0) {
    Ra.sl[6]=3397; /* line # 3397 */
    (*F_sz)=Rs.sl[0];
    Rv0=(*F_sz);
    Rs.sl[0]=-1;
    Ra.sl[6]=3398; /* line # 3398 */
    if (Rs.sl[1]<0) {
      Ra.sl[6]=3400; /* line # 3400 */
      (*F_aln)=1;
      Ra.sl[6]=3401; /* line # 3401 */
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3402; /* line # 3402 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  Ra.sl[6]=3405; /* line # 3405 */
  if (Rs.sl[1]>=0) {
    Ra.sl[6]=3406; /* line # 3406 */
    (*F_aln)=Rs.sl[1];
    Rs.sl[1]=-1;
  }
  Ra.sl[6]=3407; /* line # 3407 */
  if (V_sy_sym.ub[0]==73) {
    Ra.sl[6]=3409; /* line # 3409 */
    P_insymbol();
    Ra.sl[6]=3411; /* line # 3411 */
    (*F_sz)=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
    Ra.sl[6]=3412; /* line # 3412 */
    if ((*F_sz)<1) (*F_sz)=1;
    Ra.sl[6]=3413; /* line # 3413 */
    Rv0=(*F_sz);
    Ra.sl[6]=3414; /* line # 3414 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=3416; /* line # 3416 */
      P_insymbol();
      Ra.sl[6]=3417; /* line # 3417 */
      Rv0=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
      Ra.sl[6]=3418; /* line # 3418 */
      if (Rv0>256) P_src_error(Rd.s+724,231,2);
    }
    Ra.sl[6]=3420; /* line # 3420 */
    if (Rv0<0||Rv0>256) Rv0=((SL *)V_typ_std.v[4])[11];
    Ra.sl[6]=3421; /* line # 3421 */
    if (Rv0<=1) (*F_aln)=0;
    else {
      Ra.sl[6]=3423; /* line # 3423 */
      (*F_aln)=1;
      Ra.sl[6]=3424; /* line # 3424 */
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3425; /* line # 3425 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " conformant_def "  */
void PAS_COMILER_PRC_00000041(V *F_tr, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+728;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3444; /* line # 3444 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[6]=3445; /* line # 3445 */
  P_ide_new_typ(22, F_tr);
  Ra.sl[6]=3446; /* line # 3446 */
  Rv2=(*F_tr);
  Ra.sl[6]=3448; /* line # 3448 */
  if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv0);
  else {
    Ra.sl[6]=3449; /* line # 3449 */
    P_src_error(Rd.s+746,232,3);
  }
  Ra.sl[6]=3450; /* line # 3450 */
  P_insymbol();
  Ra.sl[6]=3451; /* line # 3451 */
  if (V_sy_sym.ub[0]==20) {
    Ra.sl[6]=3453; /* line # 3453 */
    P_insymbol();
    Ra.sl[6]=3454; /* line # 3454 */
    if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv1);
    else {
      Ra.sl[6]=3455; /* line # 3455 */
      P_src_error(Rd.s+746,232,3);
    }
    Ra.sl[6]=3456; /* line # 3456 */
    P_insymbol();
  }
  Ra.sl[6]=3458; /* line # 3458 */
  if (V_sy_sym.ub[0]==21) {
    Ra.sl[6]=3460; /* line # 3460 */
    P_insymbol();
    Ra.sl[6]=3461; /* line # 3461 */
    PAS_COMILER_PRC_00000038(((V *)Rv2),0,NULL,0,0,NULL);
    Ra.sl[6]=3462; /* line # 3462 */
    ((SL *)Rv2)[11]=((SL *)((V *)Rv2)[0])[11];
    Ra.sl[6]=3463; /* line # 3463 */
    memcpy(Rv2+48,((V *)Rv2)[0]+48,1);
    Ra.sl[6]=3464; /* line # 3464 */
    if (Rv0!=NULL) {
      Ra.sl[6]=3466; /* line # 3466 */
      ((V *)Rv0)[5]=((V *)Rv2)[0];
      Ra.sl[6]=3467; /* line # 3467 */
      ((UB *)Rv0)[86]=9;
      Ra.sl[6]=3468; /* line # 3468 */
      ((UW *)Rv0)[42]=32;
      Ra.sl[6]=3469; /* line # 3469 */
      if (Rv1==NULL) {
        Ra.sl[6]=3471; /* line # 3471 */
        ((V *)Rv2)[13]=P_lgt_new_econst(((V *)Rv2)[0],1);
        Ra.sl[6]=3472; /* line # 3472 */
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=3473; /* line # 3473 */
        ((V *)Rv2)[12]=P_lgt_link(((V *)Rv2)[14]);
        Ra.sl[6]=3474; /* line # 3474 */
        ((V *)((V *)Rv2)[12])[3]=V_int_typ;
        Ra.sl[6]=3475; /* line # 3475 */
        (*F_ndim)=(*F_ndim)+1;
      }
      else {
        Ra.sl[6]=3479; /* line # 3479 */
        ((V *)Rv1)[5]=((V *)Rv2)[0];
        Ra.sl[6]=3480; /* line # 3480 */
        ((UB *)Rv1)[86]=9;
        Ra.sl[6]=3481; /* line # 3481 */
        ((UW *)Rv1)[42]=32;
        Ra.sl[6]=3482; /* line # 3482 */
        ((V *)Rv2)[13]=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=3483; /* line # 3483 */
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=3484; /* line # 3484 */
        Rv3=P_lgt_link(((V *)Rv2)[14]);
        Ra.sl[6]=3485; /* line # 3485 */
        ((V *)Rv3)[0]=P_lgt_link(((V *)Rv2)[13]);
        Ra.sl[6]=3486; /* line # 3486 */
        Rv3=P_lgt_new_code(50, Rv3);
        Ra.sl[6]=3487; /* line # 3487 */
        ((V *)Rv3)[0]=P_lgt_new_econst(V_int_typ,1);
        Ra.sl[6]=3488; /* line # 3488 */
        ((V *)Rv2)[12]=P_lgt_new_code(49, Rv3);
        Ra.sl[6]=3489; /* line # 3489 */
        (*F_ndim)=(*F_ndim)+2;
      }
    }
  }
  else {
    Ra.sl[6]=3492; /* line # 3492 */
    P_src_error(Rd.s+746,31,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_def "  */
void PAS_COMILER_PRC_00000042(V *F_art, UB F_bconf, SL *F_ndim, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+750;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3511; /* line # 3511 */
  P_insymbol();
  Ra.sl[6]=3512; /* line # 3512 */
  if (F_bconf) P_ide_new_typ(9, F_art);
  else {
    Ra.sl[6]=3513; /* line # 3513 */
    P_ide_new_typ(8, F_art);
  }
  Ra.sl[6]=3514; /* line # 3514 */
  Rv0=(*F_art);
  Ra.sl[6]=3516; /* line # 3516 */
  ((V *)Rv0)[3]=F_owid;
  Ra.sl[6]=3517; /* line # 3517 */
  ((V *)Rv0)[15]=NULL;
  Ra.sl[6]=3518; /* line # 3518 */
  if (F_bconf) {
    Ra.sl[6]=3519; /* line # 3519 */
    PAS_COMILER_PRC_00000041(((V *)Rv0)+15,F_ndim);
  }
  else {
    Ra.sl[6]=3522; /* line # 3522 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+15,0,NULL,0,0,NULL);
    Ra.sl[6]=3523; /* line # 3523 */
    (*F_ndim)=(*F_ndim)+2;
  }
  Ra.sl[6]=3525; /* line # 3525 */
  Rv1=NULL;
  Rv2=1;
  Ra.sl[6]=3526; /* line # 3526 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=3527; /* line # 3527 */
    Rv3=((V *)Rv0)[15];
    Ra.sl[6]=3529; /* line # 3529 */
    switch (((UB *)Rv3)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=3531; /* line # 3531 */
      if (((UB *)Rv3)[112]) Rv2=(((UL *)Rv3)[30]-((UL *)Rv3)[29])+1;
      else {
        Ra.sl[6]=3532; /* line # 3532 */
        Rv2=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
      break;
      case 22:Ra.sl[6]=3534; /* line # 3534 */
      Rv1=P_lgt_link(((V *)Rv3)[12]);
      break;
      default:Ra.sl[6]=3537; /* line # 3537 */
      P_src_error(Rd.s+763,210,3);
      break;
    }
  }
  Ra.sl[6]=3542; /* line # 3542 */
  if (V_sy_sym.ub[0]==17) {
    Ra.sl[6]=3544; /* line # 3544 */
    PAS_COMILER_PRC_00000042(((V *)Rv0)+14,F_bconf, F_ndim,NULL);
    Ra.sl[6]=3545; /* line # 3545 */
    ((SL *)Rv0)[24]=(*F_ndim);
  }
  else {
    Ra.sl[6]=3549; /* line # 3549 */
    ((SL *)Rv0)[24]=(*F_ndim);
    Ra.sl[6]=3550; /* line # 3550 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else {
      Ra.sl[6]=3551; /* line # 3551 */
      P_src_error(Rd.s+763,26,2);
    }
    Ra.sl[6]=3552; /* line # 3552 */
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else {
      Ra.sl[6]=3553; /* line # 3553 */
      P_src_error(Rd.s+763,51,2);
    }
    Ra.sl[6]=3554; /* line # 3554 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+14,0,NULL,0,0,NULL);
  }
  Ra.sl[6]=3558; /* line # 3558 */
  if (((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=3561; /* line # 3561 */
    ((UB *)Rv0)[48]=((UB *)((V *)Rv0)[14])[48];
    Ra.sl[6]=3563; /* line # 3563 */
    Rv4=((V *)Rv0)[14];
    Ra.sl[6]=3565; /* line # 3565 */
    Rv5=NULL;
    Ra.sl[6]=3566; /* line # 3566 */
    Rv6=((SL *)Rv4)[11];
    Ra.sl[6]=3567; /* line # 3567 */
    Rv7=((V *)Rv4)[9];
    Ra.sl[6]=3568; /* line # 3568 */
    memcpy(Ra.s+28,Rv4+48,1);
    Ra.sl[6]=3569; /* line # 3569 */
    if (Rv6>0) Rv6=P_typ_alignement(Rv6, Rv4+48);
    Ra.sl[6]=3570; /* line # 3570 */
    if (Rv6>=0) Rv7=NULL;
    Ra.sl[6]=3572; /* line # 3572 */
    if (Rv7!=NULL) {
      Ra.sl[6]=3573; /* line # 3573 */
      if (((UB *)Rv7)[40]==14) Rv6=((SL *)((V *)Rv7)[7])[13];
      else {
        Ra.sl[6]=3574; /* line # 3574 */
        P_lgt_copy_tree(Rv7, &Rv5);
      }
    }
    Ra.sl[6]=3575; /* line # 3575 */
    if ((Rv5!=NULL&&((UB *)Rv0)[48]>0)&&((UB *)((V *)Rv0)[14])[93]!=8) {
      Ra.sl[6]=3578; /* line # 3578 */
      Rv8=1;
      Ra.sl[6]=3579; /* line # 3579 */
      if ((((UB *)Rv5)[40]==6&&((UB *)Rv5)[41]==49)&&((V *)Rv5)[1]!=NULL) {
        Ra.sl[6]=3582; /* line # 3582 */
        if (((V *)((V *)Rv5)[1])[0]!=NULL) {
          Ra.sl[6]=3583; /* line # 3583 */
          Rv9=((V *)((V *)Rv5)[1])[0];
          Ra.sl[6]=3584; /* line # 3584 */
          if (((UB *)Rv9)[40]==14&&((V *)Rv9)[7]!=NULL) {
            Ra.sl[6]=3586; /* line # 3586 */
            Rv10=((SL *)((V *)Rv9)[7])[13]+Ra.ub[28];
            Ra.sl[6]=3587; /* line # 3587 */
            P_val_free(((V *)Rv9)+7);
            Ra.sl[6]=3588; /* line # 3588 */
            P_val_new(((V *)Rv9)+7,V_int_typ);
            Ra.sl[6]=3589; /* line # 3589 */
            ((SL *)((V *)Rv9)[7])[13]=Rv10;
            Ra.sl[6]=3590; /* line # 3590 */
            Rv8=0;
          }
        }
      }
      Ra.sl[6]=3592; /* line # 3592 */
      if (Rv8) {
        Ra.sl[6]=3594; /* line # 3594 */
        ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
        Ra.sl[6]=3595; /* line # 3595 */
        Rv5=P_lgt_new_code(49, Rv5);
      }
      Ra.sl[6]=3597; /* line # 3597 */
      ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
      Ra.sl[6]=3598; /* line # 3598 */
      Rv5=P_lgt_new_code(13, Rv5);
    }
    Ra.sl[6]=3601; /* line # 3601 */
    ((V *)Rv0)[13]=Rv5;
    Ra.sl[6]=3602; /* line # 3602 */
    ((SL *)Rv0)[25]=Rv6;
    Ra.sl[6]=3605; /* line # 3605 */
    if (((UB *)((V *)Rv0)[14])[91]||((SL *)((V *)Rv0)[14])[10]>0) {
      Ra.sl[6]=3606; /* line # 3606 */
      ((UB *)Rv0)[91]=1;
    }
    Ra.sl[6]=3609; /* line # 3609 */
    ((SL *)Rv0)[11]=((SL *)Rv0)[25]*Rv2;
    Ra.sl[6]=3610; /* line # 3610 */
    if (Rv1==NULL&&((V *)Rv0)[13]==NULL) {
      Ra.sl[6]=3611; /* line # 3611 */
      ((V *)Rv0)[9]=NULL;
    }
    else {
      Ra.sl[6]=3614; /* line # 3614 */
      if (Rv1==NULL) {
        Ra.sl[6]=3616; /* line # 3616 */
        Rv1=P_lgt_new_econst(V_int_typ, Rv2);
        Ra.sl[6]=3617; /* line # 3617 */
        ((V *)Rv1)[0]=((V *)Rv0)[13];
        Ra.sl[6]=3618; /* line # 3618 */
        ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
      }
      else {
        Ra.sl[6]=3621; /* line # 3621 */
        if (((V *)Rv0)[13]==NULL) {
          Ra.sl[6]=3622; /* line # 3622 */
          if (((SL *)Rv0)[25]==1) {
            Ra.sl[6]=3623; /* line # 3623 */
            ((V *)Rv0)[9]=Rv1;
          }
          else {
            Ra.sl[6]=3626; /* line # 3626 */
            ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
            Ra.sl[6]=3627; /* line # 3627 */
            ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
          }
        }
        else {
          Ra.sl[6]=3631; /* line # 3631 */
          ((V *)Rv1)[0]=((V *)Rv0)[13];
          Ra.sl[6]=3632; /* line # 3632 */
          ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
        }
      }
      Ra.sl[6]=3634; /* line # 3634 */
      ((SL *)Rv0)[11]=-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_spc "  */
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  SL Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  SL Rv24;
  SL Rv25;
  register V Rv26;
  SL Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;
  register V Rv31;
  register V Rv32;
  V Rv33;
  register V Rv34;
  register V Rv35;
  V Rv36;
  V Rv37;
  register V Rv38;
  register UB Rv39;
  register V Rv40;
  SL Rv41;
  V Rv42;
  register V Rv43;
  register V Rv44;
  register V Rv45;
  register V Rv46;
  register V Rv47;
  register V Rv48;
  register V Rv49;
  register V Rv50;
  register V Rv51;
  register V Rv52;
  register V Rv53;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+767;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3667; /* line # 3667 */
  V_sy_type_gfirst=NULL;
  Ra.sl[6]=3668; /* line # 3668 */
  Ra.sl[6]=3670; /* line # 3670 */
  Rv0=NULL;
  Ra.sl[6]=3671; /* line # 3671 */
  if (V_sy_sym.ub[0]==37) P_insymbol();
  Ra.sl[6]=3672; /* line # 3672 */
  switch (V_sy_sym.ub[0]) {
    case 29:Ra.sl[6]=3675; /* line # 3675 */
    Rv18=0;
    Ra.sl[6]=3676; /* line # 3676 */
    P_insymbol();
    Ra.sl[6]=3678; /* line # 3678 */
    if (V_sy_sym.ub[0]!=56) P_src_error(Rd.s+779,182,2);
    else {
      Ra.sl[6]=3679; /* line # 3679 */
      P_insymbol();
    }
    Ra.sl[6]=3680; /* line # 3680 */
    P_ide_new_typ(27, &Rv0);
    Ra.sl[6]=3681; /* line # 3681 */
    ((V *)Rv0)[9]=PAS_COMILER_PRC_00000004(29,NULL);
    break;
    case 58:Ra.sl[6]=3686; /* line # 3686 */
    P_insymbol();
    Ra.sl[6]=3687; /* line # 3687 */
    Rv1=P_ide_search(2);
    Ra.sl[6]=3688; /* line # 3688 */
    P_insymbol();
    Ra.sl[6]=3689; /* line # 3689 */
    if (Rv1!=V_ide_udptr.v[1]) {
      Ra.sl[6]=3690; /* line # 3690 */
      Rv19=Rv1;
      Ra.sl[6]=3692; /* line # 3692 */
      P_ide_new_typ(((UB *)((V *)Rv1)[5])[93],&Rv0);
      Ra.sl[6]=3693; /* line # 3693 */
      V_sy_type_gfirst=((V *)Rv19)[10];
      Ra.sl[6]=3694; /* line # 3694 */
      Rv20=Rv0;
      Ra.sl[6]=3696; /* line # 3696 */
      ((V *)Rv20)[3]=F_owid;
      Ra.sl[6]=3697; /* line # 3697 */
      ((V *)Rv20)[0]=((V *)Rv19)[5];
      Ra.sl[6]=3698; /* line # 3698 */
      ((V *)Rv20)[4]=((V *)((V *)Rv20)[0])[4];
      Ra.sl[6]=3699; /* line # 3699 */
      ((SL *)Rv20)[11]=((SL *)((V *)Rv20)[0])[11];
      Ra.sl[6]=3700; /* line # 3700 */
      ((SL *)Rv20)[10]=((SL *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3701; /* line # 3701 */
      memcpy(Rv20+48,((V *)Rv20)[0]+48,1);
      Ra.sl[6]=3702; /* line # 3702 */
      ((V *)Rv20)[10]=((V *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3703; /* line # 3703 */
      ((UB *)Rv20)[91]=((UB *)((V *)Rv20)[0])[91];
      Ra.sl[6]=3704; /* line # 3704 */
      if (((V *)Rv20)[9]!=NULL) {
        Ra.sl[6]=3705; /* line # 3705 */
        ((V *)Rv20)[9]=P_lgt_link(((V *)((V *)Rv20)[0])[9]);
      }
      Ra.sl[6]=3706; /* line # 3706 */
      switch (((UB *)Rv20)[93]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=3709; /* line # 3709 */
        ((SL *)Rv20)[29]=((SL *)((V *)Rv20)[0])[29];
        Ra.sl[6]=3710; /* line # 3710 */
        ((SL *)Rv20)[30]=((SL *)((V *)Rv20)[0])[30];
        Ra.sl[6]=3711; /* line # 3711 */
        ((UB *)Rv20)[112]=((UB *)((V *)Rv20)[0])[112];
        Ra.sl[6]=3712; /* line # 3712 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 22:Ra.sl[6]=3717; /* line # 3717 */
        ((V *)Rv20)[12]=P_lgt_link(((V *)((V *)Rv20)[0])[12]);
        Ra.sl[6]=3718; /* line # 3718 */
        ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        Ra.sl[6]=3719; /* line # 3719 */
        ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        break;
        case 3:
        case 4:break;
        case 5:
        case 7:
        case 24:
        case 26:Ra.sl[6]=3726; /* line # 3726 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 11:
        case 12:Ra.sl[6]=3729; /* line # 3729 */
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        break;
        case 8:Ra.sl[6]=3733; /* line # 3733 */
        ((SL *)Rv20)[25]=((SL *)((V *)Rv20)[0])[25];
        Ra.sl[6]=3734; /* line # 3734 */
        if (((V *)((V *)Rv20)[0])[13]!=NULL) {
          Ra.sl[6]=3735; /* line # 3735 */
          ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        }
        else {
          Ra.sl[6]=3738; /* line # 3738 */
          ((V *)Rv20)[13]=NULL;
        }
        Ra.sl[6]=3739; /* line # 3739 */
        ((V *)Rv20)[14]=((V *)((V *)Rv20)[0])[14];
        Ra.sl[6]=3740; /* line # 3740 */
        ((V *)Rv20)[15]=((V *)((V *)Rv20)[0])[15];
        break;
        case 10:Ra.sl[6]=3745; /* line # 3745 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        Ra.sl[6]=3746; /* line # 3746 */
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        Ra.sl[6]=3747; /* line # 3747 */
        if (((V *)((V *)Rv20)[0])[14]!=NULL) {
          Ra.sl[6]=3748; /* line # 3748 */
          ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        }
        else {
          Ra.sl[6]=3750; /* line # 3750 */
          ((V *)Rv20)[14]=NULL;
        }
        break;
        case 14:
        case 15:
        case 19:
        case 21:Ra.sl[6]=3758; /* line # 3758 */
        Rv10=((SL *)Rv20)[11];
        Ra.sl[6]=3759; /* line # 3759 */
        Rv11=((UB *)Rv20)[48];
        Ra.sl[6]=3760; /* line # 3760 */
        PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
        Ra.sl[6]=3761; /* line # 3761 */
        if (Rv10<((SL *)Rv20)[11]) P_src_error(Rd.s+779,214,2);
        else {
          Ra.sl[6]=3762; /* line # 3762 */
          ((SL *)Rv20)[11]=Rv10;
        }
        Ra.sl[6]=3763; /* line # 3763 */
        if (Rv11>=0) ((UB *)Rv20)[48]=Rv11;
        break;
        default:Ra.sl[6]=3768; /* line # 3768 */
        P_src_error(Rd.s+779,206,3);
        break;
      }
    }
    break;
    case 43:Ra.sl[6]=3776; /* line # 3776 */
    if (F_parm!=NULL) P_src_error(Rd.s+779,207,2);
    Ra.sl[6]=3777; /* line # 3777 */
    P_insymbol();
    Ra.sl[6]=3778; /* line # 3778 */
    if (V_sy_sym.ub[0]==38) {
      Ra.sl[6]=3779; /* line # 3779 */
      if (F_bdeforg) {
        Ra.sl[6]=3781; /* line # 3781 */
        P_insymbol();
        Ra.sl[6]=3782; /* line # 3782 */
        P_ide_new_typ(24, &Rv0);
        Ra.sl[6]=3783; /* line # 3783 */
        Rv21=Rv0;
        Ra.sl[6]=3785; /* line # 3785 */
        ((V *)Rv21)[3]=F_owid;
        Ra.sl[6]=3786; /* line # 3786 */
        ((V *)Rv21)[12]=NULL;
        Ra.sl[6]=3787; /* line # 3787 */
        ((SL *)Rv21)[11]=V_fptr_size;
        Ra.sl[6]=3788; /* line # 3788 */
        memcpy(Rv21+48,V_typ_std.v[5]+48,1);
        Ra.sl[6]=3789; /* line # 3789 */
        ((V *)Rv21)[9]=NULL;
      }
      else {
        Ra.sl[6]=3793; /* line # 3793 */
        P_src_error(Rd.s+779,208,3);
      }
    }
    else {
      Ra.sl[6]=3796; /* line # 3796 */
      P_ide_new_typ(26, &Rv0);
      Ra.sl[6]=3797; /* line # 3797 */
      Rv22=Rv0;
      Ra.sl[6]=3799; /* line # 3799 */
      ((V *)Rv22)[12]=NULL;
      Ra.sl[6]=3800; /* line # 3800 */
      ((V *)Rv22)[9]=NULL;
      Ra.sl[6]=3802; /* line # 3802 */
      memcpy(Rv22+48,V_typ_std.v[2]+48,1);
      Ra.sl[6]=3803; /* line # 3803 */
      ((SL *)Rv22)[11]=1;
    }
    Ra.sl[6]=3806; /* line # 3806 */
    Rv23=Rv0;
    Ra.sl[6]=3809; /* line # 3809 */
    Rv10=((SL *)Rv23)[11];
    Ra.sl[6]=3810; /* line # 3810 */
    Rv11=((UB *)Rv23)[48];
    Ra.sl[6]=3811; /* line # 3811 */
    PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
    Ra.sl[6]=3812; /* line # 3812 */
    if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv0);
    Ra.sl[6]=3813; /* line # 3813 */
    if (Rv10<((SL *)Rv23)[11]) P_src_error(Rd.s+779,214,2);
    else {
      Ra.sl[6]=3814; /* line # 3814 */
      ((SL *)Rv23)[11]=Rv10;
    }
    Ra.sl[6]=3815; /* line # 3815 */
    if (Rv11>=0) ((UB *)Rv23)[48]=Rv11;
    break;
    case 40:Ra.sl[6]=3821; /* line # 3821 */
    P_insymbol();
    Ra.sl[6]=3822; /* line # 3822 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+779,25,2);
    Ra.sl[6]=3823; /* line # 3823 */
    Rv24=0;
    Ra.sl[6]=3824; /* line # 3824 */
    PAS_COMILER_PRC_00000042(&Rv0,0, &Rv24, F_owid);
    Ra.sl[6]=3826; /* line # 3826 */
    if (V_ima_typ==NULL) V_ima_typ=Rv0;
    break;
    case 41:Ra.sl[6]=3831; /* line # 3831 */
    Rv25=V_curr_disp;
    Ra.sl[6]=3832; /* line # 3832 */
    P_ide_new_typ(10, &Rv0);
    Ra.sl[6]=3833; /* line # 3833 */
    Rv26=Rv0;
    Ra.sl[6]=3835; /* line # 3835 */
    ((V *)Rv26)[3]=F_owid;
    Ra.sl[6]=3836; /* line # 3836 */
    ((SL *)Rv26)[10]=F_descr_sz;
    Ra.sl[6]=3837; /* line # 3837 */
    ((SL *)Rv26)[11]=((SL *)Rv26)[10];
    Ra.sl[6]=3838; /* line # 3838 */
    ((V *)Rv26)[12]=NULL;
    ((V *)Rv26)[13]=NULL;
    Ra.sl[6]=3839; /* line # 3839 */
    ((V *)Rv26)[14]=NULL;
    Ra.sl[6]=3840; /* line # 3840 */
    Rv1=NULL;
    Ra.sl[6]=3842; /* line # 3842 */
    P_insymbol();
    Ra.sl[6]=3843; /* line # 3843 */
    P_new_disp_level(NULL,1);
    Ra.sl[6]=3844; /* line # 3844 */
    Lx[5].ub[0]=0;
    Ra.sl[6]=3845; /* line # 3845 */
    PAS_COMILER_PRC_00000037(6,((SL *)Rv0)+11,&Rv27, Rv0);
    Ra.sl[6]=3846; /* line # 3846 */
    Rv28=Rv0;
    Ra.sl[6]=3848; /* line # 3848 */
    ((UB *)Rv28)[91]=Lx[5].ub[0];
    Ra.sl[6]=3849; /* line # 3849 */
    ((V *)Rv28)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    Ra.sl[6]=3850; /* line # 3850 */
    if (((V *)Rv28)[14]==NULL) {
      Ra.sl[6]=3851; /* line # 3851 */
      ((V *)Rv28)[13]=V_lex_ident_tree.v[V_curr_disp*8+4];
    }
    Ra.sl[6]=3853; /* line # 3853 */
    V_curr_disp=V_curr_disp -1;
    Ra.sl[6]=3856; /* line # 3856 */
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else P_src_error(Rd.s+779,54,2);
    Ra.sl[6]=3857; /* line # 3857 */
    if (V_typ_std.v[10]==NULL) {
      Ra.sl[6]=3859; /* line # 3859 */
      V_typ_std.v[10]=Rv0;
      Ra.sl[6]=3860; /* line # 3860 */
      Rv29=Rv0;
      Ra.sl[6]=3862; /* line # 3862 */
      V_stri_descrsz=((SL *)Rv29)[10];
      Ra.sl[6]=3863; /* line # 3863 */
      V_stri_lengthsz=((SL *)((V *)((V *)Rv29)[12])[5])[11];
      Ra.sl[6]=3864; /* line # 3864 */
      V_stri_stroffset=((SL *)((V *)((V *)Rv29)[12])[3])[14];
    }
    break;
    case 39:Ra.sl[6]=3871; /* line # 3871 */
    P_insymbol();
    Ra.sl[6]=3872; /* line # 3872 */
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+779,51,2);
    Ra.sl[6]=3873; /* line # 3873 */
    P_ide_new_typ(7, &Rv0);
    Ra.sl[6]=3874; /* line # 3874 */
    Rv30=Rv0;
    Ra.sl[6]=3876; /* line # 3876 */
    ((V *)Rv30)[3]=F_owid;
    Ra.sl[6]=3877; /* line # 3877 */
    memcpy(Rv30+48,V_typ_std.v[16]+48,1);
    Ra.sl[6]=3878; /* line # 3878 */
    ((SL *)Rv30)[11]=((SL *)V_typ_std.v[16])[11];
    Ra.sl[6]=3879; /* line # 3879 */
    ((V *)Rv30)[10]=((V *)V_typ_std.v[16])[10];
    Ra.sl[6]=3880; /* line # 3880 */
    ((V *)Rv30)[0]=V_typ_std.v[16];
    Ra.sl[6]=3882; /* line # 3882 */
    PAS_COMILER_PRC_00000038(((V *)Rv30)+12,0,NULL,0,0,NULL);
    Ra.sl[6]=3885; /* line # 3885 */
    if (((UB *)((V *)Rv30)[12])[91]||((SL *)((V *)Rv30)[12])[10]>0) ((UB *)Rv30)
    [91]=1;
    Ra.sl[6]=3887; /* line # 3887 */
    if (((SL *)((V *)Rv30)[12])[11]<=0) P_src_error(Rd.s+779,149,3);
    Ra.sl[6]=3889; /* line # 3889 */
    if (V_typ_std.v[7]==NULL) {
      Ra.sl[6]=3891; /* line # 3891 */
      V_typ_std.v[7]=Rv0;
    }
    break;
    case 23:
    case 38:Ra.sl[6]=3897; /* line # 3897 */
    P_insymbol();
    Ra.sl[6]=3898; /* line # 3898 */
    if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
      Ra.sl[6]=3899; /* line # 3899 */
      Rv0=PAS_COMILER_PRC_00000002(V_sy_sym.ub[0]==77,NULL);
    }
    else {
      Ra.sl[6]=3902; /* line # 3902 */
      P_ide_new_typ(5, &Rv0);
      Ra.sl[6]=3903; /* line # 3903 */
      Rv31=Rv0;
      Ra.sl[6]=3905; /* line # 3905 */
      ((V *)Rv31)[3]=F_owid;
      Ra.sl[6]=3906; /* line # 3906 */
      memcpy(Rv31+48,V_typ_std.v[13]+48,1);
      Ra.sl[6]=3907; /* line # 3907 */
      ((SL *)Rv31)[11]=V_fptr_size;
      Ra.sl[6]=3908; /* line # 3908 */
      ((V *)Rv31)[0]=V_typ_std.v[13];
      Ra.sl[6]=3909; /* line # 3909 */
      V_err_prt=0;
      Ra.sl[6]=3910; /* line # 3910 */
      Rv1=P_ide_search(2);
      Ra.sl[6]=3911; /* line # 3911 */
      V_err_prt=1;
      Ra.sl[6]=3912; /* line # 3912 */
      if (Rv1==NULL) {
        Ra.sl[6]=3914; /* line # 3914 */
        P_ide_new(1, Rv0, &Rv1);
        Ra.sl[6]=3915; /* line # 3915 */
        ((V *)Rv1)[7]=Lx[5].v[1];
        Ra.sl[6]=3916; /* line # 3916 */
        Lx[5].v[1]=Rv1;
      }
      else {
        Ra.sl[6]=3918; /* line # 3918 */
        ((V *)Rv31)[12]=((V *)Rv1)[5];
      }
      Ra.sl[6]=3919; /* line # 3919 */
      P_insymbol();
      Ra.sl[6]=3921; /* line # 3921 */
      V_sy_type_gfirst=P_new_oper(0, Rv0, V_typ_std.v[5],0,128,NULL,0,0);
    }
    break;
    case 13:Ra.sl[6]=3927; /* line # 3927 */
    if (V_ima_typ!=NULL) {
      Ra.sl[6]=3928; /* line # 3928 */
      if (((V *)V_ima_typ)[4]!=NULL) {
        Ra.sl[6]=3930; /* line # 3930 */
        P_insymbol();
        Ra.sl[6]=3931; /* line # 3931 */
        if (((SL *)V_typ_std.v[1])[30]==0) {
          Ra.sl[6]=3932; /* line # 3932 */
          Rv0=V_typ_std.v[1];
        }
        else {
          Ra.sl[6]=3934; /* line # 3934 */
          P_ide_new_typ(1, &Rv0);
        }
        Ra.sl[6]=3935; /* line # 3935 */
        Rv32=Rv0;
        Ra.sl[6]=3937; /* line # 3937 */
        ((V *)Rv32)[3]=F_owid;
        Ra.sl[6]=3938; /* line # 3938 */
        ((SL *)Rv32)[11]=((SL *)V_typ_std.v[0])[11];
        Ra.sl[6]=3939; /* line # 3939 */
        ((SL *)Rv32)[29]=0;
        Ra.sl[6]=3940; /* line # 3940 */
        ((SL *)Rv32)[30]=-1;
        ((V *)Rv32)[0]=NULL;
        Ra.sl[6]=3941; /* line # 3941 */
        ((UB *)Rv32)[112]=1;
        Ra.sl[6]=3942; /* line # 3942 */
        memcpy(Rv32+48,V_typ_std.v[0]+48,1);
        Ra.sl[6]=3943; /* line # 3943 */
        Rv25=0;
        Ra.sl[6]=3944; /* line # 3944 */
        Rv33=NULL;
        Ra.sl[6]=3945; /* line # 3945 */
        Rv10=0;
        Ra.sl[6]=3946; /* line # 3946 */
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=3948; /* line # 3948 */
          if (V_sy_ident.ub[0]>Rv25) Rv25=V_sy_ident.ub[0];
          Ra.sl[6]=3949; /* line # 3949 */
          P_ide_new(4, Rv0, &Rv1);
          Ra.sl[6]=3951; /* line # 3951 */
          if (((V *)Rv32)[12]==NULL) ((V *)Rv32)[12]=Rv1;
          Ra.sl[6]=3952; /* line # 3952 */
          ((SL *)Rv32)[30]=((SL *)Rv32)[30]+1;
          Ra.sl[6]=3953; /* line # 3953 */
          Rv34=Rv1;
          Ra.sl[6]=3956; /* line # 3956 */
          P_val_new(((V *)Rv34)+7,Rv0);
          Ra.sl[6]=3957; /* line # 3957 */
          Rv35=((V *)Rv34)[7];
          Ra.sl[6]=3959; /* line # 3959 */
          ((UB *)Rv35)[48]=1;
          Ra.sl[6]=3960; /* line # 3960 */
          ((SL *)Rv35)[13]=((SL *)Rv32)[30];
          Ra.sl[6]=3962; /* line # 3962 */
          Rv36=NULL;
          Ra.sl[6]=3964; /* line # 3964 */
          P_val_new(&Rv36,NULL);
          Ra.sl[6]=3966; /* line # 3966 */
          if (Rv33==NULL) Rv33=Rv36;
          else {
            Ra.sl[6]=3967; /* line # 3967 */
            ((V *)Rv37)[0]=Rv36;
          }
          Ra.sl[6]=3968; /* line # 3968 */
          Rv37=Rv36;
          Ra.sl[6]=3969; /* line # 3969 */
          Rv38=Rv36;
          Ra.sl[6]=3971; /* line # 3971 */
          ((UB *)Rv38)[48]=29;
          Ra.sl[6]=3972; /* line # 3972 */
          ((SL *)Rv38)[6]=0;
          Ra.sl[6]=3973; /* line # 3973 */
          Rv39=V_sy_ident.ub[0]+1;
          ((V *)Rv38)[7]=PAS__NEW((SL)Rv39+2);
          ((UB *)((V *)Rv38)[7])[0]=Rv39;
          Ra.sl[6]=3974; /* line # 3974 */
          ((V *)Rv38)[4]=((V *)V_ima_typ)[14];
          Ra.sl[6]=3975; /* line # 3975 */
          Rv40=((V *)Rv38)[7];
          Ra.sl[6]=3977; /* line # 3977 */
          ((UB *)Rv40)[1]=V_sy_ident.ub[0]+1;
          Ra.sl[6]=3978; /* line # 3978 */
          ((C *)Rv40)[2]=V_sy_ident.c[0];
          Ra.sl[6]=3979; /* line # 3979 */
          Rv41=1;
          for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
            Ra.sl[6]=3980; /* line # 3980 */
            ((C *)Rv40)[(Rv41+1)+1]=V_sy_ident.c[Rv41];
            Rv41++;
          }
          Ra.sl[6]=3984; /* line # 3984 */
          P_insymbol();
          Ra.sl[6]=3985; /* line # 3985 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=3987; /* line # 3987 */
            if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+779,23,2);
          }
          Ra.sl[6]=3988; /* line # 3988 */
          if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+779,27,2);
        }
        Ra.sl[6]=3990; /* line # 3990 */
        P_insymbol();
        Ra.sl[6]=3992; /* line # 3992 */
        Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv25);
        Ra.sl[6]=3993; /* line # 3993 */
        Rv6=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv32)[30]);
        Ra.sl[6]=3994; /* line # 3994 */
        ((V *)Rv6)[0]=Rv5;
        Ra.sl[6]=3995; /* line # 3995 */
        Rv42=P_type_parm_set(((V *)V_ima_typ)[3],Rv6);
        Ra.sl[6]=3997; /* line # 3997 */
        Rv36=Rv33;
        Ra.sl[6]=3998; /* line # 3998 */
        while (Rv36!=NULL){
          Ra.sl[6]=3999; /* line # 3999 */
          Rv43=Rv36;
          Ra.sl[6]=4001; /* line # 4001 */
          ((SL *)Rv43)[6]=Rv25+1;
          Ra.sl[6]=4002; /* line # 4002 */
          Rv36=((V *)Rv43)[0];
        }
        Ra.sl[6]=4006; /* line # 4006 */
        Rv44=((V *)V_ima_typ)[4];
        Ra.sl[6]=4007; /* line # 4007 */
        if (((V *)Rv44)[3]!=NULL) {
          Ra.sl[6]=4009; /* line # 4009 */
          P_val_new(&Rv36,((V *)((V *)Rv44)[3])[5]);
          Ra.sl[6]=4010; /* line # 4010 */
          Rv45=Rv36;
          Rv46=((V *)Rv44)[3];
          Ra.sl[6]=4012; /* line # 4012 */
          ((SL *)Rv45)[13]=Rv25;
          Ra.sl[6]=4013; /* line # 4013 */
          if (((V *)Rv46)[5]!=NULL) ((SL *)Rv45)[6]=((SL *)((V *)Rv46)[5])[11];
          Ra.sl[6]=4014; /* line # 4014 */
          ((V *)Rv45)[0]=Rv33;
          Ra.sl[6]=4016; /* line # 4016 */
          Rv33=Rv36;
          Ra.sl[6]=4017; /* line # 4017 */
          Rv36=NULL;
          P_val_new(&Rv36,((V *)Rv44)[5]);
          Ra.sl[6]=4018; /* line # 4018 */
          Rv47=Rv36;
          Ra.sl[6]=4020; /* line # 4020 */
          ((SL *)Rv47)[13]=((SL *)Rv32)[30];
          Ra.sl[6]=4021; /* line # 4021 */
          if (((V *)Rv44)[5]!=NULL) ((SL *)Rv47)[6]=((SL *)((V *)Rv44)[5])[11];
          Ra.sl[6]=4022; /* line # 4022 */
          ((V *)Rv47)[0]=Rv33;
          Ra.sl[6]=4024; /* line # 4024 */
          Rv33=Rv36;
        }
        Ra.sl[6]=4026; /* line # 4026 */
        P_lgt_new(((V *)Rv32)+13,Rv42,14,NULL);
        Ra.sl[6]=4027; /* line # 4027 */
        P_val_new(((V *)((V *)Rv32)[13])+7,Rv42);
        Ra.sl[6]=4028; /* line # 4028 */
        Rv48=((V *)Rv32)[13];
        Rv49=((V *)Rv48)[7];
        Ra.sl[6]=4030; /* line # 4030 */
        ((SL *)Rv49)[6]=((SL *)Rv42)[11];
        Ra.sl[6]=4031; /* line # 4031 */
        ((V *)Rv49)[7]=Rv33;
        Ra.sl[6]=4033; /* line # 4033 */
        if (((SL *)Rv32)[30]>255) {
          Ra.sl[6]=4036; /* line # 4036 */
          if (((SL *)Rv32)[30]>65535) ((SL *)Rv32)[11]=4;
          else {
            Ra.sl[6]=4037; /* line # 4037 */
            ((SL *)Rv32)[11]=2;
          }
        }
        Ra.sl[6]=4040; /* line # 4040 */
        Rv10=((SL *)Rv32)[11];
        Ra.sl[6]=4041; /* line # 4041 */
        Rv11=Rv10-1;
        Ra.sl[6]=4042; /* line # 4042 */
        PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
        Ra.sl[6]=4043; /* line # 4043 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv0);
        Ra.sl[6]=4044; /* line # 4044 */
        if (Rv10<((SL *)Rv32)[11]) P_src_error(Rd.s+779,214,2);
        else {
          Ra.sl[6]=4045; /* line # 4045 */
          ((SL *)Rv32)[11]=Rv10;
        }
        Ra.sl[6]=4046; /* line # 4046 */
        if (Rv11>=0) ((UB *)Rv32)[48]=Rv11;
        Ra.sl[6]=4049; /* line # 4049 */
        V_sy_type_gfirst=P_new_oper(0, Rv0, V_typ_std.v[15],0,0,NULL,0,0);
      }
    }
    break;
    case 42:Ra.sl[6]=4054; /* line # 4054 */
    P_insymbol();
    Ra.sl[6]=4055; /* line # 4055 */
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+779,51,2);
    Ra.sl[6]=4056; /* line # 4056 */
    PAS_COMILER_PRC_00000038(&Rv42,0,NULL,0,0,NULL);
    Ra.sl[6]=4057; /* line # 4057 */
    if (((UB *)Rv42)[93]>2) {
      Ra.sl[6]=4059; /* line # 4059 */
      P_src_error(Rd.s+779,215,3);
      Ra.sl[6]=4060; /* line # 4060 */
      Rv42=V_typ_std.v[1];
    }
    Ra.sl[6]=4063; /* line # 4063 */
    Rv12=((SL *)Rv42)[30]+1;
    Ra.sl[6]=4064; /* line # 4064 */
    if (Rv12>V_dst_seta) Rv12=V_dst_seta;
    Ra.sl[6]=4066; /* line # 4066 */
    Rv25=(Rv12+7)/8;
    Ra.sl[6]=4068; /* line # 4068 */
    if (Rv25>2) Rv25=((Rv25+3)/4)*4;
    Ra.sl[6]=4071; /* line # 4071 */
    if (Rv12>V_dst_setw) {
      Ra.sl[6]=4073; /* line # 4073 */
      P_ide_new_typ(12, &Rv0);
      Ra.sl[6]=4074; /* line # 4074 */
      Rv11=((UB *)V_typ_std.v[18])[48];
    }
    else {
      Ra.sl[6]=4078; /* line # 4078 */
      P_ide_new_typ(11, &Rv0);
      Ra.sl[6]=4079; /* line # 4079 */
      Rv10=1;
      Ra.sl[6]=4080; /* line # 4080 */
      switch (Rv25) {
        case 1:Ra.sl[6]=4081; /* line # 4081 */
        Rv11=0;
        break;
        case 2:Ra.sl[6]=4082; /* line # 4082 */
        Rv11=1;
        break;
        case 3:
        case 4:Ra.sl[6]=4083; /* line # 4083 */
        Rv11=3;
        break;
        default:Ra.sl[6]=4085; /* line # 4085 */
        Rv11=((UB *)V_typ_std.v[17])[48];
        break;
      }
    }
    Ra.sl[6]=4088; /* line # 4088 */
    Rv50=Rv0;
    Ra.sl[6]=4090; /* line # 4090 */
    ((V *)Rv50)[3]=F_owid;
    Ra.sl[6]=4091; /* line # 4091 */
    ((SL *)Rv50)[24]=Rv12;
    Ra.sl[6]=4092; /* line # 4092 */
    ((V *)Rv50)[13]=Rv42;
    Ra.sl[6]=4093; /* line # 4093 */
    ((SL *)Rv50)[11]=Rv25;
    Ra.sl[6]=4094; /* line # 4094 */
    Rv10=Rv25;
    Ra.sl[6]=4095; /* line # 4095 */
    PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
    Ra.sl[6]=4097; /* line # 4097 */
    if (Rv25>Rv10) {
      Ra.sl[6]=4099; /* line # 4099 */
      P_src_error(Rd.s+779,214,1);
      Ra.sl[6]=4100; /* line # 4100 */
      Rv10=Rv25;
    }
    Ra.sl[6]=4103; /* line # 4103 */
    ((SL *)Rv50)[11]=Rv10;
    Ra.sl[6]=4104; /* line # 4104 */
    if (Rv11>=0) ((UB *)Rv50)[48]=Rv11;
    Ra.sl[6]=4106; /* line # 4106 */
    if (Rv42!=NULL) {
      Ra.sl[6]=4107; /* line # 4107 */
      Rv51=Rv42;
      Ra.sl[6]=4108; /* line # 4108 */
      if (((UB *)Rv51)[93]==2) {
        Ra.sl[6]=4109; /* line # 4109 */
        Rv52=V_usi_tab;
        Ra.sl[6]=4111; /* line # 4111 */
        P_lgt_new(((V *)Rv51)+13,((V *)Rv52)[5],14,NULL);
        Ra.sl[6]=4112; /* line # 4112 */
        P_val_copy(((V *)Rv52)+7,((V *)((V *)Rv51)[13])+7,0);
      }
      else {
        Ra.sl[6]=4114; /* line # 4114 */
        if (((UB *)Rv51)[93]==0) {
          Ra.sl[6]=4115; /* line # 4115 */
          Rv53=V_csi_tab;
          Ra.sl[6]=4117; /* line # 4117 */
          P_lgt_new(((V *)Rv51)+13,((V *)Rv53)[5],14,NULL);
          Ra.sl[6]=4118; /* line # 4118 */
          P_val_copy(((V *)Rv53)+7,((V *)((V *)Rv51)[13])+7,0);
        }
      }
    }
    break;
    case 44:Ra.sl[6]=4125; /* line # 4125 */
    P_src_error(Rd.s+779,219,2);
    Ra.sl[6]=4126; /* line # 4126 */
    Rv0=NULL;
    break;
    case 56:Ra.sl[6]=4131; /* line # 4131 */
    Rv5=PAS_COMILER_PRC_00000004(2,NULL);
    Ra.sl[6]=4132; /* line # 4132 */
    Rv0=((V *)Rv5)[3];
    P_lgt_free(&Rv5);
    break;
    default:Ra.sl[6]=4137; /* line # 4137 */
    Rv0=NULL;
    Ra.sl[6]=4138; /* line # 4138 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=4140; /* line # 4140 */
      Rv1=P_ide_search(534);
      Ra.sl[6]=4141; /* line # 4141 */
      Rv0=((V *)Rv1)[5];
      Ra.sl[6]=4142; /* line # 4142 */
      if (Rv1!=V_ide_udptr.v[1]) {
        Ra.sl[6]=4144; /* line # 4144 */
        if (((UB *)Rv1)[53]==1) {
          Ra.sl[6]=4146; /* line # 4146 */
          Rv0=((V *)Rv1)[5];
          Ra.sl[6]=4147; /* line # 4147 */
          P_insymbol();
          Ra.sl[6]=4149; /* line # 4149 */
          V_sy_type_gfirst=((V *)Rv1)[10];
          Ra.sl[6]=4150; /* line # 4150 */
          if (V_sy_sym.ub[0]==13) {
            Ra.sl[6]=4152; /* line # 4152 */
            Rv2=Rv1;
            Ra.sl[6]=4153; /* line # 4153 */
            if (((V *)((V *)Rv2)[5])[4]==NULL) {
              Ra.sl[6]=4155; /* line # 4155 */
              P_src_error(Rd.s+779,206,2);
              Ra.sl[6]=4156; /* line # 4156 */
              P_skip_symbol(14,0,0);
            }
            else {
              Ra.sl[6]=4160; /* line # 4160 */
              Rv3=NULL;
              Ra.sl[6]=4161; /* line # 4161 */
              Rv4=((V *)((V *)Rv2)[5])[4];
              Ra.sl[6]=4162; /* line # 4162 */
              V_sy_sym.ub[0]=17;
              Ra.sl[6]=4163; /* line # 4163 */
              while (Rv4!=NULL){
                Ra.sl[6]=4165; /* line # 4165 */
                if (V_sy_sym.ub[0]==17) P_insymbol();
                Ra.sl[6]=4166; /* line # 4166 */
                if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==14) {
                  Ra.sl[6]=4167; /* line # 4167 */
                  if (((V *)Rv4)[10]!=NULL) {
                    Ra.sl[6]=4169; /* line # 4169 */
                    P_lgt_new(&Rv5,((V *)Rv4)[5],14,NULL);
                    Ra.sl[6]=4170; /* line # 4170 */
                    ((V *)Rv5)[7]=((V *)Rv4)[10];
                    Ra.sl[6]=4171; /* line # 4171 */
                    P_val_new(((V *)Rv4)+10,((V *)Rv4)[5]);
                  }
                  else {
                    Ra.sl[6]=4173; /* line # 4173 */
                    P_src_error_s(Rd.s+779,228,3,((V *)Rv4)[0],NULL);
                  }
                }
                else {
                  Ra.sl[6]=4175; /* line # 4175 */
                  Rv5=PAS_COMILER_PRC_00000005(((V *)Rv4)[5],0,0,0);
                }
                Ra.sl[6]=4177; /* line # 4177 */
                if (Rv3==NULL) Rv3=Rv5;
                else {
                  Ra.sl[6]=4178; /* line # 4178 */
                  ((V *)Rv6)[0]=Rv5;
                }
                Ra.sl[6]=4179; /* line # 4179 */
                Rv6=Rv5;
                Ra.sl[6]=4180; /* line # 4180 */
                Rv4=((V *)Rv4)[3];
              }
              Ra.sl[6]=4182; /* line # 4182 */
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else {
                Ra.sl[6]=4183; /* line # 4183 */
                P_src_error(Rd.s+779,23,2);
              }
              Ra.sl[6]=4184; /* line # 4184 */
              Rv0=P_type_parm_set(Rv1, Rv3);
            }
          }
          else {
            Ra.sl[6]=4188; /* line # 4188 */
            Rv7=Rv1;
            Ra.sl[6]=4190; /* line # 4190 */
            if (((UB *)((V *)Rv7)[5])[93]==24) {
              Ra.sl[6]=4192; /* line # 4192 */
              if (V_sy_sym.ub[0]==87) {
                Ra.sl[6]=4194; /* line # 4194 */
                P_insymbol();
                Ra.sl[6]=4195; /* line # 4195 */
                Rv8=P_ide_search(2);
                Ra.sl[6]=4196; /* line # 4196 */
                P_insymbol();
                Ra.sl[6]=4197; /* line # 4197 */
                if (Rv8!=V_ide_udptr.v[1]) {
                  Ra.sl[6]=4199; /* line # 4199 */
                  P_ide_new_typ(24, &Rv0);
                  Ra.sl[6]=4200; /* line # 4200 */
                  Rv9=Rv0;
                  Ra.sl[6]=4202; /* line # 4202 */
                  ((V *)Rv9)[0]=((V *)Rv7)[5];
                  Ra.sl[6]=4203; /* line # 4203 */
                  ((V *)Rv9)[12]=((V *)Rv8)[5];
                  Ra.sl[6]=4204; /* line # 4204 */
                  ((V *)Rv9)[4]=((V *)((V *)Rv9)[12])[4];
                  Ra.sl[6]=4205; /* line # 4205 */
                  ((SL *)Rv9)[10]=0;
                  Ra.sl[6]=4207; /* line # 4207 */
                  V_sy_type_gfirst=((V *)Rv7)[10];
                  Ra.sl[6]=4208; /* line # 4208 */
                  ((V *)Rv9)[9]=NULL;
                  Ra.sl[6]=4209; /* line # 4209 */
                  ((SL *)Rv9)[11]=((SL *)((V *)Rv7)[5])[11];
                  Ra.sl[6]=4210; /* line # 4210 */
                  ((UB *)Rv9)[91]=((UB *)((V *)Rv7)[5])[91];
                }
              }
              else Ra.sl[6]=4218; /* line # 4218 */
            }
            Ra.sl[6]=4219; /* line # 4219 */
            ((UB *)Rv0)[91]=((UB *)((V *)Rv7)[5])[91]||((SL *)((V *)Rv7)[5])[10]
            >0;
          }
        }
        else {
          Ra.sl[6]=4222; /* line # 4222 */
          Rv0=NULL;
        }
      }
    }
    Ra.sl[6]=4225; /* line # 4225 */
    if (Rv0==NULL) {
      Ra.sl[6]=4228; /* line # 4228 */
      Rv5=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,1);
      Ra.sl[6]=4229; /* line # 4229 */
      if (V_sy_sym.ub[0]==20) P_insymbol();
      else P_src_error(Rd.s+779,28,2);
      Ra.sl[6]=4230; /* line # 4230 */
      Rv6=PAS_COMILER_PRC_00000005(((V *)Rv5)[3],0,0,1);
      Ra.sl[6]=4231; /* line # 4231 */
      Rv10=((SL *)((V *)Rv5)[3])[11];
      Ra.sl[6]=4232; /* line # 4232 */
      Rv11=((UB *)((V *)Rv5)[3])[48];
      Ra.sl[6]=4233; /* line # 4233 */
      PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
      Ra.sl[6]=4234; /* line # 4234 */
      if (Rv10<4) Rv12=PAS__IIPOWER(2,8*Rv10);
      else Rv12=2147483647;
      Ra.sl[6]=4235; /* line # 4235 */
      Rv13=Rv5;
      Ra.sl[6]=4236; /* line # 4236 */
      if (((UB *)Rv13)[40]==14&&((UB *)Rv6)[40]==14) {
        Ra.sl[6]=4238; /* line # 4238 */
        P_ide_new_typ_range(((SL *)((V *)Rv13)[7])[13],((SL *)((V *)Rv6)[7])[13]
        ,((V *)Rv13)[3],&Rv0);
        Ra.sl[6]=4241; /* line # 4241 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv0);
        Ra.sl[6]=4242; /* line # 4242 */
        P_lgt_free(&Rv5);
        P_lgt_free(&Rv6);
        Ra.sl[6]=4243; /* line # 4243 */
        Rv14=Rv0;
        Ra.sl[6]=4245; /* line # 4245 */
        ((UB *)Rv14)[112]=((SL *)Rv14)[29]>=0;
        Ra.sl[6]=4246; /* line # 4246 */
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4248; /* line # 4248 */
          if (((UB *)Rv14)[112]) {
            Ra.sl[6]=4250; /* line # 4250 */
            if (((UL *)Rv14)[29]>((UL *)Rv14)[30]) {
              Ra.sl[6]=4252; /* line # 4252 */
              ((UL *)Rv14)[30]=((UL *)Rv14)[29];
              Ra.sl[6]=4253; /* line # 4253 */
              P_src_error(Rd.s+779,211,2);
            }
          }
          else {
            Ra.sl[6]=4257; /* line # 4257 */
            if (((SL *)Rv14)[29]>((SL *)Rv14)[30]) {
              Ra.sl[6]=4259; /* line # 4259 */
              ((SL *)Rv14)[30]=((SL *)Rv14)[29];
              Ra.sl[6]=4260; /* line # 4260 */
              P_src_error(Rd.s+779,211,2);
            }
          }
          Ra.sl[6]=4262; /* line # 4262 */
          if (((UB *)Rv14)[112]) {
            Ra.sl[6]=4264; /* line # 4264 */
            switch (Rv10) {
              case 1:Ra.sl[6]=4265; /* line # 4265 */
              Rv12=256;
              break;
              case 2:
              case 3:Ra.sl[6]=4266; /* line # 4266 */
              Rv12=65536;
              break;
              default:Ra.sl[6]=4268; /* line # 4268 */
              Rv12=2147483647;
              break;
            }
            Ra.sl[6]=4270; /* line # 4270 */
            if (Rv10<4) {
              Ra.sl[6]=4271; /* line # 4271 */
              if (((UL *)Rv14)[30]>=Rv12) {
                Ra.sl[6]=4273; /* line # 4273 */
                ((UL *)Rv14)[30]=Rv12-1;
                ((UL *)Rv14)[29]=0;
                Ra.sl[6]=4274; /* line # 4274 */
                P_src_error(Rd.s+779,212,2);
                Rv11=0;
              }
            }
          }
          else {
            Ra.sl[6]=4279; /* line # 4279 */
            switch (Rv10) {
              case 1:Ra.sl[6]=4280; /* line # 4280 */
              Rv12=128;
              break;
              case 2:
              case 3:Ra.sl[6]=4281; /* line # 4281 */
              Rv12=32768;
              break;
              default:Ra.sl[6]=4283; /* line # 4283 */
              Rv12=2147483647;
              break;
            }
            Ra.sl[6]=4285; /* line # 4285 */
            if (((SL *)Rv14)[30]>=Rv12||((SL *)Rv14)[29]< -Rv12) {
              Ra.sl[6]=4287; /* line # 4287 */
              Rv10=4;
              ((SL *)Rv14)[30]=Rv12-1;
              ((SL *)Rv14)[29]= -Rv12;
              Ra.sl[6]=4288; /* line # 4288 */
              P_src_error(Rd.s+779,213,2);
              Rv11=0;
            }
          }
        }
      }
      else {
        Ra.sl[6]=4296; /* line # 4296 */
        P_ide_new_typ(22, &Rv0);
        Ra.sl[6]=4297; /* line # 4297 */
        Rv15=Rv0;
        Ra.sl[6]=4299; /* line # 4299 */
        ((V *)Rv15)[0]=((V *)Rv13)[3];
        Ra.sl[6]=4300; /* line # 4300 */
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4302; /* line # 4302 */
          P_type_check_parm(Rv5);
          Ra.sl[6]=4303; /* line # 4303 */
          P_type_check_parm(Rv6);
        }
        Ra.sl[6]=4305; /* line # 4305 */
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[6]=4307; /* line # 4307 */
          ((V *)Rv15)[14]=P_lgt_new_code(0, Rv6);
        }
        else {
          Ra.sl[6]=4310; /* line # 4310 */
          ((V *)Rv15)[14]=Rv6;
        }
        Ra.sl[6]=4312; /* line # 4312 */
        ((V *)((V *)Rv15)[14])[3]=Rv0;
        Ra.sl[6]=4313; /* line # 4313 */
        if (((UB *)Rv5)[40]==14) {
          Ra.sl[6]=4314; /* line # 4314 */
          Rv16=Rv5;
          Ra.sl[6]=4316; /* line # 4316 */
          ((V *)Rv15)[13]=Rv5;
          Ra.sl[6]=4317; /* line # 4317 */
          ((V *)Rv16)[3]=Rv0;
          Ra.sl[6]=4318; /* line # 4318 */
          if (((SL *)((V *)Rv16)[7])[13]==1) {
            Ra.sl[6]=4320; /* line # 4320 */
            ((V *)Rv15)[12]=P_lgt_new_code(0, Rv6);
          }
          else {
            Ra.sl[6]=4324; /* line # 4324 */
            ((V *)((V *)Rv15)[14])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)((V
             *)Rv16)[7])[13]-1);
            Ra.sl[6]=4327; /* line # 4327 */
            ((V *)Rv15)[12]=P_lgt_new_code(50,((V *)Rv15)[14]);
          }
        }
        else {
          Ra.sl[6]=4333; /* line # 4333 */
          ((V *)Rv15)[13]=P_lgt_new_code(0, Rv5);
          Ra.sl[6]=4334; /* line # 4334 */
          ((V *)((V *)Rv15)[13])[3]=Rv0;
          Ra.sl[6]=4335; /* line # 4335 */
          if (((UB *)Rv6)[40]==14) {
            Ra.sl[6]=4339; /* line # 4339 */
            Rv12=((SL *)((V *)Rv6)[7])[13]+1;
            Ra.sl[6]=4340; /* line # 4340 */
            if (Rv12==0) {
              Ra.sl[6]=4342; /* line # 4342 */
              ((V *)Rv15)[12]=P_lgt_new_code(46,((V *)Rv15)[14]);
            }
            else {
              Ra.sl[6]=4345; /* line # 4345 */
              Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv12);
              Ra.sl[6]=4346; /* line # 4346 */
              ((V *)Rv5)[0]=((V *)Rv15)[13];
              Ra.sl[6]=4347; /* line # 4347 */
              ((V *)Rv15)[12]=P_lgt_new_code(50, Rv5);
            }
          }
          else {
            Ra.sl[6]=4352; /* line # 4352 */
            ((V *)((V *)Rv15)[14])[0]=((V *)Rv15)[13];
            Ra.sl[6]=4353; /* line # 4353 */
            Rv5=P_lgt_new_code(50,((V *)Rv15)[14]);
            Ra.sl[6]=4354; /* line # 4354 */
            ((V *)Rv15)[12]=P_lgt_new_code(43, Rv5);
          }
        }
      }
      Ra.sl[6]=4361; /* line # 4361 */
      Rv17=Rv0;
      Ra.sl[6]=4363; /* line # 4363 */
      ((V *)Rv17)[3]=F_owid;
      Ra.sl[6]=4364; /* line # 4364 */
      ((SL *)Rv17)[11]=Rv10;
      Ra.sl[6]=4365; /* line # 4365 */
      if (Rv11>=0) ((UB *)Rv17)[48]=Rv11;
    }
    break;
  }
  Ra.sl[6]=4371; /* line # 4371 */
  (*F_it)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_decl_attribute "  */
void PAS_COMILER_PRC_00000043(UB F_bvr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+783;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4390; /* line # 4390 */
  while (1){
    Ra.sl[6]=4392; /* line # 4392 */
    P_insymbol();
    Ra.sl[6]=4393; /* line # 4393 */
    if (V_sy_sym.ub[0]!=0) {
      Ra.sl[6]=4394; /* line # 4394 */
      if (F_bvr) {
        Ra.sl[6]=4396; /* line # 4396 */
        F_bvr=0;
        Ra.sl[6]=4397; /* line # 4397 */
        switch (V_sy_sym.ub[0]) {
          case 80:
          case 81:Ra.sl[6]=4399; /* line # 4399 */
          Lx[5].ub[16]=2;
          break;
          case 82:Ra.sl[6]=4400; /* line # 4400 */
          Lx[5].ub[16]=3;
          break;
          case 84:Ra.sl[6]=4401; /* line # 4401 */
          Lx[5].ub[16]=4;
          Rv0=1;
          break;
          case 83:Ra.sl[6]=4402; /* line # 4402 */
          Lx[5].ub[16]=5;
          Rv0=1;
          break;
          case 85:Ra.sl[6]=4403; /* line # 4403 */
          if (V_sy_init_mod) {
            Ra.sl[6]=4404; /* line # 4404 */
            Lx[5].ub[16]=6;
            Rv0=1;
          }
          else {
            Ra.sl[6]=4405; /* line # 4405 */
            P_src_error(Rd.s+805,992,2);
          }
          break;
          default:Ra.sl[6]=4407; /* line # 4407 */
          P_src_error(Rd.s+805,163,2);
          break;
        }
      }
      else {
        Ra.sl[6]=4410; /* line # 4410 */
        P_src_error(Rd.s+805,170,2);
      }
    }
    else {
      Ra.sl[6]=4413; /* line # 4413 */
      Rv1=P_level_search(V_attr_list);
      Ra.sl[6]=4414; /* line # 4414 */
      if (Rv1!=NULL) {
        Ra.sl[6]=4415; /* line # 4415 */
        switch (((UB *)Rv1)[54]) {
          case 23:Ra.sl[6]=4416; /* line # 4416 */
          Rs.sl[0]=1;
          break;
          case 24:Ra.sl[6]=4417; /* line # 4417 */
          Rs.sl[0]=2;
          break;
          case 25:Ra.sl[6]=4418; /* line # 4418 */
          Rs.sl[0]=4;
          break;
          case 26:Ra.sl[6]=4419; /* line # 4419 */
          Rs.sl[0]=8;
          break;
          default:Ra.sl[6]=4421; /* line # 4421 */
          P_src_error_s(Rd.s+805,165,2, V_sy_ident.s,NULL);
          break;
        }
      }
      else {
        Ra.sl[6]=4424; /* line # 4424 */
        P_src_error(Rd.s+805,162,2);
      }
    }
    Ra.sl[6]=4426; /* line # 4426 */
    P_insymbol();
    Ra.sl[6]=4427; /* line # 4427 */
    if (Rv0) {
      Ra.sl[6]=4429; /* line # 4429 */
      Lx[5].v[3]=NULL;
      Ra.sl[6]=4430; /* line # 4430 */
      P_set_strname(Lx[5].v+3);
    }
    if (V_sy_sym.ub[0]!=17)  break;
  }
  Ra.sl[6]=4434; /* line # 4434 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else {
    Ra.sl[6]=4435; /* line # 4435 */
    P_src_error(Rd.s+805,26,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_setting "  */
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  UW Rv8;
  UB Rv9;
  V Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  V Rv16;
  register V Rv17;
  UB Rv18;
  register V Rv19;
  V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  V Rv24;
  register V Rv25;
  register V Rv26;
  register V Rv27;
  register V Rv28;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+809;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4462; /* line # 4462 */
  Rv0=0;
  Ra.sl[6]=4463; /* line # 4463 */
  Rv1=Lx[5].ub[16];
  Ra.sl[6]=4464; /* line # 4464 */
  Rv2=NULL;
  Ra.sl[6]=4465; /* line # 4465 */
  Lx[5].ub[16]=1;
  Ra.sl[6]=4466; /* line # 4466 */
  if (Lx[5].v[3]!=NULL) {
    Ra.sl[6]=4468; /* line # 4468 */
    P_src_error_s(Rd.s+826,166,1, Lx[5].v[3],NULL);
    Ra.sl[6]=4469; /* line # 4469 */
    Lx[5].v[3]=NULL;
  }
  Ra.sl[6]=4471; /* line # 4471 */
  Rv3=0;
  Ra.sl[6]=4472; /* line # 4472 */
  Rv4=NULL;
  Rv5=NULL;
  Ra.sl[6]=4474; /* line # 4474 */
  if (F_v_class==6) {
    Ra.sl[6]=4476; /* line # 4476 */
    ((V *)F_ty)[12]=V_lex_ident_tree.v[V_curr_disp*8+4];
  }
  Ra.sl[6]=4478; /* line # 4478 */
  Ra.sl[6]=4479; /* line # 4479 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==15){
    Ra.sl[6]=4481; /* line # 4481 */
    Rv6=NULL;
    Ra.sl[6]=4482; /* line # 4482 */
    Rv7=NULL;
    Ra.sl[6]=4483; /* line # 4483 */
    Rv8=96;
    while (1){
      Ra.sl[6]=4485; /* line # 4485 */
      switch (F_v_class) {
        case 5:Ra.sl[6]=4488; /* line # 4488 */
        if (V_sy_sym.ub[0]==15) {
          Ra.sl[6]=4491; /* line # 4491 */
          PAS_COMILER_PRC_00000043(F_v_class!=6);
          Ra.sl[6]=4493; /* line # 4493 */
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[6]=4495; /* line # 4495 */
            Rv9=Lx[5].ub[16];
            Ra.sl[6]=4496; /* line # 4496 */
            Rv2=Lx[5].v[3];
            Ra.sl[6]=4497; /* line # 4497 */
            Lx[5].ub[16]=1;
            Ra.sl[6]=4498; /* line # 4498 */
            Lx[5].v[3]=NULL;
          }
          else {
            Ra.sl[6]=4500; /* line # 4500 */
            Rv0=1;
          }
        }
        else {
          Ra.sl[6]=4504; /* line # 4504 */
          Rv9=Rv1;
          Ra.sl[6]=4505; /* line # 4505 */
          Rv2=NULL;
        }
        Ra.sl[6]=4507; /* line # 4507 */
        if (!Rv0) {
          Ra.sl[6]=4509; /* line # 4509 */
          V_cmp_twicedclon=1;
          Ra.sl[6]=4510; /* line # 4510 */
          P_ide_new(5,NULL,&Rv10);
          Ra.sl[6]=4511; /* line # 4511 */
          V_cmp_twicedclon=0;
          Ra.sl[6]=4513; /* line # 4513 */
          if (1<<Rv9&112&&Rv2!=NULL) {
            Ra.sl[6]=4514; /* line # 4514 */
            ((V *)Rv10)[8]=Rv2;
          }
        }
        break;
        case 2:Ra.sl[6]=4518; /* line # 4518 */
        P_ide_new(2,NULL,&Rv10);
        break;
        case 1:
        case 6:Ra.sl[6]=4521; /* line # 4521 */
        P_ide_new(6,NULL,&Rv10);
        break;
        default:break;
      }
      Ra.sl[6]=4526; /* line # 4526 */
      if (!Rv0) {
        Ra.sl[6]=4528; /* line # 4528 */
        if (!V_cmp_twicedcl) {
          Ra.sl[6]=4530; /* line # 4530 */
          if (Rv5!=NULL) ((V *)Rv5)[3]=Rv10;
          else {
            Ra.sl[6]=4532; /* line # 4532 */
            if (Rv4==NULL) Rv4=Rv10;
          }
          Ra.sl[6]=4533; /* line # 4533 */
          if (Rv6==NULL) Rv6=Rv10;
          Ra.sl[6]=4534; /* line # 4534 */
          Rv5=Rv10;
        }
        Ra.sl[6]=4536; /* line # 4536 */
        P_insymbol();
        Ra.sl[6]=4537; /* line # 4537 */
        if (V_sy_sym.ub[0]==17) P_insymbol();
        else {
          Ra.sl[6]=4538; /* line # 4538 */
          if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+826,29,2);
        }
        Ra.sl[6]=4539; /* line # 4539 */
        if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+826,27,2);
      }
      if (V_sy_sym.ub[0]!=0&&V_sy_sym.ub[0]!=15)  break;
    }
    Ra.sl[6]=4543; /* line # 4543 */
    if (!Rv0) {
      Ra.sl[6]=4545; /* line # 4545 */
      P_insymbol();
      Ra.sl[6]=4547; /* line # 4547 */
      Rs.sl[1]=-1;
      Ra.sl[6]=4548; /* line # 4548 */
      Rs.sl[0]=-1;
      Ra.sl[6]=4549; /* line # 4549 */
      Rv11=0;
      Ra.sl[6]=4551; /* line # 4551 */
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        Ra.sl[6]=4552; /* line # 4552 */
        P_insymbol();
        Rv11=1;
      }
      Ra.sl[6]=4555; /* line # 4555 */
      if (V_sy_sym.ub[0]==15&&1<<F_v_class&112) {
        Ra.sl[6]=4557; /* line # 4557 */
        PAS_COMILER_PRC_00000043(F_v_class!=6);
        Ra.sl[6]=4558; /* line # 4558 */
        Rv9=Lx[5].ub[16];
      }
      Ra.sl[6]=4563; /* line # 4563 */
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        Ra.sl[6]=4564; /* line # 4564 */
        P_insymbol();
        Rv11=1;
      }
      Ra.sl[6]=4569; /* line # 4569 */
      if (Rv9==1&&Rv1!=1) {
        Ra.sl[6]=4570; /* line # 4570 */
        Rv9=Rv1;
        Rv2=NULL;
      }
      Ra.sl[6]=4572; /* line # 4572 */
      PAS_COMILER_PRC_00000038(&Rv12,0,NULL,0,0,NULL);
      Ra.sl[6]=4574; /* line # 4574 */
      switch (F_v_class) {
        case 5:Ra.sl[6]=4578; /* line # 4578 */
        if (((SL *)Rv12)[11]<0&&((V *)Rv12)[1]!=NULL) {
          Ra.sl[6]=4579; /* line # 4579 */
          Rv12=((V *)Rv12)[1];
        }
        break;
        case 2:Ra.sl[6]=4581; /* line # 4581 */
        if (Rv12!=NULL) {
          Ra.sl[6]=4582; /* line # 4582 */
          Rv13=Rv12;
          Ra.sl[6]=4584; /* line # 4584 */
          switch (((UB *)Rv13)[93]) {
            case 0:
            case 1:
            case 2:break;
            default:Ra.sl[6]=4587; /* line # 4587 */
            P_src_error(Rd.s+826,207,3);
            break;
          }
        }
        break;
        case 6:Ra.sl[6]=4591; /* line # 4591 */
        Rv14=Rv12;
        Ra.sl[6]=4593; /* line # 4593 */
        if (((UB *)Rv14)[91]||((SL *)Rv14)[10]>0) Lx[5].ub[0]=1;
        break;
        default:break;
      }
      Ra.sl[6]=4599; /* line # 4599 */
      Rv15=Rv12;
      Ra.sl[6]=4601; /* line # 4601 */
      if (Rv3<((UB *)Rv15)[48]) Rv3=((UB *)Rv15)[48];
      Ra.sl[6]=4603; /* line # 4603 */
      Rv7=((V *)Rv15)[10];
      Ra.sl[6]=4606; /* line # 4606 */
      if (F_v_class==5) {
        Ra.sl[6]=4608; /* line # 4608 */
        if (Rv9==1) {
          Ra.sl[6]=4609; /* line # 4609 */
          switch (V_sy_sym.ub[0]) {
            case 80:Ra.sl[6]=4610; /* line # 4610 */
            Rv9=2;
            P_insymbol();
            break;
            case 84:Ra.sl[6]=4611; /* line # 4611 */
            Rv9=4;
            P_insymbol();
            break;
            case 83:Ra.sl[6]=4612; /* line # 4612 */
            Rv9=5;
            P_insymbol();
            break;
            default:break;
          }
        }
        Ra.sl[6]=4615; /* line # 4615 */
        if (V_sy_sym.ub[0]==26) {
          Ra.sl[6]=4617; /* line # 4617 */
          Rv8=32;
          Ra.sl[6]=4618; /* line # 4618 */
          P_insymbol();
        }
      }
      Ra.sl[6]=4622; /* line # 4622 */
      if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
        Ra.sl[6]=4623; /* line # 4623 */
        if (F_v_class==6) {
          Ra.sl[6]=4625; /* line # 4625 */
          P_src_error(Rd.s+826,220,2);
        }
        else {
          Ra.sl[6]=4629; /* line # 4629 */
          P_insymbol();
          Ra.sl[6]=4630; /* line # 4630 */
          if (V_sy_sym.ub[0]!=13&&V_sy_sym.ub[0]!=15) {
            Ra.sl[6]=4631; /* line # 4631 */
            Rv16=PAS_COMILER_PRC_00000005(Rv12,0,0,0);
          }
          else {
            Ra.sl[6]=4633; /* line # 4633 */
            Rv16=PAS_COMILER_PRC_00000019(Rv12);
          }
          Ra.sl[6]=4635; /* line # 4635 */
          if (((UB *)Rv16)[40]!=14) {
            Ra.sl[6]=4636; /* line # 4636 */
            P_src_error(Rd.s+826,216,3);
          }
          else {
            Ra.sl[6]=4638; /* line # 4638 */
            Rv17=Rv16;
            Ra.sl[6]=4640; /* line # 4640 */
            Rv7=((V *)Rv17)[7];
            Ra.sl[6]=4641; /* line # 4641 */
            ((V *)Rv17)[7]=NULL;
          }
          Ra.sl[6]=4643; /* line # 4643 */
          Rv18=1;
          Ra.sl[6]=4644; /* line # 4644 */
          P_lgt_free_tree(&Rv16);
        }
      }
      else {
        Ra.sl[6]=4646; /* line # 4646 */
        Rv18=0;
      }
      Ra.sl[6]=4649; /* line # 4649 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=4651; /* line # 4651 */
        if (V_sy_sym.ub[0]==0) P_src_error_s(Rd.s+826,52,2, V_sy_ident.s,NULL);
      }
      Ra.sl[6]=4654; /* line # 4654 */
      if (Rv6!=NULL) while (1){
        Ra.sl[6]=4656; /* line # 4656 */
        Rv19=Rv6;
        Ra.sl[6]=4658; /* line # 4658 */
        Rv20=((V *)Rv19)[5];
        Ra.sl[6]=4659; /* line # 4659 */
        ((V *)Rv19)[5]=Rv12;
        Ra.sl[6]=4660; /* line # 4660 */
        if ((*F_isz)>0) (*F_isz)=P_ide_typ_align((*F_isz),Rv12);
        Ra.sl[6]=4661; /* line # 4661 */
        switch (F_v_class) {
          case 5:Ra.sl[6]=4664; /* line # 4664 */
          ((UW *)Rv19)[42]=Rv8;
          Ra.sl[6]=4665; /* line # 4665 */
          if (Rv11) ((UW *)Rv19)[42]=((UW *)Rv19)[42]|16384;
          Ra.sl[6]=4667; /* line # 4667 */
          if (((UB *)Rv19)[86]==5||((SL *)Rv19)[20]>0) {
            Ra.sl[6]=4669; /* line # 4669 */
            if (Rv20!=NULL&&Rv20!=Rv12) {
              Ra.sl[6]=4670; /* line # 4670 */
              P_src_error_s(Rd.s+826,217,3,((V *)Rv19)[0],NULL);
            }
            Ra.sl[6]=4671; /* line # 4671 */
            ((UB *)Rv19)[86]=Rv9;
          }
          else {
            Ra.sl[6]=4675; /* line # 4675 */
            if (((UB *)Rv19)[86]==0) ((UB *)Rv19)[86]=Rv9;
            Ra.sl[6]=4676; /* line # 4676 */
            switch (((UB *)Rv19)[86]) {
              case 4:
              case 5:
              case 6:Ra.sl[6]=4679; /* line # 4679 */
              if (((V *)Rv19)[8]==NULL) {
                Ra.sl[6]=4680; /* line # 4680 */
                P_set_gbl_def_nam(((V *)Rv19)+8,((V *)Rv19)[0],86);
              }
              Ra.sl[6]=4681; /* line # 4681 */
              ((SL *)Rv19)[20]=-1;
              break;
              default:Ra.sl[6]=4685; /* line # 4685 */
              if (16384&((UW *)Rv19)[42]||V_cmp_igenv!=0) {
                Ra.sl[6]=4686; /* line # 4686 */
                ((SL *)Rv19)[20]=-1;
              }
              break;
            }
          }
          Ra.sl[6]=4690; /* line # 4690 */
          if (Rv7!=NULL) {
            Ra.sl[6]=4691; /* line # 4691 */
            if (((UB *)Rv19)[86]==5||((SL *)Rv19)[20]>0) {
              Ra.sl[6]=4693; /* line # 4693 */
              if (Rv18) P_src_error_s(Rd.s+826,209,2,((V *)Rv19)[0],NULL);
              Ra.sl[6]=4696; /* line # 4696 */
              Rv7=NULL;
            }
            else {
              Ra.sl[6]=4700; /* line # 4700 */
              ((V *)Rv19)[7]=Rv7;
              Ra.sl[6]=4701; /* line # 4701 */
              P_val_new(((V *)Rv19)+7,Rv12);
              Ra.sl[6]=4702; /* line # 4702 */
              Rv21=((V *)Rv19)[7];
              Ra.sl[6]=4704; /* line # 4704 */
              ((UW *)Rv21)[8]=((UW *)Rv10)[42];
              Ra.sl[6]=4705; /* line # 4705 */
              ((SL *)Rv21)[5]=((SL *)Rv19)[20];
            }
          }
          Ra.sl[6]=4709; /* line # 4709 */
          switch (((UB *)Rv19)[86]) {
            case 4:Ra.sl[6]=4712; /* line # 4712 */
            if (((UB *)((V *)Rv19)[5])[90]||((UB *)((V *)Rv19)[5])[91]) P_init_d_varbl(
            Rv6);
            Ra.sl[6]=4713; /* line # 4713 */
            P_all_new(((V *)Rv19)+9,Rv12, Rv6,((UB *)Rv19)[86]);
            Ra.sl[6]=4714; /* line # 4714 */
            ((V *)((V *)Rv19)[9])[13]=((V *)Rv19)[7];
            Ra.sl[6]=4715; /* line # 4715 */
            if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv19)[9];
            else {
              Ra.sl[6]=4716; /* line # 4716 */
              ((V *)V_all_lglobal)[0]=((V *)Rv19)[9];
            }
            Ra.sl[6]=4717; /* line # 4717 */
            ((V *)((V *)Rv19)[9])[1]=V_all_lglobal;
            Ra.sl[6]=4718; /* line # 4718 */
            V_all_lglobal=((V *)Rv19)[9];
            break;
            case 1:
            case 2:Ra.sl[6]=4721; /* line # 4721 */
            if (((SL *)Rv19)[20]==0) {
              Ra.sl[6]=4723; /* line # 4723 */
              if (((UB *)((V *)Rv19)[5])[90]||((UB *)((V *)Rv19)[5])[91]) P_init_d_varbl(
              Rv6);
              Ra.sl[6]=4724; /* line # 4724 */
              P_all_new(((V *)Rv19)+9,Rv12, Rv6,((UB *)Rv19)[86]);
              Ra.sl[6]=4725; /* line # 4725 */
              ((V *)((V *)Rv19)[9])[13]=((V *)Rv19)[7];
              Ra.sl[6]=4726; /* line # 4726 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv19)[9];
              else {
                Ra.sl[6]=4727; /* line # 4727 */
                ((V *)V_all_lstatic)[0]=((V *)Rv19)[9];
              }
              Ra.sl[6]=4728; /* line # 4728 */
              ((V *)((V *)Rv19)[9])[1]=V_all_lstatic;
              Ra.sl[6]=4729; /* line # 4729 */
              V_all_lstatic=((V *)Rv19)[9];
            }
            break;
            default:break;
          }
          break;
          case 1:
          case 6:Ra.sl[6]=4736; /* line # 4736 */
          Ra.sl[6]=4738; /* line # 4738 */
          ((SL *)Rv19)[14]=(*F_isz);
          Ra.sl[6]=4739; /* line # 4739 */
          if ((*F_isz)<0) {
            Ra.sl[6]=4741; /* line # 4741 */
            P_src_error(Rd.s+826,221,3);
          }
          break;
          case 2:Ra.sl[6]=4746; /* line # 4746 */
          ((UB *)Rv19)[60]=0;
          Ra.sl[6]=4747; /* line # 4747 */
          ((V *)Rv19)[10]=Rv7;
          Ra.sl[6]=4750; /* line # 4750 */
          if (((V *)Rv19)[10]==NULL) {
            Ra.sl[6]=4752; /* line # 4752 */
            P_val_new(((V *)Rv19)+10,Rv12);
            Ra.sl[6]=4753; /* line # 4753 */
            Rv22=((V *)Rv19)[10];
            Rv23=Rv12;
            Ra.sl[6]=4754; /* line # 4754 */
            switch (((UB *)Rv23)[93]) {
              case 0:Ra.sl[6]=4756; /* line # 4756 */
              ((SL *)Rv22)[13]=((SL *)Rv23)[30];
              break;
              case 1:
              case 2:Ra.sl[6]=4758; /* line # 4758 */
              if (((SL *)Rv23)[30]>32767) ((SL *)Rv22)[13]=32767;
              else {
                Ra.sl[6]=4759; /* line # 4759 */
                ((SL *)Rv22)[13]=((SL *)Rv23)[30];
              }
              break;
              default:break;
            }
          }
          else {
            Ra.sl[6]=4764; /* line # 4764 */
            P_val_new(((V *)Rv19)+10,Rv12);
          }
          Ra.sl[6]=4765; /* line # 4765 */
          ((SL *)Rv19)[14]=(*F_isz);
          break;
        }
        Ra.sl[6]=4770; /* line # 4770 */
        if ((*F_isz)>=0) {
          Ra.sl[6]=4771; /* line # 4771 */
          if (((SL *)Rv12)[11]>=0) {
            Ra.sl[6]=4772; /* line # 4772 */
            (*F_isz)=(*F_isz)+((SL *)Rv12)[11];
          }
          else {
            Ra.sl[6]=4774; /* line # 4774 */
            if ((F_v_class==6||F_v_class==1)&&((V *)Rv12)[9]!=NULL) {
              Ra.sl[6]=4777; /* line # 4777 */
              Rv24=P_lgt_link(((V *)Rv12)[9]);
              Ra.sl[6]=4778; /* line # 4778 */
              if ((*F_isz)>0) {
                Ra.sl[6]=4780; /* line # 4780 */
                ((V *)Rv24)[0]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
                Ra.sl[6]=4781; /* line # 4781 */
                ((V *)F_ty)[9]=P_lgt_new_code(49, Rv24);
              }
              else {
                Ra.sl[6]=4783; /* line # 4783 */
                ((V *)F_ty)[9]=Rv24;
              }
              Ra.sl[6]=4784; /* line # 4784 */
              (*F_isz)=-1;
            }
            else {
              Ra.sl[6]=4789; /* line # 4789 */
              P_src_error(Rd.s+826,301,3);
            }
          }
        }
        Ra.sl[6]=4791; /* line # 4791 */
        Rv6=((V *)Rv6)[3];
        if (Rv6==NULL)  break;
      }
      Ra.sl[6]=4793; /* line # 4793 */
      if (Rv18&&Rv7!=NULL) P_val_free(&Rv7);
      Ra.sl[6]=4794; /* line # 4794 */
      Rv18=0;
    }
  }
  Ra.sl[6]=4798; /* line # 4798 */
  if (!Rv0) {
    Ra.sl[6]=4799; /* line # 4799 */
    Ra.sl[6]=4800; /* line # 4800 */
    switch (F_v_class) {
      case 1:
      case 6:Ra.sl[6]=4802; /* line # 4802 */
      Rv25=F_ty;
      Ra.sl[6]=4803; /* line # 4803 */
      switch (V_sy_sym.ub[0]) {
        case 72:Ra.sl[6]=4805; /* line # 4805 */
        if (F_v_class==6&&(*F_isz)>=0) {
          Ra.sl[6]=4806; /* line # 4806 */
          ((V *)Rv25)[9]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
        }
        break;
        case 14:Ra.sl[6]=4810; /* line # 4810 */
        if (F_v_class==6&&(*F_isz)>=0) {
          Ra.sl[6]=4811; /* line # 4811 */
          ((V *)Rv25)[9]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
        }
        Ra.sl[6]=4812; /* line # 4812 */
        if (((UB *)F_ty)[93]!=23) {
          Ra.sl[6]=4814; /* line # 4814 */
          P_src_error(Rd.s+826,223,2);
          P_insymbol();
        }
        break;
        case 56:Ra.sl[6]=4819; /* line # 4819 */
        Rv26=F_ty;
        Rv27=(V_lex_ident_tree.s+V_curr_disp*64);
        Ra.sl[6]=4820; /* line # 4820 */
        if (((SL *)Rv26)[11]<0) {
          Ra.sl[6]=4822; /* line # 4822 */
          P_src_error(Rd.s+826,224,3);
          Ra.sl[6]=4823; /* line # 4823 */
          P_insymbol();
          P_skip_symbol(72,0,0);
        }
        else {
          Ra.sl[6]=4827; /* line # 4827 */
          P_insymbol();
          Ra.sl[6]=4828; /* line # 4828 */
          if (F_v_class==6) {
            Ra.sl[6]=4829; /* line # 4829 */
            if (((V *)Rv26)[13]==NULL) {
              Ra.sl[6]=4830; /* line # 4830 */
              ((V *)Rv26)[12]=((V *)Rv27)[1];
            }
            else {
              Ra.sl[6]=4832; /* line # 4832 */
              ((V *)Rv26)[12]=((V *)((V *)Rv26)[13])[3];
            }
          }
          Ra.sl[6]=4833; /* line # 4833 */
          ((V *)Rv26)[13]=((V *)Rv27)[4];
          Ra.sl[6]=4834; /* line # 4834 */
          ((V *)Rv26)[14]=PAS_COMILER_PRC_00000004(41, F_ty);
          Ra.sl[6]=4835; /* line # 4835 */
          ((V *)Rv26)[9]=P_lgt_new_code(0,((V *)Rv26)[14]);
        }
        break;
        default:Ra.sl[6]=4840; /* line # 4840 */
        P_src_error(Rd.s+826,225,2);
        break;
      }
      break;
      case 2:Ra.sl[6]=4843; /* line # 4843 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+826,23,2);
      else {
        Ra.sl[6]=4844; /* line # 4844 */
        P_insymbol();
      }
      break;
      default:break;
    }
  }
  Ra.sl[6]=4848; /* line # 4848 */
  (*F_aln)=Rv3;
  Ra.sl[6]=4849; /* line # 4849 */
  if (F_ty!=NULL) {
    Ra.sl[6]=4850; /* line # 4850 */
    Rv28=F_ty;
    Ra.sl[6]=4851; /* line # 4851 */
    if (Rv3>((UB *)Rv28)[48]) ((UB *)Rv28)[48]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " const_decl "  */
void PAS_COMILER_PRC_00000044(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+830;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4866; /* line # 4866 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=4867; /* line # 4867 */
  Ra.sl[6]=4869; /* line # 4869 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==43){
    Ra.sl[6]=4871; /* line # 4871 */
    if (V_sy_sym.ub[0]==43) {
      Ra.sl[6]=4873; /* line # 4873 */
      P_insymbol();
      Ra.sl[6]=4874; /* line # 4874 */
      Rv0=1;
    }
    else {
      Ra.sl[6]=4876; /* line # 4876 */
      Rv0=0;
    }
    Ra.sl[6]=4877; /* line # 4877 */
    if (V_sy_sym.ub[0]!=0) {
      Ra.sl[6]=4879; /* line # 4879 */
      P_src_error(Rd.s+844,107,3);
      Ra.sl[6]=4880; /* line # 4880 */
      P_skip_symbol(18,0,0);
    }
    else {
      Ra.sl[6]=4884; /* line # 4884 */
      P_ide_new(4,NULL,&Rv1);
      Ra.sl[6]=4885; /* line # 4885 */
      P_insymbol();
      Ra.sl[6]=4887; /* line # 4887 */
      if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) {
        Ra.sl[6]=4888; /* line # 4888 */
        P_src_error(Rd.s+844,30,2);
      }
      else {
        Ra.sl[6]=4890; /* line # 4890 */
        P_insymbol();
      }
      Ra.sl[6]=4891; /* line # 4891 */
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=4892; /* line # 4892 */
      Rv3=Rv1;
      Rv4=Rv2;
      Ra.sl[6]=4894; /* line # 4894 */
      if (((UB *)Rv4)[40]!=14) P_src_error(Rd.s+844,53,3);
      else {
        Ra.sl[6]=4897; /* line # 4897 */
        ((V *)Rv3)[5]=((V *)Rv4)[3];
        Ra.sl[6]=4898; /* line # 4898 */
        ((V *)Rv3)[7]=((V *)Rv4)[7];
        Ra.sl[6]=4899; /* line # 4899 */
        ((UB *)Rv3)[72]=2;
        Ra.sl[6]=4900; /* line # 4900 */
        ((V *)Rv4)[7]=NULL;
        Ra.sl[6]=4901; /* line # 4901 */
        if ((((V *)Rv3)[7]!=NULL&&!Rv0)&&V_cmp_igenv==0) {
          Ra.sl[6]=4902; /* line # 4902 */
          if (((V *)Rv3)[5]!=NULL) {
            Ra.sl[6]=4903; /* line # 4903 */
            Rv5=((V *)Rv3)[7];
            Ra.sl[6]=4905; /* line # 4905 */
            ((SL *)Rv5)[5]=0;
            Ra.sl[6]=4906; /* line # 4906 */
            ((UW *)Rv5)[8]=((UW *)Rv5)[8]&~16384;
            Ra.sl[6]=4907; /* line # 4907 */
            P_cte_allocate(((V *)Rv3)[7],Rv1);
          }
        }
        Ra.sl[6]=4910; /* line # 4910 */
        if (V_sy_init_mod) {
          Ra.sl[6]=4911; /* line # 4911 */
          if (((UB *)((V *)Rv3)[5])[93]==8) {
            Ra.sl[6]=4912; /* line # 4912 */
            if (V_usi_tab==NULL) V_usi_tab=Rv1;
            else {
              Ra.sl[6]=4913; /* line # 4913 */
              if (V_csi_tab==NULL) V_csi_tab=Rv1;
            }
          }
        }
      }
      Ra.sl[6]=4916; /* line # 4916 */
      if (Rv2!=NULL) P_lgt_free_tree(&Rv2);
    }
    Ra.sl[6]=4918; /* line # 4918 */
    if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==18) P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_decl "  */
void PAS_COMILER_PRC_00000045(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UL Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  V Rv18;
  UB Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+848;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4940; /* line # 4940 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=4941; /* line # 4941 */
  Ra.sl[6]=4943; /* line # 4943 */
  if (V_sy_init_mod) {
    Ra.sl[6]=4944; /* line # 4944 */
    while (V_sy_sym.ub[0]==57){
      Ra.sl[6]=4946; /* line # 4946 */
      P_insymbol();
      Ra.sl[6]=4947; /* line # 4947 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=4949; /* line # 4949 */
        Rv0=P_ide_search(2);
        Ra.sl[6]=4950; /* line # 4950 */
        if (Rv0!=NULL) Rv1=((V *)Rv0)[5];
        else {
          Ra.sl[6]=4951; /* line # 4951 */
          Rv1=NULL;
        }
        Ra.sl[6]=4952; /* line # 4952 */
        if (Rv1!=NULL) {
          Ra.sl[6]=4954; /* line # 4954 */
          P_insymbol();
          Ra.sl[6]=4955; /* line # 4955 */
          if (V_sy_sym.ub[0]==73) {
            Ra.sl[6]=4956; /* line # 4956 */
            Rv2=Rv1;
            Ra.sl[6]=4958; /* line # 4958 */
            Rv3=((SL *)Rv2)[11];
            Ra.sl[6]=4959; /* line # 4959 */
            Rv4=0;
            Ra.sl[6]=4960; /* line # 4960 */
            PAS_COMILER_PRC_00000040(&Rv3, &Rv4);
            Ra.sl[6]=4961; /* line # 4961 */
            ((SL *)Rv2)[11]=Rv3;
            ((UB *)Rv2)[48]=Rv4;
            Ra.sl[6]=4963; /* line # 4963 */
            if ((((UB *)Rv2)[93]==2||((UB *)Rv2)[93]==1)||((UB *)Rv2)[93]==0) {
              Ra.sl[6]=4966; /* line # 4966 */
              if (Rv3<4) {
                Ra.sl[6]=4968; /* line # 4968 */
                if (((UB *)Rv2)[112]) {
                  Ra.sl[6]=4970; /* line # 4970 */
                  ((UL *)Rv2)[29]=0;
                  Ra.sl[6]=4971; /* line # 4971 */
                  Rv5=PAS__IIPOWER(2,8*Rv3);
                  Ra.sl[6]=4972; /* line # 4972 */
                  if (((UL *)Rv2)[30]>Rv5) ((UL *)Rv2)[30]=Rv5-1;
                }
                else {
                  Ra.sl[6]=4976; /* line # 4976 */
                  Rv6=PAS__IIPOWER(2,8*Rv3-1);
                  Ra.sl[6]=4977; /* line # 4977 */
                  if (((SL *)Rv2)[30]>=Rv6) ((SL *)Rv2)[30]=Rv6-1;
                  Ra.sl[6]=4978; /* line # 4978 */
                  if (((SL *)Rv2)[29]<= -Rv6) ((SL *)Rv2)[29]= -Rv6;
                }
              }
              else {
                Ra.sl[6]=4982; /* line # 4982 */
                if (((UB *)Rv2)[112]) {
                  ((SL *)Rv2)[29]=0;
                  ((SL *)Rv2)[30]=-1;
                }
                else {
                  Ra.sl[6]=4983; /* line # 4983 */
                  ((SL *)Rv2)[30]=2147483647;
                  ((SL *)Rv2)[29]= -((SL *)Rv2)[30]-1;
                }
              }
            }
            Ra.sl[6]=4985; /* line # 4985 */
            switch (((UB *)Rv2)[93]) {
              case 2:Ra.sl[6]=4988; /* line # 4988 */
              V_inte_size=((SL *)Rv2)[11];
              Ra.sl[6]=4989; /* line # 4989 */
              ((SL *)V_uns_typ)[11]=((SL *)Rv2)[11];
              Ra.sl[6]=4990; /* line # 4990 */
              ((UB *)V_uns_typ)[48]=((UB *)Rv2)[48];
              break;
              case 5:
              case 13:Ra.sl[6]=4994; /* line # 4994 */
              V_fptr_size=((SL *)Rv2)[11];
              Ra.sl[6]=4995; /* line # 4995 */
              ((SL *)V_typ_std.v[13])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=4996; /* line # 4996 */
              ((UB *)V_typ_std.v[13])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=4997; /* line # 4997 */
              ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=4998; /* line # 4998 */
              ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=4999; /* line # 4999 */
              ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5000; /* line # 5000 */
              ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5001; /* line # 5001 */
              ((SL *)V_typ_std.v[16])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5002; /* line # 5002 */
              ((UB *)V_typ_std.v[16])[48]=((UB *)Rv2)[48];
              break;
              case 3:Ra.sl[6]=5004; /* line # 5004 */
              V_sngl_size=((SL *)Rv2)[11];
              break;
              case 4:Ra.sl[6]=5005; /* line # 5005 */
              V_dble_size=((SL *)Rv2)[11];
              break;
              case 17:
              case 19:Ra.sl[6]=5008; /* line # 5008 */
              V_dst_setw=((SL *)Rv2)[11]*8;
              Ra.sl[6]=5009; /* line # 5009 */
              V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
              Ra.sl[6]=5010; /* line # 5010 */
              ((UB *)V_typ_std.v[18])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5011; /* line # 5011 */
              ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5012; /* line # 5012 */
              ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5013; /* line # 5013 */
              ((SL *)V_typ_std.v[19])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5014; /* line # 5014 */
              ((SL *)V_typ_std.v[17])[11]=((SL *)Rv2)[11];
              break;
              case 18:Ra.sl[6]=5018; /* line # 5018 */
              V_dst_seta=((SL *)Rv2)[11]*8;
              Ra.sl[6]=5019; /* line # 5019 */
              V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
              Ra.sl[6]=5020; /* line # 5020 */
              ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5021; /* line # 5021 */
              ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
              break;
              case 16:Ra.sl[6]=5026; /* line # 5026 */
              Rv7=((UB *)V_typ_std.v[5])[48];
              Ra.sl[6]=5027; /* line # 5027 */
              if (Rv7!=Rv4) ((UB *)Rv2)[48]=Rv7;
              Ra.sl[6]=5029; /* line # 5029 */
              Rv7=((SL *)V_typ_std.v[16])[11];
              Ra.sl[6]=5030; /* line # 5030 */
              if (Rv3!=Rv7) {
                Ra.sl[6]=5032; /* line # 5032 */
                if (Rv3<Rv7) Rv3=Rv7;
                else {
                  Ra.sl[6]=5033; /* line # 5033 */
                  if (PAS__I_MOD(Rv3,Rv7)!=0) Rv3=Rv7*(Rv3/Rv7+1);
                }
                Ra.sl[6]=5034; /* line # 5034 */
                ((SL *)Rv2)[11]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=5040; /* line # 5040 */
            if (V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
            Ra.sl[6]=5042; /* line # 5042 */
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else {
              Ra.sl[6]=5043; /* line # 5043 */
              P_src_error(Rd.s+861,21,2);
            }
          }
          else {
            Ra.sl[6]=5045; /* line # 5045 */
            P_skip_symbol(18,0,0);
          }
        }
        else {
          Ra.sl[6]=5049; /* line # 5049 */
          P_src_error(Rd.s+861,8001,3);
          Ra.sl[6]=5050; /* line # 5050 */
          P_skip_symbol(18,0,0);
        }
      }
      else {
        Ra.sl[6]=5055; /* line # 5055 */
        P_src_error(Rd.s+861,8002,3);
        Ra.sl[6]=5056; /* line # 5056 */
        P_skip_symbol(18,0,0);
      }
    }
  }
  Ra.sl[6]=5062; /* line # 5062 */
  while (V_sy_sym.ub[0]==0){
    Ra.sl[6]=5064; /* line # 5064 */
    Rv0=Lx[5].v[1];
    Rv8=NULL;
    Ra.sl[6]=5065; /* line # 5065 */
    while (Rv0!=NULL&&Rv8==NULL){
      Ra.sl[6]=5067; /* line # 5067 */
      Rv9=Rv0;
      Ra.sl[6]=5068; /* line # 5068 */
      if (P_match(((V *)Rv9)[0],V_sy_ident.s)==0) {
        Ra.sl[6]=5070; /* line # 5070 */
        Rv8=Rv0;
        Ra.sl[6]=5071; /* line # 5071 */
        if (Rv0==Lx[5].v[1]) Lx[5].v[1]=((V *)Lx[5].v[1])[7];
        else {
          Ra.sl[6]=5072; /* line # 5072 */
          ((V *)Rv10)[7]=((V *)Rv0)[7];
        }
      }
      Ra.sl[6]=5074; /* line # 5074 */
      Rv10=Rv0;
      Rv0=((V *)Rv0)[7];
    }
    Ra.sl[6]=5076; /* line # 5076 */
    if (Rv8==NULL) {
      Ra.sl[6]=5079; /* line # 5079 */
      P_ide_new(1,NULL,&Rv8);
      Ra.sl[6]=5080; /* line # 5080 */
      Rv1=NULL;
    }
    else {
      Ra.sl[6]=5082; /* line # 5082 */
      Rv1=((V *)Rv8)[5];
    }
    Ra.sl[6]=5083; /* line # 5083 */
    Rv11=Rv8;
    Ra.sl[6]=5085; /* line # 5085 */
    Rv12=V_curr_disp;
    Ra.sl[6]=5086; /* line # 5086 */
    P_insymbol();
    Ra.sl[6]=5087; /* line # 5087 */
    Rv3=0;
    Ra.sl[6]=5088; /* line # 5088 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=5090; /* line # 5090 */
      P_insymbol();
      Ra.sl[6]=5091; /* line # 5091 */
      P_new_disp_level(NULL,4);
      Ra.sl[6]=5092; /* line # 5092 */
      PAS_COMILER_PRC_00000037(2, &Rv3, &Rv7,NULL);
      Ra.sl[6]=5093; /* line # 5093 */
      Rv0=V_lex_ident_tree.v[V_curr_disp*8+1];
      Ra.sl[6]=5094; /* line # 5094 */
      Rv13=Rv0;
      Ra.sl[6]=5095; /* line # 5095 */
      Rv14=NULL;
      Ra.sl[6]=5096; /* line # 5096 */
      while (Rv13!=NULL){
        Ra.sl[6]=5098; /* line # 5098 */
        P_lgt_new(&Rv15,((V *)Rv13)[5],14,NULL);
        Ra.sl[6]=5099; /* line # 5099 */
        ((V *)Rv15)[7]=((V *)Rv13)[10];
        Ra.sl[6]=5100; /* line # 5100 */
        P_val_new(((V *)Rv15)+7,((V *)Rv13)[5]);
        Ra.sl[6]=5101; /* line # 5101 */
        if (Rv14==NULL) Rv14=Rv15;
        else {
          Ra.sl[6]=5102; /* line # 5102 */
          ((V *)Rv16)[0]=Rv15;
        }
        Ra.sl[6]=5103; /* line # 5103 */
        Rv16=Rv15;
        Ra.sl[6]=5104; /* line # 5104 */
        Rv13=((V *)Rv13)[3];
      }
    }
    else {
      Ra.sl[6]=5107; /* line # 5107 */
      Rv0=NULL;
    }
    Ra.sl[6]=5109; /* line # 5109 */
    if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+861,30,2);
    else {
      Ra.sl[6]=5110; /* line # 5110 */
      P_insymbol();
    }
    Ra.sl[6]=5112; /* line # 5112 */
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043(0);
    Ra.sl[6]=5115; /* line # 5115 */
    PAS_COMILER_PRC_00000038(((V *)Rv11)+5,Rv3, Rv0,1,0,NULL);
    Ra.sl[6]=5117; /* line # 5117 */
    V_curr_disp=Rv12;
    Ra.sl[6]=5118; /* line # 5118 */
    ((V *)Rv11)[10]=V_sy_type_gfirst;
    Ra.sl[6]=5119; /* line # 5119 */
    ((V *)Rv11)[11]=NULL;
    Ra.sl[6]=5120; /* line # 5120 */
    V_tcas_flag=0;
    Ra.sl[6]=5121; /* line # 5121 */
    Rv17=((V *)Rv11)[5];
    Ra.sl[6]=5122; /* line # 5122 */
    if (Rv0!=NULL) {
      Ra.sl[6]=5126; /* line # 5126 */
      switch (((UB *)Rv17)[93]) {
        case 8:
        case 10:
        case 11:
        case 12:
        case 22:
        case 27:Ra.sl[6]=5130; /* line # 5130 */
        ((SL *)Rv17)[10]=P_ide_typ_align(Rv3,((V *)Rv11)[5]);
        Ra.sl[6]=5131; /* line # 5131 */
        ((V *)Rv17)[4]=Rv0;
        Ra.sl[6]=5132; /* line # 5132 */
        ((UB *)Rv17)[91]=1;
        Ra.sl[6]=5133; /* line # 5133 */
        if (Rv7>((UB *)((V *)Rv11)[5])[48]) {
          Ra.sl[6]=5134; /* line # 5134 */
          ((UB *)((V *)Rv11)[5])[48]=Rv7;
        }
        Ra.sl[6]=5135; /* line # 5135 */
        if (((SL *)Rv17)[11]<0) {
          Ra.sl[6]=5137; /* line # 5137 */
          Rv18=P_lgt_type_eval(((V *)Rv17)[9],NULL,NULL,0);
          Ra.sl[6]=5138; /* line # 5138 */
          if (((UB *)Rv18)[40]==14) {
            Ra.sl[6]=5140; /* line # 5140 */
            ((SL *)Rv17)[11]= -((SL *)((V *)Rv18)[7])[13];
            Ra.sl[6]=5142; /* line # 5142 */
            if (((SL *)Rv17)[11]>=0) ((SL *)Rv17)[11]=-1;
            Ra.sl[6]=5143; /* line # 5143 */
            P_lgt_free(&Rv18);
          }
        }
        break;
        default:Ra.sl[6]=5149; /* line # 5149 */
        P_src_error(Rd.s+861,205,3);
        break;
      }
      Ra.sl[6]=5152; /* line # 5152 */
      Rv19=((UB *)Rv17)[93]!=10;
      Ra.sl[6]=5154; /* line # 5154 */
      if (Rv19) {
        Ra.sl[6]=5156; /* line # 5156 */
        if (((V *)Rv17)[9]==NULL) {
          Ra.sl[6]=5157; /* line # 5157 */
          ((SL *)Rv17)[11]=((SL *)Rv17)[11]+((SL *)Rv17)[10];
        }
        else {
          Ra.sl[6]=5160; /* line # 5160 */
          if (((UB *)((V *)Rv17)[9])[40]==14) {
            Ra.sl[6]=5162; /* line # 5162 */
            Rv20=((V *)Rv17)[9];
            Ra.sl[6]=5163; /* line # 5163 */
            if (((V *)Rv20)[7]!=NULL) {
              Ra.sl[6]=5164; /* line # 5164 */
              ((SL *)((V *)Rv20)[7])[13]=((SL *)((V *)Rv20)[7])[13]+((SL *)Rv17)
              [10];
            }
          }
          else {
            Ra.sl[6]=5168; /* line # 5168 */
            ((V *)((V *)Rv17)[9])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv17)
            [10]);
            Ra.sl[6]=5170; /* line # 5170 */
            ((V *)Rv17)[9]=P_lgt_new_code(49,((V *)Rv17)[9]);
          }
        }
      }
      Ra.sl[6]=5175; /* line # 5175 */
      if (V_tcas_flag) P_lgt_gen_routine(((V *)Rv11)[5]);
    }
    Ra.sl[6]=5187; /* line # 5187 */
    Rv21=((V *)Rv11)[5];
    Ra.sl[6]=5188; /* line # 5188 */
    if (((V *)Rv21)[3]==NULL) {
      Ra.sl[6]=5190; /* line # 5190 */
      if (((V *)Rv21)[0]!=NULL) {
        Ra.sl[6]=5191; /* line # 5191 */
        if (((V *)((V *)Rv21)[0])[3]!=NULL) {
          Ra.sl[6]=5193; /* line # 5193 */
          ((V *)Rv11)[10]=((V *)((V *)((V *)Rv21)[0])[3])[10];
        }
      }
      Ra.sl[6]=5194; /* line # 5194 */
      ((V *)Rv21)[3]=Rv8;
    }
    Ra.sl[6]=5197; /* line # 5197 */
    if (Rv1!=NULL) ((V *)Rv1)[12]=((V *)Rv11)[5];
    Ra.sl[6]=5200; /* line # 5200 */
    if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
      Ra.sl[6]=5202; /* line # 5202 */
      P_insymbol();
      Ra.sl[6]=5203; /* line # 5203 */
      if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) Rv18=PAS_COMILER_PRC_00000019((
      (V *)Rv11)[5]);
      else {
        Ra.sl[6]=5204; /* line # 5204 */
        Rv18=PAS_COMILER_PRC_00000005(((V *)Rv11)[5],0,0,0);
      }
      Ra.sl[6]=5205; /* line # 5205 */
      if (((UB *)Rv18)[40]!=14) {
        Ra.sl[6]=5206; /* line # 5206 */
        P_src_error(Rd.s+861,53,3);
      }
      else {
        Ra.sl[6]=5209; /* line # 5209 */
        Rv22=Rv18;
        Ra.sl[6]=5211; /* line # 5211 */
        ((V *)((V *)Rv11)[5])[10]=((V *)Rv22)[7];
        Ra.sl[6]=5212; /* line # 5212 */
        ((V *)Rv22)[7]=NULL;
      }
      Ra.sl[6]=5214; /* line # 5214 */
      P_lgt_free_tree(&Rv18);
    }
    Ra.sl[6]=5218; /* line # 5218 */
    if (Rv0!=NULL&&((V *)Rv11)[5]!=NULL) {
      Ra.sl[6]=5220; /* line # 5220 */
      ((V *)((V *)Rv11)[5])[1]=P_type_parm_set(Rv8, Rv14);
    }
    Ra.sl[6]=5221; /* line # 5221 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=5222; /* line # 5222 */
      P_src_error(Rd.s+861,21,2);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_decl "  */
void PAS_COMILER_PRC_00000046(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+865;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5243; /* line # 5243 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=5244; /* line # 5244 */
  Rv0=0;
  Ra.sl[6]=5245; /* line # 5245 */
  Ra.sl[6]=5246; /* line # 5246 */
  PAS_COMILER_PRC_00000037(5, &Rv0, &Rv1,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " label_decl "  */
void PAS_COMILER_PRC_00000047(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+877;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5260; /* line # 5260 */
  Rv0=0;
  Ra.sl[6]=5261; /* line # 5261 */
  while (1){
    Ra.sl[6]=5264; /* line # 5264 */
    P_insymbol();
    Ra.sl[6]=5265; /* line # 5265 */
    if (V_sy_sym.ub[0]==2) P_ide_int_label();
    Ra.sl[6]=5266; /* line # 5266 */
    if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+891,69,3);
    else {
      Ra.sl[6]=5270; /* line # 5270 */
      P_ide_new(3,NULL,&Rv1);
      Ra.sl[6]=5271; /* line # 5271 */
      if (Rv1!=NULL) {
        Ra.sl[6]=5272; /* line # 5272 */
        Rv2=Rv1;
        Ra.sl[6]=5274; /* line # 5274 */
        Rv3=Lx[5].v[13];
        Ra.sl[6]=5275; /* line # 5275 */
        if (((V *)Rv3)[20]==NULL) ((V *)Rv3)[20]=Rv1;
        else {
          Ra.sl[6]=5276; /* line # 5276 */
          ((V *)Lx[5].v[4])[7]=Rv1;
        }
        Ra.sl[6]=5277; /* line # 5277 */
        Lx[5].v[4]=Rv1;
        Ra.sl[6]=5278; /* line # 5278 */
        ((UB *)Rv2)[54]=1;
      }
    }
    Ra.sl[6]=5281; /* line # 5281 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=17)  break;
  }
  Ra.sl[6]=5283; /* line # 5283 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else {
    Ra.sl[6]=5284; /* line # 5284 */
    P_src_error(Rd.s+891,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement_decl "  */
void PAS_COMILER_PRC_00000048(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+895;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5304; /* line # 5304 */
  Ra.sl[6]=5306; /* line # 5306 */
  P_insymbol();
  Ra.sl[6]=5307; /* line # 5307 */
  if (V_sy_sym.ub[0]!=0) {
    Ra.sl[6]=5309; /* line # 5309 */
    P_src_error(Rd.s+913,107,3);
    Ra.sl[6]=5310; /* line # 5310 */
    P_skip_symbol(18,1,0);
  }
  else {
    Ra.sl[6]=5314; /* line # 5314 */
    V_err_prt=0;
    Ra.sl[6]=5315; /* line # 5315 */
    Rv0=P_ide_search(1024);
    Ra.sl[6]=5316; /* line # 5316 */
    V_err_prt=1;
    Ra.sl[6]=5317; /* line # 5317 */
    if (Rv0!=NULL) {
      Ra.sl[6]=5318; /* line # 5318 */
      if (((SL *)Rv0)[12]!=V_curr_lex) Rv1=NULL;
      else {
        Ra.sl[6]=5319; /* line # 5319 */
        Rv1=Rv0;
      }
    }
    else {
      Ra.sl[6]=5320; /* line # 5320 */
      Rv1=NULL;
    }
    Ra.sl[6]=5322; /* line # 5322 */
    if (Rv1==NULL) {
      Ra.sl[6]=5323; /* line # 5323 */
      P_ide_new(10,NULL,&Rv1);
    }
    Ra.sl[6]=5324; /* line # 5324 */
    P_insymbol();
    Ra.sl[6]=5326; /* line # 5326 */
    Ra.sl[6]=5328; /* line # 5328 */
    if (V_sy_sym.ub[0]==57) {
      Ra.sl[6]=5330; /* line # 5330 */
      P_insymbol();
      Ra.sl[6]=5331; /* line # 5331 */
      if (V_sy_sym.ub[0]==37) P_insymbol();
      Ra.sl[6]=5332; /* line # 5332 */
      if (V_sy_sym.ub[0]==40) {
        Ra.sl[6]=5334; /* line # 5334 */
        P_insymbol();
        Ra.sl[6]=5335; /* line # 5335 */
        if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+913,25,2);
        Ra.sl[6]=5336; /* line # 5336 */
        Rv2=0;
        Ra.sl[6]=5338; /* line # 5338 */
        PAS_COMILER_PRC_00000042(Ri.v+3,1, &Rv2,NULL);
      }
      else {
        Ra.sl[6]=5341; /* line # 5341 */
        PAS_COMILER_PRC_00000038(Ri.v+3,0,NULL,0,1,NULL);
      }
      Ra.sl[6]=5343; /* line # 5343 */
      if (V_sy_sym.ub[0]==22) {
        Ra.sl[6]=5345; /* line # 5345 */
        P_insymbol();
        Ra.sl[6]=5346; /* line # 5346 */
        Ri.v[4]=PAS_COMILER_PRC_00000005(Ri.v[3],0,0,0);
      }
      Ra.sl[6]=5348; /* line # 5348 */
      if (V_sy_sym.ub[0]==48) {
        Ra.sl[6]=5349; /* line # 5349 */
        Ri.ub[17]=1;
        P_insymbol();
      }
      Ra.sl[6]=5350; /* line # 5350 */
      if (V_sy_sym.ub[0]==53) P_insymbol();
      else {
        Ra.sl[6]=5351; /* line # 5351 */
        P_src_error(Rd.s+913,55,2);
      }
    }
    Ra.sl[6]=5353; /* line # 5353 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5355; /* line # 5355 */
      Ri.v[5]=P_ide_search(514);
      Ra.sl[6]=5356; /* line # 5356 */
      P_insymbol();
    }
    Ra.sl[6]=5358; /* line # 5358 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else {
      Ra.sl[6]=5359; /* line # 5359 */
      P_src_error(Rd.s+913,29,2);
    }
    Ra.sl[6]=5360; /* line # 5360 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5362; /* line # 5362 */
      Ri.v[6]=P_ide_search(514);
      Ra.sl[6]=5363; /* line # 5363 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=5364; /* line # 5364 */
      P_src_error_s(Rd.s+913,42,3,((V *)Rv1)[0],NULL);
    }
    Ra.sl[6]=5365; /* line # 5365 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=5367; /* line # 5367 */
      P_insymbol();
      Ra.sl[6]=5368; /* line # 5368 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5370; /* line # 5370 */
        Ri.v[7]=P_ide_search(514);
        Ra.sl[6]=5371; /* line # 5371 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=5373; /* line # 5373 */
        P_src_error_s(Rd.s+913,43,2,((V *)Rv1)[0],NULL);
      }
    }
    Ra.sl[6]=5377; /* line # 5377 */
    if (V_error_result<=1) {
      Ra.sl[6]=5379; /* line # 5379 */
      Rv3=PAS__NEW(56);
      Ra.sl[6]=5380; /* line # 5380 */
      memcpy(Rv3,Ri.s+8,56);
      Ra.sl[6]=5381; /* line # 5381 */
      Rv4=Rv1;
      Ra.sl[6]=5383; /* line # 5383 */
      if (((V *)Rv4)[8]==NULL) {
        Ra.sl[6]=5385; /* line # 5385 */
        if (Rv0!=NULL) {
          Ra.sl[6]=5386; /* line # 5386 */
          ((V *)Rv3)[0]=((V *)Rv0)[7];
        }
        Ra.sl[6]=5387; /* line # 5387 */
        ((V *)Rv4)[7]=Rv3;
        Ra.sl[6]=5388; /* line # 5388 */
        ((V *)Rv4)[8]=Rv3;
      }
      else {
        Ra.sl[6]=5392; /* line # 5392 */
        ((V *)Rv3)[0]=((V *)((V *)Rv4)[8])[0];
        Ra.sl[6]=5393; /* line # 5393 */
        ((V *)((V *)Rv4)[8])[0]=Rv3;
        Ra.sl[6]=5394; /* line # 5394 */
        ((V *)Rv4)[8]=Rv3;
      }
    }
  }
  Ra.sl[6]=5399; /* line # 5399 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else {
    Ra.sl[6]=5400; /* line # 5400 */
    P_src_error(Rd.s+913,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " argument_list "  */
UB PAS_COMILER_PRC_00000003(V *F_pr, UB F_isfunct, UB F_no_entry){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  SL Rv8;
  UW Rv9;
  UB Rv10;
  UW Rv11;
  UB Rv12;
  SL Rv13;
  V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+917;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5438; /* line # 5438 */
  Rv0=0;
  Ra.sl[6]=5439; /* line # 5439 */
  Rv1=Lx[5].v[13];
  Ra.sl[6]=5440; /* line # 5440 */
  Lx[5].v[13]=(*F_pr);
  Ra.sl[6]=5441; /* line # 5441 */
  Rv2=NULL;
  Ra.sl[6]=5442; /* line # 5442 */
  Rv3=0;
  Ra.sl[6]=5443; /* line # 5443 */
  Rv4=(*F_pr);
  Ra.sl[6]=5445; /* line # 5445 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=5447; /* line # 5447 */
    V_sy_sym.ub[0]=18;
    while (1){
      Ra.sl[6]=5449; /* line # 5449 */
      P_insymbol();
      Ra.sl[6]=5450; /* line # 5450 */
      if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
        Ra.sl[6]=5452; /* line # 5452 */
        if (F_no_entry) P_src_error(Rd.s+934,125,3);
        Ra.sl[6]=5453; /* line # 5453 */
        Rv0=1;
        Ra.sl[6]=5454; /* line # 5454 */
        Rv5=V_sy_sym.ub[0]==77;
        Ra.sl[6]=5455; /* line # 5455 */
        P_insymbol();
        Ra.sl[6]=5456; /* line # 5456 */
        Rv6=PAS_COMILER_PRC_00000001(Rv5);
        Ra.sl[6]=5457; /* line # 5457 */
        Rv3=Rv3+1;
        Ra.sl[6]=5459; /* line # 5459 */
        if (Rv2==NULL) Rv2=Rv6;
        Ra.sl[6]=5460; /* line # 5460 */
        Rv7=Rv6;
      }
      else {
        Ra.sl[6]=5464; /* line # 5464 */
        Rv8=0;
        Ra.sl[6]=5465; /* line # 5465 */
        Rv9=96;
        Ra.sl[6]=5466; /* line # 5466 */
        Rv10=0;
        Ra.sl[6]=5467; /* line # 5467 */
        Rv11=0;
        Ra.sl[6]=5468; /* line # 5468 */
        Rv12=9;
        while (1){
          Ra.sl[6]=5470; /* line # 5470 */
          switch (V_sy_sym.ub[0]) {
            case 30:Ra.sl[6]=5471; /* line # 5471 */
            Rv12=8;
            break;
            case 35:Ra.sl[6]=5472; /* line # 5472 */
            Rv9=32;
            Rv12=8;
            break;
            case 36:Ra.sl[6]=5473; /* line # 5473 */
            Rv9=64;
            Rv12=8;
            break;
            default:Ra.sl[6]=5475; /* line # 5475 */
            Rv10=1;
            break;
          }
          Ra.sl[6]=5477; /* line # 5477 */
          if (!Rv10) P_insymbol();
          if (Rv10)  break;
        }
        Ra.sl[6]=5480; /* line # 5480 */
        Rv7=NULL;
        Ra.sl[6]=5481; /* line # 5481 */
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=5483; /* line # 5483 */
          P_ide_new(5,NULL,&Rv6);
          Ra.sl[6]=5484; /* line # 5484 */
          Rv3=Rv3+1;
          Ra.sl[6]=5485; /* line # 5485 */
          Rv8=Rv8+1;
          Ra.sl[6]=5487; /* line # 5487 */
          if (Rv7==NULL) {
            Ra.sl[6]=5489; /* line # 5489 */
            if (Rv2==NULL) Rv2=Rv6;
            Ra.sl[6]=5490; /* line # 5490 */
            Rv7=Rv6;
          }
          Ra.sl[6]=5492; /* line # 5492 */
          P_insymbol();
          Ra.sl[6]=5493; /* line # 5493 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=5495; /* line # 5495 */
            if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+934,29,2);
          }
        }
        Ra.sl[6]=5498; /* line # 5498 */
        if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+934,31,2);
        else {
          Ra.sl[6]=5499; /* line # 5499 */
          P_insymbol();
        }
        Ra.sl[6]=5501; /* line # 5501 */
        if (V_sy_sym.ub[0]==15) {
          while (1){
            Ra.sl[6]=5504; /* line # 5504 */
            P_insymbol();
            Ra.sl[6]=5505; /* line # 5505 */
            if (V_sy_sym.ub[0]==0) {
              Ra.sl[6]=5507; /* line # 5507 */
              Rv6=P_level_search(V_attr_list);
              Ra.sl[6]=5508; /* line # 5508 */
              P_insymbol();
              Ra.sl[6]=5509; /* line # 5509 */
              if (Rv6!=NULL) {
                Ra.sl[6]=5510; /* line # 5510 */
                switch (((UB *)Rv6)[54]) {
                  case 17:Ra.sl[6]=5511; /* line # 5511 */
                  Rv9=Rv9|2048;
                  break;
                  case 16:Ra.sl[6]=5512; /* line # 5512 */
                  Rv9=Rv9|1024;
                  break;
                  case 1:Ra.sl[6]=5513; /* line # 5513 */
                  Rv9=Rv9|512;
                  break;
                  case 6:Ra.sl[6]=5514; /* line # 5514 */
                  Rv9=Rv9|256;
                  break;
                  case 21:Ra.sl[6]=5517; /* line # 5517 */
                  if (Rv12!=8) {
                    Ra.sl[6]=5518; /* line # 5518 */
                    P_src_error(Rd.s+934,242,2);
                  }
                  Ra.sl[6]=5519; /* line # 5519 */
                  Rv9=Rv9|8192;
                  break;
                  case 20:Ra.sl[6]=5521; /* line # 5521 */
                  Rv9=(Rv9|32)&~64;
                  break;
                  case 27:Ra.sl[6]=5522; /* line # 5522 */
                  Rv11=Rv11|4;
                  break;
                  case 28:Ra.sl[6]=5523; /* line # 5523 */
                  Rv11=Rv11|8;
                  break;
                  case 29:Ra.sl[6]=5524; /* line # 5524 */
                  Rv11=Rv11|16;
                  break;
                  case 30:Ra.sl[6]=5525; /* line # 5525 */
                  Rv11=Rv11|32;
                  break;
                  case 31:Ra.sl[6]=5526; /* line # 5526 */
                  Rv11=Rv11|64;
                  break;
                  default:break;
                }
              }
            }
            else {
              Ra.sl[6]=5530; /* line # 5530 */
              P_src_error(Rd.s+934,2,3);
            }
            if (V_sy_sym.ub[0]!=17)  break;
          }
          Ra.sl[6]=5532; /* line # 5532 */
          if (V_sy_sym.ub[0]==16) P_insymbol();
          else {
            Ra.sl[6]=5533; /* line # 5533 */
            P_src_error(Rd.s+934,26,2);
          }
        }
        Ra.sl[6]=5536; /* line # 5536 */
        if (V_sy_sym.ub[0]==37) P_insymbol();
        Ra.sl[6]=5537; /* line # 5537 */
        if (V_sy_sym.ub[0]==40) {
          Ra.sl[6]=5539; /* line # 5539 */
          if (Rv8>1) P_src_error(Rd.s+934,243,3);
          Ra.sl[6]=5540; /* line # 5540 */
          P_insymbol();
          Ra.sl[6]=5541; /* line # 5541 */
          if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+934,25,2);
          Ra.sl[6]=5542; /* line # 5542 */
          Rv13=0;
          Ra.sl[6]=5543; /* line # 5543 */
          if (!V_sy_init_mod) {
            Ra.sl[6]=5544; /* line # 5544 */
            if (Rv12==9&&!V_cmp_dynamic) {
              Ra.sl[6]=5546; /* line # 5546 */
              Rv12=8;
              Rv9=32;
              Ra.sl[6]=5547; /* line # 5547 */
              P_src_error(Rd.s+934,229,1);
            }
          }
          Ra.sl[6]=5550; /* line # 5550 */
          PAS_COMILER_PRC_00000042(&Rv14,1, &Rv13,NULL);
        }
        else {
          Ra.sl[6]=5554; /* line # 5554 */
          PAS_COMILER_PRC_00000038(&Rv14,0,NULL,0,1,NULL);
          Ra.sl[6]=5555; /* line # 5555 */
          if (Rv14!=NULL) {
            Ra.sl[6]=5556; /* line # 5556 */
            if (!V_sy_init_mod) {
              Ra.sl[6]=5557; /* line # 5557 */
              if ((((SL *)Rv14)[11]<0&&Rv12==9)&&!V_cmp_dynamic) {
                Ra.sl[6]=5560; /* line # 5560 */
                Rv12=8;
                Rv9=32;
                Ra.sl[6]=5561; /* line # 5561 */
                P_src_error(Rd.s+934,226,1);
              }
            }
          }
        }
        Ra.sl[6]=5564; /* line # 5564 */
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=5566; /* line # 5566 */
          P_insymbol();
          Ra.sl[6]=5567; /* line # 5567 */
          Rv15=PAS_COMILER_PRC_00000005(Rv14,0,0,0);
          Ra.sl[6]=5568; /* line # 5568 */
          Rv16=Rv15;
          Ra.sl[6]=5569; /* line # 5569 */
          if (((UB *)Rv16)[40]!=14) {
            Ra.sl[6]=5570; /* line # 5570 */
            P_src_error(Rd.s+934,53,3);
          }
          else {
            Ra.sl[6]=5573; /* line # 5573 */
            Rv17=((V *)Rv16)[7];
            Ra.sl[6]=5574; /* line # 5574 */
            ((V *)Rv16)[7]=NULL;
          }
          Ra.sl[6]=5576; /* line # 5576 */
          if (Rv12==8&&64&Rv9) {
            Ra.sl[6]=5577; /* line # 5577 */
            P_src_error(Rd.s+934,241,2);
          }
        }
        else {
          Ra.sl[6]=5579; /* line # 5579 */
          Rv17=NULL;
        }
        Ra.sl[6]=5580; /* line # 5580 */
        Rv6=Rv7;
        Ra.sl[6]=5581; /* line # 5581 */
        while (Rv6!=NULL){
          Ra.sl[6]=5583; /* line # 5583 */
          Rv18=Rv6;
          Ra.sl[6]=5584; /* line # 5584 */
          if (((UB *)Rv18)[86]==0) {
            Ra.sl[6]=5586; /* line # 5586 */
            ((V *)Rv18)[5]=Rv14;
            Ra.sl[6]=5587; /* line # 5587 */
            ((UW *)Rv18)[42]=Rv9;
            Ra.sl[6]=5588; /* line # 5588 */
            ((UB *)Rv18)[86]=Rv12;
            Ra.sl[6]=5589; /* line # 5589 */
            ((V *)Rv18)[7]=Rv17;
            Ra.sl[6]=5590; /* line # 5590 */
            ((UW *)Rv18)[44]=Rv11;
            Ra.sl[6]=5591; /* line # 5591 */
            if (Rv17!=NULL) P_val_new(((V *)Rv18)+7,Rv14);
          }
          Ra.sl[6]=5593; /* line # 5593 */
          Rv7=Rv6;
          Rv6=((V *)Rv6)[3];
        }
        Ra.sl[6]=5595; /* line # 5595 */
        if (Rv17!=NULL) P_val_free(&Rv17);
      }
      if (V_sy_sym.ub[0]!=18)  break;
    }
    Ra.sl[6]=5598; /* line # 5598 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=5599; /* line # 5599 */
      P_src_error(Rd.s+934,23,2);
    }
  }
  Ra.sl[6]=5601; /* line # 5601 */
  ((V *)Rv4)[11]=NULL;
  Ra.sl[6]=5602; /* line # 5602 */
  if (F_isfunct) {
    Ra.sl[6]=5604; /* line # 5604 */
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+934,31,2);
    Ra.sl[6]=5606; /* line # 5606 */
    Rv9=97;
    Ra.sl[6]=5607; /* line # 5607 */
    if (V_sy_sym.ub[0]==15) {
      while (1){
        Ra.sl[6]=5610; /* line # 5610 */
        P_insymbol();
        Ra.sl[6]=5611; /* line # 5611 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=5613; /* line # 5613 */
          Rv6=P_level_search(V_attr_list);
          Ra.sl[6]=5614; /* line # 5614 */
          P_insymbol();
          Ra.sl[6]=5615; /* line # 5615 */
          if (Rv6!=NULL) {
            Ra.sl[6]=5616; /* line # 5616 */
            switch (((UB *)Rv6)[54]) {
              case 16:Ra.sl[6]=5617; /* line # 5617 */
              Rv9=Rv9|1024;
              break;
              case 1:Ra.sl[6]=5618; /* line # 5618 */
              Rv9=Rv9|512;
              break;
              default:break;
            }
          }
        }
        else {
          Ra.sl[6]=5622; /* line # 5622 */
          P_src_error(Rd.s+934,2,3);
        }
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=5624; /* line # 5624 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=5625; /* line # 5625 */
        P_src_error(Rd.s+934,26,2);
      }
    }
    Ra.sl[6]=5627; /* line # 5627 */
    PAS_COMILER_PRC_00000038(((V *)Rv4)+11,0,NULL,0,1,NULL);
    Ra.sl[6]=5629; /* line # 5629 */
    if (((V *)Rv4)[11]==NULL) ((V *)Rv4)[11]=V_typ_std.v[21];
  }
  Ra.sl[6]=5631; /* line # 5631 */
  if (((V *)Rv4)[11]!=NULL) {
    Ra.sl[6]=5632; /* line # 5632 */
    if (!((UB *)((V *)Rv4)[11])[92]) {
      Ra.sl[6]=5634; /* line # 5634 */
      Rv19=((V *)Rv4)[11];
      Ra.sl[6]=5635; /* line # 5635 */
      if (((SL *)Rv19)[11]<0&&((V *)Rv19)[1]!=NULL) {
        Ra.sl[6]=5636; /* line # 5636 */
        ((V *)Rv4)[11]=((V *)Rv19)[1];
      }
      Ra.sl[6]=5639; /* line # 5639 */
      P_ide_create_name(Rd.s+938);
      Ra.sl[6]=5640; /* line # 5640 */
      P_ide_new(5,((V *)Rv4)[11],&Rv6);
      Ra.sl[6]=5641; /* line # 5641 */
      if (Rv2!=NULL) {
        Ra.sl[6]=5642; /* line # 5642 */
        ((V *)Rv7)[3]=NULL;
      }
      Ra.sl[6]=5643; /* line # 5643 */
      Rv20=Rv6;
      Ra.sl[6]=5645; /* line # 5645 */
      ((V *)Rv20)[3]=Rv2;
      Rv2=Rv6;
      Ra.sl[6]=5646; /* line # 5646 */
      ((UW *)Rv20)[42]=Rv9;
      Ra.sl[6]=5647; /* line # 5647 */
      ((UB *)Rv20)[86]=7;
    }
  }
  Ra.sl[6]=5650; /* line # 5650 */
  ((SL *)Rv4)[20]=Rv3;
  Ra.sl[6]=5651; /* line # 5651 */
  ((V *)Rv4)[8]=Rv2;
  Ra.sl[6]=5652; /* line # 5652 */
  Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
  Ra.sl[6]=5654; /* line # 5654 */
  ((V *)Rv4)[6]=((V *)Rv21)[1];
  Ra.sl[6]=5655; /* line # 5655 */
  ((V *)Rv4)[7]=((V *)Rv21)[4];
  Ra.sl[6]=5656; /* line # 5656 */
  ((V *)Rv4)[12]=((V *)Rv21)[5];
  Ra.sl[6]=5659; /* line # 5659 */
  Lx[5].v[13]=Rv1;
  Ra.sl[6]=5660; /* line # 5660 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_decl "  */
V PAS_COMILER_PRC_00000001(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+943;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5678; /* line # 5678 */
  Ra.sl[6]=5679; /* line # 5679 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=5681; /* line # 5681 */
    Rv0=P_level_search(V_lex_ident_tree.v[V_curr_disp*8+1]);
    Ra.sl[6]=5682; /* line # 5682 */
    if (Rv0!=NULL) P_src_error(Rd.s+963,101,3);
    Ra.sl[6]=5683; /* line # 5683 */
    P_ide_new(7,NULL,&Rv0);
    Ra.sl[6]=5684; /* line # 5684 */
    Rv1=PAS__NEW(120);
    Ra.sl[6]=5685; /* line # 5685 */
    Rv2=Rv1;
    Ra.sl[6]=5687; /* line # 5687 */
    ((V *)Rv2)[0]=NULL;
    Ra.sl[6]=5688; /* line # 5688 */
    ((V *)Rv2)[1]=NULL;
    Ra.sl[6]=5689; /* line # 5689 */
    ((UW *)Rv2)[8]=0;
    Ra.sl[6]=5690; /* line # 5690 */
    ((V *)Rv2)[3]=NULL;
    Ra.sl[6]=5691; /* line # 5691 */
    ((UB *)Rv2)[32]=29;
    Ra.sl[6]=5692; /* line # 5692 */
    ((V *)Rv2)[5]=NULL;
    Ra.sl[6]=5693; /* line # 5693 */
    ((V *)Rv2)[6]=NULL;
    Ra.sl[6]=5694; /* line # 5694 */
    ((V *)Rv2)[7]=NULL;
    Ra.sl[6]=5695; /* line # 5695 */
    ((V *)Rv2)[8]=NULL;
    Ra.sl[6]=5696; /* line # 5696 */
    ((SL *)Rv2)[18]=V_curr_lex;
    Ra.sl[6]=5697; /* line # 5697 */
    ((SL *)Rv2)[19]=0;
    Ra.sl[6]=5698; /* line # 5698 */
    ((SL *)Rv2)[20]=0;
    Ra.sl[6]=5699; /* line # 5699 */
    ((V *)Rv2)[11]=NULL;
    Ra.sl[6]=5700; /* line # 5700 */
    ((V *)Rv2)[12]=NULL;
    Ra.sl[6]=5701; /* line # 5701 */
    ((UB *)Rv2)[104]=4;
    Ra.sl[6]=5702; /* line # 5702 */
    ((V *)Rv2)[14]=NULL;
    Ra.sl[6]=5704; /* line # 5704 */
    ((V *)Rv0)[8]=Rv1;
    Ra.sl[6]=5706; /* line # 5706 */
    Rv3=V_curr_lex;
    Ra.sl[6]=5707; /* line # 5707 */
    Rv4=V_curr_disp;
    Ra.sl[6]=5708; /* line # 5708 */
    if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
    else {
      Ra.sl[6]=5709; /* line # 5709 */
      P_src_error(Rd.s+963,1002,3);
    }
    Ra.sl[6]=5710; /* line # 5710 */
    P_new_disp_level(Rv1,4);
    Ra.sl[6]=5711; /* line # 5711 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    Ra.sl[6]=5712; /* line # 5712 */
    P_insymbol();
    Ra.sl[6]=5713; /* line # 5713 */
    Rv5=PAS_COMILER_PRC_00000003(&Rv1, F_isfunction,0);
    Ra.sl[6]=5714; /* line # 5714 */
    V_curr_lex=Rv3;
    V_curr_disp=Rv4;
    Ra.sl[6]=5717; /* line # 5717 */
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[6]=5719; /* line # 5719 */
      P_insymbol();
      Ra.sl[6]=5720; /* line # 5720 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5723; /* line # 5723 */
        Rv6=P_ide_search(898);
        Ra.sl[6]=5724; /* line # 5724 */
        if (Rv6!=V_ide_udptr.v[1]) {
          Ra.sl[6]=5725; /* line # 5725 */
          Rv7=Rv6;
          Ra.sl[6]=5727; /* line # 5727 */
          Rv8=NULL;
          Ra.sl[6]=5728; /* line # 5728 */
          if (((UB *)Rv7)[53]==7) {
            Ra.sl[6]=5730; /* line # 5730 */
            Rv8=((V *)Rv7)[8];
            Ra.sl[6]=5731; /* line # 5731 */
            if (Rv8==Rv1) P_src_error(Rd.s+963,403,3);
          }
          else {
            Ra.sl[6]=5735; /* line # 5735 */
            if (((V *)Rv7)[11]!=((V *)Rv7)[10]&&((V *)Rv7)[11]!=NULL) {
              Ra.sl[6]=5736; /* line # 5736 */
              P_src_error_s(Rd.s+963,118,2, V_sy_ident.s,NULL);
            }
            else {
              Ra.sl[6]=5738; /* line # 5738 */
              Rv9=((V *)Rv7)[10];
              Ra.sl[6]=5739; /* line # 5739 */
              if (((UB *)Rv9)[8]) P_src_error(Rd.s+963,998,4);
              else {
                Ra.sl[6]=5740; /* line # 5740 */
                Rv8=((V *)Rv9)[2];
              }
            }
          }
          Ra.sl[6]=5743; /* line # 5743 */
          if (!P_comp_proc_arg(Rv8, Rv1)) P_src_error(Rd.s+963,119,3);
          else {
            Ra.sl[6]=5744; /* line # 5744 */
            ((V *)Rv0)[7]=Rv8;
          }
          Ra.sl[6]=5745; /* line # 5745 */
          P_insymbol();
        }
      }
      else {
        Ra.sl[6]=5749; /* line # 5749 */
        P_src_error(Rd.s+963,32,3);
      }
    }
  }
  else {
    Ra.sl[6]=5754; /* line # 5754 */
    Rv0=V_ide_udptr.v[7];
    Ra.sl[6]=5755; /* line # 5755 */
    P_src_error(Rd.s+963,107,3);
  }
  Ra.sl[6]=5757; /* line # 5757 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_ptr "  */
V PAS_COMILER_PRC_00000002(UB F_isfunction, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  UB Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+967;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5776; /* line # 5776 */
  Ra.sl[6]=5778; /* line # 5778 */
  Rv0=PAS__NEW(120);
  Ra.sl[6]=5779; /* line # 5779 */
  Rv1=Rv0;
  Ra.sl[6]=5781; /* line # 5781 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[6]=5782; /* line # 5782 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=5783; /* line # 5783 */
  ((UW *)Rv1)[8]=0;
  Ra.sl[6]=5784; /* line # 5784 */
  ((V *)Rv1)[3]=NULL;
  Ra.sl[6]=5785; /* line # 5785 */
  ((UB *)Rv1)[32]=29;
  Ra.sl[6]=5786; /* line # 5786 */
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=5787; /* line # 5787 */
  ((V *)Rv1)[6]=NULL;
  Ra.sl[6]=5788; /* line # 5788 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=5789; /* line # 5789 */
  ((V *)Rv1)[8]=NULL;
  Ra.sl[6]=5790; /* line # 5790 */
  ((SL *)Rv1)[18]=V_curr_lex;
  Ra.sl[6]=5791; /* line # 5791 */
  ((SL *)Rv1)[19]=0;
  Ra.sl[6]=5792; /* line # 5792 */
  ((SL *)Rv1)[20]=0;
  Ra.sl[6]=5793; /* line # 5793 */
  ((V *)Rv1)[11]=NULL;
  Ra.sl[6]=5794; /* line # 5794 */
  ((V *)Rv1)[12]=NULL;
  Ra.sl[6]=5795; /* line # 5795 */
  ((UB *)Rv1)[104]=4;
  Ra.sl[6]=5796; /* line # 5796 */
  ((V *)Rv1)[14]=NULL;
  Ra.sl[6]=5798; /* line # 5798 */
  Rv2=V_curr_lex;
  Ra.sl[6]=5799; /* line # 5799 */
  Rv3=V_curr_disp;
  Ra.sl[6]=5800; /* line # 5800 */
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=5801; /* line # 5801 */
    P_src_error(Rd.s+986,1002,3);
  }
  Ra.sl[6]=5802; /* line # 5802 */
  P_new_disp_level(Rv0,4);
  Ra.sl[6]=5803; /* line # 5803 */
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Ra.sl[6]=5804; /* line # 5804 */
  P_insymbol();
  Ra.sl[6]=5805; /* line # 5805 */
  Rv4=PAS_COMILER_PRC_00000003(&Rv0, F_isfunction,0);
  Ra.sl[6]=5806; /* line # 5806 */
  V_curr_lex=Rv2;
  V_curr_disp=Rv3;
  Ra.sl[6]=5808; /* line # 5808 */
  if (V_sy_sym.ub[0]==22) {
    Ra.sl[6]=5810; /* line # 5810 */
    P_insymbol();
    Ra.sl[6]=5811; /* line # 5811 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5814; /* line # 5814 */
      Rv5=P_ide_search(898);
      Ra.sl[6]=5815; /* line # 5815 */
      if (Rv5!=V_ide_udptr.v[1]) {
        Ra.sl[6]=5816; /* line # 5816 */
        Rv6=Rv5;
        Ra.sl[6]=5818; /* line # 5818 */
        Rv7=NULL;
        Ra.sl[6]=5819; /* line # 5819 */
        if (((UB *)Rv6)[53]==7) {
          Ra.sl[6]=5821; /* line # 5821 */
          Rv7=((V *)Rv6)[8];
          Ra.sl[6]=5822; /* line # 5822 */
          if (Rv7==Rv0) P_src_error(Rd.s+986,403,3);
        }
        else {
          Ra.sl[6]=5826; /* line # 5826 */
          if (((V *)Rv6)[11]!=((V *)Rv6)[10]&&((V *)Rv6)[11]!=NULL) {
            Ra.sl[6]=5827; /* line # 5827 */
            P_src_error_s(Rd.s+986,118,2, V_sy_ident.s,NULL);
          }
          else {
            Ra.sl[6]=5829; /* line # 5829 */
            Rv8=((V *)Rv6)[10];
            Ra.sl[6]=5830; /* line # 5830 */
            if (((UB *)Rv8)[8]) P_src_error(Rd.s+986,998,4);
            else {
              Ra.sl[6]=5831; /* line # 5831 */
              Rv7=((V *)Rv8)[2];
            }
          }
        }
        Ra.sl[6]=5834; /* line # 5834 */
        if (!P_comp_proc_arg(Rv7, Rv0)) P_src_error(Rd.s+986,119,3);
        else {
          Ra.sl[6]=5835; /* line # 5835 */
          ((V *)Rv5)[7]=Rv7;
        }
        Ra.sl[6]=5836; /* line # 5836 */
        P_insymbol();
      }
    }
    else {
      Ra.sl[6]=5839; /* line # 5839 */
      P_src_error(Rd.s+986,32,3);
    }
  }
  else {
    Ra.sl[6]=5841; /* line # 5841 */
    Rv7=NULL;
  }
  Ra.sl[6]=5843; /* line # 5843 */
  P_ide_new_typ(6, &Rv9);
  Ra.sl[6]=5844; /* line # 5844 */
  Rv10=Rv9;
  Ra.sl[6]=5846; /* line # 5846 */
  ((V *)Rv10)[3]=F_owid;
  Ra.sl[6]=5847; /* line # 5847 */
  ((V *)Rv10)[0]=NULL;
  Ra.sl[6]=5848; /* line # 5848 */
  memcpy(Rv10+48,V_typ_std.v[13]+48,1);
  Ra.sl[6]=5849; /* line # 5849 */
  ((SL *)Rv10)[11]=V_fptr_size;
  Ra.sl[6]=5850; /* line # 5850 */
  ((V *)Rv10)[12]=((V *)Rv0)[11];
  Ra.sl[6]=5851; /* line # 5851 */
  ((V *)Rv10)[13]=Rv0;
  Ra.sl[6]=5853; /* line # 5853 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insert_new_generic "  */
void PAS_COMILER_PRC_00000049(V *F_pgfirst, V *F_pglast, V F_pg, UB F_bwfent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+990;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5864; /* line # 5864 */
  if (F_pg!=NULL) {
    Ra.sl[6]=5866; /* line # 5866 */
    if (F_bwfent&&(*F_pgfirst)!=NULL) {
      Ra.sl[6]=5867; /* line # 5867 */
      P_src_error(Rd.s+1012,114,3);
    }
    Ra.sl[6]=5869; /* line # 5869 */
    if (V_sy_generic_qmod) {
      Ra.sl[6]=5871; /* line # 5871 */
      if ((*F_pgfirst)==NULL) (*F_pgfirst)=F_pg;
      else {
        Ra.sl[6]=5872; /* line # 5872 */
        ((V *)(*F_pglast))[0]=F_pg;
      }
      Ra.sl[6]=5873; /* line # 5873 */
      (*F_pglast)=F_pg;
    }
    else {
      Ra.sl[6]=5877; /* line # 5877 */
      ((V *)F_pg)[0]=(*F_pgfirst);
      Ra.sl[6]=5879; /* line # 5879 */
      (*F_pgfirst)=F_pg;
      Ra.sl[6]=5880; /* line # 5880 */
      if ((*F_pglast)==NULL) (*F_pglast)=F_pg;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_decl "  */
void PAS_COMILER_PRC_00000051(V F_pgf, V F_pgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  UB Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1016;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5943; /* line # 5943 */
  Lx[3].ub[0]=0;
  Ra.sl[6]=5944; /* line # 5944 */
  Lx[3].v[1]=NULL;
  Ra.sl[6]=5945; /* line # 5945 */
  Rv0=NULL;
  Ra.sl[6]=5946; /* line # 5946 */
  P_insymbol();
  Ra.sl[6]=5948; /* line # 5948 */
  if (V_sy_sym.ub[0]==13) Lx[3].ub[16]=0;
  Ra.sl[6]=5949; /* line # 5949 */
  if (!Lx[3].ub[16]) {
    Ra.sl[6]=5951; /* line # 5951 */
    Lx[3].v[3]=PAS__NEW(245);
    Ra.sl[6]=5952; /* line # 5952 */
    Rv1=Lx[3].v[3];
    Ra.sl[6]=5954; /* line # 5954 */
    ((V *)Rv1)[0]=NULL;
    Ra.sl[6]=5955; /* line # 5955 */
    ((V *)Rv1)[1]=NULL;
    Ra.sl[6]=5956; /* line # 5956 */
    ((UW *)Rv1)[8]=0;
    Ra.sl[6]=5957; /* line # 5957 */
    ((V *)Rv1)[3]=NULL;
    Ra.sl[6]=5958; /* line # 5958 */
    ((UB *)Rv1)[32]=29;
    Ra.sl[6]=5959; /* line # 5959 */
    ((V *)Rv1)[5]=NULL;
    Ra.sl[6]=5960; /* line # 5960 */
    ((V *)Rv1)[6]=NULL;
    Ra.sl[6]=5961; /* line # 5961 */
    ((V *)Rv1)[7]=NULL;
    Ra.sl[6]=5962; /* line # 5962 */
    ((V *)Rv1)[8]=NULL;
    Ra.sl[6]=5963; /* line # 5963 */
    ((SL *)Rv1)[18]=V_curr_lex;
    Ra.sl[6]=5964; /* line # 5964 */
    ((SL *)Rv1)[19]=0;
    Ra.sl[6]=5965; /* line # 5965 */
    ((SL *)Rv1)[20]=0;
    Ra.sl[6]=5966; /* line # 5966 */
    ((V *)Rv1)[11]=NULL;
    Ra.sl[6]=5967; /* line # 5967 */
    ((V *)Rv1)[12]=NULL;
    Ra.sl[6]=5968; /* line # 5968 */
    ((UB *)Rv1)[104]=10;
    Ra.sl[6]=5970; /* line # 5970 */
    ((V *)Rv1)[14]=Lx[5].v[13];
    Ra.sl[6]=5971; /* line # 5971 */
    ((V *)Rv1)[15]=NULL;
    Ra.sl[6]=5972; /* line # 5972 */
    ((V *)Rv1)[16]=NULL;
    Ra.sl[6]=5973; /* line # 5973 */
    ((V *)Rv1)[17]=NULL;
    Ra.sl[6]=5974; /* line # 5974 */
    ((V *)Rv1)[18]=NULL;
    Ra.sl[6]=5975; /* line # 5975 */
    ((V *)Rv1)[19]=NULL;
    Ra.sl[6]=5976; /* line # 5976 */
    ((V *)Rv1)[20]=NULL;
    Ra.sl[6]=5977; /* line # 5977 */
    ((V *)Rv1)[21]=NULL;
    Ra.sl[6]=5978; /* line # 5978 */
    ((V *)Rv1)[22]=NULL;
    Ra.sl[6]=5979; /* line # 5979 */
    ((V *)Rv1)[23]=NULL;
    Ra.sl[6]=5980; /* line # 5980 */
    ((V *)Rv1)[24]=NULL;
    Ra.sl[6]=5981; /* line # 5981 */
    ((V *)Rv1)[25]=NULL;
    Ra.sl[6]=5982; /* line # 5982 */
    ((V *)Rv1)[26]=NULL;
    Ra.sl[6]=5983; /* line # 5983 */
    ((V *)Rv1)[27]=NULL;
    Ra.sl[6]=5984; /* line # 5984 */
    ((SL *)Rv1)[56]=-1;
    Ra.sl[6]=5985; /* line # 5985 */
    ((SL *)Rv1)[57]=0;
    Ra.sl[6]=5986; /* line # 5986 */
    ((SL *)Rv1)[58]=0;
    Ra.sl[6]=5987; /* line # 5987 */
    ((SL *)Rv1)[59]=0;
    Ra.sl[6]=5988; /* line # 5988 */
    ((SL *)Rv1)[60]=0;
    Ra.sl[6]=5989; /* line # 5989 */
    ((UB *)Rv1)[244]=0;
  }
  else {
    Ra.sl[6]=5993; /* line # 5993 */
    Rv2=Lx[3].v[3];
    Ra.sl[6]=5995; /* line # 5995 */
    Rv0=((V *)Rv2)[8];
    Ra.sl[6]=5996; /* line # 5996 */
    if (((V *)Rv2)[11]!=NULL) {
      Ra.sl[6]=5997; /* line # 5997 */
      if (!((UB *)((V *)Rv2)[11])[92]) {
        Ra.sl[6]=5998; /* line # 5998 */
        Rv0=((V *)Rv0)[3];
      }
    }
  }
  Ra.sl[6]=6002; /* line # 6002 */
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=6003; /* line # 6003 */
    P_src_error(Rd.s+1029,1002,3);
  }
  Ra.sl[6]=6004; /* line # 6004 */
  P_new_disp_level(Lx[3].v[3],4);
  Ra.sl[6]=6005; /* line # 6005 */
  V_lex_ident_tree.v[V_curr_disp*8+1]=Rv0;
  Ra.sl[6]=6006; /* line # 6006 */
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Ra.sl[6]=6007; /* line # 6007 */
  Lx[3].sl[8]=V_curr_disp;
  Lx[3].sl[9]=V_curr_lex;
  Ra.sl[6]=6009; /* line # 6009 */
  Ra.sl[6]=6011; /* line # 6011 */
  if (!Lx[3].ub[16]) {
    Ra.sl[6]=6013; /* line # 6013 */
    Lx[3].ub[40]=PAS_COMILER_PRC_00000003(Lx[3].v+3,Lx[3].ub[41],Lx[3].ub[42]);
    Ra.sl[6]=6015; /* line # 6015 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6016; /* line # 6016 */
      P_src_error(Rd.s+1029,21,2);
    }
    Ra.sl[6]=6020; /* line # 6020 */
    if (Lx[3].sl[11]!=0) {
      Ra.sl[6]=6021; /* line # 6021 */
      if (Lx[3].sl[11]>0) {
        Ra.sl[6]=6022; /* line # 6022 */
        if (((SL *)Lx[3].v[3])[20]!=Lx[3].sl[11]) P_src_error_s(Rd.s+1029,127,2,
        Lx[3].s+48,NULL);
        else {
          Ra.sl[6]=6024; /* line # 6024 */
          if (((SL *)Lx[3].v[3])[20]!=1&&((SL *)Lx[3].v[3])[20]!=2) {
            Ra.sl[6]=6025; /* line # 6025 */
            P_src_error_s(Rd.s+1029,127,2, Lx[3].s+48,NULL);
          }
        }
      }
    }
    Ra.sl[6]=6028; /* line # 6028 */
    Lx[3].v[1]=P_compare_proc_argid(F_pgf, F_pgl, Lx[3].v[3]);
    Ra.sl[6]=6029; /* line # 6029 */
    Rv3=Lx[3].v[1]==NULL;
    Ra.sl[6]=6030; /* line # 6030 */
    if (!Rv3) {
      Ra.sl[6]=6032; /* line # 6032 */
      Rv4=Lx[3].v[3];
      Ra.sl[6]=6033; /* line # 6033 */
      Lx[3].v[3]=((V *)Lx[3].v[1])[2];
      Ra.sl[6]=6034; /* line # 6034 */
      Rv0=((V *)Lx[3].v[3])[8];
      Ra.sl[6]=6035; /* line # 6035 */
      Rv5=((V *)Rv4)[8];
      Ra.sl[6]=6036; /* line # 6036 */
      while (Rv0!=NULL&&Rv5!=NULL){
        Ra.sl[6]=6038; /* line # 6038 */
        PAS__DISPOSE(((V *)Rv0));
        Ra.sl[6]=6039; /* line # 6039 */
        ((V *)Rv0)[0]=((V *)Rv5)[0];
        Ra.sl[6]=6040; /* line # 6040 */
        Rv0=((V *)Rv0)[3];
        Rv5=((V *)Rv5)[3];
      }
      Ra.sl[6]=6042; /* line # 6042 */
      Rv6=(V_lex_ident_tree.s+V_curr_disp*64);
      Rv7=Lx[3].v[3];
      Ra.sl[6]=6044; /* line # 6044 */
      P_free_ide_list(((V *)Rv4)+8);
      Ra.sl[6]=6045; /* line # 6045 */
      P_free_typ_list(((V *)Rv4)+12);
      Ra.sl[6]=6046; /* line # 6046 */
      ((V *)Rv6)[0]=Lx[3].v[3];
      Ra.sl[6]=6047; /* line # 6047 */
      ((V *)Rv6)[1]=((V *)Rv7)[6];
      Ra.sl[6]=6050; /* line # 6050 */
      ((V *)Rv6)[4]=((V *)Rv7)[7];
      Ra.sl[6]=6051; /* line # 6051 */
      ((V *)Rv6)[5]=((V *)Rv7)[12];
      Ra.sl[6]=6056; /* line # 6056 */
      Lx[3].v[1]=NULL;
      Ra.sl[6]=6058; /* line # 6058 */
      switch (((UB *)Lx[3].v[3])[104]) {
        case 3:Ra.sl[6]=6060; /* line # 6060 */
        if (Lx[3].ub[80]!=9) P_src_error_s(Rd.s+1029,100,2, Lx[3].s+48,NULL);
        break;
        case 8:Ra.sl[6]=6062; /* line # 6062 */
        if (Lx[3].ub[80]!=10) P_src_error_s(Rd.s+1029,100,2, Lx[3].s+48,NULL);
        break;
        default:Ra.sl[6]=6064; /* line # 6064 */
        P_src_error_s(Rd.s+1029,102,2, Lx[3].s+48,NULL);
        Ra.sl[6]=6065; /* line # 6065 */
        Lx[3].ub[80]=9;
        break;
      }
      Ra.sl[6]=6067; /* line # 6067 */
      PAS__DISPOSE(&Rv4);
      Ra.sl[6]=6068; /* line # 6068 */
      ((UB *)Lx[3].v[3])[104]=10;
    }
    else {
      Ra.sl[6]=6072; /* line # 6072 */
      Lx[3].v[1]=PAS__NEW(32);
      Ra.sl[6]=6073; /* line # 6073 */
      Rv8=Lx[3].v[1];
      Ra.sl[6]=6075; /* line # 6075 */
      ((V *)Rv8)[0]=NULL;
      Ra.sl[6]=6076; /* line # 6076 */
      ((UB *)Rv8)[8]=0;
      Ra.sl[6]=6077; /* line # 6077 */
      ((V *)Rv8)[2]=Lx[3].v[3];
      Ra.sl[6]=6080; /* line # 6080 */
      if (V_pro_d_first==NULL) V_pro_d_first=Lx[3].v[3];
      else {
        Ra.sl[6]=6081; /* line # 6081 */
        ((V *)V_pro_d_last)[1]=Lx[3].v[3];
      }
      Ra.sl[6]=6082; /* line # 6082 */
      V_pro_d_last=Lx[3].v[3];
    }
  }
  else {
    Ra.sl[6]=6086; /* line # 6086 */
    Rv9=Lx[3].v[3];
    Ra.sl[6]=6088; /* line # 6088 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6089; /* line # 6089 */
      P_src_error(Rd.s+1029,21,2);
    }
    Ra.sl[6]=6090; /* line # 6090 */
    if (((UB *)Rv9)[104]==3) Lx[3].ub[80]=9;
    Ra.sl[6]=6091; /* line # 6091 */
    ((UB *)Rv9)[104]=10;
  }
  Ra.sl[6]=6095; /* line # 6095 */
  Rv10=Lx[3].v[3];
  Ra.sl[6]=6097; /* line # 6097 */
  if (V_sy_sym.ub[0]==79) {
    Ra.sl[6]=6099; /* line # 6099 */
    if (Lx[3].ub[16]||((UB *)Rv10)[104]!=10) P_src_error_s(Rd.s+1029,128,2, Lx[3]
    .s+48,NULL);
    else {
      Ra.sl[6]=6100; /* line # 6100 */
      ((UB *)Rv10)[104]=8;
    }
    Ra.sl[6]=6101; /* line # 6101 */
    P_insymbol();
    Ra.sl[6]=6102; /* line # 6102 */
    if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
    else {
      Ra.sl[6]=6104; /* line # 6104 */
      if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
        Ra.sl[6]=6106; /* line # 6106 */
        ((UB *)Rv10)[32]=Lx[3].ub[82];
        Ra.sl[6]=6107; /* line # 6107 */
        ((V *)Rv10)[3]=PAS__NEW(32);
        Ra.sl[6]=6108; /* line # 6108 */
        if (((UB *)Rv10)[32]==29) {
          Ra.sl[6]=6109; /* line # 6109 */
          memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
        }
        else {
          Ra.sl[6]=6111; /* line # 6111 */
          memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
      }
      else {
        Ra.sl[6]=6114; /* line # 6114 */
        ((V *)Rv10)[3]=P_new_int_name(Rd.s+1035,&V_proc_seq);
      }
    }
    Ra.sl[6]=6116; /* line # 6116 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6117; /* line # 6117 */
      P_src_error(Rd.s+1029,21,2);
    }
  }
  else {
    Ra.sl[6]=6120; /* line # 6120 */
    if (V_sy_sym.ub[0]==83||V_sy_sym.ub[0]==85&&V_sy_init_mod) {
      Ra.sl[6]=6122; /* line # 6122 */
      if (((UB *)Rv10)[104]!=10) {
        Ra.sl[6]=6124; /* line # 6124 */
        P_src_error_s(Rd.s+1029,108,2, Lx[3].s+48,NULL);
      }
      Ra.sl[6]=6125; /* line # 6125 */
      if (V_sy_sym.ub[0]==83) {
        Ra.sl[6]=6127; /* line # 6127 */
        ((UB *)Rv10)[104]=3;
        Ra.sl[6]=6128; /* line # 6128 */
        ((SL *)Rv10)[18]=1;
      }
      else {
        Ra.sl[6]=6133; /* line # 6133 */
        ((UB *)Rv10)[104]=1;
        Ra.sl[6]=6134; /* line # 6134 */
        ((SL *)Rv10)[18]=0;
      }
      Ra.sl[6]=6136; /* line # 6136 */
      P_insymbol();
      Ra.sl[6]=6138; /* line # 6138 */
      if (V_sy_sym.ub[0]==5) {
        Ra.sl[6]=6140; /* line # 6140 */
        P_set_stdname(Lx[3].v[3]);
      }
      else {
        Ra.sl[6]=6142; /* line # 6142 */
        if (Lx[3].ub[80]==((UB *)Rv10)[104]&&Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6143; /* line # 6143 */
          ((V *)Rv10)[3]=Lx[3].v[11];
        }
        else {
          Ra.sl[6]=6146; /* line # 6146 */
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6147; /* line # 6147 */
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6148; /* line # 6148 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else {
            Ra.sl[6]=6150; /* line # 6150 */
            P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
          }
        }
      }
      Ra.sl[6]=6153; /* line # 6153 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=6154; /* line # 6154 */
        P_src_error(Rd.s+1029,21,2);
      }
    }
    else {
      Ra.sl[6]=6158; /* line # 6158 */
      Lx[3].ub[0]=1;
      Ra.sl[6]=6160; /* line # 6160 */
      if (Lx[3].ub[80]!=10) {
        Ra.sl[6]=6162; /* line # 6162 */
        ((UB *)Rv10)[104]=Lx[3].ub[80];
        Ra.sl[6]=6163; /* line # 6163 */
        ((SL *)Rv10)[18]=1;
        Ra.sl[6]=6164; /* line # 6164 */
        if (Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6165; /* line # 6165 */
          if (Rv3) ((V *)Rv10)[3]=Lx[3].v[11];
          else {
            Ra.sl[6]=6168; /* line # 6168 */
            if (((V *)Rv10)[3]!=NULL) {
              Ra.sl[6]=6169; /* line # 6169 */
              if (P_match(((V *)Rv10)[3],Lx[3].v[11])!=0) {
                Ra.sl[6]=6170; /* line # 6170 */
                P_src_error(Rd.s+1029,129,1);
              }
            }
          }
        }
        else {
          Ra.sl[6]=6175; /* line # 6175 */
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6176; /* line # 6176 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else {
            Ra.sl[6]=6178; /* line # 6178 */
            P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
          }
        }
        Ra.sl[6]=6181; /* line # 6181 */
        switch (Lx[3].ub[80]) {
          case 3:Ra.sl[6]=6182; /* line # 6182 */
          Lx[3].ub[0]=0;
          break;
          case 9:Ra.sl[6]=6184; /* line # 6184 */
          if (Lx[3].sl[24]>1) {
            Ra.sl[6]=6185; /* line # 6185 */
            P_src_error(Rd.s+1029,404,2);
          }
          break;
          default:break;
        }
      }
      Ra.sl[6]=6190; /* line # 6190 */
      Rv11=0;
      Ra.sl[6]=6191; /* line # 6191 */
      Rv12=0;
      while (1){
        Ra.sl[6]=6193; /* line # 6193 */
        switch (V_sy_sym.ub[0]) {
          case 86:Ra.sl[6]=6196; /* line # 6196 */
          P_insymbol();
          ((UW *)Rv10)[8]=1;
          Ra.sl[6]=6197; /* line # 6197 */
          Rv12=1;
          break;
          case 5:
          case 84:Ra.sl[6]=6203; /* line # 6203 */
          if (V_sy_sym.ub[0]==84) {
            Ra.sl[6]=6204; /* line # 6204 */
            ((UB *)Rv10)[104]=9;
            P_insymbol();
          }
          Ra.sl[6]=6205; /* line # 6205 */
          if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
          else {
            Ra.sl[6]=6206; /* line # 6206 */
            P_src_error(Rd.s+1029,58,2);
          }
          Ra.sl[6]=6207; /* line # 6207 */
          Rv12=1;
          break;
          default:Ra.sl[6]=6211; /* line # 6211 */
          Rv11=1;
          Ra.sl[6]=6212; /* line # 6212 */
          if (Rv12) {
            Ra.sl[6]=6213; /* line # 6213 */
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else {
              Ra.sl[6]=6214; /* line # 6214 */
              P_src_error(Rd.s+1029,21,2);
            }
          }
          break;
        }
        if (Rv11)  break;
      }
      Ra.sl[6]=6218; /* line # 6218 */
      if (((V *)Rv10)[3]==NULL) {
        Ra.sl[6]=6220; /* line # 6220 */
        if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
          Ra.sl[6]=6222; /* line # 6222 */
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6223; /* line # 6223 */
          ((V *)Rv10)[3]=PAS__NEW(32);
          Ra.sl[6]=6224; /* line # 6224 */
          if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
          else {
            Ra.sl[6]=6225; /* line # 6225 */
            memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
          }
        }
        else {
          Ra.sl[6]=6228; /* line # 6228 */
          ((V *)Rv10)[3]=P_new_int_name(Rd.s+1041,&V_proc_seq);
        }
      }
    }
  }
  Ra.sl[6]=6231; /* line # 6231 */
  V_curr_lex=Lx[3].sl[24];
  Ra.sl[6]=6232; /* line # 6232 */
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6233; /* line # 6233 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_body "  */
void PAS_COMILER_PRC_00000052(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1045;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6247; /* line # 6247 */
  V_curr_disp=Lx[3].sl[8];
  Ra.sl[6]=6248; /* line # 6248 */
  V_curr_lex=Lx[3].sl[9];
  Ra.sl[6]=6249; /* line # 6249 */
  Rv0=Lx[3].v[3];
  Ra.sl[6]=6251; /* line # 6251 */
  if (V_cmp_traceopt>0) {
    Ra.sl[6]=6253; /* line # 6253 */
    if (V_cmp_trace>=0) Rv1=3;
    else {
      Ra.sl[6]=6255; /* line # 6255 */
      Rv1=5;
    }
    Ra.sl[6]=6256; /* line # 6256 */
    V_cmp_trace=V_cmp_traceopt;
    Ra.sl[6]=6257; /* line # 6257 */
    P_gen_cntxvar(Lx[3].v[3],Lx[3].v[14]);
  }
  else {
    Ra.sl[6]=6260; /* line # 6260 */
    if (V_cmp_trace>0) V_cmp_trace=0;
  }
  Ra.sl[6]=6262; /* line # 6262 */
  P_lgt_all_fparm(Lx[3].v[3]);
  Ra.sl[6]=6264; /* line # 6264 */
  P_cmp_block(Lx[3].v[3],1, Rv1);
  Ra.sl[6]=6266; /* line # 6266 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else {
    Ra.sl[6]=6267; /* line # 6267 */
    P_src_error(Rd.s+1058,54,3);
  }
  Ra.sl[6]=6269; /* line # 6269 */
  if (V_sy_sym.ub[0]==0&&Lx[3].ub[82]==29) {
    Ra.sl[6]=6270; /* line # 6270 */
    Ra.sl[6]=6271; /* line # 6271 */
    if (V_sy_sym.ub[0]==0&&P_match(Lx[3].s+48,V_sy_ident.s)==0) {
      Ra.sl[6]=6272; /* line # 6272 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=6273; /* line # 6273 */
      P_src_error_s(Rd.s+1058,71,2, V_sy_ident.s,NULL);
    }
  }
  else {
    Ra.sl[6]=6275; /* line # 6275 */
    if (V_sy_sym.ub[0]!=18) {
      Ra.sl[6]=6276; /* line # 6276 */
      if (V_sy_sym.ub[0]==22&&Lx[3].ub[82]==28||V_sy_sym.ub[1]==Lx[3].ub[82]) P_insymbol();
      else {
        Ra.sl[6]=6277; /* line # 6277 */
        P_src_error(Rd.s+1058,72,2);
      }
    }
  }
  Ra.sl[6]=6279; /* line # 6279 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1058,21,2);
  else {
    Ra.sl[6]=6280; /* line # 6280 */
    P_insymbol();
  }
  Ra.sl[6]=6283; /* line # 6283 */
  if (V_cmp_objf&&V_error_result<=1) {
    Ra.sl[6]=6286; /* line # 6286 */
    if (V_cmp_trace>0&&((V *)Rv0)[16]!=NULL) {
      Ra.sl[6]=6287; /* line # 6287 */
      P_gen_linetrace(Lx[3].v[3],((V *)Rv0)+16,((V *)Rv0)+17,4);
    }
    Ra.sl[6]=6289; /* line # 6289 */
    if (((V *)Rv0)[16]!=((V *)Rv0)[17]) {
      Ra.sl[6]=6291; /* line # 6291 */
      P_lgt_new(((V *)Rv0)+16,NULL,0,((V *)Rv0)[16]);
      Ra.sl[6]=6292; /* line # 6292 */
      ((UB *)((V *)Rv0)[16])[41]=2;
      Ra.sl[6]=6293; /* line # 6293 */
      ((V *)Rv0)[17]=((V *)Rv0)[16];
    }
    Ra.sl[6]=6296; /* line # 6296 */
    if (((UB *)Rv0)[104]==11) {
      Ra.sl[6]=6297; /* line # 6297 */
      ((UW *)Rv0)[8]=((UW *)Rv0)[8]|129;
    }
    else {
      Ra.sl[6]=6299; /* line # 6299 */
      ((UW *)Rv0)[8]=((UW *)Rv0)[8]|128;
    }
    Ra.sl[6]=6302; /* line # 6302 */
    if (V_pro_last==NULL) V_pro_first=Lx[3].v[3];
    else {
      Ra.sl[6]=6303; /* line # 6303 */
      ((V *)V_pro_last)[0]=Lx[3].v[3];
    }
    Ra.sl[6]=6304; /* line # 6304 */
    V_pro_last=Lx[3].v[3];
    Ra.sl[6]=6307; /* line # 6307 */
    PAS_COMILER_cmp_pass2(Lx[3].v[3]);
  }
  Ra.sl[6]=6312; /* line # 6312 */
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6313; /* line # 6313 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gene_decl "  */
void PAS_COMILER_PRC_00000050(){
  /* Define the automatic variable space. */
  Blk( Ra, 184 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  UB Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  UB Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+1062;
  Ra.v[17]=Rd.s+17;
  Ra.sl[36]=6320; /* line # 6320 */
  Ra.ub[16]=0;
  Ra.sl[36]=6321; /* line # 6321 */
  Ra.ub[42]=1;
  Ra.sl[36]=6322; /* line # 6322 */
  Ra.ub[40]=0;
  Ra.sl[36]=6323; /* line # 6323 */
  Ra.v[3]=NULL;
  Ra.sl[36]=6324; /* line # 6324 */
  Ra.ub[82]=29;
  Ra.sl[36]=6325; /* line # 6325 */
  Ra.ub[81]=0;
  Ra.sl[36]=6326; /* line # 6326 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[36]=6327; /* line # 6327 */
  Ra.sl[11]=0;
  Ra.sl[36]=6329; /* line # 6329 */
  Ra.v[13]=Lx[5].v[1];
  Ra.sl[36]=6330; /* line # 6330 */
  Ra.sl[24]=V_curr_lex;
  Ra.sl[36]=6331; /* line # 6331 */
  Ra.sl[25]=V_curr_disp;
  Ra.sl[36]=6333; /* line # 6333 */
  Ra.sl[36]=6335; /* line # 6335 */
  Ra.ub[80]=10;
  Ra.sl[36]=6336; /* line # 6336 */
  Ra.v[11]=NULL;
  Ra.sl[36]=6337; /* line # 6337 */
  if (Lx[5].ub[16]!=1) {
    Ra.sl[36]=6339; /* line # 6339 */
    switch (Lx[5].ub[16]) {
      case 4:
      case 5:Ra.sl[36]=6342; /* line # 6342 */
      if (Lx[5].ub[16]==4) Ra.ub[80]=9;
      else {
        Ra.sl[36]=6343; /* line # 6343 */
        Ra.ub[80]=3;
      }
      Ra.sl[36]=6344; /* line # 6344 */
      if (Lx[5].v[3]!=NULL) {
        Ra.sl[36]=6345; /* line # 6345 */
        Ra.v[11]=Lx[5].v[3];
        Lx[5].v[3]=NULL;
      }
      break;
      default:Ra.sl[36]=6348; /* line # 6348 */
      P_src_error(Rd.s+1058,81,2);
      break;
    }
    Ra.sl[36]=6350; /* line # 6350 */
    Lx[5].ub[16]=1;
    Ra.sl[36]=6351; /* line # 6351 */
    Lx[5].v[3]=NULL;
  }
  Ra.sl[36]=6354; /* line # 6354 */
  Ra.ub[41]=V_sy_sym.ub[0]==77;
  Ra.sl[36]=6355; /* line # 6355 */
  P_insymbol();
  Ra.sl[36]=6356; /* line # 6356 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[36]=6359; /* line # 6359 */
    memcpy(Ra.s+48,V_sy_ident.s,32);
    Ra.sl[36]=6360; /* line # 6360 */
    V_err_prt=0;
    Ra.sl[36]=6361; /* line # 6361 */
    Rv1=P_ide_search(770);
    Ra.sl[36]=6362; /* line # 6362 */
    V_err_prt=1;
    Ra.sl[36]=6363; /* line # 6363 */
    if (Rv1!=NULL) {
      Ra.sl[36]=6364; /* line # 6364 */
      if (((SL *)Rv1)[12]!=V_curr_lex) Rv0=NULL;
      else {
        Ra.sl[36]=6365; /* line # 6365 */
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[36]=6366; /* line # 6366 */
      Rv0=NULL;
    }
    Ra.sl[36]=6368; /* line # 6368 */
    if (Rv0!=NULL) {
      Ra.sl[36]=6369; /* line # 6369 */
      Rv2=Rv0;
      Ra.sl[36]=6371; /* line # 6371 */
      Ra.v[14]=((V *)Rv2)[0];
      Ra.sl[36]=6372; /* line # 6372 */
      switch (((UB *)Rv2)[53]) {
        case 1:
        case 8:
        case 9:Ra.sl[36]=6374; /* line # 6374 */
        if (((V *)Rv2)[8]!=NULL) {
          Ra.sl[36]=6376; /* line # 6376 */
          Ra.ub[16]=1;
          Ra.sl[36]=6377; /* line # 6377 */
          Ra.v[3]=((V *)Rv2)[8];
          Ra.sl[36]=6378; /* line # 6378 */
          Rv3=Ra.v[3];
          Ra.sl[36]=6379; /* line # 6379 */
          if (((UB *)Rv3)[104]==8||((UB *)Rv3)[104]==3) {
            Ra.sl[36]=6380; /* line # 6380 */
            Ra.ub[42]=0;
          }
        }
        break;
        default:Ra.sl[36]=6385; /* line # 6385 */
        P_src_error_s(Rd.s+1058,101,3,((V *)Rv2)[0],NULL);
        break;
      }
      Ra.sl[36]=6388; /* line # 6388 */
      PAS_COMILER_PRC_00000051(((V *)Rv2)[10],((V *)Rv2)[11]);
      Ra.sl[36]=6390; /* line # 6390 */
      PAS_COMILER_PRC_00000049(((V *)Rv2)+10,((V *)Rv2)+11,Ra.v[1],((UB *)Rv2)[53]
      ==8);
    }
    else {
      Ra.sl[36]=6414; /* line # 6414 */
      Ra.ub[42]=0;
      Ra.sl[36]=6415; /* line # 6415 */
      Ra.v[14]=PAS__NEW(32);
      Ra.sl[36]=6416; /* line # 6416 */
      Ra.sl[36]=6418; /* line # 6418 */
      ((UB *)Ra.v[14])[0]=V_sy_ident.ub[0];
      Ra.sl[36]=6419; /* line # 6419 */
      Rv4=1;
      for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
        ((C *)Ra.v[14])[Rv4]=V_sy_ident.c[Rv4];
        Rv4++;
      }
      Ra.sl[36]=6422; /* line # 6422 */
      Ra.ub[81]=Rv1==NULL;
      Ra.sl[36]=6423; /* line # 6423 */
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6424; /* line # 6424 */
      memcpy(Ra.s+148,V_sy_ident.s,32);
      Ra.sl[36]=6425; /* line # 6425 */
      memcpy(V_sy_ident.s,Ra.s+48,32);
      Ra.sl[36]=6426; /* line # 6426 */
      if (Ra.ub[40]) {
        Ra.sl[36]=6428; /* line # 6428 */
        P_ide_new(8,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6429; /* line # 6429 */
        Rv5=Rv0;
        Ra.sl[36]=6431; /* line # 6431 */
        ((V *)Rv5)[10]=Ra.v[1];
        Ra.sl[36]=6432; /* line # 6432 */
        ((V *)Rv5)[11]=NULL;
        Ra.sl[36]=6434; /* line # 6434 */
        if (((UB *)Ra.v[3])[104]==8||((UB *)Ra.v[3])[104]==3) {
          Ra.sl[36]=6435; /* line # 6435 */
          ((V *)Rv5)[8]=Ra.v[3];
        }
        else {
          Ra.sl[36]=6436; /* line # 6436 */
          ((V *)Rv5)[8]=NULL;
        }
      }
      else {
        Ra.sl[36]=6442; /* line # 6442 */
        if (Rv1!=NULL) {
          Ra.sl[36]=6444; /* line # 6444 */
          Rv6=((UB *)Rv1)[53];
          Ra.sl[36]=6445; /* line # 6445 */
          ((V *)Ra.v[1])[0]=((V *)Rv1)[10];
        }
        else {
          Ra.sl[36]=6449; /* line # 6449 */
          Rv6=9;
          Ra.sl[36]=6450; /* line # 6450 */
          ((V *)Ra.v[1])[0]=NULL;
        }
        Ra.sl[36]=6453; /* line # 6453 */
        P_ide_new(Rv6,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6457; /* line # 6457 */
        Rv7=Rv0;
        Ra.sl[36]=6459; /* line # 6459 */
        ((V *)Rv7)[10]=Ra.v[1];
        ((V *)Rv7)[11]=Ra.v[1];
        Ra.sl[36]=6461; /* line # 6461 */
        if (((UB *)Ra.v[3])[104]==8) ((V *)Rv7)[8]=Ra.v[3];
        else {
          Ra.sl[36]=6462; /* line # 6462 */
          ((V *)Rv7)[8]=NULL;
        }
      }
      Ra.sl[36]=6466; /* line # 6466 */
      memcpy(V_sy_ident.s,Ra.s+148,32);
    }
    Ra.sl[36]=6469; /* line # 6469 */
    if (V_sy_init_mod) {
      Ra.sl[36]=6471; /* line # 6471 */
      Rv8=1;
      Ra.sl[36]=6472; /* line # 6472 */
      switch (V_sy_sym.ub[0]) {
        case 58:Ra.sl[36]=6473; /* line # 6473 */
        V_new_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 59:Ra.sl[36]=6474; /* line # 6474 */
        V_newh_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 60:Ra.sl[36]=6475; /* line # 6475 */
        V_dispose_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 42:Ra.sl[36]=6476; /* line # 6476 */
        V_set_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 61:Ra.sl[36]=6478; /* line # 6478 */
        V_iof_std_open=Rv0;
        break;
        case 39:Ra.sl[36]=6479; /* line # 6479 */
        V_iof_std_close=Rv0;
        break;
        case 62:Ra.sl[36]=6480; /* line # 6480 */
        V_inp_std_sel=Rv0;
        break;
        case 65:Ra.sl[36]=6481; /* line # 6481 */
        V_inp_std_gene=Rv0;
        break;
        case 66:Ra.sl[36]=6482; /* line # 6482 */
        V_inp_std_eoln=Rv0;
        break;
        case 35:Ra.sl[36]=6483; /* line # 6483 */
        V_inp_std_bin=Rv0;
        break;
        case 63:Ra.sl[36]=6484; /* line # 6484 */
        V_out_std_sel=Rv0;
        break;
        case 68:Ra.sl[36]=6485; /* line # 6485 */
        V_out_std_gene=Rv0;
        break;
        case 69:Ra.sl[36]=6486; /* line # 6486 */
        V_out_std_eoln=Rv0;
        break;
        case 36:Ra.sl[36]=6487; /* line # 6487 */
        V_out_std_bin=Rv0;
        break;
        case 41:Ra.sl[36]=6489; /* line # 6489 */
        V_gen_std_string1=Rv0;
        break;
        case 40:Ra.sl[36]=6490; /* line # 6490 */
        V_gen_std_cnfardsc=Rv0;
        break;
        default:Ra.sl[36]=6493; /* line # 6493 */
        Rv8=0;
        break;
      }
      Ra.sl[36]=6495; /* line # 6495 */
      if (Rv8) {
        Ra.sl[36]=6497; /* line # 6497 */
        P_insymbol();
        Ra.sl[36]=6498; /* line # 6498 */
        if (V_sy_sym.ub[0]==18) P_insymbol();
        else {
          Ra.sl[36]=6499; /* line # 6499 */
          P_src_error(Rd.s+1058,21,2);
        }
      }
    }
    Ra.sl[36]=6503; /* line # 6503 */
    if (Ra.v[3]!=NULL) ((V *)Ra.v[3])[5]=Rv0;
    break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 22:Ra.sl[36]=6515; /* line # 6515 */
    if (V_sy_sym.ub[0]==6) Ra.sl[11]=1;
    else {
      Ra.sl[36]=6516; /* line # 6516 */
      Ra.sl[11]=2;
    }
    Ra.sl[36]=6517; /* line # 6517 */
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[36]=6519; /* line # 6519 */
      if (Ra.ub[41]) P_src_error(Rd.s+1058,115,3);
      Ra.sl[36]=6520; /* line # 6520 */
      Ra.ub[82]=28;
    }
    else {
      Ra.sl[36]=6523; /* line # 6523 */
      Ra.ub[82]=V_sy_sym.ub[1];
      Ra.sl[36]=6524; /* line # 6524 */
      if (!Ra.ub[41]) P_src_error(Rd.s+1058,116,3);
    }
    Ra.sl[36]=6526; /* line # 6526 */
    if (Ra.ub[82]==12) Ra.sl[11]=-1;
    Ra.sl[36]=6528; /* line # 6528 */
    memcpy(Ra.s+48,(V_opname.s+Ra.ub[82]*32),32);
    Ra.sl[36]=6530; /* line # 6530 */
    Ra.v[14]=PAS__NEW(32);
    Ra.sl[36]=6531; /* line # 6531 */
    Rv9=(V_opname.s+Ra.ub[82]*32);
    Ra.sl[36]=6533; /* line # 6533 */
    ((UB *)Ra.v[14])[0]=((UB *)Rv9)[0]+2;
    Ra.sl[36]=6534; /* line # 6534 */
    ((C *)Ra.v[14])[1]=79;
    Ra.sl[36]=6535; /* line # 6535 */
    ((C *)Ra.v[14])[2]=95;
    Ra.sl[36]=6536; /* line # 6536 */
    Rv10=1;
    for( Rf0=((UB *)Rv9)[0];Rf0>0;Rf0-- ) {
      ((C *)Ra.v[14])[(2+Rv10)]=((C *)Rv9)[Rv10];
      Rv10++;
    }
    Ra.sl[36]=6539; /* line # 6539 */
    Rv11=V_ope_table.v[Ra.ub[82]];
    Ra.sl[36]=6540; /* line # 6540 */
    if (Rv11!=NULL) Rv12=((SL *)Rv11)[1]==V_curr_lex;
    else {
      Ra.sl[36]=6541; /* line # 6541 */
      Rv12=0;
    }
    Ra.sl[36]=6542; /* line # 6542 */
    if (Rv12) {
      Ra.sl[36]=6543; /* line # 6543 */
      Rv13=Rv11;
      Ra.sl[36]=6545; /* line # 6545 */
      Ra.v[3]=NULL;
      Ra.sl[36]=6546; /* line # 6546 */
      PAS_COMILER_PRC_00000051(((V *)Rv13)[3],((V *)Rv13)[4]);
      Ra.sl[36]=6547; /* line # 6547 */
      PAS_COMILER_PRC_00000049(((V *)Rv13)+3,((V *)Rv13)+4,Ra.v[1],0);
    }
    else {
      Ra.sl[36]=6559; /* line # 6559 */
      Ra.v[3]=NULL;
      Ra.sl[36]=6560; /* line # 6560 */
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6561; /* line # 6561 */
      if (Ra.v[1]!=NULL) {
        Ra.sl[36]=6563; /* line # 6563 */
        Rv14=PAS__NEW(40);
        Ra.sl[36]=6564; /* line # 6564 */
        Rv15=Rv14;
        Ra.sl[36]=6566; /* line # 6566 */
        ((UB *)Rv15)[0]=Ra.ub[82];
        Ra.sl[36]=6567; /* line # 6567 */
        ((SL *)Rv15)[1]=V_curr_lex;
        Ra.sl[36]=6568; /* line # 6568 */
        ((V *)Rv15)[1]=((V *)Lx[5].v[13])[19];
        Ra.sl[36]=6569; /* line # 6569 */
        ((V *)Rv15)[2]=Rv11;
        Ra.sl[36]=6570; /* line # 6570 */
        ((V *)Rv15)[3]=Ra.v[1];
        Ra.sl[36]=6571; /* line # 6571 */
        ((V *)Rv15)[4]=Ra.v[1];
        Ra.sl[36]=6572; /* line # 6572 */
        if (Rv11==NULL) {
          Ra.sl[36]=6573; /* line # 6573 */
          ((V *)Ra.v[1])[0]=NULL;
        }
        else {
          Ra.sl[36]=6575; /* line # 6575 */
          ((V *)Ra.v[1])[0]=((V *)Rv11)[3];
        }
      }
      Ra.sl[36]=6578; /* line # 6578 */
      ((V *)Lx[5].v[13])[19]=Rv14;
      Ra.sl[36]=6579; /* line # 6579 */
      V_ope_table.v[Ra.ub[82]]=Rv14;
    }
    Ra.sl[36]=6582; /* line # 6582 */
    if (Ra.v[3]!=NULL) ((UB *)Ra.v[3])[32]=Ra.ub[82];
    break;
    default:Ra.sl[36]=6592; /* line # 6592 */
    P_src_error(Rd.s+1058,117,3);
    break;
  }
  Ra.sl[36]=6595; /* line # 6595 */
  if (Ra.ub[0]) PAS_COMILER_PRC_00000052();
  PAS__curr_cntx=Ra.v[15];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " gen_assign "  */
V PAS_COMILER_PRC_00000053(V F_target, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1073;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6622; /* line # 6622 */
  Rv0=V_sy_label_flag;
  Ra.sl[6]=6623; /* line # 6623 */
  V_sy_label_flag=0;
  Ra.sl[6]=6626; /* line # 6626 */
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6628; /* line # 6628 */
  V_sy_label_flag=Rv0;
  Ra.sl[6]=6630; /* line # 6630 */
  ((V *)F_target)[0]=Rv1;
  Ra.sl[6]=6631; /* line # 6631 */
  if (((UB *)F_target)[40]==8) {
    Ra.sl[6]=6632; /* line # 6632 */
    Rv2=((V *)F_target)[6];
    Ra.sl[6]=6634; /* line # 6634 */
    Rv3=1;
    Ra.sl[6]=6635; /* line # 6635 */
    if (((V *)Rv2)[11]!=NULL) {
      Ra.sl[6]=6636; /* line # 6636 */
      if (((UB *)((V *)Rv2)[11])[93]==24) Rv3=0;
    }
    Ra.sl[6]=6637; /* line # 6637 */
    if (Rv3) P_src_error(Rd.s+1087,175,3);
  }
  Ra.sl[6]=6639; /* line # 6639 */
  Rv4=P_lgt_gen_store(F_target,0, F_bovr);
  Ra.sl[6]=6640; /* line # 6640 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " return_state "  */
V PAS_COMILER_PRC_00000054(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1091;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6662; /* line # 6662 */
  Rv0=NULL;
  Ra.sl[6]=6663; /* line # 6663 */
  Rv1=PAS_COMILER_PRC_00000023();
  Ra.sl[6]=6665; /* line # 6665 */
  if (Rv1!=NULL) {
    Ra.sl[6]=6666; /* line # 6666 */
    Rv2=Rv1;
    Ra.sl[6]=6668; /* line # 6668 */
    if (((V *)Rv2)[11]==NULL) {
      Ra.sl[6]=6670; /* line # 6670 */
      if (F_ip!=NULL) {
        Ra.sl[6]=6673; /* line # 6673 */
        P_src_error_s(Rd.s+1107,172,3,((V *)F_ip)[0],NULL);
        Ra.sl[6]=6674; /* line # 6674 */
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[6]=6678; /* line # 6678 */
        P_lgt_new(&Rv0,NULL,0,NULL);
        Ra.sl[6]=6679; /* line # 6679 */
        ((UB *)Rv0)[41]=7;
      }
    }
    else {
      Ra.sl[6]=6684; /* line # 6684 */
      if (V_sy_sym.ub[0]==77) {
        Ra.sl[6]=6686; /* line # 6686 */
        P_insymbol();
        Rv3=1;
      }
      else {
        Ra.sl[6]=6690; /* line # 6690 */
        Rv3=F_ip!=NULL;
        Ra.sl[6]=6691; /* line # 6691 */
        if (Rv3&&F_ip!=((V *)Rv2)[5]) {
          Ra.sl[6]=6693; /* line # 6693 */
          P_src_error_s(Rd.s+1107,405,3,((V *)F_ip)[0],NULL);
          Ra.sl[6]=6694; /* line # 6694 */
          P_skip_symbol(18,0,0);
        }
      }
      Ra.sl[6]=6699; /* line # 6699 */
      Rv4=NULL;
      Ra.sl[6]=6700; /* line # 6700 */
      Lx[5].ub[40]=1;
      Ra.sl[6]=6702; /* line # 6702 */
      if (((UB *)((V *)Rv2)[11])[92]) {
        Ra.sl[6]=6704; /* line # 6704 */
        P_lgt_new(&Rv4,((V *)Rv2)[11],12,NULL);
        Ra.sl[6]=6705; /* line # 6705 */
        ((V *)Rv4)[6]=Rv1;
        Ra.sl[6]=6706; /* line # 6706 */
        if (F_ip!=NULL) {
          Ra.sl[6]=6707; /* line # 6707 */
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6708; /* line # 6708 */
            P_src_error(Rd.s+1107,32,2);
          }
        }
      }
      else {
        Ra.sl[6]=6712; /* line # 6712 */
        if (!Rv3||V_sy_sym.ub[0]==22) {
          Ra.sl[6]=6714; /* line # 6714 */
          Rv4=P_lgt_new_idref(((V *)Rv2)[8],NULL);
          Ra.sl[6]=6715; /* line # 6715 */
          Rv5=((V *)Rv2)[8];
          Ra.sl[6]=6716; /* line # 6716 */
          if ((((UB *)((V *)Rv5)[5])[90]||((UB *)((V *)Rv5)[5])[91])&&!(16&((UW *)
          Rv5)[42])) {
            Ra.sl[6]=6718; /* line # 6718 */
            P_init_d_varbl(((V *)Rv2)[8]);
          }
          Ra.sl[6]=6719; /* line # 6719 */
          if (F_ip!=NULL) P_insymbol();
        }
        else {
          Ra.sl[6]=6723; /* line # 6723 */
          V_sy_search=((V *)Rv2)[8];
          Ra.sl[6]=6724; /* line # 6724 */
          V_lastsymb=V_sy_sym.ub[0];
          Ra.sl[6]=6725; /* line # 6725 */
          V_sy_sym.ub[0]=0;
          Ra.sl[6]=6726; /* line # 6726 */
          Rv4=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=6727; /* line # 6727 */
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6728; /* line # 6728 */
            P_src_error(Rd.s+1107,32,2);
          }
        }
      }
      Ra.sl[6]=6733; /* line # 6733 */
      Rv0=PAS_COMILER_PRC_00000053(Rv4,1);
      Ra.sl[6]=6735; /* line # 6735 */
      if (!Rv3) {
        Ra.sl[6]=6737; /* line # 6737 */
        P_lgt_new(&Rv0,NULL,0, Rv0);
        Ra.sl[6]=6738; /* line # 6738 */
        ((UB *)Rv0)[41]=7;
      }
    }
  }
  Ra.sl[6]=6742; /* line # 6742 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " assignment_state "  */
V PAS_COMILER_PRC_00000055(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1111;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6755; /* line # 6755 */
  V_sy_search=F_ip;
  Ra.sl[6]=6757; /* line # 6757 */
  V_lastsymb=V_sy_sym.ub[0];
  Ra.sl[6]=6758; /* line # 6758 */
  V_sy_sym.ub[0]=0;
  Ra.sl[6]=6759; /* line # 6759 */
  Rv0=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6760; /* line # 6760 */
  Rv1=Rv0;
  Ra.sl[6]=6761; /* line # 6761 */
  switch (((UB *)Rv1)[40]) {
    case 1:
    case 2:
    case 3:
    case 7:
    case 8:
    case 13:Ra.sl[6]=6772; /* line # 6772 */
    if (((V *)Rv1)[3]==V_typ_std.v[28]&&((UB *)Rv1)[40]==7) {
      Ra.sl[6]=6773; /* line # 6773 */
      Rv2=Rv0;
    }
    else {
      Ra.sl[6]=6776; /* line # 6776 */
      if (!(2&((UW *)Rv1)[10])) {
        Ra.sl[6]=6778; /* line # 6778 */
        P_src_error(Rd.s+1131,173,2);
      }
      Ra.sl[6]=6780; /* line # 6780 */
      if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1131,32,2);
      else {
        Ra.sl[6]=6781; /* line # 6781 */
        P_insymbol();
      }
      Ra.sl[6]=6782; /* line # 6782 */
      Rv2=PAS_COMILER_PRC_00000053(Rv0,0);
    }
    break;
    default:Ra.sl[6]=6787; /* line # 6787 */
    P_src_error(Rd.s+1131,174,3);
    Ra.sl[6]=6788; /* line # 6788 */
    P_skip_symbol(18,0,0);
    Ra.sl[6]=6789; /* line # 6789 */
    P_lgt_free_tree(&Rv0);
    Ra.sl[6]=6790; /* line # 6790 */
    Rv2=NULL;
    break;
  }
  Ra.sl[6]=6792; /* line # 6792 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " with_state "  */
V PAS_COMILER_PRC_00000056(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1135;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6810; /* line # 6810 */
  Rv0=0;
  Ra.sl[6]=6811; /* line # 6811 */
  Rv1=NULL;
  Ra.sl[6]=6812; /* line # 6812 */
  Rv2=1;
  Ra.sl[6]=6813; /* line # 6813 */
  while (1){
    Ra.sl[6]=6815; /* line # 6815 */
    Rv3=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=6816; /* line # 6816 */
    Rv4=0;
    Ra.sl[6]=6817; /* line # 6817 */
    Rv5=0;
    Ra.sl[6]=6818; /* line # 6818 */
    Rv6=NULL;
    Ra.sl[6]=6819; /* line # 6819 */
    Rv7=((V *)Rv3)[3];
    Ra.sl[6]=6821; /* line # 6821 */
    Rv8=Rv7;
    Rv9=Rv3;
    Ra.sl[6]=6822; /* line # 6822 */
    if (((((UB *)Rv8)[93]==5||((UB *)Rv8)[93]==7)||((UB *)Rv8)[93]==24)&&((V *)Rv8)
    [12]!=NULL) {
      Ra.sl[6]=6828; /* line # 6828 */
      Rv10=1;
      Ra.sl[6]=6829; /* line # 6829 */
      Rv4=1;
      Ra.sl[6]=6830; /* line # 6830 */
      Rv6=Rv7;
      Ra.sl[6]=6831; /* line # 6831 */
      Rv7=((V *)Rv6)[12];
    }
    else {
      Ra.sl[6]=6835; /* line # 6835 */
      Rv10=((UB *)Rv9)[40]!=14&&((UB *)Rv9)[40]!=13;
    }
    Ra.sl[6]=6837; /* line # 6837 */
    if (((UB *)Rv7)[93]!=10) Rv7=NULL;
    Ra.sl[6]=6839; /* line # 6839 */
    Rv2=Rv7==NULL;
    Ra.sl[6]=6841; /* line # 6841 */
    if (Rv2) {
      Ra.sl[6]=6843; /* line # 6843 */
      P_src_error(Rd.s+1149,176,3);
      Ra.sl[6]=6844; /* line # 6844 */
      P_skip_symbol(72,0,0);
    }
    else {
      Ra.sl[6]=6847; /* line # 6847 */
      if (Rv10) {
        Ra.sl[6]=6849; /* line # 6849 */
        if (!Rv4) {
          Ra.sl[6]=6850; /* line # 6850 */
          if (((UB *)Rv3)[40]==2&&((SL *)Rv3)[4]==0) {
            Ra.sl[6]=6852; /* line # 6852 */
            Rv11=((V *)Rv3)[1];
            Ra.sl[6]=6853; /* line # 6853 */
            P_lgt_free(&Rv3);
            Ra.sl[6]=6854; /* line # 6854 */
            Rv6=((V *)Rv11)[3];
            Ra.sl[6]=6855; /* line # 6855 */
            Rv3=Rv11;
          }
          else {
            Ra.sl[6]=6859; /* line # 6859 */
            if (Rv6==NULL) {
              Ra.sl[6]=6860; /* line # 6860 */
              P_ide_new_typ(5, &Rv6);
            }
            Ra.sl[6]=6861; /* line # 6861 */
            Rv12=Rv6;
            Ra.sl[6]=6863; /* line # 6863 */
            memcpy(Rv12+48,V_typ_std.v[13]+48,1);
            Ra.sl[6]=6864; /* line # 6864 */
            ((SL *)Rv12)[11]=V_fptr_size;
            Ra.sl[6]=6865; /* line # 6865 */
            ((V *)Rv12)[12]=Rv7;
            Ra.sl[6]=6867; /* line # 6867 */
            P_lgt_new(&Rv3, Rv6,4, Rv3);
          }
        }
        Ra.sl[6]=6872; /* line # 6872 */
        Ra.sl[6]=6874; /* line # 6874 */
        Rv5=1;
        Ra.sl[6]=6875; /* line # 6875 */
        P_lgt_new(&Rv11, Rv6,13,NULL);
        Ra.sl[6]=6876; /* line # 6876 */
        P_all_new(((V *)Rv11)+7,Rv6,NULL,0);
        Ra.sl[6]=6877; /* line # 6877 */
        ((V *)Rv11)[0]=Rv3;
        Ra.sl[6]=6878; /* line # 6878 */
        Rv3=P_lgt_new_code(3, Rv11);
        Ra.sl[6]=6879; /* line # 6879 */
        ((SL *)Rv3)[4]=0;
        Ra.sl[6]=6880; /* line # 6880 */
        ((V *)Rv3)[0]=Rv1;
        Ra.sl[6]=6881; /* line # 6881 */
        Rv1=Rv3;
      }
      else {
        Ra.sl[6]=6885; /* line # 6885 */
        Rv11=Rv3;
      }
    }
    Ra.sl[6]=6890; /* line # 6890 */
    if (V_curr_disp<64) {
      Ra.sl[6]=6892; /* line # 6892 */
      Rv0=Rv0+1;
      Ra.sl[6]=6893; /* line # 6893 */
      P_new_disp_level(NULL,1);
      Ra.sl[6]=6894; /* line # 6894 */
      Rv13=(V_lex_ident_tree.s+V_curr_disp*64);
      Ra.sl[6]=6896; /* line # 6896 */
      ((V *)Rv13)[2]=Rv11;
      Ra.sl[6]=6897; /* line # 6897 */
      Rv14=Rv7;
      Ra.sl[6]=6898; /* line # 6898 */
      if (((V *)Rv14)[4]!=NULL) {
        Ra.sl[6]=6900; /* line # 6900 */
        Rv15=((V *)Rv14)[4];
        Ra.sl[6]=6901; /* line # 6901 */
        while (Rv15!=NULL){
          Ra.sl[6]=6903; /* line # 6903 */
          ((UB *)Rv15)[60]=3;
          Ra.sl[6]=6904; /* line # 6904 */
          Rv15=((V *)Rv15)[3];
        }
        Ra.sl[6]=6906; /* line # 6906 */
        ((V *)Rv13)[1]=((V *)Rv14)[4];
      }
      else {
        Ra.sl[6]=6909; /* line # 6909 */
        ((V *)Rv13)[1]=((V *)Rv14)[12];
      }
      Ra.sl[6]=6911; /* line # 6911 */
      ((SL *)Rv13)[13]=0;
      Ra.sl[6]=6912; /* line # 6912 */
      if (Rv10) {
        Ra.sl[6]=6913; /* line # 6913 */
        if (Rv5) ((UB *)Rv13)[24]=2;
        else {
          Ra.sl[6]=6914; /* line # 6914 */
          ((UB *)Rv13)[24]=3;
        }
      }
      else {
        Ra.sl[6]=6915; /* line # 6915 */
        ((UB *)Rv13)[24]=1;
      }
      Ra.sl[6]=6916; /* line # 6916 */
      if (((V *)Rv7)[4]!=NULL&&((UB *)Rv7)[93]==10) {
        Ra.sl[6]=6919; /* line # 6919 */
        Rv0=Rv0+1;
        Ra.sl[6]=6920; /* line # 6920 */
        P_new_disp_level(NULL,1);
        Ra.sl[6]=6921; /* line # 6921 */
        memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
        Ra.sl[6]=6922; /* line # 6922 */
        Rv16=(V_lex_ident_tree.s+V_curr_disp*64);
        Ra.sl[6]=6924; /* line # 6924 */
        ((V *)Rv16)[1]=((V *)Rv7)[12];
        Ra.sl[6]=6925; /* line # 6925 */
        ((SL *)Rv16)[13]=-1;
      }
    }
    else {
      Ra.sl[6]=6931; /* line # 6931 */
      P_src_error(Rd.s+1149,1003,4);
    }
    Ra.sl[6]=6932; /* line # 6932 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    if (V_sy_sym.ub[0]!=0)  break;
  }
  Ra.sl[6]=6934; /* line # 6934 */
  Ra.sl[6]=6936; /* line # 6936 */
  if (V_sy_sym.ub[0]==53) P_insymbol();
  else P_src_error(Rd.s+1149,55,2);
  Ra.sl[6]=6939; /* line # 6939 */
  Rv17=V_cntx_label;
  Ra.sl[6]=6940; /* line # 6940 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=6941; /* line # 6941 */
  Rv18=PAS_COMILER_PRC_00000036(NULL,1);
  Ra.sl[6]=6943; /* line # 6943 */
  if (Rv18!=NULL) {
    Ra.sl[6]=6944; /* line # 6944 */
    Rv19=Rv18;
    Ra.sl[6]=6945; /* line # 6945 */
    if (((UB *)Rv19)[40]==0) {
      Ra.sl[6]=6946; /* line # 6946 */
      switch (((UB *)Rv19)[41]) {
        case 0:
        case 2:Ra.sl[6]=6948; /* line # 6948 */
        Rv20=1;
        break;
        default:Ra.sl[6]=6951; /* line # 6951 */
        Rv20=0;
        break;
      }
    }
    else {
      Ra.sl[6]=6954; /* line # 6954 */
      Rv20=0;
    }
  }
  else {
    Ra.sl[6]=6955; /* line # 6955 */
    P_lgt_new(&Rv18,NULL,16,NULL);
  }
  Ra.sl[6]=6957; /* line # 6957 */
  P_label_purge(&Rv17);
  Ra.sl[6]=6960; /* line # 6960 */
  while (Rv0>0){
    Ra.sl[6]=6962; /* line # 6962 */
    Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=6964; /* line # 6964 */
    if (((SL *)Rv21)[13]>=0) {
      Ra.sl[6]=6965; /* line # 6965 */
      if (((SL *)Rv21)[13]==0) {
        Ra.sl[6]=6967; /* line # 6967 */
        switch (((UB *)Rv21)[24]) {
          case 1:
          case 3:Ra.sl[6]=6970; /* line # 6970 */
          P_lgt_free_tree(((V *)Rv21)+2);
          break;
          case 2:Ra.sl[6]=6974; /* line # 6974 */
          Rv3=Rv1;
          Ra.sl[6]=6975; /* line # 6975 */
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=6976; /* line # 6976 */
          ((V *)Rv3)[0]=NULL;
          Ra.sl[6]=6977; /* line # 6977 */
          P_all_free(((V *)((V *)Rv21)[2])[7]);
          Ra.sl[6]=6978; /* line # 6978 */
          ((V *)Rv21)[2]=NULL;
          Ra.sl[6]=6979; /* line # 6979 */
          P_lgt_free_tree(&Rv3);
          break;
          default:break;
        }
      }
      else {
        Ra.sl[6]=6985; /* line # 6985 */
        if (((UB *)Rv21)[24]==2) {
          Ra.sl[6]=6987; /* line # 6987 */
          Rv3=Rv1;
          Ra.sl[6]=6988; /* line # 6988 */
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=6990; /* line # 6990 */
          if (Rv20) {
            Ra.sl[6]=6992; /* line # 6992 */
            ((V *)Rv3)[0]=((V *)Rv18)[1];
            Ra.sl[6]=6993; /* line # 6993 */
            ((V *)Rv18)[1]=Rv3;
          }
          else {
            Ra.sl[6]=6997; /* line # 6997 */
            Rv20=1;
            Ra.sl[6]=6998; /* line # 6998 */
            ((V *)Rv3)[0]=Rv18;
            Ra.sl[6]=6999; /* line # 6999 */
            P_lgt_new(&Rv18,NULL,0, Rv3);
            Ra.sl[6]=7000; /* line # 7000 */
            ((UB *)Rv18)[41]=2;
          }
        }
      }
    }
    Ra.sl[6]=7004; /* line # 7004 */
    Rv15=((V *)Rv21)[1];
    Ra.sl[6]=7005; /* line # 7005 */
    if (((UB *)Rv15)[53]==2) {
      Ra.sl[6]=7007; /* line # 7007 */
      while (Rv15!=NULL){
        Ra.sl[6]=7009; /* line # 7009 */
        ((UB *)Rv15)[60]=0;
        Ra.sl[6]=7010; /* line # 7010 */
        ((V *)Rv15)[9]=NULL;
        Ra.sl[6]=7011; /* line # 7011 */
        Rv15=((V *)Rv15)[3];
      }
    }
    Ra.sl[6]=7014; /* line # 7014 */
    V_curr_disp=V_curr_disp -1;
    Ra.sl[6]=7015; /* line # 7015 */
    Rv0=Rv0-1;
  }
  Ra.sl[6]=7018; /* line # 7018 */
  Ret=Rv18;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " if_state "  */
V PAS_COMILER_PRC_00000057(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1153;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7032; /* line # 7032 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,1,0);
  Ra.sl[6]=7033; /* line # 7033 */
  Rv1=NULL;
  Ra.sl[6]=7034; /* line # 7034 */
  Rv2=NULL;
  Ra.sl[6]=7035; /* line # 7035 */
  Rv3=V_cntx_label;
  Ra.sl[6]=7036; /* line # 7036 */
  Rv4=Rv0;
  Ra.sl[6]=7038; /* line # 7038 */
  if (V_sy_sym.ub[0]==45) P_insymbol();
  else P_src_error(Rd.s+1165,56,2);
  Ra.sl[6]=7040; /* line # 7040 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7041; /* line # 7041 */
  Rv1=PAS_COMILER_PRC_00000036(NULL,1);
  Ra.sl[6]=7042; /* line # 7042 */
  P_label_purge(&Rv3);
  Ra.sl[6]=7043; /* line # 7043 */
  if (V_sy_sym.ub[0]!=18) {
    Ra.sl[6]=7044; /* line # 7044 */
    if (V_sy_sym.ub[0]==46) {
      Ra.sl[6]=7046; /* line # 7046 */
      P_insymbol();
      Ra.sl[6]=7047; /* line # 7047 */
      V_cntx_lblvl=V_cntx_lblvl+1;
      Ra.sl[6]=7048; /* line # 7048 */
      Rv2=PAS_COMILER_PRC_00000036(NULL,1);
      Ra.sl[6]=7049; /* line # 7049 */
      P_label_purge(&Rv3);
    }
  }
  Ra.sl[6]=7052; /* line # 7052 */
  if (Rv1==NULL&&Rv2==NULL) {
    Ra.sl[6]=7054; /* line # 7054 */
    P_lgt_free(&Rv0);
    Ra.sl[6]=7055; /* line # 7055 */
    Rv5=NULL;
  }
  else {
    Ra.sl[6]=7058; /* line # 7058 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=7060; /* line # 7060 */
      if (((SL *)((V *)Rv4)[7])[13]>0) {
        Ra.sl[6]=7062; /* line # 7062 */
        Rv5=Rv1;
        Ra.sl[6]=7063; /* line # 7063 */
        P_lgt_free_tree(&Rv2);
      }
      else {
        Ra.sl[6]=7067; /* line # 7067 */
        Rv5=Rv2;
        Ra.sl[6]=7068; /* line # 7068 */
        P_lgt_free_tree(&Rv1);
      }
      Ra.sl[6]=7070; /* line # 7070 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=7075; /* line # 7075 */
      if (Rv1==NULL) {
        Ra.sl[6]=7077; /* line # 7077 */
        Rv0=P_exp_genop(0, Rv0);
        Ra.sl[6]=7078; /* line # 7078 */
        ((V *)Rv0)[0]=Rv2;
      }
      else {
        Ra.sl[6]=7082; /* line # 7082 */
        ((V *)Rv0)[0]=Rv1;
        Ra.sl[6]=7083; /* line # 7083 */
        ((V *)Rv1)[0]=Rv2;
      }
      Ra.sl[6]=7085; /* line # 7085 */
      P_lgt_new(&Rv5,NULL,0, Rv0);
      Ra.sl[6]=7086; /* line # 7086 */
      ((UB *)Rv5)[41]=8;
    }
  }
  Ra.sl[6]=7090; /* line # 7090 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exit_state "  */
V PAS_COMILER_PRC_00000058(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1169;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7104; /* line # 7104 */
  Ra.sl[6]=7106; /* line # 7106 */
  P_lgt_new(&Rv0,NULL,16, Lx[5].v[6]);
  Ra.sl[6]=7107; /* line # 7107 */
  if (Lx[5].v[6]==NULL) {
    Ra.sl[6]=7108; /* line # 7108 */
    P_src_error(Rd.s+1183,244,2);
  }
  Ra.sl[6]=7109; /* line # 7109 */
  P_lgt_new(&Rv1,NULL,0, Rv0);
  Ra.sl[6]=7110; /* line # 7110 */
  ((UB *)Rv1)[41]=6;
  Ra.sl[6]=7111; /* line # 7111 */
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  Ra.sl[6]=7112; /* line # 7112 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=7114; /* line # 7114 */
    Rv2=P_ide_search(8);
    Ra.sl[6]=7115; /* line # 7115 */
    if (Rv2==V_ide_udptr.v[3]) Rv2=NULL;
    Ra.sl[6]=7116; /* line # 7116 */
    if (Rv2!=NULL) {
      Ra.sl[6]=7117; /* line # 7117 */
      Rv3=Rv2;
      Ra.sl[6]=7120; /* line # 7120 */
      Rv4=V_cntx_label;
      Ra.sl[6]=7121; /* line # 7121 */
      while (Rv4!=NULL&&Rv4!=Rv2)
      Rv4=((V *)Rv4)[8];
      Ra.sl[6]=7122; /* line # 7122 */
      if (Rv4==NULL) {
        Ra.sl[6]=7124; /* line # 7124 */
        P_src_error(Rd.s+1183,177,3);
      }
      Ra.sl[6]=7125; /* line # 7125 */
      ((UB *)Rv3)[54]=((UB *)Rv3)[54]|2;
      Ra.sl[6]=7126; /* line # 7126 */
      ((V *)Rv0)[1]=((V *)Rv3)[10];
    }
    Ra.sl[6]=7134; /* line # 7134 */
    P_insymbol();
  }
  Ra.sl[6]=7137; /* line # 7137 */
  if (V_sy_sym.ub[0]==44) {
    Ra.sl[6]=7139; /* line # 7139 */
    P_insymbol();
    Ra.sl[6]=7141; /* line # 7141 */
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
  }
  Ra.sl[6]=7144; /* line # 7144 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " loop_state "  */
V PAS_COMILER_PRC_00000059(UB F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1187;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7160; /* line # 7160 */
  Rv0=Lx[5].v[6];
  Ra.sl[6]=7161; /* line # 7161 */
  P_lgt_new(Lx[5].v+6,NULL,0,NULL);
  Ra.sl[6]=7162; /* line # 7162 */
  ((UB *)Lx[5].v[6])[41]=4;
  Ra.sl[6]=7163; /* line # 7163 */
  Rv1=Lx[5].v[6];
  Ra.sl[6]=7164; /* line # 7164 */
  if (F_symb==47) {
    Ra.sl[6]=7166; /* line # 7166 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    Ra.sl[6]=7167; /* line # 7167 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else {
      Ra.sl[6]=7168; /* line # 7168 */
      P_src_error(Rd.s+1201,55,2);
    }
  }
  else {
    Ra.sl[6]=7171; /* line # 7171 */
    P_lgt_new(&Rv2,NULL,16,NULL);
  }
  Ra.sl[6]=7172; /* line # 7172 */
  ((V *)Rv1)[1]=Rv2;
  Ra.sl[6]=7174; /* line # 7174 */
  Ra.sl[6]=7176; /* line # 7176 */
  Rv3=Lx[4].v[0];
  Ra.sl[6]=7177; /* line # 7177 */
  if (Rv3!=NULL) ((V *)Rv3)[10]=Lx[5].v[6];
  Ra.sl[6]=7179; /* line # 7179 */
  Rv4=V_cntx_label;
  Ra.sl[6]=7181; /* line # 7181 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7184; /* line # 7184 */
  switch (F_symb) {
    case 47:Ra.sl[6]=7185; /* line # 7185 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000036(NULL,1);
    break;
    case 48:Ra.sl[6]=7189; /* line # 7189 */
    Rv5=PAS_COMILER_PRC_00000035(49,0);
    Ra.sl[6]=7190; /* line # 7190 */
    if (V_sy_sym.ub[0]==49) P_insymbol();
    else {
      Ra.sl[6]=7191; /* line # 7191 */
      P_src_error(Rd.s+1201,57,2);
    }
    Ra.sl[6]=7194; /* line # 7194 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Ra.sl[6]=7195; /* line # 7195 */
    Rv7=Rv6;
    Ra.sl[6]=7197; /* line # 7197 */
    ((V *)Rv7)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    Ra.sl[6]=7198; /* line # 7198 */
    ((V *)Rv7)[1]=Lx[5].v[6];
    Ra.sl[6]=7200; /* line # 7200 */
    P_lgt_new(&Rv6,NULL,0, Rv6);
    Ra.sl[6]=7201; /* line # 7201 */
    ((UB *)Rv6)[41]=6;
    Ra.sl[6]=7202; /* line # 7202 */
    if (Rv5!=NULL) {
      Ra.sl[6]=7204; /* line # 7204 */
      ((V *)Lx[5].v[7])[0]=Rv6;
      Ra.sl[6]=7205; /* line # 7205 */
      ((V *)Rv2)[0]=Rv5;
    }
    else {
      Ra.sl[6]=7208; /* line # 7208 */
      ((V *)Rv2)[0]=Rv6;
    }
    break;
    case 54:Ra.sl[6]=7213; /* line # 7213 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000035(72,0);
    Ra.sl[6]=7214; /* line # 7214 */
    if (V_sy_sym.ub[0]!=72) P_src_error(Rd.s+1201,54,2);
    else {
      Ra.sl[6]=7215; /* line # 7215 */
      P_insymbol();
    }
    Ra.sl[6]=7216; /* line # 7216 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=7217; /* line # 7217 */
      if (Rv3==P_ide_search(8)) {
        Ra.sl[6]=7218; /* line # 7218 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=7220; /* line # 7220 */
        P_src_error_s(Rd.s+1201,179,2, V_sy_ident.s,NULL);
      }
    }
    break;
  }
  Ra.sl[6]=7223; /* line # 7223 */
  P_label_purge(&Rv4);
  Ra.sl[6]=7226; /* line # 7226 */
  Lx[5].v[6]=Rv0;
  Ra.sl[6]=7227; /* line # 7227 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " for_state "  */
V PAS_COMILER_PRC_00000060(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  UB Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1205;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7245; /* line # 7245 */
  Rv2=Lx[5].v[6];
  Ra.sl[6]=7246; /* line # 7246 */
  Rv3=V_curr_disp;
  Ra.sl[6]=7247; /* line # 7247 */
  Rv4=V_cntx_label;
  Ra.sl[6]=7248; /* line # 7248 */
  P_new_disp_level(Lx[5].v[13],0);
  Ra.sl[6]=7249; /* line # 7249 */
  Ra.sl[6]=7250; /* line # 7250 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1218,168,2);
  else {
    Ra.sl[6]=7253; /* line # 7253 */
    P_ide_new(5,NULL,&Rv5);
    Ra.sl[6]=7254; /* line # 7254 */
    P_insymbol();
    Ra.sl[6]=7255; /* line # 7255 */
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else P_src_error(Rd.s+1218,32,2);
    Ra.sl[6]=7256; /* line # 7256 */
    V_sy_fix_range_ctl=0;
    Ra.sl[6]=7257; /* line # 7257 */
    Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,1,0);
    Ra.sl[6]=7260; /* line # 7260 */
    switch (V_sy_sym.ub[0]) {
      case 51:Ra.sl[6]=7263; /* line # 7263 */
      P_insymbol();
      Ra.sl[6]=7264; /* line # 7264 */
      Rv6=38;
      break;
      case 52:Ra.sl[6]=7269; /* line # 7269 */
      P_insymbol();
      Ra.sl[6]=7270; /* line # 7270 */
      Rv6=39;
      break;
      default:Ra.sl[6]=7274; /* line # 7274 */
      P_src_error(Rd.s+1218,59,2);
      Ra.sl[6]=7275; /* line # 7275 */
      Rv6=38;
      break;
    }
    Ra.sl[6]=7278; /* line # 7278 */
    Rv7=PAS_COMILER_PRC_00000005(((V *)Rv0)[3],0,1,0);
    Ra.sl[6]=7280; /* line # 7280 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else {
      Ra.sl[6]=7281; /* line # 7281 */
      P_src_error(Rd.s+1218,55,2);
    }
    Ra.sl[6]=7283; /* line # 7283 */
    P_lgt_new(Lx[5].v+6,V_typ_std.v[2],0,NULL);
    Ra.sl[6]=7284; /* line # 7284 */
    ((UB *)Lx[5].v[6])[41]=5;
    Ra.sl[6]=7286; /* line # 7286 */
    if (Rv6==39) {
      Ra.sl[6]=7288; /* line # 7288 */
      Rv8=Rv7;
      Ra.sl[6]=7290; /* line # 7290 */
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv7);
      else {
        Ra.sl[6]=7291; /* line # 7291 */
        Rv7=Rv0;
      }
    }
    else {
      Ra.sl[6]=7295; /* line # 7295 */
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv8);
      else {
        Ra.sl[6]=7296; /* line # 7296 */
        Rv8=Rv0;
      }
    }
    Ra.sl[6]=7298; /* line # 7298 */
    if (((UB *)Rv8)[40]==14) {
      Ra.sl[6]=7300; /* line # 7300 */
      Rv9=Rv7;
      Ra.sl[6]=7301; /* line # 7301 */
      Rv10=P_lgt_new_econst(((V *)Rv8)[3],((SL *)((V *)Rv8)[7])[13]-1);
    }
    else {
      Ra.sl[6]=7305; /* line # 7305 */
      Rv10=Rv8;
      Ra.sl[6]=7306; /* line # 7306 */
      if (((UB *)Rv7)[40]==14) {
        Ra.sl[6]=7307; /* line # 7307 */
        Rv9=P_lgt_new_econst(((V *)Rv7)[3],((SL *)((V *)Rv7)[7])[13]+1);
      }
      else {
        Ra.sl[6]=7310; /* line # 7310 */
        ((V *)Rv7)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Ra.sl[6]=7311; /* line # 7311 */
        Rv9=P_lgt_new_code(49, Rv7);
      }
    }
    Ra.sl[6]=7315; /* line # 7315 */
    Rv7=P_lgt_new_addsub(1,1, Rv9, Rv10);
    Ra.sl[6]=7318; /* line # 7318 */
    ((V *)Lx[5].v[6])[1]=Rv7;
    Ra.sl[6]=7320; /* line # 7320 */
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=7322; /* line # 7322 */
    Rv11=Rv5;
    Ra.sl[6]=7324; /* line # 7324 */
    ((V *)Rv11)[5]=((V *)Rv8)[3];
    Ra.sl[6]=7325; /* line # 7325 */
    ((UW *)Rv11)[42]=32;
    Ra.sl[6]=7326; /* line # 7326 */
    ((UB *)Rv11)[86]=1;
    Ra.sl[6]=7329; /* line # 7329 */
    Rv12=Lx[4].v[0];
    Ra.sl[6]=7330; /* line # 7330 */
    if (Rv12!=NULL) {
      Ra.sl[6]=7331; /* line # 7331 */
      Rv13=Rv12;
      Ra.sl[6]=7333; /* line # 7333 */
      ((V *)Rv13)[8]=V_cntx_label;
      Ra.sl[6]=7334; /* line # 7334 */
      V_cntx_label=Rv12;
      Ra.sl[6]=7335; /* line # 7335 */
      ((V *)Rv13)[10]=Lx[5].v[6];
    }
    Ra.sl[6]=7338; /* line # 7338 */
    V_cntx_lblvl=V_cntx_lblvl+1;
    Ra.sl[6]=7341; /* line # 7341 */
    Rv8=PAS_COMILER_PRC_00000036(NULL,1);
    Ra.sl[6]=7342; /* line # 7342 */
    ((V *)Rv7)[0]=Rv8;
    Ra.sl[6]=7344; /* line # 7344 */
    if (1&((UW *)Rv5)[42]) {
      Ra.sl[6]=7349; /* line # 7349 */
      Rv0=P_lgt_link(Rv0);
      Ra.sl[6]=7350; /* line # 7350 */
      Rv0=P_lgt_new_idref(Rv5, Rv0);
      Ra.sl[6]=7351; /* line # 7351 */
      Rv0=P_lgt_new_code(3, Rv0);
      Ra.sl[6]=7352; /* line # 7352 */
      ((V *)Rv0)[0]=Lx[5].v[6];
      Ra.sl[6]=7354; /* line # 7354 */
      P_lgt_new(Lx[5].v+6,NULL,0, Rv0);
      Ra.sl[6]=7355; /* line # 7355 */
      ((UB *)Lx[5].v[6])[41]=2;
      Ra.sl[6]=7358; /* line # 7358 */
      Rv0=P_lgt_new_idref(Rv5,NULL);
      Ra.sl[6]=7359; /* line # 7359 */
      Rv0=P_lgt_new_code(Rv6, Rv0);
      Ra.sl[6]=7360; /* line # 7360 */
      ((V *)Rv0)[3]=Rv1;
      Ra.sl[6]=7361; /* line # 7361 */
      if (Rv8!=NULL) ((V *)Rv8)[0]=Rv0;
      else {
        Ra.sl[6]=7362; /* line # 7362 */
        ((V *)Rv7)[0]=Rv0;
      }
    }
    else {
      Ra.sl[6]=7366; /* line # 7366 */
      if (((UB *)Rv0)[40]==14) P_lgt_free(&Rv0);
    }
    Ra.sl[6]=7368; /* line # 7368 */
    Rv0=Lx[5].v[6];
  }
  Ra.sl[6]=7371; /* line # 7371 */
  Lx[5].v[6]=Rv2;
  Ra.sl[6]=7373; /* line # 7373 */
  if (V_curr_disp>Rv3) {
    Ra.sl[6]=7375; /* line # 7375 */
    P_ide_reserve_disp(Rv3);
  }
  Ra.sl[6]=7376; /* line # 7376 */
  P_label_purge(&Rv4);
  Ra.sl[6]=7377; /* line # 7377 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " goto_state "  */
V PAS_COMILER_PRC_00000061(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1222;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7391; /* line # 7391 */
  Rv0=NULL;
  Ra.sl[6]=7392; /* line # 7392 */
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  Ra.sl[6]=7393; /* line # 7393 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1236,69,3);
  Ra.sl[6]=7394; /* line # 7394 */
  V_err_prt=0;
  Ra.sl[6]=7395; /* line # 7395 */
  Rv1=P_ide_search(8);
  Ra.sl[6]=7396; /* line # 7396 */
  V_err_prt=1;
  Ra.sl[6]=7398; /* line # 7398 */
  if (Rv1==NULL) {
    Ra.sl[6]=7400; /* line # 7400 */
    P_ide_new(3,NULL,&Rv1);
    Ra.sl[6]=7401; /* line # 7401 */
    Rv2=Lx[5].v[13];
    Ra.sl[6]=7402; /* line # 7402 */
    if (((V *)Rv2)[20]==NULL) ((V *)Rv2)[20]=Rv1;
    else {
      Ra.sl[6]=7403; /* line # 7403 */
      ((V *)Lx[5].v[4])[7]=Rv1;
    }
    Ra.sl[6]=7404; /* line # 7404 */
    Lx[5].v[4]=Rv1;
  }
  Ra.sl[6]=7406; /* line # 7406 */
  P_lgt_new(&Rv0,NULL,0,NULL);
  Ra.sl[6]=7407; /* line # 7407 */
  Rv3=Rv0;
  Rv4=Rv1;
  Ra.sl[6]=7409; /* line # 7409 */
  if (((SL *)Rv4)[12]!=V_curr_lex) {
    Ra.sl[6]=7411; /* line # 7411 */
    ((UB *)Rv3)[41]=10;
    Ra.sl[6]=7413; /* line # 7413 */
    ((UB *)Rv4)[54]=((UB *)Rv4)[54]|12;
  }
  else {
    Ra.sl[6]=7417; /* line # 7417 */
    ((UB *)Rv4)[54]=((UB *)Rv4)[54]|4;
    Ra.sl[6]=7418; /* line # 7418 */
    if (32&((UB *)Rv4)[54]) {
      Ra.sl[6]=7420; /* line # 7420 */
      P_src_error(Rd.s+1236,70,2);
    }
    else {
      Ra.sl[6]=7422; /* line # 7422 */
      ((SL *)Rv4)[22]=V_cntx_lblvl;
    }
    Ra.sl[6]=7423; /* line # 7423 */
    ((UB *)Rv3)[41]=9;
  }
  Ra.sl[6]=7425; /* line # 7425 */
  ((V *)Rv3)[6]=Rv1;
  Ra.sl[6]=7427; /* line # 7427 */
  P_insymbol();
  Ra.sl[6]=7428; /* line # 7428 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " begin_state "  */
V PAS_COMILER_PRC_00000062(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1240;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7442; /* line # 7442 */
  Rv0=V_cntx_label;
  Ra.sl[6]=7443; /* line # 7443 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7444; /* line # 7444 */
  Rv1=PAS_COMILER_PRC_00000035(72,1);
  Ra.sl[6]=7445; /* line # 7445 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else {
    Ra.sl[6]=7446; /* line # 7446 */
    P_src_error(Rd.s+1255,54,2);
  }
  Ra.sl[6]=7447; /* line # 7447 */
  P_label_purge(&Rv0);
  Ra.sl[6]=7448; /* line # 7448 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " label_attach "  */
void PAS_COMILER_PRC_00000063(V F_lab_list, V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1259;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7454; /* line # 7454 */
  if (F_lab_list!=NULL&&F_trg!=NULL) {
    Ra.sl[6]=7455; /* line # 7455 */
    ((V *)F_trg)[4]=F_lab_list;
  }
  Ra.sl[6]=7463; /* line # 7463 */
  while (F_lab_list!=NULL){
    Ra.sl[6]=7464; /* line # 7464 */
    Rv0=F_lab_list;
    Ra.sl[6]=7466; /* line # 7466 */
    ((V *)Rv0)[10]=F_trg;
    F_lab_list=((V *)Rv0)[9];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement "  */
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1273;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=7473; /* line # 7473 */
  Rv0=NULL;
  Ra.sl[8]=7474; /* line # 7474 */
  Rv1=NULL;
  Ra.sl[8]=7475; /* line # 7475 */
  Ra.v[0]=NULL;
  Ra.sl[8]=7476; /* line # 7476 */
  Rv2=V_wildtmp_stk;
  Ra.sl[8]=7478; /* line # 7478 */
  Ra.sl[8]=7480; /* line # 7480 */
  Rv3=NULL;
  Ra.sl[8]=7481; /* line # 7481 */
  if (V_sy_sym.ub[0]==1) while (1){
    Ra.sl[8]=7483; /* line # 7483 */
    V_err_prt=0;
    Ra.sl[8]=7484; /* line # 7484 */
    Rv4=P_ide_search(8);
    Ra.sl[8]=7485; /* line # 7485 */
    V_err_prt=1;
    Ra.sl[8]=7487; /* line # 7487 */
    if (Rv4!=NULL) {
      Ra.sl[8]=7489; /* line # 7489 */
      if (((SL *)Rv4)[12]!=V_curr_lex) Rv4=NULL;
      else {
        Ra.sl[8]=7491; /* line # 7491 */
        if (16&((UB *)Rv4)[54]) {
          Ra.sl[8]=7493; /* line # 7493 */
          P_src_error_s(Rd.s+1286,75,3, V_sy_ident.s,NULL);
        }
      }
    }
    Ra.sl[8]=7495; /* line # 7495 */
    if (Rv4==NULL) {
      Ra.sl[8]=7497; /* line # 7497 */
      P_ide_new(3,NULL,&Rv4);
      Ra.sl[8]=7498; /* line # 7498 */
      Rv5=Lx[5].v[13];
      Ra.sl[8]=7499; /* line # 7499 */
      if (((V *)Rv5)[20]==NULL) ((V *)Rv5)[20]=Rv4;
      else {
        Ra.sl[8]=7500; /* line # 7500 */
        ((V *)Lx[5].v[4])[7]=Rv4;
      }
      Ra.sl[8]=7501; /* line # 7501 */
      Lx[5].v[4]=Rv4;
    }
    Ra.sl[8]=7504; /* line # 7504 */
    Rv6=Rv4;
    Ra.sl[8]=7506; /* line # 7506 */
    ((V *)Rv6)[8]=V_cntx_label;
    Ra.sl[8]=7507; /* line # 7507 */
    V_cntx_label=Rv4;
    Ra.sl[8]=7508; /* line # 7508 */
    ((UB *)Rv6)[54]=((UB *)Rv6)[54]|16;
    Ra.sl[8]=7509; /* line # 7509 */
    if (4&((UB *)Rv6)[54]) {
      Ra.sl[8]=7510; /* line # 7510 */
      if (((SL *)Rv6)[22]<V_cntx_lblvl) {
        Ra.sl[8]=7511; /* line # 7511 */
        P_src_error_s(Rd.s+1286,70,2, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[8]=7513; /* line # 7513 */
    if (Rv3==NULL) Rv3=Rv4;
    Ra.sl[8]=7514; /* line # 7514 */
    ((V *)Rv4)[9]=Ra.v[0];
    Ra.sl[8]=7515; /* line # 7515 */
    Ra.v[0]=Rv4;
    Ra.sl[8]=7516; /* line # 7516 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=1)  break;
  }
  Ra.sl[8]=7519; /* line # 7519 */
  if (V_cmp_trace>0) {
    Ra.sl[8]=7520; /* line # 7520 */
    switch (V_sy_sym.ub[0]) {
      case 18:
      case 48:
      case 54:
      case 71:break;
      default:Ra.sl[8]=7525; /* line # 7525 */
      if (Lx[5].sl[28]<2) {
        Ra.sl[8]=7526; /* line # 7526 */
        if (Ra.v[0]!=NULL) {
          Ra.sl[8]=7527; /* line # 7527 */
          if (8&((UB *)Ra.v[0])[54]) Lx[5].sl[28]=2;
          else {
            Ra.sl[8]=7528; /* line # 7528 */
            Lx[5].sl[28]=1;
          }
        }
      }
      Ra.sl[8]=7530; /* line # 7530 */
      Rv1=P_lgt_new_line(Lx[5].v[13],F_lgp, Lx[5].sl[28]);
      Ra.sl[8]=7532; /* line # 7532 */
      if (Ra.v[0]!=NULL) {
        Ra.sl[8]=7534; /* line # 7534 */
        if (Rv1==NULL) {
          Ra.sl[8]=7536; /* line # 7536 */
          if (F_lgp!=NULL) {
            Ra.sl[8]=7537; /* line # 7537 */
            ((V *)Rv3)[9]=((V *)F_lgp)[4];
          }
          Ra.sl[8]=7538; /* line # 7538 */
          PAS_COMILER_PRC_00000063(Ra.v[0],F_lgp);
        }
        else {
          Ra.sl[8]=7541; /* line # 7541 */
          PAS_COMILER_PRC_00000063(Ra.v[0],Rv1);
        }
        Ra.sl[8]=7542; /* line # 7542 */
        Ra.v[0]=NULL;
      }
      Ra.sl[8]=7544; /* line # 7544 */
      Lx[5].sl[28]=0;
      break;
    }
  }
  Ra.sl[8]=7548; /* line # 7548 */
  memcpy(Ra.s+36,V_sy_sym.s,2);
  Ra.sl[8]=7549; /* line # 7549 */
  Ra.sl[8]=7551; /* line # 7551 */
  if (((((Ra.ub[36]!=72&&Ra.ub[36]!=90)&&Ra.ub[36]!=49)&&Ra.ub[36]!=0)&&Ra.ub[36]
  !=18)&&Ra.ub[36]!=77) {
    Ra.sl[8]=7552; /* line # 7552 */
    P_insymbol();
  }
  Ra.sl[8]=7553; /* line # 7553 */
  switch (Ra.ub[36]) {
    case 90:break;
    case 0:Ra.sl[8]=7557; /* line # 7557 */
    Rv4=P_ide_search(2016);
    Ra.sl[8]=7566; /* line # 7566 */
    Rv7=Rv4;
    Ra.sl[8]=7568; /* line # 7568 */
    P_insymbol();
    Ra.sl[8]=7569; /* line # 7569 */
    switch (((UB *)Rv7)[53]) {
      case 10:Ra.sl[8]=7571; /* line # 7571 */
      Rv0=PAS_COMILER_PRC_00000014(Rv4);
      break;
      case 7:Ra.sl[8]=7575; /* line # 7575 */
      Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
      Ra.sl[8]=7576; /* line # 7576 */
      if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
      break;
      case 8:
      case 9:Ra.sl[8]=7581; /* line # 7581 */
      switch (V_sy_sym.ub[0]) {
        case 15:
        case 19:
        case 22:Ra.sl[8]=7585; /* line # 7585 */
        Rv0=PAS_COMILER_PRC_00000054(Rv4);
        break;
        default:Ra.sl[8]=7588; /* line # 7588 */
        if (((UB *)Rv7)[53]==9) Rv0=PAS_COMILER_PRC_00000011(Rv4,0);
        else {
          Ra.sl[8]=7589; /* line # 7589 */
          Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
        }
        Ra.sl[8]=7590; /* line # 7590 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
        break;
      }
      break;
      default:Ra.sl[8]=7594; /* line # 7594 */
      Rv0=PAS_COMILER_PRC_00000055(Rv4);
      break;
    }
    break;
    case 71:Ra.sl[8]=7599; /* line # 7599 */
    Rv0=PAS_COMILER_PRC_00000062();
    break;
    case 44:Ra.sl[8]=7600; /* line # 7600 */
    Rv0=PAS_COMILER_PRC_00000057();
    break;
    case 47:
    case 48:
    case 54:Ra.sl[8]=7603; /* line # 7603 */
    Rv0=PAS_COMILER_PRC_00000059(Ra.ub[36]);
    break;
    case 50:Ra.sl[8]=7604; /* line # 7604 */
    Rv0=PAS_COMILER_PRC_00000060();
    break;
    case 55:Ra.sl[8]=7605; /* line # 7605 */
    Rv0=PAS_COMILER_PRC_00000058();
    break;
    case 57:Ra.sl[8]=7606; /* line # 7606 */
    Rv0=PAS_COMILER_PRC_00000056();
    break;
    case 56:Ra.sl[8]=7607; /* line # 7607 */
    Rv0=PAS_COMILER_PRC_00000004(56,NULL);
    break;
    case 33:Ra.sl[8]=7608; /* line # 7608 */
    Rv0=PAS_COMILER_PRC_00000061();
    break;
    case 58:Ra.sl[8]=7610; /* line # 7610 */
    Rv0=PAS_COMILER_PRC_00000016(V_new_entry_proc);
    break;
    case 59:Ra.sl[8]=7611; /* line # 7611 */
    Rv0=PAS_COMILER_PRC_00000016(V_newh_entry_proc);
    break;
    case 60:Ra.sl[8]=7612; /* line # 7612 */
    Rv0=PAS_COMILER_PRC_00000017(V_dispose_entry_proc);
    break;
    case 61:Ra.sl[8]=7614; /* line # 7614 */
    Rv0=PAS_COMILER_PRC_00000012(0);
    break;
    case 62:Ra.sl[8]=7615; /* line # 7615 */
    Rv0=PAS_COMILER_PRC_00000012(1);
    break;
    case 63:Ra.sl[8]=7616; /* line # 7616 */
    Rv0=PAS_COMILER_PRC_00000012(2);
    break;
    case 64:Ra.sl[8]=7617; /* line # 7617 */
    Rv0=PAS_COMILER_PRC_00000012(3);
    break;
    case 65:Ra.sl[8]=7620; /* line # 7620 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    NULL);
    break;
    case 66:Ra.sl[8]=7623; /* line # 7623 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    V_inp_std_eoln);
    break;
    case 67:Ra.sl[8]=7626; /* line # 7626 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_inp_std_sel, V_inp_std_gene,NULL,V_inp_std_eoln);
    break;
    case 68:Ra.sl[8]=7629; /* line # 7629 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    NULL);
    break;
    case 69:Ra.sl[8]=7632; /* line # 7632 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    V_out_std_eoln);
    break;
    case 70:Ra.sl[8]=7635; /* line # 7635 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_out_std_sel, V_out_std_gene,NULL,V_out_std_eoln);
    break;
    case 77:
    case 78:Ra.sl[8]=7639; /* line # 7639 */
    Rv0=PAS_COMILER_PRC_00000054(NULL);
    break;
    default:break;
  }
  Ra.sl[8]=7643; /* line # 7643 */
  if (Ra.v[0]!=NULL) {
    Ra.sl[8]=7645; /* line # 7645 */
    if (Rv0==NULL) P_lgt_new(&Rv0,NULL,17,NULL);
    Ra.sl[8]=7646; /* line # 7646 */
    PAS_COMILER_PRC_00000063(Ra.v[0],Rv0);
  }
  Ra.sl[8]=7650; /* line # 7650 */
  if (Rv0!=NULL) {
    Ra.sl[8]=7652; /* line # 7652 */
    if (Rv1!=NULL) {
      Ra.sl[8]=7654; /* line # 7654 */
      ((V *)Rv1)[0]=Rv0;
      Ra.sl[8]=7655; /* line # 7655 */
      if (F_bsequ) {
        Ra.sl[8]=7657; /* line # 7657 */
        P_lgt_new(&Rv0,NULL,0, Rv1);
        Ra.sl[8]=7658; /* line # 7658 */
        ((UB *)Rv0)[41]=2;
        Ra.sl[8]=7659; /* line # 7659 */
        Lx[5].v[8]=Rv0;
      }
      else {
        Ra.sl[8]=7663; /* line # 7663 */
        Lx[5].v[8]=Rv0;
        Ra.sl[8]=7664; /* line # 7664 */
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[8]=7668; /* line # 7668 */
      Lx[5].v[8]=Rv0;
    }
  }
  else {
    Ra.sl[8]=7672; /* line # 7672 */
    if (Rv1!=NULL) Rv0=Rv1;
    Ra.sl[8]=7673; /* line # 7673 */
    Lx[5].v[8]=Rv0;
  }
  Ra.sl[8]=7676; /* line # 7676 */
  P_tmpstk_free(Rv2);
  Ra.sl[8]=7677; /* line # 7677 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[4]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " statelist "  */
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1290;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7692; /* line # 7692 */
  Rv0=V_src_control;
  ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
  Ra.sl[6]=7693; /* line # 7693 */
  Rv1=NULL;
  Ra.sl[6]=7694; /* line # 7694 */
  Rv2=NULL;
  Ra.sl[6]=7695; /* line # 7695 */
  Ra.sl[6]=7697; /* line # 7697 */
  while (V_sy_sym.ub[0]==18)
  P_insymbol();
  Ra.sl[6]=7698; /* line # 7698 */
  if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)&&!V_emergency_stop)
   {
    Ra.sl[6]=7701; /* line # 7701 */
    Rv1=PAS_COMILER_PRC_00000036(NULL,0);
    Ra.sl[6]=7702; /* line # 7702 */
    Rv2=Lx[5].v[8];
    Ra.sl[6]=7704; /* line # 7704 */
    while (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)
    &&!V_emergency_stop){
      Ra.sl[6]=7707; /* line # 7707 */
      if (V_sy_sym.ub[0]==18) {
        Ra.sl[6]=7708; /* line # 7708 */
        while (V_sy_sym.ub[0]==18)
        P_insymbol();
      }
      else {
        Ra.sl[6]=7709; /* line # 7709 */
        P_src_error(Rd.s+1303,21,2);
      }
      Ra.sl[6]=7710; /* line # 7710 */
      if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)&&
      !V_emergency_stop) {
        Ra.sl[6]=7713; /* line # 7713 */
        Rv3=PAS_COMILER_PRC_00000036(Rv2,0);
        Ra.sl[6]=7714; /* line # 7714 */
        if (Rv3!=NULL) {
          Ra.sl[6]=7716; /* line # 7716 */
          if (Rv1==NULL) Rv1=Rv3;
          else {
            Ra.sl[6]=7717; /* line # 7717 */
            ((V *)Rv2)[0]=Rv3;
          }
          Ra.sl[6]=7718; /* line # 7718 */
          Rv2=Lx[5].v[8];
        }
      }
    }
  }
  Ra.sl[6]=7724; /* line # 7724 */
  Rv4=V_src_control;
  ((SL *)Rv4)[6]=((SL *)Rv4)[6]-1;
  Ra.sl[6]=7725; /* line # 7725 */
  Lx[5].v[7]=Rv2;
  Ra.sl[6]=7726; /* line # 7726 */
  if (F_seq_flg&&Rv1!=Rv2) {
    Ra.sl[6]=7728; /* line # 7728 */
    P_lgt_new(&Rv2,NULL,0, Rv1);
    Ra.sl[6]=7729; /* line # 7729 */
    ((UB *)Rv2)[41]=2;
    Ra.sl[6]=7730; /* line # 7730 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=7732; /* line # 7732 */
    Ret=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cmp_block "  */
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[13]=F_owner;
  Ra.sl[28]=F_glicd;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+72;
  Ra.v[10]=Rd.s+1307;
  Ra.v[11]=Rd.s+17;
  Ra.sl[24]=7740; /* line # 7740 */
  if (V_curr_lex>0) {
    Ra.sl[24]=7742; /* line # 7742 */
    P_new_disp_level(Ra.v[13],4);
  }
  Ra.sl[24]=7746; /* line # 7746 */
  Ra.ub[40]=0;
  Ra.sl[24]=7747; /* line # 7747 */
  Ra.v[6]=NULL;
  Ra.sl[24]=7748; /* line # 7748 */
  Ra.v[1]=NULL;
  Ra.sl[24]=7749; /* line # 7749 */
  Rv0=NULL;
  Ra.sl[24]=7750; /* line # 7750 */
  Rv1=V_cntx_label;
  Ra.sl[24]=7751; /* line # 7751 */
  V_cntx_label=NULL;
  Ra.sl[24]=7752; /* line # 7752 */
  Rv2=Ra.v[13];
  Ra.sl[24]=7754; /* line # 7754 */
  ((V *)Rv2)[19]=NULL;
  Ra.sl[24]=7755; /* line # 7755 */
  ((V *)Rv2)[23]=NULL;
  Ra.sl[24]=7756; /* line # 7756 */
  ((V *)Rv2)[24]=NULL;
  Ra.sl[24]=7759; /* line # 7759 */
  P_compile_set_sbttl(Ra.v[13]);
  Ra.sl[24]=7761; /* line # 7761 */
  Ra.sl[24]=7763; /* line # 7763 */
  Ra.ub[16]=1;
  Ra.sl[24]=7764; /* line # 7764 */
  Ra.v[3]=NULL;
  while (1){
    Ra.sl[24]=7766; /* line # 7766 */
    V_pro_current=Ra.v[13];
    Ra.sl[24]=7767; /* line # 7767 */
    V_cprc_disp=V_curr_disp;
    Ra.sl[24]=7770; /* line # 7770 */
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043(1);
    Ra.sl[24]=7771; /* line # 7771 */
    switch (V_sy_sym.ub[0]) {
      case 28:Ra.sl[24]=7775; /* line # 7775 */
      P_insymbol();
      Ra.sl[24]=7776; /* line # 7776 */
      PAS_COMILER_PRC_00000044();
      break;
      case 29:Ra.sl[24]=7781; /* line # 7781 */
      P_insymbol();
      Ra.sl[24]=7782; /* line # 7782 */
      PAS_COMILER_PRC_00000045();
      break;
      case 30:Ra.sl[24]=7787; /* line # 7787 */
      if (V_sy_init_mod) {
        Ra.sl[24]=7788; /* line # 7788 */
        V_sy_var_init_mod=1;
      }
      Ra.sl[24]=7789; /* line # 7789 */
      P_insymbol();
      Ra.sl[24]=7790; /* line # 7790 */
      PAS_COMILER_PRC_00000046();
      Ra.sl[24]=7791; /* line # 7791 */
      if (V_sy_init_mod) {
        Ra.sl[24]=7792; /* line # 7792 */
        V_sy_var_init_mod=0;
      }
      break;
      case 32:Ra.sl[24]=7795; /* line # 7795 */
      PAS_COMILER_PRC_00000047();
      break;
      case 31:Ra.sl[24]=7797; /* line # 7797 */
      PAS_COMILER_PRC_00000048();
      break;
      case 76:
      case 77:Ra.sl[24]=7802; /* line # 7802 */
      PAS_COMILER_PRC_00000050();
      Ra.sl[24]=7803; /* line # 7803 */
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=7804; /* line # 7804 */
      V_cntx_varbl=((V *)Ra.v[13])[22];
      break;
      case 71:
      case 72:
      case 90:break;
      default:Ra.sl[24]=7810; /* line # 7810 */
      P_src_error(Rd.s+1320,91,2);
      Ra.sl[24]=7811; /* line # 7811 */
      P_insymbol();
      break;
    }
    if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==71)||V_sy_sym.ub[0]==72)  break;
  }
  Ra.sl[24]=7816; /* line # 7816 */
  if (V_curr_lex>0) {
    Ra.sl[24]=7817; /* line # 7817 */
    if (V_sy_sym.ub[0]==71) {
      Ra.sl[24]=7820; /* line # 7820 */
      P_ide_create_name(Rd.s+1324);
      Ra.sl[24]=7821; /* line # 7821 */
      P_ide_new_typ(21, &V_wildtmp_typ);
      Ra.sl[24]=7823; /* line # 7823 */
      ((SL *)V_wildtmp_typ)[11]=0;
      Ra.sl[24]=7824; /* line # 7824 */
      P_ide_new(5, V_wildtmp_typ, &V_wildtmp_ide);
      Ra.sl[24]=7825; /* line # 7825 */
      ((UW *)V_wildtmp_ide)[42]=96;
      Ra.sl[24]=7826; /* line # 7826 */
      V_wildtmp_psz=0;
      Ra.sl[24]=7827; /* line # 7827 */
      V_wildtmp_pal.ub[0]=0;
      Ra.sl[24]=7828; /* line # 7828 */
      V_wildtmp_stk=NULL;
      Ra.sl[24]=7830; /* line # 7830 */
      V_cntx_lblvl=0;
      Ra.sl[24]=7831; /* line # 7831 */
      V_cprc_disp=V_curr_disp;
      Ra.sl[24]=7832; /* line # 7832 */
      V_pro_current=Ra.v[13];
      Ra.sl[24]=7834; /* line # 7834 */
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=7836; /* line # 7836 */
      if (Ra.v[1]!=NULL) {
        Ra.sl[24]=7838; /* line # 7838 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=Ra.v[1];
        else {
          Ra.sl[24]=7839; /* line # 7839 */
          ((V *)Ra.v[13])[23]=Ra.v[1];
        }
        Ra.sl[24]=7840; /* line # 7840 */
        P_src_error(Rd.s+1320,92,3);
      }
      Ra.sl[24]=7844; /* line # 7844 */
      V_sy_label_flag=1;
      Ra.sl[24]=7846; /* line # 7846 */
      P_insymbol();
      Ra.sl[24]=7848; /* line # 7848 */
      Rv3=Ra.v[13];
      Ra.sl[24]=7851; /* line # 7851 */
      ((V *)Rv3)[16]=PAS_COMILER_PRC_00000035(72,0);
      Ra.sl[24]=7853; /* line # 7853 */
      if (((V *)Rv3)[11]!=NULL) {
        Ra.sl[24]=7854; /* line # 7854 */
        if (!Ra.ub[40]) P_src_error(Rd.s+1320,74,3);
      }
      Ra.sl[24]=7857; /* line # 7857 */
      if (((V *)Rv3)[18]!=NULL) {
        Ra.sl[24]=7859; /* line # 7859 */
        ((V *)((V *)Rv3)[17])[0]=((V *)Rv3)[16];
        Ra.sl[24]=7860; /* line # 7860 */
        ((V *)Rv3)[16]=((V *)Rv3)[18];
      }
      Ra.sl[24]=7862; /* line # 7862 */
      ((V *)Rv3)[17]=Ra.v[7];
      Ra.sl[24]=7866; /* line # 7866 */
      Rv4=((V *)Ra.v[13])[19];
      Ra.sl[24]=7867; /* line # 7867 */
      while (Rv4!=NULL){
        Ra.sl[24]=7869; /* line # 7869 */
        Rv5=Rv4;
        Ra.sl[24]=7871; /* line # 7871 */
        V_ope_table.v[((UB *)Rv5)[0]]=((V *)Rv5)[2];
        Ra.sl[24]=7875; /* line # 7875 */
        Rv6=((V *)Rv5)[1];
        Ra.sl[24]=7877; /* line # 7877 */
        PAS__DISPOSE(&Rv4);
        Ra.sl[24]=7878; /* line # 7878 */
        Rv4=Rv6;
      }
      Ra.sl[24]=7882; /* line # 7882 */
      V_sy_label_flag=0;
    }
  }
  Ra.sl[24]=7887; /* line # 7887 */
  if (((UB *)Ra.v[13])[104]>=5) {
    Ra.sl[24]=7889; /* line # 7889 */
    V_cntx_label=((V *)Ra.v[13])[20];
    Ra.sl[24]=7890; /* line # 7890 */
    while (V_cntx_label!=Rv1&&V_cntx_label!=NULL){
      Ra.sl[24]=7891; /* line # 7891 */
      Rv7=V_cntx_label;
      Ra.sl[24]=7893; /* line # 7893 */
      if (4&((UB *)Rv7)[54]) {
        Ra.sl[24]=7896; /* line # 7896 */
        if (!(16&((UB *)Rv7)[54])) P_src_error(Rd.s+1320,66,3);
      }
      Ra.sl[24]=7897; /* line # 7897 */
      V_cntx_label=((V *)Rv7)[7];
    }
  }
  Ra.sl[24]=7900; /* line # 7900 */
  V_cntx_label=Rv1;
  PAS__curr_cntx=Ra.v[9];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " cmp_init "  */
void P_cmp_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1331;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7920; /* line # 7920 */
  V_emergency_stop=0;
  Ra.sl[6]=7922; /* line # 7922 */
  P_insy_init();
  Ra.sl[6]=7924; /* line # 7924 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=7926; /* line # 7926 */
  V_opt_exec=0;
  Ra.sl[6]=7928; /* line # 7928 */
  V_cmp_cmpdbg=0;
  Ra.sl[6]=7930; /* line # 7930 */
  V_cmp_range=0;
  Ra.sl[6]=7931; /* line # 7931 */
  V_cmp_dynamic=0;
  Ra.sl[6]=7932; /* line # 7932 */
  V_cmp_genenv=0;
  Ra.sl[6]=7933; /* line # 7933 */
  V_cmp_listlvl=1;
  Ra.sl[6]=7934; /* line # 7934 */
  V_cmp_igenv=-1;
  Ra.sl[6]=7936; /* line # 7936 */
  V_cmp_macf=0;
  Ra.sl[6]=7937; /* line # 7937 */
  V_cmp_cobj=0;
  Ra.sl[6]=7938; /* line # 7938 */
  V_cmp_objf=0;
  Ra.sl[6]=7939; /* line # 7939 */
  V_cmp_bltt=0;
  Ra.sl[6]=7940; /* line # 7940 */
  V_cmp_opt=1;
  Ra.sl[6]=7941; /* line # 7941 */
  V_cmp_debugopt=0;
  Ra.sl[6]=7942; /* line # 7942 */
  V_cmp_debug=0;
  Ra.sl[6]=7943; /* line # 7943 */
  V_cmp_traceopt=5;
  Ra.sl[6]=7944; /* line # 7944 */
  V_cmp_trace=-1;
  Ra.sl[6]=7945; /* line # 7945 */
  V_cmp_tracecount=0;
  Ra.sl[6]=7946; /* line # 7946 */
  V_cmp_twicedclon=0;
  Ra.sl[6]=7948; /* line # 7948 */
  V_sy_init_mod=1;
  Ra.sl[6]=7949; /* line # 7949 */
  V_sy_generic_qmod=1;
  Ra.sl[6]=7950; /* line # 7950 */
  V_sy_var_init_mod=0;
  Ra.sl[6]=7952; /* line # 7952 */
  V_sy_casedef=0;
  Ra.sl[6]=7954; /* line # 7954 */
  P_insymbol();
  Ra.sl[6]=7956; /* line # 7956 */
  P_compile_set_title();
  Ra.sl[6]=7957; /* line # 7957 */
  P_compile_set_sbttl(V_lex_ident_tree.v[0]);
  Ra.sl[6]=7959; /* line # 7959 */
  P_generation_setting();
  Ra.sl[6]=7962; /* line # 7962 */
  P_cmp_block(V_lex_ident_tree.v[0],1,0);
  Ra.sl[6]=7964; /* line # 7964 */
  if (V_error_result!=0) {
    Ra.sl[6]=7965; /* line # 7965 */
    V_emergency_stop=1;
  }
  Ra.sl[6]=7967; /* line # 7967 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=7991; /* line # 7991 */
  V_cntx_procname=V_fptr_size;
  Ra.sl[6]=7992; /* line # 7992 */
  V_cntx_srcfname=V_cntx_procname+V_fptr_size;
  Ra.sl[6]=7993; /* line # 7993 */
  V_cntx_linenbr=V_cntx_srcfname+V_fptr_size;
  Ra.sl[6]=7994; /* line # 7994 */
  V_cntx_size=V_cntx_linenbr+V_inte_size;
  Ra.sl[6]=7995; /* line # 7995 */
  P_ide_new_typ(10, &V_cntx_typ);
  Ra.sl[6]=7996; /* line # 7996 */
  Rv0=V_cntx_typ;
  Ra.sl[6]=7998; /* line # 7998 */
  ((UB *)Rv0)[48]=((UB *)V_typ_std.v[5])[48];
  Ra.sl[6]=7999; /* line # 7999 */
  ((SL *)Rv0)[11]=V_cntx_size;
  Ra.sl[6]=8000; /* line # 8000 */
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=8001; /* line # 8001 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=8002; /* line # 8002 */
  ((V *)Rv0)[14]=NULL;
  Ra.sl[6]=8004; /* line # 8004 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  Ra.sl[6]=8005; /* line # 8005 */
  V_sy_init_mod=0;
  Ra.sl[6]=8006; /* line # 8006 */
  V_sy_generic_qmod=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_pass2 "  */
void PAS_COMILER_cmp_pass2(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1341;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8014; /* line # 8014 */
  Rv0=F_pr;
  Ra.sl[6]=8023; /* line # 8023 */
  P_lgt_pass1_complet(F_pr);
  Ra.sl[6]=8025; /* line # 8025 */
  if (V_cmp_macf) {
    Ra.sl[6]=8027; /* line # 8027 */
    P_lgt_dump_proc(F_pr);
    Ra.sl[6]=8028; /* line # 8028 */
    P_lst_page();
  }
  Ra.sl[6]=8033; /* line # 8033 */
  switch (((UB *)Rv0)[104]) {
    case 6:
    case 9:
    case 10:Ra.sl[6]=8039; /* line # 8039 */
    P_generate_code_p1(F_pr);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_compile "  */
UB P_cmp_compile(UB F_interactive){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;
  V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1352;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8063; /* line # 8063 */
  V_emergency_stop=0;
  Ra.sl[6]=8064; /* line # 8064 */
  Rv0=0;
  Ra.sl[6]=8066; /* line # 8066 */
  V_env_file=NULL;
  Ra.sl[6]=8067; /* line # 8067 */
  V_env_first=NULL;
  Ra.sl[6]=8068; /* line # 8068 */
  V_env_last=NULL;
  Ra.sl[6]=8070; /* line # 8070 */
  Ra.sl[6]=8072; /* line # 8072 */
  if (!V_emergency_stop) {
    Ra.sl[6]=8074; /* line # 8074 */
    P_compile_set_title();
    Ra.sl[6]=8080; /* line # 8080 */
    Rv1=V_src_control;
    Ra.sl[6]=8082; /* line # 8082 */
    ((SL *)Rv1)[7]=1;
    Ra.sl[6]=8083; /* line # 8083 */
    ((SL *)Rv1)[8]=V_cmp_listlvl;
    Ra.sl[6]=8087; /* line # 8087 */
    V_sy_ch=32;
    Ra.sl[6]=8088; /* line # 8088 */
    P_insymbol();
    Ra.sl[6]=8090; /* line # 8090 */
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=8092; /* line # 8092 */
    P_compile_set_sbttl(NULL);
    Ra.sl[6]=8094; /* line # 8094 */
    Rv2=PAS__NEW(245);
    Ra.sl[6]=8095; /* line # 8095 */
    V_pro_current=Rv2;
    Ra.sl[6]=8097; /* line # 8097 */
    if (V_sy_sym.ub[0]==15) {
      Ra.sl[6]=8100; /* line # 8100 */
      V_sy_sym.ub[0]=17;
      while (1){
        Ra.sl[6]=8102; /* line # 8102 */
        P_insymbol();
        Ra.sl[6]=8103; /* line # 8103 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=8105; /* line # 8105 */
          Rv3=P_level_search(V_attr_list);
          Ra.sl[6]=8106; /* line # 8106 */
          if (Rv3!=NULL) while (1){
            Ra.sl[6]=8108; /* line # 8108 */
            P_insymbol();
            Ra.sl[6]=8109; /* line # 8109 */
            switch (((UB *)Rv3)[54]) {
              case 18:Ra.sl[6]=8112; /* line # 8112 */
              if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1367,22,2);
              Ra.sl[6]=8113; /* line # 8113 */
              V_sy_sym.ub[0]=17;
              while (1){
                Ra.sl[6]=8115; /* line # 8115 */
                P_insymbol();
                Ra.sl[6]=8116; /* line # 8116 */
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[6]=8117; /* line # 8117 */
                  P_add_inherit_file(V_sy_string.s);
                }
                else {
                  Ra.sl[6]=8119; /* line # 8119 */
                  P_src_error(Rd.s+1367,58,3);
                }
                Ra.sl[6]=8120; /* line # 8120 */
                P_insymbol();
                if (V_sy_sym.ub[0]!=17)  break;
              }
              Ra.sl[6]=8122; /* line # 8122 */
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else {
                Ra.sl[6]=8123; /* line # 8123 */
                P_src_error(Rd.s+1367,23,2);
              }
              break;
              case 19:Ra.sl[6]=8128; /* line # 8128 */
              if (V_sy_sym.ub[0]==13) {
                Ra.sl[6]=8130; /* line # 8130 */
                P_insymbol();
                Ra.sl[6]=8131; /* line # 8131 */
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[6]=8133; /* line # 8133 */
                  Rv4=V_sy_string.ub[1];
                  V_env_file=PAS__NEW((SL)Rv4+2);
                  ((UB *)V_env_file)[0]=Rv4;
                  Ra.sl[6]=8134; /* line # 8134 */
                  PAS__STR_TO_STR(V_env_file,V_sy_string.s);
                  Ra.sl[6]=8135; /* line # 8135 */
                  V_cmp_genenv=1;
                  Ra.sl[6]=8136; /* line # 8136 */
                  V_cmp_igenv=0;
                  Ra.sl[6]=8137; /* line # 8137 */
                  P_insymbol();
                }
                else {
                  Ra.sl[6]=8138; /* line # 8138 */
                  P_src_error(Rd.s+1367,58,2);
                }
                Ra.sl[6]=8139; /* line # 8139 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else {
                  Ra.sl[6]=8140; /* line # 8140 */
                  P_src_error(Rd.s+1367,23,2);
                }
              }
              break;
              default:Ra.sl[6]=8145; /* line # 8145 */
              P_src_error_s(Rd.s+1367,3,1, V_sy_ident.s,NULL);
              break;
            }
            if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==17)||V_sy_sym.ub[0]==16)  break;
          }
        }
        else {
          Ra.sl[6]=8149; /* line # 8149 */
          P_src_error(Rd.s+1367,2,3);
        }
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=8151; /* line # 8151 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=8152; /* line # 8152 */
        P_src_error(Rd.s+1367,26,2);
      }
    }
    Ra.sl[6]=8155; /* line # 8155 */
    if (V_cmp_igenv>=0) V_cmp_genenv=1;
    else {
      Ra.sl[6]=8156; /* line # 8156 */
      V_cmp_genenv=0;
    }
    Ra.sl[6]=8158; /* line # 8158 */
    if (V_sy_sym.ub[0]==74) {
      Ra.sl[6]=8160; /* line # 8160 */
      P_insymbol();
      Ra.sl[6]=8161; /* line # 8161 */
      Rv0=1;
      Ra.sl[6]=8162; /* line # 8162 */
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=8164; /* line # 8164 */
        P_src_error(Rd.s+1367,93,4);
        Ra.sl[6]=8165; /* line # 8165 */
        V_emergency_stop=1;
      }
    }
    else {
      Ra.sl[6]=8169; /* line # 8169 */
      if (V_sy_sym.ub[0]==75) {
        Ra.sl[6]=8171; /* line # 8171 */
        P_insymbol();
        Ra.sl[6]=8172; /* line # 8172 */
        if (V_sy_sym.ub[0]!=0) {
          Ra.sl[6]=8174; /* line # 8174 */
          P_src_error(Rd.s+1367,93,4);
          Ra.sl[6]=8175; /* line # 8175 */
          V_emergency_stop=1;
        }
      }
      else {
        Ra.sl[6]=8179; /* line # 8179 */
        P_src_error(Rd.s+1367,94,4);
      }
    }
  }
  Ra.sl[6]=8182; /* line # 8182 */
  if (!V_emergency_stop) {
    Ra.sl[6]=8184; /* line # 8184 */
    Rv5=Rv2;
    Ra.sl[6]=8187; /* line # 8187 */
    V_curr_lex=V_curr_lex+1;
    Ra.sl[6]=8188; /* line # 8188 */
    P_new_disp_level(Rv2,4);
    Ra.sl[6]=8191; /* line # 8191 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    Ra.sl[6]=8193; /* line # 8193 */
    P_ide_new(9,NULL,&Rv6);
    Ra.sl[6]=8195; /* line # 8195 */
    ((V *)Rv5)[0]=NULL;
    Ra.sl[6]=8196; /* line # 8196 */
    ((V *)Rv5)[1]=NULL;
    Ra.sl[6]=8197; /* line # 8197 */
    ((UW *)Rv5)[8]=128;
    Ra.sl[6]=8198; /* line # 8198 */
    ((V *)Rv5)[3]=((V *)Rv6)[0];
    Ra.sl[6]=8199; /* line # 8199 */
    ((UB *)Rv5)[32]=29;
    Ra.sl[6]=8200; /* line # 8200 */
    ((V *)Rv5)[5]=Rv6;
    Ra.sl[6]=8201; /* line # 8201 */
    ((V *)Rv5)[6]=NULL;
    Ra.sl[6]=8202; /* line # 8202 */
    ((V *)Rv5)[7]=NULL;
    Ra.sl[6]=8203; /* line # 8203 */
    ((V *)Rv5)[8]=NULL;
    Ra.sl[6]=8204; /* line # 8204 */
    ((SL *)Rv5)[18]=0;
    Ra.sl[6]=8205; /* line # 8205 */
    ((SL *)Rv5)[19]=0;
    Ra.sl[6]=8206; /* line # 8206 */
    ((SL *)Rv5)[20]=0;
    Ra.sl[6]=8207; /* line # 8207 */
    ((V *)Rv5)[11]=NULL;
    Ra.sl[6]=8208; /* line # 8208 */
    ((V *)Rv5)[12]=NULL;
    Ra.sl[6]=8209; /* line # 8209 */
    if (Rv0) ((UB *)Rv5)[104]=7;
    else {
      Ra.sl[6]=8210; /* line # 8210 */
      ((UB *)Rv5)[104]=6;
    }
    Ra.sl[6]=8212; /* line # 8212 */
    ((V *)Rv5)[14]=NULL;
    Ra.sl[6]=8213; /* line # 8213 */
    ((V *)Rv5)[15]=NULL;
    Ra.sl[6]=8214; /* line # 8214 */
    ((V *)Rv5)[16]=NULL;
    Ra.sl[6]=8215; /* line # 8215 */
    ((V *)Rv5)[17]=NULL;
    Ra.sl[6]=8216; /* line # 8216 */
    ((V *)Rv5)[18]=NULL;
    Ra.sl[6]=8217; /* line # 8217 */
    ((V *)Rv5)[19]=NULL;
    Ra.sl[6]=8218; /* line # 8218 */
    ((V *)Rv5)[20]=NULL;
    Ra.sl[6]=8219; /* line # 8219 */
    ((V *)Rv5)[21]=NULL;
    Ra.sl[6]=8220; /* line # 8220 */
    ((V *)Rv5)[22]=NULL;
    Ra.sl[6]=8221; /* line # 8221 */
    ((V *)Rv5)[23]=NULL;
    Ra.sl[6]=8222; /* line # 8222 */
    ((V *)Rv5)[24]=NULL;
    Ra.sl[6]=8224; /* line # 8224 */
    ((V *)Rv5)[25]=NULL;
    Ra.sl[6]=8225; /* line # 8225 */
    ((V *)Rv5)[26]=NULL;
    Ra.sl[6]=8226; /* line # 8226 */
    ((V *)Rv5)[27]=NULL;
    Ra.sl[6]=8227; /* line # 8227 */
    ((SL *)Rv5)[56]=-1;
    Ra.sl[6]=8228; /* line # 8228 */
    ((SL *)Rv5)[57]=0;
    Ra.sl[6]=8229; /* line # 8229 */
    ((SL *)Rv5)[58]=0;
    Ra.sl[6]=8230; /* line # 8230 */
    ((SL *)Rv5)[59]=0;
    Ra.sl[6]=8231; /* line # 8231 */
    ((SL *)Rv5)[60]=0;
    Ra.sl[6]=8232; /* line # 8232 */
    ((UB *)Rv5)[244]=0;
    Ra.sl[6]=8234; /* line # 8234 */
    V_pas_main=Rv2;
    Ra.sl[6]=8235; /* line # 8235 */
    P_insymbol();
    Ra.sl[6]=8237; /* line # 8237 */
    P_compile_set_sbttl(V_pas_main);
    Ra.sl[6]=8239; /* line # 8239 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=8241; /* line # 8241 */
      V_sy_sym.ub[0]=17;
      Ra.sl[6]=8242; /* line # 8242 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[6]=8244; /* line # 8244 */
        P_insymbol();
        Ra.sl[6]=8245; /* line # 8245 */
        if (V_sy_sym.ub[0]==0) P_insymbol();
        else {
          Ra.sl[6]=8246; /* line # 8246 */
          P_src_error(Rd.s+1367,95,1);
        }
      }
      Ra.sl[6]=8248; /* line # 8248 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=8249; /* line # 8249 */
        P_src_error(Rd.s+1367,23,2);
      }
    }
    Ra.sl[6]=8251; /* line # 8251 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=8252; /* line # 8252 */
      P_src_error(Rd.s+1367,21,2);
    }
    Ra.sl[6]=8256; /* line # 8256 */
    if (V_env_first!=NULL) P_pas_read_env_file();
    Ra.sl[6]=8258; /* line # 8258 */
    if (V_cmp_debugopt) {
      Ra.sl[6]=8260; /* line # 8260 */
      V_cmp_debug=1;
      Ra.sl[6]=8261; /* line # 8261 */
      V_cmp_traceopt=1;
    }
    Ra.sl[6]=8264; /* line # 8264 */
    if (V_cmp_traceopt>0) {
      Ra.sl[6]=8266; /* line # 8266 */
      P_gen_cntxvar(Rv2,((V *)Rv6)[0]);
      Ra.sl[6]=8267; /* line # 8267 */
      V_cmp_trace=V_cmp_traceopt;
      Ra.sl[6]=8268; /* line # 8268 */
      Rv7=5;
    }
    else {
      Ra.sl[6]=8270; /* line # 8270 */
      Rv7=0;
    }
    Ra.sl[6]=8272; /* line # 8272 */
    P_cmp_block(Rv2,1, Rv7);
    Ra.sl[6]=8274; /* line # 8274 */
    if (V_cmp_trace>0&&!Rv0) {
      Ra.sl[6]=8276; /* line # 8276 */
      Rv8=Rv2;
      Ra.sl[6]=8277; /* line # 8277 */
      P_gen_linetrace(Rv2,((V *)Rv8)+16,((V *)Rv8)+17,6);
    }
    Ra.sl[6]=8279; /* line # 8279 */
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else {
      Ra.sl[6]=8280; /* line # 8280 */
      P_src_error(Rd.s+1367,54,2);
    }
    Ra.sl[6]=8281; /* line # 8281 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=8283; /* line # 8283 */
      if (V_sy_sym.ub[0]==0&&P_match(((V *)Rv6)[0],V_sy_ident.s)==0) {
        Ra.sl[6]=8284; /* line # 8284 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=8286; /* line # 8286 */
        P_src_error_s(Rd.s+1367,96,1, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[6]=8288; /* line # 8288 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else {
      Ra.sl[6]=8289; /* line # 8289 */
      P_src_error(Rd.s+1367,21,1);
    }
    Ra.sl[6]=8290; /* line # 8290 */
    if (V_sy_sym.ub[0]!=90) {
      Ra.sl[6]=8292; /* line # 8292 */
      P_src_error(Rd.s+1367,991,1);
      Ra.sl[6]=8293; /* line # 8293 */
      while (V_sy_sym.ub[0]!=90)
      P_insymbol();
    }
    else {
      Ra.sl[6]=8295; /* line # 8295 */
      P_src_end_of_line();
    }
    Ra.sl[6]=8296; /* line # 8296 */
    if (V_pro_last==NULL) V_pro_first=Rv2;
    else {
      Ra.sl[6]=8297; /* line # 8297 */
      ((V *)V_pro_last)[0]=Rv2;
    }
    Ra.sl[6]=8298; /* line # 8298 */
    V_pro_last=Rv2;
    Ra.sl[6]=8301; /* line # 8301 */
    if (V_error_result>1) {
      Ra.sl[6]=8302; /* line # 8302 */
      V_emergency_stop=1;
    }
    else {
      Ra.sl[6]=8305; /* line # 8305 */
      Rv9=Rv2;
      Ra.sl[6]=8306; /* line # 8306 */
      if (((V *)Rv9)[16]!=((V *)Rv9)[17]) {
        Ra.sl[6]=8308; /* line # 8308 */
        P_lgt_new(((V *)Rv9)+16,NULL,0,((V *)Rv9)[16]);
        Ra.sl[6]=8309; /* line # 8309 */
        ((UB *)((V *)Rv9)[16])[41]=2;
        Ra.sl[6]=8310; /* line # 8310 */
        ((V *)Rv9)[17]=((V *)Rv9)[16];
      }
      Ra.sl[6]=8312; /* line # 8312 */
      PAS_COMILER_cmp_pass2(Rv2);
    }
    Ra.sl[6]=8315; /* line # 8315 */
    if (V_cmp_macf) {
      Ra.sl[6]=8317; /* line # 8317 */
      P_lgt_dump_static(Rv2);
      Ra.sl[6]=8318; /* line # 8318 */
      P_lst_page();
    }
    Ra.sl[6]=8321; /* line # 8321 */
    if (V_error_result>1) V_emergency_stop=1;
    else {
      Ra.sl[6]=8324; /* line # 8324 */
      P_pas_write_env_file();
      Ra.sl[6]=8325; /* line # 8325 */
      P_generate_code_p2();
    }
  }
  Ra.sl[6]=8329; /* line # 8329 */
  Ret=V_error_result;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
