/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[6];

/* Define the local data section. */
static Blk( Rd, 1376 ) = {{
 15,  15, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  95, 116, 121, 112,
101,  62,  62,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,
 47,  83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,
 53,  45,  51,  47, 112,  99, 109, 112,  95,  99, 111, 109, 112,  46, 112,  97,
115,   4,   4,  69,  88,  80,  84,  10,  10, 101, 120, 112,  95, 103, 101, 110,
110, 117, 109,   4,   4,  69,  71,  67,  84,   9,   9,  97, 116, 116, 114,  95,
116, 121, 112, 101,   4,   4,  65,  84,  84,  89,   7,   7,  36, 115, 105, 110,
103, 108, 101,   7,   7,  36, 100, 111, 117,  98, 108, 101,   6,   6,  36,  97,
116, 116, 114,  95,  14,  14,  98, 117, 105, 108, 100,  95,  97, 114, 103,  95,
108, 105, 115, 116,   4,   4,  66,  65,  82,  71,  16,  16,  99,  97, 108, 108,
 95, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,   4,   4,  70,  67,
 65,  76,  18,  18,  99,  97, 108, 108,  95, 105, 110, 100, 105, 114, 101,  99,
116,  95, 112, 114, 111,  99,  12,  12,  99,  97, 108, 108,  95, 103, 101, 110,
101, 114, 105,  99,   4,   4,  67,  65,  76,  71,   9,   9, 111, 112, 101, 110,
 95,  99,  97, 108, 108,   4,   4,  79,  80,  69,  78,  14,  14, 114, 101,  97,
100, 119, 114, 105, 116, 101,  95,  99,  97, 108, 108,   4,   4,  82,  87,  73,
 79,  18,  18, 103, 101, 116,  95, 115, 116,  97, 116, 101,  95, 101, 102, 102,
 95, 108, 105, 115, 116,  15,  15, 117, 115, 101, 114,  95, 115, 116,  97, 116,
101,  95,  99,  97, 108, 108,   4,   4,  85,  83,  84,  65,   8,   8, 110, 101,
119,  95,  99,  97, 108, 108,   4,   4,  78,  69,  87,  67,  12,  12, 100, 105,
115, 112, 111, 115, 101,  95,  99,  97, 108, 108,   4,   4,  70,  82,  69,  69,
 20,  20, 103, 101, 110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,
 97, 116,  95, 115, 101, 116,   4,   4,  83,  65,  71,  82,  20,  20, 103, 101,
110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 116,
 97,  98,   4,   4,  84,  65,  71,  82,  20,  20, 103, 101, 110,  95, 108, 105,
115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 114, 101,  99,   4,   4,
 82,  65,  71,  82,  12,  12, 103, 101, 116,  95,  97, 103, 114, 101, 103,  97,
116, 101,   4,   4,  65,  71,  82,  69,  13,  13, 101, 120, 112,  95,  99, 111,
110, 115, 116,  95, 115, 101, 116,   4,   4,  67,  83,  69,  84,  11,  11, 103,
101, 116,  95, 112, 114, 111,  99, 114, 101, 102,   4,   4,  71,  80,  82,  79,
 15,  15, 101, 120, 112,  95, 103, 101, 110, 101, 114, 105,  99,  95, 114, 101,
102,   4,   4,  69,  88,  71,  69,  14,  14, 101, 120, 112,  95, 105, 100, 101,
110, 116, 105, 102, 105, 101, 114,   4,   4,  82,  70,  79,  66,   9,   9, 101,
120, 112,  95, 105, 110, 100, 105, 114,   4,   4,  73,  78,  68,  73,   9,   9,
101, 120, 112,  95, 102, 105, 101, 108, 100,   4,   4,  71,  70,  76,  68,   9,
  9, 101, 120, 112,  95, 105, 110, 100, 101, 120,   4,   4,  73,  78,  68,  88,
  7,   7, 101, 120, 112,  95, 117, 110,  97,   4,   4,  69,  88,  80,  82,   7,
  7, 101, 120, 112,  95, 112, 111, 119,   7,   7, 101, 120, 112,  95, 109, 117,
108,   7,   7, 101, 120, 112,  95,  97, 100, 100,   7,   7, 101, 120, 112,  95,
114, 101, 108,   7,   7, 101, 120, 112,  95,  97, 110, 100,  10,  10, 101, 120,
112, 114, 101, 115, 115, 105, 111, 110,  14,  14,  99,  97, 115, 101,  95, 119,
111, 114, 107,  95, 108, 105, 115, 116,   4,   4,  67,  65,  83,  68,  15,  15,
 99,  97, 115, 101,  95, 100, 101, 102, 105, 110, 105, 116, 105, 111, 110,  17,
 17, 115, 101, 116,  95,  97, 108, 105, 103, 110, 109, 101, 110, 116,  95, 115,
112,  99,   4,   4,  65,  76,  71,  78,  14,  14,  99, 111, 110, 102, 111, 114,
109,  97, 110, 116,  95, 100, 101, 102,   4,   4,  67,  78,  70,  65,   9,   9,
 97, 114, 114,  97, 121,  95, 100, 101, 102,   4,   4,  65,  82,  82,  89,   8,
  8, 116, 121, 112, 101,  95, 115, 112,  99,   4,   4,  84,  89,  80,  83,  18,
 18, 115, 101, 116,  95, 100, 101,  99, 108,  95,  97, 116, 116, 114, 105,  98,
117, 116, 101,   4,   4,  68,  65,  84,  84,  13,  13, 118,  97, 114,  98, 108,
 95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  86,  65,  82,  66,  10,  10,
 99, 111, 110, 115, 116,  95, 100, 101,  99, 108,   4,   4,  67,  79,  78,  68,
  9,   9, 116, 121, 112, 101,  95, 100, 101,  99, 108,   4,   4,  84,  89,  80,
 68,  10,  10, 118,  97, 114,  98, 108,  95, 100, 101,  99, 108,  10,  10, 108,
 97,  98, 101, 108,  95, 100, 101,  99, 108,   4,   4,  76,  65,  66,  68,  14,
 14, 115, 116,  97, 116, 101, 109, 101, 110, 116,  95, 100, 101,  99, 108,   4,
  4,  83,  84,  65,  68,  13,  13,  97, 114, 103, 117, 109, 101, 110, 116,  95,
108, 105, 115, 116,   4,   4,  65,  82,  71,  76,   3,   3,  46, 114, 118,  16,
 16, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,  95, 100, 101,  99,
108,   4,   4,  70,  80,  68,  69,  15,  15, 102, 111, 114, 109,  97, 108,  95,
112, 114, 111,  99,  95, 112, 116, 114,   4,   4,  70,  80,  68,  69,  18,  18,
105, 110, 115, 101, 114, 116,  95, 110, 101, 119,  95, 103, 101, 110, 101, 114,
105,  99,   4,   4,  73,  71,  69,  78,   9,   9, 112, 114, 111,  99,  95, 100,
101,  99, 108,   4,   4,  68,  80,  82,  79,   4,   4,  80,  82,  67,  95,   4,
  4,  80,  82,  67,  95,   9,   9, 112, 114, 111,  99,  95,  98, 111, 100, 121,
  4,   4,  71,  69,  78,  68,   9,   9, 103, 101, 110, 101,  95, 100, 101,  99,
108,  10,  10, 103, 101, 110,  95,  97, 115, 115, 105, 103, 110,   4,   4,  71,
 65,  83,  83,  12,  12, 114, 101, 116, 117, 114, 110,  95, 115, 116,  97, 116,
101,   4,   4,  82,  69,  84,  85,  16,  16,  97, 115, 115, 105, 103, 110, 109,
101, 110, 116,  95, 115, 116,  97, 116, 101,   4,   4,  65,  83,  83,  73,  10,
 10, 119, 105, 116, 104,  95, 115, 116,  97, 116, 101,   4,   4,  87,  73,  84,
 72,   8,   8, 105, 102,  95, 115, 116,  97, 116, 101,   4,   4,  73,  70,  83,
 84,  10,  10, 101, 120, 105, 116,  95, 115, 116,  97, 116, 101,   4,   4,  69,
 88,  83,  84,  10,  10, 108, 111, 111, 112,  95, 115, 116,  97, 116, 101,   4,
  4,  76,  79,  79,  80,   9,   9, 102, 111, 114,  95, 115, 116,  97, 116, 101,
  4,   4,  70,  79,  82,  95,  10,  10, 103, 111, 116, 111,  95, 115, 116,  97,
116, 101,   4,   4,  71,  84,  79,  76,  11,  11,  98, 101, 103, 105, 110,  95,
115, 116,  97, 116, 101,   4,   4,  66,  69,  71,  83,  12,  12, 108,  97,  98,
101, 108,  95,  97, 116, 116,  97,  99, 104,   9,   9, 115, 116,  97, 116, 101,
109, 101, 110, 116,   4,   4,  83,  84,  65,  84,   9,   9, 115, 116,  97, 116,
101, 108, 105, 115, 116,   4,   4,  83,  84,  76,  73,   9,   9,  99, 109, 112,
 95,  98, 108, 111,  99, 107,   4,   4,  66,  76,  79,  67,   5,   5,  46, 116,
101, 109, 112,   8,   8,  99, 109, 112,  95, 105, 110, 105, 116,   9,   9,  99,
109, 112,  95, 112,  97, 115, 115,  50,  11,  11,  99, 109, 112,  95,  99, 111,
109, 112, 105, 108, 101,   4,   4,  67,  77,  80,  77,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 64 ) = {{
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern Blk(V_typ_std, 248 );
extern UB V_cmp_range;
extern V V_curr_descr;
extern UB V_enm_range;
extern Blk(V_sy_sym, 8 );
extern V V_attr_list;
extern Blk(V_sy_ident, 32 );
extern V V_ima_typ;
extern V V_int_typ;
extern Blk(V_ide_udptr, 120 );
extern V V_iof_std_open;
extern UB V_sy_label_flag;
extern SL V_dst_seti;
extern SL V_dst_seta;
extern SL V_dst_setw;
extern V V_set_entry_proc;
extern SL V_stri_stroffset;
extern V V_sy_search;
extern UB V_lastsymb;
extern Blk(V_lex_ident_tree, 4160 );
extern SL V_ident_disp;
extern SL V_sy_ival;
extern G V_sy_rval;
extern Blk(V_sy_string, 264 );
extern SL V_curr_disp;
extern UB V_sy_casedef;
extern UB V_err_prt;
extern V V_sy_type_gfirst;
extern UB V_sy_init_mod;
extern UB V_sy_fix_range_ctl;
extern SL V_fptr_size;
extern SL V_stri_descrsz;
extern SL V_stri_lengthsz;
extern V V_usi_tab;
extern V V_csi_tab;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;
extern SL V_inte_size;
extern V V_uns_typ;
extern SL V_sngl_size;
extern SL V_dble_size;
extern UB V_tcas_flag;
extern SL V_curr_lex;
extern UB V_error_result;
extern UB V_cmp_dynamic;
extern Blk(V_lex_ident_level, 128 );
extern UB V_sy_generic_qmod;
extern V V_pro_d_first;
extern V V_pro_d_last;
extern Blk(V_opname, 960 );
extern SL V_proc_seq;
extern SL V_cmp_traceopt;
extern SL V_cmp_trace;
extern UB V_cmp_objf;
extern V V_pro_last;
extern V V_pro_first;
extern V V_new_entry_proc;
extern V V_newh_entry_proc;
extern V V_dispose_entry_proc;
extern V V_iof_std_close;
extern V V_inp_std_sel;
extern V V_inp_std_gene;
extern V V_inp_std_eoln;
extern V V_inp_std_bin;
extern V V_out_std_sel;
extern V V_out_std_gene;
extern V V_out_std_eoln;
extern V V_out_std_bin;
extern V V_gen_std_string1;
extern V V_gen_std_cnfardsc;
extern Blk(V_ope_table, 240 );
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_wildtmp_stk;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_src_control;
extern UB V_emergency_stop;
extern V V_pro_current;
extern SL V_cprc_disp;
extern UB V_sy_var_init_mod;
extern V V_cntx_varbl;
extern V V_wildtmp_typ;
extern V V_wildtmp_ide;
extern SL V_wildtmp_psz;
extern Blk(V_wildtmp_pal, 8 );
extern UB V_opt_exec;
extern UB V_cmp_cmpdbg;
extern UB V_cmp_genenv;
extern SL V_cmp_listlvl;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern UB V_cmp_bltt;
extern UB V_cmp_opt;
extern UB V_cmp_debugopt;
extern UB V_cmp_debug;
extern SL V_cmp_tracecount;
extern SL V_cntx_procname;
extern SL V_cntx_srcfname;
extern SL V_cntx_linenbr;
extern SL V_cntx_size;
extern V V_cntx_typ;
extern V V_env_file;
extern V V_env_first;
extern V V_env_last;
extern C V_sy_ch;
extern V V_pas_main;


/* Function/procedure prototypes. */
void P_lst_page();
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_search_char();
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_data_format_set(V F_ty);
V P_tab_new(SL F_sz);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_all_free(V F_p);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
SL P_lgt_get_econst(V F_lgt, SL F_idf);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2);
void P_new_disp_level(V F_ow, UB F_kind);
void P_ide_reserve_disp(SL F_prv);
SL P_match(V F_s1, V F_s2);
V P_new_int_name(V F_head, SL *F_nbs);
V P_level_search(V F_fp);
V P_lex_search(SL F_disp);
V P_ide_search(UW F_fs);
void P_ide_new(UB F_fc, V F_ty, V *F_ip);
void P_gen_cntxvar(V F_pr, V F_id);
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd);
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd);
void P_label_purge(V *F_prv_cntx);
SL P_typ_alignement(SL F_iaddr, V F_aln);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_cte_allocate(V F_vp, V F_id);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ);
void P_tmpstk_free(V F_stkp);
void P_free_typ_list(V *F_p);
void P_free_ide_list(V *F_p);
void P_ide_create_name(V F_name);
void P_ide_int_label();
V P_ide_search_from_nameid(V F_ip);
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach);
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2);
void P_compile_set_title();
void P_compile_set_sbttl(V F_prc);
void P_insymbol();
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rflg);
void P_insy_init();
void P_set_strname(V *F_nam);
void P_set_stdname(V F_pr);
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent);
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count);
void P_type_parm_cte_release(V F_ty);
void P_string_in_array(V F_lgt, V F_ty);
void P_string_in_substring(V F_lgt, V F_ty);
void P_call_setting(V *F_lgt);
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst);
V P_exp_genoper(V F_id, V F_p, V F_oblst);
V P_exp_genop(UB F_op, V F_oblst);
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
void P_initialize_varbl(V F_ip);
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide);
void P_init_d_varbl(V F_ip);
void P_type_check_parm(V F_lgt);
V P_type_parm_set(V F_ip, V F_lgt);
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void P_lgt_gen_routine(V F_ty);
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj);
void P_lgt_extract_simple_cte(V F_lgt);
void P_lgt_all_fparm(V F_pr);
void P_lgt_pass1_complet(V F_pr);
void P_lgt_dump_proc(V F_pr);
void P_lgt_dump_static(V F_pr);
void P_generation_setting();
void P_generate_code_p1(V F_proc);
void P_generate_code_p2();
void P_add_inherit_file(V F_fenv);
void P_pas_read_env_file();
void P_pas_write_env_file();
void PAS_COMILER_cmp_pass2(V F_pr);
V PAS_COMILER_PRC_00000000();
V PAS_COMILER_PRC_00000001(UB F_isfunction);
V PAS_COMILER_PRC_00000002(UB F_isfunction, V F_owid);
V PAS_COMILER_PRC_00000019(V F_ty);
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg);
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ);
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty);
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg, V F_owid);


/* Procedure/Function : " expression_type "  */
V PAS_COMILER_PRC_00000005(V F_it, UB F_exact, UB F_no_def, UB F_no_check){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  C Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=186; /* line # 186 */
  Rv0=0;
  Rv1=PAS_COMILER_PRC_00000000();
  if (Rv1!=NULL) {
    Rv2=Rv1;
    Rv3=F_it;
    if (((V *)Rv2)[3]!=F_it) {
      Ra.sl[6]=192; /* line # 192 */
      if (((UB *)Rv2)[40]==14) {
        if (((V *)Rv2)[3]==V_typ_std.v[13]&&P_comp_type(((V *)Rv2)[3],F_it,0,0))
         {
          ((V *)Rv2)[3]=F_it;
          Rv0=1;
        }
        else {
          Ra.sl[6]=197; /* line # 197 */
          if (P_comp_type(((V *)Rv2)[3],V_typ_std.v[10],0,0)||P_comp_type(((V *)
          Rv2)[3],V_typ_std.v[0],1,0)) {
            if ((((UB *)Rv3)[93]==10&&((UB *)((V *)Rv2)[3])[93]==0)&&P_comp_type((
            (V *)Rv2)[3],F_it, F_exact,0)) {
              Ra.sl[6]=204; /* line # 204 */
              if (((V *)Rv2)[7]!=NULL) Rv4=(C)((SL *)((V *)Rv2)[7])[13];
              else Rv4=32;
              P_val_free(((V *)Rv2)+7);
              P_val_new(((V *)Rv2)+7,V_typ_std.v[10]);
              ((V *)Rv2)[3]=V_typ_std.v[10];
              Rv5=((V *)Rv2)[7];
              Ra.sl[6]=210; /* line # 210 */
              ((UB *)Rv5)[48]=29;
              ((SL *)Rv5)[6]=1;
              ((V *)Rv5)[7]=PAS__NEW(3);
              ((UB *)((V *)Rv5)[7])[0]=1;
              PAS__CHA_TO_STR(((V *)Rv5)[7],Rv4);
              Ra.sl[6]=215; /* line # 215 */
              Rv0=1;
            }
            else {
              if (((UB *)Rv3)[93]==8&&((V *)Rv3)[14]==V_typ_std.v[0]) {
                Ra.sl[6]=221; /* line # 221 */
                P_string_in_array(Rv1, F_it);
                Rv0=1;
              }
              else {
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=227; /* line # 227 */
                  P_string_in_substring(Rv1, F_it);
                  Rv0=1;
                }
              }
            }
          }
          else {
            Ra.sl[6]=232; /* line # 232 */
            if (((V *)((V *)Rv2)[3])[0]==F_it) Rv0=1;
            else switch (((UB *)Rv3)[93]) {
              case 0:
              case 1:
              case 2:if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                Ra.sl[6]=238; /* line # 238 */
                if (((V *)Rv2)[7]!=NULL) {
                  Rv6=((V *)Rv2)[7];
                  if (((UB *)Rv3)[112]) {
                    Ra.sl[6]=243; /* line # 243 */
                    if (((UL *)Rv3)[29]<=((UL *)Rv6)[13]&&((UL *)Rv3)[30]>=((UL *)
                    Rv6)[13]) {
                      ((V *)Rv2)[3]=F_it;
                      ((V *)Rv6)[4]=F_it;
                      Rv0=1;
                    }
                  }
                  else {
                    if (((SL *)Rv3)[29]<=((SL *)Rv6)[13]&&((SL *)Rv3)[30]>=((SL *)
                    Rv6)[13]) {
                      Ra.sl[6]=248; /* line # 248 */
                      ((V *)Rv2)[3]=F_it;
                      ((V *)Rv6)[4]=F_it;
                      Rv0=1;
                    }
                  }
                  if (!Rv0) P_src_error(Rd.s+83,154,2);
                }
              }
              break;
              case 22:Ra.sl[6]=254; /* line # 254 */
              if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                if (((V *)Rv2)[7]!=NULL) {
                  Rv7=((V *)Rv2)[7];
                  if (((SL *)((V *)Rv2)[3])[11]<=((SL *)Rv3)[11]) {
                    Ra.sl[6]=260; /* line # 260 */
                    ((V *)Rv2)[3]=F_it;
                    ((V *)Rv7)[4]=F_it;
                    if (V_cmp_range&&!F_no_check) {
                      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
                      Ra.sl[6]=266; /* line # 266 */
                      ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,
                      NULL,0);
                      ((V *)Rv1)[0]=Rv8;
                      Rv1=P_lgt_new_code(2, Rv1);
                      ((V *)Rv1)[3]=F_it;
                    }
                    Ra.sl[6]=271; /* line # 271 */
                    Rv0=1;
                  }
                }
              }
              break;
              case 3:
              case 4:Rv9=((V *)Rv2)[7];
              Ra.sl[6]=277; /* line # 277 */
              if (((V *)Rv2)[3]!=NULL) switch (((UB *)((V *)Rv2)[3])[93]) {
                case 2:((G *)Rv9)[7]=(double)((SL *)Rv9)[13];
                Rv0=1;
                break;
                case 3:
                case 4:Rv0=1;
                break;
                default:break;
              }
              Ra.sl[6]=283; /* line # 283 */
              if (Rv0) {
                ((UB *)Rv9)[48]=((UB *)Rv3)[93];
                ((V *)Rv9)[4]=F_it;
                ((V *)Rv2)[3]=F_it;
              }
              break;
              default:break;
            }
          }
        }
      }
      Ra.sl[6]=300; /* line # 300 */
      if (!Rv0) {
        if (!P_comp_type(((V *)Rv2)[3],F_it, F_exact,0)) {
          P_src_error(Rd.s+83,109,3);
          ((V *)Rv1)[3]=F_it;
        }
        else {
          Ra.sl[6]=307; /* line # 307 */
          if (V_cmp_range&&!F_no_check) switch (((UB *)Rv3)[93]) {
            case 0:
            case 1:
            case 2:if (V_enm_range) {
              Ra.sl[6]=312; /* line # 312 */
              Rv8=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[29]);
              ((V *)Rv8)[0]=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[30]);
              ((V *)Rv1)[0]=Rv8;
              Rv1=P_lgt_new_code(2, Rv1);
              ((V *)Rv1)[3]=F_it;
            }
            break;
            case 22:Ra.sl[6]=321; /* line # 321 */
            Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
            ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,NULL,0);
            ((V *)Rv1)[0]=Rv8;
            Rv1=P_lgt_new_code(2, Rv1);
            ((V *)Rv1)[3]=F_it;
            break;
            default:break;
          }
        }
      }
    }
  }
  Ra.sl[6]=331; /* line # 331 */
  if (F_no_def) {
    if (((UB *)Rv1)[40]==17) P_src_error(Rd.s+83,181,2);
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_gennum "  */
SL PAS_COMILER_PRC_00000006(V *F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+87;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=348; /* line # 348 */
  Rv0=PAS_COMILER_PRC_00000005((*F_ty),0,0,0);
  Rv1=Rv0;
  (*F_ty)=((V *)Rv1)[3];
  if (((UB *)Rv1)[40]==14) {
    Ra.sl[6]=353; /* line # 353 */
    Ret=((SL *)((V *)Rv1)[7])[13];
  }
  else {
    P_src_error(Rd.s+101,853,2);
    Ret=((SL *)(*F_ty))[29];
  }
  Ra.sl[6]=360; /* line # 360 */
  P_lgt_free_tree(&Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " attr_type "  */
V PAS_COMILER_PRC_00000007(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=31;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+105;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=385; /* line # 385 */
  Rv0=NULL;
  Rv1=F_ty;
  P_insymbol();
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[16]=391; /* line # 391 */
    Rv2=P_level_search(V_attr_list);
    if (Rv2==NULL) P_src_error_s(Rd.s+118,105,3, V_sy_ident.s,NULL);
    else switch (((UB *)Rv2)[54]) {
      case 0:Ra.sl[16]=402; /* line # 402 */
      if (F_lgt==NULL) P_src_error_s(Rd.s+118,161,3, V_sy_ident.s,NULL);
      P_lgt_new(&Rv0, V_typ_std.v[13],4, F_lgt);
      F_lgt=NULL;
      break;
      case 1:Ra.sl[16]=408; /* line # 408 */
      if (((SL *)Rv1)[11]>=0) Rv0=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[11]
      );
      else {
        Rv0=P_lgt_type_compute(((V *)Rv1)[8],((V *)Rv1)[9],((SL *)Rv1)[11],F_lgt);
        Ra.sl[16]=413; /* line # 413 */
        if (F_lgt!=NULL) {
          if (((UB *)F_lgt)[40]!=14) F_lgt=NULL;
        }
      }
      break;
      case 8:
      case 9:Ra.sl[16]=421; /* line # 421 */
      if (P_comp_type(F_ty, V_typ_std.v[10],1,0)) F_ty=((V *)((V *)F_ty)[13])[5]
      ;
      switch (((UB *)F_ty)[93]) {
        case 8:
        case 9:Rv3=((V *)F_ty)[15];
        Ra.sl[16]=426; /* line # 426 */
        if (((UB *)Rv3)[93]==22) {
          if (((UB *)Rv2)[54]==8) Rv0=((V *)Rv3)[13];
          else Rv0=((V *)Rv3)[14];
          Ra.sl[16]=435; /* line # 435 */
          Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
          ((V *)Rv0)[3]=((V *)Rv3)[0];
        }
        else {
          Ra.sl[16]=440; /* line # 440 */
          if (((UB *)Rv2)[54]==8) Rv4=((SL *)Rv3)[29];
          else Rv4=((SL *)Rv3)[30];
          Rv0=P_lgt_new_econst(((V *)F_ty)[15],Rv4);
        }
        break;
        default:Ra.sl[16]=445; /* line # 445 */
        P_src_error(Rd.s+118,158,3);
        Rv0=P_lgt_new_econst(V_typ_std.v[15],1);
        break;
      }
      break;
      case 2:
      case 3:Ra.sl[16]=452; /* line # 452 */
      if (((UB *)Rv1)[93]<=2) {
        if (((UB *)Rv2)[54]==2) Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[29]);
        else Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[30]);
      }
      else {
        if (((UB *)Rv1)[93]==22) {
          Ra.sl[16]=458; /* line # 458 */
          if (((UB *)Rv2)[54]==2) Rv0=((V *)Rv1)[13];
          else Rv0=((V *)Rv1)[14];
          Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
        }
      }
      break;
      case 4:Ra.sl[16]=464; /* line # 464 */
      if (F_lgt!=NULL) {
        ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Rv0=P_exp_genop(11, F_lgt);
        F_lgt=NULL;
      }
      break;
      case 5:Ra.sl[16]=471; /* line # 471 */
      if (F_lgt!=NULL) {
        ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Rv0=P_exp_genop(12, F_lgt);
        F_lgt=NULL;
      }
      break;
      case 6:Ra.sl[16]=478; /* line # 478 */
      switch (((UB *)Rv1)[93]) {
        case 1:if (F_lgt==NULL) Rv0=P_lgt_link(((V *)Rv1)[13]);
        else {
          Ra.sl[16]=485; /* line # 485 */
          P_lgt_new(&Rv0,((V *)V_ima_typ)[14],1, P_lgt_link(((V *)Rv1)[13]));
          ((V *)((V *)Rv0)[1])[0]=F_lgt;
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_int_typ,((SL *)((V *)((V *)Rv1)[13]
          )[3])[25]);
        }
        break;
        case 11:
        case 12:Ra.sl[16]=492; /* line # 492 */
        if (((V *)Rv1)[13]!=NULL) {
          Rv5=((V *)Rv1)[13];
          if (F_lgt==NULL) {
            Ra.sl[16]=497; /* line # 497 */
            if (((V *)Rv5)[13]==NULL) Rv0=P_lgt_link(((V *)Rv5)[13]);
          }
        }
        break;
        default:break;
      }
      break;
      case 7:Ra.sl[16]=506; /* line # 506 */
      if (F_ty==V_typ_std.v[7]) Rv4=0;
      else {
        if (((UB *)Rv1)[93]==7&&((V *)Rv1)[12]!=NULL) Rv4=((SL *)((V *)Rv1)[12])
        [11];
        else Rv4=2147483647;
      }
      Rv0=P_lgt_new_econst(V_typ_std.v[2],Rv4);
      break;
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:Ra.sl[16]=519; /* line # 519 */
      Ra.ub[1]=0;
      switch (((UB *)Rv1)[93]) {
        case 3:Ra.sl[16]=524; /* line # 524 */
        PAS__VWRITE_INIT(Ra.s,1);
        PAS__WRITE_STR(Rd.s+122,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 4:PAS__VWRITE_INIT(Ra.s,1);
        PAS__WRITE_STR(Rd.s+131,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        default:break;
      }
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_STR(Rd.s+140,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[16]=529; /* line # 529 */
      Rv6=((V *)Rv2)[0];
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
      PAS__WRITE_EOLN();
      P_ide_create_name(Ra.s);
      Rv7=P_lex_search(0);
      Ra.sl[16]=534; /* line # 534 */
      if (Rv7!=NULL) {
        Rv8=Rv7;
        if (((UB *)Rv8)[53]==4) {
          P_lgt_new(&Rv0,((V *)Rv8)[5],14,NULL);
          Ra.sl[16]=539; /* line # 539 */
          Rv9=Rv0;
          ((V *)Rv9)[7]=((V *)Rv8)[7];
          P_val_new(((V *)Rv9)+7,((V *)Rv8)[5]);
        }
      }
      Ra.sl[16]=545; /* line # 545 */
      if (Rv0==NULL) {
        Rv0=P_lgt_new_econst(V_typ_std.v[2],0);
        P_src_error_s(Rd.s+118,164,2,((V *)Rv2)[0],NULL);
      }
      break;
      case 16:Ra.sl[16]=553; /* line # 553 */
      if (((UB *)Rv1)[93]==11||((UB *)Rv1)[93]==12) Rv0=P_lgt_new_econst(V_int_typ,(
      (SL *)Rv1)[24]);
      break;
      default:break;
    }
    Ra.sl[16]=558; /* line # 558 */
    P_insymbol();
  }
  else P_src_error(Rd.s+118,162,2);
  Ra.sl[16]=564; /* line # 564 */
  if (F_lgt!=NULL) P_lgt_free(&F_lgt);
  if (Rv0!=NULL) Ret=Rv0;
  else {
    P_src_error(Rd.s+118,169,2);
    Ra.sl[16]=569; /* line # 569 */
    Ret=P_lgt_new_econst(V_typ_std.v[2],1);
  }
  PAS__curr_cntx=Ra.v[5];
  return(Ret);
}


/* Procedure/Function : " build_arg_list "  */
V PAS_COMILER_PRC_00000008(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+148;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=589; /* line # 589 */
  Rv0=F_pr;
  Rv1=NULL;
  Rv2=((V *)Rv0)[8];
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[6]=594; /* line # 594 */
    if (!((UB *)((V *)Rv0)[11])[92]) Rv2=((V *)Rv2)[3];
  }
  if (Rv2!=NULL) {
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+166,22,2);
    else P_insymbol();
    Ra.sl[6]=599; /* line # 599 */
    while (Rv2!=NULL){
      if (((UB *)Rv2)[53]==7) {
        Rv3=0;
        Ra.sl[6]=604; /* line # 604 */
        Rv4=((V *)Rv2)[8];
        if (V_sy_sym.ub[0]==0) {
          Rv5=P_ide_search(928);
          if (Rv5!=V_ide_udptr.v[5]) {
            Ra.sl[6]=611; /* line # 611 */
            Rv6=Rv5;
            if (((UB *)Rv6)[53]==5) {
              Rv7=NULL;
              Ra.sl[6]=616; /* line # 616 */
              if (((V *)Rv6)[5]!=NULL) {
                Rv8=((V *)Rv6)[5];
                if (((UB *)Rv8)[93]==6) Rv7=((V *)Rv8)[13];
              }
              if (Rv7!=NULL) {
                Ra.sl[6]=621; /* line # 621 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else P_src_error_s(Rd.s+166,120,3, V_sy_ident.s,NULL);
                }
              }
            }
            else {
              Ra.sl[6]=627; /* line # 627 */
              if (((UB *)Rv6)[53]==7) {
                Rv7=((V *)Rv6)[8];
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=632; /* line # 632 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else P_src_error_s(Rd.s+166,121,3, V_sy_ident.s,NULL);
                }
              }
              else {
                Ra.sl[6]=638; /* line # 638 */
                Rv9=P_compare_proc_argid(((V *)Rv5)[10],((V *)Rv5)[11],Rv4);
                Ra.sl[6]=643; /* line # 643 */
                Rv9=((V *)Rv5)[10];
                while (Rv9!=NULL&&!Rv3){
                  Rv10=Rv9;
                  Ra.sl[6]=648; /* line # 648 */
                  if (!((UB *)Rv10)[8]) {
                    Rv7=((V *)Rv10)[2];
                    Rv3=P_comp_proc_arg(Rv7, Rv4);
                  }
                  Ra.sl[6]=653; /* line # 653 */
                  Rv9=((V *)Rv10)[0];
                }
                if (!Rv3) P_src_error_s(Rd.s+166,122,3, V_sy_ident.s,((V *)Rv2)[
0]);
              }
            }
          }
          Ra.sl[6]=658; /* line # 658 */
          P_insymbol();
        }
        else {
          Rv7=((V *)Rv2)[7];
          Ra.sl[6]=663; /* line # 663 */
          if (Rv7==NULL) P_src_error_s(Rd.s+166,148,3,((V *)Rv2)[0],NULL);
          else {
            if (Rv4!=NULL) Rv3=P_comp_proc_arg(Rv7, Rv4);
            else P_src_error_s(Rd.s+166,123,3,((V *)Rv2)[0],NULL);
          }
        }
        Ra.sl[6]=669; /* line # 669 */
        if (Rv3) {
          P_lgt_new(&Rv11,((V *)Rv7)[11],11,NULL);
          ((V *)Rv11)[6]=Rv7;
          if (((V *)Rv7)[11]!=((V *)Rv4)[11]&&((V *)Rv4)[11]!=NULL) {
            Ra.sl[6]=674; /* line # 674 */
            if (!P_comp_type(((V *)Rv7)[11],((V *)Rv4)[11],1,0)) P_src_error_s(Rd
            .s+166,124,3,((V *)Rv5)[0],((V *)Rv2)[0]);
          }
        }
      }
      else {
        Ra.sl[6]=680; /* line # 680 */
        Rv11=PAS_COMILER_PRC_00000005(((V *)Rv2)[5],((UB *)Rv2)[86]!=9,0,0);
        Rv12=Rv11;
        if (((UB *)Rv12)[40]==17) {
          if (((V *)Rv2)[7]==NULL) {
            Ra.sl[6]=685; /* line # 685 */
            P_src_error_s(Rd.s+166,854,3,((V *)Rv2)[0],NULL);
          }
          else {
            ((UB *)Rv12)[40]=14;
            ((V *)Rv12)[3]=((V *)Rv2)[5];
            Ra.sl[6]=690; /* line # 690 */
            ((V *)Rv12)[7]=((V *)Rv2)[7];
            P_val_new(((V *)Rv12)+7,NULL);
            ((V *)Rv12)[4]=NULL;
          }
        }
      }
      Ra.sl[6]=697; /* line # 697 */
      if (Rv1!=NULL) ((V *)Rv13)[0]=Rv11;
      else Rv1=Rv11;
      Rv13=Rv11;
      Rv2=((V *)Rv2)[3];
      Ra.sl[6]=702; /* line # 702 */
      if (V_sy_sym.ub[0]==17) P_insymbol();
    }
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else P_src_error(Rd.s+166,23,3);
  }
  Ra.sl[6]=708; /* line # 708 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_formal_proc "  */
V PAS_COMILER_PRC_00000009(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=724; /* line # 724 */
  Rv0=F_ip;
  switch (((UB *)Rv0)[53]) {
    case 7:Rv1=((V *)F_ip)[8];
    break;
    case 8:Ra.sl[6]=731; /* line # 731 */
    Rv1=((V *)((V *)Rv0)[10])[2];
    break;
    default:Rv1=NULL;
    break;
  }
  Ra.sl[6]=737; /* line # 737 */
  if (Rv1!=NULL) {
    Rv2=PAS_COMILER_PRC_00000008(Rv1);
    Rv2=P_lgt_new_call(((V *)Rv1)[11],Rv1, Rv2);
    Ra.sl[6]=742; /* line # 742 */
    P_call_setting(&Rv2);
  }
  else {
    P_src_error(Rd.s+190,998,3);
    Ra.sl[6]=747; /* line # 747 */
    Rv2=NULL;
  }
  if (Rv2==NULL) Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  else {
    Ra.sl[6]=753; /* line # 753 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      P_src_error(Rd.s+190,73,3);
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=758; /* line # 758 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_indirect_proc "  */
V PAS_COMILER_PRC_00000010(V F_lge){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=772; /* line # 772 */
  Rv0=NULL;
  if (F_lge!=NULL) {
    Rv1=F_lge;
    Rv2=((V *)Rv1)[3];
    Rv3=((V *)Rv2)[13];
    Ra.sl[6]=777; /* line # 777 */
    if (Rv3!=NULL) {
      Rv4=Rv3;
      ((V *)F_lge)[0]=PAS_COMILER_PRC_00000008(Rv3);
      P_lgt_new(&Rv0,((V *)Rv4)[11],7, F_lge);
      Ra.sl[6]=782; /* line # 782 */
      Rv5=Rv0;
      if (((V *)Rv4)[11]!=NULL) {
        if (!((UB *)((V *)Rv4)[11])[92]) {
          Ra.sl[6]=787; /* line # 787 */
          ((UW *)Rv5)[10]=((UW *)Rv5)[10]|4;
        }
      }
      else((V *)Rv0)[3]=V_typ_std.v[28];
      ((V *)Rv5)[6]=Rv3;
    }
  }
  Ra.sl[6]=794; /* line # 794 */
  if (Rv0==NULL) Rv0=P_lgt_new_econst(V_typ_std.v[21],0);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_generic "  */
V PAS_COMILER_PRC_00000011(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+214;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=812; /* line # 812 */
  Rv0=NULL;
  Rv1=0;
  Ra.sl[6]=817; /* line # 817 */
  if (V_sy_sym.ub[0]==13) {
    while (1){
      P_insymbol();
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=823; /* line # 823 */
      if (Rv0==NULL) Rv0=Rv2;
      else((V *)Rv3)[0]=Rv2;
      Rv3=Rv2;
      Rv1=Rv1+1;
      if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) P_src_error(Rd.s+230,24,2);
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=829; /* line # 829 */
    P_insymbol();
  }
  Rv2=P_generate_call(F_ip, Rv0, Rv1,0);
  if (Rv2==NULL) {
    Ra.sl[6]=835; /* line # 835 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      P_src_error(Rd.s+230,73,3);
      Ra.sl[6]=840; /* line # 840 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " open_call "  */
V PAS_COMILER_PRC_00000012(SL F_ifnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+234;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=863; /* line # 863 */
  Rv0=NULL;
  Rv1=P_ide_search_from_nameid(V_iof_std_open);
  if (Rv1!=NULL) {
    Ra.sl[6]=868; /* line # 868 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else P_src_error(Rd.s+247,22,2);
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[16],0,0,0);
    Ra.sl[6]=873; /* line # 873 */
    Rv3=((V *)((V *)Rv2)[3])[12];
    if (((V *)Rv2)[3]==V_typ_std.v[7]) Rv4=0;
    else {
      Ra.sl[6]=878; /* line # 878 */
      if (Rv3!=NULL) Rv4=abs(((SL *)Rv3)[11]);
      if (Rv4==0) Rv4=1;
    }
    Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv4);
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=883; /* line # 883 */
    Rv6=2;
    switch (F_ifnc) {
      case 1:Rv7=1;
      break;
      case 2:Rv7=2;
      break;
      case 3:Ra.sl[6]=888; /* line # 888 */
      Rv7=6;
      break;
      default:Rv7=0;
      break;
    }
    if (Rv7!=0) {
      Ra.sl[6]=894; /* line # 894 */
      if (V_sy_sym.ub[0]==17) {
        P_insymbol();
        Rv8=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=899; /* line # 899 */
        ((V *)Rv5)[0]=Rv8;
        Rv5=Rv8;
        Rv6=Rv6+1;
      }
      Rv8=P_lgt_new_econst(V_typ_std.v[2],Rv7);
      Ra.sl[6]=904; /* line # 904 */
      ((V *)Rv5)[0]=Rv8;
      Rv5=Rv8;
      Rv6=Rv6+1;
    }
    Ra.sl[6]=909; /* line # 909 */
    while (V_sy_sym.ub[0]==17){
      P_insymbol();
      Rv8=PAS_COMILER_PRC_00000000();
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=914; /* line # 914 */
      Rv5=Rv8;
      Rv6=Rv6+1;
    }
    Rv9=((V *)Rv1)[10];
    Ra.sl[6]=919; /* line # 919 */
    P_generic_search(((V *)Rv1)[0],Rv6, &Rv9, Rv2);
    if (Rv9!=NULL) {
      Rv10=Rv9;
      if (((V *)Rv10)[2]!=NULL) {
        Rv0=P_lgt_new_call(((V *)((V *)Rv10)[2])[11],((V *)Rv10)[2],Rv2);
        Ra.sl[6]=924; /* line # 924 */
        P_call_setting(&Rv0);
      }
    }
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else P_src_error(Rd.s+247,23,2);
  }
  Ra.sl[6]=930; /* line # 930 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " readwrite_call "  */
V PAS_COMILER_PRC_00000013(V F_dfi, V F_psel, V F_pio1, V F_pio2, V F_peoln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+251;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=948; /* line # 948 */
  Rv0=NULL;
  Rv1=NULL;
  Rv2=0;
  V_sy_label_flag=0;
  Ra.sl[6]=953; /* line # 953 */
  Rv3=F_pio1;
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=958; /* line # 958 */
    Rv4=0;
    Rv5=1;
    Rv2=1;
    P_insymbol();
    Rv6=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=963; /* line # 963 */
    if (F_dfi==NULL) {
      Rv1=Rv6;
      Rv7=1;
      if (V_sy_sym.ub[0]==21) {
        Ra.sl[6]=969; /* line # 969 */
        Rv8=Rv1;
        while (V_sy_sym.ub[0]==21){
          P_insymbol();
          Rv9=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=974; /* line # 974 */
          ((V *)Rv8)[0]=Rv9;
          Rv8=Rv9;
          Rv7=Rv7+1;
        }
      }
      Ra.sl[6]=979; /* line # 979 */
      if (V_sy_sym.ub[0]==14) {
        Rv2=0;
        P_insymbol();
      }
      else {
        if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+269,29,2);
      }
      Ra.sl[6]=984; /* line # 984 */
      Rv5=0;
    }
    else {
      if (P_comp_type(((V *)Rv6)[3],V_typ_std.v[16],0,0)) {
        Ra.sl[6]=990; /* line # 990 */
        Rv1=Rv6;
        if (((V *)Rv1)[3]!=V_typ_std.v[7]) Rv3=F_pio2;
        if (V_sy_sym.ub[0]==14) {
          Ra.sl[6]=995; /* line # 995 */
          Rv2=0;
          P_insymbol();
        }
        else {
          if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+269,29,2);
        }
        Rv5=0;
      }
    }
  }
  else {
    Ra.sl[6]=1004; /* line # 1004 */
    if (F_dfi==NULL) P_src_error(Rd.s+269,22,2);
  }
  if (F_psel!=NULL) F_psel=P_ide_search_from_nameid(F_psel);
  if (Rv3!=NULL) Rv3=P_ide_search_from_nameid(Rv3);
  if (F_peoln!=NULL) F_peoln=P_ide_search_from_nameid(F_peoln);
  Ra.sl[6]=1010; /* line # 1010 */
  if (Rv1==NULL) Rv1=P_lgt_new_idref(F_dfi,NULL);
  Rv0=P_exp_genoper(((V *)F_psel)[0],((V *)F_psel)[10],Rv1);
  Rv8=Rv0;
  Ra.sl[6]=1016; /* line # 1016 */
  if (Rv2) {
    while (Rv5||V_sy_sym.ub[0]==17){
      if (!Rv5) {
        Ra.sl[6]=1022; /* line # 1022 */
        P_insymbol();
        Rv6=PAS_COMILER_PRC_00000000();
      }
      else Rv5=0;
      Rv10=NULL;
      Ra.sl[6]=1027; /* line # 1027 */
      Rv7=1;
      while (V_sy_sym.ub[0]==21){
        P_insymbol();
        Rv9=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=1032; /* line # 1032 */
        if (Rv10==NULL) Rv10=Rv9;
        else((V *)Rv11)[0]=Rv9;
        Rv11=Rv9;
        Rv7=Rv7+1;
      }
      Ra.sl[6]=1037; /* line # 1037 */
      ((V *)Rv6)[0]=Rv10;
      Rv12=((V *)Rv3)[10];
      P_generic_search(((V *)Rv3)[0],Rv7, &Rv12, Rv6);
      if (Rv12!=NULL) {
        Rv13=Rv12;
        Ra.sl[6]=1043; /* line # 1043 */
        if (((V *)Rv13)[2]!=NULL) {
          Rv10=P_lgt_new_call(((V *)((V *)Rv13)[2])[11],((V *)Rv13)[2],Rv6);
          P_call_setting(&Rv10);
        }
        Ra.sl[6]=1048; /* line # 1048 */
        ((V *)Rv8)[0]=Rv10;
        Rv8=Rv10;
      }
    }
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=1053; /* line # 1053 */
      P_src_error(Rd.s+269,23,2);
    }
  }
  if (F_peoln!=NULL) {
    Ra.sl[6]=1059; /* line # 1059 */
    Rv12=((V *)F_peoln)[10];
    P_generic_search(((V *)F_peoln)[0],0, &Rv12,NULL);
    if (Rv12!=NULL) {
      Rv14=Rv12;
      Ra.sl[6]=1064; /* line # 1064 */
      if (((V *)Rv14)[2]!=NULL) {
        Rv10=P_lgt_new_call(((V *)((V *)Rv14)[2])[11],((V *)Rv14)[2],NULL);
        P_call_setting(&Rv10);
      }
      Ra.sl[6]=1069; /* line # 1069 */
      ((V *)Rv8)[0]=Rv10;
      Rv8=Rv10;
    }
  }
  Ra.sl[6]=1074; /* line # 1074 */
  if (Rv8!=Rv0) {
    P_lgt_new(&Rv0,NULL,0, Rv0);
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[6]=1079; /* line # 1079 */
  V_sy_label_flag=1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_state_eff_list "  */
V PAS_COMILER_PRC_00000015(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+273;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1104; /* line # 1104 */
  Rv0=NULL;
  Rv1=NULL;
  Lx[0].sl[0]=0;
  Ra.sl[6]=1109; /* line # 1109 */
  V_sy_sym.ub[0]=21;
  while (V_sy_sym.ub[0]==21){
    P_insymbol();
    Rv2=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=1114; /* line # 1114 */
    if (Rv1==NULL) Rv0=Rv2;
    else((V *)Rv1)[0]=Rv2;
    Rv1=Rv2;
    Lx[0].sl[0]=Lx[0].sl[0]+1;
  }
  Ra.sl[6]=1120; /* line # 1120 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " user_state_call "  */
V PAS_COMILER_PRC_00000014(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  UB Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+293;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=1125; /* line # 1125 */
  Rv0=NULL;
  Rv1=NULL;
  Rv2=NULL;
  Rv3=NULL;
  Rv4=0;
  Ra.sl[8]=1130; /* line # 1130 */
  Rv5=0;
  Rv6=0;
  V_sy_label_flag=0;
  Rv7=((V *)F_ip)[7];
  Ra.sl[8]=1136; /* line # 1136 */
  if (V_sy_sym.ub[0]==13) {
    Rv4=1;
    Rv3=PAS_COMILER_PRC_00000015();
  }
  Ra.sl[8]=1142; /* line # 1142 */
  while (Rv7!=NULL){
    Rv8=Rv7;
    if (((V *)Rv8)[2]==NULL||Rv3==NULL)  break;
    Ra.sl[8]=1148; /* line # 1148 */
    Rv5=P_comp_type(((V *)Rv3)[3],((V *)Rv8)[2],0,0);
    if (Rv5)  break;
    if (((V *)Rv8)[3]!=NULL)  break;
    Rv7=((V *)Rv8)[0];
  }
  Ra.sl[8]=1155; /* line # 1155 */
  if (Rv7==NULL) {
    P_src_error_s(Rd.s+312,41,3,((V *)F_ip)[0],NULL);
    P_skip_symbol(14,0,0);
    Ret=NULL;
  }
  else {
    Ra.sl[8]=1162; /* line # 1162 */
    Rv9=Rv7;
    if (((V *)Rv9)[4]!=NULL) Rv10=P_ide_search_from_nameid(((V *)Rv9)[4]);
    else Rv10=NULL;
    Ra.sl[8]=1167; /* line # 1167 */
    if (((V *)Rv9)[5]!=NULL) Rv11=P_ide_search_from_nameid(((V *)Rv9)[5]);
    else Rv11=NULL;
    if (((V *)Rv9)[6]!=NULL) Rv12=P_ide_search_from_nameid(((V *)Rv9)[6]);
    else Rv12=NULL;
    Ra.sl[8]=1173; /* line # 1173 */
    if (Rv4&&V_sy_sym.ub[0]==14) {
      P_insymbol();
      Rv4=0;
    }
    if (Rv5) {
      Ra.sl[8]=1178; /* line # 1178 */
      Rv2=Rv3;
      Rv13=Rv2;
      Rv3=NULL;
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+312,29,2);
    }
    else {
      Ra.sl[8]=1184; /* line # 1184 */
      if (((V *)Rv9)[3]!=NULL) {
        Ra.sl[0]=1;
        if (((UB *)Rv9)[8]) {
          ((UB *)Rv9)[8]=0;
          Rv13=((V *)Rv9)[3];
        }
        else Rv13=P_lgt_link(((V *)Rv9)[3]);
      }
      else {
        Ra.sl[8]=1191; /* line # 1191 */
        Ra.sl[0]=0;
        Rv13=NULL;
      }
    }
    if (Rv10!=NULL) {
      Rv0=P_generate_call(Rv10, Rv13, Ra.sl[0],0);
      Ra.sl[8]=1196; /* line # 1196 */
      Rv1=Rv0;
      if (Rv5) Rv6=1;
    }
    Ra.sl[8]=1201; /* line # 1201 */
    if (Rv4) {
      while (1){
        if (Rv3==NULL) Rv3=PAS_COMILER_PRC_00000015();
        Ra.sl[8]=1206; /* line # 1206 */
        if (((UB *)Rv9)[9]) {
          if (Rv5) {
            if (Rv6) Rv13=P_lgt_link(Rv2);
            else {
              Rv6=1;
              Rv13=Rv2;
            }
          }
          else {
            Ra.sl[8]=1212; /* line # 1212 */
            if (((UB *)Rv9)[8]) {
              ((UB *)Rv9)[8]=0;
              Rv13=((V *)Rv9)[3];
            }
            else Rv13=P_lgt_link(((V *)Rv9)[3]);
          }
          ((V *)Rv13)[0]=Rv3;
          Rv3=Rv13;
        }
        Ra.sl[8]=1218; /* line # 1218 */
        Rv13=P_generate_call(Rv11, Rv3, Ra.sl[0],0);
        if (Rv13!=NULL) {
          if (Rv1==NULL) Rv0=Rv13;
          else {
            Ra.sl[8]=1223; /* line # 1223 */
            ((V *)Rv1)[0]=Rv13;
          }
          Rv1=Rv13;
        }
        Rv3=NULL;
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[8]=1229; /* line # 1229 */
      if (V_sy_sym.ub[0]!=14) {
        P_src_error(Rd.s+312,34,3);
        P_skip_symbol(18,0,0);
      }
      else P_insymbol();
    }
    Ra.sl[8]=1236; /* line # 1236 */
    if (Rv12!=NULL) {
      if (((UB *)Rv9)[9]) {
        Ra.sl[0]=1;
        Ra.sl[8]=1241; /* line # 1241 */
        if (Rv5) {
          if (Rv6) Rv3=P_lgt_link(Rv2);
          else {
            Rv6=1;
            Rv3=Rv2;
          }
        }
        else {
          if (((UB *)Rv9)[8]) {
            ((UB *)Rv9)[8]=0;
            Rv3=((V *)Rv9)[3];
          }
          else {
            Ra.sl[8]=1246; /* line # 1246 */
            Rv3=P_lgt_link(((V *)Rv9)[3]);
          }
        }
      }
      else {
        Ra.sl[0]=0;
        Rv3=NULL;
      }
      Rv13=P_generate_call(Rv12, Rv3, Ra.sl[0],0);
      Ra.sl[8]=1251; /* line # 1251 */
      if (Rv1==NULL) Rv0=Rv13;
      else((V *)Rv1)[0]=Rv13;
      Rv1=Rv13;
    }
  }
  Ra.sl[8]=1257; /* line # 1257 */
  if (Rv1!=Rv0) {
    P_lgt_new(&Rv0,NULL,0, Rv0);
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[8]=1263; /* line # 1263 */
  V_sy_label_flag=1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " new_call "  */
V PAS_COMILER_PRC_00000016(V F_new_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  SL Rv9;
  V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  V Rv16;
  V Rv17;
  SL Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+316;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1283; /* line # 1283 */
  Rv0=NULL;
  Rv1=NULL;
  Rv2=NULL;
  Rv3=NULL;
  Ra.sl[6]=1289; /* line # 1289 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else P_src_error(Rd.s+328,22,2);
  Rv4=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  if (Rv4!=NULL) {
    Ra.sl[6]=1294; /* line # 1294 */
    Rv5=Rv4;
    if (2&((UW *)Rv5)[10]) Rv6=((V *)Rv5)[3];
  }
  if (Rv6!=NULL) {
    Rv7=Rv6;
    Ra.sl[6]=1299; /* line # 1299 */
    if (((UB *)Rv7)[93]==5) Rv3=((V *)Rv7)[12];
    else Rv3=NULL;
  }
  if (Rv3!=NULL) {
    Rv8=Rv3;
    Ra.sl[6]=1305; /* line # 1305 */
    Rv9=((SL *)Rv8)[11];
    if (((V *)Rv8)[4]!=NULL||((UB *)Rv8)[91]) {
      Ra.sl[6]=1312; /* line # 1312 */
      if (((V *)Rv8)[4]!=NULL) {
        Rv10=((V *)Rv8)[4];
        while (Rv10!=NULL){
          Ra.sl[6]=1317; /* line # 1317 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          Rv11=PAS_COMILER_PRC_00000005(((V *)Rv10)[5],0,0,0);
          if (((UB *)Rv11)[40]==17) {
            Rv12=Rv11;
            Ra.sl[6]=1322; /* line # 1322 */
            ((UB *)Rv12)[40]=14;
            ((V *)Rv12)[7]=((V *)Rv10)[10];
            if (((V *)Rv12)[7]==NULL) P_src_error(Rd.s+328,126,3);
            Ra.sl[6]=1327; /* line # 1327 */
            P_val_new(((V *)Rv12)+7,NULL);
            ((V *)Rv12)[4]=NULL;
            ((V *)Rv12)[3]=((V *)Rv10)[5];
          }
          Ra.sl[6]=1332; /* line # 1332 */
          if (((UB *)Rv11)[40]!=14) {
            P_lgt_new(&Rv13,((V *)Rv10)[5],13,NULL);
            ((V *)Rv13)[0]=Rv11;
            P_all_new(((V *)Rv13)+7,((V *)Rv10)[5],NULL,0);
            Ra.sl[6]=1337; /* line # 1337 */
            P_lgt_new(&Rv11,((V *)Rv10)[5],6, Rv13);
            ((UB *)Rv11)[41]=3;
            if (Rv0==NULL) Rv0=Rv11;
            else((V *)Rv14)[0]=Rv11;
            Ra.sl[6]=1342; /* line # 1342 */
            Rv14=Rv11;
          }
          else Rv13=Rv11;
          Rv15=Rv10;
          Ra.sl[6]=1349; /* line # 1349 */
          ((V *)Rv15)[9]=Rv13;
          ((UB *)Rv15)[60]=2;
          P_lgt_new(&Rv16,((V *)Rv15)[5],2, P_lgt_link(Rv4));
          ((SL *)Rv16)[4]=((SL *)Rv15)[14];
          Ra.sl[6]=1354; /* line # 1354 */
          if (((UB *)Rv13)[40]==14) ((V *)Rv16)[0]=Rv13;
          else((V *)Rv16)[0]=P_lgt_link(Rv13);
          P_lgt_new(&Rv13,((V *)Rv15)[5],6, Rv16);
          ((UB *)Rv13)[41]=3;
          if (Rv1==NULL) Rv1=Rv13;
          else {
            Ra.sl[6]=1359; /* line # 1359 */
            ((V *)Rv17)[0]=Rv13;
          }
          Rv17=Rv13;
          Ra.sl[6]=1364; /* line # 1364 */
          if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) P_src_error(Rd.s+328,34,2);
          Rv10=((V *)Rv10)[3];
        }
      }
      Ra.sl[6]=1369; /* line # 1369 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else P_src_error(Rd.s+328,24,2);
      Ra.sl[6]=1377; /* line # 1377 */
      Rv11=P_lgt_type_compute(((V *)Rv8)[8],((V *)Rv8)[9],((SL *)Rv8)[11],NULL);
      Ra.sl[6]=1390; /* line # 1390 */
      if (((UB *)Rv8)[91]) P_init_d_dyn(Rv3, Rv4, &Rv1, &Rv17,1,NULL);
      Rv10=((V *)Rv8)[4];
      while (Rv10!=NULL){
        Ra.sl[6]=1396; /* line # 1396 */
        ((UB *)Rv10)[60]=0;
        ((V *)Rv10)[9]=NULL;
        Rv10=((V *)Rv10)[3];
      }
      Ra.sl[6]=1402; /* line # 1402 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      ((V *)Rv4)[0]=Rv2;
      Ra.sl[6]=1407; /* line # 1407 */
      P_lgt_new(&Rv2, Rv6,6, Rv4);
      ((UB *)Rv2)[41]=3;
      if (Rv0==NULL) Rv0=Rv2;
      else {
        Ra.sl[6]=1412; /* line # 1412 */
        ((V *)Rv14)[0]=Rv2;
      }
      ((V *)Rv2)[0]=Rv1;
      P_lgt_new(&Rv1,NULL,0, Rv0);
      ((UB *)Rv1)[41]=2;
    }
    else {
      Ra.sl[6]=1419; /* line # 1419 */
      Rv9=((SL *)Rv8)[11];
      if (Rv9<=0) P_src_error(Rd.s+328,130,3);
      if (((UB *)Rv8)[93]==10) {
        Rv11=((V *)Rv8)[14];
        Ra.sl[6]=1424; /* line # 1424 */
        if (Rv11!=NULL) {
          if (((UB *)Rv11)[40]==16) Rv11=((V *)Rv11)[1];
        }
        while (V_sy_sym.ub[0]==17&&Rv11!=NULL){
          Rv2=((V *)Rv11)[1];
          Ra.sl[6]=1429; /* line # 1429 */
          Rv16=((V *)Rv2)[0];
          P_insymbol();
          Rv13=PAS_COMILER_PRC_00000005(((V *)((V *)Rv16)[0])[3],0,0,0);
          Rv18=-1;
          Ra.sl[6]=1434; /* line # 1434 */
          Rv19=Rv13;
          if (((UB *)Rv19)[40]==14) Rv18=((SL *)((V *)Rv19)[7])[13];
          else {
            Ra.sl[6]=1439; /* line # 1439 */
            P_src_error(Rd.s+328,181,2);
          }
          P_lgt_free_tree(&Rv13);
          Rv20=Rv2;
          Rv21=((V *)Rv20)[7];
          Ra.sl[6]=1444; /* line # 1444 */
          Rv18=Rv18-((SL *)Rv20)[4];
          if (Rv18>=0&&Rv18<((SL *)Rv21)[6]) {
            Rv18=((SL *)((V *)((V *)Rv2)[7])[7])[Rv18];
            if (Rv18>=0) {
              Ra.sl[6]=1449; /* line # 1449 */
              Rv16=((V *)((V *)Rv16)[0])[0];
            }
            while (Rv18>0&&Rv16!=NULL){
              Rv18=Rv18-1;
              Rv16=((V *)Rv16)[0];
            }
            Ra.sl[6]=1455; /* line # 1455 */
            if (Rv16==NULL) Rv16=((V *)Rv2)[0];
          }
          Rv22=((V *)Rv16)[3];
          Ra.sl[6]=1460; /* line # 1460 */
          Rv11=((V *)Rv22)[14];
          Rv9=((SL *)Rv22)[11];
        }
      }
      Ra.sl[6]=1465; /* line # 1465 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        P_src_error(Rd.s+328,23,2);
        P_skip_symbol(14,0,0);
      }
      Ra.sl[6]=1470; /* line # 1470 */
      P_lgt_new(&Rv1, Rv6,6, Rv4);
      ((UB *)Rv1)[41]=3;
      Rv11=P_lgt_new_econst(V_typ_std.v[2],Rv9);
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      Ra.sl[6]=1475; /* line # 1475 */
      ((V *)Rv4)[0]=Rv2;
    }
  }
  else {
    Ra.sl[6]=1480; /* line # 1480 */
    P_lgt_free_tree(&Rv4);
    P_src_error(Rd.s+328,180,3);
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dispose_call "  */
V PAS_COMILER_PRC_00000017(V F_free_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+332;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1497; /* line # 1497 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else P_src_error(Rd.s+348,22,2);
  Ra.sl[6]=1502; /* line # 1502 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Rv1=P_lgt_new_call(NULL,F_free_fnc, Rv0);
  if (V_sy_sym.ub[0]==17) P_skip_symbol(14,0,0);
  if (V_sy_sym.ub[0]==14) P_insymbol();
  else {
    P_src_error(Rd.s+348,23,2);
    Ra.sl[6]=1507; /* line # 1507 */
    P_skip_symbol(14,0,0);
  }
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_set "  */
V PAS_COMILER_PRC_00000018(V F_ty, UB F_bcte){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  UL Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+352;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1530; /* line # 1530 */
  Rv0=1;
  P_insymbol();
  if (V_sy_sym.ub[0]==16) {
    Ra.sl[6]=1535; /* line # 1535 */
    P_lgt_new(&Rv1, V_typ_std.v[19],14,NULL);
    if (F_ty!=NULL) ((V *)Rv1)[3]=F_ty;
    P_val_new(((V *)Rv1)+7,((V *)Rv1)[3]);
    Rv2=((V *)Rv1)[7];
    Ra.sl[6]=1540; /* line # 1540 */
    ((SL *)Rv2)[6]=0;
    ((UL *)Rv2)[13]=0;
  }
  else {
    Ra.sl[6]=1546; /* line # 1546 */
    Rv1=NULL;
    Rv3=NULL;
    Rv4=NULL;
    Rv5=0;
    Rv6=-1;
    Ra.sl[6]=1551; /* line # 1551 */
    Rv7=0;
    for( Rf0=(V_dst_seti-1)+1;Rf0>0;Rf0-- ) {
      Ra.ul[Rv7+7]=0;
      Rv7++;
    }
    Rv8=F_ty;
    Rv9=NULL;
    if (F_ty!=NULL) {
      Rv10=F_ty;
      Ra.sl[6]=1557; /* line # 1557 */
      Rv9=((V *)Rv10)[13];
      Rv11=((SL *)Rv10)[24];
    }
    while (1){
      Ra.sl[6]=1563; /* line # 1563 */
      if (Rv0) Rv0=0;
      else P_insymbol();
      if (Rv9==NULL) {
        Ra.sl[6]=1569; /* line # 1569 */
        Rv12=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
        if (((UB *)Rv12)[40]==17) {
          P_src_error(Rd.s+376,137,2);
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1577; /* line # 1577 */
          Rv9=((V *)Rv12)[3];
          if (Rv9!=NULL) {
            Rv11=-1;
            while (Rv9!=NULL&&Rv11<0){
              Ra.sl[6]=1582; /* line # 1582 */
              switch (((UB *)Rv9)[93]) {
                case 0:
                case 1:
                case 2:Rv11=((SL *)Rv9)[30];
                break;
                case 22:Rv9=((V *)Rv9)[0];
                break;
                default:P_src_error(Rd.s+376,110,2);
                Ra.sl[6]=1587; /* line # 1587 */
                Rv9=V_typ_std.v[2];
                Rv11=0;
                break;
              }
            }
            if (Rv11<0) P_src_error(Rd.s+376,110,2);
            else {
              Ra.sl[6]=1593; /* line # 1593 */
              if (Rv11>=V_dst_seta) Rv11=V_dst_seta-1;
            }
          }
          if (Rv11<0) Rv9=NULL;
          Ra.sl[6]=1598; /* line # 1598 */
          if (F_ty==NULL&&Rv9!=NULL) {
            if (Rv11<V_dst_setw) P_ide_new_typ(11, &Rv8);
            else P_ide_new_typ(12, &Rv8);
            Rv13=Rv8;
            Ra.sl[6]=1604; /* line # 1604 */
            ((V *)Rv13)[13]=Rv9;
            ((SL *)Rv13)[24]=Rv11+1;
            if (Rv11<V_dst_setw) memcpy(Rv13+48,V_typ_std.v[17]+48,1);
            else {
              Ra.sl[6]=1609; /* line # 1609 */
              memcpy(Rv13+48,V_typ_std.v[18]+48,1);
            }
            Rv14=((((SL *)Rv13)[24]+V_dst_setw)-1)/V_dst_setw;
            ((SL *)Rv13)[11]=(Rv14*V_dst_setw+7)/8;
          }
        }
      }
      else {
        Ra.sl[6]=1619; /* line # 1619 */
        Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
      }
      if (((UB *)Rv12)[40]==14) {
        Rv5=1;
        Ra.sl[6]=1624; /* line # 1624 */
        Rv14=P_lgt_get_econst(Rv12,-1);
        P_lgt_free(&Rv12);
        if (V_sy_sym.ub[0]==20) {
          P_insymbol();
          Ra.sl[6]=1629; /* line # 1629 */
          Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
          if (((UB *)Rv12)[40]!=14) {
            P_src_error(Rd.s+376,53,2);
            Rv15=Rv14;
          }
          else {
            Ra.sl[6]=1635; /* line # 1635 */
            Rv15=P_lgt_get_econst(Rv12, Rv14);
          }
          P_lgt_free(&Rv12);
        }
        else Rv15=Rv14;
        if (((Rv14<0||Rv14>Rv11)||Rv15<Rv14)||Rv15>Rv11) {
          Ra.sl[6]=1640; /* line # 1640 */
          P_src_error(Rd.s+376,138,2);
          Rv15=Rv14-1;
        }
        Rv16=Rv14;
        for( Rf0=(Rv15+1)-Rv14;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1645; /* line # 1645 */
          if (Rv16>Rv6) Rv6=Rv16;
          Rv17=Rv16/V_dst_setw;
          Rv18=Rv16%V_dst_setw;
          if (1<<Rv18&Ra.ul[Rv17+7]) P_src_error(Rd.s+376,139,2);
          else Ra.ul[Rv17+7]=Ra.ul[Rv17+7]|1<<Rv18;
          Rv16++;
        }
      }
      else {
        Ra.sl[6]=1652; /* line # 1652 */
        if (((UB *)Rv12)[40]!=17) {
          if (F_bcte) P_src_error(Rd.s+376,140,3);
          if (((UB *)Rv8)[92]) {
            Ra.sl[6]=1657; /* line # 1657 */
            Rv12=P_lgt_new_code(16, Rv12);
            ((V *)Rv12)[3]=Rv8;
            if (Rv1!=NULL) {
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1662; /* line # 1662 */
              Rv1=P_lgt_new_code(14, Rv1);
              ((V *)Rv1)[3]=Rv8;
            }
            else Rv1=Rv12;
          }
          else {
            Ra.sl[6]=1669; /* line # 1669 */
            Rv12=P_lgt_new_call(Rv8, V_set_entry_proc, Rv12);
            P_call_setting(&Rv12);
            if (Rv1!=NULL) {
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1674; /* line # 1674 */
              Rv1=P_exp_genop(11, Rv1);
              ((V *)Rv1)[3]=Rv8;
            }
            else Rv1=Rv12;
          }
        }
        else {
          Ra.sl[6]=1682; /* line # 1682 */
          P_src_error(Rd.s+376,141,2);
          P_lgt_free(&Rv12);
        }
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=1687; /* line # 1687 */
    if (Rv5) {
      if ((Rv1==NULL&&Rv8!=NULL)&&F_ty==NULL) {
        Rv19=Rv8;
        Ra.sl[6]=1692; /* line # 1692 */
        ((SL *)Rv19)[24]=Rv6+1;
        Rv11=Rv6;
        if (Rv6>=V_dst_setw) {
          ((UB *)Rv19)[92]=0;
          Ra.sl[6]=1697; /* line # 1697 */
          ((UB *)Rv19)[93]=12;
          ((SL *)Rv19)[11]=(((((SL *)Rv19)[24]+V_dst_setw)-1)/V_dst_setw)*((SL *)
          V_typ_std.v[17])[11];
          ((UB *)Rv19)[48]=((UB *)V_typ_std.v[18])[48];
        }
        else {
          Ra.sl[6]=1704; /* line # 1704 */
          ((UB *)Rv19)[92]=1;
          ((UB *)Rv19)[93]=11;
          ((SL *)Rv19)[11]=(((SL *)Rv19)[24]+7)/8;
          switch (((SL *)Rv19)[11]) {
            case 1:((UB *)Rv19)[48]=0;
            break;
            case 2:Ra.sl[6]=1709; /* line # 1709 */
            ((UB *)Rv19)[48]=1;
            break;
            default:((SL *)Rv19)[11]=4;
            ((UB *)Rv19)[48]=((UB *)V_typ_std.v[17])[48];
            break;
          }
        }
      }
      Ra.sl[6]=1717; /* line # 1717 */
      if (Rv11<V_dst_setw) Rv12=P_lgt_new_econst(Rv8, Ra.sl[7]);
      else {
        Ra.sl[6]=1723; /* line # 1723 */
        P_lgt_new(&Rv12, Rv8,14,NULL);
        P_val_new(((V *)Rv12)+7,Rv8);
        Rv20=((V *)Rv12)[7];
        ((V *)Rv20)[7]=PAS__NEW(32);
        Ra.sl[6]=1728; /* line # 1728 */
        ((SL *)Rv20)[6]=(Rv6+V_dst_setw)/V_dst_setw;
        Rv21=0;
        for( Rf0=(((SL *)Rv20)[6]-1)+1;Rf0>0;Rf0-- ) {
          ((SL *)((V *)Rv20)[7])[Rv21]=Ra.sl[Rv21+7];
          Rv21++;
        }
      }
    }
    Ra.sl[6]=1735; /* line # 1735 */
    if (Rv6>=0) {
      if (Rv1==NULL) Rv1=Rv12;
      else {
        Ra.sl[6]=1740; /* line # 1740 */
        ((V *)Rv12)[0]=Rv1;
        Rv1=P_exp_genop(11, Rv12);
        ((V *)Rv1)[3]=Rv8;
      }
    }
  }
  Ra.sl[6]=1745; /* line # 1745 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_tab "  */
void PAS_COMILER_PRC_00000020(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+380;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1777; /* line # 1777 */
  Rv0=F_ty;
  Rv1=((V *)Rv0)[15];
  Ra.sl[6]=1782; /* line # 1782 */
  Rv2=((V *)Rv0)[14];
  if (Rv1!=NULL) {
    Rv3=Rv1;
    Ra.sl[6]=1787; /* line # 1787 */
    if (((UB *)Rv3)[93]!=22) {
      if (((UB *)Rv3)[112]) Lx[1].sl[0]=(((UL *)Rv3)[30]+1)-((UL *)Rv3)[29];
      else Lx[1].sl[0]=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
    }
    else {
      Ra.sl[6]=1794; /* line # 1794 */
      Rv4=P_lgt_type_eval(((V *)Rv3)[12],NULL,NULL,0);
      if (((UB *)Rv4)[40]==14) {
        Lx[1].sl[0]=((SL *)((V *)Rv4)[7])[13];
        P_lgt_free(&Rv4);
      }
      else {
        Ra.sl[6]=1800; /* line # 1800 */
        P_src_error(Rd.s+404,142,4);
      }
    }
  }
  else Lx[1].sl[0]=0;
  Rv5=F_ty;
  if (((V *)Rv5)[13]!=NULL) {
    Ra.sl[6]=1806; /* line # 1806 */
    Rv4=P_lgt_type_eval(((V *)Rv5)[13],NULL,NULL,0);
    if (((UB *)Rv4)[40]==14) {
      Lx[1].sl[1]=((SL *)((V *)Rv4)[7])[13];
      P_lgt_free(&Rv4);
    }
    else {
      Ra.sl[6]=1812; /* line # 1812 */
      P_src_error(Rd.s+404,142,4);
    }
  }
  else Lx[1].sl[1]=((SL *)Rv5)[25];
  if (Rv2==NULL) Lx[1].sl[0]=0;
  Ra.sl[6]=1818; /* line # 1818 */
  Rv6=0;
  V_sy_sym.ub[0]=17;
  while (Rv6<Lx[1].sl[0]&&V_sy_sym.ub[0]==17){
    P_insymbol();
    Ra.sl[6]=1823; /* line # 1823 */
    Rv6=Rv6+1;
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) Rv4=PAS_COMILER_PRC_00000019(((V
     *)F_ty)[14]);
    else {
      Ra.sl[6]=1828; /* line # 1828 */
      Rv4=PAS_COMILER_PRC_00000005(((V *)F_ty)[14],0,0,0);
    }
    if (((UB *)Rv4)[40]!=14) Lx[1].ub[8]=0;
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv4;
    else((V *)Lx[1].v[3])[0]=Rv4;
    Ra.sl[6]=1833; /* line # 1833 */
    Lx[1].v[3]=Rv4;
  }
  if (Rv6<Lx[1].sl[0]) P_src_error(Rd.s+404,144,3);
  else {
    Ra.sl[6]=1838; /* line # 1838 */
    if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
      P_src_error(Rd.s+404,146,2);
      P_skip_symbol(Lx[1].ub[32],0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_list_agregat_rec "  */
void PAS_COMILER_PRC_00000021(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+408;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1860; /* line # 1860 */
  Rv0=F_ty;
  V_sy_sym.ub[0]=17;
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1865; /* line # 1865 */
  while (V_sy_sym.ub[0]==17&&Rv1!=NULL){
    P_insymbol();
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1870; /* line # 1870 */
      Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
    }
    else Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[5],0,0,0);
    Ra.sl[6]=1875; /* line # 1875 */
    if (((UB *)Rv2)[40]!=14) Lx[1].ub[8]=0;
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
    else((V *)Lx[1].v[3])[0]=Rv2;
    Lx[1].v[3]=Rv2;
    Ra.sl[6]=1880; /* line # 1880 */
    if (Rv1==((V *)Rv0)[13]) Rv1=NULL;
    else Rv1=((V *)Rv1)[3];
  }
  Ra.sl[6]=1885; /* line # 1885 */
  Rv3=((V *)Rv0)[14];
  if (Rv3!=NULL) {
    if (((UB *)Rv3)[40]==16) Rv3=((V *)Rv3)[1];
  }
  if (Rv3==NULL) {
    Ra.sl[6]=1891; /* line # 1891 */
    if (Rv1!=NULL) P_src_error(Rd.s+432,144,3);
    else {
      if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
        Ra.sl[6]=1896; /* line # 1896 */
        P_src_error(Rd.s+432,146,2);
        P_skip_symbol(Lx[1].ub[32],0,0);
      }
    }
    goto Ret_Label;
  }
  Ra.sl[6]=1902; /* line # 1902 */
  Rv4=Rv3;
  Rv5=((V *)Rv4)[1];
  Rv6=((V *)Rv5)[0];
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1907; /* line # 1907 */
  Rv8=Rv5;
  Rv9=((SL *)Rv8)[4];
  if (((V *)Rv8)[7]!=NULL) {
    Rv10=((V *)Rv8)[7];
    Ra.sl[6]=1913; /* line # 1913 */
    Rv11=(((SL *)Rv10)[6]+Rv9)-1;
    Rv12=((V *)Rv10)[7];
  }
  else Rv12=NULL;
  Ra.sl[6]=1918; /* line # 1918 */
  if (((V *)Rv0)[4]!=NULL) {
    Rv2=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Rv13=Rv2;
    if (((UB *)Rv13)[40]!=14) P_src_error(Rd.s+432,142,3);
    else {
      Ra.sl[6]=1924; /* line # 1924 */
      if (((V *)Rv13)[7]!=NULL) Rv14=((SL *)((V *)Rv13)[7])[13];
      else Rv14=Rv9-1;
    }
    P_lgt_free(&Rv2);
  }
  else {
    Ra.sl[6]=1930; /* line # 1930 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else P_src_error(Rd.s+432,29,3);
    Rv14=PAS_COMILER_PRC_00000006(((V *)Rv7)+3);
    if (((V *)Rv7)[4]!=NULL) {
      Ra.sl[6]=1936; /* line # 1936 */
      Rv15=((SL *)((V *)Rv7)[4])[14];
      Rv2=P_lgt_new_econst(((V *)Rv7)[3],Rv14);
      ((SL *)Rv2)[4]=Rv15;
      Ra.sl[6]=1941; /* line # 1941 */
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
      else((V *)Lx[1].v[3])[0]=Rv2;
      Lx[1].v[3]=Rv2;
    }
  }
  Ra.sl[6]=1947; /* line # 1947 */
  Rv16=((V *)Rv7)[0];
  if (Rv14<Rv9||Rv14>Rv11) Rv16=Rv6;
  else {
    Ra.sl[6]=1952; /* line # 1952 */
    Rv14=((SL *)Rv12)[(Rv14-Rv9)];
    if (Rv14<0) Rv16=Rv6;
    else {
      while (Rv14>0&&Rv16!=NULL){
        Ra.sl[6]=1958; /* line # 1958 */
        Rv16=((V *)Rv16)[0];
        Rv14=Rv14-1;
      }
      if (Rv16==NULL) Rv16=Rv6;
    }
  }
  Ra.sl[6]=1963; /* line # 1963 */
  if (Rv16!=NULL) {
    if (((V *)Rv16)[3]!=NULL) PAS_COMILER_PRC_00000021(((V *)Rv16)[3]);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_agregate "  */
V PAS_COMILER_PRC_00000019(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+436;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=1972; /* line # 1972 */
  Rv0=F_ty;
  if (((UB *)Rv0)[93]==11||((UB *)Rv0)[93]==12) {
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+452,25,2);
    Rv1=PAS_COMILER_PRC_00000018(F_ty,0);
    Ra.sl[16]=1977; /* line # 1977 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else P_src_error(Rd.s+452,26,2);
  }
  else {
    if (((UB *)Rv0)[92]) {
      Ra.sl[16]=1982; /* line # 1982 */
      P_src_error(Rd.s+452,131,3);
    }
    else {
      Ra.ub[8]=1;
      Rv1=NULL;
      Ra.sl[16]=1987; /* line # 1987 */
      Ra.v[2]=NULL;
      Ra.v[3]=NULL;
      if (V_sy_sym.ub[0]==13) Ra.ub[32]=14;
      else Ra.ub[32]=16;
      Rv2=((SL *)Rv0)[11];
      Ra.sl[16]=1992; /* line # 1992 */
      Rv3=0;
      V_sy_sym.ub[0]=17;
      if (((V *)Rv0)[4]!=NULL) {
        Ra.sl[16]=1997; /* line # 1997 */
        Rv4=((V *)Rv0)[4];
        if (((UB *)Rv0)[90]) P_type_parm_cte_init(F_ty, Ra.v+2,Ra.v+3,&Rv3);
        else while (1){
          Ra.sl[16]=2031; /* line # 2031 */
          P_insymbol();
          Rv5=Rv4;
          Rv6=((V *)Rv5)[5];
          Ra.sl[16]=2036; /* line # 2036 */
          Rv7=PAS_COMILER_PRC_00000005(Rv6,0,0,0);
          Rv8=Rv7;
          if (((UB *)Rv8)[40]==17) {
            Ra.sl[16]=2041; /* line # 2041 */
            ((UB *)Rv8)[40]=14;
            ((V *)Rv8)[7]=((V *)Rv5)[10];
            if (((V *)Rv8)[7]==NULL) P_src_error_s(Rd.s+452,157,3,((V *)Rv4)[0],
            NULL);
            P_val_new(((V *)Rv8)+7,Rv6);
            Ra.sl[16]=2046; /* line # 2046 */
            ((V *)Rv8)[4]=NULL;
            ((V *)Rv8)[3]=Rv6;
          }
          else {
            if (((UB *)Rv8)[40]!=14) P_src_error(Rd.s+452,132,3);
          }
          Ra.sl[16]=2051; /* line # 2051 */
          ((SL *)Rv8)[4]=((SL *)Rv5)[14];
          ((V *)Rv5)[9]=Rv7;
          Ra.sl[16]=2056; /* line # 2056 */
          ((UB *)Rv5)[60]=1;
          if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
          else((V *)Ra.v[3])[0]=Rv7;
          Ra.v[3]=Rv7;
          Ra.sl[16]=2062; /* line # 2062 */
          Rv4=((V *)Rv4)[3];
          Rv3=Rv3+1;
          if (Rv4==NULL||V_sy_sym.ub[0]!=17)  break;
        }
      }
      Ra.sl[16]=2069; /* line # 2069 */
      if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
        Rv9=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
        if (((UB *)Rv9)[40]==14) {
          Ra.sl[16]=2074; /* line # 2074 */
          Rv2=((SL *)((V *)Rv9)[7])[13];
          P_lgt_free(&Rv9);
        }
        else P_src_error(Rd.s+452,142,3);
      }
      Ra.sl[16]=2080; /* line # 2080 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+452,29,2);
      switch (((UB *)Rv0)[93]) {
        case 11:
        case 12:Ra.sl[16]=2085; /* line # 2085 */
        if (V_sy_sym.ub[0]==13) P_src_error(Rd.s+452,133,2);
        Rv7=PAS_COMILER_PRC_00000018(F_ty,0);
        if (((UB *)Rv7)[40]!=14) Ra.ub[8]=0;
        if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
        else {
          Ra.sl[16]=2090; /* line # 2090 */
          ((V *)Ra.v[3])[0]=Rv7;
        }
        Ra.v[3]=Rv7;
        break;
        case 10:
        case 23:Ra.sl[16]=2095; /* line # 2095 */
        PAS_COMILER_PRC_00000021(F_ty);
        break;
        case 8:PAS_COMILER_PRC_00000020(F_ty);
        break;
        default:Ra.sl[16]=2101; /* line # 2101 */
        P_src_error(Rd.s+452,131,3);
        P_skip_symbol(Ra.ub[32],0,0);
        break;
      }
      if (V_sy_sym.ub[0]==Ra.ub[32]) P_insymbol();
      else {
        Ra.sl[16]=2106; /* line # 2106 */
        P_src_error(Rd.s+452,26,2);
      }
      if (((V *)Rv0)[4]!=NULL) P_type_parm_cte_release(F_ty);
      Ra.sl[16]=2124; /* line # 2124 */
      if (Ra.ub[8]) {
        P_lgt_new(&Rv1, F_ty,14,NULL);
        switch (((UB *)F_ty)[93]) {
          case 8:
          case 9:
          case 10:Ra.sl[16]=2130; /* line # 2130 */
          P_val_new(((V *)Rv1)+7,F_ty);
          ((V *)((V *)Rv1)[7])[7]=NULL;
          Rv10=NULL;
          Rv11=Rv1;
          Rv12=((V *)Rv11)[7];
          Ra.sl[16]=2135; /* line # 2135 */
          ((SL *)Rv12)[2]=Rv3;
          ((SL *)Rv12)[6]=Rv2;
          while (Ra.v[2]!=NULL){
            Ra.sl[16]=2140; /* line # 2140 */
            Rv7=Ra.v[2];
            Rv13=NULL;
            P_val_copy(((V *)Rv7)+7,&Rv13,1);
            if (Rv10==NULL) ((V *)((V *)Rv1)[7])[7]=Rv13;
            else((V *)Rv10)[0]=Rv13;
            Ra.sl[16]=2145; /* line # 2145 */
            if (((UB *)F_ty)[93]!=10) {
              if (Rv3>0) Rv3=Rv3-1;
              else {
                if (((UB *)Rv13)[48]==29) ((SL *)Rv13)[6]=Ra.sl[1]-V_stri_stroffset;
                else((SL *)Rv13)[6]=Ra.sl[1];
              }
            }
            Ra.sl[16]=2150; /* line # 2150 */
            Rv10=Rv13;
            Ra.v[2]=((V *)Ra.v[2])[0];
            ((V *)Rv7)[7]=NULL;
            P_lgt_free(&Rv7);
          }
          break;
          default:Ra.sl[16]=2159; /* line # 2159 */
          P_val_copy(((V *)Ra.v[2])+7,((V *)Rv1)+7,1);
          ((SL *)((V *)Rv1)[7])[2]=Rv3;
          break;
        }
      }
      else {
        Ra.sl[16]=2166; /* line # 2166 */
        P_src_error(Rd.s+452,143,3);
        P_lgt_free_tree(Ra.v+2);
        Rv1=P_lgt_new_econst(V_typ_std.v[21],0);
      }
    }
  }
  Ra.sl[16]=2171; /* line # 2171 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " exp_const_set "  */
V PAS_COMILER_PRC_00000022(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+456;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2184; /* line # 2184 */
  Rv0=PAS_COMILER_PRC_00000018(NULL,0);
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else P_src_error(Rd.s+473,26,2);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_procref "  */
V PAS_COMILER_PRC_00000023(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+477;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2200; /* line # 2200 */
  Rv0=NULL;
  Rv1=Lx[5].v[13];
  while (Rv1!=NULL&&Rv0==NULL)
  switch (((UB *)Rv1)[104]) {
    case 6:
    case 9:
    case 10:
    case 11:Ra.sl[6]=2205; /* line # 2205 */
    Rv0=Rv1;
    break;
    case 5:Rv1=((V *)Rv1)[14];
    break;
    default:Ra.sl[6]=2210; /* line # 2210 */
    P_src_error(Rd.s+492,171,3);
    Rv1=NULL;
    break;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_generic_ref "  */
V PAS_COMILER_PRC_00000024(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2233; /* line # 2233 */
  Rv0=NULL;
  P_insymbol();
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2238; /* line # 2238 */
    Rv1=P_ide_search(898);
    if (Rv1!=V_ide_udptr.v[1]) {
      Rv2=Rv1;
      P_insymbol();
      Ra.sl[6]=2243; /* line # 2243 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else P_src_error(Rd.s+515,26,2);
      switch (((UB *)Rv2)[53]) {
        case 1:
        case 8:
        case 9:Ra.sl[6]=2248; /* line # 2248 */
        Rv3=((V *)Rv2)[10];
        while (Rv3!=NULL&&!P_comp_proc_arg(((V *)Rv3)[2],((V *)F_ty)[13]))
        Rv3=((V *)Rv3)[0];
        if (Rv3==NULL) Rv0=NULL;
        else Rv0=((V *)Rv3)[2];
        if (((SL *)Rv0)[18]>1) P_src_error_s(Rd.s+515,401,2,((V *)Rv2)[0],NULL);
        break;
        case 7:Ra.sl[6]=2256; /* line # 2256 */
        if (P_comp_proc_arg(((V *)Rv2)[8],((V *)F_ty)[13])) Rv0=((V *)Rv2)[8];
        else Rv0=NULL;
        break;
        default:break;
      }
      Ra.sl[6]=2261; /* line # 2261 */
      if (Rv0!=NULL) {
        P_lgt_new(&Rv4, F_ty,10,NULL);
        ((V *)Rv4)[6]=Rv0;
      }
    }
  }
  Ra.sl[6]=2268; /* line # 2268 */
  if (Rv0==NULL) {
    P_src_error(Rd.s+515,402,3);
    Rv4=P_lgt_new_econst(V_typ_std.v[13],0);
  }
  Ra.sl[6]=2273; /* line # 2273 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_identifier "  */
V PAS_COMILER_PRC_00000025(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register UB Rv16;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+519;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2290; /* line # 2290 */
  if (V_sy_sym.ub[0]==0) {
    if (V_sy_search==NULL) {
      Ra.sl[6]=2296; /* line # 2296 */
      Rv0=P_ide_search(1014);
      P_insymbol();
    }
    else {
      Ra.sl[6]=2302; /* line # 2302 */
      Rv0=V_sy_search;
      V_sy_sym.ub[0]=V_lastsymb;
      V_sy_search=NULL;
    }
    Ra.sl[6]=2307; /* line # 2307 */
    if (Rv0!=NULL) {
      Rv1=Rv0;
      switch (((UB *)Rv1)[53]) {
        case 1:Ra.sl[6]=2313; /* line # 2313 */
        if (Rv0==V_ide_udptr.v[1]) Rv2=P_lgt_new_econst(V_typ_std.v[21],0);
        else switch (V_sy_sym.ub[0]) {
          case 24:Ra.sl[6]=2318; /* line # 2318 */
          Rv2=PAS_COMILER_PRC_00000007(NULL,((V *)Rv1)[5]);
          break;
          case 13:if (((V *)Rv1)[10]!=NULL) Rv2=PAS_COMILER_PRC_00000011(Rv0,1);
          else Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
          break;
          case 15:Ra.sl[6]=2323; /* line # 2323 */
          if (((V *)Rv1)[5]!=NULL) {
            if (((UB *)((V *)Rv1)[5])[93]==6) Rv2=PAS_COMILER_PRC_00000024(((V *)
            Rv1)[5]);
            else Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
          }
          break;
          default:P_src_error(Rd.s+537,36,3);
          break;
        }
        break;
        case 7:
        case 8:Ra.sl[6]=2332; /* line # 2332 */
        Rv2=PAS_COMILER_PRC_00000009(Rv0,1);
        break;
        case 9:Rv2=PAS_COMILER_PRC_00000011(Rv0,1);
        break;
        case 2:Ra.sl[6]=2339; /* line # 2339 */
        switch (((UB *)Rv1)[60]) {
          case 2:if (((V *)Rv1)[10]!=NULL) {
            P_lgt_new(&Rv2,((V *)Rv1)[5],14,NULL);
            Ra.sl[6]=2344; /* line # 2344 */
            Rv3=Rv2;
            ((V *)Rv3)[7]=((V *)Rv1)[10];
            P_val_new(((V *)Rv3)+7,((V *)Rv1)[5]);
          }
          else {
            Ra.sl[6]=2352; /* line # 2352 */
            Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[5],0,0,0);
          }
          break;
          case 0:P_lgt_new(&Rv2,((V *)Rv1)[5],13,NULL);
          Ra.sl[6]=2357; /* line # 2357 */
          if (((V *)Rv1)[8]==NULL) ((V *)Rv1)[8]=Rv2;
          ((V *)Rv1)[9]=NULL;
          Ra.sl[6]=2362; /* line # 2362 */
          Rv4=Rv2;
          ((V *)Rv4)[6]=Rv0;
          ((UW *)Rv4)[10]=1;
          break;
          case 3:Ra.sl[6]=2370; /* line # 2370 */
          Rv5=(V_lex_ident_tree.s+V_ident_disp*64);
          if (((UB *)Rv5)[24]==1) {
            P_lgt_new_copy(((V *)Rv5)[2],&Rv2);
            Rv6=Rv2;
            Ra.sl[6]=2376; /* line # 2376 */
            ((V *)Rv6)[3]=((V *)Rv1)[5];
            ((SL *)Rv6)[4]=((SL *)Rv6)[4]+((SL *)Rv1)[14];
          }
          else {
            Ra.sl[6]=2382; /* line # 2382 */
            P_lgt_new_copy(((V *)Rv5)[2],&Rv2);
            P_lgt_new(&Rv2,((V *)Rv1)[5],2, Rv2);
            ((SL *)Rv2)[4]=((SL *)Rv1)[14];
            if (((SL *)Rv5)[13]>=0) ((SL *)Rv5)[13]=((SL *)Rv5)[13]+1;
            else {
              Ra.sl[6]=2388; /* line # 2388 */
              Rv7=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
              ((SL *)Rv7)[13]=((SL *)Rv7)[13]+1;
            }
          }
          break;
          default:break;
        }
        Ra.sl[6]=2394; /* line # 2394 */
        ((V *)Rv2)[4]=Rv0;
        ((UW *)Rv2)[10]=1;
        break;
        case 5:Ra.sl[6]=2401; /* line # 2401 */
        Rv2=P_lgt_new_idref(Rv0,NULL);
        Rv8=Rv2;
        if (((SL *)Lx[5].v[13])[18]>=((SL *)Rv1)[12]) ((UW *)Rv1)[42]=((UW *)Rv1)
        [42]|4;
        Ra.sl[6]=2407; /* line # 2407 */
        switch (((UB *)Rv1)[86]) {
          case 1:
          case 2:
          case 4:
          case 7:Ra.sl[6]=2414; /* line # 2414 */
          if ((((UB *)((V *)Rv1)[5])[90]||((UB *)((V *)Rv1)[5])[91])&&!(16&((UW *)
          Rv1)[42])) P_init_d_varbl(Rv0);
          Ra.sl[6]=2420; /* line # 2420 */
          if (((((UB *)Rv1)[86]==1&&((SL *)Rv1)[12]>1)&&((V *)Rv1)[7]!=NULL)&&!(
8&((UW *)Rv1)[42])) P_initialize_varbl(Rv0);
          break;
          case 11:Ra.sl[6]=2430; /* line # 2430 */
          ((V *)Rv8)[3]=V_typ_std.v[13];
          ((UW *)Rv8)[10]=1;
          break;
          default:break;
        }
        Ra.sl[6]=2438; /* line # 2438 */
        ((V *)Rv2)[4]=Rv0;
        break;
        case 4:Ra.sl[6]=2443; /* line # 2443 */
        Rv2=P_lgt_new_idref(Rv0,NULL);
        ((V *)Rv2)[4]=Rv0;
        break;
        case 6:Ra.sl[6]=2448; /* line # 2448 */
        Rv9=(V_lex_ident_tree.s+V_ident_disp*64);
        P_lgt_new_copy(((V *)Rv9)[2],&Rv2);
        if (((UB *)Rv9)[24]==1) {
          Ra.sl[6]=2453; /* line # 2453 */
          if (((SL *)((V *)Rv2)[3])[10]>0) V_curr_descr=Rv2;
          P_lgt_new(&Rv2,((V *)Rv1)[5],3, Rv2);
          ((SL *)Rv2)[4]=((SL *)Rv1)[14];
        }
        else {
          Ra.sl[6]=2459; /* line # 2459 */
          Rv10=Rv2;
          if (((UB *)((V *)Rv10)[3])[93]==24) {
            Rv11=((V *)((V *)((V *)Rv10)[3])[0])[3];
            ((V *)Rv10)[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[14]);
            Ra.sl[6]=2464; /* line # 2464 */
            if (Rv11!=NULL) Rv2=P_exp_genoper(((V *)Rv11)[0],((V *)Rv11)[10],Rv2);
            else P_src_error(Rd.s+537,998,3);
            ((V *)Rv2)[3]=((V *)Rv1)[5];
          }
          else {
            Ra.sl[6]=2472; /* line # 2472 */
            P_lgt_new(&Rv2,((V *)((V *)Rv2)[3])[12],2, Rv2);
            if (((SL *)((V *)Rv2)[3])[10]>0) V_curr_descr=Rv2;
            P_lgt_new(&Rv2,((V *)Rv1)[5],3, Rv2);
            ((SL *)Rv2)[4]=((SL *)Rv1)[14];
          }
          Ra.sl[6]=2478; /* line # 2478 */
          if (((SL *)Rv9)[13]>=0) ((SL *)Rv9)[13]=((SL *)Rv9)[13]+1;
          else {
            Rv12=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
            ((SL *)Rv12)[13]=((SL *)Rv12)[13]+1;
          }
        }
        Ra.sl[6]=2484; /* line # 2484 */
        Rv13=Rv2;
        ((UW *)Rv13)[10]=((UW *)((V *)Rv9)[2])[10]|4;
        ((V *)Rv13)[4]=Rv0;
        break;
      }
    }
    else {
      Ra.sl[6]=2494; /* line # 2494 */
      P_src_error(Rd.s+537,107,3);
      Rv2=P_lgt_new_econst(V_typ_std.v[21],0);
    }
  }
  else {
    Ra.sl[6]=2500; /* line # 2500 */
    switch (V_sy_sym.ub[0]) {
      case 27:Rv2=P_lgt_new_econst(V_typ_std.v[13],0);
      break;
      case 2:Rv2=P_lgt_new_econst(V_typ_std.v[2],V_sy_ival);
      break;
      case 3:Ra.sl[6]=2505; /* line # 2505 */
      Rv2=P_lgt_new_econst(V_typ_std.v[3],0);
      ((G *)((V *)Rv2)[7])[7]=V_sy_rval;
      break;
      case 4:Ra.sl[6]=2510; /* line # 2510 */
      Rv2=P_lgt_new_econst(V_typ_std.v[4],0);
      ((G *)((V *)Rv2)[7])[7]=V_sy_rval;
      break;
      case 5:Ra.sl[6]=2515; /* line # 2515 */
      Rv2=P_lgt_new_econst(V_typ_std.v[0],(SL)V_sy_string.c[2]);
      if (V_sy_string.ub[1]!=1) {
        Rv14=Rv2;
        Rv15=((V *)Rv14)[7];
        Ra.sl[6]=2521; /* line # 2521 */
        ((V *)Rv14)[3]=V_typ_std.v[10];
        ((UB *)Rv15)[48]=29;
        ((SL *)Rv15)[6]=V_sy_string.ub[1];
        ((V *)Rv15)[4]=((V *)Rv14)[3];
        if (V_sy_string.ub[1]>0) {
          Ra.sl[6]=2527; /* line # 2527 */
          Rv16=V_sy_string.ub[1];
          ((V *)Rv15)[7]=PAS__NEW((SL)Rv16+2);
          ((UB *)((V *)Rv15)[7])[0]=Rv16;
          PAS__STR_TO_STR(((V *)Rv15)[7],V_sy_string.s);
        }
        else((V *)Rv15)[7]=NULL;
      }
      break;
      default:Ra.sl[6]=2535; /* line # 2535 */
      if (Ri.ub[0]) P_src_error(Rd.s+537,44,2);
      P_lgt_new(&Rv2, V_typ_std.v[21],17,NULL);
      break;
    }
    Ra.sl[6]=2540; /* line # 2540 */
    if (((UB *)Rv2)[40]!=17) P_insymbol();
  }
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_indir "  */
V PAS_COMILER_PRC_00000026(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+541;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2556; /* line # 2556 */
  Rv0=F_pobj;
  Rv1=((V *)F_pobj)[3];
  switch (((UB *)Rv1)[93]) {
    case 7:Ra.sl[6]=2562; /* line # 2562 */
    ((V *)F_pobj)[3]=V_typ_std.v[13];
    P_lgt_new(&Rv0, V_typ_std.v[13],2, F_pobj);
    Rv2=Rv0;
    ((UW *)Rv2)[10]=((UW *)Rv2)[10]|4;
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, Rv0);
    break;
    case 5:Ra.sl[6]=2570; /* line # 2570 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, F_pobj);
    break;
    case 6:Ra.sl[6]=2576; /* line # 2576 */
    Rv0=PAS_COMILER_PRC_00000010(F_pobj);
    break;
    default:P_src_error(Rd.s+554,151,3);
    break;
  }
  Ra.sl[6]=2582; /* line # 2582 */
  if (((UB *)Rv1)[93]!=6) {
    Rv3=Rv0;
    ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_field "  */
V PAS_COMILER_PRC_00000027(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+558;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2601; /* line # 2601 */
  Rv0=0;
  Rv1=NULL;
  Rv2=0;
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2606; /* line # 2606 */
    Rv3=F_pobj;
    Rv4=((V *)Rv3)[3];
    if (((V *)Rv4)[4]!=NULL) {
      Rv1=P_level_search(((V *)Rv4)[4]);
      Ra.sl[6]=2611; /* line # 2611 */
      if (Rv1!=NULL) {
        Rv5=Rv1;
        if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
        Ra.sl[6]=2616; /* line # 2616 */
        ((UW *)Rv3)[10]=(((UW *)Rv3)[10]|1)&~2;
        Rv2=((SL *)Rv5)[14];
      }
    }
    Ra.sl[6]=2621; /* line # 2621 */
    if (Rv1==NULL) {
      if (((UB *)Rv4)[93]!=10) {
        F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
        P_src_error(Rd.s+571,152,3);
        Ra.sl[6]=2626; /* line # 2626 */
        Rv0=1;
      }
      else {
        Rv1=P_level_search(((V *)Rv4)[12]);
        Ra.sl[6]=2631; /* line # 2631 */
        if (Rv1!=NULL) {
          Rv6=Rv1;
          if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
          Rv2=((SL *)Rv6)[14];
        }
        else Ra.sl[6]=2638; /* line # 2638 */
      }
    }
    if (Rv1!=NULL) {
      Rv7=Rv1;
      Ra.sl[6]=2643; /* line # 2643 */
      if (Rv2!=0&&V_curr_descr==F_pobj) {
        if (((UB *)Rv3)[40]==14) {
          P_lgt_new_copy(F_pobj, &F_pobj);
          ((V *)F_pobj)[3]=((V *)Rv7)[5];
        }
        else {
          P_lgt_new(&F_pobj,((V *)Rv7)[5],3, F_pobj);
          ((UW *)F_pobj)[10]=((UW *)((V *)F_pobj)[1])[10];
        }
      }
      else {
        Ra.sl[6]=2650; /* line # 2650 */
        Rv2=((SL *)Rv3)[4]+Rv2;
        ((V *)Rv3)[3]=((V *)Rv7)[5];
      }
      ((SL *)F_pobj)[4]=((SL *)Rv3)[4]+Rv2;
    }
    else {
      Ra.sl[6]=2655; /* line # 2655 */
      F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
      P_src_error_s(Rd.s+571,153,2, V_sy_ident.s,NULL);
      Rv0=1;
    }
    Ra.sl[6]=2660; /* line # 2660 */
    P_insymbol();
  }
  else {
    P_src_error(Rd.s+571,156,3);
    Ra.sl[6]=2665; /* line # 2665 */
    Rv0=1;
  }
  Rv8=F_pobj;
  if (Rv0) ((V *)Rv8)[3]=V_typ_std.v[21];
  else {
    Ra.sl[6]=2672; /* line # 2672 */
    ((SL *)Rv8)[4]=Rv2;
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    if (((UB *)Rv8)[40]==14) {
      if (((V *)Rv8)[3]!=NULL) {
        if (((UB *)((V *)Rv8)[3])[92]) P_lgt_extract_simple_cte(F_pobj);
      }
    }
  }
  Ra.sl[6]=2679; /* line # 2679 */
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_index "  */
V PAS_COMILER_PRC_00000028(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+575;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2693; /* line # 2693 */
  Rv0=F_pobj;
  if (P_comp_type(((V *)F_pobj)[3],V_typ_std.v[10],1,0)) {
    Ra.sl[6]=2698; /* line # 2698 */
    V_curr_descr=F_pobj;
    P_lgt_new(&Rv0,((V *)((V *)V_typ_std.v[10])[13])[5],3, F_pobj);
    ((SL *)Rv0)[4]=((SL *)((V *)V_typ_std.v[10])[13])[14];
  }
  else {
    Ra.sl[6]=2703; /* line # 2703 */
    Rv1=F_pobj;
    if (((SL *)((V *)F_pobj)[3])[10]>0) {
      V_curr_descr=F_pobj;
      P_lgt_new(&Rv0,((V *)F_pobj)[3],3, F_pobj);
      Ra.sl[6]=2708; /* line # 2708 */
      ((SL *)Rv0)[4]=((SL *)F_pobj)[4]+((SL *)((V *)F_pobj)[3])[10];
    }
    else Rv0=F_pobj;
  }
  Rv2=Rv0;
  Ra.sl[6]=2714; /* line # 2714 */
  Rv3=((V *)Rv2)[3];
  if (((UB *)Rv3)[93]==8||((UB *)Rv3)[93]==9) {
    Rv4=PAS_COMILER_PRC_00000005(((V *)Rv3)[15],0,0,0);
    Ra.sl[6]=2719; /* line # 2719 */
    if (((UB *)Rv4)[40]==14) {
      Rv5=((SL *)((V *)Rv4)[7])[13];
      P_lgt_free(&Rv4);
    }
    Ra.sl[6]=2724; /* line # 2724 */
    Rv6=NULL;
    Rv7=NULL;
    Rv8=NULL;
    Rv9=((V *)Rv3)[15];
    Ra.sl[6]=2729; /* line # 2729 */
    if (((UB *)Rv9)[93]==22) {
      if (((UB *)((V *)Rv9)[13])[40]==14) {
        Rv10=((SL *)((V *)((V *)Rv9)[13])[7])[13];
        Rv7=((V *)Rv9)[14];
      }
      else {
        Ra.sl[6]=2737; /* line # 2737 */
        Rv6=P_lgt_type_eval(((V *)Rv9)[13],V_curr_descr,NULL,0);
        Ra.sl[6]=2744; /* line # 2744 */
        if (((UB *)((V *)Rv9)[14])[40]==14) {
          Rv11=((SL *)((V *)((V *)Rv9)[14])[7])[13];
          Rv7=((V *)Rv9)[14];
        }
      }
    }
    else {
      Ra.sl[6]=2752; /* line # 2752 */
      Rv10=((SL *)Rv9)[29];
      Rv11=((SL *)Rv9)[30];
    }
    if (((SL *)Rv3)[25]>0) Rv12=((SL *)Rv3)[25];
    else {
      Ra.sl[6]=2759; /* line # 2759 */
      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
      if (Rv8!=NULL) {
        Rv13=Rv8;
        if (((UB *)Rv13)[40]==14) {
          Ra.sl[6]=2764; /* line # 2764 */
          Rv12=((SL *)((V *)Rv13)[7])[13];
          P_lgt_free(&Rv8);
        }
      }
    }
    Ra.sl[6]=2769; /* line # 2769 */
    if (Rv4==NULL&&Rv6==NULL) {
      if (Rv5<Rv10||Rv7==NULL&&Rv5>Rv11) P_src_error(Rd.s+588,154,2);
      Rv5=Rv5-Rv10;
      Ra.sl[6]=2774; /* line # 2774 */
      if (Rv8==NULL) {
        Rv14=Rv0;
        ((SL *)Rv14)[4]=((SL *)Rv2)[4]+Rv5*Rv12;
        ((V *)Rv14)[3]=((V *)Rv3)[14];
      }
      else {
        Ra.sl[6]=2782; /* line # 2782 */
        Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        ((V *)Rv0)[0]=Rv4;
        ((V *)Rv4)[0]=Rv8;
        P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
        ((UW *)Rv14)[10]=((UW *)Rv0)[10];
        Ra.sl[6]=2787; /* line # 2787 */
        ((V *)Rv14)[6]=((V *)Rv2)[3];
      }
    }
    else {
      Ra.sl[6]=2792; /* line # 2792 */
      P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
      ((V *)Rv14)[6]=((V *)Rv2)[3];
      if (Rv8==NULL) {
        if (Rv4==NULL) {
          Ra.sl[6]=2798; /* line # 2798 */
          Rv4=P_lgt_new_code(46, Rv6);
          ((SL *)Rv14)[4]=Rv5*Rv12;
        }
        else {
          Ra.sl[6]=2803; /* line # 2803 */
          if (Rv6==NULL) ((SL *)Rv14)[4]= -Rv10*Rv12;
          else {
            Ra.sl[6]=2808; /* line # 2808 */
            ((V *)Rv4)[0]=Rv6;
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        ((V *)Rv4)[0]=P_lgt_new_econst(V_int_typ, Rv12);
      }
      else {
        Ra.sl[6]=2816; /* line # 2816 */
        if (Rv4==NULL) {
          if (Rv5!=0) Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        }
        else {
          Ra.sl[6]=2822; /* line # 2822 */
          if (Rv6==NULL) {
            if (Rv10!=0) Rv6=P_lgt_new_econst(V_int_typ, Rv10);
          }
        }
        if (Rv4==NULL) {
          Ra.sl[6]=2827; /* line # 2827 */
          Rv4=P_lgt_new_code(46, Rv4);
        }
        else {
          if (Rv6!=NULL) {
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2832; /* line # 2832 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        ((V *)Rv4)[0]=Rv8;
      }
      ((V *)Rv0)[0]=Rv4;
    }
  }
  else {
    Ra.sl[6]=2841; /* line # 2841 */
    P_src_error(Rd.s+588,155,3);
    ((V *)Rv2)[3]=V_typ_std.v[21];
    ((V *)Rv2)[1]=NULL;
    Rv14=F_pobj;
    P_skip_symbol(16,0,0);
  }
  Ra.sl[6]=2848; /* line # 2848 */
  Rv15=Rv14;
  Ra.sl[6]=2859; /* line # 2859 */
  ((UW *)Rv15)[10]=((UW *)Rv15)[10]|4;
  if (((UB *)Rv15)[40]==14) {
    if (((V *)Rv15)[3]!=NULL) {
      if (((UB *)((V *)Rv15)[3])[92]) P_lgt_extract_simple_cte(Rv14);
    }
  }
  Ra.sl[6]=2865; /* line # 2865 */
  Ret=Rv14;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_una "  */
V PAS_COMILER_PRC_00000034(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  UB Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+592;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2910; /* line # 2910 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) V_sy_sym.ub[0]
  =6;
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=2916; /* line # 2916 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else Rv0=29;
    P_insymbol();
    Rv1=PAS_COMILER_PRC_00000034();
    if (Rv0!=29) {
      Ra.sl[6]=2921; /* line # 2921 */
      if (((UB *)Rv1)[40]!=17) Rv1=P_exp_genop(Rv0, Rv1);
    }
  }
  else {
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=2926; /* line # 2926 */
      P_insymbol();
      Rv1=PAS_COMILER_PRC_00000000();
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else P_src_error(Rd.s+603,23,3);
    }
    else {
      Ra.sl[6]=2931; /* line # 2931 */
      if (V_sy_sym.ub[0]==15) Rv1=PAS_COMILER_PRC_00000022();
      else {
        Ra.sl[6]=2936; /* line # 2936 */
        Rv1=PAS_COMILER_PRC_00000025();
        Rv2=((UB *)Rv1)[40]!=17;
        if (((SL *)((V *)Rv1)[3])[10]>0) V_curr_descr=Rv1;
        while (Rv2)
        switch (V_sy_sym.ub[0]) {
          case 23:Ra.sl[6]=2943; /* line # 2943 */
          P_insymbol();
          Rv1=PAS_COMILER_PRC_00000026(Rv1);
          if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
          break;
          case 15:Ra.sl[6]=2950; /* line # 2950 */
          V_sy_sym.ub[0]=17;
          while (V_sy_sym.ub[0]==17){
            P_insymbol();
            Rv1=PAS_COMILER_PRC_00000028(Rv1);
            Ra.sl[6]=2955; /* line # 2955 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
          }
          if (V_sy_sym.ub[0]==16) P_insymbol();
          else P_src_error(Rd.s+603,26,2);
          break;
          case 19:Ra.sl[6]=2963; /* line # 2963 */
          P_insymbol();
          Rv1=PAS_COMILER_PRC_00000027(Rv1);
          if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
          break;
          case 24:Ra.sl[6]=2969; /* line # 2969 */
          Rv1=PAS_COMILER_PRC_00000007(Rv1,((V *)Rv1)[3]);
          break;
          default:Rv2=0;
          break;
        }
      }
    }
  }
  Ra.sl[6]=2977; /* line # 2977 */
  Ri.ub[0]=0;
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_pow "  */
V PAS_COMILER_PRC_00000033(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+607;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2982; /* line # 2982 */
  Rv0=PAS_COMILER_PRC_00000034();
  if (((UB *)Rv0)[40]!=17) {
    if (V_sy_sym.ub[0]==7) {
      Ra.sl[6]=2987; /* line # 2987 */
      Rv1=V_sy_sym.ub[1];
      P_insymbol();
      Ri.ub[0]=1;
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000034();
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=2993; /* line # 2993 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_mul "  */
V PAS_COMILER_PRC_00000032(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+616;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2997; /* line # 2997 */
  Rv0=PAS_COMILER_PRC_00000033();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==8){
    Ra.sl[6]=3002; /* line # 3002 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000033();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3008; /* line # 3008 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_add "  */
V PAS_COMILER_PRC_00000031(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+625;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3012; /* line # 3012 */
  Rv0=PAS_COMILER_PRC_00000032();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==9){
    Ra.sl[6]=3017; /* line # 3017 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000032();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3023; /* line # 3023 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_rel "  */
V PAS_COMILER_PRC_00000030(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+634;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3027; /* line # 3027 */
  Rv0=PAS_COMILER_PRC_00000031();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==10){
    Ra.sl[6]=3032; /* line # 3032 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000031();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3038; /* line # 3038 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_and "  */
V PAS_COMILER_PRC_00000029(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+643;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3041; /* line # 3041 */
  Rv0=PAS_COMILER_PRC_00000030();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==11){
    Ra.sl[6]=3046; /* line # 3046 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000030();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3052; /* line # 3052 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " expression "  */
V PAS_COMILER_PRC_00000000(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+652;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3056; /* line # 3056 */
  Rv0=PAS_COMILER_PRC_00000029();
  if (((UB *)Rv0)[40]!=17) while (V_sy_sym.ub[0]==12){
    Ra.sl[6]=3061; /* line # 3061 */
    Rv1=V_sy_sym.ub[1];
    P_insymbol();
    Ri.ub[0]=1;
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000029();
    Rv0=P_exp_genop(Rv1, Rv0);
  }
  Ra.sl[6]=3067; /* line # 3067 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_work_list "  */
V PAS_COMILER_PRC_00000039(UB F_mode, V F_ty, UB F_blist){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+664;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3159; /* line # 3159 */
  Rv0=NULL;
  switch (F_mode) {
    case 2:
    case 29:Ra.sl[6]=3164; /* line # 3164 */
    P_lgt_new(&Rv0,NULL,16,NULL);
    PAS_COMILER_PRC_00000038(((V *)Rv0)+3,0,NULL,0,0,NULL);
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) P_src_error(
    Rd.s+682,35,2);
    break;
    case 41:Ra.sl[6]=3171; /* line # 3171 */
    Rv2=F_ty;
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else P_src_error(Rd.s+682,22,2);
    P_ide_new_typ(23, &Rv3);
    Ra.sl[6]=3176; /* line # 3176 */
    P_lgt_new(&Rv0, Rv3,16,NULL);
    Rv4=Rv3;
    ((SL *)Rv4)[11]=Lx[2].sl[0];
    ((V *)Rv4)[12]=NULL;
    Ra.sl[6]=3181; /* line # 3181 */
    ((V *)Rv4)[13]=NULL;
    ((V *)Rv4)[14]=NULL;
    PAS_COMILER_PRC_00000037(6,((SL *)Rv4)+11,&Rv5, Rv3);
    if (Lx[2].v[1]==NULL) ((V *)Rv4)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    else {
      Ra.sl[6]=3187; /* line # 3187 */
      ((V *)Rv4)[12]=((V *)Lx[2].v[1])[3];
    }
    if (((V *)Rv4)[13]==NULL) ((V *)Rv4)[13]=V_lex_ident_tree.v[V_curr_disp*8+4]
    ;
    Lx[2].v[1]=((V *)Rv4)[13];
    Ra.sl[6]=3193; /* line # 3193 */
    if (((SL *)Rv3)[11]>((SL *)Rv2)[11]) ((SL *)Rv2)[11]=((SL *)Rv3)[11];
    else {
      if (((SL *)Rv3)[11]<0) ((SL *)Rv2)[11]=-1;
    }
    if (Rv5>((UB *)Rv2)[48]) ((UB *)Rv2)[48]=Rv5;
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=3198; /* line # 3198 */
      P_src_error(Rd.s+682,23,2);
    }
    break;
    case 22:Ra.sl[6]=3203; /* line # 3203 */
    Rv0=PAS_COMILER_PRC_00000005(F_ty,0,0,0);
    if ((V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) P_src_error(
    Rd.s+682,35,2);
    break;
    default:Ra.sl[6]=3209; /* line # 3209 */
    if (F_blist) Rv0=PAS_COMILER_PRC_00000035(72,1);
    else Rv0=PAS_COMILER_PRC_00000036(NULL,1);
    if (Rv0==NULL) {
      P_lgt_new(&Rv0,NULL,16,NULL);
      Ra.sl[6]=3214; /* line # 3214 */
      if (F_blist) {
        Rv1=Rv0;
        ((UW *)Rv1)[10]=((UW *)Rv1)[10]|2048;
      }
    }
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3219; /* line # 3219 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_definition "  */
V PAS_COMILER_PRC_00000004(UB F_mode, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 2096 );

  /* Local variable stored in C variable */
  V Rv0;
  C Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  UB Rv14;
  UB Rv15;
  UB Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  SL Rv25;
  register int Rf0;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+686;
  Ra.v[4]=Rd.s+17;
  Ra.sl[10]=3226; /* line # 3226 */
  if (F_mode==41) Ra.sl[0]=abs(((SL *)F_ty)[11]);
  else {
    Ra.sl[10]=3231; /* line # 3231 */
    Ra.sl[0]=0;
  }
  Rv0=NULL;
  if (F_mode==41) {
    Ra.sl[10]=3236; /* line # 3236 */
    if (F_ty!=NULL) Ra.v[1]=((V *)F_ty)[13];
    V_sy_casedef=1;
    Rv1=P_src_search_char();
    if (Rv1==58) {
      Ra.sl[10]=3242; /* line # 3242 */
      P_ide_new(6,NULL,&Rv2);
      Ra.v[1]=Rv2;
      P_insymbol();
      if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+682,29,2);
      else P_insymbol();
      Ra.sl[10]=3248; /* line # 3248 */
      Rv3=1;
    }
    else Rv3=0;
    Ra.sl[10]=3253; /* line # 3253 */
    V_err_prt=0;
    Rv4=P_ide_search(2);
    V_err_prt=1;
    if (!Rv3&&Rv4!=NULL) {
      Ra.sl[10]=3258; /* line # 3258 */
      Rv1=P_src_search_char();
      if (Rv1==34||Rv1==40) Rv4=NULL;
    }
    if (Rv4!=NULL) {
      Ra.sl[10]=3263; /* line # 3263 */
      Rv0=((V *)Rv4)[5];
      if (!P_comp_type(Rv0, V_typ_std.v[15],0,0)) {
        P_src_error(Rd.s+682,60,2);
        Ra.sl[10]=3268; /* line # 3268 */
        Rv0=V_typ_std.v[2];
      }
      if (Rv3) {
        Rv5=Rv2;
        Ra.sl[10]=3273; /* line # 3273 */
        ((V *)Rv5)[5]=Rv0;
        ((SL *)Rv5)[14]=P_ide_typ_align(Ra.sl[0],Rv0);
        Ra.sl[0]=((SL *)Rv5)[14]+((SL *)Rv0)[11];
        if (((UB *)Rv0)[48]>((UB *)F_ty)[48]) {
          Ra.sl[10]=3278; /* line # 3278 */
          ((UB *)F_ty)[48]=((UB *)Rv0)[48];
        }
      }
      P_lgt_new(&Rv6, Rv0,16,NULL);
      if (Rv3) ((V *)Rv6)[4]=Rv2;
      Ra.sl[10]=3283; /* line # 3283 */
      P_insymbol();
    }
  }
  if (Rv0==NULL) {
    Ra.sl[10]=3290; /* line # 3290 */
    Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
    if (F_mode==29||F_mode==41) P_type_check_parm(Rv6);
    else {
      if (F_mode==2) {
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[10]=3296; /* line # 3296 */
          P_src_error(Rd.s+682,61,3);
        }
      }
    }
    Rv0=((V *)Rv6)[3];
  }
  if (V_sy_sym.ub[0]!=87) P_src_error(Rd.s+682,51,2);
  Ra.sl[10]=3302; /* line # 3302 */
  P_lgt_new(&Rv7,((V *)Rv6)[3],14,NULL);
  Rv8=Rv7;
  ((V *)Rv8)[0]=Rv6;
  P_val_new(((V *)Rv8)+7,NULL);
  Ra.sl[10]=3307; /* line # 3307 */
  ((UB *)((V *)Rv8)[7])[48]=21;
  P_lgt_new(&Rv9,((V *)Rv6)[3],0, Rv7);
  ((UB *)Rv9)[41]=3;
  Rv10=0;
  for( Rf0=512;Rf0>0;Rf0-- ) {
    Ra.sl[Rv10+11]=-1;
    Rv10++;
  }
  Ra.sl[10]=3312; /* line # 3312 */
  Rv11=0;
  Rv12=1;
  Rv13=0;
  Rv14=0;
  Rv15=1;
  Rv16=V_sy_label_flag;
  while (1){
    Ra.sl[10]=3317; /* line # 3317 */
    if (Rv15) V_sy_sym.ub[0]=17;
    V_sy_label_flag=0;
    while (V_sy_sym.ub[0]==17||!Rv15){
      if (Rv15) P_insymbol();
      else {
        Ra.sl[10]=3322; /* line # 3322 */
        Rv15=1;
      }
      Rv17=PAS_COMILER_PRC_00000006(&Rv0);
      if (V_sy_sym.ub[0]==20) {
        Ra.sl[10]=3327; /* line # 3327 */
        P_insymbol();
        Rv18=PAS_COMILER_PRC_00000006(&Rv0);
        if (Rv18<Rv17) {
          Rv18=Rv17;
          P_src_error(Rd.s+682,62,2);
        }
      }
      else {
        Ra.sl[10]=3332; /* line # 3332 */
        Rv18=Rv17;
      }
      while (1){
        if (Rv12>Rv13) {
          Rv12=Rv17;
          Rv13=Rv17;
          Rv19=Rv17;
          Ra.sl[10]=3337; /* line # 3337 */
          Ra.sl[11]=Rv11;
        }
        else {
          if (Rv17>Rv13) Rv13=Rv17;
          else {
            Ra.sl[10]=3342; /* line # 3342 */
            if (Rv17<Rv12) Rv12=Rv17;
          }
          Rv20=Rv17-Rv19;
          if (Rv20<0) Rv20=(Rv20+511)+1;
          if (Rv20<0||Rv20>511) {
            Ra.sl[10]=3347; /* line # 3347 */
            P_src_error(Rd.s+682,63,3);
          }
          else {
            if (Ra.sl[Rv20+11]!=-1) {
              Ra.sl[10]=3352; /* line # 3352 */
              P_src_error(Rd.s+682,64,2);
            }
            else Ra.sl[Rv20+11]=Rv11;
          }
        }
        Ra.sl[10]=3357; /* line # 3357 */
        Rv17=Rv17+1;
        if (Rv17>Rv18)  break;
      }
    }
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+682,31,2);
    V_sy_label_flag=Rv16;
    Ra.sl[10]=3363; /* line # 3363 */
    Rv21=PAS_COMILER_PRC_00000039(F_mode, F_ty,0);
    if (V_sy_sym.ub[0]==18) {
      V_sy_label_flag=0;
      P_insymbol();
      Ra.sl[10]=3368; /* line # 3368 */
      Rv15=0;
    }
    if (Rv21==NULL) P_lgt_new(&Rv21,NULL,16,NULL);
    ((V *)Rv6)[0]=Rv21;
    Rv6=Rv21;
    Ra.sl[10]=3373; /* line # 3373 */
    Rv11=Rv11+1;
    if (((V_sy_sym.ub[0]==88||V_sy_sym.ub[0]==72)||V_sy_sym.ub[0]==14)||V_sy_sym
    .ub[0]==90)  break;
  }
  V_sy_label_flag=Rv16;
  if (V_sy_sym.ub[0]==88) {
    Ra.sl[10]=3378; /* line # 3378 */
    P_insymbol();
    Rv6=PAS_COMILER_PRC_00000039(F_mode, F_ty,1);
  }
  else {
    Ra.sl[10]=3383; /* line # 3383 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    if (F_mode==41) {
      P_ide_new_typ(23,((V *)Rv6)+3);
      Rv22=((V *)Rv6)[3];
      Ra.sl[10]=3389; /* line # 3389 */
      ((V *)Rv22)[12]=NULL;
      ((V *)Rv22)[13]=NULL;
      ((V *)Rv22)[14]=NULL;
      ((SL *)Rv22)[11]=Ra.sl[0];
    }
  }
  Ra.sl[10]=3396; /* line # 3396 */
  Rv21=((V *)Rv7)[0];
  ((V *)Rv6)[0]=Rv21;
  ((V *)Rv7)[0]=Rv6;
  if (F_mode!=41) P_insymbol();
  Ra.sl[10]=3401; /* line # 3401 */
  ((SL *)Rv9)[4]=Rv11;
  Rv23=Rv7;
  Rv24=((V *)Rv23)[7];
  ((SL *)Rv23)[4]=Rv12;
  ((SL *)Rv24)[6]=(Rv13-Rv12)+1;
  Ra.sl[10]=3406; /* line # 3406 */
  ((V *)Rv24)[7]=P_tab_new(((SL *)Rv24)[6]);
  Rv17=Rv12-Rv19;
  if (Rv17<0) Rv17=(Rv17+511)+1;
  Rv25=0;
  for( Rf0=(Rv13-Rv12)+1;Rf0>0;Rf0-- ) {
    Ra.sl[10]=3411; /* line # 3411 */
    ((SL *)((V *)Rv24)[7])[Rv25]=Ra.sl[Rv17+11];
    Rv17=Rv17+1;
    if (Rv17>511) Rv17=0;
    Rv25++;
  }
  Ra.sl[10]=3417; /* line # 3417 */
  V_sy_casedef=0;
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " set_alignment_spc "  */
void PAS_COMILER_PRC_00000040(SL *F_sz, SL *F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+703;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3432; /* line # 3432 */
  if (Rs.sl[0]>0) {
    Ra.sl[6]=3437; /* line # 3437 */
    (*F_sz)=Rs.sl[0];
    Rv0=(*F_sz);
    Rs.sl[0]=-1;
    if (Rs.sl[1]<0) {
      (*F_aln)=1;
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3442; /* line # 3442 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  if (Rs.sl[1]>=0) {
    (*F_aln)=Rs.sl[1];
    Rs.sl[1]=-1;
  }
  Ra.sl[6]=3447; /* line # 3447 */
  if (V_sy_sym.ub[0]==73) {
    P_insymbol();
    (*F_sz)=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
    Ra.sl[6]=3452; /* line # 3452 */
    if ((*F_sz)<1) (*F_sz)=1;
    Rv0=(*F_sz);
    if (V_sy_sym.ub[0]==17) {
      P_insymbol();
      Ra.sl[6]=3457; /* line # 3457 */
      Rv0=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
      if (Rv0>256) P_src_error(Rd.s+724,231,2);
    }
    if (Rv0<0||Rv0>256) Rv0=((SL *)V_typ_std.v[4])[11];
    if (Rv0<=1) (*F_aln)=0;
    else {
      Ra.sl[6]=3463; /* line # 3463 */
      (*F_aln)=1;
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      (*F_aln)=(*F_aln)-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " conformant_def "  */
void PAS_COMILER_PRC_00000041(V *F_tr, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+728;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3484; /* line # 3484 */
  Rv0=NULL;
  Rv1=NULL;
  P_ide_new_typ(22, F_tr);
  Rv2=(*F_tr);
  if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv0);
  else {
    Ra.sl[6]=3489; /* line # 3489 */
    P_src_error(Rd.s+746,232,3);
  }
  P_insymbol();
  if (V_sy_sym.ub[0]==20) {
    P_insymbol();
    Ra.sl[6]=3494; /* line # 3494 */
    if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv1);
    else P_src_error(Rd.s+746,232,3);
    P_insymbol();
  }
  if (V_sy_sym.ub[0]==21) {
    Ra.sl[6]=3500; /* line # 3500 */
    P_insymbol();
    PAS_COMILER_PRC_00000038(((V *)Rv2),0,NULL,0,0,NULL);
    ((SL *)Rv2)[11]=((SL *)((V *)Rv2)[0])[11];
    memcpy(Rv2+48,((V *)Rv2)[0]+48,1);
    if (Rv0!=NULL) {
      Ra.sl[6]=3506; /* line # 3506 */
      ((V *)Rv0)[5]=((V *)Rv2)[0];
      ((UB *)Rv0)[86]=9;
      ((UW *)Rv0)[42]=32;
      if (Rv1==NULL) {
        Ra.sl[6]=3511; /* line # 3511 */
        ((V *)Rv2)[13]=P_lgt_new_econst(((V *)Rv2)[0],1);
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv0,NULL);
        ((V *)Rv2)[12]=P_lgt_link(((V *)Rv2)[14]);
        ((V *)((V *)Rv2)[12])[3]=V_int_typ;
        (*F_ndim)=(*F_ndim)+1;
      }
      else {
        Ra.sl[6]=3519; /* line # 3519 */
        ((V *)Rv1)[5]=((V *)Rv2)[0];
        ((UB *)Rv1)[86]=9;
        ((UW *)Rv1)[42]=32;
        ((V *)Rv2)[13]=P_lgt_new_idref(Rv0,NULL);
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=3524; /* line # 3524 */
        Rv3=P_lgt_link(((V *)Rv2)[14]);
        ((V *)Rv3)[0]=P_lgt_link(((V *)Rv2)[13]);
        Rv3=P_lgt_new_code(50, Rv3);
        ((V *)Rv3)[0]=P_lgt_new_econst(V_int_typ,1);
        ((V *)Rv2)[12]=P_lgt_new_code(49, Rv3);
        Ra.sl[6]=3529; /* line # 3529 */
        (*F_ndim)=(*F_ndim)+2;
      }
    }
  }
  else P_src_error(Rd.s+746,31,3);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_def "  */
void PAS_COMILER_PRC_00000042(V *F_art, UB F_bconf, SL *F_ndim, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+750;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3551; /* line # 3551 */
  P_insymbol();
  if (F_bconf) P_ide_new_typ(9, F_art);
  else P_ide_new_typ(8, F_art);
  Rv0=(*F_art);
  Ra.sl[6]=3556; /* line # 3556 */
  ((V *)Rv0)[3]=F_owid;
  ((V *)Rv0)[15]=NULL;
  if (F_bconf) PAS_COMILER_PRC_00000041(((V *)Rv0)+15,F_ndim);
  else {
    Ra.sl[6]=3562; /* line # 3562 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+15,0,NULL,0,0,NULL);
    (*F_ndim)=(*F_ndim)+2;
  }
  Rv1=NULL;
  Rv2=1;
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=3567; /* line # 3567 */
    Rv3=((V *)Rv0)[15];
    switch (((UB *)Rv3)[93]) {
      case 0:
      case 1:
      case 2:if (((UB *)Rv3)[112]) Rv2=(((UL *)Rv3)[30]-((UL *)Rv3)[29])+1;
      else {
        Ra.sl[6]=3572; /* line # 3572 */
        Rv2=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
      break;
      case 22:Rv1=P_lgt_link(((V *)Rv3)[12]);
      break;
      default:Ra.sl[6]=3577; /* line # 3577 */
      P_src_error(Rd.s+763,210,3);
      break;
    }
  }
  Ra.sl[6]=3582; /* line # 3582 */
  if (V_sy_sym.ub[0]==17) {
    PAS_COMILER_PRC_00000042(((V *)Rv0)+14,F_bconf, F_ndim,NULL);
    ((SL *)Rv0)[24]=(*F_ndim);
  }
  else {
    Ra.sl[6]=3589; /* line # 3589 */
    ((SL *)Rv0)[24]=(*F_ndim);
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else P_src_error(Rd.s+763,26,2);
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+763,51,2);
    Ra.sl[6]=3594; /* line # 3594 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+14,0,NULL,0,0,NULL);
  }
  if (((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=3601; /* line # 3601 */
    ((UB *)Rv0)[48]=((UB *)((V *)Rv0)[14])[48];
    Rv4=((V *)Rv0)[14];
    Rv5=NULL;
    Ra.sl[6]=3606; /* line # 3606 */
    Rv6=((SL *)Rv4)[11];
    Rv7=((V *)Rv4)[9];
    memcpy(Ra.s+28,Rv4+48,1);
    if (Rv6>0) Rv6=P_typ_alignement(Rv6, Rv4+48);
    if (Rv6>=0) Rv7=NULL;
    Ra.sl[6]=3612; /* line # 3612 */
    if (Rv7!=NULL) {
      if (((UB *)Rv7)[40]==14) Rv6=((SL *)((V *)Rv7)[7])[13];
      else P_lgt_copy_tree(Rv7, &Rv5);
    }
    if ((Rv5!=NULL&&((UB *)Rv0)[48]>0)&&((UB *)((V *)Rv0)[14])[93]!=8) {
      Ra.sl[6]=3618; /* line # 3618 */
      Rv8=1;
      if ((((UB *)Rv5)[40]==6&&((UB *)Rv5)[41]==49)&&((V *)Rv5)[1]!=NULL) {
        if (((V *)((V *)Rv5)[1])[0]!=NULL) {
          Ra.sl[6]=3623; /* line # 3623 */
          Rv9=((V *)((V *)Rv5)[1])[0];
          if (((UB *)Rv9)[40]==14&&((V *)Rv9)[7]!=NULL) {
            Rv10=((SL *)((V *)Rv9)[7])[13]+Ra.ub[28];
            P_val_free(((V *)Rv9)+7);
            Ra.sl[6]=3628; /* line # 3628 */
            P_val_new(((V *)Rv9)+7,V_int_typ);
            ((SL *)((V *)Rv9)[7])[13]=Rv10;
            Rv8=0;
          }
        }
      }
      if (Rv8) {
        Ra.sl[6]=3634; /* line # 3634 */
        ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
        Rv5=P_lgt_new_code(49, Rv5);
      }
      ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
      Rv5=P_lgt_new_code(13, Rv5);
    }
    Ra.sl[6]=3641; /* line # 3641 */
    ((V *)Rv0)[13]=Rv5;
    ((SL *)Rv0)[25]=Rv6;
    if (((UB *)((V *)Rv0)[14])[91]||((SL *)((V *)Rv0)[14])[10]>0) {
      Ra.sl[6]=3646; /* line # 3646 */
      ((UB *)Rv0)[91]=1;
    }
    ((SL *)Rv0)[11]=((SL *)Rv0)[25]*Rv2;
    if (Rv1==NULL&&((V *)Rv0)[13]==NULL) {
      Ra.sl[6]=3651; /* line # 3651 */
      ((V *)Rv0)[9]=NULL;
    }
    else {
      if (Rv1==NULL) {
        Ra.sl[6]=3656; /* line # 3656 */
        Rv1=P_lgt_new_econst(V_int_typ, Rv2);
        ((V *)Rv1)[0]=((V *)Rv0)[13];
        ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
      }
      else {
        Ra.sl[6]=3661; /* line # 3661 */
        if (((V *)Rv0)[13]==NULL) {
          if (((SL *)Rv0)[25]==1) ((V *)Rv0)[9]=Rv1;
          else {
            Ra.sl[6]=3666; /* line # 3666 */
            ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
            ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
          }
        }
        else {
          Ra.sl[6]=3671; /* line # 3671 */
          ((V *)Rv1)[0]=((V *)Rv0)[13];
          ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
        }
      }
      ((SL *)Rv0)[11]=-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_spc "  */
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  SL Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  SL Rv24;
  SL Rv25;
  register V Rv26;
  SL Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;
  register V Rv31;
  register V Rv32;
  V Rv33;
  register V Rv34;
  register V Rv35;
  V Rv36;
  V Rv37;
  register V Rv38;
  register UB Rv39;
  register V Rv40;
  SL Rv41;
  V Rv42;
  register V Rv43;
  register V Rv44;
  register V Rv45;
  register V Rv46;
  register V Rv47;
  register V Rv48;
  register V Rv49;
  register V Rv50;
  register V Rv51;
  register V Rv52;
  register V Rv53;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+767;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3707; /* line # 3707 */
  V_sy_type_gfirst=NULL;
  Rv0=NULL;
  if (V_sy_sym.ub[0]==37) P_insymbol();
  Ra.sl[6]=3712; /* line # 3712 */
  switch (V_sy_sym.ub[0]) {
    case 29:Rv18=0;
    P_insymbol();
    Ra.sl[6]=3718; /* line # 3718 */
    if (V_sy_sym.ub[0]!=56) P_src_error(Rd.s+779,182,2);
    else P_insymbol();
    P_ide_new_typ(27, &Rv0);
    ((V *)Rv0)[9]=PAS_COMILER_PRC_00000004(29,NULL);
    break;
    case 58:Ra.sl[6]=3726; /* line # 3726 */
    P_insymbol();
    Rv1=P_ide_search(2);
    P_insymbol();
    if (Rv1!=V_ide_udptr.v[1]) {
      Rv19=Rv1;
      Ra.sl[6]=3732; /* line # 3732 */
      P_ide_new_typ(((UB *)((V *)Rv1)[5])[93],&Rv0);
      V_sy_type_gfirst=((V *)Rv19)[10];
      Rv20=Rv0;
      ((V *)Rv20)[3]=F_owid;
      Ra.sl[6]=3737; /* line # 3737 */
      ((V *)Rv20)[0]=((V *)Rv19)[5];
      ((V *)Rv20)[4]=((V *)((V *)Rv20)[0])[4];
      ((SL *)Rv20)[11]=((SL *)((V *)Rv20)[0])[11];
      ((SL *)Rv20)[10]=((SL *)((V *)Rv20)[0])[10];
      memcpy(Rv20+48,((V *)Rv20)[0]+48,1);
      Ra.sl[6]=3742; /* line # 3742 */
      ((V *)Rv20)[10]=((V *)((V *)Rv20)[0])[10];
      ((UB *)Rv20)[91]=((UB *)((V *)Rv20)[0])[91];
      if (((V *)Rv20)[9]!=NULL) ((V *)Rv20)[9]=P_lgt_link(((V *)((V *)Rv20)[0])[
9]);
      switch (((UB *)Rv20)[93]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=3749; /* line # 3749 */
        ((SL *)Rv20)[29]=((SL *)((V *)Rv20)[0])[29];
        ((SL *)Rv20)[30]=((SL *)((V *)Rv20)[0])[30];
        ((UB *)Rv20)[112]=((UB *)((V *)Rv20)[0])[112];
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 22:Ra.sl[6]=3757; /* line # 3757 */
        ((V *)Rv20)[12]=P_lgt_link(((V *)((V *)Rv20)[0])[12]);
        ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        break;
        case 3:
        case 4:break;
        case 5:
        case 7:
        case 24:
        case 26:Ra.sl[6]=3766; /* line # 3766 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 11:
        case 12:((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        break;
        case 8:Ra.sl[6]=3773; /* line # 3773 */
        ((SL *)Rv20)[25]=((SL *)((V *)Rv20)[0])[25];
        if (((V *)((V *)Rv20)[0])[13]!=NULL) ((V *)Rv20)[13]=P_lgt_link(((V *)((
        V *)Rv20)[0])[13]);
        else {
          Ra.sl[6]=3778; /* line # 3778 */
          ((V *)Rv20)[13]=NULL;
        }
        ((V *)Rv20)[14]=((V *)((V *)Rv20)[0])[14];
        ((V *)Rv20)[15]=((V *)((V *)Rv20)[0])[15];
        break;
        case 10:Ra.sl[6]=3785; /* line # 3785 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        if (((V *)((V *)Rv20)[0])[14]!=NULL) ((V *)Rv20)[14]=P_lgt_link(((V *)((
        V *)Rv20)[0])[14]);
        else {
          Ra.sl[6]=3790; /* line # 3790 */
          ((V *)Rv20)[14]=NULL;
        }
        break;
        case 14:
        case 15:
        case 19:
        case 21:Ra.sl[6]=3798; /* line # 3798 */
        Rv10=((SL *)Rv20)[11];
        Rv11=((UB *)Rv20)[48];
        PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
        if (Rv10<((SL *)Rv20)[11]) P_src_error(Rd.s+779,214,2);
        else((SL *)Rv20)[11]=Rv10;
        Ra.sl[6]=3803; /* line # 3803 */
        if (Rv11>=0) ((UB *)Rv20)[48]=Rv11;
        break;
        default:Ra.sl[6]=3808; /* line # 3808 */
        P_src_error(Rd.s+779,206,3);
        break;
      }
    }
    break;
    case 43:Ra.sl[6]=3816; /* line # 3816 */
    if (F_parm!=NULL) P_src_error(Rd.s+779,207,2);
    P_insymbol();
    if (V_sy_sym.ub[0]==38) {
      if (F_bdeforg) {
        Ra.sl[6]=3821; /* line # 3821 */
        P_insymbol();
        P_ide_new_typ(24, &Rv0);
        Rv21=Rv0;
        ((V *)Rv21)[3]=F_owid;
        Ra.sl[6]=3826; /* line # 3826 */
        ((V *)Rv21)[12]=NULL;
        ((SL *)Rv21)[11]=V_fptr_size;
        memcpy(Rv21+48,V_typ_std.v[5]+48,1);
        ((V *)Rv21)[9]=NULL;
      }
      else {
        Ra.sl[6]=3833; /* line # 3833 */
        P_src_error(Rd.s+779,208,3);
      }
    }
    else {
      P_ide_new_typ(26, &Rv0);
      Rv22=Rv0;
      Ra.sl[6]=3839; /* line # 3839 */
      ((V *)Rv22)[12]=NULL;
      ((V *)Rv22)[9]=NULL;
      memcpy(Rv22+48,V_typ_std.v[2]+48,1);
      ((SL *)Rv22)[11]=1;
    }
    Ra.sl[6]=3846; /* line # 3846 */
    Rv23=Rv0;
    Rv10=((SL *)Rv23)[11];
    Rv11=((UB *)Rv23)[48];
    Ra.sl[6]=3851; /* line # 3851 */
    PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
    if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv0);
    if (Rv10<((SL *)Rv23)[11]) P_src_error(Rd.s+779,214,2);
    else((SL *)Rv23)[11]=Rv10;
    if (Rv11>=0) ((UB *)Rv23)[48]=Rv11;
    break;
    case 40:Ra.sl[6]=3861; /* line # 3861 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+779,25,2);
    Rv24=0;
    PAS_COMILER_PRC_00000042(&Rv0,0, &Rv24, F_owid);
    Ra.sl[6]=3866; /* line # 3866 */
    if (V_ima_typ==NULL) V_ima_typ=Rv0;
    break;
    case 41:Ra.sl[6]=3871; /* line # 3871 */
    Rv25=V_curr_disp;
    P_ide_new_typ(10, &Rv0);
    Rv26=Rv0;
    ((V *)Rv26)[3]=F_owid;
    Ra.sl[6]=3876; /* line # 3876 */
    ((SL *)Rv26)[10]=F_descr_sz;
    ((SL *)Rv26)[11]=((SL *)Rv26)[10];
    ((V *)Rv26)[12]=NULL;
    ((V *)Rv26)[13]=NULL;
    ((V *)Rv26)[14]=NULL;
    Rv1=NULL;
    Ra.sl[6]=3882; /* line # 3882 */
    P_insymbol();
    P_new_disp_level(NULL,1);
    Lx[5].ub[0]=0;
    PAS_COMILER_PRC_00000037(6,((SL *)Rv0)+11,&Rv27, Rv0);
    Rv28=Rv0;
    Ra.sl[6]=3888; /* line # 3888 */
    ((UB *)Rv28)[91]=Lx[5].ub[0];
    ((V *)Rv28)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    if (((V *)Rv28)[14]==NULL) ((V *)Rv28)[13]=V_lex_ident_tree.v[V_curr_disp*8+
4];
    Ra.sl[6]=3893; /* line # 3893 */
    V_curr_disp=V_curr_disp -1;
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else P_src_error(Rd.s+779,54,2);
    if (V_typ_std.v[10]==NULL) {
      Ra.sl[6]=3899; /* line # 3899 */
      V_typ_std.v[10]=Rv0;
      Rv29=Rv0;
      V_stri_descrsz=((SL *)Rv29)[10];
      V_stri_lengthsz=((SL *)((V *)((V *)Rv29)[12])[5])[11];
      Ra.sl[6]=3904; /* line # 3904 */
      V_stri_stroffset=((SL *)((V *)((V *)Rv29)[12])[3])[14];
    }
    break;
    case 39:Ra.sl[6]=3911; /* line # 3911 */
    P_insymbol();
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+779,51,2);
    P_ide_new_typ(7, &Rv0);
    Rv30=Rv0;
    Ra.sl[6]=3916; /* line # 3916 */
    ((V *)Rv30)[3]=F_owid;
    memcpy(Rv30+48,V_typ_std.v[16]+48,1);
    ((SL *)Rv30)[11]=((SL *)V_typ_std.v[16])[11];
    ((V *)Rv30)[10]=((V *)V_typ_std.v[16])[10];
    ((V *)Rv30)[0]=V_typ_std.v[16];
    Ra.sl[6]=3922; /* line # 3922 */
    PAS_COMILER_PRC_00000038(((V *)Rv30)+12,0,NULL,0,0,NULL);
    if (((UB *)((V *)Rv30)[12])[91]||((SL *)((V *)Rv30)[12])[10]>0) ((UB *)Rv30)
    [91]=1;
    Ra.sl[6]=3927; /* line # 3927 */
    if (((SL *)((V *)Rv30)[12])[11]<=0) P_src_error(Rd.s+779,149,3);
    if (V_typ_std.v[7]==NULL) V_typ_std.v[7]=Rv0;
    break;
    case 23:
    case 38:Ra.sl[6]=3937; /* line # 3937 */
    P_insymbol();
    if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) Rv0=PAS_COMILER_PRC_00000002(V_sy_sym
    .ub[0]==77,NULL);
    else {
      Ra.sl[6]=3942; /* line # 3942 */
      P_ide_new_typ(5, &Rv0);
      Rv31=Rv0;
      ((V *)Rv31)[3]=F_owid;
      memcpy(Rv31+48,V_typ_std.v[13]+48,1);
      Ra.sl[6]=3947; /* line # 3947 */
      ((SL *)Rv31)[11]=V_fptr_size;
      ((V *)Rv31)[0]=V_typ_std.v[13];
      V_err_prt=0;
      Rv1=P_ide_search(2);
      V_err_prt=1;
      Ra.sl[6]=3952; /* line # 3952 */
      if (Rv1==NULL) {
        P_ide_new(1, Rv0, &Rv1);
        ((V *)Rv1)[7]=Lx[5].v[1];
        Lx[5].v[1]=Rv1;
      }
      else {
        Ra.sl[6]=3958; /* line # 3958 */
        ((V *)Rv31)[12]=((V *)Rv1)[5];
      }
      P_insymbol();
      V_sy_type_gfirst=P_new_oper(0, Rv0, V_typ_std.v[5],0,128,NULL,0,0);
    }
    break;
    case 13:Ra.sl[6]=3967; /* line # 3967 */
    if (V_ima_typ!=NULL) {
      if (((V *)V_ima_typ)[4]!=NULL) {
        P_insymbol();
        if (((SL *)V_typ_std.v[1])[30]==0) {
          Ra.sl[6]=3972; /* line # 3972 */
          Rv0=V_typ_std.v[1];
        }
        else P_ide_new_typ(1, &Rv0);
        Rv32=Rv0;
        Ra.sl[6]=3977; /* line # 3977 */
        ((V *)Rv32)[3]=F_owid;
        ((SL *)Rv32)[11]=((SL *)V_typ_std.v[0])[11];
        ((SL *)Rv32)[29]=0;
        ((SL *)Rv32)[30]=-1;
        ((V *)Rv32)[0]=NULL;
        ((UB *)Rv32)[112]=1;
        Ra.sl[6]=3982; /* line # 3982 */
        memcpy(Rv32+48,V_typ_std.v[0]+48,1);
        Rv25=0;
        Rv33=NULL;
        Rv10=0;
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=3988; /* line # 3988 */
          if (V_sy_ident.ub[0]>Rv25) Rv25=V_sy_ident.ub[0];
          P_ide_new(4, Rv0, &Rv1);
          if (((V *)Rv32)[12]==NULL) ((V *)Rv32)[12]=Rv1;
          ((SL *)Rv32)[30]=((SL *)Rv32)[30]+1;
          Ra.sl[6]=3993; /* line # 3993 */
          Rv34=Rv1;
          P_val_new(((V *)Rv34)+7,Rv0);
          Rv35=((V *)Rv34)[7];
          Ra.sl[6]=3999; /* line # 3999 */
          ((UB *)Rv35)[48]=1;
          ((SL *)Rv35)[13]=((SL *)Rv32)[30];
          Rv36=NULL;
          Ra.sl[6]=4004; /* line # 4004 */
          P_val_new(&Rv36,NULL);
          if (Rv33==NULL) Rv33=Rv36;
          else((V *)Rv37)[0]=Rv36;
          Rv37=Rv36;
          Ra.sl[6]=4009; /* line # 4009 */
          Rv38=Rv36;
          ((UB *)Rv38)[48]=29;
          ((SL *)Rv38)[6]=0;
          Rv39=V_sy_ident.ub[0]+1;
          ((V *)Rv38)[7]=PAS__NEW((SL)Rv39+2);
          ((UB *)((V *)Rv38)[7])[0]=Rv39;
          Ra.sl[6]=4014; /* line # 4014 */
          ((V *)Rv38)[4]=((V *)V_ima_typ)[14];
          Rv40=((V *)Rv38)[7];
          ((UB *)Rv40)[1]=V_sy_ident.ub[0]+1;
          ((C *)Rv40)[2]=V_sy_ident.c[0];
          Ra.sl[6]=4019; /* line # 4019 */
          Rv41=1;
          for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
            ((C *)Rv40)[(Rv41+1)+1]=V_sy_ident.c[Rv41];
            Rv41++;
          }
          Ra.sl[6]=4024; /* line # 4024 */
          P_insymbol();
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+779,23,2);
          }
          if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+779,27,2);
        }
        Ra.sl[6]=4030; /* line # 4030 */
        P_insymbol();
        Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv25);
        Rv6=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv32)[30]);
        ((V *)Rv6)[0]=Rv5;
        Ra.sl[6]=4035; /* line # 4035 */
        Rv42=P_type_parm_set(((V *)V_ima_typ)[3],Rv6);
        Rv36=Rv33;
        while (Rv36!=NULL){
          Rv43=Rv36;
          Ra.sl[6]=4041; /* line # 4041 */
          ((SL *)Rv43)[6]=Rv25+1;
          Rv36=((V *)Rv43)[0];
        }
        Ra.sl[6]=4046; /* line # 4046 */
        Rv44=((V *)V_ima_typ)[4];
        if (((V *)Rv44)[3]!=NULL) {
          P_val_new(&Rv36,((V *)((V *)Rv44)[3])[5]);
          Rv45=Rv36;
          Rv46=((V *)Rv44)[3];
          Ra.sl[6]=4052; /* line # 4052 */
          ((SL *)Rv45)[13]=Rv25;
          if (((V *)Rv46)[5]!=NULL) ((SL *)Rv45)[6]=((SL *)((V *)Rv46)[5])[11];
          ((V *)Rv45)[0]=Rv33;
          Rv33=Rv36;
          Ra.sl[6]=4057; /* line # 4057 */
          Rv36=NULL;
          P_val_new(&Rv36,((V *)Rv44)[5]);
          Rv47=Rv36;
          ((SL *)Rv47)[13]=((SL *)Rv32)[30];
          if (((V *)Rv44)[5]!=NULL) ((SL *)Rv47)[6]=((SL *)((V *)Rv44)[5])[11];
          Ra.sl[6]=4062; /* line # 4062 */
          ((V *)Rv47)[0]=Rv33;
          Rv33=Rv36;
        }
        P_lgt_new(((V *)Rv32)+13,Rv42,14,NULL);
        Ra.sl[6]=4067; /* line # 4067 */
        P_val_new(((V *)((V *)Rv32)[13])+7,Rv42);
        Rv48=((V *)Rv32)[13];
        Rv49=((V *)Rv48)[7];
        ((SL *)Rv49)[6]=((SL *)Rv42)[11];
        ((V *)Rv49)[7]=Rv33;
        Ra.sl[6]=4073; /* line # 4073 */
        if (((SL *)Rv32)[30]>255) {
          if (((SL *)Rv32)[30]>65535) ((SL *)Rv32)[11]=4;
          else((SL *)Rv32)[11]=2;
        }
        Ra.sl[6]=4080; /* line # 4080 */
        Rv10=((SL *)Rv32)[11];
        Rv11=Rv10-1;
        PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv0);
        if (Rv10<((SL *)Rv32)[11]) P_src_error(Rd.s+779,214,2);
        else {
          Ra.sl[6]=4085; /* line # 4085 */
          ((SL *)Rv32)[11]=Rv10;
        }
        if (Rv11>=0) ((UB *)Rv32)[48]=Rv11;
        V_sy_type_gfirst=P_new_oper(0, Rv0, V_typ_std.v[15],0,0,NULL,0,0);
      }
    }
    break;
    case 42:Ra.sl[6]=4094; /* line # 4094 */
    P_insymbol();
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+779,51,2);
    PAS_COMILER_PRC_00000038(&Rv42,0,NULL,0,0,NULL);
    if (((UB *)Rv42)[93]>2) {
      Ra.sl[6]=4099; /* line # 4099 */
      P_src_error(Rd.s+779,215,3);
      Rv42=V_typ_std.v[1];
    }
    Rv12=((SL *)Rv42)[30]+1;
    Ra.sl[6]=4104; /* line # 4104 */
    if (Rv12>V_dst_seta) Rv12=V_dst_seta;
    Rv25=(Rv12+7)/8;
    if (Rv25>2) Rv25=((Rv25+3)/4)*4;
    Ra.sl[6]=4111; /* line # 4111 */
    if (Rv12>V_dst_setw) {
      P_ide_new_typ(12, &Rv0);
      Rv11=((UB *)V_typ_std.v[18])[48];
    }
    else {
      Ra.sl[6]=4118; /* line # 4118 */
      P_ide_new_typ(11, &Rv0);
      Rv10=1;
      switch (Rv25) {
        case 1:Rv11=0;
        break;
        case 2:Rv11=1;
        break;
        case 3:
        case 4:Ra.sl[6]=4123; /* line # 4123 */
        Rv11=3;
        break;
        default:Rv11=((UB *)V_typ_std.v[17])[48];
        break;
      }
    }
    Ra.sl[6]=4128; /* line # 4128 */
    Rv50=Rv0;
    ((V *)Rv50)[3]=F_owid;
    ((SL *)Rv50)[24]=Rv12;
    ((V *)Rv50)[13]=Rv42;
    Ra.sl[6]=4133; /* line # 4133 */
    ((SL *)Rv50)[11]=Rv25;
    Rv10=Rv25;
    PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
    if (Rv25>Rv10) {
      Ra.sl[6]=4139; /* line # 4139 */
      P_src_error(Rd.s+779,214,1);
      Rv10=Rv25;
    }
    ((SL *)Rv50)[11]=Rv10;
    Ra.sl[6]=4144; /* line # 4144 */
    if (Rv11>=0) ((UB *)Rv50)[48]=Rv11;
    if (Rv42!=NULL) {
      Rv51=Rv42;
      if (((UB *)Rv51)[93]==2) {
        Ra.sl[6]=4149; /* line # 4149 */
        Rv52=V_usi_tab;
        P_lgt_new(((V *)Rv51)+13,((V *)Rv52)[5],14,NULL);
        P_val_copy(((V *)Rv52)+7,((V *)((V *)Rv51)[13])+7,0);
      }
      else {
        Ra.sl[6]=4154; /* line # 4154 */
        if (((UB *)Rv51)[93]==0) {
          Rv53=V_csi_tab;
          P_lgt_new(((V *)Rv51)+13,((V *)Rv53)[5],14,NULL);
          P_val_copy(((V *)Rv53)+7,((V *)((V *)Rv51)[13])+7,0);
        }
      }
    }
    break;
    case 44:Ra.sl[6]=4165; /* line # 4165 */
    P_src_error(Rd.s+779,219,2);
    Rv0=NULL;
    break;
    case 56:Ra.sl[6]=4171; /* line # 4171 */
    Rv5=PAS_COMILER_PRC_00000004(2,NULL);
    Rv0=((V *)Rv5)[3];
    P_lgt_free(&Rv5);
    break;
    default:Ra.sl[6]=4177; /* line # 4177 */
    Rv0=NULL;
    if (V_sy_sym.ub[0]==0) {
      Rv1=P_ide_search(534);
      Rv0=((V *)Rv1)[5];
      Ra.sl[6]=4182; /* line # 4182 */
      if (Rv1!=V_ide_udptr.v[1]) {
        if (((UB *)Rv1)[53]==1) {
          Rv0=((V *)Rv1)[5];
          Ra.sl[6]=4187; /* line # 4187 */
          P_insymbol();
          V_sy_type_gfirst=((V *)Rv1)[10];
          if (V_sy_sym.ub[0]==13) {
            Ra.sl[6]=4192; /* line # 4192 */
            Rv2=Rv1;
            if (((V *)((V *)Rv2)[5])[4]==NULL) {
              P_src_error(Rd.s+779,206,2);
              P_skip_symbol(14,0,0);
            }
            else {
              Ra.sl[6]=4200; /* line # 4200 */
              Rv3=NULL;
              Rv4=((V *)((V *)Rv2)[5])[4];
              V_sy_sym.ub[0]=17;
              while (Rv4!=NULL){
                Ra.sl[6]=4205; /* line # 4205 */
                if (V_sy_sym.ub[0]==17) P_insymbol();
                if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==14) {
                  if (((V *)Rv4)[10]!=NULL) {
                    P_lgt_new(&Rv5,((V *)Rv4)[5],14,NULL);
                    Ra.sl[6]=4210; /* line # 4210 */
                    ((V *)Rv5)[7]=((V *)Rv4)[10];
                    P_val_new(((V *)Rv4)+10,((V *)Rv4)[5]);
                  }
                  else P_src_error_s(Rd.s+779,228,3,((V *)Rv4)[0],NULL);
                }
                else {
                  Ra.sl[6]=4215; /* line # 4215 */
                  Rv5=PAS_COMILER_PRC_00000005(((V *)Rv4)[5],0,0,0);
                }
                if (Rv3==NULL) Rv3=Rv5;
                else((V *)Rv6)[0]=Rv5;
                Rv6=Rv5;
                Ra.sl[6]=4220; /* line # 4220 */
                Rv4=((V *)Rv4)[3];
              }
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else P_src_error(Rd.s+779,23,2);
              Rv0=P_type_parm_set(Rv1, Rv3);
            }
          }
          else {
            Ra.sl[6]=4228; /* line # 4228 */
            Rv7=Rv1;
            if (((UB *)((V *)Rv7)[5])[93]==24) {
              if (V_sy_sym.ub[0]==87) {
                Ra.sl[6]=4234; /* line # 4234 */
                P_insymbol();
                Rv8=P_ide_search(2);
                P_insymbol();
                if (Rv8!=V_ide_udptr.v[1]) {
                  Ra.sl[6]=4239; /* line # 4239 */
                  P_ide_new_typ(24, &Rv0);
                  Rv9=Rv0;
                  ((V *)Rv9)[0]=((V *)Rv7)[5];
                  ((V *)Rv9)[12]=((V *)Rv8)[5];
                  Ra.sl[6]=4244; /* line # 4244 */
                  ((V *)Rv9)[4]=((V *)((V *)Rv9)[12])[4];
                  ((SL *)Rv9)[10]=0;
                  V_sy_type_gfirst=((V *)Rv7)[10];
                  ((V *)Rv9)[9]=NULL;
                  Ra.sl[6]=4249; /* line # 4249 */
                  ((SL *)Rv9)[11]=((SL *)((V *)Rv7)[5])[11];
                  ((UB *)Rv9)[91]=((UB *)((V *)Rv7)[5])[91];
                }
              }
              else Ra.sl[6]=4258; /* line # 4258 */
            }
            ((UB *)Rv0)[91]=((UB *)((V *)Rv7)[5])[91]||((SL *)((V *)Rv7)[5])[10]
            >0;
          }
        }
        else Rv0=NULL;
      }
    }
    Ra.sl[6]=4265; /* line # 4265 */
    if (Rv0==NULL) {
      Rv5=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,1);
      if (V_sy_sym.ub[0]==20) P_insymbol();
      else P_src_error(Rd.s+779,28,2);
      Ra.sl[6]=4270; /* line # 4270 */
      Rv6=PAS_COMILER_PRC_00000005(((V *)Rv5)[3],0,0,1);
      Rv10=((SL *)((V *)Rv5)[3])[11];
      Rv11=((UB *)((V *)Rv5)[3])[48];
      PAS_COMILER_PRC_00000040(&Rv10, &Rv11);
      if (Rv10<4) Rv12=PAS__IIPOWER(2,8*Rv10);
      else Rv12=2147483647;
      Ra.sl[6]=4275; /* line # 4275 */
      Rv13=Rv5;
      if (((UB *)Rv13)[40]==14&&((UB *)Rv6)[40]==14) {
        P_ide_new_typ_range(((SL *)((V *)Rv13)[7])[13],((SL *)((V *)Rv6)[7])[13]
        ,((V *)Rv13)[3],&Rv0);
        Ra.sl[6]=4281; /* line # 4281 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv0);
        P_lgt_free(&Rv5);
        P_lgt_free(&Rv6);
        Rv14=Rv0;
        ((UB *)Rv14)[112]=((SL *)Rv14)[29]>=0;
        Ra.sl[6]=4286; /* line # 4286 */
        if (V_sy_fix_range_ctl) {
          if (((UB *)Rv14)[112]) {
            if (((UL *)Rv14)[29]>((UL *)Rv14)[30]) {
              Ra.sl[6]=4292; /* line # 4292 */
              ((UL *)Rv14)[30]=((UL *)Rv14)[29];
              P_src_error(Rd.s+779,211,2);
            }
          }
          else {
            Ra.sl[6]=4297; /* line # 4297 */
            if (((SL *)Rv14)[29]>((SL *)Rv14)[30]) {
              ((SL *)Rv14)[30]=((SL *)Rv14)[29];
              P_src_error(Rd.s+779,211,2);
            }
          }
          Ra.sl[6]=4302; /* line # 4302 */
          if (((UB *)Rv14)[112]) {
            switch (Rv10) {
              case 1:Rv12=256;
              break;
              case 2:
              case 3:Rv12=65536;
              break;
              default:Ra.sl[6]=4308; /* line # 4308 */
              Rv12=2147483647;
              break;
            }
            if (Rv10<4) {
              if (((UL *)Rv14)[30]>=Rv12) {
                Ra.sl[6]=4313; /* line # 4313 */
                ((UL *)Rv14)[30]=Rv12-1;
                ((UL *)Rv14)[29]=0;
                P_src_error(Rd.s+779,212,2);
                Rv11=0;
              }
            }
          }
          else {
            Ra.sl[6]=4319; /* line # 4319 */
            switch (Rv10) {
              case 1:Rv12=128;
              break;
              case 2:
              case 3:Rv12=32768;
              break;
              default:Rv12=2147483647;
              break;
            }
            Ra.sl[6]=4325; /* line # 4325 */
            if (((SL *)Rv14)[30]>=Rv12||((SL *)Rv14)[29]< -Rv12) {
              Rv10=4;
              ((SL *)Rv14)[30]=Rv12-1;
              ((SL *)Rv14)[29]= -Rv12;
              P_src_error(Rd.s+779,213,2);
              Rv11=0;
            }
          }
        }
      }
      else {
        Ra.sl[6]=4336; /* line # 4336 */
        P_ide_new_typ(22, &Rv0);
        Rv15=Rv0;
        ((V *)Rv15)[0]=((V *)Rv13)[3];
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4342; /* line # 4342 */
          P_type_check_parm(Rv5);
          P_type_check_parm(Rv6);
        }
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[6]=4347; /* line # 4347 */
          ((V *)Rv15)[14]=P_lgt_new_code(0, Rv6);
        }
        else((V *)Rv15)[14]=Rv6;
        Ra.sl[6]=4352; /* line # 4352 */
        ((V *)((V *)Rv15)[14])[3]=Rv0;
        if (((UB *)Rv5)[40]==14) {
          Rv16=Rv5;
          ((V *)Rv15)[13]=Rv5;
          Ra.sl[6]=4357; /* line # 4357 */
          ((V *)Rv16)[3]=Rv0;
          if (((SL *)((V *)Rv16)[7])[13]==1) ((V *)Rv15)[12]=P_lgt_new_code(0, Rv6);
          else {
            Ra.sl[6]=4364; /* line # 4364 */
            ((V *)((V *)Rv15)[14])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)((V
             *)Rv16)[7])[13]-1);
            ((V *)Rv15)[12]=P_lgt_new_code(50,((V *)Rv15)[14]);
          }
        }
        else {
          Ra.sl[6]=4373; /* line # 4373 */
          ((V *)Rv15)[13]=P_lgt_new_code(0, Rv5);
          ((V *)((V *)Rv15)[13])[3]=Rv0;
          if (((UB *)Rv6)[40]==14) {
            Ra.sl[6]=4379; /* line # 4379 */
            Rv12=((SL *)((V *)Rv6)[7])[13]+1;
            if (Rv12==0) ((V *)Rv15)[12]=P_lgt_new_code(46,((V *)Rv15)[14]);
            else {
              Ra.sl[6]=4385; /* line # 4385 */
              Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv12);
              ((V *)Rv5)[0]=((V *)Rv15)[13];
              ((V *)Rv15)[12]=P_lgt_new_code(50, Rv5);
            }
          }
          else {
            Ra.sl[6]=4392; /* line # 4392 */
            ((V *)((V *)Rv15)[14])[0]=((V *)Rv15)[13];
            Rv5=P_lgt_new_code(50,((V *)Rv15)[14]);
            ((V *)Rv15)[12]=P_lgt_new_code(43, Rv5);
          }
        }
      }
      Ra.sl[6]=4401; /* line # 4401 */
      Rv17=Rv0;
      ((V *)Rv17)[3]=F_owid;
      ((SL *)Rv17)[11]=Rv10;
      if (Rv11>=0) ((UB *)Rv17)[48]=Rv11;
    }
    break;
  }
  Ra.sl[6]=4411; /* line # 4411 */
  (*F_it)=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_decl_attribute "  */
void PAS_COMILER_PRC_00000043(UB F_bvr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+783;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4487; /* line # 4487 */
  while (1){
    P_insymbol();
    if (V_sy_sym.ub[0]!=0) {
      if (F_bvr) {
        Ra.sl[6]=4493; /* line # 4493 */
        F_bvr=0;
        switch (V_sy_sym.ub[0]) {
          case 80:
          case 81:Lx[5].ub[16]=2;
          break;
          case 82:Lx[5].ub[16]=3;
          break;
          case 84:Ra.sl[6]=4498; /* line # 4498 */
          Lx[5].ub[16]=4;
          Rv0=1;
          break;
          case 83:Lx[5].ub[16]=5;
          Rv0=1;
          break;
          case 85:if (V_sy_init_mod) {
            Lx[5].ub[16]=6;
            Rv0=1;
          }
          else P_src_error(Rd.s+805,992,2);
          break;
          default:Ra.sl[6]=4504; /* line # 4504 */
          P_src_error(Rd.s+805,163,2);
          break;
        }
      }
      else P_src_error(Rd.s+805,170,2);
    }
    else {
      Ra.sl[6]=4510; /* line # 4510 */
      Rv1=P_level_search(V_attr_list);
      if (Rv1!=NULL) switch (((UB *)Rv1)[54]) {
        case 23:Rs.sl[0]=1;
        break;
        case 24:Rs.sl[0]=2;
        break;
        case 25:Ra.sl[6]=4515; /* line # 4515 */
        Rs.sl[0]=4;
        break;
        case 26:Rs.sl[0]=8;
        break;
        default:P_src_error_s(Rd.s+805,165,2, V_sy_ident.s,NULL);
        break;
      }
      else {
        Ra.sl[6]=4521; /* line # 4521 */
        P_src_error(Rd.s+805,162,2);
      }
    }
    P_insymbol();
    if (Rv0) {
      Ra.sl[6]=4526; /* line # 4526 */
      Lx[5].v[3]=NULL;
      P_set_strname(Lx[5].v+3);
    }
    if (V_sy_sym.ub[0]!=17)  break;
  }
  Ra.sl[6]=4531; /* line # 4531 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else P_src_error(Rd.s+805,26,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_setting "  */
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  UW Rv8;
  UB Rv9;
  V Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  V Rv16;
  register V Rv17;
  UB Rv18;
  register V Rv19;
  V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  V Rv24;
  register V Rv25;
  register V Rv26;
  register V Rv27;
  register V Rv28;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+809;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4561; /* line # 4561 */
  Rv0=0;
  Rv1=Lx[5].ub[16];
  Rv2=NULL;
  Lx[5].ub[16]=1;
  if (Lx[5].v[3]!=NULL) {
    Ra.sl[6]=4567; /* line # 4567 */
    P_src_error_s(Rd.s+826,166,1, Lx[5].v[3],NULL);
    Lx[5].v[3]=NULL;
  }
  Rv3=0;
  Rv4=NULL;
  Rv5=NULL;
  Ra.sl[6]=4573; /* line # 4573 */
  if (F_v_class==6) ((V *)F_ty)[12]=V_lex_ident_tree.v[V_curr_disp*8+4];
  Ra.sl[6]=4578; /* line # 4578 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==15){
    Rv6=NULL;
    Rv7=NULL;
    Rv8=96;
    while (1){
      Ra.sl[6]=4584; /* line # 4584 */
      switch (F_v_class) {
        case 5:if (V_sy_sym.ub[0]==15) {
          Ra.sl[6]=4595; /* line # 4595 */
          PAS_COMILER_PRC_00000043(F_v_class!=6);
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[6]=4601; /* line # 4601 */
            Rv9=Lx[5].ub[16];
            Rv2=Lx[5].v[3];
            Lx[5].ub[16]=1;
            Lx[5].v[3]=NULL;
          }
          else {
            Ra.sl[6]=4606; /* line # 4606 */
            Rv0=1;
          }
        }
        else {
          Rv9=Rv1;
          Ra.sl[6]=4611; /* line # 4611 */
          Rv2=NULL;
        }
        if (!Rv0) {
          V_cmp_twicedclon=1;
          Ra.sl[6]=4616; /* line # 4616 */
          P_ide_new(5,NULL,&Rv10);
          V_cmp_twicedclon=0;
          if (1<<Rv9&112&&Rv2!=NULL) ((V *)Rv10)[8]=Rv2;
        }
        break;
        case 2:Ra.sl[6]=4632; /* line # 4632 */
        P_ide_new(2,NULL,&Rv10);
        break;
        case 1:
        case 6:P_ide_new(6,NULL,&Rv10);
        break;
        default:break;
      }
      Ra.sl[6]=4640; /* line # 4640 */
      if (!Rv0) {
        if (!V_cmp_twicedcl) {
          if (Rv5!=NULL) ((V *)Rv5)[3]=Rv10;
          else {
            Ra.sl[6]=4646; /* line # 4646 */
            if (Rv4==NULL) Rv4=Rv10;
          }
          if (Rv6==NULL) Rv6=Rv10;
          Rv5=Rv10;
        }
        P_insymbol();
        Ra.sl[6]=4651; /* line # 4651 */
        if (V_sy_sym.ub[0]==17) P_insymbol();
        else {
          if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+826,29,2);
        }
        if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+826,27,2);
      }
      if (V_sy_sym.ub[0]!=0&&V_sy_sym.ub[0]!=15)  break;
    }
    Ra.sl[6]=4657; /* line # 4657 */
    if (!Rv0) {
      P_insymbol();
      Rs.sl[1]=-1;
      Ra.sl[6]=4662; /* line # 4662 */
      Rs.sl[0]=-1;
      Rv11=0;
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        P_insymbol();
        Rv11=1;
      }
      Ra.sl[6]=4670; /* line # 4670 */
      if (V_sy_sym.ub[0]==15&&1<<F_v_class&112) {
        PAS_COMILER_PRC_00000043(F_v_class!=6);
        Rv9=Lx[5].ub[16];
      }
      Ra.sl[6]=4728; /* line # 4728 */
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        P_insymbol();
        Rv11=1;
      }
      Ra.sl[6]=4734; /* line # 4734 */
      if (Rv9==1&&Rv1!=1) {
        Rv9=Rv1;
        Rv2=NULL;
      }
      PAS_COMILER_PRC_00000038(&Rv12,0,NULL,0,0,NULL);
      Ra.sl[6]=4739; /* line # 4739 */
      switch (F_v_class) {
        case 5:if (((SL *)Rv12)[11]<0&&((V *)Rv12)[1]!=NULL) {
          Ra.sl[6]=4744; /* line # 4744 */
          Rv12=((V *)Rv12)[1];
        }
        break;
        case 2:if (Rv12!=NULL) {
          Rv13=Rv12;
          Ra.sl[6]=4749; /* line # 4749 */
          switch (((UB *)Rv13)[93]) {
            case 0:
            case 1:
            case 2:break;
            default:P_src_error(Rd.s+826,207,3);
            break;
          }
        }
        break;
        case 6:Ra.sl[6]=4756; /* line # 4756 */
        Rv14=Rv12;
        if (((UB *)Rv14)[91]||((SL *)Rv14)[10]>0) Lx[5].ub[0]=1;
        break;
        default:break;
      }
      Ra.sl[6]=4764; /* line # 4764 */
      Rv15=Rv12;
      if (Rv3<((UB *)Rv15)[48]) Rv3=((UB *)Rv15)[48];
      Rv7=((V *)Rv15)[10];
      Ra.sl[6]=4771; /* line # 4771 */
      if (F_v_class==5) {
        if (Rv9==1) switch (V_sy_sym.ub[0]) {
          case 80:Rv9=2;
          P_insymbol();
          break;
          case 84:Ra.sl[6]=4776; /* line # 4776 */
          Rv9=4;
          P_insymbol();
          break;
          case 83:Rv9=5;
          P_insymbol();
          break;
          default:break;
        }
        if (V_sy_sym.ub[0]==26) {
          Ra.sl[6]=4782; /* line # 4782 */
          Rv8=32;
          P_insymbol();
        }
      }
      Ra.sl[6]=4787; /* line # 4787 */
      if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
        if (F_v_class==6) P_src_error(Rd.s+826,220,2);
        else {
          Ra.sl[6]=4794; /* line # 4794 */
          P_insymbol();
          if (V_sy_sym.ub[0]!=13&&V_sy_sym.ub[0]!=15) Rv16=PAS_COMILER_PRC_00000005(
          Rv12,0,0,0);
          else Rv16=PAS_COMILER_PRC_00000019(Rv12);
          Ra.sl[6]=4800; /* line # 4800 */
          if (((UB *)Rv16)[40]!=14) P_src_error(Rd.s+826,216,3);
          else {
            Rv17=Rv16;
            Ra.sl[6]=4805; /* line # 4805 */
            Rv7=((V *)Rv17)[7];
            ((V *)Rv17)[7]=NULL;
          }
          Rv18=1;
          P_lgt_free_tree(&Rv16);
        }
      }
      else {
        Ra.sl[6]=4811; /* line # 4811 */
        Rv18=0;
      }
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=4816; /* line # 4816 */
        if (V_sy_sym.ub[0]==0) P_src_error_s(Rd.s+826,52,2, V_sy_ident.s,NULL);
      }
      if (Rv6!=NULL) while (1){
        Ra.sl[6]=4821; /* line # 4821 */
        Rv19=Rv6;
        Rv20=((V *)Rv19)[5];
        ((V *)Rv19)[5]=Rv12;
        if ((*F_isz)>0) (*F_isz)=P_ide_typ_align((*F_isz),Rv12);
        Ra.sl[6]=4826; /* line # 4826 */
        switch (F_v_class) {
          case 5:((UW *)Rv19)[42]=Rv8;
          if (Rv11) ((UW *)Rv19)[42]=((UW *)Rv19)[42]|16384;
          Ra.sl[6]=4832; /* line # 4832 */
          if (((UB *)Rv19)[86]==5||((SL *)Rv19)[20]>0) {
            if (Rv20!=NULL&&Rv20!=Rv12) P_src_error_s(Rd.s+826,217,3,((V *)Rv19)
            [0],NULL);
            ((UB *)Rv19)[86]=Rv9;
          }
          else {
            Ra.sl[6]=4840; /* line # 4840 */
            if (((UB *)Rv19)[86]==0) ((UB *)Rv19)[86]=Rv9;
            switch (((UB *)Rv19)[86]) {
              case 4:
              case 5:
              case 6:if (((V *)Rv19)[8]==NULL) {
                Ra.sl[6]=4845; /* line # 4845 */
                P_set_gbl_def_nam(((V *)Rv19)+8,((V *)Rv19)[0],86);
              }
              ((SL *)Rv19)[20]=-1;
              break;
              default:Ra.sl[6]=4850; /* line # 4850 */
              if (16384&((UW *)Rv19)[42]||V_cmp_igenv!=0) ((SL *)Rv19)[20]=-1;
              break;
            }
          }
          Ra.sl[6]=4855; /* line # 4855 */
          if (Rv7!=NULL) {
            if (((UB *)Rv19)[86]==5||((SL *)Rv19)[20]>0) {
              if (Rv18) P_src_error_s(Rd.s+826,209,2,((V *)Rv19)[0],NULL);
              Ra.sl[6]=4861; /* line # 4861 */
              Rv7=NULL;
            }
            else {
              ((V *)Rv19)[7]=Rv7;
              Ra.sl[6]=4866; /* line # 4866 */
              P_val_new(((V *)Rv19)+7,Rv12);
              Rv21=((V *)Rv19)[7];
              ((UW *)Rv21)[8]=((UW *)Rv10)[42];
              ((SL *)Rv21)[5]=((SL *)Rv19)[20];
            }
          }
          Ra.sl[6]=4874; /* line # 4874 */
          switch (((UB *)Rv19)[86]) {
            case 4:if (((UB *)((V *)Rv19)[5])[90]||((UB *)((V *)Rv19)[5])[91]) P_init_d_varbl(
            Rv6);
            P_all_new(((V *)Rv19)+9,Rv12, Rv6,((UB *)Rv19)[86]);
            Ra.sl[6]=4879; /* line # 4879 */
            ((V *)((V *)Rv19)[9])[13]=((V *)Rv19)[7];
            if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv19)[9];
            else((V *)V_all_lglobal)[0]=((V *)Rv19)[9];
            ((V *)((V *)Rv19)[9])[1]=V_all_lglobal;
            V_all_lglobal=((V *)Rv19)[9];
            break;
            case 1:
            case 2:Ra.sl[6]=4886; /* line # 4886 */
            if (((SL *)Rv19)[20]==0) {
              if (((UB *)((V *)Rv19)[5])[90]||((UB *)((V *)Rv19)[5])[91]) P_init_d_varbl(
              Rv6);
              P_all_new(((V *)Rv19)+9,Rv12, Rv6,((UB *)Rv19)[86]);
              ((V *)((V *)Rv19)[9])[13]=((V *)Rv19)[7];
              Ra.sl[6]=4891; /* line # 4891 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv19)[9];
              else((V *)V_all_lstatic)[0]=((V *)Rv19)[9];
              ((V *)((V *)Rv19)[9])[1]=V_all_lstatic;
              V_all_lstatic=((V *)Rv19)[9];
            }
            break;
            default:break;
          }
          break;
          case 1:
          case 6:Ra.sl[6]=4901; /* line # 4901 */
          ((SL *)Rv19)[14]=(*F_isz);
          if ((*F_isz)<0) {
            Ra.sl[6]=4906; /* line # 4906 */
            P_src_error(Rd.s+826,221,3);
          }
          break;
          case 2:Ra.sl[6]=4911; /* line # 4911 */
          ((UB *)Rv19)[60]=0;
          ((V *)Rv19)[10]=Rv7;
          if (((V *)Rv19)[10]==NULL) {
            Ra.sl[6]=4917; /* line # 4917 */
            P_val_new(((V *)Rv19)+10,Rv12);
            Rv22=((V *)Rv19)[10];
            Rv23=Rv12;
            switch (((UB *)Rv23)[93]) {
              case 0:((SL *)Rv22)[13]=((SL *)Rv23)[30];
              break;
              case 1:
              case 2:Ra.sl[6]=4923; /* line # 4923 */
              if (((SL *)Rv23)[30]>32767) ((SL *)Rv22)[13]=32767;
              else((SL *)Rv22)[13]=((SL *)Rv23)[30];
              break;
              default:break;
            }
          }
          else {
            Ra.sl[6]=4929; /* line # 4929 */
            P_val_new(((V *)Rv19)+10,Rv12);
          }
          ((SL *)Rv19)[14]=(*F_isz);
          break;
        }
        Ra.sl[6]=4935; /* line # 4935 */
        if ((*F_isz)>=0) {
          if (((SL *)Rv12)[11]>=0) (*F_isz)=(*F_isz)+((SL *)Rv12)[11];
          else {
            if ((F_v_class==6||F_v_class==1)&&((V *)Rv12)[9]!=NULL) {
              Ra.sl[6]=4942; /* line # 4942 */
              Rv24=P_lgt_link(((V *)Rv12)[9]);
              if ((*F_isz)>0) {
                ((V *)Rv24)[0]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
                ((V *)F_ty)[9]=P_lgt_new_code(49, Rv24);
              }
              else {
                Ra.sl[6]=4948; /* line # 4948 */
                ((V *)F_ty)[9]=Rv24;
              }
              (*F_isz)=-1;
            }
            else {
              Ra.sl[6]=4954; /* line # 4954 */
              P_src_error(Rd.s+826,301,3);
            }
          }
        }
        Rv6=((V *)Rv6)[3];
        if (Rv6==NULL)  break;
      }
      if (Rv18&&Rv7!=NULL) P_val_free(&Rv7);
      Ra.sl[6]=4959; /* line # 4959 */
      Rv18=0;
    }
  }
  if (!Rv0) {
    Ra.sl[6]=4964; /* line # 4964 */
    switch (F_v_class) {
      case 1:
      case 6:Rv25=F_ty;
      switch (V_sy_sym.ub[0]) {
        case 72:Ra.sl[6]=4970; /* line # 4970 */
        if (F_v_class==6&&(*F_isz)>=0) ((V *)Rv25)[9]=P_lgt_new_econst(V_typ_std
        .v[2],(*F_isz));
        break;
        case 14:Ra.sl[6]=4975; /* line # 4975 */
        if (F_v_class==6&&(*F_isz)>=0) ((V *)Rv25)[9]=P_lgt_new_econst(V_typ_std
        .v[2],(*F_isz));
        if (((UB *)F_ty)[93]!=23) {
          P_src_error(Rd.s+826,223,2);
          P_insymbol();
        }
        break;
        case 56:Ra.sl[6]=4984; /* line # 4984 */
        Rv26=F_ty;
        Rv27=(V_lex_ident_tree.s+V_curr_disp*64);
        if (((SL *)Rv26)[11]<0) {
          P_src_error(Rd.s+826,224,3);
          P_insymbol();
          P_skip_symbol(72,0,0);
        }
        else {
          Ra.sl[6]=4992; /* line # 4992 */
          P_insymbol();
          if (F_v_class==6) {
            if (((V *)Rv26)[13]==NULL) ((V *)Rv26)[12]=((V *)Rv27)[1];
            else {
              Ra.sl[6]=4997; /* line # 4997 */
              ((V *)Rv26)[12]=((V *)((V *)Rv26)[13])[3];
            }
          }
          ((V *)Rv26)[13]=((V *)Rv27)[4];
          ((V *)Rv26)[14]=PAS_COMILER_PRC_00000004(41, F_ty);
          ((V *)Rv26)[9]=P_lgt_new_code(0,((V *)Rv26)[14]);
        }
        break;
        default:Ra.sl[6]=5005; /* line # 5005 */
        P_src_error(Rd.s+826,225,2);
        break;
      }
      break;
      case 2:if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+826,23,2);
      else P_insymbol();
      break;
      default:break;
    }
  }
  Ra.sl[6]=5013; /* line # 5013 */
  (*F_aln)=Rv3;
  if (F_ty!=NULL) {
    Rv28=F_ty;
    if (Rv3>((UB *)Rv28)[48]) ((UB *)Rv28)[48]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " const_decl "  */
void PAS_COMILER_PRC_00000044(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+830;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5031; /* line # 5031 */
  V_ident_disp=V_curr_disp;
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==43){
    Ra.sl[6]=5036; /* line # 5036 */
    if (V_sy_sym.ub[0]==43) {
      P_insymbol();
      Rv0=1;
    }
    else {
      Ra.sl[6]=5041; /* line # 5041 */
      Rv0=0;
    }
    if (V_sy_sym.ub[0]!=0) {
      P_src_error(Rd.s+844,107,3);
      P_skip_symbol(18,0,0);
    }
    else {
      Ra.sl[6]=5049; /* line # 5049 */
      P_ide_new(4,NULL,&Rv1);
      P_insymbol();
      if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+844,30,2);
      else {
        Ra.sl[6]=5055; /* line # 5055 */
        P_insymbol();
      }
      Rv2=PAS_COMILER_PRC_00000000();
      Rv3=Rv1;
      Rv4=Rv2;
      if (((UB *)Rv4)[40]!=14) P_src_error(Rd.s+844,53,3);
      else {
        Ra.sl[6]=5062; /* line # 5062 */
        ((V *)Rv3)[5]=((V *)Rv4)[3];
        ((V *)Rv3)[7]=((V *)Rv4)[7];
        ((UB *)Rv3)[72]=2;
        ((V *)Rv4)[7]=NULL;
        if ((((V *)Rv3)[7]!=NULL&&!Rv0)&&V_cmp_igenv==0) {
          Ra.sl[6]=5067; /* line # 5067 */
          if (((V *)Rv3)[5]!=NULL) {
            Rv5=((V *)Rv3)[7];
            ((SL *)Rv5)[5]=0;
            ((UW *)Rv5)[8]=((UW *)Rv5)[8]&~16384;
            Ra.sl[6]=5072; /* line # 5072 */
            P_cte_allocate(((V *)Rv3)[7],Rv1);
          }
        }
        if (V_sy_init_mod) {
          if (((UB *)((V *)Rv3)[5])[93]==8) {
            Ra.sl[6]=5077; /* line # 5077 */
            if (V_usi_tab==NULL) V_usi_tab=Rv1;
            else {
              if (V_csi_tab==NULL) V_csi_tab=Rv1;
            }
          }
        }
      }
      if (Rv2!=NULL) P_lgt_free_tree(&Rv2);
    }
    Ra.sl[6]=5083; /* line # 5083 */
    if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==18) P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_decl "  */
void PAS_COMILER_PRC_00000045(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UL Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  V Rv18;
  UB Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+848;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5105; /* line # 5105 */
  V_ident_disp=V_curr_disp;
  if (V_sy_init_mod) while (V_sy_sym.ub[0]==57){
    Ra.sl[6]=5111; /* line # 5111 */
    P_insymbol();
    if (V_sy_sym.ub[0]==0) {
      Rv0=P_ide_search(2);
      if (Rv0!=NULL) Rv1=((V *)Rv0)[5];
      else {
        Ra.sl[6]=5116; /* line # 5116 */
        Rv1=NULL;
      }
      if (Rv1!=NULL) {
        P_insymbol();
        if (V_sy_sym.ub[0]==73) {
          Ra.sl[6]=5121; /* line # 5121 */
          Rv2=Rv1;
          Rv3=((SL *)Rv2)[11];
          Rv4=0;
          PAS_COMILER_PRC_00000040(&Rv3, &Rv4);
          Ra.sl[6]=5126; /* line # 5126 */
          ((SL *)Rv2)[11]=Rv3;
          ((UB *)Rv2)[48]=Rv4;
          if ((((UB *)Rv2)[93]==2||((UB *)Rv2)[93]==1)||((UB *)Rv2)[93]==0) {
            Ra.sl[6]=5131; /* line # 5131 */
            if (Rv3<4) {
              if (((UB *)Rv2)[112]) {
                ((UL *)Rv2)[29]=0;
                Ra.sl[6]=5136; /* line # 5136 */
                Rv5=PAS__IIPOWER(2,8*Rv3);
                if (((UL *)Rv2)[30]>Rv5) ((UL *)Rv2)[30]=Rv5-1;
              }
              else {
                Ra.sl[6]=5141; /* line # 5141 */
                Rv6=PAS__IIPOWER(2,8*Rv3-1);
                if (((SL *)Rv2)[30]>=Rv6) ((SL *)Rv2)[30]=Rv6-1;
                if (((SL *)Rv2)[29]<= -Rv6) ((SL *)Rv2)[29]= -Rv6;
              }
            }
            else {
              Ra.sl[6]=5147; /* line # 5147 */
              if (((UB *)Rv2)[112]) {
                ((SL *)Rv2)[29]=0;
                ((SL *)Rv2)[30]=-1;
              }
              else {
                ((SL *)Rv2)[30]=2147483647;
                ((SL *)Rv2)[29]= -((SL *)Rv2)[30]-1;
              }
            }
          }
          switch (((UB *)Rv2)[93]) {
            case 2:Ra.sl[6]=5153; /* line # 5153 */
            V_inte_size=((SL *)Rv2)[11];
            ((SL *)V_uns_typ)[11]=((SL *)Rv2)[11];
            ((UB *)V_uns_typ)[48]=((UB *)Rv2)[48];
            break;
            case 5:
            case 13:Ra.sl[6]=5159; /* line # 5159 */
            V_fptr_size=((SL *)Rv2)[11];
            ((SL *)V_typ_std.v[13])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[13])[48]=((UB *)Rv2)[48];
            ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
            Ra.sl[6]=5164; /* line # 5164 */
            ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
            ((SL *)V_typ_std.v[16])[11]=((SL *)Rv2)[11];
            ((UB *)V_typ_std.v[16])[48]=((UB *)Rv2)[48];
            break;
            case 3:Ra.sl[6]=5169; /* line # 5169 */
            V_sngl_size=((SL *)Rv2)[11];
            break;
            case 4:V_dble_size=((SL *)Rv2)[11];
            break;
            case 17:
            case 19:V_dst_setw=((SL *)Rv2)[11]*8;
            Ra.sl[6]=5174; /* line # 5174 */
            V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
            ((UB *)V_typ_std.v[18])[48]=((UB *)Rv2)[48];
            ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
            ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
            ((SL *)V_typ_std.v[19])[11]=((SL *)Rv2)[11];
            Ra.sl[6]=5179; /* line # 5179 */
            ((SL *)V_typ_std.v[17])[11]=((SL *)Rv2)[11];
            break;
            case 18:V_dst_seta=((SL *)Rv2)[11]*8;
            Ra.sl[6]=5184; /* line # 5184 */
            V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
            ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
            ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
            break;
            case 16:Ra.sl[6]=5191; /* line # 5191 */
            Rv7=((UB *)V_typ_std.v[5])[48];
            if (Rv7!=Rv4) ((UB *)Rv2)[48]=Rv7;
            Rv7=((SL *)V_typ_std.v[16])[11];
            if (Rv3!=Rv7) {
              Ra.sl[6]=5197; /* line # 5197 */
              if (Rv3<Rv7) Rv3=Rv7;
              else {
                if (PAS__I_MOD(Rv3,Rv7)!=0) Rv3=Rv7*(Rv3/Rv7+1);
              }
              ((SL *)Rv2)[11]=Rv3;
            }
            break;
            default:break;
          }
          Ra.sl[6]=5205; /* line # 5205 */
          if (V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
          if (V_sy_sym.ub[0]==18) P_insymbol();
          else P_src_error(Rd.s+861,21,2);
        }
        else {
          Ra.sl[6]=5210; /* line # 5210 */
          P_skip_symbol(18,0,0);
        }
      }
      else {
        P_src_error(Rd.s+861,8001,3);
        Ra.sl[6]=5215; /* line # 5215 */
        P_skip_symbol(18,0,0);
      }
    }
    else {
      Ra.sl[6]=5220; /* line # 5220 */
      P_src_error(Rd.s+861,8002,3);
      P_skip_symbol(18,0,0);
    }
  }
  Ra.sl[6]=5227; /* line # 5227 */
  while (V_sy_sym.ub[0]==0){
    Rv0=Lx[5].v[1];
    Rv8=NULL;
    while (Rv0!=NULL&&Rv8==NULL){
      Ra.sl[6]=5232; /* line # 5232 */
      Rv9=Rv0;
      if (P_match(((V *)Rv9)[0],V_sy_ident.s)==0) {
        Rv8=Rv0;
        if (Rv0==Lx[5].v[1]) Lx[5].v[1]=((V *)Lx[5].v[1])[7];
        else {
          Ra.sl[6]=5237; /* line # 5237 */
          ((V *)Rv10)[7]=((V *)Rv0)[7];
        }
      }
      Rv10=Rv0;
      Rv0=((V *)Rv0)[7];
    }
    if (Rv8==NULL) {
      Ra.sl[6]=5244; /* line # 5244 */
      P_ide_new(1,NULL,&Rv8);
      Rv1=NULL;
    }
    else Rv1=((V *)Rv8)[5];
    Rv11=Rv8;
    Ra.sl[6]=5250; /* line # 5250 */
    Rv12=V_curr_disp;
    P_insymbol();
    Rv3=0;
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=5255; /* line # 5255 */
      P_insymbol();
      P_new_disp_level(NULL,4);
      PAS_COMILER_PRC_00000037(2, &Rv3, &Rv7,NULL);
      Rv0=V_lex_ident_tree.v[V_curr_disp*8+1];
      Rv13=Rv0;
      Ra.sl[6]=5260; /* line # 5260 */
      Rv14=NULL;
      while (Rv13!=NULL){
        P_lgt_new(&Rv15,((V *)Rv13)[5],14,NULL);
        ((V *)Rv15)[7]=((V *)Rv13)[10];
        Ra.sl[6]=5265; /* line # 5265 */
        P_val_new(((V *)Rv15)+7,((V *)Rv13)[5]);
        if (Rv14==NULL) Rv14=Rv15;
        else((V *)Rv16)[0]=Rv15;
        Rv16=Rv15;
        Rv13=((V *)Rv13)[3];
      }
    }
    else {
      Ra.sl[6]=5272; /* line # 5272 */
      Rv0=NULL;
    }
    if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+861,30,2);
    else P_insymbol();
    Ra.sl[6]=5314; /* line # 5314 */
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043(0);
    PAS_COMILER_PRC_00000038(((V *)Rv11)+5,Rv3, Rv0,1,0,NULL);
    Ra.sl[6]=5320; /* line # 5320 */
    V_curr_disp=Rv12;
    ((V *)Rv11)[10]=V_sy_type_gfirst;
    ((V *)Rv11)[11]=NULL;
    V_tcas_flag=0;
    Rv17=((V *)Rv11)[5];
    Ra.sl[6]=5325; /* line # 5325 */
    if (Rv0!=NULL) {
      switch (((UB *)Rv17)[93]) {
        case 8:
        case 10:
        case 11:
        case 12:
        case 22:
        case 27:Ra.sl[6]=5333; /* line # 5333 */
        ((SL *)Rv17)[10]=P_ide_typ_align(Rv3,((V *)Rv11)[5]);
        ((V *)Rv17)[4]=Rv0;
        if (Rv7>((UB *)((V *)Rv11)[5])[48]) ((UB *)((V *)Rv11)[5])[48]=Rv7;
        if (((SL *)Rv17)[11]<0) {
          Ra.sl[6]=5339; /* line # 5339 */
          Rv18=P_lgt_type_eval(((V *)Rv17)[9],NULL,NULL,0);
          if (((UB *)Rv18)[40]==14) {
            ((SL *)Rv17)[11]= -((SL *)((V *)Rv18)[7])[13];
            Ra.sl[6]=5344; /* line # 5344 */
            if (((SL *)Rv17)[11]>=0) ((SL *)Rv17)[11]=-1;
            P_lgt_free(&Rv18);
          }
        }
        break;
        default:Ra.sl[6]=5351; /* line # 5351 */
        P_src_error(Rd.s+861,205,3);
        break;
      }
      Rv19=((UB *)Rv17)[93]!=10;
      Ra.sl[6]=5356; /* line # 5356 */
      if (Rv19) {
        if (((V *)Rv17)[9]==NULL) ((SL *)Rv17)[11]=((SL *)Rv17)[11]+((SL *)Rv17)
        [10];
        else {
          Ra.sl[6]=5362; /* line # 5362 */
          if (((UB *)((V *)Rv17)[9])[40]==14) {
            Rv20=((V *)Rv17)[9];
            if (((V *)Rv20)[7]!=NULL) ((SL *)((V *)Rv20)[7])[13]=((SL *)((V *)Rv20)
            [7])[13]+((SL *)Rv17)[10];
          }
          else {
            Ra.sl[6]=5370; /* line # 5370 */
            ((V *)((V *)Rv17)[9])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv17)
            [10]);
            ((V *)Rv17)[9]=P_lgt_new_code(49,((V *)Rv17)[9]);
          }
        }
      }
      Ra.sl[6]=5377; /* line # 5377 */
      if (V_tcas_flag) P_lgt_gen_routine(((V *)Rv11)[5]);
    }
    Rv21=((V *)Rv11)[5];
    Ra.sl[6]=5382; /* line # 5382 */
    if (((V *)Rv21)[3]==NULL) {
      if (((V *)Rv21)[0]!=NULL) {
        if (((V *)((V *)Rv21)[0])[3]!=NULL) {
          Ra.sl[6]=5387; /* line # 5387 */
          ((V *)Rv11)[10]=((V *)((V *)((V *)Rv21)[0])[3])[10];
        }
      }
      ((V *)Rv21)[3]=Rv8;
    }
    if (Rv1!=NULL) ((V *)Rv1)[12]=((V *)Rv11)[5];
    Ra.sl[6]=5394; /* line # 5394 */
    if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
      P_insymbol();
      if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) Rv18=PAS_COMILER_PRC_00000019((
      (V *)Rv11)[5]);
      else Rv18=PAS_COMILER_PRC_00000005(((V *)Rv11)[5],0,0,0);
      Ra.sl[6]=5399; /* line # 5399 */
      if (((UB *)Rv18)[40]!=14) P_src_error(Rd.s+861,53,3);
      else {
        Rv22=Rv18;
        Ra.sl[6]=5405; /* line # 5405 */
        ((V *)((V *)Rv11)[5])[10]=((V *)Rv22)[7];
        ((V *)Rv22)[7]=NULL;
      }
      P_lgt_free_tree(&Rv18);
    }
    Ra.sl[6]=5412; /* line # 5412 */
    if (Rv0!=NULL&&((V *)Rv11)[5]!=NULL) ((V *)((V *)Rv11)[5])[1]=P_type_parm_set(
    Rv8, Rv14);
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+861,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_decl "  */
void PAS_COMILER_PRC_00000046(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+865;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5437; /* line # 5437 */
  V_ident_disp=V_curr_disp;
  Rv0=0;
  PAS_COMILER_PRC_00000037(5, &Rv0, &Rv1,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " label_decl "  */
void PAS_COMILER_PRC_00000047(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+877;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5454; /* line # 5454 */
  Rv0=0;
  while (1){
    P_insymbol();
    Ra.sl[6]=5459; /* line # 5459 */
    if (V_sy_sym.ub[0]==2) P_ide_int_label();
    if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+891,69,3);
    else {
      Ra.sl[6]=5464; /* line # 5464 */
      P_ide_new(3,NULL,&Rv1);
      if (Rv1!=NULL) {
        Rv2=Rv1;
        Rv3=Lx[5].v[13];
        Ra.sl[6]=5469; /* line # 5469 */
        if (((V *)Rv3)[20]==NULL) ((V *)Rv3)[20]=Rv1;
        else((V *)Lx[5].v[4])[7]=Rv1;
        Lx[5].v[4]=Rv1;
        ((UB *)Rv2)[54]=1;
      }
    }
    Ra.sl[6]=5475; /* line # 5475 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=17)  break;
  }
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else P_src_error(Rd.s+891,21,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement_decl "  */
void PAS_COMILER_PRC_00000048(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+895;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5498; /* line # 5498 */
  P_insymbol();
  if (V_sy_sym.ub[0]!=0) {
    Ra.sl[6]=5503; /* line # 5503 */
    P_src_error(Rd.s+913,107,3);
    P_skip_symbol(18,1,0);
  }
  else {
    Ra.sl[6]=5508; /* line # 5508 */
    V_err_prt=0;
    Rv0=P_ide_search(1024);
    V_err_prt=1;
    if (Rv0!=NULL) {
      if (((SL *)Rv0)[12]!=V_curr_lex) Rv1=NULL;
      else {
        Ra.sl[6]=5513; /* line # 5513 */
        Rv1=Rv0;
      }
    }
    else Rv1=NULL;
    if (Rv1==NULL) P_ide_new(10,NULL,&Rv1);
    Ra.sl[6]=5518; /* line # 5518 */
    P_insymbol();
    if (V_sy_sym.ub[0]==57) {
      Ra.sl[6]=5524; /* line # 5524 */
      P_insymbol();
      if (V_sy_sym.ub[0]==37) P_insymbol();
      if (V_sy_sym.ub[0]==40) {
        P_insymbol();
        Ra.sl[6]=5529; /* line # 5529 */
        if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+913,25,2);
        Rv2=0;
        PAS_COMILER_PRC_00000042(Ri.v+3,1, &Rv2,NULL);
      }
      else {
        Ra.sl[6]=5535; /* line # 5535 */
        PAS_COMILER_PRC_00000038(Ri.v+3,0,NULL,0,1,NULL);
      }
      if (V_sy_sym.ub[0]==22) {
        P_insymbol();
        Ra.sl[6]=5540; /* line # 5540 */
        Ri.v[4]=PAS_COMILER_PRC_00000005(Ri.v[3],0,0,0);
      }
      if (V_sy_sym.ub[0]==48) {
        Ri.ub[17]=1;
        P_insymbol();
      }
      if (V_sy_sym.ub[0]==53) P_insymbol();
      else {
        Ra.sl[6]=5545; /* line # 5545 */
        P_src_error(Rd.s+913,55,2);
      }
    }
    if (V_sy_sym.ub[0]==0) {
      Ri.v[5]=P_ide_search(514);
      Ra.sl[6]=5550; /* line # 5550 */
      P_insymbol();
    }
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else P_src_error(Rd.s+913,29,2);
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5556; /* line # 5556 */
      Ri.v[6]=P_ide_search(514);
      P_insymbol();
    }
    else P_src_error_s(Rd.s+913,42,3,((V *)Rv1)[0],NULL);
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=5561; /* line # 5561 */
      P_insymbol();
      if (V_sy_sym.ub[0]==0) {
        Ri.v[7]=P_ide_search(514);
        P_insymbol();
      }
      else {
        Ra.sl[6]=5567; /* line # 5567 */
        P_src_error_s(Rd.s+913,43,2,((V *)Rv1)[0],NULL);
      }
    }
    if (V_error_result<=1) {
      Ra.sl[6]=5573; /* line # 5573 */
      Rv3=PAS__NEW(56);
      memcpy(Rv3,Ri.s+8,56);
      Rv4=Rv1;
      if (((V *)Rv4)[8]==NULL) {
        Ra.sl[6]=5579; /* line # 5579 */
        if (Rv0!=NULL) ((V *)Rv3)[0]=((V *)Rv0)[7];
        ((V *)Rv4)[7]=Rv3;
        ((V *)Rv4)[8]=Rv3;
      }
      else {
        Ra.sl[6]=5586; /* line # 5586 */
        ((V *)Rv3)[0]=((V *)((V *)Rv4)[8])[0];
        ((V *)((V *)Rv4)[8])[0]=Rv3;
        ((V *)Rv4)[8]=Rv3;
      }
    }
  }
  Ra.sl[6]=5593; /* line # 5593 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else P_src_error(Rd.s+913,21,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " argument_list "  */
UB PAS_COMILER_PRC_00000003(V *F_pr, UB F_isfunct, UB F_no_entry){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  SL Rv8;
  UW Rv9;
  UB Rv10;
  UW Rv11;
  UB Rv12;
  SL Rv13;
  V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+917;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5632; /* line # 5632 */
  Rv0=0;
  Rv1=Lx[5].v[13];
  Lx[5].v[13]=(*F_pr);
  Rv2=NULL;
  Rv3=0;
  Ra.sl[6]=5637; /* line # 5637 */
  Rv4=(*F_pr);
  if (V_sy_sym.ub[0]==13) {
    V_sy_sym.ub[0]=18;
    while (1){
      Ra.sl[6]=5643; /* line # 5643 */
      P_insymbol();
      if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
        if (F_no_entry) P_src_error(Rd.s+934,125,3);
        Rv0=1;
        Ra.sl[6]=5648; /* line # 5648 */
        Rv5=V_sy_sym.ub[0]==77;
        P_insymbol();
        Rv6=PAS_COMILER_PRC_00000001(Rv5);
        Rv3=Rv3+1;
        Ra.sl[6]=5653; /* line # 5653 */
        if (Rv2==NULL) Rv2=Rv6;
        Rv7=Rv6;
      }
      else {
        Ra.sl[6]=5658; /* line # 5658 */
        Rv8=0;
        Rv9=96;
        Rv10=0;
        Rv11=0;
        Rv12=9;
        while (1){
          Ra.sl[6]=5664; /* line # 5664 */
          switch (V_sy_sym.ub[0]) {
            case 30:Rv12=8;
            break;
            case 35:Rv9=32;
            Rv12=8;
            break;
            case 36:Rv9=64;
            Rv12=8;
            break;
            default:Ra.sl[6]=5669; /* line # 5669 */
            Rv10=1;
            break;
          }
          if (!Rv10) P_insymbol();
          if (Rv10)  break;
        }
        Ra.sl[6]=5674; /* line # 5674 */
        Rv7=NULL;
        while (V_sy_sym.ub[0]==0){
          P_ide_new(5,NULL,&Rv6);
          Rv3=Rv3+1;
          Ra.sl[6]=5679; /* line # 5679 */
          Rv8=Rv8+1;
          if (Rv7==NULL) {
            if (Rv2==NULL) Rv2=Rv6;
            Ra.sl[6]=5684; /* line # 5684 */
            Rv7=Rv6;
          }
          P_insymbol();
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=5689; /* line # 5689 */
            if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+934,29,2);
          }
        }
        if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+934,31,2);
        else P_insymbol();
        Ra.sl[6]=5695; /* line # 5695 */
        if (V_sy_sym.ub[0]==15) {
          while (1){
            P_insymbol();
            if (V_sy_sym.ub[0]==0) {
              Ra.sl[6]=5701; /* line # 5701 */
              Rv6=P_level_search(V_attr_list);
              P_insymbol();
              if (Rv6!=NULL) switch (((UB *)Rv6)[54]) {
                case 17:Rv9=Rv9|2048;
                break;
                case 16:Ra.sl[6]=5706; /* line # 5706 */
                Rv9=Rv9|1024;
                break;
                case 1:Rv9=Rv9|512;
                break;
                case 6:Rv9=Rv9|256;
                break;
                case 21:Ra.sl[6]=5711; /* line # 5711 */
                if (Rv12!=8) P_src_error(Rd.s+934,242,2);
                Rv9=Rv9|8192;
                break;
                case 20:Rv9=(Rv9|32)&~64;
                break;
                case 27:Ra.sl[6]=5716; /* line # 5716 */
                Rv11=Rv11|4;
                break;
                case 28:Rv11=Rv11|8;
                break;
                case 29:Rv11=Rv11|16;
                break;
                case 30:Rv11=Rv11|32;
                break;
                case 31:Rv11=Rv11|64;
                break;
                default:break;
              }
            }
            else {
              Ra.sl[6]=5724; /* line # 5724 */
              P_src_error(Rd.s+934,2,3);
            }
            if (V_sy_sym.ub[0]!=17)  break;
          }
          if (V_sy_sym.ub[0]==16) P_insymbol();
          else P_src_error(Rd.s+934,26,2);
        }
        Ra.sl[6]=5730; /* line # 5730 */
        if (V_sy_sym.ub[0]==37) P_insymbol();
        if (V_sy_sym.ub[0]==40) {
          if (Rv8>1) P_src_error(Rd.s+934,243,3);
          P_insymbol();
          Ra.sl[6]=5735; /* line # 5735 */
          if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+934,25,2);
          Rv13=0;
          if (!V_sy_init_mod) {
            if (Rv12==9&&!V_cmp_dynamic) {
              Ra.sl[6]=5740; /* line # 5740 */
              Rv12=8;
              Rv9=32;
              P_src_error(Rd.s+934,229,1);
            }
          }
          PAS_COMILER_PRC_00000042(&Rv14,1, &Rv13,NULL);
        }
        else {
          Ra.sl[6]=5748; /* line # 5748 */
          PAS_COMILER_PRC_00000038(&Rv14,0,NULL,0,1,NULL);
          if (Rv14!=NULL) {
            if (!V_sy_init_mod) {
              if ((((SL *)Rv14)[11]<0&&Rv12==9)&&!V_cmp_dynamic) {
                Ra.sl[6]=5754; /* line # 5754 */
                Rv12=8;
                Rv9=32;
                P_src_error(Rd.s+934,226,1);
              }
            }
          }
        }
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=5760; /* line # 5760 */
          P_insymbol();
          Rv15=PAS_COMILER_PRC_00000005(Rv14,0,0,0);
          Rv16=Rv15;
          if (((UB *)Rv16)[40]!=14) P_src_error(Rd.s+934,53,3);
          else {
            Ra.sl[6]=5767; /* line # 5767 */
            Rv17=((V *)Rv16)[7];
            ((V *)Rv16)[7]=NULL;
          }
          if (Rv12==8&&64&Rv9) P_src_error(Rd.s+934,241,2);
        }
        else {
          Ra.sl[6]=5773; /* line # 5773 */
          Rv17=NULL;
        }
        Rv6=Rv7;
        while (Rv6!=NULL){
          Rv18=Rv6;
          Ra.sl[6]=5778; /* line # 5778 */
          if (((UB *)Rv18)[86]==0) {
            ((V *)Rv18)[5]=Rv14;
            ((UW *)Rv18)[42]=Rv9;
            ((UB *)Rv18)[86]=Rv12;
            Ra.sl[6]=5783; /* line # 5783 */
            ((V *)Rv18)[7]=Rv17;
            ((UW *)Rv18)[44]=Rv11;
            if (Rv17!=NULL) P_val_new(((V *)Rv18)+7,Rv14);
          }
          Rv7=Rv6;
          Rv6=((V *)Rv6)[3];
        }
        Ra.sl[6]=5789; /* line # 5789 */
        if (Rv17!=NULL) P_val_free(&Rv17);
      }
      if (V_sy_sym.ub[0]!=18)  break;
    }
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else P_src_error(Rd.s+934,23,2);
  }
  Ra.sl[6]=5795; /* line # 5795 */
  ((V *)Rv4)[11]=NULL;
  if (F_isfunct) {
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+934,31,2);
    Ra.sl[6]=5800; /* line # 5800 */
    Rv9=97;
    if (V_sy_sym.ub[0]==15) {
      while (1){
        P_insymbol();
        Ra.sl[6]=5805; /* line # 5805 */
        if (V_sy_sym.ub[0]==0) {
          Rv6=P_level_search(V_attr_list);
          P_insymbol();
          if (Rv6!=NULL) {
            Ra.sl[6]=5810; /* line # 5810 */
            switch (((UB *)Rv6)[54]) {
              case 16:Rv9=Rv9|1024;
              break;
              case 1:Rv9=Rv9|512;
              break;
              default:break;
            }
          }
        }
        else {
          Ra.sl[6]=5816; /* line # 5816 */
          P_src_error(Rd.s+934,2,3);
        }
        if (V_sy_sym.ub[0]!=17)  break;
      }
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else P_src_error(Rd.s+934,26,2);
    }
    Ra.sl[6]=5821; /* line # 5821 */
    PAS_COMILER_PRC_00000038(((V *)Rv4)+11,0,NULL,0,1,NULL);
    if (((V *)Rv4)[11]==NULL) ((V *)Rv4)[11]=V_typ_std.v[21];
  }
  if (((V *)Rv4)[11]!=NULL) {
    Ra.sl[6]=5826; /* line # 5826 */
    if (!((UB *)((V *)Rv4)[11])[92]) {
      Rv19=((V *)Rv4)[11];
      if (((SL *)Rv19)[11]<0&&((V *)Rv19)[1]!=NULL) ((V *)Rv4)[11]=((V *)Rv19)[1]
      ;
      Ra.sl[6]=5833; /* line # 5833 */
      P_ide_create_name(Rd.s+938);
      P_ide_new(5,((V *)Rv4)[11],&Rv6);
      if (Rv2!=NULL) ((V *)Rv7)[3]=NULL;
      Rv20=Rv6;
      Ra.sl[6]=5839; /* line # 5839 */
      ((V *)Rv20)[3]=Rv2;
      Rv2=Rv6;
      ((UW *)Rv20)[42]=Rv9;
      ((UB *)Rv20)[86]=7;
    }
  }
  Ra.sl[6]=5844; /* line # 5844 */
  ((SL *)Rv4)[20]=Rv3;
  ((V *)Rv4)[8]=Rv2;
  Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
  ((V *)Rv4)[6]=((V *)Rv21)[1];
  Ra.sl[6]=5849; /* line # 5849 */
  ((V *)Rv4)[7]=((V *)Rv21)[4];
  ((V *)Rv4)[12]=((V *)Rv21)[5];
  Lx[5].v[13]=Rv1;
  Ra.sl[6]=5854; /* line # 5854 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_decl "  */
V PAS_COMILER_PRC_00000001(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+943;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5872; /* line # 5872 */
  if (V_sy_sym.ub[0]==0) {
    Rv0=P_level_search(V_lex_ident_tree.v[V_curr_disp*8+1]);
    if (Rv0!=NULL) P_src_error(Rd.s+963,101,3);
    Ra.sl[6]=5877; /* line # 5877 */
    P_ide_new(7,NULL,&Rv0);
    Rv1=PAS__NEW(120);
    Rv2=Rv1;
    ((V *)Rv2)[0]=NULL;
    Ra.sl[6]=5882; /* line # 5882 */
    ((V *)Rv2)[1]=NULL;
    ((UW *)Rv2)[8]=0;
    ((V *)Rv2)[3]=NULL;
    ((UB *)Rv2)[32]=29;
    ((V *)Rv2)[5]=NULL;
    Ra.sl[6]=5887; /* line # 5887 */
    ((V *)Rv2)[6]=NULL;
    ((V *)Rv2)[7]=NULL;
    ((V *)Rv2)[8]=NULL;
    ((SL *)Rv2)[18]=V_curr_lex;
    ((SL *)Rv2)[19]=0;
    Ra.sl[6]=5892; /* line # 5892 */
    ((SL *)Rv2)[20]=0;
    ((V *)Rv2)[11]=NULL;
    ((V *)Rv2)[12]=NULL;
    ((UB *)Rv2)[104]=4;
    ((V *)Rv2)[14]=NULL;
    Ra.sl[6]=5898; /* line # 5898 */
    ((V *)Rv0)[8]=Rv1;
    Rv3=V_curr_lex;
    Rv4=V_curr_disp;
    if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
    else {
      Ra.sl[6]=5903; /* line # 5903 */
      P_src_error(Rd.s+963,1002,3);
    }
    P_new_disp_level(Rv1,4);
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    P_insymbol();
    Rv5=PAS_COMILER_PRC_00000003(&Rv1, F_isfunction,0);
    Ra.sl[6]=5908; /* line # 5908 */
    V_curr_lex=Rv3;
    V_curr_disp=Rv4;
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[6]=5913; /* line # 5913 */
      P_insymbol();
      if (V_sy_sym.ub[0]==0) {
        Rv6=P_ide_search(898);
        Ra.sl[6]=5918; /* line # 5918 */
        if (Rv6!=V_ide_udptr.v[1]) {
          Rv7=Rv6;
          Rv8=NULL;
          if (((UB *)Rv7)[53]==7) {
            Ra.sl[6]=5924; /* line # 5924 */
            Rv8=((V *)Rv7)[8];
            if (Rv8==Rv1) P_src_error(Rd.s+963,403,3);
          }
          else {
            Ra.sl[6]=5929; /* line # 5929 */
            if (((V *)Rv7)[11]!=((V *)Rv7)[10]&&((V *)Rv7)[11]!=NULL) P_src_error_s(
            Rd.s+963,118,2, V_sy_ident.s,NULL);
            else {
              Rv9=((V *)Rv7)[10];
              if (((UB *)Rv9)[8]) P_src_error(Rd.s+963,998,4);
              else {
                Ra.sl[6]=5934; /* line # 5934 */
                Rv8=((V *)Rv9)[2];
              }
            }
          }
          if (!P_comp_proc_arg(Rv8, Rv1)) P_src_error(Rd.s+963,119,3);
          else((V *)Rv0)[7]=Rv8;
          Ra.sl[6]=5939; /* line # 5939 */
          P_insymbol();
        }
      }
      else P_src_error(Rd.s+963,32,3);
    }
  }
  else {
    Ra.sl[6]=5948; /* line # 5948 */
    Rv0=V_ide_udptr.v[7];
    P_src_error(Rd.s+963,107,3);
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_ptr "  */
V PAS_COMILER_PRC_00000002(UB F_isfunction, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  UB Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+967;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5970; /* line # 5970 */
  Rv0=PAS__NEW(120);
  Rv1=Rv0;
  Ra.sl[6]=5975; /* line # 5975 */
  ((V *)Rv1)[0]=NULL;
  ((V *)Rv1)[1]=NULL;
  ((UW *)Rv1)[8]=0;
  ((V *)Rv1)[3]=NULL;
  ((UB *)Rv1)[32]=29;
  Ra.sl[6]=5980; /* line # 5980 */
  ((V *)Rv1)[5]=NULL;
  ((V *)Rv1)[6]=NULL;
  ((V *)Rv1)[7]=NULL;
  ((V *)Rv1)[8]=NULL;
  ((SL *)Rv1)[18]=V_curr_lex;
  Ra.sl[6]=5985; /* line # 5985 */
  ((SL *)Rv1)[19]=0;
  ((SL *)Rv1)[20]=0;
  ((V *)Rv1)[11]=NULL;
  ((V *)Rv1)[12]=NULL;
  ((UB *)Rv1)[104]=4;
  Ra.sl[6]=5990; /* line # 5990 */
  ((V *)Rv1)[14]=NULL;
  Rv2=V_curr_lex;
  Rv3=V_curr_disp;
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=5995; /* line # 5995 */
    P_src_error(Rd.s+986,1002,3);
  }
  P_new_disp_level(Rv0,4);
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  P_insymbol();
  Rv4=PAS_COMILER_PRC_00000003(&Rv0, F_isfunction,0);
  Ra.sl[6]=6000; /* line # 6000 */
  V_curr_lex=Rv2;
  V_curr_disp=Rv3;
  if (V_sy_sym.ub[0]==22) {
    P_insymbol();
    Ra.sl[6]=6005; /* line # 6005 */
    if (V_sy_sym.ub[0]==0) {
      Rv5=P_ide_search(898);
      if (Rv5!=V_ide_udptr.v[1]) {
        Ra.sl[6]=6010; /* line # 6010 */
        Rv6=Rv5;
        Rv7=NULL;
        if (((UB *)Rv6)[53]==7) {
          Ra.sl[6]=6015; /* line # 6015 */
          Rv7=((V *)Rv6)[8];
          if (Rv7==Rv0) P_src_error(Rd.s+986,403,3);
        }
        else {
          Ra.sl[6]=6020; /* line # 6020 */
          if (((V *)Rv6)[11]!=((V *)Rv6)[10]&&((V *)Rv6)[11]!=NULL) P_src_error_s(
          Rd.s+986,118,2, V_sy_ident.s,NULL);
          else {
            Rv8=((V *)Rv6)[10];
            if (((UB *)Rv8)[8]) P_src_error(Rd.s+986,998,4);
            else {
              Ra.sl[6]=6025; /* line # 6025 */
              Rv7=((V *)Rv8)[2];
            }
          }
        }
        if (!P_comp_proc_arg(Rv7, Rv0)) P_src_error(Rd.s+986,119,3);
        else((V *)Rv5)[7]=Rv7;
        Ra.sl[6]=6030; /* line # 6030 */
        P_insymbol();
      }
    }
    else P_src_error(Rd.s+986,32,3);
  }
  else {
    Ra.sl[6]=6035; /* line # 6035 */
    Rv7=NULL;
  }
  P_ide_new_typ(6, &Rv9);
  Rv10=Rv9;
  Ra.sl[6]=6040; /* line # 6040 */
  ((V *)Rv10)[3]=F_owid;
  ((V *)Rv10)[0]=NULL;
  memcpy(Rv10+48,V_typ_std.v[13]+48,1);
  ((SL *)Rv10)[11]=V_fptr_size;
  ((V *)Rv10)[12]=((V *)Rv0)[11];
  Ra.sl[6]=6045; /* line # 6045 */
  ((V *)Rv10)[13]=Rv0;
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insert_new_generic "  */
void PAS_COMILER_PRC_00000049(V *F_pgfirst, V *F_pglast, V F_pg, UB F_bwfent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+990;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6058; /* line # 6058 */
  if (F_pg!=NULL) {
    if (F_bwfent&&(*F_pgfirst)!=NULL) P_src_error(Rd.s+1012,114,3);
    Ra.sl[6]=6063; /* line # 6063 */
    if (V_sy_generic_qmod) {
      if ((*F_pgfirst)==NULL) (*F_pgfirst)=F_pg;
      else((V *)(*F_pglast))[0]=F_pg;
      (*F_pglast)=F_pg;
    }
    else {
      Ra.sl[6]=6071; /* line # 6071 */
      ((V *)F_pg)[0]=(*F_pgfirst);
      (*F_pgfirst)=F_pg;
      if ((*F_pglast)==NULL) (*F_pglast)=F_pg;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_decl "  */
void PAS_COMILER_PRC_00000051(V F_pgf, V F_pgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  UB Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1016;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6137; /* line # 6137 */
  Lx[3].ub[0]=0;
  Lx[3].v[1]=NULL;
  Rv0=NULL;
  P_insymbol();
  Ra.sl[6]=6142; /* line # 6142 */
  if (V_sy_sym.ub[0]==13) Lx[3].ub[16]=0;
  if (!Lx[3].ub[16]) {
    Lx[3].v[3]=PAS__NEW(245);
    Rv1=Lx[3].v[3];
    Ra.sl[6]=6148; /* line # 6148 */
    ((V *)Rv1)[0]=NULL;
    ((V *)Rv1)[1]=NULL;
    ((UW *)Rv1)[8]=0;
    ((V *)Rv1)[3]=NULL;
    ((UB *)Rv1)[32]=29;
    Ra.sl[6]=6153; /* line # 6153 */
    ((V *)Rv1)[5]=NULL;
    ((V *)Rv1)[6]=NULL;
    ((V *)Rv1)[7]=NULL;
    ((V *)Rv1)[8]=NULL;
    ((SL *)Rv1)[18]=V_curr_lex;
    Ra.sl[6]=6158; /* line # 6158 */
    ((SL *)Rv1)[19]=0;
    ((SL *)Rv1)[20]=0;
    ((V *)Rv1)[11]=NULL;
    ((V *)Rv1)[12]=NULL;
    ((UB *)Rv1)[104]=10;
    Ra.sl[6]=6164; /* line # 6164 */
    ((V *)Rv1)[14]=Lx[5].v[13];
    ((V *)Rv1)[15]=NULL;
    ((V *)Rv1)[16]=NULL;
    ((V *)Rv1)[17]=NULL;
    ((V *)Rv1)[18]=NULL;
    Ra.sl[6]=6169; /* line # 6169 */
    ((V *)Rv1)[19]=NULL;
    ((V *)Rv1)[20]=NULL;
    ((V *)Rv1)[21]=NULL;
    ((V *)Rv1)[22]=NULL;
    ((V *)Rv1)[23]=NULL;
    Ra.sl[6]=6174; /* line # 6174 */
    ((V *)Rv1)[24]=NULL;
    ((V *)Rv1)[25]=NULL;
    ((V *)Rv1)[26]=NULL;
    ((V *)Rv1)[27]=NULL;
    ((SL *)Rv1)[56]=-1;
    Ra.sl[6]=6179; /* line # 6179 */
    ((SL *)Rv1)[57]=0;
    ((SL *)Rv1)[58]=0;
    ((SL *)Rv1)[59]=0;
    ((SL *)Rv1)[60]=0;
    ((UB *)Rv1)[244]=0;
  }
  else {
    Ra.sl[6]=6187; /* line # 6187 */
    Rv2=Lx[3].v[3];
    Rv0=((V *)Rv2)[8];
    if (((V *)Rv2)[11]!=NULL) {
      if (!((UB *)((V *)Rv2)[11])[92]) {
        Ra.sl[6]=6192; /* line # 6192 */
        Rv0=((V *)Rv0)[3];
      }
    }
  }
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=6197; /* line # 6197 */
    P_src_error(Rd.s+1029,1002,3);
  }
  P_new_disp_level(Lx[3].v[3],4);
  V_lex_ident_tree.v[V_curr_disp*8+1]=Rv0;
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Lx[3].sl[8]=V_curr_disp;
  Lx[3].sl[9]=V_curr_lex;
  Ra.sl[6]=6203; /* line # 6203 */
  if (!Lx[3].ub[16]) {
    Lx[3].ub[40]=PAS_COMILER_PRC_00000003(Lx[3].v+3,Lx[3].ub[41],Lx[3].ub[42]);
    Ra.sl[6]=6209; /* line # 6209 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+1029,21,2);
    Ra.sl[6]=6214; /* line # 6214 */
    if (Lx[3].sl[11]!=0) {
      if (Lx[3].sl[11]>0) {
        if (((SL *)Lx[3].v[3])[20]!=Lx[3].sl[11]) P_src_error_s(Rd.s+1029,127,2,
        Lx[3].s+48,NULL);
        else {
          if (((SL *)Lx[3].v[3])[20]!=1&&((SL *)Lx[3].v[3])[20]!=2) {
            Ra.sl[6]=6219; /* line # 6219 */
            P_src_error_s(Rd.s+1029,127,2, Lx[3].s+48,NULL);
          }
        }
      }
    }
    Lx[3].v[1]=P_compare_proc_argid(F_pgf, F_pgl, Lx[3].v[3]);
    Rv3=Lx[3].v[1]==NULL;
    Ra.sl[6]=6224; /* line # 6224 */
    if (!Rv3) {
      Rv4=Lx[3].v[3];
      Lx[3].v[3]=((V *)Lx[3].v[1])[2];
      Rv0=((V *)Lx[3].v[3])[8];
      Ra.sl[6]=6229; /* line # 6229 */
      Rv5=((V *)Rv4)[8];
      while (Rv0!=NULL&&Rv5!=NULL){
        PAS__DISPOSE(((V *)Rv0));
        ((V *)Rv0)[0]=((V *)Rv5)[0];
        Ra.sl[6]=6234; /* line # 6234 */
        Rv0=((V *)Rv0)[3];
        Rv5=((V *)Rv5)[3];
      }
      Rv6=(V_lex_ident_tree.s+V_curr_disp*64);
      Rv7=Lx[3].v[3];
      P_free_ide_list(((V *)Rv4)+8);
      Ra.sl[6]=6239; /* line # 6239 */
      P_free_typ_list(((V *)Rv4)+12);
      ((V *)Rv6)[0]=Lx[3].v[3];
      ((V *)Rv6)[1]=((V *)Rv7)[6];
      Ra.sl[6]=6244; /* line # 6244 */
      ((V *)Rv6)[4]=((V *)Rv7)[7];
      ((V *)Rv6)[5]=((V *)Rv7)[12];
      Ra.sl[6]=6250; /* line # 6250 */
      Lx[3].v[1]=NULL;
      switch (((UB *)Lx[3].v[3])[104]) {
        case 3:if (Lx[3].ub[80]!=9) P_src_error_s(Rd.s+1029,100,2, Lx[3].s+48,NULL);
        break;
        case 8:Ra.sl[6]=6256; /* line # 6256 */
        if (Lx[3].ub[80]!=10) P_src_error_s(Rd.s+1029,100,2, Lx[3].s+48,NULL);
        break;
        default:P_src_error_s(Rd.s+1029,102,2, Lx[3].s+48,NULL);
        Lx[3].ub[80]=9;
        break;
      }
      Ra.sl[6]=6261; /* line # 6261 */
      PAS__DISPOSE(&Rv4);
      ((UB *)Lx[3].v[3])[104]=10;
    }
    else {
      Ra.sl[6]=6266; /* line # 6266 */
      Lx[3].v[1]=PAS__NEW(32);
      Rv8=Lx[3].v[1];
      ((V *)Rv8)[0]=NULL;
      ((UB *)Rv8)[8]=0;
      Ra.sl[6]=6271; /* line # 6271 */
      ((V *)Rv8)[2]=Lx[3].v[3];
      if (V_pro_d_first==NULL) V_pro_d_first=Lx[3].v[3];
      else((V *)V_pro_d_last)[1]=Lx[3].v[3];
      Ra.sl[6]=6276; /* line # 6276 */
      V_pro_d_last=Lx[3].v[3];
    }
  }
  else {
    Rv9=Lx[3].v[3];
    Ra.sl[6]=6282; /* line # 6282 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+1029,21,2);
    if (((UB *)Rv9)[104]==3) Lx[3].ub[80]=9;
    ((UB *)Rv9)[104]=10;
  }
  Ra.sl[6]=6289; /* line # 6289 */
  Rv10=Lx[3].v[3];
  if (V_sy_sym.ub[0]==79) {
    if (Lx[3].ub[16]||((UB *)Rv10)[104]!=10) P_src_error_s(Rd.s+1029,128,2, Lx[3]
    .s+48,NULL);
    else {
      Ra.sl[6]=6294; /* line # 6294 */
      ((UB *)Rv10)[104]=8;
    }
    P_insymbol();
    if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
    else {
      if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
        Ra.sl[6]=6300; /* line # 6300 */
        ((UB *)Rv10)[32]=Lx[3].ub[82];
        ((V *)Rv10)[3]=PAS__NEW(32);
        if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
        else {
          Ra.sl[6]=6305; /* line # 6305 */
          memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
      }
      else((V *)Rv10)[3]=P_new_int_name(Rd.s+1035,&V_proc_seq);
    }
    Ra.sl[6]=6310; /* line # 6310 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+1029,21,2);
  }
  else {
    if (V_sy_sym.ub[0]==83||V_sy_sym.ub[0]==85&&V_sy_init_mod) {
      Ra.sl[6]=6316; /* line # 6316 */
      if (((UB *)Rv10)[104]!=10) P_src_error_s(Rd.s+1029,108,2, Lx[3].s+48,NULL);
      if (V_sy_sym.ub[0]==83) {
        Ra.sl[6]=6321; /* line # 6321 */
        ((UB *)Rv10)[104]=3;
        ((SL *)Rv10)[18]=1;
      }
      else {
        Ra.sl[6]=6327; /* line # 6327 */
        ((UB *)Rv10)[104]=1;
        ((SL *)Rv10)[18]=0;
      }
      P_insymbol();
      Ra.sl[6]=6332; /* line # 6332 */
      if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
      else {
        if (Lx[3].ub[80]==((UB *)Rv10)[104]&&Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6337; /* line # 6337 */
          ((V *)Rv10)[3]=Lx[3].v[11];
        }
        else {
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6342; /* line # 6342 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
        }
      }
      Ra.sl[6]=6347; /* line # 6347 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else P_src_error(Rd.s+1029,21,2);
    }
    else {
      Ra.sl[6]=6352; /* line # 6352 */
      Lx[3].ub[0]=1;
      if (Lx[3].ub[80]!=10) {
        ((UB *)Rv10)[104]=Lx[3].ub[80];
        Ra.sl[6]=6357; /* line # 6357 */
        ((SL *)Rv10)[18]=1;
        if (Lx[3].v[11]!=NULL) {
          if (Rv3) ((V *)Rv10)[3]=Lx[3].v[11];
          else {
            Ra.sl[6]=6362; /* line # 6362 */
            if (((V *)Rv10)[3]!=NULL) {
              if (P_match(((V *)Rv10)[3],Lx[3].v[11])!=0) P_src_error(Rd.s+1029,129,1);
            }
          }
        }
        else {
          Ra.sl[6]=6369; /* line # 6369 */
          if (((UB *)Rv10)[32]==29) P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          else P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
        }
        Ra.sl[6]=6375; /* line # 6375 */
        switch (Lx[3].ub[80]) {
          case 3:Lx[3].ub[0]=0;
          break;
          case 9:if (Lx[3].sl[24]>1) P_src_error(Rd.s+1029,404,2);
          break;
          default:break;
        }
      }
      Ra.sl[6]=6384; /* line # 6384 */
      Rv11=0;
      Rv12=0;
      while (1){
        switch (V_sy_sym.ub[0]) {
          case 86:Ra.sl[6]=6390; /* line # 6390 */
          P_insymbol();
          ((UW *)Rv10)[8]=1;
          Rv12=1;
          break;
          case 5:
          case 84:Ra.sl[6]=6397; /* line # 6397 */
          if (V_sy_sym.ub[0]==84) {
            ((UB *)Rv10)[104]=9;
            P_insymbol();
          }
          if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
          else P_src_error(Rd.s+1029,58,2);
          Rv12=1;
          break;
          default:Ra.sl[6]=6405; /* line # 6405 */
          Rv11=1;
          if (Rv12) {
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else P_src_error(Rd.s+1029,21,2);
          }
          break;
        }
        if (Rv11)  break;
      }
      Ra.sl[6]=6412; /* line # 6412 */
      if (((V *)Rv10)[3]==NULL) {
        if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6417; /* line # 6417 */
          ((V *)Rv10)[3]=PAS__NEW(32);
          if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
          else memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
        else {
          Ra.sl[6]=6422; /* line # 6422 */
          ((V *)Rv10)[3]=P_new_int_name(Rd.s+1041,&V_proc_seq);
        }
      }
    }
  }
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6427; /* line # 6427 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_body "  */
void PAS_COMILER_PRC_00000052(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1045;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6441; /* line # 6441 */
  V_curr_disp=Lx[3].sl[8];
  V_curr_lex=Lx[3].sl[9];
  Rv0=Lx[3].v[3];
  if (V_cmp_traceopt>0) {
    Ra.sl[6]=6447; /* line # 6447 */
    if (V_cmp_trace>=0) Rv1=3;
    else Rv1=5;
    V_cmp_trace=V_cmp_traceopt;
    P_gen_cntxvar(Lx[3].v[3],Lx[3].v[14]);
  }
  else {
    Ra.sl[6]=6454; /* line # 6454 */
    if (V_cmp_trace>0) V_cmp_trace=0;
  }
  P_lgt_all_fparm(Lx[3].v[3]);
  P_cmp_block(Lx[3].v[3],1, Rv1);
  Ra.sl[6]=6460; /* line # 6460 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else P_src_error(Rd.s+1058,54,3);
  if (V_sy_sym.ub[0]==0&&Lx[3].ub[82]==29) {
    Ra.sl[6]=6465; /* line # 6465 */
    if (V_sy_sym.ub[0]==0&&P_match(Lx[3].s+48,V_sy_ident.s)==0) P_insymbol();
    else P_src_error_s(Rd.s+1058,71,2, V_sy_ident.s,NULL);
  }
  else {
    if (V_sy_sym.ub[0]!=18) {
      Ra.sl[6]=6470; /* line # 6470 */
      if (V_sy_sym.ub[0]==22&&Lx[3].ub[82]==28||V_sy_sym.ub[1]==Lx[3].ub[82]) P_insymbol();
      else P_src_error(Rd.s+1058,72,2);
    }
  }
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1058,21,2);
  else P_insymbol();
  Ra.sl[6]=6477; /* line # 6477 */
  if (V_cmp_objf&&V_error_result<=1) {
    if (V_cmp_trace>0&&((V *)Rv0)[16]!=NULL) P_gen_linetrace(Lx[3].v[3],((V *)Rv0)
    +16,((V *)Rv0)+17,4);
    Ra.sl[6]=6483; /* line # 6483 */
    if (((V *)Rv0)[16]!=((V *)Rv0)[17]) {
      P_lgt_new(((V *)Rv0)+16,NULL,0,((V *)Rv0)[16]);
      ((UB *)((V *)Rv0)[16])[41]=2;
      ((V *)Rv0)[17]=((V *)Rv0)[16];
    }
    Ra.sl[6]=6490; /* line # 6490 */
    if (((UB *)Rv0)[104]==11) ((UW *)Rv0)[8]=((UW *)Rv0)[8]|129;
    else((UW *)Rv0)[8]=((UW *)Rv0)[8]|128;
    Ra.sl[6]=6496; /* line # 6496 */
    if (V_pro_last==NULL) V_pro_first=Lx[3].v[3];
    else((V *)V_pro_last)[0]=Lx[3].v[3];
    V_pro_last=Lx[3].v[3];
    Ra.sl[6]=6501; /* line # 6501 */
    PAS_COMILER_cmp_pass2(Lx[3].v[3]);
  }
  Ra.sl[6]=6506; /* line # 6506 */
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gene_decl "  */
void PAS_COMILER_PRC_00000050(){
  /* Define the automatic variable space. */
  Blk( Ra, 184 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  UB Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  UB Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+1062;
  Ra.v[17]=Rd.s+17;
  Ra.sl[36]=6514; /* line # 6514 */
  Ra.ub[16]=0;
  Ra.ub[42]=1;
  Ra.ub[40]=0;
  Ra.v[3]=NULL;
  Ra.ub[82]=29;
  Ra.sl[36]=6519; /* line # 6519 */
  Ra.ub[81]=0;
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[11]=0;
  Ra.v[13]=Lx[5].v[1];
  Ra.sl[36]=6524; /* line # 6524 */
  Ra.sl[24]=V_curr_lex;
  Ra.sl[25]=V_curr_disp;
  Ra.sl[36]=6529; /* line # 6529 */
  Ra.ub[80]=10;
  Ra.v[11]=NULL;
  if (Lx[5].ub[16]!=1) {
    switch (Lx[5].ub[16]) {
      case 4:
      case 5:Ra.sl[36]=6536; /* line # 6536 */
      if (Lx[5].ub[16]==4) Ra.ub[80]=9;
      else Ra.ub[80]=3;
      if (Lx[5].v[3]!=NULL) {
        Ra.v[11]=Lx[5].v[3];
        Lx[5].v[3]=NULL;
      }
      break;
      default:Ra.sl[36]=6542; /* line # 6542 */
      P_src_error(Rd.s+1058,81,2);
      break;
    }
    Lx[5].ub[16]=1;
    Lx[5].v[3]=NULL;
  }
  Ra.sl[36]=6548; /* line # 6548 */
  Ra.ub[41]=V_sy_sym.ub[0]==77;
  P_insymbol();
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[36]=6553; /* line # 6553 */
    memcpy(Ra.s+48,V_sy_ident.s,32);
    V_err_prt=0;
    Rv1=P_ide_search(770);
    V_err_prt=1;
    if (Rv1!=NULL) {
      Ra.sl[36]=6558; /* line # 6558 */
      if (((SL *)Rv1)[12]!=V_curr_lex) Rv0=NULL;
      else Rv0=Rv1;
    }
    else Rv0=NULL;
    if (Rv0!=NULL) {
      Ra.sl[36]=6563; /* line # 6563 */
      Rv2=Rv0;
      Ra.v[14]=((V *)Rv2)[0];
      switch (((UB *)Rv2)[53]) {
        case 1:
        case 8:
        case 9:Ra.sl[36]=6568; /* line # 6568 */
        if (((V *)Rv2)[8]!=NULL) {
          Ra.ub[16]=1;
          Ra.v[3]=((V *)Rv2)[8];
          Rv3=Ra.v[3];
          Ra.sl[36]=6573; /* line # 6573 */
          if (((UB *)Rv3)[104]==8||((UB *)Rv3)[104]==3) Ra.ub[42]=0;
        }
        break;
        default:Ra.sl[36]=6579; /* line # 6579 */
        P_src_error_s(Rd.s+1058,101,3,((V *)Rv2)[0],NULL);
        break;
      }
      PAS_COMILER_PRC_00000051(((V *)Rv2)[10],((V *)Rv2)[11]);
      Ra.sl[36]=6584; /* line # 6584 */
      PAS_COMILER_PRC_00000049(((V *)Rv2)+10,((V *)Rv2)+11,Ra.v[1],((UB *)Rv2)[53]
      ==8);
    }
    else {
      Ra.sl[36]=6608; /* line # 6608 */
      Ra.ub[42]=0;
      Ra.v[14]=PAS__NEW(32);
      ((UB *)Ra.v[14])[0]=V_sy_ident.ub[0];
      Ra.sl[36]=6613; /* line # 6613 */
      Rv4=1;
      for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
        ((C *)Ra.v[14])[Rv4]=V_sy_ident.c[Rv4];
        Rv4++;
      }
      Ra.ub[81]=Rv1==NULL;
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6618; /* line # 6618 */
      memcpy(Ra.s+148,V_sy_ident.s,32);
      memcpy(V_sy_ident.s,Ra.s+48,32);
      if (Ra.ub[40]) {
        P_ide_new(8,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6623; /* line # 6623 */
        Rv5=Rv0;
        ((V *)Rv5)[10]=Ra.v[1];
        ((V *)Rv5)[11]=NULL;
        Ra.sl[36]=6628; /* line # 6628 */
        if (((UB *)Ra.v[3])[104]==8||((UB *)Ra.v[3])[104]==3) ((V *)Rv5)[8]=Ra.v[
3];
        else((V *)Rv5)[8]=NULL;
      }
      else {
        Ra.sl[36]=6636; /* line # 6636 */
        if (Rv1!=NULL) {
          Rv6=((UB *)Rv1)[53];
          ((V *)Ra.v[1])[0]=((V *)Rv1)[10];
        }
        else {
          Ra.sl[36]=6643; /* line # 6643 */
          Rv6=9;
          ((V *)Ra.v[1])[0]=NULL;
        }
        P_ide_new(Rv6,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6651; /* line # 6651 */
        Rv7=Rv0;
        ((V *)Rv7)[10]=Ra.v[1];
        ((V *)Rv7)[11]=Ra.v[1];
        if (((UB *)Ra.v[3])[104]==8) ((V *)Rv7)[8]=Ra.v[3];
        else {
          Ra.sl[36]=6656; /* line # 6656 */
          ((V *)Rv7)[8]=NULL;
        }
      }
      memcpy(V_sy_ident.s,Ra.s+148,32);
    }
    Ra.sl[36]=6663; /* line # 6663 */
    if (V_sy_init_mod) {
      Rv8=1;
      switch (V_sy_sym.ub[0]) {
        case 58:V_new_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 59:Ra.sl[36]=6668; /* line # 6668 */
        V_newh_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 60:V_dispose_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 42:V_set_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 61:V_iof_std_open=Rv0;
        break;
        case 39:Ra.sl[36]=6673; /* line # 6673 */
        V_iof_std_close=Rv0;
        break;
        case 62:V_inp_std_sel=Rv0;
        break;
        case 65:V_inp_std_gene=Rv0;
        break;
        case 66:V_inp_std_eoln=Rv0;
        break;
        case 35:V_inp_std_bin=Rv0;
        break;
        case 63:Ra.sl[36]=6678; /* line # 6678 */
        V_out_std_sel=Rv0;
        break;
        case 68:V_out_std_gene=Rv0;
        break;
        case 69:V_out_std_eoln=Rv0;
        break;
        case 36:V_out_std_bin=Rv0;
        break;
        case 41:Ra.sl[36]=6683; /* line # 6683 */
        V_gen_std_string1=Rv0;
        break;
        case 40:V_gen_std_cnfardsc=Rv0;
        break;
        default:Rv8=0;
        break;
      }
      Ra.sl[36]=6689; /* line # 6689 */
      if (Rv8) {
        P_insymbol();
        if (V_sy_sym.ub[0]==18) P_insymbol();
        else P_src_error(Rd.s+1058,21,2);
      }
    }
    Ra.sl[36]=6697; /* line # 6697 */
    if (Ra.v[3]!=NULL) ((V *)Ra.v[3])[5]=Rv0;
    break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 22:Ra.sl[36]=6709; /* line # 6709 */
    if (V_sy_sym.ub[0]==6) Ra.sl[11]=1;
    else Ra.sl[11]=2;
    if (V_sy_sym.ub[0]==22) {
      if (Ra.ub[41]) P_src_error(Rd.s+1058,115,3);
      Ra.sl[36]=6714; /* line # 6714 */
      Ra.ub[82]=28;
    }
    else {
      Ra.ub[82]=V_sy_sym.ub[1];
      if (!Ra.ub[41]) P_src_error(Rd.s+1058,116,3);
    }
    Ra.sl[36]=6720; /* line # 6720 */
    if (Ra.ub[82]==12) Ra.sl[11]=-1;
    memcpy(Ra.s+48,(V_opname.s+Ra.ub[82]*32),32);
    Ra.v[14]=PAS__NEW(32);
    Ra.sl[36]=6725; /* line # 6725 */
    Rv9=(V_opname.s+Ra.ub[82]*32);
    ((UB *)Ra.v[14])[0]=((UB *)Rv9)[0]+2;
    ((C *)Ra.v[14])[1]=79;
    ((C *)Ra.v[14])[2]=95;
    Ra.sl[36]=6730; /* line # 6730 */
    Rv10=1;
    for( Rf0=((UB *)Rv9)[0];Rf0>0;Rf0-- ) {
      ((C *)Ra.v[14])[(2+Rv10)]=((C *)Rv9)[Rv10];
      Rv10++;
    }
    Rv11=V_ope_table.v[Ra.ub[82]];
    if (Rv11!=NULL) Rv12=((SL *)Rv11)[1]==V_curr_lex;
    else {
      Ra.sl[36]=6735; /* line # 6735 */
      Rv12=0;
    }
    if (Rv12) {
      Rv13=Rv11;
      Ra.v[3]=NULL;
      Ra.sl[36]=6740; /* line # 6740 */
      PAS_COMILER_PRC_00000051(((V *)Rv13)[3],((V *)Rv13)[4]);
      PAS_COMILER_PRC_00000049(((V *)Rv13)+3,((V *)Rv13)+4,Ra.v[1],0);
    }
    else {
      Ra.sl[36]=6753; /* line # 6753 */
      Ra.v[3]=NULL;
      PAS_COMILER_PRC_00000051(NULL,NULL);
      if (Ra.v[1]!=NULL) {
        Rv14=PAS__NEW(40);
        Ra.sl[36]=6758; /* line # 6758 */
        Rv15=Rv14;
        ((UB *)Rv15)[0]=Ra.ub[82];
        ((SL *)Rv15)[1]=V_curr_lex;
        ((V *)Rv15)[1]=((V *)Lx[5].v[13])[19];
        Ra.sl[36]=6763; /* line # 6763 */
        ((V *)Rv15)[2]=Rv11;
        ((V *)Rv15)[3]=Ra.v[1];
        ((V *)Rv15)[4]=Ra.v[1];
        if (Rv11==NULL) ((V *)Ra.v[1])[0]=NULL;
        else {
          Ra.sl[36]=6769; /* line # 6769 */
          ((V *)Ra.v[1])[0]=((V *)Rv11)[3];
        }
      }
      ((V *)Lx[5].v[13])[19]=Rv14;
      V_ope_table.v[Ra.ub[82]]=Rv14;
    }
    Ra.sl[36]=6776; /* line # 6776 */
    if (Ra.v[3]!=NULL) ((UB *)Ra.v[3])[32]=Ra.ub[82];
    break;
    default:Ra.sl[36]=6786; /* line # 6786 */
    P_src_error(Rd.s+1058,117,3);
    break;
  }
  if (Ra.ub[0]) PAS_COMILER_PRC_00000052();
  PAS__curr_cntx=Ra.v[15];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " gen_assign "  */
V PAS_COMILER_PRC_00000053(V F_target, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1073;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6816; /* line # 6816 */
  Rv0=V_sy_label_flag;
  V_sy_label_flag=0;
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6822; /* line # 6822 */
  V_sy_label_flag=Rv0;
  ((V *)F_target)[0]=Rv1;
  if (((UB *)F_target)[40]==8) {
    Rv2=((V *)F_target)[6];
    Ra.sl[6]=6828; /* line # 6828 */
    Rv3=1;
    if (((V *)Rv2)[11]!=NULL) {
      if (((UB *)((V *)Rv2)[11])[93]==24) Rv3=0;
    }
    if (Rv3) P_src_error(Rd.s+1087,175,3);
  }
  Ra.sl[6]=6833; /* line # 6833 */
  Rv4=P_lgt_gen_store(F_target,0, F_bovr);
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " return_state "  */
V PAS_COMILER_PRC_00000054(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1091;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6856; /* line # 6856 */
  Rv0=NULL;
  Rv1=PAS_COMILER_PRC_00000023();
  if (Rv1!=NULL) {
    Rv2=Rv1;
    Ra.sl[6]=6862; /* line # 6862 */
    if (((V *)Rv2)[11]==NULL) {
      if (F_ip!=NULL) {
        Ra.sl[6]=6867; /* line # 6867 */
        P_src_error_s(Rd.s+1107,172,3,((V *)F_ip)[0],NULL);
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[6]=6872; /* line # 6872 */
        P_lgt_new(&Rv0,NULL,0,NULL);
        ((UB *)Rv0)[41]=7;
      }
    }
    else {
      Ra.sl[6]=6878; /* line # 6878 */
      if (V_sy_sym.ub[0]==77) {
        P_insymbol();
        Rv3=1;
      }
      else {
        Ra.sl[6]=6884; /* line # 6884 */
        Rv3=F_ip!=NULL;
        if (Rv3&&F_ip!=((V *)Rv2)[5]) {
          P_src_error_s(Rd.s+1107,405,3,((V *)F_ip)[0],NULL);
          P_skip_symbol(18,0,0);
        }
      }
      Ra.sl[6]=6893; /* line # 6893 */
      Rv4=NULL;
      Lx[5].ub[40]=1;
      if (((UB *)((V *)Rv2)[11])[92]) {
        Ra.sl[6]=6898; /* line # 6898 */
        P_lgt_new(&Rv4,((V *)Rv2)[11],12,NULL);
        ((V *)Rv4)[6]=Rv1;
        if (F_ip!=NULL) {
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else P_src_error(Rd.s+1107,32,2);
        }
      }
      else {
        Ra.sl[6]=6906; /* line # 6906 */
        if (!Rv3||V_sy_sym.ub[0]==22) {
          Rv4=P_lgt_new_idref(((V *)Rv2)[8],NULL);
          Rv5=((V *)Rv2)[8];
          if ((((UB *)((V *)Rv5)[5])[90]||((UB *)((V *)Rv5)[5])[91])&&!(16&((UW *)
          Rv5)[42])) {
            Ra.sl[6]=6912; /* line # 6912 */
            P_init_d_varbl(((V *)Rv2)[8]);
          }
          if (F_ip!=NULL) P_insymbol();
        }
        else {
          Ra.sl[6]=6917; /* line # 6917 */
          V_sy_search=((V *)Rv2)[8];
          V_lastsymb=V_sy_sym.ub[0];
          V_sy_sym.ub[0]=0;
          Rv4=PAS_COMILER_PRC_00000000();
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6922; /* line # 6922 */
            P_src_error(Rd.s+1107,32,2);
          }
        }
      }
      Ra.sl[6]=6927; /* line # 6927 */
      Rv0=PAS_COMILER_PRC_00000053(Rv4,1);
      if (!Rv3) {
        P_lgt_new(&Rv0,NULL,0, Rv0);
        Ra.sl[6]=6932; /* line # 6932 */
        ((UB *)Rv0)[41]=7;
      }
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " assignment_state "  */
V PAS_COMILER_PRC_00000055(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1111;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6949; /* line # 6949 */
  V_sy_search=F_ip;
  V_lastsymb=V_sy_sym.ub[0];
  V_sy_sym.ub[0]=0;
  Rv0=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6954; /* line # 6954 */
  Rv1=Rv0;
  switch (((UB *)Rv1)[40]) {
    case 1:
    case 2:
    case 3:
    case 7:
    case 8:
    case 13:Ra.sl[6]=6966; /* line # 6966 */
    if (((V *)Rv1)[3]==V_typ_std.v[28]&&((UB *)Rv1)[40]==7) Rv2=Rv0;
    else {
      if (!(2&((UW *)Rv1)[10])) {
        Ra.sl[6]=6972; /* line # 6972 */
        P_src_error(Rd.s+1131,173,2);
      }
      if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1131,32,2);
      else P_insymbol();
      Rv2=PAS_COMILER_PRC_00000053(Rv0,0);
    }
    break;
    default:Ra.sl[6]=6981; /* line # 6981 */
    P_src_error(Rd.s+1131,174,3);
    P_skip_symbol(18,0,0);
    P_lgt_free_tree(&Rv0);
    Rv2=NULL;
    break;
  }
  Ra.sl[6]=6986; /* line # 6986 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " with_state "  */
V PAS_COMILER_PRC_00000056(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1135;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7004; /* line # 7004 */
  Rv0=0;
  Rv1=NULL;
  Rv2=1;
  while (1){
    Ra.sl[6]=7009; /* line # 7009 */
    Rv3=PAS_COMILER_PRC_00000000();
    Rv4=0;
    Rv5=0;
    Rv6=NULL;
    Rv7=((V *)Rv3)[3];
    Ra.sl[6]=7015; /* line # 7015 */
    Rv8=Rv7;
    Rv9=Rv3;
    if (((((UB *)Rv8)[93]==5||((UB *)Rv8)[93]==7)||((UB *)Rv8)[93]==24)&&((V *)Rv8)
    [12]!=NULL) {
      Ra.sl[6]=7022; /* line # 7022 */
      Rv10=1;
      Rv4=1;
      Rv6=Rv7;
      Rv7=((V *)Rv6)[12];
    }
    else {
      Ra.sl[6]=7029; /* line # 7029 */
      Rv10=((UB *)Rv9)[40]!=14&&((UB *)Rv9)[40]!=13;
    }
    if (((UB *)Rv7)[93]!=10) Rv7=NULL;
    Rv2=Rv7==NULL;
    Ra.sl[6]=7035; /* line # 7035 */
    if (Rv2) {
      P_src_error(Rd.s+1149,176,3);
      P_skip_symbol(72,0,0);
    }
    else {
      Ra.sl[6]=7041; /* line # 7041 */
      if (Rv10) {
        if (!Rv4) {
          if (((UB *)Rv3)[40]==2&&((SL *)Rv3)[4]==0) {
            Ra.sl[6]=7046; /* line # 7046 */
            Rv11=((V *)Rv3)[1];
            P_lgt_free(&Rv3);
            Rv6=((V *)Rv11)[3];
            Rv3=Rv11;
          }
          else {
            Ra.sl[6]=7053; /* line # 7053 */
            if (Rv6==NULL) P_ide_new_typ(5, &Rv6);
            Rv12=Rv6;
            memcpy(Rv12+48,V_typ_std.v[13]+48,1);
            Ra.sl[6]=7058; /* line # 7058 */
            ((SL *)Rv12)[11]=V_fptr_size;
            ((V *)Rv12)[12]=Rv7;
            P_lgt_new(&Rv3, Rv6,4, Rv3);
          }
        }
        Ra.sl[6]=7066; /* line # 7066 */
        Rv5=1;
        P_lgt_new(&Rv11, Rv6,13,NULL);
        P_all_new(((V *)Rv11)+7,Rv6,NULL,0);
        Ra.sl[6]=7071; /* line # 7071 */
        ((V *)Rv11)[0]=Rv3;
        Rv3=P_lgt_new_code(3, Rv11);
        ((SL *)Rv3)[4]=0;
        ((V *)Rv3)[0]=Rv1;
        Rv1=Rv3;
      }
      else {
        Ra.sl[6]=7079; /* line # 7079 */
        Rv11=Rv3;
      }
    }
    Ra.sl[6]=7084; /* line # 7084 */
    if (V_curr_disp<64) {
      Rv0=Rv0+1;
      P_new_disp_level(NULL,1);
      Rv13=(V_lex_ident_tree.s+V_curr_disp*64);
      Ra.sl[6]=7090; /* line # 7090 */
      ((V *)Rv13)[2]=Rv11;
      Rv14=Rv7;
      if (((V *)Rv14)[4]!=NULL) {
        Rv15=((V *)Rv14)[4];
        Ra.sl[6]=7095; /* line # 7095 */
        while (Rv15!=NULL){
          ((UB *)Rv15)[60]=3;
          Rv15=((V *)Rv15)[3];
        }
        Ra.sl[6]=7100; /* line # 7100 */
        ((V *)Rv13)[1]=((V *)Rv14)[4];
      }
      else((V *)Rv13)[1]=((V *)Rv14)[12];
      Ra.sl[6]=7105; /* line # 7105 */
      ((SL *)Rv13)[13]=0;
      if (Rv10) {
        if (Rv5) ((UB *)Rv13)[24]=2;
        else((UB *)Rv13)[24]=3;
      }
      else((UB *)Rv13)[24]=1;
      Ra.sl[6]=7110; /* line # 7110 */
      if (((V *)Rv7)[4]!=NULL&&((UB *)Rv7)[93]==10) {
        Rv0=Rv0+1;
        P_new_disp_level(NULL,1);
        Ra.sl[6]=7115; /* line # 7115 */
        memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
        Rv16=(V_lex_ident_tree.s+V_curr_disp*64);
        ((V *)Rv16)[1]=((V *)Rv7)[12];
        ((SL *)Rv16)[13]=-1;
      }
    }
    else {
      Ra.sl[6]=7125; /* line # 7125 */
      P_src_error(Rd.s+1149,1003,4);
    }
    if (V_sy_sym.ub[0]==17) P_insymbol();
    if (V_sy_sym.ub[0]!=0)  break;
  }
  Ra.sl[6]=7130; /* line # 7130 */
  if (V_sy_sym.ub[0]==53) P_insymbol();
  else P_src_error(Rd.s+1149,55,2);
  Rv17=V_cntx_label;
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7135; /* line # 7135 */
  Rv18=PAS_COMILER_PRC_00000036(NULL,1);
  if (Rv18!=NULL) {
    Rv19=Rv18;
    if (((UB *)Rv19)[40]==0) {
      Ra.sl[6]=7140; /* line # 7140 */
      switch (((UB *)Rv19)[41]) {
        case 0:
        case 2:Rv20=1;
        break;
        default:Ra.sl[6]=7145; /* line # 7145 */
        Rv20=0;
        break;
      }
    }
    else Rv20=0;
  }
  else P_lgt_new(&Rv18,NULL,16,NULL);
  Ra.sl[6]=7151; /* line # 7151 */
  P_label_purge(&Rv17);
  while (Rv0>0){
    Ra.sl[6]=7156; /* line # 7156 */
    Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
    if (((SL *)Rv21)[13]>=0) {
      if (((SL *)Rv21)[13]==0) {
        Ra.sl[6]=7161; /* line # 7161 */
        switch (((UB *)Rv21)[24]) {
          case 1:
          case 3:P_lgt_free_tree(((V *)Rv21)+2);
          break;
          case 2:Ra.sl[6]=7168; /* line # 7168 */
          Rv3=Rv1;
          Rv1=((V *)Rv3)[0];
          ((V *)Rv3)[0]=NULL;
          P_all_free(((V *)((V *)Rv21)[2])[7]);
          ((V *)Rv21)[2]=NULL;
          Ra.sl[6]=7173; /* line # 7173 */
          P_lgt_free_tree(&Rv3);
          break;
          default:break;
        }
      }
      else {
        Ra.sl[6]=7179; /* line # 7179 */
        if (((UB *)Rv21)[24]==2) {
          Rv3=Rv1;
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=7184; /* line # 7184 */
          if (Rv20) {
            ((V *)Rv3)[0]=((V *)Rv18)[1];
            ((V *)Rv18)[1]=Rv3;
          }
          else {
            Ra.sl[6]=7191; /* line # 7191 */
            Rv20=1;
            ((V *)Rv3)[0]=Rv18;
            P_lgt_new(&Rv18,NULL,0, Rv3);
            ((UB *)Rv18)[41]=2;
          }
        }
      }
    }
    Ra.sl[6]=7198; /* line # 7198 */
    Rv15=((V *)Rv21)[1];
    if (((UB *)Rv15)[53]==2) while (Rv15!=NULL){
      Ra.sl[6]=7203; /* line # 7203 */
      ((UB *)Rv15)[60]=0;
      ((V *)Rv15)[9]=NULL;
      Rv15=((V *)Rv15)[3];
    }
    Ra.sl[6]=7208; /* line # 7208 */
    V_curr_disp=V_curr_disp -1;
    Rv0=Rv0-1;
  }
  Ret=Rv18;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " if_state "  */
V PAS_COMILER_PRC_00000057(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1153;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7226; /* line # 7226 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,1,0);
  Rv1=NULL;
  Rv2=NULL;
  Rv3=V_cntx_label;
  Rv4=Rv0;
  Ra.sl[6]=7232; /* line # 7232 */
  if (V_sy_sym.ub[0]==45) P_insymbol();
  else P_src_error(Rd.s+1165,56,2);
  V_cntx_lblvl=V_cntx_lblvl+1;
  Rv1=PAS_COMILER_PRC_00000036(NULL,1);
  P_label_purge(&Rv3);
  Ra.sl[6]=7237; /* line # 7237 */
  if (V_sy_sym.ub[0]!=18) {
    if (V_sy_sym.ub[0]==46) {
      P_insymbol();
      V_cntx_lblvl=V_cntx_lblvl+1;
      Ra.sl[6]=7242; /* line # 7242 */
      Rv2=PAS_COMILER_PRC_00000036(NULL,1);
      P_label_purge(&Rv3);
    }
  }
  if (Rv1==NULL&&Rv2==NULL) {
    Ra.sl[6]=7248; /* line # 7248 */
    P_lgt_free(&Rv0);
    Rv5=NULL;
  }
  else {
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=7254; /* line # 7254 */
      if (((SL *)((V *)Rv4)[7])[13]>0) {
        Rv5=Rv1;
        P_lgt_free_tree(&Rv2);
      }
      else {
        Ra.sl[6]=7261; /* line # 7261 */
        Rv5=Rv2;
        P_lgt_free_tree(&Rv1);
      }
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=7269; /* line # 7269 */
      if (Rv1==NULL) {
        Rv0=P_exp_genop(0, Rv0);
        ((V *)Rv0)[0]=Rv2;
      }
      else {
        Ra.sl[6]=7276; /* line # 7276 */
        ((V *)Rv0)[0]=Rv1;
        ((V *)Rv1)[0]=Rv2;
      }
      P_lgt_new(&Rv5,NULL,0, Rv0);
      ((UB *)Rv5)[41]=8;
    }
  }
  Ra.sl[6]=7284; /* line # 7284 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exit_state "  */
V PAS_COMILER_PRC_00000058(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1169;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7298; /* line # 7298 */
  P_lgt_new(&Rv0,NULL,16, Lx[5].v[6]);
  if (Lx[5].v[6]==NULL) P_src_error(Rd.s+1183,244,2);
  Ra.sl[6]=7303; /* line # 7303 */
  P_lgt_new(&Rv1,NULL,0, Rv0);
  ((UB *)Rv1)[41]=6;
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=7308; /* line # 7308 */
    Rv2=P_ide_search(8);
    if (Rv2==V_ide_udptr.v[3]) Rv2=NULL;
    if (Rv2!=NULL) {
      Rv3=Rv2;
      Ra.sl[6]=7314; /* line # 7314 */
      Rv4=V_cntx_label;
      while (Rv4!=NULL&&Rv4!=Rv2)
      Rv4=((V *)Rv4)[8];
      if (Rv4==NULL) P_src_error(Rd.s+1183,177,3);
      Ra.sl[6]=7319; /* line # 7319 */
      ((UB *)Rv3)[54]=((UB *)Rv3)[54]|2;
      ((V *)Rv0)[1]=((V *)Rv3)[10];
    }
    Ra.sl[6]=7328; /* line # 7328 */
    P_insymbol();
  }
  if (V_sy_sym.ub[0]==44) {
    Ra.sl[6]=7333; /* line # 7333 */
    P_insymbol();
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
  }
  Ra.sl[6]=7338; /* line # 7338 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " loop_state "  */
V PAS_COMILER_PRC_00000059(UB F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1187;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7354; /* line # 7354 */
  Rv0=Lx[5].v[6];
  P_lgt_new(Lx[5].v+6,NULL,0,NULL);
  ((UB *)Lx[5].v[6])[41]=4;
  Rv1=Lx[5].v[6];
  if (F_symb==47) {
    Ra.sl[6]=7360; /* line # 7360 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else P_src_error(Rd.s+1201,55,2);
  }
  else {
    Ra.sl[6]=7365; /* line # 7365 */
    P_lgt_new(&Rv2,NULL,16,NULL);
  }
  ((V *)Rv1)[1]=Rv2;
  Ra.sl[6]=7370; /* line # 7370 */
  Rv3=Lx[4].v[0];
  if (Rv3!=NULL) ((V *)Rv3)[10]=Lx[5].v[6];
  Rv4=V_cntx_label;
  Ra.sl[6]=7375; /* line # 7375 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  switch (F_symb) {
    case 47:((V *)Rv2)[0]=PAS_COMILER_PRC_00000036(NULL,1);
    break;
    case 48:Ra.sl[6]=7383; /* line # 7383 */
    Rv5=PAS_COMILER_PRC_00000035(49,0);
    if (V_sy_sym.ub[0]==49) P_insymbol();
    else P_src_error(Rd.s+1201,57,2);
    Ra.sl[6]=7388; /* line # 7388 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Rv7=Rv6;
    ((V *)Rv7)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    ((V *)Rv7)[1]=Lx[5].v[6];
    Ra.sl[6]=7394; /* line # 7394 */
    P_lgt_new(&Rv6,NULL,0, Rv6);
    ((UB *)Rv6)[41]=6;
    if (Rv5!=NULL) {
      ((V *)Lx[5].v[7])[0]=Rv6;
      Ra.sl[6]=7399; /* line # 7399 */
      ((V *)Rv2)[0]=Rv5;
    }
    else((V *)Rv2)[0]=Rv6;
    break;
    case 54:Ra.sl[6]=7407; /* line # 7407 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000035(72,0);
    if (V_sy_sym.ub[0]!=72) P_src_error(Rd.s+1201,54,2);
    else P_insymbol();
    if (V_sy_sym.ub[0]==0) {
      if (Rv3==P_ide_search(8)) {
        Ra.sl[6]=7412; /* line # 7412 */
        P_insymbol();
      }
      else P_src_error_s(Rd.s+1201,179,2, V_sy_ident.s,NULL);
    }
    break;
  }
  Ra.sl[6]=7417; /* line # 7417 */
  P_label_purge(&Rv4);
  Lx[5].v[6]=Rv0;
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " for_state "  */
V PAS_COMILER_PRC_00000060(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  UB Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1205;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7439; /* line # 7439 */
  Rv2=Lx[5].v[6];
  Rv3=V_curr_disp;
  Rv4=V_cntx_label;
  P_new_disp_level(Lx[5].v[13],0);
  Ra.sl[6]=7444; /* line # 7444 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1218,168,2);
  else {
    P_ide_new(5,NULL,&Rv5);
    P_insymbol();
    Ra.sl[6]=7449; /* line # 7449 */
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else P_src_error(Rd.s+1218,32,2);
    V_sy_fix_range_ctl=0;
    Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,1,0);
    Ra.sl[6]=7454; /* line # 7454 */
    switch (V_sy_sym.ub[0]) {
      case 51:P_insymbol();
      Rv6=38;
      break;
      case 52:Ra.sl[6]=7463; /* line # 7463 */
      P_insymbol();
      Rv6=39;
      break;
      default:Ra.sl[6]=7468; /* line # 7468 */
      P_src_error(Rd.s+1218,59,2);
      Rv6=38;
      break;
    }
    Rv7=PAS_COMILER_PRC_00000005(((V *)Rv0)[3],0,1,0);
    Ra.sl[6]=7474; /* line # 7474 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else P_src_error(Rd.s+1218,55,2);
    P_lgt_new(Lx[5].v+6,V_typ_std.v[2],0,NULL);
    ((UB *)Lx[5].v[6])[41]=5;
    Ra.sl[6]=7480; /* line # 7480 */
    if (Rv6==39) {
      Rv8=Rv7;
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv7);
      else {
        Ra.sl[6]=7485; /* line # 7485 */
        Rv7=Rv0;
      }
    }
    else {
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv8);
      else {
        Ra.sl[6]=7490; /* line # 7490 */
        Rv8=Rv0;
      }
    }
    if (((UB *)Rv8)[40]==14) {
      Rv9=Rv7;
      Ra.sl[6]=7495; /* line # 7495 */
      Rv10=P_lgt_new_econst(((V *)Rv8)[3],((SL *)((V *)Rv8)[7])[13]-1);
    }
    else {
      Rv10=Rv8;
      Ra.sl[6]=7500; /* line # 7500 */
      if (((UB *)Rv7)[40]==14) Rv9=P_lgt_new_econst(((V *)Rv7)[3],((SL *)((V *)Rv7)
      [7])[13]+1);
      else {
        ((V *)Rv7)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Ra.sl[6]=7505; /* line # 7505 */
        Rv9=P_lgt_new_code(49, Rv7);
      }
    }
    Rv7=P_lgt_new_addsub(1,1, Rv9, Rv10);
    Ra.sl[6]=7512; /* line # 7512 */
    ((V *)Lx[5].v[6])[1]=Rv7;
    V_sy_fix_range_ctl=1;
    Rv11=Rv5;
    Ra.sl[6]=7518; /* line # 7518 */
    ((V *)Rv11)[5]=((V *)Rv8)[3];
    ((UW *)Rv11)[42]=32;
    ((UB *)Rv11)[86]=1;
    Ra.sl[6]=7523; /* line # 7523 */
    Rv12=Lx[4].v[0];
    if (Rv12!=NULL) {
      Rv13=Rv12;
      ((V *)Rv13)[8]=V_cntx_label;
      Ra.sl[6]=7528; /* line # 7528 */
      V_cntx_label=Rv12;
      ((V *)Rv13)[10]=Lx[5].v[6];
    }
    V_cntx_lblvl=V_cntx_lblvl+1;
    Ra.sl[6]=7535; /* line # 7535 */
    Rv8=PAS_COMILER_PRC_00000036(NULL,1);
    ((V *)Rv7)[0]=Rv8;
    if (1&((UW *)Rv5)[42]) {
      Ra.sl[6]=7543; /* line # 7543 */
      Rv0=P_lgt_link(Rv0);
      Rv0=P_lgt_new_idref(Rv5, Rv0);
      Rv0=P_lgt_new_code(3, Rv0);
      ((V *)Rv0)[0]=Lx[5].v[6];
      Ra.sl[6]=7548; /* line # 7548 */
      P_lgt_new(Lx[5].v+6,NULL,0, Rv0);
      ((UB *)Lx[5].v[6])[41]=2;
      Rv0=P_lgt_new_idref(Rv5,NULL);
      Ra.sl[6]=7553; /* line # 7553 */
      Rv0=P_lgt_new_code(Rv6, Rv0);
      ((V *)Rv0)[3]=Rv1;
      if (Rv8!=NULL) ((V *)Rv8)[0]=Rv0;
      else((V *)Rv7)[0]=Rv0;
    }
    else {
      Ra.sl[6]=7560; /* line # 7560 */
      if (((UB *)Rv0)[40]==14) P_lgt_free(&Rv0);
    }
    Rv0=Lx[5].v[6];
  }
  Ra.sl[6]=7565; /* line # 7565 */
  Lx[5].v[6]=Rv2;
  if (V_curr_disp>Rv3) P_ide_reserve_disp(Rv3);
  Ra.sl[6]=7570; /* line # 7570 */
  P_label_purge(&Rv4);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " goto_state "  */
V PAS_COMILER_PRC_00000061(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1222;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7584; /* line # 7584 */
  Rv0=NULL;
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1236,69,3);
  V_err_prt=0;
  Rv1=P_ide_search(8);
  Ra.sl[6]=7589; /* line # 7589 */
  V_err_prt=1;
  if (Rv1==NULL) {
    P_ide_new(3,NULL,&Rv1);
    Ra.sl[6]=7594; /* line # 7594 */
    Rv2=Lx[5].v[13];
    if (((V *)Rv2)[20]==NULL) ((V *)Rv2)[20]=Rv1;
    else((V *)Lx[5].v[4])[7]=Rv1;
    Lx[5].v[4]=Rv1;
  }
  Ra.sl[6]=7599; /* line # 7599 */
  P_lgt_new(&Rv0,NULL,0,NULL);
  Rv3=Rv0;
  Rv4=Rv1;
  if (((SL *)Rv4)[12]!=V_curr_lex) {
    Ra.sl[6]=7604; /* line # 7604 */
    ((UB *)Rv3)[41]=10;
    ((UB *)Rv4)[54]=((UB *)Rv4)[54]|12;
  }
  else {
    Ra.sl[6]=7610; /* line # 7610 */
    ((UB *)Rv4)[54]=((UB *)Rv4)[54]|4;
    if (32&((UB *)Rv4)[54]) P_src_error(Rd.s+1236,70,2);
    else {
      Ra.sl[6]=7615; /* line # 7615 */
      ((SL *)Rv4)[22]=V_cntx_lblvl;
    }
    ((UB *)Rv3)[41]=9;
  }
  ((V *)Rv3)[6]=Rv1;
  Ra.sl[6]=7620; /* line # 7620 */
  P_insymbol();
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " begin_state "  */
V PAS_COMILER_PRC_00000062(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1240;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7635; /* line # 7635 */
  Rv0=V_cntx_label;
  V_cntx_lblvl=V_cntx_lblvl+1;
  Rv1=PAS_COMILER_PRC_00000035(72,1);
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else P_src_error(Rd.s+1255,54,2);
  Ra.sl[6]=7640; /* line # 7640 */
  P_label_purge(&Rv0);
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " label_attach "  */
void PAS_COMILER_PRC_00000063(V F_lab_list, V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1259;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7647; /* line # 7647 */
  if (F_lab_list!=NULL&&F_trg!=NULL) ((V *)F_trg)[4]=F_lab_list;
  Ra.sl[6]=7656; /* line # 7656 */
  while (F_lab_list!=NULL){
    Rv0=F_lab_list;
    ((V *)Rv0)[10]=F_trg;
    F_lab_list=((V *)Rv0)[9];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement "  */
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1273;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=7666; /* line # 7666 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=NULL;
  Rv2=V_wildtmp_stk;
  Ra.sl[8]=7671; /* line # 7671 */
  Rv3=NULL;
  if (V_sy_sym.ub[0]==1) while (1){
    Ra.sl[8]=7676; /* line # 7676 */
    V_err_prt=0;
    Rv4=P_ide_search(8);
    V_err_prt=1;
    if (Rv4!=NULL) {
      Ra.sl[8]=7682; /* line # 7682 */
      if (((SL *)Rv4)[12]!=V_curr_lex) Rv4=NULL;
      else {
        if (16&((UB *)Rv4)[54]) P_src_error_s(Rd.s+1286,75,3, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[8]=7688; /* line # 7688 */
    if (Rv4==NULL) {
      P_ide_new(3,NULL,&Rv4);
      Rv5=Lx[5].v[13];
      if (((V *)Rv5)[20]==NULL) ((V *)Rv5)[20]=Rv4;
      else {
        Ra.sl[8]=7693; /* line # 7693 */
        ((V *)Lx[5].v[4])[7]=Rv4;
      }
      Lx[5].v[4]=Rv4;
    }
    Rv6=Rv4;
    Ra.sl[8]=7699; /* line # 7699 */
    ((V *)Rv6)[8]=V_cntx_label;
    V_cntx_label=Rv4;
    ((UB *)Rv6)[54]=((UB *)Rv6)[54]|16;
    if (4&((UB *)Rv6)[54]) {
      if (((SL *)Rv6)[22]<V_cntx_lblvl) {
        Ra.sl[8]=7704; /* line # 7704 */
        P_src_error_s(Rd.s+1286,70,2, V_sy_ident.s,NULL);
      }
    }
    if (Rv3==NULL) Rv3=Rv4;
    ((V *)Rv4)[9]=Ra.v[0];
    Ra.v[0]=Rv4;
    Ra.sl[8]=7709; /* line # 7709 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=1)  break;
  }
  if (V_cmp_trace>0) switch (V_sy_sym.ub[0]) {
    case 18:
    case 48:
    case 54:
    case 71:break;
    default:Ra.sl[8]=7718; /* line # 7718 */
    if (Lx[5].sl[28]<2) {
      if (Ra.v[0]!=NULL) {
        if (8&((UB *)Ra.v[0])[54]) Lx[5].sl[28]=2;
        else Lx[5].sl[28]=1;
      }
    }
    Ra.sl[8]=7723; /* line # 7723 */
    Rv1=P_lgt_new_line(Lx[5].v[13],F_lgp, Lx[5].sl[28]);
    if (Ra.v[0]!=NULL) {
      if (Rv1==NULL) {
        Ra.sl[8]=7729; /* line # 7729 */
        if (F_lgp!=NULL) ((V *)Rv3)[9]=((V *)F_lgp)[4];
        PAS_COMILER_PRC_00000063(Ra.v[0],F_lgp);
      }
      else {
        Ra.sl[8]=7734; /* line # 7734 */
        PAS_COMILER_PRC_00000063(Ra.v[0],Rv1);
      }
      Ra.v[0]=NULL;
    }
    Lx[5].sl[28]=0;
    break;
  }
  Ra.sl[8]=7741; /* line # 7741 */
  memcpy(Ra.s+36,V_sy_sym.s,2);
  if (((((Ra.ub[36]!=72&&Ra.ub[36]!=90)&&Ra.ub[36]!=49)&&Ra.ub[36]!=0)&&Ra.ub[36]
  !=18)&&Ra.ub[36]!=77) P_insymbol();
  Ra.sl[8]=7746; /* line # 7746 */
  switch (Ra.ub[36]) {
    case 90:break;
    case 0:Rv4=P_ide_search(2016);
    Ra.sl[8]=7759; /* line # 7759 */
    Rv7=Rv4;
    P_insymbol();
    switch (((UB *)Rv7)[53]) {
      case 10:Ra.sl[8]=7764; /* line # 7764 */
      Rv0=PAS_COMILER_PRC_00000014(Rv4);
      break;
      case 7:Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
      Ra.sl[8]=7769; /* line # 7769 */
      if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
      break;
      case 8:
      case 9:Ra.sl[8]=7774; /* line # 7774 */
      switch (V_sy_sym.ub[0]) {
        case 15:
        case 19:
        case 22:Rv0=PAS_COMILER_PRC_00000054(Rv4);
        break;
        default:Ra.sl[8]=7781; /* line # 7781 */
        if (((UB *)Rv7)[53]==9) Rv0=PAS_COMILER_PRC_00000011(Rv4,0);
        else Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
        if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
        break;
      }
      break;
      default:Ra.sl[8]=7787; /* line # 7787 */
      Rv0=PAS_COMILER_PRC_00000055(Rv4);
      break;
    }
    break;
    case 71:Ra.sl[8]=7792; /* line # 7792 */
    Rv0=PAS_COMILER_PRC_00000062();
    break;
    case 44:Rv0=PAS_COMILER_PRC_00000057();
    break;
    case 47:
    case 48:
    case 54:Rv0=PAS_COMILER_PRC_00000059(Ra.ub[36]);
    break;
    case 50:Ra.sl[8]=7797; /* line # 7797 */
    Rv0=PAS_COMILER_PRC_00000060();
    break;
    case 55:Rv0=PAS_COMILER_PRC_00000058();
    break;
    case 57:Rv0=PAS_COMILER_PRC_00000056();
    break;
    case 56:Rv0=PAS_COMILER_PRC_00000004(56,NULL);
    break;
    case 33:Rv0=PAS_COMILER_PRC_00000061();
    break;
    case 58:Ra.sl[8]=7803; /* line # 7803 */
    Rv0=PAS_COMILER_PRC_00000016(V_new_entry_proc);
    break;
    case 59:Rv0=PAS_COMILER_PRC_00000016(V_newh_entry_proc);
    break;
    case 60:Rv0=PAS_COMILER_PRC_00000017(V_dispose_entry_proc);
    break;
    case 61:Rv0=PAS_COMILER_PRC_00000012(0);
    break;
    case 62:Ra.sl[8]=7808; /* line # 7808 */
    Rv0=PAS_COMILER_PRC_00000012(1);
    break;
    case 63:Rv0=PAS_COMILER_PRC_00000012(2);
    break;
    case 64:Rv0=PAS_COMILER_PRC_00000012(3);
    break;
    case 65:Ra.sl[8]=7813; /* line # 7813 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    NULL);
    break;
    case 66:Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene,
    V_inp_std_bin, V_inp_std_eoln);
    break;
    case 67:Ra.sl[8]=7819; /* line # 7819 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_inp_std_sel, V_inp_std_gene,NULL,V_inp_std_eoln);
    break;
    case 68:Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene,
    V_out_std_bin,NULL);
    break;
    case 69:Ra.sl[8]=7825; /* line # 7825 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    V_out_std_eoln);
    break;
    case 70:Rv0=PAS_COMILER_PRC_00000013(NULL,V_out_std_sel, V_out_std_gene,NULL,
    V_out_std_eoln);
    break;
    case 77:
    case 78:Ra.sl[8]=7832; /* line # 7832 */
    Rv0=PAS_COMILER_PRC_00000054(NULL);
    break;
    default:break;
  }
  if (Ra.v[0]!=NULL) {
    Ra.sl[8]=7838; /* line # 7838 */
    if (Rv0==NULL) P_lgt_new(&Rv0,NULL,17,NULL);
    PAS_COMILER_PRC_00000063(Ra.v[0],Rv0);
  }
  Ra.sl[8]=7843; /* line # 7843 */
  if (Rv0!=NULL) {
    if (Rv1!=NULL) {
      ((V *)Rv1)[0]=Rv0;
      Ra.sl[8]=7848; /* line # 7848 */
      if (F_bsequ) {
        P_lgt_new(&Rv0,NULL,0, Rv1);
        ((UB *)Rv0)[41]=2;
        Lx[5].v[8]=Rv0;
      }
      else {
        Ra.sl[8]=7856; /* line # 7856 */
        Lx[5].v[8]=Rv0;
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[8]=7861; /* line # 7861 */
      Lx[5].v[8]=Rv0;
    }
  }
  else {
    if (Rv1!=NULL) Rv0=Rv1;
    Ra.sl[8]=7866; /* line # 7866 */
    Lx[5].v[8]=Rv0;
  }
  P_tmpstk_free(Rv2);
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[4]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " statelist "  */
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1290;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7885; /* line # 7885 */
  Rv0=V_src_control;
  ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
  Rv1=NULL;
  Rv2=NULL;
  Ra.sl[6]=7890; /* line # 7890 */
  while (V_sy_sym.ub[0]==18)
  P_insymbol();
  if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)&&!V_emergency_stop)
   {
    Rv1=PAS_COMILER_PRC_00000036(NULL,0);
    Ra.sl[6]=7895; /* line # 7895 */
    Rv2=Lx[5].v[8];
    while (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)
    &&!V_emergency_stop){
      Ra.sl[6]=7900; /* line # 7900 */
      if (V_sy_sym.ub[0]==18) while (V_sy_sym.ub[0]==18)
      P_insymbol();
      else P_src_error(Rd.s+1303,21,2);
      if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)&&
      !V_emergency_stop) {
        Ra.sl[6]=7906; /* line # 7906 */
        Rv3=PAS_COMILER_PRC_00000036(Rv2,0);
        if (Rv3!=NULL) {
          if (Rv1==NULL) Rv1=Rv3;
          else((V *)Rv2)[0]=Rv3;
          Ra.sl[6]=7911; /* line # 7911 */
          Rv2=Lx[5].v[8];
        }
      }
    }
  }
  Ra.sl[6]=7917; /* line # 7917 */
  Rv4=V_src_control;
  ((SL *)Rv4)[6]=((SL *)Rv4)[6]-1;
  Lx[5].v[7]=Rv2;
  if (F_seq_flg&&Rv1!=Rv2) {
    P_lgt_new(&Rv2,NULL,0, Rv1);
    Ra.sl[6]=7922; /* line # 7922 */
    ((UB *)Rv2)[41]=2;
    Ret=Rv2;
  }
  else Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cmp_block "  */
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[13]=F_owner;
  Ra.sl[28]=F_glicd;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+72;
  Ra.v[10]=Rd.s+1307;
  Ra.v[11]=Rd.s+17;
  Ra.sl[24]=7933; /* line # 7933 */
  if (V_curr_lex>0) P_new_disp_level(Ra.v[13],4);
  Ra.sl[24]=7939; /* line # 7939 */
  Ra.ub[40]=0;
  Ra.v[6]=NULL;
  Ra.v[1]=NULL;
  Rv0=NULL;
  Rv1=V_cntx_label;
  Ra.sl[24]=7944; /* line # 7944 */
  V_cntx_label=NULL;
  Rv2=Ra.v[13];
  ((V *)Rv2)[19]=NULL;
  ((V *)Rv2)[23]=NULL;
  Ra.sl[24]=7949; /* line # 7949 */
  ((V *)Rv2)[24]=NULL;
  P_compile_set_sbttl(Ra.v[13]);
  Ra.sl[24]=7954; /* line # 7954 */
  Ra.ub[16]=1;
  Ra.v[3]=NULL;
  while (1){
    Ra.sl[24]=7959; /* line # 7959 */
    V_pro_current=Ra.v[13];
    V_cprc_disp=V_curr_disp;
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043(1);
    Ra.sl[24]=7964; /* line # 7964 */
    switch (V_sy_sym.ub[0]) {
      case 28:P_insymbol();
      Ra.sl[24]=7969; /* line # 7969 */
      PAS_COMILER_PRC_00000044();
      break;
      case 29:Ra.sl[24]=7974; /* line # 7974 */
      P_insymbol();
      PAS_COMILER_PRC_00000045();
      break;
      case 30:Ra.sl[24]=7980; /* line # 7980 */
      if (V_sy_init_mod) V_sy_var_init_mod=1;
      P_insymbol();
      PAS_COMILER_PRC_00000046();
      if (V_sy_init_mod) {
        Ra.sl[24]=7985; /* line # 7985 */
        V_sy_var_init_mod=0;
      }
      break;
      case 32:PAS_COMILER_PRC_00000047();
      break;
      case 31:Ra.sl[24]=7990; /* line # 7990 */
      PAS_COMILER_PRC_00000048();
      break;
      case 76:
      case 77:Ra.sl[24]=7995; /* line # 7995 */
      PAS_COMILER_PRC_00000050();
      P_compile_set_sbttl(Ra.v[13]);
      V_cntx_varbl=((V *)Ra.v[13])[22];
      break;
      case 71:
      case 72:
      case 90:break;
      default:Ra.sl[24]=8003; /* line # 8003 */
      P_src_error(Rd.s+1320,91,2);
      P_insymbol();
      break;
    }
    if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==71)||V_sy_sym.ub[0]==72)  break;
  }
  Ra.sl[24]=8009; /* line # 8009 */
  if (V_curr_lex>0) {
    if (V_sy_sym.ub[0]==71) {
      P_ide_create_name(Rd.s+1324);
      Ra.sl[24]=8014; /* line # 8014 */
      P_ide_new_typ(21, &V_wildtmp_typ);
      ((SL *)V_wildtmp_typ)[11]=0;
      P_ide_new(5, V_wildtmp_typ, &V_wildtmp_ide);
      ((UW *)V_wildtmp_ide)[42]=96;
      Ra.sl[24]=8019; /* line # 8019 */
      V_wildtmp_psz=0;
      V_wildtmp_pal.ub[0]=0;
      V_wildtmp_stk=NULL;
      V_cntx_lblvl=0;
      Ra.sl[24]=8024; /* line # 8024 */
      V_cprc_disp=V_curr_disp;
      V_pro_current=Ra.v[13];
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=8029; /* line # 8029 */
      if (Ra.v[1]!=NULL) {
        if (Rv0!=NULL) ((V *)Rv0)[3]=Ra.v[1];
        else((V *)Ra.v[13])[23]=Ra.v[1];
        P_src_error(Rd.s+1320,92,3);
      }
      Ra.sl[24]=8037; /* line # 8037 */
      V_sy_label_flag=1;
      P_insymbol();
      Rv3=Ra.v[13];
      Ra.sl[24]=8044; /* line # 8044 */
      ((V *)Rv3)[16]=PAS_COMILER_PRC_00000035(72,0);
      if (((V *)Rv3)[11]!=NULL) {
        if (!Ra.ub[40]) P_src_error(Rd.s+1320,74,3);
      }
      Ra.sl[24]=8050; /* line # 8050 */
      if (((V *)Rv3)[18]!=NULL) {
        ((V *)((V *)Rv3)[17])[0]=((V *)Rv3)[16];
        ((V *)Rv3)[16]=((V *)Rv3)[18];
      }
      Ra.sl[24]=8055; /* line # 8055 */
      ((V *)Rv3)[17]=Ra.v[7];
      Rv4=((V *)Ra.v[13])[19];
      Ra.sl[24]=8060; /* line # 8060 */
      while (Rv4!=NULL){
        Rv5=Rv4;
        V_ope_table.v[((UB *)Rv5)[0]]=((V *)Rv5)[2];
        Ra.sl[24]=8068; /* line # 8068 */
        Rv6=((V *)Rv5)[1];
        PAS__DISPOSE(&Rv4);
        Rv4=Rv6;
      }
      Ra.sl[24]=8075; /* line # 8075 */
      V_sy_label_flag=0;
    }
  }
  Ra.sl[24]=8080; /* line # 8080 */
  if (((UB *)Ra.v[13])[104]>=5) {
    V_cntx_label=((V *)Ra.v[13])[20];
    while (V_cntx_label!=Rv1&&V_cntx_label!=NULL){
      Rv7=V_cntx_label;
      Ra.sl[24]=8086; /* line # 8086 */
      if (4&((UB *)Rv7)[54]) {
        if (!(16&((UB *)Rv7)[54])) P_src_error(Rd.s+1320,66,3);
      }
      V_cntx_label=((V *)Rv7)[7];
    }
  }
  Ra.sl[24]=8093; /* line # 8093 */
  V_cntx_label=Rv1;
  PAS__curr_cntx=Ra.v[9];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " cmp_init "  */
void P_cmp_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1331;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8113; /* line # 8113 */
  V_emergency_stop=0;
  P_insy_init();
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8119; /* line # 8119 */
  V_opt_exec=0;
  V_cmp_cmpdbg=0;
  V_cmp_range=0;
  Ra.sl[6]=8124; /* line # 8124 */
  V_cmp_dynamic=0;
  V_cmp_genenv=0;
  V_cmp_listlvl=1;
  V_cmp_igenv=-1;
  Ra.sl[6]=8129; /* line # 8129 */
  V_cmp_macf=0;
  V_cmp_cobj=0;
  V_cmp_objf=0;
  V_cmp_bltt=0;
  V_cmp_opt=1;
  Ra.sl[6]=8134; /* line # 8134 */
  V_cmp_debugopt=0;
  V_cmp_debug=0;
  V_cmp_traceopt=5;
  V_cmp_trace=-1;
  V_cmp_tracecount=0;
  Ra.sl[6]=8139; /* line # 8139 */
  V_cmp_twicedclon=0;
  V_sy_init_mod=1;
  V_sy_generic_qmod=1;
  V_sy_var_init_mod=0;
  Ra.sl[6]=8145; /* line # 8145 */
  V_sy_casedef=0;
  P_insymbol();
  P_compile_set_title();
  Ra.sl[6]=8150; /* line # 8150 */
  P_compile_set_sbttl(V_lex_ident_tree.v[0]);
  P_generation_setting();
  Ra.sl[6]=8155; /* line # 8155 */
  P_cmp_block(V_lex_ident_tree.v[0],1,0);
  if (V_error_result!=0) V_emergency_stop=1;
  Ra.sl[6]=8160; /* line # 8160 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8184; /* line # 8184 */
  V_cntx_procname=V_fptr_size;
  V_cntx_srcfname=V_cntx_procname+V_fptr_size;
  V_cntx_linenbr=V_cntx_srcfname+V_fptr_size;
  V_cntx_size=V_cntx_linenbr+V_inte_size;
  P_ide_new_typ(10, &V_cntx_typ);
  Ra.sl[6]=8189; /* line # 8189 */
  Rv0=V_cntx_typ;
  ((UB *)Rv0)[48]=((UB *)V_typ_std.v[5])[48];
  ((SL *)Rv0)[11]=V_cntx_size;
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=8194; /* line # 8194 */
  ((V *)Rv0)[13]=NULL;
  ((V *)Rv0)[14]=NULL;
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  V_sy_init_mod=0;
  Ra.sl[6]=8199; /* line # 8199 */
  V_sy_generic_qmod=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_pass2 "  */
void PAS_COMILER_cmp_pass2(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1341;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8207; /* line # 8207 */
  Rv0=F_pr;
  Ra.sl[6]=8216; /* line # 8216 */
  P_lgt_pass1_complet(F_pr);
  if (V_cmp_macf) {
    P_lgt_dump_proc(F_pr);
    Ra.sl[6]=8221; /* line # 8221 */
    P_lst_page();
  }
  Ra.sl[6]=8226; /* line # 8226 */
  switch (((UB *)Rv0)[104]) {
    case 6:
    case 9:
    case 10:Ra.sl[6]=8232; /* line # 8232 */
    P_generate_code_p1(F_pr);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_compile "  */
UB P_cmp_compile(UB F_interactive){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;
  V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1352;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8256; /* line # 8256 */
  V_emergency_stop=0;
  Rv0=0;
  V_env_file=NULL;
  V_env_first=NULL;
  Ra.sl[6]=8261; /* line # 8261 */
  V_env_last=NULL;
  if (!V_emergency_stop) {
    Ra.sl[6]=8267; /* line # 8267 */
    P_compile_set_title();
    Ra.sl[6]=8273; /* line # 8273 */
    Rv1=V_src_control;
    ((SL *)Rv1)[7]=1;
    ((SL *)Rv1)[8]=V_cmp_listlvl;
    Ra.sl[6]=8280; /* line # 8280 */
    V_sy_ch=32;
    P_insymbol();
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=8285; /* line # 8285 */
    P_compile_set_sbttl(NULL);
    Rv2=PAS__NEW(245);
    V_pro_current=Rv2;
    Ra.sl[6]=8290; /* line # 8290 */
    if (V_sy_sym.ub[0]==15) {
      V_sy_sym.ub[0]=17;
      while (1){
        Ra.sl[6]=8295; /* line # 8295 */
        P_insymbol();
        if (V_sy_sym.ub[0]==0) {
          Rv3=P_level_search(V_attr_list);
          if (Rv3!=NULL) while (1){
            Ra.sl[6]=8301; /* line # 8301 */
            P_insymbol();
            switch (((UB *)Rv3)[54]) {
              case 18:if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1367,22,2);
              Ra.sl[6]=8306; /* line # 8306 */
              V_sy_sym.ub[0]=17;
              while (1){
                P_insymbol();
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) P_add_inherit_file(V_sy_string
                .s);
                else {
                  Ra.sl[6]=8312; /* line # 8312 */
                  P_src_error(Rd.s+1367,58,3);
                }
                P_insymbol();
                if (V_sy_sym.ub[0]!=17)  break;
              }
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else P_src_error(Rd.s+1367,23,2);
              break;
              case 19:Ra.sl[6]=8321; /* line # 8321 */
              if (V_sy_sym.ub[0]==13) {
                P_insymbol();
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[6]=8326; /* line # 8326 */
                  Rv4=V_sy_string.ub[1];
                  V_env_file=PAS__NEW((SL)Rv4+2);
                  ((UB *)V_env_file)[0]=Rv4;
                  PAS__STR_TO_STR(V_env_file,V_sy_string.s);
                  V_cmp_genenv=1;
                  V_cmp_igenv=0;
                  P_insymbol();
                }
                else {
                  Ra.sl[6]=8331; /* line # 8331 */
                  P_src_error(Rd.s+1367,58,2);
                }
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else P_src_error(Rd.s+1367,23,2);
              }
              break;
              default:Ra.sl[6]=8338; /* line # 8338 */
              P_src_error_s(Rd.s+1367,3,1, V_sy_ident.s,NULL);
              break;
            }
            if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==17)||V_sy_sym.ub[0]==16)  break;
          }
        }
        else P_src_error(Rd.s+1367,2,3);
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=8344; /* line # 8344 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else P_src_error(Rd.s+1367,26,2);
    }
    if (V_cmp_igenv>=0) V_cmp_genenv=1;
    else {
      Ra.sl[6]=8349; /* line # 8349 */
      V_cmp_genenv=0;
    }
    if (V_sy_sym.ub[0]==74) {
      P_insymbol();
      Ra.sl[6]=8354; /* line # 8354 */
      Rv0=1;
      if (V_sy_sym.ub[0]!=0) {
        P_src_error(Rd.s+1367,93,4);
        V_emergency_stop=1;
      }
    }
    else {
      Ra.sl[6]=8362; /* line # 8362 */
      if (V_sy_sym.ub[0]==75) {
        P_insymbol();
        if (V_sy_sym.ub[0]!=0) {
          Ra.sl[6]=8367; /* line # 8367 */
          P_src_error(Rd.s+1367,93,4);
          V_emergency_stop=1;
        }
      }
      else {
        Ra.sl[6]=8372; /* line # 8372 */
        P_src_error(Rd.s+1367,94,4);
      }
    }
  }
  if (!V_emergency_stop) {
    Ra.sl[6]=8377; /* line # 8377 */
    Rv5=Rv2;
    V_curr_lex=V_curr_lex+1;
    P_new_disp_level(Rv2,4);
    Ra.sl[6]=8384; /* line # 8384 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    P_ide_new(9,NULL,&Rv6);
    ((V *)Rv5)[0]=NULL;
    Ra.sl[6]=8389; /* line # 8389 */
    ((V *)Rv5)[1]=NULL;
    ((UW *)Rv5)[8]=128;
    ((V *)Rv5)[3]=((V *)Rv6)[0];
    ((UB *)Rv5)[32]=29;
    ((V *)Rv5)[5]=Rv6;
    Ra.sl[6]=8394; /* line # 8394 */
    ((V *)Rv5)[6]=NULL;
    ((V *)Rv5)[7]=NULL;
    ((V *)Rv5)[8]=NULL;
    ((SL *)Rv5)[18]=0;
    ((SL *)Rv5)[19]=0;
    Ra.sl[6]=8399; /* line # 8399 */
    ((SL *)Rv5)[20]=0;
    ((V *)Rv5)[11]=NULL;
    ((V *)Rv5)[12]=NULL;
    if (Rv0) ((UB *)Rv5)[104]=7;
    else((UB *)Rv5)[104]=6;
    Ra.sl[6]=8405; /* line # 8405 */
    ((V *)Rv5)[14]=NULL;
    ((V *)Rv5)[15]=NULL;
    ((V *)Rv5)[16]=NULL;
    ((V *)Rv5)[17]=NULL;
    ((V *)Rv5)[18]=NULL;
    Ra.sl[6]=8410; /* line # 8410 */
    ((V *)Rv5)[19]=NULL;
    ((V *)Rv5)[20]=NULL;
    ((V *)Rv5)[21]=NULL;
    ((V *)Rv5)[22]=NULL;
    ((V *)Rv5)[23]=NULL;
    Ra.sl[6]=8415; /* line # 8415 */
    ((V *)Rv5)[24]=NULL;
    ((V *)Rv5)[25]=NULL;
    ((V *)Rv5)[26]=NULL;
    ((V *)Rv5)[27]=NULL;
    Ra.sl[6]=8420; /* line # 8420 */
    ((SL *)Rv5)[56]=-1;
    ((SL *)Rv5)[57]=0;
    ((SL *)Rv5)[58]=0;
    ((SL *)Rv5)[59]=0;
    ((SL *)Rv5)[60]=0;
    Ra.sl[6]=8425; /* line # 8425 */
    ((UB *)Rv5)[244]=0;
    V_pas_main=Rv2;
    P_insymbol();
    Ra.sl[6]=8430; /* line # 8430 */
    P_compile_set_sbttl(V_pas_main);
    if (V_sy_sym.ub[0]==13) {
      V_sy_sym.ub[0]=17;
      Ra.sl[6]=8435; /* line # 8435 */
      while (V_sy_sym.ub[0]==17){
        P_insymbol();
        if (V_sy_sym.ub[0]==0) P_insymbol();
        else P_src_error(Rd.s+1367,95,1);
      }
      Ra.sl[6]=8441; /* line # 8441 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else P_src_error(Rd.s+1367,23,2);
    }
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else P_src_error(Rd.s+1367,21,2);
    Ra.sl[6]=8449; /* line # 8449 */
    if (V_env_first!=NULL) P_pas_read_env_file();
    if (V_cmp_debugopt) {
      V_cmp_debug=1;
      Ra.sl[6]=8454; /* line # 8454 */
      V_cmp_traceopt=1;
    }
    if (V_cmp_traceopt>0) {
      Ra.sl[6]=8459; /* line # 8459 */
      P_gen_cntxvar(Rv2,((V *)Rv6)[0]);
      V_cmp_trace=V_cmp_traceopt;
      Rv7=5;
    }
    else Rv7=0;
    Ra.sl[6]=8465; /* line # 8465 */
    P_cmp_block(Rv2,1, Rv7);
    if (V_cmp_trace>0&&!Rv0) {
      Rv8=Rv2;
      Ra.sl[6]=8470; /* line # 8470 */
      P_gen_linetrace(Rv2,((V *)Rv8)+16,((V *)Rv8)+17,6);
    }
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else P_src_error(Rd.s+1367,54,2);
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=8476; /* line # 8476 */
      if (V_sy_sym.ub[0]==0&&P_match(((V *)Rv6)[0],V_sy_ident.s)==0) P_insymbol();
      else P_src_error_s(Rd.s+1367,96,1, V_sy_ident.s,NULL);
    }
    Ra.sl[6]=8481; /* line # 8481 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else P_src_error(Rd.s+1367,21,1);
    if (V_sy_sym.ub[0]!=90) {
      P_src_error(Rd.s+1367,991,1);
      Ra.sl[6]=8486; /* line # 8486 */
      while (V_sy_sym.ub[0]!=90)
      P_insymbol();
    }
    else P_src_end_of_line();
    if (V_pro_last==NULL) V_pro_first=Rv2;
    else((V *)V_pro_last)[0]=Rv2;
    Ra.sl[6]=8491; /* line # 8491 */
    V_pro_last=Rv2;
    if (V_error_result>1) V_emergency_stop=1;
    else {
      Ra.sl[6]=8498; /* line # 8498 */
      Rv9=Rv2;
      if (((V *)Rv9)[16]!=((V *)Rv9)[17]) {
        P_lgt_new(((V *)Rv9)+16,NULL,0,((V *)Rv9)[16]);
        ((UB *)((V *)Rv9)[16])[41]=2;
        Ra.sl[6]=8503; /* line # 8503 */
        ((V *)Rv9)[17]=((V *)Rv9)[16];
      }
      PAS_COMILER_cmp_pass2(Rv2);
    }
    Ra.sl[6]=8508; /* line # 8508 */
    if (V_cmp_macf) {
      P_lgt_dump_static(Rv2);
      P_lst_page();
    }
    Ra.sl[6]=8514; /* line # 8514 */
    if (V_error_result>1) V_emergency_stop=1;
    else {
      P_pas_write_env_file();
      P_generate_code_p2();
    }
  }
  Ra.sl[6]=8522; /* line # 8522 */
  Ret=V_error_result;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
